(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22410,        589]
NotebookOptionsPosition[     19753,        499]
NotebookOutlinePosition[     20956,        535]
CellTagsIndexPosition[     20871,        530]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightMagenta" :> 
          Documentation`HelpLookup["paclet:ref/LightMagenta"], "ColorData" :> 
          Documentation`HelpLookup["paclet:ref/ColorData"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightMagenta\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Magenta", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Magenta",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Magenta"]], "InlineFormula"],
     "\[LineSeparator]represents the color magenta in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magenta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magenta"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"1", ",", "0", ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->495305589],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->252592418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Magenta", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0, 1], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22679669]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Magenta"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->325294931]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Magenta", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0, 1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->30672028,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightMagenta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightMagenta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->337400881]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Magenta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 18.6497460}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Magenta represents the color magenta in graphics or style \
specifications. ", "synonyms" -> {}, "title" -> "Magenta", "type" -> "Symbol",
     "uri" -> "ref/Magenta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3724, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->495305589]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20728, 523}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1680, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2303, 64, 44, 1, 70, "ObjectName",
 CellID->6361],
Cell[2350, 67, 449, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2836, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3314, 103, 373, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[3724, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->495305589],
Cell[CellGroupData[{
Cell[4109, 136, 148, 5, 70, "ExampleSection",
 CellID->252592418],
Cell[CellGroupData[{
Cell[4282, 145, 185, 6, 28, "Input",
 CellID->511908593],
Cell[4470, 153, 262, 8, 121, "Output",
 CellID->22679669]
}, Open  ]],
Cell[CellGroupData[{
Cell[4769, 166, 268, 8, 28, "Input",
 CellID->245967023],
Cell[5040, 176, 2268, 41, 109, "Output",
 Evaluatable->False,
 CellID->325294931]
}, Open  ]],
Cell[CellGroupData[{
Cell[7345, 222, 188, 6, 70, "Input",
 CellID->82364862],
Cell[7536, 230, 9622, 163, 129, 86, 2, "CachedBoxData", "BoxData", "Output",
 CellID->30672028]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17219, 400, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[17533, 411, 1663, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[19233, 478, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[19555, 489, 124, 3, 70, "MoreAbout",
 CellID->337400881]
}, Open  ]],
Cell[19694, 495, 29, 0, 70, "History"],
Cell[19726, 497, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

