(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15577,        531]
NotebookOptionsPosition[     12487,        431]
NotebookOutlinePosition[     13909,        471]
CellTagsIndexPosition[     13824,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Magnification" :> 
          Documentation`HelpLookup["paclet:ref/Magnification"], "ImageSize" :> 
          Documentation`HelpLookup["paclet:ref/ImageSize"], 
          "ImageSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeMultipliers"], 
          "ImageSizeAction" :> 
          Documentation`HelpLookup["paclet:ref/ImageSizeAction"], "Scale" :> 
          Documentation`HelpLookup["paclet:ref/Scale"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Magnification\"\>", 2->"\<\"ImageSize\"\>", 
       3->"\<\"ImageSizeMultipliers\"\>", 4->"\<\"ImageSizeAction\"\>", 
       5->"\<\"Scale\"\>", 6->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Shape & Size" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsShapeAndSize"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Shape & Size\"\>", 
       2->"\<\"New in 6.0: Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Magnify", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Magnify",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Magnify"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object to be displayed with magnification \
",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Magnify",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Magnify"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]display with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " magnified by a fixed factor."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->9853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnify"]], "InlineFormula"],
 " magnifies every aspect of the image of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", including fonts and margins. "
}], "Notes",
 CellID->25629],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnify"]], "InlineFormula"],
 " can be applied to any element of any expression, including a graphic. "
}], "Notes",
 CellID->11224],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " less than 1 will shrink the image. "
}], "Notes",
 CellID->15748],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["GoldenRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GoldenRatio"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->471174715]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->287843012],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->334386038],

Cell["Control magnification of a string:", "ExampleText",
 CellID->1224354516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Magnify", "[", 
    RowBox[{"\"\<string\>\"", ",", "m"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "0.5", ",", "2", ",", "0.5"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1732774180],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"string\"\>",
    StripOnInput->False,
    Magnification->0.5 Inherited], ",", 
   StyleBox["\<\"string\"\>",
    StripOnInput->False,
    Magnification->1. Inherited], ",", 
   StyleBox["\<\"string\"\>",
    StripOnInput->False,
    Magnification->1.5 Inherited], ",", 
   StyleBox["\<\"string\"\>",
    StripOnInput->False,
    Magnification->2. Inherited]}], "}"}]], "Output",
 ImageSize->{268, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2123407366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1900474970],

Cell["Control magnification of any expression:", "ExampleText",
 CellID->677945368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Magnify", "[", 
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "+", "y"}], ")"}], "^", "m"}], "]"}], ",", 
     RowBox[{"m", "/", "1.5"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468732048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    RowBox[{"x", "+", "y"}],
    StripOnInput->False,
    Magnification->0.6666666666666666 Inherited], ",", 
   StyleBox[
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     RowBox[{"2", " ", "x", " ", "y"}], "+", 
     SuperscriptBox["y", "2"]}],
    StripOnInput->False,
    Magnification->1.3333333333333333` Inherited], ",", 
   StyleBox[
    RowBox[{
     SuperscriptBox["x", "3"], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["x", "2"], " ", "y"}], "+", 
     RowBox[{"3", " ", "x", " ", 
      SuperscriptBox["y", "2"]}], "+", 
     SuperscriptBox["y", "3"]}],
    StripOnInput->False,
    Magnification->2. Inherited]}], "}"}]], "Output",
 ImageSize->{429, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->458690979]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4944],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnification"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImageSizeAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSizeAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14955]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->583731813],

Cell[TextData[ButtonBox["Graphics Shape & Size",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsShapeAndSize"]], "MoreAbout",
 CellID->42188765],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->180290823]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Magnify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 19.7904002}", "context" -> "System`", 
    "keywords" -> {
     "zoom", "magnifying", "magnifying text", "magnifying formulas", 
      "magnifying graphics", "magnifying controls", "enlarge", "bigger", 
      "larger"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Magnify[expr, r] represents an object to be displayed with magnification \
r. Magnify[expr] display with expr magnified by a fixed factor.", 
    "synonyms" -> {}, "title" -> "Magnify", "type" -> "Symbol", "uri" -> 
    "ref/Magnify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6919, 217, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->287843012]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13681, 459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1923, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2546, 69, 1572, 37, 70, "ObjectNameGrid"],
Cell[4121, 108, 1008, 33, 70, "Usage",
 CellID->9853]
}, Open  ]],
Cell[CellGroupData[{
Cell[5166, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5644, 163, 301, 10, 70, "Notes",
 CellID->25629],
Cell[5948, 175, 236, 7, 70, "Notes",
 CellID->11224],
Cell[6187, 184, 156, 6, 70, "Notes",
 CellID->15748],
Cell[6346, 192, 536, 20, 70, "Notes",
 CellID->471174715]
}, Closed]],
Cell[CellGroupData[{
Cell[6919, 217, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->287843012],
Cell[CellGroupData[{
Cell[7304, 231, 148, 5, 70, "ExampleSection",
 CellID->334386038],
Cell[7455, 238, 78, 1, 70, "ExampleText",
 CellID->1224354516],
Cell[CellGroupData[{
Cell[7558, 243, 273, 9, 28, "Input",
 CellID->1732774180],
Cell[7834, 254, 567, 19, 47, "Output",
 CellID->2123407366]
}, Open  ]],
Cell[8416, 276, 126, 3, 70, "ExampleDelimiter",
 CellID->1900474970],
Cell[8545, 281, 83, 1, 70, "ExampleText",
 CellID->677945368],
Cell[CellGroupData[{
Cell[8653, 286, 391, 13, 70, "Input",
 CellID->468732048],
Cell[9047, 301, 840, 28, 51, "Output",
 CellID->458690979]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9948, 336, 310, 9, 70, "SeeAlsoSection",
 CellID->4944],
Cell[10261, 347, 1469, 53, 70, "SeeAlso",
 CellID->14955]
}, Open  ]],
Cell[CellGroupData[{
Cell[11767, 405, 319, 9, 70, "MoreAboutSection",
 CellID->583731813],
Cell[12089, 416, 152, 3, 70, "MoreAbout",
 CellID->42188765],
Cell[12244, 421, 171, 3, 70, "MoreAbout",
 CellID->180290823]
}, Open  ]],
Cell[12430, 427, 27, 0, 70, "History"],
Cell[12460, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

