(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17670,        626]
NotebookOptionsPosition[     13922,        502]
NotebookOutlinePosition[     15319,        540]
CellTagsIndexPosition[     15234,        535]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low\[Hyphen]Level Input and Output Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LowLevelInputAndOutputRules"], "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low\[Hyphen]Level Input and Output Rules\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"], "Format" :> 
          Documentation`HelpLookup["paclet:ref/Format"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MakeExpression\"\>", 2->"\<\"ToBoxes\"\>", 
       3->"\<\"Format\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Defining Custom Notation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MakeBoxes", "ObjectName",
 CellID->19369],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MakeBoxes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MakeBoxes"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the low\[Hyphen]level function used in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " sessions to convert expressions into boxes. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MakeBoxes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MakeBoxes"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the function to convert ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      ButtonBox["StandardForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
     " boxes."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->3878]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " does not evaluate ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20259],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ", or any other output form. "
}], "Notes",
 CellID->19008],

Cell[TextData[{
 "You can give definitions for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MakeBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeBoxes"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " to specify your own rules for how expressions should be converted to \
boxes. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->214178341]
}], "Notes",
 CellID->22619],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " is not automatically called on the results it generates. This means that \
explicit ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " calls must typically be inserted into definitions that are given. "
}], "Notes",
 CellID->23971],

Cell[TextData[{
 "If you change the output format for an expression by giving a definition \
for ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ", there is no guarantee that output you get will subsequently be able to be \
interpreted by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->30003],

Cell[TextData[{
 "Definitions you give for ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " will override built\[Hyphen]in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rules for generating output. "
}], "Notes",
 CellID->21945]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->503219804],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->37958466],

Cell["Box representation of a polynomial:", "ExampleText",
 CellID->82304522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeBoxes", "[", 
  RowBox[{
   RowBox[{"a", "+", 
    RowBox[{"b", "^", "2"}]}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60899740],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"a\"\>", ",", "\<\"+\"\>", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"b\"\>", ",", "\<\"2\"\>"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4994819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147778807],

Cell["Box representation of a graphic:", "ExampleText",
 CellID->506613430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeBoxes", "[", 
  RowBox[{
   GraphicsBox[{
     {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
     {RGBColor[0, 0, 1], 
      RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
       NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}}], ",", 
   "StandardForm"}], "]"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"In[1]:=",
 CellID->329304623],

Cell[BoxData[
 RowBox[{"GraphicsBox", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"DiskBox", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
      RowBox[{"RectangleBox", "[", 
       RowBox[{"NCache", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["1", "2"], ",", 
           FractionBox["1", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`"}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
   "}"}], "]"}]], "Output",
 ImageSize->{451, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115887150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528597179],

Cell[TextData[{
 "A special function in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->756809942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeBoxes", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207310738],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"Beta\"\>", ",", "\<\"[\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>"}], "}"}], "]"}],
     ",", "\<\"]\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67977624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeBoxes", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "TraditionalForm"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->104170424],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"InterpretationBox", "[", 
     RowBox[{"\<\"\[CapitalBeta]\"\>", ",", "Beta", ",", 
      RowBox[{"Editable", "\[Rule]", "False"}], ",", 
      RowBox[{"Selectable", "\[Rule]", "False"}]}], "]"}], ",", "\<\"(\"\>", 
    ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>"}], "}"}], "]"}],
     ",", "\<\")\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{497, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104274665]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25313],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6698]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9781],

Cell[TextData[ButtonBox["Low\[Hyphen]Level Input and Output Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LowLevelInputAndOutputRules"]], "Tutorials",
 CellID->26504],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->98300283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->342658399]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MakeBoxes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 24.9936584}", "context" -> "System`", 
    "keywords" -> {
     "format expression", "output format", "print expression with boxes"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MakeBoxes[expr, form] is the low-level function used in Mathematica \
sessions to convert expressions into boxes. MakeBoxes[expr] is the function \
to convert expr to StandardForm boxes.", "synonyms" -> {"make boxes"}, 
    "title" -> "MakeBoxes", "type" -> "Symbol", "uri" -> "ref/MakeBoxes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6876, 233, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->503219804]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15091, 528}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2143, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2766, 78, 47, 1, 70, "ObjectName",
 CellID->19369],
Cell[2816, 81, 1186, 37, 70, "Usage",
 CellID->3878]
}, Open  ]],
Cell[CellGroupData[{
Cell[4039, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4517, 140, 255, 10, 70, "Notes",
 CellID->20259],
Cell[4775, 152, 416, 15, 70, "Notes",
 CellID->19008],
Cell[5194, 169, 472, 16, 70, "Notes",
 CellID->22619],
Cell[5669, 187, 447, 13, 70, "Notes",
 CellID->23971],
Cell[6119, 202, 402, 13, 70, "Notes",
 CellID->30003],
Cell[6524, 217, 315, 11, 70, "Notes",
 CellID->21945]
}, Closed]],
Cell[CellGroupData[{
Cell[6876, 233, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->503219804],
Cell[CellGroupData[{
Cell[7261, 247, 147, 5, 70, "ExampleSection",
 CellID->37958466],
Cell[7411, 254, 77, 1, 70, "ExampleText",
 CellID->82304522],
Cell[CellGroupData[{
Cell[7513, 259, 187, 6, 28, "Input",
 CellID->60899740],
Cell[7703, 267, 349, 11, 36, "Output",
 CellID->4994819]
}, Open  ]],
Cell[8067, 281, 125, 3, 70, "ExampleDelimiter",
 CellID->147778807],
Cell[8195, 286, 75, 1, 70, "ExampleText",
 CellID->506613430],
Cell[CellGroupData[{
Cell[8295, 291, 417, 11, 70, "Input",
 CellID->329304623],
Cell[8715, 304, 896, 29, 73, "Output",
 CellID->115887150]
}, Open  ]],
Cell[9626, 336, 125, 3, 70, "ExampleDelimiter",
 CellID->528597179],
Cell[9754, 341, 356, 13, 70, "ExampleText",
 CellID->756809942],
Cell[CellGroupData[{
Cell[10135, 358, 196, 6, 70, "Input",
 CellID->207310738],
Cell[10334, 366, 411, 12, 36, "Output",
 CellID->67977624]
}, Open  ]],
Cell[CellGroupData[{
Cell[10782, 383, 201, 7, 70, "Input",
 CellID->104170424],
Cell[10986, 392, 612, 17, 54, "Output",
 CellID->104274665]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11659, 416, 311, 9, 70, "SeeAlsoSection",
 CellID->25313],
Cell[11973, 427, 701, 26, 70, "SeeAlso",
 CellID->6698]
}, Open  ]],
Cell[CellGroupData[{
Cell[12711, 458, 313, 9, 70, "TutorialsSection",
 CellID->9781],
Cell[13027, 469, 178, 3, 70, "Tutorials",
 CellID->26504],
Cell[13208, 474, 145, 3, 70, "Tutorials",
 CellID->98300283]
}, Open  ]],
Cell[CellGroupData[{
Cell[13390, 482, 299, 8, 70, "MoreAboutSection"],
Cell[13692, 492, 158, 3, 70, "MoreAbout",
 CellID->342658399]
}, Open  ]],
Cell[13865, 498, 27, 0, 70, "History"],
Cell[13895, 500, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

