(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33657,       1320]
NotebookOptionsPosition[     26984,       1081]
NotebookOutlinePosition[     28250,       1117]
CellTagsIndexPosition[     28164,       1112]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"], 
          "Working with Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithOperators"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Applying Functions to Parts of Expressions\"\>", 
       2->"\<\"Working with Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Map" :> Documentation`HelpLookup["paclet:ref/Map"], 
          "ExpandAll" :> Documentation`HelpLookup["paclet:ref/ExpandAll"], 
          "ReplaceAll" :> Documentation`HelpLookup["paclet:ref/ReplaceAll"], 
          "MapAt" :> Documentation`HelpLookup["paclet:ref/MapAt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Map\"\>", 2->"\<\"ExpandAll\"\>", 
       3->"\<\"ReplaceAll\"\>", 4->"\<\"MapAt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Functional Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MapAll ",
 StyleBox["(//@)", "OperatorCharacter"]
}], "ObjectName",
 CellID->28614],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapAll",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapAll"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "//@", 
       StyleBox["expr", "TI"]}]], "InlineFormula"],
     " applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to every subexpression in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18598]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MapAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAll"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->28458],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MapAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAll"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Heads",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Heads"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to heads in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", and their parts. "
}], "Notes",
 CellID->2661]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->890128692],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->269780054],

Cell[TextData[{
 "Apply ",
 Cell[BoxData["f"], "InlineFormula"],
 " to every subpart of an expression:"
}], "ExampleText",
 CellID->1386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "d", "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7833],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", "c", "]"}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", "d", "]"}], "}"}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13330],

Cell["Alternative input form:", "ExampleText",
 CellID->26048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "//@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "c", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", "d", "}"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8928],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", "c", "]"}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", "d", "]"}], "}"}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29492]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->199321983],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " can be used on expressions with any head:"
}], "ExampleText",
 CellID->31561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23245],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], "+", 
   RowBox[{"f", "[", "b", "]"}], "+", 
   RowBox[{"f", "[", "c", "]"}], "+", 
   RowBox[{"f", "[", "d", "]"}]}], "]"}]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76474566]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28274],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    SuperscriptBox[
     RowBox[{"f", "[", "x", "]"}], 
     RowBox[{"f", "[", "2", "]"}]], "]"}], "+", 
   RowBox[{"f", "[", 
    SuperscriptBox[
     RowBox[{"f", "[", "y", "]"}], 
     RowBox[{"f", "[", "2", "]"}]], "]"}]}], "]"}]], "Output",
 ImageSize->{177, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304513091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331515620],

Cell["The function can be mapped onto the heads as well:", "ExampleText",
 CellID->1743972991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12677],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", "List", "]"}], "[", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", "b", "]"}], ",", 
    RowBox[{"f", "[", "c", "]"}]}], "]"}], "]"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325833120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124936808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " can be used on sparse arrays:"
}], "ExampleText",
 CellID->1501529872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "3"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1754447050],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 2, ">"],
     Editable->False], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143052986]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1818349502],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "1", "]"}], ",", 
    RowBox[{"f", "[", "0", "]"}], ",", 
    RowBox[{"f", "[", "3", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219961281]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1735],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->19810],

Cell[TextData[{
 "Apply ",
 Cell[BoxData["f"], "InlineFormula"],
 " to heads as well as ordinary parts of expressions:"
}], "ExampleText",
 CellID->11599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11837],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", "List", "]"}], "[", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", "b", "]"}]}], "]"}], "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174728243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31982],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93697690]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29352],

Cell["Show nesting structure of an expression:", "ExampleText",
 CellID->11369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31244],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"ArcTan", "[", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "x"}]}], 
      SqrtBox["3"]], "]"}], 
    SqrtBox["3"]]}], "+", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], "]"}]}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x", "+", 
     SuperscriptBox["x", "2"]}], "]"}]}]}]], "Output",
 ImageSize->{308, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4133700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "//@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6608],

Cell[BoxData[
 FrameBox[
  RowBox[{
   FrameBox[
    RowBox[{
     FrameBox[
      RowBox[{"-", "1"}],
      StripOnInput->False], " ", 
     FrameBox[
      RowBox[{"ArcTan", "[", 
       FrameBox[
        RowBox[{
         FrameBox[
          SuperscriptBox[
           FrameBox["3",
            StripOnInput->False], 
           FrameBox[
            RowBox[{"-", 
             FractionBox["1", "2"]}],
            StripOnInput->False]],
          StripOnInput->False], " ", 
         FrameBox[
          RowBox[{
           FrameBox["1",
            StripOnInput->False], "+", 
           FrameBox[
            RowBox[{
             FrameBox["2",
              StripOnInput->False], " ", 
             FrameBox["x",
              StripOnInput->False]}],
            StripOnInput->False]}],
          StripOnInput->False]}],
        StripOnInput->False], "]"}],
      StripOnInput->False], " ", 
     FrameBox[
      SuperscriptBox[
       FrameBox["3",
        StripOnInput->False], 
       FrameBox[
        RowBox[{"-", 
         FractionBox["1", "2"]}],
        StripOnInput->False]],
      StripOnInput->False]}],
    StripOnInput->False], "+", 
   FrameBox[
    RowBox[{
     FrameBox[
      FractionBox["1", "3"],
      StripOnInput->False], " ", 
     FrameBox[
      RowBox[{"Log", "[", 
       FrameBox[
        RowBox[{
         FrameBox[
          RowBox[{"-", "1"}],
          StripOnInput->False], "+", 
         FrameBox["x",
          StripOnInput->False]}],
        StripOnInput->False], "]"}],
      StripOnInput->False]}],
    StripOnInput->False], "+", 
   FrameBox[
    RowBox[{
     FrameBox[
      RowBox[{"-", 
       FractionBox["1", "6"]}],
      StripOnInput->False], " ", 
     FrameBox[
      RowBox[{"Log", "[", 
       FrameBox[
        RowBox[{
         FrameBox["1",
          StripOnInput->False], "+", 
         FrameBox["x",
          StripOnInput->False], "+", 
         FrameBox[
          SuperscriptBox[
           FrameBox["x",
            StripOnInput->False], 
           FrameBox["2",
            StripOnInput->False]],
          StripOnInput->False]}],
        StripOnInput->False], "]"}],
      StripOnInput->False]}],
    StripOnInput->False]}],
  StripOnInput->False]], "Output",
 ImageSize->{376, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108879196]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7625091],

Cell["Leaves are visited before roots:", "ExampleText",
 CellID->78166484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapAll", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Print", "[", "#", "]"}], ";", "#"}], ")"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", 
        RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1353467537],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->45597736],

Cell[BoxData["b"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->233498492],

Cell[BoxData["c"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->692275985],

Cell[BoxData[
 RowBox[{"{", "c", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->152670513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", 
   RowBox[{"{", "c", "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->118562823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", 
     RowBox[{"{", "c", "}"}]}], "}"}]}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->178387699]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94745500],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " is equivalent to a specific level specification in ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->506324401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "d", "}"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1493791351],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", "c", "]"}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", "d", "]"}], "}"}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157860803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "d", "}"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479676633],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", "c", "]"}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"{", 
        RowBox[{"f", "[", "d", "]"}], "}"}], "]"}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21227426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99888172],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " maps also around the whole expression, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", "\[Infinity]"}], "]"}]], "InlineFormula"],
 " does not:"
}], "ExampleText",
 CellID->1399282076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1108466881],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "c", "]"}], ",", 
       RowBox[{"f", "[", "d", "]"}]}], "}"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->696320757]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "\[Infinity]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1231471864],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f", "[", "c", "]"}], ",", 
      RowBox[{"f", "[", "d", "]"}]}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->177500680]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19489],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpandAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpandAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26063],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->32756],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "Tutorials",
 CellID->27892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->279383601],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->1017397]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MapAll (//@) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 41.4784554}", "context" -> "System`", 
    "keywords" -> {"apply function to all parts", "apply to every part"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MapAll[f, expr] or f //@ expr applies f to every subexpression in expr. \
", "synonyms" -> {"map all", "//@"}, "title" -> "MapAll", "type" -> "Symbol", 
    "uri" -> "ref/MapAll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5631, 192, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->890128692]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28021, 1105}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2245, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2868, 79, 101, 4, 70, "ObjectName",
 CellID->28614],
Cell[2972, 85, 818, 28, 70, "Usage",
 CellID->18598]
}, Open  ]],
Cell[CellGroupData[{
Cell[3827, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4305, 135, 654, 26, 70, "Notes",
 CellID->28458],
Cell[4962, 163, 632, 24, 70, "Notes",
 CellID->2661]
}, Closed]],
Cell[CellGroupData[{
Cell[5631, 192, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->890128692],
Cell[CellGroupData[{
Cell[6016, 206, 148, 5, 70, "ExampleSection",
 CellID->269780054],
Cell[6167, 213, 137, 5, 70, "ExampleText",
 CellID->1386],
Cell[CellGroupData[{
Cell[6329, 222, 311, 11, 28, "Input",
 CellID->7833],
Cell[6643, 235, 628, 22, 36, "Output",
 CellID->8360]
}, Open  ]],
Cell[7286, 260, 121, 3, 70, "ExampleDelimiter",
 CellID->13330],
Cell[7410, 265, 62, 1, 70, "ExampleText",
 CellID->26048],
Cell[CellGroupData[{
Cell[7497, 270, 273, 10, 70, "Input",
 CellID->8928],
Cell[7773, 282, 629, 22, 36, "Output",
 CellID->29492]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8451, 310, 243, 7, 70, "ExampleSection",
 CellID->199321983],
Cell[8697, 319, 211, 7, 70, "ExampleText",
 CellID->31561],
Cell[CellGroupData[{
Cell[8933, 330, 165, 5, 70, "Input",
 CellID->23245],
Cell[9101, 337, 344, 11, 36, "Output",
 CellID->76474566]
}, Open  ]],
Cell[CellGroupData[{
Cell[9482, 353, 195, 7, 70, "Input",
 CellID->28274],
Cell[9680, 362, 443, 15, 39, "Output",
 CellID->304513091]
}, Open  ]],
Cell[10138, 380, 125, 3, 70, "ExampleDelimiter",
 CellID->331515620],
Cell[10266, 385, 94, 1, 70, "ExampleText",
 CellID->1743972991],
Cell[CellGroupData[{
Cell[10385, 390, 222, 7, 70, "Input",
 CellID->12677],
Cell[10610, 399, 370, 12, 36, "Output",
 CellID->325833120]
}, Open  ]],
Cell[10995, 414, 125, 3, 70, "ExampleDelimiter",
 CellID->124936808],
Cell[11123, 419, 204, 7, 70, "ExampleText",
 CellID->1501529872],
Cell[CellGroupData[{
Cell[11352, 430, 217, 7, 70, "Input",
 CellID->1754447050],
Cell[11572, 439, 453, 16, 36, "Output",
 CellID->143052986]
}, Open  ]],
Cell[CellGroupData[{
Cell[12062, 460, 126, 4, 70, "Input",
 CellID->1818349502],
Cell[12191, 466, 333, 11, 36, "Output",
 CellID->219961281]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12573, 483, 217, 7, 70, "ExampleSection",
 CellID->1735],
Cell[CellGroupData[{
Cell[12815, 494, 222, 7, 70, "ExampleSubsection",
 CellID->19810],
Cell[13040, 503, 154, 5, 70, "ExampleText",
 CellID->11599],
Cell[CellGroupData[{
Cell[13219, 512, 212, 7, 70, "Input",
 CellID->11837],
Cell[13434, 521, 330, 11, 36, "Output",
 CellID->174728243]
}, Open  ]],
Cell[CellGroupData[{
Cell[13801, 537, 170, 6, 70, "Input",
 CellID->31982],
Cell[13974, 545, 292, 10, 36, "Output",
 CellID->93697690]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[14327, 562, 223, 7, 70, "ExampleSection",
 CellID->29352],
Cell[14553, 571, 79, 1, 70, "ExampleText",
 CellID->11369],
Cell[CellGroupData[{
Cell[14657, 576, 229, 9, 70, "Input",
 CellID->31244],
Cell[14889, 587, 633, 24, 72, "Output",
 CellID->4133700]
}, Open  ]],
Cell[CellGroupData[{
Cell[15559, 616, 94, 3, 70, "Input",
 CellID->6608],
Cell[15656, 621, 2362, 91, 180, "Output",
 CellID->108879196]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18067, 718, 235, 7, 70, "ExampleSection",
 CellID->7625091],
Cell[18305, 727, 74, 1, 70, "ExampleText",
 CellID->78166484],
Cell[CellGroupData[{
Cell[18404, 732, 390, 14, 70, "Input",
 CellID->1353467537],
Cell[CellGroupData[{
Cell[18819, 750, 90, 2, 70, "Print",
 CellID->45597736],
Cell[18912, 754, 91, 2, 70, "Print",
 CellID->233498492],
Cell[19006, 758, 91, 2, 70, "Print",
 CellID->692275985],
Cell[19100, 762, 113, 3, 70, "Print",
 CellID->152670513],
Cell[19216, 767, 160, 5, 70, "Print",
 CellID->118562823],
Cell[19379, 774, 211, 7, 70, "Print",
 CellID->178387699]
}, Open  ]]
}, Open  ]],
Cell[19617, 785, 124, 3, 70, "ExampleDelimiter",
 CellID->94745500],
Cell[19744, 790, 340, 12, 70, "ExampleText",
 CellID->506324401],
Cell[CellGroupData[{
Cell[20109, 806, 383, 13, 70, "Input",
 CellID->1493791351],
Cell[20495, 821, 633, 22, 36, "Output",
 CellID->157860803]
}, Open  ]],
Cell[CellGroupData[{
Cell[21165, 848, 316, 11, 70, "Input",
 CellID->479676633],
Cell[21484, 861, 632, 22, 36, "Output",
 CellID->21227426]
}, Open  ]],
Cell[22131, 886, 124, 3, 70, "ExampleDelimiter",
 CellID->99888172],
Cell[22258, 891, 458, 16, 70, "ExampleText",
 CellID->1399282076],
Cell[CellGroupData[{
Cell[22741, 911, 281, 10, 70, "Input",
 CellID->1108466881],
Cell[23025, 923, 533, 19, 36, "Output",
 CellID->696320757]
}, Open  ]],
Cell[CellGroupData[{
Cell[23595, 947, 301, 11, 70, "Input",
 CellID->1231471864],
Cell[23899, 960, 492, 17, 36, "Output",
 CellID->177500680]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24452, 984, 311, 9, 70, "SeeAlsoSection",
 CellID->19489],
Cell[24766, 995, 931, 35, 70, "SeeAlso",
 CellID->19435]
}, Open  ]],
Cell[CellGroupData[{
Cell[25734, 1035, 314, 9, 70, "TutorialsSection",
 CellID->26063],
Cell[26051, 1046, 193, 4, 70, "Tutorials",
 CellID->32756],
Cell[26247, 1052, 153, 3, 70, "Tutorials",
 CellID->27892]
}, Open  ]],
Cell[CellGroupData[{
Cell[26437, 1060, 319, 9, 70, "MoreAboutSection",
 CellID->279383601],
Cell[26759, 1071, 153, 3, 70, "MoreAbout",
 CellID->1017397]
}, Open  ]],
Cell[26927, 1077, 27, 0, 70, "History"],
Cell[26957, 1079, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

