(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66339,       2460]
NotebookOptionsPosition[     54409,       2036]
NotebookOutlinePosition[     55905,       2076]
CellTagsIndexPosition[     55819,       2071]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Parts of Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MapAt" :> Documentation`HelpLookup["paclet:ref/MapAt"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MapAt\"\>", 2->"\<\"Map\"\>", 
       3->"\<\"SparseArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Functional Programming\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MapIndexed", "ObjectName",
 CellID->13579],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapIndexed",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapIndexed"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the elements of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", giving the part specification of each element as a second argument to \
",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapIndexed",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapIndexed"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to all parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->27577],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels 1 through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels 1 through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->12750],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14007],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->23729],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24081],

Cell["\<\
Level -1 consists of numbers, symbols and other objects that do not have \
subparts.\
\>", "Notes",
 CellID->2995],

Cell["Level 0 corresponds to the whole expression.", "Notes",
 CellID->2678],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " also applies to heads of expressions, and their parts. "
}], "Notes",
 CellID->24676],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " traverses the parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " in a depth-first order, with leaves visited before roots.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2114579524,
  ButtonNote->"2114579524"]
}], "Notes",
 CellID->27753],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " always effectively constructs a complete new expression, and then \
evaluates it."
}], "Notes",
 CellID->20899]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->465565141],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->82641783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"d", ",", 
     RowBox[{"{", "4", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{293, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1221922227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData["#2"], "InlineFormula"],
 " gives the indices of each part:"
}], "ExampleText",
 CellID->8922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"First", "[", "#2", "]"}], "+", 
     RowBox[{"f", "[", "#1", "]"}]}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6748],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"f", "[", "a", "]"}]}], ",", 
   RowBox[{"2", "+", 
    RowBox[{"f", "[", "b", "]"}]}], ",", 
   RowBox[{"3", "+", 
    RowBox[{"f", "[", "c", "]"}]}], ",", 
   RowBox[{"4", "+", 
    RowBox[{"f", "[", "d", "]"}]}]}], "}"}]], "Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460752928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2144],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48429814]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", "e"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"e", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63581685]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29916],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Level Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1181],

Cell["Map at level 1 (default):", "ExampleText",
 CellID->4015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->16626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->577520676]
}, Open  ]],

Cell["Map down to level 2:", "ExampleText",
 CellID->9168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"{", "a", "}"}], "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153277555]
}, Open  ]],

Cell["Map at level 2:", "ExampleText",
 CellID->12097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12181722]
}, Open  ]],

Cell["Map down to level 3:", "ExampleText",
 CellID->19199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->12420],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", "a", "}"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->604760999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->612265955],

Cell["Map onto all elements of an expression:", "ExampleText",
 CellID->5874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", 
       RowBox[{"{", "e", "}"}]}], "}"}]}], "}"}], ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"b", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"c", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"f", "[", 
           RowBox[{"e", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{447, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73710024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56183828],

Cell["\<\
Map only onto the \[OpenCurlyDoubleQuote]leaves\[CloseCurlyDoubleQuote] of \
the expression:\
\>", "ExampleText",
 CellID->8146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d", ",", 
       RowBox[{"{", "e", "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30693],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"f", "[", 
       RowBox[{"e", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "]"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{515, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->423791574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->701579100],

Cell["Negative levels:", "ExampleText",
 CellID->8387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13444],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtuwjAMdZuWMdAGfZl45GvYEx9RoUnwMG0CfmD8eJeUBiHjyvHm3qRW
appzkthuc+qm2ebn/cdnfj7s8vX7Mf/eH3an9ebraCkTAUQ/ALBYga0Xtlae
7rjYEyBxpfFcATNbxBZOlPg5wd/jZ4QXQpxUflKCl/hdtuSnKbt1dowrruUd
i2cFe9Nu92rAd+H5JbpmjH2MDWM/a9Cuhj3ueWIcF9SsOjaFx3eaGt1GP1Px
OM5p4PiJEi/FofE99SSOtv39TZ0Ycxmv6/7lXaQ3XN4T3PIslX+pfFyXpyW8
FEviw5moqzja9CfXcsz0Ir+6PepPa/mVGSVdi3FR4vYXpp1bk2n7a9q+1F7k
isHnUdeeWEitfP+jNumbzI0P+QPQ9Ne0/fGrXVGj9gaqvT7+zziIZ2tU0xDU
1HVmkvZ/Ez61UWVdqKwuR/j/Ebwvqt2+IqKidtT8lVIlxeOdLW83U7anZSd0
/HU/1FUvATWIfgEUEbGS\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{385, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311373320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"f", "[", 
         RowBox[{
          RowBox[{"{", "a", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->950362050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"{", "a", "}"}], "}"}], "}"}], "}"}], ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", "a", "}"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->58782440]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->630194383],

Cell["Different heads at each level:", "ExampleText",
 CellID->19885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"h0", "[", 
    RowBox[{"h1", "[", 
     RowBox[{"h2", "[", 
      RowBox[{"h3", "[", 
       RowBox[{"h4", "[", "a", "]"}], "]"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337],

Cell[BoxData[
 RowBox[{"h0", "[", 
  RowBox[{"h1", "[", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"h2", "[", 
      RowBox[{"f", "[", 
       RowBox[{
        RowBox[{"h3", "[", 
         RowBox[{"h4", "[", "a", "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687131741]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->474907511],

Cell["Map on levels 0 through 1; the head has index {}:", "ExampleText",
 CellID->15199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11785],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", "1", "}"}]}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253391326]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->279566456],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " can be used on expressions with any head:"
}], "ExampleText",
 CellID->31561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23245],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", "1", "}"}]}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"c", ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"d", ",", 
    RowBox[{"{", "4", "}"}]}], "]"}]}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527951044]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->559948443],

Cell["The function can be mapped onto the heads as well:", "ExampleText",
 CellID->1743972991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12677],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"List", ",", 
    RowBox[{"{", "0", "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->724878531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444459605],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapIndexed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapIndexed"]], "InlineFormula"],
 " works on sparse arrays:"
}], "ExampleText",
 CellID->26949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{"3", "->", "a"}], ",", "5"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "4", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"0", ",", 
     RowBox[{"{", "5", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{364, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118953020]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->236],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Heads",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->563123815],

Cell["By default, the function is not mapped onto the heads:", "ExampleText",
 CellID->1342037577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1012910825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57470857]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9487],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"List", ",", 
    RowBox[{"{", "0", "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6054340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168479735],

Cell["Map at heads at all levels:", "ExampleText",
 CellID->982168857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{
    RowBox[{"p", "[", "x", "]"}], "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "Infinity", ",", 
   RowBox[{"Heads", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28162],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "[", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", "0", "}"}]}], "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->463454867]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23183],

Cell["Label parts by position:", "ExampleText",
 CellID->8394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"Labeled", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"y", "^", "2"}], ",", 
     RowBox[{"y", "^", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30180],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V81OwkAQ3ra0VEREDAFiJODPI+gDeNCT4eyxISZwMBrkZOJDGO+8at3t
drF+O5tZagJJt/1mtrPf/OxseczWi+eXbL2cZ5OHVfa2WM7fJ/evKymKAiHE
Rl7ToZDPuXwqrk2ey/utGiOFi584APxUzLoB6SHgEWNlwOhb5CqhHGIJGyAf
Mmz6jL5YXRwxnNAnxUbEW1zY4LlFclAwZjjG5byI5NpmPML4IquEme/nG3JG
q6EXd9+soh4x+tAkIl/Fp4Q+IXikJGuODbLHfCMbnM/FEmPvlzGdAawW5IYY
I8txozIXetR8EZPGL3bx/28u6u3cXTNStefOxa6+UF0oIqzX61b78eHO0weq
i4VET9SnhdFinjg2H3mlOi3b2EXCnK7lTyrelrXvvc86BzyWg9pi6FenlJ84
5Mfeq6noTEGelHK03nXIO16rNcu3Q4eVFPToM4fRZ7SPepo1eQr+6XK9kl/L
0qQOj41nJn49wF14L9DmIn1TY7ucOanEJobdo3b8CPAlYBUT9UGpVghIf1uw
En5XJZbXQ0tyYUkw9nptrJDUem/MxrjY2VanHJDSKSmtV72mCw5A3inlunGZ
X99I46rULHHm1G7rjOWHEZ4Bvib84a1iZaLVS8CYnXpWr2pxrUZAxW8GGPcC
VvY+I0CfBuZM/MqrZ5z+pyeCH54+boo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{158, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->854572464]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Labeled", "[", 
      RowBox[{"#1", ",", "#2"}], "]"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"y", "^", "2"}], ",", 
     RowBox[{"y", "^", "3"}]}], "}"}], ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3065],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXc1OGzEQdrIEKBVtgbTNDSr158apavsEVD300jMXhCrBoWpFOfWSh+Hh
2rdI1/tDli/jHY89DgEciSWOPX/ffDv2ejfw9eTy7PuPk8vz05ODzxcnv87O
T38fHP28KD8qBsYM/hpjvk1M+X5Wvqt+7Otf+WPMH3ssNjc3Tf2a2oNtV2Nm
5in0Hwv71ysrj7y0tJ7NzBTa2H8s7O964a8le7FqXnyCNspjP8q/ZeTfKcvT
UeIo7Ecr6MVHaD9m+lH+DSPP2ZfK0yjgKNSCVjgUhuVhVDbXItEoyoNtjiJR
GTV6ChV0XNGFoGRG1+3KdjxmflqlCK5TVqKRRK+kiH5g5NFrHI/6XkN7A9rI
H84/1Gfl1z2YQ6NHsbqvjdY5PnLZkDJRypk0zF4OExEbzAUyR4ql9WeoUAkr
P9bm7VXFj+PObXOxG9/qsvAuzTCriSiuYm3sBeGddLXr0iNd9bZ1AetL2Op3
OAurMlOm/yFdF2UvVs2LL1V7vuNxaA+dHQ+cC1B+yMhzZ4dUno4y1osRI/8M
xh+S9rko3fJ+KPnL96EU7gVWPpTPKGWUMkq3iRKu5NEf1I/X8FJUY+1Js6Bt
zy9rnFUuC9Isx0aJ/qD+rVm9kt1h7ErZEGpHygItO37Zd1nbZcZJsx4aFZdt
147ses/nmixw7VP72o9lh2t/O9R+GGtcWdhwfK7NplgW+LCM3vewHN5w9qZk
Xr9PmMHUPKSi0/AjjI/U3o/1ZosZl4KXejlClnI7XOgt6iO9FXCAOtu77W0h
WlIOov32HsuTSLt+nOO4w9UU6a6pD8cl9mP9Rf9S1zvUh+xKXeHoc1mKQpr6
xlUG7boWywUpN1E/tdrR5FpboTlctTm2eI/uYfIL21jRY/mF46VX5ne9luEd
t4fJstgshF01bJOf3s7VQmzeM+8oFMKuCmLnUIoxRaO3IBimvTvatUfdSdbe
HW3n6CeB9sJ2R9vr2h2HVe3dUSmqd/POgutZhnwfZna9HjTVq4poAaeMGyFP
z7EZu4xdxu6BY4fyuAqQYjkuD7ZMv2D84uzi+L1G78vIeER6l5gDak9eij1i
/twjB5RdHId60I5vPEF6lXKw1/jUrlrRNsaA1wibTG52QT/GgqtTXN1Kc8f5
F5vDJPodueRiw/5xNWjeXkSbioa6z4RZ3FvQjHXBJ49U/qkYKY8oXIcedU9b
H8oNajiK+hcVOWupeezywB46z1zimcvN5uNG74QYZwmGfnWZaTwyw83WY9AX
G5+2ftselE2bsTpr0vOrmzn7+xVhQSNj3LlUZe7G2chVRS9sFypHSIx6mukz
TTq/6UWmXxMr3xZqf2wu90itWvkM0J5wpaKRR26FgqtJ60cxD6N5jWf93nO4
7pJaQ2NU0K64xtfI0jKuVTWQ7tWjjCnWFw7DVcVcOw5VO8o5wzkAfcI29QTT
KuYwdVxJ7SbOsVVfjV3r2rEDUOOdyvaNaIYtauox+qLc3geLQDoxD8i9vhsr
SO4+9ErzgUNINdIle6LMDG5G4/62CNcO48VkMjH1q/7+Z9l2xEFng5Cvh7DZ
1Y5X6o8db0kR5IeDG/13rN2+cc9cc09lhNUMd+6PGPn3QvtcVZT6T9rfgJw0
meF2a0nbxN113E3kMOh7ZsQQHJFiMFXEqMsvDd98sMHVeYhd+mkdtL5wdplG
ZuEs5mpBbA5GpFUdX9ioKezEVv0Q30+Mo1S/VD5HKfViPpdMYS65H1Fe5SiW
FoV9Fto2ue93cNH46uGisnqo732ER9dnPSRKiT4uWuxH/WFR43c1sC2NWqqP
i1qq735EnSbXXS1G6TyW6PM5nyX67keu0zB8PzJKTj7PmzmKHMVyo5iv5fft
obOW94vCX56Owl+ejgL//h96meavDGYrtJV5No8hm1dMP15ZYn9txb6t/1+G
GfwHH7tW4w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->638496457]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2513],

Cell["Use tooltips to show part numbers of subexpressions:", "ExampleText",
 CellID->9261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"Tooltip", ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "4"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}], ",", 
   "Infinity"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12578],

Cell[BoxData[
 RowBox[{
  TagBox[
   TooltipBox[
    RowBox[{
     TagBox[
      TooltipBox[
       RowBox[{"-", 
        FractionBox["1", "2"]}],
       RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]],
      Annotation[#, {1, 1}, "Tooltip"]& ], " ", 
     TagBox[
      TooltipBox[
       RowBox[{"ArcTan", "[", 
        TagBox[
         TooltipBox["x",
          RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "1"}], "}"}]],
         Annotation[#, {1, 2, 1}, "Tooltip"]& ], "]"}],
       RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}]],
      Annotation[#, {1, 2}, "Tooltip"]& ]}],
    RowBox[{"{", "1", "}"}]],
   Annotation[#, {1}, "Tooltip"]& ], "+", 
  TagBox[
   TooltipBox[
    RowBox[{
     TagBox[
      TooltipBox[
       FractionBox["1", "4"],
       RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}]],
      Annotation[#, {2, 1}, "Tooltip"]& ], " ", 
     TagBox[
      TooltipBox[
       RowBox[{"Log", "[", 
        TagBox[
         TooltipBox[
          RowBox[{
           TagBox[
            TooltipBox[
             RowBox[{"-", "1"}],
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "1", ",", "1"}], "}"}]],
            Annotation[#, {2, 2, 1, 1}, "Tooltip"]& ], "+", 
           TagBox[
            TooltipBox["x",
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "1", ",", "2"}], "}"}]],
            Annotation[#, {2, 2, 1, 2}, "Tooltip"]& ]}],
          RowBox[{"{", 
            RowBox[{"2", ",", "2", ",", "1"}], "}"}]],
         Annotation[#, {2, 2, 1}, "Tooltip"]& ], "]"}],
       RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]],
      Annotation[#, {2, 2}, "Tooltip"]& ]}],
    RowBox[{"{", "2", "}"}]],
   Annotation[#, {2}, "Tooltip"]& ], "+", 
  TagBox[
   TooltipBox[
    RowBox[{
     TagBox[
      TooltipBox[
       RowBox[{"-", 
        FractionBox["1", "4"]}],
       RowBox[{"{", 
         RowBox[{"3", ",", "1"}], "}"}]],
      Annotation[#, {3, 1}, "Tooltip"]& ], " ", 
     TagBox[
      TooltipBox[
       RowBox[{"Log", "[", 
        TagBox[
         TooltipBox[
          RowBox[{
           TagBox[
            TooltipBox["1",
             RowBox[{"{", 
               RowBox[{"3", ",", "2", ",", "1", ",", "1"}], "}"}]],
            Annotation[#, {3, 2, 1, 1}, "Tooltip"]& ], "+", 
           TagBox[
            TooltipBox["x",
             RowBox[{"{", 
               RowBox[{"3", ",", "2", ",", "1", ",", "2"}], "}"}]],
            Annotation[#, {3, 2, 1, 2}, "Tooltip"]& ]}],
          RowBox[{"{", 
            RowBox[{"3", ",", "2", ",", "1"}], "}"}]],
         Annotation[#, {3, 2, 1}, "Tooltip"]& ], "]"}],
       RowBox[{"{", 
         RowBox[{"3", ",", "2"}], "}"}]],
      Annotation[#, {3, 2}, "Tooltip"]& ]}],
    RowBox[{"{", "3", "}"}]],
   Annotation[#, {3}, "Tooltip"]& ]}]], "Output",
 ImageSize->{281, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41238959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16878],

Cell["Convert a list to a polynomial:", "ExampleText",
 CellID->14140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"MapIndexed", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", " ", 
      RowBox[{"x", "^", 
       RowBox[{"First", "[", "#2", "]"}]}]}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4611],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "x"}], "+", 
  RowBox[{"b", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"c", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"d", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"e", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->731501894]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2445],

Cell["Rotate lists based on position:", "ExampleText",
 CellID->170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"RotateLeft", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->604403862]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapIndexed", "[", 
   RowBox[{"RotateLeft", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", "3", "}"}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24750],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW71y2kAQFggZDEwmEye2k0nB0yRVniAV4/GMXWSScVzQUVJSKh0zfgFK
lZSUlJSUlJSU5P5Ax3qlPR3CCDhmQFq0+vbbvR/d7Z1+tJ8f7n+1nx/v2q3v
T+0/D493f1vffj+xv/yS53kv7Pvz1mPnK3Ymvi+rFTvqvwH/9QeDwUp8vAsh
c10pfwXy+x2v14Tc7XaV7AsWFXE6nU6jKMJYcK2AiU11DMD1d0AOlF5NHauE
PoVfXUdpMplA1mEYJsROXA82srjH8+rov/BeyLAoWDISy+Wy0+nEkfDX/8pg
vIp3UdjniSVrcq/XY27z0/ImEuXxeAwjEKCYDXasIPWzCeQLpYczo+7OZlvK
rCGy5rjtl6jr8/l8zQjaKDOxjEUpJ8b1BBuwtWJo9tykHPdNejzifgyLh1eR
sic+nJWv+iSqrH1VPtsI1J3mNjetWHb8WXzS5FuCz0cgX5rwT8GXXsT9bcmI
NW/jvPS/ENavlF6D0EvCg082M3YtwlrW646FY+FY7IMFlwP1FMrSj6/HlBAP
00/Dt2Od/CTN86n8tli5R2KHZ1Qzb+9TuDi/M/utyeV91FWAb4RkxcksBtis
g9tQ0zT+t7BXQfojbA7N9RoIhsn829TupZVnsHe8IhjdALlC6FP4dqyrKi6f
COvXSo8qoyQ8M3bQx7xzPXUjFv/OQKsYkcZ6B33EQWXJgtX2iMY0C5eEb9eG
ipL/yRMr90ik9GQob/LJvoP3KVzM/HYjGpzxOYxosFlY0sjCNIuKjWhMZmem
du08g3UEZs8gI5gdo7KgFL4d65qKyzVh/UbpUWWUhHfMmQPHwrFwLNJZ8PGD
vgJrmi2racc0fQrfZddcJPYZiSKu9Nr7d5orvXY5NjHzQVddTefTr1d6qTvN
be4wswSjtzQ+MDuWdc4J8e1Yi70XTPxMWP+g9OB8B9sVhOG57FqxtIoRaaw2
HnLPmsuuuUjYRcKNaDS0MxjRHNfetXxyp4fZu2YzK3Z71xwLx8Kx0Fn0+/1M
LIqxdy1+y0RnHYbhYrHAWBclD5QnlpRns9lwOOSn+s7rKIrU+yWnt+IpUUej
EfJWASt+FY1T9Zu11623ROCbQ5Dhaa30SjnuneIYlFl9P8Y9a2LfFauzohwV
cnJpHnqvWhXw8zXW8nUejPVb7VWrAh6SHbw775yOwFfvQHql/5RcL7U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->857504959]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97873598],

Cell["Obtain list of all parts in an expression:", "ExampleText",
 CellID->666998931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"First", "@", 
  RowBox[{"Last", "[", 
   RowBox[{"Reap", "[", 
    RowBox[{"MapIndexed", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Sow", "[", "#2", "]"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"a", ",", "b"}], "}"}], ",", 
        RowBox[{"{", "c", "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"{", "d", "}"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "\[Infinity]"}], "}"}]}], "]"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->831147438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59624533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"{", "d", "}"}], "}"}]}], "}"}], ",", "_", ",", "Infinity", ",",
    
   RowBox[{"Heads", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->215839878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", "3", "}"}]}], "}"}]], "Output",
 ImageSize->{374, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31156927]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->122346155],

Cell["Leaves are visited before roots:", "ExampleText",
 CellID->641830738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "#2", "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"{", "e", "}"}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1136444641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->536743012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->463753607],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->43465992],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->793981410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->777804683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->893922482],

Cell[BoxData[
 RowBox[{"{", "2", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->12233255],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->197611147]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9351336],

Cell[TextData[{
 "Using only the first argument is equivalent to using ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1338270049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", "#1", "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1983105638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322493445]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->374625322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118368325]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6172],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11243]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11784],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->15565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->204563280],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->823790388],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->521587587],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->246355285],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->112451994]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MapIndexed",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MapIndexed"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MapIndexed"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MapIndexed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 43.3222526}", "context" -> "System`", 
    "keywords" -> {
     "applying functions with multiple arguments", 
      "applying indexed functions", "numbered parts of expressions"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MapIndexed[f, expr] applies f to the elements of expr, giving the part \
specification of each element as a second argument to f. MapIndexed[f, expr, \
levelspec] applies f to all parts of expr on levels specified by levelspec. ",
     "synonyms" -> {"map indexed"}, "title" -> "MapIndexed", "type" -> 
    "Symbol", "uri" -> "ref/MapIndexed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9267, 321, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->465565141]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55676, 2064}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2440, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3063, 84, 48, 1, 70, "ObjectName",
 CellID->13579],
Cell[3114, 87, 1478, 48, 70, "Usage",
 CellID->25058]
}, Open  ]],
Cell[CellGroupData[{
Cell[4629, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5107, 157, 207, 7, 70, "Notes",
 CellID->27577],
Cell[5317, 166, 1564, 51, 70, "2ColumnTableMod",
 CellID->12750],
Cell[6884, 219, 344, 14, 70, "Notes",
 CellID->14007],
Cell[7231, 235, 303, 12, 70, "Notes",
 CellID->23729],
Cell[7537, 249, 312, 13, 70, "Notes",
 CellID->24081],
Cell[7852, 264, 124, 4, 70, "Notes",
 CellID->2995],
Cell[7979, 270, 76, 1, 70, "Notes",
 CellID->2678],
Cell[8058, 273, 479, 17, 70, "Notes",
 CellID->24676],
Cell[8540, 292, 434, 14, 70, "Notes",
 CellID->27753],
Cell[8977, 308, 253, 8, 70, "Notes",
 CellID->20899]
}, Closed]],
Cell[CellGroupData[{
Cell[9267, 321, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->465565141],
Cell[CellGroupData[{
Cell[9652, 335, 147, 5, 70, "ExampleSection",
 CellID->82641783],
Cell[CellGroupData[{
Cell[9824, 344, 193, 6, 28, "Input",
 CellID->5055],
Cell[10020, 352, 545, 19, 36, "Output",
 CellID->1221922227]
}, Open  ]],
Cell[10580, 374, 120, 3, 70, "ExampleDelimiter",
 CellID->5973],
Cell[10703, 379, 124, 4, 70, "ExampleText",
 CellID->8922],
Cell[CellGroupData[{
Cell[10852, 387, 305, 10, 28, "Input",
 CellID->6748],
Cell[11160, 399, 440, 15, 36, "Output",
 CellID->460752928]
}, Open  ]],
Cell[11615, 417, 121, 3, 70, "ExampleDelimiter",
 CellID->10986],
Cell[CellGroupData[{
Cell[11761, 424, 289, 10, 70, "Input",
 CellID->2144],
Cell[12053, 436, 479, 17, 36, "Output",
 CellID->48429814]
}, Open  ]],
Cell[CellGroupData[{
Cell[12569, 458, 324, 11, 70, "Input",
 CellID->31577],
Cell[12896, 471, 886, 31, 36, "Output",
 CellID->63581685]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13831, 508, 216, 7, 70, "ExampleSection",
 CellID->29916],
Cell[CellGroupData[{
Cell[14072, 519, 236, 7, 70, "ExampleSubsection",
 CellID->1181],
Cell[14311, 528, 63, 1, 70, "ExampleText",
 CellID->4015],
Cell[CellGroupData[{
Cell[14399, 533, 257, 10, 70, "Input",
 CellID->16626],
Cell[14659, 545, 364, 13, 36, "Output",
 CellID->577520676]
}, Open  ]],
Cell[15038, 561, 58, 1, 70, "ExampleText",
 CellID->9168],
Cell[CellGroupData[{
Cell[15121, 566, 268, 10, 70, "Input",
 CellID->17906],
Cell[15392, 578, 485, 17, 36, "Output",
 CellID->153277555]
}, Open  ]],
Cell[15892, 598, 54, 1, 70, "ExampleText",
 CellID->12097],
Cell[CellGroupData[{
Cell[15971, 603, 289, 10, 70, "Input",
 CellID->28118],
Cell[16263, 615, 391, 14, 36, "Output",
 CellID->12181722]
}, Open  ]],
Cell[16669, 632, 59, 1, 70, "ExampleText",
 CellID->19199],
Cell[CellGroupData[{
Cell[16753, 637, 268, 10, 70, "Input",
 CellID->12420],
Cell[17024, 649, 626, 21, 36, "Output",
 CellID->604760999]
}, Open  ]],
Cell[17665, 673, 125, 3, 70, "ExampleDelimiter",
 CellID->612265955],
Cell[17793, 678, 77, 1, 70, "ExampleText",
 CellID->5874],
Cell[CellGroupData[{
Cell[17895, 683, 338, 12, 70, "Input",
 CellID->15791],
Cell[18236, 697, 1269, 42, 54, "Output",
 CellID->73710024]
}, Open  ]],
Cell[19520, 742, 124, 3, 70, "ExampleDelimiter",
 CellID->56183828],
Cell[19647, 747, 138, 4, 70, "ExampleText",
 CellID->8146],
Cell[CellGroupData[{
Cell[19810, 755, 372, 13, 70, "Input",
 CellID->30693],
Cell[20185, 770, 930, 33, 36, "Output",
 CellID->423791574]
}, Open  ]],
Cell[21130, 806, 125, 3, 70, "ExampleDelimiter",
 CellID->701579100],
Cell[21258, 811, 54, 1, 70, "ExampleText",
 CellID->8387],
Cell[CellGroupData[{
Cell[21337, 816, 256, 9, 70, "Input",
 CellID->13444],
Cell[21596, 827, 720, 16, 70, "Output",
 Evaluatable->False,
 CellID->311373320]
}, Open  ]],
Cell[CellGroupData[{
Cell[22353, 848, 256, 9, 70, "Input",
 CellID->14507],
Cell[22612, 859, 594, 20, 36, "Output",
 CellID->950362050]
}, Open  ]],
Cell[CellGroupData[{
Cell[23243, 884, 256, 9, 70, "Input",
 CellID->17827],
Cell[23502, 895, 454, 16, 36, "Output",
 CellID->58782440]
}, Open  ]],
Cell[23971, 914, 125, 3, 70, "ExampleDelimiter",
 CellID->630194383],
Cell[24099, 919, 69, 1, 70, "ExampleText",
 CellID->19885],
Cell[CellGroupData[{
Cell[24193, 924, 363, 12, 70, "Input",
 CellID->337],
Cell[24559, 938, 555, 18, 36, "Output",
 CellID->687131741]
}, Open  ]],
Cell[25129, 959, 125, 3, 70, "ExampleDelimiter",
 CellID->474907511],
Cell[25257, 964, 88, 1, 70, "ExampleText",
 CellID->15199],
Cell[CellGroupData[{
Cell[25370, 969, 233, 8, 70, "Input",
 CellID->11785],
Cell[25606, 979, 449, 16, 36, "Output",
 CellID->253391326]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26116, 1002, 243, 7, 70, "ExampleSection",
 CellID->279566456],
Cell[26362, 1011, 219, 7, 70, "ExampleText",
 CellID->31561],
Cell[CellGroupData[{
Cell[26606, 1022, 169, 5, 70, "Input",
 CellID->23245],
Cell[26778, 1029, 509, 18, 36, "Output",
 CellID->527951044]
}, Open  ]],
Cell[27302, 1050, 125, 3, 70, "ExampleDelimiter",
 CellID->559948443],
Cell[27430, 1055, 94, 1, 70, "ExampleText",
 CellID->1743972991],
Cell[CellGroupData[{
Cell[27549, 1060, 226, 7, 70, "Input",
 CellID->12677],
Cell[27778, 1069, 539, 19, 36, "Output",
 CellID->724878531]
}, Open  ]],
Cell[28332, 1091, 125, 3, 70, "ExampleDelimiter",
 CellID->444459605],
Cell[28460, 1096, 201, 7, 70, "ExampleText",
 CellID->26949],
Cell[CellGroupData[{
Cell[28686, 1107, 216, 7, 70, "Input",
 CellID->26857],
Cell[28905, 1116, 634, 22, 36, "Output",
 CellID->118953020]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29588, 1144, 216, 7, 70, "ExampleSection",
 CellID->236],
Cell[CellGroupData[{
Cell[29829, 1155, 226, 7, 70, "ExampleSubsection",
 CellID->563123815],
Cell[30058, 1164, 98, 1, 70, "ExampleText",
 CellID->1342037577],
Cell[CellGroupData[{
Cell[30181, 1169, 189, 6, 70, "Input",
 CellID->1012910825],
Cell[30373, 1177, 453, 16, 36, "Output",
 CellID->57470857]
}, Open  ]],
Cell[CellGroupData[{
Cell[30863, 1198, 230, 7, 70, "Input",
 CellID->9487],
Cell[31096, 1207, 537, 19, 36, "Output",
 CellID->6054340]
}, Open  ]],
Cell[31648, 1229, 125, 3, 70, "ExampleDelimiter",
 CellID->168479735],
Cell[31776, 1234, 70, 1, 70, "ExampleText",
 CellID->982168857],
Cell[CellGroupData[{
Cell[31871, 1239, 283, 8, 70, "Input",
 CellID->28162],
Cell[32157, 1249, 796, 28, 36, "Output",
 CellID->463454867]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[33014, 1284, 223, 7, 70, "ExampleSection",
 CellID->23183],
Cell[33240, 1293, 62, 1, 70, "ExampleText",
 CellID->8394],
Cell[CellGroupData[{
Cell[33327, 1298, 304, 10, 70, "Input",
 CellID->30180],
Cell[33634, 1310, 915, 19, 70, "Output",
 Evaluatable->False,
 CellID->854572464]
}, Open  ]],
Cell[CellGroupData[{
Cell[34586, 1334, 434, 14, 70, "Input",
 CellID->3065],
Cell[35023, 1350, 2176, 40, 70, "Output",
 Evaluatable->False,
 CellID->638496457]
}, Open  ]],
Cell[37214, 1393, 120, 3, 70, "ExampleDelimiter",
 CellID->2513],
Cell[37337, 1398, 90, 1, 70, "ExampleText",
 CellID->9261],
Cell[CellGroupData[{
Cell[37452, 1403, 324, 11, 70, "Input",
 CellID->12578],
Cell[37779, 1416, 2955, 97, 70, "Output",
 CellID->41238959]
}, Open  ]],
Cell[40749, 1516, 121, 3, 70, "ExampleDelimiter",
 CellID->16878],
Cell[40873, 1521, 70, 1, 70, "ExampleText",
 CellID->14140],
Cell[CellGroupData[{
Cell[40968, 1526, 353, 12, 70, "Input",
 CellID->4611],
Cell[41324, 1540, 426, 15, 36, "Output",
 CellID->731501894]
}, Open  ]],
Cell[41765, 1558, 120, 3, 70, "ExampleDelimiter",
 CellID->2445],
Cell[41888, 1563, 68, 1, 70, "ExampleText",
 CellID->170],
Cell[CellGroupData[{
Cell[41981, 1568, 281, 9, 70, "Input",
 CellID->29975],
Cell[42265, 1579, 598, 19, 36, "Output",
 CellID->604403862]
}, Open  ]],
Cell[CellGroupData[{
Cell[42900, 1603, 500, 16, 70, "Input",
 CellID->24750],
Cell[43403, 1621, 1439, 27, 70, "Output",
 Evaluatable->False,
 CellID->857504959]
}, Open  ]],
Cell[44857, 1651, 124, 3, 70, "ExampleDelimiter",
 CellID->97873598],
Cell[44984, 1656, 85, 1, 70, "ExampleText",
 CellID->666998931],
Cell[CellGroupData[{
Cell[45094, 1661, 573, 19, 70, "Input",
 CellID->831147438],
Cell[45670, 1682, 590, 20, 36, "Output",
 CellID->59624533]
}, Open  ]],
Cell[CellGroupData[{
Cell[46297, 1707, 387, 13, 70, "Input",
 CellID->215839878],
Cell[46687, 1722, 590, 20, 36, "Output",
 CellID->31156927]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47326, 1748, 237, 7, 70, "ExampleSection",
 CellID->122346155],
Cell[47566, 1757, 75, 1, 70, "ExampleText",
 CellID->641830738],
Cell[CellGroupData[{
Cell[47666, 1762, 447, 16, 70, "Input",
 CellID->1136444641],
Cell[CellGroupData[{
Cell[48138, 1782, 136, 4, 70, "Print",
 CellID->536743012],
Cell[48277, 1788, 136, 4, 70, "Print",
 CellID->463753607],
Cell[48416, 1794, 112, 3, 70, "Print",
 CellID->43465992],
Cell[48531, 1799, 136, 4, 70, "Print",
 CellID->793981410],
Cell[48670, 1805, 146, 4, 70, "Print",
 CellID->777804683],
Cell[48819, 1811, 136, 4, 70, "Print",
 CellID->893922482],
Cell[48958, 1817, 112, 3, 70, "Print",
 CellID->12233255],
Cell[49073, 1822, 108, 3, 70, "Print",
 CellID->197611147]
}, Open  ]]
}, Open  ]],
Cell[49208, 1829, 123, 3, 70, "ExampleDelimiter",
 CellID->9351336],
Cell[49334, 1834, 227, 8, 70, "ExampleText",
 CellID->1338270049],
Cell[CellGroupData[{
Cell[49586, 1846, 239, 8, 70, "Input",
 CellID->1983105638],
Cell[49828, 1856, 301, 10, 36, "Output",
 CellID->322493445]
}, Open  ]],
Cell[CellGroupData[{
Cell[50166, 1871, 181, 6, 70, "Input",
 CellID->374625322],
Cell[50350, 1879, 301, 10, 36, "Output",
 CellID->118368325]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50712, 1896, 310, 9, 70, "SeeAlsoSection",
 CellID->6172],
Cell[51025, 1907, 686, 26, 70, "SeeAlso",
 CellID->11243]
}, Open  ]],
Cell[CellGroupData[{
Cell[51748, 1938, 314, 9, 70, "TutorialsSection",
 CellID->11784],
Cell[52065, 1949, 193, 4, 70, "Tutorials",
 CellID->15565]
}, Open  ]],
Cell[CellGroupData[{
Cell[52295, 1958, 319, 9, 70, "MoreAboutSection",
 CellID->204563280],
Cell[52617, 1969, 163, 3, 70, "MoreAbout",
 CellID->823790388],
Cell[52783, 1974, 155, 3, 70, "MoreAbout",
 CellID->521587587],
Cell[52941, 1979, 145, 3, 70, "MoreAbout",
 CellID->246355285],
Cell[53089, 1984, 147, 3, 70, "MoreAbout",
 CellID->112451994]
}, Open  ]],
Cell[CellGroupData[{
Cell[53273, 1992, 305, 8, 70, "RelatedLinksSection"],
Cell[53581, 2002, 365, 12, 70, "RelatedLinks"],
Cell[53949, 2016, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[54352, 2032, 27, 0, 70, "History"],
Cell[54382, 2034, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

