(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42364,       1593]
NotebookOptionsPosition[     34252,       1307]
NotebookOutlinePosition[     35620,       1344]
CellTagsIndexPosition[     35534,       1339]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Parts of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Applying Functions to Parts of Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apply" :> Documentation`HelpLookup["paclet:ref/Apply"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "Thread" :> 
          Documentation`HelpLookup["paclet:ref/Thread"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "Transpose" :> 
          Documentation`HelpLookup["paclet:ref/Transpose"], "Through" :> 
          Documentation`HelpLookup["paclet:ref/Through"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Apply\"\>", 2->"\<\"Map\"\>", 
       3->"\<\"Thread\"\>", 4->"\<\"Inner\"\>", 5->"\<\"Transpose\"\>", 
       6->"\<\"Through\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Functional Programming\"\>", 
       3->"\<\"List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MapThread", "ObjectName",
 CellID->26835],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapThread",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapThread"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["a", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["b", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "[", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        RowBox[{
         StyleBox["f", "TI"], "[", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["b", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MapThread",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MapThread"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the parts of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25680]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->611141124],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to corresponding pairs of elements:"
}], "ExampleText",
 CellID->7905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99132174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->593036811],

Cell[TextData[{
 "Apply ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to elements of a matrix:"
}], "ExampleText",
 CellID->572149649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "v"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"s", ",", "t"}], "}"}]}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1870475873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "u"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "v"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "s"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "t"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58183358]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->664882383],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " threads over level 1 of the arguments:"
}], "ExampleText",
 CellID->1448643162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "v"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"w", ",", "x"}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1847374338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137590671]
}, Open  ]],

Cell["Thread over level 2:", "ExampleText",
 CellID->1863455680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "v"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"w", ",", "x"}], "}"}]}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1438850718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "u"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"b", ",", "v"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"c", ",", "w"}], "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"d", ",", "x"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->457958621]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->771687514],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " works with any number of expressions:"
}], "ExampleText",
 CellID->21962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "11", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->21080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "4", ",", "7", ",", "10"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"2", ",", "5", ",", "8", ",", "11"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"3", ",", "6", ",", "9", ",", "12"}], "]"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255830932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10508],

Cell["Set up an outer totalistic cellular automaton:", "ExampleText",
 CellID->10080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"1", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->929739458]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{
      RowBox[{"RotateLeft", "[", "t", "]"}], "+", 
      RowBox[{"RotateRight", "[", "t", "]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1329930471],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWctuwjAQ3NikaakgCace+ZUKqT31IyJUCQ5VK8r/U9tNEFq8ysvG2mCk
RPEynp3VeuIo+aiOu8+v6rjfVuv3Q/Wz229/12/fBxWSCYB4BYD8BdT1SV2Z
o/lt1AEw02d5jsNcnYQaPqN4XsdTFC8848tAegrP/KHqlabrEkXx7GYVlJbZ
trhr/CqQHpyXe73Y3eJk676OpnB9L9A4aVlDGRHH8x+Y8WbM9A7hteG78lLr
xJdeCs+9b3YX4jFmMbPS89hw/GvTzs/If7ESjX6caK6nidY1LtfcwjokCzXv
lrXgDt/TSri+h4gWVDcli04Klky5c6a6h3EXCNWXFeN9asWdmUrnMFdicG72
+/DVRa9Gr07Hqz6fzcNXF70avXpvXqXeUozJvGDCuWSisx9nm/cotmGe66et
zWtcOhL3wbgPuvBi3AfHKB7jVeotdfOeaVaPcxQvHeNWN8p7+YWWwoka1zXv
JZ/rOuxfYps+b3qOIPkDOsz8iw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{577, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->651750365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7740],

Cell["Divide eigenvectors by their corresponding eigenvalues:", "ExampleText",
 CellID->24773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigensystem", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "7"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", "+", 
      SqrtBox["15"]}], ",", 
     RowBox[{"4", "-", 
      SqrtBox["15"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "2"]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"4", "+", 
           SqrtBox["15"]}], ")"}]}]}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["7", "2"]}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"4", "-", 
           SqrtBox["15"]}], ")"}]}]}], ",", "1"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{466, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->797940800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"#2", "/", "#1"}], "&"}], ",", "%"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "27"}], "+", 
        RowBox[{"7", " ", 
         SqrtBox["15"]}]}], ")"}]}], ",", 
     RowBox[{"4", "-", 
      SqrtBox["15"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "27"}], "-", 
        RowBox[{"7", " ", 
         SqrtBox["15"]}]}], ")"}]}], ",", 
     RowBox[{"4", "+", 
      SqrtBox["15"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{388, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->554002912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->33962027],

Cell["Apply the functions in a list to corresponding arguments:", \
"ExampleText",
 CellID->465355440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#1", "@", "#2"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "g", ",", "h"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->574995411],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"g", "[", "y", "]"}], ",", 
   RowBox[{"h", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179590852]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23335],

Cell["Add columns of elements in a matrix:", "ExampleText",
 CellID->11072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23400],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "u", "+", "x"}], ",", 
   RowBox[{"b", "+", "v", "+", "y"}], ",", 
   RowBox[{"c", "+", "w", "+", "z"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102094318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22955],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "u", "+", "x"}], ",", 
   RowBox[{"b", "+", "v", "+", "y"}], ",", 
   RowBox[{"c", "+", "w", "+", "z"}]}], "}"}]], "Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18042388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4141],

Cell["Get lists of elements in columns of a matrix:", "ExampleText",
 CellID->23588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "u", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "v", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "w", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->906928372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "u", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "v", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "w", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153547551]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->869319521],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 ", but takes the function and arguments separately:"
}], "ExampleText",
 CellID->280322633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401818638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537386511]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139695211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->474178488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1146506325],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " evaluates the whole expression before threading:"
}], "ExampleText",
 CellID->166134388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x", " ", "y"}], ",", " ", 
      RowBox[{"x", " ", "z"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328141533],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "::", "\<\"dvar\"\>"}], ":", 
  " ", "\<\"Multiple derivative specifier \\!\\({x, y, z}\\) does not have \
the form {variable, n}, where n is a non-negative machine integer. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/D/dvar\\\", ButtonNote \
-> \\\"D::dvar\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->741810338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->639218074]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " takes the function and its arguments separately:"
}], "ExampleText",
 CellID->1608977100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"D", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", " ", "y"}], ",", 
       RowBox[{"x", " ", "z"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->591599609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195488569]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1367403153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " is a generalization of ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to functions of several variables:"
}], "ExampleText",
 CellID->1947319642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1378560731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546814371]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->693812842],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433128475]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->379103449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->81789806]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->112625539],

Cell["All arguments must be lists of the same length:", "ExampleText",
 CellID->444919631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "t", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1732502791],

Cell[BoxData[
 RowBox[{
  RowBox[{"MapThread", "::", "\<\"mptd\"\>"}], ":", 
  " ", "\<\"Object \\!\\(t\\) at position {2, \\!\\(2\\)} in \\!\\(MapThread[\
\\(\\(f, \\(\\({\\(\\({a, b, c}\\)\\), t, \\(\\({u, v, w}\\)\\)}\\)\\)\\)\\)]\
\\) has only \\!\\(0\\) of required \\!\\(1\\) dimensions. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/MapThread/mptd\\\", \
ButtonNote -> \\\"MapThread::mptd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->191808465],

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "t", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49917420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->794405016],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " repeats nonlist arguments as needed:"
}], "ExampleText",
 CellID->287086067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "t", ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v", ",", "w"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1858272168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "t", ",", "u"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "t", ",", "v"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "t", ",", "w"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24953603]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24808],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Through",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Through"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8976],

Cell[TextData[ButtonBox["Applying Functions to Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ApplyingFunctionsToPartsOfExpressions"]], "Tutorials",
 CellID->18455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->735206221],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->129881841],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->912164359],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->9440116]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MapThread - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 44.4316560}", "context" -> "System`", 
    "keywords" -> {"multivariate Map", "parallel form of Map"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MapThread[f, {{a_1, a_2, ...}, {b_1, b_2, ...}, ...}] gives {f[a_1, b_1, \
...], f[a_2, b_2, ...], ...}. MapThread[f, {expr_1, expr_2, ...}, n] applies \
f to the parts of the expr_i at level n. ", "synonyms" -> {"map thread"}, 
    "title" -> "MapThread", "type" -> "Symbol", "uri" -> "ref/MapThread"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6150, 186, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35399, 1332}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2567, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3190, 85, 47, 1, 70, "ObjectName",
 CellID->26835],
Cell[3240, 88, 2873, 93, 70, "Usage",
 CellID->25680]
}, Open  ]],
Cell[CellGroupData[{
Cell[6150, 186, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[6527, 200, 148, 5, 70, "ExampleSection",
 CellID->611141124],
Cell[6678, 207, 157, 6, 70, "ExampleText",
 CellID->7905],
Cell[CellGroupData[{
Cell[6860, 217, 299, 10, 28, "Input",
 CellID->10440],
Cell[7162, 229, 375, 13, 36, "Output",
 CellID->99132174]
}, Open  ]],
Cell[7552, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->593036811],
Cell[7680, 250, 151, 6, 70, "ExampleText",
 CellID->572149649],
Cell[CellGroupData[{
Cell[7856, 260, 525, 19, 28, "Input",
 CellID->1870475873],
Cell[8384, 281, 533, 19, 36, "Output",
 CellID->58183358]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8966, 306, 220, 7, 70, "ExampleSection",
 CellID->664882383],
Cell[9189, 315, 236, 8, 70, "ExampleText",
 CellID->1448643162],
Cell[CellGroupData[{
Cell[9450, 327, 512, 18, 70, "Input",
 CellID->1847374338],
Cell[9965, 347, 524, 19, 36, "Output",
 CellID->137590671]
}, Open  ]],
Cell[10504, 369, 64, 1, 70, "ExampleText",
 CellID->1863455680],
Cell[CellGroupData[{
Cell[10593, 374, 525, 19, 70, "Input",
 CellID->1438850718],
Cell[11121, 395, 534, 19, 36, "Output",
 CellID->457958621]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11704, 420, 243, 7, 70, "ExampleSection",
 CellID->771687514],
Cell[11950, 429, 213, 7, 70, "ExampleText",
 CellID->21962],
Cell[CellGroupData[{
Cell[12188, 440, 450, 15, 70, "Input",
 CellID->21080],
Cell[12641, 457, 439, 13, 36, "Output",
 CellID->255830932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13129, 476, 223, 7, 70, "ExampleSection",
 CellID->10508],
Cell[13355, 485, 85, 1, 70, "ExampleText",
 CellID->10080],
Cell[CellGroupData[{
Cell[13465, 490, 152, 5, 70, "Input",
 CellID->5340],
Cell[13620, 497, 291, 9, 36, "Output",
 CellID->929739458]
}, Open  ]],
Cell[CellGroupData[{
Cell[13948, 511, 287, 9, 70, "Input",
 CellID->1329930471],
Cell[14238, 522, 728, 16, 70, "Output",
 Evaluatable->False,
 CellID->651750365]
}, Open  ]],
Cell[14981, 541, 120, 3, 70, "ExampleDelimiter",
 CellID->7740],
Cell[15104, 546, 94, 1, 70, "ExampleText",
 CellID->24773],
Cell[CellGroupData[{
Cell[15223, 551, 251, 9, 70, "Input",
 CellID->8546],
Cell[15477, 562, 937, 36, 51, "Output",
 CellID->797940800]
}, Open  ]],
Cell[CellGroupData[{
Cell[16451, 603, 211, 8, 70, "Input",
 CellID->19097],
Cell[16665, 613, 748, 29, 51, "Output",
 CellID->554002912]
}, Open  ]],
Cell[17428, 645, 124, 3, 70, "ExampleDelimiter",
 CellID->33962027],
Cell[17555, 650, 102, 2, 70, "ExampleText",
 CellID->465355440],
Cell[CellGroupData[{
Cell[17682, 656, 349, 12, 70, "Input",
 CellID->574995411],
Cell[18034, 670, 301, 10, 36, "Output",
 CellID->179590852]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18384, 686, 233, 7, 70, "ExampleSection",
 CellID->23335],
Cell[18620, 695, 75, 1, 70, "ExampleText",
 CellID->11072],
Cell[CellGroupData[{
Cell[18720, 700, 375, 12, 70, "Input",
 CellID->23400],
Cell[19098, 714, 316, 10, 36, "Output",
 CellID->102094318]
}, Open  ]],
Cell[CellGroupData[{
Cell[19451, 729, 337, 11, 70, "Input",
 CellID->22955],
Cell[19791, 742, 315, 10, 36, "Output",
 CellID->18042388]
}, Open  ]],
Cell[20121, 755, 120, 3, 70, "ExampleDelimiter",
 CellID->4141],
Cell[20244, 760, 84, 1, 70, "ExampleText",
 CellID->23588],
Cell[CellGroupData[{
Cell[20353, 765, 375, 12, 70, "Input",
 CellID->12481],
Cell[20731, 779, 391, 13, 36, "Output",
 CellID->906928372]
}, Open  ]],
Cell[CellGroupData[{
Cell[21159, 797, 341, 11, 70, "Input",
 CellID->28315],
Cell[21503, 810, 391, 13, 36, "Output",
 CellID->153547551]
}, Open  ]],
Cell[21909, 826, 125, 3, 70, "ExampleDelimiter",
 CellID->869319521],
Cell[22037, 831, 361, 12, 70, "ExampleText",
 CellID->280322633],
Cell[CellGroupData[{
Cell[22423, 847, 303, 10, 70, "Input",
 CellID->401818638],
Cell[22729, 859, 376, 13, 36, "Output",
 CellID->537386511]
}, Open  ]],
Cell[CellGroupData[{
Cell[23142, 877, 276, 9, 70, "Input",
 CellID->139695211],
Cell[23421, 888, 376, 13, 36, "Output",
 CellID->474178488]
}, Open  ]],
Cell[23812, 904, 126, 3, 70, "ExampleDelimiter",
 CellID->1146506325],
Cell[23941, 909, 222, 7, 70, "ExampleText",
 CellID->166134388],
Cell[CellGroupData[{
Cell[24188, 920, 335, 11, 70, "Input",
 CellID->328141533],
Cell[24526, 933, 437, 8, 70, "Message",
 CellID->741810338],
Cell[24966, 943, 213, 7, 36, "Output",
 CellID->639218074]
}, Open  ]],
Cell[25194, 953, 229, 7, 70, "ExampleText",
 CellID->1608977100],
Cell[CellGroupData[{
Cell[25448, 964, 359, 12, 70, "Input",
 CellID->591599609],
Cell[25810, 978, 213, 7, 36, "Output",
 CellID->195488569]
}, Open  ]],
Cell[26038, 988, 126, 3, 70, "ExampleDelimiter",
 CellID->1367403153],
Cell[26167, 993, 353, 12, 70, "ExampleText",
 CellID->1947319642],
Cell[CellGroupData[{
Cell[26545, 1009, 182, 6, 70, "Input",
 CellID->1378560731],
Cell[26730, 1017, 301, 10, 36, "Output",
 CellID->546814371]
}, Open  ]],
Cell[CellGroupData[{
Cell[27068, 1032, 213, 7, 70, "Input",
 CellID->693812842],
Cell[27284, 1041, 301, 10, 36, "Output",
 CellID->433128475]
}, Open  ]],
Cell[CellGroupData[{
Cell[27622, 1056, 303, 10, 70, "Input",
 CellID->379103449],
Cell[27928, 1068, 375, 13, 36, "Output",
 CellID->81789806]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28352, 1087, 230, 7, 70, "ExampleSection",
 CellID->112625539],
Cell[28585, 1096, 90, 1, 70, "ExampleText",
 CellID->444919631],
Cell[CellGroupData[{
Cell[28700, 1101, 314, 10, 70, "Input",
 CellID->1732502791],
Cell[29017, 1113, 534, 9, 70, "Message",
 CellID->191808465],
Cell[29554, 1124, 401, 13, 36, "Output",
 CellID->49917420]
}, Open  ]],
Cell[29970, 1140, 125, 3, 70, "ExampleDelimiter",
 CellID->794405016],
Cell[30098, 1145, 210, 7, 70, "ExampleText",
 CellID->287086067],
Cell[CellGroupData[{
Cell[30333, 1156, 287, 9, 70, "Input",
 CellID->1858272168],
Cell[30623, 1167, 405, 13, 36, "Output",
 CellID->24953603]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31089, 1187, 311, 9, 70, "SeeAlsoSection",
 CellID->24808],
Cell[31403, 1198, 1405, 53, 70, "SeeAlso",
 CellID->13559]
}, Open  ]],
Cell[CellGroupData[{
Cell[32845, 1256, 313, 9, 70, "TutorialsSection",
 CellID->8976],
Cell[33161, 1267, 193, 4, 70, "Tutorials",
 CellID->18455]
}, Open  ]],
Cell[CellGroupData[{
Cell[33391, 1276, 319, 9, 70, "MoreAboutSection",
 CellID->735206221],
Cell[33713, 1287, 163, 3, 70, "MoreAbout",
 CellID->129881841],
Cell[33879, 1292, 155, 3, 70, "MoreAbout",
 CellID->912164359],
Cell[34037, 1297, 143, 3, 70, "MoreAbout",
 CellID->9440116]
}, Open  ]],
Cell[34195, 1303, 27, 0, 70, "History"],
Cell[34225, 1305, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

