(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87117,       2073]
NotebookOptionsPosition[     79874,       1826]
NotebookOutlinePosition[     81420,       1867]
CellTagsIndexPosition[     81334,       1862]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuS" :> Documentation`HelpLookup["paclet:ref/MathieuS"], 
          "MathieuCPrime" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCPrime"], 
          "MathieuCharacteristicA" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicA"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MathieuS\"\>", 
       2->"\<\"MathieuCPrime\"\>", 
       3->"\<\"MathieuCharacteristicA\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathieu and Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathieuAndRelatedFunctions"],
           "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Mathieu and Related Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuC", "ObjectName",
 CellID->13698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuC",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuC"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the even Mathieu function with characteristic \
value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11267]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The Mathieu functions satisfy the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", "q", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"2", "z"}], ")"}]}]}], ")"}], "y"}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->65],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuC"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->326595552],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuC"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuC"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->288207148],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->866357652],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->164095502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuC", "[", 
  RowBox[{"2", ",", "1", ",", "3.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30685000],

Cell[BoxData[
 RowBox[{"-", "0.8995311634414722`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->785782887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741042028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{"3", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522055755],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402524631]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18630],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->347043095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuC", "[", 
  RowBox[{"I", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47512834],

Cell[BoxData[
 RowBox[{"20.292026911382564`", "\[InvisibleSpace]", "-", 
  RowBox[{"27.042760080016404`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->269436193]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139258261],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109862149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"37", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706408],

Cell[BoxData[
 RowBox[{"-", 
  "0.7067473413037672704676050403643143864980241652301139270085285500406`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180044896]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96263149],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->65024484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuC", "[", 
  RowBox[{"2", ",", "1", ",", "3.70000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179399986],

Cell[BoxData[
 RowBox[{"-", 
  "0.70674734130376727046760504036431438649802361151`30.90313673579998"}]], \
"Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6025705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88790991],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322566979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuC", "[", 
  RowBox[{"3", ",", "0", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120703106],

Cell[BoxData[
 RowBox[{"Cos", "[", 
  RowBox[{
   SqrtBox["3"], " ", "z"}], "]"}]], "Output",
 ImageSize->{73, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->356888347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627196239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuC",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuC"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->190360466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuC", "[", 
  RowBox[{"a", ",", "q", ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634825195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{"a", ",", "q", ",", "z1"}], "]"}], ",", 
   RowBox[{"MathieuC", "[", 
    RowBox[{"a", ",", "q", ",", "z2"}], "]"}], ",", 
   RowBox[{"MathieuC", "[", 
    RowBox[{"a", ",", "q", ",", "z3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28580151]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6407],

Cell["\<\
Solve the Schr\[ODoubleDot]dinger equation with periodic potential:\
\>", "ExampleText",
 CellID->371320199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"\[ScriptCapitalE]", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169079706],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"MathieuC", "[", 
       RowBox[{
        RowBox[{"4", " ", "\[ScriptCapitalE]"}], ",", "2", ",", 
        FractionBox["x", "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"MathieuS", "[", 
       RowBox[{
        RowBox[{"4", " ", "\[ScriptCapitalE]"}], ",", "2", ",", 
        FractionBox["x", "2"]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{406, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->207552333]
}, Open  ]],

Cell[TextData[{
 "By the Bloch theorem, solutions are bounded provided \[ScriptCapitalE] is \
within an energy band. The energy gap corresponds to a range of \
\[ScriptCapitalE] where ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " has a non-vanishing imaginary part:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->478229195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"Re", "[", 
       RowBox[{"MathieuC", "[", 
        RowBox[{"a", ",", "2", ",", "100"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"MathieuCharacteristicExponent", "[", 
       RowBox[{"a", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "16"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Dashing", "[", "Tiny", "]"}], "}"}], ",", 
      RowBox[{"{", "Thick", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166580877],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->415818447]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322927007],

Cell["\<\
Solve the Laplace equation in an ellipse using separation of variables:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19883067],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ellipse\[Psi]", "[", 
    RowBox[{"n_", ",", "z0_"}], "]"}], "[", 
   RowBox[{"r_", ",", "f_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ch", "=", 
      RowBox[{"MathieuCharacteristicA", "[", 
       RowBox[{"n", ",", "z0"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"MathieuC", "[", 
      RowBox[{"ch", ",", "z0", ",", 
       RowBox[{"\[ImaginaryI]", " ", "r"}]}], "]"}], 
     RowBox[{"MathieuC", "[", 
      RowBox[{"ch", ",", "z0", ",", "f"}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36876722],

Cell["This finds a zero:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->468674505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicA", "[", 
      RowBox[{"5", ",", "q"}], "]"}], ",", "q", ",", 
     RowBox[{"I", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "20"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5359889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", "\[Rule]", "22.66671708059834602782344939772130821153`25."}], 
  "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135129354]
}, Open  ]],

Cell["\<\
This plots an eigenfunction. It vanishes at the ellipse boundary:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->155111556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", "r", "]"}], " ", 
      RowBox[{"Cos", "[", "f", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sinh", "[", "r", "]"}], " ", 
      RowBox[{"Sin", "[", "f", "]"}]}], ",", 
     RowBox[{
      RowBox[{"ellipse\[Psi]", "[", 
       RowBox[{"5", ",", 
        RowBox[{"q", "/.", "%"}]}], "]"}], "[", 
      RowBox[{"r", ",", "f"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16325066],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->399944633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12295],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->953271091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuC", "[", 
  RowBox[{"3", ",", "1", ",", 
   RowBox[{"10.", "^", "15"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672864365],

Cell[BoxData[
 RowBox[{"-", "0.394902988184427`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->779623800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuC", "[", 
    RowBox[{"3", ",", "1", ",", 
     RowBox[{"10", "^", "15"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358064807],

Cell[BoxData[
 RowBox[{"-", "0.78255601989076339545677197509273437408`20."}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18488869]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18490],

Cell["Phase space plots of the Mathieu function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->943110199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MathieuC", "[", 
      RowBox[{"8", ",", "5", ",", "t"}], "]"}], ",", 
     RowBox[{"MathieuCPrime", "[", 
      RowBox[{"8", ",", "5", ",", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"AspectRatio", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122182031],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132901644]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2003],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuS",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuS"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicA",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicA"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29130]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10389],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->6932]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->25619],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/MathieuC/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MathieuC"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->136884502],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->208014662],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->472830724],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->23064628],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->192629530]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuC - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 52.5412386}", "context" -> "System`", 
    "keywords" -> {
     "band structure calculations", "Blanch's Newton method", "CE", 
      "electron wave functions", "elliptical geometries", "Hill's equation", 
      "Mathieu function C", "parametric amplifiers", "Paul traps", 
      "Penning traps", "periodic potentials", "Schrodinger equation", 
      "solid-state physics"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathieuC[a, q, z] gives the even Mathieu function with characteristic \
value a and parameter q. ", "synonyms" -> {"Mathieu C"}, "title" -> 
    "MathieuC", "type" -> "Symbol", "uri" -> "ref/MathieuC"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5870, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->288207148]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 81191, 1855}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2646, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3269, 89, 46, 1, 70, "ObjectName",
 CellID->13698],
Cell[3318, 92, 774, 25, 70, "Usage",
 CellID->11267]
}, Open  ]],
Cell[CellGroupData[{
Cell[4129, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4607, 139, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4730, 145, 427, 16, 70, "Notes",
 CellID->65],
Cell[5160, 163, 248, 8, 70, "Notes",
 CellID->326595552],
Cell[5411, 173, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5632, 182, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5870, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->288207148],
Cell[CellGroupData[{
Cell[6255, 208, 148, 5, 70, "ExampleSection",
 CellID->866357652],
Cell[6406, 215, 201, 5, 70, "ExampleText",
 CellID->164095502],
Cell[CellGroupData[{
Cell[6632, 224, 138, 4, 28, "Input",
 CellID->30685000],
Cell[6773, 230, 193, 6, 36, "Output",
 CellID->785782887]
}, Open  ]],
Cell[6981, 239, 125, 3, 70, "ExampleDelimiter",
 CellID->741042028],
Cell[CellGroupData[{
Cell[7131, 246, 274, 9, 28, "Input",
 CellID->522055755],
Cell[7408, 257, 2891, 51, 112, "Output",
 Evaluatable->False,
 CellID->402524631]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10348, 314, 216, 7, 70, "ExampleSection",
 CellID->18630],
Cell[10567, 323, 226, 5, 70, "ExampleText",
 CellID->347043095],
Cell[CellGroupData[{
Cell[10818, 332, 181, 6, 70, "Input",
 CellID->47512834],
Cell[11002, 340, 273, 7, 36, "Output",
 CellID->269436193]
}, Open  ]],
Cell[11290, 350, 125, 3, 70, "ExampleDelimiter",
 CellID->139258261],
Cell[11418, 355, 207, 5, 70, "ExampleText",
 CellID->109862149],
Cell[CellGroupData[{
Cell[11650, 364, 217, 7, 70, "Input",
 CellID->706408],
Cell[11870, 373, 253, 8, 36, "Output",
 CellID->180044896]
}, Open  ]],
Cell[12138, 384, 124, 3, 70, "ExampleDelimiter",
 CellID->96263149],
Cell[12265, 389, 112, 3, 70, "ExampleText",
 CellID->65024484],
Cell[CellGroupData[{
Cell[12402, 396, 173, 5, 70, "Input",
 CellID->179399986],
Cell[12578, 403, 245, 8, 36, "Output",
 CellID->6025705]
}, Open  ]],
Cell[12838, 414, 124, 3, 70, "ExampleDelimiter",
 CellID->88790991],
Cell[12965, 419, 228, 5, 70, "ExampleText",
 CellID->322566979],
Cell[CellGroupData[{
Cell[13218, 428, 137, 4, 70, "Input",
 CellID->120703106],
Cell[13358, 434, 223, 8, 43, "Output",
 CellID->356888347]
}, Open  ]],
Cell[13596, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->627196239],
Cell[13724, 450, 347, 11, 70, "ExampleText",
 CellID->190360466],
Cell[CellGroupData[{
Cell[14096, 465, 199, 6, 70, "Input",
 CellID->634825195],
Cell[14298, 473, 429, 13, 36, "Output",
 CellID->28580151]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14776, 492, 222, 7, 70, "ExampleSection",
 CellID->6407],
Cell[15001, 501, 118, 3, 70, "ExampleText",
 CellID->371320199],
Cell[CellGroupData[{
Cell[15144, 508, 456, 15, 70, "Input",
 CellID->169079706],
Cell[15603, 525, 703, 22, 49, "Output",
 CellID->207552333]
}, Open  ]],
Cell[16321, 550, 566, 15, 70, "ExampleText",
 CellID->478229195],
Cell[CellGroupData[{
Cell[16912, 569, 756, 22, 70, "Input",
 CellID->166580877],
Cell[17671, 593, 6768, 115, 70, "Output",
 Evaluatable->False,
 CellID->415818447]
}, Open  ]],
Cell[24454, 711, 125, 3, 70, "ExampleDelimiter",
 CellID->322927007],
Cell[24582, 716, 258, 7, 70, "ExampleText",
 CellID->19883067],
Cell[24843, 725, 618, 19, 70, "Input",
 CellID->36876722],
Cell[25464, 746, 198, 5, 70, "ExampleText",
 CellID->468674505],
Cell[CellGroupData[{
Cell[25687, 755, 407, 12, 70, "Input",
 CellID->5359889],
Cell[26097, 769, 257, 8, 36, "Output",
 CellID->135129354]
}, Open  ]],
Cell[26369, 780, 253, 7, 70, "ExampleText",
 CellID->155111556],
Cell[CellGroupData[{
Cell[26647, 791, 761, 24, 70, "Input",
 CellID->16325066],
Cell[27411, 817, 18935, 314, 70, "Output",
 Evaluatable->False,
 CellID->399944633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46395, 1137, 233, 7, 70, "ExampleSection",
 CellID->12295],
Cell[46631, 1146, 253, 7, 70, "ExampleText",
 CellID->953271091],
Cell[CellGroupData[{
Cell[46909, 1157, 164, 5, 70, "Input",
 CellID->672864365],
Cell[47076, 1164, 192, 6, 36, "Output",
 CellID->779623800]
}, Open  ]],
Cell[CellGroupData[{
Cell[47305, 1175, 220, 7, 70, "Input",
 CellID->358064807],
Cell[47528, 1184, 218, 6, 36, "Output",
 CellID->18488869]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47795, 1196, 224, 7, 70, "ExampleSection",
 CellID->18490],
Cell[48022, 1205, 222, 5, 70, "ExampleText",
 CellID->943110199],
Cell[CellGroupData[{
Cell[48269, 1214, 443, 13, 70, "Input",
 CellID->122182031],
Cell[48715, 1229, 27272, 451, 70, "Output",
 Evaluatable->False,
 CellID->132901644]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[76048, 1687, 310, 9, 70, "SeeAlsoSection",
 CellID->2003],
Cell[76361, 1698, 734, 26, 70, "SeeAlso",
 CellID->29130]
}, Open  ]],
Cell[CellGroupData[{
Cell[77132, 1729, 314, 9, 70, "TutorialsSection",
 CellID->10389],
Cell[77449, 1740, 165, 3, 70, "Tutorials",
 CellID->6932]
}, Open  ]],
Cell[CellGroupData[{
Cell[77651, 1748, 321, 9, 70, "RelatedLinksSection",
 CellID->25619],
Cell[77975, 1759, 186, 4, 70, "RelatedLinks"],
Cell[78164, 1765, 197, 4, 70, "RelatedLinks"],
Cell[78364, 1771, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78787, 1789, 319, 9, 70, "MoreAboutSection",
 CellID->136884502],
Cell[79109, 1800, 195, 4, 70, "MoreAbout",
 CellID->208014662],
Cell[79307, 1806, 178, 3, 70, "MoreAbout",
 CellID->472830724],
Cell[79488, 1811, 166, 3, 70, "MoreAbout",
 CellID->23064628],
Cell[79657, 1816, 145, 3, 70, "MoreAbout",
 CellID->192629530]
}, Open  ]],
Cell[79817, 1822, 27, 0, 70, "History"],
Cell[79847, 1824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

