(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56967,       1516]
NotebookOptionsPosition[     50413,       1290]
NotebookOutlinePosition[     51852,       1330]
CellTagsIndexPosition[     51766,       1325]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuCharacteristicB" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicB"], 
          "SpheroidalEigenvalue" :> 
          Documentation`HelpLookup["paclet:ref/SpheroidalEigenvalue"], 
          "MathieuC" :> Documentation`HelpLookup["paclet:ref/MathieuC"], 
          "MathieuCharacteristicExponent" :> 
          Documentation`HelpLookup[
           "paclet:ref/MathieuCharacteristicExponent"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathieuCharacteristicB\"\>", 
       2->"\<\"SpheroidalEigenvalue\"\>", 3->"\<\"MathieuC\"\>", 
       4->"\<\"MathieuCharacteristicExponent\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathieuAndRelatedFunctions"],
           "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Mathieu and Related Functions\"\>",
        2->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuCharacteristicA", "ObjectName",
 CellID->10542],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuCharacteristicA",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuCharacteristicA"], "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the characteristic value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["r", "TI"]]], "InlineFormula"],
     " for even Mathieu functions with characteristic exponent ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13063]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The characteristic value ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["r", "TI"]]], "InlineFormula"],
 " gives the value of the parameter ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", "q", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"2", "z"}], ")"}]}]}], ")"}], "y"}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 " for which the solution has the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{"i", "r", "z"}]], 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " is an even function of ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " with period ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->30502],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->113608451],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189017359],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->190924448],

Cell["Evaluate numerically:", "ExampleText",
 CellID->18110920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicA", "[", 
  RowBox[{"1", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->823140269],

Cell[BoxData["1.4667668425160558`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282193564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256945766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicA", "[", 
    RowBox[{"3", ",", " ", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451537999],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->886518097]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25967],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->6973551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicA", "[", 
  RowBox[{
   RowBox[{"1", "+", "I"}], ",", 
   RowBox[{"2.7", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146853109],

Cell[BoxData[
 RowBox[{"7.684462086130704`", "\[InvisibleSpace]", "+", 
  RowBox[{"6.245037845473937`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467407104]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166855353],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->59296603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicA", "[", 
    RowBox[{"5", ",", 
     RowBox[{"2", "/", "3"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360966149],

Cell[BoxData["25.\
0092629615330511295369787381222814470581007473859923024768595171606`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143971462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242519978],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->31214616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicA", "[", 
  RowBox[{"5", ",", "0.6666666666666666666666666667"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206397105],

Cell[BoxData["25.00926296153305112953697873812228144706`27.82134826690919"], \
"Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532749395]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232425046],

Cell["Simple exact values are generated automatically: ", "ExampleText",
 CellID->5434195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicA", "[", 
  RowBox[{"r", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->557088022],

Cell[BoxData[
 SuperscriptBox["r", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->723937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271346320],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->211024904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicA", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
   "0.33"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210819352],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.3158195407174649`", ",", "4.044736208026365`", ",", "9.00737398967495`", 
   ",", "16.003635940617805`", ",", "25.002268945095626`"}], "}"}]], "Output",\

 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312477069]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11531],

Cell["\<\
Symmetric periodic solutions of the Mathieu differential equation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->205285174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"MathieuC", "[", 
       RowBox[{
        RowBox[{"MathieuCharacteristicA", "[", 
         RowBox[{"r", ",", " ", "2"}], "]"}], ",", "2", ",", "x"}], "]"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"r", ",", " ", "3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365179592],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->568094196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120460177],

Cell["This shows the stability diagram for the Mathieu equation:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->208429359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Flatten", "@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"MathieuCharacteristicA", "[", 
          RowBox[{"r", ",", " ", "q"}], "]"}], ",", "\n", 
         RowBox[{"MathieuCharacteristicB", "[", 
          RowBox[{
           RowBox[{"r", "+", "1"}], ",", " ", "q"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "4"}], "}"}]}], "]"}]}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"Filling", " ", "->", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", "->", 
       RowBox[{"i", "+", "1"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "1", ",", "10", ",", "2"}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98494228],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197074704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5037091],

Cell[TextData[{
 "As a function of the first argument, ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 " is a piecewise continuous function (called bands and band gaps in solid \
state physics):"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->115117666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicA", "[", 
    RowBox[{"r", ",", " ", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347807411],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209941799]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicA",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicA"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["SpheroidalEigenvalue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpheroidalEigenvalue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->752056060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpheroidalEigenvalue", "[", 
  RowBox[{"n", ",", 
   RowBox[{"1", "/", "2"}], ",", "c"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718444903],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "4"]}], "-", 
  FractionBox[
   SuperscriptBox["c", "2"], "2"], "+", 
  RowBox[{"MathieuCharacteristicA", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], "+", "n"}], ",", 
    FractionBox[
     SuperscriptBox["c", "2"], "4"]}], "]"}]}]], "Output",
 ImageSize->{292, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50010375]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10556],

Cell["\<\
Branch points of the Mathieu characteristic along the imaginary \
q\[Hyphen]axis.:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->15501612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"MathieuCharacteristicA", "[", 
        RowBox[{"i", ",", 
         RowBox[{"I", " ", "q"}]}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "9"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "30"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2468313],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228445808]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31203],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicB"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SpheroidalEigenvalue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpheroidalEigenvalue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicExponent",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicExponent"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29617],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->9099]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->25023],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/MathieuCharacteristicA/\
"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->439999770],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->355705086],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->662317720]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuCharacteristicA - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 49.3536570}", "context" -> "System`", 
    "keywords" -> {
     "ar", "Floquet solution", "Mathieu characteristic", "Mathieu functions", 
      "mathueua"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MathieuCharacteristicA[r, q] gives the characteristic value a_r for even \
Mathieu functions with characteristic exponent r and parameter q. ", 
    "synonyms" -> {"mathieu characteristic a"}, "title" -> 
    "MathieuCharacteristicA", "type" -> "Symbol", "uri" -> 
    "ref/MathieuCharacteristicA"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6549, 217, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->189017359]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51623, 1318}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2406, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3029, 83, 60, 1, 70, "ObjectName",
 CellID->10542],
Cell[3092, 86, 902, 28, 70, "Usage",
 CellID->13063]
}, Open  ]],
Cell[CellGroupData[{
Cell[4031, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4509, 136, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4632, 142, 1120, 42, 70, "Notes",
 CellID->30502],
Cell[5755, 186, 276, 8, 70, "Notes",
 CellID->113608451],
Cell[6034, 196, 246, 7, 70, "Notes",
 CellID->31226],
Cell[6283, 205, 229, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6549, 217, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->189017359],
Cell[CellGroupData[{
Cell[6934, 231, 148, 5, 70, "ExampleSection",
 CellID->190924448],
Cell[7085, 238, 63, 1, 70, "ExampleText",
 CellID->18110920],
Cell[CellGroupData[{
Cell[7173, 243, 143, 4, 28, "Input",
 CellID->823140269],
Cell[7319, 249, 176, 5, 36, "Output",
 CellID->282193564]
}, Open  ]],
Cell[7510, 257, 125, 3, 70, "ExampleDelimiter",
 CellID->256945766],
Cell[CellGroupData[{
Cell[7660, 264, 283, 9, 28, "Input",
 CellID->451537999],
Cell[7946, 275, 2348, 43, 144, "Output",
 Evaluatable->False,
 CellID->886518097]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10343, 324, 216, 7, 70, "ExampleSection",
 CellID->25967],
Cell[10562, 333, 72, 1, 70, "ExampleText",
 CellID->6973551],
Cell[CellGroupData[{
Cell[10659, 338, 186, 6, 70, "Input",
 CellID->146853109],
Cell[10848, 346, 271, 7, 36, "Output",
 CellID->467407104]
}, Open  ]],
Cell[11134, 356, 125, 3, 70, "ExampleDelimiter",
 CellID->166855353],
Cell[11262, 361, 69, 1, 70, "ExampleText",
 CellID->59296603],
Cell[CellGroupData[{
Cell[11356, 366, 222, 7, 70, "Input",
 CellID->360966149],
Cell[11581, 375, 236, 7, 36, "Output",
 CellID->143971462]
}, Open  ]],
Cell[11832, 385, 125, 3, 70, "ExampleDelimiter",
 CellID->242519978],
Cell[11960, 390, 112, 3, 70, "ExampleText",
 CellID->31214616],
Cell[CellGroupData[{
Cell[12097, 397, 170, 4, 70, "Input",
 CellID->206397105],
Cell[12270, 403, 219, 6, 36, "Output",
 CellID->532749395]
}, Open  ]],
Cell[12504, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->232425046],
Cell[12632, 417, 90, 1, 70, "ExampleText",
 CellID->5434195],
Cell[CellGroupData[{
Cell[12747, 422, 141, 4, 70, "Input",
 CellID->557088022],
Cell[12891, 428, 178, 6, 36, "Output",
 CellID->723937]
}, Open  ]],
Cell[13084, 437, 125, 3, 70, "ExampleDelimiter",
 CellID->271346320],
Cell[13212, 442, 238, 7, 70, "ExampleText",
 CellID->211024904],
Cell[CellGroupData[{
Cell[13475, 453, 227, 7, 70, "Input",
 CellID->210819352],
Cell[13705, 462, 330, 10, 36, "Output",
 CellID->312477069]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14084, 478, 223, 7, 70, "ExampleSection",
 CellID->11531],
Cell[14310, 487, 254, 7, 70, "ExampleText",
 CellID->205285174],
Cell[CellGroupData[{
Cell[14589, 498, 533, 17, 70, "Input",
 CellID->365179592],
Cell[15125, 517, 12303, 206, 70, "Output",
 Evaluatable->False,
 CellID->568094196]
}, Open  ]],
Cell[27443, 726, 125, 3, 70, "ExampleDelimiter",
 CellID->120460177],
Cell[27571, 731, 240, 6, 70, "ExampleText",
 CellID->208429359],
Cell[CellGroupData[{
Cell[27836, 741, 912, 28, 70, "Input",
 CellID->98494228],
Cell[28751, 771, 6593, 112, 70, "Output",
 Evaluatable->False,
 CellID->197074704]
}, Open  ]],
Cell[35359, 886, 123, 3, 70, "ExampleDelimiter",
 CellID->5037091],
Cell[35485, 891, 474, 13, 70, "ExampleText",
 CellID->115117666],
Cell[CellGroupData[{
Cell[35984, 908, 287, 9, 70, "Input",
 CellID->347807411],
Cell[36274, 919, 2575, 46, 70, "Output",
 Evaluatable->False,
 CellID->209941799]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38898, 971, 233, 7, 70, "ExampleSection",
 CellID->29962],
Cell[39134, 980, 376, 12, 70, "ExampleText",
 CellID->752056060],
Cell[CellGroupData[{
Cell[39535, 996, 173, 5, 70, "Input",
 CellID->718444903],
Cell[39711, 1003, 448, 16, 54, "Output",
 CellID->50010375]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40208, 1025, 224, 7, 70, "ExampleSection",
 CellID->10556],
Cell[40435, 1034, 269, 8, 70, "ExampleText",
 CellID->15501612],
Cell[CellGroupData[{
Cell[40729, 1046, 488, 15, 70, "Input",
 CellID->2468313],
Cell[41220, 1063, 5759, 98, 70, "Output",
 Evaluatable->False,
 CellID->228445808]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[47040, 1168, 311, 9, 70, "SeeAlsoSection",
 CellID->31203],
Cell[47354, 1179, 1035, 35, 70, "SeeAlso",
 CellID->30048]
}, Open  ]],
Cell[CellGroupData[{
Cell[48426, 1219, 314, 9, 70, "TutorialsSection",
 CellID->29617],
Cell[48743, 1230, 165, 3, 70, "Tutorials",
 CellID->9099]
}, Open  ]],
Cell[CellGroupData[{
Cell[48945, 1238, 321, 9, 70, "RelatedLinksSection",
 CellID->25023],
Cell[49269, 1249, 186, 4, 70, "RelatedLinks"],
Cell[49458, 1255, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49704, 1264, 319, 9, 70, "MoreAboutSection",
 CellID->439999770],
Cell[50026, 1275, 167, 3, 70, "MoreAbout",
 CellID->355705086],
Cell[50196, 1280, 145, 3, 70, "MoreAbout",
 CellID->662317720]
}, Open  ]],
Cell[50356, 1286, 27, 0, 70, "History"],
Cell[50386, 1288, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

