(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62465,       1591]
NotebookOptionsPosition[     55839,       1362]
NotebookOutlinePosition[     57297,       1402]
CellTagsIndexPosition[     57211,       1397]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuCharacteristicA" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicA"], 
          "MathieuCharacteristicB" :> 
          Documentation`HelpLookup["paclet:ref/MathieuCharacteristicB"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MathieuCharacteristicA\"\>", 
       2->"\<\"MathieuCharacteristicB\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Functions Used in Quantum Mechanics\"\>", 
       2->"\<\"Mathieu and Related Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuCharacteristicExponent", "ObjectName",
 CellID->19552],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuCharacteristicExponent",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuCharacteristicExponent"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the characteristic exponent ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " for Mathieu functions with characteristic value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "All Mathieu functions have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["e", 
     RowBox[{"i", "r", "z"}]], 
    RowBox[{"f", "(", "z", ")"}]}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
 " has period ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is the Mathieu characteristic exponent. "
}], "Notes",
 CellID->29731],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->402046127],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191962995],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->143437932],

Cell["Evaluate numerically:", "ExampleText",
 CellID->215811998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicExponent", "[", 
  RowBox[{"2", ",", "0.5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258126159],

Cell[BoxData["1.3695085696605283`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185345449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227123800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicExponent", "[", 
    RowBox[{"3", ",", "q"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->591578573],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33869557]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13043],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->28895374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicExponent", "[", 
  RowBox[{
   RowBox[{"1", "-", "I"}], ",", 
   RowBox[{"1.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236303685],

Cell[BoxData[
 RowBox[{"1.4310591606878107`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.7086362083424469`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233971090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->534576297],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->296705785],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuCharacteristicExponent", "[", 
    RowBox[{"5", ",", 
     RowBox[{"1", "/", "2"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365808881],

Cell[BoxData["2.\
228788924247257167583903079627611688854708650737662059427737113034`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->371371236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15649972],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->181228213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicExponent", "[", 
  RowBox[{"5", ",", "0.50000000000000000000000000"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673663673],

Cell[BoxData["2.22878892424725716758390307962761168885`26.433046241926142"], \
"Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329732073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45929241],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->7882547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicExponent", "[", 
  RowBox[{"a", ",", " ", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156769570],

Cell[BoxData[
 SqrtBox["a"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->324107829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->119874100],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->580513672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicExponent", "[", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.0", ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5512648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.228788924247257`", ",", "2.2030007517289945`", ",", 
   "2.1400351318567807`"}], "}"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338019190]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1563],

Cell["\<\
Solve the Schr\[ODoubleDot]dinger equation with periodic potential:\
\>", "ExampleText",
 CellID->371320199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"\[ScriptCapitalE]", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169079706],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"MathieuC", "[", 
       RowBox[{
        RowBox[{"4", " ", "\[ScriptCapitalE]"}], ",", "2", ",", 
        FractionBox["x", "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"MathieuS", "[", 
       RowBox[{
        RowBox[{"4", " ", "\[ScriptCapitalE]"}], ",", "2", ",", 
        FractionBox["x", "2"]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{406, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29665165]
}, Open  ]],

Cell[TextData[{
 "By the Bloch theorem, solutions are bounded provided \[ScriptCapitalE] is \
within an energy band. The energy gap corresponds to a range of \
\[ScriptCapitalE] where ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " has non-vanishing imaginary part:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->478229195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"Re", "[", 
       RowBox[{"MathieuS", "[", 
        RowBox[{"a", ",", "2", ",", "100"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"MathieuCharacteristicExponent", "[", 
       RowBox[{"a", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "16"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Dashing", "[", "Tiny", "]"}], "}"}], ",", 
      RowBox[{"{", "Thick", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166580877],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->645872030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173845218],

Cell["This shows the stability diagram for the Mathieu equation:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->5649855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Im", "[", 
     RowBox[{"MathieuCharacteristicExponent", "[", 
      RowBox[{"a", ",", "q"}], "]"}], "]"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "5"}], ",", "20"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "60"}], ",", 
   RowBox[{"MaxRecursion", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62129292],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{182, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->654954478]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25834],

Cell["\<\
The characteristic exponent and the characteristic are inverses of each \
other:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->85385987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MathieuCharacteristicExponent", "[", 
     RowBox[{"a", ",", "1"}], "]"}], "\[Equal]", 
    RowBox[{"3", "/", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", " ", "0.8", ",", "1.6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->944818499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", "\[Rule]", 
   RowBox[{"2.5371800871199013`", "\[InvisibleSpace]", "+", 
    RowBox[{"5.5341858275743616`*^-17", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{204, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417226456]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuCharacteristicA", "[", 
  RowBox[{"1.5", ",", " ", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->201676340],

Cell[BoxData["2.5371800871199017`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506484605]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7240],

Cell["This shows the band gaps in a periodic potential:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->213585679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"MathieuCharacteristicExponent", "[", 
     RowBox[{"a", ",", "q"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "10"}], ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "0", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->211529204],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341310594]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10498],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicA",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicA"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuCharacteristicB",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuCharacteristicB"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6747],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->7511]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->5869],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuCharacteristicExponent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/\
MathieuCharacteristicExponent/"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->133798056],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->41260286],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->364502509]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuCharacteristicExponent - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 51.4162098}", "context" -> "System`", 
    "keywords" -> {
     "Floquet solution", "Mathieu characteristic exponent", 
      "Mathieu functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathieuCharacteristicExponent[a, q] gives the characteristic exponent r \
for Mathieu functions with characteristic value a and parameter q. ", 
    "synonyms" -> {"mathieu characteristic exponent"}, "title" -> 
    "MathieuCharacteristicExponent", "type" -> "Symbol", "uri" -> 
    "ref/MathieuCharacteristicExponent"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5810, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->191962995]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 57068, 1390}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2200, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2823, 80, 67, 1, 70, "ObjectName",
 CellID->19552],
Cell[2893, 83, 860, 26, 70, "Usage",
 CellID->28773]
}, Open  ]],
Cell[CellGroupData[{
Cell[3790, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4268, 131, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4391, 137, 571, 21, 70, "Notes",
 CellID->29731],
Cell[4965, 160, 293, 9, 70, "Notes",
 CellID->402046127],
Cell[5261, 171, 263, 8, 70, "Notes",
 CellID->31226],
Cell[5527, 181, 246, 8, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5810, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191962995],
Cell[CellGroupData[{
Cell[6195, 208, 148, 5, 70, "ExampleSection",
 CellID->143437932],
Cell[6346, 215, 64, 1, 70, "ExampleText",
 CellID->215811998],
Cell[CellGroupData[{
Cell[6435, 220, 150, 4, 28, "Input",
 CellID->258126159],
Cell[6588, 226, 176, 5, 36, "Output",
 CellID->185345449]
}, Open  ]],
Cell[6779, 234, 125, 3, 70, "ExampleDelimiter",
 CellID->227123800],
Cell[CellGroupData[{
Cell[6929, 241, 285, 9, 28, "Input",
 CellID->591578573],
Cell[7217, 252, 2920, 52, 144, "Output",
 Evaluatable->False,
 CellID->33869557]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10186, 310, 216, 7, 70, "ExampleSection",
 CellID->13043],
Cell[10405, 319, 73, 1, 70, "ExampleText",
 CellID->28895374],
Cell[CellGroupData[{
Cell[10503, 324, 198, 6, 70, "Input",
 CellID->236303685],
Cell[10704, 332, 273, 7, 36, "Output",
 CellID->233971090]
}, Open  ]],
Cell[10992, 342, 125, 3, 70, "ExampleDelimiter",
 CellID->534576297],
Cell[11120, 347, 70, 1, 70, "ExampleText",
 CellID->296705785],
Cell[CellGroupData[{
Cell[11215, 352, 229, 7, 70, "Input",
 CellID->365808881],
Cell[11447, 361, 234, 7, 36, "Output",
 CellID->371371236]
}, Open  ]],
Cell[11696, 371, 124, 3, 70, "ExampleDelimiter",
 CellID->15649972],
Cell[11823, 376, 113, 3, 70, "ExampleText",
 CellID->181228213],
Cell[CellGroupData[{
Cell[11961, 383, 175, 4, 70, "Input",
 CellID->673663673],
Cell[12139, 389, 219, 6, 36, "Output",
 CellID->329732073]
}, Open  ]],
Cell[12373, 398, 124, 3, 70, "ExampleDelimiter",
 CellID->45929241],
Cell[12500, 403, 226, 5, 70, "ExampleText",
 CellID->7882547],
Cell[CellGroupData[{
Cell[12751, 412, 153, 4, 70, "Input",
 CellID->156769570],
Cell[12907, 418, 169, 6, 38, "Output",
 CellID->324107829]
}, Open  ]],
Cell[13091, 427, 125, 3, 70, "ExampleDelimiter",
 CellID->119874100],
Cell[13219, 432, 255, 8, 70, "ExampleText",
 CellID->580513672],
Cell[CellGroupData[{
Cell[13499, 444, 211, 6, 70, "Input",
 CellID->5512648],
Cell[13713, 452, 274, 9, 36, "Output",
 CellID->338019190]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14036, 467, 222, 7, 70, "ExampleSection",
 CellID->1563],
Cell[14261, 476, 118, 3, 70, "ExampleText",
 CellID->371320199],
Cell[CellGroupData[{
Cell[14404, 483, 456, 15, 70, "Input",
 CellID->169079706],
Cell[14863, 500, 702, 22, 49, "Output",
 CellID->29665165]
}, Open  ]],
Cell[15580, 525, 564, 15, 70, "ExampleText",
 CellID->478229195],
Cell[CellGroupData[{
Cell[16169, 544, 756, 22, 70, "Input",
 CellID->166580877],
Cell[16928, 568, 6666, 113, 70, "Output",
 Evaluatable->False,
 CellID->645872030]
}, Open  ]],
Cell[23609, 684, 125, 3, 70, "ExampleDelimiter",
 CellID->173845218],
Cell[23737, 689, 238, 6, 70, "ExampleText",
 CellID->5649855],
Cell[CellGroupData[{
Cell[24000, 699, 512, 15, 70, "Input",
 CellID->62129292],
Cell[24515, 716, 5056, 87, 70, "Output",
 Evaluatable->False,
 CellID->654954478]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29620, 809, 233, 7, 70, "ExampleSection",
 CellID->25834],
Cell[29856, 818, 267, 8, 70, "ExampleText",
 CellID->85385987],
Cell[CellGroupData[{
Cell[30148, 830, 335, 10, 70, "Input",
 CellID->944818499],
Cell[30486, 842, 336, 10, 39, "Output",
 CellID->417226456]
}, Open  ]],
Cell[CellGroupData[{
Cell[30859, 857, 148, 4, 70, "Input",
 CellID->201676340],
Cell[31010, 863, 176, 5, 36, "Output",
 CellID->506484605]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31235, 874, 223, 7, 70, "ExampleSection",
 CellID->7240],
Cell[31461, 883, 229, 5, 70, "ExampleText",
 CellID->213585679],
Cell[CellGroupData[{
Cell[31715, 892, 390, 12, 70, "Input",
 CellID->211529204],
Cell[32108, 906, 20774, 345, 70, "Output",
 Evaluatable->False,
 CellID->341310594]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[52943, 1258, 311, 9, 70, "SeeAlsoSection",
 CellID->10498],
Cell[53257, 1269, 507, 17, 70, "SeeAlso",
 CellID->11008]
}, Open  ]],
Cell[CellGroupData[{
Cell[53801, 1291, 313, 9, 70, "TutorialsSection",
 CellID->6747],
Cell[54117, 1302, 165, 3, 70, "Tutorials",
 CellID->7511]
}, Open  ]],
Cell[CellGroupData[{
Cell[54319, 1310, 320, 9, 70, "RelatedLinksSection",
 CellID->5869],
Cell[54642, 1321, 200, 4, 70, "RelatedLinks"],
Cell[54845, 1327, 216, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55098, 1336, 319, 9, 70, "MoreAboutSection",
 CellID->133798056],
Cell[55420, 1347, 177, 3, 70, "MoreAbout",
 CellID->41260286],
Cell[55600, 1352, 167, 3, 70, "MoreAbout",
 CellID->364502509]
}, Open  ]],
Cell[55782, 1358, 27, 0, 70, "History"],
Cell[55812, 1360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

