(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     84857,       2023]
NotebookOptionsPosition[     77636,       1777]
NotebookOutlinePosition[     79212,       1818]
CellTagsIndexPosition[     79126,       1813]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathieu and Related Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathieuAndRelatedFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Mathieu and Related Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathieuC" :> Documentation`HelpLookup["paclet:ref/MathieuC"], 
          "MathieuSPrime" :> 
          Documentation`HelpLookup["paclet:ref/MathieuSPrime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MathieuC\"\>", 
       2->"\<\"MathieuSPrime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions for Separable Coordinate Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsForSeparableCoordinateSystems"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Mathieu and Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathieuAndRelatedFunctions"],
           "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Functions for Separable Coordinate Systems\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Mathieu and Related Functions\"\>", 
       4->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MathieuS", "ObjectName",
 CellID->13758],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MathieuS",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MathieuS"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["q", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the odd Mathieu function with characteristic \
value ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " and parameter\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The Mathieu functions satisfy the equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]\[Prime]"], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", 
        RowBox[{"2", "q", " ", 
         RowBox[{"cos", "(", 
          RowBox[{"2", "z"}], ")"}]}]}], ")"}], "y"}]}], "=", "0"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->29065],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["MathieuS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuS"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->711271909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuS"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuS"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->426622051],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->47270948],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->164095502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuS", "[", 
  RowBox[{"2", ",", "1", ",", "3.2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30685000],

Cell[BoxData[
 RowBox[{"-", "0.7680982888758947`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50984376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741042028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"MathieuS", "[", 
    RowBox[{"3", ",", "2", ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522055755],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151768660]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30137],

Cell["Evaluate for complex arguments and parameters:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->347043095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuS", "[", 
  RowBox[{"I", ",", 
   RowBox[{"-", "2"}], ",", 
   RowBox[{"2.5", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47512834],

Cell[BoxData[
 RowBox[{"26.867498783923267`", "\[InvisibleSpace]", "+", 
  RowBox[{"19.70520127285938`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105294190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139258261],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109862149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuS", "[", 
    RowBox[{"2", ",", "1", ",", 
     RowBox[{"37", "/", "10"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706408],

Cell[BoxData[
 RowBox[{"-", 
  "0.9482567495940457416070808573150165900475295518003103037063654218392`50."}\
]], "Output",
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77210032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96263149],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->65024484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuS", "[", 
  RowBox[{"2", ",", "1", ",", "3.70000000000000000000000000000000"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179399986],

Cell[BoxData[
 RowBox[{"-", 
  "0.94825674959404574160708085731501659004752872768`31.01057489334055"}]], \
"Output",
 ImageSize->{243, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122258830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88790991],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322566979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuS", "[", 
  RowBox[{"3", ",", "0", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120703106],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   SqrtBox["3"], " ", "z"}], "]"}]], "Output",
 ImageSize->{73, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4924127]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627196239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MathieuS",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuS"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->190360466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuS", "[", 
  RowBox[{"a", ",", "q", ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->634825195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MathieuS", "[", 
    RowBox[{"a", ",", "q", ",", "z1"}], "]"}], ",", 
   RowBox[{"MathieuS", "[", 
    RowBox[{"a", ",", "q", ",", "z2"}], "]"}], ",", 
   RowBox[{"MathieuS", "[", 
    RowBox[{"a", ",", "q", ",", "z3"}], "]"}]}], "}"}]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376737930]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28211],

Cell["\<\
Solve the Schr\[ODoubleDot]dinger equation with periodic potential:\
\>", "ExampleText",
 CellID->371320199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"\[ScriptCapitalE]", " ", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169079706],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"MathieuC", "[", 
       RowBox[{
        RowBox[{"4", " ", "\[ScriptCapitalE]"}], ",", "2", ",", 
        FractionBox["x", "2"]}], "]"}]}], "+", 
     RowBox[{
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"MathieuS", "[", 
       RowBox[{
        RowBox[{"4", " ", "\[ScriptCapitalE]"}], ",", "2", ",", 
        FractionBox["x", "2"]}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{406, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295773946]
}, Open  ]],

Cell[TextData[{
 "By the Bloch theorem, solutions are bounded provided \[ScriptCapitalE] is \
within an energy band. The energy gap corresponds to a range of \
\[ScriptCapitalE] where ",
 Cell[BoxData[
  ButtonBox["MathieuCharacteristicExponent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathieuCharacteristicExponent"]], 
  "InlineFormula"],
 " has a non-vanishing imaginary part:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->478229195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ArcTan", "[", 
      RowBox[{"Re", "[", 
       RowBox[{"MathieuS", "[", 
        RowBox[{"a", ",", "2", ",", "100"}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"Im", "[", 
      RowBox[{"MathieuCharacteristicExponent", "[", 
       RowBox[{"a", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", "8"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "16"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Dashing", "[", "Tiny", "]"}], "}"}], ",", 
      RowBox[{"{", "Thick", "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166580877],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1XGusVcUV3p43Fy+osWr7y6Siffyw/xvTNKY1AhatMcaoTYEoYK0vsK1v
qlWUl4hQAS1UQN6VqyhUem0Ag6ICwq1WK6QWqoEmEhuJTUhNdr+Zb82a2evs
c7hoSu69Z8/es2fW41vfrHkcLhk7ZeJ1Px87ZdL4sWdfdNvYWyZOGj/57B/e
fBtuVU/KsuwF/E44K8N1jiv/+0Ke45N/z3R/q+6u/5ct8neb+OtuVpKnmSvj
t4Fr9/ltd69x9Oixfe9/zJd5zXf0fnadf7dl+mmYctWUv+UroYnH577KW7xm
63pfWufr/FcJxRPo7TxfPnbs819P7XeXtwxaZldcVFq7Jnayb3WunZbrHf3i
2gyfdfn8hrHKLaW+Pc94przWIr3rWn6yS0tv7f7o5ps2fLmWFnVpf9PG96Y9
tCW2X4ZKd5mi8slS63p/12I562Df4+FosO0Mrn9XoVzTLyr/F30v4KlhPofm
EhdSe1apt4a4Pw2gYeGC1wEtAOy5vncOHfqUyMeF1BtudD3Xlw8c+OT1HQfd
5cm+PGvmK0eOfBZRgObk/WGlvTvZszMA/CuvWLFhw7tr1wygB7TwzPK3Xtn2
AYuogj7ZEkKcF3jlnbcP555ZXu7fT8vgmupm3/S2A8ChGOqhLeIO7Yq8LE+a
2MdmBC1oQeSvhuepN9xztJVrzKMAc8UyhIMJcuUAiCb9sQwjUyNhFrwPCfW5
xlsr9EZtyRVwhr9QNSF6VjE1XS1/bwg65j2YETehF0TDHRS99yrouRa8KFr1
BsyIVWoBBcI6NZGjHuoVtEMlea9hvF+X/hqlKPB3a3g84fr1AwOHIGndyEF0
4QEMiFYlNsiGqAW3Bo38I8AEdcU2pLno8+9dsFDKrdCLMC+1RZeiVc34nFIt
WbxT3tf6hedoj2Ejz2F1KXfRfjjkHTd27cPTtky+9UWoAw3QKEXFIw5tgJqg
qwIUeU3hOmCMmtUIJQiPBrwsNchGJ+HOeQlicVP4AdqgcRhApCc8A+IrUL4e
MNDVCngOQeJz9lmwksRmtEIYDbOmG73v67/80uU7XjsAWdC4A7vrJOuFVnh8
+5SNNAVCkuYcP24dhcULuGY/LQh8150v0RIglZf7990wqQ9WGpFHRoAiIddp
oLLCFNXwSj1gVzDv6jl78z6hFfWy5cgwdYM+tRP6iOgjnerzcoY0TJA1Wdb4
4AVRUKfuuecJFytkA+qMMjRBDXWPM/G5BufkOlKna8GxQoz66MlaqFfQEFYU
i2h9ea5jSFeN29mgYfoZGiwJKoPUwgaoiK6pkteorhoBIa4e45+F4FnvIeFg
Pxa6eGU7YgcNv8jx6DfqB30kvssjI7JYNdhHotj7VsfvNF+x+bqv2TIcAeig
b3CE16OHSNO8Tj2MtxDxZAj6Dm8FPNcIipQh8AhWc36nnRFwbDSyvGCxavRT
fSXydQwUe1v72Aixsw/ah3hI86CmQUzpjOGsUk5hAkMIqGNxjQveAc/Qu7gD
yXDHt96ChcjJhNPTS3ZOva8/8EoTIc3GiQS2LHLFnMnr21AcKzBrpTiLOCln
nsiwfI6CjGMtg3PGmc2PJeWIZj2uXUu5qMdwkbqPd8g+yhkEJkwAVQAM2DOO
ZbC7Q92I0IuwEZHL1sgtvYPCYcRROW8pX2SnBD+l4/YgcVcNs0THWAgVMJZm
z5axOFiHJMXnc1bvyFkcSLLyvJWhnytnxefUTUc1KYMAEuxoJtbGXUke6ctM
wtX3JTYJs1g7U/Zlx1gTJ6yf/vCWa69ZvWb1AMRetXIPgoWMRUQrY+kUmAxL
v1Mi6tc0uOe4hapwrcv3vJVrP7jwKaZ0GllxRLK5SK3E852tUxw5nP9aXazS
bUWA1iFDgcAh3T13b4ZWzKIqjjwauKkWgc7IfF02ljVgRPoEVqNE7QyFOjB6
O0MRampr4hDM6OVpqPfzkEJbpikvR+byaIDZGgGFEsOtPMmhOq6ElM16wpjF
aHYm9EKzSJQOSxmV2buyiwYGNbcoPV0iWHNciSpij53gLn56REbfO0Vq45Hy
siRnQU+0dWroTdj4OHmQYZWIXsvPGsPMcfm8rugXnrE2sP0yi1RbJDzkPMg+
ARngUWUoYL+YL5tRqMo8tCA9u4oz4gJrx9ilTyLTta8lndTZjpaJMLLOnL4V
lvVtNIl2zc0dmYT2m5qvEJiSS1oucto4M5xleqfWkaN6fJu4umzMMmoh6gbL
aZ4d48BaTtcbBa31UsuZMaMWLdnNcpptDmtnJ7RAsqa5lJ18XLQYeahGg6Ea
JSA7QVTc1+UcUMNv57+GBtO1U9fMV8vQaNkLXQF+gqA4Fnq963hX7JZlIWuN
eMRIKPNU33MtrrtmHWZw7DvPQ17lxu9ucVuaJfWmLKYI4wXZAk9DZuBzKrgT
3eIWRDcsFvgy+Kucvdgy/7osQblTZjvFtRwzRtZi9pRldhQ9JcS81qh2jrwS
BrOZ24kyWKp/e6wldsBnxcQpyzEnt2v3do/CYiJkCCnvOZlCBmRXi+JoQK+g
WykPKgoLvLVs6S7yFmCdzmV9Ium828NhWC2V+zUNNMF6lrNsVnJGnuZynFy7
tnsC7mXHwNtV5Y9ISREVVherHS1jfFJL5wiV7qNizJwQznf8ahNEJTdVXMC7
pWZtHKKijnITah48+G+YyXAT7jOpSrmpNHNiO4LcuHZQsdgL2b3MBS0nE1dg
scKcJebbds7Hcly7HF5qnVLukRWhBIlOtkZeJB/IQe7RiSyagTCGe0ZYPfPI
NUTCyQEVBc1sDl4c3Sol2c2Z7dFQ4JLTQ300HaaQWd2IK7MqlRfcDzi0RXnF
IHxIiN3CjNzmvRbReFiYV0Qrla0ppisfzS5Yxys/vnQZGGDD83/dtvXvygAW
EWRb2pmY1V2DtjkThmK6TFb8i3lM+1za5rRWc42ODppbSw9O8833Pj1n5P0P
XHDXs5PmPjry/pkXTV0xdvb8Sx+soJDV1lw3Z9lPZj115SMbbppfefqaGVkv
LvCJH1zg6YLLp+HpMz+dvWr8o8/dOA83WcwquMxqqDfjqsfvv3czhD/Hi/7e
xtcfufC+P0yciy4r0mrV1a2iw5XjZrvLuv8DgdZe/5h2w7tVXKHsG/flx3/0
G1SM5cVXTUf32oprFZ/xOXpG/+6yx99UuT9+/0NvNz9f+b3PPUqz9qFaxr9l
Y+5FcX//7o9273vj+V3z7u7zCQBKWQ1lXOPydw++WHF3TmURPytmv7R/+7vu
XpZtXb0DF3/p37v+iT+7tra/i6e48+y8P/l8deEFtwI7C3gaIeswln7J8jAt
oyPXYZYd3OHke/mZ7Uunb1JB7xi71GvibACJJ4xZgNJ7W9+mYmnlrOY+q6px
5t9roDxj8jrewtud6lVpCC23+Fy7RJHWZm1UZQVavqmtvfrsGwfe+BuKx47+
h5q2+ZSx8+mhI1D7qQtvZy05taERhVCqljCBm9VzbwWBiDqr71mJJtDQS3cu
dj1aX50Ryoff/kffxDni21+MnCXP23IrL6DyBAcu1qqnKNR144ZySB4m0Byd
NH8XFDHbsKt3cd/ESl7MmmTlbXk/5F93wzwZFTiA791zCH9dlm3HJI6bMdP3
fbZQwFCzd9NuWm7JxXcCgp8c+BfnKLgYWLNl9dXTaKs6HoNAOGa4PrxF68p0
smage47Cr18v9byXb9jnx/6LIEbj83+5Fu1QPA5Sag5mdukqodvR0SyXSKEV
WvQe3qAhdPObK7DAGajGqeL1qa0bNxPqItYghl+xcOHwTt/2LQ+tXHHFA1VX
pwnxXp3b99mRuOjt/D3ceJDWjWuSTeNRO3/lmGT3CeJKQvlsg/t/JAnIjua5
NY+4wKvW476NBqek/EH/qEdLcQUS3R0+fJQJGdHLVj7YNrBxykJvJB8lMAcs
1z91aVbZufiPyLeW9zPG8YO6WdXdreI5agElWd2/iivEIiAD8zGy0QGMRAE5
Q6kk0iiGGFV5soIsq3lDA9Z1U9F5o2IQx6hTa8tKGuNEOaSQ5VpPmPmbxp63
Ti80Jl9Be2hx48+egzhoAm+x1XR3pKYxJ/rYPRPGM14cP26dW4fimiCwSieA
qk7z1sQFkAjLg78aQerLxixzMce8VndAaUuFI7PjMF9xvEmLmXW2yHV8RyS7
9urVNjOSTMfO/3TWw61sMkH5ON6AEuQcIAdS7nzzw0o4wyK5NqUp57E4Eujc
fsb0bU5m5rVIJ2A92Ip4FWS6lMNnRg0YEvfxg2iHE4HPkwOGuCkcdwckIskP
OltBrfOjdl9JxwP0DeBDMzhPkduJ3NI9kBYLmmkCIsz96V36lRwBFyqscAc1
OQuAcFy8Eszb0y60XsxNW6asswCpz/dj7mvneMXo8ICB3VV98CpjgAiEpClP
oY8Q3lkDfWCqiGY5nUUXhqdwwSglOnyW79bzVfjkBGZNY8DNmL3i9JziSCLU
e72Wbs7oyYDEInrqRmYUjBadGaMnXclps5Xh40I0OGgyC8GIA1tpdPTADnPn
bEer7aySy2jWSHmFvRyPWTizxfRKVmZpeWIcGEFfEB2ska5W0NfeZ400j6FH
6ol3CbmGiU96m5PSMqvoqTGZnSWc4bIsDHMwEGkirtuBLSB1F76I/K2n/GQk
boT+0YZD34hBxT2jjj0w7lt55zMNzBGRV3ARFSmES4x1L/mGievvuXtzSge5
H8PFs8w72WNEU8VDLJ5W5K4zzzZBf1QcdfGSlBAywwiySTPM4FtzT8EM+dPu
acTZcK+xj13pIsq5lpHumXCtL+VJ5AUoAvlI1v3TOjTY+eY/87CyHjNy7ndF
poCslIiq+npuF4OQpdEkVtt5gmFEv6EXLuPEtUtdHLLzeJ+1ywhAffXEZLoy
4Pa3uf5OkAtbaOzI7grvqh3lJJOex0nP53SyZpd5Je0JTJFF4G5nC88bTaUR
hjZprP2UZcCJrBcNjkt0P5nrlegn3ePmU3KJsqcaKt0LpQXsvMiOPjZX09M2
smLZOgHrxVMOll+Yg9ozTp0ZhiigCJFniEPc3Re+j0BrnOZfoU7U+vwOUoc9
gdKd9sgrJBIVx/BKi/BTP3H3JXilDrfR35w8xfNkMifWM4bMAPE2+SRmkpYP
yk9vxBNmetLF7inIumSnCLBWsHNmRsCqlXvIKFwPj4wi578UtRj1uCfDOOVI
o+zrzmr46uq87Jygd9gx8P0pW/ClrAJ/pru6XD+thNiRKO8p1gir9nZFua5W
S9mipuM9OtcdP1pTzz8b9OroFc4nhG+D+IhxvLFmlctpmH4Kb2jeTwh15Q28
hWlDjA48Bxwd75E3YO4Cb6ilkSVAfT3NTgu4+T5XWDSvyEMyRtbQbUA9WW3O
pLk91ELGYUdAkxN32OlDE5CNxoncENcBqiYa9JRUgUVRee+eQ+WsAF3xLlmB
cIBWqHp+F6lQb/JtLzD2K4mdmGKwFUY/R6901OG5KeIL1UgacAemcPFklo1+
JuIa/Tx7H21JJ+Ya/ZywxOcxq9GdFGGDRoiM9ERE8TsDhZh2wNT1e4y6Maah
IwiMe/g8Ls0sQZkPF5o0yp5Bsv/n66Ynp7n8FxGPMpJWF+Oa94vOPcEnUIP2
rgYtCzkTLe96130OPHe7/prnolFqUHp2rXxvzPl+wRM7OHmEqs73bsCukZCZ
4bg1gFbotRAH6A9pmMtbGKkwokQqbaK+ok3QnD/hGN5Fn9EnmnXF89bSl55n
pv3DSmkVqEv27j2yCidE7VoDKstaxJDuUTswcGjXrg/DKCh8wdZ0P0h6bgZ/
CmaJp/Rcw/79btOYJ7BJkXk40pdxzw5qy2pojNu4xwd3TJqwfsb0rbCsl+cU
nugjpSrP6hf+0AFtznOCuM94JcZyv+eHi8i9ssbLGQCecO4lo0ZvQKM90yyr
NkNDDBZWfVCQGVwjeEJsrPu6hf0wLtMeB6t1fiUr97TnQWpkY5as5dx/J0JY
RZfaJXohgeQMRCqMqIDjV4N0pcztOouNdO0QwR61hylEG9W+sPt3xH+Bq4DD
9HwgqmtWmO4mtFnha0FfKX8nQU/EYvx+gcaZlL/rW3WR3OmbhyFrbJr4ecy/
OcS80X7WzeZVOg8Q/b9oO6OD3UXTUSfQjqswOugjdj+R99v1+X/ZJeRZ4VsO
wRuXBL/LiDCqFB3UMa63ltcq16DAOG1ylfd0PHlGeitwxADiEbOjS/oqk6Sb
pb6f54Wx4ZIufes3QBBYo9XCFvthHSZYe1RRbkTk6FIv23OjNp4Gh5XBtXI8
/QfTqit6uzjGQCi5cx/lb4f83s6aLvYPeZyCC6yd328ru3jQjZOwq+A+/Zjn
1id1lybZ62loZl68n2Tsl6lny+Yo3b6pnf7fAdlJ/wMTrz8c\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75188149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322927007],

Cell["\<\
Solve the Laplace equation in an ellipse using separation of variables: \
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19883067],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ellipse\[Psi]", "[", 
    RowBox[{"n_", ",", "z0_"}], "]"}], "[", 
   RowBox[{"r_", ",", "f_"}], "]"}], ":=", 
  RowBox[{"With", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"ch", "=", 
      RowBox[{"MathieuCharacteristicB", "[", 
       RowBox[{"n", ",", "z0"}], "]"}]}], "}"}], ",", 
    RowBox[{"I", " ", 
     RowBox[{"MathieuS", "[", 
      RowBox[{"ch", ",", "z0", ",", 
       RowBox[{"\[ImaginaryI]", " ", "r"}]}], "]"}], 
     RowBox[{"MathieuS", "[", 
      RowBox[{"ch", ",", "z0", ",", "f"}], "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36876722],

Cell["This finds a zero:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->468674505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"MathieuS", "[", 
    RowBox[{
     RowBox[{"MathieuCharacteristicB", "[", 
      RowBox[{"5", ",", "q"}], "]"}], ",", "q", ",", 
     RowBox[{"I", "/", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "30"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "25"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5359889],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"q", "\[Rule]", "28.94550038860446698764038858835369474683`25."}], 
  "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->588881444]
}, Open  ]],

Cell["\<\
This plots an eigenfunction. It vanishes at the ellipse boundary:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->155111556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cosh", "[", "r", "]"}], " ", 
      RowBox[{"Cos", "[", "f", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sinh", "[", "r", "]"}], " ", 
      RowBox[{"Sin", "[", "f", "]"}]}], ",", 
     RowBox[{"2", 
      RowBox[{
       RowBox[{"ellipse\[Psi]", "[", 
        RowBox[{"5", ",", 
         RowBox[{"q", "/.", "%"}]}], "]"}], "[", 
       RowBox[{"r", ",", "f"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", 
     RowBox[{"1", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "->", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16325066],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->650281951]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24668],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->953271091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MathieuS", "[", 
  RowBox[{"3", ",", "3", ",", 
   RowBox[{"10.", "^", "12"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672864365],

Cell[BoxData[
 RowBox[{"-", "1.1126220597778071`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->656228369]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"MathieuS", "[", 
    RowBox[{"3", ",", "3", ",", 
     RowBox[{"10", "^", "12"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358064807],

Cell[BoxData[
 RowBox[{"-", "1.11324421869849203244008577090865856468`20."}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200508883]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7498],

Cell["Phase space plots of the Mathieu function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->92265039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MathieuS", "[", 
      RowBox[{"8", ",", "5", ",", "t"}], "]"}], ",", 
     RowBox[{"MathieuSPrime", "[", 
      RowBox[{"8", ",", "5", ",", "t"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "100"}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74369459],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVnVuobVl612f2uu7rudf1VFd1VXfu6dxvhs5KiCcSiyRsMOwEOQ/tRsh5
0C0x9eJ+sV7cL/aL9WJAPA/agpYPCUoKIYJ4QGwQD4gBsQSJIOWDheDBhwPC
8j++3/j+81tz70picXr12nPNOeYY3/02vvHL3/jt3/zLf+Ubv/3k/Bvv/Lnf
+sZf+80n53/9nV+8+C1dmn3HMAz/vP3vtUHft/oW//uN7XY7zNq3+G/49fYx
fPHVvaH/Ovxa+1x+9tn/fv7v/zv/9NPH/+Q/7LVvsz/8j/+jP/sX4u5fbp+L
ly//r359+vf/3Qe//ftPfvN3h9Xm678T79H/t68Lfexd/NV/Nswu/8a/+NY/
fN6G+pV4/pfa5/yP/uh/ffL7/+mbf/vZ+V/6p0eTZw/bx1yjfvR3/s2//IP/
oonFM8Mvxlo+/c//U4+9/0tPh5N47vRX/0F7j/7jffq7jxPjzvW3pqCXacqP
YpxfiHE+//z//N7v/uHjv/iPmftSI+pW/dOLNZC+LG9Y07DSz2e/9o90h77o
wqNf+Hu6deBe/XH1t/7Vt//tf+Mdw8/Hm5796//64d/8A48w4xF9Dnvt77W+
8UJ9Chz6BK6sp903DPG1fax/5+9+W+vXV02dqeoOTT6gNtPUdIOgO/xczOBn
YwZaunDQ5jkLwOgJ/b8GYBl6SN8FJU1eY7OwePtcr9ZkNKT+7enbMGuri4vD
rH2s9YD+X//0sGavJ/Wg1runv4eFBtUVvVk/NVjvJQQ0Y722/603Chea5fD1
mPXXE266JZDYPm4BNz3oKTOIXqbZaYFCsuahVwY16PZ5gA3wta+xpgWDsno9
OLR1xWxnuqanGj3vtY9j5q379UWfep3QovH1hVWJS9qsfyZm/TNJnxq3TTjW
dsij/BOs9B6mrzdrvlp2AHmYtQnw3178LY7R6A3EbX5tEcM9fYGX9E9P6lN/
6iKEozfpBeIYAU6j6U/NlvcxlwPwrk+QpuXWZfx0rOKnkzt0j1fxQG/QYMBM
8AYGGlujiEt5ua5rRZIXej+T0pwb0pM3l7oVWmnLGgbdFzQ1FyzAkP7F+440
Z10UrYmUtVK9T7NGlOgJ/apx9zRcY/dhn0XpT42oae7g5idjVT/VPu/pEqjT
P80ZRCDBmL/WrE+NpYu6WW+GFYe99p65JqC/BfYXL16CpfGO4M43TWsATL9p
GD2gZWgGgo0WoOuahd7PhJGDEDTMbcwFh7Rx2wr1DGPBn+MKfzxW+BMhV0V9
MKH+NWEw3NeQmra+6s36zoJFJLpT79efGk7TFKglaDUdcMEgrBFiaXzfiHL4
Ll2zptBVSACBxLz0XS/TYvUOzRFi0Wv0VsGBdekGwQ7u5YqmBRD0ReSnqTCg
LrZ3/1isMj7n+lnPsMo9TXWY61bNQ2Pp7j393/BA84CCIHTdpaloiZqT3q3Z
mKC0DF3UwPqVtelOpEKRH0Go7eN1qFL3axq6WW/RaFqhXqslaRCtXN+ZgEYG
6oIRXwROvTc1QFNkK5GAhtPDKC+tTQQ2/Eis+Efb54nugHL1KtCpm/RFyxK4
IBjd07R247i1Jqo5CuCaCMSml2tee6G9Ud2IKdPYzNw5oPmBhdf9HgKAOcD6
ELbeUgkYAMNP+klTQgXrT26wytJQuqilop+Q7w3XPxwrj8/bAjIsjZrUEHpG
V7QkA0KT0Gz0sJaw15TfMVzEDPQCeM9rBp1tkfOQdnpEf+jWAR2HggvZ3G76
KiMwCEoGha3J6I26qAG0AE9GIwEsfdH9+oJgwaaB52AVrVbD6hGudMz/YKz/
h9rnQ2OeBzSuxgIKAoEe0OsZVNMSsHQ/4lHT15+QKZOD07WioIJ9PWjBWy2C
xj4VDnrfEJq020ioTUR9jPSa5i80I0U1I/QanAyzaEg9BS/oNubIdzQVOilG
a9rAwPlaQOJrqZMQnd1q0PLh5GGvEfGByEFCA1LUdPRawQU1lTM90hdeqJeI
U2F6KxiNpRGhftFkt3vnExt60T7egfl1OxoWjQL5A3MtEl2CfWKC0FPwgb7o
ESwndCqUDVDgVM0XntOVJuu/P+DxAzEjjYXFCjxe1cq1YEwkDabhoQuEEt9R
GXpcn+AIdOgKhjWwXOqbYOlbhQkoQuPChFiSxTqOvxeQj27V0xpwmIVvgUiw
idL0frv+hlbAaCgprd2MhCaCYaAVTGMEnicGreiiVvh9AZuA0JLVmmuapdAm
va+F6KX6KkCI0ypQhpjTHaxOzRIZrz95K1A0OJgclkLnFt2KQIxVN9DE6l9H
tGCZolf1fuHToglXBBIU9CwToFQ9IoQKKrpt2GuvO9CbdBUJoHGxUeG3ZpkE
0YpyIAW9/nsDMvF5VzfoTVi6mooeQWsyJz0FChGpBg6w0UX9qsc1FQhIN0Bq
+l0jIwWACiYA3LOq3iU2XJgWATd4osFtkdIE3sFq0O3wlN6IYIWm9afeCLUA
U71OsNOferz5Kw1WjRKAOwLQ8NGMQIbm/D0Bn+/JNWIXMqxggqzXzaBdXzRd
zBPNv8nrGPGWvulnXcVARCOJkCAbSx40BrSx0MqYrF5iybbAr+tOi/4L6bu2
Z4smxNzQdGOkV5Hm8FgVbmhCvZQrehvj6LqwqEEEQcCqe4bwg9rroAg9s5f+
Pj6sPhuvfFdA7LtDQwssuhXFYF9Wt2oWQElv0EC4TnpnzPcubKif9BcjAEyN
rjlineO1Q1r6nt7BArGA6daMtsVEQgfNHdgT0Zpsm2oKQrjAHut607oRo9hU
jGGq2zBNhBqgoTXh4aNLkdzm0zaXWF0zmCyXvjNgFRCbMzSjx1r2BTFIFx2B
OtKVsLfTe9fdoZU1XagazY5tpdfnelbEGjQm1q2A1ugTDaahMYc736Hd08NM
+WX4ratmtBgVvWE9aCgbuZCW4IdUinkOJ4RpdJ9moUlrieANXQfYgRAw0/ux
CzWLrwbMAnJz3AM9qwdDy6z1OGyqQfiid2mhMc59DYizob94CxIVxasJIHXR
d8hIvQJ1BxTxWwizYCI3oM9vgtoajYh/pi+YP0nlzVfACIEaBE+LfKYGGwI9
bDjNAjkLSWopCOUh/JoWURHEobfGibP0+/S0wKcXfiVg99WEHSPpsYDdSq+F
3TSqpqNRLKXvYpFoLP1DK+sNSAmNgkIUdPG9NAWNlfJ0pV/xb3BsCU8Mq5ts
p7Ue0o+CkzmneCczJICjFg/0dugSH4nYCZICFYUy0FjoSSS11py2bIsIzeD9
eEFARgPoRiD2XkDsvZR0oBSDpMfooEpYFIAIcbo14HZfxKIHNKKISPMWKBAb
mpuFimCCg2MTTJBMf22GiBxnZ17V+yKysF8jC3jk6E3z99KeLQSdMuEBmgcm
1sPA0hNkOsR7IAZd0Z0ozSaFAn4LuJYomJ7knTtQfDegGJ8nQBEQOjSgqWlS
Zls9qCUgq5FxghFSTQ8yKXyNvUboc+Qw6n0vtSfmAIIJPbyvmx2B4gEiMY5g
HNcIBhEcKBw+JfaTdtywQPlgfmpg3vIa2n4CVZuUug8Rg56waNNnlYP6EhGA
Gfe3gfd24aofvhxw/XKBK1QAILFRGFSfCGFNPuD6QPdbFuIfYIqAaexba2vI
kuBKx31AYKVbEZU1AHaNt+PvFRJPCEe4IVZZ1Rt6EBqCY+EBQsQYDkBRM4By
kIwE/PCjMS5YLbYK0Vn9E7ArTWpMPfJOwO6dAjv0CKgU6DVFvRTphpNuruZ+
rUcDajKaM/aTbvbEkINGPhIw6bNpaVESThainxnq+g53R3R3acbW8xpRN8HX
1sO242zBgpXms7YrxwQHCUwYfEh7zcOY7xIR6R8c3oTtArQRr7ZUmQsKxF80
q7cDmvF5rOvQIA6aBiM6gLIHry2Csgw9SCRGV/UM2liP4dPikDj4gQAgQlgJ
0uYHNLkWus3ixEVg8S/icBvyRGM0TVtrC9t8+DIjD9qeh+dhLuAEQGF4y3w0
o4bHD3HoEcee/EHS1w5kvzRC9ogQADFV/VT9NCSiBg+oNo+fKA+SVZPRr0xM
8wGZQBsg2/ax9Nf4nccFDU/3i3k83jsjKN/YL6IFM5uAHXJ2mpMTHmLRsAJQ
yoJIN+HfQZxMX7PW3FFyWMiIcWApeOinxTUN9FZAMWC5JErG+BpEsA9NPoeD
MHPaasKKuwXoDEMYmscw/C3NrQHmODfITfQRZguIb5SK3U2kKPgsLEhUorMi
C43gxE6TlbGuhd5ZPZPRziPeZGvJfhSzWsDVgiJW1RC6c4W6QaeCl7BgI/NJ
7I0Enb5r4ouUL6h7XXkYkA34LjGxsJDwVYAsfhUWfdDJK/oVMwk5CsEDW7xj
3QxBYuhiYTrKYEkHpFFzUKuWQdjZnucYh9GbyGETx94n3uDAM7FTkgFgaFF9
mYiyBB+iZfRWaBZxoCv8ySz3GuDvoHHrMliqo4Mof0cKI5ia+MRE0aBvBowD
0guwSrAr4tJNbLf0sUCq2WJtMsYD7Gh9xfcwuK06CQvpuhUcip9IxuB4EVBP
D2+FuwuAHWy42aJfEfR2cBtl16Urvs4kWjJDn0emJTQEkU6mTWAPGxaWq+yn
X0lXEwAGfo46NIkGbDWW4I6b9EbANiB8hJfDPyQ6Uhao6VOTjBGOMFKZDZEK
9Ng2HBEeCf460uuxDwA69qtNGc07dcjCISyM4Jhr0OkcpiQ0Rl6UfB9iAamA
JeYALxA+IdpUw7voJdMlFkzLaIVlU3U0JiH6gZCdE/bYNwSDuKjlLBN7+AgD
kH2jwAsZrWmSkyL9xxdNDsjqC5NDRJh4sbAwBgKyS9MyLkKuYR8sQhp4gpBp
k7PzlKDQJEyHtJ2TuSpQXqNpnZUijZ3WV9dlhKbtOULoLSoe0EDsBZ8GfDFM
kBNYl/h6Fh5QNwagXulcfFt1BNNhaPPXDFS0CN3rAe/4PEL3YZKgTykZ4FaE
RPBrs+30E25x6OmgL6CNjplA20GUWNG6rohHyDZZGsPhBLb0phZTWE4kBZFg
TUmj2vFHHXfthqlKSCSufAlDwZYhNIBOAbYocsQDGhwzgotY69CJRobPmSdw
dmChwxlLtEml10Y4HxIwh6Go4cDxwmmxnfQQ+Opv3U0GCDyyLis7ElUWac4Y
kZb0utA8eBKOfaOkRIvxxjmZS9RdWwzYJn6FPesszAxd3dY2LxLYGuCBfodS
PRunxfmOoQl96BPbCEu3SYIG0VZ1E3U0IGiwjUZ0SoO8GnAN6B4ySewhdLlz
4AALuL6J0ULcBTeCn4G3sW0RQkwQaoU3MWd5U4OIo9qO9VpurIjjIMURHVG5
1LS9K1mIChKdwAS3tMA2SnnfpQVahZigwxrACHq1mW4I2yTFlnCSTmDXgHh+
PQuH4dZYepW6HDrXo68EvAPqM3RsrKYFxpYaQZMHhDh965ghBEr1AH6entS0
ccChXQMb8rCJjJiA4h1BmENrmndy9hr+QDkQVtC4es0024r8IX8krnN5DKFt
RkfG4vEikcFDw3SM96qehFOt66w59N1BOtM80pnVIeldrbYgnkUwJ4zreCNR
s+YTAfH4PERCEwpBkWKZI6QbLwbEF6hB0zny+a5+cpxnGy6zvU7PFJATlS0Q
6JSoixlfX6DJSBg0L2Z/Amlkh5ZKJLVaGDPw2Wwr4It6iAqJ9vdbELETpKQe
LLD5jvjgHsoKgC9sj1TG3sDlNXS6VG5vfzDCtkfeyasjmEF51GqV/D1ZRb1d
48NLeAh6eJsZAk3SupppQ/QGMMmD9GcbV1OAo19nBd4AbZXcln5WaFtnDlxj
4LqSodoaxQZf8x7HcrDhNYQzOj1+T3zCPPlF/InXDikRqneiykkevWO1K7U1
m/sB9wdJ6VAlXskSD0Nz16CgLbC2hlxRgtaJzW9tHmMj8kOIvTosABs/2p7Y
zMAfJrDOmN8KS5KMuCuUyHONcG+R5PC40Vy6g6T+CH2uWopA9enx7xnu8J/t
vVcxCIC7PQRYxCYTQKDUhclXuDdOWqfs5geB5V5APWB/hCBigsgerGE9uYu3
h1gVMJZeyYQwuF3sYQFICMmQr74Lfg/yHKoXlEklJdWvMOWYGMWnTebebPm5
5ts+YsMw8gWbskFhLyGMDJlA3vKE+14hdmKhAxHhyrIIIA/JYmmjz21lIAUp
dm32dYH5IbJFv4Ekau9EjBP5tAKa0LtlCLn0I/6wm4NSRYbj3reatcLNLaAA
TJzKYq1L/HEX2urPg4Rzj9ahSxytJ4Pd/XtEB6YzV6q02Mt42nG9auKoCgeI
dr2sOSJKcKRdqYd1DSPE5HMOwF0j3Q04B7SPwL7Ai7lFwSLOJPHspO0DrDnL
cgQ+Vb/6HrV/+/COdSnU3nnM/hoRf/4+wF60RSZo2kXvlh012s5kYQn0nBxZ
I6d/e5wEy9c58YxlzWxlD8YCSn0HC+ZP/YfCmkhyiK3bsS5+xGKlXn6mGfWo
LPpIA0LyA7CPzyPMOkx4cEeuExNLVwSEoKv7zAn60BfkBDWPxOrty3jGmiKR
WcvxuvYFchw1G35Ik84zHt2m7bfvWrqWKRuGFtQMincu4MiSBlIlt4xDgUOv
IalpIK4mSFXbO231Xp/OOAA4njqpwqWuE7pBixebf0ZiMKzfsBhduaO7m8VY
rZqGxTsFH+TebATpU6PpJuqHdUXgC3zex/uBIzwrK2d8G6I7dkQ1Q42QXv0M
xnFMbm7p37R04GL0j/eSC+auW2tJqy2VbsHfS3x7eIf4AFKCuUyiUUkVSwfX
bHVdh3q1HaE9i9DkrCWylAooYD2bxFKQQhqLAhl9uR3LCPjPsTLQZUTGoQ0c
B6LMyHvEDvwAkCPHGVWoeEqIJ3hLD+sLqbGY6aGDYdsS1tJtZCtsdbfIKdUj
uqNZIczfddlpz6xcG4A67AFw5xGIDVJaMrhag3KUbVGdXc9Y9tjPDny8gnMK
CpGgkIHdkqp3MR5xu3BPE6ozDLxRLmHBtAgC2LiduoLEaVZKrYgfQEXIsmYH
xBj3oAnzAgF1x0DqJC2bSOl2DWC1vE0nXFcoNtHnLCGJrUPtaK+S8h4Hb9Qq
Fv6h85AkIQhAEDjutucsVwuWsjZ25nA9GZx9+yMVDYgAMH1odFUeqZ4Mexri
XtehEcjCzietBoC7jMKcbrRxq+AGZkY1gxscC9CqGWkwR2/uQk8TbkHf64qZ
xVPWPS0eGXghIG+SIvlJDXxWHi2oXSGZ6YqotQtYm8KLvUbtt+HmWsEl72cY
clSzlBXUseTbDkUXzKjaRFURDNbitxxv3RZbykkFfSeRh3yLHWvDPnl+khrs
RsSed6RhDu0DtJPASuDmGOsKhVwrKrBARR2UbzLKW8AdBciTRKrQP5VjkHaY
vc7UmtHRPOTEx5pFyh4cH1h4V4Jgk/p/Lyuk5ww/iWLOyXMRvJ2lvgIeg2sQ
jQvzBHTULT3HBnscyCrRCYiqHitqiC7gZm1ynyema2AY/sDgbTq8YGLGZpbg
3WazrHULgOZ96HFNHn+NjVnVWwY3ONXGPusS8AgAToQwgQ2SjLUG3BWP8Ior
HUimdm7wfiDs2jkGCEnqqD5b2MClGrt7zChBciPAG0awZ7wyhipoe552mwEX
9Node8713ppww4MCDmQFxgw2gSObQaucn33j48BPYGkfdYyHBLNhXTmLPsOK
MM+9ITBSYokhwp4bs4o1JtYsghG1bx8EBGmmaX3N8a+hW/iAMBgpEeQSeglW
pipjKr+AM1avC8BrVqXZ092vtGapPvSRcXQjc7C2eOtdR3EqPmzkbNMI1hes
HaId4Y20tZmU0fuj/Vtwc4w7CahcwcJjlmJtn0qM8QACmmh/TDV4BwRxA1WQ
SGFm2iGCWrdcmUGA9sSv56WW7M7AMiO6sp7gZZm6qVaTDxPMJ1/erl630WBo
Wo8Q1Mls8G0L9+2uz2XxwOqxCrMCZvRGcBCDG+EX/YWc0xuOAieBmZn5hUqx
OVCsVSi4ik2ioPMBS42LuKJholqIv+qnLf7vXuqPnlmzpwKjjLVZxEWTdxb4
MoQJ23PUJbDrz2ZXW3/L4SQcqEnq/QmQaXjsRYrO4Gh7rbeuR1krC1gWdHkS
dHDX2t8YtGI1PCjZIjOKOPNuB8rGumUG9xBsbYK0YGoN91hkkJVudfOFzk2d
93FriCzyHdcMtNgqICztuhmoznhH7HY8OdU11AjqGLmlQhF3IzDULTy2+th3
6XpiGCMAbKIiHkk5XI8f1moS+zBdD5njDo0zawhb/GAEK3uGhN+mvTCvkjC0
1r3KWLZdcb0AOKYbFloNlnTrTc9gTujLYSzyKNcIH5DToKqU6XQ5jnI39h7C
6HzabsACpPSB9VHYxTZSXARXr4J2K6dWjZ6rpqKgRn4xiMQM+JVAHBsla5Ga
RRerbJaZM3XobzL5UZHW7rhXM8zVSTGD2DZ2fICldo6CK3nYJXoWLIYKGp6w
b2b9e9yJGTWaqfqovaHgZY34RnyQ8mFscIKFYT/0TUQ2jM0CcIGZKr8S4YeX
sCIgTSZZnbyRngn9NV1ZY8MtJkCcEUvvKnYf26PE7bweJbCPagvwIRVwriCi
cM1ul1N71cVk9uYFe936IkrLSp+15aH9OyidukR90YyhbLuiXT477sU7hmrT
8YaIf4Otfd5PdhOkE88Z+Qf4NjkeM3sTiefMJZIRBsQ35wrhfyaNuANXmoJm
aKCM1gME4KzcvEaXXaFOqMe1duwxwOpBmIS9thtDcNSHMPkoA2N9b3iTr67W
CFN1TmtcADlo/NhugIkCRrdtslXNNuEytAVqIyJuy2qJo/ngMObdvMKCuTVb
EEiTE0opsdcZKettWrr7WLpPs+UMqbzeTSG68CwAIUmE2NHciGeNJUCG8GVu
sZpE5XeqEzsOF4X/HC9aOF7DbsAxj1B70FxkQX/ZW7a0ZCQMltf3iWJg/ht1
Pb7jTAEF0S060uyw3vuoaa/bbeUHGFi6SqcNLAE3Y2h2+F4TGa2PiVXXMu2r
nhsYMePsrreD8AQWsGBFHMuNRBruI/e+IIaBiRheWuxxIpoRiZPAE7E5SmYd
E3AXADKASKFFytqq09feMfcit9SRByH7MdmZPnMJTcegiMi7CmxHrMlwUqhP
jQK5VnpSgW+YOfYZzL3BVD8dbMZ+U/zz3jFgax6CvuEJbIUoVA7IB/zXbMCD
uGF4RMK8YMtru+ddxdt0QfWkoIKUpJZDi4eaEFfsgQET++jpy2hA4OrmXuse
9HGIzWdPFhnruujgslgroSD9jTkEE7Sqxqb4F1fZIqrvPAj5tmTHECyMCXUc
1EzdNLGUanUhw2wFUzFB9GyOBK3Rf/BhWK3wXSZ5xJ6xRgO10SouiG2RGtCw
GASuY/KG6rNsE1W4+j4WGdDjE8w63EbRPIgiEI4gFaiYv1ulMP8Dd8FiW6Qr
1RAE9ERzDqR3yhh54ZX2cYdwL4LJthOkaTfSzifmJBA6NsQczqCdDeEubPPz
Xqo+rMgEkV8w2Y9ZGNvB4TsD87X1uKMAT6PBEHIZm629ofYAsb3+Jnawyz30
G7FqtLbzNtjRBO/Q/igeqjrQaVgZdH5augWLU6TYKGw+2mRHKeRwgfedADr8
Sa06Jof9QStk7Flb7f7CKoLal1a8hEZblqHN7g4inlAXnhST3+TeZbZ/4A32
uNYytWv3IgsObrP7xm4olmHdBIP1gniSqIixul9cLeCr2HjPbl3dTOKt1yoE
vx46W4YhuC0VeRBjl968apTmMHn7encC8ejm985pdtM7jRYMaCo34bI5xr46
7GFHtuyWI0phVVu1cPFqlxv8FBE/tpFAdk31HaUGmta8bKgtLbC/BbDBpV2O
7W59DnLK9Z5rgle48hhL5D1C27+BQaUHXkYRMf4KZhxh6G3JAeLobWI/KBVM
9MVBpKYHNQcZUBn61lfQKQUjIQsONQxiB/48z/pm75ftFT14NiDpebSw0TPV
3DTTmIdsmKL1qBRx4NjRfTbhouWQHgA6CHHTOzHWLXIQWdZa9/osCAHeCO5b
oYCIuZxnB8RhWgET8ukWMR7mz8S8ywp9gLpD0fVuHJ6MVlsjUHW7HlE09uMT
wTKxUA2yRLmyYsrO2pobmoJj1kwCWwEBjO0Y/SaO6s4sh70p1jZzkKd0wLaC
nglDrSfVc4en2KmD8ALofAle30eEoEbPc2sbxNjj/7obAvDewIKxnnuy7Ga9
K+tVtoRC7nDmffCDtIXKEGw4hJAutILzaof4qvdtehOdRUjLW70RhN77yG5D
Ks+olqD+BOEOw4GpJ9kLYYZ7GimZi+u9LeOer7hwBEwzFlsYMPyIULGPHzQg
CgxDfHxrG7CHqEeSW0EBYX5Co0aUuE1oTiysxF1OqhZ1eLgGsLbZlgMpo/lh
6uoFBaMz25HXtEH8/cDvwQmEom3QEBPB0OHiVewNJuYbOr+p8n18QEidtJs3
+REHP8KnpOjK2+m9iw3/JPZaH1f7lbFgAeJnGFDN459mEUJqfBW1Q5Ucwgei
gAypLiN3BNV4nmhVvRnuJxprAWoEAwWzY4+HPc2OVaz2AC+HPfOPsoft42ys
4162Wob9SweVHQmBGps9F+hipl5pXz9os/06t3DI9+xjD4BnwpAWeVDfAaWu
2C3sXOMOrbjVWDS1+2Xq8jeRUCJgQZpFuMTWpx3Zk2jHZCYnwI0CpX9htRjY
sMHkMlc8zNAOTQbeWHX/LvE+fBU2N7qjC0zqbBp/YtmQFSF2cRodEMAhvLW9
lkoipoP8xRIjFY0CQeljIRCR44u9WN7ibTglSrNAgPCvLTje1OkI8gv3rI10
jBK2JMeDQWKBorO+n6jh8W2UDPCDPfkE1JRH8XZ0su63NCNfSZnDs+jr5kAY
W0l6zzfXYJpHbX5rapTgYfcBpubFHEzwGJT7ZchML0JXeaneOUzVCOYpiAPj
6B/iGQhhOirUSXX/aZ6251XuBOeVmhvCnS6yPVO/l7ZnlZAroIyy+SB7M/VY
MjSBGVPxyA4Xj/E1XLNa3bONaMAmgtswH74WXhplYNRGsjH50+xWu80aXd6B
kIDzcFcucxMpbOGANHgi+naZm062uxl5PdLirBGZgs9wtFt9xuEEi8GdR/C/
c/7Q0yfR8NJViGGb3YVF0aCkLcja6B40mkUDt5X53iLOTm6G/mgkmV0Bus0C
icivbXrtXMeBu4fBp5gmsGf32MGmy3ozjtY9P3hjk921F8gDphsyP+4iVxFS
tf39HloGzKAGzrIZOil3SHEbgXTo/ip3vRPeJe/BAomqnuc23ms1IvHOE2Io
2+IrwzI492z7QctMsRk8+hA7+cPsEo4g0FtqOTX8RrUhkCHchaABpzVrvddY
6wFsCdgw7ty7zY6Wteo2/RNnB/GM1mdZe+24AJ/gD6eZXyv+LHE7/uhDB9GN
+7SgdOdf72B8Ep/DNSbW6YA5ZEdchxhupzS217j1/KfZ2si1VgsbWL2qJ954
7DoRWBKYQqFn0ckLUU22bYq7Q7QyqyfqRmLS1ELedk6oHaaNiqW3iNTBL2RD
tqUIz/EqjWKYwJDIHMjCSwKozRVab3q9I+oS+dnj9GBmrAkDX0SvjUew3uLP
kAM8O1ZgD/nfXoFI4KFdfAWzHXGP8YITCUlhW22yGAoDjQg18G9VuG2chZlJ
f0QyoV099pqZmAWb3gSvkanpdSEjtoLzjsnkAHnC6oj6bSkXCp0UMwDujQ+G
IbbsRY97EtXYLrQEqzYQzEVugOyb06djVVkD1kAf/Wn8M97cI7pIAcAPi4Ip
aLLRdcUfNsrIb+h4h3V3coxD1pm+ri+wjL4gGlkyvpE7HWNcQTVaHyR7Hvtp
kFimh4W+oFB6NhwuA4Qvo3MefhRuLbLJBtE1vAXXPWQ2YA9lu4lCR+tPPcAY
+qIboDUY091cKW0jZNsqCZp5tfTmfScUJvXWNm662ol1cErF4zg6AFnPvg9m
BcZLXdoMYRsStWDsPBvh9/0weo69IwEAV35Rt80z93hhm3qUDOs5BPb70Xzf
domDB4RhGu/H3ohWqwNwK85mjp72ijvess2iLRLVWjfRIUIbrRpur7Nk1LdD
k0gwhEdNh+hO2I3X45E3RghYHsMB+EREYnGK8VSJkHg/zevOfSNC/EWjOIDE
J8Kj0eEwIBM/jmMTsD8j6bPtnh+4yMrGsSfppkQJFzTJoL543H2M52ksvU3U
g3phQj7or8fR3gBCQXBwEcp+li2lX8bOjCZyAlbNDkycRbwscYTkwnRy736E
KUbRyU3c9C4ZDEIcqFPcfWAN0OprHalEH3w7DljB9ULAn2b//NoNg13NDj45
BMP4F6V0GekDAFgVUT53Rkg7f2aaHgqO5uAVIxLZR38BLJsX2ednZmG+gyWW
Q5QX4kN0oMEAJaYv8oRAdi3MRuaw+csC3xXkkW2utZ69VxICFAg0yp7iKvhq
CYBxrvGoIl5zaC2COcMXKHobZftokgOMAEq2GOjjOGMEPRV+06GDQ3ZKWBTh
vcY7nBQD1j+LQyiIKaEInTnp9sWTPCqgYumIlWwy8OdPF55rSq6ogEh6jeQQ
p7SAJypAI8IVcyLLzzEGcDwKHl89YmVtjH1oGKGJNNo6c7iXGmqbDgp4tX3i
+FQT9LduwtOXLP9cUUeokXgqd7+M/R2EkzERkeO8FmIDeee5eSU7XhzYtnex
GUoN2zxgcQwFEi2CoYA5KZOx4wTaB8prgK7yzoFo4Lty6hiFyGe/tyNpGFxb
NxxhdRAJw/dELxMz2oxVozPqgFw9MrOA6OcLbbO3RbwNat5mjIFyMjaCuvTt
RswcgkWcc6czTOlRWRmkRpKncGnz79ovKxSrBWGPwYYnvry+bzqsuia75ygh
CN223goLzNlmZtJxAqwiElVw4mhxtxZPc/tgtygdROtyDo83ptc+1uDE9iCK
9VHfA31k6eniAKJNH2XfrRZha+MsrAd29JB1MSvBwSSOaZNxipmQdQ+hNWx+
eIBdDlXlPIneIn5HjRcSwNmWci+NFlg5qPtJAQV7DDZjJHhuqLYcUlwBM1T1
7YXp6o3PvTqY6Jr+ZXVFhzi1AsbQ3HFnwWTu3gBTvDyKLbishDItskrRp+hx
P8KCdolgemH3sMfDwItDON2iAS9eOpYIKU2C6gBe77sRL/tIBiQaz1PylVyR
XhihCHRAzaRReOa7Z6OkZXeqZ1YrZjptf5TNyHs1CdWUqBM+EZ4QArYbon8T
RUoVK6PtFhBtTLtEOtYoBrhBMhk3S/42btrO6TbQCbBhNyH69CJ7qtvRK/Xn
C1vW3SoAN/Zt+ZkQEYUq8Iwk4Y24ect9eRCXGpVikAkKWAv488sqanzzDmac
+TTDjZlil5F0zHCLMcNWB+eOwQzbuf8kzAQnMBbGq4Fp3FyVuvLlJg8Cooam
7dNuuD3By2LnBfRt3EyKfMENun6KmwlkMO3ZfQbfSKHcjBvokFtJXRDyqXLI
uWleXq9TJPNFuFkaJU4y7CceCJZf5NFR3MnQEzzkTsWOB1/vUfcbkTBMsRBj
vgoOHZp7Gm2hmQnDsiqQb0Q4YFW7dCy4e4KJ9Rdhgp3/fuaa5XwjNlwFOcEG
V3hDvc7jfzI2YDP9GbW9x870/vFoGSZ40UvAy9D/r/3XPPXvKNhqXkLYd8iz
ZmNEsG8YJgLIsRjjrA/KSSykQHBNKcofq0JifGMOk5lxrZIxxIcJD+nKDg9V
C9vu8QfRORoeqtHDAMbk79mf5veH/nsb6g+M6yKnPZj/ePdENg5Rt14xzmju
Pdkx3v2QNb8a8906HXr0Bt4Z0s47hABskxPKJeJ10U/NSRrgDkH3ZhkJb6IW
EfhUchjeC0z9Ec9hMW96/WHaiu3vWzBDxTFMiVsxUWHDRIfhnPduSQYdP6OG
qAjqWaAGuxsl5WtoMTKnn+chPxPFNMGU7eur6GBD1Odm+6IWMpi9eyXGBEsH
7ObZRLINe4118Tq4lIDndS1GoNEYmlkddrvH1tpol1c99oplxaM83G6T1Z5V
j2FIY6/Y1GWNE/uvR1xvtP9cJvA0Dxn8QvsPR43m4tswwQkhbqv9R6jPqa//
H/vPBgkMsQ2ntlvORIUhWWMI0sc5op8l4X5bgPZhsv92wMCnGaOn+mwcJBmx
0tcGVs7yWDZSvZ9ES1bWoy9Ya8yGeLE3XG3/FN7S3CTZsqxNvC4JNcGFm/BG
brYumJdL11C5vNaERh7b7zBSjPZtCSD0vA44mexe3xabfO6ywbNeJ3VA1vVR
nP6BVcEUkB/gxPmIz3p/xy7BRzvSeQqYrcJpdpFb0sDKvbMsuXaumymxsxX9
DlaoMyFn69zf2nrK6OcmOpMgD4GMq08ITBHbvDnq02W0/bPXqqWzLd0zSF7Y
ujYKXBSxTZeXaEV4sSvf5jnHju/NmGd/P09kO4ADPopzjShEwUGA8cDIVR5J
+6L3Je2wHmsvgmPmzBP4GBudo2Ok+6AdzrLUcxYCYxvGQawCAnI9xONqQdpl
Nkvqld/IL+bvfiwOUZMPJrx7Y8x04VIhXgJuXrEWw3jGZacuDco3w5LPq3VJ
CCrq/+1K+H6KzalirVGFTfhxEUno5x7zWaOkESgquBiz5uCCBSNXjAvkMk88
BNXsy0JsO/pwlv0Y9ZNzOMCBEnYn/q1XkB17+SZs9d7FjGSQtavTf0Q9efeN
GHkLXqXuF8lDunybkYxt1rRV7gBgrL2yjC31HoNzjsGKkAi79Su02usEiH2h
VVwY1CuX4BNXVmt5FTfWMj0XhLAhOTtmGQCFofYGG1FADrwC98DB4ITMK7An
bP08Dnlm9xBIKJ5rzddldGnce+FS7aiMnnuPsZ6+MR904Ng1Q9Ti7223se5W
bTIpZ3dbAIRe9ZqIXZtiHC0iak+qJWB58H72KDzP00TZD0G9zcRb0jwrXmyf
dUsZ4kdrOwW+g50x6k82mfgWaCI6TDEkKHMGpHUlo2AAFdSTdLZyukeA/p/a
0rb2UcNtj2Rs7Ua2UgTqxjvBN86uPqRSj52IL7OrpCnDkXN3Mj7PvR61Lglp
aOPAPYLWVi+TnQgRX1hRUAaBUBzo3vmjjs842uD+s5sa33FFOiV2uht+Dpy8
hUHlRlXcDFbOoiQLfYzUQIIRFUXKU9C/Cc8PwPa9fRPvpUYcZqPfSg2Xq6AA
BnUXJInZ9HCaBxpO64CisuSWc8u2tumCj31bN6GHJGoEeUL8lyLLbSR09Ezd
xLNNvzTwtF/xjOaBmscY3ZgpYJ8zso4MFtKbPequ0stehki+I1ckoNHZdnlW
eoILK+yuxTimyJaMW0ibd7RwFCqlONwD7tnOB/7OYwcNPgT05nRZ1QB1/1KJ
1h4DZJOyfQ7uZ27uPFJwFTVb75DOo0AHg49iJEvQj7JRLtbL+7mF+yLPcEFe
O/Jq+7/A+Ngo9CKQek7LwdRdl6BMedPzPJdy4RgA5s5QcPVurWjGa7I95uQn
9bNUW7MQTAICPwhxFDDFTJS/wtWXscd7L8uin8Xhqw3PqV/nyJp+1l3M15qh
yLy9RATyh9u5ES7BoNE8b6x1PSHfjmzWUO4pBlgpIqFCKSB5gvx+HEeZg2l8
B7bS1UKGgPGR52wxCP2wBQOA4qmQcXyaB9kwv51q5FrdM+6BJjtL6TM1E6fR
BYI9EpDEmXd6RebndXdUt9ok74Gm+jja1p7lbh8K759G/0ycMmRO+r27crD6
RTXrGnLMOsPQOM+d9ZQmU9J/HmcS3VxjfkAVBTUH34rTXAl+weXe7WWoUf8a
3nDfhQf1XsapC3a3cR/gjMPrbT1QhDbtkIBrS0QC1cY9+4JeZr9nwLdTnVV0
WPPpg+Ldaq/NN4JKFAWc5hn3sw/y/DB49UfxRv3pvDW1HMzuIvf+4v8ggHDi
qjB0u6MqccghfBznLIMXQE8NC6xOohSIkcx7kb24C+44qwtFgWEKmSNnbJ8h
bSiSP83jOdDpYSc1Ej4+j5Y+n+UJcY/ivHW29lLdwzYH3nlwIweyp6Lt39j0
/QCVXnoxXnDg4uM82WJDn4JShXzorcbYm5TpbyLcR5HCGHdCA+kzKOxtZDmo
wp9j3rAf/u6jOHuAas2PsjMd9fsT7YVKYR93cHl79T7YuIpdyOhbElupFyKv
1U8QpVR72rnekUiEPDGVdx1jIeQIhhzbwJCjZGeymfsqauFZGXIZo5PyiQ/j
lMiz7GlBZWeN5p2XzuaYZcwkqiwCj7YwCLD0iCU5FWZ0GicQX9sPMObeWwa/
8V4fy4WyWE5drl1Ghw/T9ZeAPyrIPhfEwXWSh2x2qFvPaH6AcepCrqvc0tB2
AkbEm/Ba0FNoTKr5oVd2V8N8rTQnTn1YDnnqg7exsc+VWhbYifQRYj8o5l3b
QpvcDumGCA6pQMWWeVDYJhLfbjrLfs7aLsmPX/UasznoZuvaXvGsYCi/uu9i
xWnyZsW+w4quDLZjiBGh+FDaGKF9JHcn30Rkj6ePbFCiwpHySDdsqGZlNEV3
7NjIZbQvZlWn0W7GNlfT3HG60C2AhEbW3VRmWh8gSjFvo+5rs1upHam3N/CU
n8Wp9shLPLkaCYOKUPJ09sEr8JfneTxQeIT7CCZyV3geVCDELpdG+WsQ7rCv
2xxFTXPvOeHY4Mo6kIKN09I3dOn9YtsIrWi8sqPqyNLzNLsUYD+ynQS81P6K
bfpIKFuVQ8S/fph1+FH8PcoaCRRihZDiuMoTRHibq+ERYjgjMCubSlCXlA1u
shEseEVRYTqyGkpko3q+YDTN3OEWJY9C2x/lgfFuEfdJHhLFJvbon9tW+528
ujoPVXHjRgJ2fBZyXnAofbyRRjhZp9n3cRvJVhTOWTYjAl2RbZ4RZm0CiLOt
+Zm3Ei0xF3V8O4ZFziH3uc5dYe/oHzF+90N5tVqhvJT9uxgqDOeaAGzcT/JU
BADsOMqMCE/sb2xk+tZH0ZIHvGFdUU/8QRwf4HJJe2oEMxFXEJFL856XVubs
2HhVf+DOYSzRhBbe8ia98zyQe7vbjwy/KKI6jWlesa3pAALClLiJDRim8+08
tpXGWXwPSXWA+ML6Ps1zZpFmLauVNsnLPA4KrkIxunvxjK0b1nKdClyNhjGx
LXmDFaLJPfw2pVftbcqaHW7GViZI4Upx5ooeCE9lCaqREfALMR96CDzKzseI
1uzOde/82pl41aRl8x7wdYdhLhJt+8GqPWkIgARgUymjuLEY3sp2t2+wG8XA
rTaB7LcjwiZRNsvPbZ4/FNmfBokTZLgtbxQiPPQ0W3XB53Qcpkc8wzk7yHTd
txa7ppV6l/4CKzQXGoXVeB9czXdue6SrV7Ri4QNwtD2fjMZsNpF5dRyWt+Cl
5l77Ta8UushmSkiT0ae04Ou9n2s/jYvrvf7HrtLZbbDV7/9eHIret5uFxfQA
hx7D9/M8nQ+qo8jESL4sh6Gc5/ZIOPjVx7v9pGBWHI6qk2ss9HGeoo07E3Ks
WWOHuKqbPDoFJ977/gMHm753FTunxiCXdOPDOGd8rHmkeJPcBef7jicwg206
hA3us5ThuNgab5VamdgYEPzSVW6Zf5Td4m2fe+IORvDprllUqGGVYGESrSRp
GVGh9o7D7bWD9K5Kp86wCKK2FSXrjoa37NO4mYR3zl7FeYDbPPXTu0e/4kCo
jdHLa90iJ81wzfCmUnasnOVhpOBYvxKgxDXIquEFBqxdGDo6HhA+QKBf5IFL
OLt6q09u7bIarIbvemj4W7EwLySPs1adq/M85ogMkhXDRBr7jPTq2ZAwR57I
Wbb6taojT72hjqx2G9q4nsWcT++WJtkjqPcoN1Xrcz2xisnmnGd/fhiUxlJC
KtZy4O4drFeL3c93j8N6lo08sYegn7M8pvL97H/I+Jh0OCpY8W2uUQqtn5AT
mvRRwghDqncNwOts1Q6ly9WJvU22bDHB09iipKfJQ1AC4hoJVqz7b6f2RuG3
zpaBMxxkESndSId7mx6jvyh9j4SUZTCsNdxY+32R3XHDCQg57Bgi+hUwU4XV
TqCGdPWFDkaEP5wv2LcY2GSUe8xKB5cuzrJpU93NPKM8IHh383V3bzjLfkfz
yzyPWIA6SJ3Q/fEC5Xvec4zwfFnauGIgODxpjPfuetEP6/BRbiLCcHZAHl2b
vSisaZbWERr0m3F4DedcwnABufZxTOACvU+TMasT7212B4NpjeIcQj8bz98+
pFyFEDrhas0EjxTXYXiw6XsSqG3PLskze+VQwQpVz6Lh38t+snFY7N23O0jb
4TT2FdVukbdcBWKrqFbUW2x2qzdWdIDhzOQfZwdYQh5NZzdKObClu41YpvfS
gM5YzWG1v16UI1FsGPg0xbj/7qd5XO82+3N/M4/W1uPw+UUePPEiz/wC17RU
Iap2Ea0f4vprn187sfsqT8e06+Z5khWiKhBD90n04GmZ+Iz/YvD1LDAMmHKa
89ttbHpfJxo1fJ+FfeweCyMLgqXfbICCu4XPC8Hw6HvbHmcfEDuXeOOf5kmX
96EEAug27jFRkUWO+ROWQ0BiRYG52me5Ro1e5CFDu5ibud5l7PPwuPTZXz7P
E126vur1mHPCk+TWsQ7dgs/nsVFZC+2WGMQdx0OqLsH5fnxT78Q2u4DrgW3+
l+XwPPdqo4ebd8a52ySYOnNVJ5giH4zGAdW1OSAeIt/xlpOt8/xCxobvHRqE
IGlPgbj7JA82KFha2mg1V7sr6ZNyQsTMlYND/d1+5XiSWO8HeaOcW8BeZ9mT
vfeYflbOTHyWpzBud+pXjm23QSYWy7X4sMk1emxUdJpFqXOq1RkLm+K4np2T
sJuNa652TkJ72jfofSrJdTmdrDs4y+XjPOTQSW68BddF8QhMxbh0vAJFnfK9
gm3GC2oH/RFH1BKMnTdexqk4l9G5jJpGalHx755G422apEXUYwWHXeb55aQP
uq2NXL3MPmGflGbslbmrt3Jwnl3Ut7t+NIwEpibFSts8fAfDzdmWhS1N0isd
UyiLeFlgKrL3K1LXaEpzUkQV90LBO7ytgajgdWb4LBtooGsEasanuJT6TuL7
l+UsOp8Gel0r7aVse1L6fJd++uwShIkxm6ic073EKbpNn9vn0V24QTyrWRMB
eN7P6rzjfcHb3QNWK6LofWMhN1Yk7fDRN8sZL34UZbYpOZrF+9nkclNOmyh8
VE6fWHh/3g18dJ7HFrjJT/DRK5elkTPcAB9g7FF7BKljRDj/QjQsPYiZD36Y
4Acv0fmEOdLto3LKGJEbzDBXMxX55rNxieT4PNLPd88IuVXx8aIcQ4Gx7HIs
CGbHdt6mJXxgi6vqHsKO9syMjtEb7Jg+mHAOuImqsZPL7Kx1mb1oqo1HEhMD
kjMq0RiQDJINTnIxLKFx4tQv48A3yKjHea7KKeO70mzEzYs4vyf6fqSUoxKF
v+/RIQZi+jBP8/Huk21GBzRVH7Wj28x703N2jnyMwnY3/IREoMwQmrCl3XfR
4gdakG1L2RVxaCo4TrPXZcXUTVxTTkG65boUO/6UMcAuqH+40JmaexZpn+ex
MB9ly+6X0SgaV3eT2RwMB+uTFZ3OEPIuohlPRcJwH+PKFKCMHMRwWj8VWJ/F
AT7Up57lnppNHupI4cdzn1kFpVyVM6vwiDy7W85iMnNsw0mtgxPM40n0F3nK
Y0i8g21x1wAt1nu3t5vonTma0DtdAvnL3gS1n/J26K4F6MltObHnqp+oEfj2
pHtlPMTjRm6X2WiUsJOLVUha4A+8n70iwRPkD8USOR3xRLXFiy86vapJ45qH
7BGOiVxb8H5khrXYGkfIJILZkrL2kGTmk2gRuS3+zNYn1a2Tso04x3bMeMSF
Pshj0PrOOQuNjhHqOdrMCkZO0OSUsF3EBi1bIefZNp8wNtaa+wwC6LNszobX
+LKcJkhLQ5iIlLnlx8pbSbZprI4Wmgubds58A6iBj9VneeINgSlEGbg6rDsX
yVth8aGV2uq9R7dXW1mC4s4Oji2AGcyxGntFKICZuxUzz+P49JflAEu2jWA7
u0IxczkzhrPO6pGFZhuWU0UP3eUKBLOoizz9MOAUHMgcTI/zy9KhM/j41iRU
e17KmZk3oxK1GE+YZCOCviAERgsNzH3L5yUij0ZMzbMDCIbMBfszI9q5IKZK
HcUo0VhZj39su/1+Xk5VOgIvVjgvd48QQ3HSHb9aERVLxNOJ9Lo+8Jt5ahmO
c7Mr0DRE45vMBidxEvIxBqcDTttMuLlDLvoCSfFqtQBcvYSagX+cysFKsxXN
bRrUPsbSmhhzLOMv108V3QcbWHYO4vA5dvlkmyzxuRmUGz9tuz1HhvKi1vpT
KGB+nSNZ0Q7M8bJ0hWVGdID/IozAUBhqvfon+AN2cb6n9A1ZJ/1RIldPqe5X
T/PUyiUxLKI5GF8txhQjnCDK0JJoF/DDprttKQaJGpBWtX8V7eSQw9X7XzkC
xj4gZF+HEej8KHoj4q/qhQTR3EJpGg3gvpfZPPb9PPplliPuWt9zQvpPxtPF
lpDYNi385/2E5duWuBM8OM5BeQeud7PkWg3MWd/s260nLGSM1lBRgYE7wR3Q
P6Y6VMwSGB+3pUnamM1rXP109wx3LOnz3KoE3hyuofwIxPBg7vRfUpVJN7qS
8V2gmVxkB3RXntpZbDlHHIWfh7dPdgBj1DsJu7RDCz0ZT0PdhyWJNk/CoJ3j
bOv2CCL7Trm3YsJn8z6P47f1J6smd7cZ9/HO0LUjTwDdJqNvF4y8jNbkRDjR
y9tM7SGZcGcY43UrfhfCeD/o+W6bbGxF7FjK1OB6qiNt6a7YOfU4mvdStWBr
azxTTRMbT16ji0Dood26PkLBmf9rfGDbDLyQZaDiw7odo8teE6fVkiae2O4V
+uhGYjxn0ciq6e4oanKCR/dgX2FzNvoJmMfmruGYnnkUd8AC7I3HEyQY2rCF
znpWTjS2hm7WYjMKFri9jgYN7qhA87nP8lQ77Fd7g0sEElViJN58lhvdj3u8
b7f37NZ+y9TS5XhLhH6TXWgLuBbz/rnPWJ5EDWaOu/TzPPGfGB7Lb4IDVgyv
U5R22TuzjTjQlYPkr56rAQft2NbhiJ0XuEqYthip3u6kdQTlP4DmEfpWyqhQ
YqWTGA9+CoUQtiX7OY9Em4A0HsSjaIdP5MN9MKmT7d3ZcIWcMWvWLEKA1L0j
j4Td7J+3/uZPo2M9JWA7Xvtor1G4Zzx23Fg63YYf7GUY/uSLtxkdZlvYo97p
rO+Oam+BD/DNG8aDA4b7IRtJp55lz5+XeTjYE59xwis8u5NPd89qu8w+0uQs
LrJPeovGhzvvKA9J2R1PG+7+YDw3ekWUF+PcJQUdLlRQX/WWG9GhxIloCj+I
LbJD9PM4gND1744jTzJiDtEQFUOWmk8eVD7AkAT2zikgSLyl0nUm2ItDlUHN
VLk3wr5FFR7lvlDGI6pGZnOTVeP9DF8sWRSwod99npA4+1UDOFMFNqg8XH+S
DflBB3X46b/NKFgZMY9cdNeE6e6JFdErHNExS3xjZKrIG56F3D7PEwzpidJ3
qdrKg8Y/yLPWKcXxvIdax9HsFmBNVUIjPWD9IOez6b0LmuG6pkEBU3qUjWkz
pv468EW76tPFM8h429G+PrGgCaR0OkL7IanwDII+913T9SiPBtJaaT98rfsP
lEu4GGHDnAU2PfFFJ6XTBXDsgUml59M8PWABJ2P4hE2cucVDBPLL2MRHCpis
IoLGtdYziscCofEGhF17Y1D48Erg08W/pAT0s2Oymyy5epln4L3h7YgXpZ8L
ypnU2KSeDe8XSkINkCykmhY57BqFHimyjcLGA91NDdDEG145C+ot382vdx8+
orYZy5ojWRBwPq/8W3mAGrIcBnPwwioUVwC/h+/UG8+idBvb1Ynzzo/ULDe+
eVCgjb+GYMQQxg70rlOi7X23gaNKFiwId+xLWCTk+InlOELbaQCS09Caxk1J
vpxEg/QncUzdgOK0f0uYwHJlwZm8ZJpvkij0M8Z3o5LQcvyj6J6BWHZeliDR
We4IdPMWdANWCD4tJqGj0DMSo40UArbDqym3T+M8Rmr+gTAeENFw5AKreQsY
wkgCnQmbm+q59xTlbNN3um6162YSsM26oy/Vp3ncLxTKWaox+2a5IGupxMTQ
QdcZqnM8HaTGPKkYsnGsB4lrWb7PHm44znvUS4eGYeHYGHk6ekDPoF9HT2fY
TE2/AN3XArq4VpjEhCgJvzJ/TgS2HlkgScZYuTs24dLZdYY8kHUQreXgvuPK
aEX8FmIOg2vZXKGZFYJRo+aq7OhDFsUNThEA1+qbLtDY4LBp9gpxpJP3pVqS
bK8VA2kIEF5hfuCA4Xk013RwExG7LvK5YSAoeXg9IE71DWli7BC4mYtIKVfX
3EYgf1xa05KHJ5JhgKPUvSK0lk0uSNqpXdKTBDhH+WwTWwue3VQlOBuzZYvE
E1uYqFbo2MMKx8Ny7GdGlM9U/aqpnMmTFHJw2bY2tuNF7FgByad5UKJrmHtN
c/P0gqaHN4IPETnoO6K9rmOfs1kJrou1HFsUQ+/+07eVeoU9+9SY7vYt5mxm
xsrD5yeVdpZ7jXDav8DC+yzPTWI3k2bc4gPmCZILPXITo7/FXpUqlUE1mCc/
SfTms2wUS/gQVgdPm9x1jBvoiO3MxjaUC1zXBJtx8glCa9Kt0iQgixLhhUDW
EV+w+zwPdbIlUStB1qhLzx/ucr1WTS3N0kpzasNauO3sjc26QJgKw6C9iKIQ
BnDZctoPLRJAGJcQjWOK1+PxY24MGxqzA0FuSCPiUKSI2bGC9Ul2kQfSxOGb
8REwHt5snyfQHjGhy+z+DiM8zkPTCqTvomp90QVSSHRWZymHdsto9dxnW/V6
+6jAOs9DA5uUsI1leTQPuUxulmq0D9wJjz1u8UjAlpQ+tI2pY43o0Dq1QPZS
LY2JlfWa2rCOXP1AoA82QIaiT57kuUns7yV4itICwg/z+nkekxzRpbXPE0Td
ONIRq3jdZRQOlDlC46MGkOaYE9e9X0pRXJPQ4vK22/Q+PX/jGYmN64jOe78M
Abmac0IngE/v9skrDyBE3elaJzgQLY2uYivRh3Fg6+M4+AiZ0ECzTPyj6PRw
UOnwVtAqgIKnqJpi24sZ0hDjLGB7zM72GpK2zUC9LYepl7sgovcktsQ7mr1P
PRRyDcVBpxJnPU9qdhT7mA1B5ks8sOxf0zw3MmM1pz13NDcreO6xRPbTmgSe
57ly27CFCXcKHpjP7H1nx89srLHCg0SDtTcGtQ5fylUD6cvYSU49/mqTrZUB
NaTYex27esgghuv2GtAOCexBAhe7BdEfxuGqHdoc0Eau5lmeKrBgH8BYO0//
bu/ZcJ0D7EQcIJ5c0sEBtqQUFCgSk3LlJ5MxLRNyRcYi+F/EEcyxX7YJ0H1v
VthkL3MiGU0hLCdwDdod3t52f53JxA0Z0Qtqa2CemSyB6u2JnN1mHoD5wAbG
f9LIHD+Tom8shJfZX4FdHxqtwXwqBdx9lhgUFEAbqMG9EvBp4YZtKWPX+EQj
orqsSdDbH8bpYtvckIpgIfOrgd6PE1ARAmDCkOsWbdDi8E7wE/TG9KEaTIpP
4kCYD/Ponk96z/U7FqpEZPQFzkFhfJyHzFa0d55DeiG0YtXNDueBs9g8dZFF
j9iq7Z7IYR0h7jBw2cNL9hoDA0fOEXyM1V5ZSySBaJ1VpOMM23R+EaOkQ1s+
unH0+lF2+iTUgeTUoio02zuCAocvB18Q0QKaSE9qxNlghV4k/hrQHGsvAI5W
iUh11bO9LVfm1r2Q6MseR7cd5AJf/Kvg6kXl6qjHbPp/TlMnvJJ5roC9q94/
GW976JpiUsCmPCJfTtzjDiB7zrI1qz3Fy9i8TV3Tyzy1boRkUOTwbkoYIIkJ
nBn1lQNeusFbCHuNILDT7BwVcOUNJIk7AqkCXI075r+RapTYXUajiD+Wm2lg
Rpk124uZx1vkJOFmdOJVdHKB5LA/iYYCRm6DzKhCoHyeygnAuGPFGWRBdcN7
RSvjHOJrbbIVAsKNRFzXLjHTBxA4gCLesd09CtxOiusciPJQkTFWHpFzogvF
EkZGc0NbSIC6kzPiWfsO0p7nuWxjJD1m2GJX2FjOVX0abVZIV1nB2OQkykRV
0Hke44qXcpYHC11E1d9YswPkgGhQ3/CVhChTI1COYAS6z6PlmYbDz3Gm8hZ2
D+qPphXWyHb1HCHu2vl59EbB4R3jVYg8AMmkRy/E3NxyWMHJ1EZSFx3Pv1ut
dsJvjrqzKu+KRji6hBVvCPsYq9NxQJiZvTgEWL0/nU3C+jWocfhqUAbKPfIk
LcvV5r4PMIlc4lzyxVbgbVcMuTMPQHPBHTh36AnudT8A65HPsrP41CK/J6zp
dveY884i4IGr5be58CIstjbNYxQsVEYGgMjU0zxMIvOCDTczp2jGWhpSWRog
KG34rqAdBCws67zeoziUEp5k6xpf+rm4ruEh2ctmfQ728gIcNiIJMth2saY4
y63bEfiapf+NytW/qCqMPWvAjJgDqajC4a8jurBA4FYiStYbliF2sCF7DLKP
s39WRHsaAGcEawOJaYOh+TVY0Njw3UEzjAQuT/NsMgJ6GH+aOHGMp9EOj1q8
mtdhXi7JMQDhUdQ3JNckPXknjahlZpRtlj71Re7HbUatu8sDKNbxDtAnBId9
ZXsZeUesCBhh6KDDyG7oV8vuqzz/BCmB1IMv2a1MUOk7A1rfE9BCap1moyVI
A3Xh0ggULBYokRIN4rwUFQLmTgPMUm0N1Tk4ijrI2sZp/OwV4meOG0MMEIyN
TTIy2Ohgi2gdMIuqlkNKVpmj60KwhfDSOx2xFtIZQUHD9wY/oV3dqoHIOsIf
mj7PVvoINtd1voazAJ5gxqqyYGlrt21uWABtJFUhmIjfNmsZBmzQD87DpETF
s3QsX+wzAwnmc/Ui5jBmDnByfSiz0k84DfjbmEjQuev0YCXBPqhn+P7AIBg4
y73dR+wVgJoQrigPYFHqCm7zJHEM20oE7XCoqtLyjme8/Yi+BIQu47RG/qOO
CNuQ4EOVcTgZBszgyCC+aot/NoPjNowH1aDa8VboS4VsR/6Ver3OY3pECw0a
Gn4grEBki/dMPY7jrM+yKT4McxGVv/iVFHCANQcnqvQm9NYzMdhF7iyB7vmC
nDixFbxd6O0sG/nhtI4UjAoi10q9NECB+BCmT6NjFnbAWZ5QgT7GXUFiIm03
2V1s+L6AzdfSLgCoxBzewyciVUj5ECRjGaQbMNvZB4dzgr/hbUEYet5oBeIt
Fjf9VITQyGNfCrwjfBMgaH+g7S/FgoI7CHTAaPDIEL0kTjBnjEX6538Yjf6I
StA9xXEE+A0nO2hl+KGACiJrk7u5XqOqh1JWAM078MuIqFnG4PrSqQFt4pQE
la+AZ8fqdXZ5lVYcFNLiS80HfhvDCD1ELzvo0IoakGG3iyRxTLCOLrIDqmM+
GEvY+c0HCVoYfiT0oYDrfmAOkFxlO0X96qZNpAO8V4TJ8W5YnNoDOAcAXPSz
Rdcg0iEtkmRaZETDvwqYIQSkCJSEYiKGSKb0SXa6xdIiBP5RdJvDOOaTuAbZ
MAIPrBFPYPjBWP+Php/zeXZ+QzaTDa6thsE+QEXwV8KkFoLVorxIEXWbA41s
jBMyZfWtyqYRwXtOQ2HRWCuhaAi9gAEBmz4ZGAfUjl1EHZ4zKRiy1eNlYU2C
/XCs+8eD5si6FU/mNaiKTh2oCcsl1JgFt8Pudd4ODcVoS7DpzHPbEZ+W2jEF
OgAKxqcfJIKMsErUWrXE/B06QeLuQ/+Ur7PSq9xf4uqTZsMGboef2HYvucs8
975H4CG7H+e5oHt6MDj2FqoZIwGkOiKPy/5pHHBftWKTbCwIi7Rh9m3SSM+z
wx3CCRqyKNNPz+KYceDKlujTPIGCFcFtyKNNNgYbfizW+FOpoxG1rPG+ByBi
jnigvu9ZHAnrYlBrr4/zdIuow5thTTddH+tb1f5ucLar8B7iqWOgQ+VEm6gt
qLWyDpCChE02eqZGxK1nhP/A3fBnwj+jac4mN6izLMB0mWdF4BlFLCROcUJZ
groe+Ys9RQjap7udzA4R0Hqtw3gIAtIhMWpLOZxAZJii4AyB6wQ7lQlN9mfl
Hw7X8JOxnp8JDY0Wdq+cjrMn2S0au5Hs3Xl2c7uKzQCCJcW8oAd1qnsaX82z
JuxVZoPtj9wkAI6SIzP4tBQEIzEdQMXl6vVzRGbbtH86VvD1pDdAEXo8PIDF
abYTZVAyAHNohfrl6FrVZhl9Ap5mh4SGlsACMs0TxVIijtirdOan5bRgmFKX
melltIFq0wsoD5ucKSKN9Zw8yvbzEIxdNxvibHJocc8gDyZvzioWDPNwpkaP
ziLnYTc95Ff0Kk9aeFw7k7N3rFk9Pxvz/fm00HB86Cc1sxGLNJxDbJqF5jxP
mwrdCvZvV+CBCj6RZCz+/Tx4QN99flXvLfJzMZs/G7OxaRF91WaGPhyPeTW7
aRYL4OlgWSTbojuWo+EO/gy/EG/8xbSOHDWMnlI7pwY1lNBp9XF2PmbkuZ08
DRAjDX8+bSvMCD1wOMHgfo4PJem+piXjueFX0paGKFHM4w7EnRnRER1K4B+0
3WytX43Rfj2h2TfS/UZc/Y2Jv/Drvtpo74+7Z/iO/wcYGN26\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50262906]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10393],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuC"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathieuSPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathieuSPrime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30548]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->726],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathieuAndRelatedFunctions"]], "Tutorials",
 CellID->2401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3034],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MathieuFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/MathieuFunctions/MathieuS/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->577295928],

Cell[TextData[ButtonBox["Functions for Separable Coordinate Systems",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/FunctionsForSeparableCoordinateSystems"]], "MoreAbout",
 CellID->291360882],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->150041328],

Cell[TextData[ButtonBox["Mathieu and Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathieuAndRelatedFunctions"]], "MoreAbout",
 CellID->33146620],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->138640421]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MathieuS - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 59, 54.6037914}", "context" -> "System`", 
    "keywords" -> {
     "band structure calculations", "Blanch's Newton method", 
      "electron wave functions", "elliptical geometries", "Hill's equation", 
      "Mathieu function S", "MathieuS", "parametric amplifiers", "Paul traps",
       "penning traps", "Penning traps", "periodic potentials", 
      "Schro\"dinger equation", "SE", "solid-state physics"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MathieuS[a, q, z] gives the odd Mathieu function with characteristic \
value a and parameter q. ", "synonyms" -> {"Mathieu S"}, "title" -> 
    "MathieuS", "type" -> "Symbol", "uri" -> "ref/MathieuS"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5713, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->426622051]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 78983, 1806}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2487, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3110, 86, 46, 1, 70, "ObjectName",
 CellID->13758],
Cell[3159, 89, 773, 25, 70, "Usage",
 CellID->15433]
}, Open  ]],
Cell[CellGroupData[{
Cell[3969, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4447, 136, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4570, 142, 430, 16, 70, "Notes",
 CellID->29065],
Cell[5003, 160, 248, 8, 70, "Notes",
 CellID->711271909],
Cell[5254, 170, 218, 7, 70, "Notes",
 CellID->31226],
Cell[5475, 179, 201, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5713, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->426622051],
Cell[CellGroupData[{
Cell[6098, 205, 147, 5, 70, "ExampleSection",
 CellID->47270948],
Cell[6248, 212, 201, 5, 70, "ExampleText",
 CellID->164095502],
Cell[CellGroupData[{
Cell[6474, 221, 138, 4, 28, "Input",
 CellID->30685000],
Cell[6615, 227, 192, 6, 36, "Output",
 CellID->50984376]
}, Open  ]],
Cell[6822, 236, 125, 3, 70, "ExampleDelimiter",
 CellID->741042028],
Cell[CellGroupData[{
Cell[6972, 243, 274, 9, 28, "Input",
 CellID->522055755],
Cell[7249, 254, 2924, 52, 115, "Output",
 Evaluatable->False,
 CellID->151768660]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10222, 312, 216, 7, 70, "ExampleSection",
 CellID->30137],
Cell[10441, 321, 226, 5, 70, "ExampleText",
 CellID->347043095],
Cell[CellGroupData[{
Cell[10692, 330, 181, 6, 70, "Input",
 CellID->47512834],
Cell[10876, 338, 272, 7, 36, "Output",
 CellID->105294190]
}, Open  ]],
Cell[11163, 348, 125, 3, 70, "ExampleDelimiter",
 CellID->139258261],
Cell[11291, 353, 207, 5, 70, "ExampleText",
 CellID->109862149],
Cell[CellGroupData[{
Cell[11523, 362, 217, 7, 70, "Input",
 CellID->706408],
Cell[11743, 371, 252, 8, 36, "Output",
 CellID->77210032]
}, Open  ]],
Cell[12010, 382, 124, 3, 70, "ExampleDelimiter",
 CellID->96263149],
Cell[12137, 387, 112, 3, 70, "ExampleText",
 CellID->65024484],
Cell[CellGroupData[{
Cell[12274, 394, 173, 5, 70, "Input",
 CellID->179399986],
Cell[12450, 401, 247, 8, 36, "Output",
 CellID->122258830]
}, Open  ]],
Cell[12712, 412, 124, 3, 70, "ExampleDelimiter",
 CellID->88790991],
Cell[12839, 417, 228, 5, 70, "ExampleText",
 CellID->322566979],
Cell[CellGroupData[{
Cell[13092, 426, 137, 4, 70, "Input",
 CellID->120703106],
Cell[13232, 432, 221, 8, 43, "Output",
 CellID->4924127]
}, Open  ]],
Cell[13468, 443, 125, 3, 70, "ExampleDelimiter",
 CellID->627196239],
Cell[13596, 448, 347, 11, 70, "ExampleText",
 CellID->190360466],
Cell[CellGroupData[{
Cell[13968, 463, 199, 6, 70, "Input",
 CellID->634825195],
Cell[14170, 471, 430, 13, 36, "Output",
 CellID->376737930]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14649, 490, 223, 7, 70, "ExampleSection",
 CellID->28211],
Cell[14875, 499, 118, 3, 70, "ExampleText",
 CellID->371320199],
Cell[CellGroupData[{
Cell[15018, 506, 456, 15, 70, "Input",
 CellID->169079706],
Cell[15477, 523, 703, 22, 49, "Output",
 CellID->295773946]
}, Open  ]],
Cell[16195, 548, 566, 15, 70, "ExampleText",
 CellID->478229195],
Cell[CellGroupData[{
Cell[16786, 567, 756, 22, 70, "Input",
 CellID->166580877],
Cell[17545, 591, 6665, 113, 70, "Output",
 Evaluatable->False,
 CellID->75188149]
}, Open  ]],
Cell[24225, 707, 125, 3, 70, "ExampleDelimiter",
 CellID->322927007],
Cell[24353, 712, 259, 7, 70, "ExampleText",
 CellID->19883067],
Cell[24615, 721, 628, 19, 70, "Input",
 CellID->36876722],
Cell[25246, 742, 198, 5, 70, "ExampleText",
 CellID->468674505],
Cell[CellGroupData[{
Cell[25469, 751, 407, 12, 70, "Input",
 CellID->5359889],
Cell[25879, 765, 257, 8, 36, "Output",
 CellID->588881444]
}, Open  ]],
Cell[26151, 776, 253, 7, 70, "ExampleText",
 CellID->155111556],
Cell[CellGroupData[{
Cell[26429, 787, 787, 25, 70, "Input",
 CellID->16325066],
Cell[27219, 814, 17728, 295, 70, "Output",
 Evaluatable->False,
 CellID->650281951]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44996, 1115, 226, 7, 70, "ExampleSection",
 CellID->24668],
Cell[45225, 1124, 253, 7, 70, "ExampleText",
 CellID->953271091],
Cell[CellGroupData[{
Cell[45503, 1135, 164, 5, 70, "Input",
 CellID->672864365],
Cell[45670, 1142, 193, 6, 36, "Output",
 CellID->656228369]
}, Open  ]],
Cell[CellGroupData[{
Cell[45900, 1153, 220, 7, 70, "Input",
 CellID->358064807],
Cell[46123, 1162, 219, 6, 36, "Output",
 CellID->200508883]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46391, 1174, 223, 7, 70, "ExampleSection",
 CellID->7498],
Cell[46617, 1183, 221, 5, 70, "ExampleText",
 CellID->92265039],
Cell[CellGroupData[{
Cell[46863, 1192, 447, 13, 70, "Input",
 CellID->74369459],
Cell[47313, 1207, 27100, 448, 70, "Output",
 Evaluatable->False,
 CellID->50262906]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74474, 1662, 311, 9, 70, "SeeAlsoSection",
 CellID->10393],
Cell[74788, 1673, 461, 17, 70, "SeeAlso",
 CellID->30548]
}, Open  ]],
Cell[CellGroupData[{
Cell[75286, 1695, 312, 9, 70, "TutorialsSection",
 CellID->726],
Cell[75601, 1706, 165, 3, 70, "Tutorials",
 CellID->2401]
}, Open  ]],
Cell[CellGroupData[{
Cell[75803, 1714, 320, 9, 70, "RelatedLinksSection",
 CellID->3034],
Cell[76126, 1725, 186, 4, 70, "RelatedLinks"],
Cell[76315, 1731, 197, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76549, 1740, 319, 9, 70, "MoreAboutSection",
 CellID->577295928],
Cell[76871, 1751, 195, 4, 70, "MoreAbout",
 CellID->291360882],
Cell[77069, 1757, 178, 3, 70, "MoreAbout",
 CellID->150041328],
Cell[77250, 1762, 166, 3, 70, "MoreAbout",
 CellID->33146620],
Cell[77419, 1767, 145, 3, 70, "MoreAbout",
 CellID->138640421]
}, Open  ]],
Cell[77579, 1773, 27, 0, 70, "History"],
Cell[77609, 1775, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

