(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32684,       1251]
NotebookOptionsPosition[     25104,        984]
NotebookOutlinePosition[     26614,       1024]
CellTagsIndexPosition[     26528,       1019]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"], 
          "Scalars, Vectors and Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ScalarsVectorsAndMatrices"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Putting Constraints on Patterns\"\>", 
       2->"\<\"Scalars, Vectors and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HermitianMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/HermitianMatrixQ"], 
          "PositiveDefiniteMatrixQ" :> 
          Documentation`HelpLookup["paclet:ref/PositiveDefiniteMatrixQ"], 
          "VectorQ" :> Documentation`HelpLookup["paclet:ref/VectorQ"], 
          "ArrayQ" :> Documentation`HelpLookup["paclet:ref/ArrayQ"], 
          "ArrayDepth" :> Documentation`HelpLookup["paclet:ref/ArrayDepth"], 
          "Dimensions" :> 
          Documentation`HelpLookup["paclet:ref/Dimensions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"HermitianMatrixQ\"\>", 
       2->"\<\"PositiveDefiniteMatrixQ\"\>", 3->"\<\"VectorQ\"\>", 
       4->"\<\"ArrayQ\"\>", 5->"\<\"ArrayDepth\"\>", 
       6->"\<\"Dimensions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Parts of Matrices\"\>", 
       4->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MatrixQ", "ObjectName",
 CellID->28630],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MatrixQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MatrixQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a list of lists or a two\[Hyphen]dimensional ",
     Cell[BoxData[
      ButtonBox["SparseArray",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
     " object that can represent a matrix, and gives ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MatrixQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MatrixQ"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " only if ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " when applied to each of the matrix elements in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18717]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " only if ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a list, and each of its elements is a list of the same length, \
containing no elements that are themselves lists, or is a \
two\[Hyphen]dimensional ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->23043],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixQ"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["NumberQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberQ"]}], "]"}]], "InlineFormula"],
 " tests whether ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is a numerical matrix. "
}], "Notes",
 CellID->31376]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->527998584],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->51811018],

Cell["Test of whether an object is a matrix:", "ExampleText",
 CellID->108649090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22590046],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->759989151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "a"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "b"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->257736663],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621124565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->273813849],

Cell["These are not matrices:", "ExampleText",
 CellID->10903167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "1", "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126477014],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->766500781]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->169391414],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247907682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242134064],

Cell["Use tests to generalize and specialize:", "ExampleText",
 CellID->39457903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", "ListQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26960864],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63531515]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", "MachineNumberQ"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253983874],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->323722940]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30664],

Cell["Test if a matrix has positive (real) entries:", "ExampleText",
 CellID->228531182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}]}], "}"}], ",", "Positive"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206047948],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173168521]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", 
       RowBox[{"4", "+", 
        RowBox[{"5", "I"}]}]}], "}"}]}], "}"}], ",", "Positive"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318660142],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261719272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->613002528],

Cell["Test if a matrix has real numeric entries:", "ExampleText",
 CellID->563468179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pi", ",", 
       RowBox[{"Sin", "[", "1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "2", "]"}], ",", "E"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Im", "[", "#", "]"}], "\[Equal]", "0"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273335696],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38499170]
}, Open  ]],

Cell["Faster test for real-valued numbers:", "ExampleText",
 CellID->356431287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "/", "4"}], ",", "5`20"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"NumberQ", "[", "#", "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"MatchQ", "[", 
       RowBox[{"#", ",", "_Complex"}], "]"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137537818],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6110358]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12212],

Cell["Define a function that only evaluates for explicit matrices:", \
"ExampleText",
 CellID->280474530],

Cell[BoxData[
 RowBox[{
  RowBox[{"hpart", "[", 
   RowBox[{"m_", "?", "MatrixQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"m", "+", 
     RowBox[{"ConjugateTranspose", "[", "m", "]"}]}], ")"}], "/", 
   "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99259542],

Cell["This represents the Hermitian part of a matrix symbolically:", \
"ExampleText",
 CellID->119904606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hpart", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387971996],

Cell[BoxData[
 RowBox[{"hpart", "[", "a", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->436262565]
}, Open  ]],

Cell["This gets the Hermitian part explicitly:", "ExampleText",
 CellID->274582463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"hpart", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"2", "I"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "I"}], ",", "4"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->674431885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", 
      FractionBox["\[ImaginaryI]", "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["\[ImaginaryI]", "2"], ",", "4"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{126, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10330716]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->117701076],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->327396648]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21100],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixQ"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["ArrayQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->599492953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371158469],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9252636886737409`", ",", "0.5221176593545447`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.1885812639080069`", ",", "0.9210654019973841`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24125796]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayQ", "[", 
    RowBox[{"m", ",", "2"}], "]"}], ",", 
   RowBox[{"MatrixQ", "[", "m", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106621055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59358925]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayQ", "[", 
    RowBox[{"m", ",", "2", ",", "MachineNumberQ"}], "]"}], ",", 
   RowBox[{"MatrixQ", "[", 
    RowBox[{"m", ",", "MachineNumberQ"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37529934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->737160467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayQ", "[", 
    RowBox[{"m", ",", "2", ",", "IntegerQ"}], "]"}], ",", 
   RowBox[{"MatrixQ", "[", 
    RowBox[{"m", ",", "IntegerQ"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->178405380],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "False"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->95148630]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->621901661],

Cell["A matrix is made up of vectors of equal length:", "ExampleText",
 CellID->54470389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201991780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.7974704877026426`", ",", "0.5513267926164491`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5519768041164248`", ",", "0.10370552613733675`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.18865672037880432`", ",", "0.7347068528092626`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233997493]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vecs", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"VectorQ", ",", "m"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33849120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->622169935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lens", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"Length", ",", "m"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27824881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "2", ",", "2"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->294658721]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"And", ",", 
   RowBox[{"Append", "[", 
    RowBox[{"vecs", ",", 
     RowBox[{"Apply", "[", 
      RowBox[{"Equal", ",", "lens"}], "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->168562455],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->403166659]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", "m", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->515030676],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->63422183]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14171],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HermitianMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HermitianMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PositiveDefiniteMatrixQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PositiveDefiniteMatrixQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VectorQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VectorQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dimensions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dimensions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26792]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25314],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->16626],

Cell[TextData[ButtonBox["Scalars, Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ScalarsVectorsAndMatrices"]], "Tutorials",
 CellID->17117]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->365498952],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->280796301],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->254100793],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->128549969],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->368770814]
}, Open  ]],

Cell["New in 1  |  Last modified in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MatrixQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 5.5884476}", "context" -> "System`", 
    "keywords" -> {
     "list as matrix", "numerical matrices", "testing for matrices", 
      "matrix element test", "matrix type test"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MatrixQ[expr] gives True if expr is a list of lists or a two-dimensional \
SparseArray object that can represent a matrix, and gives False otherwise. \
MatrixQ[expr, test] gives True only if test yields True when applied to each \
of the matrix elements in expr. ", "synonyms" -> {"matrix q"}, "title" -> 
    "MatrixQ", "type" -> "Symbol", "uri" -> "ref/MatrixQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7258, 227, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->527998584]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26385, 1012}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3014, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3637, 95, 45, 1, 70, "ObjectName",
 CellID->28630],
Cell[3685, 98, 1877, 60, 70, "Usage",
 CellID->18717]
}, Open  ]],
Cell[CellGroupData[{
Cell[5599, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6077, 180, 708, 24, 70, "Notes",
 CellID->23043],
Cell[6788, 206, 433, 16, 70, "Notes",
 CellID->31376]
}, Closed]],
Cell[CellGroupData[{
Cell[7258, 227, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->527998584],
Cell[CellGroupData[{
Cell[7643, 241, 147, 5, 70, "ExampleSection",
 CellID->51811018],
Cell[7793, 248, 81, 1, 70, "ExampleText",
 CellID->108649090],
Cell[CellGroupData[{
Cell[7899, 253, 251, 9, 28, "Input",
 CellID->22590046],
Cell[8153, 264, 161, 5, 36, "Output",
 CellID->759989151]
}, Open  ]],
Cell[CellGroupData[{
Cell[8351, 274, 367, 13, 28, "Input",
 CellID->257736663],
Cell[8721, 289, 161, 5, 36, "Output",
 CellID->621124565]
}, Open  ]],
Cell[8897, 297, 125, 3, 70, "ExampleDelimiter",
 CellID->273813849],
Cell[9025, 302, 65, 1, 70, "ExampleText",
 CellID->10903167],
Cell[CellGroupData[{
Cell[9115, 307, 226, 8, 70, "Input",
 CellID->126477014],
Cell[9344, 317, 162, 5, 36, "Output",
 CellID->766500781]
}, Open  ]],
Cell[CellGroupData[{
Cell[9543, 327, 220, 7, 70, "Input",
 CellID->169391414],
Cell[9766, 336, 162, 5, 36, "Output",
 CellID->247907682]
}, Open  ]],
Cell[9943, 344, 125, 3, 70, "ExampleDelimiter",
 CellID->242134064],
Cell[10071, 349, 81, 1, 70, "ExampleText",
 CellID->39457903],
Cell[CellGroupData[{
Cell[10177, 354, 253, 9, 70, "Input",
 CellID->26960864],
Cell[10433, 365, 160, 5, 36, "Output",
 CellID->63531515]
}, Open  ]],
Cell[CellGroupData[{
Cell[10630, 375, 258, 9, 70, "Input",
 CellID->253983874],
Cell[10891, 386, 161, 5, 36, "Output",
 CellID->323722940]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11101, 397, 216, 7, 70, "ExampleSection",
 CellID->30664],
Cell[11320, 406, 88, 1, 70, "ExampleText",
 CellID->228531182],
Cell[CellGroupData[{
Cell[11433, 411, 291, 11, 70, "Input",
 CellID->206047948],
Cell[11727, 424, 161, 5, 36, "Output",
 CellID->173168521]
}, Open  ]],
Cell[CellGroupData[{
Cell[11925, 434, 343, 13, 70, "Input",
 CellID->318660142],
Cell[12271, 449, 162, 5, 36, "Output",
 CellID->261719272]
}, Open  ]],
Cell[12448, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->613002528],
Cell[12576, 462, 85, 1, 70, "ExampleText",
 CellID->563468179],
Cell[CellGroupData[{
Cell[12686, 467, 438, 16, 70, "Input",
 CellID->273335696],
Cell[13127, 485, 160, 5, 36, "Output",
 CellID->38499170]
}, Open  ]],
Cell[13302, 493, 79, 1, 70, "ExampleText",
 CellID->356431287],
Cell[CellGroupData[{
Cell[13406, 498, 488, 17, 70, "Input",
 CellID->137537818],
Cell[13897, 517, 159, 5, 36, "Output",
 CellID->6110358]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14105, 528, 223, 7, 70, "ExampleSection",
 CellID->12212],
Cell[14331, 537, 105, 2, 70, "ExampleText",
 CellID->280474530],
Cell[14439, 541, 279, 10, 70, "Input",
 CellID->99259542],
Cell[14721, 553, 105, 2, 70, "ExampleText",
 CellID->119904606],
Cell[CellGroupData[{
Cell[14851, 559, 101, 3, 70, "Input",
 CellID->387971996],
Cell[14955, 564, 189, 6, 36, "Output",
 CellID->436262565]
}, Open  ]],
Cell[15159, 573, 83, 1, 70, "ExampleText",
 CellID->274582463],
Cell[CellGroupData[{
Cell[15267, 578, 294, 11, 70, "Input",
 CellID->674431885],
Cell[15564, 591, 397, 15, 51, "Output",
 CellID->10330716]
}, Open  ]],
Cell[CellGroupData[{
Cell[15998, 611, 112, 3, 70, "Input",
 CellID->117701076],
Cell[16113, 616, 161, 5, 36, "Output",
 CellID->327396648]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16323, 627, 233, 7, 70, "ExampleSection",
 CellID->21100],
Cell[16559, 636, 318, 12, 70, "ExampleText",
 CellID->599492953],
Cell[CellGroupData[{
Cell[16902, 652, 204, 7, 70, "Input",
 CellID->371158469],
Cell[17109, 661, 376, 12, 36, "Output",
 CellID->24125796]
}, Open  ]],
Cell[CellGroupData[{
Cell[17522, 678, 209, 7, 70, "Input",
 CellID->106621055],
Cell[17734, 687, 208, 7, 36, "Output",
 CellID->59358925]
}, Open  ]],
Cell[CellGroupData[{
Cell[17979, 699, 269, 8, 70, "Input",
 CellID->37529934],
Cell[18251, 709, 209, 7, 36, "Output",
 CellID->737160467]
}, Open  ]],
Cell[CellGroupData[{
Cell[18497, 721, 258, 8, 70, "Input",
 CellID->178405380],
Cell[18758, 731, 211, 7, 36, "Output",
 CellID->95148630]
}, Open  ]],
Cell[18984, 741, 125, 3, 70, "ExampleDelimiter",
 CellID->621901661],
Cell[19112, 746, 89, 1, 70, "ExampleText",
 CellID->54470389],
Cell[CellGroupData[{
Cell[19226, 751, 204, 7, 70, "Input",
 CellID->201991780],
Cell[19433, 760, 478, 15, 36, "Output",
 CellID->233997493]
}, Open  ]],
Cell[CellGroupData[{
Cell[19948, 780, 154, 5, 70, "Input",
 CellID->33849120],
Cell[20105, 787, 223, 7, 36, "Output",
 CellID->622169935]
}, Open  ]],
Cell[CellGroupData[{
Cell[20365, 799, 153, 5, 70, "Input",
 CellID->27824881],
Cell[20521, 806, 213, 7, 36, "Output",
 CellID->294658721]
}, Open  ]],
Cell[CellGroupData[{
Cell[20771, 818, 257, 8, 70, "Input",
 CellID->168562455],
Cell[21031, 828, 161, 5, 36, "Output",
 CellID->403166659]
}, Open  ]],
Cell[CellGroupData[{
Cell[21229, 838, 103, 3, 70, "Input",
 CellID->515030676],
Cell[21335, 843, 160, 5, 36, "Output",
 CellID->63422183]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21556, 855, 311, 9, 70, "SeeAlsoSection",
 CellID->14171],
Cell[21870, 866, 1479, 53, 70, "SeeAlso",
 CellID->26792]
}, Open  ]],
Cell[CellGroupData[{
Cell[23386, 924, 314, 9, 70, "TutorialsSection",
 CellID->25314],
Cell[23703, 935, 170, 3, 70, "Tutorials",
 CellID->16626],
Cell[23876, 940, 165, 3, 70, "Tutorials",
 CellID->17117]
}, Open  ]],
Cell[CellGroupData[{
Cell[24078, 948, 319, 9, 70, "MoreAboutSection",
 CellID->365498952],
Cell[24400, 959, 144, 3, 70, "MoreAbout",
 CellID->280796301],
Cell[24547, 964, 163, 3, 70, "MoreAbout",
 CellID->254100793],
Cell[24713, 969, 144, 3, 70, "MoreAbout",
 CellID->128549969],
Cell[24860, 974, 149, 3, 70, "MoreAbout",
 CellID->368770814]
}, Open  ]],
Cell[25024, 980, 50, 0, 70, "History"],
Cell[25077, 982, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

