(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     82984,       2393]
NotebookOptionsPosition[     72561,       2023]
NotebookOutlinePosition[     73933,       2062]
CellTagsIndexPosition[     73847,       2057]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Ordering in Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/OrderingInLists"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"], 
          "Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Numerical Functions\"\>", 3->"\<\"Ordering in Lists\"\>", 
       4->"\<\"Piecewise Functions\"\>", 
       5->"\<\"Basic Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Min" :> Documentation`HelpLookup["paclet:ref/Min"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"], "Maximize" :> 
          Documentation`HelpLookup["paclet:ref/Maximize"], "FindMaximum" :> 
          Documentation`HelpLookup["paclet:ref/FindMaximum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Min\"\>", 2->"\<\"Ordering\"\>", 
       3->"\<\"Maximize\"\>", 4->"\<\"FindMaximum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Math & Counting Operations on Lists\"\>", 
       2->"\<\"Mathematical Functions\"\>", 3->"\<\"Numerical Data\"\>", 
       4->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Max", "ObjectName",
 CellID->30323],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Max",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Max"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the numerically largest of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Max",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Max"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields the largest element of any of the lists. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " yields a definite result if all its arguments are real numbers. "
}], "Notes",
 CellID->15948],

Cell[TextData[{
 "In other cases, ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " carries out some simplifications. "
}], "Notes",
 CellID->24395],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"], "[", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"-", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25197],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->4508]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41165489],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->320026520],

Cell["Maximum of two numbers:", "ExampleText",
 CellID->8965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"9", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18023],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114568830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11715],

Cell["Maximum of a list:", "ExampleText",
 CellID->20253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"{", 
   RowBox[{"4", ",", "1", ",", "7", ",", "2"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31805],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683850135]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32145],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " works with exact numeric quantities:"
}], "ExampleText",
 CellID->21840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"{", 
   RowBox[{"Pi", ",", "E", ",", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->833],

Cell[BoxData["\[Pi]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599668370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " effectively flattens out all lists:"
}], "ExampleText",
 CellID->10968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23994],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30794027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13885],

Cell["Basic symbolic simplification is done automatically:", "ExampleText",
 CellID->348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"x", ",", "y", ",", 
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18281],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67521354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16256],

Cell[TextData[{
 "Simplify a symbolic ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"1", "-", "x"}], ",", "x", ",", 
    RowBox[{"1", "+", "x"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10872],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"1", "-", "x"}], ",", 
   RowBox[{"1", "+", "x"}]}], "]"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411677728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23901],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10635],

Cell[BoxData[
 RowBox[{"1", "+", 
  SqrtBox["2"]}]], "Output",
 ImageSize->{48, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10524815]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", 
      RowBox[{"a", "-", "x"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32471],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V01uEzEUdsYOCT9tQbQl7apEbFBXRUhIwJIWWHCIUFVqF4iodBHBIuoJ
sswRsswROEKOkWOYeTPP08c3bzyZUGopY/v5s/29Hz87XwZX52ffBlcXp4OD
j5eD4fnF6Y+Dk++Xqci2jDHX6e+oZ9K2T1vZ79r7tJZfS183Go1+Z2W5XP68
kdvxeOyzYu6ln3a6xCbXba6fZThaO8c5lu+kNYkt96lODDdMXpK06bgu79gW
KxP6SSYsdmKpA9Q+8LEwvhcZ1/pJ4Ac61vPtCkvJ2YjrCQs1Zlqyx3pcqflY
mwkY9DZypubu2rzbK8cCarlVwwvx6JONhvO3FXwSolH3iS5VzxmdiafKDo6j
xIlzFMYIugUY9GjCLDkoTD4SIjzhmbZYHLntqXo8knNKoz0epbxh3A2XCpuW
9twXusVPPzUxPolbJ8Rkae1DoTXaSfZ3GXeornKUuU1qln8/VKNLehyr2F93
Kn0AWveh/1mddR9QL6D/SZ3VBRStQkbpgDzcMujnIO+LcarDLZWfrdyP0+l0
NptpXB9CH3fHDFg3nule8i3mmq6KkoyrrRuyZJU9bocxWZHiHXe3guNwOJxM
JrdhVavoo2HI15RAuswOY0jPp4hqyg5zgXq/RvC4n/6KCRZHdGstncI9oL08
HEdFcUqc5EIdugstc8JcSs9K4qTzwkjAjILZecOL95/kWaT2UPqq1XSP464h
XnogxzscWeCt8NzH7saTmtXCDftypdmvVNQxr/FaHb3b26KJlPwcy+5v/d9Z
vBO1NL716k7we6/FDsZq5OVW+V9o1SysMyDeSbDKijs31d2ydUM2KLL6f9oP
o/7Nv2nu5vP5OCuLxWIT1g5Z7p3PowXPfcyjO4D9GsFuM9szL6My//dsWn8A
cXYUWw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{129, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75776370]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "->", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8343],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159274675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28233],

Cell[TextData[{
 "Reduce inequalities involving ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->3995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"Sin", "[", "x", "]"}], ",", 
        RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ">", "0"}], ",", 
     RowBox[{"0", "<", "x", "<", "20"}]}], "}"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->29171],

Cell[BoxData[
 RowBox[{
  RowBox[{"0", "<", "x", "<", "\[Pi]"}], "||", 
  RowBox[{
   FractionBox[
    RowBox[{"3", " ", "\[Pi]"}], "2"], "<", "x", "<", 
   RowBox[{"3", " ", "\[Pi]"}]}], "||", 
  RowBox[{
   FractionBox[
    RowBox[{"7", " ", "\[Pi]"}], "2"], "<", "x", "<", 
   RowBox[{"5", " ", "\[Pi]"}]}], "||", 
  RowBox[{
   FractionBox[
    RowBox[{"11", " ", "\[Pi]"}], "2"], "<", "x", "<", "20"}]}]], "Output",
 ImageSize->{342, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20043281]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28942],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " works on sparse arrays:"
}], "ExampleText",
 CellID->18011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "->", "x"}], ",", 
      RowBox[{"2", "->", "y"}]}], "}"}], ",", "10"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7879],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"0", ",", "x", ",", "y"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->459317267]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->493827067],

Cell["Use in bounds of iterator variables:", "ExampleText",
 CellID->21282401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", " ", "j", " ", "k"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"j", ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", " ", 
     RowBox[{"Max", "[", 
      RowBox[{"i", ",", " ", "j"}], "]"}], ",", " ", "3"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274576424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", "9", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "12"}], "}"}], ",", 
     RowBox[{"{", "18", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "9", "}"}], ",", 
     RowBox[{"{", "18", "}"}], ",", 
     RowBox[{"{", "27", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131684247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3224277],

Cell["Cumulative maxima:", "ExampleText",
 CellID->402754535],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rest", "[", 
  RowBox[{"FoldList", "[", 
   RowBox[{"Max", ",", "0", ",", 
    RowBox[{"{", 
     RowBox[{
     "4", ",", "2", ",", "8", ",", "3", ",", "9", ",", "12", ",", "11", ",", 
      "18", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409414005],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "4", ",", "8", ",", "8", ",", "9", ",", "12", ",", "12", ",", 
   "18", ",", "18"}], "}"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73767247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235686175],

Cell["Find the highest point of a plotted curve:", "ExampleText",
 CellID->643055140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "3", "]"}], " ", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"20", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90907305],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407118574]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Last", "/@", 
   RowBox[{"Level", "[", 
    RowBox[{
     RowBox[{"Cases", "[", 
      RowBox[{"%", ",", "_Line", ",", "Infinity"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "2"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->50413500],

Cell[BoxData["1.9921974754593537`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78485636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329221519],

Cell["Mean of the length ratio of a randomly broken stick:", "ExampleText",
 CellID->906197234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", 
      RowBox[{"1", "-", "x"}]}], "]"}], "/", 
    RowBox[{"Max", "[", 
     RowBox[{"x", ",", " ", 
      RowBox[{"1", "-", "x"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241087390],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"Log", "[", "2", "]"}]}]}]], "Output",
 ImageSize->{84, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23658782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->378876340],

Cell["\<\
R\[Hyphen]function-based solid modeling:\
\>", "ExampleText",
 CellID->76361876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Max", "[", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "+", 
        RowBox[{"y", " ", "z"}], "+", 
        RowBox[{"y", "^", "3"}]}], "]"}], ",", " ", 
      RowBox[{
       RowBox[{"x", "  ", "z"}], "+", 
       RowBox[{"y", " ", 
        RowBox[{"Max", "[", 
         RowBox[{
          RowBox[{"y", "^", "2"}], "-", "z"}], "]"}]}]}]}], "]"}], ">", "0"}],
    ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", " ", 
     RowBox[{"-", "3"}], ",", " ", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->302679551],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162547514]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14161],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->476154913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"z", ",", "y"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5906],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279519181]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Max", "[", 
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6188],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVz1SAjEUDrsbFlFEKdQSa/UMaiFWHkCtGMYZHUfdQQs6am2w4wiUHMEj
cAyOEZPdF8i+vMSIjmaGTfJe3v/Lt8tF9+X25qH7ctfrts/73ez2rvfc7jz1
JSmuMMbe5e9gj8m1kKv89y6EnM1nrJ7JYDD4yMd8Pn9d0uPhcCjywarywaWK
hpxjVvA5zBGDBStGJJeJnC+dmpgSFXoomc381IIKUu59BHZM2jVpL0WnmiGW
LP/CbNXQqaCoSFvcn79kqYOREan8JO5ILKrbFieqE4GFwkQ+gKI5SpMSuCL1
7lgx4PzeO+VSeeiB5L79KVXlRoXQhvnQmL/ujH20P0L7gyAt6yjrW4hfRfsa
VCUV5VtbqqlBw/Kq01Q/cERfE0tU0LUcj8eTyURzI8COctW3gVODOb+rVm9y
Sy62KFrDFqmhathx3Ajwms61RijtI86B4teBz90x8MVp07JFrSLN+hbiaui8
0ohqRpVl2Wg0WkRVylwDtGxbHN0ldFWwNwnap2S1cXd+VZWwt8eGZasZ5PNq
kdE+NC0fqNsXGqfql7iMsEaP6bvaIE/RsetqcmO2ZVWXc+c9on09Js/SVFrD
CfhyKkwc+V98fxQFnu+R3EyUa7vrrKJZL4zXOts/xekY6cU3jYOd1Jtf+8vC
Rmx/b62O37btFuiso1g8XzXkt18EXruwWy1/F7tNSxjL/W+6sChayPuf4/RC
a6kCunvXvuFrcA9Zb5pfwuWSXhrF/Pky4kqm0+kwH7PZLBFhd9lvk6PZlLbR
GH/v+Xr/jOQdeyQ6gkLd4n8hq3wCJZFdlA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{144, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95532745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->921798116],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->595017756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{"x", ",", " ", "y"}], "]"}], "-", 
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{"-", "x"}], ",", " ", 
     RowBox[{"-", "y"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->514788120],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydVdtKAzEQnb1ktxWtImotPlhfRb9BQVTwAv2FpQjtgyi1/x8nt22cnC1r
A5vJ3M7ckva9WS8+Ppv1ct5Mn1fN92I5/5k+fa1YVGRENOPv4pz4rPlkv5nW
TC95L5m9tdyV2QujtYturLTg3QgV05xp7mktrCvBj7yf8VeeGj97ILdyH1+1
kRLEcsMTDYCFwTwScokk+VBHLKthDnVUrQqZej31jaxa3nv9L/ZQyFXSl8Od
s2hr2qH7JURFuZgqsHUOpTgjeQMPtLthDjqskfAK1pGVwAk3vIJRr5M+yOmN
O/1qZidQ+2KlIYO3lottXrdIMZ6UPmj3vgqofQSdwvdA+fbFXTsFfD+0jnn/
6fE4kVRw2sNohvgFoRc18fQs0lMnStevTkCpYWaDpALcEfm6yx69OIFd3OAb
uD0wj23zO4ZVZJbZh/HuLA2v8N5y7n+Fsl8GJi5E\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{80, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251154270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Min", "[", 
     RowBox[{"x", " ", ",", "y"}], "]"}], "-", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", 
       RowBox[{"2", "y"}], "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "y"}], ")"}], "^", "2"}], "]"}]}], ")"}], "/", 
     "2"}]}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", "Reals"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->689558348],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["y", "2"]}]], "Output",
 ImageSize->{23, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->735331949]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81306443],

Cell[TextData[{
 "Maximize a function containing ",
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->219261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"Max", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"2", "x"}], "+", "2"}], ",", " ", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"x", "^", "4"}]}], "+", 
      RowBox[{"3", " ", "x"}], "+", "2"}]}], "]"}], ",", " ", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227220823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", "+", 
    RowBox[{"3", " ", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "-", 
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], "4"]}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{497, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598266611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->521447580],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " can be differentiated:"
}], "ExampleText",
 CellID->25118721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Max", "'"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191578631],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132382669]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Derivative", "[", 
   RowBox[{"1", ",", " ", "0"}], "]"}], "[", "Max", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->277402001],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVNsOgjAMLZdxUSHEF33ka/TJbyCEkMCD0SD/jx0rl3SDGEOMJGvX0649
a4Fb3lblPW/rIk+vTf6s6uKVXh4NQo4FACWu0xlw3+GuX2XXoXZQOmhmowXS
7Prnj1EPhUDzIA13wlWk9MSLHm+mZcoAtQ0UoA6A1W9t8uxY9T0KD02X4RHh
8hyIEVdp+3rzaH85SuNNOWenQ2brnRAsQtC9XS2S32PoyApDQkep+G3AUp8b
jwiJnTCy81m06h5/f4INePF5eqtd+x0vXolP18xvmPlnvL77AhIjGhkr+sRH
v59LnsTokSmOpGNj5mxDdPp3qv8pWG/Tm9VD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->137425652]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32719],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Max",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Max"]], "InlineFormula"],
 " flattens lists, rather than being ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5224],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->494811282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->102050560],

Cell["\<\
The one\[Hyphen]argument form evaluates for any argument:\
\>", "ExampleText",
 CellID->101776815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "I", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17770597],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617141076]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3202],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Maximize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Maximize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMaximum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMaximum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22908],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->17411],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->13993],

Cell[TextData[ButtonBox["Ordering in Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OrderingInLists"]], "Tutorials",
 CellID->581],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->869807265],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->289]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->7665],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Maximum.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Max/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Max"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->595933420],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->463254124],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->893241482],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->323622292],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->204457071]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Max - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 8.6822768}", "context" -> "System`", 
    "keywords" -> {
     "finding maximal element in lists", "highest", "largest", 
      "maximal element", "maximum", "supremum"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Max[x_1, x_2, ...] yields the numerically largest of the x_i. Max[{x_1, \
x_2, ...}, {y_1, ...}, ...] yields the largest element of any of the lists. ",
     "synonyms" -> {}, "title" -> "Max", "type" -> "Symbol", "uri" -> 
    "ref/Max"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7046, 225, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41165489]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 73705, 2050}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3129, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3752, 96, 41, 1, 70, "ObjectName",
 CellID->30323],
Cell[3796, 99, 1611, 52, 70, "Usage",
 CellID->11153]
}, Open  ]],
Cell[CellGroupData[{
Cell[5444, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5922, 173, 222, 7, 70, "Notes",
 CellID->15948],
Cell[6147, 182, 213, 8, 70, "Notes",
 CellID->24395],
Cell[6363, 192, 337, 14, 70, "Notes",
 CellID->25197],
Cell[6703, 208, 306, 12, 70, "Notes",
 CellID->4508]
}, Closed]],
Cell[CellGroupData[{
Cell[7046, 225, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41165489],
Cell[CellGroupData[{
Cell[7430, 239, 148, 5, 70, "ExampleSection",
 CellID->320026520],
Cell[7581, 246, 61, 1, 70, "ExampleText",
 CellID->8965],
Cell[CellGroupData[{
Cell[7667, 251, 118, 4, 28, "Input",
 CellID->18023],
Cell[7788, 257, 158, 5, 36, "Output",
 CellID->114568830]
}, Open  ]],
Cell[7961, 265, 121, 3, 70, "ExampleDelimiter",
 CellID->11715],
Cell[8085, 270, 57, 1, 70, "ExampleText",
 CellID->20253],
Cell[CellGroupData[{
Cell[8167, 275, 162, 5, 70, "Input",
 CellID->31805],
Cell[8332, 282, 158, 5, 36, "Output",
 CellID->683850135]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8539, 293, 216, 7, 70, "ExampleSection",
 CellID->32145],
Cell[8758, 302, 200, 7, 70, "ExampleText",
 CellID->21840],
Cell[CellGroupData[{
Cell[8983, 313, 184, 6, 70, "Input",
 CellID->833],
Cell[9170, 321, 162, 5, 36, "Output",
 CellID->599668370]
}, Open  ]],
Cell[9347, 329, 121, 3, 70, "ExampleDelimiter",
 CellID->26900],
Cell[9471, 334, 199, 7, 70, "ExampleText",
 CellID->10968],
Cell[CellGroupData[{
Cell[9695, 345, 236, 8, 70, "Input",
 CellID->23994],
Cell[9934, 355, 157, 5, 36, "Output",
 CellID->30794027]
}, Open  ]],
Cell[10106, 363, 121, 3, 70, "ExampleDelimiter",
 CellID->13885],
Cell[10230, 368, 89, 1, 70, "ExampleText",
 CellID->348],
Cell[CellGroupData[{
Cell[10344, 373, 184, 6, 70, "Input",
 CellID->18281],
Cell[10531, 381, 219, 7, 36, "Output",
 CellID->67521354]
}, Open  ]],
Cell[10765, 391, 121, 3, 70, "ExampleDelimiter",
 CellID->16256],
Cell[10889, 396, 189, 8, 70, "ExampleText",
 CellID->29910],
Cell[CellGroupData[{
Cell[11103, 408, 214, 7, 70, "Input",
 CellID->10872],
Cell[11320, 417, 259, 9, 36, "Output",
 CellID->411677728]
}, Open  ]],
Cell[11594, 429, 121, 3, 70, "ExampleDelimiter",
 CellID->23901],
Cell[11718, 434, 201, 8, 70, "ExampleText",
 CellID->12306],
Cell[CellGroupData[{
Cell[11944, 446, 306, 10, 70, "Input",
 CellID->10635],
Cell[12253, 458, 191, 7, 38, "Output",
 CellID->10524815]
}, Open  ]],
Cell[CellGroupData[{
Cell[12481, 470, 299, 10, 70, "Input",
 CellID->32471],
Cell[12783, 482, 1134, 23, 70, "Output",
 Evaluatable->False,
 CellID->75776370]
}, Open  ]],
Cell[13932, 508, 120, 3, 70, "ExampleDelimiter",
 CellID->7137],
Cell[CellGroupData[{
Cell[14077, 515, 366, 12, 70, "Input",
 CellID->8343],
Cell[14446, 529, 2518, 45, 70, "Output",
 Evaluatable->False,
 CellID->159274675]
}, Open  ]],
Cell[16979, 577, 121, 3, 70, "ExampleDelimiter",
 CellID->28233],
Cell[17103, 582, 198, 8, 70, "ExampleText",
 CellID->3995],
Cell[CellGroupData[{
Cell[17326, 594, 369, 13, 70, "Input",
 CellID->29171],
Cell[17698, 609, 550, 18, 51, "Output",
 CellID->20043281]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18297, 633, 239, 7, 70, "ExampleSection",
 CellID->28942],
Cell[18539, 642, 187, 7, 70, "ExampleText",
 CellID->18011],
Cell[CellGroupData[{
Cell[18751, 653, 264, 9, 70, "Input",
 CellID->7879],
Cell[19018, 664, 220, 7, 36, "Output",
 CellID->459317267]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19287, 677, 227, 7, 70, "ExampleSection",
 CellID->493827067],
Cell[19517, 686, 78, 1, 70, "ExampleText",
 CellID->21282401],
Cell[CellGroupData[{
Cell[19620, 691, 438, 14, 70, "Input",
 CellID->274576424],
Cell[20061, 707, 747, 26, 36, "Output",
 CellID->131684247]
}, Open  ]],
Cell[20823, 736, 123, 3, 70, "ExampleDelimiter",
 CellID->3224277],
Cell[20949, 741, 61, 1, 70, "ExampleText",
 CellID->402754535],
Cell[CellGroupData[{
Cell[21035, 746, 309, 9, 70, "Input",
 CellID->409414005],
Cell[21347, 757, 284, 9, 36, "Output",
 CellID->73767247]
}, Open  ]],
Cell[21646, 769, 125, 3, 70, "ExampleDelimiter",
 CellID->235686175],
Cell[21774, 774, 85, 1, 70, "ExampleText",
 CellID->643055140],
Cell[CellGroupData[{
Cell[21884, 779, 358, 12, 70, "Input",
 CellID->90907305],
Cell[22245, 793, 9489, 160, 70, "Output",
 Evaluatable->False,
 CellID->407118574]
}, Open  ]],
Cell[CellGroupData[{
Cell[31771, 958, 314, 10, 70, "Input",
 CellID->50413500],
Cell[32088, 970, 175, 5, 36, "Output",
 CellID->78485636]
}, Open  ]],
Cell[32278, 978, 125, 3, 70, "ExampleDelimiter",
 CellID->329221519],
Cell[32406, 983, 95, 1, 70, "ExampleText",
 CellID->906197234],
Cell[CellGroupData[{
Cell[32526, 988, 386, 13, 70, "Input",
 CellID->241087390],
Cell[32915, 1003, 251, 9, 36, "Output",
 CellID->23658782]
}, Open  ]],
Cell[33181, 1015, 125, 3, 70, "ExampleDelimiter",
 CellID->378876340],
Cell[33309, 1020, 90, 3, 70, "ExampleText",
 CellID->76361876],
Cell[CellGroupData[{
Cell[33424, 1027, 877, 29, 70, "Input",
 CellID->302679551],
Cell[34304, 1058, 23596, 391, 70, "Output",
 Evaluatable->False,
 CellID->162547514]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57949, 1455, 231, 7, 70, "ExampleSection",
 CellID->530],
Cell[CellGroupData[{
Cell[58205, 1466, 90, 3, 70, "Input",
 CellID->14161],
Cell[58298, 1471, 185, 6, 36, "Output",
 CellID->476154913]
}, Open  ]],
Cell[58498, 1480, 121, 3, 70, "ExampleDelimiter",
 CellID->10258],
Cell[58622, 1485, 415, 17, 70, "ExampleText",
 CellID->21926],
Cell[CellGroupData[{
Cell[59062, 1506, 173, 6, 70, "Input",
 CellID->5906],
Cell[59238, 1514, 220, 7, 36, "Output",
 CellID->279519181]
}, Open  ]],
Cell[59473, 1524, 121, 3, 70, "ExampleDelimiter",
 CellID->14443],
Cell[CellGroupData[{
Cell[59619, 1531, 218, 7, 70, "Input",
 CellID->6188],
Cell[59840, 1540, 1040, 21, 70, "Output",
 Evaluatable->False,
 CellID->95532745]
}, Open  ]],
Cell[60895, 1564, 125, 3, 70, "ExampleDelimiter",
 CellID->921798116],
Cell[61023, 1569, 334, 13, 70, "ExampleText",
 CellID->595017756],
Cell[CellGroupData[{
Cell[61382, 1586, 295, 10, 70, "Input",
 CellID->514788120],
Cell[61680, 1598, 678, 15, 70, "Output",
 Evaluatable->False,
 CellID->251154270]
}, Open  ]],
Cell[CellGroupData[{
Cell[62395, 1618, 596, 21, 70, "Input",
 CellID->689558348],
Cell[62994, 1641, 196, 7, 49, "Output",
 CellID->735331949]
}, Open  ]],
Cell[63205, 1651, 124, 3, 70, "ExampleDelimiter",
 CellID->81306443],
Cell[63332, 1656, 201, 8, 70, "ExampleText",
 CellID->219261],
Cell[CellGroupData[{
Cell[63558, 1668, 417, 15, 70, "Input",
 CellID->227220823],
Cell[63978, 1685, 954, 35, 41, "Output",
 CellID->598266611]
}, Open  ]],
Cell[64947, 1723, 125, 3, 70, "ExampleDelimiter",
 CellID->521447580],
Cell[65075, 1728, 189, 7, 70, "ExampleText",
 CellID->25118721],
Cell[CellGroupData[{
Cell[65289, 1739, 117, 4, 70, "Input",
 CellID->191578631],
Cell[65409, 1745, 158, 5, 36, "Output",
 CellID->132382669]
}, Open  ]],
Cell[CellGroupData[{
Cell[65604, 1755, 165, 5, 70, "Input",
 CellID->277402001],
Cell[65772, 1762, 553, 13, 70, "Output",
 Evaluatable->False,
 CellID->137425652]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66374, 1781, 226, 7, 70, "ExampleSection",
 CellID->32719],
Cell[66603, 1790, 323, 12, 70, "ExampleText",
 CellID->26484],
Cell[CellGroupData[{
Cell[66951, 1806, 215, 8, 70, "Input",
 CellID->5224],
Cell[67169, 1816, 231, 7, 36, "Output",
 CellID->494811282]
}, Open  ]],
Cell[67415, 1826, 125, 3, 70, "ExampleDelimiter",
 CellID->102050560],
Cell[67543, 1831, 108, 3, 70, "ExampleText",
 CellID->101776815],
Cell[CellGroupData[{
Cell[67676, 1838, 98, 3, 70, "Input",
 CellID->17770597],
Cell[67777, 1843, 170, 5, 36, "Output",
 CellID->617141076]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68008, 1855, 310, 9, 70, "SeeAlsoSection",
 CellID->3202],
Cell[68321, 1866, 937, 35, 70, "SeeAlso",
 CellID->17610]
}, Open  ]],
Cell[CellGroupData[{
Cell[69295, 1906, 314, 9, 70, "TutorialsSection",
 CellID->22908],
Cell[69612, 1917, 163, 3, 70, "Tutorials",
 CellID->17411],
Cell[69778, 1922, 148, 3, 70, "Tutorials",
 CellID->13993],
Cell[69929, 1927, 141, 3, 70, "Tutorials",
 CellID->581],
Cell[70073, 1932, 152, 3, 70, "Tutorials",
 CellID->869807265],
Cell[70228, 1937, 140, 3, 70, "Tutorials",
 CellID->289]
}, Open  ]],
Cell[CellGroupData[{
Cell[70405, 1945, 320, 9, 70, "RelatedLinksSection",
 CellID->7665],
Cell[70728, 1956, 178, 4, 70, "RelatedLinks"],
Cell[70909, 1962, 195, 4, 70, "RelatedLinks"],
Cell[71107, 1968, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[71525, 1986, 319, 9, 70, "MoreAboutSection",
 CellID->595933420],
Cell[71847, 1997, 190, 4, 70, "MoreAbout",
 CellID->463254124],
Cell[72040, 2003, 155, 3, 70, "MoreAbout",
 CellID->893241482],
Cell[72198, 2008, 139, 3, 70, "MoreAbout",
 CellID->323622292],
Cell[72340, 2013, 149, 3, 70, "MoreAbout",
 CellID->204457071]
}, Open  ]],
Cell[72504, 2019, 27, 0, 70, "History"],
Cell[72534, 2021, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

