(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35454,        911]
NotebookOptionsPosition[     32072,        797]
NotebookOutlinePosition[     33474,        836]
CellTagsIndexPosition[     33389,        831]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"MaxStepSize" :> 
         Documentation`HelpLookup["paclet:ref/MaxStepSize"], "PlotPoints" :> 
         Documentation`HelpLookup["paclet:ref/PlotPoints"], "NDSolve" :> 
         Documentation`HelpLookup["paclet:ref/NDSolve"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"MaxStepSize\"\>", 2->"\<\"PlotPoints\"\>", 
      3->"\<\"NDSolve\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxStepFraction", "ObjectName",
 CellID->28892],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MaxStepFraction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MaxStepFraction"]], "InlineFormula"],
     " \[LineSeparator]is an option to functions like ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     " that specifies the maximum fraction of the total range to cover in a \
single step."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->48088658],

Cell[TextData[{
 "Make sure that ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " uses at least 100 steps over the integration range:"
}], "ExampleText",
 CellID->390828788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"-", "1000"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"t", "-", "\[Pi]"}], ")"}], "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"MaxStepFraction", "\[Rule]", 
    RowBox[{"1", "/", "100"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301051753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "20.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->958170579]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", "%"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31101270],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->626909545]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->119118845],

Cell["\<\
Features with small relative size in the integration interval can be missed:\
\>", "ExampleText",
 CellID->338881393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
             RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
            RowBox[{"Exp", "[", 
             RowBox[{"-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1000", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"x", "/", "L"}], "-", 
                   RowBox[{"1", "/", "3"}]}], ")"}]}], ")"}], "^", "2"}]}], 
             "]"}]}], ",", 
           RowBox[{
            RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
         ",", "y", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "L"}], "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"L", "/", "4"}], ",", 
       RowBox[{"L", "/", "2"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "100", ",", "1000"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52497343],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189605254]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MaxStepFraction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxStepFraction"]], "InlineFormula"],
 " to ensure features are not missed, independent of interval size:"
}], "ExampleText",
 CellID->175305345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "/.", 
       RowBox[{"NDSolve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
             RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
            RowBox[{"Exp", "[", 
             RowBox[{"-", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1000", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"x", "/", "L"}], "-", 
                   RowBox[{"1", "/", "3"}]}], ")"}]}], ")"}], "^", "2"}]}], 
             "]"}]}], ",", 
           RowBox[{
            RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
            RowBox[{
             RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
         ",", "y", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "L"}], "}"}], ",", 
         RowBox[{"MaxStepFraction", "\[Rule]", "0.001"}]}], "]"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"L", "/", "4"}], ",", 
       RowBox[{"L", "/", "2"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"L", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "10", ",", "100", ",", "1000"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47417740],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->74743068]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->103565021],

Cell[TextData[{
 "For an interval length ",
 Cell[BoxData[
  StyleBox["L",
   FontSlant->"Italic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"MaxStepFraction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MaxStepSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepSize"], "->", 
   RowBox[{"(", 
    RowBox[{
     StyleBox["f", "TI"], " ", 
     StyleBox["L",
      FontSlant->"Italic"]}], ")"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->178843422],

Cell[BoxData[
 RowBox[{
  RowBox[{"msf", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "1000"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"t", "-", "\[Pi]"}], ")"}], "^", "2"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"MaxStepFraction", "\[Rule]", 
      RowBox[{"1", "/", "100"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245793823],

Cell[BoxData[
 RowBox[{
  RowBox[{"mss", "=", 
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", "1000"}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"t", "-", "\[Pi]"}], ")"}], "^", "2"}]}], "]"}]}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "20"}], "}"}], ",", 
     RowBox[{"MaxStepSize", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"20", " ", 
        RowBox[{"1", "/", "100"}]}], ")"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104742341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"msf", "===", "mss"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->353370955],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2269833]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1549],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxStepSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotPoints",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotPoints"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13774]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxStepFraction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 15.4324496}", "context" -> "System`", 
    "keywords" -> {
     "max relative step size", "relative step size", 
      "relative step size limit", "step size limit"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MaxStepFraction is an option to functions like NDSolve that specifies \
the maximum fraction of the total range to cover in a single step.", 
    "synonyms" -> {"max step fraction"}, "title" -> "MaxStepFraction", "type" -> 
    "Symbol", "uri" -> "ref/MaxStepFraction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2139, 71, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33255, 824}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 769, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1392, 44, 53, 1, 70, "ObjectName",
 CellID->28892],
Cell[1448, 47, 654, 19, 70, "Usage",
 CellID->6798]
}, Open  ]],
Cell[CellGroupData[{
Cell[2139, 71, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2516, 85, 147, 5, 70, "ExampleSection",
 CellID->48088658],
Cell[2666, 92, 247, 8, 70, "ExampleText",
 CellID->390828788],
Cell[CellGroupData[{
Cell[2938, 104, 796, 26, 47, "Input",
 CellID->301051753],
Cell[3737, 132, 467, 17, 36, "Output",
 CellID->958170579]
}, Open  ]],
Cell[CellGroupData[{
Cell[4241, 154, 311, 10, 28, "Input",
 CellID->31101270],
Cell[4555, 166, 3408, 60, 116, "Output",
 Evaluatable->False,
 CellID->626909545]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8012, 232, 227, 7, 70, "ExampleSection",
 CellID->119118845],
Cell[8242, 241, 127, 3, 70, "ExampleText",
 CellID->338881393],
Cell[CellGroupData[{
Cell[8394, 248, 1484, 45, 70, "Input",
 CellID->52497343],
Cell[9881, 295, 2287, 42, 70, "Output",
 Evaluatable->False,
 CellID->189605254]
}, Open  ]],
Cell[12183, 340, 265, 8, 70, "ExampleText",
 CellID->175305345],
Cell[CellGroupData[{
Cell[12473, 352, 1554, 47, 70, "Input",
 CellID->47417740],
Cell[14030, 401, 13932, 232, 70, "Output",
 Evaluatable->False,
 CellID->74743068]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28011, 639, 237, 7, 70, "ExampleSection",
 CellID->103565021],
Cell[28251, 648, 554, 22, 70, "ExampleText",
 CellID->178843422],
Cell[28808, 672, 886, 28, 70, "Input",
 CellID->245793823],
Cell[29697, 702, 940, 30, 70, "Input",
 CellID->104742341],
Cell[CellGroupData[{
Cell[30662, 736, 98, 3, 70, "Input",
 CellID->353370955],
Cell[30763, 741, 159, 5, 36, "Output",
 CellID->2269833]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30983, 753, 310, 9, 70, "SeeAlsoSection",
 CellID->1549],
Cell[31296, 764, 704, 26, 70, "SeeAlso",
 CellID->13774]
}, Open  ]],
Cell[32015, 793, 27, 0, 70, "History"],
Cell[32045, 795, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

