(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34001,        954]
NotebookOptionsPosition[     30193,        825]
NotebookOutlinePosition[     31509,        862]
CellTagsIndexPosition[     31424,        857]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"StepMonitor" :> 
         Documentation`HelpLookup["paclet:ref/StepMonitor"], "MaxStepSize" :> 
         Documentation`HelpLookup["paclet:ref/MaxStepSize"], 
         "MaxStepFraction" :> 
         Documentation`HelpLookup["paclet:ref/MaxStepFraction"], "NDSolve" :> 
         Documentation`HelpLookup["paclet:ref/NDSolve"], "MaxIterations" :> 
         Documentation`HelpLookup["paclet:ref/MaxIterations"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"StepMonitor\"\>", 
      2->"\<\"MaxStepSize\"\>", 3->"\<\"MaxStepFraction\"\>", 
      4->"\<\"NDSolve\"\>", 5->"\<\"MaxIterations\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MaxSteps", "ObjectName",
 CellID->17916],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MaxSteps",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
     " \[LineSeparator]is an option to functions like ",
     Cell[BoxData[
      ButtonBox["NDSolve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
     " that specifies the maximum number of steps to take in generating a \
result."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6716]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MaxSteps", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " allows an unlimited number of steps."
}], "Notes",
 CellID->25328]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7428884],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->374773456],

Cell["Stop integration after 25 steps:", "ExampleText",
 CellID->113889016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "x", 
    ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"MaxSteps", "\[Rule]", "25"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216819241],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"Maximum number of \\!\\(25\\) steps reached at the point \
\\!\\(t\\) == \\!\\(1.2921760437342775`\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/mxst\\\", ButtonNote -> \
\\\"NDSolve::mxst\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->15785187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.2921760437342775`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421678503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->827777223],

Cell["\<\
Allow integration to go to completion without any restriction on the number \
of steps:\
\>", "ExampleText",
 CellID->217173341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{"x", " ", 
         RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "y", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "200"}], "}"}], ",", 
    RowBox[{"MaxSteps", "\[Rule]", "\[Infinity]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358373314],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "200.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{323, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->657379582]
}, Open  ]],

Cell["Plot the solution in the phase plane:", "ExampleText",
 CellID->358078506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], "}"}], "/.", 
     RowBox[{"First", "[", "sol", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "200"}], "}"}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{"Hue", "[", 
      RowBox[{"#3", "/", "200"}], "]"}], "]"}]}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->189927418],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 177},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44726679]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->241450283],

Cell["\<\
See how method order affects integration interval with a limited number of \
steps:\
\>", "ExampleText",
 CellID->122704665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Quiet", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"sol", "=", 
        RowBox[{"First", "[", 
         RowBox[{"x", "/.", 
          RowBox[{"NDSolve", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
                RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
              RowBox[{
               RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], 
             "}"}], ",", "x", ",", 
            RowBox[{"{", 
             RowBox[{"t", ",", "\[Infinity]"}], "}"}], ",", 
            RowBox[{"MaxSteps", "\[Rule]", "1000"}], ",", 
            RowBox[{"Method", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"\"\<ExplicitRungeKutta\>\"", ",", 
               RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "order"}]}], 
              "}"}]}]}], "]"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"end", "=", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"{", 
        RowBox[{"order", ",", "end", ",", 
         RowBox[{
          RowBox[{"sol", "[", "end", "]"}], "-", 
          RowBox[{"Cos", "[", "end", "]"}]}]}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"order", ",", "3", ",", "8"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Method order\>\"", ",", "\"\<Interval Length\>\"", ",", 
        "\"\<Error\>\""}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11010938],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], 
      TagBox["\<\"Method order\"\>",
       HoldForm], 
      TagBox["\<\"Interval Length\"\>",
       HoldForm], 
      TagBox["\<\"Error\"\>",
       HoldForm]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "3", 
      "4.412487441300015`", "4.89864571129317`*^-9"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "4", 
      "24.76404068983998`", 
      RowBox[{"-", "2.9456309280639914`*^-8"}]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "5", 
      "138.43761594727997`", 
      RowBox[{"-", "2.818168198803761`*^-8"}]},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "6", 
      "98.09037582514159`", "3.4755154310062153`*^-10"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "7", 
      "189.5075723509651`", "1.9367869086295286`*^-8"},
     {
      TagBox[
       StyleBox["\<\"\[Null]\"\>",
        ShowStringCharacters->False],
       StyleForm[#, ShowStringCharacters -> False]& ], "8", 
      "386.0506924974034`", "5.814709846951871`*^-8"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   MatrixForm[
   BoxForm`e$, 
    TableHeadings -> {{}, {
      "Method order", "Interval Length", "Error"}}]]]], "Output",
 ImageSize->{311, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->26295284]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->107536559],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MaxSteps",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxSteps"]], "InlineFormula"],
 " is roughly equivalent to an event with a step counter:"
}], "ExampleText",
 CellID->783756133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"esol", "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"evals", "=", "0"}], "}"}], ",", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"x", "[", "t", "]"}]}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "x", 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<EventLocator\>\"", ",", 
         RowBox[{"\"\<Event\>\"", "\[RuleDelayed]", 
          RowBox[{
           RowBox[{"++", "evals"}], "-", "28"}]}], ",", 
         RowBox[{
         "\"\<EventLocationMethod\>\"", "\[Rule]", "\"\<StepEnd\>\""}]}], 
        "}"}]}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141948613],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.2921760437342775`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188807278]
}, Open  ]],

Cell["\<\
The event function is evaluated a few extra times during initialization:\
\>", "ExampleText",
 CellID->401015600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "x", 
    ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
    RowBox[{"MaxSteps", "\[Rule]", "25"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24093489],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"mxst\"\>"}], ":", 
  " ", "\<\"Maximum number of \\!\\(25\\) steps reached at the point \
\\!\\(t\\) == \\!\\(1.2921760437342775`\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/mxst\\\", ButtonNote -> \
\\\"NDSolve::mxst\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->208223014],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.2921760437342775`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274095588]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11544],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxStepSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxStepFraction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxStepFraction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MaxIterations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MaxIterations"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1056]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MaxSteps - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 16.8856118}", "context" -> "System`", 
    "keywords" -> {"iteration limit", "max iterations", "step number limit"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MaxSteps is an option to functions like NDSolve that specifies the \
maximum number of steps to take in generating a result.", 
    "synonyms" -> {"max steps"}, "title" -> "MaxSteps", "type" -> "Symbol", 
    "uri" -> "ref/MaxSteps"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3112, 105, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7428884]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31283, 850}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1017, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1640, 48, 46, 1, 70, "ObjectName",
 CellID->17916],
Cell[1689, 51, 633, 19, 70, "Usage",
 CellID->6716]
}, Open  ]],
Cell[CellGroupData[{
Cell[2359, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2837, 92, 238, 8, 70, "Notes",
 CellID->25328]
}, Closed]],
Cell[CellGroupData[{
Cell[3112, 105, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7428884],
Cell[CellGroupData[{
Cell[3495, 119, 148, 5, 70, "ExampleSection",
 CellID->374773456],
Cell[3646, 126, 75, 1, 70, "ExampleText",
 CellID->113889016],
Cell[CellGroupData[{
Cell[3746, 131, 529, 17, 70, "Input",
 CellID->216819241],
Cell[4278, 150, 425, 8, 19, "Message",
 CellID->15785187],
Cell[4706, 160, 483, 17, 36, "Output",
 CellID->421678503]
}, Open  ]],
Cell[5204, 180, 125, 3, 70, "ExampleDelimiter",
 CellID->827777223],
Cell[5332, 185, 138, 4, 70, "ExampleText",
 CellID->217173341],
Cell[CellGroupData[{
Cell[5495, 193, 693, 22, 70, "Input",
 CellID->358373314],
Cell[6191, 217, 468, 17, 36, "Output",
 CellID->657379582]
}, Open  ]],
Cell[6674, 237, 80, 1, 70, "ExampleText",
 CellID->358078506],
Cell[CellGroupData[{
Cell[6779, 242, 701, 20, 65, "Input",
 CellID->189927418],
Cell[7483, 264, 12505, 209, 198, "Output",
 Evaluatable->False,
 CellID->44726679]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20037, 479, 227, 7, 70, "ExampleSection",
 CellID->241450283],
Cell[20267, 488, 134, 4, 70, "ExampleText",
 CellID->122704665],
Cell[CellGroupData[{
Cell[20426, 496, 1985, 54, 70, "Input",
 CellID->11010938],
Cell[22414, 552, 2509, 74, 156, "Output",
 CellID->26295284]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24972, 632, 237, 7, 70, "ExampleSection",
 CellID->107536559],
Cell[25212, 641, 232, 7, 70, "ExampleText",
 CellID->783756133],
Cell[CellGroupData[{
Cell[25469, 652, 966, 29, 70, "Input",
 CellID->141948613],
Cell[26438, 683, 483, 17, 36, "Output",
 CellID->188807278]
}, Open  ]],
Cell[26936, 703, 123, 3, 70, "ExampleText",
 CellID->401015600],
Cell[CellGroupData[{
Cell[27084, 710, 528, 17, 70, "Input",
 CellID->24093489],
Cell[27615, 729, 426, 8, 70, "Message",
 CellID->208223014],
Cell[28044, 739, 483, 17, 36, "Output",
 CellID->274095588]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28588, 763, 311, 9, 70, "SeeAlsoSection",
 CellID->11544],
Cell[28902, 774, 1219, 44, 70, "SeeAlso",
 CellID->1056]
}, Open  ]],
Cell[30136, 821, 27, 0, 70, "History"],
Cell[30166, 823, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

