(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115006,       3721]
NotebookOptionsPosition[     98502,       3154]
NotebookOutlinePosition[    100500,       3201]
CellTagsIndexPosition[    100413,       3196]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/Inequalities-SymbolicMathematics"], 
          "Minimization and Maximization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MinimizationAndMaximization"], 
          "Constrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Inequalities\"\>", 
       2->"\<\"Minimization and Maximization\"\>", 
       3->"\<\"Constrained Optimization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Minimize" :> Documentation`HelpLookup["paclet:ref/Minimize"], 
          "NMaximize" :> Documentation`HelpLookup["paclet:ref/NMaximize"], 
          "FindMaximum" :> Documentation`HelpLookup["paclet:ref/FindMaximum"],
           "Max" :> Documentation`HelpLookup["paclet:ref/Max"], "D" :> 
          Documentation`HelpLookup["paclet:ref/D"], "LinearProgramming" :> 
          Documentation`HelpLookup["paclet:ref/LinearProgramming"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Minimize\"\>", 
       2->"\<\"NMaximize\"\>", 3->"\<\"FindMaximum\"\>", 4->"\<\"Max\"\>", 
       5->"\<\"D\"\>", 6->"\<\"LinearProgramming\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Optimization\"\>", 3->"\<\"Polynomial Systems\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Maximize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Maximize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Maximize"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]maximizes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Maximize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Maximize"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["cons", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]maximizes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Maximize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Maximize"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["cons", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]maximizes with variables over the domain ",
     Cell[BoxData[
      StyleBox["dom", "TI"]], "InlineFormula"],
     ", typically ",
     Cell[BoxData[
      ButtonBox["Reals",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["Integers",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->7266]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " returns a list of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["max", "TI"]], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "->", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["max", "TI"]]}], ",", 
      RowBox[{
       StyleBox["y", "TI"], "->", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["max", "TI"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18633],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " can contain equations, inequalities or logical combinations of these. "
}], "Notes",
 CellID->13509],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " are linear or polynomial, ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " will always find a global maximum. "
}], "Notes",
 CellID->24557],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " will return exact results if given exact input. "
}], "Notes",
 CellID->2317],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " is given an expression containing approximate numbers, it automatically \
calls ",
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->148710633],

Cell[TextData[{
 "If the maximum is achieved only infinitesimally outside the region defined \
by the constraints, or only asymptotically, ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " will return the supremum and the closest specifiable point. "
}], "Notes",
 CellID->26134],

Cell["\<\
If no domain is specified, all variables are assumed to be real. \
\>", "Notes",
 CellID->24196],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 " can be used to specify that a particular variable can take on only integer \
values. "
}], "Notes",
 CellID->1683],

Cell[TextData[{
 "If the constraints cannot be satisfied, ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "->", 
       ButtonBox["Indeterminate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Indeterminate"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12258]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->655143709],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->258949038],

Cell["Maximize a univariate function:", "ExampleText",
 CellID->95476681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"3", "x"}], "+", "5"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303084943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["49", "8"], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox["3", "4"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{104, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55740226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->187776654],

Cell["Maximize a multivariate function:", "ExampleText",
 CellID->3230957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "-", "3"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114846595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13572201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275658031],

Cell["Maximize a function subject to constraints:", "ExampleText",
 CellID->514914013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"2", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306285297],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SqrtBox["5"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["4", 
         SqrtBox["5"]]}], "+", 
       SqrtBox["5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["2", 
        SqrtBox["5"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{233, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3721301]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61381153],

Cell["A maximization problem containing parameters:", "ExampleText",
 CellID->196243439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"b", " ", "x"}], "+", "c"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55196351],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{372, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77221029]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(15)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5794],

Cell["Unconstrained univariate polynomial maximization:", "ExampleText",
 CellID->268465082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"2", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"5", "x"}], "-", "7"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194093916],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1y0zAQVvyTtjEJbQI0wIFcIOXAlU6Hc+HEQ2Q6MO2BoZS+AX0DTrwA
vANvxFMYS5Zi5dPKsh3bcTrpTC2vtFrtfruSV9t+XNxefvqyuL26WMw+3Cyu
L68uvs/ef71JuvweY73fjLH5lCXvcfImfvnPn+SXsTfJ00u6fsh2KttT6A9k
G8p2uJzNfCUxFtw6/RjoUwd/4KAHHVr1GuhDoA8cNGrlklddS+6vI0Ib3j8o
oBU1v5g2o+TJO30Y9WVE+TKiFI0SfLkyb/timWw8lRom7QOYua9LtM7gVqWK
CQZDx77kJS2D1bRVpGTPgq+yugoikew/7BgixWLhIX+GOk5M4lS017f34j4z
uOjVuaZ9wiLED/euZ5kXGfiq8xIlUBhRfJ4hEXULWsJ1QHKNOo5ridg09kUp
/DSZIWFVqParvudlf0hKDUmbUXc1f4la7oxIW2n5TK3PwegRMe5Jew5ITZtA
b8/S33X0UAqOiwgWUoKakRtSdAWkcNdWRRzluDIczOO4vcvcE+bVjd2I0n2L
sGv1m5yDo8riuL4Bo3IWl6WWGY1GmvnVjSg7G0VOZXvqZOgmcuvEmR9nWanK
iYtk3KjTntOqJxpdbL/xM8aTceuMHGv2P17Lbow5/NJs0u51/I53SerM0GmK
n8oSvTi7MepW27JR5aXnDlvwdHhaySr0JiLctlXFb/Dc1GfEaMCy27kZWSpL
RLnjOKsk0TMwTz629Kt9hPtiatE5kjqr+/MmdK5WxXkL9BzomUMqZjNY5VlX
fjUrToB+AbQn/YX+dWnvkltce+5BXTrfd3OgZ7EZM+o80CupZeSYldbPDg+9
irN6bR7fOyHtL/T+E738Na0KKx3ONam8PZPtnWwnghszmXOgUSf03x3QRxuU
6qrC4irfHPzFV6WqrNRqFB+9Cn5x8AbNzyZ1Dqo8ZOV8Zdtbk0RbQ42veVvx
htqsrdW8n3MT3VUT5UiRqNpuDDFSm8cwjVYPeldqoTA7JKT6xvq7mqN52mH2
SZ9YTaO2cr+tgFrUEmrKO8J6w1qyupKzc/j8XVVylcbIoM7TrmKGJ2VbmNFf
d1c0qtyuXwLJ+1ynxEjbp/g7hhNGXBs40dGGmuCeoqPsPtQ5J0DbM7N2LD1u
zFLa8/R/U6As2v/bVhGlq9X0Od+0beOabbN7N2TZX+dUtt3Fyqm+dr06TmrT
UXljSKKNVZ+yVdeydU+cT9c5y2rpqq66tHztmE/WMYyKZNFq6pmF/8TCjx5N
McJaInrqpwOjl7Ca+CqLwV+ktfw1rcSy3n+w4u8D\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{422, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->608185916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62740543],

Cell["Constrained univariate polynomial maximization:", "ExampleText",
 CellID->9290849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], 
       RowBox[{"x", "^", "2"}]}], "-", "x", "+", "9"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", 
        RowBox[{"x", "^", "3"}]}], "+", 
       RowBox[{"5", "x"}], "-", "7"}], "\[GreaterEqual]", "0"}]}], "}"}], ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87280424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381937403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192428172],

Cell["Univariate transcendental maximization:", "ExampleText",
 CellID->207021031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], "\[LessEqual]", 
      RowBox[{"Cos", "[", "x", "]"}], "\[LessEqual]", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133973068],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["\[Pi]", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{86, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21618150]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22982105],

Cell["Univariate piecewise maximization:", "ExampleText",
 CellID->454751844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", 
      RowBox[{"Floor", "[", 
       RowBox[{"x", "+", 
        RowBox[{"UnitStep", "[", 
         RowBox[{"x", "-", "1"}], "]"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"Ceiling", "[", 
       RowBox[{"Abs", "[", "x", "]"}], "]"}], "\[LessEqual]", "5"}]}], "}"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->301089152],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "5"}], "}"}]}], "}"}]], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292806840]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21103409],

Cell["Multivariate linear constrained maximization:", "ExampleText",
 CellID->101386429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "-", "z"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3561804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["15", "2"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["5", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{190, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->462841733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->271356286],

Cell["Linear-fractional constrained maximization: ", "ExampleText",
 CellID->260073986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "+", "y", "-", "z"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"5", "x"}], "-", 
        RowBox[{"7", "y"}], "+", "3"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"0", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->695124919],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "13"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{182, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13688859]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->489602931],

Cell["Unconstrained polynomial maximization:", "ExampleText",
 CellID->472029359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", "y"}]}], ")"}], "^", "2"}], "-", 
    RowBox[{"2", "y"}], "-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163965134],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["3", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291400747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193283604],

Cell["Constrained polynomial optimization can always be solved:", \
"ExampleText",
 CellID->392024223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", "y"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->405571012],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{191, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19657977]
}, Open  ]],

Cell["The maximum value may not be attained:", "ExampleText",
 CellID->426077459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"x", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[GreaterEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101417820],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"The maximum is not attained at any point satisfying the given \
constraints. \"\>"}]], "Message", "MSG",
 CellID->116123331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34335003]
}, Open  ]],

Cell["The objective function may be unbounded:", "ExampleText",
 CellID->262241521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->539447548],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"The maximum is not attained at any point satisfying the given \
constraints. \"\>"}]], "Message", "MSG",
 CellID->15087942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->157334636]
}, Open  ]],

Cell["There may be no points satisfying the constraints:", "ExampleText",
 CellID->353970800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->248070447],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"infeas\"\>"}], ":", 
  " ", "\<\"There are no values of \\!\\({x, y}\\) for which the constraints \
\\!\\(\\(\\(x\\^2 + y\\^2\\)\\) < 0\\) are satisfied and the objective \
function \\!\\(x\\) is real-valued. \"\>"}]], "Message", "MSG",
 CellID->397555060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "\[Infinity]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "Indeterminate"}], ",", 
     RowBox[{"y", "\[Rule]", "Indeterminate"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{299, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->223490698]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26152599],

Cell["Algebraic maximization:", "ExampleText",
 CellID->152197366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", "y"}], "]"}], "-", "y", "+", "1"}], ",",
      
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"Sqrt", "[", "y", "]"}]}], "\[LessEqual]", "1"}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212088409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["5", "16"]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{133, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179050512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117376046],

Cell["Bounded transcendental maximization:", "ExampleText",
 CellID->352688884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", "x"}], "+", 
      RowBox[{"Log", "[", "y", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", 
        RowBox[{"Log", "[", "y", "]"}]}], "\[Equal]", "2"}], "&&", 
      RowBox[{
       RowBox[{"-", "10"}], "\[LessEqual]", "x", "\[LessEqual]", "10"}], "&&",
       
      RowBox[{
       RowBox[{"1", "/", "10"}], "\[LessEqual]", "y", "\[LessEqual]", 
       "10"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25329921],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "5"], "+", 
    SuperscriptBox["\[ExponentialE]", "10"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "10"}], ",", 
     RowBox[{"y", "\[Rule]", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"1", "/", "5"}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->598679417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->642251835],

Cell["Piecewise maximization:", "ExampleText",
 CellID->357845437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Min", "[", 
      RowBox[{
       RowBox[{"x", "-", "y"}], ",", 
       RowBox[{"Abs", "[", "y", "]"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"Max", "[", 
       RowBox[{
        RowBox[{"x", "-", "2"}], ",", 
        RowBox[{"x", "-", 
         RowBox[{"y", "^", "2"}]}]}], "]"}], "\[GreaterEqual]", 
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"x", " ", "y"}], "-", "1"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132161290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80907841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7039544],

Cell["Unconstrained parametric maximization:", "ExampleText",
 CellID->718818873],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"x", "^", "4"}]}], "+", 
     RowBox[{"a", " ", 
      RowBox[{"x", "^", "2"}]}], "+", "b"}], ",", "x"}], "]"}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->459540071],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWttqFEEQ7Z3Lbi4m3qJ4I8Z4C6KCipcv8IIGRNEnkURR9EEMmoe87Q8I
q09BUfKYx3yCn7D4BUER8phPaLtnumd6zlRP90x2RXBhZ7a6q6qrT1Xfqnd+
cfnVizeLy6+fL87cere49Or18/czN9++E0Vhi7HWZ8bY2UNM/ObiV/KVny/i
y9gP8QxE0Qf1vpGUjslntLKy8j35bG1tfU1KxO9eryee/X7/pCwJtTaeaDDp
a7mmsNvtqtJvsh2h4HQj6VHxkEyfLFpWgN7rpXUMuD5WaJcY7fPSOiIekWAa
B+5zQD9WrbVV30Kolz8jVRerd4Q84hEL8qDBF2u+KOdjGecEaOiYmkmJXar3
qYEJQ8nWjtmuUT5h9C1Wb1OX/AQKrz1WNLVGRqB6HuhHClVpEYuzciUd1CgN
7aVGe7TsIcJPZS6JVtuCmkmP8HKblNx4yYexwhsjHSUnKXsr6ECjZpQlo4Mc
uUFdv5XisJbPDK0xgVxZStocK7QyXEtcMYku4q9HQabHKaFbymN8zyC8RSPm
9BdGyijQVX6LBuytUOmcIqXbqtbtFxxPTf27C2hcZQbnpzibD6XOIBvruZ8O
gK6LQF9Xckf5QOfD2mPrAI1qA/TRixaJoXsw80YNNAOWz8WJTSU0Xf7VKyjO
o3JtMFdY7PEk91+Bd4NsdeyEPN85mC1Qe5TQ4Dcx1+M4VO9q7wUWDW6/67Y7
qvd1/a59mDImH1Wia3QL2DJqDry8nyAeis12N/kkVQmt6v3GHkY7zuX2XYnJ
hVHRZG+AeFdHFnJjb7EfGA/Se9T+qMoq3XNKDunDjvryPgxbPujQUCdKtre3
C1EiaAtuO9n9NIoK5x7EFhdtZdMRqMfdiZQP9MxVQFyvm4jBXrOclJBvWXFY
0W3QIL3bYeU9fjMfUvN8RIzdilVziL6KmX1VwFMy+uYS0GcMWuqfhXo8Hw8G
T7+ZkV57qJkMaQrbujsE7BPObzbETT6p5xLQc8qW4SCtz/zUqlK13psjj7Gs
pAJT/9VXj2GMRRNB6jSKsToH9HElh6efZsghYi6aRBCjF3e5tdafkaIEoIto
dhSaP73QwLZTrtXV1fX1dU7MG64TqJ7Bta87UC/PCXp+lvWYPQlL6JBzrdxt
9Xq9zc1N9svRz1aqxsiPpR6xn6pdfZwB+iphoV6bRtVbeuQ3YWlLkNLCVoU3
lpaWRF99LMV83Amov0bol5aSp7dQmLywsOCPsWtkjVhawxg4DvQNoBOUCjGC
M0a9MeCyu1tsjxfH3xQvzl4v1fvB4Nr2WG1eAn3/P2r9IdCYofv71lCn2OFa
sZN7CjMzar9lKM0Pje8j2pzORVzh+VknZnnuYTCndhtyf+suYozksp1qEXEb
n/1WAVctlLxM2oMril8WgvaILTuq/TvP8ziQb33bpfcQBQ8N9dYhtup0Z6/M
E3qT+wTcT/v5Sa+lbSsS5awm3ibQsnfJUjKaSlwX+PDuG8a5742Ce7ZySbju
eK4oW9rc2MWWekTfmdZBXWdE6TnKRHu4twf03PUveKLJ6Kjjl3s8j7psVq3p
Cd9c/Divm2svZ9ZcuXWfyJYk7qjpkWxHksrO3CF17CTGXbno/dwv12zLSSPt
yireqolSMdMyr7An/w9gRcaWjZ0y9KcitqzrpJVTZ1v1aR1zGbe5kUWie2hw
P6vsB+6j8Z9MxwxayuHZ9kluQ7SxsZFm3fv9vu7LC2VrchcbiVNtyrG2toYt
zUJL00oD3aL+r9YpqJ0maMn3NJGSRel/vVjrD5VYWZE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{409, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->950973757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30496838],

Cell["Constrained parametric maximization:", "ExampleText",
 CellID->65207227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Maximize",
   FormatType->StandardForm], 
  StyleBox["[",
   FormatType->StandardForm], 
  RowBox[{
   RowBox[{
    StyleBox["{",
     FormatType->StandardForm], 
    RowBox[{
     StyleBox[
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}],
      FormatType->StandardForm], 
     StyleBox[",",
      FormatType->StandardForm], 
     StyleBox[" ",
      FormatType->StandardForm], 
     RowBox[{
      StyleBox[
       RowBox[{
        RowBox[{"x", "^", "4"}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"y", "^", "4"}]}]}],
       FormatType->StandardForm], 
      StyleBox["\[Equal]",
       FormatType->StandardForm], "1"}]}], 
    StyleBox["}",
     FormatType->StandardForm]}], 
   StyleBox[",",
    FormatType->StandardForm], 
   StyleBox[" ",
    FormatType->StandardForm], 
   StyleBox[
    RowBox[{"{", 
     RowBox[{"x", ",", " ", "y"}], "}"}],
    FormatType->StandardForm]}], 
  StyleBox["]",
   FormatType->StandardForm]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298396418],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{441, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54185524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462090459],

Cell["Integer linear programming:", "ExampleText",
 CellID->115493641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "-", "z"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}], " ", "&&", 
      RowBox[{"Element", "[", 
       RowBox[{
        RowBox[{"x", "|", "y", "|", "z"}], ",", "Integers"}], "]"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111064747],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->793341590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528344132],

Cell["Polynomial maximization over the integers:", "ExampleText",
 CellID->119371554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"x", " ", "y"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[GreaterEqual]", "1"}], "&&", 
      RowBox[{"Element", "[", 
       RowBox[{
        RowBox[{"x", "|", "y"}], ",", "Integers"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529056659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->383579926]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21817],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24837],

Cell["\<\
Finding the exact solution takes a long time due to high-degree algebraic \
number operations:\
\>", "ExampleText",
 CellID->422401855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "8"}], "-", 
          RowBox[{"3", " ", "x", " ", "y", " ", "z"}], "+", 
          RowBox[{"9", " ", 
           RowBox[{"z", "^", "2"}]}], "+", 
          RowBox[{"y", "^", "2"}]}], "==", "5"}], "&&", 
        RowBox[{
         RowBox[{"x", " ", "y", " ", "z"}], "\[LessEqual]", "4"}]}]}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], ",", "300"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5965103],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87383134]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "200"}]], 
  "InlineFormula"],
 ", you get an exact maximum value, but it might be incorrect:"
}], "ExampleText",
 CellID->358216118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "8"}], "-", 
         RowBox[{"3", " ", "x", " ", "y", " ", "z"}], "+", 
         RowBox[{"9", " ", 
          RowBox[{"z", "^", "2"}]}], "+", 
         RowBox[{"y", "^", "2"}]}], "==", "5"}], "&&", 
       RowBox[{
        RowBox[{"x", " ", "y", " ", "z"}], "\[LessEqual]", "4"}]}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "200"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173571601],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8.094000000000001`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "6972858230480717397169"}], "-", 
          RowBox[{"10045212142987656086748", " ", "#1"}], "-", 
          RowBox[{"15558294483043255710552", " ", 
           SuperscriptBox["#1", "2"]}], "-", 
          RowBox[{"14114720089159418072291", " ", 
           SuperscriptBox["#1", "3"]}], "-", 
          RowBox[{"5333024752414858151190", " ", 
           SuperscriptBox["#1", "4"]}], "-", 
          RowBox[{"877635211050004629348", " ", 
           SuperscriptBox["#1", "5"]}], "-", 
          RowBox[{"51550386291144679680", " ", 
           SuperscriptBox["#1", "6"]}], "+", 
          RowBox[{"79350997166666496", " ", 
           SuperscriptBox["#1", "7"]}], "+", 
          RowBox[{"35450825752503", " ", 
           SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", 
        RowBox[{
        "-", "0.91373875564920579974957579545797738025544690150901468800129516\
683087028712138498529110589525964355858437991961007725527745569064691798370471\
541481380256988043403205`149.35736235069595"}]}], ",", 
       RowBox[{"y", "\[Rule]", 
        RowBox[{
        "-", "2.38571358653299079033783340896543558244733935208979484700400318\
738118510576842114854054279897259161210823356295038813602425364554799602911188\
515645979352179006562018126536625`159.9956439691729"}]}], ",", 
       RowBox[{
       "z", "\[Rule]", 
        "0.3973939082460081676875108590082605068539839842057353085401155391768\
619992558560684096396506817442896001822115044108018640808867459392115256715867\
6824077157738575521`147.63125145876847"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{579, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28024974]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28900],

Cell["\<\
Find the maximal area among rectangles with a unit perimeter:\
\>", "ExampleText",
 CellID->504661259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", " ", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "x"}], "+", 
        RowBox[{"2", "y"}]}], "\[Equal]", "1"}], "&&", 
      RowBox[{"x", ">", "0"}], "&&", 
      RowBox[{"y", ">", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37864644],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "16"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "4"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "4"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{141, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49567029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6354034],

Cell["Find the maximal area among triangles with a unit perimeter:", \
"ExampleText",
 CellID->53431186],

Cell[BoxData[{
 RowBox[{
  RowBox[{"triangle", "=", 
   RowBox[{
    RowBox[{"a", ">", "0"}], "&&", 
    RowBox[{"b", ">", "0"}], "&&", 
    RowBox[{"c", ">", "0"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ">", "c"}], "&&", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ">", "b"}], "&&", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ">", "a"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->545322231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"s", 
       RowBox[{"(", 
        RowBox[{"s", "-", "a"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"s", "-", "b"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"s", "-", "c"}], ")"}]}], "]"}], ",", 
     RowBox[{"triangle", "&&", 
      RowBox[{
       RowBox[{"a", "+", "b", "+", "c"}], "\[Equal]", "1"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->100593768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"12", " ", 
     SqrtBox["3"]}]], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "\[Rule]", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"b", "\[Rule]", 
      FractionBox["1", "3"]}], ",", 
     RowBox[{"c", "\[Rule]", 
      FractionBox["1", "3"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52956444]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3021488],

Cell["Find the maximum height reached by a projectile:", "ExampleText",
 CellID->776908962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"v", " ", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}], " ", "t"}], "-", 
      RowBox[{"5", " ", 
       RowBox[{"t", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"t", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"0", "<", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"v", ">", "0"}]}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503791689],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWr1u3EYQXvHnqF/H0lmxbMOwE8dwE8Tughhwm1QJkDeQIhiwYdg+2C6U
FJHbIIWqQKVKlXqBBH6Ee4RDUkSpLCNpgzC75I4493GWy+ORhAmI5Cx3Z7/5
253Z09c7rx49fLrz6vHuzs2vXuyMHj3efXnzy+cvdFO4oFRwXSl1e0vp91S/
ZX903dB/Si2be7S3t/cmu05PT823i1mrpg8ODvR9PB7/W/QO9/f3cxYZs3X9
F+hO/zXs8Z2+hRpYqJ+xfQbKvqj8CvRrpJ+/WE6J7aviok8mmgpt75iNitgM
EfvOZ0A69HIPgevaDHLsiZpYE0Z8S9PaPqGHDuwsvO3Qam0J+5pbzH2CMDpa
2dhMNQn0sn0TCWN8/t32iuZAE1bMvtGCxn4Q7TNIp73OrZ1v6mDw6rgzu1Ug
E7+3b7sKBBdb0Z1swVVzi7jp2rOcaaT1aV6LxQ49udqbWojWLtdcF+bSxnyr
XEBS1NRble7PY7xk+8DJr56sEtJqK8hYZO6x2CpZZVZt5baJ+Ehmo10H7rxj
djFJAlXsht9b+hq3RsRnR9tH0Ebz4V5KdBlHWDFamk3i/EFjiZ9YOmbPsveg
hrdLHoAr0U9AT2mUta8BvQj0Z0APvTP/KGKf1k09Cc0W/bNDDsrhVq3e7kC/
O3b861bQ/O1Age3vI/c/4Tt6QPuzGXssdzrLKXxHr6U4RRTJTCjQs/Neh4eH
x8fH5vUvK6s0e3nNRCx5rqSLI10lTSYT9Y8H00LOh61UA9DKUlqsTnzkRJx5
ml7S5CAt1giqgHi/PwSEukzMkC1UaGw0GmkZCWFJz5Y2Ovrdo4NVURINeXt7
2+gw07Ejs5fQl/Xr87ylGWZAXitAkzdWofZppF68zIKa8q9LvaHj8aPA7+ro
dbNfPTr817x+muYrwop9joDGXYrvykUmNb2L8fGvgb7WilQP4Dv66TPP99sO
qb7wjMNMAb9faUU65JKfWRWeUWRz8olNqeJPWRZe4QubQOOqS6t1ksoZLLbR
noZaCnuSh84vYvvESpusflWSuwd8nwh4MUeYRd9xKucQUU/ykJ5J7+j9zaIh
P13TWcd+dqnE3AwtcFVspfGhletEd015XuswHpdgbrLUosiF+1XeFJZa5Ap4
0fId9CibnP0VtCuaFme0V58y3YK5Sa9JY3sNxJEJ49uXbLjT42rSZjSenZ1N
WVfTAleDVjpnaCq57yQVo5FyFNlGPNKKMYHYKuMhz8Ucv0sZyWOxgquOxvr2
wqjvUhaMxuWUefZc9nJzMPzxBKlLGWkFwOisF42u88rLIhY8J+1SrqE4iiJC
3v98K1L13tenZ5IcOOd6On3auyVy99VcbSL9WBzF95/Z7VC9p2E236V0FLHS
nOUzaPzlRY4SwytU5f2zMsttKT5wzjbjRMr6u5fTtR+ZU3h3hAx6wSbHBmq3
zRjByKeKrFs5XXtMlhOUooLOSqm6lGtARMx/R8LfmCTpQtZHwkx96L9I2O9O
ymaNzhVoKupLvTATahu5ry4iz1+xek5ECaX9v02UH82hV9m3u9arr36RvRl3
BkRZQqLK/zHj29FuifrYrKWlOvPhd/IgzFOxXx3en4soP+wMez0rrQNNnlfl
H3SuQ0+ptjfkZfvcaMBzaJ/3HBYYNuB53+LZagHXRiPt3gX6V4d0b2tx515i
xLgL9G9+7tHJyUlej47HY6rShzVQq2gymeQjj46OqF58l3FO7XUjx7HwP8hC
DOQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{541, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149243825]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    RowBox[{"0", "<", 
     RowBox[{"Sin", "[", "\[Alpha]", "]"}], "\[LessEqual]", "1"}], "&&", 
    RowBox[{"v", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->253303408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "20"], " ", 
    SuperscriptBox["v", "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "\[Alpha]", "]"}], "2"]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{
      FractionBox["1", "10"], " ", "v", " ", 
      RowBox[{"Sin", "[", "\[Alpha]", "]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{224, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172521251]
}, Open  ]],

Cell["Find the maximum range of a projectile:", "ExampleText",
 CellID->135801757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"v", " ", 
      RowBox[{"Cos", "[", "\[Alpha]", "]"}], " ", "t"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"v", " ", 
         RowBox[{"Sin", "[", "\[Alpha]", "]"}], " ", "t"}], "-", 
        RowBox[{"5", " ", 
         RowBox[{"t", "^", "2"}]}]}], "==", "0"}], " ", "&&", 
      RowBox[{"t", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"v", ">", "0"}], "&&", 
      RowBox[{"0", "\[LessEqual]", 
       RowBox[{"Sin", "[", "\[Alpha]", "]"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{"0", "\[LessEqual]", 
       RowBox[{"Cos", "[", "\[Alpha]", "]"}], "\[LessEqual]", "1"}], "&&", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Sin", "[", "\[Alpha]", "]"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"Cos", "[", "\[Alpha]", "]"}], "^", "2"}]}], "\[Equal]", 
       "1"}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Alpha]", "]"}], ",", 
     RowBox[{"Cos", "[", "\[Alpha]", "]"}], ",", "t"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->678258871],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{401, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->485287338]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{"%", ",", 
   RowBox[{"v", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->95051772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    SuperscriptBox["v", "2"], "10"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", "\[Alpha]", "]"}], "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "\[Alpha]", "]"}], "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"t", "\[Rule]", 
      FractionBox["v", 
       RowBox[{"5", " ", 
        SqrtBox["2"]}]]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{317, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->52288650]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13232],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " gives an exact global maximum of the objective function:"
}], "ExampleText",
 CellID->83860016],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}]}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "4"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "7"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "9"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "10"}], ")"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->170192576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43630285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["35721", "64"], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox["11", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{126, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235286166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10.5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "/.", 
          RowBox[{"%", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"%", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->220378345],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->402619480]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMaximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMaximize"]], "InlineFormula"],
 " attempts to find a global maximum numerically, but may find a local \
maximum:"
}], "ExampleText",
 CellID->179571605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMaximize", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17885355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"228.4001364327751`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.4024194394025435`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->12364738]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10.5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "/.", 
          RowBox[{"%", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ",", 
         RowBox[{"%", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->311368626],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWluIlVUU/j23mXEaZ8Zb2uQ402iTl6wMCSJRE2+pmZH0EBGTBM5DKWYg
9WC9JHkpyB4SIh+6SJcHRdECg0iIhEiIhKggDEIDJcp6GAj+vrXW3v9aZ519
dLIZxuPZ/7/X+tblW2tfdP3Qji1PPT20Y3jzUN+q7UPbtgxvfrZv5dbteFQe
l2XZcfzZNi3D9xzf+E9vnudZmb7xT3aAPjJ6WsLDN3hU4Tlnv/n1woU/6euN
TuZV975kpPbvO330yLnmUrtf/vzkie/rpUqH3v56WnL21meOAcZjAAAwzTHS
UoAFeHOpRze9n/AHiqAuSlGMXuPnGze8c/ny31ef3YixZPHBMLZSgAV4Smo/
j69cGVm75hB/NVL6NC2lWkWq6iyYmpRSD6yUejs1REH8OfPVL8/tOOFnP/7Y
B+fP/94cQzNhpTRraamPPvz2wOtfeqkXnv/09Bc/N5MiZlXMbGVfGkPfKwbp
SEf4pRdPfXbqJ2/Re++ePfjmmcZYqX92tsYibdHmJz/+8YdLXkrjnpZSLlsp
yS3mZmRVKVhXdn/XkhqVN0ZjRTkm+rKayvGX+LxcDOvGhT4z3sfjkZF/Vix/
i0FErhzEg/VZRfn//7BpKJjqjWDWjOfZmHuolWbRpNLGHg1FglLxaMKusUfT
Dm3RQNmQQc+5ZtwjbVR/VaNFa3RKEltXIIuNkkRhRinCEl5r/7CztYbTGFrL
VkprOS2lVWmllAdpKZAcVPdSSBuS11xK69VKgVogmI2CZ75EusXpmOww9vL4
3HcXh7cc8VLqZVpKe5eV0j6XltLYWikogrrmUppHK6UMSkthmcFiUy9FLKyP
mXZ/q1uZn9atzLFSUAR1zaU0plZKmZOWQgNFG/VSmmsvtYfH2leZM1mr48Kk
EIW9jod2tto7KYmh3chKaWzSUroDsFJmFR5FRxFN2g2sJn1qu5rveqPpgnuc
ZYJCn5Us7t/+m3Ya7nFRsrZrRMfGds2gQakU2Q7RHc2q0RxDOWUwqgX/gr3l
68R4hcfa8Zj9WRv7UVSG8eNqrBFd2u+MLrPbnZiU0tq2Utq5JgZMiYl2LDtb
17Q0hr63UqorLaU2WCm110u181RwAFrBQvxKJ0Uosw38DtFGkYKIeAftMAAk
yvpdnCya9g+PJpmCCHRhCvpvCbzPKrISIKlAWsdmgTHoC3iCT9QBZsEt2Ign
CAzeZnLq1T1lq7FAn8ZMFHFAtgmS2VARFBgDJ9cY22GG9n44SRuqGTyG7Rgr
3vi8vrK6nceiBf4h/mS12AELYAfFcRWP4VsYt0WGwyhCvTm+D+urRdVce1S/
d+Es0yoBrYSyImpFWinT8h72BdQeHmtvtqjKS4/qzzEdDnV59B3vCbUjoiLi
9P4mp9+iqi0etRLzBhSKcGfMEyJK42XRCqDoex1P57F2YIuqvnjUcuQZtAAr
vHc7cjM/3sZMc3K1On6qPOkrmy5mz+vWQu2F3WGmv7PhCohnZmMR87lie7Cc
iHUnVW2YIVbqXoq9bnF9nIKaBfsCs3S/2+WsKLk4y/4FqUNjjvC9DXZMdZyo
NbEUcUa1EreSlgLDW6o11VUvgR9oQ6HTUY735zXohXZicly/ZjbYMSWyEfmm
ma0hS+3O766Ufcigt0+zwxI1a5/kRbKotV8KdpWLuGl0Wxrs9SidKbsA5O3S
XLBd1UJCGqpUWUWim/FPn2PCZKentYltiD+iXlSyt43AnG31US7FDYiEIVhm
c9kfZk1yeOPD8w5naUdev9Ng3gWbWo0dugvvMr5JpqjjUpXewzN1lzk98hjW
UmeWFVVXWPHzBn6qq3Fn1F9QtifqCX1nUR56cTht9LhIdTsWWRzHDsqhbEvC
Gqla7nao8l7P59INtJ9YFD11FShwhTLU67QsDLHrdbUm2vUUarVrBAvtoV/2
xqwHtLvceKazeUL0Ebkt1tK6u62j/On7b7EfDV5U3fviBjV0l5bk+4Q+/z70
rKbvryXf5H1xO97EvlHrC1WU9p9YJfq9Prlt73A8lezKOpqFWmYp2QJndzhO
9MfshSiJPhRbQG03KHrK5qcVXV2ybMDpnZ/X94gBY1ehwXQEtjtwSeuYGVvR
PX/EUfbOi3ogRPbPjqwJu5nxqfgwDlWM6C+4nUv/EgztQXPzesYLhtaZ341a
X3S/zCtytahacSeblddX15zoH1JA48FgaVv0E7udYu8Yale9bXHe+vPkQNAm
KNpBBiMLQpdtddmzaO6eg1gBKYq9P60OOG4NOvk5Lo41N58jGLqY2RHFWXCb
1i/fVySieuKb7Xyb53yrurFBbYN+oIz88Ve+e3e+dGm+c+fIb5dgPbQ31Ots
VwGznN75sZ4Rf/4ao2f35brufLJ6WG4EqJceu/cJcy9HHL2V5+npfSDyKKzV
C5gOWEDABDmayQmBIsC+yUpavbhsHb7L75X77m/oYoKju+lbeKwrIPeTKgbI
2ZLFB8Ple7dByE+eLBDyw4ebIGgF9zvPVrIu2YuQrl27SEur0zLomN/nsiFa
/L8U3+bqp9flbFUhRTH3fJ3hYr46iTEn5j3cw8mJVrvL1aR059DjWL0mKTXX
xW56tBBaKLYPJKWoIqgryGztY+nZ813M/FlkbV3MbncWTIkWUl0hhuuSGCKl
XXBSrJXQadazFPXZ1P2or8wFLnbdMbahIzyYa3crjjLXvGP0Y1lZkeQQh86I
Ak9p079hTFDu5DGSFXhe3CGEo8VD141CQ9nroYrCXUK7YTztdDayfNzvj/am
1I8X8hj6UDd0xJOTDiIFt2RD8XCBY05S1xkx3oNXwRo0MTQpEJXqibtvBTyU
OzUgP8L6JuTp21PPqUWRkcg2bOaLX16lQACK3KYkr1P/M+W4+DHuX3caFCU=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->385675119]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindMaximum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMaximum"]], "InlineFormula"],
 " finds local maxima depending on the starting point:"
}], "ExampleText",
 CellID->31148106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FindMaximum", "[", 
    RowBox[{"f", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->186995912],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"228.40013643277274`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "1.4024194391813876`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"558.1406249999491`", ",", 
     RowBox[{"{", 
      RowBox[{"x", "\[Rule]", "5.5000000002814`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->192268000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "10.5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "/.", 
            RowBox[{"%", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
           RowBox[{"%", "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"x", "/.", 
            RowBox[{"%", "[", 
             RowBox[{"[", 
              RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ",", 
           RowBox[{"%", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "1"}], "]"}], "]"}]}], "}"}], "]"}]}], "}"}]}],
      "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->560258836],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->292854519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148375834],

Cell["\<\
The maximum point satisfies the constraints, unless messages say otherwise:\
\>", "ExampleText",
 CellID->195277511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Maximize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"y", "-", 
          RowBox[{"3", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237456092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["49", "4"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["4", "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "5"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{157, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350654133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "/.", 
  RowBox[{"m", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27441563],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->578190848]
}, Open  ]],

Cell[TextData[{
 "The given point m",
 "aximiz",
 "es the distance from the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", 
    FractionBox["3", "2"]}], "}"}]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->460857148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.2"}], ",", "2.2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.2"}], ",", "2.2"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Point", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y"}], "}"}], "/.", 
          RowBox[{"m", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"3", "/", "2"}]}], "}"}], "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->721702684],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->510574352]
}, Open  ]],

Cell[TextData[{
 "When the maximum is not attained, ",
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " may give a point on the boundary:"
}], "ExampleText",
 CellID->556211698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", 
         RowBox[{"3", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->421324397],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"wksol\"\>"}], ":", 
  " ", "\<\"Warning: There is no maximum in the region described by the \
constraints; returning a result on the boundary. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Maximize/wksol\\\", ButtonNote -> \
\\\"Maximize::wksol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->119410906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["49", "4"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["4", "5"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["3", "5"]}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{157, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->266762706]
}, Open  ]],

Cell[TextData[{
 "Here the objective function tends to the maximum value when ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " tends to infinity:"
}], "ExampleText",
 CellID->794807772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "-", "x"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[Equal]", "1"}], "&&", 
      RowBox[{"x", ">", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->390848494],

Cell[BoxData[
 RowBox[{
  RowBox[{"Maximize", "::", "\<\"natt\"\>"}], ":", 
  " ", "\<\"The maximum is not attained at any point satisfying the given \
constraints. \"\>"}]], "Message", "MSG",
 CellID->617957896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "ComplexInfinity"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->44596113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11671239],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " can solve linear programming problems:"
}], "ExampleText",
 CellID->922674425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"2", "x"}], "+", 
      RowBox[{"3", "y"}], "-", "z"}], ",", 
     RowBox[{
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "+", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{"1", "\[LessEqual]", 
       RowBox[{"x", "-", "y", "+", "z"}], "\[LessEqual]", "2"}], "&&", 
      RowBox[{
       RowBox[{"x", "-", "y", "-", "z"}], "\[Equal]", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747118779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["15", "2"], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["5", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "1"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{190, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247113007]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LinearProgramming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearProgramming"]], "InlineFormula"],
 " can be used to solve the same problem given in matrix notation:"
}], "ExampleText",
 CellID->20812021],

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "0"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->541483476],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearProgramming", "[", 
  RowBox[{
   RowBox[{"-", "c"}], ",", "m", ",", "b", ",", 
   RowBox[{"-", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->116676670],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "2"], ",", 
   FractionBox["1", "2"], ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{78, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->65281539]
}, Open  ]],

Cell["This computes the maximum value:", "ExampleText",
 CellID->600747964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"c", ".", "%"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->95719142],

Cell[BoxData[
 FractionBox["15", "2"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->33280130]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12675],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Maximize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Maximize"]], "InlineFormula"],
 " requires that all functions present in the input be real-valued:"
}], "ExampleText",
 CellID->42800722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Maximize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "x"}], "-", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "x", "]"}], "-", 
       RowBox[{"Sqrt", "[", "y", "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->215217577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346469573]
}, Open  ]],

Cell["\<\
Values for which the equation is satisfied but the square roots are not real \
are disallowed:\
\>", "ExampleText",
 CellID->45228127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", "x", "]"}], "-", 
      RowBox[{"Sqrt", "[", "y", "]"}]}], "\[Equal]", "0"}], ",", 
    RowBox[{"Sqrt", "[", "x", "]"}], ",", 
    RowBox[{"Sqrt", "[", "y", "]"}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->748279558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "\[ImaginaryI]", ",", "\[ImaginaryI]"}], 
  "}"}]], "Output",
 ImageSize->{85, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3201922]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMaximize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMaximize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMaximum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMaximum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearProgramming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearProgramming"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2593],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Inequalities-SymbolicMathematics"]], "Tutorials",\

 CellID->17843],

Cell[TextData[ButtonBox["Minimization and Maximization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MinimizationAndMaximization"]], "Tutorials",
 CellID->21693],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstrainedOptimizationOverview"]], "Tutorials",\

 CellID->78894921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->16466],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#24355"], None}]], "RelatedLinks",
 CellID->22951]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->74185673],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->165487088],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "MoreAbout",
 CellID->122187686],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->409792913],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->121011543]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Maximize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 6.7916034}", "context" -> "System`", 
    "keywords" -> {
     "constrained optimization", "cost function", "cylindrical decomposition",
       "exact optimization", "extremization", "global maximization", 
      "goal functions", "inequalities", "infeasible constraints", 
      "integer linear programming", "integer programming", 
      "linear fractional programming", "linear programming", 
      "LP (linear programming)", "maximization", "objective functions", 
      "operations research", "optimization", "parametric optimization", 
      "pay-off functions", "polynomial programming", "quadratic programming", 
      "simplex algorithm", "symbolic optimization"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Maximize[f, {x, y, ...}] maximizes f with respect to x, y, .... \
Maximize[{f, cons}, {x, y, ...}] maximizes f subject to the constraints cons. \
Maximize[{f, cons}, {x, y, ...}, dom] maximizes with variables over the \
domain dom, typically Reals or Integers.", "synonyms" -> {}, "title" -> 
    "Maximize", "type" -> "Symbol", "uri" -> "ref/Maximize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14354, 422, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->655143709]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 100269, 3189}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3028, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3651, 94, 4192, 83, 70, "ObjectNameGrid"],
Cell[7846, 179, 2616, 86, 70, "Usage",
 CellID->7266]
}, Open  ]],
Cell[CellGroupData[{
Cell[10499, 270, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10977, 287, 713, 27, 70, "Notes",
 CellID->18633],
Cell[11693, 316, 179, 5, 70, "Notes",
 CellID->13509],
Cell[11875, 323, 370, 14, 70, "Notes",
 CellID->24557],
Cell[12248, 339, 215, 7, 70, "Notes",
 CellID->2317],
Cell[12466, 348, 387, 14, 70, "Notes",
 CellID->148710633],
Cell[12856, 364, 354, 9, 70, "Notes",
 CellID->26134],
Cell[13213, 375, 106, 3, 70, "Notes",
 CellID->24196],
Cell[13322, 380, 327, 11, 70, "Notes",
 CellID->1683],
Cell[13652, 393, 665, 24, 70, "Notes",
 CellID->12258]
}, Closed]],
Cell[CellGroupData[{
Cell[14354, 422, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->655143709],
Cell[CellGroupData[{
Cell[14739, 436, 148, 5, 70, "ExampleSection",
 CellID->258949038],
Cell[14890, 443, 73, 1, 70, "ExampleText",
 CellID->95476681],
Cell[CellGroupData[{
Cell[14988, 448, 248, 9, 28, "Input",
 CellID->303084943],
Cell[15239, 459, 327, 12, 51, "Output",
 CellID->55740226]
}, Open  ]],
Cell[15581, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->187776654],
Cell[15709, 479, 74, 1, 70, "ExampleText",
 CellID->3230957],
Cell[CellGroupData[{
Cell[15808, 484, 306, 11, 70, "Input",
 CellID->114846595],
Cell[16117, 497, 360, 13, 36, "Output",
 CellID->13572201]
}, Open  ]],
Cell[16492, 513, 125, 3, 70, "ExampleDelimiter",
 CellID->275658031],
Cell[16620, 518, 86, 1, 70, "ExampleText",
 CellID->514914013],
Cell[CellGroupData[{
Cell[16731, 523, 393, 14, 70, "Input",
 CellID->306285297],
Cell[17127, 539, 507, 20, 55, "Output",
 CellID->3721301]
}, Open  ]],
Cell[17649, 562, 124, 3, 70, "ExampleDelimiter",
 CellID->61381153],
Cell[17776, 567, 88, 1, 70, "ExampleText",
 CellID->196243439],
Cell[CellGroupData[{
Cell[17889, 572, 236, 8, 28, "Input",
 CellID->55196351],
Cell[18128, 582, 2428, 44, 133, "Output",
 Evaluatable->False,
 CellID->77221029]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20605, 632, 216, 7, 70, "ExampleSection",
 CellID->5794],
Cell[20824, 641, 92, 1, 70, "ExampleText",
 CellID->268465082],
Cell[CellGroupData[{
Cell[20941, 646, 283, 10, 70, "Input",
 CellID->194093916],
Cell[21227, 658, 1533, 29, 70, "Output",
 Evaluatable->False,
 CellID->608185916]
}, Open  ]],
Cell[22775, 690, 124, 3, 70, "ExampleDelimiter",
 CellID->62740543],
Cell[22902, 695, 88, 1, 70, "ExampleText",
 CellID->9290849],
Cell[CellGroupData[{
Cell[23015, 700, 440, 16, 70, "Input",
 CellID->87280424],
Cell[23458, 718, 258, 9, 36, "Output",
 CellID->381937403]
}, Open  ]],
Cell[23731, 730, 125, 3, 70, "ExampleDelimiter",
 CellID->192428172],
Cell[23859, 735, 82, 1, 70, "ExampleText",
 CellID->207021031],
Cell[CellGroupData[{
Cell[23966, 740, 378, 12, 70, "Input",
 CellID->133973068],
Cell[24347, 754, 285, 10, 49, "Output",
 CellID->21618150]
}, Open  ]],
Cell[24647, 767, 124, 3, 70, "ExampleDelimiter",
 CellID->22982105],
Cell[24774, 772, 77, 1, 70, "ExampleText",
 CellID->454751844],
Cell[CellGroupData[{
Cell[24876, 777, 451, 15, 70, "Input",
 CellID->301089152],
Cell[25330, 794, 259, 9, 36, "Output",
 CellID->292806840]
}, Open  ]],
Cell[25604, 806, 124, 3, 70, "ExampleDelimiter",
 CellID->21103409],
Cell[25731, 811, 88, 1, 70, "ExampleText",
 CellID->101386429],
Cell[CellGroupData[{
Cell[25844, 816, 617, 18, 70, "Input",
 CellID->3561804],
Cell[26464, 836, 454, 16, 51, "Output",
 CellID->462841733]
}, Open  ]],
Cell[26933, 855, 125, 3, 70, "ExampleDelimiter",
 CellID->271356286],
Cell[27061, 860, 87, 1, 70, "ExampleText",
 CellID->260073986],
Cell[CellGroupData[{
Cell[27173, 865, 767, 23, 70, "Input",
 CellID->695124919],
Cell[27943, 890, 403, 14, 51, "Output",
 CellID->13688859]
}, Open  ]],
Cell[28361, 907, 125, 3, 70, "ExampleDelimiter",
 CellID->489602931],
Cell[28489, 912, 81, 1, 70, "ExampleText",
 CellID->472029359],
Cell[CellGroupData[{
Cell[28595, 917, 394, 14, 70, "Input",
 CellID->163965134],
Cell[28992, 933, 407, 15, 51, "Output",
 CellID->291400747]
}, Open  ]],
Cell[29414, 951, 125, 3, 70, "ExampleDelimiter",
 CellID->193283604],
Cell[29542, 956, 102, 2, 70, "ExampleText",
 CellID->392024223],
Cell[CellGroupData[{
Cell[29669, 962, 398, 14, 70, "Input",
 CellID->405571012],
Cell[30070, 978, 490, 19, 55, "Output",
 CellID->19657977]
}, Open  ]],
Cell[30575, 1000, 81, 1, 70, "ExampleText",
 CellID->426077459],
Cell[CellGroupData[{
Cell[30681, 1005, 345, 12, 70, "Input",
 CellID->101417820],
Cell[31029, 1019, 212, 5, 70, "Message",
 CellID->116123331],
Cell[31244, 1026, 340, 11, 36, "Output",
 CellID->34335003]
}, Open  ]],
Cell[31599, 1040, 83, 1, 70, "ExampleText",
 CellID->262241521],
Cell[CellGroupData[{
Cell[31707, 1045, 289, 10, 70, "Input",
 CellID->539447548],
Cell[31999, 1057, 211, 5, 70, "Message",
 CellID->15087942],
Cell[32213, 1064, 351, 11, 36, "Output",
 CellID->157334636]
}, Open  ]],
Cell[32579, 1078, 93, 1, 70, "ExampleText",
 CellID->353970800],
Cell[CellGroupData[{
Cell[32697, 1083, 334, 12, 70, "Input",
 CellID->248070447],
Cell[33034, 1097, 313, 6, 70, "Message",
 CellID->397555060],
Cell[33350, 1105, 370, 12, 36, "Output",
 CellID->223490698]
}, Open  ]],
Cell[33735, 1120, 124, 3, 70, "ExampleDelimiter",
 CellID->26152599],
Cell[33862, 1125, 66, 1, 70, "ExampleText",
 CellID->152197366],
Cell[CellGroupData[{
Cell[33953, 1130, 473, 17, 70, "Input",
 CellID->212088409],
Cell[34429, 1149, 343, 12, 51, "Output",
 CellID->179050512]
}, Open  ]],
Cell[34787, 1164, 125, 3, 70, "ExampleDelimiter",
 CellID->117376046],
Cell[34915, 1169, 79, 1, 70, "ExampleText",
 CellID->352688884],
Cell[CellGroupData[{
Cell[35019, 1174, 635, 21, 70, "Input",
 CellID->25329921],
Cell[35657, 1197, 476, 16, 51, "Output",
 CellID->598679417]
}, Open  ]],
Cell[36148, 1216, 125, 3, 70, "ExampleDelimiter",
 CellID->642251835],
Cell[36276, 1221, 66, 1, 70, "ExampleText",
 CellID->357845437],
Cell[CellGroupData[{
Cell[36367, 1226, 629, 21, 70, "Input",
 CellID->132161290],
Cell[36999, 1249, 316, 11, 36, "Output",
 CellID->80907841]
}, Open  ]],
Cell[37330, 1263, 123, 3, 70, "ExampleDelimiter",
 CellID->7039544],
Cell[37456, 1268, 81, 1, 70, "ExampleText",
 CellID->718818873],
Cell[CellGroupData[{
Cell[37562, 1273, 305, 11, 70, "Input",
 CellID->459540071],
Cell[37870, 1286, 2025, 37, 70, "Output",
 Evaluatable->False,
 CellID->950973757]
}, Open  ]],
Cell[39910, 1326, 124, 3, 70, "ExampleDelimiter",
 CellID->30496838],
Cell[40037, 1331, 78, 1, 70, "ExampleText",
 CellID->65207227],
Cell[CellGroupData[{
Cell[40140, 1336, 1068, 42, 70, "Input",
 CellID->298396418],
Cell[41211, 1380, 3640, 64, 70, "Output",
 Evaluatable->False,
 CellID->54185524]
}, Open  ]],
Cell[44866, 1447, 125, 3, 70, "ExampleDelimiter",
 CellID->462090459],
Cell[44994, 1452, 70, 1, 70, "ExampleText",
 CellID->115493641],
Cell[CellGroupData[{
Cell[45089, 1457, 752, 22, 70, "Input",
 CellID->111064747],
Cell[45844, 1481, 381, 13, 36, "Output",
 CellID->793341590]
}, Open  ]],
Cell[46240, 1497, 125, 3, 70, "ExampleDelimiter",
 CellID->528344132],
Cell[46368, 1502, 85, 1, 70, "ExampleText",
 CellID->119371554],
Cell[CellGroupData[{
Cell[46478, 1507, 513, 17, 70, "Input",
 CellID->529056659],
Cell[46994, 1526, 380, 14, 36, "Output",
 CellID->383579926]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47423, 1546, 218, 7, 70, "ExampleSection",
 CellID->21817],
Cell[CellGroupData[{
Cell[47666, 1557, 233, 7, 70, "ExampleSubsection",
 CellID->24837],
Cell[47902, 1566, 145, 4, 70, "ExampleText",
 CellID->422401855],
Cell[CellGroupData[{
Cell[48072, 1574, 810, 26, 70, "Input",
 CellID->5965103],
Cell[48885, 1602, 164, 5, 36, "Output",
 CellID->87383134]
}, Open  ]],
Cell[49064, 1610, 295, 10, 70, "ExampleText",
 CellID->358216118],
Cell[CellGroupData[{
Cell[49384, 1624, 811, 26, 70, "Input",
 CellID->173571601],
Cell[50198, 1652, 1990, 48, 247, "Output",
 CellID->28024974]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[52249, 1707, 223, 7, 70, "ExampleSection",
 CellID->28900],
Cell[52475, 1716, 112, 3, 70, "ExampleText",
 CellID->504661259],
Cell[CellGroupData[{
Cell[52612, 1723, 452, 16, 70, "Input",
 CellID->37864644],
Cell[53067, 1741, 389, 14, 51, "Output",
 CellID->49567029]
}, Open  ]],
Cell[53471, 1758, 123, 3, 70, "ExampleDelimiter",
 CellID->6354034],
Cell[53597, 1763, 104, 2, 70, "ExampleText",
 CellID->53431186],
Cell[53704, 1767, 572, 20, 70, "Input",
 CellID->545322231],
Cell[CellGroupData[{
Cell[54301, 1791, 578, 19, 70, "Input",
 CellID->100593768],
Cell[54882, 1812, 496, 18, 55, "Output",
 CellID->52956444]
}, Open  ]],
Cell[55393, 1833, 123, 3, 70, "ExampleDelimiter",
 CellID->3021488],
Cell[55519, 1838, 91, 1, 70, "ExampleText",
 CellID->776908962],
Cell[CellGroupData[{
Cell[55635, 1843, 537, 16, 70, "Input",
 CellID->503791689],
Cell[56175, 1861, 1985, 37, 70, "Output",
 Evaluatable->False,
 CellID->149243825]
}, Open  ]],
Cell[CellGroupData[{
Cell[58197, 1903, 261, 8, 70, "Input",
 CellID->253303408],
Cell[58461, 1913, 512, 17, 51, "Output",
 CellID->172521251]
}, Open  ]],
Cell[58988, 1933, 82, 1, 70, "ExampleText",
 CellID->135801757],
Cell[CellGroupData[{
Cell[59095, 1938, 1160, 33, 70, "Input",
 CellID->678258871],
Cell[60258, 1973, 2582, 46, 70, "Output",
 Evaluatable->False,
 CellID->485287338]
}, Open  ]],
Cell[CellGroupData[{
Cell[62877, 2024, 148, 5, 70, "Input",
 CellID->95051772],
Cell[63028, 2031, 644, 23, 58, "Output",
 CellID->52288650]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63721, 2060, 233, 7, 70, "ExampleSection",
 CellID->13232],
Cell[63957, 2069, 233, 7, 70, "ExampleText",
 CellID->83860016],
Cell[64193, 2078, 526, 19, 70, "Input",
 CellID->170192576],
Cell[CellGroupData[{
Cell[64744, 2101, 126, 4, 70, "Input",
 CellID->43630285],
Cell[64873, 2107, 311, 11, 51, "Output",
 CellID->235286166]
}, Open  ]],
Cell[CellGroupData[{
Cell[65221, 2123, 596, 19, 70, "Input",
 CellID->220378345],
Cell[65820, 2144, 3145, 56, 70, "Output",
 Evaluatable->False,
 CellID->402619480]
}, Open  ]],
Cell[68980, 2203, 258, 8, 70, "ExampleText",
 CellID->179571605],
Cell[CellGroupData[{
Cell[69263, 2215, 127, 4, 70, "Input",
 CellID->17885355],
Cell[69393, 2221, 295, 10, 36, "Output",
 CellID->12364738]
}, Open  ]],
Cell[CellGroupData[{
Cell[69725, 2236, 596, 19, 70, "Input",
 CellID->311368626],
Cell[70324, 2257, 3141, 56, 70, "Output",
 Evaluatable->False,
 CellID->385675119]
}, Open  ]],
Cell[73480, 2316, 234, 7, 70, "ExampleText",
 CellID->31148106],
Cell[CellGroupData[{
Cell[73739, 2327, 275, 10, 70, "Input",
 CellID->186995912],
Cell[74017, 2339, 491, 16, 36, "Output",
 CellID->192268000]
}, Open  ]],
Cell[CellGroupData[{
Cell[74545, 2360, 1153, 36, 70, "Input",
 CellID->560258836],
Cell[75701, 2398, 3210, 57, 70, "Output",
 Evaluatable->False,
 CellID->292854519]
}, Open  ]],
Cell[78926, 2458, 125, 3, 70, "ExampleDelimiter",
 CellID->148375834],
Cell[79054, 2463, 126, 3, 70, "ExampleText",
 CellID->195277511],
Cell[CellGroupData[{
Cell[79205, 2470, 609, 21, 70, "Input",
 CellID->237456092],
Cell[79817, 2493, 436, 16, 51, "Output",
 CellID->350654133]
}, Open  ]],
Cell[CellGroupData[{
Cell[80290, 2514, 252, 9, 70, "Input",
 CellID->27441563],
Cell[80545, 2525, 161, 5, 36, "Output",
 CellID->578190848]
}, Open  ]],
Cell[80721, 2533, 236, 10, 70, "ExampleText",
 CellID->460857148],
Cell[CellGroupData[{
Cell[80982, 2547, 1015, 33, 70, "Input",
 CellID->721702684],
Cell[82000, 2582, 3299, 58, 70, "Output",
 Evaluatable->False,
 CellID->510574352]
}, Open  ]],
Cell[85314, 2643, 250, 8, 70, "ExampleText",
 CellID->556211698],
Cell[CellGroupData[{
Cell[85589, 2655, 558, 20, 70, "Input",
 CellID->421324397],
Cell[86150, 2677, 440, 8, 70, "Message",
 CellID->119410906],
Cell[86593, 2687, 436, 16, 51, "Output",
 CellID->266762706]
}, Open  ]],
Cell[87044, 2706, 199, 6, 70, "ExampleText",
 CellID->794807772],
Cell[CellGroupData[{
Cell[87268, 2716, 367, 13, 70, "Input",
 CellID->390848494],
Cell[87638, 2731, 212, 5, 70, "Message",
 CellID->617957896],
Cell[87853, 2738, 332, 12, 36, "Output",
 CellID->44596113]
}, Open  ]],
Cell[88200, 2753, 124, 3, 70, "ExampleDelimiter",
 CellID->11671239],
Cell[88327, 2758, 216, 7, 70, "ExampleText",
 CellID->922674425],
Cell[CellGroupData[{
Cell[88568, 2769, 619, 18, 70, "Input",
 CellID->747118779],
Cell[89190, 2789, 454, 16, 51, "Output",
 CellID->247113007]
}, Open  ]],
Cell[89659, 2808, 258, 7, 70, "ExampleText",
 CellID->20812021],
Cell[89920, 2817, 1170, 41, 70, "Input",
 CellID->541483476],
Cell[CellGroupData[{
Cell[91115, 2862, 201, 6, 70, "Input",
 CellID->116676670],
Cell[91319, 2870, 275, 10, 51, "Output",
 CellID->65281539]
}, Open  ]],
Cell[91609, 2883, 75, 1, 70, "ExampleText",
 CellID->600747964],
Cell[CellGroupData[{
Cell[91709, 2888, 91, 3, 70, "Input",
 CellID->95719142],
Cell[91803, 2893, 178, 6, 51, "Output",
 CellID->33280130]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[92030, 2905, 226, 7, 70, "ExampleSection",
 CellID->12675],
Cell[92259, 2914, 241, 7, 70, "ExampleText",
 CellID->42800722],
Cell[CellGroupData[{
Cell[92525, 2925, 405, 14, 70, "Input",
 CellID->215217577],
Cell[92933, 2941, 317, 11, 36, "Output",
 CellID->346469573]
}, Open  ]],
Cell[93265, 2955, 144, 4, 70, "ExampleText",
 CellID->45228127],
Cell[CellGroupData[{
Cell[93434, 2963, 495, 17, 70, "Input",
 CellID->748279558],
Cell[93932, 2982, 241, 8, 36, "Output",
 CellID->3201922]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[94234, 2997, 311, 9, 70, "SeeAlsoSection",
 CellID->18140],
Cell[94548, 3008, 1433, 53, 70, "SeeAlso",
 CellID->11094]
}, Open  ]],
Cell[CellGroupData[{
Cell[96018, 3066, 313, 9, 70, "TutorialsSection",
 CellID->2593],
Cell[96334, 3077, 157, 4, 70, "Tutorials",
 CellID->17843],
Cell[96494, 3083, 167, 3, 70, "Tutorials",
 CellID->21693],
Cell[96664, 3088, 171, 4, 70, "Tutorials",
 CellID->78894921]
}, Open  ]],
Cell[CellGroupData[{
Cell[96872, 3097, 321, 9, 70, "RelatedLinksSection",
 CellID->16466],
Cell[97196, 3108, 254, 5, 70, "RelatedLinks",
 CellID->22951]
}, Open  ]],
Cell[CellGroupData[{
Cell[97487, 3118, 318, 9, 70, "MoreAboutSection",
 CellID->74185673],
Cell[97808, 3129, 128, 3, 70, "MoreAbout",
 CellID->165487088],
Cell[97939, 3134, 136, 3, 70, "MoreAbout",
 CellID->122187686],
Cell[98078, 3139, 147, 3, 70, "MoreAbout",
 CellID->409792913],
Cell[98228, 3144, 179, 3, 70, "MoreAbout",
 CellID->121011543]
}, Open  ]],
Cell[98422, 3150, 50, 0, 70, "History"],
Cell[98475, 3152, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

