(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39479,       1457]
NotebookOptionsPosition[     31846,       1188]
NotebookOutlinePosition[     33146,       1224]
CellTagsIndexPosition[     33060,       1219]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
          "MedianDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MedianDeviation"], 
          "StandardDeviation" :> 
          Documentation`HelpLookup["paclet:ref/StandardDeviation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mean\"\>", 
       2->"\<\"MedianDeviation\"\>", 
       3->"\<\"StandardDeviation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       4->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       5->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MeanDeviation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MeanDeviation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MeanDeviation"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the mean absolute deviation from the mean of the \
elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5384]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["n", "TI"]]}], "}"}]], "InlineFormula"],
 ", the mean deviation is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "n"], 
    RowBox[{
     UnderscriptBox["\[Sum]", "i"], 
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{
       SubscriptBox["x", "i"], "-", 
       OverscriptBox["x", "_"]}], "\[RightBracketingBar]"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]], "InlineMath"],
 " is the mean of the list."
}], "Notes",
 CellID->7738],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->28487],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MeanDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeanDeviation"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"MeanDeviation", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"MeanDeviation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26555],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->22482]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93676089],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->171057286],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " of a list:"
}], "ExampleText",
 CellID->336147900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22425],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"a", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{"b", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
     "]"}]}], ")"}]}]], "Output",
 ImageSize->{468, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->422832448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90435593],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " of columns of a matrix:"
}], "ExampleText",
 CellID->234915771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "15"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36247193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "2"], ",", 
   FractionBox["9", "2"]}], "}"}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->146070484]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5446],

Cell["Compute results at machine precision:", "ExampleText",
 CellID->379986608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216003675],

Cell[BoxData["0.23844655709397097`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->565503625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "15", ",", "10", ",", "8"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["3.83333333333333333333333333333333333334`29.427229384774023"], \
"Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->511219913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.25002794206548495`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102971513]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.2498438470127594`", ",", "0.2500961603940172`", ",", 
   "0.24991944943621078`", ",", "0.25012201210990365`", ",", 
   "0.25012366058408514`", ",", "0.2500476966073683`", ",", 
   "0.2499117028565811`", ",", "0.250130415665507`", ",", 
   "0.24998011654694602`", ",", "0.24990633934283252`"}], "}"}]], "Output",
 ImageSize->{396, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502348180]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19412],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288981640]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["99", "5000"], ",", 
   FractionBox["99", "2500"], ",", 
   FractionBox["49", "625"], ",", 
   FractionBox["147", "1250"], ",", 
   FractionBox["98", "625"], ",", 
   FractionBox["49", "250"], ",", 
   FractionBox["147", "625"], ",", 
   FractionBox["343", "1250"], ",", 
   FractionBox["196", "625"], ",", 
   FractionBox["441", "1250"]}], "}"}]], "Output",
 ImageSize->{405, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196758165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of absolute deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->866035301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57098655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.466554218308547`", ",", "3.4371685080195347`", ",", "9.82403646584623`", 
   ",", "7.093717805399509`", ",", "9.49632554103366`", ",", 
   "5.942115750951336`", ",", "9.742437259118548`", ",", "4.10855845979728`", 
   ",", "8.167490450985294`", ",", "1.6831775533541538`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10110998]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Mean", "[", "data", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120365439],

Cell[BoxData["2.468643303195239`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438848199]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->73093501],

Cell[BoxData["2.468643303195239`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23324899]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83903156],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " is equivalent to the 1\[Hyphen]norm of the deviations divided by the ",
 Cell[BoxData[
  ButtonBox["Length",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Length"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19367069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21398448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.1165619037196506`", ",", "6.657224871150602`", ",", 
   "0.8224898333970887`", ",", "4.896281952202026`", ",", 
   "4.473124763936809`", ",", "0.18983278339558485`", ",", 
   "9.474665477899567`", ",", "2.371308004796626`", ",", "8.975765763138078`",
    ",", "2.1018396528780547`"}], "}"}]], "Output",
 ImageSize->{375, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299689884]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"data", "-", 
     RowBox[{"Mean", "[", "data", "]"}]}], ",", "1"}], "]"}], "/", 
  RowBox[{"Length", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->436530018],

Cell[BoxData["2.7875030650140076`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->152388715]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->535897644],

Cell[BoxData["2.7875030650140076`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->526191804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->543634770],

Cell[TextData[{
 "For large uniform ",
 "dataset",
 "s, ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " are nearly the same:"
}], "ExampleText",
 CellID->68140390],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", 
     RowBox[{"10", "^", "6"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212321697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36438168],

Cell[BoxData["2.4986977225918836`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118861375]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->432525148],

Cell[BoxData["2.499153074619526`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->327279577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70099947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " as a scaled ",
 Cell[BoxData[
  ButtonBox["ManhattanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ManhattanDistance"]], "InlineFormula"],
 " from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->394865487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463545505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625850780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mean", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mean", "[", "data", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"Length", "[", "data", "]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132468290],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    FractionBox["1", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{264, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460965870]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->917053855],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"a", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{"b", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
     "]"}]}], ")"}]}]], "Output",
 ImageSize->{468, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->231739440]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ManhattanDistance", "[", 
   RowBox[{"data", ",", "mean"}], "]"}], "/", 
  RowBox[{"Length", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->42727618],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"a", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{"b", "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
     "]"}]}], ")"}]}]], "Output",
 ImageSize->{468, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->64798254]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20132],

Cell[TextData[{
 "Ratio of ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 " for increasing sample size: "
}], "ExampleText",
 CellID->191652913],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"10", ",", 
     RowBox[{"10", "^", "5"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25556991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"MeanDeviation", "[", 
      RowBox[{"Take", "[", 
       RowBox[{"data", ",", "i"}], "]"}], "]"}], "/", 
     RowBox[{"MedianDeviation", "[", 
      RowBox[{"Take", "[", 
       RowBox[{"data", ",", "i"}], "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5000", ",", 
      RowBox[{"10", "^", "5"}], ",", "5000"}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->572307205],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 0.9957474262416939}, {2., 0.9970286405645783}, {3., 
     0.9943186104474623}, {4., 0.995548094905992}, {5., 0.997209981760428}, {
     6., 0.9966973590890027}, {7., 0.9977320030642152}, {8., 
     0.9990604400522065}, {9., 0.9996367710799456}, {10., 
     0.9987065941492557}, {11., 0.9988844956016303}, {12., 
     0.9982086451872063}, {13., 0.9985688038907542}, {14., 
     0.9991311504461484}, {15., 1.0001843713284697`}, {16., 
     0.9999308547193559}, {17., 0.9997944582790996}, {18., 
     1.0000688740528214`}, {19., 1.0004535595148736`}, {20., 
     1.0007771753131545`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0., 20.}, {0.9943186104474623, 1.0007771753131545`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440832566]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5030],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19782]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30383],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->76997437],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->130949785],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->254666831],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->617974019],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->377115816]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanDeviation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 19.3700504}", "context" -> "System`", 
    "keywords" -> {"dispersion", "robust estimates", "robust estimation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MeanDeviation[list] gives the mean absolute deviation from the mean of \
the elements in list.", "synonyms" -> {"mean deviation"}, "title" -> 
    "MeanDeviation", "type" -> "Symbol", "uri" -> "ref/MeanDeviation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9134, 290, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->93676089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32918, 1212}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2787, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3410, 92, 1578, 37, 70, "ObjectNameGrid"],
Cell[4991, 131, 601, 19, 70, "Usage",
 CellID->5384]
}, Open  ]],
Cell[CellGroupData[{
Cell[5629, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6107, 172, 878, 33, 70, "Notes",
 CellID->7738],
Cell[6988, 207, 220, 7, 70, "Notes",
 CellID->28487],
Cell[7211, 216, 1554, 55, 70, "Notes",
 CellID->26555],
Cell[8768, 273, 329, 12, 70, "Notes",
 CellID->22482]
}, Closed]],
Cell[CellGroupData[{
Cell[9134, 290, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93676089],
Cell[CellGroupData[{
Cell[9518, 304, 148, 5, 70, "ExampleSection",
 CellID->171057286],
Cell[9669, 311, 198, 7, 70, "ExampleText",
 CellID->336147900],
Cell[CellGroupData[{
Cell[9892, 322, 162, 5, 28, "Input",
 CellID->22425],
Cell[10057, 329, 874, 31, 51, "Output",
 CellID->422832448]
}, Open  ]],
Cell[10946, 363, 124, 3, 70, "ExampleDelimiter",
 CellID->90435593],
Cell[11073, 368, 211, 7, 70, "ExampleText",
 CellID->234915771],
Cell[CellGroupData[{
Cell[11309, 379, 380, 13, 70, "Input",
 CellID->36247193],
Cell[11692, 394, 247, 9, 51, "Output",
 CellID->146070484]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11988, 409, 215, 7, 70, "ExampleSection",
 CellID->5446],
Cell[12206, 418, 80, 1, 70, "ExampleText",
 CellID->379986608],
Cell[CellGroupData[{
Cell[12311, 423, 171, 5, 70, "Input",
 CellID->216003675],
Cell[12485, 430, 177, 5, 36, "Output",
 CellID->565503625]
}, Open  ]],
Cell[12677, 438, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[12805, 443, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[12906, 448, 260, 8, 70, "Input",
 CellID->190699768],
Cell[13169, 458, 219, 6, 36, "Output",
 CellID->511219913]
}, Open  ]],
Cell[13403, 467, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[13531, 472, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[13644, 477, 196, 6, 70, "Input",
 CellID->315224713],
Cell[13843, 485, 177, 5, 36, "Output",
 CellID->102971513]
}, Open  ]],
Cell[CellGroupData[{
Cell[14057, 495, 250, 8, 70, "Input",
 CellID->594479966],
Cell[14310, 505, 487, 12, 54, "Output",
 CellID->502348180]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14846, 523, 239, 7, 70, "ExampleSection",
 CellID->19412],
Cell[15088, 532, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[15324, 544, 570, 19, 70, "Input",
 CellID->19878761],
Cell[15897, 565, 484, 17, 36, "Output",
 CellID->288981640]
}, Open  ]],
Cell[CellGroupData[{
Cell[16418, 587, 110, 3, 70, "Input",
 CellID->235263230],
Cell[16531, 592, 544, 17, 51, "Output",
 CellID->196758165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17124, 615, 232, 7, 70, "ExampleSection",
 CellID->2549],
Cell[17359, 624, 461, 17, 70, "ExampleText",
 CellID->866035301],
Cell[CellGroupData[{
Cell[17845, 645, 157, 5, 70, "Input",
 CellID->57098655],
Cell[18005, 652, 467, 11, 54, "Output",
 CellID->10110998]
}, Open  ]],
Cell[CellGroupData[{
Cell[18509, 668, 193, 6, 70, "Input",
 CellID->120365439],
Cell[18705, 676, 175, 5, 36, "Output",
 CellID->438848199]
}, Open  ]],
Cell[CellGroupData[{
Cell[18917, 686, 111, 3, 70, "Input",
 CellID->73093501],
Cell[19031, 691, 174, 5, 36, "Output",
 CellID->23324899]
}, Open  ]],
Cell[19220, 699, 124, 3, 70, "ExampleDelimiter",
 CellID->83903156],
Cell[19347, 704, 377, 12, 70, "ExampleText",
 CellID->19367069],
Cell[CellGroupData[{
Cell[19749, 720, 157, 5, 70, "Input",
 CellID->21398448],
Cell[19909, 727, 478, 12, 54, "Output",
 CellID->299689884]
}, Open  ]],
Cell[CellGroupData[{
Cell[20424, 744, 248, 8, 70, "Input",
 CellID->436530018],
Cell[20675, 754, 176, 5, 36, "Output",
 CellID->152388715]
}, Open  ]],
Cell[CellGroupData[{
Cell[20888, 764, 112, 3, 70, "Input",
 CellID->535897644],
Cell[21003, 769, 176, 5, 36, "Output",
 CellID->526191804]
}, Open  ]],
Cell[21194, 777, 125, 3, 70, "ExampleDelimiter",
 CellID->543634770],
Cell[21322, 782, 393, 15, 70, "ExampleText",
 CellID->68140390],
Cell[21718, 799, 204, 7, 70, "Input",
 CellID->212321697],
Cell[CellGroupData[{
Cell[21947, 810, 111, 3, 70, "Input",
 CellID->36438168],
Cell[22061, 815, 176, 5, 36, "Output",
 CellID->118861375]
}, Open  ]],
Cell[CellGroupData[{
Cell[22274, 825, 114, 3, 70, "Input",
 CellID->432525148],
Cell[22391, 830, 175, 5, 36, "Output",
 CellID->327279577]
}, Open  ]],
Cell[22581, 838, 124, 3, 70, "ExampleDelimiter",
 CellID->70099947],
Cell[22708, 843, 469, 17, 70, "ExampleText",
 CellID->394865487],
Cell[CellGroupData[{
Cell[23202, 864, 152, 5, 70, "Input",
 CellID->463545505],
Cell[23357, 871, 213, 7, 36, "Output",
 CellID->625850780]
}, Open  ]],
Cell[CellGroupData[{
Cell[23607, 883, 251, 8, 70, "Input",
 CellID->132468290],
Cell[23861, 893, 538, 19, 51, "Output",
 CellID->460965870]
}, Open  ]],
Cell[CellGroupData[{
Cell[24436, 917, 112, 3, 70, "Input",
 CellID->917053855],
Cell[24551, 922, 874, 31, 51, "Output",
 CellID->231739440]
}, Open  ]],
Cell[CellGroupData[{
Cell[25462, 958, 201, 6, 70, "Input",
 CellID->42727618],
Cell[25666, 966, 873, 31, 51, "Output",
 CellID->64798254]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26588, 1003, 224, 7, 70, "ExampleSection",
 CellID->20132],
Cell[26815, 1012, 372, 13, 70, "ExampleText",
 CellID->191652913],
Cell[27190, 1027, 203, 7, 70, "Input",
 CellID->25556991],
Cell[CellGroupData[{
Cell[27418, 1038, 512, 16, 70, "Input",
 CellID->572307205],
Cell[27933, 1056, 1042, 24, 121, "Output",
 CellID->440832566]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29036, 1087, 310, 9, 70, "SeeAlsoSection",
 CellID->5030],
Cell[29349, 1098, 720, 26, 70, "SeeAlso",
 CellID->19782]
}, Open  ]],
Cell[CellGroupData[{
Cell[30106, 1129, 314, 9, 70, "TutorialsSection",
 CellID->30383],
Cell[30423, 1140, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[30616, 1148, 299, 8, 70, "MoreAboutSection"],
Cell[30918, 1158, 154, 3, 70, "MoreAbout",
 CellID->76997437],
Cell[31075, 1163, 185, 3, 70, "MoreAbout",
 CellID->130949785],
Cell[31263, 1168, 179, 3, 70, "MoreAbout",
 CellID->254666831],
Cell[31445, 1173, 175, 3, 70, "MoreAbout",
 CellID->617974019],
Cell[31623, 1178, 151, 3, 70, "MoreAbout",
 CellID->377115816]
}, Open  ]],
Cell[31789, 1184, 27, 0, 70, "History"],
Cell[31819, 1186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

