(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44378,       1618]
NotebookOptionsPosition[     35470,       1297]
NotebookOutlinePosition[     36740,       1335]
CellTagsIndexPosition[     36654,       1330]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DescriptiveStatistics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Statistics\"\>", 
       2->"\<\"Descriptive Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], 
          "Commonest" :> Documentation`HelpLookup["paclet:ref/Commonest"], 
          "TrimmedMean" :> Documentation`HelpLookup["paclet:ref/TrimmedMean"],
           "Quantile" :> Documentation`HelpLookup["paclet:ref/Quantile"], 
          "MedianDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MedianDeviation"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Max" :> 
          Documentation`HelpLookup["paclet:ref/Max"], "Ordering" :> 
          Documentation`HelpLookup["paclet:ref/Ordering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mean\"\>", 2->"\<\"Commonest\"\>", 
       3->"\<\"TrimmedMean\"\>", 4->"\<\"Quantile\"\>", 
       5->"\<\"MedianDeviation\"\>", 6->"\<\"Sort\"\>", 7->"\<\"Max\"\>", 
       8->"\<\"Ordering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Statistics" :> 
          Documentation`HelpLookup["paclet:guide/Statistics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 
       3->"\<\"Math & Counting Operations on Lists\"\>", 
       4->"\<\"Numerical Data\"\>", 
       5->"\<\"Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Median", "ObjectName",
 CellID->28290],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Median",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Median"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the median of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " gives the center element in the sorted version of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", or the average of the two center elements if ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " is of even length. "
}], "Notes",
 CellID->985],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Median", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"Median", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->21447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->1084]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->348759309],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->203419814],

Cell["Find the middle value in the list:", "ExampleText",
 CellID->30037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5506],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542859482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317369567],

Cell["Average the two middle values:", "ExampleText",
 CellID->5053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", ",", 
    "8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9793],

Cell[BoxData[
 FractionBox["9", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513383048]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3609],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " works with any real numeric quantities:"
}], "ExampleText",
 CellID->13924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", "E", ",", "Pi", ",", 
    RowBox[{"Pi", "^", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19854],

Cell[BoxData["\[ExponentialE]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361790900]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], ",", "E", ",", "Pi", ",", 
    RowBox[{"Pi", "^", "2"}], ",", "1", ",", "2", ",", "3", ",", "4"}], "}"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12239],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", "\[ExponentialE]"}], "2"]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44371813]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24209],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " finds medians of elements in each column:"
}], "ExampleText",
 CellID->15492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"2", "Pi"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", 
      RowBox[{"3", "Pi"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"2", " ", "\[Pi]"}]}], "}"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->693569788]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->158391064],

Cell["Obtain results at any precision: ", "ExampleText",
 CellID->160553898],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "10", ",", "4", ",", "25", ",", "2", ",", "1"}], "}"}],
     ",", "30"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190699768],

Cell[BoxData["4.5`29.999999999999996"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183794594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "6"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.5007058280564813`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252662775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "5"}], ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5001822689052355`", ",", "0.4990107092896573`", ",", 
   "0.49953155403216565`", ",", "0.5010642985415049`", ",", 
   "0.5001248772607346`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278025037]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31036],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}], ",", "1"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "17", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 17, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}], ",", "1"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14905495]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350893094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13647],

Cell["\<\
Obtain a robust estimate of location when outliers are present:\
\>", "ExampleText",
 CellID->273453718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "5", ",", "2", ",", "6", ",", "10", ",", 
    RowBox[{"10", "^", "5"}], ",", "5", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128754409],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45929716]
}, Open  ]],

Cell[TextData[{
 "Extreme values have a large influence on the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9445300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "2", ",", "6", ",", "10", ",", 
     RowBox[{"10", "^", "5"}], ",", "5", ",", "4"}], "}"}], "]"}], "//", 
  "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79767602],

Cell[BoxData["12504.125`"], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->384997358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->384117222],

Cell["Medians of random reals approach a Gaussian distribution:", \
"ExampleText",
 CellID->31708],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Sort", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Median", "[", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", "100"}], "]"}], "]"}], ",", 
     RowBox[{"{", "1000", "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15618],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWdtrXEUYP9lzdre7aVLbmLRYlKigog+KFETUJtukqaxpjMQSaC11SYsN
2DaukYIXqNhLLKn1CmY3gTS0Aeljqr5JwRd9EF999h85fvPN7cw33zm7mwZL
w+bMzsx3+c13m5mzh2vzp0+dqc3PztQGD9Vrc6dnZz4cHDtXh6GwKwiCO/Bf
2xPA9xi+4f+dOIb2YfEMb938G4auLf4erCRGp4+sB/IvOfrnH//CyK+//KNG
+3FUSMS/oA8eEXRz0OagDVW7S0xGho6ZTfZ1uzNl/CFoQ0ZLsvVXh1jzEoN5
ogy9AtoXX3e4yNvg6BWPQpKjPb6eTfL1doRQ90VgdIk2Yavx6qry+UDHq+5R
ng+KBnuqnR9sK01OrMHoSKUZ7G5DgoedzrdYy73YSvDlOtWzFTaKZJ0Yem0J
Em+gQyttBnXYAf39jKB+tbYgHN7fUHJ2/k/exUqWN/02vXG/rYUUEEjwwdji
6n327tKXsFO7u0varmJ3l36tU2I7cfx20/FwDgabHKU7Lvwx9dZNPdUIGjgn
VtQMdDE1dli78VcFaEJhjNB6o0BsH5F+vsV8p/QPurxtrlXVqLQqOFL16TyV
0kf621v0KT2VtzcdpY3tgyPLAuePZk5WE/gCJRdqCsZdchU/cFLgL0I6KM+K
7ntL59SIy5d+CyRtZaipaL9ztGMghidrt1WWSgTj1RuK+lve2vg4Or2ewvUN
yyVtBmngcNnVfu0gk3kBK3CoRw+sKOrrrA7JVZ/bcLggN9X8VyxXkVghJDZb
dJCVNDJIZ0FIvXEVqXWOaxfz1VuAoBFfJtalaL6U/E59plUkJH1a4bu1L5w1
WDtdYXQI/0WqzZLdQ/BHxHOXUmQn9xNqE20r3JnETWa00hQVN09wf8HIzsfu
HkBl4x4eTr25pvDmCd4LLWRm1YVdjp0bwTYSK596sVJkVp5TFhLtgEWLniuS
3Ps45iIcT7uRjlnxKZLsO8/y7bW+RG0FEosfGS6B7bFYZd9wcrX2tPQBq2Mw
NtmHOsoE2fss1xMkEiDTG93Euu856J5BG2jLNRj6GVbTcw4+qalMYuQEy/kC
atTWaxg+a79jLN++FD6LdNqLm2QkYnUhES/al70ooOuYiv1YL1LJTIQm+6+i
FhPz8CmROJjcAi3Dno1otB3epBbRHfUsVSSeqzLStZ1Ramp9E19fj7ksttgP
pUjPvgNwdkKcIk/GRpZF9JZIJI14kVSM3TO3XtVE7NayMsE8FHOxjL6OTJ6a
mLP5/QrL93bsZx3F/pLhFPiOOjb1V7qP1fMO4jM1y3jarutFlu9dgo9yPe9g
Oxm7dbREoulZVscpz3YlYrunWb7ZmFa6Atknn2L5zhAPF8je8qQXK1zVSZ5r
RB+rvtkVlrw9+/E4O09jJqppv+74XueT1fHoFuiYx76pCWp3s9Z5ZJM6RPd8
isdsZd7DSG91svmEWIWe8nanyMxCTCvZZ45V/NPqgBczur5o1Ppkc4GVZPMX
3055Mfs59jFB2HtCXwaXzixtGfJex2Tvxdhkb+JEa5HtYHVcZNdjdfBclwky
ekvqZbkWYn0rtJbvcdaAtwbvZmTttJ2Vy3NZNN0sF96AvJuezZSyg2xR28mh
ttYteRHk3W4ycgCl583dTr2pkbiZPbqNd3G0f008IoMfPvcqXXTxpornm/0N
+Y6qvIWY8fYcHhjWWZMm27ybzTzNXNf+fqO6enXhLiut/dOL8CK+CxC//8jX
0Fpii1OKj2lsdAUkiHcrNuZ8qspQw7EDTzVf/xlIjh/7icSvxDpeXYVZyL4s
GdHkhLplwqJKGXSQ/wfFeW0JniVHG75bCReu3IXJubMbAS9FYpo+si5FZFJx
sqwmu64sGXJd4neVLCpY1bmzG+IXSJ5qWbq36z8SZiaZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->579393015]
}, Open  ]],

Cell["Theoretical curve:", "ExampleText",
 CellID->283170534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sd", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"UniformDistribution", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", 
       RowBox[{"1", "/", "2"}]}], "]"}]}], "/", "2"}], "/", 
   RowBox[{"Sqrt", "[", "100", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->239048488],

Cell[BoxData[
 FractionBox["1", "20"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99200092]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"InverseCDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "sd"}], "]"}], ",", 
     RowBox[{"q", "/", "1000"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"q", ",", "1", ",", "1000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->358209183],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmGuIVVUUx8/cM/feuU0zOk2SYQ+FqEgNP/ShqDCwshDpQVLRg6ZJmAFL
mUYKpXAojEottYeTU37oAT0+GIkRGERCJERCJEQFYRD2IQmSPgwEt9/e6zz2
3Wedcx8zKNEwc87Ze6/132ut/1prnzOrh8ZH1j46ND46PLRw5djQhpHR4ccX
3rx+jKmwKwiCA/ytmx/wXOfJ/h2o17m718Vcu1kqcS9xD6P7OWbVLNTjH3/V
Hcf3gZz5udxDZRf3HgRLzLUseyZXqxOE+tg8zmm0tAWNfnOpuBqt6fV1qNff
loXx2FDYZe52bmnbXvZFzAbVxNbcuP5Xo3JlCxoZW/31JrbPJDZGr9TuPqc5
Jp3YGLYhfybzY/Fp4s32oHIybjHyZzIyS+p6Jy7u+4NOXFrt+3n9Pu377nk0
L1p5Mxm5nk81zh799rd01li+N4jbXSLz6cEfrEseUtkbt7v+f8PrUaN6tSe1
wBv76ymKwvHuXV+lbCazG8cPNs4qmjetmJqe/seTCcJj3/8e7ftGo/y+t77h
V8mm9Y99Es1GqWl/7GOmuuMcLif73b3mvRMn/kr3a6zRSr2oas1jyZH48IPv
iMdeBccwY8/1cj3uGZFF3Y6dxOOO294+dWpatcVlN+kXGYnQeiWWmNlJBSn2
XkdwuhsGEV0o6QCl6saeEA8//JHxbE+GqWqjvseQFQyhmZwy+fJ6I//RniJF
gm/e9JmRek2Vkgge/vIXsIwtrzbkXiXeaXRkPy4Hr6gYInX8+J9IvfvO0WB3
A0bNrk7uORJh7FQxrFQ360ht33b45Mm/X1Lleq3cx/uPkaTQidz2TPT0PC9F
mRBH0Z5aZSJDYggYjAQvKqxW1Mh6+e6faynyxJZDxu/nFeS4Bvwu5SMOWMTP
D/1MdB64733cN1xtzUF0K8Lvh3EUBi0inBFsCuy5rV8c+frX4FkF0c26koJo
GargLalGEgFGKH/68Y+JJlhFXXq+xYRcIkiRCD1gPp3huqr4V4riYO4XWCSY
dZGgY7OaXReZS1WkCTW+QB5+YUnwhKqxyGqwDjkEEQ12oSljbDCeaBhLLrWS
zLOKzKpb94ENkybrNqjYl5tLD0yDDU3YDvc8UK1MrmtAt99VPfAJIgUPOvZT
dLCK7IiKv8zqEAyKFubQwS7CI/iPqDpXWR28IEKyj+hgIkF4KMOPy7StQuXE
ucbBJCbEUPwUzPuVPKr6qE3q5zonOu4OUEv475mFHW5wdiAP4EqSB5dw7K4O
dzDDGy2yZBiBltSBLkiDutsLqiznFHL2uMVcapBNmkiHXn79JMcbKUrTN6fG
qhz84q8ELUKrrR/AAs4WvOuwXZJtKzOZU3W8cLPlzjhr3QxMuFyhZu0aO4YI
YScowU8QJikWLFe17rU7AepmjVhMaK5NdIxVD5pRFf7FKvGOkOKvvD1m0Ies
hlSfxANS0QZDqizBXmvtYEtYYnuMwHzpA0wuU9FtxVfFdrEH9KjbLFU1bD+p
sIW0GmljGHNFhhmtpv3T1Xa0inQ7MVg6+GVNKkHLHH88Vvd7OpswvGQWsDfG
2EACDDHkFVFe1CG2GT5pBmUyQQ4I4ms4vlhBbHbWbrJIlAtMElUoNaf2hTlI
Rbb5neApOwkamPiN0wsyvFc96+IzdovVJWbS+NA9X82wiViOYpJ36PNUuWes
nLx1Aom78xI5s5997wklBMb/c1UUkaK68ch8JQ02YNi3MfNWGr0dD6gYIkWd
RVJzVakX7BhLIqk5mchl3hiVU3Cbs5d57FdY9b5FkhJsltUGu0QQZhszCPGX
EjT53DdDbDO07/KhfAWYx7NzMJP/2xWebjvsmHASVPPYq6B1dpbtiBmPvup7
M4znnV4vW830C/usupZR9tsnpGPS4ZpJpVakUulO8EPvz8cQKSikN5vHWgPG
Ti+CtQIMaomTrJlU+hVey8RMqxL/XBGL0iqp5WRIcWb4fIpt8o+T2UYlsIR3
ZqhhwidpQ/IUoYUF50crGO2eHDmYLZwbwiXtnXe4/LwRKd5Lo3FPm1Jmp112
lbOkEGOqYDbo+hd67e9r\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->409762261]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26727],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " is equivalent to a parametrized ",
 Cell[BoxData[
  ButtonBox["Quantile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quantile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->153083683],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"20", ",", "50"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278425048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{"data", ",", 
   RowBox[{"1", "/", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90261944],

Cell[BoxData["11.0398511980096`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9955898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->115183643],

Cell[BoxData["11.0398511980096`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->570160280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->948186085],

Cell[TextData[{
 "For nearly symmetric samples, ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " are nearly the same:"
}], "ExampleText",
 CellID->79908064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "4", ",", "3", ",", "1", ",", 
     "1"}], "}"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15712],

Cell[BoxData["2.375`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403787414]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Median", "[", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2", ",", "3", ",", "4", ",", "4", ",", "3", ",", "1", ",", 
     "1"}], "}"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21909],

Cell[BoxData["2.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->183055382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270791786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " of absolute deviations from the ",
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["MedianDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MedianDeviation"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->866035301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57098655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.7730900130365526`", ",", "6.15665877444602`", ",", "2.379274144784569`", 
   ",", "9.42960119583111`", ",", "8.83526908663219`", ",", 
   "9.881432102312848`", ",", "3.758485732686061`", ",", "5.820535196077358`",
    ",", "7.167837685879734`", ",", "4.281518060078873`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86723354]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MedianDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73093501],

Cell[BoxData["2.538391676973064`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104616915]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Median", "[", "data", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->120365439],

Cell[BoxData["2.538391676973064`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->158959128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->503717345],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MovingMedian",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MovingMedian"]], "InlineFormula"],
 " is a sequence of medians:"
}], "ExampleText",
 CellID->331423122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MovingMedian", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10", ",", "6"}], "}"}], 
   ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->99227007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "3", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191641111]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Median", "[", 
    RowBox[{"Take", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10", ",", "6"}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"i", "+", "2"}]}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->527641572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "3", ",", "6"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72536816]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20130],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Median",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Median"]], "InlineFormula"],
 " requires numeric values:"
}], "ExampleText",
 CellID->9090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9034],

Cell[BoxData[
 RowBox[{
  RowBox[{"Median", "::", "\<\"rectn\"\>"}], ":", 
  " ", "\<\"Rectangular array of real numbers is expected at position \\!\\(1\
\\) in \\!\\(Median[\\(\\({a, b, c}\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellID->83941391],

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378774318]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15338],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Commonest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Commonest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrimmedMean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrimmedMean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ordering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ordering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17342]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->592],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->8996],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Median",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Median"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->8719947],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->190020660],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->329909659],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->111940855],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->318520533],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->535973568]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Median - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 20.9794666}", "context" -> "System`", 
    "keywords" -> {
     "2nd quartile", "50th percentile", "central value", "median", 
      "order statistics"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Median[list] gives the median of the elements in list. ", 
    "synonyms" -> {}, "title" -> "Median", "type" -> "Symbol", "uri" -> 
    "ref/Median"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7233, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->348759309]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36511, 1323}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3212, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3835, 97, 44, 1, 70, "ObjectName",
 CellID->28290],
Cell[3882, 100, 555, 18, 70, "Usage",
 CellID->1898]
}, Open  ]],
Cell[CellGroupData[{
Cell[4474, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4952, 140, 463, 15, 70, "Notes",
 CellID->985],
Cell[5418, 157, 1461, 54, 70, "Notes",
 CellID->21447],
Cell[6882, 213, 314, 12, 70, "Notes",
 CellID->1084]
}, Closed]],
Cell[CellGroupData[{
Cell[7233, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->348759309],
Cell[CellGroupData[{
Cell[7618, 244, 148, 5, 70, "ExampleSection",
 CellID->203419814],
Cell[7769, 251, 73, 1, 70, "ExampleText",
 CellID->30037],
Cell[CellGroupData[{
Cell[7867, 256, 198, 6, 28, "Input",
 CellID->5506],
Cell[8068, 264, 158, 5, 36, "Output",
 CellID->542859482]
}, Open  ]],
Cell[8241, 272, 125, 3, 70, "ExampleDelimiter",
 CellID->317369567],
Cell[8369, 277, 68, 1, 70, "ExampleText",
 CellID->5053],
Cell[CellGroupData[{
Cell[8462, 282, 213, 7, 70, "Input",
 CellID->9793],
Cell[8678, 291, 178, 6, 51, "Output",
 CellID->513383048]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8905, 303, 215, 7, 70, "ExampleSection",
 CellID->3609],
Cell[9123, 312, 209, 7, 70, "ExampleText",
 CellID->13924],
Cell[CellGroupData[{
Cell[9357, 323, 258, 8, 70, "Input",
 CellID->19854],
Cell[9618, 333, 172, 5, 36, "Output",
 CellID->361790900]
}, Open  ]],
Cell[CellGroupData[{
Cell[9827, 343, 268, 8, 70, "Input",
 CellID->12239],
Cell[10098, 353, 214, 7, 51, "Output",
 CellID->44371813]
}, Open  ]],
Cell[10327, 363, 121, 3, 70, "ExampleDelimiter",
 CellID->24209],
Cell[10451, 368, 211, 7, 70, "ExampleText",
 CellID->15492],
Cell[CellGroupData[{
Cell[10687, 379, 355, 13, 70, "Input",
 CellID->16499],
Cell[11045, 394, 231, 8, 36, "Output",
 CellID->693569788]
}, Open  ]],
Cell[11291, 405, 125, 3, 70, "ExampleDelimiter",
 CellID->158391064],
Cell[11419, 410, 76, 1, 70, "ExampleText",
 CellID->160553898],
Cell[CellGroupData[{
Cell[11520, 415, 253, 8, 70, "Input",
 CellID->190699768],
Cell[11776, 425, 180, 5, 36, "Output",
 CellID->183794594]
}, Open  ]],
Cell[11971, 433, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[12099, 438, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[12212, 443, 189, 6, 70, "Input",
 CellID->315224713],
Cell[12404, 451, 176, 5, 36, "Output",
 CellID->252662775]
}, Open  ]],
Cell[CellGroupData[{
Cell[12617, 461, 242, 8, 70, "Input",
 CellID->594479966],
Cell[12862, 471, 336, 10, 36, "Output",
 CellID->278025037]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13247, 487, 239, 7, 70, "ExampleSection",
 CellID->31036],
Cell[13489, 496, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[13725, 508, 580, 19, 70, "Input",
 CellID->19878761],
Cell[14308, 529, 493, 17, 36, "Output",
 CellID->14905495]
}, Open  ]],
Cell[CellGroupData[{
Cell[14838, 551, 103, 3, 70, "Input",
 CellID->235263230],
Cell[14944, 556, 291, 9, 36, "Output",
 CellID->350893094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15284, 571, 223, 7, 70, "ExampleSection",
 CellID->13647],
Cell[15510, 580, 114, 3, 70, "ExampleText",
 CellID->273453718],
Cell[CellGroupData[{
Cell[15649, 587, 236, 6, 70, "Input",
 CellID->128754409],
Cell[15888, 595, 157, 5, 36, "Output",
 CellID->45929716]
}, Open  ]],
Cell[16060, 603, 218, 8, 70, "ExampleText",
 CellID->9445300],
Cell[CellGroupData[{
Cell[16303, 615, 263, 8, 70, "Input",
 CellID->79767602],
Cell[16569, 625, 167, 5, 36, "Output",
 CellID->384997358]
}, Open  ]],
Cell[16751, 633, 125, 3, 70, "ExampleDelimiter",
 CellID->384117222],
Cell[16879, 638, 98, 2, 70, "ExampleText",
 CellID->31708],
Cell[CellGroupData[{
Cell[17002, 644, 325, 10, 70, "Input",
 CellID->15618],
Cell[17330, 656, 2147, 39, 70, "Output",
 Evaluatable->False,
 CellID->579393015]
}, Open  ]],
Cell[19492, 698, 61, 1, 70, "ExampleText",
 CellID->283170534],
Cell[CellGroupData[{
Cell[19578, 703, 397, 13, 70, "Input",
 CellID->239048488],
Cell[19978, 718, 178, 6, 51, "Output",
 CellID->99200092]
}, Open  ]],
Cell[CellGroupData[{
Cell[20193, 729, 381, 12, 70, "Input",
 CellID->358209183],
Cell[20577, 743, 2307, 42, 70, "Output",
 Evaluatable->False,
 CellID->409762261]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22933, 791, 233, 7, 70, "ExampleSection",
 CellID->26727],
Cell[23169, 800, 331, 12, 70, "ExampleText",
 CellID->153083683],
Cell[23503, 814, 178, 6, 70, "Input",
 CellID->278425048],
Cell[CellGroupData[{
Cell[23706, 824, 346, 12, 70, "Input",
 CellID->90261944],
Cell[24055, 838, 172, 5, 36, "Output",
 CellID->9955898]
}, Open  ]],
Cell[CellGroupData[{
Cell[24264, 848, 105, 3, 70, "Input",
 CellID->115183643],
Cell[24372, 853, 174, 5, 36, "Output",
 CellID->570160280]
}, Open  ]],
Cell[24561, 861, 125, 3, 70, "ExampleDelimiter",
 CellID->948186085],
Cell[24689, 866, 349, 13, 70, "ExampleText",
 CellID->79908064],
Cell[CellGroupData[{
Cell[25063, 883, 240, 8, 70, "Input",
 CellID->15712],
Cell[25306, 893, 163, 5, 36, "Output",
 CellID->403787414]
}, Open  ]],
Cell[CellGroupData[{
Cell[25506, 903, 242, 8, 70, "Input",
 CellID->21909],
Cell[25751, 913, 161, 5, 36, "Output",
 CellID->183055382]
}, Open  ]],
Cell[25927, 921, 125, 3, 70, "ExampleDelimiter",
 CellID->270791786],
Cell[26055, 926, 469, 17, 70, "ExampleText",
 CellID->866035301],
Cell[CellGroupData[{
Cell[26549, 947, 157, 5, 70, "Input",
 CellID->57098655],
Cell[26709, 954, 466, 11, 54, "Output",
 CellID->86723354]
}, Open  ]],
Cell[CellGroupData[{
Cell[27212, 970, 113, 3, 70, "Input",
 CellID->73093501],
Cell[27328, 975, 175, 5, 36, "Output",
 CellID->104616915]
}, Open  ]],
Cell[CellGroupData[{
Cell[27540, 985, 197, 6, 70, "Input",
 CellID->120365439],
Cell[27740, 993, 175, 5, 36, "Output",
 CellID->158959128]
}, Open  ]],
Cell[27930, 1001, 125, 3, 70, "ExampleDelimiter",
 CellID->503717345],
Cell[28058, 1006, 211, 7, 70, "ExampleText",
 CellID->331423122],
Cell[CellGroupData[{
Cell[28294, 1017, 224, 7, 70, "Input",
 CellID->99227007],
Cell[28521, 1026, 223, 7, 36, "Output",
 CellID->191641111]
}, Open  ]],
Cell[CellGroupData[{
Cell[28781, 1038, 454, 15, 70, "Input",
 CellID->527641572],
Cell[29238, 1055, 222, 7, 36, "Output",
 CellID->72536816]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29509, 1068, 226, 7, 70, "ExampleSection",
 CellID->20130],
Cell[29738, 1077, 193, 7, 70, "ExampleText",
 CellID->9090],
Cell[CellGroupData[{
Cell[29956, 1088, 154, 5, 70, "Input",
 CellID->9034],
Cell[30113, 1095, 246, 5, 70, "Message",
 CellID->83941391],
Cell[30362, 1102, 248, 8, 36, "Output",
 CellID->378774318]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30671, 1117, 311, 9, 70, "SeeAlsoSection",
 CellID->15338],
Cell[30985, 1128, 1917, 71, 70, "SeeAlso",
 CellID->17342]
}, Open  ]],
Cell[CellGroupData[{
Cell[32939, 1204, 312, 9, 70, "TutorialsSection",
 CellID->592],
Cell[33254, 1215, 141, 3, 70, "Tutorials",
 CellID->8996],
Cell[33398, 1220, 156, 3, 70, "Tutorials",
 CellID->4063544]
}, Open  ]],
Cell[CellGroupData[{
Cell[33591, 1228, 305, 8, 70, "RelatedLinksSection"],
Cell[33899, 1238, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[34293, 1255, 317, 9, 70, "MoreAboutSection",
 CellID->8719947],
Cell[34613, 1266, 155, 3, 70, "MoreAbout",
 CellID->190020660],
Cell[34771, 1271, 157, 3, 70, "MoreAbout",
 CellID->329909659],
Cell[34931, 1276, 190, 4, 70, "MoreAbout",
 CellID->111940855],
Cell[35124, 1282, 139, 3, 70, "MoreAbout",
 CellID->318520533],
Cell[35266, 1287, 132, 3, 70, "MoreAbout",
 CellID->535973568]
}, Open  ]],
Cell[35413, 1293, 27, 0, 70, "History"],
Cell[35443, 1295, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

