(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30595,       1160]
NotebookOptionsPosition[     24123,        938]
NotebookOutlinePosition[     25598,        978]
CellTagsIndexPosition[     25513,        973]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing and Searching List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TestingAndSearchingListElements"], 
          "Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Testing and Searching List Elements\"\>", 
       2->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FreeQ" :> Documentation`HelpLookup["paclet:ref/FreeQ"], 
          "Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Count" :> Documentation`HelpLookup["paclet:ref/Count"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "IntervalMemberQ" :> 
          Documentation`HelpLookup["paclet:ref/IntervalMemberQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FreeQ\"\>", 2->"\<\"Element\"\>", 
       3->"\<\"Count\"\>", 4->"\<\"Cases\"\>", 
       5->"\<\"IntervalMemberQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Pattern Matching Functions" :> 
          Documentation`HelpLookup["paclet:guide/PatternMatchingFunctions"], 
          "Rules & Patterns" :> 
          Documentation`HelpLookup["paclet:guide/RulesAndPatterns"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Expressions\"\>", 3->"\<\"Language Overview\"\>", 
       4->"\<\"List Manipulation\"\>", 
       5->"\<\"Pattern Matching Functions\"\>", 6->"\<\"Rules & Patterns\"\>",
        7->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MemberQ", "ObjectName",
 CellID->24816],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MemberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MemberQ"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if an element of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " matches ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MemberQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MemberQ"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["levelspec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]tests all parts of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " specified by ",
     Cell[BoxData[
      StyleBox["levelspec", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be a pattern. "
}], "Notes",
 CellID->15319],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " can have any head, not necessarily ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5589],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemberQ"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " immediately tests whether any expression in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " matches ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 "; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["dom", "TI"]}], "]"}]], "InlineFormula"],
 " asserts that ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is an element of the symbolic domain ",
 Cell[BoxData[
  StyleBox["dom", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5513],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " uses standard level specifications:"
}], "Notes",
 CellID->18259],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[{
     "levels ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], Cell[TextData[{
     "levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->20851],

Cell[TextData[{
 "The default value for ",
 Cell[BoxData[
  StyleBox["levelspec", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"{", "1", "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32271],

Cell[TextData[{
 "A positive level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " specified by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " indices."
}], "Notes",
 CellID->23283],

Cell[TextData[{
 "A negative level ",
 Cell[BoxData[
  RowBox[{"-", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " consists of all parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with depth ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4364],

Cell[TextData[{
 "Level ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " consists of numbers, symbols and other objects that do not have subparts."
}], "Notes",
 CellID->27038],

Cell[TextData[{
 "Level ",
 Cell[BoxData["0"], "InlineFormula"],
 " corresponds to the whole expression."
}], "Notes",
 CellID->3012],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " looks at heads of expressions, and their parts."
}], "Notes",
 CellID->3184]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213715140],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->314974005],

Cell[TextData[{
 "Test whether ",
 Cell[BoxData["2"], "InlineFormula"],
 " is a member of a list:"
}], "ExampleText",
 CellID->231875166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214274302],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297608941]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->565],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " works with patterns:"
}], "ExampleText",
 CellID->162528210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"y", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "}"}], ",", 
   RowBox[{"x", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20416],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94795786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41446031],

Cell[TextData[{
 "Test down to level ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->313951566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", "0", 
   ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->967420666],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47533224]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " normally only tests level ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->573291433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "3", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "2", ",", "2"}], "}"}]}], "}"}], ",", "0"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222060889],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57163869]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20967],

Cell[TextData[{
 "Test whether ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["2", "i"], TraditionalForm]], "InlineMath"],
 " is ever equal to 1 modulo 7:"
}], "ExampleText",
 CellID->418706100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mod", "[", 
    RowBox[{
     RowBox[{"2", "^", "i"}], ",", "7"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698754643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "1", ",", "2", ",", "4", ",", "1", ",", "2", ",", "4", 
   ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->420677501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"2", "^", "i"}], ",", "7"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7095003],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->97834725]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13787],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " tests for structural matches, not numerical equality:"
}], "ExampleText",
 CellID->128502178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1", ",", "3"}], "}"}], ",", "1."}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20871308],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->536712881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318616286],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " does not test for subsequences:"
}], "ExampleText",
 CellID->53926675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->266501222],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76225010]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " does:"
}], "ExampleText",
 CellID->219441744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FreeQ", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{"a", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223846919],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50429546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->550443270],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MemberQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MemberQ"]], "InlineFormula"],
 " by default only operates at level ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"y", "^", "2"}]}], "}"}], "}"}], ",", 
   RowBox[{"x", "^", "_"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18222],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16439]
}, Open  ]],

Cell[TextData[{
 "Include level ",
 Cell[BoxData["2"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemberQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "^", "2"}], ",", 
      RowBox[{"y", "^", "2"}]}], "}"}], "}"}], ",", 
   RowBox[{"x", "^", "_"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6648],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26804]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27714],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntervalMemberQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntervalMemberQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27649]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21759],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndSearchingListElements"]], "Tutorials",\

 CellID->23501],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->9574]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MemberQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->518353802],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->10802707],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->241529464],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->117567748],

Cell[TextData[ButtonBox["Pattern Matching Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PatternMatchingFunctions"]], "MoreAbout",
 CellID->136083439],

Cell[TextData[ButtonBox["Rules & Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RulesAndPatterns"]], "MoreAbout",
 CellID->53594204],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->72647344]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MemberQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 22.4638796}", "context" -> "System`", 
    "keywords" -> {
     "contains", "depends on", "element of a list", "list member", 
      "membership test", "present in list", "test for elements in lists", 
      "testing for presence"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MemberQ[list, form] returns True if an element of list matches form, and \
False otherwise. MemberQ[list, form, levelspec] tests all parts of list \
specified by levelspec. ", "synonyms" -> {"member q"}, "title" -> "MemberQ", 
    "type" -> "Symbol", "uri" -> "ref/MemberQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10923, 377, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->213715140]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25369, 966}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3207, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3830, 97, 45, 1, 70, "ObjectName",
 CellID->24816],
Cell[3878, 100, 1534, 51, 70, "Usage",
 CellID->28488]
}, Open  ]],
Cell[CellGroupData[{
Cell[5449, 156, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5927, 173, 127, 5, 70, "Notes",
 CellID->15319],
Cell[6057, 180, 345, 13, 70, "Notes",
 CellID->5589],
Cell[6405, 195, 854, 32, 70, "Notes",
 CellID->5513],
Cell[7262, 229, 201, 7, 70, "Notes",
 CellID->18259],
Cell[7466, 238, 1664, 55, 70, "2ColumnTableMod",
 CellID->20851],
Cell[9133, 295, 338, 14, 70, "Notes",
 CellID->32271],
Cell[9474, 311, 303, 12, 70, "Notes",
 CellID->23283],
Cell[9780, 325, 311, 13, 70, "Notes",
 CellID->4364],
Cell[10094, 340, 189, 6, 70, "Notes",
 CellID->27038],
Cell[10286, 348, 133, 5, 70, "Notes",
 CellID->3012],
Cell[10422, 355, 464, 17, 70, "Notes",
 CellID->3184]
}, Closed]],
Cell[CellGroupData[{
Cell[10923, 377, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->213715140],
Cell[CellGroupData[{
Cell[11308, 391, 148, 5, 70, "ExampleSection",
 CellID->314974005],
Cell[11459, 398, 137, 5, 70, "ExampleText",
 CellID->231875166],
Cell[CellGroupData[{
Cell[11621, 407, 208, 7, 28, "Input",
 CellID->214274302],
Cell[11832, 416, 161, 5, 36, "Output",
 CellID->297608941]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12042, 427, 214, 7, 70, "ExampleSection",
 CellID->565],
Cell[12259, 436, 196, 7, 70, "ExampleText",
 CellID->162528210],
Cell[CellGroupData[{
Cell[12480, 447, 283, 10, 70, "Input",
 CellID->20416],
Cell[12766, 459, 160, 5, 36, "Output",
 CellID->94795786]
}, Open  ]],
Cell[12941, 467, 124, 3, 70, "ExampleDelimiter",
 CellID->41446031],
Cell[13068, 472, 121, 5, 70, "ExampleText",
 CellID->313951566],
Cell[CellGroupData[{
Cell[13214, 481, 335, 11, 70, "Input",
 CellID->967420666],
Cell[13552, 494, 160, 5, 36, "Output",
 CellID->47533224]
}, Open  ]],
Cell[13727, 502, 246, 9, 70, "ExampleText",
 CellID->573291433],
Cell[CellGroupData[{
Cell[13998, 515, 324, 11, 70, "Input",
 CellID->222060889],
Cell[14325, 528, 161, 5, 36, "Output",
 CellID->57163869]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14535, 539, 223, 7, 70, "ExampleSection",
 CellID->20967],
Cell[14761, 548, 194, 7, 70, "ExampleText",
 CellID->418706100],
Cell[CellGroupData[{
Cell[14980, 559, 256, 9, 70, "Input",
 CellID->698754643],
Cell[15239, 570, 291, 9, 36, "Output",
 CellID->420677501]
}, Open  ]],
Cell[CellGroupData[{
Cell[15567, 584, 324, 11, 70, "Input",
 CellID->7095003],
Cell[15894, 597, 160, 5, 36, "Output",
 CellID->97834725]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16103, 608, 226, 7, 70, "ExampleSection",
 CellID->13787],
Cell[16332, 617, 229, 7, 70, "ExampleText",
 CellID->128502178],
Cell[CellGroupData[{
Cell[16586, 628, 198, 7, 70, "Input",
 CellID->20871308],
Cell[16787, 637, 162, 5, 36, "Output",
 CellID->536712881]
}, Open  ]],
Cell[16964, 645, 125, 3, 70, "ExampleDelimiter",
 CellID->318616286],
Cell[17092, 650, 206, 7, 70, "ExampleText",
 CellID->53926675],
Cell[CellGroupData[{
Cell[17323, 661, 184, 6, 70, "Input",
 CellID->266501222],
Cell[17510, 669, 161, 5, 36, "Output",
 CellID->76225010]
}, Open  ]],
Cell[17686, 677, 177, 7, 70, "ExampleText",
 CellID->219441744],
Cell[CellGroupData[{
Cell[17888, 688, 182, 6, 70, "Input",
 CellID->223846919],
Cell[18073, 696, 161, 5, 36, "Output",
 CellID->50429546]
}, Open  ]],
Cell[18249, 704, 125, 3, 70, "ExampleDelimiter",
 CellID->550443270],
Cell[18377, 709, 250, 9, 70, "ExampleText",
 CellID->27224],
Cell[CellGroupData[{
Cell[18652, 722, 275, 10, 70, "Input",
 CellID->18222],
Cell[18930, 734, 158, 5, 36, "Output",
 CellID->16439]
}, Open  ]],
Cell[19103, 742, 112, 5, 70, "ExampleText",
 CellID->27441],
Cell[CellGroupData[{
Cell[19240, 751, 284, 10, 70, "Input",
 CellID->6648],
Cell[19527, 763, 157, 5, 36, "Output",
 CellID->26804]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19745, 775, 311, 9, 70, "SeeAlsoSection",
 CellID->27714],
Cell[20059, 786, 1180, 44, 70, "SeeAlso",
 CellID->27649]
}, Open  ]],
Cell[CellGroupData[{
Cell[21276, 835, 314, 9, 70, "TutorialsSection",
 CellID->21759],
Cell[21593, 846, 179, 4, 70, "Tutorials",
 CellID->23501],
Cell[21775, 852, 169, 3, 70, "Tutorials",
 CellID->9574]
}, Open  ]],
Cell[CellGroupData[{
Cell[21981, 860, 305, 8, 70, "RelatedLinksSection"],
Cell[22289, 870, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22711, 888, 299, 8, 70, "MoreAboutSection"],
Cell[23013, 898, 144, 3, 70, "MoreAbout",
 CellID->518353802],
Cell[23160, 903, 133, 3, 70, "MoreAbout",
 CellID->10802707],
Cell[23296, 908, 145, 3, 70, "MoreAbout",
 CellID->241529464],
Cell[23444, 913, 145, 3, 70, "MoreAbout",
 CellID->117567748],
Cell[23592, 918, 162, 3, 70, "MoreAbout",
 CellID->136083439],
Cell[23757, 923, 143, 3, 70, "MoreAbout",
 CellID->53594204],
Cell[23903, 928, 148, 3, 70, "MoreAbout",
 CellID->72647344]
}, Open  ]],
Cell[24066, 934, 27, 0, 70, "History"],
Cell[24096, 936, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

