(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     79579,       1759]
NotebookOptionsPosition[     75283,       1620]
NotebookOutlinePosition[     76809,       1661]
CellTagsIndexPosition[     76723,       1656]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mesh" :> Documentation`HelpLookup["paclet:ref/Mesh"], 
          "MeshFunctions" :> 
          Documentation`HelpLookup["paclet:ref/MeshFunctions"], "MeshStyle" :> 
          Documentation`HelpLookup["paclet:ref/MeshStyle"], "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"], "PlotStyle" :> 
          Documentation`HelpLookup["paclet:ref/PlotStyle"], "ContourShading" :> 
          Documentation`HelpLookup["paclet:ref/ContourShading"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mesh\"\>", 
       2->"\<\"MeshFunctions\"\>", 3->"\<\"MeshStyle\"\>", 
       4->"\<\"ColorFunction\"\>", 5->"\<\"PlotStyle\"\>", 
       6->"\<\"ContourShading\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Plotting Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MeshShading", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["MeshShading",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
     "\[LineSeparator]is an option for plotting functions that gives lists of \
colors to use for regions between mesh divisions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31665]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MeshShading", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that directives ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be used cyclically for each of the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "+", "1"}]], "InlineFormula"],
 " regions defined by ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " mesh divisions. "
}], "Notes",
 CellID->18908],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MeshShading", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["12", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["21", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " should be used cyclically for the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["i", "TI"], ",", 
   StyleBox["j", "TI"]}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " patch defined by two mesh functions. "
}], "Notes",
 CellID->20340],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " mesh functions are specified, the setting for ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " should be an array of depth ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1360],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->2814],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"MeshShading", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that no additional directives associated with mesh regions \
should be added. "
}], "Notes",
 CellID->21154],

Cell[TextData[{
 "The elements of the ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " array should be color directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 ", or named colors such as ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 ". They can also include ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18012],

Cell[TextData[{
 "In cases where regions defined by ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " are surfaces, directives such as ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " can be used."
}], "Notes",
 CellID->19752],

Cell[TextData[{
 "When the regions defined by ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " are lines, directives such as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " can also be used."
}], "Notes",
 CellID->3338],

Cell[TextData[{
 "Directives can be combined using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Directive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directive"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8706]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5375916],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->508979203],

Cell["Style the areas between mesh lines:", "ExampleText",
 CellID->418097482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"1", "-", 
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Yellow", ",", "Orange"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Pink", ",", "Red"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->770854980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129656153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->669635292],

Cell["Alternate colors along a curve:", "ExampleText",
 CellID->273957992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"4", "\[Theta]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "15"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435522418],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188244361]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->207032376],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["ColorFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorFunction"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16353097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"v", "+", "u"}], ")"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "}"}], ",", 
      RowBox[{"Hue", "[", "x", "]"}]}], "]"}]}], ",", 
   RowBox[{"MeshFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"#3", "&"}], "}"}]}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2116078110],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228893770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1746042364],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MeshShading",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeshShading"]], "InlineFormula"],
 " to remove portions of a surface:"
}], "ExampleText",
 CellID->369975493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], " ", 
      RowBox[{"Sin", "[", "v", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "v", "]"}], " ", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Cos", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"MeshShading", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", 
         RowBox[{"Red", ",", "None"}], "]"}], ",", 
        RowBox[{"FaceForm", "[", 
         RowBox[{"None", ",", "Blue"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"FaceForm", "[", 
         RowBox[{"None", ",", "Cyan"}], "]"}], ",", 
        RowBox[{"FaceForm", "[", 
         RowBox[{"Orange", ",", "None"}], "]"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1212952786],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175494313]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3079],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourShading"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8313]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with MeshShading",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MeshShading"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->611911104],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->76057836],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->344054831]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeshShading - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 38.8705496}", "context" -> "System`", 
    "keywords" -> {
     "mesh shading", "overlay mesh patterns", "mesh texture", "texture", 
      "surface texture", "curve texture", "surface patches", "curve segments",
       "ribbon plots", "checker board", "checker board plot", 
      "surface stencil", "gobo surface"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MeshShading is an option for plotting functions that gives lists of \
colors to use for regions between mesh divisions. ", 
    "synonyms" -> {"mesh shading"}, "title" -> "MeshShading", "type" -> 
    "Symbol", "uri" -> "ref/MeshShading"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10432, 355, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5375916]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 76581, 1649}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1916, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2539, 69, 1576, 37, 70, "ObjectNameGrid"],
Cell[4118, 108, 497, 14, 70, "Usage",
 CellID->31665]
}, Open  ]],
Cell[CellGroupData[{
Cell[4652, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5130, 144, 713, 26, 70, "Notes",
 CellID->18908],
Cell[5846, 172, 1016, 36, 70, "Notes",
 CellID->20340],
Cell[6865, 210, 382, 14, 70, "Notes",
 CellID->1360],
Cell[7250, 226, 342, 13, 70, "Notes",
 CellID->2814],
Cell[7595, 241, 310, 10, 70, "Notes",
 CellID->21154],
Cell[7908, 253, 888, 33, 70, "Notes",
 CellID->18012],
Cell[8799, 288, 644, 23, 70, "Notes",
 CellID->19752],
Cell[9446, 313, 507, 18, 70, "Notes",
 CellID->3338],
Cell[9956, 333, 439, 17, 70, "Notes",
 CellID->8706]
}, Closed]],
Cell[CellGroupData[{
Cell[10432, 355, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5375916],
Cell[CellGroupData[{
Cell[10815, 369, 148, 5, 70, "ExampleSection",
 CellID->508979203],
Cell[10966, 376, 78, 1, 70, "ExampleText",
 CellID->418097482],
Cell[CellGroupData[{
Cell[11069, 381, 683, 22, 47, "Input",
 CellID->770854980],
Cell[11755, 405, 19602, 325, 160, "Output",
 Evaluatable->False,
 CellID->129656153]
}, Open  ]],
Cell[31372, 733, 125, 3, 70, "ExampleDelimiter",
 CellID->669635292],
Cell[31500, 738, 74, 1, 70, "ExampleText",
 CellID->273957992],
Cell[CellGroupData[{
Cell[31599, 743, 476, 14, 47, "Input",
 CellID->435522418],
Cell[32078, 759, 10420, 175, 201, "Output",
 Evaluatable->False,
 CellID->188244361]
}, Open  ]],
Cell[42513, 937, 125, 3, 70, "ExampleDelimiter",
 CellID->207032376],
Cell[42641, 942, 332, 13, 70, "ExampleText",
 CellID->16353097],
Cell[CellGroupData[{
Cell[42998, 959, 999, 31, 65, "Input",
 CellID->2116078110],
Cell[44000, 992, 10558, 177, 180, "Output",
 Evaluatable->False,
 CellID->228893770]
}, Open  ]],
Cell[54573, 1172, 126, 3, 70, "ExampleDelimiter",
 CellID->1746042364],
Cell[54702, 1177, 225, 8, 70, "ExampleText",
 CellID->369975493],
Cell[CellGroupData[{
Cell[54952, 1189, 1093, 34, 65, "Input",
 CellID->1212952786],
Cell[56048, 1225, 15918, 265, 227, "Output",
 Evaluatable->False,
 CellID->175494313]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72027, 1497, 310, 9, 70, "SeeAlsoSection",
 CellID->3079],
Cell[72340, 1508, 1458, 53, 70, "SeeAlso",
 CellID->8313]
}, Open  ]],
Cell[CellGroupData[{
Cell[73835, 1566, 305, 8, 70, "RelatedLinksSection"],
Cell[74143, 1576, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[74547, 1593, 319, 9, 70, "MoreAboutSection",
 CellID->611911104],
Cell[74869, 1604, 142, 3, 70, "MoreAbout",
 CellID->76057836],
Cell[75014, 1609, 197, 4, 70, "MoreAbout",
 CellID->344054831]
}, Open  ]],
Cell[75226, 1616, 27, 0, 70, "History"],
Cell[75256, 1618, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

