(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24257,        851]
NotebookOptionsPosition[     20178,        717]
NotebookOutlinePosition[     21620,        756]
CellTagsIndexPosition[     21535,        751]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"Mathematica Sessions\"\>", 
       3->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Print" :> Documentation`HelpLookup["paclet:ref/Print"], 
          "CellPrint" :> Documentation`HelpLookup["paclet:ref/CellPrint"], 
          "Write" :> Documentation`HelpLookup["paclet:ref/Write"], "On" :> 
          Documentation`HelpLookup["paclet:ref/On"], "Off" :> 
          Documentation`HelpLookup["paclet:ref/Off"], "Quiet" :> 
          Documentation`HelpLookup["paclet:ref/Quiet"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"], "MessageList" :> 
          Documentation`HelpLookup["paclet:ref/MessageList"], "Beep" :> 
          Documentation`HelpLookup["paclet:ref/Beep"], "MessageName" :> 
          Documentation`HelpLookup["paclet:ref/MessageName"], "Messages" :> 
          Documentation`HelpLookup["paclet:ref/Messages"], "Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Print\"\>", 2->"\<\"CellPrint\"\>", 
       3->"\<\"Write\"\>", 4->"\<\"On\"\>", 5->"\<\"Off\"\>", 
       6->"\<\"Quiet\"\>", 7->"\<\"Check\"\>", 8->"\<\"MessageList\"\>", 
       9->"\<\"Beep\"\>", 10->"\<\"MessageName\"\>", 11->"\<\"Messages\"\>", 
       12->"\<\"Information\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> Documentation`HelpLookup["paclet:guide/Messages"],
           "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"Package Development\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Message", "ObjectName",
 CellID->14899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Message",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Message"], "[", 
       RowBox[{
        StyleBox["symbol", "TI"], "::", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints the message ",
     Cell[BoxData[
      RowBox[{
       StyleBox["symbol", "TI"], "::", 
       StyleBox["tag", "TI"]}]], "InlineFormula"],
     " unless it has been switched off. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Message",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Message"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["symbol", "TI"], "::", 
         StyleBox["tag", "TI"]}], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints a message, inserting the values of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " as needed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " generates output on the channel ",
 Cell[BoxData[
  ButtonBox["$Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Messages"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10415],

Cell[TextData[{
 "You can switch off a message using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    StyleBox["symbol", "TI"], "::", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 ". You can switch on a message using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{
    StyleBox["symbol", "TI"], "::", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3644],

Cell[TextData[{
 "Between any two successive input lines, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " prints a message with a particular name at most three times. On the last \
occurrence, it prints the message ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", "stop"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5436],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    ButtonBox["General",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/General"], "::", "stop"}], "]"}]], 
  "InlineFormula"],
 " makes ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " not stop repeating messages. "
}], "Notes",
 CellID->23669],

Cell[TextData[{
 "During the evaluation of a particular input line, names of messages \
associated with that input line are appended to the list ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 ", wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". At the end of the evaluation of the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " input line, the value of ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " is assigned to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10378],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"], "[", 
   RowBox[{
    StyleBox["mname", "TI"], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is printed as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StringForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringForm"], "[", 
   RowBox[{
    StyleBox["mess", "TI"], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  StyleBox["mess", "TI"]], "InlineFormula"],
 " is the value of the message ",
 Cell[BoxData[
  StyleBox["mname", "TI"]], "InlineFormula"],
 ". Entries of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"`", 
    StyleBox["i", "TI"], "`"}]]], "InlineFormula"],
 " in the string ",
 Cell[BoxData[
  StyleBox["mess", "TI"]], "InlineFormula"],
 " are replaced by the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31676],

Cell[TextData[{
 "Given a message specified as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " first searches for messages ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"], "::", 
   SubscriptBox[
    StyleBox["lang", "TI"], 
    StyleBox["i", "TI"]]}]], "InlineFormula"],
 " for each of the languages in the list ",
 Cell[BoxData[
  ButtonBox["$Language",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Language"]], "InlineFormula"],
 ". If it finds none of these, it then searches for the actual message ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". If it does not find this, it then performs the same search procedure for \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["General",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/General"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". If it still finds no message, it applies any value given for the global \
variable ",
 Cell[BoxData[
  ButtonBox["$NewMessage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewMessage"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  StyleBox["symbol", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17858],

Cell[TextData[{
 "If you specify a message as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"], "::", 
   StyleBox["lang", "TI"]}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " will search only for messages with the particular language ",
 Cell[BoxData[
  StyleBox["lang", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7952]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130806256],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->47952283],

Cell["Issue a message:", "ExampleText",
 CellID->261600752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Message", "[", 
  RowBox[{
   RowBox[{"f", "::", "argx"}], ",", "1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->499866100],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(1\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Cell$$28869`f::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->269464579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106364644],

Cell["\<\
Define a function to issue a message and return unevaluated upon an error:\
\>", "ExampleText",
 CellID->451728668],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rsqrt", "[", "x_", "]"}], "/;", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"TrueQ", "[", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "]"}], ",", "True", ",", 
     RowBox[{
      RowBox[{"Message", "[", 
       RowBox[{
        RowBox[{"rsqrt", "::", "nnarg"}], ",", "x"}], "]"}], ";", "False"}]}],
     "]"}]}], " ", ":=", 
  RowBox[{"Sqrt", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213924982],

Cell["Define the message:", "ExampleText",
 CellID->76616870],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rsqrt", "::", "nnarg"}], "=", 
   "\"\<The argument `1` is not greater than or equal to zero.\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390751893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rsqrt", "[", "2.25", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->331807204],

Cell[BoxData["1.5`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->850259765]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rsqrt", "[", 
  RowBox[{"-", "2.25"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->50103430],

Cell[BoxData[
 RowBox[{
  RowBox[{"rsqrt", "::", "\<\"nnarg\"\>"}], ":", 
  " ", "\<\"The argument \\!\\(-2.25`\\) is not greater than or equal to \
zero.\"\>"}]], "Message", "MSG",
 CellID->346522446],

Cell[BoxData[
 RowBox[{"rsqrt", "[", 
  RowBox[{"-", "2.25`"}], "]"}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->425587674]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24616],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellPrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellPrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Write",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Write"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quiet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quiet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Beep",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beep"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Messages",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Messages"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9846],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->27137],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->515861756],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->13834]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->68017558],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->104433248],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->33734319],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->150425647]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Message - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 43.3237886}", "context" -> "System`", 
    "keywords" -> {
     "display of messages", "printing of messages", "error message", 
      "warnings", "errors", "diagnostics", "message handling"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Message[symbol::tag] prints the message symbol::tag unless it has been \
switched off. Message[symbol::tag, e_1, e_2, ...] prints a message, inserting \
the values of the e_i as needed. ", "synonyms" -> {"::"}, "title" -> 
    "Message", "type" -> "Symbol", "uri" -> "ref/Message"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12048, 400, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130806256]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21391, 744}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3359, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3982, 97, 45, 1, 70, "ObjectName",
 CellID->14899],
Cell[4030, 100, 1436, 46, 70, "Usage",
 CellID->22514]
}, Open  ]],
Cell[CellGroupData[{
Cell[5503, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5981, 168, 326, 12, 70, "Notes",
 CellID->10415],
Cell[6310, 182, 556, 21, 70, "Notes",
 CellID->3644],
Cell[6869, 205, 405, 13, 70, "Notes",
 CellID->5436],
Cell[7277, 220, 395, 16, 70, "Notes",
 CellID->23669],
Cell[7675, 238, 985, 32, 70, "Notes",
 CellID->10378],
Cell[8663, 272, 1353, 51, 70, "Notes",
 CellID->31676],
Cell[10019, 325, 1510, 51, 70, "Notes",
 CellID->17858],
Cell[11532, 378, 479, 17, 70, "Notes",
 CellID->7952]
}, Closed]],
Cell[CellGroupData[{
Cell[12048, 400, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130806256],
Cell[CellGroupData[{
Cell[12433, 414, 147, 5, 70, "ExampleSection",
 CellID->47952283],
Cell[12583, 421, 59, 1, 70, "ExampleText",
 CellID->261600752],
Cell[CellGroupData[{
Cell[12667, 426, 164, 5, 70, "Input",
 CellID->499866100],
Cell[12834, 433, 394, 8, 70, "Message",
 CellID->269464579]
}, Open  ]],
Cell[13243, 444, 125, 3, 70, "ExampleDelimiter",
 CellID->106364644],
Cell[13371, 449, 125, 3, 70, "ExampleText",
 CellID->451728668],
Cell[13499, 454, 470, 15, 70, "Input",
 CellID->213924982],
Cell[13972, 471, 61, 1, 70, "ExampleText",
 CellID->76616870],
Cell[14036, 474, 211, 7, 70, "Input",
 CellID->390751893],
Cell[CellGroupData[{
Cell[14272, 485, 104, 3, 70, "Input",
 CellID->331807204],
Cell[14379, 490, 161, 5, 36, "Output",
 CellID->850259765]
}, Open  ]],
Cell[CellGroupData[{
Cell[14577, 500, 121, 4, 70, "Input",
 CellID->50103430],
Cell[14701, 506, 201, 5, 70, "Message",
 CellID->346522446],
Cell[14905, 513, 211, 7, 36, "Output",
 CellID->425587674]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15177, 527, 311, 9, 70, "SeeAlsoSection",
 CellID->24616],
Cell[15491, 538, 2866, 107, 70, "SeeAlso",
 CellID->7288]
}, Open  ]],
Cell[CellGroupData[{
Cell[18394, 650, 313, 9, 70, "TutorialsSection",
 CellID->9846],
Cell[18710, 661, 127, 3, 70, "Tutorials",
 CellID->27137],
Cell[18840, 666, 284, 9, 70, "Tutorials",
 CellID->515861756],
Cell[19127, 677, 191, 4, 70, "Tutorials",
 CellID->13834]
}, Open  ]],
Cell[CellGroupData[{
Cell[19355, 686, 318, 9, 70, "MoreAboutSection",
 CellID->68017558],
Cell[19676, 697, 128, 3, 70, "MoreAbout",
 CellID->104433248],
Cell[19807, 702, 148, 3, 70, "MoreAbout",
 CellID->33734319],
Cell[19958, 707, 148, 3, 70, "MoreAbout",
 CellID->150425647]
}, Open  ]],
Cell[20121, 713, 27, 0, 70, "History"],
Cell[20151, 715, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

