(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21151,        785]
NotebookOptionsPosition[     16286,        618]
NotebookOutlinePosition[     17775,        661]
CellTagsIndexPosition[     17649,        655]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Messages\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Message" :> Documentation`HelpLookup["paclet:ref/Message"], 
          "MessageList" :> Documentation`HelpLookup["paclet:ref/MessageList"],
           "$MessageList" :> 
          Documentation`HelpLookup["paclet:ref/$MessageList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Message\"\>", 
       2->"\<\"MessageList\"\>", 
       3->"\<\"$MessageList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "MessageName ",
 StyleBox["(::)", "OperatorCharacter"]
}], "ObjectName",
 CellID->27264],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["symbol", "TI"], "::", 
       StyleBox["tag", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is a name for a message. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19714]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can specify messages by defining values for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26746],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " is converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"], "[", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " can contain any characters that can appear in symbol names. ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " can also be used. "
}], "Notes",
 CellID->24390],

Cell[TextData[{
 "Assignments for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["s", "TI"], "::", 
   StyleBox["tag", "TI"]}]], "InlineFormula"],
 " are stored in the ",
 Cell[BoxData[
  ButtonBox["Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Messages"]], "InlineFormula"],
 " value of the symbol ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10425],

Cell["\<\
The following messages are typically defined for built\[Hyphen]in functions: \
\
\>", "Notes",
 CellID->26255],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["f", "TI"], "::", "template"}], Cell[
    "a template showing a typical case of the function ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["f", "TI"], "::", "usage"}], Cell[
    "a description of how to use the function ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->13163],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " prints out the message ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "::", "usage"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31467],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["form", "TI"]}]], "InlineFormula"],
 " finds more than one function, only the names of the functions are printed. \
"
}], "Notes",
 CellID->5792],

Cell[TextData[{
 "You can switch on and off messages using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"], "[", 
   RowBox[{
    StyleBox["s", "TI"], "::", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Off",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Off"], "[", 
   RowBox[{
    StyleBox["s", "TI"], "::", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14231],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MessageName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageName"], "[", 
   RowBox[{
    StyleBox["symbol", "TI"], ",", "\"\<\!\(\*
StyleBox[\"tag\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"lang\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   StyleBox["symbol", "TI"], "::", 
   StyleBox["tag", "TI"], "::", 
   StyleBox["lang", "TI"]}]], "InlineFormula"],
 " represents a message in a particular language. "
}], "Notes",
 CellID->22619]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->434902898],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->87228731],

Cell["Define a usage message for a function:", "ExampleText",
 CellID->375705874],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "usage"}], "=", "\"\<f[x] gives (x - 1)(x + 1)\>\""}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->528398534],

Cell["Show the usage message:", "ExampleText",
 CellID->98054248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "f"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122568879],

Cell[BoxData[
 StyleBox["\<\"f[x] gives (x - 1)(x + 1)\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3383635442-4868740",
 CellID->389025619]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->169862432],

Cell["Process messages generated during an evaluation:", "ExampleText",
 CellID->124940440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", ",", "2."}], "]"}], ",", 
   RowBox[{"BesselJ", "[", 
    RowBox[{"3", ",", "4."}], "]"}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"5", ",", "6."}], "]"}], ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"7", ",", "8."}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267550403],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->132619542],

Cell[BoxData[
 RowBox[{
  RowBox[{"Exp", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Exp\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Exp::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->102360334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"1", ",", "2.`"}], "]"}], ",", "0.4301714738756218`", ",", 
   "1.1132827525593785`", ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"7", ",", "8.`"}], "]"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199205673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mess", " ", "=", " ", 
  RowBox[{"MessageList", "[", 
   RowBox[{"-", "1"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->381725338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"Sin", "::", "\<\"argx\"\>"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Exp", "::", "\<\"argx\"\>"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->497666498]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mest", " ", "=", " ", 
  RowBox[{"Cases", "[", 
   RowBox[{"mess", ",", 
    RowBox[{
     RowBox[{"HoldForm", "[", 
      RowBox[{"MessageName", "[", 
       RowBox[{"f_", ",", "s_"}], "]"}], "]"}], "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"f", ",", "s"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->71083665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sin", ",", "\<\"argx\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Exp", ",", "\<\"argx\"\>"}], "}"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->388649438]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12126],

Cell[TextData[{
 "Define a function that will test another function and give the ",
 Cell[BoxData[
  StyleBox["argx", "TI"]], "InlineFormula"],
 " message if needed:"
}], "ExampleText",
 CellID->190233460],

Cell[BoxData[
 RowBox[{
  RowBox[{"oneargtest", "[", 
   RowBox[{"f_", ",", "args___"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"nargs", " ", "=", " ", 
      RowBox[{"Length", "[", 
       RowBox[{"{", "args", "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"nargs", "\[NotEqual]", " ", "1"}], ",", 
      RowBox[{
       RowBox[{"Message", "[", 
        RowBox[{
         RowBox[{"MessageName", "[", 
          RowBox[{"f", ",", "\"\<argx\>\""}], "]"}], ",", "nargs", ",", "1"}],
         "]"}], ";", "False"}], ",", "True"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846003905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"oneargtest", "[", 
  RowBox[{"g", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->324863185],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(2\\) called with \\!\\(1\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Cell$$27704`g::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->41756091],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1022076769]
}, Open  ]],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " to use the test and return unevaluated when it fails:"
}], "ExampleText",
 CellID->41644004],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "args___", "]"}], "  ", ":=", " ", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", " ", "=", " ", 
       RowBox[{"First", "[", 
        RowBox[{"{", "args", "}"}], "]"}]}], "}"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "+", "1"}], ")"}]}]}], "]"}], " ", "/;", " ", 
   RowBox[{"oneargtest", "[", 
    RowBox[{"g", ",", "args"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->970223977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->73482685],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(2\\) called with \\!\\(1\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Cell$$27704`g::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->349135238],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->345184477]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "[", "1.5", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->146824277],

Cell[BoxData["1.25`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->87212197]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4720],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MessageList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MessageList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MessageList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9079]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2880],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->4718]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MessageName (::) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 42.8862774}", "context" -> "System`", 
    "keywords" -> {
     "double colon", "warning messages", "error messages", "message handle", 
      "message name", "message handling"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "symbol::tag is a name for a message. ", 
    "synonyms" -> {"message name", "::"}, "title" -> "MessageName", "type" -> 
    "Symbol", "uri" -> "ref/MessageName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6737, 250, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->434902898]},
 "Info3383635442-4868740"->{
  Cell[7713, 292, 149, 3, 70, "Print",
   CellTags->"Info3383635442-4868740",
   CellID->389025619]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17375, 644},
 {"Info3383635442-4868740", 17524, 648}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1345, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1968, 61, 105, 4, 70, "ObjectName",
 CellID->27264],
Cell[2076, 67, 398, 13, 70, "Usage",
 CellID->19714]
}, Open  ]],
Cell[CellGroupData[{
Cell[2511, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2989, 102, 212, 8, 70, "Notes",
 CellID->26746],
Cell[3204, 112, 705, 24, 70, "Notes",
 CellID->24390],
Cell[3912, 138, 401, 16, 70, "Notes",
 CellID->10425],
Cell[4316, 156, 120, 4, 70, "Notes",
 CellID->26255],
Cell[4439, 162, 725, 18, 70, "2ColumnTableMod",
 CellID->13163],
Cell[5167, 182, 241, 10, 70, "Notes",
 CellID->31467],
Cell[5411, 194, 214, 8, 70, "Notes",
 CellID->5792],
Cell[5628, 204, 522, 21, 70, "Notes",
 CellID->14231],
Cell[6153, 227, 547, 18, 70, "Notes",
 CellID->22619]
}, Closed]],
Cell[CellGroupData[{
Cell[6737, 250, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->434902898],
Cell[CellGroupData[{
Cell[7122, 264, 147, 5, 70, "ExampleSection",
 CellID->87228731],
Cell[7272, 271, 81, 1, 70, "ExampleText",
 CellID->375705874],
Cell[7356, 274, 174, 6, 70, "Input",
 CellID->528398534],
Cell[7533, 282, 65, 1, 70, "ExampleText",
 CellID->98054248],
Cell[CellGroupData[{
Cell[7623, 287, 87, 3, 70, "Input",
 CellID->122568879],
Cell[7713, 292, 149, 3, 70, "Print",
 CellTags->"Info3383635442-4868740",
 CellID->389025619]
}, Open  ]],
Cell[7877, 298, 125, 3, 70, "ExampleDelimiter",
 CellID->169862432],
Cell[8005, 303, 91, 1, 70, "ExampleText",
 CellID->124940440],
Cell[CellGroupData[{
Cell[8121, 308, 367, 12, 70, "Input",
 CellID->267550403],
Cell[8491, 322, 388, 8, 70, "Message",
 CellID->132619542],
Cell[8882, 332, 388, 8, 70, "Message",
 CellID->102360334],
Cell[9273, 342, 380, 12, 36, "Output",
 CellID->199205673]
}, Open  ]],
Cell[CellGroupData[{
Cell[9690, 359, 162, 5, 70, "Input",
 CellID->381725338],
Cell[9855, 366, 334, 13, 36, "Output",
 CellID->497666498]
}, Open  ]],
Cell[CellGroupData[{
Cell[10226, 384, 357, 11, 70, "Input",
 CellID->71083665],
Cell[10586, 397, 328, 11, 36, "Output",
 CellID->388649438]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10963, 414, 216, 7, 70, "ExampleSection",
 CellID->12126],
Cell[11182, 423, 205, 6, 70, "ExampleText",
 CellID->190233460],
Cell[11390, 431, 686, 20, 70, "Input",
 CellID->846003905],
Cell[CellGroupData[{
Cell[12101, 455, 158, 5, 70, "Input",
 CellID->324863185],
Cell[12262, 462, 393, 8, 70, "Message",
 CellID->41756091],
Cell[12658, 472, 163, 5, 36, "Output",
 CellID->1022076769]
}, Open  ]],
Cell[12836, 480, 180, 6, 70, "ExampleText",
 CellID->41644004],
Cell[13019, 488, 560, 18, 70, "Input",
 CellID->970223977],
Cell[CellGroupData[{
Cell[13604, 510, 119, 4, 70, "Input",
 CellID->73482685],
Cell[13726, 516, 394, 8, 70, "Message",
 CellID->349135238],
Cell[14123, 526, 208, 7, 36, "Output",
 CellID->345184477]
}, Open  ]],
Cell[CellGroupData[{
Cell[14368, 538, 99, 3, 70, "Input",
 CellID->146824277],
Cell[14470, 543, 161, 5, 36, "Output",
 CellID->87212197]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14692, 555, 310, 9, 70, "SeeAlsoSection",
 CellID->4720],
Cell[15005, 566, 707, 26, 70, "SeeAlso",
 CellID->9079]
}, Open  ]],
Cell[CellGroupData[{
Cell[15749, 597, 313, 9, 70, "TutorialsSection",
 CellID->2880],
Cell[16065, 608, 126, 3, 70, "Tutorials",
 CellID->4718]
}, Open  ]],
Cell[16206, 614, 50, 0, 70, "History"],
Cell[16259, 616, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

