(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12777,        469]
NotebookOptionsPosition[      9299,        353]
NotebookOutlinePosition[     10625,        390]
CellTagsIndexPosition[     10540,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink and External Program Communication" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]}\
, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"MathLink and External Program Communication\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupt" :> Documentation`HelpLookup["paclet:ref/Interrupt"],
           "Abort" :> Documentation`HelpLookup["paclet:ref/Abort"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupt\"\>", 
       2->"\<\"Abort\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink Packets" :> 
          Documentation`HelpLookup["paclet:guide/MathLinkPackets"], 
          "Messages" :> Documentation`HelpLookup["paclet:guide/Messages"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"MathLink Packets\"\>", 
       2->"\<\"Messages\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MessagePacket", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MessagePacket",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MessagePacket"], "[", 
       RowBox[{
        StyleBox["symbol", "TI"], ",", 
        StyleBox["string", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]is a ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packet containing a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " message identifier of the form ",
     StyleBox["symbol", "TI"],
     "::",
     StyleBox["string", "TI"],
     StyleBox[".", "TR"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->1974514],

Cell[TextData[{
 "Launch a subsidiary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process:"
}], "ExampleText",
 CellID->1215824468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", "=", 
  RowBox[{"LinkLaunch", "[", 
   RowBox[{
    RowBox[{"First", "[", "$CommandLine", "]"}], " ", "<>", " ", 
    "\"\< -mathlink\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->312144257],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"MathKernel -mathlink\"\>", ",", "198", ",", "7"}], 
  "]"}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513121077]
}, Open  ]],

Cell["Read the first packet:", "ExampleText",
 CellID->625050465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2053461425],

Cell[BoxData[
 RowBox[{"InputNamePacket", "[", "\<\"In[1]:= \"\>", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->50344218]
}, Open  ]],

Cell[TextData[{
 "Write the packet representing the text ",
 Cell[BoxData["\"\<10+\>\""], "InlineFormula"],
 " to enter:"
}], "ExampleText",
 CellID->316479038],

Cell[BoxData[
 RowBox[{"LinkWrite", "[", 
  RowBox[{"link", ",", 
   RowBox[{"EnterTextPacket", "[", "\"\<10+\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1893681694],

Cell[TextData[{
 "The evaluation failed, and a ",
 Cell[BoxData[
  ButtonBox["MessagePacket",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MessagePacket"]], "InlineFormula"],
 " expression is returned:"
}], "ExampleText",
 CellID->1400582518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1420596703],

Cell[BoxData[
 RowBox[{"MessagePacket", "[", 
  RowBox[{"Syntax", ",", "\<\"sntxi\"\>"}], "]"}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->602069128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->335210291],

Cell[BoxData[
 RowBox[{"TextPacket", 
  "[", "\<\"Syntax::sntxi: Incomplete expression; more input is \
needed.\\n\"\>", "]"}]], "Output",
 ImageSize->{494, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->552111347]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinkRead", "[", "link", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->517472919],

Cell[BoxData[
 RowBox[{"SyntaxPacket", "[", "6", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->104211535]
}, Open  ]],

Cell["Close the link:", "ExampleText",
 CellID->1054932471],

Cell[BoxData[
 RowBox[{"LinkClose", "[", "link", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"],
  FontSlant->"Italic"],
 ButtonBox[" and External Program Communication",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/MathLinkAndExternalProgramCommunicationOverview"]
}], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["MathLink Packets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathLinkPackets"]], "MoreAbout",
 CellID->71193509],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->42269831]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MessagePacket - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 44.8707032}", "context" -> "System`", 
    "keywords" -> {"MathLink packet", "output packet", "message packet"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MessagePacket[symbol, string] is a MathLink packet containing a \
Mathematica message identifier of the form symbol::string.", 
    "synonyms" -> {"message packet"}, "title" -> "MessagePacket", "type" -> 
    "Symbol", "uri" -> "ref/MessagePacket"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3509, 111, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10405, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1983, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2606, 76, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2665, 79, 807, 27, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3509, 111, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3886, 125, 146, 5, 70, "ExampleSection",
 CellID->1974514],
Cell[4035, 132, 149, 6, 70, "ExampleText",
 CellID->1215824468],
Cell[CellGroupData[{
Cell[4209, 142, 234, 7, 28, "Input",
 CellID->312144257],
Cell[4446, 151, 260, 8, 36, "Output",
 CellID->513121077]
}, Open  ]],
Cell[4721, 162, 65, 1, 70, "ExampleText",
 CellID->625050465],
Cell[CellGroupData[{
Cell[4811, 167, 108, 3, 28, "Input",
 CellID->2053461425],
Cell[4922, 172, 214, 6, 36, "Output",
 CellID->50344218]
}, Open  ]],
Cell[5151, 181, 160, 5, 70, "ExampleText",
 CellID->316479038],
Cell[5314, 188, 185, 5, 70, "Input",
 CellID->1893681694],
Cell[5502, 195, 246, 8, 70, "ExampleText",
 CellID->1400582518],
Cell[CellGroupData[{
Cell[5773, 207, 108, 3, 70, "Input",
 CellID->1420596703],
Cell[5884, 212, 238, 7, 36, "Output",
 CellID->602069128]
}, Open  ]],
Cell[CellGroupData[{
Cell[6159, 224, 107, 3, 70, "Input",
 CellID->335210291],
Cell[6269, 229, 269, 8, 54, "Output",
 CellID->552111347]
}, Open  ]],
Cell[CellGroupData[{
Cell[6575, 242, 107, 3, 70, "Input",
 CellID->517472919],
Cell[6685, 247, 197, 6, 36, "Output",
 CellID->104211535]
}, Open  ]],
Cell[6897, 256, 59, 1, 70, "ExampleText",
 CellID->1054932471],
Cell[6959, 259, 109, 3, 70, "Input",
 CellID->1396673512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7117, 268, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[7436, 279, 451, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7924, 301, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[8245, 312, 371, 11, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[8653, 328, 299, 8, 70, "MoreAboutSection"],
Cell[8955, 338, 142, 3, 70, "MoreAbout",
 CellID->71193509],
Cell[9100, 343, 127, 3, 70, "MoreAbout",
 CellID->42269831]
}, Open  ]],
Cell[9242, 349, 27, 0, 70, "History"],
Cell[9272, 351, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

