(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42583,       1271]
NotebookOptionsPosition[     37269,       1093]
NotebookOutlinePosition[     38711,       1132]
CellTagsIndexPosition[     38625,       1127]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PerformanceGoal" :> 
          Documentation`HelpLookup["paclet:ref/PerformanceGoal"], 
          "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], 
          "StepMonitor" :> Documentation`HelpLookup["paclet:ref/StepMonitor"],
           "SystemOptions" :> 
          Documentation`HelpLookup["paclet:ref/SystemOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PerformanceGoal\"\>", 
       2->"\<\"EvaluationMonitor\"\>", 3->"\<\"StepMonitor\"\>", 
       4->"\<\"SystemOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Options & Styling\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Method", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Method",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Method"]], "InlineFormula"],
     " \[LineSeparator]is an option for various algorithm-intensive functions \
that specifies what internal methods they should use."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21505]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Typical settings include:", "Notes",
 CellID->80508347],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "pick the method automatically", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", Cell[
    "use the method with the specified name", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], 
        StyleBox["1", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "use the specified method with particular options", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"name\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]}], "}"}], Cell[
    "use a method and a submethod", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], 
        StyleBox["1", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["opt", "TI"], 
        StyleBox["2", "TR"]], "\[Rule]", 
       SubscriptBox[
        StyleBox["val", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "give options for methods", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->720453457],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"Method", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will automatically try to pick the best method for a particular \
computation."
}], "Notes",
 CellID->153]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->249875175],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->138511480],

Cell["\<\
Find a nonlinear fit for exponential decay using a quasi-Newton method:\
\>", "ExampleText",
 CellID->101072580],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.0", ",", "12."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.9", ",", "10."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", "8.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.4", ",", "6.9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.0", ",", "5.9"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->613023938],

Cell[BoxData[
 RowBox[{
  RowBox[{"model", "=", 
   RowBox[{"a", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "k"}], " ", "t"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211120279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fit", "=", 
  RowBox[{"FindFit", "[", 
   RowBox[{"data", ",", "model", ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "k"}], "}"}], ",", "t", ",", " ", 
    RowBox[{"Method", "\[Rule]", "\"\<QuasiNewton\>\""}]}], "]"}]}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->932959552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "14.388856947044653`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.19820818673838608`"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->88579712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43109325],

Cell["\<\
Solve a differential equation using an explicit Runge-Kutta method:\
\>", "ExampleText",
 CellID->90897741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"2", " ", "+", " ", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "[", "t", "]"}], "]"}]}], ")"}], " ", 
        RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", "0"}], ",", 
     " ", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", " ", 
   RowBox[{"Method", "\[Rule]", "\"\<ExplicitRungeKutta\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62541226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33182847]
}, Open  ]],

Cell["Plot the solution and its derivative:", "ExampleText",
 CellID->302727518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "[", "t", "]"}], ",", 
        RowBox[{
         RowBox[{"x", "'"}], "[", "t", "]"}]}], "}"}], " ", "/.", " ", "%"}], 
     "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101059406],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113273806]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->814744088],

Cell["\<\
Find a root in 2-dimensions using Newton's method with a trust-region step \
control:\
\>", "ExampleText",
 CellID->179609688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "1"}], ",", 
     RowBox[{"10", 
      RowBox[{"(", 
       RowBox[{"y", "-", 
        RowBox[{"x", "^", "2"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Newton\>\"", ",", 
      RowBox[{"\"\<StepControl\>\"", "\[Rule]", "\"\<TrustRegion\>\""}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12766332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.`"}], ",", 
   RowBox[{"y", "\[Rule]", "1.`"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278073725]
}, Open  ]],

Cell["\<\
This takes fewer evaluations than the default step control for this problem:\
\>", "ExampleText",
 CellID->315251564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", " ", "=", " ", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "-", "1"}], ",", 
        RowBox[{"10", 
         RowBox[{"(", 
          RowBox[{"y", "-", 
           RowBox[{"x", "^", "2"}]}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Newton\>\"", ",", 
         RowBox[{"\"\<StepControl\>\"", "\[Rule]", "\"\<TrustRegion\>\""}]}], 
        "}"}]}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"e", "++"}]}]}], "]"}], ";", "e"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204103328],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->303285549]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", " ", "=", " ", "0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"x", "-", "1"}], ",", 
        RowBox[{"10", 
         RowBox[{"(", 
          RowBox[{"y", "-", 
           RowBox[{"x", "^", "2"}]}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"Method", "\[Rule]", "\"\<Newton\>\""}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"e", "++"}]}]}], "]"}], ";", "e"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->823480044],

Cell[BoxData["37"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->594937471]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->733842826],

Cell["\<\
Number of steps and evaluations for an ODE using Runge-Kutta methods of \
various order:\
\>", "ExampleText",
 CellID->286635598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"e", "=", "0"}], ",", 
         RowBox[{"s", "=", "0"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"NDSolve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "''"}], "[", "t", "]"}], " ", "+", " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"2", " ", "+", " ", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"x", "[", "t", "]"}], "]"}]}], ")"}], " ", 
               RowBox[{"x", "[", "t", "]"}]}]}], " ", "\[Equal]", " ", "0"}], 
            ",", " ", 
            RowBox[{
             RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}],
           ",", "x", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", " ", 
          RowBox[{"Method", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<ExplicitRungeKutta\>\"", ",", 
             RowBox[{"\"\<DifferenceOrder\>\"", "\[Rule]", "do"}]}], "}"}]}], 
          ",", 
          RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
           RowBox[{"e", "++"}]}], ",", 
          RowBox[{"StepMonitor", "\[RuleDelayed]", 
           RowBox[{"s", "++"}]}]}], "]"}], ";", 
        RowBox[{"{", 
         RowBox[{"do", ",", "s", ",", "e"}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"do", ",", 
       RowBox[{"{", 
        RowBox[{
        "Automatic", ",", " ", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
         ",", "8", ",", "9"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Difference Order\>\"", ",", " ", "\"\<Steps\>\"", ",", " ", 
        "\"\<Evaluations\>\""}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93707297],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdW81yG0UQXq92pWCXC5xQwQ7EVgIPEMBV/KZyAi7wDOBKUZUcKCCWHV6A
a/KsHHMaduRpbe+33/ztSkJBVdG6Z7tnunt6vulpTX66WDz79beLxfOnF/Mf
Xlz88ez508v597+/aJome0VRvGn+/X1cNH+b5q/lvzfGNM/afk8svfwU/2S0
ls2XJf9yz2KyZFt+LD137ShXu/Yvaa9IX9uvqqXdMIrj/lJsRTslKuCaAv0F
HR25/my+pg1ZQvucjll3dXWy3E5rhWW9TNL+zD9erxX9wy0tqeyi522UO3V6
o6fKnuRXGeNeKa6C9H4f6FusVyU/ZmzONYe+JpSrMil6WFlLvmyepZsxSz90
T6tB7XxfenvJWavbbdX2hZBhquy1z68zZs32PQQXplG5nPViVy/Dh0+Aniov
rHobMWYcMT7mdg6wXGbzqiePnGeOs6Ij5c5wDBNOga6Bn/e6eWQYo4cPGR6Y
G9StoZ37cxcwgLdilF5F3j+IvBek5N7cxGipM4n0WsZWNJ/5dY+KCLEdW5Hm
GRTiwbpHHY/JnPcsgzcXw2qnS120WcQZ0G8rdojeC9NmRyy7OPbYW7nn5xnz
ijEVzx6OgU7DEN762QhNLRfLTD6M6Be38NFIreK5y70N6mjFrqG9nxmh5ElE
I0uXaTGm6JeBXq1fEOFisTXUL8iF/kG9+CzGZm185It3F87bM9PNhu45ulbP
+MrfBWxLQzyhJ45Gj6ch/JiVus6Z57sYxvxlUl8YwR8RT25XI/QB4u4YjWR+
cZ3yPlAaZ4tpUnmjJ4YVXAf0IYvcEP3NGnXhrce0NZYP+31UKZxCHLK7iazT
smjrIG9bnUfsujS8niN2Ii4JfnGUZzXYIXWcu0kzup58bEpW45SsvQ+IB/PR
LSeDjdfJ0CPDMljk4r7qZ1p2jcja4DWjGJYLH8bNp1QDzGUWgRlhvsdKNEWu
KP7xPGysbidJMzM+4iW/svphVapy617m9P+Uh12ZLn7hyfK2e84MP5kKf876
Tav25szp+2Q28yM6DbtpVon8QXS6gxKE57/V8D1zE/VpuJh73rHr59q064i9
1/Hn2T06FjCdKm9crt9j70Y95fWcos+ptttaRUeDbEjbyRFvfDh6x7Q7n+Cv
zid5VO0CoqrWzu/lk5XT5FM6mzpYaloclnxzVvTzTKSfGI7Lc8NvKgw5R/fQ
U4abAadRq/OWXi36O5APRrNELvuk63Mil3afYkhlOi275dZp2dZ7aT3GdrjH
JvuWR6B3/6+ovdxtrb6Q7GuI9aNuoOygL0bERU/qW4MrBuVCd2L8+IFeEKTT
T0QzjV7Sh85Ihad2Gj2GMZLu1XAPRH9d3Qcaa+Y/EnuH3rNJr8NYTz6C9u9M
+N6NrKT8eoy9aLeJ/fKV0/AX+vY10D+3XJ3dtXLrWtdk0Gakb7qRjwwkcVY5
rn3TPxlJ77rXfaVTsfLVBMavFG0lpgSPZAR2xsJ8IZYXrFZWz9ZVXs+xIogK
sTpLDI2ofM7vxkr2gHJlIGxAzwPT4lV4DEtPM6zYT+oxfhPPGHKqDWs8MLvK
ad0z3rjKrkNvMLYCo2wyqvgZke5B0Wob3haldbS1ng6HZRr+2uHeFuKlJnpr
HE+LD8v0TpJP/HHBNPHHQ/hkYbs4UH2tvEO5ZYeMezgr286IGtmPNooMdOTS
6xmdkebeKZ3Fx0tGZfv20KjfC5KiKaA5YMQk6IFdQQi/PbkoobM43+90vtoL
q8tINig8fP/2VXR0m+js0wLPGpXpZ3Q+7bSstqhfd5KTVDeL1me00Pkrpkdg
pjoze2D6tmr6nHr5ELju4jgkBue0p9vAdQT0aWtH77SBO7FULuV57p6Hzk8n
JA7sXXp7Ajhy7/AmxdKy4ub/MxV7/wIjO4i1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->57294624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->419622373],

Cell["\<\
Use of event location method using a backward differentiation formula base \
method:\
\>", "ExampleText",
 CellID->277046282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EventLocator\>\"", ",", 
      RowBox[{"\"\<Event\>\"", "\[Rule]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{"\"\<EventAction\>\"", "\[RuleDelayed]", 
       RowBox[{"Throw", "[", 
        RowBox[{
         RowBox[{"end", "=", "t"}], ",", "\"\<StopIntegration\>\""}], "]"}]}],
       ",", 
      RowBox[{"Method", "\[Rule]", "\"\<BDF\>\""}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280287220],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "4.038884470746768`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584666652]
}, Open  ]],

Cell[TextData[{
 "Plot the solution up to the event ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"x", "(", "t", ")"}], "\[LongEqual]", "0"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->33247914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"First", "[", 
     RowBox[{
      RowBox[{"x", "[", "t", "]"}], "/.", "%"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "end"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2525445],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333621797]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82835246],

Cell[TextData[{
 "Use of event locator with deeply nested ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option:"
}], "ExampleText",
 CellID->423402573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<EventLocator\>\"", ",", 
      RowBox[{"\"\<Event\>\"", "\[Rule]", 
       RowBox[{"x", "[", "t", "]"}]}], ",", 
      RowBox[{"\"\<EventAction\>\"", "\[RuleDelayed]", 
       RowBox[{"Throw", "[", 
        RowBox[{
         RowBox[{"end", "=", "t"}], ",", "\"\<StopIntegration\>\""}], "]"}]}],
       ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Projection\>\"", ",", 
         RowBox[{"\"\<Invariants\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"x", "'"}], "[", "t", "]"}], "^", "2"}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"Cos", "[", 
              RowBox[{"x", "[", "t", "]"}], "]"}]}]}], "}"}]}], ",", 
         RowBox[{"Method", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<Extrapolation\>\"", ",", 
            RowBox[{"Method", "\[Rule]", "\"\<ExplicitMidpoint\>\""}]}], 
           "}"}]}]}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144593886],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "4.038413218212866`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673094582]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20072],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PerformanceGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PerformanceGoal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11134]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->171410488],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->26285336],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->97473030],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->62641422]
}, Open  ]],

Cell["New in 4  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Method - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 45.3863414}", "context" -> "System`", 
    "keywords" -> {
     "method options", "method selection", "nested method options", 
      "method parameters", "manual overrides", "expert options", 
      "manual method selection", "method hierarchy", "method framework"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Method is an option for various algorithm-intensive functions that \
specifies what internal methods they should use.", "synonyms" -> {}, "title" -> 
    "Method", "type" -> "Symbol", "uri" -> "ref/Method"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10303, 274, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->249875175]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38481, 1120}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1920, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2543, 71, 4190, 83, 70, "ObjectNameGrid"],
Cell[6736, 156, 490, 14, 70, "Usage",
 CellID->21505]
}, Open  ]],
Cell[CellGroupData[{
Cell[7263, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7741, 192, 61, 1, 70, "Notes",
 CellID->80508347],
Cell[7805, 195, 2095, 59, 70, "2ColumnTableMod",
 CellID->720453457],
Cell[9903, 256, 363, 13, 70, "Notes",
 CellID->153]
}, Closed]],
Cell[CellGroupData[{
Cell[10303, 274, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->249875175],
Cell[CellGroupData[{
Cell[10688, 288, 148, 5, 70, "ExampleSection",
 CellID->138511480],
Cell[10839, 295, 122, 3, 70, "ExampleText",
 CellID->101072580],
Cell[10964, 300, 477, 16, 70, "Input",
 CellID->613023938],
Cell[11444, 318, 218, 8, 70, "Input",
 CellID->211120279],
Cell[CellGroupData[{
Cell[11687, 330, 301, 9, 28, "Input",
 CellID->932959552],
Cell[11991, 341, 300, 9, 36, "Output",
 CellID->88579712]
}, Open  ]],
Cell[12306, 353, 124, 3, 70, "ExampleDelimiter",
 CellID->43109325],
Cell[12433, 358, 117, 3, 70, "ExampleText",
 CellID->90897741],
Cell[CellGroupData[{
Cell[12575, 365, 844, 27, 70, "Input",
 CellID->62541226],
Cell[13422, 394, 466, 17, 36, "Output",
 CellID->33182847]
}, Open  ]],
Cell[13903, 414, 80, 1, 70, "ExampleText",
 CellID->302727518],
Cell[CellGroupData[{
Cell[14008, 419, 444, 15, 28, "Input",
 CellID->101059406],
Cell[14455, 436, 4934, 85, 121, "Output",
 Evaluatable->False,
 CellID->113273806]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19438, 527, 220, 7, 70, "ExampleSection",
 CellID->814744088],
Cell[19661, 536, 136, 4, 70, "ExampleText",
 CellID->179609688],
Cell[CellGroupData[{
Cell[19822, 544, 669, 23, 70, "Input",
 CellID->12766332],
Cell[20494, 569, 268, 9, 36, "Output",
 CellID->278073725]
}, Open  ]],
Cell[20777, 581, 127, 3, 70, "ExampleText",
 CellID->315251564],
Cell[CellGroupData[{
Cell[20929, 588, 960, 30, 70, "Input",
 CellID->204103328],
Cell[21892, 620, 159, 5, 36, "Output",
 CellID->303285549]
}, Open  ]],
Cell[CellGroupData[{
Cell[22088, 630, 822, 26, 70, "Input",
 CellID->823480044],
Cell[22913, 658, 159, 5, 36, "Output",
 CellID->594937471]
}, Open  ]],
Cell[23087, 666, 125, 3, 70, "ExampleDelimiter",
 CellID->733842826],
Cell[23215, 671, 139, 4, 70, "ExampleText",
 CellID->286635598],
Cell[CellGroupData[{
Cell[23379, 679, 2194, 61, 70, "Input",
 CellID->93707297],
Cell[25576, 742, 2150, 39, 70, "Output",
 Evaluatable->False,
 CellID->57294624]
}, Open  ]],
Cell[27741, 784, 125, 3, 70, "ExampleDelimiter",
 CellID->419622373],
Cell[27869, 789, 135, 4, 70, "ExampleText",
 CellID->277046282],
Cell[CellGroupData[{
Cell[28029, 797, 1047, 32, 70, "Input",
 CellID->280287220],
Cell[29079, 831, 482, 17, 36, "Output",
 CellID->584666652]
}, Open  ]],
Cell[29576, 851, 229, 9, 70, "ExampleText",
 CellID->33247914],
Cell[CellGroupData[{
Cell[29830, 864, 311, 10, 70, "Input",
 CellID->2525445],
Cell[30144, 876, 2287, 42, 70, "Output",
 Evaluatable->False,
 CellID->333621797]
}, Open  ]],
Cell[32446, 921, 124, 3, 70, "ExampleDelimiter",
 CellID->82835246],
Cell[32573, 926, 226, 8, 70, "ExampleText",
 CellID->423402573],
Cell[CellGroupData[{
Cell[32824, 938, 1653, 47, 70, "Input",
 CellID->144593886],
Cell[34480, 987, 482, 17, 36, "Output",
 CellID->673094582]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35023, 1011, 311, 9, 70, "SeeAlsoSection",
 CellID->20072],
Cell[35337, 1022, 989, 35, 70, "SeeAlso",
 CellID->11134]
}, Open  ]],
Cell[CellGroupData[{
Cell[36363, 1062, 319, 9, 70, "MoreAboutSection",
 CellID->171410488],
Cell[36685, 1073, 162, 3, 70, "MoreAbout",
 CellID->26285336],
Cell[36850, 1078, 174, 3, 70, "MoreAbout",
 CellID->97473030],
Cell[37027, 1083, 147, 3, 70, "MoreAbout",
 CellID->62641422]
}, Open  ]],
Cell[37189, 1089, 50, 0, 70, "History"],
Cell[37242, 1091, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

