(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     95706,       2797]
NotebookOptionsPosition[     85143,       2417]
NotebookOutlinePosition[     86440,       2455]
CellTagsIndexPosition[     86354,       2450]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Basic Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Det" :> Documentation`HelpLookup["paclet:ref/Det"], "Delete" :> 
          Documentation`HelpLookup["paclet:ref/Delete"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Det\"\>", 2->"\<\"Delete\"\>", 3->"\<\"Tr\"\>", 
       4->"\<\"Band\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup[
           "paclet:guide/MatricesAndLinearAlgebra"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Minors", "ObjectName",
 CellID->10139],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Minors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Minors"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the minors of a matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Minors",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Minors"], "[", 
       RowBox[{
        StyleBox["m", "TI"], ",", 
        StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox[
       RowBox[{
        StyleBox["k", "TI"], "\[Null]"}]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " minors. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12082]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "\[Cross]", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " matrix the ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], ")"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " gives the determinant of the matrix obtained by deleting the ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["n", "TI"], "-", 
    StyleBox["i", "TI"], "+", "1"}], ")"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " row and the ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["n", "TI"], "-", 
    StyleBox["j", "TI"], "+", "1"}], ")"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14024],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    ButtonBox["Reverse",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Reverse"], ",", 
    RowBox[{"Minors", "[", 
     StyleBox["m", "TI"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}]], "InlineFormula"],
 " makes the ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}], ")"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " element correspond to deleting the ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " row and ",
 Cell[BoxData[
  StyleBox["j", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " column of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20900],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     StyleBox["n", "TI"], "-", "1"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1575],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives the determinants of the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["k", "TI"], "\[Cross]", 
   StyleBox["k", "TI"]}]], "InlineFormula"],
 " submatrices obtained by picking each possible set of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " rows and ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " columns from ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19337],

Cell["\<\
Each element in the result corresponds to taking rows and columns with \
particular lists of positions. The ordering of the elements is such that \
reading across or down the final matrix the successive lists of positions \
appear in lexicographic order. \
\>", "Notes",
 CellID->15376],

Cell[TextData[{
 "For an ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["1", "TR"]], "\[Cross]", 
   SubscriptBox[
    StyleBox["n", "TI"], 
    StyleBox["2", "TR"]]}]], "InlineFormula"],
 " matrix ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", GridBox[{
      {
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]]},
      {
       StyleBox["k", "TI"]}
     }], ")"}], "\[Cross]", 
   RowBox[{"(", GridBox[{
      {
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]]},
      {
       StyleBox["k", "TI"]}
     }], ")"}]}]], "InlineFormula"],
 " matrix. "
}], "Notes",
 CellID->11300],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["k", "TI"], ",", 
    StyleBox["f", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " applies the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " rather than ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 " to each of the submatrices picked out. "
}], "Notes",
 CellID->19424]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265726377],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->348148119],

Cell[TextData[{
 "Minors of a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Times]", "3"}], TraditionalForm]], "InlineMath"],
 " matrix:"
}], "ExampleText",
 CellID->7920076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mat", "=", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", "##"], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451192175],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVztPAkEQXu6Qh6gRn2gs/AP+Da38BRaEEBOuMBqloKOkpKTkJ1BSUlJS
UlJSUlKeM/vglmEOFgE1xktub2dnZuexs9/tPpaqleeXUjUol24f3ktvlaD8
cXv/+g5DfkIIEcB7VxDQD6En3yAM4XuJrY+0fMTNCjovtbD1YDBJuHuC8JIz
HjwoeBLLxdEjOfuenLXdbutZc8SKZ0zNdKEvzjmpyAJ0LjiJJbTyo16va9qX
06iYh8Nht9uVJqBBZ6h2mtC5LculTJYGgwH1rtVq2T4v5IquW4rQ+zvUonGo
LE+n01qtFsXhm1EVipplYW47R0hnnDyiWmlC576kpWw3Gg1wOjTVJOPw+v0+
5gqL0WdyiJV/GMPnqsNFTtFQolCo897I6hiPx/FZvV5jVOFHtBtsO9HOwTVG
527It2BWWW32GO2i8VrTiSVSEf0XpST6roHWh06zYk35TE0ZNJ/xWDTnuVjT
+87Wbat8TZ5yUnPofsZJLEH3tJN3WLk/ge4ZJ+/4XK3CBh4Vt6NFEdgty78f
3bNOcWC1fCfKb1Il66B8wTl6DuWvnLSL/1J6dDcoj7uFQx4cO7Z5Cyifj+VG
KN9sNpdaPyBW+XMpxXDyXxGLp3y6Q3hcje4StndwophMJmH4cyiv6NFo1Ol0
Zt5r7+BApU/2vx/l1U2g1+sxp01IsY5ul3HYd5F4lF+lpeKCWp47w9M7FdJJ
vbqe1rLR3YxnibXcCj79V0bWPaiEzVEc778erIWcSd+75m+KHHpfMnJGW10j
sPtEaCUVWK1IfAJlIkc1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->137734529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", "mat", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98990379],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWj9v2kAUN+ZfW0LaNJBA2qqoytqv0U79ECiqlAxVqzSqUBeGRmJkZOQj
MDIyMjIyMjIyMl7v+Yyxn599d8YmmBgJc3d+797vnd+d3/24b+2H2+8/2g93
N+3W1/v2r9u7m9+tLz/veVM+Zxi5f4ZhfG4YvMx4yfrC55F/DeMjXPObNmZc
onoL1S9Q/fqJ9c8sL5r8Co15qBWcu3Zrlf+a/LeAdIu8WHdronsVt56v16tA
m6BzGrtNaH2nbtOH9yJ0jE5C7Z5ao1y08A6HQ/fYu/AjXV7AEubGTad3XvY9
8wIp9Zrqy2PtPdUP1nDVq0mjC6k34sDq8Z7s0SPxRhOjeN7dbteuW5FjI53P
5+PxGIoQOTAcWLuM6iUNuSh6RUW58wxvonhF/3yVmM1mDEXNYDCwpSqMmkV4
RaQw+LXw3KE8lPcis03Pe5ntt0q2XsRia59+Yq2zZ+KnWBPX63Wn02FOdOc3
rSLArV6KGww+G+4ZBPUyqpeUtKixBCV6NFS09ZFWMj9j8xNrbdZbNT8pbX0t
MVq9Xo+HMhQtectrczqdQhZYUJhZpQA5aDeJZyKTLyvaPT9yfCpvchW9oqKc
qPM0jyd7zBMN1pt8uVxC8YRRkVYnW/HujY7SGtn66cjsiH3FNo92j+4254a8
P29Lw2+LeXdz1zveF7sGPt3Fti4ABVz+MubJ4HISyW3bc5FsMm80pI1LqSp5
CRmtsw/Q4lpqjN5ByLmWZqBNGdcSzSa0Xqnb9OGth45RONfySukp1JA/iNUx
VLkXzBrQGY6ce/lA9YM1fLGWILqQOp6nkbB6vCd73Il7Ee9eWRQAsjRxA2nj
MtKGV2SusqihM7aMe9nFVsa9JO+n2poYzr1Qezj9vboeJxFtNHbjJDI/dfzU
415kNqNxLy+ZSnTDG79g92Y6Wl4sUbgN03U/CqeRdjyq3EpQv6qcyi5v6PRy
Hfuy01Aa3aQ5laYSCrikgdV4WsmMUzGceKXOi8j4DUcvAqcSr001TiUYr5xT
CbYrOJV+vx/6FOScCmYa6IxGjbXArIL/vIYup1JJGl2IbV1OhcSqyamcamIU
7+Lt+SV3FAwGg9VqxVjGqWR4qfpisRiNRox5/yEZj8f2KZc4ORXd3DTO3ZhM
K05O5ZD8xIjj5FQO2U9hezKZEP/x8gXRjvmMU8n81PXzEDgVMdY87/OcZ8Fn
EWHtPgYO49Dw7ItTwbzw9imb/O2ccSnR7ICuydd/a7bY5x6953eh46Q4lEtk
L+9CIQ4eQREuf1CbkITiIyoZuf/K61YC\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{387, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->33102155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38138880],

Cell[TextData[{
 "2\[Times]2 Minors of a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", "\[Times]", "3"}], TraditionalForm]], "InlineMath"],
 " matrix:"
}], "ExampleText",
 CellID->198182832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mat", "=", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Subscript", "[", 
        RowBox[{"a", ",", "##"}], "]"}], "&"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279757422],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVmtLwzAUzZrOqVWx8zVkwn6NfvIPiAhlDNYPosz9/3pv1s1wdmJSdegH
C21z7is3j3uS+2o5nz1Xy3paTe4W1eu8nr5Nbl8WIrI9Y0wt783ISLuRlnvr
ppH/lX6tYveYcQSXzku/KrSg7RvQ5RtdKx0GtZmAExe9D1EPAOfrrja+0jZn
zOqjB2mcMwsPZxG9w1SqyaD3AHDxw3Z7gC3NztK5wnXD2Ic79NoHjKvdZRz+
HCnG2Dwj9BoALr7khbOxGsdWhcgnJ7Oiq6kVcBzQs12SYoc4o1nxirruIEUe
4f3o6BWO4T9K8n76t2qlJeAYax8lRdVqYcyjslNft8XqZVCrexr5m/eOOfKK
Rw6Hc0QaF8ziE5ZHHg3v3N9g+e/U719i+bRZ3uU4/AzCLB/zwnGFd0verm7W
evnsvpZjZRQRPd8NaWdlFza/ZBHpzYexOZ4F3PuRWuFt4IH0KdfZVZ69d38k
xls=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{105, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->500679278]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minors", "[", 
  RowBox[{"mat", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->510316129],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV+FOwjAQ7jo2QARiwhD/LVHxTfSXD7EQE/hhNEiMj6FPPNvZ4fi4cbcy
iUtoe+191+/u2tI+Zpvl03O2WS2y9GGdvS5Xi7f0/mVtusJAqeBTKTWeKdPO
Tav4Xed5rkLbKj51CXIK8hTkO2Yc8Wh/fuT8iS1UB3pRHpkiMqIuBrf95rNK
Q1eHgLKISRUJY4Mqbs8qckhqOegjOJzXctCNOYwO+lOPDVkeEZOfArXnO2pd
UKjfuezipixEVTamrWaUnT2tIWVrZ7bYeUfaq8iYt7MWWY6YmNGZbsp4wMbi
irK4oyFieoATqc9q2VhTe6cLctxAzwcXCfWQ/7hl+744qZ+YDyn//xp/v1XX
z6m9iiiKY3MURsTPCn0GSVC6PHdZdA9k+kTj5myHuSxKyFgf5a8f01Pml8wQ
uxtwT1H/7tu9x3Ko+mvHYxKlQYuKtQW1GS2cswtyecuUrWv0k2bK+Vmea23u
Aqmff5lPnLP0U5ZPv9jinLjzcF0HhZ7kBtJxs9mzo09w7dT4oImMx2Cv5+pu
jR3M+ZThEzF86vSRT0/IJ/GMj+Rm4OPnKW8ECdmLb1x69U7I3tsGuvjWps8Q
muPNifyZMHGVvwJC57GtU1dPXX0Hcgr6cwaftMLSFh8iS9yatMU7o/Pz5rbN
L0FLBd/H9KNn\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92034253]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->374524412],

Cell[TextData[{
 "Minors of a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"4", "\[Times]", "4"}], TraditionalForm]], "InlineMath"],
 " matrix:"
}], "ExampleText",
 CellID->294582923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mat", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"i", "^", "2"}], "+", 
       RowBox[{"i", " ", "j"}], "+", 
       RowBox[{"j", "^", "3"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->578863953],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"3", "11", "31", "69"},
     {"7", "16", "37", "76"},
     {"13", "23", "45", "85"},
     {"21", "32", "55", "96"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{104, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->77122500]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", "mat", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58261985],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWb1uGkEQXm4P29jGEHDknySKXyMvkFR5CGRZsgsrkeOCjpKS8uSKR6C8
kpKSkpKSkpJys7/evblZezE666IcEre7c8PMtzOzM6vhZ+/x9ua+93h33bv6
8dD7fXt3/efq+68HTqI1QsgT/347J3zO+Ex+nxjjo/usiycdj8dMfsghf9SJ
olM+dvS4p8dzPZr3n/QY6/FEyhsMBloelVpiOV0sFmmaiumReAg1zHyI1kHo
M5W0g7guUS4KuM5QrgilNo1N5vM53EOSJM7O6sTQrSZB3+PLhn5PvZoFV1tz
7Qt6bKXkd9AK5pTWpZvNpt/vW/zUUNUWtKfsr3BbdLawm/BE7H375VXcx3I9
HA45yGdEkiuazWZtDG9GXpfZWMy+ufDuQrB9Fho0HrFuSU08VHnAZnFI/69W
K2aiE+LRa7/lYsDlR+bK/prbkZTunCgXoz19x0EYdkEKfRh2GpWFuZtV4vGg
bzKbeyLHv2Z9ybK5CK5bxmNaXg3VMgLr/5cLywh1HR8mk1E9YnRTA7oeeuPN
KHbLS0VJOA1CilMPgmwRa0vCmgfzwxHDa9E+qrvp4fZXqjzVvScUa4MWhtJZ
Qy+8ZqtdvFa8x+FuoY8wBCYnhvCZs/gxaCfmBIedXFgRUew5HQ2MK39PePHm
0CncL3gl3SazQMz4afsXspKwhZvfT5mNrdhDd0dBj4it09vVh7JWz6peWxRV
vUY0VfVarqt6XdXrql5balWvy881Go0CuGwX1eVKkmS9Xrt+eGtvVeWa5XI5
mUwYy3ZN0jTV3Uo88svSW1W3hel0ivTWuJn0zkwdLV9vVfUoeTxkepSwN9wE
vypLb9VGrMUd8biBVay43qrwf8S9LOXo24i1G3qXfLee6geAhjoYVdNXTA+D
MLx/T/UE4FToYc902x5qV0pR/xWR2l9ld3oM\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->238536121]
}, Open  ]],

Cell["The matrices used to compute the minors:", "ExampleText",
 CellID->358881777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "3", ",", "Identity"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->100268213],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{356, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->683500755]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216679859],

Cell[TextData[{
 "2\[Times]2 Minors of a ",
 Cell[BoxData[
  FormBox[
   RowBox[{"3", "\[Times]", "4"}], TraditionalForm]], "InlineMath"],
 " matrix:"
}], "ExampleText",
 CellID->115501580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mat", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Range", "[", "12", "]"}], ",", "4"}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430510472],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4"},
     {"5", "6", "7", "8"},
     {"9", "10", "11", "12"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{97, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->53490105]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "2"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->86484904],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD9zWjEMN8/wmjT/GkJ6aVPusvd7tFM/BJfLXTL02kszsDEyMjL1uM4Z
GBkZGRkZGRkZGV1Z1sNG6LXmQZoM5e49W7ae9LMsyRZfGg+3N18bD3fXjavP
943vt3fXP64+fbuHIV1SSj3C8/FCQd9AD59HY6AN3xX71r1ez+BP/US61WoR
rZGrjN3JZDIYDGz3GF4aBFapfQ9tBdqE2nM2X6d2qW08HnPp3W6XdJ4gbfE6
+o19VZY0fqPUJeNKRK63UbLqjMshWiwWzWbT49TZqIOKXFaUHU+h3Q/odR2n
NFthujSjDwpJzbhTlNZutwHm0io4m4xGoyNRRjXKvmVGy1/Jo+/E0VcoEVwK
HGsVK3rDbDazXcRc9nqVOjPOmz4wRNyy1dwvL9dmHBbv4SEWHw3HgYZ4y6US
ro2keGvBtrpg3SlCOXZqhXDuZftHLCURp43xhO1IQtGhKW7D+TrRe0yOLP3X
fy4aPSL7WTtmeSKkM3tXc/hq1O5HaTs0f/Mjk+ttsnfx2JHz9zYa4jwqzPXr
Ml4bObfLODJunlHjMn4xXbKsuLVvs6vb7MzT72oWHeeCprJavz0gAvFEyZPw
ZPET0Bd/mN/QugFd28KucevgN58z8aswSuJXEyd7My+xOhLKSVmu1ESHZ1Ue
X5wPvNSTZBOuTqcTweWrjpALbg7z+dx2T0yxKsOdGdPptN/vG7N6U4LrHdUe
eJI8a5XhMvhwOBTuv2ACQv9yqwzY5ZUqg9dxB6Ks5602vA96zAl4xL+pMjBT
wL7i6kiSt9dhIDneUrupLlKGRQcIXSFWHOEuq4uUIXI4bSYoUk3geuifEFX6
DZ80aac=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{171, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->447962276]
}, Open  ]],

Cell["The matrices used to compute the minors:", "ExampleText",
 CellID->414515063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "2", ",", "Identity"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->260912530],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{375, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->306356294]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->558119070],

Cell["Define the adjoint of a matrix:", "ExampleText",
 CellID->228094263],

Cell[BoxData[
 RowBox[{
  RowBox[{"adj", "[", "m_", "]"}], ":=", 
  RowBox[{
   RowBox[{"Map", "[", 
    RowBox[{"Reverse", ",", 
     RowBox[{"Minors", "[", 
      RowBox[{
       RowBox[{"Transpose", "[", "m", "]"}], ",", 
       RowBox[{
        RowBox[{"Length", "[", "m", "]"}], "-", "1"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "]"}], 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"i", "+", "j"}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "m", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", 
       RowBox[{"Length", "[", "m", "]"}]}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->620568634],

Cell[TextData[{
 "Show its relation to ",
 Cell[BoxData[
  ButtonBox["Det",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Det"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Inverse",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inverse"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->222809384],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49989413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"adj", "[", "mat", "]"}], "-", 
   RowBox[{
    RowBox[{"Inverse", "[", "mat", "]"}], 
    RowBox[{"Det", "[", "mat", "]"}]}]}], "//", "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->333325333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{354, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1252139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341570230],

Cell["Compute the rank of a matrix:", "ExampleText",
 CellID->857330844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mat", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Range", "[", "20", "]"}], ",", "5"}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->654818451],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4", "5"},
     {"6", "7", "8", "9", "10"},
     {"11", "12", "13", "14", "15"},
     {"16", "17", "18", "19", "20"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{126, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->461436322]
}, Open  ]],

Cell[TextData[{
 "The rank is the largest ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"], "[", 
   RowBox[{
    StyleBox["mat", "TI"], ",", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 "contains nonzero entries:"
}], "ExampleText",
 CellID->1410262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "4"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280703515],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwhAMxvwQDkP0fyALj
8P//gTQriGQG8cGAwQONzwJWxYIm6oXGZwarYkYTBZkN4vIQoDnQ9DFhNQ3s
BlY4H6yGgYGLRqLso24adRPN3YSer5jp6iY2bLZjlAggUWJyMbppkJIjHAfJ
wAgAz613jQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->374366894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "3"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->272515907],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb1ugzAQgA2U/nfvmNfoC7RTHwJFlZKhapVmYGNkZHQ3pLwAIyMjIyMj
IyMjo3u2ITY0USMVVGqMhDlOlvF9vrPR3bOzXb28Otv10lk8bZz31Xr5sXh8
24DKMhBCO7gf7hHIBCR27wiBp9zatLXCMCTsQhY0FnS9Heh5wQb1PE8aH6Ez
JuZ5HsfxXmvTGbYXyOhaCe15SzjLsj4BjLHMZZLzH4pAXdeu6woCVqvlEDiR
Sc7/91oeBb7vg7lUNPcEzDRN7QnMcFzLIcwh2LuWM+8vy5LMYu3FXicTEPui
+gTA9fkxc4QAjYIhT54r0t1hjYNf/ey9z7fXOPx/+qrKfn+pCWgCmoAmoAmc
ROBvTqCpnsf6D+D/a3XkawKagCagCeg/gHF7BUFwQi+R55d7YYyrqhqDP1/1
oiiiKKKinPmJ47jJiKvs9zz3lSTJgfwnQG+4qE8A/LOT+55T/aNfAxMETIgA
ldeeVn5M8HFmY1NrFGtuTmCGY1r+zb8bArzoMQ8CwlZO4IYMe8LcsVF5LRsZ
X/DZN4U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->357708372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "2"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->620619725],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXL1y2zAMpiU5TZs6dmPH/R3yBl3TF2inzp19ud4lQ6+9NIO3jBkzaswj
ZPSYMWNGjx49evSokpRo0SglQhQl2Q5zZ1mkQOATwB8QBvN9dHX+89fo6uJs
dPLtcvTn/OLs78nX35e0ym8R0jolhPx4R+h9RO/4h/19oZ/4Ft612dW/u7vj
dBE5oBefNvtAv9v020/KfU15gGyXRSfqDzme6+vrBI/PUQb8djqdTiYTgZK0
xdtxQvr3kVOtaomnpBqgqI6UtUVoq0eDk6Bu24kSuz89PUE9h2EoaZ81fQEk
dZP6NgrBqwzqPVDeT+gCUO/ncq0Xmx1pkAvvz/5yuRyPx6k1fFEbG4T0QKv3
KJmwh8E3O0JxGVYiGz7HcYVYXvPyzc0NVdWqFdee9/j4yGYURvzJCLGYn4ZK
ah9Qv7Eia1CISz+h7nJqOkHSaXJdC3xEz+dzdtsBPM2RyuW37BKkZbVm7MuF
z/Eag2NYXl1kzaUrUTWa6ytb4XBvng7pAIxdiRwdsm7CVn8vmTVFjxflQOrT
gfQc2y6LLliNkXR9aylRsstnUOcoISWbdTGenrDhMPn2Muh17XX0sPwS9Rax
v6nr7eW9wZyVLHfexK3OVeGz7yvjOO5HGNuxnlHc9zLwLnMtJDxDVr9HBAF/
HCNR0G4G4ipR4Hjj7Iwbo7iepR9xPWW7MjJtIcPNBTYx2bTPsbJW9Y6eqFd7
HWs6KvN2NhDZllSvTfR9bqClkFGXHSm28ZSRVL816ljFy1roeXoabN8C9xNw
fwJ9XTFnwH0Kpj2GXn6O83XZZRt2Fs1SdqJmI+A9FEoe83IR8BJtuyg9iz2G
i4BXGwHvoKzhIuBqLDjtiZlt1yPhuBnURcL/j+I2qbldiYTjddh8JHyzPbFt
oYSRcF3kWxfZLho51/FrKhLeRKxt06PvdcS/cz23QrFsyFl+jn1jI//SCkr7
EnUc91B2gyNN6RMajBvIp8zoqgoTHFHF5eg4mNlAzJUsUlsk/izv8oPMdln+
ram0YyN+WSjM1ofini+MFCs9QKkcoN/CLg6Vds0lqDjY0XgRjxnGgHW+L74H
VYVIZwVTWeb2kKPAKt9cjvoGJPXLVFFgTPu+hh7yw3kN7LINXnWzlC67ZTv9
6935zcllt5RD7LJb6tlxu+wWxstlt2Ak1WsTl91Slo/LbrGP0Y50l92yWfuF
ailvb2+RlOlJTpkyDMPFYhFFzWe3xL87zWaz+/v7SPTbBOVkMklOI7rsFrwE
ddt4Tn54eFCcBqNdIdG+y26B2KrJbolPKNJRvHZCEZ627YJWLrtF1l4626Xa
8+h88VyyWtiI9ui45b0m6Y9p3zkAvFw2i/BL10+zC83Fx2Gr09yuZLMcAm3F
OszLLqkje4Wj5BDj/2JBWv8ASP545Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{312, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->161999939]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MatrixRank",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixRank"]], "InlineFormula"],
 " to check that the rank is indeed equal to two:"
}], "ExampleText",
 CellID->574163037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "mat", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->125460652],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->207624743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51561375],

Cell["Find singularities of an algebraic space curve:", "ExampleText",
 CellID->67330718],

Cell[BoxData[
 RowBox[{
  RowBox[{"curve", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"4", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"x", "^", "4"}]}], "+", 
      RowBox[{"z", "^", "2"}]}], ",", 
     RowBox[{"x", "-", "y", "-", 
      RowBox[{"z", "^", "2"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129275449],

Cell[BoxData[
 RowBox[{
  RowBox[{"JacobianMinors", "[", 
   RowBox[{"polys_", ",", "vars_"}], "]"}], ":=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Minors", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"polys", ",", 
       RowBox[{"{", "vars", "}"}]}], "]"}], ",", 
     RowBox[{"Length", "[", "polys", "]"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->694726976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sing", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Join", "[", 
      RowBox[{"curve", ",", 
       RowBox[{"JacobianMinors", "[", 
        RowBox[{"curve", ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "]"}], 
     "\[Equal]", "0"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Reals"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63563384],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", "0"}], "&&", 
  RowBox[{"y", "\[Equal]", "0"}], "&&", 
  RowBox[{"z", "\[Equal]", "0"}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26861735]
}, Open  ]],

Cell["The curve is the intersection of two surfaces:", "ExampleText",
 CellID->387982420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ContourPlot3D", "[", 
    RowBox[{"curve", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"Contours", "\[Rule]", 
      RowBox[{"{", "0", "}"}]}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Sphere", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", ".1"}], "]"}]}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->476741559],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->402071348]
}, Open  ]],

Cell["Generate an explicit parametrization of the curve:", "ExampleText",
 CellID->132183129],

Cell[BoxData[
 RowBox[{
  RowBox[{"CurveParametrization", "[", 
   RowBox[{"polys_", ",", "vars_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vars", "//.", 
       RowBox[{"{", 
        RowBox[{"ToRules", "[", 
         RowBox[{"Rest", "[", "#", "]"}], "]"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "3"}], "]"}], "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
        RowBox[{"#", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "5"}], "]"}], "]"}]}], "}"}]}], "}"}], "&"}], "/@",
    
   RowBox[{"List", "@@", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Reduce", "[", 
       RowBox[{
        RowBox[{"polys", "\[Equal]", "0"}], ",", "vars", ",", "Reals", ",", 
        RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Head", "[", 
         RowBox[{"#", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}], "===", "Inequality"}], 
       "&"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->52803377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"ParametricPlot3D", "@@@", 
      RowBox[{"CurveParametrization", "[", 
       RowBox[{"curve", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ",", 
     RowBox[{"Graphics3D", "[", 
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"PointSize", "[", "Large", "]"}], ",", 
        RowBox[{"Point", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", "z"}], "}"}], "/.", 
          RowBox[{"{", 
           RowBox[{"ToRules", "[", "sing", "]"}], "}"}]}], "]"}]}], "}"}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->719807379],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->323389690]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->127358994],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 " of dimensions higher than the ",
 Cell[BoxData[
  ButtonBox["MatrixRank",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixRank"]], "InlineFormula"],
 " are zero:"
}], "ExampleText",
 CellID->246139085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"mat", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"10", "i"}], "+", "j"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162174201],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"11", "12", "13", "14", "15"},
     {"21", "22", "23", "24", "25"},
     {"31", "32", "33", "34", "35"},
     {"41", "42", "43", "44", "45"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{126, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->573872120]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "mat", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127581842],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118661609]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"mat", ",", "3"}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->496993694],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb1ugzAQgA2U/nfvmNfoC7RTHwJFlZKhapVmYGNkZHQ3pLwAIyMjIyMj
IyMjo3u2ITY0USMVVGqMhDlOlvF9vrPR3bOzXb28Otv10lk8bZz31Xr5sXh8
24DKMhBCO7gf7hHIBCR27wiBp9zatLXCMCTsQhY0FnS9Heh5wQb1PE8aH6Ez
JuZ5HsfxXmvTGbYXyOhaCe15SzjLsj4BjLHMZZLzH4pAXdeu6woCVqvlEDiR
Sc7/91oeBb7vg7lUNPcEzDRN7QnMcFzLIcwh2LuWM+8vy5LMYu3FXicTEPui
+gTA9fkxc4QAjYIhT54r0t1hjYNf/ey9z7fXOPx/+qrKfn+pCWgCmoAmoAmc
ROBvTqCpnsf6D+D/a3XkawKagCagCeg/gHF7BUFwQi+R55d7YYyrqhqDP1/1
oiiiKKKinPmJ47jJiKvs9zz3lSTJgfwnQG+4qE8A/LOT+55T/aNfAxMETIgA
ldeeVn5M8HFmY1NrFGtuTmCGY1r+zb8bArzoMQ8CwlZO4IYMe8LcsVF5LRsZ
X/DZN4U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->601040689]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360131852],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Dimensions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dimensions"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " minors of an ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", "\[Times]", "n"}], TraditionalForm]], "InlineMath"],
 " matrix are ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", GridBox[{
      {"m"},
      {
       StyleBox["k", "TI"]}
     }], ")"}], "\[Cross]", 
   RowBox[{"(", GridBox[{
      {
       StyleBox["n", "TI"]},
      {
       StyleBox["k", "TI"]}
     }], ")"}]}]]],
 " :"
}], "ExampleText",
 CellID->5961990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Minors", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{"1", ",", 
      RowBox[{"{", 
       RowBox[{"7", ",", "9"}], "}"}]}], "]"}], ",", "5"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->283916115],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "126"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672199528]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"7", ",", "5"}], "]"}], ",", 
   RowBox[{"Binomial", "[", 
    RowBox[{"9", ",", "5"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->697962761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"21", ",", "126"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34410416]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->91352803],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 " of an ",
 Cell[BoxData[
  ButtonBox["IdentityMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFormula"],
 " gives an ",
 Cell[BoxData[
  ButtonBox["IdentityMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/IdentityMatrix"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->569683559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"IdentityMatrix", "[", "4", "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238444590],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmL1ugzAQgA2E/iXZO+Y1unRss/QhUFQpGapWaYZsjIyMjDwCI2NGRkZG
RsaMGd3zX+y4jhQarEQqSHC2dfJn351PPt6C1fz9I1gtZsHkdRl8zRez78nL
5xKGPAchNIX36RFBG0OLvlOMQapfn3y9NE0xfZAHHw9UR5ocgvRB3lClMAwV
fYQGtFlVVZ7n+1GijsUDbfTQYnREp9mPci6ssyxLnZskiboaC9zdbrderyXX
E6MMzdbRKfeW9qMoAghpunuuWxSFb4kH7gMnHvKofZumsblPGTkqV0aZLS4Y
l4X+ES6xs+k0EOkKlhJ/jnGWZ63/f7V0e4qsMuT9+5NmaRMNut/NWnc9t+de
jGvKMiS7jHGbU3GtZ/5yWUbPLsK+52SZ0/zefRT23J57HlfNMmp2aXcqrvXM
t9GK4/gELVkTqVpw19tut5j70ZRdhGReqes6yzLSVG+YcNnldQyrL/7md/Mo
u9luNhvDTR6Wzldjiwu2PahY9ArNt8SV3pNcF2zc/T7JjC5Yke6M70fub2CF
96vG5VxWltnkSgLjkmg3ZQ8hx1SL/VtAzg9U6pJB\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{72, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->97548682]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{
    RowBox[{"IdentityMatrix", "[", "4", "]"}], ",", "2"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55268911],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmj1zgjAYgCNIv9S9o7+mnTp36cJ59XTotWcd3BgdGRn5CY6Mjo6OjIyO
jo7pmy8TKWo8QXJHuIM35AI8JC/P4OubPx19fvnT8cDvv078n9F48Nt/+Z5A
l9tCCA1hf39G0MbQovsQY4jq0SNHN45jTDfkwsGFod0zsQPRg3hHLwqCQLke
oTZtpmmaJMm+lwzHYoM2eqqot0sfue/ljPCO6/U6zxhFkUpeM+Nut5vNZpLR
Fb0MkzHXxnhPz+fzOQCRprNndFarlWcAG6QbJN0hG13jzWZjyvzJr0JllF+Q
CYywwEwJRxjJWutYgkRHPFv51lqFd/3InTd31Ln5Ffbt8PNHrbtWlVn5HCoe
9WAZLaNlrIBRx8bEwj18iS1MdaM5Ns5bWPTfysZ6OVRv9ltGy9gsxlM2Vi18
mS1MdWP9Nj5m4epsfE0O3Sr7LaNltIzFNi6ysLXxdTY+Z+EybFx+DpWf/ZbR
MlpGHRufsnDzbByGocYoWadTR0VRtN1uMc8BHQuLyFYty7LFYkGa6q/9SZLw
ehmrTVWfQ8W9rCKxXC4LKjvw2pzcBEZYw4PKWL7C6BnAKDNKMjqwzvXOH3m6
AytJZ4zPk5y3du1s/+rEnJGVFU1hlDSMkVhAx7Ii9uhV7H8BqPUHMKlgiA==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->435601679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80227402],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 " of a ",
 Cell[BoxData[
  ButtonBox["DiagonalMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["DiagonalMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiagonalMatrix"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->74634588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{"DiagonalMatrix", "[", 
    RowBox[{"Range", "[", "4", "]"}], "]"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->494966945],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"6", "0", "0", "0"},
     {"0", "8", "0", "0"},
     {"0", "0", "12", "0"},
     {"0", "0", "0", "24"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{90, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->136804191]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Minors", "[", 
   RowBox[{
    RowBox[{"DiagonalMatrix", "[", 
     RowBox[{"Range", "[", "4", "]"}], "]"}], ",", "2"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->312859162],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2", "0", "0", "0", "0", "0"},
     {"0", "3", "0", "0", "0", "0"},
     {"0", "0", "4", "0", "0", "0"},
     {"0", "0", "0", "6", "0", "0"},
     {"0", "0", "0", "0", "8", "0"},
     {"0", "0", "0", "0", "0", "12"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{113, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->828784360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274405106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minors"]], "InlineFormula"],
 " is effectively equivalent to an outer product of row and column \
extractions:"
}], "ExampleText",
 CellID->356384964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"10", "i"}], "+", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9740705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "13", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "22", ",", "23", ",", "24"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "32", ",", "33", ",", "34"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "42", ",", "43", ",", "44"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->158826887]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"m", "[", 
      RowBox[{"[", 
       RowBox[{"#1", ",", "#2"}], "]"}], "]"}], "&"}], ",", 
    RowBox[{"Subsets", "[", 
     RowBox[{
      RowBox[{"Range", "[", "4", "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], ",", 
    RowBox[{"Subsets", "[", 
     RowBox[{
      RowBox[{"Range", "[", "4", "]"}], ",", 
      RowBox[{"{", "2", "}"}]}], "]"}], ",", "1"}], "]"}], "==", 
  RowBox[{"Minors", "[", 
   RowBox[{"m", ",", "2", ",", "Identity"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3846174],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96266232]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9766],

Cell["Some minor variations:", "ExampleText",
 CellID->353911423],

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "6"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10037999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"ArrayFlatten", "[", 
     RowBox[{"Minors", "[", 
      RowBox[{"mat", ",", "3", ",", "Identity"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"Minors", "[", 
     RowBox[{"mat", ",", "3"}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->515257672],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1u0zAUx524Ca2AjnAD3dW0i73AkLhht9sVD1FNSNsFAo09AXsVHgAG
4vWCndjUNV76saKec/yv1DjHcU79O43//kjT9/Pbqw8f57fXl/Oji5v556vr
yy9H559uTJYulCq+KqV+v1ZmvzV73du+7sxbqbHZ3pus5yb9qXpbqSd2q33J
Vn2P7MmK43UmXg7MxppTl9aRrU1auvw6OF4lyvnzq6CcDsrXgZ/S5Y9WUJyZ
zaExT016nCgPKpZUo7+5znfpPku71NfZnjMN8rWrc2hr1+rriK0M2Hz6NOEn
PB4zgTF7xkQL9LXytqd89kBtxgO111GUwhYXtkzrN64PqFZTUVVLa0/cldq4
aL50aePyxy6duHzQg16aEiMWiMU+YuHr9CqoW8ycikkZ2T6GB0FsH9vjgR3s
+fWKfpw3c+kJqIRSUZ9pgEoUFRv9B5NsJq14jb/jsYcdczTtYmxi7bdgZ66k
oAXtuq2YsiqDFaz8Z1Yy7tuLp2A7tgETe6aBUvy9MNYEUJCmoDpGz4mCktI8
wovEXgVMPJjEaQIo6FDsXVl37kXWGAYUe6Jgs1oGBvIMlJRS4ggJTAyZmLZl
MNBgIKKpIxeJDqk/qH6s48l9B6p7Vd1e56IKvxt7rGmX2yvJecY/tR6BiDVR
qABklYEf0UJ53bcvgCkgKBN5m1PdJ3M38VvG9Uqdu9QL+pHQkOLHXor+MwPl
j+ebm/Yp1lVhTOu5WIuE+gzb/nLSP7lg09PAbhLnp2M8rLqs2bfqZ/Ih9jXi
MvtBBP7fVf9QjavITkUgjlh43lDk/NXv7ele2z0igAhQ1f5vbf+s4hBZarb8
ghNXYtbO7Z7HEk+Qn14VoX6XEzRSaagrPOhE07G9/3Le9iOMdyadgTEHRkZ9
Aqhyo6LeF4ByNSXVuUw8y561i//Tsf37YbvNKAa0QmjZ/M4BrGCV1+eAHvS7
auVa8Zm5WfvMfd4b1a/cS52lglVGTwW2bNgY9yqgBS3vtbRjl57kRsVGUcEk
jomxKoISlH1tqK7Tin8SXBzF3p9B3rkXbkoAKhFUbFeywMSeCUoMzQIVwzUT
UHCjoKSvUGlQsaVis7YIBvIMRJUV+pwbFaXrZnsvv1Q/yrJp9780XZG7bk8V
fwCmoh1M\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->983210583]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18629],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Delete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Delete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22851]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15864],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "Tutorials",
 CellID->20537]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14197656],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->416525872],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->44050498]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Minors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 0, 49.6364502}", "context" -> "System`", 
    "keywords" -> {
     "cofactors", "combinations", "minors of matrices", "matrix rank", 
      "adjoint"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Minors[m] gives the minors of a matrix m. Minors[m, k] gives \
k\\[Null]\\[Null]^th minors. ", "synonyms" -> {}, "title" -> "Minors", "type" -> 
    "Symbol", "uri" -> "ref/Minors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9593, 353, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->265726377]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 86211, 2443}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2141, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2764, 79, 44, 1, 70, "ObjectName",
 CellID->10139],
Cell[2811, 82, 1082, 37, 70, "Usage",
 CellID->12082]
}, Open  ]],
Cell[CellGroupData[{
Cell[3930, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4408, 141, 1175, 45, 70, "Notes",
 CellID->14024],
Cell[5586, 188, 1048, 40, 70, "Notes",
 CellID->20900],
Cell[6637, 230, 476, 19, 70, "Notes",
 CellID->1575],
Cell[7116, 251, 670, 25, 70, "Notes",
 CellID->19337],
Cell[7789, 278, 296, 6, 70, "Notes",
 CellID->15376],
Cell[8088, 286, 902, 40, 70, "Notes",
 CellID->11300],
Cell[8993, 328, 563, 20, 70, "Notes",
 CellID->19424]
}, Closed]],
Cell[CellGroupData[{
Cell[9593, 353, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->265726377],
Cell[CellGroupData[{
Cell[9978, 367, 148, 5, 70, "ExampleSection",
 CellID->348148119],
Cell[10129, 374, 176, 7, 70, "ExampleText",
 CellID->7920076],
Cell[CellGroupData[{
Cell[10330, 385, 319, 12, 28, "Input",
 CellID->451192175],
Cell[10652, 399, 1037, 21, 80, "Output",
 Evaluatable->False,
 CellID->137734529]
}, Open  ]],
Cell[CellGroupData[{
Cell[11726, 425, 136, 4, 28, "Input",
 CellID->98990379],
Cell[11865, 431, 1536, 29, 80, "Output",
 Evaluatable->False,
 CellID->33102155]
}, Open  ]],
Cell[13416, 463, 124, 3, 70, "ExampleDelimiter",
 CellID->38138880],
Cell[13543, 468, 189, 7, 70, "ExampleText",
 CellID->198182832],
Cell[CellGroupData[{
Cell[13757, 479, 362, 13, 28, "Input",
 CellID->279757422],
Cell[14122, 494, 716, 16, 64, "Output",
 Evaluatable->False,
 CellID->500679278]
}, Open  ]],
Cell[CellGroupData[{
Cell[14875, 515, 127, 4, 28, "Input",
 CellID->510316129],
Cell[15005, 521, 894, 19, 36, "Output",
 Evaluatable->False,
 CellID->92034253]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15948, 546, 220, 7, 70, "ExampleSection",
 CellID->374524412],
Cell[16171, 555, 178, 7, 70, "ExampleText",
 CellID->294582923],
Cell[CellGroupData[{
Cell[16374, 566, 455, 16, 70, "Input",
 CellID->578863953],
Cell[16832, 584, 813, 24, 92, "Output",
 CellID->77122500]
}, Open  ]],
Cell[CellGroupData[{
Cell[17682, 613, 136, 4, 70, "Input",
 CellID->58261985],
Cell[17821, 619, 1175, 23, 70, "Output",
 Evaluatable->False,
 CellID->238536121]
}, Open  ]],
Cell[19011, 645, 83, 1, 70, "ExampleText",
 CellID->358881777],
Cell[CellGroupData[{
Cell[19119, 650, 181, 6, 70, "Input",
 CellID->100268213],
Cell[19303, 658, 3397, 60, 70, "Output",
 Evaluatable->False,
 CellID->683500755]
}, Open  ]],
Cell[22715, 721, 125, 3, 70, "ExampleDelimiter",
 CellID->216679859],
Cell[22843, 726, 189, 7, 70, "ExampleText",
 CellID->115501580],
Cell[CellGroupData[{
Cell[23057, 737, 255, 9, 70, "Input",
 CellID->430510472],
Cell[23315, 748, 774, 23, 78, "Output",
 CellID->53490105]
}, Open  ]],
Cell[CellGroupData[{
Cell[24126, 776, 160, 5, 70, "Input",
 CellID->86484904],
Cell[24289, 783, 1086, 22, 70, "Output",
 Evaluatable->False,
 CellID->447962276]
}, Open  ]],
Cell[25390, 808, 83, 1, 70, "ExampleText",
 CellID->414515063],
Cell[CellGroupData[{
Cell[25498, 813, 181, 6, 70, "Input",
 CellID->260912530],
Cell[25682, 821, 2546, 46, 70, "Output",
 Evaluatable->False,
 CellID->306356294]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28277, 873, 227, 7, 70, "ExampleSection",
 CellID->558119070],
Cell[28507, 882, 74, 1, 70, "ExampleText",
 CellID->228094263],
Cell[28584, 885, 819, 27, 70, "Input",
 CellID->620568634],
Cell[29406, 914, 321, 13, 70, "ExampleText",
 CellID->222809384],
Cell[29730, 929, 222, 8, 70, "Input",
 CellID->49989413],
Cell[CellGroupData[{
Cell[29977, 941, 247, 8, 70, "Input",
 CellID->333325333],
Cell[30227, 951, 498, 15, 36, "Output",
 CellID->1252139]
}, Open  ]],
Cell[30740, 969, 125, 3, 70, "ExampleDelimiter",
 CellID->341570230],
Cell[30868, 974, 72, 1, 70, "ExampleText",
 CellID->857330844],
Cell[CellGroupData[{
Cell[30965, 979, 255, 9, 70, "Input",
 CellID->654818451],
Cell[31223, 990, 831, 24, 92, "Output",
 CellID->461436322]
}, Open  ]],
Cell[32069, 1017, 397, 15, 70, "ExampleText",
 CellID->1410262],
Cell[CellGroupData[{
Cell[32491, 1036, 161, 5, 70, "Input",
 CellID->280703515],
Cell[32655, 1043, 418, 11, 70, "Output",
 Evaluatable->False,
 CellID->374366894]
}, Open  ]],
Cell[CellGroupData[{
Cell[33110, 1059, 161, 5, 70, "Input",
 CellID->272515907],
Cell[33274, 1066, 781, 17, 70, "Output",
 Evaluatable->False,
 CellID->357708372]
}, Open  ]],
Cell[CellGroupData[{
Cell[34092, 1088, 161, 5, 70, "Input",
 CellID->620619725],
Cell[34256, 1095, 1659, 31, 70, "Output",
 Evaluatable->False,
 CellID->161999939]
}, Open  ]],
Cell[35930, 1129, 237, 8, 70, "ExampleText",
 CellID->574163037],
Cell[CellGroupData[{
Cell[36192, 1141, 108, 3, 70, "Input",
 CellID->125460652],
Cell[36303, 1146, 158, 5, 36, "Output",
 CellID->207624743]
}, Open  ]],
Cell[36476, 1154, 124, 3, 70, "ExampleDelimiter",
 CellID->51561375],
Cell[36603, 1159, 89, 1, 70, "ExampleText",
 CellID->67330718],
Cell[36695, 1162, 426, 15, 70, "Input",
 CellID->129275449],
Cell[37124, 1179, 393, 12, 70, "Input",
 CellID->694726976],
Cell[CellGroupData[{
Cell[37542, 1195, 483, 16, 70, "Input",
 CellID->63563384],
Cell[38028, 1213, 282, 9, 36, "Output",
 CellID->26861735]
}, Open  ]],
Cell[38325, 1225, 89, 1, 70, "ExampleText",
 CellID->387982420],
Cell[CellGroupData[{
Cell[38439, 1230, 827, 26, 70, "Input",
 CellID->476741559],
Cell[39269, 1258, 21900, 363, 70, "Output",
 Evaluatable->False,
 CellID->402071348]
}, Open  ]],
Cell[61184, 1624, 93, 1, 70, "ExampleText",
 CellID->132183129],
Cell[61280, 1627, 1204, 38, 70, "Input",
 CellID->52803377],
Cell[CellGroupData[{
Cell[62509, 1669, 1082, 34, 70, "Input",
 CellID->719807379],
Cell[63594, 1705, 3962, 69, 70, "Output",
 Evaluatable->False,
 CellID->323389690]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67605, 1780, 237, 7, 70, "ExampleSection",
 CellID->127358994],
Cell[67845, 1789, 342, 12, 70, "ExampleText",
 CellID->246139085],
Cell[CellGroupData[{
Cell[68212, 1805, 385, 14, 70, "Input",
 CellID->162174201],
Cell[68600, 1821, 840, 24, 92, "Output",
 CellID->573872120]
}, Open  ]],
Cell[CellGroupData[{
Cell[69477, 1850, 108, 3, 70, "Input",
 CellID->127581842],
Cell[69588, 1855, 158, 5, 36, "Output",
 CellID->118661609]
}, Open  ]],
Cell[CellGroupData[{
Cell[69783, 1865, 161, 5, 70, "Input",
 CellID->496993694],
Cell[69947, 1872, 781, 17, 70, "Output",
 Evaluatable->False,
 CellID->601040689]
}, Open  ]],
Cell[70743, 1892, 125, 3, 70, "ExampleDelimiter",
 CellID->360131852],
Cell[70871, 1897, 718, 32, 70, "ExampleText",
 CellID->5961990],
Cell[CellGroupData[{
Cell[71614, 1933, 286, 10, 70, "Input",
 CellID->283916115],
Cell[71903, 1945, 206, 7, 36, "Output",
 CellID->672199528]
}, Open  ]],
Cell[CellGroupData[{
Cell[72146, 1957, 237, 8, 70, "Input",
 CellID->697962761],
Cell[72386, 1967, 205, 7, 36, "Output",
 CellID->34410416]
}, Open  ]],
Cell[72606, 1977, 124, 3, 70, "ExampleDelimiter",
 CellID->91352803],
Cell[72733, 1982, 463, 17, 70, "ExampleText",
 CellID->569683559],
Cell[CellGroupData[{
Cell[73221, 2003, 180, 6, 70, "Input",
 CellID->238444590],
Cell[73404, 2011, 811, 17, 70, "Output",
 Evaluatable->False,
 CellID->97548682]
}, Open  ]],
Cell[CellGroupData[{
Cell[74252, 2033, 204, 7, 70, "Input",
 CellID->55268911],
Cell[74459, 2042, 895, 19, 70, "Output",
 Evaluatable->False,
 CellID->435601679]
}, Open  ]],
Cell[75369, 2064, 124, 3, 70, "ExampleDelimiter",
 CellID->80227402],
Cell[75496, 2069, 460, 17, 70, "ExampleText",
 CellID->74634588],
Cell[CellGroupData[{
Cell[75981, 2090, 214, 7, 70, "Input",
 CellID->494966945],
Cell[76198, 2099, 801, 24, 92, "Output",
 CellID->136804191]
}, Open  ]],
Cell[CellGroupData[{
Cell[77036, 2128, 240, 8, 70, "Input",
 CellID->312859162],
Cell[77279, 2138, 915, 26, 122, "Output",
 CellID->828784360]
}, Open  ]],
Cell[78209, 2167, 125, 3, 70, "ExampleDelimiter",
 CellID->274405106],
Cell[78337, 2172, 252, 8, 70, "ExampleText",
 CellID->356384964],
Cell[CellGroupData[{
Cell[78614, 2184, 305, 11, 70, "Input",
 CellID->9740705],
Cell[78922, 2197, 518, 16, 36, "Output",
 CellID->158826887]
}, Open  ]],
Cell[CellGroupData[{
Cell[79477, 2218, 599, 19, 70, "Input",
 CellID->3846174],
Cell[80079, 2239, 160, 5, 36, "Output",
 CellID->96266232]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80288, 2250, 223, 7, 70, "ExampleSection",
 CellID->9766],
Cell[80514, 2259, 65, 1, 70, "ExampleText",
 CellID->353911423],
Cell[80582, 2262, 230, 8, 70, "Input",
 CellID->10037999],
Cell[CellGroupData[{
Cell[80837, 2274, 375, 11, 70, "Input",
 CellID->515257672],
Cell[81215, 2287, 1380, 27, 70, "Output",
 Evaluatable->False,
 CellID->983210583]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[82656, 2321, 311, 9, 70, "SeeAlsoSection",
 CellID->18629],
Cell[82970, 2332, 907, 35, 70, "SeeAlso",
 CellID->22851]
}, Open  ]],
Cell[CellGroupData[{
Cell[83914, 2372, 314, 9, 70, "TutorialsSection",
 CellID->15864],
Cell[84231, 2383, 155, 3, 70, "Tutorials",
 CellID->20537]
}, Open  ]],
Cell[CellGroupData[{
Cell[84423, 2391, 318, 9, 70, "MoreAboutSection",
 CellID->14197656],
Cell[84744, 2402, 139, 3, 70, "MoreAbout",
 CellID->416525872],
Cell[84886, 2407, 162, 3, 70, "MoreAbout",
 CellID->44050498]
}, Open  ]],
Cell[85063, 2413, 50, 0, 70, "History"],
Cell[85116, 2415, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

