(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44491,       1678]
NotebookOptionsPosition[     34748,       1339]
NotebookOutlinePosition[     36203,       1379]
CellTagsIndexPosition[     36117,       1374]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions as Procedures" :> 
          Documentation`HelpLookup["paclet:tutorial/FunctionsAsProcedures"], 
          "Modules and Local Variables" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ModulesAndLocalVariables"], 
          "Variables in Pure Functions and Rules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/VariablesInPureFunctionsAndRules"], 
          "Blocks Compared with Modules" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BlocksComparedWithModules"], 
          "Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Functions as Procedures\"\>", 
       2->"\<\"Modules and Local Variables\"\>", 
       3->"\<\"Variables in Pure Functions and Rules\"\>", 
       4->"\<\"Blocks Compared with Modules\"\>", 
       5->"\<\"Introduction to Dynamic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"With" :> Documentation`HelpLookup["paclet:ref/With"], "Block" :> 
          Documentation`HelpLookup["paclet:ref/Block"], "DynamicModule" :> 
          Documentation`HelpLookup["paclet:ref/DynamicModule"], "Unique" :> 
          Documentation`HelpLookup["paclet:ref/Unique"], 
          "GeneratedParameters" :> 
          Documentation`HelpLookup["paclet:ref/GeneratedParameters"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"With\"\>", 
       2->"\<\"Block\"\>", 3->"\<\"DynamicModule\"\>", 4->"\<\"Unique\"\>", 
       5->"\<\"GeneratedParameters\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Language Overview\"\>", 3->"\<\"Namespace Management\"\>", 
       4->"\<\"Package Bulletproofing\"\>", 5->"\<\"Package Development\"\>", 
       6->"\<\"Procedural Programming\"\>", 
       7->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Module", "ObjectName",
 CellID->25419],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Module",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Module"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that occurrences of the symbols ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", \[Ellipsis]  in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " should be treated as local. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Module",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Module"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "=", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]defines initial values for ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", \[Ellipsis]. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28735]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " allows you to set up local variables with names that are local to the \
module. "
}], "Notes",
 CellID->16616],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " creates new symbols to represent each of its local variables every time it \
is called. "
}], "Notes",
 CellID->20113],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " creates a symbol with name ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["xxx", "TI"], "$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 " to represent a local variable with name ",
 Cell[BoxData[
  StyleBox["xxx", "TI"]], "InlineFormula"],
 ". The number ",
 Cell[BoxData[
  StyleBox["nnn", "TI"]], "InlineFormula"],
 " is the current value of ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13335],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " is incremented every time any module is used. "
}], "Notes",
 CellID->28592],

Cell[TextData[{
 "Before evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " substitutes new symbols for each of the local variables that appear \
anywhere in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " except as local variables in scoping constructs. "
}], "Notes",
 CellID->29018],

Cell[TextData[{
 "Symbols created by ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " carry the attribute ",
 Cell[BoxData[
  ButtonBox["Temporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9265],

Cell[TextData[{
 "Symbols created by ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " can be returned from modules. "
}], "Notes",
 CellID->9370],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"], "[", 
   RowBox[{
    RowBox[{"{", 
     StyleBox["vars", "TI"], "}"}], ",", 
    RowBox[{
     StyleBox["body", "TI"], "/;", 
     StyleBox["cond", "TI"]}]}], "]"}]], "InlineFormula"],
 " as the right\[Hyphen]hand side of a transformation rule with a condition \
attached. "
}], "Notes",
 CellID->22336],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26525],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " constructs can be nested in any way, with inner variables being renamed if \
necessary. "
}], "Notes",
 CellID->12746],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " is a scoping construct that implements lexical scoping. "
}], "Notes",
 CellID->17644]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80714432],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->543220243],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x0_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "=", "x0"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"x", ">", "0"}], ",", 
       RowBox[{"x", "=", 
        RowBox[{"Log", "[", "x", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]",
      "x"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->531020242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "2.0", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->617537663],

Cell[BoxData[
 RowBox[{"-", "0.36651292058166435`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19208448]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5857],

Cell["Dynamic programming with a local function:", "ExampleText",
 CellID->213989856],

Cell[BoxData[
 RowBox[{
  RowBox[{"fib", "[", "n_", "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "f", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "=", 
      RowBox[{
       RowBox[{"f", "[", "2", "]"}], "=", "1"}]}], ";", "\[IndentingNewLine]",
      
     RowBox[{
      RowBox[{"f", "[", "i_", "]"}], ":=", 
      RowBox[{
       RowBox[{"f", "[", "i", "]"}], "=", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"i", "-", "1"}], "]"}], "+", 
        RowBox[{"f", "[", 
         RowBox[{"i", "-", "2"}], "]"}]}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"f", "[", "n", "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3381480],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fib", "[", "5", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13953838],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->657801489]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->609441506],

Cell["\<\
Euclid's algorithm for the GCD using initialized local variables:\
\>", "ExampleText",
 CellID->260419147],

Cell[BoxData[
 RowBox[{
  RowBox[{"gcd", "[", 
   RowBox[{"m0_", ",", "n0_"}], "]"}], ":=", "\[IndentingNewLine]", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"m", "=", "m0"}], ",", 
      RowBox[{"n", "=", "n0"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"While", "[", 
      RowBox[{
       RowBox[{"n", "\[NotEqual]", "0"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"m", ",", "n"}], "}"}], "=", 
        RowBox[{"{", 
         RowBox[{"n", ",", 
          RowBox[{"Mod", "[", 
           RowBox[{"m", ",", "n"}], "]"}]}], "}"}]}]}], "]"}], ";", 
     "\[IndentingNewLine]", "m"}]}], "\[IndentingNewLine]", "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->614959507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gcd", "[", 
  RowBox[{"18", ",", "21"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->430217641],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89607771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2700],

Cell["\<\
Every time a module is evaluated, a new temporary symbol is created:\
\>", "ExampleText",
 CellID->202781666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "x"}], "]"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->592443154],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$100", ",", "x$101"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->155373935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286105926],

Cell["\<\
Module symbols are temporary and are removed if they are no longer \
referenced:\
\>", "ExampleText",
 CellID->16188905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "x", "]"}], ";", 
    RowBox[{"Attributes", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409793869],

Cell[BoxData["x$106"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->53680255],

Cell[BoxData[
 RowBox[{"{", "Temporary", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162729894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<x$*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34703542],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->459958815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->249276108],

Cell[TextData[{
 "Each use of ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " increments ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100859915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$ModuleNumber", ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "x"}], "]"}], ",", "$ModuleNumber"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->559802953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"37", ",", "x$37", ",", "38"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156831312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297869164],

Cell["\<\
If there is no need to assign to a local variable, a constant should be used \
instead:\
\>", "ExampleText",
 CellID->726335353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "2.0"}], "}"}], ",", 
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], "+", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150496373],

Cell[BoxData["2.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->756720769]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " is faster than ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->262584003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", "=", "5"}], "}"}], ",", 
      RowBox[{"x", ";"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28825695],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.31199999999999994`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->448275794]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", "=", "5"}], "}"}], ",", 
      RowBox[{"x", ";"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", "^", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->261207485],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.09300000000000003`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->625593919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->269893],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " localizes values only; it does not create new symbols:"
}], "ExampleText",
 CellID->31192632],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "7"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "=", "5"}], "}"}], ",", 
    RowBox[{"Print", "[", "x", "]"}]}], "]"}], ";", "x"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->609008510],

Cell[BoxData["5"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->222174938],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116678760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->449870061],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " creates new variables in a way similar to ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->83875166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Unique", "[", "x", "]"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172321148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$949", ",", "x$950"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->564793309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->776603349],

Cell["\<\
Local variables are not affected by global ones, and vice versa:\
\>", "ExampleText",
 CellID->680725067],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "17"}], ";"}], "\n", 
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "x"}], "}"}], ",", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"x", "+", "1"}]}], ";", "x"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->396712470],

Cell[BoxData["18"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169095205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[2]:=",
 CellID->949120556],

Cell[BoxData["17"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77039327]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->253548225],

Cell[TextData[{
 "A symbol brought into the scope of ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " is not affected by naming conflicts:"
}], "ExampleText",
 CellID->251257241],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49126059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "5"}], "}"}], ",", 
   RowBox[{"x", "+", "y"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460960204],

Cell[BoxData[
 RowBox[{"5", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138839267]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18849],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " is a scoping construct; inner local variables shield outer ones:"
}], "ExampleText",
 CellID->280628775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "x", "]"}], ";", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"Print", "[", "x", "]"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160279358],

Cell[CellGroupData[{

Cell[BoxData["x$119"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->182000784],

Cell[BoxData["x$120"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->102750987]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2189026],

Cell["Variables are renamed in nested scopes:", "ExampleText",
 CellID->127077581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "^", "5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{"x", ",", "e"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34425433],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x$", ",", "e$100477"}], "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1018400]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "10", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300888483],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"5", " ", "x"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200361076]
}, Open  ]],

Cell["Build the function from its parts to avoid the renaming:", "ExampleText",
 CellID->257040373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"e", "=", 
     RowBox[{"Expand", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "x"}], ")"}], "^", "5"}], "]"}]}], "}"}], ",", 
   RowBox[{"Function", "@@", 
    RowBox[{"{", 
     RowBox[{"x", ",", "e"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->174526574],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"1", "+", 
    RowBox[{"5", " ", "x"}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"10", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    SuperscriptBox["x", "5"]}]}], "]"}]], "Output",
 ImageSize->{274, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->175001910]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "[", "10", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3968270],

Cell[BoxData["161051"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->9587867]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206667194],

Cell[TextData[{
 "Parallel assignment is not available for ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " variables:"
}], "ExampleText",
 CellID->262054502],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4685685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "=", "v"}], "}"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200267492],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "::", "\<\"lvset\"\>"}], ":", 
  " ", "\<\"Local variable specification \\!\\({\\(\\({x, y}\\)\\) = v}\\) \
contains \\!\\(\\(\\({x, y}\\)\\) = v\\), which is an assignment to \\!\\({x, \
y}\\); only assignments to symbols are allowed. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Module/lvset\\\", ButtonNote -> \
\\\"Module::lvset\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->409751406],

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "=", "v"}], "}"}], ",", 
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}]}], "]"}]], "Output",
 ImageSize->{183, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334384906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", 
      RowBox[{"v", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
     ",", 
     RowBox[{"y", "=", 
      RowBox[{"v", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}]}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259955082],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["a", "2"], "+", 
  SuperscriptBox["b", "2"]}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->504434818]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23201],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["With",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/With"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicModule",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicModule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19512],

Cell[TextData[ButtonBox["Functions as Procedures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FunctionsAsProcedures"]], "Tutorials",
 CellID->29482],

Cell[TextData[ButtonBox["Modules and Local Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ModulesAndLocalVariables"]], "Tutorials",
 CellID->2815],

Cell[TextData[ButtonBox["Variables in Pure Functions and Rules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VariablesInPureFunctionsAndRules"]], "Tutorials",\

 CellID->135909037],

Cell[TextData[ButtonBox["Blocks Compared with Modules",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BlocksComparedWithModules"]], "Tutorials",
 CellID->28548028],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Module",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Module"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->719795698],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->696813066],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->244552316],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->303378041],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->19396428],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->30995862],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->8251782],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->424952759]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Module - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 0.9336144}", "context" -> "System`", 
    "keywords" -> {
     "blocks", "lexical scoping", "procedure", "scoping", "section", 
      "static scoping", "symbols", "values", "local variables", 
      "local scoping"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Module[{x, y, ...}, expr] specifies that occurrences of the symbols x, \
y, ... in expr should be treated as local. Module[{x = x_0, ...}, expr] \
defines initial values for x, .... ", "synonyms" -> {}, "title" -> "Module", 
    "type" -> "Symbol", "uri" -> "ref/Module"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10246, 336, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80714432]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35974, 1367}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3780, 81, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4403, 108, 44, 1, 70, "ObjectName",
 CellID->25419],
Cell[4450, 111, 1592, 51, 70, "Usage",
 CellID->28735]
}, Open  ]],
Cell[CellGroupData[{
Cell[6079, 167, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6557, 184, 244, 8, 70, "Notes",
 CellID->16616],
Cell[6804, 194, 252, 8, 70, "Notes",
 CellID->20113],
Cell[7059, 204, 660, 24, 70, "Notes",
 CellID->13335],
Cell[7722, 230, 242, 8, 70, "Notes",
 CellID->28592],
Cell[7967, 240, 451, 15, 70, "Notes",
 CellID->29018],
Cell[8421, 257, 335, 13, 70, "Notes",
 CellID->9265],
Cell[8759, 272, 217, 8, 70, "Notes",
 CellID->9370],
Cell[8979, 282, 447, 16, 70, "Notes",
 CellID->22336],
Cell[9429, 300, 302, 12, 70, "Notes",
 CellID->26525],
Cell[9734, 314, 252, 8, 70, "Notes",
 CellID->12746],
Cell[9989, 324, 220, 7, 70, "Notes",
 CellID->17644]
}, Closed]],
Cell[CellGroupData[{
Cell[10246, 336, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80714432],
Cell[CellGroupData[{
Cell[10630, 350, 148, 5, 70, "ExampleSection",
 CellID->543220243],
Cell[10781, 357, 509, 15, 70, "Input",
 CellID->531020242],
Cell[CellGroupData[{
Cell[11315, 376, 99, 3, 28, "Input",
 CellID->617537663],
Cell[11417, 381, 193, 6, 36, "Output",
 CellID->19208448]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11659, 393, 222, 7, 70, "ExampleSection",
 CellID->5857],
Cell[11884, 402, 85, 1, 70, "ExampleText",
 CellID->213989856],
Cell[11972, 405, 789, 24, 70, "Input",
 CellID->3381480],
Cell[CellGroupData[{
Cell[12786, 433, 98, 3, 70, "Input",
 CellID->13953838],
Cell[12887, 438, 158, 5, 36, "Output",
 CellID->657801489]
}, Open  ]],
Cell[13060, 446, 125, 3, 70, "ExampleDelimiter",
 CellID->609441506],
Cell[13188, 451, 116, 3, 70, "ExampleText",
 CellID->260419147],
Cell[13307, 456, 756, 24, 70, "Input",
 CellID->614959507],
Cell[CellGroupData[{
Cell[14088, 484, 124, 4, 70, "Input",
 CellID->430217641],
Cell[14215, 490, 157, 5, 36, "Output",
 CellID->89607771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14421, 501, 232, 7, 70, "ExampleSection",
 CellID->2700],
Cell[14656, 510, 119, 3, 70, "ExampleText",
 CellID->202781666],
Cell[CellGroupData[{
Cell[14800, 517, 285, 10, 70, "Input",
 CellID->592443154],
Cell[15088, 529, 212, 7, 36, "Output",
 CellID->155373935]
}, Open  ]],
Cell[15315, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->286105926],
Cell[15443, 544, 130, 4, 70, "ExampleText",
 CellID->16188905],
Cell[CellGroupData[{
Cell[15598, 552, 246, 8, 70, "Input",
 CellID->409793869],
Cell[15847, 562, 94, 2, 70, "Print",
 CellID->53680255],
Cell[15944, 566, 188, 6, 36, "Output",
 CellID->162729894]
}, Open  ]],
Cell[CellGroupData[{
Cell[16169, 577, 110, 3, 70, "Input",
 CellID->34703542],
Cell[16282, 582, 175, 6, 36, "Output",
 CellID->459958815]
}, Open  ]],
Cell[16472, 591, 125, 3, 70, "ExampleDelimiter",
 CellID->249276108],
Cell[16600, 596, 337, 13, 70, "ExampleText",
 CellID->100859915],
Cell[CellGroupData[{
Cell[16962, 613, 237, 8, 70, "Input",
 CellID->559802953],
Cell[17202, 623, 218, 7, 36, "Output",
 CellID->156831312]
}, Open  ]],
Cell[17435, 633, 125, 3, 70, "ExampleDelimiter",
 CellID->297869164],
Cell[17563, 638, 138, 4, 70, "ExampleText",
 CellID->726335353],
Cell[CellGroupData[{
Cell[17726, 646, 231, 8, 70, "Input",
 CellID->150496373],
Cell[17960, 656, 175, 5, 36, "Output",
 CellID->756720769]
}, Open  ]],
Cell[18150, 664, 306, 12, 70, "ExampleText",
 CellID->262584003],
Cell[CellGroupData[{
Cell[18481, 680, 344, 12, 70, "Input",
 CellID->28825695],
Cell[18828, 694, 225, 7, 36, "Output",
 CellID->448275794]
}, Open  ]],
Cell[CellGroupData[{
Cell[19090, 706, 343, 12, 70, "Input",
 CellID->261207485],
Cell[19436, 720, 225, 7, 36, "Output",
 CellID->625593919]
}, Open  ]],
Cell[19676, 730, 122, 3, 70, "ExampleDelimiter",
 CellID->269893],
Cell[19801, 735, 225, 7, 70, "ExampleText",
 CellID->31192632],
Cell[CellGroupData[{
Cell[20051, 746, 286, 10, 70, "Input",
 CellID->609008510],
Cell[20340, 758, 91, 2, 70, "Print",
 CellID->222174938],
Cell[20434, 762, 158, 5, 36, "Output",
 CellID->116678760]
}, Open  ]],
Cell[20607, 770, 125, 3, 70, "ExampleDelimiter",
 CellID->449870061],
Cell[20735, 775, 336, 12, 70, "ExampleText",
 CellID->83875166],
Cell[CellGroupData[{
Cell[21096, 791, 234, 8, 70, "Input",
 CellID->172321148],
Cell[21333, 801, 212, 7, 36, "Output",
 CellID->564793309]
}, Open  ]],
Cell[21560, 811, 125, 3, 70, "ExampleDelimiter",
 CellID->776603349],
Cell[21688, 816, 115, 3, 70, "ExampleText",
 CellID->680725067],
Cell[CellGroupData[{
Cell[21828, 823, 303, 11, 70, "Input",
 CellID->396712470],
Cell[22134, 836, 159, 5, 36, "Output",
 CellID->169095205]
}, Open  ]],
Cell[CellGroupData[{
Cell[22330, 846, 70, 2, 70, "Input",
 CellID->949120556],
Cell[22403, 850, 158, 5, 36, "Output",
 CellID->77039327]
}, Open  ]],
Cell[22576, 858, 125, 3, 70, "ExampleDelimiter",
 CellID->253548225],
Cell[22704, 863, 250, 8, 70, "ExampleText",
 CellID->251257241],
Cell[22957, 873, 133, 5, 70, "Input",
 CellID->49126059],
Cell[CellGroupData[{
Cell[23115, 882, 198, 7, 70, "Input",
 CellID->460960204],
Cell[23316, 891, 204, 7, 36, "Output",
 CellID->138839267]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23569, 904, 226, 7, 70, "ExampleSection",
 CellID->18849],
Cell[23798, 913, 238, 7, 70, "ExampleText",
 CellID->280628775],
Cell[CellGroupData[{
Cell[24061, 924, 331, 11, 70, "Input",
 CellID->160279358],
Cell[CellGroupData[{
Cell[24417, 939, 95, 2, 70, "Print",
 CellID->182000784],
Cell[24515, 943, 95, 2, 70, "Print",
 CellID->102750987]
}, Open  ]]
}, Open  ]],
Cell[24637, 949, 123, 3, 70, "ExampleDelimiter",
 CellID->2189026],
Cell[24763, 954, 82, 1, 70, "ExampleText",
 CellID->127077581],
Cell[CellGroupData[{
Cell[24870, 959, 354, 12, 70, "Input",
 CellID->34425433],
Cell[25227, 973, 222, 7, 36, "Output",
 CellID->1018400]
}, Open  ]],
Cell[CellGroupData[{
Cell[25486, 985, 98, 3, 70, "Input",
 CellID->300888483],
Cell[25587, 990, 414, 14, 36, "Output",
 CellID->200361076]
}, Open  ]],
Cell[26016, 1007, 99, 1, 70, "ExampleText",
 CellID->257040373],
Cell[CellGroupData[{
Cell[26140, 1012, 377, 13, 70, "Input",
 CellID->174526574],
Cell[26520, 1027, 489, 16, 39, "Output",
 CellID->175001910]
}, Open  ]],
Cell[CellGroupData[{
Cell[27046, 1048, 96, 3, 70, "Input",
 CellID->3968270],
Cell[27145, 1053, 161, 5, 36, "Output",
 CellID->9587867]
}, Open  ]],
Cell[27321, 1061, 125, 3, 70, "ExampleDelimiter",
 CellID->206667194],
Cell[27449, 1066, 230, 8, 70, "ExampleText",
 CellID->262054502],
Cell[27682, 1076, 157, 6, 70, "Input",
 CellID->4685685],
Cell[CellGroupData[{
Cell[27864, 1086, 301, 11, 70, "Input",
 CellID->200267492],
Cell[28168, 1099, 516, 9, 70, "Message",
 CellID->409751406],
Cell[28687, 1110, 392, 14, 39, "Output",
 CellID->334384906]
}, Open  ]],
Cell[CellGroupData[{
Cell[29116, 1129, 453, 15, 70, "Input",
 CellID->259955082],
Cell[29572, 1146, 228, 8, 36, "Output",
 CellID->504434818]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29861, 1161, 311, 9, 70, "SeeAlsoSection",
 CellID->23201],
Cell[30175, 1172, 1198, 44, 70, "SeeAlso",
 CellID->773]
}, Open  ]],
Cell[CellGroupData[{
Cell[31410, 1221, 314, 9, 70, "TutorialsSection",
 CellID->19512],
Cell[31727, 1232, 155, 3, 70, "Tutorials",
 CellID->29482],
Cell[31885, 1237, 161, 3, 70, "Tutorials",
 CellID->2815],
Cell[32049, 1242, 186, 4, 70, "Tutorials",
 CellID->135909037],
Cell[32238, 1248, 167, 3, 70, "Tutorials",
 CellID->28548028],
Cell[32408, 1253, 159, 3, 70, "Tutorials",
 CellID->445434225]
}, Open  ]],
Cell[CellGroupData[{
Cell[32604, 1261, 305, 8, 70, "RelatedLinksSection"],
Cell[32912, 1271, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33306, 1288, 319, 9, 70, "MoreAboutSection",
 CellID->719795698],
Cell[33628, 1299, 132, 3, 70, "MoreAbout",
 CellID->696813066],
Cell[33763, 1304, 145, 3, 70, "MoreAbout",
 CellID->244552316],
Cell[33911, 1309, 151, 3, 70, "MoreAbout",
 CellID->303378041],
Cell[34065, 1314, 154, 3, 70, "MoreAbout",
 CellID->19396428],
Cell[34222, 1319, 148, 3, 70, "MoreAbout",
 CellID->30995862],
Cell[34373, 1324, 153, 3, 70, "MoreAbout",
 CellID->8251782],
Cell[34529, 1329, 147, 3, 70, "MoreAbout",
 CellID->424952759]
}, Open  ]],
Cell[34691, 1335, 27, 0, 70, "History"],
Cell[34721, 1337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

