(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40446,       1397]
NotebookOptionsPosition[     32800,       1129]
NotebookOutlinePosition[     34079,       1166]
CellTagsIndexPosition[     33993,       1161]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Divisors" :> Documentation`HelpLookup["paclet:ref/Divisors"], 
          "SquareFreeQ" :> Documentation`HelpLookup["paclet:ref/SquareFreeQ"],
           "FactorInteger" :> 
          Documentation`HelpLookup["paclet:ref/FactorInteger"], 
          "JacobiSymbol" :> 
          Documentation`HelpLookup["paclet:ref/JacobiSymbol"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Divisors\"\>", 
       2->"\<\"SquareFreeQ\"\>", 3->"\<\"FactorInteger\"\>", 
       4->"\<\"JacobiSymbol\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cryptographic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/CryptographicNumberTheory"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Cryptographic Number Theory\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Number Theoretic Functions\"\>", 
       4->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MoebiusMu", "ObjectName",
 CellID->13910],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MoebiusMu",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MoebiusMu"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the M\[ODoubleDot]bius function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Mu]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Mu]", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is a product of an even number of distinct primes, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " if it is a product of an odd number of primes, and ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " if it has a multiple prime factor. "
}], "Notes",
 CellID->19728],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28994299],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->248757541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", "51", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1422434891],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1336728329]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", "1729", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1127831516],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1566594236]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6125],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->1214943786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", 
  RowBox[{"{", 
   RowBox[{"2", ",", "4", ",", "7", ",", "9"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1285695626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1599812232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2114475257],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify ",
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1652232881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{"MoebiusMu", "[", "i", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "1", ",", "n"}], "}"}]}], "]"}], "]"}], "<", 
    RowBox[{"8", "+", 
     FractionBox["n", "9"]}]}], ",", 
   RowBox[{
    RowBox[{"n", "\[Element]", "Integers"}], "&&", 
    RowBox[{"n", "\[GreaterEqual]", "1"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1426253843],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1548922784]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->139],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " works for negative integers:"
}], "ExampleText",
 CellID->860695118],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"MoebiusMu", "[", 
    RowBox[{"-", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106515408],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{"-", "1"}], ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "1", ",", 
   RowBox[{"-", "1"}], ",", "0"}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->948461754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->417662308],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " works for Gaussian integers:"
}], "ExampleText",
 CellID->36409781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", 
  RowBox[{"3", "+", 
   RowBox[{"11", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133758942],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25587797]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"MoebiusMu", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"ColorRules", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "\[Rule]", "Red"}], ",", 
      RowBox[{"0", "\[Rule]", "White"}], ",", 
      RowBox[{"1", "\[Rule]", "Green"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->670881525],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7748358]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6340],

Cell[TextData[{
 "The ",
 ButtonBox["Mertens function",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/MertensFunction.html"], None}],
 ":"
}], "ExampleText",
 CellID->255413202],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "[", "n_", "]"}], ":=", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"MoebiusMu", "[", "k", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522329170],

Cell[TextData[{
 "Plot of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sqrt",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sqrt"], "[", 
    StyleBox["n", "TI"], "]"}], "-", 
   RowBox[{
    StyleBox["m", "TI"], "[", 
    StyleBox["n", "TI"], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1145971607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "n", "]"}], "-", 
     RowBox[{"Abs", "[", 
      RowBox[{"m", "[", "n", "]"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2020694901],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->909654151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1121244025],

Cell[TextData[{
 "Dirichlet generating function of ",
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2062855436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MoebiusMu", "[", "k", "]"}], "/", 
    RowBox[{"k", "^", "s"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->579325750],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"Zeta", "[", "s", "]"}]]], "Output",
 ImageSize->{58, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1280858256]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3640],

Cell[TextData[{
 "The number ",
 Cell[BoxData["183245"], "InlineFormula"],
 " is square-free and factors into an odd number of distinct primes:"
}], "ExampleText",
 CellID->630959665],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "183245", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1375587311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"67", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"547", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1008631064]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", "183245", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->615781775],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1973866877]
}, Open  ]],

Cell[TextData[{
 "Here ",
 Cell[BoxData["210"], "InlineFormula"],
 " is square-free and factors into an even number of distinct primes:"
}], "ExampleText",
 CellID->248060065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "210", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->879753628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->453222883]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", "210", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->725948010],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->192498672]
}, Open  ]],

Cell[TextData[{
 "The number ",
 Cell[BoxData["192"], "InlineFormula"],
 " is not square-free:"
}], "ExampleText",
 CellID->1164651525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorInteger", "[", "192", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2132221917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->1214807922]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoebiusMu", "[", "192", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1702013495],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->1149713025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->774287566],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " is multiplicative for coprime elements:"
}], "ExampleText",
 CellID->1847704589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoprimeQ", "@@", 
  RowBox[{"{", 
   RowBox[{"11", ",", "23", ",", "34", ",", "75"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->350709735],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168955469]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Times", "@@", 
   RowBox[{"MoebiusMu", "[", 
    RowBox[{"{", 
     RowBox[{"11", ",", "23", ",", "34", ",", "75"}], "}"}], "]"}]}], 
  "\[Equal]", 
  RowBox[{"MoebiusMu", "[", 
   RowBox[{"Times", "@@", 
    RowBox[{"{", 
     RowBox[{"11", ",", "23", ",", "34", ",", "75"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->712350834],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->661186149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1007270604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EulerPhi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EulerPhi"]], "InlineFormula"],
 " can be expressed in terms of ",
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->583452127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"EulerPhi", "[", "n", "]"}], "\[Equal]", 
    RowBox[{"n", " ", 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"MoebiusMu", "[", "d", "]"}], "/", "d"}], ",", 
       RowBox[{"{", 
        RowBox[{"d", ",", 
         RowBox[{"Divisors", "[", "n", "]"}]}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->669566287],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1475216665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40604768],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MoebiusMu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MoebiusMu"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["DivisorSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivisorSigma"]], "InlineFormula"],
 " through the M\[ODoubleDot]bius inversion formulas:"
}], "ExampleText",
 CellID->790242783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"n", "\[Equal]", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"MoebiusMu", "[", "d", "]"}], 
       RowBox[{"DivisorSigma", "[", 
        RowBox[{"1", ",", 
         RowBox[{"n", "/", "d"}]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", 
        RowBox[{"Divisors", "[", "n", "]"}]}], "}"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->830252044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1267784040]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29348],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SquareFreeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SquareFreeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorInteger"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JacobiSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/JacobiSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1278]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30522],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->11149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->27277],

Cell[TextData[{
 ButtonBox["Demonstrations with MoebiusMu",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=MoebiusMu"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MoebiusFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/NumberTheoryFunctions/MoebiusMu/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
MoebiusMu"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->478757612],

Cell[TextData[ButtonBox["Cryptographic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CryptographicNumberTheory"]], "MoreAbout",
 CellID->223953227],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->12990202],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->74969627],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->237130052]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MoebiusMu - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 1.6680082}", "context" -> "System`", 
    "keywords" -> {
     "mobius", "Mobius function", "moebius", "Moebius function", "Moebius mu",
       "mu"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "MoebiusMu[n] gives the Mo\"bius function \\[Mu](n). ", 
    "synonyms" -> {"moebius mu"}, "title" -> "MoebiusMu", "type" -> "Symbol", 
    "uri" -> "ref/MoebiusMu"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5393, 171, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->28994299]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33851, 1154}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2640, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3263, 88, 47, 1, 70, "ObjectName",
 CellID->13910],
Cell[3313, 91, 602, 19, 70, "Usage",
 CellID->18361]
}, Open  ]],
Cell[CellGroupData[{
Cell[3952, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4430, 132, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4565, 138, 581, 19, 70, "Notes",
 CellID->19728],
Cell[5149, 159, 207, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[5393, 171, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28994299],
Cell[CellGroupData[{
Cell[5777, 185, 148, 5, 70, "ExampleSection",
 CellID->248757541],
Cell[CellGroupData[{
Cell[5950, 194, 107, 3, 28, "Input",
 CellID->1422434891],
Cell[6060, 199, 159, 5, 36, "Output",
 CellID->1336728329]
}, Open  ]],
Cell[CellGroupData[{
Cell[6256, 209, 109, 3, 28, "Input",
 CellID->1127831516],
Cell[6368, 214, 176, 6, 36, "Output",
 CellID->1566594236]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6593, 226, 215, 7, 70, "ExampleSection",
 CellID->6125],
Cell[6811, 235, 214, 7, 70, "ExampleText",
 CellID->1214943786],
Cell[CellGroupData[{
Cell[7050, 246, 173, 5, 70, "Input",
 CellID->1285695626],
Cell[7226, 253, 262, 9, 36, "Output",
 CellID->1599812232]
}, Open  ]],
Cell[7503, 265, 126, 3, 70, "ExampleDelimiter",
 CellID->2114475257],
Cell[7632, 270, 335, 13, 70, "ExampleText",
 CellID->1652232881],
Cell[CellGroupData[{
Cell[7992, 287, 510, 16, 70, "Input",
 CellID->1426253843],
Cell[8505, 305, 162, 5, 36, "Output",
 CellID->1548922784]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8716, 316, 237, 7, 70, "ExampleSection",
 CellID->139],
Cell[8956, 325, 208, 7, 70, "ExampleText",
 CellID->860695118],
Cell[CellGroupData[{
Cell[9189, 336, 231, 8, 70, "Input",
 CellID->106515408],
Cell[9423, 346, 399, 12, 36, "Output",
 CellID->948461754]
}, Open  ]],
Cell[9837, 361, 125, 3, 70, "ExampleDelimiter",
 CellID->417662308],
Cell[9965, 366, 207, 7, 70, "ExampleText",
 CellID->36409781],
Cell[CellGroupData[{
Cell[10197, 377, 148, 5, 70, "Input",
 CellID->133758942],
Cell[10348, 384, 174, 6, 36, "Output",
 CellID->25587797]
}, Open  ]],
Cell[CellGroupData[{
Cell[10559, 395, 645, 20, 70, "Input",
 CellID->670881525],
Cell[11207, 417, 2520, 45, 70, "Output",
 Evaluatable->False,
 CellID->7748358]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13776, 468, 222, 7, 70, "ExampleSection",
 CellID->6340],
Cell[14001, 477, 211, 8, 70, "ExampleText",
 CellID->255413202],
Cell[14215, 487, 275, 9, 70, "Input",
 CellID->522329170],
Cell[14493, 498, 334, 14, 70, "ExampleText",
 CellID->1145971607],
Cell[CellGroupData[{
Cell[14852, 516, 343, 11, 70, "Input",
 CellID->2020694901],
Cell[15198, 529, 4987, 86, 70, "Output",
 Evaluatable->False,
 CellID->909654151]
}, Open  ]],
Cell[20200, 618, 126, 3, 70, "ExampleDelimiter",
 CellID->1121244025],
Cell[20329, 623, 219, 8, 70, "ExampleText",
 CellID->2062855436],
Cell[CellGroupData[{
Cell[20573, 635, 275, 9, 70, "Input",
 CellID->579325750],
Cell[20851, 646, 210, 7, 53, "Output",
 CellID->1280858256]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21110, 659, 232, 7, 70, "ExampleSection",
 CellID->3640],
Cell[21345, 668, 183, 5, 70, "ExampleText",
 CellID->630959665],
Cell[CellGroupData[{
Cell[21553, 677, 115, 3, 70, "Input",
 CellID->1375587311],
Cell[21671, 682, 365, 13, 36, "Output",
 CellID->1008631064]
}, Open  ]],
Cell[CellGroupData[{
Cell[22073, 700, 110, 3, 70, "Input",
 CellID->615781775],
Cell[22186, 705, 176, 6, 36, "Output",
 CellID->1973866877]
}, Open  ]],
Cell[22377, 714, 175, 5, 70, "ExampleText",
 CellID->248060065],
Cell[CellGroupData[{
Cell[22577, 723, 111, 3, 70, "Input",
 CellID->879753628],
Cell[22691, 728, 420, 15, 36, "Output",
 CellID->453222883]
}, Open  ]],
Cell[CellGroupData[{
Cell[23148, 748, 107, 3, 70, "Input",
 CellID->725948010],
Cell[23258, 753, 158, 5, 36, "Output",
 CellID->192498672]
}, Open  ]],
Cell[23431, 761, 135, 5, 70, "ExampleText",
 CellID->1164651525],
Cell[CellGroupData[{
Cell[23591, 770, 112, 3, 70, "Input",
 CellID->2132221917],
Cell[23706, 775, 303, 11, 36, "Output",
 CellID->1214807922]
}, Open  ]],
Cell[CellGroupData[{
Cell[24046, 791, 108, 3, 70, "Input",
 CellID->1702013495],
Cell[24157, 796, 159, 5, 36, "Output",
 CellID->1149713025]
}, Open  ]],
Cell[24331, 804, 125, 3, 70, "ExampleDelimiter",
 CellID->774287566],
Cell[24459, 809, 220, 7, 70, "ExampleText",
 CellID->1847704589],
Cell[CellGroupData[{
Cell[24704, 820, 171, 5, 70, "Input",
 CellID->350709735],
Cell[24878, 827, 161, 5, 36, "Output",
 CellID->168955469]
}, Open  ]],
Cell[CellGroupData[{
Cell[25076, 837, 386, 13, 70, "Input",
 CellID->712350834],
Cell[25465, 852, 161, 5, 36, "Output",
 CellID->661186149]
}, Open  ]],
Cell[25641, 860, 126, 3, 70, "ExampleDelimiter",
 CellID->1007270604],
Cell[25770, 865, 334, 12, 70, "ExampleText",
 CellID->583452127],
Cell[CellGroupData[{
Cell[26129, 881, 496, 16, 70, "Input",
 CellID->669566287],
Cell[26628, 899, 322, 9, 36, "Output",
 CellID->1475216665]
}, Open  ]],
Cell[26965, 911, 124, 3, 70, "ExampleDelimiter",
 CellID->40604768],
Cell[27092, 916, 377, 12, 70, "ExampleText",
 CellID->790242783],
Cell[CellGroupData[{
Cell[27494, 932, 525, 17, 70, "Input",
 CellID->830252044],
Cell[28022, 951, 322, 9, 36, "Output",
 CellID->1267784040]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28405, 967, 311, 9, 70, "SeeAlsoSection",
 CellID->29348],
Cell[28719, 978, 964, 35, 70, "SeeAlso",
 CellID->1278]
}, Open  ]],
Cell[CellGroupData[{
Cell[29720, 1018, 314, 9, 70, "TutorialsSection",
 CellID->30522],
Cell[30037, 1029, 198, 4, 70, "Tutorials",
 CellID->11149]
}, Open  ]],
Cell[CellGroupData[{
Cell[30272, 1038, 321, 9, 70, "RelatedLinksSection",
 CellID->27277],
Cell[30596, 1049, 363, 12, 70, "RelatedLinks"],
Cell[30962, 1063, 186, 4, 70, "RelatedLinks"],
Cell[31151, 1069, 203, 4, 70, "RelatedLinks"],
Cell[31357, 1075, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31781, 1093, 319, 9, 70, "MoreAboutSection",
 CellID->478757612],
Cell[32103, 1104, 164, 3, 70, "MoreAbout",
 CellID->223953227],
Cell[32270, 1109, 154, 3, 70, "MoreAbout",
 CellID->12990202],
Cell[32427, 1114, 161, 3, 70, "MoreAbout",
 CellID->74969627],
Cell[32591, 1119, 137, 3, 70, "MoreAbout",
 CellID->237130052]
}, Open  ]],
Cell[32743, 1125, 27, 0, 70, "History"],
Cell[32773, 1127, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

