(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35475,       1232]
NotebookOptionsPosition[     30212,       1057]
NotebookOutlinePosition[     31621,       1096]
CellTagsIndexPosition[     31535,       1091]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic" :> Documentation`HelpLookup["paclet:ref/Dynamic"], 
          "PrintTemporary" :> 
          Documentation`HelpLookup["paclet:ref/PrintTemporary"], 
          "ProgressIndicator" :> 
          Documentation`HelpLookup["paclet:ref/ProgressIndicator"], 
          "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], 
          "StepMonitor" :> Documentation`HelpLookup["paclet:ref/StepMonitor"],
           "Print" :> Documentation`HelpLookup["paclet:ref/Print"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"], "Trace" :> 
          Documentation`HelpLookup["paclet:ref/Trace"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Dynamic\"\>", 2->"\<\"PrintTemporary\"\>", 
       3->"\<\"ProgressIndicator\"\>", 4->"\<\"EvaluationMonitor\"\>", 
       5->"\<\"StepMonitor\"\>", 6->"\<\"Print\"\>", 7->"\<\"Sow\"\>", 
       8->"\<\"Trace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Tuning & Debugging\"\>", 
       2->"\<\"Viewers and Annotation\"\>", 
       3->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Monitor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Monitor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Monitor"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["mon", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a temporary monitor cell in which the \
continually updated current value of ",
     Cell[BoxData[
      StyleBox["mon", "TI"]], "InlineFormula"],
     " is displayed during the course of evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Table",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Table"], "[", 
     RowBox[{
      StyleBox["e", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " generates a monitor cell that shows the continually updated current value \
of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " during the evaluation of the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9466],

Cell[TextData[{
 "In a notebook, the monitor cell normally appears directly after the cell in \
which ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["mon", "TI"]}], "]"}]], "InlineFormula"],
 " is evaluated. The cell is deleted as soon as the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is complete. "
}], "Notes",
 CellID->21474],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PrintTemporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrintTemporary"]], "InlineFormula"],
 " or similar output is generated before the evaluation of ",
 Cell[BoxData[
  ButtonBox["Monitor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Monitor"]], "InlineFormula"],
 " begins, it will appear before the monitor cell. "
}], "Notes",
 CellID->3445],

Cell[TextData[{
 "Any expression, including graphics and controls, can be given for ",
 Cell[BoxData[
  StyleBox["mon", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11788]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10950355],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->105896205],

Cell[TextData[{
 "Monitor the value of ",
 Cell[BoxData["n"], "InlineFormula"],
 " while the computation is running:"
}], "ExampleText",
 CellID->89055079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"FactorInteger", "[", 
       RowBox[{
        RowBox[{"2", "^", "n"}], "-", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50", ",", "300", ",", "50"}], "}"}]}], "]"}], ",", 
   "n"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->108898803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "12", ",", "13", ",", "18", ",", "11", ",", "25"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->831119649]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58405798],

Cell["\<\
Display a progress indicator while the computation is running:\
\>", "ExampleText",
 CellID->239188919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Length", "[", 
      RowBox[{"FactorInteger", "[", 
       RowBox[{
        RowBox[{"2", "^", "n"}], "-", "1"}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50", ",", "300", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"ProgressIndicator", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "300"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->459790111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "12", ",", "13", ",", "18", ",", "11", ",", "25"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270956262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145833247],

Cell[TextData[{
 "Monitor a fast process by using ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " to slow down : "
}], "ExampleText",
 CellID->28680713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"i", "=", "0"}], ";", 
    RowBox[{"While", "[", 
     RowBox[{
      RowBox[{"i", "<", "100"}], ",", 
      RowBox[{
       RowBox[{"Pause", "[", "0.1", "]"}], ";", 
       RowBox[{"i", "++"}]}]}], "]"}], ";", "i"}], ",", "i"}], "]"}]], "Input",\

 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->90012738],

Cell[BoxData["100"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360635981]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12312],

Cell[TextData[{
 "Monitor ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ", with steps along the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis and evaluation points on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis: "
}], "ExampleText",
 CellID->49538128],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"values", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"1", "-", "x"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Pause", "[", "0.025", "]"}], ";", 
        RowBox[{"AppendTo", "[", 
         RowBox[{"values", ",", "x"}], "]"}], ";"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", "values", "]"}]}], "]"}]}], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->177850912],

Cell[BoxData["0.3926990816987338`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72536807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107035679],

Cell[TextData[{
 "Monitor ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " using an extrapolation method:"
}], "ExampleText",
 CellID->70476062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"values1", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"values2", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Monitor", "[", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
          RowBox[{"Sin", "[", 
           RowBox[{"x", "[", "t", "]"}], "]"}]}], "\[Equal]", "0"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], 
      ",", "x", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"values1", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{"x", "[", "t", "]"}]}], "}"}]}], "]"}], ";", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"values2", ",", 
           RowBox[{"{", 
            RowBox[{"t", ",", 
             RowBox[{
              RowBox[{"x", "'"}], "[", "t", "]"}]}], "}"}]}], "]"}], ";", 
         RowBox[{"Pause", "[", "0.05", "]"}], ";"}], ")"}]}], ",", " ", 
      RowBox[{"Method", "\[Rule]", "\"\<Extrapolation\>\""}]}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"{", 
      RowBox[{"values1", ",", "values2"}], "}"}], "]"}]}], "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->247644231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "6.283185307179586`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{344, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->606957400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->621219093],

Cell[TextData[{
 "Monitor ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " solving the sine-Gordon PDE:"
}], "ExampleText",
 CellID->129132036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         SubscriptBox["\[PartialD]", 
          RowBox[{"t", ",", "t"}]], 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], "\[Equal]", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[PartialD]", 
           RowBox[{"x", ",", "x"}]], 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}]}], "+", 
         RowBox[{"Sin", "[", 
          RowBox[{"u", "[", 
           RowBox[{"t", ",", "x"}], "]"}], "]"}]}]}], " ", ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"-", 
          SuperscriptBox["x", "2"]}]]}], ",", 
       RowBox[{
        RowBox[{
         SuperscriptBox["u", 
          TagBox[
           RowBox[{"(", 
            RowBox[{"1", ",", "0"}], ")"}],
           Derivative],
          MultilineFunction->None], "[", 
         RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"u", "[", 
         RowBox[{"t", ",", 
          RowBox[{"-", "10"}]}], "]"}], "\[Equal]", 
        RowBox[{"u", "[", 
         RowBox[{"t", ",", "10"}], "]"}]}]}], "}"}], ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sol", "=", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "x"}], "]"}]}], ";", " ", 
        RowBox[{"time", "=", "t"}]}], ")"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{"sol", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}]}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "time"}]}], "]"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->317869808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"u", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "10.`"}], ",", "10.`"}], "}"}]}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{402, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18050914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->321468613],

Cell["Steps in parameter space for a nonlinear fit:", "ExampleText",
 CellID->735994752],

Cell[BoxData[{
 RowBox[{
  RowBox[{"data", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.18", ",", 
       RowBox[{"-", "0.13"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.84", ",", 
       RowBox[{"-", "0.06"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.24", ",", 
       RowBox[{"-", "0.63"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.67", ",", "0.93"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.05", ",", "0.88"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.65", ",", "0.92"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.99"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.17", ",", 
       RowBox[{"-", "0.04"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.23", ",", 
       RowBox[{"-", "0.55"}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lp", " ", "=", " ", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]}], ";"}]}], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->37843928],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"model", "[", 
    RowBox[{"{", 
     RowBox[{"a_", ",", " ", "k_", ",", " ", "w_", ",", " ", "p_"}], "}"}], 
    "]"}], " ", "=", " ", 
   RowBox[{"a", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "k"}], " ", "x"}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"w", " ", "x"}], " ", "+", "p"}], "]"}]}]}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->67367124],

Cell["\<\
Monitor the evolution of the model over the steps with a graph:\
\>", "ExampleText",
 CellID->205567056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", " ", 
     RowBox[{"model", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "k", ",", "w", ",", "p"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "k", ",", "w", ",", "p"}], "}"}], ",", "x", ",", " ", 
     
     RowBox[{"StepMonitor", "\[RuleDelayed]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"vars", "=", 
         RowBox[{"{", 
          RowBox[{"a", ",", "k", ",", "w", ",", "p"}], "}"}]}], ";", 
        RowBox[{"Pause", "[", "0.3", "]"}], ";"}], ")"}]}]}], "]"}], ",", 
   RowBox[{"Show", "[", 
    RowBox[{"lp", ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"model", "[", "vars", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->262267683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "0.9972788935407545`"}], ",", 
   RowBox[{"k", "\[Rule]", "0.10440754896764803`"}], ",", 
   RowBox[{"w", "\[Rule]", 
    RowBox[{"-", "9.416425570747133`"}]}], ",", 
   RowBox[{"p", "\[Rule]", "1.5609257497834457`"}]}], "}"}]], "Output",
 ImageSize->{362, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->454996825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173283042],

Cell[TextData[{
 "Implement a simple LU decomposition with a slowdown parameter ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->238179222],

Cell[BoxData[
 RowBox[{
  RowBox[{"LU", "[", 
   RowBox[{"A_", ",", 
    RowBox[{"p_:", "0"}]}], "]"}], ":=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"m", ",", "n", ",", "L", ",", "U"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"m", ",", "n"}], "}"}], "=", 
      RowBox[{"Dimensions", "[", "A", "]"}]}], ";", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"L", ",", "U"}], "}"}], "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"IdentityMatrix", "[", "n", "]"}], ",", "A"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Pause", "[", "p", "]"}], ";", 
        RowBox[{
         RowBox[{"L", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{"k", ";;", "n"}], ",", "k"}], "]"}], "]"}], "=", " ", 
         RowBox[{
          RowBox[{"U", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{"k", ";;", "n"}], ",", "k"}], "]"}], "]"}], "/", 
          RowBox[{"U", "[", 
           RowBox[{"[", 
            RowBox[{"k", ",", "k"}], "]"}], "]"}]}]}], ";", 
        RowBox[{
         RowBox[{"U", "[", 
          RowBox[{"[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"k", "+", "1"}], ")"}], ";;", "n"}], ",", 
            RowBox[{"k", ";;", "n"}]}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"U", "[", 
           RowBox[{"[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"k", "+", "1"}], ")"}], ";;", "n"}], ",", 
             RowBox[{"k", ";;", "n"}]}], "]"}], "]"}], "-", 
          RowBox[{
           RowBox[{"L", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"k", "+", "1"}], ")"}], ";;", "n"}], ",", 
              RowBox[{"{", "k", "}"}]}], "]"}], "]"}], ".", 
           RowBox[{"U", "[", 
            RowBox[{"[", 
             RowBox[{
              RowBox[{"{", "k", "}"}], ",", 
              RowBox[{"k", ";;", "n"}]}], "]"}], "]"}]}]}]}], ";"}], 
       "\[IndentingNewLine]", ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "1", ",", 
         RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{"L", ",", "U"}], "}"}]}]}], "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->446643489],

Cell[TextData[{
 "Monitor an algorithm animation using ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->291328065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"LU", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "5", ",", "7"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"6", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "1"}], "]"}], 
   ",", 
   RowBox[{"MatrixForm", "/@", 
    RowBox[{"{", 
     RowBox[{"L", ",", "U"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->218644546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", 
       FractionBox["4", "3"], ",", "1"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["7", "3"]}]}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{478, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350449958]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"LU", "[", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "10"}], "}"}]}], "]"}], ",", ".3"}], "]"}], ";"}],
    ",", 
   RowBox[{"MatrixPlot", "/@", 
    RowBox[{"{", 
     RowBox[{"L", ",", "U"}], "}"}]}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->157417187]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3281],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrintTemporary",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrintTemporary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ProgressIndicator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ProgressIndicator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StepMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StepMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14246]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->258498129],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->52661792],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->417742243],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->575153937]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Monitor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 2.1992718}", "context" -> "System`", 
    "keywords" -> {
     "monitoring a computation", "automatically instrument computations", 
      "algorithm animation", "algorithm progress"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Monitor[expr, mon] generates a temporary monitor cell in which the \
continually updated current value of mon is displayed during the course of \
evaluation of expr. ", "synonyms" -> {}, "title" -> "Monitor", "type" -> 
    "Symbol", "uri" -> "ref/Monitor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7802, 239, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->10950355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31393, 1084}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2230, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2853, 74, 1572, 37, 70, "ObjectNameGrid"],
Cell[4428, 113, 790, 24, 70, "Usage",
 CellID->30943]
}, Open  ]],
Cell[CellGroupData[{
Cell[5255, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5733, 159, 810, 29, 70, "Notes",
 CellID->9466],
Cell[6546, 190, 499, 16, 70, "Notes",
 CellID->21474],
Cell[7048, 208, 534, 18, 70, "Notes",
 CellID->3445],
Cell[7585, 228, 180, 6, 70, "Notes",
 CellID->11788]
}, Closed]],
Cell[CellGroupData[{
Cell[7802, 239, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10950355],
Cell[CellGroupData[{
Cell[8186, 253, 148, 5, 70, "ExampleSection",
 CellID->105896205],
Cell[8337, 260, 155, 5, 70, "ExampleText",
 CellID->89055079],
Cell[CellGroupData[{
Cell[8517, 269, 427, 14, 28, "Input",
 CellID->108898803],
Cell[8947, 285, 252, 8, 36, "Output",
 CellID->831119649]
}, Open  ]],
Cell[9214, 296, 124, 3, 70, "ExampleDelimiter",
 CellID->58405798],
Cell[9341, 301, 113, 3, 70, "ExampleText",
 CellID->239188919],
Cell[CellGroupData[{
Cell[9479, 308, 549, 17, 70, "Input",
 CellID->459790111],
Cell[10031, 327, 252, 8, 36, "Output",
 CellID->270956262]
}, Open  ]],
Cell[10298, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->145833247],
Cell[10426, 343, 223, 8, 70, "ExampleText",
 CellID->28680713],
Cell[CellGroupData[{
Cell[10674, 355, 390, 14, 70, "Input",
 CellID->90012738],
Cell[11067, 371, 160, 5, 36, "Output",
 CellID->360635981]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11276, 382, 223, 7, 70, "ExampleSection",
 CellID->12312],
Cell[11502, 391, 396, 14, 70, "ExampleText",
 CellID->49538128],
Cell[CellGroupData[{
Cell[11923, 409, 768, 23, 70, "Input",
 CellID->177850912],
Cell[12694, 434, 175, 5, 36, "Output",
 CellID->72536807]
}, Open  ]],
Cell[12884, 442, 125, 3, 70, "ExampleDelimiter",
 CellID->107035679],
Cell[13012, 447, 218, 8, 70, "ExampleText",
 CellID->70476062],
Cell[CellGroupData[{
Cell[13255, 459, 1670, 49, 70, "Input",
 CellID->247644231],
Cell[14928, 510, 482, 17, 36, "Output",
 CellID->606957400]
}, Open  ]],
Cell[15425, 530, 125, 3, 70, "ExampleDelimiter",
 CellID->621219093],
Cell[15553, 535, 217, 8, 70, "ExampleText",
 CellID->129132036],
Cell[CellGroupData[{
Cell[15795, 547, 2171, 66, 70, "Input",
 CellID->317869808],
Cell[17969, 615, 592, 21, 36, "Output",
 CellID->18050914]
}, Open  ]],
Cell[18576, 639, 125, 3, 70, "ExampleDelimiter",
 CellID->321468613],
Cell[18704, 644, 88, 1, 70, "ExampleText",
 CellID->735994752],
Cell[18795, 647, 1176, 38, 70, "Input",
 CellID->37843928],
Cell[19974, 687, 476, 16, 70, "Input",
 CellID->67367124],
Cell[20453, 705, 114, 3, 70, "ExampleText",
 CellID->205567056],
Cell[CellGroupData[{
Cell[20592, 712, 934, 28, 70, "Input",
 CellID->262267683],
Cell[21529, 742, 436, 12, 36, "Output",
 CellID->454996825]
}, Open  ]],
Cell[21980, 757, 125, 3, 70, "ExampleDelimiter",
 CellID->173283042],
Cell[22108, 762, 190, 6, 70, "ExampleText",
 CellID->238179222],
Cell[22301, 770, 2473, 76, 70, "Input",
 CellID->446643489],
Cell[24777, 848, 357, 13, 70, "ExampleText",
 CellID->291328065],
Cell[CellGroupData[{
Cell[25159, 865, 559, 19, 70, "Input",
 CellID->218644546],
Cell[25721, 886, 822, 28, 51, "Output",
 CellID->350449958]
}, Open  ]],
Cell[26558, 917, 447, 16, 70, "Input",
 CellID->157417187]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27054, 939, 310, 9, 70, "SeeAlsoSection",
 CellID->3281],
Cell[27367, 950, 1951, 71, 70, "SeeAlso",
 CellID->14246]
}, Open  ]],
Cell[CellGroupData[{
Cell[29355, 1026, 319, 9, 70, "MoreAboutSection",
 CellID->258498129],
Cell[29677, 1037, 147, 3, 70, "MoreAbout",
 CellID->52661792],
Cell[29827, 1042, 154, 3, 70, "MoreAbout",
 CellID->417742243],
Cell[29984, 1047, 156, 3, 70, "MoreAbout",
 CellID->575153937]
}, Open  ]],
Cell[30155, 1053, 27, 0, 70, "History"],
Cell[30185, 1055, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

