(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19946,        784]
NotebookOptionsPosition[     15269,        614]
NotebookOutlinePosition[     16474,        649]
CellTagsIndexPosition[     16389,        644]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Pieces of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingPiecesOfLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Getting Pieces of Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rest" :> Documentation`HelpLookup["paclet:ref/Rest"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "Last" :> 
          Documentation`HelpLookup["paclet:ref/Last"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Rest\"\>", 2->"\<\"Drop\"\>", 3->"\<\"Last\"\>", 
       4->"\<\"Part\"\>", 5->"\<\"Take\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Most", "ObjectName",
 CellID->23355],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Most",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Most"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " with the last element removed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Most",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Most"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"-", "1"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28251]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47259927],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->163172323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13991],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13739]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12567],

Cell[TextData[{
 "The head need not be ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"a", "+", "b", "+", "c", "+", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29877],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31197],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10773],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Most",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Most"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->30589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"Range", "[", "100", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26862],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "99", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 99, ">"],
     Editable->False], ",", 
    RowBox[{"{", "99", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27536]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12888],

Cell["Nest the operation of finding most of a list:", "ExampleText",
 CellID->10539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Most", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21841]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4167],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Most",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Most"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"-", "1"}]}], "]"}]], "InlineFormula"],
 ". "
}], "ExampleText",
 CellID->5520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11560],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30382]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19606],

Cell[TextData[{
 "The expression is evaluated before ",
 Cell[BoxData[
  ButtonBox["Most",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Most"]], "InlineFormula"],
 " is applied:"
}], "ExampleText",
 CellID->11989],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"c", "+", "a", "+", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26784],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21960],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Most",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Most"]], "InlineFormula"],
 " always operates on the ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of expressions:"
}], "ExampleText",
 CellID->21462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Most", "[", 
  RowBox[{"1", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8732],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20392]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"1", "/", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26843],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"b", ",", 
     RowBox[{"-", "1"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->14063]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31173],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Last",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Last"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13454]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5081],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->32271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->132328729],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->23421545],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->132153202]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Most - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 2.7774116}", "context" -> "System`", 
    "keywords" -> {"all but last", "drop last", "truncate list"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Most[expr] gives expr with the last element removed. ", "synonyms" -> {},
     "title" -> "Most", "type" -> "Symbol", "uri" -> "ref/Most"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4425, 145, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->47259927]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16247, 637}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2205, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2828, 79, 42, 1, 70, "ObjectName",
 CellID->23355],
Cell[2873, 82, 552, 18, 70, "Usage",
 CellID->15948]
}, Open  ]],
Cell[CellGroupData[{
Cell[3462, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3940, 122, 448, 18, 70, "Notes",
 CellID->28251]
}, Closed]],
Cell[CellGroupData[{
Cell[4425, 145, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->47259927],
Cell[CellGroupData[{
Cell[4809, 159, 148, 5, 70, "ExampleSection",
 CellID->163172323],
Cell[CellGroupData[{
Cell[4982, 168, 163, 5, 28, "Input",
 CellID->13991],
Cell[5148, 175, 209, 7, 36, "Output",
 CellID->13739]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5406, 188, 239, 7, 70, "ExampleSection",
 CellID->12567],
Cell[5648, 197, 192, 8, 70, "ExampleText",
 CellID->17054],
Cell[CellGroupData[{
Cell[5865, 209, 139, 4, 70, "Input",
 CellID->29877],
Cell[6007, 215, 186, 6, 36, "Output",
 CellID->22490]
}, Open  ]],
Cell[CellGroupData[{
Cell[6230, 226, 168, 5, 70, "Input",
 CellID->31197],
Cell[6401, 233, 214, 7, 36, "Output",
 CellID->19056]
}, Open  ]],
Cell[6630, 243, 121, 3, 70, "ExampleDelimiter",
 CellID->10773],
Cell[6754, 248, 314, 12, 70, "ExampleText",
 CellID->30589],
Cell[CellGroupData[{
Cell[7093, 264, 169, 5, 70, "Input",
 CellID->26862],
Cell[7265, 271, 452, 16, 36, "Output",
 CellID->27536]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7766, 293, 223, 7, 70, "ExampleSection",
 CellID->12888],
Cell[7992, 302, 84, 1, 70, "ExampleText",
 CellID->10539],
Cell[CellGroupData[{
Cell[8101, 307, 218, 7, 70, "Input",
 CellID->17585],
Cell[8322, 316, 476, 15, 36, "Output",
 CellID->21841]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8847, 337, 232, 7, 70, "ExampleSection",
 CellID->4167],
Cell[9082, 346, 453, 18, 70, "ExampleText",
 CellID->5520],
Cell[CellGroupData[{
Cell[9560, 368, 163, 5, 70, "Input",
 CellID->11560],
Cell[9726, 375, 209, 7, 36, "Output",
 CellID->21047]
}, Open  ]],
Cell[CellGroupData[{
Cell[9972, 387, 207, 7, 70, "Input",
 CellID->14581],
Cell[10182, 396, 209, 7, 36, "Output",
 CellID->30382]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10440, 409, 226, 7, 70, "ExampleSection",
 CellID->19606],
Cell[10669, 418, 217, 8, 70, "ExampleText",
 CellID->11989],
Cell[CellGroupData[{
Cell[10911, 430, 129, 4, 70, "Input",
 CellID->26784],
Cell[11043, 436, 176, 6, 36, "Output",
 CellID->13403]
}, Open  ]],
Cell[11234, 445, 121, 3, 70, "ExampleDelimiter",
 CellID->21960],
Cell[11358, 450, 329, 12, 70, "ExampleText",
 CellID->21462],
Cell[CellGroupData[{
Cell[11712, 466, 118, 4, 70, "Input",
 CellID->8732],
Cell[11833, 472, 154, 5, 36, "Output",
 CellID->20392]
}, Open  ]],
Cell[CellGroupData[{
Cell[12024, 482, 123, 4, 70, "Input",
 CellID->26843],
Cell[12150, 488, 364, 14, 50, "Output",
 CellID->14063]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12575, 509, 311, 9, 70, "SeeAlsoSection",
 CellID->31173],
Cell[12889, 520, 1146, 44, 70, "SeeAlso",
 CellID->13454]
}, Open  ]],
Cell[CellGroupData[{
Cell[14072, 569, 313, 9, 70, "TutorialsSection",
 CellID->5081],
Cell[14388, 580, 154, 3, 70, "Tutorials",
 CellID->32271]
}, Open  ]],
Cell[CellGroupData[{
Cell[14579, 588, 319, 9, 70, "MoreAboutSection",
 CellID->132328729],
Cell[14901, 599, 143, 3, 70, "MoreAbout",
 CellID->23421545],
Cell[15047, 604, 150, 3, 70, "MoreAbout",
 CellID->132153202]
}, Open  ]],
Cell[15212, 610, 27, 0, 70, "History"],
Cell[15242, 612, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

