(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29786,        973]
NotebookOptionsPosition[     24801,        801]
NotebookOutlinePosition[     26175,        840]
CellTagsIndexPosition[     26090,        835]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"], 
          "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "Mouseover" :> 
          Documentation`HelpLookup["paclet:ref/Mouseover"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tooltip\"\>", 
       2->"\<\"MousePosition\"\>", 3->"\<\"CurrentValue\"\>", 
       4->"\<\"Mouseover\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Viewers and Annotation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MouseAnnotation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MouseAnnotation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MouseAnnotation"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives any mouse annotation associated with the \
expression at the current mouse position. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20236]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"], "[", "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if there is no mouse annotation associated with the expression at the \
current mouse position. "
}], "Notes",
 CellID->20012],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"], "[", 
   StyleBox["def", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " returns ",
 Cell[BoxData[
  StyleBox["def", "TI"]], "InlineFormula"],
 " if there is no current annotation. "
}], "Notes",
 CellID->16274],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"], "[", "]"}]], "InlineFormula"],
 " yields the mouse annotation associated with the expression that would be \
selected if the mouse were clicked. "
}], "Notes",
 CellID->5433],

Cell[TextData[{
 "The annotation is the expression ",
 Cell[BoxData[
  StyleBox["note", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["note", "TI"], ",", " ", "\"\<Mouse\>\""}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->29740],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{"MouseAnnotation", "[", "]"}], "]"}]], "InlineFormula"],
 " gives the continually updated current mouse annotation. "
}], "Notes",
 CellID->24401]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28999699],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->141067717],

Cell[TextData[{
 "If the mouse is over the graphics, ",
 Cell[BoxData[
  ButtonBox["MouseAnnotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFormula"],
 " will return the associated annotation:"
}], "ExampleText",
 CellID->106589744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Annotation", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Disk", "[", "]"}], "]"}], ",", "\"\<An annotation\>\"", ",", 
   "\"\<Mouse\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272343053],

Cell[BoxData[
 TagBox[
  GraphicsBox[DiskBox[{0, 0}]],
  Annotation[#, "An annotation", "Mouse"]& ]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->12760198]
}, Open  ]],

Cell["\<\
When the mouse is over the graphic, the annotation is displayed: \
\>", "ExampleText",
 CellID->333011660],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MouseAnnotation", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->296124962],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MouseAnnotation[], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2247383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1084893],

Cell["Use in plots: ", "ExampleText",
 CellID->287063986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Annotation", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], ",", "\"\<Sine\>\"", ",", 
       "\"\<Mouse\>\""}], "]"}], ",", 
     RowBox[{"Annotation", "[", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], ",", "\"\<Cosine\>\"", ",", 
       "\"\<Mouse\>\""}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6297718],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206323444]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MouseAnnotation", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58119476],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MouseAnnotation[], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576697365]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10282],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MouseAnnotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFormula"],
 " to update the state associated with each graphic: "
}], "ExampleText",
 CellID->162066968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Annotation", "[", 
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Red", ",", 
             RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"Dynamic", "[", 
             RowBox[{"x", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}]}]}], "]"}], ",", "1", 
         ",", "\"\<Mouse\>\""}], "]"}], ",", 
       RowBox[{"Annotation", "[", 
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Green", ",", 
             RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"Dynamic", "[", 
             RowBox[{"x", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "]"}]}]}], "]"}], ",", "2", 
         ",", "\"\<Mouse\>\""}], "]"}], ",", 
       RowBox[{"Annotation", "[", 
        RowBox[{
         RowBox[{"Graphics", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Blue", ",", 
             RowBox[{"Disk", "[", "]"}]}], "}"}], ",", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"Dynamic", "[", 
             RowBox[{"x", "[", 
              RowBox[{"[", "3", "]"}], "]"}], "]"}]}]}], "]"}], ",", "3", 
         ",", "\"\<Mouse\>\""}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseClicked\>\"", ":>", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "[", 
          RowBox[{"[", 
           RowBox[{"MouseAnnotation", "[", "]"}], "]"}], "]"}], "=", 
         RowBox[{
          RowBox[{"x", "[", 
           RowBox[{"[", 
            RowBox[{"MouseAnnotation", "[", "]"}], "]"}], "]"}], "+", "1"}]}],
         ")"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417908989],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = {1, 0, 0}}, 
  TagBox[
   RowBox[{"{", 
    RowBox[{
     TagBox[
      GraphicsBox[
       {RGBColor[1, 0, 0], DiskBox[{0, 0}]},
       PlotLabel->FormBox[
         DynamicBox[
          ToBoxes[
           Part[$CellContext`x$$, 1], TraditionalForm]], TraditionalForm]],
      Annotation[#, 1, "Mouse"]& ], ",", 
     TagBox[
      GraphicsBox[
       {RGBColor[0, 1, 0], DiskBox[{0, 0}]},
       PlotLabel->FormBox[
         DynamicBox[
          ToBoxes[
           Part[$CellContext`x$$, 2], TraditionalForm]], TraditionalForm]],
      Annotation[#, 2, "Mouse"]& ], ",", 
     TagBox[
      GraphicsBox[
       {RGBColor[0, 0, 1], DiskBox[{0, 0}]},
       PlotLabel->FormBox[
         DynamicBox[
          ToBoxes[
           Part[$CellContext`x$$, 3], TraditionalForm]], TraditionalForm]],
      Annotation[#, 3, "Mouse"]& ]}], "}"}],
   EventHandlerTag[{"MouseClicked" :> (Part[$CellContext`x$$, 
        MouseAnnotation[]] = Part[$CellContext`x$$, 
         MouseAnnotation[]] + 1), PassEventsDown -> Automatic, PassEventsUp -> 
     True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{341, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->221376612]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1848],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MouseAnnotation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MouseAnnotation"]], "InlineFormula"],
 " reveals annotations stored in other expressions:"
}], "ExampleText",
 CellID->8298503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Annotation", "[", 
  RowBox[{"\"\<xxx\>\"", ",", "\"\<Label\>\"", ",", "\"\<Mouse\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310603081],

Cell[BoxData[
 TagBox["\<\"xxx\"\>",
  Annotation[#, "Label", "Mouse"]& ]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->140365780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MouseAnnotation", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->364962775],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MouseAnnotation[], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7125930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415588265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " presents the annotated information in a popup box:"
}], "ExampleText",
 CellID->96543143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->477464077],

Cell[BoxData[
 TagBox[
  TooltipBox[
   RowBox[{"x", "+", "y"}],
   "label"],
  Annotation[#, $CellContext`label, "Tooltip"]& ]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562303480]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->403856881],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " presents the annotated information by changing the displayed form:"
}], "ExampleText",
 CellID->30166704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150980044],

Cell[BoxData[
 PaneSelectorBox[{False->
  RowBox[{"x", "+", "y"}], True->"label"}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252288532]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->437],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32134]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20183],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->361968277],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->479406266],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->355296503]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MouseAnnotation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 3.1211704}", "context" -> "System`", 
    "keywords" -> {
     "extracting annotations", "reaping annotation", "annotation flow", 
      "nonlocal annotation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MouseAnnotation[] gives any mouse annotation associated with the \
expression at the current mouse position. ", 
    "synonyms" -> {"mouse annotation"}, "title" -> "MouseAnnotation", "type" -> 
    "Symbol", "uri" -> "ref/MouseAnnotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7374, 232, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->28999699]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25948, 828}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2264, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2887, 82, 1580, 37, 70, "ObjectNameGrid"],
Cell[4470, 121, 525, 16, 70, "Usage",
 CellID->20236]
}, Open  ]],
Cell[CellGroupData[{
Cell[5032, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5510, 159, 429, 14, 70, "Notes",
 CellID->20012],
Cell[5942, 175, 364, 12, 70, "Notes",
 CellID->16274],
Cell[6309, 189, 318, 9, 70, "Notes",
 CellID->5433],
Cell[6630, 200, 413, 16, 70, "Notes",
 CellID->29740],
Cell[7046, 218, 291, 9, 70, "Notes",
 CellID->24401]
}, Closed]],
Cell[CellGroupData[{
Cell[7374, 232, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->28999699],
Cell[CellGroupData[{
Cell[7758, 246, 148, 5, 70, "ExampleSection",
 CellID->141067717],
Cell[7909, 253, 270, 8, 70, "ExampleText",
 CellID->106589744],
Cell[CellGroupData[{
Cell[8204, 265, 239, 7, 28, "Input",
 CellID->272343053],
Cell[8446, 274, 294, 9, 121, "Output",
 CellID->12760198]
}, Open  ]],
Cell[8755, 286, 116, 3, 70, "ExampleText",
 CellID->333011660],
Cell[CellGroupData[{
Cell[8896, 293, 140, 4, 70, "Input",
 CellID->296124962],
Cell[9039, 299, 246, 8, 70, "Output",
 CellID->2247383]
}, Open  ]],
Cell[9300, 310, 123, 3, 70, "ExampleDelimiter",
 CellID->1084893],
Cell[9426, 315, 57, 1, 70, "ExampleText",
 CellID->287063986],
Cell[CellGroupData[{
Cell[9508, 320, 594, 18, 47, "Input",
 CellID->6297718],
Cell[10105, 340, 4576, 79, 128, "Output",
 Evaluatable->False,
 CellID->206323444]
}, Open  ]],
Cell[CellGroupData[{
Cell[14718, 424, 139, 4, 70, "Input",
 CellID->58119476],
Cell[14860, 430, 248, 8, 70, "Output",
 CellID->576697365]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15157, 444, 223, 7, 70, "ExampleSection",
 CellID->10282],
Cell[15383, 453, 251, 8, 70, "ExampleText",
 CellID->162066968],
Cell[CellGroupData[{
Cell[15659, 465, 2103, 60, 70, "Input",
 CellID->417908989],
Cell[17765, 527, 1326, 39, 70, "Output",
 CellID->221376612]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19140, 572, 232, 7, 70, "ExampleSection",
 CellID->1848],
Cell[19375, 581, 238, 7, 70, "ExampleText",
 CellID->8298503],
Cell[CellGroupData[{
Cell[19638, 592, 176, 5, 70, "Input",
 CellID->310603081],
Cell[19817, 599, 267, 8, 36, "Output",
 CellID->140365780]
}, Open  ]],
Cell[CellGroupData[{
Cell[20121, 612, 140, 4, 70, "Input",
 CellID->364962775],
Cell[20264, 618, 246, 8, 70, "Output",
 CellID->7125930]
}, Open  ]],
Cell[20525, 629, 125, 3, 70, "ExampleDelimiter",
 CellID->415588265],
Cell[20653, 634, 225, 7, 70, "ExampleText",
 CellID->96543143],
Cell[CellGroupData[{
Cell[20903, 645, 154, 5, 70, "Input",
 CellID->477464077],
Cell[21060, 652, 269, 10, 70, "Output",
 CellID->562303480]
}, Open  ]],
Cell[21344, 665, 125, 3, 70, "ExampleDelimiter",
 CellID->403856881],
Cell[21472, 670, 245, 7, 70, "ExampleText",
 CellID->30166704],
Cell[CellGroupData[{
Cell[21742, 681, 156, 5, 70, "Input",
 CellID->150980044],
Cell[21901, 688, 307, 10, 70, "Output",
 CellID->252288532]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22269, 705, 309, 9, 70, "SeeAlsoSection",
 CellID->437],
Cell[22581, 716, 959, 35, 70, "SeeAlso",
 CellID->32134]
}, Open  ]],
Cell[CellGroupData[{
Cell[23577, 756, 314, 9, 70, "TutorialsSection",
 CellID->20183],
Cell[23894, 767, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[24077, 775, 319, 9, 70, "MoreAboutSection",
 CellID->361968277],
Cell[24399, 786, 173, 3, 70, "MoreAbout",
 CellID->479406266],
Cell[24575, 791, 154, 3, 70, "MoreAbout",
 CellID->355296503]
}, Open  ]],
Cell[24744, 797, 27, 0, 70, "History"],
Cell[24774, 799, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

