(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35412,       1162]
NotebookOptionsPosition[     28894,        953]
NotebookOutlinePosition[     30878,       1000]
CellTagsIndexPosition[     30793,        995]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Advanced Dynamic Functionality\"\>", 
       3->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MouseAnnotation" :> 
          Documentation`HelpLookup["paclet:ref/MouseAnnotation"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "Locator" :> 
          Documentation`HelpLookup["paclet:ref/Locator"], "ClickPane" :> 
          Documentation`HelpLookup["paclet:ref/ClickPane"], "EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"], 
          "ControllerState" :> 
          Documentation`HelpLookup["paclet:ref/ControllerState"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MouseAnnotation\"\>", 
       2->"\<\"CurrentValue\"\>", 3->"\<\"Locator\"\>", 
       4->"\<\"ClickPane\"\>", 5->"\<\"EventHandler\"\>", 
       6->"\<\"ControllerState\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Click-Interactive Panels\"\>", 2->"\<\"Control Objects\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"External Operations\"\>", 
       5->"\<\"Low-Level Interface Control\"\>", 
       6->"\<\"Stand-Alone Interfaces\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["MousePosition", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MousePosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MousePosition"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the current mouse position in the notebook front \
end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MousePosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MousePosition"], "[", "\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the mouse position with respect to the specified \
coordinate system."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["MousePosition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/MousePosition"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\"", ",", 
        StyleBox["def", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["def", "TI"]], "InlineFormula"],
     " if the mouse is not over an object that defines the specified \
coordinate system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->9964]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{"MousePosition", "[", "]"}], "]"}]], "InlineFormula"],
 " gives the continually updated current mouse position. "
}], "Notes",
 CellID->440],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\"", ",", 
     StyleBox["h", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " takes the coordinate system to extend only over the contents of the \
nearest enclosing object with head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->841093097]
}], "Notes",
 CellID->21113],

Cell["The following coordinate systems can be used:", "Notes",
 CellID->30389],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ScreenAbsolute\>\"", Cell[
    "absolute position within the complete screen display", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ScreenScaled\>\"", Cell[
    "scaled position within the complete screen display", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowAbsolute\>\"", Cell[
    "absolute position down the current window", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowScaled\>\"", Cell[
    "scaled position down the current window", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DocumentAbsolute\>\"", Cell[
    "absolute position down the current complete document", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DocumentScaled\>\"", Cell[
    "scaled position down the current complete document", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CellAbsolute\>\"", Cell[
    "absolute position within the current cell ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CellScaled\>\"", Cell[
    "scaled position within the current cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CellContentsAbsolute\>\"", Cell["\<\
absolute position within the content area of the current cell\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<CellContentsScaled\>\"", Cell[
    "scaled position within the content area of the current cell", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EventHandlerAbsolute\>\"", Cell[
    "absolute position within the current event handler region", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EventHandlerScaled\>\"", Cell[
    "scaled position within the current event handler region ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "coordinates in the current graphic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3DBoxIntercepts\>\"", Cell[
    "front and back intercepts with the 3D bounding box ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsAbsolute\>\"", Cell[
    "absolute position within the current graphic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsScaled\>\"", Cell[
    "scaled position within the current graphic", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsImageScaled\>\"", Cell[
    "scaled position within the current graphics image area", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True}}}},
 CellID->22710],

Cell["\<\
Absolute positions are given in printer\[CloseCurlyQuote]s points, \
corresponding to pixels on 72 dpi displays.\
\>", "Notes",
 CellID->20488],

Cell["Scaled positions normally run from 0 to 1 in each direction.", "Notes",
 CellID->13763],

Cell[TextData[{
 "For constructs that appear within windows, position ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineFormula"],
 " is taken to be at the bottom left. "
}], "Notes",
 CellID->30320],

Cell[TextData[{
 "For complete windows and documents, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineFormula"],
 " is taken to be at the top left."
}], "Notes",
 CellID->8188],

Cell[TextData[{
 "For the complete screen display, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}]], "InlineFormula"],
 " is taken to be at the top left corner of the primary monitor. Secondary \
monitors correspond to scaled positions outside the range 0 to 1. "
}], "Notes",
 CellID->23821],

Cell[TextData[{
 "For ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 ", ordinary coordinates as specified by ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " are used."
}], "Notes",
 CellID->17264],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"], "[", "\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\"", ",", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"]}], "]"}]], "InlineFormula"],
 ", so that by default ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " is returned if the mouse is not over an object that defines the specified \
coordinate system."
}], "Notes",
 CellID->6003],

Cell[TextData[{
 "When used in functions like ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["MousePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MousePosition"]], "InlineFormula"],
 " returns the mouse position at the moment when the triggering event \
occurred. "
}], "Notes",
 CellID->9754],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"], "[", "\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<MousePosition\>\"", ",", "\"\<\!\(\*
StyleBox[\"coords\", \"TI\"]\)\>\""}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14722]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->586950879],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->94498494],

Cell["Get the current position of the mouse:", "ExampleText",
 CellID->131913858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MousePosition", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272373048],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"898", ",", "446"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443590548]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->367460531],

Cell[TextData[{
 "Get the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " position of the mouse:"
}], "ExampleText",
 CellID->114238579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MousePosition", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196352019],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MousePosition[], StandardForm],
  ImageSizeCache->{39.1875, {2., 8.}}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->786334575]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->224331135],

Cell["\<\
Get the mouse position in the coordinate system of the graphic:\
\>", "ExampleText",
 CellID->144108848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53128782],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->100], ",", 
   DynamicBox[ToBoxes[
     MousePosition["Graphics"], StandardForm],
    ImageSizeCache->{28., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{158, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254569114]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344703900],

Cell["\<\
Get the scaled coordinates of the mouse within the current window:\
\>", "ExampleText",
 CellID->81238766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MousePosition", "[", "\"\<WindowScaled\>\"", "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->308254606],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MousePosition["WindowScaled"], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->179150738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->407215863],

Cell["\<\
When the mouse is not within the specified coordinate system, return an \
expression: \
\>", "ExampleText",
 CellID->129951407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"MousePosition", "[", 
     RowBox[{"\"\<Graphics\>\"", ",", "\"\<Mouse not in graphics!\>\""}], 
     "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62447765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->100], ",", 
   DynamicBox[ToBoxes[
     MousePosition["Graphics", "Mouse not in graphics!"], StandardForm],
    ImageSizeCache->{154., {2., 8.}}]}], "}"}]], "Output",
 ImageSize->{284, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->614551787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1271265300],

Cell[TextData[{
 "Constrain the coordinate system of ",
 Cell[BoxData[
  ButtonBox["MousePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MousePosition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->841093097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"MousePosition", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\"\<Graphics\>\"", ",", "Graphics"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "10"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"MousePosition", "[", 
        RowBox[{"\"\<Graphics\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "10"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1514316725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    DiskBox[Dynamic[MousePosition[{"Graphics", Graphics}, {0, 0}]]],
    ImageSize->100,
    PlotRange->10], ",", 
   GraphicsBox[DiskBox[Dynamic[MousePosition["Graphics", {0, 0}]]],
    ImageSize->100,
    PlotRange->10]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2038001821]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->515487498],

Cell["\<\
Change the color and opacity as the mouse is moved through the graphic:\
\>", "ExampleText",
 CellID->29897232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Framed", "@", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"MousePosition", "[", 
         RowBox[{"\"\<GraphicsScaled\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
      RowBox[{"Opacity", "[", 
       RowBox[{
        RowBox[{"MousePosition", "[", 
         RowBox[{"\"\<GraphicsScaled\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}]}], "]"}], "[", 
        RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81746456],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Framed[
    Graphics[{
      Hue[
       Part[
        MousePosition["GraphicsScaled", {0, 0}], 1]], 
      Opacity[
       Part[
        MousePosition["GraphicsScaled", {0, 0}], 2]], 
      Disk[]}]], StandardForm],
  ImageSizeCache->{190., {93., 97.}}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233417241]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->185067637],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MousePosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MousePosition"]], "InlineFormula"],
 " is often used with ",
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->420475597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"list", "=", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"EventHandler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", 
      RowBox[{"Framed", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Red", ",", 
           RowBox[{"Line", "[", "list", "]"}], ",", 
           RowBox[{"Point", "[", "list", "]"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<MouseClicked\>\"", "\[RuleDelayed]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"list", ",", 
         RowBox[{"MousePosition", "[", "\"\<Graphics\>\"", "]"}]}], "]"}]}], 
      "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->332435897],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`list$$ = {}}, 
  TagBox[
   DynamicBox[ToBoxes[
     Framed[
      Graphics[{Red, 
        Line[$CellContext`list$$], 
        Point[$CellContext`list$$]}, PlotRange -> 2]], StandardForm],
    ImageSizeCache->{190., {93., 97.}}],
   EventHandlerTag[{"MouseClicked" :> AppendTo[$CellContext`list$$, 
       MousePosition["Graphics"]], PassEventsDown -> Automatic, PassEventsUp -> 
     True}]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{194, 192},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1645155032]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9524],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClickPane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClickPane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerState",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerState"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15818]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25316],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->51916926],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->176815378],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->214560484],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->1253788],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->308730491],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->296660316],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->10692894]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MousePosition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 9.7619654}", "context" -> "System`", 
    "keywords" -> {
     "mouse coordinates", "mouse position", "mouse events", "event handler", 
      "event action handler", "event data", "event coordinates", 
      "screen absolute", "screen scaled", "window absolute", "window scaled", 
      "document absollute", "document scaled", "cell absolute", "cell scaled",
       "cell contents absolute", "cell contents scaled", 
      "event handler absolute", "event handler scaled", 
      "graphics 3D box intercepts", "graphics absolute", "graphics scaled", 
      "graphics image scaled"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MousePosition[] gives the current mouse position in the notebook front \
end. MousePosition[\"coords\"] gives the mouse position with respect to the \
specified coordinate system. MousePosition[\"coords\", def] returns def if \
the mouse is not over an object that defines the specified coordinate \
system.", "synonyms" -> {"mouse position"}, "title" -> "MousePosition", 
    "type" -> "Symbol", "uri" -> "ref/MousePosition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14631, 412, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->586950879]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30649, 988}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3470, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4093, 102, 1578, 37, 70, "ObjectNameGrid"],
Cell[5674, 141, 1366, 41, 70, "Usage",
 CellID->9964]
}, Open  ]],
Cell[CellGroupData[{
Cell[7077, 187, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7555, 204, 285, 9, 70, "Notes",
 CellID->440],
Cell[7843, 215, 580, 19, 70, "Notes",
 CellID->21113],
Cell[8426, 236, 78, 1, 70, "Notes",
 CellID->30389],
Cell[8507, 239, 2878, 50, 70, "2ColumnTableMod",
 CellID->22710],
Cell[11388, 291, 153, 4, 70, "Notes",
 CellID->20488],
Cell[11544, 297, 93, 1, 70, "Notes",
 CellID->13763],
Cell[11640, 300, 226, 7, 70, "Notes",
 CellID->30320],
Cell[11869, 309, 205, 7, 70, "Notes",
 CellID->8188],
Cell[12077, 318, 312, 8, 70, "Notes",
 CellID->23821],
Cell[12392, 328, 285, 10, 70, "Notes",
 CellID->17264],
Cell[12680, 340, 813, 26, 70, "Notes",
 CellID->6003],
Cell[13496, 368, 548, 19, 70, "Notes",
 CellID->9754],
Cell[14047, 389, 547, 18, 70, "Notes",
 CellID->14722]
}, Closed]],
Cell[CellGroupData[{
Cell[14631, 412, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->586950879],
Cell[CellGroupData[{
Cell[15016, 426, 147, 5, 70, "ExampleSection",
 CellID->94498494],
Cell[15166, 433, 81, 1, 70, "ExampleText",
 CellID->131913858],
Cell[CellGroupData[{
Cell[15272, 438, 104, 3, 28, "Input",
 CellID->272373048],
Cell[15379, 443, 207, 7, 36, "Output",
 CellID->443590548]
}, Open  ]],
Cell[15601, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->367460531],
Cell[15729, 458, 211, 8, 70, "ExampleText",
 CellID->114238579],
Cell[CellGroupData[{
Cell[15965, 470, 138, 4, 70, "Input",
 CellID->196352019],
Cell[16106, 476, 250, 8, 70, "Output",
 CellID->786334575]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16405, 490, 220, 7, 70, "ExampleSection",
 CellID->224331135],
Cell[16628, 499, 114, 3, 70, "ExampleText",
 CellID->144108848],
Cell[CellGroupData[{
Cell[16767, 506, 341, 11, 70, "Input",
 CellID->53128782],
Cell[17111, 519, 358, 12, 70, "Output",
 CellID->254569114]
}, Open  ]],
Cell[17484, 534, 125, 3, 70, "ExampleDelimiter",
 CellID->344703900],
Cell[17612, 539, 116, 3, 70, "ExampleText",
 CellID->81238766],
Cell[CellGroupData[{
Cell[17753, 546, 164, 5, 70, "Input",
 CellID->308254606],
Cell[17920, 553, 260, 8, 70, "Output",
 CellID->179150738]
}, Open  ]],
Cell[18195, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->407215863],
Cell[18323, 569, 137, 4, 70, "ExampleText",
 CellID->129951407],
Cell[CellGroupData[{
Cell[18485, 577, 399, 12, 70, "Input",
 CellID->62447765],
Cell[18887, 591, 385, 12, 70, "Output",
 CellID->614551787]
}, Open  ]],
Cell[19287, 606, 126, 3, 70, "ExampleDelimiter",
 CellID->1271265300],
Cell[19416, 611, 276, 9, 70, "ExampleText",
 CellID->841093097],
Cell[CellGroupData[{
Cell[19717, 624, 936, 26, 70, "Input",
 CellID->1514316725],
Cell[20656, 652, 431, 14, 123, "Output",
 CellID->2038001821]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21136, 672, 227, 7, 70, "ExampleSection",
 CellID->515487498],
Cell[21366, 681, 121, 3, 70, "ExampleText",
 CellID->29897232],
Cell[CellGroupData[{
Cell[21512, 688, 773, 22, 70, "Input",
 CellID->81746456],
Cell[22288, 712, 436, 16, 70, "Output",
 CellID->233417241]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22773, 734, 237, 7, 70, "ExampleSection",
 CellID->185067637],
Cell[23013, 743, 340, 12, 70, "ExampleText",
 CellID->420475597],
Cell[CellGroupData[{
Cell[23378, 759, 838, 24, 70, "Input",
 CellID->332435897],
Cell[24219, 785, 611, 17, 70, "Output",
 CellID->1645155032]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24891, 809, 310, 9, 70, "SeeAlsoSection",
 CellID->9524],
Cell[25204, 820, 1475, 53, 70, "SeeAlso",
 CellID->15818]
}, Open  ]],
Cell[CellGroupData[{
Cell[26716, 878, 314, 9, 70, "TutorialsSection",
 CellID->25316],
Cell[27033, 889, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[27195, 894, 173, 3, 70, "Tutorials",
 CellID->558945376],
Cell[27371, 899, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[27556, 907, 318, 9, 70, "MoreAboutSection",
 CellID->51916926],
Cell[27877, 918, 158, 3, 70, "MoreAbout",
 CellID->176815378],
Cell[28038, 923, 141, 3, 70, "MoreAbout",
 CellID->214560484],
Cell[28182, 928, 166, 3, 70, "MoreAbout",
 CellID->1253788],
Cell[28351, 933, 149, 3, 70, "MoreAbout",
 CellID->308730491],
Cell[28503, 938, 163, 3, 70, "MoreAbout",
 CellID->296660316],
Cell[28669, 943, 153, 3, 70, "MoreAbout",
 CellID->10692894]
}, Open  ]],
Cell[28837, 949, 27, 0, 70, "History"],
Cell[28867, 951, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

