(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    147167,       3925]
NotebookOptionsPosition[    137092,       3572]
NotebookOutlinePosition[    138456,       3611]
CellTagsIndexPosition[    138369,       3606]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Advanced Dynamic Functionality\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tooltip" :> Documentation`HelpLookup["paclet:ref/Tooltip"], 
          "Annotation" :> Documentation`HelpLookup["paclet:ref/Annotation"], 
          "PopupView" :> Documentation`HelpLookup["paclet:ref/PopupView"], 
          "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"], 
          "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"], "AutoAction" :> 
          Documentation`HelpLookup["paclet:ref/AutoAction"], "StatusArea" :> 
          Documentation`HelpLookup["paclet:ref/StatusArea"], 
          "WindowStatusArea" :> 
          Documentation`HelpLookup["paclet:ref/WindowStatusArea"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tooltip\"\>", 
       2->"\<\"Annotation\"\>", 3->"\<\"PopupView\"\>", 
       4->"\<\"MousePosition\"\>", 5->"\<\"PaneSelector\"\>", 
       6->"\<\"AutoAction\"\>", 7->"\<\"StatusArea\"\>", 
       8->"\<\"WindowStatusArea\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Click-Interactive Panels\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Document Generation\"\>", 
       5->"\<\"Dynamic Graphics Elements\"\>", 
       6->"\<\"Dynamic Visualization\"\>", 
       7->"\<\"Graphics Annotation & Appearance\"\>", 
       8->"\<\"Notebook Formatting & Styling\"\>", 9->"\<\"Palettes\"\>", 
       10->"\<\"Stand-Alone Interfaces\"\>", 
       11->"\<\"User Interface Structuring & Layout\"\>", 
       12->"\<\"Viewers and Annotation\"\>", 
       13->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       14->"\<\"New in 6.0: Formatting & Styling\"\>", 
       15->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       16->"\<\"New in 6.0: Notebooks & Documents\"\>", 
       17->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Mouseover", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Mouseover",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Mouseover"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["over", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an object that displays as ",
     Cell[BoxData[
      StyleBox["over", "TI"]], "InlineFormula"],
     " when the mouse pointer is over it, and as ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23263]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " can be used with graphics or any other expression. "
}], "Notes",
 CellID->17830],

Cell["The following options can be given: ", "Notes",
 CellID->8514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Left",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Left"], ",", 
      ButtonBox["Top",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Top"]}], "}"}], Cell[
    "how to align objects in the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size for the displayed objects ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->3336],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " leaves space only for the object currently being displayed. "
}], "Notes",
 CellID->5783],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " leaves enough space for either ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["over", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31032]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->627998293],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->244309571],

Cell[TextData[{
 "Change from ",
 Cell[BoxData["off"], "InlineFormula"],
 " to ",
 Cell[BoxData["on"], "InlineFormula"],
 " when the mouse is over the expression:"
}], "ExampleText",
 CellID->92555482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{"off", ",", "on"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357786019],

Cell[BoxData[
 PaneSelectorBox[{False->"off", True->"on"}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246803509]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26320],

Cell["Use anywhere in a formula: ", "ExampleText",
 CellID->639599976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371237454],

Cell[BoxData[
 PaneSelectorBox[{False->"x", True->
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->50]}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242868153]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Mouseover", "[", 
   RowBox[{"x", ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358129812],

Cell[BoxData[
 FractionBox["1", 
  PaneSelectorBox[{False->"x", True->
   Graphics3DBox[SphereBox[{0, 0, 0}],
    ImageSize->50]}, Dynamic[
    CurrentValue["MouseOver"]],
   FrameMargins->0,
   ImageSize->Automatic]]], "Output",
 ImageSize->{16, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111629872]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", 
      RowBox[{"Mouseover", "[", 
       RowBox[{"x", ",", 
        RowBox[{"Grid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"e", ",", "f"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"g", ",", "h"}], "}"}]}], "}"}], "]"}]}], "]"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20173571],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     PaneSelectorBox[{False->"x", True->
      TagBox[GridBox[{
         {"e", "f"},
         {"g", "h"}
        }],
       "Grid"]}, Dynamic[
       CurrentValue["MouseOver"]],
      FrameMargins->0,
      ImageSize->Automatic]},
    {"c", "d"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->788071928]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Mouseover", "[", 
      RowBox[{"x", ",", 
       RowBox[{"Style", "[", 
        RowBox[{"xxxx", ",", "Red"}], "]"}]}], "]"}], "+", "y"}], ")"}], "^", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->254294621],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["y", "3"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["y", "2"], " ", 
   PaneSelectorBox[{False->"x", True->
    StyleBox["xxxx",
     StripOnInput->False,
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic]}], "+", 
  RowBox[{"3", " ", "y", " ", 
   SuperscriptBox[
    PaneSelectorBox[{False->"x", True->
     StyleBox["xxxx",
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->0,
     ImageSize->Automatic], "2"]}], "+", 
  SuperscriptBox[
   PaneSelectorBox[{False->"x", True->
    StyleBox["xxxx",
     StripOnInput->False,
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontColor->RGBColor[1, 0, 0]]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], "3"]}]], "Output",
 ImageSize->{132, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->289667010]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375434542],

Cell["Use anywhere in a graphic: ", "ExampleText",
 CellID->451317969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Mouseover", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256276209],

Cell[BoxData[
 GraphicsBox[
  DynamicBox[FEPrivate`If[
    CurrentValue["MouseOver"], 
    CircleBox[{0, 0}], 
    DiskBox[{0, 0}]],
   ImageSizeCache->{{1., 48.}, {-26.0625, 20.9375}}],
  ImageSize->50]], "Output",
 ImageSize->{54, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341922227]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mouseover", "[", 
     RowBox[{
      RowBox[{"Point", "[", "p", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Point", "[", "p", "]"}], ",", 
        RowBox[{"Arrowheads", "[", ".1", "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Scaled", "[", 
            RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", "p"}], "}"}], 
         "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"1", ",", 
        RowBox[{"{", 
         RowBox[{"10", ",", "2"}], "}"}]}], "]"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23154845],

Cell[BoxData[
 GraphicsBox[{
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.15551053071846854`, 0.8507211756414506}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.15551053071846854`, 0.8507211756414506}}]}, 
     PointBox[{0.15551053071846854`, 0.8507211756414506}]],
    ImageSizeCache->{{1.5625, 5.5625}, {-57.4375, -53.4375}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.5853435082230467, 0.8584138605826401}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.5853435082230467, 0.8584138605826401}}]}, 
     PointBox[{0.5853435082230467, 0.8584138605826401}]],
    ImageSizeCache->{{93.5625, 97.5625}, {-59.0625, -55.0625}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.32224983147493846`, 0.9049727861868986}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.32224983147493846`, 0.9049727861868986}}]}, 
     PointBox[{0.32224983147493846`, 0.9049727861868986}]],
    ImageSizeCache->{{37.25, 41.25}, {-69.0625, -65.0625}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.9582932223532679, 0.34304196415268784`}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.9582932223532679, 0.34304196415268784`}}]}, 
     PointBox[{0.9582932223532679, 0.34304196415268784`}]],
    ImageSizeCache->{{173.4375, 177.4375}, {51.25, 55.25}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.31084248710822693`, 0.968135221156901}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.31084248710822693`, 0.968135221156901}}]}, 
     PointBox[{0.31084248710822693`, 0.968135221156901}]],
    ImageSizeCache->{{34.8125, 38.8125}, {-82.5625, -78.5625}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.18517824789274084`, 0.2446194532893864}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.18517824789274084`, 0.2446194532893864}}]}, 
     PointBox[{0.18517824789274084`, 0.2446194532893864}]],
    ImageSizeCache->{{7.9375, 11.9375}, {72.3125, 76.3125}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.5503040974812656, 0.3711567897665604}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.5503040974812656, 0.3711567897665604}}]}, 
     PointBox[{0.5503040974812656, 0.3711567897665604}]],
    ImageSizeCache->{{86.0625, 90.0625}, {45.25, 49.25}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.8018400995147268, 0.6715548550380179}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.8018400995147268, 0.6715548550380179}}]}, 
     PointBox[{0.8018400995147268, 0.6715548550380179}]],
    ImageSizeCache->{{139.9375, 143.9375}, {-19.0625, -15.0625}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.5402412397944911, 0.7778600346197626}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.5402412397944911, 0.7778600346197626}}]}, 
     PointBox[{0.5402412397944911, 0.7778600346197626}]],
    ImageSizeCache->{{83.9375, 87.9375}, {-41.8125, -37.8125}}], 
   DynamicBox[FEPrivate`If[
     CurrentValue["MouseOver"], {
      PointBox[{0.23676219149827915`, 0.9384683648149779}], 
      Arrowheads[0.1], 
      ArrowBox[{
        Scaled[{1, 1}], {0.23676219149827915`, 0.9384683648149779}}]}, 
     PointBox[{0.23676219149827915`, 0.9384683648149779}]],
    ImageSizeCache->{{19., 23.}, {-76.1875, -72.1875}}]}]], "Output",
 ImageSize->{184, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339470792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->72158884],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "\[Rule]", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " keeps the overall size constant regardless of which expression is \
visible:"
}], "ExampleText",
 CellID->1867467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<xxx\>\"", ",", 
    RowBox[{"Mouseover", "[", 
     RowBox[{"\"\<A very long string.\>\"", ",", "\"\<Short!\>\""}], "]"}], 
    ",", "\"\<xxx\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210383986],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xxx\"\>", "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"\<\"A very long string.\"\>", 
    True->"\<\"Short!\"\>"}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], "\[InvisibleSpace]", "\<\"xxx\"\>"}],
  Row[{"xxx", 
    Mouseover["A very long string.", "Short!"], "xxx"}]]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45572]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<xxx\>\"", ",", 
    RowBox[{"Mouseover", "[", 
     RowBox[{"\"\<A very long string.\>\"", ",", "\"\<Short!\>\"", ",", 
      RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}], ",", "\"\<xxx\>\""}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34300315],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xxx\"\>", "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"\<\"A very long string.\"\>", 
    True->"\<\"Short!\"\>"}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->All], "\[InvisibleSpace]", "\<\"xxx\"\>"}],
  Row[{"xxx", 
    Mouseover["A very long string.", "Short!", ImageSize -> All], 
    "xxx"}]]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16554675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->275608514],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to recompute the tooltip every time it is looked at:"
}], "ExampleText",
 CellID->44051271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{"date", ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{
     RowBox[{"DateString", "[", "]"}], ",", 
     RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18900580],

Cell[BoxData[
 PaneSelectorBox[{False->"date", True->
  DynamicBox[ToBoxes[
    DateString[], StandardForm],
   ImageSizeCache->{161., {2., 8.}},
   UpdateInterval:>1]}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->593131944]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3228375],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->308988161],

Cell[TextData[{
 "Align within ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->58908241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Mouseover", "[", 
      RowBox[{
       RowBox[{"x", "+", "y"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"x", "+", "y"}], ",", "Red"}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"50", ",", "25"}], "}"}]}], ",", 
       RowBox[{"Alignment", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439315865],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Left, Top},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Center, Top},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Right, Top},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False]},
    {
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Left, Center},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Center, Center},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Right, Center},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False]},
    {
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Left, Bottom},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Center, Bottom},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       Alignment->{Right, Bottom},
       FrameMargins->0,
       ImageSize->{50, 25}],
      StripOnInput->False]}
   }],
  "Grid"]], "Output",
 ImageSize->{200, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242443431]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->655670651],

Cell["Change the background color:", "ExampleText",
 CellID->120667488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", "Red"}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"30", ",", "15"}], "}"}]}], ",", 
   RowBox[{"Background", "\[Rule]", "Gray"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213319341],

Cell[BoxData[
 PaneSelectorBox[{False->
  RowBox[{"x", "+", "y"}], True->
  StyleBox[
   RowBox[{"x", "+", "y"}],
   StripOnInput->False,
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontColor->RGBColor[1, 0, 0]]}, Dynamic[
   CurrentValue["MouseOver"]],
  Background->GrayLevel[0.5],
  FrameMargins->0,
  ImageSize->{30, 15}]], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89197124]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44399],

Cell["Align with surrounding text:", "ExampleText",
 CellID->42640069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Framed", "@", 
      RowBox[{"Mouseover", "[", 
       RowBox[{
        RowBox[{"x", "+", "y"}], ",", 
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{"x", "+", "y"}], ",", "Red"}], "]"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\< xxx \>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62423245],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Top,
     FrameMargins->0,
     ImageSize->Automatic],
    StripOnInput->False], " ", "xxx", " ", 
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Center,
     FrameMargins->0,
     ImageSize->Automatic],
    StripOnInput->False], " ", "xxx", " ", 
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Bottom,
     FrameMargins->0,
     ImageSize->Automatic],
    StripOnInput->False]}],
  Row[{
    Framed[
     Mouseover[$CellContext`x + $CellContext`y, 
      Style[$CellContext`x + $CellContext`y, 
       RGBColor[1, 0, 0]], BaselinePosition -> Top]], 
    Framed[
     Mouseover[$CellContext`x + $CellContext`y, 
      Style[$CellContext`x + $CellContext`y, 
       RGBColor[1, 0, 0]], BaselinePosition -> Center]], 
    Framed[
     Mouseover[$CellContext`x + $CellContext`y, 
      Style[$CellContext`x + $CellContext`y, 
       RGBColor[1, 0, 0]], BaselinePosition -> Bottom]]}, " xxx "]]], "Output",\

 ImageSize->{169, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33434255]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->81932343],

Cell[TextData[{
 "Add margins to ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->60687876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Mouseover", "[", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"x", "+", "y"}], ",", "Red"}], "]"}], ",", 
      RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404218665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->0,
     ImageSize->Automatic],
    StripOnInput->False], ",", 
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->10,
     ImageSize->Automatic],
    StripOnInput->False], ",", 
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->20,
     ImageSize->Automatic],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{212, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9236777]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->740978042],

Cell[TextData[{
 "Add margins to ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93529613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Mouseover", "[", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"x", "+", "y"}], ",", "Red"}], "]"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81884322],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->0,
     ImageMargins->0,
     ImageSize->Automatic],
    StripOnInput->False], ",", 
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->0,
     ImageMargins->10,
     ImageSize->Automatic],
    StripOnInput->False], ",", 
   FrameBox[
    PaneSelectorBox[{False->
     RowBox[{"x", "+", "y"}], True->
     StyleBox[
      RowBox[{"x", "+", "y"}],
      StripOnInput->False,
      FrontFaceColor->RGBColor[1, 0, 0],
      BackFaceColor->RGBColor[1, 0, 0],
      GraphicsColor->RGBColor[1, 0, 0],
      FontColor->RGBColor[1, 0, 0]]}, Dynamic[
      CurrentValue["MouseOver"]],
     FrameMargins->0,
     ImageMargins->20,
     ImageSize->Automatic],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{212, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30647752]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->64521293],

Cell[TextData[{
 "Control the overall size of ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141841228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Mouseover", "[", 
      RowBox[{
       RowBox[{"x", "+", "y"}], ",", 
       RowBox[{"Style", "[", 
        RowBox[{
         RowBox[{"x", "+", "y"}], ",", "Red"}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "50", ",", "70"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->254057507],

Cell[BoxData[
 TagBox[GridBox[{
    {
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{50, 30}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{70, 30}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{100, 30}],
      StripOnInput->False]},
    {
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{50, 50}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{70, 50}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{100, 50}],
      StripOnInput->False]},
    {
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{50, 70}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{70, 70}],
      StripOnInput->False], 
     FrameBox[
      PaneSelectorBox[{False->
       RowBox[{"x", "+", "y"}], True->
       StyleBox[
        RowBox[{"x", "+", "y"}],
        StripOnInput->False,
        FrontFaceColor->RGBColor[1, 0, 0],
        BackFaceColor->RGBColor[1, 0, 0],
        GraphicsColor->RGBColor[1, 0, 0],
        FontColor->RGBColor[1, 0, 0]]}, Dynamic[
        CurrentValue["MouseOver"]],
       FrameMargins->0,
       ImageSize->{100, 70}],
      StripOnInput->False]}
   }],
  "Grid"]], "Output",
 ImageSize->{270, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->729603362]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9354],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " to find the rule number of a particular ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->531982041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mouseover", "[", 
    RowBox[{
     RowBox[{"ArrayPlot", "[", 
      RowBox[{
       RowBox[{"CellularAutomaton", "[", 
        RowBox[{"n", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "All"}], "}"}]}], "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "n", ",", 
     RowBox[{"Alignment", "\[Rule]", "Center"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "All"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "64"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->546955807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"1"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"2"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"3"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"4"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"5"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"6"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"7"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"8"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"9"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"10"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"11"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"12"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
      1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"13"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"14"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"15"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"16"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"17"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"18"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"19"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"20"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"21"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"22"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"23"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"24"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"25"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"26"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"27"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"28"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"29"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 
      0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1}, {1,
       1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"30"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"31"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"32"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"33"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"34"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"35"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"36"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"37"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"38"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"39"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"40"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"41"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"42"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"43"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"44"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      0}, {0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0}, {1,
       1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 
      1, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"45"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"46"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 1, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"47"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"48"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"49"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"50"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"51"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"52"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"53"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 
      0}, {1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1}, {1,
       1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 1, 
      1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"54"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"55"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"56"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"57"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 
      0}, {1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1}, {1,
       1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1}, {1, 1, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 1, 
      0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 
      0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"58"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"59"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 
      0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"60"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"61"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 
      0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1}, {1,
       1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1}, {1, 1, 1, 
      0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 
      0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 0, 0, 
      1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 
      0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 
      0, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"62"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"63"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[
     RasterBox[{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1,
       1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1}}, {{0, 0}, {21, 11}}, {0, 1}],
     Frame->Automatic,
     FrameLabel->{None, None},
     FrameTicks->{{None, None}, {None, None}},
     ImageSize->50,
     PlotRangeClipping->True], True->"64"}, Dynamic[
     CurrentValue["MouseOver"]],
    Alignment->Center,
    FrameMargins->0,
    ImageSize->All]}], "}"}]], "Output",
 ImageSize->{497, 247},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27236282]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28703],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 " changes the expression itself:"
}], "ExampleText",
 CellID->30166704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150980044],

Cell[BoxData[
 PaneSelectorBox[{False->
  RowBox[{"x", "+", "y"}], True->"label"}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->554068008]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StatusArea",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StatusArea"]], "InlineFormula"],
 " presents the label in the status area:"
}], "ExampleText",
 CellID->477652960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StatusArea", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343638917],

Cell[BoxData[
 TagBox[
  RowBox[{"x", "+", "y"}],
  StatusArea[#, $CellContext`label]& ,
  TagBoxNote->"label"]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310334492]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " presents the label in a popup box:"
}], "ExampleText",
 CellID->96543143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "label"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->477464077],

Cell[BoxData[
 TagBox[
  TooltipBox[
   RowBox[{"x", "+", "y"}],
   "label"],
  Annotation[#, $CellContext`label, "Tooltip"]& ]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->171826864]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5494],

Cell["\<\
If the mouseover is smaller than the original object, there can be an \
oscillation:\
\>", "ExampleText",
 CellID->30562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<xxx\>\"", ",", 
    RowBox[{"Mouseover", "[", 
     RowBox[{"1000", ",", "1"}], "]"}], ",", "\"\<xxx\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23865],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xxx\"\>", "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"1000", True->"1"}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], "\[InvisibleSpace]", "\<\"xxx\"\>"}],
  Row[{"xxx", 
    Mouseover[1000, 1], "xxx"}]]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16835718]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " space is always left for the largest object:"
}], "ExampleText",
 CellID->20700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<xxx\>\"", ",", 
    RowBox[{"Mouseover", "[", 
     RowBox[{"1000", ",", "1", ",", 
      RowBox[{"ImageSize", "->", "All"}]}], "]"}], ",", "\"\<xxx\>\""}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32302],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"xxx\"\>", "\[InvisibleSpace]", 
   PaneSelectorBox[{False->"1000", True->"1"}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->All], "\[InvisibleSpace]", "\<\"xxx\"\>"}],
  Row[{"xxx", 
    Mouseover[1000, 1, ImageSize -> All], "xxx"}]]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69548406]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Mouseover", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"RandomReal", "[", "100", "]"}]}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"RandomReal", "[", "100", "]"}]}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   PaneSelectorBox[{False->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->56.1951213310153], True->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->53.3444034456209]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->14.2756525803504], True->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->37.4074969946746]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->85.9825241639174], True->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->63.43645787335]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->64.186243751991], True->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->50.6594509188954]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic], ",", 
   PaneSelectorBox[{False->
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->22.800930552879], True->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->91.9827584616079]}, Dynamic[
     CurrentValue["MouseOver"]],
    FrameMargins->0,
    ImageSize->Automatic]}], "}"}]], "Output",
 ImageSize->{306, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15940],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaneSelector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaneSelector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoAction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowStatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowStatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24988],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Mouseover",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Mouseover"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->717411740],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->351493407],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->85784745],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->44881662],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->72283117],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->318550763],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->2330248],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->190218807],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->442761484],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->871019911],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->58877307],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->139746619],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->34104257],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->217414225],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->283856527],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->537648388],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->127884445],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->119203697]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Mouseover - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 9.0431970}", "context" -> "System`", 
    "keywords" -> {
     "mouse over", "drill down", "dynamic action", "dynamic display", 
      "mouse driven display"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Mouseover[expr, over] represents an object that displays as over when \
the mouse pointer is over it, and as expr otherwise. ", 
    "synonyms" -> {"hover"}, "title" -> "Mouseover", "type" -> "Symbol", 
    "uri" -> "ref/Mouseover"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11819, 323, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->627998293]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 138225, 3599}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5796, 120, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6419, 147, 1574, 37, 70, "ObjectNameGrid"],
Cell[7996, 186, 751, 23, 70, "Usage",
 CellID->23263]
}, Open  ]],
Cell[CellGroupData[{
Cell[8784, 214, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9262, 231, 221, 7, 70, "Notes",
 CellID->17830],
Cell[9486, 240, 68, 1, 70, "Notes",
 CellID->8514],
Cell[9557, 243, 1118, 31, 70, "3ColumnTableMod",
 CellID->3336],
Cell[10678, 276, 507, 17, 70, "Notes",
 CellID->5783],
Cell[11188, 295, 594, 23, 70, "Notes",
 CellID->31032]
}, Closed]],
Cell[CellGroupData[{
Cell[11819, 323, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->627998293],
Cell[CellGroupData[{
Cell[12204, 337, 148, 5, 70, "ExampleSection",
 CellID->244309571],
Cell[12355, 344, 201, 7, 70, "ExampleText",
 CellID->92555482],
Cell[CellGroupData[{
Cell[12581, 355, 131, 4, 28, "Input",
 CellID->357786019],
Cell[12715, 361, 283, 9, 36, "Output",
 CellID->246803509]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13047, 376, 216, 7, 70, "ExampleSection",
 CellID->26320],
Cell[13266, 385, 70, 1, 70, "ExampleText",
 CellID->639599976],
Cell[CellGroupData[{
Cell[13361, 390, 259, 8, 70, "Input",
 CellID->371237454],
Cell[13623, 400, 326, 11, 70, "Output",
 CellID->242868153]
}, Open  ]],
Cell[CellGroupData[{
Cell[13986, 416, 291, 9, 70, "Input",
 CellID->358129812],
Cell[14280, 427, 359, 12, 70, "Output",
 CellID->111629872]
}, Open  ]],
Cell[CellGroupData[{
Cell[14676, 444, 549, 19, 70, "Input",
 CellID->20173571],
Cell[15228, 465, 447, 19, 70, "Output",
 CellID->788071928]
}, Open  ]],
Cell[CellGroupData[{
Cell[15712, 489, 315, 11, 70, "Input",
 CellID->254294621],
Cell[16030, 502, 1356, 42, 70, "Output",
 CellID->289667010]
}, Open  ]],
Cell[17401, 547, 125, 3, 70, "ExampleDelimiter",
 CellID->375434542],
Cell[17529, 552, 70, 1, 70, "ExampleText",
 CellID->451317969],
Cell[CellGroupData[{
Cell[17624, 557, 288, 9, 70, "Input",
 CellID->256276209],
Cell[17915, 568, 345, 12, 70, "Output",
 CellID->341922227]
}, Open  ]],
Cell[CellGroupData[{
Cell[18297, 585, 807, 26, 70, "Input",
 CellID->23154845],
Cell[19107, 613, 3740, 86, 70, "Output",
 CellID->339470792]
}, Open  ]],
Cell[22862, 702, 124, 3, 70, "ExampleDelimiter",
 CellID->72158884],
Cell[22989, 707, 360, 12, 70, "ExampleText",
 CellID->1867467],
Cell[CellGroupData[{
Cell[23374, 723, 284, 8, 70, "Input",
 CellID->210383986],
Cell[23661, 733, 507, 14, 70, "Output",
 CellID->45572]
}, Open  ]],
Cell[CellGroupData[{
Cell[24205, 752, 335, 9, 70, "Input",
 CellID->34300315],
Cell[24543, 763, 527, 15, 70, "Output",
 CellID->16554675]
}, Open  ]],
Cell[25085, 781, 125, 3, 70, "ExampleDelimiter",
 CellID->275608514],
Cell[25213, 786, 236, 8, 70, "ExampleText",
 CellID->44051271],
Cell[CellGroupData[{
Cell[25474, 798, 270, 8, 70, "Input",
 CellID->18900580],
Cell[25747, 808, 394, 13, 70, "Output",
 CellID->593131944]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26190, 827, 220, 7, 70, "ExampleSection",
 CellID->3228375],
Cell[CellGroupData[{
Cell[26435, 838, 230, 7, 70, "ExampleSubsection",
 CellID->308988161],
Cell[26668, 847, 197, 8, 70, "ExampleText",
 CellID->58908241],
Cell[CellGroupData[{
Cell[26890, 859, 876, 27, 70, "Input",
 CellID->439315865],
Cell[27769, 888, 4637, 146, 70, "Output",
 CellID->242443431]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32455, 1040, 231, 7, 70, "ExampleSubsection",
 CellID->655670651],
Cell[32689, 1049, 71, 1, 70, "ExampleText",
 CellID->120667488],
Cell[CellGroupData[{
Cell[32785, 1054, 391, 12, 70, "Input",
 CellID->213319341],
Cell[33179, 1068, 537, 18, 70, "Output",
 CellID->89197124]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33765, 1092, 233, 7, 70, "ExampleSubsection",
 CellID->44399],
Cell[34001, 1101, 70, 1, 70, "ExampleText",
 CellID->42640069],
Cell[CellGroupData[{
Cell[34096, 1106, 617, 19, 70, "Input",
 CellID->62423245],
Cell[34716, 1127, 2116, 66, 70, "Output",
 CellID->33434255]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36881, 1199, 232, 7, 70, "ExampleSubsection",
 CellID->81932343],
Cell[37116, 1208, 199, 8, 70, "ExampleText",
 CellID->60687876],
Cell[CellGroupData[{
Cell[37340, 1220, 512, 16, 70, "Input",
 CellID->404218665],
Cell[37855, 1238, 1492, 49, 70, "Output",
 CellID->9236777]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39396, 1293, 233, 7, 70, "ExampleSubsection",
 CellID->740978042],
Cell[39632, 1302, 199, 8, 70, "ExampleText",
 CellID->93529613],
Cell[CellGroupData[{
Cell[39856, 1314, 511, 16, 70, "Input",
 CellID->81884322],
Cell[40370, 1332, 1559, 52, 70, "Output",
 CellID->30647752]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41978, 1390, 229, 7, 70, "ExampleSubsection",
 CellID->64521293],
Cell[42210, 1399, 213, 8, 70, "ExampleText",
 CellID->141841228],
Cell[CellGroupData[{
Cell[42448, 1411, 746, 24, 70, "Input",
 CellID->254057507],
Cell[43197, 1437, 4334, 137, 70, "Output",
 CellID->729603362]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[47592, 1581, 222, 7, 70, "ExampleSection",
 CellID->9354],
Cell[47817, 1590, 372, 13, 70, "ExampleText",
 CellID->531982041],
Cell[CellGroupData[{
Cell[48214, 1607, 697, 20, 70, "Input",
 CellID->546955807],
Cell[48914, 1629, 74031, 1415, 70, "Output",
 CellID->27236282]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[122994, 3050, 233, 7, 70, "ExampleSection",
 CellID->28703],
Cell[123230, 3059, 209, 7, 70, "ExampleText",
 CellID->30166704],
Cell[CellGroupData[{
Cell[123464, 3070, 156, 5, 70, "Input",
 CellID->150980044],
Cell[123623, 3077, 307, 10, 70, "Output",
 CellID->554068008]
}, Open  ]],
Cell[123945, 3090, 220, 7, 70, "ExampleText",
 CellID->477652960],
Cell[CellGroupData[{
Cell[124190, 3101, 157, 5, 70, "Input",
 CellID->343638917],
Cell[124350, 3108, 253, 9, 36, "Output",
 CellID->310334492]
}, Open  ]],
Cell[124618, 3120, 209, 7, 70, "ExampleText",
 CellID->96543143],
Cell[CellGroupData[{
Cell[124852, 3131, 154, 5, 70, "Input",
 CellID->477464077],
Cell[125009, 3138, 269, 10, 70, "Output",
 CellID->171826864]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[125327, 3154, 225, 7, 70, "ExampleSection",
 CellID->5494],
Cell[125555, 3163, 131, 4, 70, "ExampleText",
 CellID->30562],
Cell[CellGroupData[{
Cell[125711, 3171, 242, 8, 70, "Input",
 CellID->23865],
Cell[125956, 3181, 444, 13, 70, "Output",
 CellID->16835718]
}, Open  ]],
Cell[126415, 3197, 331, 12, 70, "ExampleText",
 CellID->20700],
Cell[CellGroupData[{
Cell[126771, 3213, 291, 9, 70, "Input",
 CellID->32302],
Cell[127065, 3224, 456, 13, 70, "Output",
 CellID->69548406]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[127570, 3243, 224, 7, 70, "ExampleSection",
 CellID->16794],
Cell[CellGroupData[{
Cell[127819, 3254, 574, 17, 70, "Input",
 CellID->20463],
Cell[128396, 3273, 1524, 47, 70, "Output",
 CellID->528]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129981, 3327, 311, 9, 70, "SeeAlsoSection",
 CellID->15940],
Cell[130295, 3338, 1966, 71, 70, "SeeAlso",
 CellID->9868]
}, Open  ]],
Cell[CellGroupData[{
Cell[132298, 3414, 314, 9, 70, "TutorialsSection",
 CellID->24988],
Cell[132615, 3425, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[132777, 3430, 173, 3, 70, "Tutorials",
 CellID->558945376],
Cell[132953, 3435, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[133136, 3443, 305, 8, 70, "RelatedLinksSection"],
Cell[133444, 3453, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133844, 3470, 319, 9, 70, "MoreAboutSection",
 CellID->717411740],
Cell[134166, 3481, 173, 3, 70, "MoreAbout",
 CellID->351493407],
Cell[134342, 3486, 157, 3, 70, "MoreAbout",
 CellID->85784745],
Cell[134502, 3491, 167, 3, 70, "MoreAbout",
 CellID->44881662],
Cell[134672, 3496, 148, 3, 70, "MoreAbout",
 CellID->72283117],
Cell[134823, 3501, 160, 3, 70, "MoreAbout",
 CellID->318550763],
Cell[134986, 3506, 151, 3, 70, "MoreAbout",
 CellID->2330248],
Cell[135140, 3511, 175, 3, 70, "MoreAbout",
 CellID->190218807],
Cell[135318, 3516, 169, 3, 70, "MoreAbout",
 CellID->442761484],
Cell[135490, 3521, 128, 3, 70, "MoreAbout",
 CellID->871019911],
Cell[135621, 3526, 153, 3, 70, "MoreAbout",
 CellID->58877307],
Cell[135777, 3531, 180, 3, 70, "MoreAbout",
 CellID->139746619],
Cell[135960, 3536, 153, 3, 70, "MoreAbout",
 CellID->34104257],
Cell[136116, 3541, 172, 3, 70, "MoreAbout",
 CellID->217414225],
Cell[136291, 3546, 171, 3, 70, "MoreAbout",
 CellID->283856527],
Cell[136465, 3551, 197, 4, 70, "MoreAbout",
 CellID->537648388],
Cell[136665, 3557, 173, 3, 70, "MoreAbout",
 CellID->127884445],
Cell[136841, 3562, 179, 3, 70, "MoreAbout",
 CellID->119203697]
}, Open  ]],
Cell[137035, 3568, 27, 0, 70, "History"],
Cell[137065, 3570, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

