(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    350821,       7005]
NotebookOptionsPosition[    338401,       6567]
NotebookOutlinePosition[    339704,       6604]
CellTagsIndexPosition[    339617,       6599]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binomial" :> Documentation`HelpLookup["paclet:ref/Binomial"], 
          "Factorial" :> Documentation`HelpLookup["paclet:ref/Factorial"], 
          "Beta" :> Documentation`HelpLookup["paclet:ref/Beta"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binomial\"\>", 
       2->"\<\"Factorial\"\>", 3->"\<\"Beta\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Integer Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Multinomial", "ObjectName",
 CellID->17633],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Multinomial",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Multinomial"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the multinomial coefficient ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["n", "1"], "+", 
           SubscriptBox["n", "2"], "+", "\[Ellipsis]"}], ")"}], "!"}], "/", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["n", "1"], "!"}], " ", 
          RowBox[{
           SubscriptBox["n", "2"], "!"}], " ", "\[Ellipsis]"}], ")"}]}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19351]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Integer mathematical function, suitable for both symbolic and numerical \
manipulation.\
\>", "Notes",
 CellID->126685801],

Cell[TextData[{
 "The multinomial coefficient ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Multinomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Multinomial"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["n", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 ", denoted ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"N", ";", 
      SubscriptBox["n", "1"]}], ",", 
     SubscriptBox["n", "2"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["n", "m"]}], ")"}], TraditionalForm]], "InlineMath"],
 ", gives the number of ways of partitioning ",
 Cell[BoxData[
  FormBox["N", TraditionalForm]], "InlineMath"],
 " distinct objects into ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " sets, each of size ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " (with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"N", "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"i", "=", "1"}], "m",
      LimitsPositioning->True], 
     SubscriptBox["n", "i"]}]}], TraditionalForm]], "InlineMath"],
 "). "
}], "Notes",
 CellID->18625],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Multinomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Multinomial"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->555347927]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->652990462],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->244331290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"1", ",", "2", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88658836],

Cell[BoxData["12"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327531263]
}, Open  ]],

Cell[TextData[{
 "The 1, 2, 1 multinomial coefficient appears as the coefficient of ",
 Cell[BoxData[
  RowBox[{"x", " ", 
   SuperscriptBox["y", "2"], " ", "z"}]]],
 ":"
}], "ExampleText",
 CellID->400442616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y", "+", "z"}], ")"}], "^", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->243236155],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"4", " ", "x", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  SuperscriptBox["y", "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", "z"}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "2"], " ", "y", " ", "z"}], "+", 
  RowBox[{"12", " ", "x", " ", 
   SuperscriptBox["y", "2"], " ", "z"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "3"], " ", "z"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"12", " ", "x", " ", "y", " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"4", " ", "x", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  RowBox[{"4", " ", "y", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  SuperscriptBox["z", "4"]}]], "Output",
 ImageSize->{385, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->272372370]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2344],

Cell["Special cases evaluate for symbolic arguments:", "ExampleText",
 CellID->178486459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"k", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554573752],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", "k"}], ")"}]}]], "Output",
 ImageSize->{241, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->911247395]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"k", ",", "2", ",", "3", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20062039],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "288"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"5", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"7", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"8", "+", "k"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"9", "+", "k"}], ")"}]}]], "Output",
 ImageSize->{422, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->194487320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38519095],

Cell["Evaluate with any number of arguments:", "ExampleText",
 CellID->384162706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13539723],

Cell[BoxData["720"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373103295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282644420],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->72455335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->996659982],

Cell["Evaluate for large integer arguments:", "ExampleText",
 CellID->315449466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Multinomial", "[", 
   RowBox[{"10000", ",", "10000", ",", "10000"}], "]"}], "//", 
  "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154945223],

Cell[BoxData[
 TagBox[
  RowBox[{"1196775522075134250005422052024426", 
   RowBox[{"\[LeftSkeleton]", "14241", "\[RightSkeleton]"}], 
   "44196831380378825515494437719566080"}],
  Short]], "Output",
 ImageSize->{348, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->530031291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173966702],

Cell["\<\
Evaluate for half\[Hyphen]integer arguments:\
\>", "ExampleText",
 CellID->640061315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"7", "/", "2"}], ",", 
   RowBox[{"5", "/", "2"}], ",", 
   RowBox[{"3", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35310702],

Cell[BoxData[
 FractionBox["858", "\[Pi]"]], "Output",
 ImageSize->{30, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33532087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257459341],

Cell["Numerical generalization:", "ExampleText",
 CellID->30822883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"3.4", ",", "5.6", ",", 
   RowBox[{"-", "6.2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324413767],

Cell[BoxData["0.04258360109998583`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->649246]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739669181],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->861395129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"2", "+", "I"}], ",", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", "I"}]}], ",", 
   RowBox[{"4.5", "-", 
    RowBox[{"3", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398811977],

Cell[BoxData[
 RowBox[{"71.41977958655556`", "\[InvisibleSpace]", "-", 
  RowBox[{"72.67924006963655`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163918392]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->437153892],

Cell["Series expansion at a generic point:", "ExampleText",
 CellID->365075382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Multinomial", "[", 
     RowBox[{"n", ",", "k", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "2", ",", "1"}], "}"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27862721],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Multinomial", "[", 
    RowBox[{"2", ",", "j", ",", "n"}], "]"}], "+", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "3"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"HarmonicNumber", "[", 
        RowBox[{"2", "+", "j", "+", "n"}], "]"}]}]}], ")"}], " ", 
    RowBox[{"Multinomial", "[", 
     RowBox[{"2", ",", "j", ",", "n"}], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{"k", "-", "2"}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"k", "-", "2"}], "]"}], "2"],
    SeriesData[$CellContext`k, 2, {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`k, 2, {
    Multinomial[2, $CellContext`j, $CellContext`n], 
    Rational[1, 2] (-3 + 
     2 HarmonicNumber[2 + $CellContext`j + $CellContext`n]) 
    Multinomial[2, $CellContext`j, $CellContext`n]}, 0, 2, 1],
  Editable->False]], "Output",
 ImageSize->{482, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->778198374]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52626280],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->805077600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Multinomial", "[", 
   RowBox[{"n", ",", "m", ",", "p"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18325408],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"m", "+", "n", "+", "p"}], ";", "m"}], ",", "n", ",", "p"}], 
    ")"}],
   Multinomial,
   Editable->False], TraditionalForm]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->12984547]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8352],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Multinomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Multinomial"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists:"
}], "ExampleText",
 CellID->79608146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "5", ",", "7", ",", "11"}], "}"}], ",", " ", 
   "3", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->504928409],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2520", ",", "9240", ",", "72072", ",", "360360", ",", "4232592"}], 
  "}"}]], "Output",
 ImageSize->{254, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258382755]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6070],

Cell["Illustrate the multinomial theorem: ", "ExampleText",
 CellID->623913885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"KroneckerDelta", "[", 
     RowBox[{"4", "-", 
      RowBox[{"(", 
       RowBox[{"n1", "+", "n2", "+", "n3"}], ")"}]}], "]"}], 
    RowBox[{"Multinomial", "[", 
     RowBox[{"n1", ",", "n2", ",", "n3"}], "]"}], 
    RowBox[{"x", "^", "n1"}], " ", 
    RowBox[{"y", "^", "n2"}], " ", 
    RowBox[{"z", "^", "n3"}]}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n3", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172247567],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", "y"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"4", " ", "x", " ", 
   SuperscriptBox["y", "3"]}], "+", 
  SuperscriptBox["y", "4"], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"], " ", "z"}], "+", 
  RowBox[{"12", " ", 
   SuperscriptBox["x", "2"], " ", "y", " ", "z"}], "+", 
  RowBox[{"12", " ", "x", " ", 
   SuperscriptBox["y", "2"], " ", "z"}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["y", "3"], " ", "z"}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"12", " ", "x", " ", "y", " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["y", "2"], " ", 
   SuperscriptBox["z", "2"]}], "+", 
  RowBox[{"4", " ", "x", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  RowBox[{"4", " ", "y", " ", 
   SuperscriptBox["z", "3"]}], "+", 
  SuperscriptBox["z", "4"]}]], "Output",
 ImageSize->{385, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->526219232]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323400314],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"x", "+", "y", "+", "z"}], ")"}], "4"]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29662069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204336319],

Cell[TextData[{
 "Plot isosurfaces of the number of ways to put ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "+", 
    SubscriptBox["n", "2"], "+", 
    SubscriptBox["n", "3"]}], TraditionalForm]], "InlineMath"],
 " elements in 3 boxes:"
}], "ExampleText",
 CellID->204289743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Multinomial", "[", 
     RowBox[{"n1", ",", "n2", ",", "n3"}], "]"}], "]"}], " ", ",", 
   RowBox[{"{", 
    RowBox[{"n1", ",", "1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n2", ",", "1", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"n3", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53021260],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->213259137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268866017],

Cell["Multinomial probability distribution: ", "ExampleText",
 CellID->295173371],

Cell[BoxData[
 RowBox[{
  RowBox[{"p", "[", 
   RowBox[{"n_", ",", "ns_List", ",", " ", "\[Theta]s_List"}], "]"}], " ", ":=",
   
  RowBox[{"Piecewise", "[", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"Multinomial", "@@", "ns"}], ")"}], 
       RowBox[{"Apply", "[", 
        RowBox[{"Times", ",", 
         RowBox[{"\[Theta]s", "^", "ns"}]}], "]"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Total", "[", "ns", "]"}], "\[Equal]", "n"}], " ", "&&", " ", 
       
       RowBox[{"Apply", "[", 
        RowBox[{"And", ",", 
         RowBox[{"Thread", "[", 
          RowBox[{"ns", "\[GreaterEqual]", "0"}], "]"}]}], "]"}]}]}], "}"}], 
    "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773946705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", " ", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", " ", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"n1", ",", "n2", ",", 
         RowBox[{"p", "[", 
          RowBox[{"20", ",", 
           RowBox[{"{", 
            RowBox[{"n1", ",", "n2", ",", 
             RowBox[{"20", "-", "n1", "-", "n2"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.4", ",", "0.3", ",", "0.3"}], "}"}]}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"n1", ",", "0", ",", "20"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"n2", ",", "0", ",", "20"}], "}"}]}], "]"}], ",", "1"}], 
    "]"}], ",", " ", 
   RowBox[{"PlotRange", " ", "->", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->480768013],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57113631]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->457424684],

Cell[TextData[{
 "Volume of a hyper-super-ellipsoid ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "d"], 
     SuperscriptBox[
      RowBox[{"\[LeftBracketingBar]", 
       SubscriptBox["x", "k"], "\[RightBracketingBar]"}], 
      SubscriptBox["p", "k"]]}], "<", "1"}], TraditionalForm]], 
  "InlineMath"],
 " is  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "d"], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\[Sum]", 
         RowBox[{"k", "=", "1"}], "d"], 
        SubsuperscriptBox["p", "k", 
         RowBox[{"-", "1"}]]}], ";", 
       SubsuperscriptBox["p", "1", 
        RowBox[{"-", "1"}]]}], ",", "\[Ellipsis]", ",", 
      SubsuperscriptBox["p", "d", 
       RowBox[{"-", "1"}]]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->35812094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2", "^", "4"}], " ", "/", 
  RowBox[{"Multinomial", "[", 
   RowBox[{
    RowBox[{"1", "/", "4"}], ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "2"}], ",", 
    RowBox[{"1", "/", "2"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->412127704],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[Pi]", 
    RowBox[{"3", "/", "2"}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["5", "4"], "]"}]}], 
  RowBox[{"Gamma", "[", 
   FractionBox["11", "4"], "]"}]]], "Output",
 ImageSize->{104, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56106015]
}, Open  ]],

Cell["Compare with direct integration:", "ExampleText",
 CellID->602650937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", 
   RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
   RowBox[{
    SubsuperscriptBox["\[Integral]", 
     RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
     RowBox[{
      RowBox[{"Boole", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "4"], "+", 
         SuperscriptBox["y", "2"], "+", 
         SuperscriptBox["z", "2"], "+", 
         SuperscriptBox["w", "2"]}], "<", "1"}], "]"}], 
      RowBox[{"\[DifferentialD]", "w"}], 
      RowBox[{"\[DifferentialD]", "z"}], 
      RowBox[{"\[DifferentialD]", "y"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->493784226],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[Pi]", 
    RowBox[{"3", "/", "2"}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["1", "4"], "]"}]}], 
  RowBox[{"2", " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["11", "4"], "]"}]}]]], "Output",
 ImageSize->{94, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24690353]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "\[Equal]", "%%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154487320],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->109018583]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11367],

Cell[TextData[{
 "With two arguments, ",
 Cell[BoxData[
  ButtonBox["Multinomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Multinomial"]], "InlineFormula"],
 " gives binomial coefficients:"
}], "ExampleText",
 CellID->569247390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"10", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->460210662],

Cell[BoxData["120"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22377690]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"7", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358454813],

Cell[BoxData["120"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59918093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243509429],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions involving multinomial coefficients:"
}], "ExampleText",
 CellID->40279076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"Multinomial", "[", 
    RowBox[{"n1", ",", "n2", ",", "n3"}], "]"}], "/", 
   RowBox[{"Multinomial", "[", 
    RowBox[{
     RowBox[{"n2", "-", "1"}], ",", 
     RowBox[{"n1", "+", "1"}], ",", "n3"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274592871],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", "n1"}], "n2"]], "Output",
 ImageSize->{42, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54555526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643748604],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to expand into ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->344380312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Multinomial", "[", 
   RowBox[{"n1", ",", "n2", ",", "n3", ",", " ", "n4"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116867745],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", "n1", "+", "n2", "+", "n3", "+", "n4"}], "]"}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n1"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n2"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n3"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "n4"}], "]"}]}]]], "Output",
 ImageSize->{348, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215794002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->747390567],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Multinomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Multinomial"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->360211402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"b", ",", "a", ",", "c", ",", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385357238],

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7058096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8919],

Cell["\<\
Large arguments can give results too large to be computed explicitly:\
\>", "ExampleText",
 CellID->65254562],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"10.", "^", "10"}], ",", 
   RowBox[{"10.", "^", "10"}], ",", 
   RowBox[{"10.", "^", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64316533],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->130662672],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"ovfl\"\>"}], ":", 
  " ", "\<\"Overflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/ovfl\\\", ButtonNote -> \
\\\"General::ovfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->160092221],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149931786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287306201],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->590663712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"10.", "^", "6"}], ",", 
   RowBox[{"10.", "^", "5"}], ",", 
   RowBox[{"10.", "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46743626],

Cell[BoxData["1.701887413418824258931`8.502862651061154*^170303"], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34456116]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77840443],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377645812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78494453],

Cell[TextData[{
 "As a multivariate function, ",
 Cell[BoxData[
  ButtonBox["Multinomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Multinomial"]], "InlineFormula"],
 " is not continuous in all variables at negative integers:"
}], "ExampleText",
 CellID->566941073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"-", "5"}], ",", " ", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->774637896],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108613501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"-", "5.000001"}], ",", "3.000000000001"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3885154],

Cell[BoxData[
 RowBox[{"-", "4.000008333695438`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133072350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"-", "5.000000000001"}], ",", "3.000000000001"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->512295117],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->408779621]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Multinomial", "[", 
  RowBox[{
   RowBox[{"-", "5.000000001"}], ",", "3.000000001"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31538948],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->216112829]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24487],

Cell["Trinomials mod 2:", "ExampleText",
 CellID->33260424],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Multinomial", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "30"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106228383],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111562761]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Multinomial", "[", 
          RowBox[{
           RowBox[{"30", "-", "i"}], ",", 
           RowBox[{"30", "-", "j"}], ",", 
           RowBox[{"30", "-", "k"}]}], "]"}], ",", "2"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "30"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270483980],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->446975760]
}, Open  ]],

Cell["Modulo 3:", "ExampleText",
 CellID->551446662],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"Multinomial", "[", 
          RowBox[{"i", ",", "j", ",", "k"}], "]"}], ",", "3"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "30"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "30"}], "}"}]}], "]"}], ",", "1"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->511236652],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->163124546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31413146],

Cell["Nested multinomials over the complex plane: ", "ExampleText",
 CellID->28537817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"Nest", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Multinomial", "[", 
        RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], ",", "3"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"3", "/", "2"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289351595],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188524424]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->770291701],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Multinomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Multinomial"]], "InlineFormula"],
 " for complex arguments: "
}], "ExampleText",
 CellID->478760569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"Arg", "[", 
    RowBox[{"Multinomial", "[", 
     RowBox[{
      RowBox[{"4.1", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Phi]1"}], "]"}]}], ",", 
      RowBox[{"2.2", " ", 
       RowBox[{"Exp", "[", 
        RowBox[{"I", " ", "\[Phi]2"}], "]"}]}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]1", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]2", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97149888],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNnDGodUcRx9+Xm+vzFYaUdvJZKShCRBuFXSEiiIVIjKBNFIwIgqJFEMQ0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   "], {{
     {GrayLevel[0.8], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxN3Qm4RlP1BvBzvyFJphAaDZkiosgQmUtzitJkjjTKWEmmBmMq8xQiJJKU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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJyMunkw1f8b/00JlaKihTaVFilLWVp4lkSikKKQtFCSVqGiVHaFlIg20UJU
9iXZl1D2fT8rzvt9Kooi8nt9Z9z3PfOZ+c3cf5lxTqfX+/m6ruf1eF6H7LFz
+2wnCQgIdE4REJhMfl6Mfx0qt4kDZYaOuto/DijRMK916/h45OP0Ms+Vje75
vRfnlrHhKtmdUr6aj6E5P3aKv2cgL/BQqY52N9YWuI1GPaIRzbDRCmpuQ6xS
h96t83VQW3F3x37jHsjbfX05abQOp6/bdPIk05Ek1HKRVcbA0Od1fwZyKEz/
sryeqU5DOcLdyD2Pwrqk1MelOb1QG9RvylCnMKqq1f98Ph/nJ8657j/nzF31
80y4NwNyIc8k6353YaHJhSP5NjS6G9bvdhhqwctPoidV5KuhEpT69coYBxL+
Y9s3ZvARpSk/1aabxuTL2dnLOnlIOOU6VryEgt41LdnKSTR2XZaq+SJCY8YN
brl4TC+CXt3qr1pP4Zg3V+HRCj50a1q9/Ic5uBYb9ffAhh4cHttjFqzMx5mJ
c66aOCdv4pyR27SfmvgxsXXNIj2JBAY85/sdurGIj9kR5kc2M1kQ16kK29rE
wpzaU1pWcnzIP3W4b2TCQOLF5BAfrS608ZbfapOi4Sh79PXVQ+0wDNIxjDOu
x7Dz/FPf43pQsDc1un95I0yerlhQNrUQAR39YhV7WAi/d3PGKnJvkmbOrmYf
aGTqyCe+XUxBVjk/2e4fD/hStDbhN4WzPh835M0lnx8lcsctqhdWPtulf62j
8OvNXs88ch7Lrxvo0HgOvBjRjz6kc3FFxGZTlSIfa+0kjKdaM2GjYGPkdZKB
JXU5ebcW8nFJUe7yro42vDk6WJLhWoeFPUkLX5n2IGHbvzv3dOuw5F3CUsFV
SVCX1fWz3s2AS3HqKclXFGxFZfLCFGn8SlroHVVBwS907460DX344t2IdGsK
VaMMLS02jfsTeir9R087V/vZ0ZfbUGz+9Nitolq87Hm2tnJaD4TUPgauUOzG
9e4Iy2t72hDoeerTmDsPO6S2O9geb4MxN2FxRUwtOpRm7x4d46Iif179gvZG
dHm/WKLoX4wDi2WvaVSx0F2zKfS59Df4r8s1UxHk49Dko5XTkngwsh3+7ddG
w7/qgUj5Qxpe+2ea/dtGYeO7v7sZiRS2rb22zGcDjU858WsPllA40h0nsD+I
h7J7tb9e1FI4sFuUvrWLhqCmQICheR8uvxjaFXqa6H9TocWwnsYJ9fd+tgU9
WDZ/8UqbWTwsU1t8d2QLH6bJUkrR7hzUyp1q3H6Gi7Qr3C2f1vMx8u364/Am
JkIalx1ukGdC7sr+dbuW8LGsZHdny8ouhKTPVP2r2ALRwzrhC6P70D6g7y+3
qQ6P5JV+vi5LBHebcPz3bQwYTej5ZELPBxN6/s4sLn8RR+rUbltWC3nuI8zi
ZjU2D4kf7izrMmyGUG912b075dDSVfWyrWXjzc74GOVDDWDLFIp+3JWHeIck
G8NcJnqOb5/2+Vctbj2LbbJqf4/aEyvOsSQYyB3N+x0cwoeTyxG6to4G3RNr
Nv6Nh1tepiMfVvFxusZjviKp5xfLeQ+7ST07JTl/0KFpZCnzN1g/ptEpfOTd
jU0UrB3vm63ponHMznLXeBiNqMsLu61B4Vr4zaCov0RXB16qexSNSttlBU9U
KJy0WL2qldS1aUdcaU8SjUO1c2I0ZCgknBO21gMfTWUt2WIZNDSj3W2NJCmU
N5ueOBxLY+vBJykzvWmUG/MTXc0pLF85uDqN3N/OmFn+FTI0vkrbm27mUtgs
dOzrwktsPJLsChPOY8PuU2h5LOnP7xN6rp7Q8/iEntYfPUzUDXjYv8Ven/5I
wdD8ir/wSRq36tILOz348JSN0aC/0rgQcr+DHuJhTNP5X8IRPsJbTUpaC2i8
/qNlXzGFglti2997x/g4URrjX1NIY2CfM+eGEDmPmH3EqWA+As9dzpQmOn/2
kP0y9J2HY3v/Pu3m87HK/4Ok7gANXqrMrHklPCy462vew6/DuvTv3pVJaXj9
/sGx4VwGpvKeJhvub4RR747yH4mFWH3WUbH0HAsRvitqGt1bcCjgJ18ysRKv
vo0t+viGg2xpbnTj7Q6oZV91OWveiIpJDPHnbr0Quzw5T1WdgW3M7PJCVie0
LtafWNtPYd4Z5eLzR1jw6PAenj+F/Gw/8dtmGfFxh6xjK8LYkI7YYcobZkNB
wlvcbQ0fdJFxZMiUDrw2SEtmXWvA1QeOJ5jLe2E+oafJhJ5GE3p+9B09+/4V
FwG3OKU++r1oMf1XeUuVD7XPHomL9lEIfsFsCJtDY5+a7HKQ86gffieYoUbD
oyvRpe4IjTjWDeUGfwrnjZJ6NyzgQ1PJXMPiLY3ekTxYy1EIkw89HDXjG8rn
fv/SPkqDMcvLtiOdh89f3zTb1jXglL5x+If+fEyxOK6lKMWC1o+yo0OeLdjp
mbOntaySzJfO7OwEDoy9+uYHFnbAzNb1vXpJI5qt6+mTsb0wvOWY72HOgOXN
yj/i+7ugrHP/bdBiGqsVqGqtVyzEDYW5tTuzkJG2UfHfcj58N7ndSV7PRcKG
SG6ubw/yvbMflKjwoeU9+ClNvg8p1SvnpltSkGIHauj2kv7wuL3puyUNeZer
/lvP0DgdNX/SmqsUGqXkvcxr+Kj7uVm4gLxPNrYxp6uWh5QJPW/8R8983x0J
+RlMxBQ+tds1zEB/rp3Kg8V81Ph9rL3m0oekvwEdxpcpPJl24w2jmIawu4Nx
XiCFn7t2qlevolG01kpIqpGCxrzfVLklH1XPavoD82mYa3Zs8BOhcF1q7e7i
sAYYiminmS3Lx/39W1bpUUyIq1/RGXjZiqqf7sonLGugPjP7fqMrF89l1gSN
1HTh73PPD96HWmHUcejrURkePAZy7cpdmJhXGXOPG8xAu+zcmQvIfNHTKM1e
EUHq7IJha/Y/NkLlXty/S+otySVq17EfXHw+phjUn9uLhH45npI6H5zMp7WP
L/VBZcvrE8JOFKrDlz5/Ukqjzr7orQjhnt3bH4h+I/Wj8PS3RyKpH69VN1vq
dJqw6bAj5/BQCaQ1jZtr57NxPSgr53wPA4UzVT4YxnTjpvGiEQbRO2NCz4f/
0dOZIdJjWlqLw5MMpi48kYAszx3n+n90w30s7PSxNb34MFdZoSWNB1P91oem
WnwozAsI/BtMoaeoLDVwNQ3TmqoFUg2EE84bZ9Vo1GGVTuS0o6WJCLfwL0oh
c4HfkTqySacVhfzqZ9cSqxFhPqtz9UYu8kKniL482I3fawX9v5L5fztTOtM0
g3DGDBqqU1m42nM5P+AqE5db7NLsl/JxdoKXFP7DS08NjlNS9j3oaJ2T0H2z
DzYapfv7N/FxrPXIpVXefdjLOqqjSuqvaOfP5Ua5NPrMy79rv6Sg8+EZx4Tw
w7b1ItbjhB9KFjsovfzDh8O6l/s6BonvjTgt1cnn4eRFvQevbrbCeU2/066F
Nbjz/Y/e/iNc2Fim5/XuYuL124Pa93cycOuzqZMI4Zk7Q66yixZ/Q+ij2hHL
SXykvpw5cPUDD3LV06/7ZZL++ccTWTGZB7ZJaXMJmcuR5u53Gq734vyvM+22
y8g5HY3TdUn9u5aOzHzygobdRTWLytvkPDZRo9ctKAiE39ya5N+M2IohTtDx
CiQPyA43j7Hxolm2INOpG5NyXcWc0A6pyeqHvnTxsJaRwOy9yULQEYuuq1tZ
WL1UVFae9PXDpb5nVzZzsNZE88F7wjHb6ACXr0p8HLYLKvIY6cH2X+x2Lwce
hr/PG9uuycemf5t+dlf1oSrBe05FCIXMZpt6vac09NoDh8Y9KUQEN+QGraBR
scTg6KVWCiIGO0J3kM+rGZH7MS2ZxrQ631NTyXz8NmerET2nAa5/a1Z9eJ+D
G1vPbnwSyIRik3DHKd9WiHNX/BJdXYN3vyvNJU9w4SEZzGk/243Z29rbJda2
w+90ZkpgEw8LJ/RM+Y+ea6r3ZUdWsNCMmFfsJBZGPylubSYc/qPhyKHO93XQ
/rP6huXkVJQe959p84ABU4MLBX3SzTj9NwpNnWW4JG4zWf89G+KDLiayrG60
bnx/4Wgu8dH7VzaMkjo6sKTuadgONuICv/nEk/ksGXDB+QHhjFSFExZiX4hP
VvT3B3n1YpHlcJuVGh9iRY9quzp6kTyNtpynTSFd8WJJ0jQ+jpeHRcYTrpx0
4Utb7hfC1eaHIh2MSX3Ovvv7JJtCq9Coh40O6S+rTxdT31No87aXekDqS+6H
ht3VeMKNZW4L2paTPvQOurF9uBbO//LGDGd8QLeK7RVRScLXBk9OP+toQHa8
+DxIFWCvkDbXeiELvgpNftEBzTDcu12oya4C7faSwbeIP5UOTXoye1sbWqe6
LbE5WYsmxxV9qzlcLJvQ88t/9ETJb/MTVp14uHlb7GBVE2J6Odq1kn3wP1Ft
bJvNQ+OxQvM4BoUpu0zU920k3MN/8HllGweaq3Vlbk3qQazgm7+dpD5K6EV2
rbN70MSedNn0dy8OqJbNGSF+eO116hmVn73QMtr9ZoM+hdzEu6ZyhKMv58hl
p4bwsPzGu9eFdRTC0xbPGdelMaXjimAB4abENf46a3YSnz++Pfv1OwrN53+m
TSFcEtfEOq1P6jV8xKaIUiP5wULqVns2H2WnHj3lM2hs3rDhsVg7D8LBiqbn
DhEf+11eox6XhDcp+T+fk3m5+MOj7jtO9eg4tvToDsssXFJ4/j1iMRPrzZY1
nhivR0+jXGHv0hzw0x0jFD2Y0L32cdtK0QYc3Sb/4uvhHLQ79LHNvJl4Gxvw
7kl0Pdhqv5ofvfiIFQzjoXdgYs2Enucn9Ayd0NPp5bx0Gbl6DN3xE8tTyYDU
eU5hMZeBmP38w+vHOchNiGu03dqDc/vDtyWSXOm85k5myGArzHc4ajdxasCt
Lxv98oGLu/eG8m2UmrA4vH/29vclOLlL596laWy4F0X77j7dgC8vy68reuZh
jfwDD+MKJqaOZb0QetSA9Fm3NyWszIfs2vKwVTQTK1YNdCqrN2LwxZa6LMNC
zFj9JXafJQslS7WKHe82grnXkBHhWoSw+bqN/DAWpjzb45pl2wgZcVH7O98K
cfTG1SFhNxasIyenZSc2QJmj1/rCLR9r1ZtEfMaYOHFJu2Ty2XrcM9khVbUu
C3oF1eKTpZmYNmmOr4z4NzC3vu61GKOh/ezmyAbCRf2yfda0Dh/3ByIjv2XS
UP67Y+rnWRQUvi1inzegEbF0/81sOxoNM5c8vnOTgtWEniYTek6Z0LNHTuzx
WZLDRM5dVkgiM8j0hp7O2mEKknrtnn5kLkS/cplfT+YC6xLTy5jMhbclsYtt
RHm4NufC6hdknoSZJpr/8SSv21cHJkX0oJiymxVW04cP4S0ds4kv+b3c9Pf1
LzY8H8uGywdzsCRcr+rJWj6uyD6P4rxnQjXOYZcYxUBym/h1GzKXR0OXqUc+
I3NYcGb6vfp2sEymXZ+9kIKBagpfMrADQhdGeJr2jXA9Fy1ad7sXkc079AUX
t8Ilyvm98LlqzGhaLGW4gIsxqex8u/BGLKq0Eyp8WgSBwegpMc9Y6HKaf5pV
U4sVMkpOgr8T8MQjx/3wn24k6tZrKBGe6s4pGjkQRCP62Zl4QQMK8x31dZx0
Kfw45qKbIk7jQ96MSNchCsnGA28Co/pQJj719cHbhL90NA+IEr/vmtBTaEJP
8wk9d8+fcXe4twerH51ZZWVE+Ho4JrFtKx+Jv7peezR048CxmIKxoA4orihy
rj9JQdUr3z13eytYYh8dFBKqkXffoP+0ChcK71avkPlF8siukKpDv2hUuy/P
NCzkId75TokayXn6154L6E8i5/whE3dDlEbSgFbbdsle/Alds6TnAQ9pWud2
N5O5ditABqnFbNR2c+o/6nBgNa2yJkCe5FXvnsTBJAZKDVMLxfS7wev2O77o
GY0vBlLpMZrt8LKeqa6ztB7b3jE1joT1wCbulIT5hwb0CxxbWeqSj3lzVOID
Rpm4bjYcOkp8S5Cbqfc4moYKvaW1SJHCR0uxxWqDPOg88nv5+Bfh54Fzqzul
SZ6jjW4MMXrR7pxg67SDzIW62I4OUT4qcn5XSARzset6VqOiXC8KUPzl30Y+
tCf0lPmPnv+3fV3YxL6u/f/nvu7ZxL4uamJfpzKxr5Od2NcpT+zr4if2dYP/
2depTOzr1k7s61Qn9nVjE/u6/4fr5P/DdZ8m9nVLJvZ10hP7uo6Jfd3ziX2d
0sS+bsbEvu75xL5uysS+7u1/9nX6E/u6mf+XfZ3OxL7O5T/7OoeJc678zzm1
FO8WO+Vzcchgg1KAUy/uWK2avoTM/aMyW3g/z7Yj0a/3joBzPZaecfshnNUD
7Ri1uR1ED9nwGTu9NWhMEhf5FJVLuEL/7cir81xM9lrVnTbQg/tno1z1yP1a
xKrttJ7Xjn7ui8PpHXWYoZ1b7OrWg4YXqq29RY0oeiTk47epGH01F/uoHBaK
jy5Q+JLLx959d/R6meT+Lnl2fGzlkTo9cUlhPo08/ejW6AM0XJTpg57hFPwS
K74fP8nDmpw0D5NiCn9uWhqctKBxJfvtxpqZTZhPTzG8s7kEKlbxBzoGWLiv
mKH12K8O7N8sfd3hZNxebfPG7QoDkyWzvPSudKLGajNDcVIzNjq+fLtkTR+E
a+QTu+RbYaZ8rcjOqxo75/HPmC/jQtht4VWlk43QitgqGPWzEIe+vaiZ4c6C
Xl1fylIzPiaVrTR7S3i9/1IFZ/Y0CoGil003hNJo4+obHLhBIyo93+CmDQVB
KQvBFOJDdfpuN6/upnG/vV7g9msK3sOnYz3PU1B5dRMfFxF+Pthw5DmLwiSx
gWdiPB6sBHNyWT8opBiyjTqX0Hh3Yuqlxat4pJ4mpzAJb3XdXX5BxYX83rnH
a8ZvHkaLZ7RsGqRQb/Ln9zTSp7o+k+Ls7jXAsbtNV0ksH99U+mS/cpnYUZMx
EviQj9CK2OxVDSSvpZ69qsrnIUu38F+UKx+iqR8F1lWQOfErKuzJCA9zi7nL
S+/yIXn02orNtTSqYubdWtHPg9iinSOCs9txMCvbxLa+DlUzA4xSXHvgXNap
HOndAk2huth7VZV40GXgzn7HQcNUXoLkXRrTT39b/NyNxuzTMj4rTlB4+73m
8Ml+Gmd0Gx9LEv7ZIDeSokL6T79l4Zr7Fwhnjee61n6mcXCR84zSMR421yUH
C837hnvCizf+Gydz80tP4ZtkHm4urSvRUGjA5HlWgu8P5qL3QvzkxGeEB/75
LfEntB24dvc6VetyqG1m1wgTX6neWnWhZXEveLIJLOolD6mGBjJzSX58HaA6
Z3CsD6pfpxSvfkHuKVVmXbQfDQOtwMxEXyYydr86Ih7PgKu1bco1kqO1b4WN
3SW5IdU8ZMRWkEaQWe3rD1NpHDCTSJe9TkO+aNm3aHJPGfIygk2nKXw/6FG9
sIYP5QMhF9+R3DvuGTd9pJbkGFMxv9DBBpx1naoVcqoATzmFU9TWseDK019K
3yHvC/keHkJ00+FIJKkR3XaGTtE3MGhGXGn5aSmfcgyeKvmgX8PGaTuWbBWT
i/SdOwdl43oxTXBpIoP0e87kq03i63jIOSAi1plI/G5oWruvE+mzzrwT/6Jo
HGtcdOERyXFKSkGzSkiO2yxQtSUluR63apymX5+djf5qUe+x3UzMOFt0xW8t
uc/bvRoHezno2rl7fqcCH9U8/8R8XQ5uaUWpSkpyMVTBGnAj/rNT94tY0DU+
dsXxy1d+ofHcfqPQ3mEe/GpPXUjRbYKI+4/lnNESSK1xfLxCmo3PHro3s9I7
MV+wii4620zygIn75AN9uDTgMNUtiIXnbjpXdu9joUJipsUVkhOLHNU0hghH
yUtf+d1LOOrr/OFuY8JR3Uf+hPp4N2HOhtDWptZSWNo++DauywYj4WLR7ll8
jLjGsdLe0NDwyrrVt5oCbfpdPvhDHVoyB1WVRFPxY16ISAfJX7zMDUH7k5tw
7cDn3BfOnzG44sRFNzs2lnquDDDjtCHmyCylLO86OKitsDY61IMQ6fwLj/p6
8MyFNfOwMQ+Hkz+bdZF5Z3p1zPCUbheMa20dWuxa8DE9dsPuzD7MWOiRecGU
ibPP2/09zBhYWsz8rkNyVNpB0YQmIxqP5wlrbzxF47bbu6r7N4gPNzfsLDYl
XFByXYaZQ8PSc9dW2emE77Kuoba9Fn2xV0slg95Bu/Osv5gAA3qRV0b6a+ox
LWWVdg07G9Y6RR5aNkyoxbMOKJg1ImfrwySnjEK4hvbozr9A/LNoY54Y0c1r
84ZkhZZSMLLkI2KJboFZZVM7iD99mZqnoEJy38tzaz/8JD6U0S30ulKMQvTl
GYLXRkmeif8hYChBY+To98+ebvWI3Vdb/C4kCwr9nyI2rmDC/McDmXvZ9fio
XcuQNc7G/ZlJCzVMmCQ3Oi+mj9Zjrsh2sdSWTLDWSZ28PYsJ7a4g+rAKH/2d
3ZdzCLeV2J/cMl+aQtH79SVc03Ysnf710W/detQfz+ie/LoHB94klGSVdSL5
abHzrMBmvNSQ3BJ3tA89XyV+6l9rh+PsSV6XAuoRccrxfFJBDyYzfi0bZbWi
IezKFe3SGog9Oet1PoaL/TtqbvnvacHpjK13l06txHTqnEWZNwcr7vYEOzk2
gcM99Ofl7VLcXdJy30aVjbZN1qOScg04ZdnZIbwql+QYtzPxEeS5xO6rlVE0
Dvd1Cqs+pjE3P2Q8bROFlQXacVEJFMQtH55fqEJj37ddjvhMISL2anPCdh6O
7GItzsmg8Nva38TQgfTn6py/fzr4EGgzNfxDEx9WW7Va/SsP6qaTmy6k0BgM
aAnNIz5V0STy5+Y+CuOhvhdniHTih8+UqvtbmhAmECba3NyLys1XG1f3NuNg
aEPi/TdfoJjyrdEXHLQcvxw8iVOH4vS3GT+d0jBjJq2ZmcmA7m4VvWbStwVm
KyNZ92j8lh68d1+PwkCk8qOppO5eGm6kWX9Jzo9J/DN3Fg1f8RilGEE29mse
C0ydyoZ29J2QOSv5UJvx9OPTHy34E524etHSalgcHT9vRzjm5al/m5d84yHE
XfYsBkgeHyneNH0x4YI1BbaNH1gYczbTYviwoJ8qLLCV8I+P8ifl9dUcaPio
uDF+cKHllvTrKcnpElfeW/PWsfGg6IdjszEbCfN+/ZJaRXwp/sP3wqNsVBxx
sVwVw8aMmui7OoQn5aIZf97KsnD6xi7V1igm7vEyrv1ZyoebVcLB6tZuLPgZ
K+L8ogNumy7EG5yj8H6Pm+A5F8J79KFHCwq7IHL90L0LxHfqz592ZF3pQmBa
kJVVXgsu5JpFuXb0oXbx8/UZPW0oVtJW7PQnXNo1XvfXogd/b+n9ro2rx6wa
j1cf6z/ixnRmc64OExb7lwwv12rBZuM635C6r9i8eeaNoWscqDY1XPrf956G
8x9G/O97z2Srfbf/973n81Gb1/vVSP8fFTVLOkIj22h6imAAhdrRH83RukTP
Bdwo2ywKS453WM6xp4FD3rk745hYsDmwfBKTAYdZrDiQHGf12Kn1AMkFLaa+
PwpILvjraFnrT3IBL1pZKiyrDplBa7n0nlTQ9yOl+iIZJKd/D7p2kkaYUJjd
3PM0SvfsDxl1onBq3e6dK2fzkapxba5ALI1PxccUfIivmjkzWXNlumDnxef7
yLTg0tqoi80RfdhSZiI2qtEHQ0f24SuEk/Z1CAcwGCTXnbJJnPmrB6m6la/k
j/JwLmPrkYUkB5UHL7DyIb59xOn4/Ari299yvA5Xks8/uCpkeOELNpZtMR/w
n85BWOi1udlr+CibuPfc/9y72vA1mTCqAWZWJ+xrdhYgOCLjm+JKFhy2/G38
dpiFmy92s+MnsXDcasHag8v4yNYojhDaRub+F6Mlu9UZuK6aHFwnw0eG886F
Mzd146PMs/Cf59rwcE7dfTqAhydZ38PLbVvgdNGQdjpcCTffFc71YRzoJDoq
js1qwVTz2QFTN39FGke/9JsVB69W/T3RTPwhdztz7mbiDzPOu6h8IP4wte9u
UrULH1Uma1R7ymm0P/a0/Et4bObO5rST2hQkPOsfW8yk0aP4c2TXHwo3DN4e
SiO+/E/5nNT1EzRCHrvtDfaksFf66nhHUC8sCo7/mkP0yi1crPmSzOXFiT1n
RWUJf14YeL1pMo2bD75abSW5o2uO1uQPf/qQvTCBbfecwkUzicDxABpibcoH
urfVIfj4eoPT44nI9LY+bq3LwOorabwjlRSql/sliWjS8Lvgqfggk4K1ZLHu
k7tsyFSPWUTy2Jj+odVJh9xL/IRuIRO6eU/oVjF0zSywhMZwSefHcpLrlYwc
ak/spvD5okKs3bZ2DA8OxYrL1aNqqo610aMeWDgy1t251IjQTwKvIxYX4bix
0Z5PXiwY/Fb3FNVoxvwtHR3SOuU48NzOIK+QjcvZQn52D+tA32Kmbd6XAi+n
0fYrtxhQ/KiUVLS6DiVr1Gbmmidik9ZbzhlVBug3+5cf4vDxqNpvwPE74bf1
vTv6yniQ9Dycv6CYD8d8w/F4No2fF83fWjbzACN997EfxIevq+ztf0JD9sPn
5ccIx9o0bghRMOdj3SrPWKE8os/XKZyIqRSyfCednKdNw2emvPnT4zRuzRJk
Z3tR8L9/T1pKiI/ZT2qVjWJoSFQqXq8n+W/L/StdYYTb2me9e3V2A43176ZL
XCmh4Ba1SM+zmY/T+hm+K0kd3YvawHhTxcMmgS3BvSTHpzuzgxVFyTlLmvaF
CNBIp65/E7hVB5uYYwzromSINORLrHBi4JnE66DJD3mo1Vyb3lFPIXvJBjnP
nTRe9xQ/Vc1tQFhXmYHb23w8kqga/CfMgofcZ7VFIc2YLmLkaeleAc0+1XDx
yRxce+pnM1Dei5m0mm/pFsIHFyp81s3hg9dywvHWvjbsdGiOOOtTi7bXMdMX
D3AxGDdyY28hF3O/XTbzdOmFiklj0xrCq8td8rzvktxwt2lPXksWF2O37FP+
9322z32fhepzaRieTXs7up9G7QL7gROPKNyrOtsz3s7BATpY7+oU4rOTK4r6
yFwQfjUw80IPD3Lv5ZZNIXmKGgw7OlWWhvZE/WhP1I/pRP0IaUU+7pHoQfCV
G9NVfvXiTH5byjd1Pvrmle8S96pHzK6TyVKVWZBPDDNUlWdC4eetCq0xMm9L
ewRiDWk0x35PehBDIfjEdH+rM+TfXdewlyql8T5JdWihAMn5UQqh0lbEx5bb
34rNp3HiTuZtWxHSv7+GRw/dJH5MrzCWqqSxaNP+2NQhHg4tVWd+vcTHvMje
8uAyGp+f3rQuHeVBQzVeLMGNcHW+q7w3mc/evwNZX//wUPIlNZLO4CP4wOTb
T7ppuP4ck6vu4KHwKz1daVoDdJ9kxY045BAeKXpS7MPELytxAzmhdgSuDlpk
kF2HxrDZ2kNnexCpWGQ7tKcb+5mJg68z2iAvYdBhFMvDbCp4clktE5MsAn2k
lzPh/SptgcIS0teuShIdJhxYW8Wk0XJcbJlSX/SJ+ExPa3HLoGMbtgeftV2T
Xotensi/U+R+esPPvD23jI2V3R75dlps9G6PG6olnLApPkX6jhUDd9Y3h0bY
dsGFrVDzSo48H0cmQXmcjZPdYtMWRHEgVjfTqG0tHysn9B+b0L9tQv99/gKP
3pI+WUzXaVRZ0zi6r61a5Q6p65rZzEgboi+1KbzCkcY00Um9Eq4UjvlqPgzM
JjkvXnTpZZK3zMLvPOzaS6GpJVXWi/RZrfzlVfabSU5XGZ284BMFqaWy9ibk
+RYJzr4gnkTjwzOmruVCCmvmznB+94rGOlVu1Bov4hub3M7HHyR9UHl3rVIu
HybaJdtTmKTfy2bkC7bx0H18htH+YD4KR/t/zakj/eb7kjX+neSG8eW9p6Ia
wWtICZqbU4SQ/KHKPy9ZuOB6dChgdyvuiy1vd82uhtbGPIEIDS4c7r0xlP9E
7n+6jCjNoLBp84ffw+T5f1ruPZRp0YIDw6qn/6hVIqbDa9OMYA6mPN9htTi/
E4sdHj6Yf6MZKaM5/Y8t+yC+F/v03fvwqcBQc5sLhcwKkdW7CmnEft33TPYg
D7rMjpbNeRTytJtMNI8SHjHJ0lir1As5B63s3Hweotd1rr9GcrTmx9Gkymoy
Xy7/tGkic6HQVGC9O+HZgGMeDbHBPNi3vh+QrCOfo7rqc58eed0ktLWd8Fr9
kTVZmoRzrJ91fftCOKdqHuvxv6skTxT+WhTuTPqlf2GF1hkKnu5fxQ/PbcbC
UCHxKVVlkHwYcGluPBsLEqubLF60Qt1EMFjuQA3Gk6xsjZ25OBDrLfj+ZB9u
NNYKi52nsD0y+OMg6ZuVTu8O7ucQvW9MqjX+TuHtvJdP/xJ/OJTRYOlLdJws
kKbisIP49pTJAuMfCJ8KTRv8/bcTGZeiQx04zTgzc9XGYc8+LKgaf+7xjo0N
y272XVzCQW/J7hNC8nyE+Y8eNt5RB4M3wietJZIQ4rr3t+QuBi4k+f1QbuFA
+lnR8cPjXHCTMoPriF8dVHFY/MuuGwV5NqVB4u2YV5P14vwXHix51ryLzhQC
bR8EpC6hocpOUvnTTeGoTOsp37k8OJVKFVrEUUj+NBz7/DqNh+GrouelNmHS
nBKLQrfP0BCSds08ycbyk43ecXdbcETW/uHi3koM7vdKbk3moNbV6NoJ93qs
TugILgjPwsaElbU1JK9JzdPMNSdzedTvhk8GmcuLZ5vouZO53LH00Es4tGCR
xXHpc+crYfHp2L64SA52ut63ttbvwvr7026Mk9dZ3LER6499MJh4rocTzzVl
4rnOvCrevOARG5rLi6eJj7Hx3drpqg/hhG4jZbX1g3wk/5XxT/1F44cy7V5T
wAPff39Bilsf3mu+TZpJ6tMnxCDNn9Tn+gcF+u53+bjxtOy2bC05Z4tw+M5+
Hu6uL6k9RHLFJLkPv4T1aUjzu1Y5x5LzCwhMlfRogNOJg6I/q/Jw4Gu+4/NW
Jq67fM4u9+7GIg3LzXrX26H0kG+sPMzD1hsnbip6Uyje8O/PrxU0PG8nn6Ba
KKzzPl5xx53kox89OhddaMxzuZqxwIHCp69RfrMtaSx0ihwYIPmtzXxDd8BV
MscN9xyZUtuKUt8VLsJvalBrtMy5OoyLbwmnVjRkN2FJptlgQthn8KQuzJN3
ZOPUqUHvqf4d8Cu9+EL1WCPk+QXmfz16wZnQIX5CB/8JHR5+OrVkDtG5bP2y
wzfF2uEUamGzsYKHP8Rah9bwMHz6pm0DqWOz0P129GUaRX5G/uWFJNc+F/Ua
bueCv5v1yozUIXXne9q0B3XoK85Uqtuegq/XWO41Hgy4FRd9DfVrR/S/QCGj
mHoUKvk8y/nSA3oRBjQnd+DuF/2djS4NKLwZNgPLetF6ebxIIZpCyH61omfr
CZ8OuMR/+0KhZnR2zrnDNDQ/XyzKPkMjZygix+0K4d7u1MOFxDeFC9IcFEnf
f7qzpdjhJIXbr5Kr1BMbcHzuzOT6q/k4YxLxfM0YE/KC2w6VO9XjuMSO3m9W
WTCcfWt5yWImbji7PjIlecxmi6/Q7vAqaJjYe1xu4mBXgvflmxpNyMtSifKs
KMHGXf961kiwYeu7PHKnaieSP77P/hHQhOFJrl9Mh3txcca2KLeuFkh9mdm3
b1I1nC5FNlnyOTC/tOH6gksc/GC4nTC15KJMa0n2jfV8DOYyb7QZcaHEFE2Y
ktMDftVtSd8NfCh3L5Y5u5SDYVtO+o1GDiLELHSfKPBhO1J1RcSQ9LXqMrVg
kp8FFZ6rD/+kUOGYs+rWsx4cOPWXa9LSByMHl/71W/gwX6qa/WAjjZdyD38v
JLlP+m6DdTnJfXMv35yvercPrNk1dkFuhIeSA9RWknk2kutqrrWcj4t/Z51I
fkeDYRuY1LmUwofrgZuPzaIwxzMoUfAfha6vzssJtMFUy637WjfJ03FP31fy
acQXL10x73/+c+xGZHAzyXvbviz7Ekpj69/uM6Ykh2jHBDUti6jDZ42jeapn
UlBXpPZ7gRcDb3SC57Vx6+BquW5R+c00nNnSZTblIwNOJk3b6ofrsHp2nV7u
lHRwwmoELD8zwONujEt83gARS9rXens+qPL6F3f6maBWvNRRrqjH82OR6q2p
2fg1In3nhiUTjcvsS7SGGvGB++T+Ak4xAp88swhnsLBG4vXMnZfqwH04XME5
nAz/IvFVZfYMjHesO9b1oBkzvE8p//SuQA+ngzMuxMGFg7LjuS18zJpiUxNE
+Lk0fNF5GcLPLdIpgcePslC6a9rxzaIs2BvvMztD8uDCP6prAlp74STJEfq7
jcxHOeMiJTE+xLr+9DGHunG2PFtESqgTtcMeO/IfknlXsjAic1MLdu9oSlMv
+orHYTvE2105yHLZe/o30W9yr4uvP9G9WH1DhOj/cpyOPzuBzYHmQMCcmlk9
KD9q+nCuMh+9Cfvfjr5jYXv9nPm9nixE55lvUF7BhxN/3oq1hN/3p7/sy0nv
wuCvJ29adWnIz90/I9O6AW4lBeKDlnkQnb1vhWIhE/NGk1ed5jXAfXZ2e9b2
ArzaEOBgJcfC2izTg2rnG/Fx7pmrgnOK0NbFVbe9zUJjfZvJK/9GcJZmNP44
W4SDRxxrh0NJTg5XGjD5UA/B8ECpwZGP+Ggy5cPjXUxEeSn5hS9qRGfI047U
nwWIkJDr26/PgjnH4/zqF/XYGCg5cjn8I04G58S80WIiLUw8qk+2Adxi9YG/
ErmY8+ux8sVwJs7keCsPvudjJN5sxvMOGkl9/9zrGTzMSO3TG/Tn49azfgf9
Ghr9D3y4Jwd4WKa6XnQm4eZT2Q+4u0NobCwf+SKqR8FlQn/hCf0DJ/Q38Ove
YRDKhmDjn5UDQ2y0zjiue4HMnQv1pw8MNjXiYtgTg9Jrxfhjd3GV0RcW4aJb
2Sk9NKbI5mQ0R9Cwurab9if5JosRGPOJ5Mty3pZ3Ids5aA4sMvMgcz+qxkug
8xeZL5pbJ0vaFWDQ8I5oqgILphFpL+uvdEAizaJVRLcRSobnXMIuk9wzIFD1
/nUb2h1X6/rK1MG4KWL+33U9qK/zje9a3Aq9tmBLv/PVaL4++WjvAi42/Oxl
xHxlYPJopcVFl27UR0y+9KyI+H+A3x8l+2ZELNT8Kva9HOMF/aWGXDbGJN7f
y6lvg8qQm0y3fR3Edxc2v9zTg9qXM6Y6mjfild8yqiq7EA+bZ74dvsDCkLv9
u21Hm3HvZVz4hbpyLPrg5JLRzcbOUx8L+sf4EBKbnhL1m4Z93O5j7BweQqxk
Zk3PrUfC1h1Clkez8ficftzgPiYy7//5gat83DYfnpZeQWO3yBw5Npmnacdk
pfbtoxEt+KVaxJ5GXO14uMt1CtdZnasOTyNzQeoUX9SEhsdD4dUpTyn8EXCN
dh/j4Vm6yaUjvylscNZ7snoemRMT9zJp4l5sJu5lXuXs8cTSFjixFrH6Eon/
3/qtF03y4alFb06HSfLxuywhsDqW+N1Amcy5VRSYu5fITY7swwGf5L41N8lc
/240NJRKI20obMso4ZBPEkOaI4RDnt2oVb5MOMQ498dpz6/dODVNUXCTUwci
tHZMi7SiIPx6WEFbjAfu3XWv+K8olM+MFtxym8aMp2NWX7/yoeBv2XyfnFev
9Vfy5Xoe4ix/cp0Od2P7OuF9ft/a0BC4WWdeLg9tOZaLY8+1QX/dK9XFWbWY
+lC1J0K4B/Pebbs+6WQj6pbOXiD4sxBhKts8+G4sXHWOuJD0jeSgVdKiVYSn
H/xz3bjgLYXYJd0ZRdKEd55fal8mSPK/YkvtNKLvyqXaLuWfe7Fzg6CbONHr
GHtH2QqiyxnnxisblfogNNWjPeAwhZnrZztVc2hcXLR/v5VkDxqXwD/3f3Mx
VbJ7kgYfX7qefbHR4aJwLFzgwdserB7ZNHcnmXetE3rum9BTeULPse/frmy9
zsSLax9Lt0cyYHeo/63WIj68Jva6qv/Z60rGP93iI8FF+LHZc3Ye7MHnbf7u
c1X+v/2tw3/2t+0MbuzoQAOer/Zc53+kAHFdtjnH1rKgmVuZ1XeChknAb5Et
52g8mpygt5zw9O659hLffzch81LQ6w22ZfghqRSU/JD9f927Ph3/7DDlcw+0
fP9G20vzcFrAwEZmKx+5/7hXqu80Y6vryG3+6QrsfBYjYUby6i4p+UD363w0
df6UkP1K8mOqQ/nYbx6s8l1St53uhP5FSyPx3ibsk+ufG7y4D2vpIe45wqkz
s1nnZtnRCBGMd7x4i4LlxJ62YWJPOzKxp70zsY99OLGP/Tyxjy3WS/d5/5cN
q0rq92XC5Y9DXRpKSF7OSHVUeWbcg2/a2zeFWPRBZ9XloGObyPya0DngPzqb
TexXl/xnvzp/Vnh0pDMHf38+cR6y4WKTW5rqA8I/xrdvm9S8Z6IgUf8lxWNA
fuC2yP/+Xsh4QueqCZ1/Tehsfkr+z499zdimf0YxIaocUyMMQ2Ib2RCYF7ep
7QYfeqGjb0OJbuYPApcfJbodn9DNbEI3swndLLqinqePN+HPo+Q0HY8yaBxd
82vtYzYGxeyf57g3YX7AFiWD7FIsmD1uVreN/f/qQP9Hh2dC160U7XhoDGE+
4hVRuJyz3q/fggbrdL74yK0+DMybIryScKr7m2y/j3k0tmx3aB342oaMlHlq
4tZ1eBE4sqprVw/Spwo90cpvxCGD7MZyhWJcYA3dPJjNgt/m1zvfptfDef3O
wFnrs6FDb+4p2cPE+JUTwmOS9RBZykV0QToMn/KuXWhjQDZKVkOym0bqmqHI
PeGkryuWvBrUoqA2t+NZZS/h5vOGmWqRJJ9pKESLkT5e16xYMkL6WGZh3od+
4m/sxMRwbeJv0TdmSC3YQeZpakjpvkwac777H300m9Tzp8MiY+J83BmOD9d7
Q4P+5Sx8Yw2FnpwFum8X9eHCo+vOh80Jl1/PMFz8jfj3wbCUhVVNWKP99KdW
02dk90/7MekqGxztT9+qjrchtNzVxPNlLT6JDcjp/ePC/aNCXFBnFyZFOO87
ea4VpkvHn29awcNR9aLjAmeY0D1c4jzozkCk//dt9QsJ54gLjqo9bkL/kSdP
t638jLcmh25rmrFRIrzsoE8rH6b+Xga1/9tzGtjIFlTyoFPsru69qBnGFks+
Uz1lWPGstWpxIhs/ioQsg4p5yD2i/T6DTaHZcauyuhLxv90P7zgZdeCRQNSP
Q6MN6JdWNaoy78Wx66++joz2YZKyr1FDFIWBe2qGc/zJ/dYqf4hoboRzr7KR
8PVi6E4dOlxIeEDvhMmYFPE/TmD/+1fE114bChzwnUfh0i0PdQ5NwULab5Mq
8WHVi8ENPcSHh0Mu/xOIIXNSYqWIL8mNRexXcQCNvGqp69V97VA+/nbuc4MG
aE4XWWEj0Ys1IqEDS7SZUDE3SIrfzIAK26i9S4YPN9mA0t3CvZhtW/jb+ToP
m320yr01+dCvfeKVWdGHqtt+l07dI89rH6q14jmZn+vmS5voUpj29MqdN+I0
Li8VsfIdovA3UOL9oBMN76nR9APyk6N+nxo4S8F11qIswSN8ZJuJ7I8qoBEb
sebhfGEKdb6BQn9nN0A+OG1MNjYHqqmHnv28y4ShyizpfLFmXHge+jIioQwG
pXXBB16y4Wsv4J3NqCe6xjbE7PuEg7uPvTR3YGL+t0XjirfbIblJ3VjxUT2e
7J4fCOKnX+nyY/O+NWO5gMexjZ++QFDFdF7KDg62ct3P+A43oDFpNHiPcwEG
rAzcRhVZmPpcvlx3OYVH/fpKw5NpVGktn7FFmIb2R8uH1mak3gQMrSNutYB6
rjn3VlEfNtb9cRmor8O/B/Mdt05Jg1Nlufq5dwx8XtS/KGVaJ+TUzAbo7U0o
lW3jn2rrRfPC9ZG1QeT5vzUr+5N8r235XoJ3jOS0qcsel/0lvvDXLlDBkPiS
VjJzy0sKz611Zw3RfRBukKxzf0xhyYDzmW33aCxb6h+sq9KLZ4ObjJaRejRv
v3rVR4uPuw0VLVcKehAqsa3MYxYPb5fETf5L8l3Vf76/k534/k7isU3t+1f1
6EzZfXww/SMeZqq5Nm1nIr19+NAdaQ7EaqqOi30l+dY8b+AqyZU75BWmg8tE
xKSmHUdIHWWc5cQ/WcKHhriayoFzXSi4rt0n+K4FH5V2XZnR2Ie6dYuOO3t2
g2v+9MI653Y0RLTPpgZ5kE9etmnIlZzvanbQugoKQZ96JXwJty0VSt9rSHKe
zhO1VcY/u6Dx66T/N2sat0pF927Pq8e8beeTPttnQ6ZALqXKlInUzfvNTSe3
wadeKjZvrAbxaTuMXbLIXI8U2+b1twWyUx0XzdpQDZH5516KC3KxNn6gzyyS
j22Z/czcRsL1iYtWz6J4mBKrsW80nY+jJj1H9xBf9GkeqdjSSThq5c0ZO+P5
OHegdqNtO43v9467XGOR9/tmxn73r4fjjke+v4ayIN7+LMxsPRPhOyp9Y6Wb
cGG/7IJPx0tw0P6dm9JfFj5Li3/Mmt6K3m9dP2BUjZU/6voviXERXJ0YmzG7
HRcD3gy+aKhD3+i6lI1XerC0PuD9izoezo+GG57uI5wavL+ndw3xmR1p1y5+
68TD1SuE+r42Q4EKuOB6rQ+/Cxd5i43QOHtYJ2aI9GfuYZaa6QYKZnnGGaNb
GvEvsHiF7eFCrOlr7flgTXKeYLTyOOEMkcyYlibiI5FzwpL+9/dTdLnprPW5
7biv+bPlumAD9uw0s7Yf6IFPdVrTedN6eAmPbx1zykSqUT3rgAgTMbHTzEPE
KGzZuYVtN0rhh/ZU4ZMSpH4ZL1h96RT4Enbq/qo05h20Vo4ppHDae1O2L+Ee
F3vrnIu+hINd3Z2191Pgbol8KuRH8tfWI1+iq2kc2H/7pO5PHiJdHlStXloP
pZkZ9fslMmD3YPERAxYDd54tk4wfrQN99yi8FqRDMfqzt0U5A68171bv+ESh
T75KzFSdxvmN8S5a+RSEDmzSPe3Cx65tR2cUlxP/bdmgteYvDycMm3te5PZC
sEb5j6AGhZRfg0la8/k4tfRly1o7ksOuvfihJ01D/LPstB29FFa6HajJMSc5
rz9zmo0iF3ezHOd3r+ODT61Qr6/pgOysXNWpXY2QfdI153xyL24XlhVp2PfB
wUfYLOg8hfSNFaY7v5D7qdZTvvijD4OV4qavn1DovfEi7wPxhYj1y5eK3enB
p9wk+RlZfVgUvcv602bCz2sW3KcPcKDI3EZdVOBCJtHRpYH8v98PScx42MwE
o31VyBkFJsTUT/3aQ/pxsDzDKiiyC0t13izoHWnBhcXBVcsG+6B7JHfmw2l1
OC+b01Pv9QEr49t91ZYysJVhf3jFzS68mzJtzvAX0jea91PuMfvwemfy2IZf
DJyo7Q9wz+pGmZ2/Wy2ps82p6/8qkXN9HFd3tEijsacbHQ/nEv3SxOLcqigM
KSi9ttMkvy92fSqZSUGOndQ4l9zXcbFoAxepdKhujIjuL2Pgfp/EZVuNNog0
7IOIRS1cB/RKC7u48P+SpDCb+I3F5ZWjMYk0GPaWBryFZP79al18IoH41rzZ
jnY+hLtvD/LjDhCuWO3zriuOg5zvYq4/Uriw/FKxpViRD5GtR01qJSio356U
UjNGIWmr3uMbM2nM2hD7L/MeH2+892wNqKOhH3P+5ZHvPOxr1znjfpOPwox1
srIk9wtybcteDvHQfmZjdWUUHwXyGVK9zTTen0w2XtvLw8ZfWfofDjRi2vka
0+K0QryuNp+ff56Fsx73Nt5xa8Hj+bGaYfGV0Jf2Kqh9zcGRYLvYlzYdUGzS
1NeSbsRLwYWX2cd7UaEZ/TM2uRsRB/7eNZHugKfJztEdpB4vvkjjmD4g/hZ6
dFfXcC30nz4SsVnag3NKf0TaE8jcyEePogrJUW/t9eQ+U3DmurtP3ksjRchW
Npzw+7ztbYG2HhTuGTrOyBmg0SD0huX9lCbcNVfxkRqFXNa9i3feER62yc9b
1UHjjcYKGWcmDzuLb8X+bKWxZnxqb9hDGmW3jsRv307qPzLlaHt5JywDPSdN
DW7G36LCosvH+rD8WvjMzSlNED1qW5N35TNeh7l9WnSSDQ8FzQe7e7hIiqRC
DyT24ujc6Ja/anwsWJbYU3KKD1f5gJOsYhoL5kSJZwhSODM2NOvNXzLfPe/5
8IRzkCHhuy7InYmll8J0Dlk043Bxntu5j+WwabEw6mxj416T67lz7XWQcc8r
Md6UBuZR12tJyQxYeDW9cVvSgEcnJ69aJJCLtXzJ4k8PmfhhLvdrU28DjqR8
+bx4cwH+5dmm1C5ngeuy48Tco3xQkgqD+wpJLns+7deaKRQmHdAx99vIxwEp
ywSXFBot6qyTSxaQPF5tt9PiAx/N7G0F+UQ3K5fnqq8ZPJzlVqjrq9ahTNkL
le8ScZIRPmuTFgPvT3+gB1QbgBU5nw88zoW0xtdFPq+YGHHfbrVubwM+fZN+
4rAsD7dZrdsC05m4sTBrxPNLPUKmZjEkc7PRH1lqeNaKiSPS2kHz99AI/x5U
pk/ud0O/V2Ulud+dW2o11r7vxIu18t3MI80YE6s8O763D7SVsoQ8mrD1z419
8cwSxMy6QTVJsrHN/vz3lA31WNplt2hXeAaKzj7eJ9rPwKwSAc7Ti6Svl4/k
rS2jYcN5JWM0Rub1bpkT5av6YN0zzfeTBYX49zuuhfaR3DlUbD2Y2gzvwENb
BEcqsLf5ZuK2hRyUPbLJ1U7iYPX9RGZlHhc3B+cc/EH6saU7xtmL5IvbhyJM
F5N8Ufam2X4dyRfNAlT6c5KP0hfOOylRTHS/eTMvh+SjrRov346kMNHv0fhB
7ScD5X9/rLxOcl/U0rgbxp96YLc9+ZPqVB6mz9VktxPOWXVs6MhVby4u/hXR
+SzVi43nsptLyP1FPNj30+hpM4yCVqeWvK7AZP9D+i9I7lx3vOuKdicbClVm
F9ef4cBs9lVpGZJnVTYn73tU1IPmu+//9UnyIDbJ5qQIyeNCD5WUHjEa0ZK1
ZM2eJ8W4uDzkoVQdC8q7NvNLbpO5tS220+sKjXfLJ981OkXy8ual/AUyFCp8
tutCkMaT6pFX7Kk01H4IKOfokPcn1SV5nKBhwNpQcceTgpO564fAnm5cXbE/
qaSyA71Lgner3qSQ7OcsnunRhTnZah5axJ8FOSd36xJ/phuWbPES7cCf4fXl
k282YD1bNO+XXC+Shb78qX5JeNBVdJcW6ePQ3vbwI1zCiRpp46tl+bDfK+on
+I7Gvz1OL77KUrgTyUP0NT6efrX0WUfm00OrO791hnnIpE2SrsXQaD6w8rej
J42QxcmBbw5RkGjjZnLW0xh6GVugfpj45OcQNbNACppx9XIOPaQuowPW50XQ
iLsuwH5L7jd17WX/B6YUXt/e2ygpSfTRTt0Y9oPkFQvHxiDCwTOrEnddcqGR
pO9qOd+BwlzrAj2WIqmHg8cNqpJI/jx3rUDnEo2r/u9b2vSaMUksSX35tXLI
lBk+6apk4/LUM7P44k3gOXw4fVKrBCpPRBtjfrIgEKy8aiigDsK27beeT02B
3bj1++XXGDCWKbLNuc2H33thPwbx+YJslz3RhEuFZ3CzDl8ifS156YQDqf8x
r5VPhkd5EGB5Gr8350MgbFhbieTzt1WH9tlMpWB8vGHIJoCPF/9K9jvW0Mjs
C3mjPsDDSvcdrkG7+DDuLJKW+0iDVx3Ws5LModcxaa7Ldfmw3ipiYZZFo06h
KnbrLAoHffc/YU5uwHjLJRu5bTmY1diXYH6b5KApMXcTTzEQK5N7rymoC761
Ut6ZaiR/ezZXN1g0ok5q80jc50JIlO6YdcSJhT2vZJeZC/Kx0X69jG00jeHZ
T4ZnKpFzRr7TmjlO+uqr5t0dxD8cfnBnF0eTPtaKykiW4iN3ps9hxTgad1J8
Pn1fSeZIQUa5qgof14Pr5iQm05DfNkdNXprC45FDnjZkfqzeX/H+xC0a+xz0
2k9YUVjGefBgmOjzIm9MWJ/ok5UzJAaiz81zD150+vCRE7q6cDvhOuux7zLl
hOsk7MwvjhmSftp/YfuzbBrbXY2Z8jMJB+k5MJ4X8MG4YfizhUX4YYm5iksL
6W9praCNhCerFc/l7iE8mf411nGQ8KTru30d0tY8hC8UqtYooP5PV2ceVtP3
vv8oVEoiojRThCYkTTcaEJK5UsgQGVJECJUIkZJIRYMyFNEgzfOoeZ6nM1bn
7BOhUim/9b4+/fP7/tV17euc09prPc99v+591t4H8/Ov6PiTvLD7amPrhCnx
v/hTsRtPUli1YzHbx4sLh/saZ7saKMgIXgz1D6QQ2aq8e9yIi5UPPgTcnkdh
4cb8Q7l7iT4FrGaKhhLeaPnSVnmcrFcKenQLybzfHzv2k5+L+AivGS+oBhRH
7ZmxPCwLNu8hPXqRDsX14wcOirDgHHk4TecrC4m/pYWWE46x+f7T9MMAB79d
KhUcfxIOVlW4USFDwUWp0aVqGQVlOd84daJ3+w4P1Z8O4KI7kS0R2tiA1Sdc
Mk0nMyHqzJKuPUaH7ap5QXwPGXijHNaycDsDLuM+mkf+e17BZ7lSWycezkfs
23m2lMLeYcd3uyc5GOVVfujMbkFy4z/62KIKeI2LW3gpsvDGbEvK9vMdkFZ6
NS57qQHf/GqqOlJ7kaGwr+HXSRbY8iuT15iyoSQzb/oaNR6Ui/YLqoU0wYd+
QedndCGMmeGTjAgGYm7J3bIYbcHmBw/d9ZgViDTXPhi0nQWnbDtWyMcmLHC+
TQmwClHlbTynOY6BBfdrHq9W6oLR33Xt1881o3pDnuVLqg/KExGj3aJtsJ+b
zhvbU4O628FDQ6JsVFc0p2xa3IB10cXNe3pSsHVFspNzFw0dH0/6529sRLxj
xC3v3hxkrplnKP+JjovGs5XOPG6AptaW5GViGSjk6p4v1aDjifQNS9k9TdAc
VlE4FFuADYU7Cw0dGUh6saHv/e5mfPpl7DuhWIITV1TDmhWYcDu2fUPPk0Yw
F1GTTaJ5SGvu8lfspSP8BBsSJi2Ydv3pu6vOZVjVdOUWt4KJBH6+OoO1rSiv
eSurnFCJa3Oeu067zELtp7oy9rImSPttagqaW4CikkXGK3cxsOy0TPoOwl/H
ZzSp7RamYFZH35NM+LQx451l53cK9+++X//kFYWXpSa6jPVc7Gz8Msu7rg9d
1hXW5oZcjPZZPCkV48H7xqy9Xvsbcfr0xeUDerkICVoh/TWTjs7pPcqtaMCC
u99vp1Gp0Lu+r9p/lIYxg7ky37wawKi4vW5DUTreCC6Za7GCTs5f5KWtfCOq
H5+P2TAzB18aRzsPBdFhJpoinRXZAG6ljvvDZxlo/1m4ztaQjitOu6/0hzSg
dpp+/lz7DOj3qf/030DH52g7Y61OHgLuLBD8ShH90b+u5l/JQYBBt5wE4acb
j5z3Rz6goGgh/PvDHi4Y45ZarTM60En7ILgppx7194NfLXfqRfafy2fnJDfj
lavgzqgbpciS+TyRSHjy2PEfa6P02lG4aMVQzJE62O8+9l2Yzgb4ahLVljaD
f6GoQcudYnzs/2tFm8ZEvEX//LMuTdjYRBVFKhRi6Q2pIStvBv5Oh8O+qBY8
Tl5zeENaOVzvtwisEGPBympRxNXoRhjO71vsaZ6HwsLODWt/02HkGSjimtQA
b/+h2w1zM+FSm3u3zoyOtXG60neLGhER/XyBY14ehpoMDzrOZkBYe+P1tyTX
jr2co+FE/C52+l23JcTvLA8cVjuXwYFtj5XRQRoXedOnNeStpcB+2XrhC6cf
Qvz6a7KI7ngejlhjFEBhY/3toNWpJMd4LK6x7aHwr1A/bVkXB88mdQeW27WA
b73ENLn6Mkz4GBS/62Fillbi4q/sdowk612SeVCPF8pzL5pa9yIp45DH3sJW
GM69+ELrbTW+3bJYYtLGAlOtXUjvdTNu7vNftEqvFAbLJWmu1kzYntjtlHSt
EYytN7KL0nLRJdg2Y1kTHS88NwYdIXzc4/VcKOMxBbfE7/W127n4HV4z/QkZ
/9jAr2MJZPyPvj2ct5eM/4Psy5aEOMKza9su3O6l4ZtYVdRewm/xQxcSBANZ
WPlL66+BPxvu/5J+gPChUdSFUl8NiuQL4VVFhCvaPC7qv/Dlwlld+8VhwpXL
e7Z6jVazkH409+ldoqspw5blNVzC78WeqtFsBiJfO2sFLuOhM/C6zPZGBhpb
qT0u+QykJ3fnzSXHWxfw/l7RYWH3vLnxMhMsrHCI9llBcnSqeXzU8v290PoQ
faDDrh/6Sm+Fbm7ggT9lZJ2eKw13evvcTuZ3w1rvVsHy7RS67ULybYS6ED9L
fjCI8PWk/ZZXrm19qG12NNXf1gGauhTfubUN2Hw+u+1OeC9Wq1f/nO/cBOfK
k4sEFhaC/S9umO8OA4fjfdilAgO4FXkmpn+UgorTcHc9qY95pWI9lpcpVO3z
5vvqQvhq+gO3Ykcu6lbuPKx4vQHL1vKOLL6dDqXC/hf3FOnInlNYtqmkBw80
V/y4dLgTseyFh6oIb03KfxVofVkP/75NCeLuX2DkLt487R4NBWdm/fMx5+Hn
PKpeKYsC6g1Kr4pykeXVZl2dzYNITuafp3QKM2ufyq9u58D7TfjWnOUU5nVV
pKkeIuO50O0n+YT49RDfqwXjTZBs3/ScN1SE9zcKZvxjMhDw2P/aTfIXd2NF
utsYMKqfc9GBzL9bLp/NdD4GLkyslCo8S8eZJfqz1srzIHQgZ6HhbTau8T7J
js3pQ8/LBvlPhNslcgbOCuYyoaHe8vCVHgv7lkglnVHlYdGwZ+j9aAbieFtO
LyHcszW5RvP3fz6YVjue+oeO7d72w3OO0nHiIs1DiHx+g++O8cLofvCdH+4+
QzhbyfPfQFACBU2p8B1bY3k4Kz/0KKOdQq2ExvEjTA7kVse2BWiRPLQ443R0
fRdMjl8Qf8ch86PVv/jmIS74Em1GUxZScE07sVaEx8VZJuv9zEiSE18XH3jT
QqHJqHP8Th8HK4devnEaasFx3fET+U0VeHiqaXPXVha4Ifto089245FV0N5b
b1sxzHdzkL++H4uF9wuUVDXgnOSihd+qMjFHbPKRwGE65AQd3Idn1uOj3EBF
5Ll4fP+W/zpWhgbB0p5Vh+cO4PCDGx7FE4SjD2hfiPrKQdliZ1U/CzLf2qzf
1WR9tVf0PngiwoVTj6lm9ux6iKcy3Ht84xE9a0fMTAUafDQKtBSyeFAXCPcW
IOsO/y1NPLLuM6NTqqpHeWimLvZuHCb6ffyZZXYuB4Ondj4NUKuHeZmiroxH
Ag56W2h4bqBB+JVESkJ1MzJnecqbtJZiR3R5zNnrTMjsqOkom9+A/hF5zu70
FGwR2r8rpI0GiTLD2QO8BvASLfIvvsvCXs8st/5LdKxRChc6bt2O/DUiP+Wf
1eGPtdzBdyNsXLD5YdHg04irhSlj+4dyYdqXma9Gp0OrftC+O7IRrw7Y17ia
5IGuZ5h09CeZt/O81ydcu9GQtTZuRmYrFANPfkpp74fX6a4PtAoGPgsVH/jx
hYH7DKvY7qU8zA1Z9+/z93qI5IV5a+d8xfbq5L26eTTYFv8odCbceP2C4tFz
hBuD5/ZPrDTm4rRi9Mp7HAqmZ6xefyN59sCfAZMtulyU0ZVjW1+3QHPJu7uP
U8qx5ZVtbt0cFvJC2PLH3TnAwt+SeypJHekcU363i+QAwVu+g3vqcaoqce+8
m4mQ3uwrLL6XBheep6NCQicef7wRp/a2CWP6JXyXX/bB4n6HqKEFF7u9rzNG
CLfuW0DnX0i4coSj+S3Pi4MHUrWKJVVccG6ITSYQ3g/6+s4xx6Qdb5+XqBk6
14GvIWBkWT8binLvfjaS/GUo+SvGh+Qv7Pz0888ZLgxzEgxn/OBBz2Gz4MRP
CsYx77cqFHGQtfFWU7YyB0lLs2rzP3MhWhBqakve925SeOMcdQrz/VaYmhDd
/vx+ZI4xyYM5E1b1ttmdODX772qtrCb0pnfa57/pw5BCqdIcs37w+mbGqdpz
0b9rKFuP5NS/P9qHSnn92MBrVC58yYVxYMQgzZ9Cs+qmch7R+4Osbp0B0rcO
5Um995aQXPzPfnJvGAe3/b/ejGrmYmLe9Jdlm4g+Se7+cn4bF0u0ijQT51Jg
BFx1UxoiuTVn9sT+0+S8HvzMySqisKOz5A1nGhe3D6WqqPdy8SnofuxOEwpX
vqg0XfnEReUZ/ZuFRH+X6Q7cuUP+GlgHDwle4ELkE2/trL88vA1rl5kkfTGU
U6+cm8MB6x13t/8ghSV7ppkokpykL7TERp7w2xPtli2SvHqscNx0XSXuK6Kx
c/mpHBrsV+9gec8awBao5tePkfzr8cUuOJ0DQ+oh9dipAUbOb4vdkY7uX+aJ
FdJ0PB8Zzhv+UYfIlwf4jN59hk3hv+dr59BAPz3BVlNtQ2JextE1d2oQsWza
6nYFNlZ93Pfj35kmyDH3KNL4CrHMSOdYhjsDQ+qlN86WMPGi7saw2xYWrpsc
q35GdPV5tKjs5uE+RMm4/9Mx40JgZ6Be8T8KIuzNk4y4JhSeC7W82V+Icx5G
VtmfGEg+7XN8TR0T11twqMqShbWb1qQ3kM+x/uHk7vCGjfepBZI3tvRhp1rD
Ubd1JO85tzqs39wAAztVfq2JVGSGhbJ0x2lQY4nmmGQSzrmmbplBIz4jkqVs
0cHB0Ef/oCGSk1O3uWWSKUHexMba57u42ODkv3yLag+c1lrc99dvR1TQVjUV
Vw7Mzi1iSgkNYLpv/3XrcQriJ46dYKZxcOHxnpll8ynkLhB5vHofyXd8rppu
IVzM1Aq60D3Yj6s6QXIKYSQf83+WE/Wj0DjdX0L0BwNdDW27LvLIfLlYcT4S
/3pwc7hmtXID1Cut7bV0U/HFVuC0N+Gap0fiYvrIOtpduWLzm6xj2QX+Z+fJ
OkZFfD4xR78RTX8uPKsuzkGRl9mP2lg6fBOmjweMcdBkkXnZfpiLf/r1Mq6L
KHx0y0cLrR8tnuza0hdcdLYKWuk9p/CgzjqWKu3D7hcvGFJ6XNw6OXFlgQTx
u+yxDaev9GEsKujSczkuDuVWaIoSbjkQflM94FovRPWVrtq+7Idz+A6f3bo8
FB+r9MuvZONDw6aZFvf74Gtj22qvzcPApKFscnAvrrDsOv5V9+NbW9FCUT0e
+AobRPlesXG776X0nw19kLYx32ZG1nF7WXZCpS8bkgbddr4KfQgwlAseJH59
7IV59daLvegrtN333r8fZ4cG+VXI/50vPnmQr68e3xew3uU9+ArvQT+n+gwa
HALuLw5vJhyiPybdRnS0U0fOV6yGg8Drfw1kDfrByZiNNjsuIk/JXJtF+Dcs
RMRbRKIeDSUmw9El8TDRThLvVKZhu0v0ph+Vzdh+5o+yan0p/vE5lKhfY+Lb
6cOx/o95eLPmnuXNOgrfh0I3lP3gQMDomFrDBhZmxl/LNv/Hwsf3Dzw0CQcu
Ew6/pyhD8pkkS9I/hI7ggXvTugg/8O2+GeNv24JN+Z+rworLUJnMx6fQxQTF
ldZdYFcPr8nJrtPdidjwxe0vny0NO6bmZ/H/mZ9zU+f7a+p8O6bOt2HukoP6
MUTX5GZ+5vemsPP+Q497B0ldrP6h2erSj2s+i1kXXLjI71nIFCuhIGsi23Gs
pR/7lJhWkc9IPWgXyl8NoRBqfHTakpVsmH7ddWnsdi+emJiEJWjxUGrXNkuA
rxMDEWMbdC82Ysxha9CYXB/hjSrTEjMG6KJcXTaDDhHRVrs+BR4ODwcNm9k3
4OCaBXel/qQhuGE485kEHcP/KuMdUlvwRpim4TO9AlWBL7aOybCgrFsq1Tij
H7nL9/ieIf15cEvv3Io/FH7dUD19c5CDMY3zg4d/cWH7JO7P/SUk/4mNS9SS
3GZitUpyWWwfnnz1yPzveQJ1U3xuOsXny6f43Lxehm07rxU1p890WOlV4u3W
3zlatiw4Z27pcAjkwItxSHJ/A+E60/Z4PVMKctyaj9dv1WPe9hX57R+ScD1f
51eMM6m3cTGHoodtmNRw0KatrsWZpvGlzvZsaP3dv+1oFfH18sB99iS3+D07
8YthyoXKFA8kTPGAzRQPbL75zNiAcLj7iOvlBsLhb1bEeoQQDl97p2P0qEc9
HBN2DIqnJYG5wyD930Uaetx361lzeVgoMeLtSPzBLHzOW50SDpxmsa/JK5I8
5XjNd8iS6P+rJ41zArnQE5Yo1iKvC08Ums9PfCTgY6qxGfGRWt+X553/kPNc
3i0sRnKIzpiJS8ZbLozUje0/KvLAeSKVdvsThdvZByXkFbj4qssnskm8H0dz
u0I3kDygPuS29NMvCs9j5ln4V9djm+O1K+XdydC7kvT6bSwNy38UlkhGsNDZ
v21+WBQbkTVjFt4kl53TXM0/QHxxvWMxP/sEBdHot58ECEcvmOJbiSm+dZvi
W//IwqvNxN/nBQbUnCf+ruUe/YjWSuFUxeRz6WntyH7uc4s1Wgv1Jdlmfals
DE0TznKb3YL5fOfWqcd8Q8DiVyynaCb8pvgna4p/RA3+xz9tObuXFAtRuPO3
6nGTBYWfzaL1I0S/H8ZoFbz7SMM0reMBCw17MKKcW72R6Odfx4V+szb34cLG
R+sukvxsWiFxlmHIQ+wr7tq3hEcknXOvHlTnQmHtSikGyRFC+5X/zCL+p+9j
GMUi/DBju+qRrt9c2Gl8UNfUb8Lg7YIg6cMFuCbuW9J4mIGBKe7ynuKugSnu
ih1wuXeX6PTNjVFBZaS/7682lnNVIfPmJH2syI8Hp3LP7UyiSzISV7gguqQv
8bffaVcT/IPvP5kdWYDDjeVCtucYeKu9Ghar6vGZ6fbP3ikBb46kZ3DW07DJ
YbPQtcQeWIdIbVi9sBNnhouPB2kT30ibuEI7RDhW/EKAbkYijiTemW5lRcO+
xKR5H3SJ/7x5HJugRkP4qsWWX6SJ/qs+36/5sRUKwy7GpnuqsT0hbtaubyw8
8zyRKj2zFfVp9/6kzq3EkfFra5/tIzks/J7VXa8WdByla700K0cQv9NE5R8m
3nUPZoSKk3lty2DUvqdQLtOgX7ScixKRwcUL9OgwqdaYaaNOw6AjLf/rf/c7
ayds5g4wsehGbuFPbxZ0Wqr23ljJQ+CKta2flNrx6puFM792HZjdkSLratlo
CNzkapLbBBXaBqfTK4qwJPDaqZgMwiHpM6pi1ftQfSjr1CDJJ90C5zddJevr
fsRgVugLDtpRM5zeyEUu/+t+a2MKylO8MWOKNxZO8UaboWXuGxrhkByOgNYA
8SOjgIQn5RyUP3gdHnerE40F+55eNm9CjoFh1L+rfVB/s73v2FUa9MKr8hyK
uyFw86196Q7Cn9pxUkevdEGoKNdUaaIZEZ/0NBao9OPGAXrZknAKwtdSr0bd
psBeYec114aLQnNPppdKLy5/CVvjvYj4r8D+mIs6PAynLqhjRfTDusPGSt6L
CxOO8OjeJAqbJb6vUN/ChLiI7rgz8Tnjir5zMSo8JJ5U7FYhenZ/Cb9zK60X
ng1R2sLEdyrl3F61XexBWOJYy6BOB5anNLSpdnKQsW3fwut+DMxzsD24ZQ8D
xofizP97/snsKX8Un/LHuCl/vDf5OFjmGQ+Xfwr6fSR5SC41Z6iNx0GHxLk/
utkc2M2oHDKlc8FSj612X0PyBFbF6Yd3wHVZwNPf3xqg4b5He7i9F2NT1yUu
TV2X2DR1XeLJ1HUDg/9z3WD283ncWST/Zu/pdVe2j8f9Fx+GppP822j52V6N
9HOxyoJnA//tj2uYcFRfRkFB1fd5uiTpv2BT+s39FKJpTw+lEJ6SC7zX99/9
1IcKhpz/u59aZ03WLzuiq8lmjnG0Vh5qMz+JhHIppKjutxKp5qDnrOGzwZI6
vNzUZBl3Lg7nC8Q2HR3sQWOXTWZvFQ9VsibTf/ZSuGu+Zc1IPQf5e9fFseYN
QKxU6XzYJAWL0Axrz2QOHGMvn08aqofCco+lQv1fYbZ66yaXIhpunSrxi9nY
D8vXqjWCx0kd/I6ZdOqiILh7yQMvUw4Ev1xpt07nolE7qlHBgYJSSEfOZZI7
wndVjCmOkFymNhDxmOSOA7PvRIiAwoJ1uVEhxyi8ruIvXXyPi7bctvmCI72g
uhX/Dp7kwLL9c/pqAx4WayhIGdWz4fpOebnKkz6c2R0+5E38NysstLE6qR7j
J0uPlcom4/rQy/vLgmgQOyy+91kHD9M2z0j0pChk5ffcbKrkYNmvbeVsctw6
hb/zJTmeYrxrMoEcz5i6/2vh/7n/y8fi6gJB8R6cjdG4VMRswxam+qPYvRxE
h+7JNlpdj2//zroLuCbgYNrdzmc6NIzGPtp+9wULs2XnXL0UxMZc5SE5a+JH
ibYysYy8Hkioj175tr0TiacutW3ewYWPn73eEWEGbBpK7525QUeytKOnE+G3
s6LJcTXpDKjVrjbqD2IgbaJJ9wrJ+0OW/fcsk5m4Pb46w1mVBQE/h32rSH5R
7ynlupXSYLrf0O+aYw+GE1/FHc4i9bI3MVg2owkKu8YVb0kWIRu0m8KpDNze
WnZjZ38dpJJVRBL1P+PfsIlGnSANVwYj5U08G1CsfvFAelI6OsyuXnmoQsep
upp5/TIDqG/LDDObzoPv2uPGAfEczI86ft6qmwcrtdUN53kUjo0tNQqu4EBn
6frCswebYLXS27M8swDTVucX/3FmoK2wJs2zvwX2e87OMoqrgHDmdD23jSxc
rZURX93djwBXrX/MIC74AuIczgeR8X+1M1qq0YP33477/7ZoR8JVE9WT7hxQ
/jbrvVsoeER8/VD6jMIXkTAJy81cWOpbB49rNqDm45z3Zo9SIfTm1bK67zSM
vb0SpuHdhPze/DDHI4Wo4mifaw5gYJ/I7BuyN3gQuVobfqCCQoKwQL7oKAeh
vOQ6u988NO8Mt3P+Teo7oXzO6gIOXmSvU31Act3nZ+q6S25QOPCmJKXxBBeK
t7UeDz3nYq/sHeqRKvHNO3Exp+pIXjtRmWYY2A+xjltafbe4+K35csG/VAoP
za+EyL9swP1Kj9Q7jhnoDH4Udpb4XNVToeiHZ3jIuaJjd72Y6FXzUX0eHxc6
d/cMXgnlYTJw/ZOyJgq01Mqq6VwOnj0WbBz6WwfVqKKnc1XiIbRVafT1Qhpk
bQz1NTvrwXn5IirQ8CsqYls+636h4X3psmCO4AAqWrWOmpG8udRidOYYyZsD
/qaj11QacH3E6J6OUSr4N4W1XuijYaWU5NkvkQ3g+SiK7XqWgdLgLVIHDekw
Y/AGdJ40wjn+N57MzoPrNtHJj2w6Lm4PuXk9hY3lg4dWep3owxKJgzVMkr/2
fuv7zj3Vi3FeLnuaRz/kh3MecEju28YOuxO0oh9PguabHzxE5q/0Nau4jwIz
Lr+7qJWJHdFuw39OsFDE1eHyrfzvvoaHMua/e/B4u76C9Hgndjs4Oco/5aK3
UV6l51Ab4obPa4W01SBOs6WyxJgNxgHlB7uZ9aB+e3ksdfqKx0eF6vXTaCii
Ta+fGOIhZbSu6L/7WXTidri55HOwyoZP58ucery9Q92++joesrMnT0sr0ZA7
fj/X+3cjAsQzQ5gn8jHOCfzquoqB0pSyjzVNjRBmFxcHTOThtrH0gueSDAQN
Bt6r9a3HTd1rKT4Lv8D2Qlep8w0azHdsmvvkBYXHO5fEuHiQ+jWaZvDvMBcp
zh8NhWt4iLv6jb6HnH/i8ouil4k+M/camOum9eFNwp3urnVcmK9P/SxDOKSn
RbkmxrYPgX81n7QIc7HI53b8HZCcK7HurZRxP7RPMSPVSF3mxMQbszsIdxrM
L49I5UFGOlf3DsmlbrNmy/wkftrpfZ3mIki4o9ToZeEbwnW5lxu7VnFxcqn2
z73rG+F69MAM3pscBJZs3uD+jo4gPx9Rd+EGzPjkfS/2WgqWP1ibJ95AA/8L
F0kjNzrO0u0vXn9Ow03tWxarZXjw+1vlLPKWAZFjWb4PrzDQn6QvNEH82tzG
I82wgg2zoxU9PXf7QNkOTjtM9HxT5WZW2lg9gob8z/2dnYIXZd9P/iW6lrLj
0K+zSTzscRQvKCF+8zegfMOWHjI/knujHs0cgH5e106PMQpOMmvdhTKID45p
5FrObYL+snfiUUX5oL72yc/YyMDWnfbjfH404uOrN90X7oGZs6Lo03MkH8jV
G8Vl9uDLaNXSmA2duL/yhuZ3Yy4m3JcfiiQ5sqDoYOdT4qNZ9z5YN0nxQNv4
OM6HcFLdys+DSVe/wfOUpHd0COFCuW9HNx9vhkSb4zLNoyWorFq1RFuNiU0X
J17NzOVB/P2PwnE6BbGHIZ8i2zgYPfnR6BJZzxN9vxdIfSR5f929mzZLuRAU
TY9qi+Fh14qT48/bKZSV1Xr5MzlYR7tzim97AyLZxv7bddNwVox5+9Q0Og7q
K3q1byS579uxwq3/EvCwdw7fof+eS3PMRMPlFeGFE0qHU1ZRiPOarLxVzcUj
tzVdpy62wDE7sEhSrByRBe5RxRQTARICuxuYPWh7JaxoVtQJu+1l0UducpGo
mxT4+kwXqvOi3NL6mmEaOaOnQbYfRUfF2UfzeRDN1nlVyKDw9oRpx9NWDhyU
n804T3J8hGf+rQLCf+k1Pa7iUlws0Tyz5bTIAGQkJ064/KXwUjHtvUMqB1YK
1nuVWuogmSUx/H3nJ+y1+07l/e1BYJ5/8f1Z9Xj0mKEc6hSPNW/4ncVlSZ5N
e9HzsaEeKcJB5yz5v+LXmyFzw080uCzWucP3vB4emtFql3d9gcHR+hVat2lY
tfhIgn5vAxzb1/qwr2bBKct9z7oLdByJ2ZO8LrUbhXtlH6WuasPQgv2uJkIc
YPKowaMLbbBLexJU9bcGp5Om6YTuIfyhpRR37C3Jrb1JXY5tFBynW+6RZXPg
Ft3nkmFSj/L3rbIaCokwaHwqXrqNhln35713EBqA8RexHBeit3/rfkjlEb2N
ZYou8yUcb5tZsrOc6EHfc7tvOwy52KUdEf4otA3CIustLLbVYpaqws97zmyo
3Htjdz+yCYZqNvx3sguxQKKTN4f0VZLXYv+B6H4wdqVmXSX51kZUyfzuf98T
zWbS3F3ZuFD4ZmfKRC/ahV44XiBcbaJrvuWcfC9Mx1v5FUT7cU37uMk2wu2v
HgYkR0d1Q3O0XHFYsA1638+urB3rh2fw42PbbtPRI1RdWRBJ+CDAetcB0tfe
1ef+Snf04JWpwvaRt524PGLeKONM6iTnFP1vYCMWWnVYxSzKwz3R1657+umI
fX5FPYqcX2pq+cgiUcJ9T18uHB3lYtWvVTuURJiofuM9ESD13/PSfBoslHng
1vQNfvzWBnO1oHKv4FpcDdUb+vmEDWNBS5nuOzw8O/qkZlM1hdB3y4YUhgjH
O97p1F7NxgyBINh490JPe25vFqm/rI2fzq4o7UNl/peSVl0uHNrVvp8j+XYB
6yBLbGUj7ixeviHMIgdWkkK2PWF0nHh2bMD7v+e+NKW2h/n0I0nKYaG4Lg/r
jn5exiXjCjrZKcf7TGGnwof1G+QIn1+u9z7tSvKTe8LQycsUDn84vKjtPBen
Qo0uvF9OeLpVU1rpEIXxC3YVCk+42NNmVnCxh4trdoERc4wovBjusHFLIDqz
/tZbyr8BAr+vHAiRz8DebdTEQy06bNPfrC1WrEdxkXHFHLUEiB/66aStSQOX
Vp7odLce4tM9npt0JEFW7+eRx1doEOEoPP0Ty0PXzov7h4lu2C71PTOX6Mb7
r1GC+5p4yDBblnyWQ+rw08GuqBoOnI/f7Ap8x0ORiMJYA6nnki/Fy56xOFgh
IDmHOsUD74H7uZAiCgddRaSlpnNx8PrNgHWPeLix/5ful1oKb3YLOrQMcrCw
rE75rWgjAt1oLqJ3stG8+YDdWh86Fu44LK69vg/zflmenks4m/l6x9ZoknO/
ikpZpKj24zmLbvrf75LcXbJwxIT43oO3oYsiyOvLlowXpJPXa7Mkkt6S18v9
iOgV5/Eg0Hxr2bSfFCr2Dny8VMyBGDM+Y7yyF2elO/5NKHGQY9i10lCfBzPJ
8LjQEB687MouehJeunUoT+gk4SXtLarND39woecZxDq3lUL9/vdyJrFcXPpn
eNRZsB7XHu3uoq7EI6P6IOcL0ZlqrfNKxSS/XGm//81g5L/94TtfnSH55bu9
qerhnEbMFJU0E/qYh01fIl2kZzHAzhk4GPGLQsyX71Z1YRSKf5pUrdHm4o9e
5bZKbiMObuys8zXNh/wINf2AMvHFn9/9l6bSIPGqulFsTw9KWbdd7d8SvjuB
KDNyfKk2v+Aecny9qsJ4KDn+aF8XZ4ivHe9PTJ+MGq2FfmlOTWUqGweEZc7M
iafhqrKPPZ9xD3bMNQ0TDCV+uE5p1sPIXqjZf6143tGP+n9ba3X1eDikdlrb
9GkfKgIia7RXcFHnV3xDdhUPF9yqvWYSjta14FujO4eCPdfb2+UPF37ci/lt
j+oR/PDUpSaxL/hLyVsXutGgEi62rSy8BTqxy6w5H8txUn+V+kcRFqJ1/cWX
PuxBUF5Hmb1vB0Jed+mb/+NAcer5MJv+z/NhghOfGgQd64fdG6dNVo6E4xu8
ag1If7OLcgsqlPswsmjxgsREDpZKXPQ0JvWQxlwvUXmbDX+Lm53dYn0Y99tz
PIHoG+ui+VWBO70IXta5QzmuH0oGLp6PSf/S+nVeGmnQ0ec5oTNGcrifyeII
V+K7hcvVxAXDGeiROm5qcpaBs7mPFzQQPkk7E3tjIqERN3Z8k75zMw/zLXc+
/jJBx9XtnlUi9v89z7+h6ZApG23BTU//22+2qjzfKd6B6Cq98GfL7X6oevq3
/SZ8ayEpuObXbjb2BLqdPJbXC8WLnWaBa3iQNRhXjvBgQbBSlZpD9N2/2eBj
FfmcJMfm/nM5LHw166scamRjXeSpVQYkh0aN2narexAe2LmJnVBJ6iv+0Xq9
EQ6UrWsDR+saEa3+XFrnRx4unDmlwpBgIFd6n8CHQSYshg7ftn3IIrr/4/Aj
ws8Jvo/SQwQZEO8pdHt6jY4P/q807Ene9N205c9BeSZmqM0REtZjIincIreY
6N3aGDWzXnsuevjXXPSWIv2uJiX+vZfwoWiVjSFZ5xcSyUFzv7Iw7nrQVYXU
T7xrbFCoCg/L/FqHVeIpIOPxSo4sFyoXI+pTlhD91H+625twjtKCNQvLlbiY
plfUM1eDgqrh9LuhthTO7bqjWePLxYkJnfOf3zRg3XRltcn4DGh9zDBR2kQH
r6sosXh+K2w2V3pv3FiJR+8r92gcZmGpi6Tkre8MlDiLPHlEkZzp2f4uZhkP
MY6LGNUn+jFstY++8AIXFg+S56KKgrRh5PwVbWR9no62J3IpKJuk2FBVHJw/
k7m98mobYkqjs1gitZgmdWj9Eis2ziutWppbQ8cKm/rIRjk6ps9jbZCX46G0
vdhs5FUf5sd2Pi4h3FxZrrNlHzn/Be/2qnfa8mB07GcR8imYjqm+CZ3JxdMD
Rl7b0okPr/nSIU78/4Fff9MawuFjEos4at8bsPyo/nHV+CysvPtissyFjiv+
PjTJpQ2w6Dan4lemQmMgRlmMTXQpPOp+tVM7fpzSlpXNrIPxO706h1m9qD08
WYKUerReOGMZr52M0BGNP37BhEPe2XkJ3yO6vfTmzHHSV1o5qUorfnPg81oh
/RdZ32bF4SAfsr4CyxNv9ZP1vVaSmt1TTF4//WSaMYtCvHRQo18zB7ablznO
DeuDdDXjRzU5X6ckNYFt5Hyb0jX2m2xtheSJD00Vw5UQwF/FBV4sbCtP7J9e
1oIz+dHcTFRgbFpHsKUqC7s/9Zbee8zDFtfjx67XER5wkV1b9YMDxtrs3xqk
/+b8seR9+kT0yyQ9gSnPRclPz6pXJLf+Y/sXahCOquid6bgknQPLaUou8owe
zJrB73Q4pxMlubZ/x65zEbgji7lIuQFH1m2kR2xIhbdDaJJrLw3DUdI2v/xb
sc14hq/PryokVhS/WUHqN9K69bPG0VZY7H30eGxbFY54fElgPmXhegGlX8jP
QBa3JqDSmQ7FkcLf20i/9M8vqC6IqIf94wYhi5AviJy3+FX+A6Lj1F8b6h8P
Qh+3RZv9ITnWctX5adkcpF7JOJl7ogPXB8LqjU40oHN50IP2xF70NtkF6n5t
wamP4b2DY+XQ7I3Y77yEhfx79tMTS5oxZ8XPXS5Zpdh4JcKrwoWJjWsGNxgI
U/hxN2zLpAXhZ50fl/PDuBgPDdz/fRkXW3XqFDoEKBwX+6cqPIMCL2nTNpV9
ZLyVNWXTcyiYW1rtHfovL2bxH1tb34S7Ri0ncbYIS99t6xopZYCxPdDdSr0f
g77+TZttuUjqlH2sxaZwg1O2U8KEiT3ZP9XmXmEipF1m6Suy7r7lQ+dnER0N
aFKXH/5AcibVUfGI5Jck5xwvv+VchM8035ZJxpHxSUGwk5+Cntk5w7XXuLiu
S8uNkKfgYqaqndnNxQLHoplbfdugLTrs6KlRC1PP7A6PU2w4nWe9n+fWjhS3
2eNDlXUY+HpcM2JOL5LPpypV2dfj9IFjOutmJaFWsNxnph0Ni6PcS9Q0eTC2
en/YiuSO23KnhCNI7pjo1K6ZQfLJMo0P/VuDKSwOXCwcbcDFz6sSG+OjuDh9
N+xluRqFgE7doqQKLsTu+mS4ShC/zbV0O7WPQunl7UdWh3ChKV3p+nwO4QHX
1zNr3lHQ6OWLkVMln//gzeYuGzY2Zsts5dX14tu97ukNROdtTvt/j9/Owsj4
aca0JWyIf1bPCV5Ncv7Os9vKx0genmDIJ08yMDbr+Usu0auPS28vfHCACSnH
SNMlAUwkMyb4+ZfzkPK4NfODOQsTYx/cy+XZyF/Zp/iBfM4L2WnMrt1Ez0s+
n9n+nQ6b9rIicUUeNNdWSuRLs2Gwr0/F4kwv5NU0ZlkSHqZVxfSdW0ByqsA5
ZfcVTIj4mAveIzrv+SNbL0SZhaPF8g/P9LBQeGxyex7R8xK7kOSJrW34eqDs
VGFaDe5OGkvfXs+GwmnZm8d+taCOtjfpZXUF3gSkXz23hQUnU6PEDM8mzH92
S/r7rkK0Ov17kuzHwG+aX/CVfh4au5NR+YPCct8UC/FSDhblTQv3yKVQyagf
LPKl0KYzKim9k4vipx0OmR0U8o3u6WgEUTgQ9VTk8kYuZCB4bTCrHWdFVo7q
bq7Hr5FT18INejH4PSnccVczOEyFM4bSJTBQkqw1JX52ZsUMc8mWRrzW3B82
fXo+smkro90WMTDPum5L1GYOTI+7joilcfGlSMW26wzxgRT+5GYBLuisYfF6
kk8CqgUvdc4n4w3bZhuxmY779hUz3fSIjojkfaOTuh89aGa7xZsG1jU/zbTh
btx/ds1x11EKfx7Wbov43Yh2+Z5TBifzofZcNObBKgbSp73bGJzYAOnrst8r
hTOx+uaGaG0zOrbcCpK230Bh290go1Ty/sIMibrIB1zY9t1IT6dTOKGZ2a1O
6rbJ+0xcEanbL6saTbcRPhubc7z44B4KS+a93vXzJRexmnWc9Fk8lN37+sL7
DanflWuWaa3mghu+xMqlmQsFxz2NczZS4BP+1Hw7mYuVt0VHNhAejL33sSzx
K9HVpc3K8gvJ6+MWn+99SvLa7FKp+ytIPvU8OKe4ngvnAaHxRwqEH61O9CgS
fT5gUdQcocCF0e+A35+kyXgkDNyqD1AYvO9YO/ici9wGnyI/y3b4/xB0//2k
Dh8P9vw4PMzGOaemNeOjFNZF+3b+iKCgwnIatV7DxccXTZZvw3loDpBvU28h
fXe3vlaxn4PBFeJHWw368cfj4ttFx7ioqdCLSuqmkOcxy5sX2I87hk03FN0J
x1c6F8enkvln8SWZDtCR/fKjgukuOhIb0h5UEL/+IWG/xfNxD6yFu14tDu6A
eR+zSJCs90jA41O3ttNhF+NklU5ye8JExoOFhFf27bOIXP2nAS/mrw5KG8jC
9yCBwzJudDhM6x19t78Bd09uDT15Jw2JV9ZeZwrSUeUSdmFXNB3U2zhHxxYa
Ftbv6l4iy4N/YuyueCGSnxeLnnc16ULm6Kn56iT3nRdJJVPAhe+Cu9ecVSic
knm7PbCJrPvpYsWJ/343WcA/vmw9F+uY6cP3FxFujE988VeKhtNehi/DPLtg
MML/xP0bF6Wloy3fyfu3zFX2ZVmT/HB28y0XkjePvF/r8saIhxVrJ557plHI
sY64ZT2P+PbDlq5CjWZcb7PWfhVfjIS3Xrw0YSY8rL7tWSrTCN+tjR2V37Px
cm5/i+Qzcj6HFtpv5zShWIJK8ckoQsTSDZparQzEltn5FAc2wfpyuppKQCH0
6lxiJF8xkL1xYUmOJQ9+pgOyD0l/m8Uv38wWJBwZfYQef5yOnyUhKqFONJKv
y3KjyDxbTO2HsZ3aDzN92v/2w6yd0lvXKb1Vn9Lba//n+4J/T/73fQGtNWzN
XD4KUv8qAoJ3kjqMd7i9m+j7l5szTJeT/HT5rQP97x0KF6gVj/ssuXgucaRL
zLYRUoONHmoHcvE+5sFugXw6lnluHRz61o+jDwI6av1JX8Xq+A6QOk2b0mG+
8f9fhxUu199iFbUjOEBKXMyiHkLOjxy0jXohMLJDWr6U8Kb+w68W/hTiFl1q
iN/GRUZo3eekoxw05lt6LSwg/SbgZmdP+Pfkop9rd5H8/uH2m7Yskt/FqTEz
G5Lfu4JEStP9+tHRdi3V/ibJZ/vMfgpkUDi6KCdo9Ssuimoc68NXEb2ce9Ux
rJr4UfnnAnMTHtzFT54VS6cgdCbld6g4F7O9CgI8GnuR9Ofpp3kaHDh0bhI9
Q/Jywab9lyMjOXi3c59jVgsXtdF+zbuITpzffH3GaeKb99VexjgQ/bm+rEn4
KtGfFy8P9Ubmkz68HmsiQ3RrpvPlnqZsLu7P6q7/dYKsl9jtvpeFFLIWNH12
5Oei+qfb9WahNnyWlE0c2V4DQ8P9u+Rns9HduSu0164Z32IMjNwOlaBfHSc3
r2biVJGHvmVMI0ZUtoRdOpKHihvHxSJH6LCc2td6dWpfa+jUvta08i4sf1ZP
cp7Q3GfbvkDBRG1liCcNmz+etVMu7sG06zXHQqw78evHs7/Yw0V9ibWMyeYe
NFhZ/Jj0a4f8h2vOPS84uHjG48B1Uq+vZS+0FhA/Kln8rE+G+JGujXH/bbVe
XKcVdBUo9WNmdubNUB0eZAxmVkbGcGGlsHR6Cckxub1/ZYTLuBidFPI/ZtqA
bcun/1KXSoNx+gP28knSt9Ea7h4SPVgpWd/V9KMNtoblux9aclDHdth6r7MF
SnPTX4R6VcCjfKXUXB0WzGXPGx0obERERcGQRVYeVt9iugcLM2CYtlrIqqgB
SfM/Ca/1zcTzbQVjxw/SITu171Hg/P/2PV6b2ve4WG6lZp1YB+4Jd/G9qKlH
3pz1DFXXXtQ1PnxR9pKO6G9DOVYVNJxbS038kCH6WxF1nfu8G+tEdBKafrZC
7bfB7//2HfJ5/OJbM70Fkoy769j3v2H9+XQPzism+HUWeS016wEeTT915EM7
Atyn7RuM4sA4e9sHNd92VFQl51zk1aF8ZuV5a+le5FaZOla8aoR6sBm1Y30e
mLFH4r0IvwilR1X5X2nE1Qz+iK5PuQjNKKd+1NPhu/j7rEfzmuAdfbVtW2U+
Pi3gm/5kEwOSq33kw2834dQ2+YkZewsx6b7BYb8/AzZll69Rbjxcvur+87/n
F9zP8VuxdJQD16l9lQVT+yo9pvZVqmdeW2aj1oDSKN0diy6lYvRUzR5THg0l
yXnf538h+XrL59fFd/KQ/EFz1ap/ZJyR8vcu9fTBys7B+tdmkk9279N9KMSD
XqzDOmEfLiRGBfkNlSnoLu630iT9tD6N5iC2lMLe0z3BIVaEMzfvkNIk/lry
5XifgmoH3m2a/eLgZD3i/L/Wvn/QC6Z+oLN5bB9szwmLsjS4YNWtHK8gvvs9
+6sQJ4eDKsan5CY6Fz4aNxOytSgMRTEXRpP/4259Vc6F9O0+F6PCsS9cHH17
J2LJmU7sdFuyMkm1CWNSJQcfnumDvPysv6rWXbjBEkySrGgGZb5oyeb5/Vha
dtkxXImFgyWdAxHtLMxnm/R9Jhz4Xv/84K2gBnzdcu6RuXkGfPhW7FVdT8eY
zGP34olGNK0osJxzNx/332wsG9FiYO7U/SCVU/eDTJ+6H8Rgem67TkoLNq9V
UbafLEfJwP7ZS2UIb948Y66zrBH/hJ7f+auSgwDN/SgKocP0bebsBQdIPaZ+
vPiO5JeGz8pyi0h+Ec9edEjwEw/X1mh9GSecuOKy89YEOgd/ri8PWEr8tGS7
ZL8p8UPrAybXK4mfSu3fGO94n4u256ySL8sorPEz+Nrf8t/vVeYlZ3zhQW7o
Sfp6whOXxHdWxXdzsLtCx/Ew8btB8afsCuJ35+c7PAHxu5SFYae/qzdBaBl3
0Y01BdgXpHdH5wDxQfq2oCNy/fCruDc8cJCL1/xuDdY8CgONi+MOevGQNf5t
S04VBYvXVntq/7tvd2VXXrpPM8ZGNFIv9pdgNLAn4Nc2Jmxyckun/ejF1dT0
iPfWHBxxr88QMOCBJyqtLqjaA4lnz32S9dox7Wl4TNUVDs5f5cvQKOLhov6H
91+YFD7HHjm6u4UDqawaO/9FA7i2Mk7rNh8Pr7N8nUYSOej7dzLqZyYLjcWH
ksZq2ai9XfhVTYOHS1v2rZQP40E/+U9mXDOF1C7nsFrCXbX3HUIiT1IYLpS0
unqBQkpYVG/NZeIjHx1/Pc1kQC6he192CAMll67e8VjKg/XY6jApCx44/Dsk
Y7JI3np8N7dIhIv4XRqq0eLkuM2lpIb3FK59/345j+TDtwtSzDw8eVhStmih
Ipmfeb22HtHDHBSd+lUvtrcBcc6bbltfTEPa08kv4rPo2HVwectOox7syPfz
DnraDt2HD3z3hXBgdre1aBrh6om370/Fz8zExx3z1Sq20aE8Vc/W/6eeVdxP
1GusZaPXQbvsyZNebBz++YpN8tG6dQ07ljoxsS/pQdzGDCZWLd7m8oLkrxrD
ba8okidW3n/b+UePCdMzVUplJDf5rA49on+a9PP9tMQDThSU8gw037pwwZ98
g79Ruxe2KfLWipr9OC8rLFpB/KItkE82UrMXVT2utsXL+/E3fH58HDlu+twk
Kvi/+yceOwfeNO1G+Yc5ZvMXk5y6q0nx0/M2iC6Sm966sRbTcnLY0o5spMh5
56kUtmDr+NOYIysrMHP57jFdkt/CnmxM5lNqhFBQI8d/UQ70Zh3crx1Mh318
19mjjH4U/NkbvD2Yi4sVse8ePqOwcm39sOQJCtpKLhJDjhR279DZ5HmFi2WK
YX1HvFiA6beYa5fZeLXhSEqXGg+t4xZX7oly8UZkyevUv1wsdb27blTsv31J
0wf/zGrEd0cB9wCbbGhJeYqs96ZDoeiecoNQA+ipeZwZl1OQsfZBdHA9DdUn
BdozLvPwoJ92Z10ZBd6PP+KccQ7YuG/sdqUBpw/L1CecTscOvwX2w3J0DF4q
2Mpf3Y6+dk1W35F6yOtHhodt68UCrfdJ82soPJkfeW8kgMK7lEC6vCkXe6eu
b3+bur7dOHV9+5Ouwvw0FQYcDuxVf/qBDlzaWSFNdPXkmefPbsyloVWWUpG2
7YL081sGWemkzoc3H9I+1Q5lwUW55z/UoZ+jyozl68XQYrurTsn9mLg4NDJK
ctrTHEMp+VgKlmWZH5Y29+HsnK6MFnCh8pGe/VWUh6i/wptLjRjo6inye99C
R/VeZ98c8n/zRPJ2zLKjEJmw88z38yTHxYSX9rhyocpx3dSVyESka2TEFbKu
EU7FXTKqPNgviMzUNOEiztQ6dSuZ95l7zRYLjRA+mdr/Yz21/2dm0v/2/6jL
qi0KMOvFwFlttFr043lYjyE28FCbsnWkQKQf924Wn03fzUXmHf6B+CEKwVff
m0w70Ajh+SzFaINcqOWFhc/JouOSV5bTDr5m7A0VOCkmWAyLWFWVmD4G6v85
7j0V1Qd+/bcFQWpcfPIZecMkOrBJaUUrpciF6JK5Wu38FGwbdlsen0m4TfHW
32QbwoHcnknRjhowjd8uPGzCxhYz85ezLEnuEFsX9ck4F7uPVnOuZ9PxrmF9
3PfcRiTt8Lt3MyEPp+8eiV4nyIB20L6o8gNN4B53iA1LL8BZ53v6950Z8DuR
sWYGjayz1tD1v0R/J3tDw1rLOfCscjsSnUTy+ueKp21dFLa2Nf1c3cNB/xzh
35lHeNieYVfQnU/0zTQ4uXAGF19bOQelDJlwstwb3XaGiWfSeuddVEj/RtWp
XNFjYEzYQcKsnI7Tv5QmH5N1PDgnrG6XdBd89hR6VR5uRnCe/7wFvX1gxxy8
UEP8K3gr7zuL+FewFmdloRAXwVPft6pOfd+6Yer71qN7N13T0GxFQEuEwIO3
lWgQW7yv4yILW5i6/ZK6zaj9WiciXFuMzxvC/beIM3HvXp3wu6Fm+HwayTK2
/YaPolulFj9jIkDberP5By7m3TJl7NekwFEVW2lGcuJ7Jbcu5elsTBfjy1u5
qRcxf5jP8zV5EJWa+fjwbjZW6TL8L+X2wu/dkV7/NTw0XDw35ERyqsX34I92
a4gvKAi5+xST8a9NKNKNYGFj9OodTVFsaBzSlLmnzoPJ0rCTc+uYWCRro/jc
koU3X//y6knd8sn+jxOoKU54NMUJp4+debhfrg2Lefd3HnCuQcFDfR09KTY+
rNqh+ZXk9TCzENrdOMLVcqfyLpF6KuU9UuVqtoE+EHn37ZMaiPycyzNTYcO8
0Egh5A0NG4w95tZr9qDAubz4wCMKfH+i9nPGOhAxQ2f0kEMjLKSlv59Y0gdT
nrnAuHMnUox/v7HTacKM2tz58536oPD94+v3Olx8ZPMFSM0mXKExWvSW6Jxk
Lk3OlOjfRKWkiF0iBfuNWm940lyYGHsN/dVuw2C+p6BrSA22S22d1a7Kxsx4
uCTa0VAaN22Rl2s3vFoqOAySz4pbAh0fpHLRkeN4NmcdhT0ChSk2JP9dO2by
iJ/kq9e+vk0hHhTCNwr/Kj/MRWFl4NYrZP78Sy0jpRMorFbUrXstQ8YTcW25
EbcVG5WO2lQsrMG90D9ur4dY0JEJL4g+0AlHVuzTVsEmvO7JjOyw6cPq19Ub
AjyasHW7fSxzeyEOB27yZD5m4PKLpJu9jG68njAOSbjahgNHX/waU+Fg0ap1
/kdm9JL6/EDF0vpw1/XD6Q/reQj53enlWNCPH3waN6IfE92T9bRqjyI8rT4v
9k8JE/ufuJUf3sqCxMbts4LJuDU4WbILjZhQP51/ueMiE2tC424/IX20paf5
HT2uB2c7om02zOzE3mTWu6WEc/kuC317eaMD24u7YnJ9G2C76sXTiIJeNKqs
W7vifTM+3/J3Kd9VipVirzteH2ZihR+fgceBehSbXJ5X8ywRQTNeSzzZT4Op
vUOc65NmhL/eL0bjK8Vuj5edn82Z+GH8Z0HlxmZkare42PYVo1qkzmFyARNq
mseja/qJLznovT//vgdqj9Uu6VDED7NO+brmdsKgesXS1twmVJYf36P/rg8e
m22+obIOthveZF37GofPt61qpIZ6oCgp372ykcyjxGiOR1wtlv+bt2VWCBuG
Z7ldckSfDmSOFtxWYCC8KGRlqSIPxcvctzkubAR/KW2OQl42RMa/nDjqT8ct
faW5y4juB2nc3/qpm4VvH9Qjsol/DdmFXhTQZuPTSJ28Z2Av3v2dNB0k3HIm
4iz3+l06KHaxNestDeHfbv08TXKcV+TG01IkN88R9WxzsaWjwf60KJ88D3v4
I3xb0sn6xP/y20SjYL6Zm/erg4OllW8Pujv3QPLsBR3dtR1Qk3icurmdg49C
5pk5/+1jUv0M9T1MDNxcXidF1lFuIcODVklH+sZZphukybh1fa6Lkb4N1bWU
ffWiBwqNr9M2ZnZA1ddpu+E8LoJ2sB44StMwz2GoSdWrCzWTrWlyJC+LZB8I
nS1BxzElq81RP3qwFRk/6qR4+H/C0oSe
    "]],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  Method->{},
  PlotRange->
   NCache[{{-Pi, Pi}, {-Pi, Pi}}, {{-3.141592653589793, 
    3.141592653589793}, {-3.141592653589793, 3.141592653589793}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->487900749,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26031],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Binomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Binomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Beta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Beta"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31724],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->15346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3200],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/MultinomialCoefficient.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/Multinomial/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Multinomial"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->288644764],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->61555787],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->39431500],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->291226990]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Multinomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 13.4183090}", "context" -> "System`", 
    "keywords" -> {
     "multinomial", "multinomial coefficients", "number of partitions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Multinomial[n_1, n_2, ...] gives the multinomial coefficient (n_1 + n_2 \
+ ...)!/(n_1! n_2! ...). ", "synonyms" -> {}, "title" -> "Multinomial", 
    "type" -> "Symbol", "uri" -> "ref/Multinomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6256, 208, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->652990462]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 339474, 6592}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2249, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2872, 80, 49, 1, 70, "ObjectName",
 CellID->17633],
Cell[2924, 83, 1170, 38, 70, "Usage",
 CellID->19351]
}, Open  ]],
Cell[CellGroupData[{
Cell[4131, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4609, 143, 132, 4, 70, "Notes",
 CellID->126685801],
Cell[4744, 149, 1261, 45, 70, "Notes",
 CellID->18625],
Cell[6008, 196, 211, 7, 70, "Notes",
 CellID->555347927]
}, Closed]],
Cell[CellGroupData[{
Cell[6256, 208, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->652990462],
Cell[CellGroupData[{
Cell[6641, 222, 148, 5, 70, "ExampleSection",
 CellID->244331290],
Cell[CellGroupData[{
Cell[6814, 231, 139, 4, 28, "Input",
 CellID->88658836],
Cell[6956, 237, 159, 5, 36, "Output",
 CellID->327531263]
}, Open  ]],
Cell[7130, 245, 209, 7, 70, "ExampleText",
 CellID->400442616],
Cell[CellGroupData[{
Cell[7364, 256, 184, 6, 28, "Input",
 CellID->243236155],
Cell[7551, 264, 1187, 36, 54, "Output",
 CellID->272372370]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8787, 306, 215, 7, 70, "ExampleSection",
 CellID->2344],
Cell[9005, 315, 89, 1, 70, "ExampleText",
 CellID->178486459],
Cell[CellGroupData[{
Cell[9119, 320, 140, 4, 70, "Input",
 CellID->554573752],
Cell[9262, 326, 478, 17, 51, "Output",
 CellID->911247395]
}, Open  ]],
Cell[CellGroupData[{
Cell[9777, 348, 149, 4, 70, "Input",
 CellID->20062039],
Cell[9929, 354, 707, 25, 51, "Output",
 CellID->194487320]
}, Open  ]],
Cell[10651, 382, 124, 3, 70, "ExampleDelimiter",
 CellID->38519095],
Cell[10778, 387, 81, 1, 70, "ExampleText",
 CellID->384162706],
Cell[CellGroupData[{
Cell[10884, 392, 172, 5, 70, "Input",
 CellID->13539723],
Cell[11059, 399, 160, 5, 36, "Output",
 CellID->373103295]
}, Open  ]],
Cell[CellGroupData[{
Cell[11256, 409, 107, 3, 70, "Input",
 CellID->282644420],
Cell[11366, 414, 157, 5, 36, "Output",
 CellID->72455335]
}, Open  ]],
Cell[11538, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->996659982],
Cell[11666, 427, 80, 1, 70, "ExampleText",
 CellID->315449466],
Cell[CellGroupData[{
Cell[11771, 432, 184, 6, 70, "Input",
 CellID->154945223],
Cell[11958, 440, 336, 10, 54, "Output",
 CellID->530031291]
}, Open  ]],
Cell[12309, 453, 125, 3, 70, "ExampleDelimiter",
 CellID->173966702],
Cell[12437, 458, 95, 3, 70, "ExampleText",
 CellID->640061315],
Cell[CellGroupData[{
Cell[12557, 465, 211, 7, 70, "Input",
 CellID->35310702],
Cell[12771, 474, 183, 6, 51, "Output",
 CellID->33532087]
}, Open  ]],
Cell[12969, 483, 125, 3, 70, "ExampleDelimiter",
 CellID->257459341],
Cell[13097, 488, 67, 1, 70, "ExampleText",
 CellID->30822883],
Cell[CellGroupData[{
Cell[13189, 493, 165, 5, 70, "Input",
 CellID->324413767],
Cell[13357, 500, 174, 5, 36, "Output",
 CellID->649246]
}, Open  ]],
Cell[13546, 508, 125, 3, 70, "ExampleDelimiter",
 CellID->739669181],
Cell[13674, 513, 74, 1, 70, "ExampleText",
 CellID->861395129],
Cell[CellGroupData[{
Cell[13773, 518, 274, 10, 70, "Input",
 CellID->398811977],
Cell[14050, 530, 271, 7, 36, "Output",
 CellID->163918392]
}, Open  ]],
Cell[14336, 540, 125, 3, 70, "ExampleDelimiter",
 CellID->437153892],
Cell[14464, 545, 79, 1, 70, "ExampleText",
 CellID->365075382],
Cell[CellGroupData[{
Cell[14568, 550, 296, 10, 70, "Input",
 CellID->27862721],
Cell[14867, 562, 1098, 33, 67, "Output",
 CellID->778198374]
}, Open  ]],
Cell[15980, 598, 124, 3, 70, "ExampleDelimiter",
 CellID->52626280],
Cell[16107, 603, 203, 7, 70, "ExampleText",
 CellID->805077600],
Cell[CellGroupData[{
Cell[16335, 614, 181, 6, 70, "Input",
 CellID->18325408],
Cell[16519, 622, 377, 14, 50, "Output",
 CellID->12984547]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16945, 642, 238, 7, 70, "ExampleSection",
 CellID->8352],
Cell[17186, 651, 223, 7, 70, "ExampleText",
 CellID->79608146],
Cell[CellGroupData[{
Cell[17434, 662, 229, 7, 70, "Input",
 CellID->504928409],
Cell[17666, 671, 258, 8, 36, "Output",
 CellID->258382755]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17973, 685, 222, 7, 70, "ExampleSection",
 CellID->6070],
Cell[18198, 694, 79, 1, 70, "ExampleText",
 CellID->623913885],
Cell[CellGroupData[{
Cell[18302, 699, 665, 20, 70, "Input",
 CellID->172247567],
Cell[18970, 721, 1187, 36, 54, "Output",
 CellID->526219232]
}, Open  ]],
Cell[CellGroupData[{
Cell[20194, 762, 102, 3, 70, "Input",
 CellID->323400314],
Cell[20299, 767, 237, 8, 36, "Output",
 CellID->29662069]
}, Open  ]],
Cell[20551, 778, 125, 3, 70, "ExampleDelimiter",
 CellID->204336319],
Cell[20679, 783, 300, 10, 70, "ExampleText",
 CellID->204289743],
Cell[CellGroupData[{
Cell[21004, 797, 446, 13, 70, "Input",
 CellID->53021260],
Cell[21453, 812, 14564, 243, 70, "Output",
 Evaluatable->False,
 CellID->213259137]
}, Open  ]],
Cell[36032, 1058, 125, 3, 70, "ExampleDelimiter",
 CellID->268866017],
Cell[36160, 1063, 81, 1, 70, "ExampleText",
 CellID->295173371],
Cell[36244, 1066, 778, 25, 70, "Input",
 CellID->773946705],
Cell[CellGroupData[{
Cell[37047, 1095, 823, 24, 70, "Input",
 CellID->480768013],
Cell[37873, 1121, 12883, 215, 70, "Output",
 Evaluatable->False,
 CellID->57113631]
}, Open  ]],
Cell[50771, 1339, 125, 3, 70, "ExampleDelimiter",
 CellID->457424684],
Cell[50899, 1344, 922, 32, 70, "ExampleText",
 CellID->35812094],
Cell[CellGroupData[{
Cell[51846, 1380, 302, 10, 70, "Input",
 CellID->412127704],
Cell[52151, 1392, 376, 13, 68, "Output",
 CellID->56106015]
}, Open  ]],
Cell[52542, 1408, 75, 1, 70, "ExampleText",
 CellID->602650937],
Cell[CellGroupData[{
Cell[52642, 1413, 901, 26, 70, "Input",
 CellID->493784226],
Cell[53546, 1441, 390, 14, 68, "Output",
 CellID->24690353]
}, Open  ]],
Cell[CellGroupData[{
Cell[53973, 1460, 139, 4, 70, "Input",
 CellID->154487320],
Cell[54115, 1466, 161, 5, 36, "Output",
 CellID->109018583]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54325, 1477, 233, 7, 70, "ExampleSection",
 CellID->11367],
Cell[54561, 1486, 237, 8, 70, "ExampleText",
 CellID->569247390],
Cell[CellGroupData[{
Cell[54823, 1498, 128, 4, 70, "Input",
 CellID->460210662],
Cell[54954, 1504, 159, 5, 36, "Output",
 CellID->22377690]
}, Open  ]],
Cell[CellGroupData[{
Cell[55150, 1514, 130, 4, 70, "Input",
 CellID->358454813],
Cell[55283, 1520, 159, 5, 36, "Output",
 CellID->59918093]
}, Open  ]],
Cell[55457, 1528, 125, 3, 70, "ExampleDelimiter",
 CellID->243509429],
Cell[55585, 1533, 253, 8, 70, "ExampleText",
 CellID->40279076],
Cell[CellGroupData[{
Cell[55863, 1545, 337, 10, 70, "Input",
 CellID->274592871],
Cell[56203, 1557, 202, 7, 51, "Output",
 CellID->54555526]
}, Open  ]],
Cell[56420, 1567, 125, 3, 70, "ExampleDelimiter",
 CellID->643748604],
Cell[56548, 1572, 343, 13, 70, "ExampleText",
 CellID->344380312],
Cell[CellGroupData[{
Cell[56916, 1589, 204, 6, 70, "Input",
 CellID->116867745],
Cell[57123, 1597, 548, 17, 53, "Output",
 CellID->215794002]
}, Open  ]],
Cell[57686, 1617, 125, 3, 70, "ExampleDelimiter",
 CellID->747390567],
Cell[57814, 1622, 314, 12, 70, "ExampleText",
 CellID->360211402],
Cell[CellGroupData[{
Cell[58153, 1638, 150, 4, 70, "Input",
 CellID->385357238],
Cell[58306, 1644, 237, 7, 36, "Output",
 CellID->7058096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58592, 1657, 225, 7, 70, "ExampleSection",
 CellID->8919],
Cell[58820, 1666, 119, 3, 70, "ExampleText",
 CellID->65254562],
Cell[CellGroupData[{
Cell[58964, 1673, 220, 7, 70, "Input",
 CellID->64316533],
Cell[59187, 1682, 357, 7, 70, "Message",
 CellID->130662672],
Cell[59547, 1691, 357, 7, 70, "Message",
 CellID->160092221],
Cell[59907, 1700, 170, 5, 36, "Output",
 CellID->149931786]
}, Open  ]],
Cell[60092, 1708, 125, 3, 70, "ExampleDelimiter",
 CellID->287306201],
Cell[60220, 1713, 113, 3, 70, "ExampleText",
 CellID->590663712],
Cell[CellGroupData[{
Cell[60358, 1720, 217, 7, 70, "Input",
 CellID->46743626],
Cell[60578, 1729, 206, 5, 36, "Output",
 CellID->34456116]
}, Open  ]],
Cell[CellGroupData[{
Cell[60821, 1739, 109, 3, 70, "Input",
 CellID->77840443],
Cell[60933, 1744, 162, 5, 36, "Output",
 CellID->377645812]
}, Open  ]],
Cell[61110, 1752, 124, 3, 70, "ExampleDelimiter",
 CellID->78494453],
Cell[61237, 1757, 273, 8, 70, "ExampleText",
 CellID->566941073],
Cell[CellGroupData[{
Cell[61535, 1769, 154, 5, 70, "Input",
 CellID->774637896],
Cell[61692, 1776, 170, 5, 36, "Output",
 CellID->108613501]
}, Open  ]],
Cell[CellGroupData[{
Cell[61899, 1786, 167, 5, 70, "Input",
 CellID->3885154],
Cell[62069, 1793, 192, 6, 36, "Output",
 CellID->133072350]
}, Open  ]],
Cell[CellGroupData[{
Cell[62298, 1804, 175, 5, 70, "Input",
 CellID->512295117],
Cell[62476, 1811, 158, 5, 36, "Output",
 CellID->408779621]
}, Open  ]],
Cell[CellGroupData[{
Cell[62671, 1821, 168, 5, 70, "Input",
 CellID->31538948],
Cell[62842, 1828, 173, 5, 36, "Output",
 CellID->216112829]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63064, 1839, 224, 7, 70, "ExampleSection",
 CellID->24487],
Cell[63291, 1848, 59, 1, 70, "ExampleText",
 CellID->33260424],
Cell[CellGroupData[{
Cell[63375, 1853, 605, 19, 70, "Input",
 CellID->106228383],
Cell[63983, 1874, 7036, 119, 70, "Output",
 Evaluatable->False,
 CellID->111562761]
}, Open  ]],
Cell[CellGroupData[{
Cell[71056, 1998, 704, 22, 70, "Input",
 CellID->270483980],
Cell[71763, 2022, 6508, 111, 70, "Output",
 Evaluatable->False,
 CellID->446975760]
}, Open  ]],
Cell[78286, 2136, 52, 1, 70, "ExampleText",
 CellID->551446662],
Cell[CellGroupData[{
Cell[78363, 2141, 605, 19, 70, "Input",
 CellID->511236652],
Cell[78971, 2162, 11327, 190, 70, "Output",
 Evaluatable->False,
 CellID->163124546]
}, Open  ]],
Cell[90313, 2355, 124, 3, 70, "ExampleDelimiter",
 CellID->31413146],
Cell[90440, 2360, 86, 1, 70, "ExampleText",
 CellID->28537817],
Cell[CellGroupData[{
Cell[90551, 2365, 702, 23, 70, "Input",
 CellID->289351595],
Cell[91256, 2390, 88040, 1447, 70, "Output",
 Evaluatable->False,
 CellID->188524424]
}, Open  ]],
Cell[179311, 3840, 125, 3, 70, "ExampleDelimiter",
 CellID->770291701],
Cell[179439, 3845, 217, 8, 70, "ExampleText",
 CellID->478760569],
Cell[CellGroupData[{
Cell[179681, 3857, 679, 21, 70, "Input",
 CellID->97149888],
Cell[180363, 3880, 154417, 2547, 246, 71925, 1190, "CachedBoxData", \
"BoxData", "Output",
 CellID->487900749]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[334841, 6434, 311, 9, 70, "SeeAlsoSection",
 CellID->26031],
Cell[335155, 6445, 690, 26, 70, "SeeAlso",
 CellID->11221]
}, Open  ]],
Cell[CellGroupData[{
Cell[335882, 6476, 314, 9, 70, "TutorialsSection",
 CellID->31724],
Cell[336199, 6487, 156, 3, 70, "Tutorials",
 CellID->15346]
}, Open  ]],
Cell[CellGroupData[{
Cell[336392, 6495, 320, 9, 70, "RelatedLinksSection",
 CellID->3200],
Cell[336715, 6506, 193, 4, 70, "RelatedLinks"],
Cell[336911, 6512, 196, 4, 70, "RelatedLinks"],
Cell[337110, 6518, 389, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337536, 6536, 319, 9, 70, "MoreAboutSection",
 CellID->288644764],
Cell[337858, 6547, 156, 3, 70, "MoreAbout",
 CellID->61555787],
Cell[338017, 6552, 164, 3, 70, "MoreAbout",
 CellID->39431500],
Cell[338184, 6557, 145, 3, 70, "MoreAbout",
 CellID->291226990]
}, Open  ]],
Cell[338344, 6563, 27, 0, 70, "History"],
Cell[338374, 6565, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

