(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    218550,       5723]
NotebookOptionsPosition[    194311,       4856]
NotebookOutlinePosition[    195850,       4897]
CellTagsIndexPosition[    195763,       4892]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematics-BasicOperations"], 
          "Exact and Approximate Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExactAndApproximateResults"], 
          "Arbitrary\[Hyphen]Precision Calculations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionCalculations"], 
          "Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"], 
          "Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"], 
          "Defining Numerical Values" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DefiningNumericalValues"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Numerical Mathematics: Basic Operations\"\>", 
       2->"\<\"Exact and Approximate Results\"\>", 
       3->"\<\"Arbitrary\[Hyphen]Precision Calculations\"\>", 
       4->"\<\"Numerical Precision\"\>", 
       5->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>", 
       6->"\<\"Defining Numerical Values\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Chop" :> Documentation`HelpLookup["paclet:ref/Chop"], 
          "CompiledFunction" :> 
          Documentation`HelpLookup["paclet:ref/CompiledFunction"], 
          "Rationalize" :> Documentation`HelpLookup["paclet:ref/Rationalize"],
           "MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/MachinePrecision"], "NHoldAll" :> 
          Documentation`HelpLookup["paclet:ref/NHoldAll"], "RealDigits" :> 
          Documentation`HelpLookup["paclet:ref/RealDigits"], "PossibleZeroQ" :> 
          Documentation`HelpLookup["paclet:ref/PossibleZeroQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Chop\"\>", 
       2->"\<\"CompiledFunction\"\>", 3->"\<\"Rationalize\"\>", 
       4->"\<\"MachinePrecision\"\>", 5->"\<\"NHoldAll\"\>", 
       6->"\<\"RealDigits\"\>", 
       7->"\<\"PossibleZeroQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Display of Numbers\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Precision & Accuracy Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["N", "ObjectName",
 CellID->14969],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["N",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/N"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the numerical value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["N",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/N"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to give a result with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21813]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Unless numbers in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " are exact, or of sufficiently high precision, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " may not be able to give results with ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision. "
}], "Notes",
 CellID->14398],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " may internally do computations to more than ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " digits of precision. "
}], "Notes",
 CellID->1244],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " specifies the maximum number of extra digits of precision that will ever \
be used internally. "
}], "Notes",
 CellID->20359],

Cell[TextData[{
 "The precision ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is given in decimal digits; it need not be an integer. "
}], "Notes",
 CellID->26850],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must lie between ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " can be set to ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20456],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be smaller than ",
 Cell[BoxData[
  ButtonBox["$MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachinePrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25605],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " gives a machine\[Hyphen]precision number, so long as its magnitude is \
between ",
 Cell[BoxData[
  ButtonBox["$MinMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$MaxMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxMachineNumber"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25810],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8428],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", "0", "]"}]], "InlineFormula"],
 " gives the number ",
 Cell[BoxData["0."], "InlineFormula"],
 " with machine precision. "
}], "Notes",
 CellID->3913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " converts all nonzero numbers to ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " form. "
}], "Notes",
 CellID->420],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " converts each successive argument of any function it encounters to \
numerical form, unless the head of the function has an attribute such as ",
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16882],

Cell[TextData[{
 "You can define numerical values of functions using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]"}], "]"}], ":=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["args", "TI"], "]"}], ",", 
     StyleBox["n", "TI"]}], "]"}], ":=", 
   StyleBox["value", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3032],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["p", "TI"], ",", 
      StyleBox["a", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " attempts to generate a result with precision at most ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " and accuracy at most ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23266],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"], ",", 
      StyleBox["a", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " attempts to generate a result with accuracy ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16387],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"], ",", "1"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " attempts to find a numerical approximation to the integer part of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20631]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->493011386],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->104525302],

Cell["Evaluate numerically:", "ExampleText",
 CellID->1866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1", "/", "7"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19168],

Cell[BoxData["0.14285714285714285`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27147]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->371],

Cell["Evaluate numerically to 50-digit precision:", "ExampleText",
 CellID->1137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "/", "7"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26633],

Cell[BoxData["0.\
1428571428571428571428571428571428571428571428571428571428571428572`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7862],

Cell["\<\
With machine-precision input, the results are always machine precision:\
\>", "ExampleText",
 CellID->5320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", "3.3", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27101],

Cell[BoxData["2.6834373819557684`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32555]
}, Open  ]],

Cell["\<\
With exact input, the results can be to the precision specified:\
\>", "ExampleText",
 CellID->4685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"33", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28086],

Cell[BoxData["2.\
6834373819557687935963273147667112586281870043547784561314710348953`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13117]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(16)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19763],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Mathematical Constants",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1001097239],

Cell["Evaluate mathematical constants to any precision:", "ExampleText",
 CellID->10648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27932],

Cell[BoxData["3.\
1415926535897932384626433832795028841971693993751058209749445923078`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Khinchin", ",", "50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28953],

Cell[BoxData["2.\
6854520010653064453097148354817956938203822939944629530511523455572`49.\
999999999999986"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31146]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213],

Cell["Get approximate values for large integers: ", "ExampleText",
 CellID->24709029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1000", "!"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23594],

Cell[BoxData["4.02387260077093773543702433923004`15.954589770191005*^2567"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15707]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"2", "^", "1000000"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->458426057],

Cell[BoxData["9.9006562292958982506979236163`15.954589770191005*^301029"], \
"Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59101300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12075],

Cell["Complex number results:", "ExampleText",
 CellID->3266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"ArcSin", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16729],

Cell[BoxData[
 RowBox[{"1.5707963267948966`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.762747174039086`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->360293750],

Cell[TextData[{
 "More elaborate symbolic mathematical constants can be detected using ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->374862793],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Exp", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Sqrt", "[", "2", "]"}], "]"}], "+", 
     RowBox[{"BesselJ", "[", 
      RowBox[{"3", ",", "4"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328515039],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "c", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->455279925],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->381217043]
}, Open  ]],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " expressions represent numbers that can be evaluated to any precision:"
}], "ExampleText",
 CellID->404146082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "c", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->590679954],

Cell[BoxData["4.128596091926912`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->252103719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"c", ",", "47"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->567233550],

Cell[BoxData["4.1285960919269121334399493403233126676526451558587586375393`47.\
"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->56172177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "General Expressions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->136221808],

Cell["Evaluate the entries of a matrix numerically:", "ExampleText",
 CellID->403717263],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Cos", "[", "1", "]"}], ",", 
       RowBox[{"Sin", "[", "1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"Sin", "[", "1", "]"}]}], ",", 
       RowBox[{"Cos", "[", "1", "]"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206266736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->356929403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.5403023058681398`", ",", "0.8414709848078965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8414709848078965`"}], ",", "0.5403023058681398`"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->164898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136693263],

Cell["\<\
Evaluate numerically the numeric parts of a symbolic expression:\
\>", "ExampleText",
 CellID->204092144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"Pi", "+", 
      RowBox[{"2", " ", "x"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"E", "-", "x"}], ")"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->715599762],

Cell[BoxData[
 FractionBox[
  RowBox[{"3.14159265358979323846264338358607339165`20.", "+", 
   RowBox[{"2.`20.", " ", "x"}]}], 
  RowBox[{"2.71828182845904523536028579257075851155`20.", "-", 
   RowBox[{"1.`20.", " ", "x"}]}]]], "Output",
 ImageSize->{325, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384945641]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12681980],

Cell["Make the coefficients of a polynomial numerical:", "ExampleText",
 CellID->2881526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"poly", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{"Product", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "i"}], ")"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27022051],

Cell[BoxData[
 RowBox[{"3628800", "-", 
  RowBox[{"10628640", " ", "x"}], "+", 
  RowBox[{"12753576", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"8409500", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"3416930", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"902055", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"157773", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"18150", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"1320", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"55", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{418, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296439037]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "poly", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->401946374],

Cell[BoxData[
 RowBox[{"3.6288`*^6", "-", 
  RowBox[{"1.062864`*^7", " ", "x"}], "+", 
  RowBox[{"1.2753576`*^7", " ", 
   SuperscriptBox["x", "2"]}], "-", 
  RowBox[{"8.4095`*^6", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"3.41693`*^6", " ", 
   SuperscriptBox["x", "4"]}], "-", 
  RowBox[{"902055.`", " ", 
   SuperscriptBox["x", "5"]}], "+", 
  RowBox[{"157773.`", " ", 
   SuperscriptBox["x", "6"]}], "-", 
  RowBox[{"18150.`", " ", 
   SuperscriptBox["x", "7"]}], "+", 
  RowBox[{"1320.`", " ", 
   SuperscriptBox["x", "8"]}], "-", 
  RowBox[{"55.`", " ", 
   SuperscriptBox["x", "9"]}], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{480, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->646317973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Machine and Adaptive Precision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->51147739],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " typically works by replacing numbers with machine numbers and computing \
the result:"
}], "ExampleText",
 CellID->412714797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "[", "h_", "]"}], "=", 
  RowBox[{
   RowBox[{"Cos", "[", "1", "]"}], "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"1", "+", "h"}], "]"}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"1", "-", "h"}], "]"}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"2", " ", "h"}], ")"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->955455176],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "1", "]"}], "-", 
  FractionBox[
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Sin", "[", 
      RowBox[{"1", "-", "h"}], "]"}]}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{"1", "+", "h"}], "]"}]}], 
   RowBox[{"2", " ", "h"}]]}]], "Output",
 ImageSize->{207, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261139128]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"e", "[", 
   RowBox[{"10", "^", 
    RowBox[{"-", "12"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->479035102],

Cell[BoxData["0.000012270934307334613`"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->471414578]
}, Open  ]],

Cell["This is equivalent to the expression with machine numbers:", \
"ExampleText",
 CellID->574141463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "[", 
  RowBox[{"10.", "^", 
   RowBox[{"-", "12"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->19967784],

Cell[BoxData["0.000012270934307334613`"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->951646967]
}, Open  ]],

Cell["\<\
The machine roundoff error shows up clearly on a log-log plot of the \
difference quotient error:\
\>", "ExampleText",
 CellID->657364638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"h", "=", 
    RowBox[{"10", "^", 
     RowBox[{"-", "k"}]}]}], ";", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"h", ",", 
       RowBox[{"Abs", "[", 
        RowBox[{"N", "[", 
         RowBox[{"e", "[", "h", "]"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->676729120],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV89rE1EQ3ibZTbS4ouZXkWo8FSSC0F6EBkGpHkRPSvEgGIrSHGxL04ug
F6EntRdzKXhU/wGL/gFe9OTVs//I+n7sZjbfTt6+l6bag4HsZuZ9M2/mm5m3
m7vdnfUnz7o7vbVu6/Z2d2u9t9Zv3drcFqrijOd5B+K70fTE70j8Ut+DKBL3
9LUtrkWxVBD3grjXQG6AXAV5Lr4XpTe5EKmP+llRO1yR1xKtaNs09lwuopaL
ODuBjwAQ5f/xHot4pZ0UvZJe15/A2i7pzYqVRVo+kWtRBnl2almj58xE2Xkw
IvxjxEg7opMjuZe4kwTkgsnOGGnJcsfyGJwG6o/Un4rXg/iuuPI6o3HEa/Xc
6Gog11Oy3PESeQc20nLVeZ9GHCHvH7nJP0uyiObIDsuxJO2kWQ3YTp44c+D3
orLWT60LsPaO1T5W8scPP6939t+++eZdVajz4rqvaoj4JsgYAa6HSv7x/ffm
xuevX35lJgHtT7JRLuXs4kMWbSuvq0peffBJWK3cfO9dM6AoAx7Fs3t47T3I
7IYBRZmYUJSJRuET4QwbV/65Gf5jux4wtWDpx4/zLsc89IBLWz/Y2SU2PmJ/
Ycg+d44mk++DlxXI8o7ykn2vQLtlsAsgSzc/ZBdAVm5+yO6+gtUjelr8jely
1+ZNyyLw/Miye7CbF4FnFz8yriXgtwNxzTv4k2If4rG1x0piH/Qhzmn5pWrZ
vM3grGrrxhRR+ROhcfWIn3u+Jy9DVZ8aUFQ7E4oqwaNcZ0PeB5Y1DSfAp+UX
wEbVcd+XwJOtvR/nneTfgjgeArO2fisgY9e2IN6tYRW4nse+5L1RlNobvmmh
FXXt+HO7HmX54ueoYN35LtoG1OO5AUVsmlDEEo8yRZe8b2T+s0HNikzNtAel
HekcpQnSmog6yh/qtTLD8C7wMzu1XeQmu8Dr9Lxnc6C6HM0uR8P/aF9w88vN
RQhVexVxPRcC+yYUscejXGYO/5G9NqAoOhOKouNRpuhOR/zMjZ+xMFNjPNvQ
1x5kXDiUH+LExY8U94CtSeOYlIdRxpNudjnV5xMmxYJkcpDSCl6EVvKS1ops
hVZmO3DuDV7rzfwB3c2hgQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->786544531]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->622424864],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " works adaptively using arbitrary-precision numbers when ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " is not ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->150478225],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"e", "[", "h_", "]"}], "=", 
   RowBox[{
    RowBox[{"Cos", "[", "1", "]"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"1", "+", "h"}], "]"}], "-", 
       RowBox[{"Sin", "[", 
        RowBox[{"1", "-", "h"}], "]"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", " ", "h"}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357639806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"e", "[", 
    RowBox[{"10", "^", 
     RowBox[{"-", "12"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2823616],

Cell[BoxData["9.00503843113566195668227634046436`20.*^-26"], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465527033]
}, Open  ]],

Cell["\<\
With adaptive precision, the difference quotient error matches the \
theoretical value:\
\>", "ExampleText",
 CellID->70287448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListLogLogPlot", "[", 
    RowBox[{
     RowBox[{"h", "=", 
      RowBox[{"10", "^", 
       RowBox[{"-", "k"}]}]}], ";", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"h", ",", 
         RowBox[{"Abs", "[", 
          RowBox[{"N", "[", 
           RowBox[{
            RowBox[{"e", "[", "h", "]"}], ",", "20"}], "]"}], "]"}]}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", "0", ",", "16"}], "}"}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"LogLogPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "1", "]"}], " ", 
      RowBox[{
       SuperscriptBox["h", "2"], "/", "6"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"h", ",", 
       RowBox[{"10", "^", 
        RowBox[{"-", "16"}]}], ",", "1"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63027162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->29643640]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->849949596],

Cell[TextData[{
 "The adaptive precision control has a default limit, ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ", for extra precision:"
}], "ExampleText",
 CellID->214898180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "1000"}], "]"}]}], "]"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73161945],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1 - \\@\\(1 - \
1\\/\[ExponentialE]\\^1000\\)\\).\"\>"}]], "Message", "MSG",
 CellID->59978455],

Cell[BoxData["0``69.52287874528034"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3445590]
}, Open  ]],

Cell[TextData[{
 "When the limit is reached, you can locally increase ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " to resolve the difficulty:"
}], "ExampleText",
 CellID->591278822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "500"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "1000"}], "]"}]}], "]"}]}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62554901],

Cell[BoxData["2.5379794487747283826459047397871684596`20.*^-435"], "Output",
 ImageSize->{197, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32362812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->570568123],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " does not raise the precision of approximate numbers in its input:"
}], "ExampleText",
 CellID->549355668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"1.", "+", 
   RowBox[{"2`20", " ", "x"}], "+", 
   RowBox[{"3`30", 
    RowBox[{"x", "^", "2"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18050051],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`20.", " ", "x"}], "+", 
  RowBox[{"3.`30.", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{433, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3253054]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"e", ",", "25"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77494800],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`20.", " ", "x"}], "+", 
  RowBox[{"3.`25.", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352785658]
}, Open  ]],

Cell["\<\
The precision of the result is the same as that of the input:\
\>", "ExampleText",
 CellID->511038408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Precision", "[", "%", "]"}], ",", 
   RowBox[{"Precision", "[", "e", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->790930514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", "MachinePrecision"}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->48886537]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["SetPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetPrecision"]], "InlineFormula"],
 " to increase the precision of input expressions:"
}], "ExampleText",
 CellID->78792451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetPrecision", "[", 
  RowBox[{"e", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->140845274],

Cell[BoxData[
 RowBox[{"1.`20.", "+", 
  RowBox[{"2.`20.", " ", "x"}], "+", 
  RowBox[{"3.`20.", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{496, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->133083394]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Data Objects and Special Rules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14079251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " does not affect exact numeric powers:"
}], "ExampleText",
 CellID->55689949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"x", "^", 
   RowBox[{"(", 
    RowBox[{"3", "/", "2"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->516243537],

Cell[BoxData[
 SuperscriptBox["x", 
  RowBox[{"3", "/", "2"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178537943]
}, Open  ]],

Cell["The base is modified:", "ExampleText",
 CellID->37913914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Pi", "^", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126915185],

Cell[BoxData[
 SuperscriptBox["3.141592653589793`", "x"]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->188455076]
}, Open  ]],

Cell[TextData[{
 "The power is modified if it is not ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->237422699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"E", "^", 
   RowBox[{"(", 
    RowBox[{"x", "+", "Pi"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6055822],

Cell[BoxData[
 SuperscriptBox["2.718281828459045`", 
  RowBox[{"3.141592653589793`", "\[InvisibleSpace]", "+", "x"}]]], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->852597595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"x", "+", "Pi"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6809765],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->386434545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217999918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects are treated based on the represented array:"
}], "ExampleText",
 CellID->206072393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"Abs", "[", 
         RowBox[{"i", "-", "j"}], "]"}]}], "-", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355104775],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1385976]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ns", "=", 
  RowBox[{"N", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387321601],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "13", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 13, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9001611]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MatrixForm", "[", "s", "]"}], ",", 
   RowBox[{"MatrixForm", "[", "ns", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->38595705],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtTGzEQPvswBGMw2OYVIAMT8gvShT6ZFPkRHiYzUGSSEDJDR0lJkeJK
SpeULikpKSlduqSkdPRaSyw6SZZ0B8nADJZWPq12P+2uvgN96R4ffP3WPT7c
725/Our+ODjc/7X98fsRGUorSVL5kCTJ57WE9Eekx37pzx755V3ca9DP9OLi
gj03Sn4y+fT0VMhtJmdZJuQ/TL6/v+dTkjmmhX2mt7e3/X6fdqfIR0oW76CW
aquR9rVop2H1m5sb2m0xmSgZDoeqHtpWSbtskTtCbyrkTSS/Au+E/rpivfSR
Pp3UADs2RH5aE4x2mJrxKPP38VPTgOXJyYn0/vz83GgH+NIJ+HYF2afilT+L
ozcYDDhUAr06eCFGp6KjR5+qiV1Wx7k9Z2dnZHHaXWQyCaWrq6t8S9YnGN1A
K67nWNJEOzc7RqZ6fX1di47IJpJnRiJvSApKJIg9Apn4SLxF8kIuAiyzlHyO
i8QWknlOyUrEkSAxIr6Pj8QukueZ3Ov1hM8qErKuxkfiDZJZ1CmVungk3iGZ
ny0kGUkOlImEvtryaiGrfNPJjhA8drRP0UypElDU6imtoLumOzlpS2vwlpBn
0TzsDejZ0LRUz66Qm0ZrfltWyV5mP7PZOH4w46qLdtGyCujxZVoNJC8ZrZ6k
BrhlewM9ZfNXb0GRbGohZ1ZxSOXxqPkoWIUxKGzrSmEoYO4UJ1L8WFO7NK8x
T5or0WvMkFqleY05Ub1ErzEbWirN6yIrYgjzmSzadUxIZUANIbcsfuiYkMqA
2kJee2ANnHNTSJvr6QzVnLFw/iaveO6rtYb0VF+0R9VeRc/jmIy/Go2Ruair
QLznMb+2+H4JzcN68RsGZoSTMkDMIIHn6L3EO1FD1uirk18l1FdVXB/BD7dK
XQw3NPNQQHQaza7w51Le0M8ZLzRd+aMbnm7njS9/1J9TcOJQ/ytEpshwdOLE
m41bFomMjVuaEdHHjK3WuKFi455FomLjnmZU/CqwGyo2blokKjZu+nSoxKzY
fti4cdciEFIZr47pwgmKT24T49Ux3U0hrwZZ+z/xvuekPe6bx3P62yT1yMRI
4U3PFt+gx5d55jFRvdX4ZAypUH51C1tQJId0Y5huSIXxxThYhfFFc5V3Q8GP
E8bx3o8TxvDaj/PF8dqP88Xw2o/TxfHaj9PF8PrpK2IIZ/NBgJ6tJobmepKB
njyGBn+zXDVa8+/+t/LpZ8sbKz6z5b05l9lZlt3d3dEuMJQ8BgQtz4PBYHB5
eUm7+A4HZjqTMh8dE0pSshhZknbVGxv9fl/c0mOZHTXf9aMcUwIivtWkeF8u
/7GzI/WGiYoe2Xixh8BeY7IiE37yFhjFD+6jxeZE+VX0MSL4viX2vKhIktnJ
d0pmL7Yg5OTQjy4zjcPhkIevcvO0SrKqidYLYUv6UXbriERgGzwXMYGzJIQr
mTwnbj+4c8v3WMYAtiOEOeUjoK7IPSUw9Ho92sV7EMKf9KMdWJEXcHF3miPB
wRl7XkJ1XUDrtp3siJ8ZY1TE2chRoZzSxKygfT8yMydo2ZsQW3iPr1v5Cz8d
8lk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{314, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->103835440]
}, Open  ]],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    ButtonBox["Normal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Normal"], "[", 
    StyleBox["s", "TI"], "]"}], "]"}]], "InlineFormula"],
 " is identical to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   RowBox[{"N", "[", 
    StyleBox["s", "TI"], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->68976332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Normal", "[", "s", "]"}], "]"}], "===", 
  RowBox[{"Normal", "[", 
   RowBox[{"N", "[", "s", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->153161057],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->294177665]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->284986845],

Cell[TextData[{
 "Data objects like ",
 Cell[BoxData[
  ButtonBox["InterpolatingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpolatingFunction"]], "InlineFormula"],
 " have special rules so that only the data is affected:"
}], "ExampleText",
 CellID->82894215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ifun", "=", 
  RowBox[{"ListInterpolation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->288246807],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->875236344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nifun", "=", 
  RowBox[{"N", "[", "ifun", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->85031311],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2633014]
}, Open  ]],

Cell["\<\
Only the appropriate data has been changed so that the new function uses \
machine numbers:\
\>", "ExampleText",
 CellID->327638190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ifun", "[", 
    RowBox[{"1", "/", "2"}], "]"}], ",", 
   RowBox[{"nifun", "[", 
    RowBox[{"1", "/", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->550915478],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["9", "8"], ",", "1.125`"}], "}"}]], "Output",
 ImageSize->{76, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->341398111]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->413134602],

Cell[TextData[{
 "Operations like ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " use the corresponding ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "-functions when appropriate:"
}], "ExampleText",
 CellID->378348176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"int", "=", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"Sinc", "[", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "1"}], "/", "x"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->817605804],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{"Sinc", "[", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "x"}]], "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{110, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->788378732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "int", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->422557117],

Cell[BoxData["0.9937708785245603`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->360467437]
}, Open  ]],

Cell[TextData[{
 "This is using ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->154280397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->350283515],

Cell[BoxData["0.9937708785245603`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->376332021]
}, Open  ]],

Cell["\<\
For high requested precision, numerical algorithms may take a lot of time or \
need adjustment:\
\>", "ExampleText",
 CellID->312553239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"N", "[", 
   RowBox[{"int", ",", "32"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->248102784],

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "::", "\<\"ncvb\"\>"}], ":", 
  " ", "\<\"NIntegrate failed to converge to prescribed accuracy after \
\\!\\(9\\) recursive bisections in \\!\\(x\\) near \\!\\({x}\\) = \
\\!\\({2.231372025482049120914244388947558549199664092670906575897385861824050\
763884902243177496656`92.*^-15}\\). NIntegrate obtained \
\\!\\(0.9937708775436354119573668587774703032723231671456131274288545548100219\
6895368828756650726041`92.\\) and \
\\!\\(1.0117225879196415388318673777298900123730660265482613570378443889168449\
229828592954883273609`92.*^-9\\) for the integral and error \
estimates.\"\>"}]], "Message", "MSG",
 CellID->3381671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "8.031000000000002`", ",", 
   "0.993770877543635411957366858777470303272323167146`32."}], 
  "}"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->61326540]
}, Open  ]],

Cell[TextData[{
 "In this case you may want to use ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " directly:"
}], "ExampleText",
 CellID->70666283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sinc", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "32"}], ",", 
   RowBox[{"MaxRecursion", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->33235622],

Cell[BoxData["0.99377087855465223235188554142450770086601092764`32."], \
"Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->100123529]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14343995],

Cell[TextData[{
 "For most expressions, ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " affects the tree shown in ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->432446993],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{"2", "-", "x"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->614080742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340390005],

Cell[BoxData[
 RowBox[{"2.`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.`", " ", "x"}]}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66637690]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData["1"], "InlineFormula"],
 ". appears in front of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " because of how ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " is represented:"
}], "ExampleText",
 CellID->49283010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "e", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->99716290],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"2", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->17349804]
}, Open  ]],

Cell[TextData[{
 "The integers in ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " have just been converted to machine numbers:"
}], "ExampleText",
 CellID->66849232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"N", "[", "e", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->71468965],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"2.`", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"-", "1.`"}], ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{175, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->245862364]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Defining Special Rules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->90647492],

Cell[TextData[{
 "Prevent an indexed variable from being affected by ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " using the ",
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->47988867],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"x", ",", "NHoldAll"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161832880],

Cell[TextData[{
 "With this, ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " only affects the coefficients:"
}], "ExampleText",
 CellID->298940183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", " ", 
    RowBox[{"x", "[", "1", "]"}]}], " ", "+", " ", 
   RowBox[{"3", " ", 
    RowBox[{"x", "[", "2", "]"}]}], " ", "+", " ", 
   RowBox[{"4", " ", 
    RowBox[{"x", "[", "1", "]"}], " ", 
    RowBox[{"x", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52899033],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`", " ", 
   RowBox[{"x", "[", "1", "]"}]}], "+", 
  RowBox[{"3.`", " ", 
   RowBox[{"x", "[", "2", "]"}]}], "+", 
  RowBox[{"4.`", " ", 
   RowBox[{"x", "[", "1", "]"}], " ", 
   RowBox[{"x", "[", "2", "]"}]}]}]], "Output",
 ImageSize->{222, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9485289]
}, Open  ]],

Cell[TextData[{
 "Without this, ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " affects the indices too:"
}], "ExampleText",
 CellID->377351155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1", "+", 
   RowBox[{"2", 
    RowBox[{"y", "[", "1", "]"}]}], " ", "+", " ", 
   RowBox[{"3", " ", 
    RowBox[{"y", "[", "2", "]"}]}], " ", "+", " ", 
   RowBox[{"4", " ", 
    RowBox[{"y", "[", "1", "]"}], " ", 
    RowBox[{"y", "[", "2", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->185534140],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"2.`", " ", 
   RowBox[{"y", "[", "1.`", "]"}]}], "+", 
  RowBox[{"3.`", " ", 
   RowBox[{"y", "[", "2.`", "]"}]}], "+", 
  RowBox[{"4.`", " ", 
   RowBox[{"y", "[", "1.`", "]"}], " ", 
   RowBox[{"y", "[", "2.`", "]"}]}]}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->406931705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->373804042],

Cell[TextData[{
 "Define a numerical constant equal to ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 "/2:"
}], "ExampleText",
 CellID->136880050],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", "pit", "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{"Pi", "/", "2"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33869410],

Cell["\<\
In an exact symbolic expression the constant does not evaluate:\
\>", "ExampleText",
 CellID->432947579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "pit", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8899671],

Cell[BoxData[
 RowBox[{"Sin", "[", "pit", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->667644899]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " it does:"
}], "ExampleText",
 CellID->123529721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->325219151],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->318809735]
}, Open  ]],

Cell["\<\
Add a definition that will work with arbitrary precision or accuracy:\
\>", "ExampleText",
 CellID->345064080],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"pit", ",", "pa_"}], "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"Pi", "/", "2"}], ",", "pa"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13271379],

Cell["Numerically evaluate an expression to accuracy 20", "ExampleText",
 CellID->122628886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"\[Pi]", "-", 
    RowBox[{"2", " ", "pit"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->215728166],

Cell[BoxData["0``20."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->24607381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14097626],

Cell[TextData[{
 "Define a function that represents the real-valued root  ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{"1", "/", "n"}]], TraditionalForm]], "InlineMath"],
 " for positive ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and positive integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->80110771],

Cell[BoxData[
 RowBox[{
  RowBox[{"nthroot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x_", "?", "InexactNumberQ"}], " ", "/;", " ", 
     RowBox[{"Positive", "[", "x", "]"}]}], ",", 
    RowBox[{"n_Integer", "/;", 
     RowBox[{"Positive", "[", "n", "]"}]}]}], "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}], " ", 
         RowBox[{"#", "^", "n"}]}], " ", "+", " ", "x"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"n", " ", 
        RowBox[{"#", "^", 
         RowBox[{"(", 
          RowBox[{"n", "-", "1"}], ")"}]}]}], ")"}]}], "&"}], ",", 
    RowBox[{"N", "[", 
     RowBox[{"1", ",", 
      RowBox[{"Precision", "[", "x", "]"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141147017],

Cell[TextData[{
 "Prevent its second argument from being converted to real using ",
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->711531574],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"nthroot", ",", " ", "NHoldRest"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22712307],

Cell["An exact representation of the cube root of 2:", "ExampleText",
 CellID->377440979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"crt", "=", 
  RowBox[{"nthroot", "[", 
   RowBox[{"2", ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->608601075],

Cell[BoxData[
 RowBox[{"nthroot", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->144652799]
}, Open  ]],

Cell["Machine-number approximation:", "ExampleText",
 CellID->158336978],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "crt", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7375132],

Cell[BoxData["1.259921049894873`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->183447890]
}, Open  ]],

Cell["47-digit approximation:", "ExampleText",
 CellID->14214760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"crt", ",", "47"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->8800314],

Cell[BoxData["1.2599210498948731647672106072782283505702514647015079800819`47.\
"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->58761369]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512388404],

Cell[TextData[{
 "Define a data object that represents a polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["c", "1"], " ", 
      SuperscriptBox["x", 
       SubscriptBox["p", "1"]]}], "+"}], "..."}], TraditionalForm]], 
  "InlineMath"],
 " in a sparse form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["c", "1"], ",", 
       SubscriptBox["p", "1"]}], "}"}], ",", "..."}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->265605447],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"spoly", "[", "cp_", "]"}], "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", " ", "n", ",", "p", ",", " ", "y"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "c"}], "}"}], "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"SortBy", "[", 
        RowBox[{"cp", ",", "Last"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"p", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"y", "=", 
      RowBox[{"c", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "=", 
         RowBox[{
          RowBox[{"c", "[", 
           RowBox[{"[", "k", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", 
              RowBox[{"p", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], ")"}]}], "*", "y"}]}]}], ";",
         
        RowBox[{"n", "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{
          RowBox[{"Length", "[", "p", "]"}], "-", "1"}], ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", ">", " ", "0"}], ",", 
       RowBox[{"y", "*=", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "y"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36239431],

Cell[TextData[{
 "Make sure that ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " only affects the coefficients, not the powers:"
}], "ExampleText",
 CellID->4983566],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"e", ":", 
     RowBox[{"spoly", "[", "cp_", "]"}]}], ",", "pa_"}], "]"}], ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "c", ",", "nc"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "p"}], "}"}], "=", 
      RowBox[{"Transpose", "[", "cp", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"nc", "=", 
      RowBox[{"N", "[", 
       RowBox[{"c", ",", "pa"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"nc", "===", "c"}], ",", "e", ",", 
       RowBox[{"spoly", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"nc", ",", "p"}], "}"}], "]"}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->466916685],

Cell[TextData[{
 "Default ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " evaluation of the argument needs to be prevented for the rule to work:"
}], "ExampleText",
 CellID->321595248],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"spoly", ",", "NHoldAll"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->326590932],

Cell[TextData[{
 "A representation of the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", 
    RowBox[{"2", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "8"]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->179441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"spoly", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->531716292],

Cell[BoxData[
 RowBox[{"spoly", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->296471903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"sp", "[", "x", "]"}], ",", 
   RowBox[{"Expand", "[", 
    RowBox[{"sp", "[", "x", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->53225029],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"8", " ", "x"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{290, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->658514383]
}, Open  ]],

Cell["Get the representation with approximate real coefficients:", \
"ExampleText",
 CellID->58650974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsp", "=", " ", 
  RowBox[{"N", "[", "sp", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->31671949],

Cell[BoxData[
 RowBox[{"spoly", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.`", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.`", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4.`", ",", "8"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{286, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->250264132]
}, Open  ]],

Cell[TextData[{
 "Evaluate at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->7806351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsp", "[", "\[Pi]", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->256179902],

Cell[BoxData["926.1786364489872`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->371240457]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24508],

Cell["5-digit accuracy and any precision:", "ExampleText",
 CellID->1802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Pi", "^", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12494],

Cell[BoxData["93648.0474760830209737167`9.971498726941338"], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276516668]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10506],

Cell["1-digit accuracy, corresponding to integer part only:", "ExampleText",
 CellID->698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Pi", "^", "10"}], ",", 
   RowBox[{"{", 
    RowBox[{"Infinity", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27955],

Cell[BoxData["93648.0474760830209737167`5.971498726941338"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->826500735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11965525],

Cell["Get either 20-digit precision or 30-digit accuracy: ", "ExampleText",
 CellID->37049141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"val", "=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"1", "-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"Exp", "[", 
        RowBox[{"-", "1000"}], "]"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", "30"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5180236],

Cell[BoxData["0``30."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9231606]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Accuracy", "[", "val", "]"}], ",", 
   RowBox[{"Precision", "[", "val", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->562823131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"30.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->341313318]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8303],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " generally has precision ",
 Cell[BoxData[
  ButtonBox["MachinePrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MachinePrecision"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->165104771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"Sin", "[", "1000", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282381158],

Cell[BoxData["2.286173685812171`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->665560102]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->516227460],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->138218385]
}, Open  ]],

Cell["\<\
If the result is too large for machine numbers the precision may be \
different:\
\>", "ExampleText",
 CellID->137396772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ne", "=", 
  RowBox[{"N", "[", 
   RowBox[{"Exp", "[", "1000", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->245171242],

Cell[BoxData["1.97007111401704699388887935224`12.954589770191003*^434"], \
"Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->151971123]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->126630726],

Cell[BoxData["12.954589770191003`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->46470448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->463625235],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " generally has ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " equal to ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->361596147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"Sin", "[", "1000", "]"}], "]"}], ",", "47"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242969861],

Cell[BoxData["2.2861736858121711022258908545330612218712785120126149203246`47.\
"], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38446686]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20666979],

Cell[BoxData["47.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->452151520]
}, Open  ]],

Cell[TextData[{
 "When this is not possible, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will give a message:"
}], "ExampleText",
 CellID->136465322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"-", "1000"}], "]"}]}], "]"}]}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->43058856],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1 - \\@\\(1 - \
1\\/\[ExponentialE]\\^1000\\)\\).\"\>"}]], "Message", "MSG",
 CellID->390245086],

Cell[BoxData["0``69.52287874528034"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26751330]
}, Open  ]],

Cell[TextData[{
 "Typically increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " will resolve the problem:"
}], "ExampleText",
 CellID->624211287],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "500"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "1000"}], "]"}]}], "]"}]}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->415632662],

Cell[BoxData["2.5379794487747283826459047397871684596`20.*^-435"], "Output",
 ImageSize->{197, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->3604701]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->44631633],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->151907238]
}, Open  ]],

Cell["\<\
For hidden zeros, positive precision is not achievable, so you may want to \
use accuracy:\
\>", "ExampleText",
 CellID->604106974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "GoldenRatio"}], "+", "1", "-", "GoldenRatio"}], ",", 
   "20"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->849445264],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(1 + 1\\/GoldenRatio - GoldenRatio\\).\"\>"}]], \
"Message", "MSG",
 CellID->38150862],

Cell[BoxData["0``69.31389110503036"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->179733350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "GoldenRatio"}], "+", "1", "-", "GoldenRatio"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->991075506],

Cell[BoxData["0``20."], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->311841662]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->492648595],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->158828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396446512],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"\[Infinity]", ",", 
      StyleBox["a", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " generally has",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"]}]], "InlineFormula"],
 " equal to ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18083741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "100", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", 
     RowBox[{"-", "10"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107168583],

Cell[BoxData["2.6881171418161354484126255515800135873611119`33.\
429448190325175*^43"], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27971435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74611908],

Cell[BoxData[
 RowBox[{"-", "10.000000000000007`"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->153785728]
}, Open  ]],

Cell[TextData[{
 "When this is not possible ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will give a message:"
}], "ExampleText",
 CellID->427390766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"10000000000", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Exp", "[", "100", "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{"999999999999", "/", "10000000000"}], "]"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->103677849],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(10000000000\\\\ \
\\(\\((\\(\\(-\[ExponentialE]\\^\\(999999999999/10000000000\\)\\)\\) + \
\[ExponentialE]\\^100)\\)\\)\\).\"\>"}]], "Message", "MSG",
 CellID->59163702],

Cell[BoxData["2.\
688117141681729591326298974395630530648558808379370953675983976734322599`59.\
522878745273104*^43"], "Output",
 ImageSize->{467, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->560390496]
}, Open  ]],

Cell[TextData[{
 "Typically increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " will resolve the problem:"
}], "ExampleText",
 CellID->491029925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"10000000000", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", "100", "]"}], "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"999999999999", "/", "10000000000"}], "]"}]}], ")"}]}], ",", 
     
     RowBox[{"{", 
      RowBox[{"\[Infinity]", ",", "20"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->328778357],

Cell[BoxData["2.\
688117141681729591326298974395630530648558808379370953675983976734322598964222\
648`63.429448190303475*^43"], "Output",
 ImageSize->{488, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->22946181]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->768794186],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->222484992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25541],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " digit texture: "
}], "ExampleText",
 CellID->1067076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", 
     RowBox[{"10", "^", "5"}]}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->656666377],

Cell[BoxData[
 StyleBox[
  "3.1415926535897932384626433832795028841971693993751058209749445923078164062\
862089986280348253421170679821480865132823066470938446095505822317253594081284\
811174502841027019385211055596446229489549303819644288109756659334461284756482\
337867831652712019091456485669234603486104543266482133936072602491412737245870\
066063155881748815209209628292540917153643678925903600113305305488204665213841\
469519415116094330572703657595919530921861173819326117931051185480744623799627\
495673518857527248912279381830119491298336733624406566430860213949463952247371\
907021798609437027705392171762931767523846748184676694051320005681271452635608\
277857713427577896091736371787214684409012249534301465495853710507922796892589\
235420199561121290219608640344181598136297747713099605187072113499999983729780\
499510597317328160963185950244594553469083026425223082533446850352619311881710\
100031378387528865875332083814206171776691473035982534904287554687311595628638\
823537875937519577818577805321712268066130019278766111959092164201989380952572\
010654858632788659361533818279682303019520353018529689957736225994138912497217\
752834791315155748572424541506959508295331168617278558890750983817546374649393\
192550604009277016711390098488240128583616035637076601047101819429555961989467\
678374494482553797747268471040475346462080466842590694912933136770289891521047\
521620569660240580381501935112533824300355876402474964732639141992726042699227\
967823547816360093417216412199245863150302861829745557067498385054945885869269\
956909272107975093029553211653449872027559602364806654991198818347977535663698\
074265425278625518184175746728909777727938000816470600161452491921732172147723\
501414419735685481613611573525521334757418494684385233239073941433345477624168\
625189835694855620992192221842725502542568876717904946016534668049886272327917\
860857843838279679766814541009538837863609506800642251252051173929848960841284\
886269456042419652850222106611863067442786220391949450471237137869609563643719\
172874677646575739624138908658326459958133904780275900994657640789512694683983\
525957098258226205224894077267194782684826014769909026401363944374553050682034\
962524517493996514314298091906592509372216964615157098583874105978859597729754\
989301617539284681382686838689427741559918559252459539594310499725246808459872\
736446958486538367362226260991246080512438843904512441365497627807977156914359\
977001296160894416948685558484063534220722258284886481584560285060168427394522\
674676788952521385225499546667278239864565961163548862305774564980355936345681\
743241125150760694794510965960940252288797108931456691368672287489405601015033\
086179286809208747609178249385890097149096759852613655497818931297848216829989\
487226588048575640142704775551323796414515237462343645428584447952658678210511\
413547357395231134271661021359695362314429524849371871101457654035902799344037\
420073105785390621983874478084784896833214457138687519435064302184531910484810\
053706146806749192781911979399520614196634287544406437451237181921799983910159\
195618146751426912397489409071864942319615679452080951465502252316038819301420\
937621378559566389377870830390697920773467221825625996615014215030680384477345\
492026054146659252014974428507325186660021324340881907104863317346496514539057\
962685610055081066587969981635747363840525714591028970641401109712062804390397\
595156771577004203378699360072305587631763594218731251471205329281918261861258\
673215791984148488291644706095752706957220917567116722910981690915280173506712\
748583222871835209353965725121083579151369882091444210067510334671103141267111\
369908658516398315019701651511685171437657618351556508849099898599823873455283\
316355076479185358932261854896321329330898570642046752590709154814165498594616\
371802709819943099244889575712828905923233260972997120844335732654893823911932\
597463667305836041428138830320382490375898524374417029132765618093773444030707\
469211201913020330380197621101100449293215160842444859637669838952286847831235\
526582131449576857262433441893039686426243410773226978028073189154411010446823\
252716201052652272111660396665573092547110557853763466820653109896526918620564\
769312570586356620185581007293606598764861179104533488503461136576867532494416\
680396265797877185560845529654126654085306143444318586769751456614068007002378\
776591344017127494704205622305389945613140711270004078547332699390814546646458\
807972708266830634328587856983052358089330657574067954571637752542021149557615\
814002501262285941302164715509792592309907965473761255176567513575178296664547\
791745011299614890304639947132962107340437518957359614589019389713111790429782\
856475032031986915140287080859904801094121472213179476477726224142548545403321\
571853061422881375850430633217518297986622371721591607716692547487389866549494\
501146540628433663937900397692656721463853067360965712091807638327166416274888\
800786925602902284721040317211860820419000422966171196377921337575114959501566\
049631862947265473642523081770367515906735023507283540567040386743513622224771\
589150495309844489333096340878076932599397805419341447377441842631298608099888\
687413260472156951623965864573021631598193195167353812974167729478672422924654\
366800980676928238280689964004824354037014163149658979409243237896907069779422\
362508221688957383798623001593776471651228935786015881617557829735233446042815\
126272037343146531977774160319906655418763979293344195215413418994854447345673\
831624993419131814809277771038638773431772075456545322077709212019051660962804\
909263601975988281613323166636528619326686336062735676303544776280350450777235\
547105859548702790814356240145171806246436267945612753181340783303362542327839\
449753824372058353114771199260638133467768796959703098339130771098704085913374\
641442822772634659470474587847787201927715280731767907707157213444730605700733\
492436931138350493163128404251219256517980694113528013147013047816437885185290\
928545201165839341965621349143415956258658655705526904965209858033850722426482\
939728584783163057777560688876446248246857926039535277348030480290058760758251\
047470916439613626760449256274204208320856611906254543372131535958450687724602\
901618766795240616342522577195429162991930645537799140373404328752628889639958\
794757291746426357455254079091451357111369410911939325191076020825202618798531\
887705842972591677813149699009019211697173727847684726860849003377024242916513\
005005168323364350389517029893922334517220138128069650117844087451960121228599\
371623130171144484640903890644954440061986907548516026327505298349187407866808\
818338510228334508504860825039302133219715518430635455007668282949304137765527\
939751754613953984683393638304746119966538581538420568533862186725233402830871\
123282789212507712629463229563989898935821167456270102183564622013496715188190\
973038119800497340723961036854066431939509790190699639552453005450580685501956\
730229219139339185680344903982059551002263535361920419947455385938102343955449\
597783779023742161727111723643435439478221818528624085140066604433258885698670\
543154706965747458550332323342107301545940516553790686627333799585115625784322\
988273723198987571415957811196358330059408730681216028764962867446047746491599\
505497374256269010490377819868359381465741268049256487985561453723478673303904\
688383436346553794986419270563872931748723320837601123029911367938627089438799\
362016295154133714248928307220126901475466847653576164773794675200490757155527\
819653621323926406160136358155907422020203187277605277219005561484255518792530\
343513984425322341576233610642506390497500865627109535919465897514131034822769\
306247435363256916078154781811528436679570611086153315044521274739245449454236\
828860613408414863776700961207151249140430272538607648236341433462351897576645\
216413767969031495019108575984423919862916421939949072362346468441173940326591\
840443780513338945257423995082965912285085558215725031071257012668302402929525\
220118726767562204154205161841634847565169998116141010029960783869092916030288\
400269104140792886215078424516709087000699282120660418371806535567252532567532\
861291042487761825829765157959847035622262934860034158722980534989650226291748\
788202734209222245339856264766914905562842503912757710284027998066365825488926\
488025456610172967026640765590429099456815065265305371829412703369313785178609\
040708667114965583434347693385781711386455873678123014587687126603489139095620\
099393610310291616152881384379099042317473363948045759314931405297634757481193\
567091101377517210080315590248530906692037671922033229094334676851422144773793\
937517034436619910403375111735471918550464490263655128162288244625759163330391\
072253837421821408835086573917715096828874782656995995744906617583441375223970\
968340800535598491754173818839994469748676265516582765848358845314277568790029\
095170283529716344562129640435231176006651012412006597558512761785838292041974\
844236080071930457618932349229279650198751872127267507981255470958904556357921\
221033346697499235630254947802490114195212382815309114079073860251522742995818\
072471625916685451333123948049470791191532673430282441860414263639548000448002\
670496248201792896476697583183271314251702969234889627668440323260927524960357\
996469256504936818360900323809293459588970695365349406034021665443755890045632\
882250545255640564482465151875471196218443965825337543885690941130315095261793\
780029741207665147939425902989695946995565761218656196733786236256125216320862\
869222103274889218654364802296780705765615144632046927906821207388377814233562\
823608963208068222468012248261177185896381409183903673672220888321513755600372\
798394004152970028783076670944474560134556417254370906979396122571429894671543\
578468788614445812314593571984922528471605049221242470141214780573455105008019\
086996033027634787081081754501193071412233908663938339529425786905076431006383\
519834389341596131854347546495569781038293097164651438407007073604112373599843\
452251610507027056235266012764848308407611830130527932054274628654036036745328\
651057065874882256981579367897669742205750596834408697350201410206723585020072\
452256326513410559240190274216248439140359989535394590944070469120914093870012\
645600162374288021092764579310657922955249887275846101264836999892256959688159\
205600101655256375678566722796619885782794848855834397518744545512965634434803\
966420557982936804352202770984294232533022576341807039476994159791594530069752\
148293366555661567873640053666564165473217043903521329543529169414599041608753\
201868379370234888689479151071637852902345292440773659495630510074210871426134\
974595615138498713757047101787957310422969066670214498637464595280824369445789\
772330048764765241339075920434019634039114732023380715095222010682563427471646\
024335440051521266932493419673977041595683753555166730273900749729736354964533\
288869844061196496162773449518273695588220757355176651589855190986665393549481\
068873206859907540792342402300925900701731960362254756478940647548346647760411\
463233905651343306844953979070903023460461470961696886885014083470405460742958\
699138296682468185710318879065287036650832431974404771855678934823089431068287\
027228097362480939962706074726455399253994428081137369433887294063079261595995\
462624629707062594845569034711972996409089418059534393251236235508134949004364\
278527138315912568989295196427287573946914272534366941532361004537304881985517\
065941217352462589548730167600298865925786628561249665523533829428785425340483\
083307016537228563559152534784459818313411290019992059813522051173365856407826\
484942764411376393866924803118364453698589175442647399882284621844900877769776\
312795722672655562596282542765318300134070922334365779160128093179401718598599\
933849235495640057099558561134980252499066984233017350358044081168552653117099\
570899427328709258487894436460050410892266917835258707859512983441729535195378\
855345737426085902908176515578039059464087350612322611200937310804854852635722\
825768203416050484662775045003126200800799804925485346941469775164932709504934\
639382432227188515974054702148289711177792376122578873477188196825462981268685\
817050740272550263329044976277894423621674119186269439650671515779586756482399\
391760426017633870454990176143641204692182370764887834196896861181558158736062\
938603810171215855272668300823834046564758804051380801633638874216371406435495\
561868964112282140753302655100424104896783528588290243670904887118190909494533\
144218287661810310073547705498159680772009474696134360928614849417850171807793\
068108546900094458995279424398139213505586422196483491512639012803832001097738\
680662877923971801461343244572640097374257007359210031541508936793008169980536\
520276007277496745840028362405346037263416554259027601834840306811381855105979\
705664007509426087885735796037324514146786703688098806097164258497595138069309\
449401515422221943291302173912538355915031003330325111749156969174502714943315\
155885403922164097229101129035521815762823283182342548326111912800928252561902\
052630163911477247331485739107775874425387611746578671169414776421441111263583\
553871361011023267987756410246824032264834641766369806637857681349204530224081\
972785647198396308781543221166912246415911776732253264335686146186545222681268\
872684459684424161078540167681420808850280054143613146230821025941737562389942\
075713627516745731891894562835257044133543758575342698699472547031656613991999\
682628247270641336222178923903176085428943733935618891651250424404008952719837\
873864805847268954624388234375178852014395600571048119498842390606136957342315\
590796703461491434478863604103182350736502778590897578272731305048893989009923\
913503373250855982655867089242612429473670193907727130706869170926462548423240\
748550366080136046689511840093668609546325002145852930950000907151058236267293\
264537382104938724996699339424685516483261134146110680267446637334375340764294\
026682973865220935701626384648528514903629320199199688285171839536691345222444\
708045923966028171565515656661113598231122506289058549145097157553900243931535\
190902107119457300243880176615035270862602537881797519478061013715004489917210\
022201335013106016391541589578037117792775225978742891917915522417189585361680\
594741234193398420218745649256443462392531953135103311476394911995072858430658\
361935369329699289837914941939406085724863968836903265564364216644257607914710\
869984315733749648835292769328220762947282381537409961545598798259891093717126\
218283025848112389011968221429457667580718653806506487026133892822994972574530\
332838963818439447707794022843598834100358385423897354243956475556840952248445\
541392394100016207693636846776413017819659379971557468541946334893748439129742\
391433659360410035234377706588867781139498616478747140793263858738624732889645\
643598774667638479466504074111825658378878454858148962961273998413442726086061\
872455452360643153710112746809778704464094758280348769758948328241239292960582\
948619196670918958089833201210318430340128495116203534280144127617285830243559\
830032042024512072872535581195840149180969253395075778400067465526031446167050\
827682772223534191102634163157147406123850425845988419907611287258059113935689\
601431668283176323567325417073420817332230462987992804908514094790368878687894\
930546955703072619009502076433493359106024545086453628935456862958531315337183\
868265617862273637169757741830239860065914816164049449650117321313895747062088\
474802365371031150898427992754426853277974311395143574172219759799359685252285\
745263796289612691572357986620573408375766873884266405990993505000813375432454\
635967504844235284874701443545419576258473564216198134073468541117668831186544\
893776979566517279662326714810338643913751865946730024434500544995399742372328\
712494834706044063471606325830649829795510109541836235030309453097335834462839\
476304775645015008507578949548931393944899216125525597701436858943585877526379\
625597081677643800125436502371412783467926101995585224717220177723700417808419\
423948725406801556035998390548985723546745642390585850216719031395262944554391\
316631345308939062046784387785054239390524731362012947691874975191011472315289\
326772533918146607300089027768963114810902209724520759167297007850580717186381\
054967973100167870850694207092232908070383263453452038027860990556900134137182\
368370991949516489600755049341267876436746384902063964019766685592335654639138\
363185745698147196210841080961884605456039038455343729141446513474940784884423\
772175154334260306698831768331001133108690421939031080143784334151370924353013\
677631084913516156422698475074303297167469640666531527035325467112667522460551\
199581831963763707617991919203579582007595605302346267757943936307463056901080\
114942714100939136913810725813781357894005599500183542511841721360557275221035\
268037357265279224173736057511278872181908449006178013889710770822931002797665\
935838758909395688148560263224393726562472776037890814458837855019702843779362\
407825052704875816470324581290878395232453237896029841669225489649715606981192\
186584926770403956481278102179913217416305810554598801300484562997651121241536\
374515005635070127815926714241342103301566165356024733807843028655257222753049\
998837015348793008062601809623815161366903341111386538510919367393835229345888\
322550887064507539473952043968079067086806445096986548801682874343786126453815\
834280753061845485903798217994599681154419742536344399602902510015888272164745\
006820704193761584547123183460072629339550548239557137256840232268213012476794\
522644820910235647752723082081063518899152692889108455571126603965034397896278\
250016110153235160519655904211844949907789992007329476905868577878720982901352\
956613978884860509786085957017731298155314951681467176959760994210036183559138\
777817698458758104466283998806006162298486169353373865787735983361613384133853\
684211978938900185295691967804554482858483701170967212535338758621582310133103\
877668272115726949518179589754693992642197915523385766231676275475703546994148\
929041301863861194391962838870543677743224276809132365449485366768000001065262\
485473055861598999140170769838548318875014293890899506854530765116803337322265\
175662207526951791442252808165171667766727930354851542040238174608923283917032\
754257508676551178593950027933895920576682789677644531840404185540104351348389\
531201326378369283580827193783126549617459970567450718332065034556644034490453\
627560011250184335607361222765949278393706478426456763388188075656121689605041\
611390390639601620221536849410926053876887148379895599991120991646464411918568\
277004574243434021672276445589330127781586869525069499364610175685060167145354\
315814801054588605645501332037586454858403240298717093480910556211671546848477\
803944756979804263180991756422809873998766973237695737015808068229045992123661\
689025962730430679316531149401764737693873514093361833216142802149763399189835\
484875625298752423873077559555955465196394401821840998412489826236737714672260\
616336432964063357281070788758164043814850188411431885988276944901193212968271\
588841338694346828590066640806314077757725705630729400492940302420498416565479\
736705485580445865720227637840466823379852827105784319753541795011347273625774\
080213476826045022851579795797647467022840999561601569108903845824502679265942\
055503958792298185264800706837650418365620945554346135134152570065974881916341\
359556719649654032187271602648593049039787489589066127250794828276938953521753\
621850796297785146188432719223223810158744450528665238022532843891375273845892\
384422535472653098171578447834215822327020690287232330053862163479885094695472\
004795231120150432932266282727632177908840087861480221475376578105819702226309\
717495072127248479478169572961423658595782090830733233560348465318730293026659\
645013718375428897557971449924654038681799213893469244741985097334626793321072\
686870768062639919361965044099542167627840914669856925715074315740793805323925\
239477557441591845821562518192155233709607483329234921034514626437449805596103\
307994145347784574699992128599999399612281615219314888769388022281083001986016\
549416542616968586788372609587745676182507275992950893180521872924610867639958\
916145855058397274209809097817293239301067663868240401113040247007350857828724\
627134946368531815469690466968693925472519413992914652423857762550047485295476\
814795467007050347999588867695016124972282040303995463278830695976249361510102\
436555352230690612949388599015734661023712235478911292547696176005047974928060\
721268039226911027772261025441492215765045081206771735712027180242968106203776\
578837166909109418074487814049075517820385653909910477594141321543284406250301\
802757169650820964273484146957263978842560084531214065935809041271135920041975\
985136254796160632288736181367373244506079244117639975974619383584574915988097\
667447093006546342423460634237474666080431701260052055928493695941434081468529\
815053947178900451835755154125223590590687264878635752541911288877371766374860\
276606349603536794702692322971868327717393236192007774522126247518698334951510\
198642698878471719396649769070825217423365662725928440620430214113719922785269\
984698847702323823840055655517889087661360130477098438611687052310553149162517\
283732728676007248172987637569816335415074608838663640693470437206688651275688\
266149730788657015685016918647488541679154596507234287730699853713904300266530\
783987763850323818215535597323530686043010675760838908627049841888595138091030\
423595782495143988590113185835840667472370297149785084145853085781339156270760\
356390763947311455495832266945702494139831634332378975955680856836297253867913\
275055542524491943589128405045226953812179131914513500993846311774017971512283\
785460116035955402864405902496466930707769055481028850208085800878115773817191\
741776017330738554758006056014337743299012728677253043182519757916792969965041\
460706645712588834697979642931622965520168797300035646304579308840327480771811\
555330909887025505207680463034608658165394876951960044084820659673794731680864\
156456505300498816164905788311543454850526600698230931577765003780704661264706\
021457505793270962047825615247145918965223608396645624105195510522357239739512\
881816405978591427914816542632892004281609136937773722299983327082082969955737\
727375667615527113922588055201898876201141680054687365580633471603734291703907\
986396522961312801782679717289822936070288069087768660593252746378405397691848\
082041021944719713869256084162451123980620113184541244782050110798760717155683\
154078865439041210873032402010685341947230476666721749869868547076781205124736\
792479193150856444775379853799732234456122785843296846647513336573692387201464\
723679427870042503255589926884349592876124007558756946413705625140011797133166\
207153715436006876477318675587148783989081074295309410605969443158477539700943\
988394914432353668539209946879645066533985738887866147629443414010498889931600\
512076781035886116602029611936396821349607501116498327856353161451684576956871\
090029997698412632665023477167286573785790857466460772283415403114415294188047\
825438761770790430001566986776795760909966936075594965152736349811896413043311\
662774712338817406037317439705406703109676765748695358789670031925866259410510\
533584384656023391796749267844763708474978333655579007384191473198862713525954\
625181604342253729962863267496824058060296421146386436864224724887283434170441\
573482481833301640566959668866769563491416328426414974533349999480002669987588\
815935073578151958899005395120853510357261373640343675347141048360175464883004\
078464167452167371904831096767113443494819262681110739948250607394950735031690\
197318521195526356325843390998224986240670310768318446607291248747540316179699\
411397387765899868554170318847788675929026070043212666179192235209382278788809\
886335991160819235355570464634911320859189796132791319756490976000139962344455\
350143464268604644958624769094347048293294140411146540923988344435159133201077\
394411184074107684981066347241048239358274019449356651610884631256785297769734\
684303061462418035852933159734583038455410337010916767763742762102137013548544\
509263071901147318485749233181672072137279355679528443925481560913728128406333\
039373562420016045664557414588166052166608738748047243391212955877763906969037\
078828527753894052460758496231574369171131761347838827194168606625721036851321\
566478001476752310393578606896111259960281839309548709059073861351914591819510\
297327875571049729011487171897180046961697770017913919613791417162707018958469\
214343696762927459109940060084983568425201915593703701011049747339493877885989\
417433031785348707603221982970579751191440510994235883034546353492349826883624\
043327267415540301619505680654180939409982020609994140216890900708213307230896\
621197755306659188141191577836272927461561857103721724710095214236964830864102\
592887457999322374955191221951903424452307535133806856807354464995127203174487\
195403976107308060269906258076020292731455252078079914184290638844373499681458\
273372072663917670201183004648190002413083508846584152148991276106513741539435\
657211390328574918769094413702090517031487773461652879848235338297260136110984\
514841823808120540996125274580881099486972216128524897425555516076371675054896\
173016809613803811914361143992106380050832140987604599309324851025168294467260\
666138151745712559754953580239983146982203613380828499356705575524712902745397\
762140493182014658008021566536067765508783804304134310591804606800834591136640\
834887408005741272586704792258319127415739080914383138456424150940849133918096\
840251163991936853225557338966953749026620923261318855891580832455571948453875\
628786128859004106006073746501402627824027346962528217174941582331749239683530\
136178653673760642166778137739951006589528877427662636841830680190804609849809\
469763667335662282915132352788806157768278159588669180238940333076441912403412\
022316368577860357276941541778826435238131905028087018575047046312933353757285\
386605888904583111450773942935201994321971171642235005644042979892081594307167\
019857469273848653833436145794634175922573898588001698014757420542995801242958\
105456510831046297282937584161162532562516572498078492099897990620035936509934\
721582965174135798491047111660791587436986541222348341887722929446335178653856\
731962559852026072947674072616767145573649812105677716893484917660771705277187\
601199908144113058645577910525684304811440261938402322470939249802933550731845\
890355397133088446174107959162511714864874468611247605428673436709046678468670\
274091881014249711149657817724279347070216688295610877794405048437528443375108\
828264771978540006509704033021862556147332117771174413350281608840351781452541\
964320309576018694649088681545285621346988355444560249556668436602922195124830\
910605377201980218310103270417838665447181260397190688462370857518080035327047\
185659499476124248110999288679158969049563947624608424065930948621507690314987\
020673533848349550836366017848771060809804269247132410009464014373603265645184\
566792456669551001502298330798496079949882497061723674493612262229617908143114\
146609412341593593095854079139087208322733549572080757165171876599449856937956\
238755516175754380917805280294642004472153962807463602113294255916002570735628\
126387331060058910652457080244749375431841494014821199962764531068006631183823\
761639663180931444671298615527598201451410275600689297502463040173514891945763\
607893528555053173314164570504996443890936308438744847839616840518452732884032\
345202470568516465716477139323775517294795126132398229602394548579754586517458\
787713318138752959809412174227300352296508089177705068259248822322154938048371\
454781647213976820963320508305647920482085920475499857320388876391601995240918\
938945576768749730856955958010659526503036266159750662225084067428898265907510\
637563569968211510949669744580547288693631020367823250182323708459790111548472\
087618212477813266330412076216587312970811230758159821248639807212407868878114\
501655825136178903070860870198975889807456643955157415363193191981070575336633\
738038272152798849350397480015890519420879711308051233933221903466249917169150\
948541401871060354603794643379005890957721180804465743962806186717861017156740\
967662080295766577051291209907944304632892947306159510430902221439371849560634\
056189342513057268291465783293340524635028929175470872564842600349629611654138\
230077313327298305001602567240141851520418907011542885799208121984493156999059\
182011819733500126187728036812481995877070207532406361259313438595542547781961\
142935163561223496661522614735399674051584998603552953329245752388810136202347\
624669055816438967863097627365504724348643071218494373485300606387644566272186\
661701238127715621379746149861328744117714552444708997144522885662942440230184\
791205478498574521634696448973892062401943518310088283480249249085403077863875\
165911302873958787098100772718271874529013972836614842142871705531796543076504\
534324600536361472618180969976933486264077435199928686323835088756683595097265\
574815431940195576850437248001020413749831872259677387154958399718444907279141\
965845930083942637020875635398216962055324803212267498911402678528599673405242\
031091797899905718821949391320753431707980023736590985375520238911643467185582\
906853711897952626234492483392496342449714656846591248918556629589329909035239\
233333647435203707701010843880032907598342170185542283861617210417603011645918\
780539367447472059985023582891833692922337323999480437108419659473162654825748\
099482509991833006976569367159689364493348864744213500840700660883597235039532\
340179582557036016936990988671132109798897070517280755855191269930673099250704\
070245568507786790694766126298082251633136399521170984528092630375922426742575\
599892892783704744452189363203489415521044597261883800300677617931381399162058\
062701651024458869247649246891924612125310275731390840470007143561362316992371\
694848132554200914530410371354532966206392105479824392125172540132314902740585\
892063217589494345489068463993137570910346332714153162232805522972979538018801\
628590735729554162788676498274186164218789885741071649069191851162815285486794\
173638906653885764229158342500673612453849160674137340173572779956341043326883\
569507814931378007362354180070619180267328551191942676091221035987469241172837\
493126163395001239599240508454375698507957046222664619000103500490183034153545\
842833764378111988556318777792537201166718539541835984438305203762819440761594\
106820716970302285152250573126093046898423433152732131361216582808075212631547\
730604423774753505952287174402666389148817173086436111389069420279088143119448\
799417154042103412190847094080254023932942945493878640230512927119097513536000\
921971105412096683111516328705423028470073120658032626417116165957613272351566\
662536672718998534199895236884830999302757419916463841427077988708874229277053\
891227172486322028898425125287217826030500994510824783572905691988555467886079\
462805371227042466543192145281760741482403827835829719301017888345674167811398\
954750448339314689630763396657226727043393216745421824557062524797219978668542\
798977992339579057581890622525473582205236424850783407110144980478726691990186\
438822932305382318559732869780922253529591017341407334884761005564018242392192\
695062083183814546983923664613639891012102177095976704908305081854704194664371\
312299692358895384930136356576186106062228705599423371631021278457446463989738\
188566746260879482018647487672727222062676465338099801966883680994159075776852\
639865146253336312450536402610569605513183813174261184420189088853196356986962\
795036738424313011331753305329802016688817481342988681585577810343231753064784\
983210629718425184385534427620128234570716988530518326179641178579608888150329\
602290705614476220915094739035946646916235396809201394578175891088931992112260\
073928149169481615273842736264298098234063200244024495894456129167049508235812\
487391799648641133480324757775219708932772262349486015046652681439877051615317\
026696929704928316285504212898146706195331970269507214378230476875280287354126\
166391708245925170010714180854800636923259462019002278087409859771921805158532\
147392653251559035410209284665925299914353791825314545290598415817637058927906\
909896911164381187809435371521332261443625314490127454772695739393481546916311\
624928873574718824071503995009446731954316193855485207665738825139639163576723\
151005556037263394867208207808653734942440115799667507360711159351331959197120\
948964717553024531364770942094635696982226673775209945168450643623824211853534\
887989395673187806606107885440005508276570305587448541805778891719207881423351\
138662929667179643468760077047999537883387870348718021842437342112273940255717\
690819603092018240188427057046092622564178375265263358324240661253311529423457\
965569502506810018310900411245379015332966156970522379210325706937051090830789\
479999004999395322153622748476603613677697978567386584670936679588583788795625\
946464891376652199588286933801836011932368578558558195556042156250883650203322\
024513762158204618106705195330653060606501054887167245377942831338871631395596\
905832083416898476065607118347136218123246227258841990286142087284956879639325\
464285343075301105285713829643709990356948885285190402956047346131138263878897\
551788560424998748316382804046848618938189590542039889872650697620201995548412\
650005394428203930127481638158530396439925470201672759328574366661644110962566\
337305409219519675148328734808957477775278344221091073111351828046036347198185\
655572957144747682552857863349342858423118749440003229690697758315903858039353\
521358860079600342097547392296733310649395601812237812854584317605561733861126\
734780745850676063048229409653041118306671081893031108871728167519579675347188\
537229309616143204006381322465841111157758358581135018569047815368938137718472\
814751998350504781297718599084707621974605887423256995828892535041937958260616\
211842368768511418316068315867994601652057740529423053601780313357263267054790\
338401257305912339601880137825421927094767337191987287385248057421248921183470\
876629667207272325650565129333126059505777727542471241648312832982072361750574\
673870128209575544305968395555686861188397135522084452852640081252027665557677\
495969626612604565245684086139238265768583384698499778726706555191854468698469\
478495734622606294219624557085371272776523098955450193037732166649182578154677\
292005212667143463209637891852323215018976126034373684067194193037746880999296\
877582441047878123266253181845960453853543839114496775312864260925211537673258\
866722604042523491087026958099647595805794663973419064010036361904042033113579\
336542426303561457009011244800890020801478056603710154122328891465722393145076\
071670643556827437743965789067972687438473076346451677562103098604092717090951\
280863090297385044527182892749689212106670081648583395537735919136950153162018\
908887484210798706899114804669270650940762046502772528650728905328548561433160\
812693005693785417861096969202538865034577183176686885923681488475276498468821\
949739729707737187188400414323127636504814531122850990020742409255859252926103\
021067368154347015252348786351643976235860419194129697690405264832347009911154\
242601273438022089331096686367898694977994001260164227609260823493041180643829\
138347354679725399262338791582998486459271734059225620749105308531537182911681\
637219395188700957788181586850464507699343940987433514431626330317247747486897\
918209239480833143970840673084079589358108966564775859905563769525232653614424\
780230826811831037735887089240613031336477371011628214614661679404090518615260\
360092521947218890918107335871964142144478654899528582343947050079830388538860\
831035719306002771194558021911942899922722353458707566246926177663178855144350\
218287026685610665003531050216318206017609217984684936863161293727951873078972\
637353717150256378733579771808184878458866504335824377004147710414934927438457\
587107159731559439426412570270965125108115548247939403597681188117282472158250\
109496096625393395380922195591918188552678062149923172763163218339896938075616\
855911752998450132067129392404144593862398809381240452191484831646210147389182\
510109096773869066404158973610476436500068077105656718486281496371118832192445\
663945814491486165500495676982690308911185687986929470513524816091743243015383\
684707292898982846022237301452655679898627767968091469798378268764311598832109\
043715611299766521539635464420869197567370005738764978437686287681792497469438\
427465256316323005551304174227341646455127812784577772457520386543754282825671\
412885834544435132562054464241011037955464190581168623059644769587054072141985\
212106734332410756767575818456990693046047522770167005684543969234041711089888\
993416350585157887353430815520811772071880379104046983069578685473937656433631\
979786803671873079693924236321448450354776315670255390065423117920153464977929\
066241508328858395290542637687668968805033317227800185885069736232403894700471\
897619347344308437443759925034178807972235859134245813144049847701732361694719\
765715353197754997162785663119046912609182591249890367654176979903623755286526\
375733763526969344354400473067198868901968147428767790866979688522501636949856\
730217523132529265375896415171479559538784278499866456302878831962099830494519\
874396369070682762657485810439112232618794059941554063270131989895703761105323\
606298674803779153767511583043208498720920280929752649812569163425000522908872\
646925284666104665392171482080130502298052637836426959733707053922789153510568\
883938113249757071331029504430346715989448786847116438328050692507766274500122\
003526203709466023414648998390252588830148678162196775194583167718762757200505\
439794412459900771152051546199305098386982542846407255540927403132571632640792\
934183342147090412542533523248021932277075355546795871638358750181593387174236\
061551171013123525633485820365146141870049205704372018261733194715700867578539\
336078622739558185797587258744102542077105475361294047460100094095444959662881\
486915903899071865980563617137692227290764197755177720104276496949611056220592\
502420217704269622154958726453989227697660310524980855759471631075870133208861\
463266412591148633881220284440694169488261529577625325019870359870674380469821\
942056381255833436421949232275937221289056420943082352544084110864545369404969\
271494003319782861318186188811118408257865928757426384450059944229568586460481\
033015388911499486935436030221810943466764000022362550573631294626296096198760\
564259963946138692330837196265954739234624134597795748524647837980795693198650\
815977675350553918991151335252298736112779182748542008689539658359421963331502\
869561192012298889887006079992795411188269023078913107603617634779489432032102\
773359416908650071932804017163840644987871753756781185321328408216571107549528\
294974936214608215583205687232185574065161096274874375098092230211609982633033\
915469494644491004515280925089745074896760324090768983652940657920198315265410\
658136823791984090645712468948470209357761193139980246813405200394781949866202\
624008902150166163813538381515037735022966074627952910384068685569070157516624\
192987244482719429331004854824454580718897633003232525821581280327467962002814\
762431828622171054352898348208273451680186131719593324711074662228508710666117\
703465352839577625997744672185715816126411143271794347885990892808486694914139\
097716736900277758502686646540565950394867841110790116104008572744562938425494\
167594605487117235946429105850909950214958793112196135908315882620682332156153\
086833730838173279328196983875087083483880463884784418840031847126974543709373\
298362402875197920802321878744882872843727378017827008058782410749357514889978\
911739746129320351081432703251409030487462262942344327571260086642508333187688\
650756429271605525289544921537651751492196367181049435317858383453865255656640\
657251363575064353236508936790431702597878177190314867963840828810209461490079\
715137717099061954969640070867667102330048672631475510537231757114322317411411\
680622864206388906210192355223546711662137499693269321737043105987225039456574\
924616978260970253359475020913836673772894438696400028110344026084712899000746\
807764844088711341352503367877316797709372778682166117865344231732264637847697\
875144332095340001650692130546476890985050203015044880834261845208730530973189\
492916425322933612431514306578264070283898409841602950309241897120971601649265\
613413433422298827909921786042679812457285345801338260995877178113102167340256\
562744007296834066198480676615805021691833723680399027931606420436812079900316\
264449146190219458229690992122788553948783538305646864881655562294315673128274\
390826450611628942803501661336697824051770155219626522725455850738640585299830\
379180350432876703809252167907571204061237596327685674845079151147313440001832\
570344920909712435809447900462494313455028900680648704293534037436032625820535\
790118395649089354345101342969617545249573960621490288728932792520696535386396\
443225388327522499605986974759882329916263545973324445163755334377492928990581\
175786355555626937426910947117002165411718219750519831787137106051063795558588\
905568852887989084750915764639074693619881507814685262133252473837651192990156\
109189777922008705793396463827490680698769168197492365624226087154176100430608\
904377976678519661891404144925270480881971498801542057787006521594009289777601\
330756847966992955433656139847738060394368895887646054983871478968482805384701\
730871117761159663505039979343869339119789887109156541709133082607647406305711\
411098839388095481437828474528838368079418884342666222070438722887413947801017\
721392281911992365405516395893474263953824829609036900288359327745855060801317\
988407162446563997948275783650195514221551339281978226984278638391679715091262\
410548725700924070045488485692950448110738087996547481568913935380943474556972\
128919827177020766613602489581468119133614121258783895577357194986317210844398\
901423948496659251731388171602663261931065366535041473070804414939169363262373\
767777095850313255990095762731957308648042467701212327020533742667053142448208\
168130306397378736642483672539837487690980602182785786216512738563513290148903\
509883270617258932575363993979055729175160097615459044771692265806315111028038\
436017374742152476085152099016158582312571590733421736576267142390478279587281\
505095633092802668458937649649770232973641319060982740633531089792464242134583\
740901169391964250459128813403498810635400887596820054408364386516617880557608\
956896727531538081942077332597917278437625661184319891025007491829086475149794\
003160703845549465385946027452447466812314687943441610993338908992638411847425\
257044572517459325738989565185716575961481266020310797628254165590506042479114\
016957900338356574869252800743025623419498286467914476322774005529460903940177\
536335655471931000175430047504719144899841040015867946179241610016454716551337\
074073950260442769538553834397550548871099785205401175169747581344926079433689\
543783221172450687344231989878844128542064742809735625807066983106979935260693\
392135685881391214807354728463227784908087002467776303605551232386656295178853\
719673034634701222939581606792509153217489030840886516061119011498443412350124\
646928028805996134283511884715449771278473361766285062169778717743824362565711\
779450064477718370221999106695021656757644044997940765037999954845002710665987\
813603802314126836905783190460792765297277694043613023051787080546511542469395\
265127101052927070306673024447125973939950514628404767431363739978259184541176\
413327906460636584152927019030276017339474866960348694976541752429306040727005\
059039503148522921392575594845078867977925253931765156416197168443524369794447\
355964260633391055126826061595726217036698506473281266724521989060549880280782\
881429796336696744124805982192146339565745722102298677599746738126069367069134\
081559412016115960190237753525556300606247983261249881288192937343476862689219\
239777833910733106588256813777172328315329082525092733047850724977139448333892\
552081175608452966590553940965568541706001179857293813998258319293679100391844\
099286575605993598910002969864460974714718470101531283762631146774209145574041\
815908800064943237855839308530828305476076799524357391631221886057549673832243\
195650655460852881201902363644712703748634421727257879503428486312944916318475\
347531435041392096108796057730987201352484075057637199253650470908582513936863\
463863368042891767107602111159828875539940120076013947033661793715396306139863\
655492213741597905119083588290097656647300733879314678913181465109316761575821\
351424860442292445304113160652700974330088499034675405518640677342603583409608\
605533747362760935658853109760994238347382222087292464497684560579562516765574\
088410321731345627735856052358236389532038534024842273371639123973215995440828\
421666636023296545694703577184873442034227706653837387506169212768015766181095\
420097708363604361110592409117889540338021426523948929686439808926114635414571\
535194342850721353453018315875628275733898268898523557799295727645229391567477\
566676051087887648453493636068278050564622813598885879259940946446041705204470\
046315137975431737187756039815962647501410906658866162180038266989961965580587\
208639721176995219466789857011798332440601811575658074284182910615193917630059\
194314434605154047710570054339000182453117733718955857603607182860506356479979\
004139761808955363669603162193113250223851791672055180659263518036251214575926\
238369348222665895576994660491938112486609099798128571823494006615552196112207\
203092277646200999315244273589488710576623894693889446495093960330454340842102\
462401048723328750081749179875543879387381439894238011762700837196053094383940\
063756116458560943129517597713935396074322792489221267045808183313764165818269\
562105872892447740035947009268662659651422050630078592002488291860839743732353\
849083964326147000532423540647042089499210250404726781059083644007466380020870\
126664209457181702946752278540074508552377720890581683918446592829417018288233\
014971554235235911774818628592967605048203864343108779562892925405638946621948\
268711042828163893975711757786915430165058602965217459581988878680408110328432\
739867198621306205559855266036405046282152306154594474489908839081999738747452\
969810776201487134000122535522246695409315213115337915798026979555710508507473\
874750758068765376445782524432638046143042889235934852961058269382103498000405\
248407084403561167817170512813378805705643450616119330424440798260377951198548\
694559152051960093041271007277849301555038895360338261929343797081874320949914\
159593396368110627557295278004254863060054523839151068998913578820019411786535\
682149118528207852130125518518493711503422159542244511900207393539627400208110\
465530207932867254740543652717595893500716336076321614725815407642053020045340\
183572338292661915308354095120226329165054426123619197051613839357326693760156\
914429944943744856809775696303129588719161129294681884936338647392747601226964\
158848900965717086160598147204467428664208765334799858222090619802173211614230\
419477754990738738567941189824660913091691772274207233367635032678340586301930\
193242996397204445179288122854478211953530898910125342975524727635730226281382\
091807439748671453590778633530160821559911314144205091447293535022230817193663\
509346865858656314855575862447818620108711889760652969899269328178705576435143\
382060141077329261063431525337182243385263520217735440715281898137698755157574\
546939727150488469793619500477720970561793913828989845327426227288647108883270\
173723258818244658436249580592560338105215606206155713299156084892064340303395\
262263451454283678698288074251422567451806184149564686111635404971897682154227\
722479474033571527436819409892050113653400123846714296551867344153741615042563\
256713430247655125219218035780169240326699541746087592409207004669340396510178\
134857835694440760470232540755557764728450751826890418293966113310160131119077\
398632462778219023650660374041606724962490137433217246454097412995570529142438\
208076098364823465973886691349919784013108015581343979194852830436739012482082\
444814128095443773898320059864909159505322857914576884962578665885999179867520\
554558099004556461178755249370124553217170194282884617402736649978475508294228\
020232901221630102309772151569446427909802190826689868834263071609207914085197\
695235553488657743425277531197247430873043619511396119080030255878387644206085\
044730631299277888942729189727169890575925244679660189707482960949190648764693\
702750773866432391919042254290235318923377293166736086996228032557185308919284\
403805071030064776847863243191000223929785255372375566213644740096760539439838\
235764606992465260089090624105904215453927904411529580345334500256244101006359\
530039598864466169595626351878060688513723462707997327233134693971456285542615\
467650632465676620279245208581347717608521691340946520307673391841147504140168\
924121319826881568664561485380287539331160232292555618941042995335640095786495\
340935115266454024418775949316930560448686420862757201172319526405023099774567\
647838488973464317215980626787671838005247696884084989185086149003432403476742\
686245952395890358582135006450998178244636087317754378859677672919526111213859\
194725451400301180503437875277664402762618941017576872680428176623860680477885\
242887430259145247073950546525135339459598789619778911041890292943818567205070\
964606263541732944649576612651953495701860015412623962286413897796733329070567\
376962156498184506842263690367849555970026079867996261019039331263768556968767\
029295371162528005543100786408728939225714512481135778627664902425161990277471\
090335933309304948380597856628844787441469841499067123764789582263294904679812\
089984857163571087831191848630254501620929805829208334813638405421720056121989\
353669371336733392464416125223196943471206417375491216357008573694397305979709\
719726666642267431117762176403068681310351899112271339724036887000996862922546\
465006385288620393800504778276912835603372548255793912985251506829969107754257\
647488325341412132800626717094009098223529657957997803018282428490221470748111\
124018607613415150387569830918652780658896682362523937845272634530420418802508\
442363190383318384550522367992357752929106925043261446950109861088899914658551\
881873582528164302520939285258077969737620845637482114433988162710031703151334\
402309526351929588680690821355853680161000213740851154484912685841268695899174\
149133820578492800698255195740201818105641297250836070356851055331787840829000\
041552511865779453963317538532092149720526607831260281961164858098684587525129\
997404092797683176639914655386108937587952214971731728131517932904431121815871\
023518740757222100123768721944747209349312324107065080618562372526732540733324\
875754482967573450019321902199119960797989373383673242576103938985349278777473\
980508080015544764061053522202325409443567718794565430406735896491017610775948\
364540823486130254718476485189575836674399791508512858020607820554462991723202\
028222914886959399729974297471155371858924238493855858595407438104882624648788\
053304271463011941589896328792678327322456103852197011130466587100500083285177\
311776489735230926661234588873102883515626446023671996644554727608310118788389\
151149340939344750073025855814756190881398752357812331342279866503522725367171\
230756861045004548970360079569827626392344107146584895780241408158405229536937\
499710665594894459246286619963556350652623405339439142111271810691052290024657\
423604130093691889255865784668461215679554256605416005071276641766056874274200\
329577160643448606201239821698271723197826816628249938714995449137302051843669\
076723577400053932662622760323659751718925901801104290384274185507894887438832\
703063283279963007200698012244365116394086922220745320244624121155804354542064\
215121585056896157356414313068883443185280853975927734433655384188340303517822\
946253702015782157373265523185763554098954033236382319219892171177449469403678\
296185920803403867575834111518824177439145077366384071880489358256868542011645\
031357633355509440319236720348651010561049872726472131986543435450409131859513\
145181276437310438972507004981987052176272494065214619959232142314439776546708\
351714749367986186552791715824080651063799500184295938799158350171580759883784\
962257398512129810326379376218322456594236685376799113140108043139732335449090\
824910499143325843298821033984698141715756010829706583065211347076803680695322\
971990599904451209087275776225351040902392888779424630483280319132710495478599\
180196967835321464441189260631526618167443193550817081875477050802654025294109\
218264858213857526688155584113198560022135158887210365696087515063187533002942\
118682221893775546027227291290504292259787710667873840000616772154638441292371\
193521828499824350920891801685572798156421858191197490985730570332667646460728\
757430565372602768982373259745084479649545648030771598153955827779139373601717\
422996027353102768719449444917939785144631597314435351850491413941557329382048\
542123508173912549749819308714396615132942045919380106231421774199184060180347\
949887691051557905554806953878540066453375981862846419905220452803306263695626\
490910827627115903856995051246529996062855443838330327638599800792922846659503\
551211245284087516229060262011857775313747949362055496401073001348853150735487\
353905602908933526400713274732621960311773433943673385759124508149335736911664\
541281788171454023054750667136518258284898099512139193995633241336556777098003\
081910272040997148687418134667006094051021462690280449159646545330107754695413\
088714165312544813061192407821188690056027781824235022696189344352547633573536\
485619363254417756613981703930632872166905722259745209192917262199844409646158\
269456380239502837121686446561785235565164127712826918688615572716201474934052\
276946595712198314943381622114006936307430444173284786101777743837977037231795\
255434107223445512555589998646183876764903972461167959018100035098928641204195\
163551108763204267612979826529425882951141275841262732790798807559751851576841\
264742209479721843309352972665210015662514552994745127631550917636730259462132\
930190402837954246323258550301096706922720227074863419005438302650681214142135\
057154175057508639907673946335146209082888934938376439399256900604067311422093\
312195936202982972351163259386772241477911629572780752395056251581603133359382\
311500518626890530658368129988108663263271980611271548858798093487912913707498\
230575929091862939195014721197586067270092547718025750337730799397134539532646\
195269996596385654917590458333585799102012713204583903200853878881633637685182\
083727885131175227769609787962142372162545214591281831798216044111311671406914\
827170981015457781939202311563871950805024679725792497605772625913328559726371\
211201905720771409148645074094926718035815157571514050397610963846755569298970\
383547314100223802583468767350129775413279532060971154506484212185936490997917\
766874774481882870632315515865032898164228288232746866106592732197907162384642\
153489852476216789050260998045266483929542357287343977680495774091449538391575\
565485459058976495198513801007958010783759945775299196700547602252552034453988\
712538780171960718164078124847847257912407824544361682345239570689514272269750\
431873633263011103053423335821609333191218806608268341428910415173247216053355\
849993224548730778822905252324234861531520976938461042582849714963475341837562\
003014915703279685301868631572488401526639835689563634657435321783493199825542\
117308467745297085839507616458229630324424328237737450517028560698067889521768\
198156710781633405266759539424926280756968326107495323390536223090807081455919\
837355377748742029039018142937311529334644468151212945097596534306284215319445\
727118614900017650558177095302468875263250119705209476159416768727784472000192\
789137251841622857783792284439084301181121496366424659033634194540657183544771\
912446621259392656620306888520055599121235363718226922531781458792593750441448\
933981608657900876165024635197045828895481793756681046474614105142498870252139\
936870509372305447734112641354892806841059107716677821238332810262185587751312\
721179344448201440425745083063944738363793906283008973306241380614589414227694\
747931665717623182472168350678076487573420491557628217583972975134478990696589\
532548940335615613167403276472469212505759116251529654568544633498114317670257\
295661844775487469378464233737238981920662048511894378868224807279352022501796\
545343757274163910791972952950812942922205347717304184477915673991738418311710\
362524395716152714669005814700002633010452643547865903290733205468338872078735\
444762647925297690170912007874183736735087713376977683496344252419949951388315\
074877537433849458259765560996555954318040920178497184685497370696212088524377\
013853757681416632722412634423982152941645378000492507262765150789085071265997\
036708726692764308377229685985169122305037462744310852934305273078865283977335\
246017463527703205938179125396915621063637625882937571373840754406468964783100\
704580613446731271591194608435935825987782835266531151065041623295329047772174\
083559349723758552138048305090009646676088301540612824308740645594431853413755\
220166305812111033453120745086824339432159043594430312431227471385842030390106\
070940315235556172767994160020393975099897629335325855575624808996691829864222\
677502360193257974726742578211119734709402357457222271212526852384295874273501\
563660093188045493338989741571490544182559738080871565281430102670460284316819\
230392535297795765862414392701549740879273131051636119137577008929564823323648\
298263024607975875767745377160102490804624301856524161756655600160859121534556\
267602192689982855377872583145144082654583484409478463178777374794653580169960\
779405568701192328608041130904629350871827125934668712766694873899824598527786\
499569165464029458935064964335809824765965165142090986755203808309203230487342\
703468288751604071546653834619611223013759451579252696743642531927390036038608\
236450762698827497618723575476762889950752114804852527950845033958570838130476\
937881321123674281319487950228066320170022460331989671970649163741175854851878\
484012054844672588851401562725019821719066960812627785485964818369621410721714\
214986361918774754509650308957099470934337856981674465828267911940611956037845\
397855839240761276344105766751024307559814552786167815949657062559755074306521\
085301597908073343736079432866757890533483669555486803913433720156498834220893\
399971641479746938696905480089193067138057171505857307148815649920714086758259\
602876056459782423770242469805328056632787041926768467116266879463486950464507\
420219373945259262668613552940624781361206202636498199999498405143868285258956\
342264328707663299304891723400725471764188685351372332667877921738347541480022\
803392997357936152412755829569276837231234798989446274330454566790062032420516\
396282588443085438307201495672106460533238537203143242112607424485845094580494\
081820927639140008540422023556260218564348994145439950410980591817948882628052\
066441086319001688568155169229486203010738897181007709290590480749092427141018\
933542818429995988169660993836961644381528877214085268088757488293258735809905\
670755817017949161906114001908553744882726200936685604475596557476485674008177\
381703307380305476973609786543859382187220583902344443508867499866506040645874\
346005331827436296177862518081893144363251205107094690813586440519229512932450\
078833398788429339342435126343365204385812912834345297308652909783300671261798\
130316794385535726296998740359570458452230856390098913179475948752126397078375\
944861139451960286751210561638976008880092746115860800207803341591451797073036\
835196977766076373785333012024120112046988609209339085365773222392412449051532\
780950955866459477634482269986074813297302630975028812103517723124465095349653\
693090018637764094094349837313251321862080214809922685502948454661814715557444\
709669530177690434272031892770604717784527939160472281534379803539679861424370\
956683221491465438014593829277393396032754048009552231816667380357183932757077\
142046723838624617803976292377131209580789363841447929802588065522129262093623\
930637313496640186619510811583471173312025805866727639992763579078063818813069\
156366274125431259589936119647626101405563503399523140323113819656236327198961\
837254845333702062563464223952766943568376761368711962921818754576081617053031\
590728828700712313666308722754918661395773730546065997437810987649802414011242\
142773668082751390959313404155826266789510846776118665957660165998178089414985\
754976284387856100263796543178313634025135814161151902096499133548733131115022\
700681930135929595971640197196053625033558479980963488718039111612813595968565\
478868325856437896173159762002419621552896297904819822199462269487137462444729\
093456470028537694958859591606789282491054412515996300781368367490209374915732\
896270028656829344431342347351239298259166739503425995868970697267332582735903\
121288746660451461487850346142827765991608090398652575717263081833494441820193\
533385071292345774375579344062178711330063106003324053991693682603746176638565\
758877580201229366353270267100681261825172914608202541892885935244491070138206\
211553827793565296914576502048643282865557934707209634807372692141186895467322\
767751335690190153723669036865389161291688887876407525493494249733427181178892\
759931596719354758988097924525262363659036320070854440784544797348291802082044\
926670634420437555325050527522833778887040804033531923407685630109347772125639\
088640413101073817853338316038135280828119040832564401842053746792992622037698\
718018061122624490909242641985820861751177113789051609140381575003366424156095\
216328197122335023167422600567941281406217219641842705784328959802882335059828\
208196666249035857789940333152274817776952843681630088531769694783690580671064\
828083598046698841098135158654906933319522394363287923990534810987830274500172\
065433699066117784554364687723631844464768069142828004551074686645392805399409\
108754939166095731619715033166968309929466349142798780842257220697148875580637\
480308862995118473187124777291910070227588893486939456289515802965372150409603\
107761289831263589964893410247036036645058687287589051406841238124247386385427\
908282733827973326885504935874303160274749063129572349742611221517417153133618\
622410913869500688835898962349276317316478340077460886655598733382113829928776\
911495492184192087771606068472874673681886167507221017261103830671787856694812\
948785048943063086169948798703160515884108282351274153538513365895332948629494\
495061868514779105804696039069372662670386512905201137810858616188886947957607\
413585534585151768051973334433495230120395770739623771316030242887200537320998\
253008977618973129817881944671731160647231476248457551928732782825127182446807\
824215216469567819294098238926284943760248852279003620219386696482215628093605\
373178040863727268426696421929946819214908701707533361094791381804063287387593\
848269535583077395761447997270003472880182785281389503217986345216111066608839\
314053226944905455527867894417579202440021450780192099804461382547805858048442\
416404775031536054906591430078158372430123137511562284015838644270890718284816\
757527123846782459534334449622010096071051370608461801187543120725491334994247\
617115633321408934609156561550600317384218701570226103101916603887064661438897\
736318780940711527528174689576401581047016965247557740891644568677717158500583\
269943401677202156767724068128366565264122982439465133197359199709403275938502\
669557470231813203243716420586141033606524536939160050644953060161267822648942\
437397166717661231048975031885732165554988342121802846912529086101485527815277\
625623750456375769497734336846015607727035509629049392487088406281067943622418\
704747008368842671022558302403599841645951122485272633632645114017395248086194\
635840783753556885622317115520947223065437092606797351000565549381224575483728\
545711797393615756167641692895805257297522338558611388322171107362265816218842\
443178857488798109026653793426664216990914056536432249301334867988154886628665\
052346997235574738424830590423677143278792316422403877764330192600192284778313\
837632536121025336935812624086866699738275977365682227907215832478888642369346\
396164363308730139814211430306008730666164803678984091335926293402304324974926\
887831643602681011309570716141912830686577323532639653677390317661361315965553\
584999398600565155921936759977717933019744688148371103206503693192894521402650\
915465184309936553493337183425298433679915939417466223900389527673813330617747\
629574943868716978453767219493506590875711917720875477107189937960894774512654\
757501871194870738736785890200617373321075693302216320628432065671192096950585\
761173961632326217708945426214609858410237813215817727602222738133495410481003\
073275107799948991977963883530734443457532975914263768405442264784216063122769\
646967156473999043715903323906560726644116438605404838847161912109008701019130\
726071044114143241976796828547885524779476481802959736049439700479596040292746\
299203572099761950140348315380947714601056333446998820822120587281510729182971\
211917876424880354672316916541852256729234429187128163232596965413548589577133\
208339911288775917226115273379010341362085614577992398778325083550730199818459\
025958355989260553299673770491722454935329683300002230181517226575787524058832\
249085821280089747909326100762578770428656006996176212176845478996440705066241\
710213327486796237430229155358200780141165348065647488230615003392068983794766\
255036549822805329662862117930628430170492402301985719978948836897183043805182\
174419147660429752437251683435411217038631379411422095295885798060152938752753\
799030938871683572095760715221900279379292786303637268765822681241993384808166\
021603722154710143007377537792699069587121289288019052031601285861825494413353\
820784883465311632650407642428390870121015194231961652268422003711230464300673\
442064747718021353070124098860353399152667923871101706221865883573781210935179\
775604425634694999787251125440854522274810914874307259869602040275941178942581\
281882159952359658979181144077653354321757595255536158128001163846720319346507\
296807990793963714961774312119402021297573125165253768017359101557338153772001\
952444543620071848475663415407442328621060997613243487548847434539665981338717\
466093020535070271952983943271425371155766600025784423031073429551533945060486\
222764966687624079324353192992639253731076892135352572321080889819339168668278\
948281170472624501948409700975760920983724090074717973340788141825195842598096\
241747610138252643955135259311885045636264188300338539652435997416931322894719\
878308427600401368074703904097238473945834896186539790594118599310356168436869\
219485382055780395773881360679549900085123259442529724486666766834641402189915\
944565309423440650667851948417766779470472041958822043295380326310537494883122\
180391279678446100139726753892195119117836587662528083690053249004597410947068\
772912328214304635337283519953648274325833119144459017809607782883583730111857\
543659958982724531925310588115026307542571493943024453931870179923608166611305\
426253995833897942971602070338767815033010280120095997252222280801423571094760\
351925544434929986767817891045559063015953809761875920358937341978962358931125\
983902598310267193304189215109689156225069659119828323455503059081730735195503\
721665870288053992138576037035377105178021280129566841984140362872725623214428\
754302210909472721073474134975514190737043318276626177275996888826027225247133\
683353452816692779591328861381766349857728936900965749562287103024362590772412\
219094300871755692625758065709912016659622436080242870024547362036394841255954\
881727272473653467783647201918303998717627037515724649922289467932322693619177\
641614618795613956699567783068290316589699430767333508234990790624100202506134\
057344300695745474682175690441651540636584680463692621274211075399042188716127\
617787014258864825775223889184599523376292377915585744549477361295525952226578\
636462118377598473700347971408206994145580719080213590732269233100831759510659\
019121294795408603640757358750205890208704579670007055262505811420663907459215\
273309406823649441590891009220296680523325266198911311842016291631076894084723\
564366808182168657219688268358402785500782804043453710183651096951782335743030\
504852653738073531074185917705610397395062640355442275156101107261779370634723\
804990666922161971194259120445084641746383589938239946517395509000859479990136\
026674261494290066467115067175422177038774507673563742154782905911012619157555\
870238957001405117822646989944917908301795475876760168094100135837613578591356\
924455647764464178667115391951357696104864922490083446715486383054477914330097\
680486878348184672733758436892724310447406807685278625585165092088263813233623\
148733336714764520450876627614950389949504809560460989604329123358348859990294\
526400284994280878624039811814884767301216754161106629995553668193123287425702\
063738352020086863691311733469731741219153633246745325630871347302792174956227\
014687325867891734558379964351358800959350877556356248810493852999007675135513\
527792412429277488565888566513247302514710210575352516511814850902750476845518\
252096331899068527614435138213662152368890578786699432288816028377482035506016\
029894009119713850179871683633744139275973644017007014763706655703504338121113\
576415018451821413619823495159601064752712575935185304332875537783057509567425\
442684712219618709178560783936144511383335649103256405733898667178123972237519\
316430617013859539474367843392670986712452211189690840236327411496601243483098\
929941738030588417166613073040067588380432111555379440605497721705942821514886\
165672771240903387727745629097110134885184374118695655449745736845218066982911\
045058004299887953899027804383596282409421860556287788428802127553884803728640\
019441614257499904272009595204654170598104989967504511936471172772220436102614\
079750809686975176600237187748348016120310234680567112644766123747627852190241\
202569943534716226660893675219833111813511146503854895025120655772636145473604\
426859498074396932331297127377157347099713952291182653485155587137336629120242\
714302503763269501350911612952993785864681307226486008270881333538193703682598\
867893321238327053297625857382790097826460545598555131836688844628265133798491\
667839409761353766251798258249663458771950124384040359140849209733754642474488\
176184070023569580177410177696925077814893386672557898564589851056891960924398\
841569280696983352240225634570497312245269354193837004843183357196516626721575\
524193401933099018319309196582920969656247667683659647019595754739345514337413\
708761517323677204227385674279170698204549953095918872434939524094441678998846\
319845504852393662972079777452814399418256789457795712552426826089940863317371\
538896262889629402112108884427376568624527612130371017300785135715404533041507\
959447776143597437803742436646973247138410492124314138903579092416036406314038\
149831481905251720937103964026808994832572297954564042701757722904173234796073\
618787889913318305843069394825961318713816423467218730845133877219086975104942\
843769325024981656673816260615941768252509993741672883951744066932549653403101\
452225316189009235376486378482881344209870048096227171226407489571939002918573\
307460104360729190945767994614929290427981687729426487729952858434647775386906\
950148984133924540394144680263625402118614317031251117577642829914644533408920\
976961699098372652361768745605894704968170136974909523072082682887890730190018\
253425805343421705928713931737993142410852647390948284596418093614138475831136\
130576108462366837237695913492615824516221552134879244145041756848064120636520\
170386330129532777699023118648020067556905682295016354931992305914246396217025\
329747573114094220180199368035026495636955866425906762685687372110339156793839\
895765565193177883000241613539562437777840801748819373095020699900890899328088\
397430367736595524891300156633294077907139615464534088791510300651321934486673\
248275907946807879819425019582622320395131252014109960531260696555404248670549\
986786923021746989009547850725672978794769888831093487464426400718183160331655\
511534276155622405474473378049246214952133258527698847336269182649174338987824\
789278468918828054669982303689939783413747587025805716349413568433929396068192\
061773331791738208562436433635359863494496890781064019674074436583667071586924\
521182997893804077137501290858646578905771426833582768978554717687184427726120\
509266486102051535642840632368481807287940717127966820060727559555904040233178\
749447346454760628189541512139162918444297651066947969354016866010055196077687\
335396511614930937570968554559381513789569039251014953265628147011998326992200\
066392875374713135236421589265126204072887716578358405219646054105435443642166\
562244565042999010256586927279142752931172082793937751326106052881235373451068\
372939893580871243869385934389175713376300720319760816604464683937725806909237\
297523486702916910426369262090199605204121024077648190316014085863558427609537\
086558164273995349346546314504040199528537252004957805254656251154109252437991\
326262713609099402902262062836752132305065183934057450112099341464918433323646\
569371725914489324159006242020612885732926133596808726500045628284557574596592\
120530341310111827501306961509835515632004310784601906565493806542525229161991\
819959602752327702249855738824899882707465936355768582560518068964285376850772\
012220347920993936179268206590142165615925306737944568949070853263568196831861\
772268249911472615732035807646298116244013316737892788689229032593349861797021\
994981925739617673075834417098559222170171825712777534491508205278430904619460\
835217402005838672849709411023266953921445461066215006410674740207009189911951\
376466904481267253691537162290791385403937560077835153374167747942100384002308\
951850994548779039346122220865060160500351776264831611153325587705073541279249\
909859373473787081194253055121436979749914951860535920403830235716352727630874\
693219622190064260886183676103346002255477477813641012691906569686495012688376\
296907233961276287223041141813610060264044030035996988919945827397624114613744\
804059697062576764723766065541618574690527229238228275186799156983390747671146\
103022776606020061246876477728819096791613354019881402757992174167678799231603\
963569492851513633647219540611171767387372555728522940054361785176502307544693\
869307873499110352182532929726044553210797887711449898870911511237250604238753\
734841257086064069052058452122754533848008205302450456517669518576913200042816\
758054924811780519832646032445792829730129105318385636821206215531288668564956\
512613892261367064093953334570526986959692350353094224543865278677673027540402\
702246384483553239914751363441044050092330361271496081355490531539021002299595\
756583705381261965683144286057956696622154721695620870013727768536960840704833\
325132793112232507148630206951245395003735723346807094656483089209801534878705\
633491092366057554050864111521441481434630437273271045027768661953107858323334\
857840297160925215326092558932655600672124359464255065996771770388445396181632\
879614460817789272171836908880126778207430106422524634807454300476492885553409\
062185153654355474125476152769772667769772777058315801412185688011705028365275\
543214803488004442979998062157904564161957212784508928489806426497427090579129\
069217807298769477975112447305991406050629946894280931034216416629935614828130\
998870745292716048433630818404126469637925843094185442216359084576146078558562\
473814931427078266215185541603870206876980461747400808324343665382354555109449\
498431093494759944672673665352517662706772194183191977196378015702169933675083\
760057163454643671776723387588643405644871566964321041282595645349841388412890\
420682047007615596916843038999348366793542549210328113363184722592305554383058\
206941675629992013373175489122037230349072681068534454035993561823576312837767\
640631013125335212141994611869350833176587852047112364331226765129964171325217\
513553261867681942338790365468908001827135283584888444111761234101179918709236\
507184857856221021104009776994453121795022479578069506532965940383987369907240\
797679040826794007618729547835963492793904576973661643405359792219285870574957\
481696694062334272619733518136626063735982575552496509807260123668283605928341\
855848026958413772558970883789942910549800331113884603401939166122186696058491\
571485733568286149500019097591125218800396419762163559375743718011480559442298\
730418196808085647265713547612831629200449880315402105530597076666362749328308\
916880932359290081787411985738317192616728834918402429721290434965526942726402\
559641463525914348400675867690350382320572934132981593533044446496829441367323\
442158380761694831219333119819061096142952201536170298575105594326461468505452\
684975764807808009221335811378197749271768545075538328768874474591593731162470\
601091244609829424841287520224462594477638749491997840446829257360968534549843\
266536862844489365704111817793806441616531223600214918768769467398407517176307\
516849856359201486892943105940202457969622924566644881967576294349535326382171\
613395757790766370764569570259738800438415805894336137106551859987600754924187\
211714889295221737721146081154344982665479872580056674724051122007383459271575\
727715218589946948117940644466399432370044291140747218180224825837736017346685\
300744985564715420036123593397312914458591522887408719508708632218837288262822\
884631843717261903305777147651564143822306791847386039147683108141358275755853\
643597721650028277803713422869688787349795096031108899196143386664068450697420\
787700280509367203387232629637856038653216432348815557557018469089074647879122\
436375556668678067610544955017260791142930831285761254481944449473244819093795\
369008206384631678225064809531810406570254327604385703505922818919878065865412\
184299217273720955103242251079718077833042609086794273428955735559252723805511\
440438001239041687716445180226491681641927401106451622431101700056691121733189\
423400547959684669804298017362570406733282129962153684881404102194463424646220\
745575643960452985313071409084608499653767803793201899140865814662175319337665\
970114330608625009829566917638846056762972931464911493704624469351984039534449\
135141193667933301936617663652555149174982307987072280860859626112660504289296\
966535652516688885572112276802772743708917389639772257564890533401038855931125\
679991516589025016486961427207005916056166159702451989051832969278935550303934\
681219761582183980483960562523091462638447386296039848924386187298507775928792\
722068554807210497817653286210187476766897248841139560349480376727036316921007\
350834073865261684507482496448597428134936480372426116704266870831925040997615\
319076855770327421785010006441984124207396400139603601583810565928413684574119\
102736420274163723488214524101347716529603128408658419787951116511529827814620\
379139855006399960326591248525308493690313130100799977191362230866011099929142\
871249388541612038020411340188887219693477904497527454288072803509305828754420\
755134816660927879353566521255620139988249628478726214432362853676502591450468\
377635282587652139156480972141929675549384375582600253168536356731379262475878\
049445944183429172756988376226261846365452743497662411138451305481449836311789\
784489732076719508784158618879692955819733250699951402601511675529750575437810\
242238957925786562128432731202200716730574069286869363930186765958251326499145\
950260917069347519408975357464016830811798846452473618956056479426358070562563\
281189269663026479535951097127659136233180866921535788607812759910537171402204\
506186075374866306350591483916467656723205714516886170790984695932236724946737\
583099607042589220481550799132752088583781117685214269334786921895240622657921\
043620348852926267984013953216458791151579050460579710838983371864038024417511\
347226472547010794793996953554669619726763255229914654933499663234185951450360\
980344092212206712567698723427940708857070474293173329188523896721971353924492\
426178641188637790962814486917869468177591717150669111480020759432012061969637\
795103227089029566085562225452602610460736131368869009281721068198618553780982\
018471154163630326265699283424155023600978046417108525537612728905335045506135\
684143775854429677977014660294387687225115363801191758154028120818255606485410\
787933598921064427244898618961629413418001295130683638609294100083136673372153\
008352696235737175330738653338204842190308186449184093723944033405244909554558\
016406460761581010301767488475017661908692946098769201691202181688291040870709\
560951470416921147027413390052253340834812870353031023919699978597413908593605\
433599697075604460134242453682496098772581311024732798562072126572499003468293\
886872304895562253204463602639854225258416464324271611419817802482595563544907\
219226583863662663750835944314877635156145710745528016159677048442714194435183\
275698407552677926411261765250615965235457187956673170913319358761628255920783\
080185206890151504713340386100310055914817852110384754542933389188444120517943\
969970194112695119526564919594189975418393234647424290702718875223534393673633\
663200307232747037407123982562024662651974090199762452056198557625760008708173\
083288344381831070054514493545885422678578551915372292379555494333410174420169\
600090696415612732297770221217951868376359082255128816470021992348864043959153\
018464004714321186360622527011541122283802778538911098490201342741014121559769\
965438877197485376431158229838533123071751132961904559007938064276695819014842\
627991221792947987348901868471676503827328552059082984529806259250352128451925\
927986593506132961946796252373972565584157853744567558998032405492186962888490\
332560851455344391660226257775512916200772796852629387937530454181080729285891\
989715381797343496187232927614747850192611450413274873242970583408471112333746\
274617274626582415324271059322506255302314738759251724787322881491455915605036\
334575424233779160374952502493022351481961381162563911415610326844958072508273\
431765944054098269765269344579863479709743124498271933113863873159636361218623\
497261409556079920628316999420072054811525353393946076850019909886553861433495\
781650089961649079678142901148387645682174914075623767618453775144031475411206\
760160726460556859257799322070337333398916369504346690694828436629980037414527\
627716547623825546170883189810868806847853705536480469350958818025360529740793\
538676511195079373282083146268960071075175520614433784114549950136432446328193\
346389050936545714506900864483440180428363390513578157273973334537284263372174\
065775771079830517555721036795976901889958494130195999573017901240193908681356\
585539661941371794487632079868800371607303220547423572266896801882123424391885\
984168972277652194032493227314793669234004848976059037958094696041754279613782\
553781223947646147832926976545162290281701100437846038756544151739433960048915\
318817576650500951697402415644771293656614253949368884230517400129920556854289\
853897942669956777027089146513736892206104415481662156804219838476730871787590\
279209175900695273456682026513373111518000181434120962601658629821076663523361\
774007837783423709152644063054071807843358061072961105550020415131696373046849\
213356837265400307509829089364612047891114753037049893952833457824082817386441\
322710002968311940203323456420826473276233830294639378998375836554559919340866\
235090967961134004867027123176526663710778725111860354037554487418693519733656\
621772359229396776463251562023487570113795712096237723431370212031004965152111\
976013176419408203437348512852602913334915125083119802850177855710725373149139\
215709105130965059885999931560863655477403551898166733535880048214665099741433\
761182777723351910741217572841592580872591315074606025634903777263373914461377\
038021318347447301113032670296917335047701632106616227830027269283365584011791\
419447808748253360714403296252285775009808599609040936312635621328162071453406\
104224112083010008587264252112262480142647519426184325853386753874054743491072\
710049754281159466017136122590440158991600229827801796035194080046513534752698\
777609527839984368086908989197839693532179980139135442552717910225397010810632\
143048511378291498511381969143043497500189980681644412123273328307192824362406\
733196554692677851193152775113446468905504248113361434984604849051258345683266\
441528489713972376040328212660253516693914082049947320486021627759791771234751\
097502403078935759937715095021751693555827072533911892334070223832077585802137\
174778378778391015234132098489423459613692340497998279304144463162707214796117\
456975719681239291913740982925805561955207434243295982898980529233366415419256\
367380689494201471241340525072204061794355252555225008748790086568314542835167\
750542294803274783044056438581591952666758282929705226127628711040134801787224\
801789684052407924360582742467443076721645270313451354167649668901274786801010\
295133862698649748212118629040337691568576240699296372493097201628707200189835\
423690364149270236961938547372480329855045112089192879829874467864129159417531\
675602533435310626745254507114181483239880607297140234725520713490798398982355\
268723950909365667878992383712578976248755990443228895388377317348941122757071\
410959790047919301046740750411435381782464630795989555638991884773781341347070\
246747362112048986226991888517456251732519341352038115863350123913054441910073\
628447567514161050410973505852762044489190978901984315485280533985777844313933\
883994310444465669244550885946314081751220331390681596592510546858013133838152\
176418210433429788826119630443111388796258746090226130900849975430395771243230\
616906262919403921439740270894777663702488155499322458825979020631257436910946\
393252806241642476868495455324938017639371615636847859823715902385421265840615\
367228607131702674740131145261063765383390315921943469817605358380310612887852\
051546933639241088467632009567089718367490578163085158138161966882222047570437\
590614338040725853862083565176998426774523195824182683698270160237414938363496\
629351576854061397342746470899685618170160551104880971554859118617189668025973\
541705423985135560018720335079060946421271143993196046527424050882225359773481\
519135438571253258540493946010865793798058620143366078825219717809025817370870\
916460452727977153509910340736425020386386718220522879694458387652947951048660\
717390229327455426785669776865939923416834122274663015062155320502655341460995\
249356050854921756549134830958906536175693817637473644183378974229700703545206\
663170929607591989627732423090252397443861014263098687733913882518684316501027\
964911497737582888913450341148865948670215492101084328080783428089417298008983\
297536940644969903125399863919581601468995220880662285408414864274786281975546\
629278814621607171381880180840572084715868906836919393381864278454537956719272\
397972364651667592011057995663962598535512763558768140213409829016296873429850\
792471846056874828331381259161962476156902875901072733103299140623864608333378\
638257926302391590003557609032477281338887339178096966601469615031754226751125\
993315529674213336300222964906480934582008181061802100227664580400278213336758\
573019011371754672763059044353131319036092489097246427928455549913490005180295\
707082919052556781889913899625138662319380053611346224294610248954072404857123\
256628888931722116432947816190554868054943441034090680716088028227959686950133\
643814268252170472870863010137301155236861416908375675747637239763185757038109\
443390564564468524183028148107998376918512127201935044041804604721626939445788\
377090105974693219720558114078775989772072009689382249303236830515862657281114\
637996983137517937623215111252349734305240622105244234353732905655163406669506\
165892878218707756794176080712973781335187117931650033155523822487730653444179\
453415395202424449703410120874072188109388268167512042299404948179449472732894\
770111574139441228455521828424922240658752689172272780607116754046973008037039\
618787796694882555614674384392570115829546661358678671897661297311267200072971\
553613027503556167817765442287442114729881614802705243806817653573275578602505\
847084013208837932816008769081300492491473682517035382219619039014999523495387\
105997351143478292339499187936608692301375596368532373806703591144243268561512\
109404259582639301678017128669239283231057658851714020211196957064799814031505\
633045141564414623163763809904402816256917576489142569714163598439317433270237\
812336938043012892626375382667795034169334323607500248175741808750388475094939\
454896209740485442635637164995949920980884294790363666297526003243856352945844\
728944547166209297495496616877414120882130477022816116456044007236351581149729\
739218966737382647204722642221242016560150284971306332795814302516013694825567\
014780935790889657134926158161346901806965089556310121218491805847922720691871\
696316330044858020102860657858591269974637661741463934159569539554203314628026\
518951167938074573315759846086173702687867602943677780500244673391332431669880\
354073232388281847501051641331189537036488422690270478052742490603492082954755\
054003457160184072574536938145531175354210726557835615499874447480427323457880\
061873149341566046352979779455075359304795687209316724536547208381685855606043\
801977030764246083489876101345709394877002946175792061952549255757109038525171\
488525265671045349813419803390641529876343695420256080277614421914318921393908\
834543131769685101840103844472348948869520981943531906506555354617335814045544\
837884752526253949665869992058417652780125341033896469818642430034146791380619\
028059607854888010789705516946215228773090104467462497979992627120951684779568\
482583341402266477210843362437593741610536734041954738964197895425335036301861\
400951534766961476255651873823292468547356935802896011536791787303553159378363\
082248615177770541577576561759358512016692943111138863582159667618830326104164\
651714846979385422621687161400122378213779774131268977266712992025922017408770\
076956283473932201088159356286281928563571893384958850603853158179760679479840\
878360975960149733420572704603521790605647603285569276273495182203236144112584\
182426247712012035776388895974318232827871314608053533574494297621796789034568\
169889553518504478325616380709476951699086247100019748809205009521943632378719\
764870339223811540363475488626845956159755193765410115014067001226927474393888\
589943859730245414801061235908036274585288493563251585384383242493252666087588\
908318700709100237377106576985056433928854337658342596750653715005333514489908\
293887737352051459333049626531415141386124437935885070944688045486975358170212\
908490787347806814366323322819415827345671356443171537967818058195852464840084\
032909981943781718177302317003989733050495387356116261023999433259780126893432\
605584710278764901070923443884634011735556865903585244919370181041626208504299\
258697435817098133894045934471937493877624232409852832762266604942385129709453\
245586252103600829286649724174919141988966129558076770979594795306013119159011\
773943104209049079424448868513086844493705909026006120649425744710353547657859\
242708130410618546219881830090634588187038755856274911587375421064667951346487\
586771543838018521348281915812462599335160198935595167968932852205824799421034\
512715877163345222995418839680448835529753361286837225935390079201666941339091\
168758803988828869216002373257361588207163516271332810518187602104852180675526\
648673908900907195138058626735124312215691637902277328705410842037841525683288\
718046987952513073266340278519059417338920358540395677035611329354482585628287\
610610698229721420961993509331312171187891078766872044548876089410174798647137\
882462153955933333275562009439580434537919782280590395959927436913793778664940\
964048777841748336432684026282932406260081908081804390914556351936856063045089\
142289645219987798849347477729132797266027658401667890136490508741142126861969\
862044126965282981087045479861559545338021201155646979976785738920186243599326\
777689454060508218838227909833627167124490026761178498264377033002081844590009\
717235204331994708242098771514449751017055643029542821819670009202515615844174\
205933658148134902693111517093872260026458630561325605792560927332265579346280\
805683443921373688405650434307396574061017779370141424615493070741360805442100\
295600095663588977899267630517718781943706761498217564186590116160865408635391\
513039201316805769034172596453692350806417446562351523929050409479953184074862\
151210561833854566176652606393713658802521666223576132201941701372664966073252\
010771947931265282763302413805164907174565964853748354669194523580315301969160\
480994606814904037819829732360930087135760798621425422096419004367905479049930\
078372421581954535418371129368658430553842717628035279128821129308351575656599\
944741788438381565148434229858704245592434693295232821803508333726283791830216\
591836181554217157448465778420134329982594566884558266171979012180849480332448\
787258183774805522268151011371745368417870280274452442905474518234674919564188\
551244421337783521423865979925988203287085109338386829906571994614906290257427\
686038850511032638544540419184958866538545040571323629681069146814847869659166\
861842756798460041868762298055562963045953227923051616721591968675849523635298\
935788507746081537321454642984792310511676357749494622952569497660359473962430\
995343310404994209677883827002714478494069037073249106444151696053256560586778\
757417472110827435774315194060757983563629143326397812218946287447798119807225\
646714664054850131009656786314880090303749338875364183165134982546694673316118\
123364854397649325026179549357204305402182974871251107404011611405899911093062\
492312813116340549262571356721818628932786138833718028535056503591952741400869\
510926167541476792668032109237467087213606278332922386413619594121339278036118\
276324106004740971111048140003623342714514483334641675466354699731494756643423\
659493496845884551524150756376605086632827424794136062876041290644913828519456\
402643153225858624043141838669590633245063000392213192647625962691510904457695\
301444054618037857503036686212462278639752746667870121003392984873375014475600\
322100622358029343774955032037012738468163061026570300872275462966796880890587\
127676361066225722352229739206443093524327228100859973095132528630601105497915\
644791845004618046762408928925680912930592960642357021061524646205023248966593\
987324933967376952023991760898474571843531936646529125848064480196520162838795\
189499336759241485626136995945307287254532463291529110128763770605570609531377\
527751867923292134955245133089867969165129073841302167573238637575820080363575\
728002754490327953079900799442541108725693188014667935595834676432868876966610\
097395749967836593397846346959948950610490383647409504695226063858046758073069\
912290474089879166872117147527644711604401952718169508289733537148530928937046\
384420893299771125856840846608339934045689026787516008775461267988015465856522\
061210953490796707365539702576199431376639960606061106406959330828171876426043\
573425361756943784848495250108266488395159700490598380812105221111091943323951\
136051446459834210799058082093716464523127704023160072138543723461267260997870\
385657091998507595634613248460188409850194287687902268734556500519121546544063\
829253851276317663922050938345204300773017029940362615434001322763910912988327\
863920412300445551684054889809080779174636092439334912641164240093880746356607\
262336695842764583698268734815881961058571835767462009650526065929263548291499\
045768307210893245857073701660717398194485028842603963660746031184786225831056\
580870870305567595861341700745402965687634774176431051751036732869245558582082\
372038601781739405175130437994868822320044378043103170921034261674998000073016\
094814586374488778522273076330495383944345382770608760763542098445008306247630\
253572781032783461766970544287155315340016497076657195985041748199087201490875\
686037783591994719343352772947285537925787684832301101859365800717291186967617\
655053775030293033830706448912811412025506150896411007623824574488655182581058\
140345320124754723269087547507078577659732542844459353044992070014538748948226\
556442223696365544194225441338212225477497535494624827680533336983284156138692\
363443358553868471111430498248398991803165458638289353799130535222833430137953\
372954016257623228081138499491876144141322933767106563492528814528239506209022\
357876684650116660097382753660405446941653422239052108314585847035529352219928\
272760574821266065291385530345549744551470344939486863429459658431024190785923\
680224560763936784166270518555178702904073557304620639692453307795782245949710\
420188043000183881429008173039450507342787013124466860092778581811040911511729\
374873627887874907465285565434748886831064110051023020875107768918781525622735\
251550379532444857787277617001964853703555167655209119339343762866284619844026\
295252183678522367475108809781507098978413086245881522660963551401874495836926\
917799047120726494905737264286005211403581231076006699518536124862746756375896\
225299116496066876508261734178484789337295056739007878617925351440621045366250\
640463728815698232317500596261080921955211150859302955654967538862612972339914\
628358476048627627027309739202001432248707582337354915246085608210328882974183\
906478869923273691360048837436615223517058437705545210815513361262142911815615\
301758882573594892507108879262128641392443309383797333867806131795237315266773\
820858024701433527009243803266951742119507670884326346442749127558907746863582\
162166042741315170212458586056233631493164646913946562497471741958354218607748\
711057338458433689939645913740603382159352243594751626239188685307822821763983\
237306180204246560477527943104796189724299533029792497481684052893791044947004\
590864991872727345413508101983881864673609392571930511968645601855782450218231\
065889437986522432050677379966196955472440585922417953006820451795370043472451\
762893566770508490213107736625751697335527462302943031203596260953423574397249\
659211010657817826108745318874803187430823573699195156340957162700992444929749\
105489851519658664740148225106335367949737142510229341882585117371994499115097\
583746130105505064197721531929354875371191630262030328588658528480193509225875\
775597425276584011721342323648084027143356367542046375182552524944329657043861\
387865901965738802868401894087672816714137033661732650120578653915780703088714\
261519075001492576112927675193096728453971160213606303090542243966320674323582\
797889332324405779199278484633339777737655901870574806828678347965624146102899\
508487399692970750432753029972872297327934442988646412725348160603779707298299\
173029296308695801996312413304939350493325412355071054461182591141116454534710\
329881047844067780138077131465400099386306481266614330858206811395838319169545\
558259426895769841428893743467084107946318932539106963955780706021245974898293\
564613560788983472419979478564362042094613412387613198865352358312996862268948\
608408456655606876954501274486631405054735351746873009806322780468912246821460\
806727627708402402266155485024008952891657117617439020337584877842911289623247\
059191874691042005848326140677333751027195653994697162517248312230633919328707\
983800748485726516123434933273356664473358556430235280883924348278760886164943\
289399166399210488307847777048045728491456303353265070029588906265915498509407\
972767567129795010098229476228961891591441520032283878773485130979081019129267\
227103778898053964156362364169154985768408398468861684375407065121039062506128\
107663799047908879674778069738473170475253442156390387201238806323688037017949\
308954900776331523063548374256816653361606641980030188287123767481898330246836\
371488309259283375902278942588060087286038859168849730693948020511221766359138\
251524278670094406942355120201568377778851824670025651708509249623747726813694\
284350062938814429987905301056217375459182679973217735029368928065210025396268\
807498092643458011655715886700443503976505323478287327368840863540002740676783\
821963522226539290939807367391364082898722017776747168118195856133721583119054\
682936083236976113450281757830202934845982925000895682630271263295866292147653\
142233351793093387951357095346377183684092444422096319331295620305575517340067\
973740614162107923633423805646850092037167152642556371853889571416419772387422\
610596667396997173168169415435095283193556417705668622215217991151355639707143\
312893657553844648326201206424338016955862698561022460646069330793847858814367\
407000599769703649019273328826135329363112403650698652160638987250267238087403\
396744397830258296894256896741864336134979475245526291426522842419243083388103\
580053787023999542172113686550275341362211693140694669513186928102574795985605\
145005021715913317751609957865551981886193211282110709442287240442481153406055\
895958355815232012184605820563592699303478851132068626627588771446035996656108\
430725696500563064489187599466596772847171539573612108180841547273142661748933\
134174632662354222072600146012701206934639520564445543291662986660783089068118\
790090815295063626782075614388815781351134695366303878412092346942868730839320\
432333872775496805210302821544324723388845215343727250128589747691460808314404\
125868181540049187772287869801853454537006526655649170915429522756709222217474\
112062720656622989806032891672068743654948246108697367225547404812889242471854\
323605753411672850757552057131156697954584887398742228135887985840783135060548\
290551482785294891121905383195624228719484759407859398047901094194070671764439\
032730712135887385049993638838205501683402777496070276844880281912220636888636\
811043569529300652195528261526991271637277388418993287130563464688227398288763\
198645709836308917786487086676185485680047672552675414742851028145807403152992\
197814557756843681110185317498167016426647884090262682824448258027532094549915\
104518517716546311804904567985713257528117913656278158111288816562285876030875\
974963849435275676612168959261485030785362045274507752950631012480341804584059\
432926079854435620093708091821523920371790678121992280496069738238743312626730\
306795943960954957189577217915597300588693646845576676092450906088202212235719\
254536715191834872587423919410890444115959932760044506556206461164655665487594\
247369252336955993030355095817626176231849561906494839673002037763874369343999\
829430209147073618947932692762445186560239559053705128978163455423320114975994\
896278424327483788032701418676952621180975006405149755889650293004867605208010\
491537885413909424531691719987628941277221129464568294860281493181560249677887\
949813777216229359437811004448060797672429276249510784153446429150842764520002\
042769470698041775832209097020291657347251582904630910359037842977572651720877\
244740952267166306005469716387943171196873484688738186656751279298575016363411\
314627530499019135646823804329970695770150789337728658035712790913767420805655\
493624646412600244`100000.",
  StripOnInput->False,
  FontSize->4]], "Output",
 ImageSize->{586, 1735},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20166333]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8594],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CompiledFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CompiledFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RealDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RealDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PossibleZeroQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PossibleZeroQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28227]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31464],

Cell[TextData[ButtonBox["Numerical Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematics-BasicOperations"]], "Tutorials",
 CellID->123709578],

Cell[TextData[ButtonBox["Exact and Approximate Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExactAndApproximateResults"]], "Tutorials",
 CellID->21501],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Calculations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionCalculations"]], "Tutorials",
 CellID->15380],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->30585],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "Tutorials",
 CellID->16702],

Cell[TextData[ButtonBox["Defining Numerical Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningNumericalValues"]], "Tutorials",
 CellID->672156057]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->11073],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5677"], None}]], "RelatedLinks",
 CellID->9653]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->56220687],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->192282218],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->68147849],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->287356060]
}, Open  ]],

Cell["New in 1  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"N - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 21.7169324}", "context" -> "System`", 
    "keywords" -> {
     "approximations", "decimal places", "adaptive precision", 
      "adaptive accuracy", "numerical values", "numerical approximation", 
      "numericalize", "numericize", "arbitrary precision numbers", 
      "arbitrary accuracy numbers", "significance arithmetic", 
      "validated numerics", "guaranteed numerical values"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "N[expr] gives the numerical value of expr. N[expr, n] attempts to give a \
result with n-digit precision. ", "synonyms" -> {}, "title" -> "N", "type" -> 
    "Symbol", "uri" -> "ref/N"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12680, 440, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->493011386]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 195619, 4885}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3802, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4425, 109, 39, 1, 70, "ObjectName",
 CellID->14969],
Cell[4467, 112, 971, 32, 70, "Usage",
 CellID->21813]
}, Open  ]],
Cell[CellGroupData[{
Cell[5475, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5953, 166, 514, 18, 70, "Notes",
 CellID->14398],
Cell[6470, 186, 381, 14, 70, "Notes",
 CellID->1244],
Cell[6854, 202, 283, 8, 70, "Notes",
 CellID->20359],
Cell[7140, 212, 180, 6, 70, "Notes",
 CellID->26850],
Cell[7323, 220, 673, 25, 70, "Notes",
 CellID->20456],
Cell[7999, 247, 270, 10, 70, "Notes",
 CellID->25605],
Cell[8272, 259, 579, 20, 70, "Notes",
 CellID->25810],
Cell[8854, 281, 518, 20, 70, "Notes",
 CellID->8428],
Cell[9375, 303, 270, 10, 70, "Notes",
 CellID->3913],
Cell[9648, 315, 433, 17, 70, "Notes",
 CellID->420],
Cell[10084, 334, 422, 13, 70, "Notes",
 CellID->16882],
Cell[10509, 349, 549, 21, 70, "Notes",
 CellID->3032],
Cell[11061, 372, 555, 21, 70, "Notes",
 CellID->23266],
Cell[11619, 395, 508, 19, 70, "Notes",
 CellID->16387],
Cell[12130, 416, 513, 19, 70, "Notes",
 CellID->20631]
}, Closed]],
Cell[CellGroupData[{
Cell[12680, 440, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->493011386],
Cell[CellGroupData[{
Cell[13065, 454, 148, 5, 70, "ExampleSection",
 CellID->104525302],
Cell[13216, 461, 59, 1, 70, "ExampleText",
 CellID->1866],
Cell[CellGroupData[{
Cell[13300, 466, 116, 4, 28, "Input",
 CellID->19168],
Cell[13419, 472, 173, 5, 36, "Output",
 CellID->27147]
}, Open  ]],
Cell[13607, 480, 119, 3, 70, "ExampleDelimiter",
 CellID->371],
Cell[13729, 485, 81, 1, 70, "ExampleText",
 CellID->1137],
Cell[CellGroupData[{
Cell[13835, 490, 141, 5, 70, "Input",
 CellID->26633],
Cell[13979, 497, 231, 7, 36, "Output",
 CellID->24312]
}, Open  ]],
Cell[14225, 507, 120, 3, 70, "ExampleDelimiter",
 CellID->7862],
Cell[14348, 512, 117, 3, 70, "ExampleText",
 CellID->5320],
Cell[CellGroupData[{
Cell[14490, 519, 152, 5, 70, "Input",
 CellID->27101],
Cell[14645, 526, 172, 5, 36, "Output",
 CellID->32555]
}, Open  ]],
Cell[14832, 534, 110, 3, 70, "ExampleText",
 CellID->4685],
Cell[CellGroupData[{
Cell[14967, 541, 177, 6, 70, "Input",
 CellID->28086],
Cell[15147, 549, 231, 7, 36, "Output",
 CellID->13117]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15427, 562, 217, 7, 70, "ExampleSection",
 CellID->19763],
Cell[CellGroupData[{
Cell[15669, 573, 244, 7, 70, "ExampleSubsection",
 CellID->1001097239],
Cell[15916, 582, 88, 1, 70, "ExampleText",
 CellID->10648],
Cell[CellGroupData[{
Cell[16029, 587, 118, 4, 70, "Input",
 CellID->27932],
Cell[16150, 593, 231, 7, 36, "Output",
 CellID->18667]
}, Open  ]],
Cell[CellGroupData[{
Cell[16418, 605, 124, 4, 70, "Input",
 CellID->28953],
Cell[16545, 611, 246, 7, 36, "Output",
 CellID->31146]
}, Open  ]],
Cell[16806, 621, 119, 3, 70, "ExampleDelimiter",
 CellID->213],
Cell[16928, 626, 85, 1, 70, "ExampleText",
 CellID->24709029],
Cell[CellGroupData[{
Cell[17038, 631, 114, 4, 70, "Input",
 CellID->23594],
Cell[17155, 637, 215, 6, 36, "Output",
 CellID->15707]
}, Open  ]],
Cell[CellGroupData[{
Cell[17407, 648, 126, 4, 70, "Input",
 CellID->458426057],
Cell[17536, 654, 216, 6, 36, "Output",
 CellID->59101300]
}, Open  ]],
Cell[17767, 663, 121, 3, 70, "ExampleDelimiter",
 CellID->12075],
Cell[17891, 668, 61, 1, 70, "ExampleText",
 CellID->3266],
Cell[CellGroupData[{
Cell[17977, 673, 126, 4, 70, "Input",
 CellID->16729],
Cell[18106, 679, 268, 7, 36, "Output",
 CellID->18482]
}, Open  ]],
Cell[18389, 689, 125, 3, 70, "ExampleDelimiter",
 CellID->360293750],
Cell[18517, 694, 252, 8, 70, "ExampleText",
 CellID->374862793],
Cell[18772, 704, 298, 10, 70, "Input",
 CellID->328515039],
Cell[CellGroupData[{
Cell[19095, 718, 104, 3, 70, "Input",
 CellID->455279925],
Cell[19202, 723, 161, 5, 36, "Output",
 CellID->381217043]
}, Open  ]],
Cell[19378, 731, 264, 8, 70, "ExampleText",
 CellID->404146082],
Cell[CellGroupData[{
Cell[19667, 743, 97, 3, 70, "Input",
 CellID->590679954],
Cell[19767, 748, 175, 5, 36, "Output",
 CellID->252103719]
}, Open  ]],
Cell[CellGroupData[{
Cell[19979, 758, 121, 4, 70, "Input",
 CellID->567233550],
Cell[20103, 764, 223, 6, 36, "Output",
 CellID->56172177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20375, 776, 240, 7, 70, "ExampleSubsection",
 CellID->136221808],
Cell[20618, 785, 88, 1, 70, "ExampleText",
 CellID->403717263],
Cell[20709, 788, 429, 15, 70, "Input",
 CellID->206266736],
Cell[CellGroupData[{
Cell[21163, 807, 97, 3, 70, "Input",
 CellID->356929403],
Cell[21263, 812, 397, 13, 36, "Output",
 CellID->164898]
}, Open  ]],
Cell[21675, 828, 125, 3, 70, "ExampleDelimiter",
 CellID->136693263],
Cell[21803, 833, 115, 3, 70, "ExampleText",
 CellID->204092144],
Cell[CellGroupData[{
Cell[21943, 840, 275, 10, 70, "Input",
 CellID->715599762],
Cell[22221, 852, 369, 10, 52, "Output",
 CellID->384945641]
}, Open  ]],
Cell[22605, 865, 124, 3, 70, "ExampleDelimiter",
 CellID->12681980],
Cell[22732, 870, 89, 1, 70, "ExampleText",
 CellID->2881526],
Cell[CellGroupData[{
Cell[22846, 875, 294, 10, 70, "Input",
 CellID->27022051],
Cell[23143, 887, 753, 24, 54, "Output",
 CellID->296439037]
}, Open  ]],
Cell[CellGroupData[{
Cell[23933, 916, 100, 3, 70, "Input",
 CellID->401946374],
Cell[24036, 921, 782, 24, 54, "Output",
 CellID->646317973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24867, 951, 250, 7, 70, "ExampleSubsection",
 CellID->51147739],
Cell[25120, 960, 300, 10, 70, "ExampleText",
 CellID->412714797],
Cell[CellGroupData[{
Cell[25445, 974, 425, 15, 70, "Input",
 CellID->955455176],
Cell[25873, 991, 418, 15, 52, "Output",
 CellID->261139128]
}, Open  ]],
Cell[CellGroupData[{
Cell[26328, 1011, 171, 6, 70, "Input",
 CellID->479035102],
Cell[26502, 1019, 181, 5, 36, "Output",
 CellID->471414578]
}, Open  ]],
Cell[26698, 1027, 103, 2, 70, "ExampleText",
 CellID->574141463],
Cell[CellGroupData[{
Cell[26826, 1033, 141, 5, 70, "Input",
 CellID->19967784],
Cell[26970, 1040, 181, 5, 36, "Output",
 CellID->951646967]
}, Open  ]],
Cell[27166, 1048, 148, 4, 70, "ExampleText",
 CellID->657364638],
Cell[CellGroupData[{
Cell[27339, 1056, 483, 16, 70, "Input",
 CellID->676729120],
Cell[27825, 1074, 1335, 26, 70, "Output",
 Evaluatable->False,
 CellID->786544531]
}, Open  ]],
Cell[29175, 1103, 125, 3, 70, "ExampleDelimiter",
 CellID->622424864],
Cell[29303, 1108, 528, 19, 70, "ExampleText",
 CellID->150478225],
Cell[29834, 1129, 455, 16, 70, "Input",
 CellID->357639806],
Cell[CellGroupData[{
Cell[30314, 1149, 196, 7, 70, "Input",
 CellID->2823616],
Cell[30513, 1158, 201, 5, 36, "Output",
 CellID->465527033]
}, Open  ]],
Cell[30729, 1166, 137, 4, 70, "ExampleText",
 CellID->70287448],
Cell[CellGroupData[{
Cell[30891, 1174, 928, 31, 70, "Input",
 CellID->63027162],
Cell[31822, 1207, 2570, 46, 70, "Output",
 Evaluatable->False,
 CellID->29643640]
}, Open  ]],
Cell[34407, 1256, 125, 3, 70, "ExampleDelimiter",
 CellID->849949596],
Cell[34535, 1261, 276, 8, 70, "ExampleText",
 CellID->214898180],
Cell[CellGroupData[{
Cell[34836, 1273, 263, 9, 70, "Input",
 CellID->73161945],
Cell[35102, 1284, 271, 6, 70, "Message",
 CellID->59978455],
Cell[35376, 1292, 175, 5, 36, "Output",
 CellID->3445590]
}, Open  ]],
Cell[35566, 1300, 281, 8, 70, "ExampleText",
 CellID->591278822],
Cell[CellGroupData[{
Cell[35872, 1312, 402, 14, 70, "Input",
 CellID->62554901],
Cell[36277, 1328, 206, 5, 36, "Output",
 CellID->32362812]
}, Open  ]],
Cell[36498, 1336, 125, 3, 70, "ExampleDelimiter",
 CellID->570568123],
Cell[36626, 1341, 229, 7, 70, "ExampleText",
 CellID->549355668],
Cell[CellGroupData[{
Cell[36880, 1352, 199, 7, 70, "Input",
 CellID->18050051],
Cell[37082, 1361, 293, 9, 36, "Output",
 CellID->3253054]
}, Open  ]],
Cell[CellGroupData[{
Cell[37412, 1375, 120, 4, 70, "Input",
 CellID->77494800],
Cell[37535, 1381, 295, 9, 36, "Output",
 CellID->352785658]
}, Open  ]],
Cell[37845, 1393, 112, 3, 70, "ExampleText",
 CellID->511038408],
Cell[CellGroupData[{
Cell[37982, 1400, 189, 6, 70, "Input",
 CellID->790930514],
Cell[38174, 1408, 228, 7, 36, "Output",
 CellID->48886537]
}, Open  ]],
Cell[38417, 1418, 249, 8, 70, "ExampleText",
 CellID->78792451],
Cell[CellGroupData[{
Cell[38691, 1430, 132, 4, 70, "Input",
 CellID->140845274],
Cell[38826, 1436, 277, 9, 36, "Output",
 CellID->133083394]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39152, 1451, 250, 7, 70, "ExampleSubsection",
 CellID->14079251],
Cell[39405, 1460, 200, 7, 70, "ExampleText",
 CellID->55689949],
Cell[CellGroupData[{
Cell[39630, 1471, 169, 6, 70, "Input",
 CellID->516243537],
Cell[39802, 1479, 204, 7, 36, "Output",
 CellID->178537943]
}, Open  ]],
Cell[40021, 1489, 63, 1, 70, "ExampleText",
 CellID->37913914],
Cell[CellGroupData[{
Cell[40109, 1494, 121, 4, 70, "Input",
 CellID->126915185],
Cell[40233, 1500, 198, 6, 36, "Output",
 CellID->188455076]
}, Open  ]],
Cell[40446, 1509, 218, 8, 70, "ExampleText",
 CellID->237422699],
Cell[CellGroupData[{
Cell[40689, 1521, 168, 6, 70, "Input",
 CellID->6055822],
Cell[40860, 1529, 259, 7, 36, "Output",
 CellID->852597595]
}, Open  ]],
Cell[CellGroupData[{
Cell[41156, 1541, 126, 4, 70, "Input",
 CellID->6809765],
Cell[41285, 1547, 162, 5, 36, "Output",
 CellID->386434545]
}, Open  ]],
Cell[41462, 1555, 125, 3, 70, "ExampleDelimiter",
 CellID->217999918],
Cell[41590, 1560, 235, 7, 70, "ExampleText",
 CellID->206072393],
Cell[CellGroupData[{
Cell[41850, 1571, 575, 19, 70, "Input",
 CellID->355104775],
Cell[42428, 1592, 479, 17, 36, "Output",
 CellID->1385976]
}, Open  ]],
Cell[CellGroupData[{
Cell[42944, 1614, 121, 4, 70, "Input",
 CellID->387321601],
Cell[43068, 1620, 479, 17, 36, "Output",
 CellID->9001611]
}, Open  ]],
Cell[CellGroupData[{
Cell[43584, 1642, 191, 6, 70, "Input",
 CellID->38595705],
Cell[43778, 1650, 1802, 34, 70, "Output",
 Evaluatable->False,
 CellID->103835440]
}, Open  ]],
Cell[45595, 1687, 562, 22, 70, "ExampleText",
 CellID->68976332],
Cell[CellGroupData[{
Cell[46182, 1713, 218, 7, 70, "Input",
 CellID->153161057],
Cell[46403, 1722, 161, 5, 36, "Output",
 CellID->294177665]
}, Open  ]],
Cell[46579, 1730, 125, 3, 70, "ExampleDelimiter",
 CellID->284986845],
Cell[46707, 1735, 279, 8, 70, "ExampleText",
 CellID->82894215],
Cell[CellGroupData[{
Cell[47011, 1747, 312, 10, 70, "Input",
 CellID->288246807],
Cell[47326, 1759, 356, 13, 36, "Output",
 CellID->875236344]
}, Open  ]],
Cell[CellGroupData[{
Cell[47719, 1777, 126, 4, 70, "Input",
 CellID->85031311],
Cell[47848, 1783, 358, 13, 36, "Output",
 CellID->2633014]
}, Open  ]],
Cell[48221, 1799, 142, 4, 70, "ExampleText",
 CellID->327638190],
Cell[CellGroupData[{
Cell[48388, 1807, 230, 8, 70, "Input",
 CellID->550915478],
Cell[48621, 1817, 230, 8, 51, "Output",
 CellID->341398111]
}, Open  ]],
Cell[48866, 1828, 125, 3, 70, "ExampleDelimiter",
 CellID->413134602],
Cell[48994, 1833, 361, 13, 70, "ExampleText",
 CellID->378348176],
Cell[CellGroupData[{
Cell[49380, 1850, 336, 11, 70, "Input",
 CellID->817605804],
Cell[49719, 1863, 390, 13, 51, "Output",
 CellID->788378732]
}, Open  ]],
Cell[CellGroupData[{
Cell[50146, 1881, 99, 3, 70, "Input",
 CellID->422557117],
Cell[50248, 1886, 176, 5, 36, "Output",
 CellID->360467437]
}, Open  ]],
Cell[50439, 1894, 201, 8, 70, "ExampleText",
 CellID->154280397],
Cell[CellGroupData[{
Cell[50665, 1906, 300, 10, 70, "Input",
 CellID->350283515],
Cell[50968, 1918, 176, 5, 36, "Output",
 CellID->376332021]
}, Open  ]],
Cell[51159, 1926, 146, 4, 70, "ExampleText",
 CellID->312553239],
Cell[CellGroupData[{
Cell[51330, 1934, 157, 5, 70, "Input",
 CellID->248102784],
Cell[51490, 1941, 670, 12, 70, "Message",
 CellID->3381671],
Cell[52163, 1955, 283, 10, 36, "Output",
 CellID->61326540]
}, Open  ]],
Cell[52461, 1968, 228, 8, 70, "ExampleText",
 CellID->70666283],
Cell[CellGroupData[{
Cell[52714, 1980, 407, 12, 70, "Input",
 CellID->33235622],
Cell[53124, 1994, 213, 6, 36, "Output",
 CellID->100123529]
}, Open  ]],
Cell[53352, 2003, 124, 3, 70, "ExampleDelimiter",
 CellID->14343995],
Cell[53479, 2008, 342, 13, 70, "ExampleText",
 CellID->432446993],
Cell[53824, 2023, 134, 5, 70, "Input",
 CellID->614080742],
Cell[CellGroupData[{
Cell[53983, 2032, 97, 3, 70, "Input",
 CellID->340390005],
Cell[54083, 2037, 227, 7, 36, "Output",
 CellID->66637690]
}, Open  ]],
Cell[54325, 2047, 282, 11, 70, "ExampleText",
 CellID->49283010],
Cell[CellGroupData[{
Cell[54632, 2062, 103, 3, 70, "Input",
 CellID->99716290],
Cell[54738, 2067, 431, 16, 50, "Output",
 CellID->17349804]
}, Open  ]],
Cell[55184, 2086, 180, 6, 70, "ExampleText",
 CellID->66849232],
Cell[CellGroupData[{
Cell[55389, 2096, 131, 4, 70, "Input",
 CellID->71468965],
Cell[55523, 2102, 436, 16, 50, "Output",
 CellID->245862364]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56008, 2124, 242, 7, 70, "ExampleSubsection",
 CellID->90647492],
Cell[56253, 2133, 364, 13, 70, "ExampleText",
 CellID->47988867],
Cell[56620, 2148, 139, 4, 70, "Input",
 CellID->161832880],
Cell[56762, 2154, 210, 8, 70, "ExampleText",
 CellID->298940183],
Cell[CellGroupData[{
Cell[56997, 2166, 361, 11, 70, "Input",
 CellID->52899033],
Cell[57361, 2179, 423, 13, 36, "Output",
 CellID->9485289]
}, Open  ]],
Cell[57799, 2195, 207, 8, 70, "ExampleText",
 CellID->377351155],
Cell[CellGroupData[{
Cell[58031, 2207, 357, 11, 70, "Input",
 CellID->185534140],
Cell[58391, 2220, 433, 13, 36, "Output",
 CellID->406931705]
}, Open  ]],
Cell[58839, 2236, 125, 3, 70, "ExampleDelimiter",
 CellID->373804042],
Cell[58967, 2241, 164, 6, 70, "ExampleText",
 CellID->136880050],
Cell[59134, 2249, 175, 6, 70, "Input",
 CellID->33869410],
Cell[59312, 2257, 114, 3, 70, "ExampleText",
 CellID->432947579],
Cell[CellGroupData[{
Cell[59451, 2264, 99, 3, 70, "Input",
 CellID->8899671],
Cell[59553, 2269, 189, 6, 36, "Output",
 CellID->667644899]
}, Open  ]],
Cell[59757, 2278, 182, 8, 70, "ExampleText",
 CellID->123529721],
Cell[CellGroupData[{
Cell[59964, 2290, 97, 3, 70, "Input",
 CellID->325219151],
Cell[60064, 2295, 160, 5, 36, "Output",
 CellID->318809735]
}, Open  ]],
Cell[60239, 2303, 120, 3, 70, "ExampleText",
 CellID->345064080],
Cell[60362, 2308, 227, 8, 70, "Input",
 CellID->13271379],
Cell[60592, 2318, 92, 1, 70, "ExampleText",
 CellID->122628886],
Cell[CellGroupData[{
Cell[60709, 2323, 235, 8, 70, "Input",
 CellID->215728166],
Cell[60947, 2333, 162, 5, 36, "Output",
 CellID->24607381]
}, Open  ]],
Cell[61124, 2341, 124, 3, 70, "ExampleDelimiter",
 CellID->14097626],
Cell[61251, 2346, 407, 14, 70, "ExampleText",
 CellID->80110771],
Cell[61661, 2362, 870, 28, 70, "Input",
 CellID->141147017],
Cell[62534, 2392, 248, 8, 70, "ExampleText",
 CellID->711531574],
Cell[62785, 2402, 150, 4, 70, "Input",
 CellID->22712307],
Cell[62938, 2408, 89, 1, 70, "ExampleText",
 CellID->377440979],
Cell[CellGroupData[{
Cell[63052, 2413, 152, 5, 70, "Input",
 CellID->608601075],
Cell[63207, 2420, 214, 7, 36, "Output",
 CellID->144652799]
}, Open  ]],
Cell[63436, 2430, 72, 1, 70, "ExampleText",
 CellID->158336978],
Cell[CellGroupData[{
Cell[63533, 2435, 97, 3, 70, "Input",
 CellID->7375132],
Cell[63633, 2440, 175, 5, 36, "Output",
 CellID->183447890]
}, Open  ]],
Cell[63823, 2448, 65, 1, 70, "ExampleText",
 CellID->14214760],
Cell[CellGroupData[{
Cell[63913, 2453, 121, 4, 70, "Input",
 CellID->8800314],
Cell[64037, 2459, 223, 6, 36, "Output",
 CellID->58761369]
}, Open  ]],
Cell[64275, 2468, 125, 3, 70, "ExampleDelimiter",
 CellID->512388404],
Cell[64403, 2473, 578, 23, 70, "ExampleText",
 CellID->265605447],
Cell[64984, 2498, 1773, 54, 70, "Input",
 CellID->36239431],
Cell[66760, 2554, 228, 8, 70, "ExampleText",
 CellID->4983566],
Cell[66991, 2564, 892, 27, 70, "Input",
 CellID->466916685],
Cell[67886, 2593, 247, 8, 70, "ExampleText",
 CellID->321595248],
Cell[68136, 2603, 143, 4, 70, "Input",
 CellID->326590932],
Cell[68282, 2609, 355, 13, 70, "ExampleText",
 CellID->179441],
Cell[CellGroupData[{
Cell[68662, 2626, 406, 14, 70, "Input",
 CellID->531716292],
Cell[69071, 2642, 461, 16, 36, "Output",
 CellID->296471903]
}, Open  ]],
Cell[CellGroupData[{
Cell[69569, 2663, 209, 7, 70, "Input",
 CellID->53225029],
Cell[69781, 2672, 689, 24, 39, "Output",
 CellID->658514383]
}, Open  ]],
Cell[70485, 2699, 102, 2, 70, "ExampleText",
 CellID->58650974],
Cell[CellGroupData[{
Cell[70612, 2705, 127, 4, 70, "Input",
 CellID->31671949],
Cell[70742, 2711, 469, 16, 36, "Output",
 CellID->250264132]
}, Open  ]],
Cell[71226, 2730, 166, 7, 70, "ExampleText",
 CellID->7806351],
Cell[CellGroupData[{
Cell[71417, 2741, 103, 3, 70, "Input",
 CellID->256179902],
Cell[71523, 2746, 175, 5, 36, "Output",
 CellID->371240457]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[71759, 2758, 239, 7, 70, "ExampleSection",
 CellID->24508],
Cell[72001, 2767, 73, 1, 70, "ExampleText",
 CellID->1802],
Cell[CellGroupData[{
Cell[72099, 2772, 198, 7, 70, "Input",
 CellID->12494],
Cell[72300, 2781, 200, 5, 36, "Output",
 CellID->276516668]
}, Open  ]],
Cell[72515, 2789, 121, 3, 70, "ExampleDelimiter",
 CellID->10506],
Cell[72639, 2794, 90, 1, 70, "ExampleText",
 CellID->698],
Cell[CellGroupData[{
Cell[72754, 2799, 198, 7, 70, "Input",
 CellID->27955],
Cell[72955, 2808, 200, 5, 36, "Output",
 CellID->826500735]
}, Open  ]],
Cell[73170, 2816, 124, 3, 70, "ExampleDelimiter",
 CellID->11965525],
Cell[73297, 2821, 94, 1, 70, "ExampleText",
 CellID->37049141],
Cell[CellGroupData[{
Cell[73416, 2826, 345, 12, 70, "Input",
 CellID->5180236],
Cell[73764, 2840, 161, 5, 36, "Output",
 CellID->9231606]
}, Open  ]],
Cell[CellGroupData[{
Cell[73962, 2850, 192, 6, 70, "Input",
 CellID->562823131],
Cell[74157, 2858, 208, 7, 36, "Output",
 CellID->341313318]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74414, 2871, 232, 7, 70, "ExampleSection",
 CellID->8303],
Cell[74649, 2880, 399, 15, 70, "ExampleText",
 CellID->165104771],
Cell[CellGroupData[{
Cell[75073, 2899, 161, 5, 70, "Input",
 CellID->282381158],
Cell[75237, 2906, 175, 5, 36, "Output",
 CellID->665560102]
}, Open  ]],
Cell[CellGroupData[{
Cell[75449, 2916, 105, 3, 70, "Input",
 CellID->516227460],
Cell[75557, 2921, 174, 5, 36, "Output",
 CellID->138218385]
}, Open  ]],
Cell[75746, 2929, 131, 4, 70, "ExampleText",
 CellID->137396772],
Cell[CellGroupData[{
Cell[75902, 2937, 155, 5, 70, "Input",
 CellID->245171242],
Cell[76060, 2944, 215, 6, 36, "Output",
 CellID->151971123]
}, Open  ]],
Cell[CellGroupData[{
Cell[76312, 2955, 105, 3, 70, "Input",
 CellID->126630726],
Cell[76420, 2960, 175, 5, 36, "Output",
 CellID->46470448]
}, Open  ]],
Cell[76610, 2968, 125, 3, 70, "ExampleDelimiter",
 CellID->463625235],
Cell[76738, 2973, 493, 20, 70, "ExampleText",
 CellID->361596147],
Cell[CellGroupData[{
Cell[77256, 2997, 187, 6, 70, "Input",
 CellID->242969861],
Cell[77446, 3005, 223, 6, 36, "Output",
 CellID->38446686]
}, Open  ]],
Cell[CellGroupData[{
Cell[77706, 3016, 104, 3, 70, "Input",
 CellID->20666979],
Cell[77813, 3021, 161, 5, 36, "Output",
 CellID->452151520]
}, Open  ]],
Cell[77989, 3029, 160, 6, 70, "ExampleText",
 CellID->136465322],
Cell[CellGroupData[{
Cell[78174, 3039, 263, 9, 70, "Input",
 CellID->43058856],
Cell[78440, 3050, 272, 6, 70, "Message",
 CellID->390245086],
Cell[78715, 3058, 176, 5, 36, "Output",
 CellID->26751330]
}, Open  ]],
Cell[78906, 3066, 249, 8, 70, "ExampleText",
 CellID->624211287],
Cell[CellGroupData[{
Cell[79180, 3078, 403, 14, 70, "Input",
 CellID->415632662],
Cell[79586, 3094, 205, 5, 36, "Output",
 CellID->3604701]
}, Open  ]],
Cell[CellGroupData[{
Cell[79828, 3104, 104, 3, 70, "Input",
 CellID->44631633],
Cell[79935, 3109, 161, 5, 36, "Output",
 CellID->151907238]
}, Open  ]],
Cell[80111, 3117, 141, 4, 70, "ExampleText",
 CellID->604106974],
Cell[CellGroupData[{
Cell[80277, 3125, 204, 7, 70, "Input",
 CellID->849445264],
Cell[80484, 3134, 261, 6, 70, "Message",
 CellID->38150862],
Cell[80748, 3142, 177, 5, 36, "Output",
 CellID->179733350]
}, Open  ]],
Cell[CellGroupData[{
Cell[80962, 3152, 259, 8, 70, "Input",
 CellID->991075506],
Cell[81224, 3162, 163, 5, 36, "Output",
 CellID->311841662]
}, Open  ]],
Cell[CellGroupData[{
Cell[81424, 3172, 104, 3, 70, "Input",
 CellID->492648595],
Cell[81531, 3177, 158, 5, 36, "Output",
 CellID->158828]
}, Open  ]],
Cell[81704, 3185, 125, 3, 70, "ExampleDelimiter",
 CellID->396446512],
Cell[81832, 3190, 573, 23, 70, "ExampleText",
 CellID->18083741],
Cell[CellGroupData[{
Cell[82430, 3217, 234, 8, 70, "Input",
 CellID->107168583],
Cell[82667, 3227, 227, 6, 36, "Output",
 CellID->27971435]
}, Open  ]],
Cell[CellGroupData[{
Cell[82931, 3238, 103, 3, 70, "Input",
 CellID->74611908],
Cell[83037, 3243, 193, 6, 36, "Output",
 CellID->153785728]
}, Open  ]],
Cell[83245, 3252, 159, 6, 70, "ExampleText",
 CellID->427390766],
Cell[CellGroupData[{
Cell[83429, 3262, 379, 12, 70, "Input",
 CellID->103677849],
Cell[83811, 3276, 345, 7, 70, "Message",
 CellID->59163702],
Cell[84159, 3285, 259, 7, 36, "Output",
 CellID->560390496]
}, Open  ]],
Cell[84433, 3295, 249, 8, 70, "ExampleText",
 CellID->491029925],
Cell[CellGroupData[{
Cell[84707, 3307, 527, 17, 70, "Input",
 CellID->328778357],
Cell[85237, 3326, 267, 7, 36, "Output",
 CellID->22946181]
}, Open  ]],
Cell[CellGroupData[{
Cell[85541, 3338, 104, 3, 70, "Input",
 CellID->768794186],
Cell[85648, 3343, 161, 5, 36, "Output",
 CellID->222484992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[85858, 3354, 224, 7, 70, "ExampleSection",
 CellID->25541],
Cell[86085, 3363, 140, 6, 70, "ExampleText",
 CellID->1067076],
Cell[CellGroupData[{
Cell[86250, 3373, 206, 7, 70, "Input",
 CellID->656666377],
Cell[86459, 3382, 102795, 1291, 1756, "Output",
 CellID->20166333]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[189315, 4680, 310, 9, 70, "SeeAlsoSection",
 CellID->8594],
Cell[189628, 4691, 1720, 62, 70, "SeeAlso",
 CellID->28227]
}, Open  ]],
Cell[CellGroupData[{
Cell[191385, 4758, 314, 9, 70, "TutorialsSection",
 CellID->31464],
Cell[191702, 4769, 193, 4, 70, "Tutorials",
 CellID->123709578],
Cell[191898, 4775, 166, 3, 70, "Tutorials",
 CellID->21501],
Cell[192067, 4780, 181, 3, 70, "Tutorials",
 CellID->15380],
Cell[192251, 4785, 148, 3, 70, "Tutorials",
 CellID->30585],
Cell[192402, 4790, 171, 3, 70, "Tutorials",
 CellID->16702],
Cell[192576, 4795, 163, 3, 70, "Tutorials",
 CellID->672156057]
}, Open  ]],
Cell[CellGroupData[{
Cell[192776, 4803, 321, 9, 70, "RelatedLinksSection",
 CellID->11073],
Cell[193100, 4814, 265, 6, 70, "RelatedLinks",
 CellID->9653]
}, Open  ]],
Cell[CellGroupData[{
Cell[193402, 4825, 318, 9, 70, "MoreAboutSection",
 CellID->56220687],
Cell[193723, 4836, 146, 3, 70, "MoreAbout",
 CellID->192282218],
Cell[193872, 4841, 174, 3, 70, "MoreAbout",
 CellID->68147849],
Cell[194049, 4846, 167, 3, 70, "MoreAbout",
 CellID->287356060]
}, Open  ]],
Cell[194231, 4852, 50, 0, 70, "History"],
Cell[194284, 4854, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

