(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35936,       1381]
NotebookOptionsPosition[     28384,       1115]
NotebookOutlinePosition[     29723,       1153]
CellTagsIndexPosition[     29637,       1148]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Controlling Numerical Evaluation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ControllingNumericalEvaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Controlling Numerical Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NHoldFirst" :> 
          Documentation`HelpLookup["paclet:ref/NHoldFirst"], "NHoldRest" :> 
          Documentation`HelpLookup["paclet:ref/NHoldRest"], "NumericFunction" :> 
          Documentation`HelpLookup["paclet:ref/NumericFunction"], "HoldAll" :> 
          Documentation`HelpLookup["paclet:ref/HoldAll"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NHoldFirst\"\>", 2->"\<\"NHoldRest\"\>", 
       3->"\<\"NumericFunction\"\>", 
       4->"\<\"HoldAll\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NHoldAll", "ObjectName",
 CellID->20117],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NHoldAll",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which specifies that none of the \
arguments to a function should be affected by ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NHoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldFirst"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NHoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldRest"]], "InlineFormula"],
 " are useful in ensuring that arguments to functions are maintained as exact \
integers, rather than being converted by ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to approximate numbers. "
}], "Notes",
 CellID->24868]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->250891343],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->386279504],

Cell[TextData[{
 "Prevent ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " from affecting the arguments of a function:"
}], "ExampleText",
 CellID->428078403],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "NHoldAll"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->355306178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"1", "+", "2"}], ",", 
    RowBox[{"3", "+", "Pi"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7447681],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"3", ",", 
   RowBox[{"3", "+", "\[Pi]"}]}], "]"}]], "Output",
 ImageSize->{71, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27500421]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13977],

Cell[TextData[{
 "System symbols with the ",
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->115115300],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ssymb", "=", 
   RowBox[{"Cases", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{"ToExpression", ",", 
       RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], "]"}], ",", 
     "_Symbol"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Select", "[", 
  RowBox[{"ssymb", ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Attributes", "[", "#", "]"}], ",", "NHoldAll"}], "]"}], 
    "&"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->20129150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "AlgebraicNumber", ",", "C", ",", "CompiledFunction", ",", "Derivative", 
   ",", "InverseFunction", ",", "RecurringDigitsForm", ",", "Root", ",", 
   "Slot", ",", "SlotSequence"}], "}"}]], "Output",
 ImageSize->{441, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165279354]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293482475],

Cell[TextData[{
 "The arguments of ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " remain unchanged with ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->560527844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"der", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"Derivative", "[", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0"}], "]"}], "[", "f", "]"}], "[",
    
   RowBox[{"1", ",", "2", ",", "3", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160136804],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"1", ",", "2", ",", "3", ",", "x"}], "]"}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->964977988]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " leaves the derivative order while changing the point of evaluation:"
}], "ExampleText",
 CellID->377555425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nder", "=", 
  RowBox[{"N", "[", "der", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->526018097],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", 
     RowBox[{"1", ",", "0", ",", "1", ",", "0"}], ")"}],
    Derivative],
   MultilineFunction->None], "[", 
  RowBox[{"1.`", ",", "2.`", ",", "3.`", ",", "x"}], "]"}]], "Output",
 ImageSize->{154, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390463780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nder", " ", "/.", " ", 
  RowBox[{"f", "\[Rule]", "Times"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->170793310],

Cell[BoxData[
 RowBox[{"2.`", " ", "x"}]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->80935392]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->185316391],

Cell["Define a pure function:", "ExampleText",
 CellID->424054921],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"#1", "^", "2"}], "+", 
     RowBox[{
      RowBox[{"Pi", "^", "3"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"#1", "^", "2"}], "-", "#2"}], ")"}], "^", "2"}]}]}], 
    "&"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107291278],

Cell["\<\
The function with coefficients converted to numerical values:\
\>", "ExampleText",
 CellID->568792911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"N", "[", "f", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149873597],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["#1", "2"], "+", 
   RowBox[{"31.006276680299816`", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["#1", "2"], "-", 
       RowBox[{"1.`", " ", "#2"}]}], ")"}], "2"]}]}], "&"}]], "Output",
 ImageSize->{182, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32134733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->708349275],

Cell[BoxData["32.00627668029982`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14144014]
}, Open  ]],

Cell[TextData[{
 "The positional parameters remain unchanged with ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " because ",
 Cell[BoxData[
  ButtonBox["Slot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slot"]], "InlineFormula"],
 " has the ",
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->285021637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "f", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->679617677],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Function", "[", 
    RowBox[{"Plus", "[", 
     RowBox[{
      RowBox[{"Power", "[", 
       RowBox[{
        RowBox[{"Slot", "[", "1", "]"}], ",", "2"}], "]"}], ",", 
      RowBox[{"Times", "[", 
       RowBox[{
        RowBox[{"Power", "[", 
         RowBox[{"Pi", ",", "3"}], "]"}], ",", 
        RowBox[{"Power", "[", 
         RowBox[{
          RowBox[{"Plus", "[", 
           RowBox[{
            RowBox[{"Power", "[", 
             RowBox[{
              RowBox[{"Slot", "[", "1", "]"}], ",", "2"}], "]"}], ",", 
            RowBox[{"Times", "[", 
             RowBox[{
              RowBox[{"-", "1"}], ",", 
              RowBox[{"Slot", "[", "2", "]"}]}], "]"}]}], "]"}], ",", "2"}], 
         "]"}]}], "]"}]}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{534, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->265117608]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2030],

Cell["Use an indexed variable: ", "ExampleText",
 CellID->814261207],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"x", ",", "NHoldAll"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51303760],

Cell["With this attribute, the variables remain unchanged: ", "ExampleText",
 CellID->65695561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"x", "[", "1", "]"}]}], "+", 
   RowBox[{"5", 
    SuperscriptBox[
     RowBox[{"x", "[", "2", "]"}], "2"]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69773346],

Cell[BoxData[
 RowBox[{
  RowBox[{"2.`", " ", 
   RowBox[{"x", "[", "1", "]"}]}], "+", 
  RowBox[{"5.`", " ", 
   SuperscriptBox[
    RowBox[{"x", "[", "2", "]"}], "2"]}]}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->76724803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512388404],

Cell[TextData[{
 "Define a data object that represents a polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["c", "1"], " ", 
      SuperscriptBox["x", 
       SubscriptBox["p", "1"]]}], "+"}], "..."}], TraditionalForm]], 
  "InlineMath"],
 " in a sparse form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["c", "1"], ",", 
       SubscriptBox["p", "1"]}], "}"}], ",", "..."}], "}"}], 
   TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->130620463],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"spoly", "[", "cp_", "]"}], "[", "x_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", " ", "n", ",", "p", ",", " ", "y"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "c"}], "}"}], "=", 
      RowBox[{"Transpose", "[", 
       RowBox[{"SortBy", "[", 
        RowBox[{"cp", ",", "Last"}], "]"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"n", "=", 
      RowBox[{"p", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"y", "=", 
      RowBox[{"c", "[", 
       RowBox[{"[", 
        RowBox[{"-", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "=", 
         RowBox[{
          RowBox[{"c", "[", 
           RowBox[{"[", "k", "]"}], "]"}], "+", 
          RowBox[{
           RowBox[{"x", "^", 
            RowBox[{"(", 
             RowBox[{"n", "-", 
              RowBox[{"p", "[", 
               RowBox[{"[", "k", "]"}], "]"}]}], ")"}]}], "*", "y"}]}]}], ";",
         
        RowBox[{"n", "=", 
         RowBox[{"p", "[", 
          RowBox[{"[", "k", "]"}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"k", ",", 
         RowBox[{
          RowBox[{"Length", "[", "p", "]"}], "-", "1"}], ",", "1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", ">", " ", "0"}], ",", 
       RowBox[{"y", "*=", 
        RowBox[{"x", "^", "n"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
     "y"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406470732],

Cell[TextData[{
 "Make sure that ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " only affects the coefficients, not the powers:"
}], "ExampleText",
 CellID->515707102],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"e", ":", 
     RowBox[{"spoly", "[", "cp_", "]"}]}], ",", "pa_"}], "]"}], ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"p", ",", "c", ",", "nc"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"c", ",", "p"}], "}"}], "=", 
      RowBox[{"Transpose", "[", "cp", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"nc", "=", 
      RowBox[{"N", "[", 
       RowBox[{"c", ",", "pa"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"nc", "===", "c"}], ",", "e", ",", 
       RowBox[{"spoly", "[", 
        RowBox[{"Transpose", "[", 
         RowBox[{"{", 
          RowBox[{"nc", ",", "p"}], "}"}], "]"}], "]"}]}], "]"}]}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21875759],

Cell[TextData[{
 "Default ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " evaluation of the argument needs to be prevented for the rule above to \
work:"
}], "ExampleText",
 CellID->206828400],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"spoly", ",", "NHoldAll"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->178331045],

Cell[TextData[{
 "A representation of the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", 
    RowBox[{"2", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "4"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "8"]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->15236113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"spoly", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->388384316],

Cell[BoxData[
 RowBox[{"spoly", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "8"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{258, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->296471903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"sp", "[", "x", "]"}], ",", 
   RowBox[{"Expand", "[", 
    RowBox[{"sp", "[", "x", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->64895344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"x", " ", 
          RowBox[{"(", 
           RowBox[{"4", "+", 
            RowBox[{"8", " ", "x"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
   RowBox[{"x", "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["x", "4"]}]}]}], "}"}]], "Output",
 ImageSize->{290, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->658514383]
}, Open  ]],

Cell["Get the representation with approximate real coefficients:", \
"ExampleText",
 CellID->70137105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsp", "=", " ", 
  RowBox[{"N", "[", "sp", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1600983],

Cell[BoxData[
 RowBox[{"spoly", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.`", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2.`", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3.`", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4.`", ",", "8"}], "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{286, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->250264132]
}, Open  ]],

Cell[TextData[{
 "Evaluate at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "\[Pi]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->23748143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nsp", "[", "\[Pi]", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->378697107],

Cell[BoxData["926.1786364489872`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->371240457]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 " prevents evaluation while ",
 Cell[BoxData[
  ButtonBox["NHoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NHoldAll"]], "InlineFormula"],
 " only prevents numerical evaluation:"
}], "ExampleText",
 CellID->293430125],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f1", ",", "HoldAll"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47837573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"Pi", "+", "E"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160953],

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"\[Pi]", "+", "\[ExponentialE]"}]}], "]"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22248489]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->123348454],

Cell[BoxData[
 RowBox[{"f1", "[", 
  RowBox[{
   RowBox[{"1.`", "\[InvisibleSpace]", "+", "2.`"}], ",", 
   RowBox[{
   "3.141592653589793`", "\[InvisibleSpace]", "+", "2.718281828459045`"}]}], 
  "]"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->557878009]
}, Open  ]],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f2", ",", "NHoldAll"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21768317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"Pi", "+", "E"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->137692413],

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"3", ",", 
   RowBox[{"\[ExponentialE]", "+", "\[Pi]"}]}], "]"}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->181355320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->195540706],

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"3", ",", 
   RowBox[{"\[ExponentialE]", "+", "\[Pi]"}]}], "]"}]], "Output",
 ImageSize->{78, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->266750171]
}, Open  ]],

Cell["You can prevent both by setting both attributes:", "ExampleText",
 CellID->200417411],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"HoldAll", ",", "NHoldAll"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->217759067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"Pi", "+", "E"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->152019579],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"\[Pi]", "+", "\[ExponentialE]"}]}], "]"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->235595211]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->41745134],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"1", "+", "2"}], ",", 
   RowBox[{"\[Pi]", "+", "\[ExponentialE]"}]}], "]"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->342775402]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21184],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldFirst",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldFirst"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NHoldRest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NHoldRest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumericFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumericFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAll"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17374],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->5692],

Cell[TextData[ButtonBox["Controlling Numerical Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ControllingNumericalEvaluation"]], "Tutorials",
 CellID->126352843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->18306117],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->555656768]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NHoldAll - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 5.9352784}", "context" -> "System`", 
    "keywords" -> {
     "numerical evaluation control", "suppressing numerical evaluation", 
      "index variables"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NHoldAll is an attribute which specifies that none of the arguments to a \
function should be affected by N. ", "synonyms" -> {"hold all"}, "title" -> 
    "NHoldAll", "type" -> "Symbol", "uri" -> "ref/NHoldAll"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4855, 154, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->250891343]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29494, 1141}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2337, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2960, 82, 46, 1, 70, "ObjectName",
 CellID->20117],
Cell[3009, 85, 612, 19, 70, "Usage",
 CellID->13790]
}, Open  ]],
Cell[CellGroupData[{
Cell[3658, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4136, 126, 682, 23, 70, "Notes",
 CellID->24868]
}, Closed]],
Cell[CellGroupData[{
Cell[4855, 154, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->250891343],
Cell[CellGroupData[{
Cell[5240, 168, 148, 5, 70, "ExampleSection",
 CellID->386279504],
Cell[5391, 175, 220, 8, 70, "ExampleText",
 CellID->428078403],
Cell[5614, 185, 139, 4, 70, "Input",
 CellID->355306178],
Cell[CellGroupData[{
Cell[5778, 193, 198, 7, 28, "Input",
 CellID->7447681],
Cell[5979, 202, 235, 8, 36, "Output",
 CellID->27500421]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6263, 216, 216, 7, 70, "ExampleSection",
 CellID->13977],
Cell[6482, 225, 217, 8, 70, "ExampleText",
 CellID->115115300],
Cell[CellGroupData[{
Cell[6724, 237, 512, 17, 70, "Input",
 CellID->20129150],
Cell[7239, 256, 372, 10, 54, "Output",
 CellID->165279354]
}, Open  ]],
Cell[7626, 269, 125, 3, 70, "ExampleDelimiter",
 CellID->293482475],
Cell[7754, 274, 337, 13, 70, "ExampleText",
 CellID->560527844],
Cell[CellGroupData[{
Cell[8116, 291, 284, 9, 70, "Input",
 CellID->160136804],
Cell[8403, 302, 380, 13, 36, "Output",
 CellID->964977988]
}, Open  ]],
Cell[8798, 318, 231, 7, 70, "ExampleText",
 CellID->377555425],
Cell[CellGroupData[{
Cell[9054, 329, 125, 4, 70, "Input",
 CellID->526018097],
Cell[9182, 335, 386, 13, 36, "Output",
 CellID->390463780]
}, Open  ]],
Cell[CellGroupData[{
Cell[9605, 353, 139, 4, 70, "Input",
 CellID->170793310],
Cell[9747, 359, 181, 6, 36, "Output",
 CellID->80935392]
}, Open  ]],
Cell[9943, 368, 125, 3, 70, "ExampleDelimiter",
 CellID->185316391],
Cell[10071, 373, 66, 1, 70, "ExampleText",
 CellID->424054921],
Cell[10140, 376, 351, 14, 70, "Input",
 CellID->107291278],
Cell[10494, 392, 112, 3, 70, "ExampleText",
 CellID->568792911],
Cell[CellGroupData[{
Cell[10631, 399, 121, 4, 70, "Input",
 CellID->149873597],
Cell[10755, 405, 406, 14, 41, "Output",
 CellID->32134733]
}, Open  ]],
Cell[CellGroupData[{
Cell[11198, 424, 121, 4, 70, "Input",
 CellID->708349275],
Cell[11322, 430, 174, 5, 36, "Output",
 CellID->14144014]
}, Open  ]],
Cell[11511, 438, 485, 18, 70, "ExampleText",
 CellID->285021637],
Cell[CellGroupData[{
Cell[12021, 460, 104, 3, 70, "Input",
 CellID->679617677],
Cell[12128, 465, 1036, 33, 68, "Output",
 CellID->265117608]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13213, 504, 222, 7, 70, "ExampleSection",
 CellID->2030],
Cell[13438, 513, 68, 1, 70, "ExampleText",
 CellID->814261207],
Cell[13509, 516, 138, 4, 70, "Input",
 CellID->51303760],
Cell[13650, 522, 95, 1, 70, "ExampleText",
 CellID->65695561],
Cell[CellGroupData[{
Cell[13770, 527, 244, 9, 70, "Input",
 CellID->69773346],
Cell[14017, 538, 314, 11, 36, "Output",
 CellID->76724803]
}, Open  ]],
Cell[14346, 552, 125, 3, 70, "ExampleDelimiter",
 CellID->512388404],
Cell[14474, 557, 578, 23, 70, "ExampleText",
 CellID->130620463],
Cell[15055, 582, 1774, 54, 70, "Input",
 CellID->406470732],
Cell[16832, 638, 230, 8, 70, "ExampleText",
 CellID->515707102],
Cell[17065, 648, 891, 27, 70, "Input",
 CellID->21875759],
Cell[17959, 677, 255, 9, 70, "ExampleText",
 CellID->206828400],
Cell[18217, 688, 143, 4, 70, "Input",
 CellID->178331045],
Cell[18363, 694, 357, 13, 70, "ExampleText",
 CellID->15236113],
Cell[CellGroupData[{
Cell[18745, 711, 406, 14, 70, "Input",
 CellID->388384316],
Cell[19154, 727, 461, 16, 36, "Output",
 CellID->296471903]
}, Open  ]],
Cell[CellGroupData[{
Cell[19652, 748, 209, 7, 70, "Input",
 CellID->64895344],
Cell[19864, 757, 689, 24, 39, "Output",
 CellID->658514383]
}, Open  ]],
Cell[20568, 784, 102, 2, 70, "ExampleText",
 CellID->70137105],
Cell[CellGroupData[{
Cell[20695, 790, 126, 4, 70, "Input",
 CellID->1600983],
Cell[20824, 796, 469, 16, 36, "Output",
 CellID->250264132]
}, Open  ]],
Cell[21308, 815, 167, 7, 70, "ExampleText",
 CellID->23748143],
Cell[CellGroupData[{
Cell[21500, 826, 103, 3, 70, "Input",
 CellID->378697107],
Cell[21606, 831, 175, 5, 36, "Output",
 CellID->371240457]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21830, 842, 233, 7, 70, "ExampleSection",
 CellID->18920],
Cell[22066, 851, 362, 12, 70, "ExampleText",
 CellID->293430125],
Cell[22431, 865, 138, 4, 70, "Input",
 CellID->47837573],
Cell[CellGroupData[{
Cell[22594, 873, 167, 6, 70, "Input",
 CellID->160953],
Cell[22764, 881, 274, 9, 36, "Output",
 CellID->22248489]
}, Open  ]],
Cell[CellGroupData[{
Cell[23075, 895, 97, 3, 70, "Input",
 CellID->123348454],
Cell[23175, 900, 345, 11, 36, "Output",
 CellID->557878009]
}, Open  ]],
Cell[23535, 914, 139, 4, 70, "Input",
 CellID->21768317],
Cell[CellGroupData[{
Cell[23699, 922, 170, 6, 70, "Input",
 CellID->137692413],
Cell[23872, 930, 251, 8, 36, "Output",
 CellID->181355320]
}, Open  ]],
Cell[CellGroupData[{
Cell[24160, 943, 97, 3, 70, "Input",
 CellID->195540706],
Cell[24260, 948, 251, 8, 36, "Output",
 CellID->266750171]
}, Open  ]],
Cell[24526, 959, 91, 1, 70, "ExampleText",
 CellID->200417411],
Cell[24620, 962, 194, 6, 70, "Input",
 CellID->217759067],
Cell[CellGroupData[{
Cell[24839, 972, 169, 6, 70, "Input",
 CellID->152019579],
Cell[25011, 980, 274, 9, 36, "Output",
 CellID->235595211]
}, Open  ]],
Cell[CellGroupData[{
Cell[25322, 994, 96, 3, 70, "Input",
 CellID->41745134],
Cell[25421, 999, 274, 9, 36, "Output",
 CellID->342775402]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25756, 1015, 311, 9, 70, "SeeAlsoSection",
 CellID->21184],
Cell[26070, 1026, 958, 35, 70, "SeeAlso",
 CellID->8848]
}, Open  ]],
Cell[CellGroupData[{
Cell[27065, 1066, 314, 9, 70, "TutorialsSection",
 CellID->17374],
Cell[27382, 1077, 130, 3, 70, "Tutorials",
 CellID->5692],
Cell[27515, 1082, 177, 3, 70, "Tutorials",
 CellID->126352843]
}, Open  ]],
Cell[CellGroupData[{
Cell[27729, 1090, 299, 8, 70, "MoreAboutSection"],
Cell[28031, 1100, 131, 3, 70, "MoreAbout",
 CellID->18306117],
Cell[28165, 1105, 147, 3, 70, "MoreAbout",
 CellID->555656768]
}, Open  ]],
Cell[28327, 1111, 27, 0, 70, "History"],
Cell[28357, 1113, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

