(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    848365,      15699]
NotebookOptionsPosition[    835590,      15264]
NotebookOutlinePosition[    837312,      15307]
CellTagsIndexPosition[    837224,      15302]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematics-BasicOperations"], 
          "Numerical Optimization" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalOptimization"], 
          "Constrained Optimization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConstrainedOptimizationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics: Basic Operations\"\>", 
       2->"\<\"Numerical Optimization\"\>", 
       3->"\<\"Constrained Optimization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NMaximize" :> Documentation`HelpLookup["paclet:ref/NMaximize"],
           "Minimize" :> Documentation`HelpLookup["paclet:ref/Minimize"], 
          "FindMinimum" :> Documentation`HelpLookup["paclet:ref/FindMinimum"],
           "FindFit" :> Documentation`HelpLookup["paclet:ref/FindFit"], 
          "LinearProgramming" :> 
          Documentation`HelpLookup["paclet:ref/LinearProgramming"], 
          "LeastSquares" :> 
          Documentation`HelpLookup["paclet:ref/LeastSquares"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NMaximize\"\>", 
       2->"\<\"Minimize\"\>", 3->"\<\"FindMinimum\"\>", 4->"\<\"FindFit\"\>", 
       5->"\<\"LinearProgramming\"\>", 
       6->"\<\"LeastSquares\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], "Optimization" :> 
          Documentation`HelpLookup["paclet:guide/Optimization"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Assumptions and Domains\"\>",
        2->"\<\"Calculus\"\>", 3->"\<\"Numerical Evaluation & Precision\"\>", 
       4->"\<\"Optimization\"\>", 
       5->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NMinimize", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NMinimize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NMinimize"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " numerically with respect to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NMinimize",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NMinimize"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["f", "TI"], ",", 
          StyleBox["cons", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]minimizes ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " numerically subject to the constraints ",
     Cell[BoxData[
      StyleBox["cons", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->28454]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " returns a list of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["min", "TI"]], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "->", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["min", "TI"]]}], ",", 
      RowBox[{
       StyleBox["y", "TI"], "->", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["min", "TI"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3992],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " can contain equations, inequalities or logical combinations of these. "
}], "Notes",
 CellID->27602],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " always attempts to find a global minimum of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " subject to the constraints given. "
}], "Notes",
 CellID->32226],

Cell["By default, all variables are assumed to be real. ", "Notes",
 CellID->25045],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[Element]", 
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"]}]], "InlineFormula"],
 " can be used to specify that a variable can take on only integer values. "
}], "Notes",
 CellID->21374],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["cons", "TI"]], "InlineFormula"],
 " are linear, ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " can always find global minima, over both real and integer values."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->14292637],

Cell[TextData[{
 "Otherwise, ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " may sometimes find only a local minimum. "
}], "Notes",
 CellID->29994],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " determines that the constraints cannot be satisfied, it returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], "->", 
       ButtonBox["Indeterminate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Indeterminate"]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2548],

Cell["The following options can be given: ", "Notes",
 CellID->27883],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of digits of final accuracy sought ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EvaluationMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EvaluationMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "expression to evaluate whenever ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is evaluated "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "100", Cell[
    "maximum number of iterations to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrecisionGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PrecisionGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "number of digits of final precision sought ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["StepMonitor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StepMonitor"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "expression to evaluate whenever a step is taken ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->30444],

Cell[TextData[{
 "The default settings for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "/", "2"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->11881],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " specify the number of digits to seek in both the value of the position of \
the maximum, and the value of the function at the minimum. "
}], "Notes",
 CellID->31975],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " continues until either of the goals specified by ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " is achieved. "
}], "Notes",
 CellID->4670],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " option include ",
 Cell[BoxData["\"\<NelderMead\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DifferentialEvolution\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<SimulatedAnnealing\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<RandomSearch\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4261523],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->213397682],

Cell["Find the global minimum of an unconstrained problem:", "ExampleText",
 CellID->1917251726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", 
    RowBox[{"3", 
     RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1746774899],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.0702301817761544`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.130901122470168`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27842243]
}, Open  ]],

Cell["Extract the minimizing argument:", "ExampleText",
 CellID->1664023518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/.", 
  RowBox[{"Last", "[", 
   RowBox[{"NMinimize", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "-", 
      RowBox[{"3", 
       RowBox[{"x", "^", "2"}]}], "+", "x"}], ",", "x"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1557760567],

Cell[BoxData["1.130901122470168`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->542254139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1112598013],

Cell["Find the global minimum of problems with constraints:", "ExampleText",
 CellID->1719552892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->886900649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "9.000000008381903`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "6.55605118140317`*^-12"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2.000000001396984`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{234, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143721150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"E", "^", 
       RowBox[{"(", 
        RowBox[{"Sin", "[", 
         RowBox[{"50", " ", "x"}], "]"}], ")"}]}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"60", " ", 
        RowBox[{"E", "^", "y"}]}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"70", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], "]"}], "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"80", " ", "y"}], "]"}], "]"}], "-", 
      RowBox[{"Sin", "[", 
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"x", "+", "y"}], ")"}]}], "]"}], "+", 
      RowBox[{
       RowBox[{"1", "/", "4"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1759366686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.306868647475239`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.024403079611618198`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.21061242724960783`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45162468]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " constraints can be specified:"
}], "ExampleText",
 CellID->1077996427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "||", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "+", "2"}], ")"}], "^", "2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"y", "+", "2"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
        "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1881132418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.414213569823204`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "2.7071067894726037`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2.7071067803506`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253276688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145340294],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " for linear objectives and constraints:"
}], "ExampleText",
 CellID->1627702079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"3", "x"}], "+", 
        RowBox[{"2", "y"}]}], "\[GreaterEqual]", "7"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], "\[GreaterEqual]", "6"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555314442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.25`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.5000000000000001`"}], ",", 
     RowBox[{"y", "\[Rule]", "2.75`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131287448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592370280],

Cell["Integer constraints can be imposed:", "ExampleText",
 CellID->1554484569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"3", "x"}], "+", 
        RowBox[{"2", "y"}]}], "\[GreaterEqual]", "7"}], "&&", 
      RowBox[{
       RowBox[{"x", "+", 
        RowBox[{"2", "y"}]}], "\[GreaterEqual]", "6"}], "&&", 
      RowBox[{"x", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{"y", "\[GreaterEqual]", "0"}], "&&", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "\[Element]", "Integers"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1605455941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "2"}], ",", 
     RowBox[{"y", "\[Rule]", "2"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111692357]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", 
         RowBox[{"1", "/", "3"}]}], ")"}], "^", "2"}]}], ",", 
     RowBox[{"x", "\[Element]", "Integers"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1044023529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1111111111111111`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0.3333333333333333`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->271323027]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->453790855],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AccuracyGoal & PrecisionGoal",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->61701773],

Cell[TextData[{
 "This enforces a convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", " ", 
    RowBox[{"\[LessEqual]", " ", 
     RowBox[{"max", "(", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "9"}]], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]], "||", 
        SubscriptBox["x", "k"], "||"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]f", "(", 
     SubscriptBox["x", "k"], ")"}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "9"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->764461149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "/", "2"}], "]"}], ",", "x", ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "9"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "8"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1625295724],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "3.141592653589793`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96017384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1055000278],

Cell[TextData[{
 "This enforces a convergence criteria ",
 Cell[BoxData[
  FormBox[
   RowBox[{"||", 
    RowBox[{
     SubscriptBox["x", "k"], "-", 
     SuperscriptBox["x", "*"]}], "||", " ", 
    RowBox[{"\[LessEqual]", " ", 
     RowBox[{"max", "(", 
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "20"}]], ",", 
       RowBox[{
        SuperscriptBox["10", 
         RowBox[{"-", "18"}]], "||", 
        SubscriptBox["x", "k"], "||"}]}], ")"}]}]}], TraditionalForm]], 
  "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[EmptyDownTriangle]f", "(", 
     SubscriptBox["x", "k"], ")"}], "\[LessEqual]", 
    SuperscriptBox["10", 
     RowBox[{"-", "20"}]]}], TraditionalForm]], "InlineMath"],
 ", which is not achievable with the default machine-precision computation:"
}], "ExampleText",
 CellID->1329553122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "/", "2"}], "]"}], ",", "x", ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "20"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "18"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1468387723],

Cell[BoxData[
 RowBox[{
  RowBox[{"NMinimize", "::", "\<\"cvmit\"\>"}], ":", 
  " ", "\<\"Failed to converge to the requested accuracy or precision within \
\\!\\(100\\) iterations.\"\>"}]], "Message", "MSG",
 CellID->200770448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "3.1415926607337976`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295424970]
}, Open  ]],

Cell[TextData[{
 "Setting a high ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " makes the process convergent:"
}], "ExampleText",
 CellID->1199314865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "/", "2"}], "]"}], ",", "x", ",", 
   RowBox[{"AccuracyGoal", "\[Rule]", "20"}], ",", 
   RowBox[{"PrecisionGoal", "\[Rule]", "18"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "40"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->39134653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.`40."}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "-", "3.1415926535897932384626433832795034721592982030009607408362`40."}]\
}], "}"}]}], "}"}]], "Output",
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36602932]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EvaluationMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->405919056],

Cell["\<\
Record all the points evaluated during the solution process of a function \
with a ring of minima:\
\>", "ExampleText",
 CellID->1914018609],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", " ", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "-", "16"}], ")"}], "^", "2"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"sol", ",", " ", "pts"}], "}"}], "=", 
   RowBox[{"Reap", "[", "\[IndentingNewLine]", 
    RowBox[{"NMinimize", "[", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"y", ",", 
          RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "}"}], ",", "  ", 
      RowBox[{"Method", "->", "\"\<DifferentialEvolution\>\""}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->157454682],

Cell["\<\
Plot all the visited points that are close in objective function value to the \
final solution:\
\>", "ExampleText",
 CellID->738842830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{".6", 
        RowBox[{"(", 
         RowBox[{"1", "-", "#1"}], ")"}]}], "]"}], "&"}], ")"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Epilog", "->", 
    RowBox[{"Map", "[", 
     RowBox[{"Point", ",", 
      RowBox[{"Cases", "[", 
       RowBox[{
        RowBox[{"First", "[", "pts", "]"}], ",", 
        RowBox[{"x_", "/;", 
         RowBox[{
          RowBox[{"Abs", "[", 
           RowBox[{
            RowBox[{"f", "@@", "x"}], "-", 
            RowBox[{"First", "[", "sol", "]"}]}], "]"}], "\[LessEqual]", 
          ".05"}]}]}], "]"}]}], "]"}]}], ",", " ", 
   RowBox[{"Contours", "\[Rule]", 
    RowBox[{"4", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{"0", ",", "10"}], "]"}], "^", "2"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->629793524],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyc3VvIptm2H/TvUPWdz1WgsEBQSyNe6U3dWFIvCJI2gtAgXvSVYQueyqjI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   "], {{{}, 
     {Hue[0.5972809298637413], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXd8VVX29i8JIUAgpNAhPSHhQshNgNCCMYUbpIOKvTe6DWfsBREbNhR7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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3d8lUXWxx8ISYBACAkQWkggoV1S7g1JKAlC2r1KL1IEBEWRIogF3RUF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         "],
         VertexColors->None]}]}, 
     {Hue[0.5864046493187062], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxMnXd4VcXWxg+EHghJCAkEUkglBxISCAklEHKSnFBEQCx0FQQRBEUBRekK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnXd81UXTxS8kEDohlFASAqHm5qZBSIAEQm6SG0A6KB0FpBcVREXpCChN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         "],
         VertexColors->None]}]}, 
     {Hue[0.564652088228636], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXWYlVXXxg8oQ9cww/Qw1MAwM+SZ7jNpK68iIYKEviYgGKhYqICBLSgG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnHWclsXXxu9VQRp2l1w6BJdddmHZYLt3AYuQTkkbkEYJQQVESQkBAxCk
BBQQpEMQKVEQxSCkDCwUBQPf7/W73j/O57nnmZkz55w5M/fMibt2rwFtHr8l
CILYIkFwG79P5wXBK42CoHSxIJhcKQiuU74B7KscBAuKB8HY/CAYA5y9PQgS
awdBn9ggaJcYBL1KBkFhCeppOwa4lf5/0P+t5CBYA3xdPghq0OevqCCIjA+C
tdTfXjQIdkUHQdm0IPipbBD8R3l3DP3Sg6BylSC4VisIehcyBjCuWhC8Af7r
OUGwumEQHIgIgowaQdA3Kwj6AfdUDYJ/6V+J/kcZ/zn6TgK+5TmF/3bTfjHl
rIIgyAZ6Vg+C87RPaRwEefDzPPV3wcO5XHgDNlH3TcUgGN40CEYAW6hrFBIE
34MvFXzrkMcS8GVC+23NwVEvCE7A45+RQbACfj/juTeCPQy9R4Anw6APHAOQ
1xcZQXBHaBDcDz/TKZfKRAaMPw153gtvObQfDn0db0XutD0AfI48MmnflvHb
AKuR5Trk+x+0pFHfm/oo+r8JP7vhb3qZIChXCnk1CYIdyG9F3SBYCRyHtxPA
QuT5FfS9B++bgb7gXsd/p6BnZRyyov8n4OvPWEPQh88Z70h4EJSkbflsFIW2
h+D/QeqHQfM6eAulPIWx/2ZOXyoHr3WC4B3GfhtYUjoIFjFHudT1ZP4vIt9O
wCjo7ZcQBGHI4zHatwZfB8Z7k/F2VIBPxpvPeK8y3gjoOYL+XGI+ctGfo+js
BvD9m4qOQP/P4FvPWI2A4vC6ENhG/63AHvBNov9v4G+OzGpCy1rojaV/IfTc
Rd904Dx1D9B+AfS8gr73pX0f4Bj9jyHvOOamKdCb+WkHzw2Rbzv0Lwt8AeP1
pf+qdK+VksC3lKswP4XMT22ND22HmgVBGfTjKPg6g6sL8BL4ZoCvE/UdgW/p
2x2e/4SWP4Br8PoT5fE8Pw28T//R4JwN7auRz9vUnUU/T4B7NuOtpq4ybSIY
/2v06yT69Q4y+42+V4EY8O+lvjr050B/U+j/CfkXMH9fM/8Xmf+6lPfRP4v2
k5HHYPrMAf9cYAXyuAV5XWE+KsZ77V2Hxtvpm5bE+kHf1yOPL8F3mDk+zfhr
wFcN3kbSZhT4/6V8SPXAQerboo+9kPV+6N1CuRTzMwH6BtCnFbjaAHOgZTaw
qLx5rIasawAFrMeu8FeVtnfQ5xS6fyc010Of6yd6bf8I/UvBvwzoQfszyOsI
z+XhcS7lZxlvFXOxEjijuaB/d8bqAWQz1gqm+EHW9xDkPRh5d6V/V/r3RF83
II/F0DSI8QcCDUqY5umMPQN4lP1tEPJZxF5RKwVdQ7ffgcdZ9L2OPNPpG8v4
d9B3NPIZjXxuo/8y6t4ELoA/FBmHwM9U5PMMfd+Fn0Os5cPA5fLW4eXQvgJ4
DPmfhocXof0F4DxtJ8HDg+j7mlTvRZNon0TbRKAj5YfQwVPw9gVwBf6OwsMa
6tYCP1F3ljaf8XwSqMreWw2YB20PZFgXz7E/jGSuP4f+U9D/KPN7A/24E/34
mLGKAsV5LgE8DD1fI8+u8NsF+Ji9LgN+FyDfR6hPZP9IgqcHkc8S6HkTeooj
n1Pw+rn4RVeW8V8q8pjD+G8xflfW1wfI5jQyXlvdOjQfWhcA/ZDHQej/lOdp
4L8X/FWgfzL0PkX78Xe4TyjyeRD5rETe1aH3BLRVhp8I+NnJGmmHrixA3/aj
LxuhpyLj92b8jejKcXi6jO7fwv5fCO03wF+UutuBKOg7Bb4+8NIXaEb/lujP
3dB7D/Ax7SfS/y3eJ+uAz9gbPoWGVOjpAr1n6XsfMAR9e5n99k94uUP7LfIZ
nmdZXaP9Q9D7MDCjmnVwKm3/YH+dGeo5jKFtw0Z+t++viVx5/pLxboWeLPAt
QlcWA48iy2PgTGD8+xi/FWMXAlngbs366oosqjNf8cgzQfIFdwdo2s7cTAHf
O+DPAX8e7fOBBOj5Bv5WIOuPU/1u1Tv8a9o/yxgrwd2L9jfA3R8ZXmC+VoH/
CvJ9EPn0oO030PQg9T2QXxfwNaa+B7hXMT9LmJ9syt3gbwM812f93wY/BeCe
w3hprL8ujPEe5dugL5z63yifgrcvgCPsHaAK7ma8V+D/C+RVH/nNk7yBBOST
xHyNYq96EngDenqigz9D/09AeWTfDJ5j6Ps4Ov8j6/sHxp+PrnwPz7tr+Qz1
K21P651D21HwWxTa39c7EtrfAQZRfoE+62n7AvtFKOWzooH+71F/l+hDHrMY
vzb0PYc+HqD9tXLe0z8B11b4/w957Kb9bHidC+ys5HfgLGifgM5/wFz9Tpva
zH936p+hfjP0rIf+d4B24P4enX0SfKOAMA6HXcBXl7p6wN/QNx7++2rugdeZ
//ngvBPc06DvWej7W+cR9r7lQDL0PYq8x0DbEcrdmN9d9BmO7EfEW9aLke9Z
6MmHn7uQ3xDmZD575QJgGeWyrNFN1M9GHvdCbyr1D1M+keW1uRf+QsBdE3oK
qnuPWM/+tAHYEep3ak32l1j0JxL92a/5pu1h8D2DfFuyX02gPB7YCi89oLEf
a7k/8Cpr4Svovwmt/wGN0Z++0DuE+WzNfH8Cfad1HkW+vZHBMPq/ggxe1Xka
aA+t6cisDbowF34W034R7dci22Po9OulfWbrBb4fmI/ytD1M/Z3giwZfOvjK
Mx95jJ2v/RFeqsLfFuQ5j/WdCH93074VutWP+u+gtT/QD31Zx3z9RH1LZDwK
3p5q6HfPVmS0mfJ3eT4bPwP/zZF9S2AQ44+C5n20zYDejtDbHvx7oGc59ITC
/z/QO4nxXmO8OtCzlvEOUPcN8/8V+FvQpg7tv0KHz9H2H/RhJ+U3kedJ5Pky
4/0M/hqs99eR9Tjw/yXdAu6i/wK9n5HNKub3FeZ3Lvo3mPbFmeOl8LMJ+kdA
/xD+28j7IxkaqyCLCtCfAf2QFXSj7ec5fldJh2+F3oJU79WloPcHxv4P/nfU
8hrtD339CnwXqQe+aejXAeZjI/vVDfTrT/g7CD2boWch/L3J/O2GxumlvWet
pvwB5dmUp6DzDeDlTuBf6HkdfhZQ9x76twP9ewR+spjvTGA8uP6Gpy2MtQ24
UMl3rAzqqsJPLv1fgoee0NYD+LOo7wj9kHV/oCvyepr5fYC6Mehjd/a7AuR7
lPLb0NwA/NeYg120fTLHcx/egP2YusuUo8G9kPYtGS+F8boz3hv8txzZvAk8
ji705r/S4O6TaFrnUb+B541Af3jdCE0tdH6FxyrwP4s2HzPejRzf1eoyXprO
PsChUK+hRazHhchjEfI4gnyqQc8c5jCe+r/Ql73gWom85yPvGcjrAdbPY/Qf
z9zMAGch47WnTeXSfsfVQNY1dV7W/gm+Q8jyMJCPbA5T3sbcfwGPR5nPI0AD
9GEs/zVDXknQ35W6uCjfPbaC/3ftrUA4a+8K+/FQ2m+lfQjyeIn2o1GyMcB1
1uce8PeCvhehbyH9X6V/ddoPTvVZrAHtSyDLEvzXjbHns99eZawM6ndTfxP8
VeG/CvLKZn5uwP8v6PbRNN+lnwZfHPQ1AQYhu8Xo28AY38l0FzsC/Is8v8r2
XeEh9od2tL0fWEfft4Hm4H+VOXkJfanHfN8LLX2gv6/OJsAMaJ8JDIW/wcBZ
2v9c4LWuMdswF22BNOk/7fO11wKjoXcIPGxk/Eqs786s74vI4zJnn2+BTpQf
gJ5I9qOhlFOZr99YgzfhvxHjH9fZEDiEfMLh6fUI78lzGPuZxj673YCGPJ7n
Qv9U6mtC/yO0H8EaPX2736lLkNUy4AjPH/HfRWi7BDwd5j1rHG0HIZ+ByKcK
+Ouhu2+oTXWfQa8jy87QlIw+nED+P/Pu+AX4Ft1KQ4ey0bfH4b9bVb9DuiK/
N5m/XbR/CvpXoIu92VO+YbxB6OuzorfAtB+Ghw70f4w2jeF/AzgD7TX5xv05
4w2Gn8nQ+Bu0N0Vm65HNBmAJsqqBPM9RH4t8jhXzmeBl6ubH+64aRv15ePkm
x3d/8fwssp4EvI7+hjDGMfpXof/LrI/J9H+b+Qpnvtoz1jf0fwl6bmX8Oazn
ocj3SebrPP3/CvUdex645wIflvSZ+i30s3yieclGv05Ay6fAbOgDZbCEtouB
i9Ut4yk8v6D7c5h1fpHODjmWTX/+q0/fBvG+a36n9zPy6om8apX2nr8TehtC
70Mgvy566Tsb6BvmM81W+vZmfnswN82pHwY/xyifotwZfp6ibQ7z1YL1tw16
qjKX1YAKzOcyZDYNfpejXwvRrwnw+yHtDwA3wD2KMd5mfb+GfrzEWh1dH72j
7mugBH3HUn+NvWsw5XfAvRZ9+kDyQkY3ec5iT/iR55ppPiuORl7/MB+fMd4x
xnuP+UiDlnSgUVXPcUlkXwpoyvyN1/kJfRoLzj3gHwg/U5HHBfSzoe7D8PuP
3jVAEdknaJ/Dcy5Qm/5Ma3Cose/kuot3YPyWjH0XkMP4bVifLeG/A+X7KNeC
/+LsHcWAaPibDH/boWUHEMN4DamfCS0zgP0lPQcV0a0Pwf86+CfCzyPI41Eg
hbYvMv5Qva+BDdC3ESgD7tK5pqUjECpbUILPKh/BzwXkVZn1tBDcI6lfhbwG
wcgnyO9B8A9kPhYl+65ymTk+cyd3Lc4bl9Af1Ca4Aa5hOR7rbebgOeR1GnnV
o/0rsudR9wMwLtR3goXgegWIoL4z8nifscqw/yexXjow3hZ43wrcSX0n6q+A
/yL6dYOxh1Dew6DL0dk/K/lMMCbSNhnZYiYy3iLwPQMPmyiXY353MR/h8P8A
vK1EZteoa4EMdzLeOsabgS7MBMJpXwyZ3IPuDM/x2Wc1Mg9n/3kEfb7CflGD
+d4G/rngGFfJNrIQcN+Sa1uIzgBbmJv3CrxXZaOPl5HfZfT5J/R5Ku/nBuCu
D6SAuzVj9Ii1DU62txK0/wZez2Wb1wHwXJT5SWH9f6LzNTROoG5spHn9nwyh
pwtjRHN2H0H7cdSPpH5kiHl6lvL4SL+rq1GeSXlapHU5mvKWZI8h3LJxHECW
//B+Ks76nSCaaT850mcrzUl3eO0J7Eae5anvjS78TvtA73vZl8G3C7hC2x+B
ktT1B/8SdONSKdsa28DP96G2OW6lvhv4ttewzeYC9eeB69U856/pbpBsXdEa
1Nl2GfBpeZ9xf4G2J5izl5mPQ5Rn0Xc6/60J8Rpqi2wKkH9t2c6Q0Q3qlrL+
Xo6wzXyxzkbZtnXIBjIL3DOTvVbPh0Mn7WN0vgH/Dtqvou3KbNtyZRN8S8+R
3tvbUb+G8oZIv5v1Tp7O/FSGx0R4+xUcW9N8R9PdTGfQtZQXQd/ksrZJ7KC8
HQgrapvUE/SfxJ7bgvfFCernpPlOoruI7py14e8v1s9Bnl+t57VbgfHiK3gN
r6H94Ea2dTSHnjcoD2jkd3dRygspLwD+CfEetJrnVWleywng2MDz+jTb5vWO
eJr1tBf5bdJ+CnwmeSfb1nkBeUxgvSyA3nTwL4eHLdTvQR5/h/hM/g/PJZj/
N0NtA/sXfbvZzHehqbS/Fu01qLWXJxs1vEY15Z2MfO6GnmLUt2E9DihuGR0F
/0OM/7r0AXx/g38t5dOUv6O8jvq1wGOs7aaygbPXtc/1We3mbX53fQR8Xs3v
sG/oP4z+q+n/JeWV0LIize+aOMZvjGyrQU+9sr5Dt4K+ofBTMsxntCas7Sz+
i7zVPpDj4AtFHpdoP0X+C3j9A0grb5tkOOt/dL59PTvpc572/Wkfx3yvof5p
aBkHbOB5o3w84K8O5Ff3HTyVsefm2zY3hv4htF0a6bmWjewneCve0LYEvbOK
0f6JfPsydKf7Sm0ZL7yc7+BRehfl+q64j/lulWweRPvzwHZwTcqzLavdbT5r
r4Wfa+E+c+czN7fwX0nmpjY851L+I8q2bM1Z2Szf8XS3k83hP+o+yrMvqQRt
ylH/GTLJQrdK8o6uQvm/xj47xDJ/EeAeAM7BjDUUaAh/sfm2BXUF/yDqBqb6
3aQ2lel/k/5L6d+Z8Z6g/QDeL1N4Xw9ifqvpPJfsvTcX+dSH9wa5fhfuhf8J
0LIl376NCPjNov09De07qkmfCPShCpDEczPgL+r/zvFZrRpjhlMXlmLdaQpU
4rliiteW9oQ7eX4DfHkaH3hK/rEUP1+VvQFc9wFjWQ+/MUd1qasDZFCfKZsB
z1/Q/3GeH6tgXJdZnxcijFN7dY9c12nPbgOuyuhvLeZmEvx+p/sE8/8D5W26
U1BeTLlnOb9DTyKvCbK3oj9nkVcP2UYTfPeUT2U47aeDbyz9w2ifLXsGOvZZ
qH04w3jel2/fm94B26gvkuSzTkto6gA93Rpad6Mo99HZFXgZftvRpr30Lc2+
uMngy6GcCc5TobaJztB+znyvZa6bMP7j9P2M8mXKK6jvTfv9icYlG9qj1FVA
h2oW9Tt9aZp1SrqkO82nlF9nfyzLflSJcklkWSLTZ1Wdic/IHyubcoTPcJ14
/h0aWvHcGhgHrrnIr6L8FYyRyVljBOeBLvLVceY4he49Hmvf5CWd/9D9knm+
q7anTwzzGZti2TSSDQz8fYA/QmyDaIAuv0B5fIR9FKPBFZrsd89VdPoS+C9m
+C6oO8ca7Z/gywdfMvp7P33bZvrsKRtQcZ6HIJ9iyKc05RDeJz9H2leUxvvk
AvzEI5O7K9kmKF/sH5G2zcon25a6YsirA7RPZM6i4fdZ3kcr4HUVMJHnfxm/
BPJdrTsR5UnAHnj7iDlswfjNgbwQn5FT0LdU2Z9p/yNreAb8lWGMuoxdLsJ7
Qx7tMyK8R6TwnJxp24LeAYd4Ppzpu8BF5nAA8nqb8jLaLgd+gNd6KV47ujN8
gKy+gObUKvYBdxcvzMeX8h/B04eSJWPmlPCZ5SBtH86wr6cOcB1e/ky3bUE+
9R+QzwHNOXvRac57t9L2lgzbJhpQf5y6ynqfwk805UPUPQj+u+RfBX9r5uvW
FNvGHoC+26j/iD5jwHcNKE750xj7Mirrzgh/IbSvK3sI/HVHdldzbfsuqOS7
vnxw8r3pzr8PWbwPtLrF7/Bx8mdT3iB/l2yCjN8gxWfXW9CXDdSNlk0M/V1B
/RHw5bOe/6tln/4w1vJw4Lruj8zXetq/k2nfvGT+Fs+rgd3MRSQ4e2kvpzw/
wnfAxyh3TDTvSyN8NlvH/tI81Ge0QuoX8N+MCNvk5+vsBhRnbiqBby7zVTXF
e6/uBBN5FyXKH1HRPt0uyLpzmm1fY6jfx/yEpds2uZb75Tr6vwb94by/KqCf
TaJso5JtSj6JA9RXpH1mZds89fwh/3Wr5f8O6XzHf9mVbUOM4LlKum3X+q8X
tPQF+kFPtaK+6+ylT2Jl33k+ZH3NZ/0eRHcbQ9+8NNvcZWvfyn97qfsq174b
nan6gGsJPJyLMM7q4LtH79AK9tEmUk5It62ss+ijbXq6ffcb4TeL5y/BP5D5
GAFcYLzzQDtkdQflk9Ql0aZrZdsoc3j+SjYd6joxRqF8wen2HciGNZvntxq5
r+5UyZSbpftuKRz1eb4j3bb0L+hfi7mtDXQug54EtpU0Y78sWs42kxa0fQyZ
7K1oG3kVaPuAclF4L0ub/Yp9QCb7y3sNnaC8NNmxIcmUo6ClI3eSHuCfUsln
49559nXrjKyzvN55etfpTK+7w6+U51XyHSKRckKafc/a8yby/Fya7zqKmWgV
ZZ+EfBHrqa/BeJ3SrFu6Ez7BWEPz7DuUjakfzw/lOXZDMR5deO6eZ9+ZfNo9
6dsD6FLEPqJK0DI4zmePacinOrzVAIoVsw/vjjTbiGUbTqf9j+jDG8jgpOIr
6PML5eXR9oXKx34J2V4GjlG3B3z15PukvvLtfseVprybMetU8h6bQzk7zb5r
3eH+At829pwj7FVlqH+HviGssd6sl3KSJ7KIzbWtdD9j3J7md4reJTWoX0/7
jHTbtkMpv0B5GfTUZf9azxjvyj4Mf+sZqyL1X0vfgLPF7APrzfhlo7129I55
mHJYtO/inRSjw9pdC9SEnlrAOA5+L3HmG8fZcTwwgrpyyPMP6PszzGeH9+Dn
YBWfIXRWmUX7sVV9Zpmnd0msbQHT4OE4st5bYNv9KeboLLSfASYgyz9KGvcs
9Dku1GO8zPjzwTcFfC8C71P+ONG+rgWUz3A+2VVg30xJ3oErqd8E/xfhfx71
r0LvK0BYuPekKeB6Psu+3QTkW5O6YbojsRYWhdm3Ixu2bNfy8aRSrg/N2yo4
RqQe5X+oH8VYSynnUN6iMwTPO4EsaOtO/Yzq9sn2or488HKYbaxTGXtkE+vW
YeofT/IdSnen7/jvIs/n2H+/Y7w24ZblH8xRyUqW6ZP0ncZ/T/I8GjiN7L4G
2spWJpqoeyPLsWeDwLeQ5+LoUE36T6X9U7R9EggJsc9jKM8z0dctrO80ZNCT
911Hyhkh9lmXYi5KJtj3H0f7ebR/OtpnsSVAI8U6xXst1Kf9Tp7H0X8d+IaB
byXlbyO998rnMiPbPlT5TmfS/pYC24RlCz7NmfYAvA9G/7+uYR/etnjbSGUb
lQ26F/0fyHaskWymc+IdU6RYIp1xJ/LcmvPzPWV9xw+B9iDBsTPyWclW/Cn7
xdRathmPln23wLFfm+gfgf4lJfostUvypfxigW2XtW+3ralugX2DsjnNkT23
wLZn2ZgVS/Yh+CfUckzZS9Azlv9e0XmqqN8NE3Ida6F3xPBo66B0TzEen9D+
Y4DHYC34pvD8PFAG+ucqHoHnqdH2XWnNt6VvOjrxPv2PA4d5HhbvuVwI/a1Y
e09QTqF8Dp5yobdXgX1tg0s6lqawwLFTiqnJhvfcho6t+Yr2r8m2Gmvb6WzW
72z0KS/RZ5mnwX8vz/kxPjtdls8WfNsSfdZ6GhwLeJ6faNuX7jRr8x2DqdjL
0ciwlerRj/jy9lncT/k7xu/LXF3R/qH7eKJjta7QfzXPq4CHizrm5iee5zX0
3jFCMVysxYbMfwxtn5c8qP+d9XuVclfKhygPbWjZdqH8XmOvYa3dKVrDlI8x
5x+jv7MoB9R9Rv/j9H+OcjK4mxfYF9WVd/BR8Ur7frTvTv379I+jnEN5Tphj
B0Yz3s7qjiH4WfsD85cN7SMpX6I8nfq/ZB+XzZjyTOQzsYR98rKFaA1r7com
orvFfdp/qvuO8YNsufn2/XxFnx85n6ymfQTy+4/z8gX04W7WVF/FJoLjKOWr
ifYNvEq5Bu+e6sBI9ppRwDeMfTPfvh3tEfcyN1XiLftPqL8Jb7ULHCtxt2wg
lEOzbFuQj1m+6b/vdOyZfNSjkd0U9D2E81ZfnekZqxIwBFxDgVvBdZti+Grb
ptSJuo7AcupWAL/ATzLl++hbHrwPyZcWa99xT/TxfKZ9+PLdK2ZvAbQMTvTd
7AXoaZ9oH4Z8F4op+A79fDjRtodG/Nee+Z1KuQ7yOAmEU34CmtvC7zzKV+E/
s8C+uw7w2wxakoB7oadTcdv6L4K/Tynb/P+i/e0Fjv3pT/tZzPUJ9u+LFX2H
vsLz6/x3qKh1JoT5uJTkvb4i9L6JrA+DYx97Wx90JCLBMQKKDagLTQd1Xgf/
SOjZBb9jkO1oYAnz+7veWcj/NWBiBZ+pFUusGOAltRxTvJ2x3of+Iqy3g7Q5
iOzOgvOLCMdAHKH8T6rPImcod0Ce7bMcG6qYUb0Li8f5XaV34h7drfmvHvKo
whljErJYiowvV/eZuhS6VDrfvl75mBV7Ulo01nQMynu6a+i/Io7RTOE5PN2x
J3upf5d3+Y5cx2aVgub9un8m+WzyOfg/oFw0yWv3lOaf8lHdyXjeD7Rq4hgw
xX7JBzqd+gPUb6duJ9AUXuOAq0Vs45TtfAs0lSliG/qLtC+fYlvTNtpXjrFP
Ur7IrZQT6JvJ+adfFd+R/mVubhY4VvdtdGI/fe+Gp/rgO1LBd4td0BsT7juG
3nUf0CayiN95GdB7EP5/gP9W0NuScoFiWGnfmfIexhsdbV92K/RhC+Uh0fbt
z2GOqtB+LvSshZ4Y2m+k/vFo24J1J94sWx/lWUUdE9Bfcx3t2MEo5H+S8qep
9t1KZ1cqdjvPvqsnijkWWT4f+XoUk/wttH3fzLaiRbS/znqdCb7NivdgvX4E
ru3wc0bxqxV9F7kA/63DfSe5hjwyaVNY0T7OPHQtN8uxb4rxjYSfCxm2xaQr
nlF7MfI6VcE2BdnqKrF+3w21zS4bXFmpjtUUztW6KzLmRNnOdd/jORp9/B76
N1d0bOCaLMd6K0awD8+9sxyLoBj9+fC6IM++NMVw9KT/NfhNKe8Ym1Xg7xVt
X6d8rstZqC9G+yx+A9gr/yX6diLCMc1RtD8f5dgMxWzVhvaMKNt2d8LDb6z1
q0AL6P+VNTY13zHBigVuzp7SkbU1vMC+4en0b8/+35L9Io75OqYzO/j6Uv4z
3DFkl6n/BXyj4Ocv9pRWCbYByvb3dzn7wm6nfEt1+8SGpzsGW7HX85mzCooX
pM+D7Je90M8feb6f9s9Ud4x1a8qRiqFWvBT4piO7BL1feP8/hfyelm8/0bb4
vfSJgJ7ayOhX+C0CPbfC2zL6v0r/leCbjqxu4b/N8PucbNb0TWpo397yUPs6
5JOQL0I+j/8Yfyn19Wo4Bv4YtA9Gv66yH0yjXJb2YeA7UNwxaU0SHSOm2DDF
9JxJsY1YtmG9Y6pC718JzjXIYcwa1P1DeTj8P06bu3nOjPJe/Cf8dtLdW/IE
d1HwVWD8GoyxPdQxjnvRlcci7RvSnjuX9iPp34H+CbSZKX9zlNey7jwn4P94
pt+VsjGOo3/rZPsKQtC3l2j7Zppj+4tJ/9Cvpom+SxxSDCP8TEDHJle0z7EV
9NzPmeVe8NegzWbafwr+oxH24Sv28xv6/FDBMaC6ezwc5XeJ7iADma+NyCCx
pmNQZkPvSwn2/SjmSbF8ddlfb63rmL4LrP/mCfbdt+T8URp9qkC5XmAbzWT0
Y0AT3yW0ZhtR10bnGeR3FnlVyLZNQ7YM5WzEam+Gpv9k34efntSVY7wr6H8Z
+u+R/kXbltGZ8gMJtiHLdlyWcl/ZvpDP+VDnbMgW9jr616OcbWKDoGcgsLeU
zxyXqb+U4NhA2exlKytAZjMjbDM7AT/H0+1LV8zWfOYiNs+xyZMqOVdgC/Qt
reucgSeVOwAsLGIbdh3aP0X5FcoplRw7v432y+o6hv4edKUq9P1Y1mviR/bQ
Y+hzWrj3hD7yPUPv8KrOeXlE8baK10ffB1BeTLlAPlb2g6PwMIxylUjbEqeW
9lq4r9CxyFoTikXWHUJ3B8Ukr6HcIclnoVzaf8v42dBTupzPtG3RpQMNbbuS
To2EllFZ3nu0ZtvqPhrp3ILq9GkXb5+yfMk1KLehnMh8tShqm+PzyDI+2rHa
ylFKkn1FY5axDetD2abjHeu8I8K+NdnAZfuWj+0S+pYCTc9S3xl9aynfLvBX
4Bi7Ap5jop0rc5Q9bSz6dQ//DUU+T6Nf7TN9ptdZ/l75IOJ8BtTZTza1jxQP
eKdtR/uoPxPnO6HugorhmsdefJZyJM8j0Mnr4ApJ8l2hiuItM30m1FlwAf2P
0vYIsKKobVCHeT4UZ9/uVnDMp++CJPtqdQZZmOkzqM6e0sHIpvbhynerO45y
X3KgoXYd58Bsp+37uuOX8x3mC8rLmJ85VZ3j0Im1PR59qRzmGELFjuXRv04d
x5BlRXmP094mn6xiEXrFORdEMQkd4ryHae+STbAbE9O90LkQyvGaxvuqZ6Fj
2xUzd5H5+RX5taZ7B+anL7TdF+1Y3++BTeB7NtKxsyXonx7ld4reJfKp7QfX
TtoMpe0GcG7meWKkY2FCaf9ipu8kuotM0Bk20z5V+VI/jXBsuXKslFulGHPF
9v4OjcdqO8ZXvmH5qOWblo/4ccr3Rzv2WzazM5k+c+qs+VmE3+V7Ghu33um3
JzkmSrFQsgFtSPWZVGfRPcirQpLvYLp7yQa0MdlnWp1l9U4+l+kzt87aXwJ1
oLV+oXNpzpZyrE35XL97FXPzNRtrbrptzbIhd4X2+c0cW1EQ4rP8h42NS2d6
+cpP0ObDavaZL+P99i/925XyGV13lxHQf2ct32EU26+cKOVCKcZf74pN4Pso
wu8M5SpoD9beq5yFNHDl5Tp2tGdl28aeBV9GLdvIIrJ8x9HdRjFrrdCHSOY4
BH26yUvhW/BX1vm5lH2sA3keBPwRbp93apbPtDrLKsbsTLpzwJT7dVM2UOgt
W2jbl94Jvza1jVG2ReWE7kTXO0LTi/DaGvn/Qt0J5X+GOYczGvn8G+VYTuV4
KlZ9b4LfJYpZb0j57yjnfionKEYXsWj71hUD2oNyNuWORf8/R5ByMuV7izoH
JkJ3j0LnjinHqzf190Q7dvUM422G3k1NHRu4l//iqW8ab1+dfF6dZbuJdi5N
afT9e92Fop2L+ERNx7r0QcfOhznm5SVwLYhyLoZiZKdRngr0B/9XvGObZTtm
UbGKiejEb1G2kcg2ojPZMOR7Pcq5T8ox+4a+55o6Fvlv+tegb/V455bslA0l
0jlVyqWSz3F7gXMeles4F5678NwbeYaGOqdFsd69aVNYxzHfBylfY/ynwhyT
Wgi+Z8B3KNzvsFmMPU/xPEWc0zNS9pdI53YqR20AujowzrJUmz3Qtq/QuSl6
J4xNcA7UxlrOYZXv/Zlkx37IB78u0z4z+cqUI6OzXCf0N6jlM53OJvdSvlrT
ZxT52h5o7L1cPjf5Clvk2NYln+E9Oc7RUG6GzsiXoL1cvGO5FLPWKcdneJ3d
ZSN+Lt13TN0tVyLv9jn2Acv3K52dBK2Tkx0rdbOoz1KnlYNR12eqBcxn31jb
0hST/jnrqxs0XuSud6U+kGafnHxxytEox3ipuY5FT6ZcE9m3AOe54j6zdka+
WSmO7ZANpCyyrsZ8DA/3Hl4n3jGpikWVTW1XmmOUFZv8rXw+2c4RVG7gK9DT
K9Y2PdnyFNO+PdU5bcplU0z7wTTHdCmW6xfgfejbBwwOt03gY3g9XujcIOW0
6e4+rbHPArrDK5dXNj3Z8pTTewr+u2c6FuAX+J9S6BhnxTYPBPbB6/4En010
BlGu1o+xtiUpZ2tGsmOwFHulnFX5xk9SnxlhH/nDyY6RUmyUcjoVO1C/sd89
iiFYTP3n2Y7tVI5cc/hrAVwt7zuxYuUjcny3UMz8/WmOEVBsgHxw0xLtw5Dv
QjaphemOqVEszQfM15Vs2/xk69Od7QrzM40xd5e3D1q+57HQszHCPuj3cpwz
o1wZ2RhH0HZksmOhfijq2IFDhc7VUgxBGGulMMGxMauLOXZ3XI7vborhbQtt
P9D+V9p/W8qxG6djfXZSDMeYHNvUZUuXzTOEtX451rZ92fiUGyEfjnw3ypHI
y7FNWrZo2TQbxtlGKNug7pSKvfswzbqhGLyveC7IdS7SbZUdW5/f2L4lxdiX
T3NO/jX0ryF9foO/XTHORVJOxEdJtvHLtq8z9SeZvkPp7qSc3tfyHdOpWE7l
FH7C3GRQrsBZ5gj6NJjnO2J9F1dO7cfNnaOi3JTD1LdIdA6wcn9151DuQovG
tp0rh+HHZs6ZUK6EbN5vN3NMrWJpdWe/ke4YRMUe6s4t29G+FNvWZEP6kPrJ
sunB+3fynzfznVp3aa2ZKemOkVFszNuVbdudQflqZdt4FVswMsm+O8UYjGas
J5vblvW/nFLqqsb47i8fYPUY2wxkK3gPGnZTvyfJsRyyWSk2JSrGe5diVLZS
ty3JsTeKEW0U4zuy7sbKWbzCWbBmM9ua5bNa18wxZIod0zv/hNYC5XBoO4U8
OyK/15N91lNM0DbqP0hzbtML1Pdo5JgpxUqtv925Lb8k2rauHJcSTXzm0FlD
Z8iGOl9SDu7wGeR98Z/t3PYl4BuS4hwm5S7Jhno+xTm9yuW9Qvmovp2QblvY
JtrPS3EOknKPZIPV3lwxwbko2qN7NHUMlWKndOfvnOqYMcWKdWX/a9fINnbZ
1pdB/5Ak24Bk+5ENo0Gac/KVi59Ryd92+CjRvgZ946EEZ6WT1MdXccx9kQzH
xCgWRjm8vzXyHVt3a+U4HG/uHCflNh2r79zHyMa2tSgHcmq8cyyVWymf6GDl
hqb4biKf+j7mYkWmcwW1p+nbFYqhV+z8c0CvNMcMKFbgeaAT+3OxFMeqyCZ0
E1p2FvrbDrKpKDdYPhz5bpQj/EUjy1iyVUyFYpNPRvuurBjl/ALn8Cp3V3eW
w7Q90tyxGMr5yqJt93iflXQmOx5tnZGuKOd1OuVNlCfX9zczVkHb6hTHQiqm
MbfA30zQtxJ0pypP+3doP66+Y9y6ZTsmSLFA8pE2zHWOhXIr5LPawVwej/O3
QxRjNrLA30zQtxIUs6bckucb+66oHBP5/uXTly9fMQDyVcsGLtu3fNZbCx1D
qthR2RRS0b3PGvmsrW8CKFeqWJzvRsqZej7XOajKPZXPRbnSyxt5r1TO9MBG
1nnpur4R0afAOVHKhdKZrCDfMVaKrVJM0n6tt+aO7VFOaL/mjqlTLF0rxnhC
vkj+m1jfNuXxspUUOJdQORbKvX+jsc+CysEfpPjoZN/1FCNyW4pjyhVLrhz2
ZuCLSHPsjs7Q/4vlybSvQzE9damrn+ZYDcVcKNZBMVWKpVLMw754xwwoVkB3
4DZNbQOT7Us+4bfibOOQbUM2H9m+Hovy2pYNrJHsrdn27chGvCzVMRCKfVBM
ZH/atofeMnfYB3QX870kzmcz2WBl23402nc/2bila43B16e4da4UtEcn23+r
GJFd1OUk++wvn09f+m6gzzP1bbPuw3pJhYdLxXyG3o4+NMp1bIhsRm2QbdsC
5wbomzayRZyLc66xbBJzwT8v22cxfUNln/IFkm0b0p1QY7XMtu9AY8q23TTd
sU7/s3HrvpbtWGDN8QvQv7e5cyOUM/+cfN15zg3Rna8T8tqQ671NMYfpvCtP
NnOuhHwSz6FbsbHO7dI7dWKGbbay1SrnS7EkM8Exr6JjSkIpl8twLk4y5a3M
9bZM587Kh6ZYGvms5atWTM0ZcH2Z4VzwHPlkGGtXvGMR1lTxXfNsjH3punMO
UW5MrHP79M6pzfOj/De5imOaFctYNsNjK6ZxM8+bMpzLrpycNdCyNtOxtoqp
WszzkkzHMivHWL4P+fTky5MPRO/i3Qn+VofeydOoz4lxbKV8wpnsh78lOxZP
Me9ZMX6n612uHPsdPI/nv3rF7ZPW3l87zbFaegfsh7Zusf72ju4AOisM479Z
VXxm+ID++9P9bQ75YJ+P8ZlCZwn5nKrSNiLD3xrQN2ACcDVOte21D+UM6tIz
/v9bHvQ/ydyfyPPZQDEV8gXuTbFvUT7B+6i7J8/vNt2hDvJ8IM9nS8VIRDe1
z1y+cuUkdEW3Ojd3LJhycJrE2acvX75sgvL93B/l2Df5gDqDq2Oe3/26s43U
933y/G0J2TTkazudaduNfG5lFLuW51gn+SD1LQ7piHRD3+So2sw2dtnWdee5
kGAfnHxvyrl6gv1sEPB2defMKXZcMReKtVAM+aB426Ble1bMxePgfyzDthnp
lHyF8mnIlyGf4QSe0+FxSQnb5D5LdAypYkeVc6hYeOWsKFdFMfF9WFt9c51r
r5x8fUtJc6S50TeV9G0mxfgqtlffaDqfaJ+nfJ36xsrvifaRyjeqbzzJVtq5
mX3tspn+lmKfg3wNsrn3TbINWbZj2RiGM96YdMfOSqdupjuGV7G7ytlTrpG+
yaRvMSnn6GCBY/gVu68cu7K0X5jnu6e+KTKA8WdFOndU31x4M8sxTIpdks1S
sV/zmtiXrxiwc4m2aciWIZv3aMYbk21brr65pVi1sU0cm6KYtWnKp8l2rJG+
MfJilmPAFPslG/rNFOdoKT5FMdUbkd+7mc6t0hr7LsZnJp2VlNM6hv35ljTH
1immp1asz6w6q+qbNcpFkY9RvkXlpOisWbKJfcE6c36aaBuKbCeyQY2A93fi
/K0G5Zgp11DfmNK3pZRzeBh8B5PsO9Y3mE4jv8Uxtn0pR394sn2w8r0qx6Yr
5W7J/raQYhif4n0xutDfwtA3zvLh7dNs5x7oTqtYslFN7KtTTNlIaFtT6G8X
KCZvj2ID7nRurO6U32X4G1L6dtQ15vtsjmPwFHsnH5xy87/NcWyFcvSvNLdN
XLbwfzlzfq7YkELnxivGaVWWY1IUi6JvJsRQF13ou6W+idU6yz5g+X6Vw10f
3iek29ehGGj5+uc3tm1ePv+Tmc7RVG6mbJaKfamea9+dYmCU23lfomOVlOOp
u6y+sbE/8J1WvvbobMeyyef+KHPzWJx9B9IRxeZMKvS3EBSjU6/QNlvZauUD
096gbwrpW0LaIwqS7NOXL18xWsub2CYhW4S+YaZvnekbMvp2jL55lsjYSdm2
zekbNMoNrZNo37ByRBXbeCnbvlzFOP7d0DGJikVUTOpy9q5VTR1rJp/TmAJ/
80TfOlHM+Y4Y31l1V9U3jSqCb2ys51I58L0THeOv2H7lUL+cZh+XfFvKOZvF
u+BMM+fq6h09lf7vR/uuLRvE8VTHAMj3rxikRfGOqVIslXxu7+Y6J1O5mPIp
Xsv3N5z07SbZ5P9UvlGyv3WnmMfK8fYRyzesnJrlsq9E+y6kb9bJdiWfo3yN
smHNL/A3oPTtJ8XI6OyelObYBp3hl8p2VOBvSygHegXyWt3UsYzyyW2Jc8yc
YuUUE9mX9g8W+NszyhnaHOMzsM6+OtPNh96H4+3LWKz9g/4j6NM5zDGQOfHO
4VDuhnxovaGlT5rvRvIBKddrZ5ptZ8r5eibVMZ6K7ZQPt1q8cxKUiyCfoM6O
x1IdS6EzpN4d8rHIt6J3SMVE5xQql1DfeFJum75RoW9TKMdtNrzOaWrbj3I6
h4Lv71THIusbLBUzfIbS2UnfEPsj0TZg2X5lo9XZt0SKYyl0Bta3pdrH2Dal
b0wdjbHNRLYS5VgMjLVNTrY4faNHuYFvRdt2rRzBEooHT3ashGJUe8bahinb
pXJEXqR+qvSvtG3YKc0cE6ZYMOW036+7Wo5t+2rzZ1PvOdprlIMZFu+cYeUK
K8ZHuX+bop2LpBzA/52tm9t3qDN2LmPlpflbG4q5fFax4mmOvdY3TOQ7UU6K
clHkQ3mFsV/N8bcA9A2VNtHWCemCYhTfynJMnmLx9E1B+R7v1R2ltH2QX9D3
yxzn4uubOu/KdpbjWEC1kS61j7fvVDr1f2cCrAM=
         "],
         VertexColors->None]}]}, 
     {Hue[0.5320232465935308], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd8VVXWhi9ICS2FkNyEBEikhjRILzc3CSGAYkWpOoJ+VsCuFBFEsaCD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtnAmYztUXx3/JMjMYhlntFDWrZcaY95133pkxMyitZEtooZWoZMlaUip7
Klna00qJShJRdqEUJYV/EhXK0k7/z7ev53Ef751777nnnnPuveee5df0+sFd
bq8UBMHJykHAv2BiNAhatgyCp9OC4CnK9OIgSG8VBKHqQfBKQhBc0SYImrYN
gs9rB8HAmCCoUhoE5xUEwei6QXCsfhDMSA+CH6m3SgyCxecEQZ2yIOgQDoKi
GkHQt1EQ1GLs1+2C4CL6z2S+URpLWUf9UJUgOCcUBJUoXal/yvjE3CCoS1kJ
coOZb2OnINieHQTnNgiCJS2CYHY5ODHnDvpf1SQI1rcPgubMdxJ8qzPfp7T/
URIEX4Lbw7TfEAmC+7OC4Grwn5zCmlnvLvpMoy2D9f7B79eKguCz1CBYyt/6
Md8XrHFEzSCINmcc+M+uCII+TYOgJ/hng8th8K2dBAzgHQGXmdTXsv7vwXEb
a91OKQK/zPgg+Ap63s6Y15l/R70gSAJ2IiUp1jS9Hvz6R4zbhGrQH/zC8ONV
cHuF0p+xR7Q+5ltOnxG0Z9D+GG2zKCWtg+Bi5ttQJwjOZ776rD3gb4msP4Xy
ayFjKdUY+3XVILgQWOmUy8CvBjSuRFsJPI7Ci9rJ4MN8f7OeRsy3LMW0fwEa
XdvkLA+Y/y3KYKZZy/yx0GdPxyDYdB5r4m/58G49/I2DHjfDzymsvwXyVAB/
ateCr8x3NfhdC27bmG8I9P4SemyJY63Q+1X639gBeWmGTEKv6xn7Mn+LY313
A+M5cLuUeod6HtOR350p5dQ3Uv+B+feDzzfg8xT4nAv8k/CoD0Lf/nz60nYt
82fTnkUZA71GUZrB71vBqXt+ELwJv8fC7xehTyvWfhv82Qbt1jemD/PPor07
7QuZbxFzP8HfNrDe58GhI/jO529fsne6g29L6Pcj7QkQZyb0fDIzCKayR6oC
ay71ImBHKd353ZU5etL/Cei3D/4s4m8Toc1O6gnM9SD0/wfcW8Dvl6DHEvB9
n7kuBf4k5n+D+d+mfm8O45HnV6mfYO1P0b6V9oOMHw5+W6j/Tn0h7Z3AJ501
rwPfLPiTw/yHaK8FvjOYfwG8LkHelsPr9ygtwGcm+MeCf33gNWauLeyfY8y3
gv0ahV5DWM+lrGUPfR6CH52Rkd+Q9UW07wHe15THkP/DwBvBWkZSTrGe3+HB
YOb6kvaDtB2izGf8b/CsHrzLhgY30V4HeBuAtyfNfW/nbz+keUwh649Q3uH3
TfD/dWjXE5n7H+s9Dk1fpv8rUa+lMzh8AewvKeuQhfPYP4Po+xfysBvaDkY+
f2Y9RygvIf+tkyy7PzL+9zTL8C5+76T0BtYB/nYCWEOh+Z3Ifiw4T4EWg6nH
Mv9S6FkJefyVenfksYT2U8h6XInP1m3IfHfo+wA4N4UWV0Dfb/j9LaU545ux
/k+Zazvlaubbx3zJwPrjQvYDaxsK/t1Z+7fQYx99w/CzKnv9s3KfhRfQ5zr4
+yv8TWYt74BPhPpR6onUH6c+S7yhpDFfTWCUQeub4e8j8Pc79sMq4I9BhpZW
9xn+LOsZnYEcnste4XzuCrx/gdcUeK/qTGM9X4B/L/bLRNazlvrn4Fyd9U9m
jhuhz00Rn6W/cgbNBn4F8LsAfwcymQwu/dhvyU0tM1uAdRwax0C7AvGTsS9R
7mPsNmBcy9oX0n8k/bsh35uBV4qMvg3+a6gPof0t2u+lvTv1A9DuIPAOwn+6
Bbuh1f2s92X6z4RmE5jvfsoW5no31nfHWNqfSfUd8hSwnqPcDrx06NWYs/TW
iPd6VXC6VHcfMtMLWfkEGV8JvaK6zxqyHui1lvX1Aadd8HJnms/ul+HZm0k+
w7dwdw2OmDfVuR+mMdd0Smfmu5iyHnrugp51oOd06DkUeEX8rRBazwDes+yf
V8B3O/i+DPh5Ojtb+Ww6gLysov8LwBsMrJbg/zTtF9Hei/ZvoP+54PMPMrqb
vfAyd/oV8PZKnXd1zcO74P1w7uCbwG8pMnAj46eynljW2hf6rmQtxZwxDaHF
WtZUztr/YHwDfj/HmOvpu4j5RzH/s8jXaeh3H/TeCPws9lAF+zHK+PqMvwQc
HgDfYtZX1MA6yyT2zmBwvAta3Ul5lLaDjM9iLbPosxx83qNcBa4boc+Humug
V2XqY6mXgs9v4FMPfJ4Bn1L4Owp638L5tZ/z6wraA9bQjPYFtGfQlk0p43fD
aj4bfqJ8G+Mz4n3grwX+aXAfDPyp1PeDz/ngMw18Svh9AX9rxO+ZrPEfaL0A
+G8Avzb4f4C8fER9A/Us6Ti6/8GvLvXXmfMq1tKFshd4l0DfZVGfETobNkKP
8cDeRr0T58d9zPGJ1g//ZnG2fET/5uDeglKoux16v0T7da18tx5EHp5hLRuZ
syfruYb13EL7EXh0LM48rYUsDWCOa4Hdi/Z36L+MMpTfMxlzmE10G/xsDj83
Mt+qPGhOqc34SdCkEFhP0P55gv/WBf6NRsY/g7dR6QTMncUcVyKvA4DXkd/7
+dvt1AdRptN3H/fPzfAmAxzKkI81zFmPtV8MjCuY60pKrTjzfDj9p1GvDKwn
4OnHwJoLvt3Btwt/2017VekX4FoCTXLBbRXw6gDvKH3KoNU/zPcg8/Wm/XF4
06HIuDwLT9ZwPn5Eqc19FAJ+I8ZvpN6P9X3D+M+A/wL824Es5Ov+Z+yf5dY1
/4oxrX5kvovTTLPbkP8J9HkJ+OOQ+csZu5k9HMdaHkr0Xn4u12O1p4czvjf8
6AEtWja17nOI9iDWOlAmslgCjTpBm9b0mcZcnwDjF8buBIcmrK9xxLpOO/DL
kq7Dnu7XyDI+GtifIE+1mHss46+CX98jcyfAtxh+HQXW+8CsQb065UHm7sT6
T0KPe7h/cnM9p+bKpd6J8R0ppaxnrfS/1t7D2rtDKfcAe1TUum1L1pCOvNxF
fTr1mZRewJrPnJVreI2S9ZmMH1vfMq+91AV+LWrkPVWf9gaUEXV9R1Rl7IfI
QEvWn0M5B/4spn8r+DsZ+MOZaxildazP+K3M1xEaB9A2wvqnA/9RyjPAfirJ
Z1G01G06k74B3i/MURNYjTkfWtPWqtSymkm5R+ch8z0BflMYnwT8DfQ/lGr9
6EfGr4DnhxOtEw6l/9Pl3ou9aU9jLR10pyGvw1jTZt3NwDjC+J8prSo8p+b6
mTHNkP2TnJ//sva94HM+9eOMqQ1+J+HHBfTfAb8GIq8H6P8i/F9A2czc5yHP
ycy3lv4HgZ0OTRqA21vMV5nx/cDxM9oaV1jWo7F+S9wT8dmuN8WhVl6z1noC
nN+g7U3KF9pLtCe0tAxLdltTSsC1ATKTEuM7YxrysQmYn3A2TYLH/YE1gDKQ
tb+HzM6F97PpcyO8r8b5lALv9oFfOfiVUZJYb8CdW4i+MJwzrjX7IZe/nav9
Co2upf91lP8Bbyv4L6mwjirdVDrCEGSlP/SvyfrG0D8Cbg8DI521F0G/fnpP
dPRdfByZXEv/eeU+G7uyhn7Q7yL4Uc7YRczRj/EjWeP1rG01/LhYtGB/HtTb
C5rcEbGOKN1wC3OcQj/Jkg7C2LEspR3j72b+BNraMf8hZOGHYr/ltObHoMc4
6NEZeuyFpyOkC1WYtqcZc1T6ITwZCK4j4MlJ5G0ud04t4N/I/Lez9oGUA9Di
YeD9Da3/oVQ/+57LBfY7xX5bdIQf4VLTVLQsoPRnbVfynjjM3BXgdwZZ78ya
ViNLD7HHTjHfJdQHpFhniEatY0m3GsB8lRj7M/zrLHsEMH6mrTTXtoU24DCF
tdzGmAdp7yidkLZb4Gce/JzAfD2L/ebTW28b/XfCjzAyOkpnLaU947+Dphms
9zQ8msz4EOOrMX4M49fAi4GsoTv82QFP+iKfXcCplPukJM6624fAf7yFdbhb
ofdtJb7L9QYoZ3+Mi1hX+Jg1Xw38O4F3NfAuYP4S+u4An9/YT62h3420jWf/
tWCtHWv5rNmWY9uEzpyb6H8R/FmPbF9J/560f0F7G9pr0h4DLZ7MtWy0TrOu
8T5/25xmnUNvp3m0f3iO31AV/O5Ln4Xg24H5/gGXDcBrTP9GOv9or4Cfm2i/
jfZ41v4Y/fdSLwJGpMQ4CZeWlL7gMxr8z0uwjv4U62nPmG+pP8D4BHCpRZkK
bcJ6QwL/Jt1fwJpPew3mf7LctpwroM+r1PuDz6epvt/OUC+rMK9GAmM78vNM
yLzNkz6GfB3OsO44mjP1Dnh5JyUnzm/+08z1j2wS0OcD+PFtjvek9mJJms+G
RPpfVslnRA/gvQU+tzPfJPD5HfmeS3sv5CMRfv/C+mrB3+bM/Q88rVfgN67O
bp3H06HNPeyRKPtvKzT4BHlpzBo6spa+TfwW+IF6lTS/Ce4A3uGwZUMykgit
6lKqs54IffZIF4n6d1RvYvBNAZ9LwfeNC7i/kc/JFd4LYfbfn8xfE/6B1n82
sJ+R5+s4P4cA+3Sy3waRUvfVG+FF1voG/Tdwvl4PfnPA7TBzLAP2e5TFOsug
+WvJpolsQZ+ypm6ptgndV+EzVGdnGBziwe1u6HErvD1AuZO5ByEfKQl+n/Ys
M41F26Xw61ra45ifrsE0/vYRiH9cYN23PzJSF3gdaH+SsYfoFJtnnUa6zH7q
34LvhRW+uy4Bhxmsv11Lvx2lE/RnrX3of10D66wbwD2JMVtrW8edSn09/Dwq
WQJGCfXfka/6ut/5WzVwjaFcDq6XUdYA7y/WVxX6rwPeUs7Sf8FpJfA+4UzM
YD3plFTonQ0+w0ttE9PZOZz+ezl78ulfhf5Fojm0S4E+W6iPg78DIn5D6u04
hfl/on8Z/eNp/4n1vAJvXkfemyIfF7ewbnRhS7/1pCPVYPwy5lzBXLexR94s
tE1MtrBV8PB4K+sw0l1igfcV/Py63G/dNdDjCPK2iPluYb5L03wWfwmMQ8k+
k/fn+I7V3VpBCfN7DPxaD7+up/409PtcOjO4h5tYt10KvEG1reN+z1l2UPYr
7p8urPF7cDvJ+FCiz6jfqX8EvwZR/1z2Qni1iz3yDX33I3MHoccQ8BkKPl+D
/w/AmgB/aqTahizbTQ7nz8YE23DmQ4t/gV8h+xw0eZLfcygHdJ+CzzH6/kJp
D35jOR+GgusR6sM5b09Uty3hOui7O802hZQS2+Bke0uQ/RtZGU+fEG0bOHOe
53cF4/cl+E39LPVnKIOa2kYwDnqNlc0dfswWvSpsQ5Dt4FHwq8d6UylX665i
TRmsvYg1LgOfpdDsecY+F7XtSjauq1lfd+gVgXZ7WFMUwLNpfzPNNus3Wesd
1KeI9oxpzVxtKPHUl5xrW8LdUevWsinkM3ce5Vbm753qu/bWqM9e3bl/0f8a
aNQcen1B/wpoPzVsW/3T7I96yHJ9eNgjxnusSntkCZm9qjljOD/rgOuF4DSu
rm3I44F9b9S0aBVr29c90Pjm+raBzWFsLPvhNPK+FhghcGtX5Lu8D/glshfW
wYMT8De5oW2543Qn17dNd0jUOr50e9GgFHzbU+aB61zKLbS/zJzHwGei7JvA
/pz1XAv8S1Jtu5oP/E8SbcNqwNrrS9+A3iOQj360NUfGF9D38USfNdWhwdra
PnOqhG2Dk+3tbuh9N3tjWMRnSw/k7W323gWZPguHsF/+Afaz5b4r+C+oQ9sE
xncC3q7Ktg39yx6uW982onho05X5ztB+lPXezvxpRZadYczfjfE9AHQa3Su3
im2To0qty8pG+XiFbX6y9fVo6ruyDmseUtd35t30XQ69Chl/N2Puk70B/KsB
f57uJ2i7Axx2cJaVs6bF0l+itk1GOA83MP9GdJBlvEVXsZ/Hwpu7OSMW1jaP
CsF1QbnvnkHQ/HrwW1hgW+3l4Hcj8rxJNuM02+T303cf5S/Jhvw7tG8Bn+N6
q9I+R/qQbGCx3gND4E1NcNrSxD6XW6DVrZRi5o9Usm7eIde6l3T0keBXqaV9
X5LBfH6v1J1G/wXSSYE9P2rb8hLqo2W7ouyD96O15+j7IGtYCj1aMOYD+l7e
0ra0rWm2lbxLCSfZZjIC+a3BefEa7YWyQSHvTcK2pbak3E77Jtp7sf9b0b4k
z28GvRV0pi7O8x6Q7N9GvWHYMAVLc1zJ7xWMv4zxzam/S//+6Mh94M1g+tek
fw3Ki8jmYGiewVlzBPl6pIZ9DL0Y3zbfukyG7gxkoQp9rqrsO3G6bC30qcX8
lwMvgbatGfb9zWL8IyH7dOTLWZVoW594Jl7J5jeV8cOybJsZxnuoq97iwPi9
st/wOvvSkaElNXwGPg682SHb8tZTujG+O+Wl6rapn6HtNKVJkm3Qf/H7T0rD
JPu09utszrdtZSw8Lwz7Dtfd3Z32z7hbXoYHF0H7/dwxFyIfo9radiqb3Slg
naSkJdlmuEHvefEL2m2n/i34Z0ZsG7yRPbMQ3AqQh8fjfac+z9j2yOQ7qbYJ
TYMWcdAnvp59XHOhXXm+327tgdcQWPUptYGXC893gt/nlPer+s04if7Pg287
8P0MHv7E2Ccy7AsdJvrn+c7WXd2Z+feXeY1am2xoy2h/F/mfBy2G0L6WvTyZ
+203Y9eD8xfA+zzfuu4x+vzG71OULXq/Uv+Z3+8z5v1435ljoNUI6iOpn5/g
t0H9dNf1RrgWXO+DBqWc5SWUccw/j/aPaC+Tj1a6DvgfhTaXUL8DXAcX2hah
Oz+P9o2sp0ma3/ATmP8+Sgh8OusMom9yln03nSmvcpZ8AP0OQrtfpKPQXov2
AbT1p4wB3nzmL0y0DlACL/aAYwPpx/BkNWOXAyON+Q8DYyPyMJ750pC1bfQJ
QtYxpFt0AMZw6sMohZXsE1/P+ZZSYF3wB3i+kd/DSq0L6k09L2QfnXxzumPS
OH+mtrX864yXbnFvhXVr6RjyNT4WsuzL53g/fSfIB8tZ+QNn+EHasrKtO8Yj
P6Opj6K8Kf885a486zjSbfrJPspaFmf6LVYT/v1E31bZ9nXWkc9Z5026fVF3
QZ8u0COG9ruAf2eKdb1nqJ9Osc63OmqfgnwJ2+V/YPwzlBuZK8IezmC+TOlc
NawDyTb6t95TZ/fDQ/T9iHKP9EVKNfhRhTI2zjba8+i7C/5FUmzDvo3fjVn/
jtq+I3VWDkZ+FjX0mSnf/yD+dm4dxwC8COwXKAPAZzwwl+XYZiZb2UWsNxL2
maCzoEeS93aU0ruy9/gE4F3DmbSnjt+EXdFvlrNfJnK/PcKcqfCv5Ox7ro50
mLDPdJ3l8fLpgttd+bZVdQB+B9a/utRvifsSfXZdDj1fTPEZdgn1y0K2/T6Y
aF3y2ZB95dIpezBfN8pe6FnKfFOQt67g+DyyvRSaLgz5jtbdvIfxmdSnyYae
7PfBQ4xNAZ/Rle1D6YosDOOM2Mf5sb+Rf49iz4xL9t82Rm0TkS1EOvH1rO+G
sG1JHVjzQOm6lEvSfKfIFjQg07YG2YQ6M/8zWX6Laj1PcfZuL/ZZI5vujbov
aI8B3/l6AxTZxijbomwm9+stLJse88/XHOynavTvBrwj0hk4e34CnxNJfk+/
j2wMitqW1ZX5Z7Ge6qwnhf7VG9uX/XSmbQfyad9E/YOwfVXb+dtCcKtGfZJi
D+rZdz8n07ES8uFXgO99OX6biH8T6fvz2fnl0/0WeS2g3iTGOlNvzd/auvxy
4I8D//3Aa5Vsn1oJ7f3z7ZuRjTiNtsmMnwO8PfxtDPVj1P+mXon5JzH/KtZ/
PvT6gPkb0T5X9zntv1T222dwlm3tegO9n2+bqGyhlyKDH7O3W+pOqmaf1Z3I
6v+oZ9B+KzLWk98vw+/WrH0G4ysBfyDwxyc5Rmcg8H7Ksa2ukt4oshewhodY
7+Amvnsrsu1L0x18ayfbJGWL1JugL30fgEYLwX9VI9MqRLkqyTTTW2o/e2ZY
I7+pqsDfTchsHLL6nfRd+DuH++unGNsYWtO/KOy9qz2rvf8JY7bF+wzYwPyb
OjmWqCv8CMPfW0KO5chjjeXAbk/ZDn/y6vssfh14byX5TI4B3lDwWcZefyHB
usqrtC8+235NqW1mspXJJzMT+v+Wad/UN/D3EnTh2Hz7ShWDIt1vdIljT6QD
Ni90jJRio7IYs5exTfhbOr/Pa+y31cqz8qk3Vl9wXwB/K6X4/bEIes4o8Ftw
r3z4tI/McqzNlbqPqOdSfkz2m+lz1p8BvEasd4viReRfDvktu62pfSOVsux7
lY/kv7uHek6K76CbOtDO+JHVHbPTH1yfg775LayTfIB8bW/js/8UNOlFe2Gp
bcVtG/ttUR940cZ+Y9ST7Z/6EOZrxplxKfS/jDKe8auh76+srY98NrQXyEdC
/+egUTL1y2vZl/FQun2t8ml8SX1aut/Wd1FfBb27cWZPhn/D4EE91jOU8aeg
Z1/gnQfsDxXDBi6dKPsYv5TxSxg/JsGxU/soh5IcQ7VJ93eWbdu/JfpsKQvZ
9qsz5hz2TlHUtu0FjH+atu8UT5DmmJy9wH8T+G8Bf1SC55bPTb424SBf3XT2
164m9tn1YexX1AsY/zrzL2d8J3hYBu+uZPy/4BaAQw3RD5lfwe/yiH2X/Rrb
N3lfumOJ5KNcDv9aMOav6vYRl+U75kaxNrLhjgDfxayvFuMXgm+Ys2ML87dI
s818bYHfiHobxiRaNy6WDyTFOvJWeD9bPv8U78HzI7YRyTakO1y2MNl0ZMuR
TewL2t9lvuNVrVNsBf+Hxe+q9iE8wO+N/O3LZMck7Cx1zJ5i9d5J9F2wrsi6
lu6Ee0PWOaVrCqbujkK9mSr5DhkRcQyAfP9Pp9jW9uuF1iVlc9PaH8+1b0E0
yJQ9GnplxNhHvSHLbxLthZYpjoWLg8YFMY6J60LfrpRwjP92QGcd89VMtc1q
jc5qxRik2ue/jvqmdo5t2UI9jf7pWfYta8/J9jJR8hhvG8wJZLdpnn1z8vEF
jD2nnW1nspnJFnyz7JFVbRPOg3Y/MeZkFce0NQX2KvpnM9946HU/7RMKba+U
DbuF5i722Xi/7mzFqoHvycY+s98LO2ZNsWqrwLcj/R9j/JP0nScdhLkH0v4a
uL4R77NhQKF1b50RnehflGtf2nz+1ijLOrJ041G6s6iXlfgsnkM9m7EHwP8I
+M+AnhMijjlSrNErlAdpz5Z+WNUxaFOoR6h3qeoYjXeBvYxyuJppMl3xJbRf
VdVvrA78nnUW/7mUC6g3pf8o2Yeox2T5TaG3RPdkx7LMkMymOKZFZ5feIHp7
6AybGHEMh2I3XqPMo/4WOs8L7LU11DfL/xayr6819TbwshH3ywWcT5WgWVwb
28Bk+/qhpn3DdwFjTop9xOOg/1jKF5yNncCpVol1AN39uiOrctZ9yZgu1Qzz
BsWCKgaisd9Az2ZZx5QudibZvra5ufbdyOcWJ38s8rxdbzPW15P+A2UjqGMb
yvOibcixXP8y/mFwSc20rtJF9gVwjac8EGefzyu0v3Q2vkl35nWsN8x8hcyX
Rf+PaevM+C+47zfT/pr2x9n4GN3BV6JftKE9Fv6fYg0hfj+qGDnW/iHt0zlv
13KH1ajjOZcD+33KxDjb7GcAa9pZ+/fTSfZFygcq36d8kue0tc9avupVtX23
Tsm1b1B37Ar4MQn6LantN+/b/P4TGE1Tvcfli5ye7tgj+STnZFnHl254Evqs
i9jnIF/DEeB9mGUbiWwj8ilJl3ueOebGW6dbTf0V6s/InpRi2/7qdNNSNv6P
QvZR/eebAkZPZGUPPH4R+jRrbl36Lca/Fm+dejb19iHHPv0KPrOotwo5Vkk2
/pXgNwb8fkjxm7mM++j+sG2PspmeKPQe1d5UTHE56/0afOYlOgZmKeOvQ7/N
4ezbnWJbyqeF9lXIpiLd+H5g/t3IOvJC+t/FfDtTHBOgt8k39P8l2W8U6Sp5
lDsTrbPcme83nN5uVeHxB/QdwZjZVR3js5n6pkLHBuiO2BzyHa27WTGv8i3M
jXjvycfwQ8hvZr2VFfOaHfIbSW+jgZSkDNvYZFs7JRtzhmMoFDvxJ/UKzsYT
rLHrhY4ZX0vbx3nWdRSTcLzAMViKvZK+8guwj1GSkhyD+XPIb269tRXjFQft
VsGvVfG2eZ2BXqcpDSr5TNTbOI01DI/3G3lNnveQ9s5IynTZ51j/FPhfjf3x
BPujINexAvHS+YB1POzYOr03PpD9DXivxtvG+QZjb8myr2hlsmNDp0Gvt1Mc
Izohzz5J+SIr6N8a+ItY/80tvCe3wp9t+fYdy+e4uo1joBT7JBvP6ELfObpr
9KZ8P+w3st7Gq4HfIGoflHxPekO+ynq+LnFsWQvWM479eRXtf1P/h/IKbfGK
L4HWT9Z3LHTns+eZYqIn8/vhs/vrQ8k89/cHjK+VZh+IfO8V4Ngt3j741UW2
icoW+h17ej3nzTrKGcaOZ88m0Hczd/zCVNugFQv+WIVt54oJH8bab0JGspN8
Bl0bso4u3fwJ7RHgn4Re3ZCXbuDfK+Q3lt5WMxO9l5oX2fegPRXh9yn696L/
LOShKfCb5dt3qJjIUuhZTDmnqmO8msCfNeynNoz/BR6sgH7vlzk2VDq2Yu2K
kckZdR1zNzTiGFPFlkpn+4C5VnVybKrumJkR5wQoF0B3nHIfbuZv01OcAyFd
/DFoMjXeOvk1WZZ5yfqb1BfoLCr0XaKYlOkRxyAr9lgyJd27H3+bmGIdfBrr
7ZtlX5xspH/Q1k1vwhifsd3hRR/G/8Na/m7su1o6gnQD3dnyVe+m/3dJ9lnL
FnK4wLY42UR60/9v5mgI7/tRX8Za3+vks3INc66jfSJjbgD2Ttqvph5LPYm2
hdDoefAZzPxbUhwj1a+l38x6KytGpCf0H5nu2Msmtf22v4b5JqT6jb+ljXM6
lMuxNd6xpfdFrLsoxvQjeHW80LkaF4HDLRHH5CsWXzQfDbwdxX6r/aU1yl5C
2S3ZSXSuwf0R6xrKOdjK2heDY5t6jhmSLiOdTrqcdJrFbazDSnfVGSDf9/CI
dWH5wN9tYx1Fuol0zmbav4X2HepNqrdX9Kw86Q0m24RwFG6yUeSw9hHU+1Zx
zMDX8q3JhsH5f4D2b1jvnjLfXaL5XvEaeFPr+o01kbYfw7bl6M64K9NvNr3V
lBMj3v5U4Ngg8Vi+u6sy7euSD29ZG8eMKFZEPpn/yVcNPQrqOYZLtmb5MOS7
kM15bMQxfIrdkw2uX6ZxFq6SKZ3dRdnObdAZ3oq92DLfvstf2Z8Psd58nYEx
PiMG5DimRbEsyjFSbEv3EtvqFOMyk/Pu0ahzfcpinbtRcVZfUA7H94w9oHhY
2iZAkx7oc7HSYXivTW149izLc6yFzrQVOY7JVCymYhCvZS0bWNMx1jJe8a9F
1pmkKymmT7GA5xfa1qCYwAdyHGOoWBbFJCq3akuxY+eVY6XY2Lg8x14oRla2
eMUQKXZINnntLemw0l21x5QLtrvYuU/KCcvV3sjz3aEzQ7GLF+Y690QxjHsV
35rjWA7ZYHZT/6rItJHPOJWzdmuRYxX0Jp6c4xhIxT4qB+UP6PNne8ceK0ZC
b7Uf5D9J9ZttSY5jGBW7qBgcxb4Eba3rKQbmY+TlHOBl0H8d9RcUS1NkX7Pq
Z4B1OmLbuWzWhfCyqMSxUOvBt79sJ6X2DcyRPUD5dNqTcfbxbEZ26hc5llM+
/o3M1xt9+us6jnEUb98odi6ReKyz73fma5LqM3Ad/ZuB7xdn8dVbQjEqik3R
m2Jlun188u3JJ6tY4bFt7YtRzPCdwEth/pJU249i+B1b5FjYFdCrAe0rip1L
tJD5L0OWL6ckJ9jG9inz35Fv3esz4P8WcQyLYleE4z3QfhRlST3nhOguukVv
lCTfSU3Ze4OjjkVQjKFit7sU+i2lGG7ZFv6VTKbZxiDbX4OIfV+yAcrWp5g3
xboJn8foexFjjsX4TX2jYsPLbLtV/Ghv2n/NdmyRclY2yHcYsi4nm+cDyNOD
Ffb97+dvL7C+5fm2jc5nfZdDz8Z5vkulg8sWHBO2L1Q24c7p9pHINyKdXbpI
rbB9tdJJ4sG1A/j9HGObjWIFXi+2LVkxAy1yHEMg/UAx37LFZYbtG5BNbgXr
bxm2b0I+1wszHTOgWIF3GznWvQh8v0hwzPsT0h2AeTzGMZ67kK2pRfYFHIix
re7csH3BstmdlG7TgT2G7LwHvHPAN4g6VkE8qAKsx8KOdVcO0J+sd1HIvgT5
dOTb+xvdpHtd+/iqhx0jqthQ6UAN9R4tce6IfDifMHZryLrzr9SHQ+96wHiJ
ac+FXifKjZNwEU9lS766zGuVTbkH/Xu2ca6kYmhHtLfMSlZlkz1W5Bw35bYp
Jv0QsnM44rtRPp/ruavLy6xLXcSdfZ1ig8usi7WnfjfjE3Ks6z3Geu+mbXiZ
fSGKgR9Pe5Mc57opvr12jseo7yztKXDpV2Zbdm1oMlv+GPr8GWP6zKPePce6
q2zsYfr+m+G9pz1SRL1ypm2dDyT57Toi3745vWFlq7sgbN+wbHY7ON+PCsfG
jmErYmxqrnUVxaBNynWMos5z5Ti9De3GpzsXQz7zbNpyCiwbejMod2Zl1LEK
yqG5lL4LtCdiHfMyHPhHw87N0J2uXJS/KxwLpJyUXR2dk6pcVOXUrQfWhqhz
mxQD+pViizkDvm7qnL2l1N+OOpdUd9w6fn+neKumzom6F3gzlC+KbPxBfZN8
j2HTRmfYUmRpH+ftqQbO8dPbUzmeyu3UG7QY+swodKyNbDzSvRWjrdhs6eAv
Md9q5mtXzzmO8uVNjThXTz69t4D/DfB/aeAYj3uof0Z9D/U3pIPwe03IvlfF
QHSEtzOKHOuoPa+3yu6ocxn1Zjmss5L5BsbZZ/c09WeijiVRzIpweaLQtjPh
JN1Nd4ruEulwpzvYhyTfkfasdBnhJFyk08wuccy8YuUfrG9b8wFKZqJtzjOi
zuFW7rZyjKe3tg9HvhvR+Ab4eVOxc7eOKp826pwP5XqcTLMvaA3wKifaJ6S3
707+tj7Ob+CJ/K5/Vj9TjmR72aaLnRupPb4T3qS1ca6lbNTdw94z2ivyQbbi
dwX0G5jqHADlOhyvsC9COQ+XUP9cOlI95wDrt2KiFQutv11c7Jxs5WIrJ/hz
8DkXfC6S7Vp3arZtMLK9SCe6qNg5xModlg39UeRlV6Fj8xVjsQhaJckeEGcf
wMGI72DdvdIpEpRLQ/1KcA1T30X7zojvHuH/P+nizNksxj6tW+j/fLbbJqd6
bHyJYzEFYyHzJTDfTXH2Ccg2vDZsW7BsxAcZ/0BL7wXlYOwH/j7FjMZ4DtH+
iRLzXjyQ7b2RbOCJtsFrb/Updm6k9tinjN0ecWx0DdlPpPtDv+JEx1TtpX8P
+u9McE6p9m7fYudOag/LVvQS8nC0rm1GVzJ31xLncn2jM7/AOX2yNyhGVLFF
HyIDr5/nGKPPmG9utueWjWc5fWfKH3KOY7hrst6Psp2rtZk7dia8fpTyImv/
GHmpzv1Xg7Ik1jlS+7Kdo6X7SjJ0SvHohc590RtZuWQzw7b9KadsnXJJmfNQ
Tdtcmup8LzJsxWyvpG1JuX2ZK+MtC4ei3guSiXboVkOLfPZfBs6nWzvGULGF
WuP3zJ9T6NxW2ax3hBwTqVhI2RT2gk9yW6/tNmDUg3YNSpy7rxhZvf13ZTs2
TjaARepf4lxBxRgMKPae1V5VTNe/7Ic7K+ybXKr8ZvqPz3NsTS/gtwSXVoVu
E08eZC2Tov72w7hYx37mFvmtoBjQEel+0+otKxvi8qhzGJS7oBwD5dYqpkmx
G8qx3cpaxqU71/dGcMiH/+W5zgWZDP8L0UcilO9rOqYzRP9wW+sCimGtCr3X
drQtS32UiyuflnxZyskdUO6cX+X6Kiend7p9YPJ9KYenNrgllNg3rDNJuQ7y
mclXppwH2T7GZDm3Q2/Wh8F/E3OcqOGcr1rpjrlWrLVyxq5lrr4Rx6bJRrEa
frzRybn7ygE5neeYTcVqag92THfMumLVlTPcDVnoTjlaxzL2M/unWgfnWiqn
cliubfCyvStmvhn4NTnrb9A3Nl4psIxJthSjmkk9o8BvQeUEKdZB3+hQrIHs
qWfyHAOq2E/FpF+T7hgIxT4o5vkHxlaF/3WTneP6XBvb8GW7V4y9YrPuD9mX
phitPtBmcruzvpZUv23b5fvbFnrjFum+ivrto28U9ELexxXaV6KYLO3Nwqhj
w7VH5XtQDJFih+SDeDvdPlb5Vnsz56p0x6QpFu1W6iOh3Ygyx1bJZvB0G9vU
ZUtXTJ3Oqv25jkXTmSVf08sltgXK5zQSXpUWOxZVMV2LmPvFdH9rRDbnBfzu
lmvfse6IA8z1XZltQbJBD1SsQMhvA+kYihVrW+TYaMWMnSiwT1r2LsWwK1f0
4TzH2ilndHG6fbzy7fagvWHINibZlnQmVyvyNzR0vCsncQL4r4k41kw+qsX0
favQtljlhDwCv39t5W8FKCZEvpTTrRyLLp9KIbzpk2HbgHJsD0L7OrLZxTln
szP8ejfqXGF9o0K2UfkY5FuQjTTC+CVt7KvTm+I/21KWc2NlY7qN+dZl+65T
DMgY4B2I+qzXnTVCsQBh+4rks5fv5kwrx0LJh6NvTXRERjJr+ZsT2dSz8p3r
qZgwxd7cEfbbVDEOlYocY6TYIr3JFcumO113uWLaxkLvWzOdS3AC+WgMrEb5
zsdRDuqDtGcXOdbjjHR4+o6R/STJPrNHQ84JUC6AvuEi3+YVbOYTje3jvJi5
uhY711p3YAf2QlFr5/rpzEhoaxuBbAP6JsWyXPtY5FtRTKVyqZZE7AtRTlXt
tv4mjr6FozfaLObuF3XssHKs9G2bhnmOtdQ3bmTrXMOcreva5tkDeVwccmyH
dNLHCxxjotgSfTPk3gLHFMm2rxz6Cp23rW2bUk5EuMDf8NC3O2Rj07djimlf
V8ffkFGuWcscx1Yr52wT9Hqp0LZcxXwWsbaphf5WiXyq8g0qJlyx4PIR9qb/
44X2nZZWcWyebCqij2L0ZLsYlWXfoGwYyn2pl+ncAeXAyJZYXOzYS53PHdr4
DtHdIRu9cpOUQy1bhnKU9G2dz9rYFqFv7AxU/HuuY0ekow5lPXe18902lfXv
YO03t3Xst3R4+TJ1x+tul08zNc85Vsqt0ptnVtjfwNC3L5TzW44sF3fwtxP0
jQqd1fKxxJ+1p14s3mb6bahvnoxBFq8O2bavbzQMYL7+7Zz7Kh/O3fK/UObV
tM7THd2gZ4ZjUxRjqVjG2mF/e0QxjbIlZYR8NsqmpFjEzW1sS1ZMomLl9Y0U
fRtFMfMXA++i9s5VUAz4Ve0ds6hYRcXA3Mv4buAcQJsztCcDOyXks1hvFJ0d
dUM+u3SGLIS+8SHHEinmdFg7x2wqVlPfcDlW5pxy5ZLrTXoeuJ8fdiyy1vhQ
lmOkFRutmI4fGZ8UdS6e3sjaez2y7dvVHhRux9uad8JRuQ5dMp1LrpyHTvCj
Uwd/60TfrJAvuCDTsQjyCddo6xxz5ZYrJ2Nk1N/8QMT/+4aSckGVsy5+KSdU
vizlJCoXUT6tTegiGzo6t0I5DLe3s09evnjd6bNZ25gynz3KMb0QfJp28LeO
9A2tfcC+LmTfj2JO5KvcXeZYHPksVwNvfdix49rju6k/yvwrUv3NrAXw6sX2
ju1WjqZiKxQzMf+sv+PIheaheKdvTulbMLWjzrXUN2FWtrNPXb50xXgsKHDM
pGIlpbPH0rcix7Y05ZQqNzMnZN+nfMzK1XixjW1hytmQ7jCtzL5F6RDK3Xup
zLFpyuH7MdM+O/nqFGPynWK/Q44dUkz0A+nOkVBuhL5pkwAuHxbZ16ack7Hp
1iGlO+obNHuo3xRyLKh8oFPTHdOlWC69aVfm+JsN+laDbI76NszmAn97R9+I
WSddKepYUX2T6nZwG1TmWCXFGLyArA5Kd66hfDqK9b6m0L4hxXzr2z1Tc50r
oG/4zGTuR9v6W0XKEX6N/telO1flvxiLXOe8KNdFd5xiBT6MOhZaMQN9s+3D
ku9KOTnyLS0tcyycfEwPc148km9bmL7xs1q6SJlj0WYnOnZBbwa9FRTD8AFn
5cpi+zaVw/oofR8rc2yrYgDmwP/lYftWleOtbzsoR0O5GfrGw1fgfkPIsBXT
fltbf1NI9gvZfLdBi+2F9ofrmynKDZiS59h85QjIdt2ptb9tIxv2HNY2KGxb
Wnd4kpVln5Z8WYrJuUe6Xsix6PoGxI/M9VDIsavKaZ1V5JgWxbJoD9SAt1PC
ttUph0e2yKo5fjvrjfcwsB8pcyysYl6nRJ2zo1wdvRH7M98NbX0XKcakUzt/
061n4DtP3xKYVGbdQN8UGB32m0lvJekIP9H/x07OhZWN8wL299Rix/Lpm2b/
B1om2FU=
         "],
         VertexColors->None]}]}, 
     {Hue[0.48851812441339065`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnXd4VcXWxg9g6CRASCNICjWkkkLqOUlMAti9tmvvWBHbpSgoVkRsFAuo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtm3d8VcXTxg8lhSIlEAhFShAhpJJCbtpNIAmJnZ8Vu1jp2OhdARFBqQKi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         "],
         VertexColors->None]}]}, 
     {Hue[0.4341367216882153], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnHd4VVXWxg8tQgwECIkJoSWhJIRwUwgJCTe5gSTgqKCCFRVEBx07WFB0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmcz9Uax7/2GQ1mjJmMyTIGGbP8ZvEz+29mMGPciuoS2rRIqltIcduv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         "],
         VertexColors->None], 
        PolygonBox[{{13630, 13618, 13617, 13628, 4332}, {13618, 15723, 6285, 
         15722, 13617}},
         VertexColors->None]}]}, 
     {Hue[0.368879038418005], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3d4lkXWxh9KEEIKEAhIIkmAhIRAQhJCQmJeQgmwnwgurL0g6lpwBSyw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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmAztX+xw8zyjYYxiAKJRmzPGYez6w901hmRpco2rSh+qU9lVb9uknd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         "],
         VertexColors->None]}]}, 
     {Hue[0.2927450746027596], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgl01dW1xv+QBINCwiQQwpAEoQRCwk0IN5CXEAypKIh1nvscuqqiRVFf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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmUzvUex7+YYWYyM2QbM5YZuo5ZzOOZZ8ZgmplHY46ktClK95Z0kpQt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         "],
         VertexColors->None], 
        PolygonBox[{{13685, 13223, 13222, 11855, 4380}, {13223, 13681, 4378, 
         11854, 13222}, {12930, 13737, 4420, 11902, 12929}, {13735, 12930, 
         12929, 11901, 4419}},
         VertexColors->None]}]}, 
     {Hue[0.2057348302424791], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl3twVdUVxjchiQQDIbmBEgKGvAiXExKSS8gNeO89KYnU+CihtoxSqoSZ
lo6gJb4GilOqgZHSaumgf9SphPqeWrU4UgniA3WmrX3JCONMY2esRdSqtDPF
KTOK/X185489Z5991l57Pb717XXqh25cdUNRCKF/QggTeY5PC+GJshBaeG+s
DeFvDSEcKg9hzpQQ1k8NYVNJCLdWhDCfsYX5we4Qvp8LoSkVwjWdIaxhrEPu
Up4DjNXM9/P9NHJXI3NxFMKXMiHUsb+4PYQfxpxXGUIG2cWM5chXdoTwxSU+
V7aMsPY0ZzViwwbmw8wvTIfwfuz3B9Bbhr5fsV7G+onYtu7j+QN0/pL17Twf
7wrhDtZbVoSwiDNOoj+NfF/eZ3yEfIr1I6x3Y+dU7JyF3gvaQjjaF8K/ic19
vN892Tpr8Ol76Bwlbk3I9rEnrdig5+OFjuUN7I04byk+fov1h5EvIuDTqkLY
M9nzBvb9emkIz0wPYVt1CD9N1nW21kYm4SOxqiv423fReYiYZitti54TkN/O
+lPoX8F7ehY2sn/vZOdkJMnLYE0IvyBejxHXtcjXY1sr8vewr7ifuDBv4pz9
yL+Lj2vx8QHm48yPlDlXWbCRJ26lS4yTncisxp4J6L1yWQiXMVbOCOEMMfmc
2L6BHS+x9gZ+HkfPlcjvjIyleXzfkcxna2/W+byHtaYuY2wd8m9Htmev8oFv
t+PXb8sdY9mg/Mk+4WQi9hczJiG3kr27ImPm7QrHT3qe5Yxv8/4P5h/Lfmwd
5P11xtcrbOcH5LCh0/FfhL72guM6h7WLGIs481Z0r814z0nsf59xFt/X48fL
zA+k7P+2yY7hBHQUFezDKmQGkXkImXcasYXxJFi6N+W56uUU38cj21m8OIS5
BfuxjngfjuxvEesTGeOsj2DLDsZtSY3eltRpOfYuwc9/UUNzymyT7Nmac6wl
8yFnfSfr2Oi5NO25auvhpL5WIvMi8geZt5Of02D6XXJwYcbxUqyE/QV552YQ
HZkuY6akyjlR7lrK7IdyoTpQXammnlbNFfyu/IwnOfpNhTlD54onzi42V7y3
HLy0gp86ntTQPsbj1Mz22BwhfjjFfC++j4GXT2LXuWpceNk50zE8PtPYr2Jt
Hd/XMgbgv1LiUJ21vcOx+UXcchZ9k7KO5XuxY6E4dKWde+V9K/Xx+7RrU/jQ
mnAlPMZ5Y1KxOdLn+GzUOawfQu5n2HP7XPvSSEyWR87nN8jXwci5WJg2hoQf
xUZPxUecLe5WrqVLdaIa+St2DmP3f8jDceY7uv1NdVxIW0acPavbvD3GWnMP
eag2Dz+XsswZZKLIuNB+naH6HcbOkch5+wl+XQu/tBHTw9i8jfnf8Wkz648i
dzcyX8bXsnbn4RbWH4q8rnOeSGo5wEkb25yXhtkhfIZfe5P6UJ2oXuTPs4yP
8Hc58ejL+ls5+17rcxzFk1uqjTHdI2+mHPPzd0Kn7wXhU76qVnuIT5YRcd4p
8roJ3nwBGz5kLR07vuIS8bUwXIRPGeyvVm0y38r8aualK3x/6O4Q97+eNrcr
h7XLnMfSLu/X3mbmd2Z8xypOiotiIn66MTJH/bjePKg62lBtuzX/ObH8X96+
Fsjbi73czdXm1Hlp8+oucnsXo4j5M+g+wBiodGy0T1jdj54ZBdflbuaf5R0T
2XVHYpu4fDRnPG9A/8XoP5hyHYr/3gzmrQ+WuX5153y1xvfOReiry/v9GPte
xc7fzXYtyV7ZcGw+fmEbx4ZLkR3IOwefEvvNnLsHLK1g7SuMjaw/mPJTOYor
rU93n+63XV2+40rgicuxZ3CGOeyKZa6XHLEajR0DnS87xI3CxaNJz/AqOBpN
uEW9QH+Xc/oC8+ty5hHxcVPeuH1OtcVoxq63Mu4P1BvoXtT5uHf+LhUWhUPd
J69lfKcsiI0zYez6NteA8K+c6Y5Vvzan4BzLXuHzcJX5bazWdaDaVw/1z9h9
lPqg62Lj/wtsPMcogYu3tJnL5HMHa2s63Ou9zJkv9RtrN7HvZsYQujs73D+p
d6otuBdR/yGsiC+F7TOspfOu4X2V3iedU7DhL7Htq+f7XMZKcraEtW7Gglpz
qzhFfJLvcW6UlwI2xt328w9pc6twIrzf327sbu53P6de4DFiuTupnQjdrYwm
9Ldg/+XMe5jfy77Ggnsx1bKesl88LlnFbT7nH067znqZxz2u+WbOvT5rrpIP
8lPYvgbdaxiXsH9T1pwufmxEviHv/kscvDnhYWFnKMGPOEv8Jk4TPwkbuiPa
0LeQ0VxrTIwl3D693/2lekvtF48KS3dx5upe61AtnJzp+0s1cK7WWAr4VNXr
d3FnTYKbo9jySs57WutdV6qpYuJWF1tuUru5W+epN5xdcL00J1wpHK5H/qq8
fVAvqR5OPHkick8peXHMaLux86PIvZr8vb/LvsmvFubzGG9Nc5+o3lHY+BO2
/Dl2LNQX72t3DjN8L+HsA1XmNfkv32XLUIftyeH71/D9CjhiMfKd3ZY/DWY+
ybgHPMrzlYz7Ht2TFR3G5YmUfVRMdDcIK+olztLzPN/nvAgL0i08DKXsh+pF
fCGMS1731ztJj6e62ZP8U6hHky7pUf/eMss8pt5EmJKeEuyvwf4izojwvbVg
ueGc+VHcKC6WHao7cZD+zyiZ833NtUlvU19wDQj3wvJVvcZzG+sLGfPR+Sn2
nIOsvsn6U+h/MudeqbTf/w/C1PSse1P1c1OZ35ncp8qZ/mHUEwrXur+F7bKs
/w3Ugz6PvrGce4PAelHaMVOdNRdca1O6fafqPhVn6b7blvz3iLfEAw0F947q
G8U9/20z/6j/Ex6Fq0fAUTm6/ihKzfv/UxwsP4UTxflm/Lqp39jvzbuWVEfH
ZG/Gfehu1laljYUBYnlZwif/B7RfRAk=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3tw1NUVxw+RAFFgAwuUJGDIC7JsWCCbsAtxH5FE2lSqsQ+m1VaJMw7T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         "],
         VertexColors->None], 
        PolygonBox[{{11900, 14348, 14347, 15804, 6366}, {11175, 13709, 4398, 
         13708, 11174}, {14325, 14324, 14323, 14326, 4956}, {11183, 15803, 
         6366, 15802, 11182}, {13743, 11183, 11182, 13742, 4423}, {16460, 
         11175, 11174, 16458, 6969}, {14348, 16664, 7170, 16665, 14347}, {
         14324, 12583, 6969, 16459, 14323}},
         VertexColors->None]}]}, 
     {Hue[0.10784830533716358`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlllslFUUxw8t01IYih1Qlo60pXQZm3aYGYYZtukgTFoRNSyJMYAsEUsE
2kYEFTBxYQmLcYkkJC4UeEDqQgISIyCiligaRSvwoEIwAk+GsogxPqi/k/88
3NzznXvuOf+z3q9qacec9gIzO88qZG1Nm7VmzM4NNZs50axnmtnmYWYvZs2W
xczay80egY5C56DrkmbVcbPxpWa9CbN66MnQfdCzoedD1yH7Z8rs56DZU/A3
N5gtH2L2HHrvLTN7faDZdM4bkTsZMjvI+UH07kLmIfiPwT8D/62o2ZpWs1cG
yuZP9bL7FzprwNqLfEfObDXfbdC3kPkSegB0Aj0fTjLrBsMV8J/l7nfg/yZi
9hk+9oTNAuPNLmD7IvLt6LnZZPZeiVlxC2esS2PMdoNlBxhWDTbbg569fHdA
34L+Zxw89PfMMDvF2lBp9hV69kbl4+GkbLj+l6H3Y+tV6A+gDyXk753sJ+Af
CZg9Cf0R9AHobui/U5IvAsvQmPBUQFey/oM+Ss72lAmz6xuak86rk806+V4G
3a+Zc3R2oXMK+4/wh0MvHaz43ehnthb+NfgL4J9vUHz9rJr9genysQiflhOH
49i61aR4ud0ucC0G5yXy9Sz+X7mDvA0wW49MCJmKEvk9Kytf9kUVI4/PdWTa
0NmNTAodSdZh9HSwDyKXfdBPUJ9zydfH+FoKXUz+VkCPgBdMS/9VdF/OKr//
Npr90iIM59BxX1rxXMP5QrCOxu/OCWbHIvK9hdqfnVb8j01VLXoMj0Yk5zLf
h1RffreNGp5RLn51RvgcW9tIamSI4nOSWvictZ54TCDXc9A1Efk0fgXAcCCo
O1Xo6Q7IT/fb+a7be8L1lyJbl5Wc57NwvHLqveSYHI/Xose+hKbeSW9cCCm3
hWCfgt3afuq5+9HxR1AYf0CmFpl5YfWZY7tNrGamhcexXM/jCcLvTOn7UbAs
ykrXuGbNC58VleXyx21VgXMTqw47M6nDi/WaD0eJxzHWM8Tkk5DuuPxd1MIw
1ln4BeyFrB7oFdRG/zw9Gz8eJt9zw5pTjtsxF3MeYJ1C5s2kasLroSyk/va5
keHuPPgPhjWTbufn0gtgeq1cff01OiYjtwvebvzryuosSPwzKeH1PnMdXqvz
8S+XVk95DvzcffFZ6fi8lsq4ay3yN4h8UUyzqH9MdeCxfTorG37f+8b98/q5
Af8maz81/Cvxuw7dW6756/Xndq/B68vzl7AvZs2C3pdVT3pNhEepJjwOg4hn
LimdG8EznTqvCCi3FVnld0tKM3RAvsbcN/ernjzXTpTt7Wm9Ge5nBt5p4rYO
/t3UQ7hZNldx3hzRfPL50TVJM6QNXJtaVXvTuPttRG/CNPoom1EPeZxq4oqV
z+/ShGiftY1x6XkeX16CripRfy+Mq8fdf8+r1/kcdL0/RPk6gq/huGr7SEo1
6vV5My6f3d8FMc0I93kb8huQaYe/E/72VvWU87Ip8fuD/XKLbHlNbU2qrnyW
DE+oBk7me9F72WPkden15vPpXL1mVC1+17HmjpSdN2K6s4RZtJS1ZYTmbnFU
teE2J8Rkd/VU5dVz6r66rOv09+qdmGx5rztej7m/LdFmxWosew1rzCj1/ZiM
4uM1ezzfp6Oha2Pya3lab7nXhc8Yfx8cZw33xmYU7z0xvZE+k/zN893n0pn8
vPGe9Tnqvvrb4W/721HVZ7BJ/rgvPtc3NKmXvV4ej+m+96fj9bfD340bTcpv
c0pz1vUX0csrmzQTHMNvIeHw3e877f8La7PCkiImtdwNBmTDY+V6Cpi1Gzlb
CX8b59tZjcyAOFgaiEtRtf53rqX0z+PzY29WNtZh/3ROc7fX+UnFoSOht9ln
uPMO5fkniPenM/R+vovMIu4H8GtqRHPcezCCzXvydvs478xpJvn/l89Zn7He
owXN6lPH9XuLsPn7vzChufEFewPfBdCVCfWD98L//0GPDQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltslFUUhTdIEbSdygAitEJbaMtk7JTp0A4VOh2kFY0EFUnUQOUSsRgu
NSaiAgYvgAIxoJEEI3KNUarGREKMVFEBE9GgQsQHEoxGeTNyi9EXxW+5+rCT
/8zZZ521176cqV7cM2flwIh4GRuE9aUiJrZGdI+IuDQgYmM6YnY+4ttkxNLy
iL/5/gsrGRqxjfXepogJ7RE1YyJ2JCKSnRE3Yj9URYzDZ0EG7Gb76swj2Yg1
uYgVrOvKIha2RRzpiHga/51DIvLcv7MxYut1EdvBmzgzIsuZSVg933OnRyyb
EtEL1uzKiM18P8Bvc/k+MzxiA9jrsXEl+HPHkqx9tLeyIuIzfNtbjX+cM6uK
EfPxGQuXbvw/hUsOvudvMKcEWHk0KAWvtzSiUTz69ekEL8N6Bnp8jj4drDdx
thqeV2sizuJ/P/e9xP2fwPe+St99M3pVjjEHaTG40fvSZCF81qHpc8Q+C7wX
+E5wfhn8q/H5En6laPo2Wq2FXzt6DW4hD8MiDuOzj/N74dRT5nxsgvs98Ps+
afxd4HWxPpe0vvWFiOXgvyt+ozH4toFZR+4/Gu69FVOMLZ+BcB+A7SmxBpXt
xhSWYprKfSOJ6RD7o0oc+3Tu6B7tGDtZP1i0dsL4EL0OYj/BbSiFWIPv+ILv
7mV/Bnjjwdtb6px2cXZR0dr8zm/H4Xs65bMb4ZPG/88mnx2IzWFvS3/+W4lp
Ans9xH+B+A+UunbuZv1d0jX0K9jnsZPgnyWHa9G6jxrdUe56ngC3Pu54j/Uc
YhpOra/JeE8++9B+P+d/TjoHV2+PGMZvT1UZbyF3nernK5/LnO3pdO1J3zvA
n1mwfuI8Dd+lU9x7ysl67n4cPQ6wvxzbcysadLgWpNFl7j7Wv1aNdKLtUdZr
+tfFgmtCtaCcPMH3vJxzMR8rgWsu71qXPuq12oJjVc99A5+3wLyNensGvev4
rscmJ9wjtU3WWGeFcRLsixmflWbSbhF6vniT11X0ytiZ7hX1TJG72/PO1Ur2
G+CzHVtc5h5TbFeKjlUxfsH6UtGxKcYWzpZy/0V8D2L17B1Kux6qyemZieak
uzVvFuU9w9Qrv+C/j178qtPrV+nPY/gezbmWhpS7lzanzU091dfhmlFuleNr
JuM72blZUu7ZuSHt/GqGqvd+ZH263D14J/PgTJPzqfrdA1Ybv60g3lcqPAt2
F/2tmfABWj+b8SxQvf3TEPFvg2PRzFJuHsL/rgrnaB2+7zfbV2feJL7XsWFJ
z58t7L2T82xuwP8Pvi9g8xKuB83Ce1OeXcJvIRerM8ZW/y1u8wzX/crpJfYu
ZDyPlPMu+M9vsh6K8VHqKZF1LtTjtcyPYqu11htSiW9Fk/VWzjTbCinPemFq
9mrmatZq/jzMd3fWb4l6+FzaOVUuNVMawZ/Ubm11v7QtYKtHWGO9LduIcWuz
3xhxmd7q2hanI+A9X/TboZ5s0VuQc22r3mvgNihlLZSfWs4eTvntVI5H4Tst
7Vmo87PAqs+63vUmdrG/Km2t1YMnOLu6xfkRR9VOXcGzWTWk2aGaUTyaISeo
1f2N5qqcjAN/UNb9px44Bf5pbGrCHApoU8Z+FfF8zP5vRc8o1a9m3mtZv8Ga
5+q5x8C/kvFskv7XNrrmVAua5134P1k0lt7Q68ldPu/e04xdUPTMlj6qyZHg
vdHsean/CA3439Lk2a6e3pW1ptJS+alj3ZuzVtJM3FVDqh3FoFrenbXv/5qh
3dcpv+1a/wc9RFhd
         "],
         VertexColors->None], 
        PolygonBox[{{17669, 11870, 11869, 17670, 8389}, {17667, 17665, 17664, 
         11883, 8388}, {16624, 16621, 16620, 16622, 7122}, {10452, 13616, 
         13615, 16614, 7117}, {11770, 17594, 8312, 17596, 11769}, {13616, 
         10460, 7122, 16623, 13615}, {17665, 17671, 8389, 11884, 17664}, {
         13712, 17666, 8388, 17668, 13711}, {11887, 18217, 8966, 18219, 
         11886}, {14133, 11770, 11769, 14134, 4787}, {17684, 11887, 11886, 
         17685, 8404}, {18218, 18216, 18215, 12594, 8966}, {11784, 17600, 
         8315, 17602, 11783}, {16621, 18183, 8928, 12563, 16620}, {18181, 
         11784, 11783, 18182, 8928}, {11870, 18207, 8959, 18209, 11869}},
         VertexColors->None]}]}, 
     {Hue[6.661338147750939*^-17], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlUts1FUUxg8vi9LWCGgkY2qnUHvHSscpKVNjQsbIOHFlYlhopMYgaNxQ
N2oU4wPfT7AFtFFE24BCJKKBaiCgiEZEUJGOC+NO3ZgYeSw0JhJ/X767ODnn
f+55fufc+y+uGr517fSI2ADNgB7pi1haiei4MGKgPWLv3Ig56DejWwz92hpx
LEU8AR1D/zD8SQh1vFaMGC3a99/F+FcjxmZHXNOPL7SMeDuxXQ/9hP0idN39
zjObvLMaEduxP4/vf9CbyPeSczW0qC1iohzxTd05DhLjEFScFvFl8rfkt+BP
Q5cTfxt+Y/i8clFElVrmkOsP4mzk/IvkmPpWfvX4GLpvFRf55usiTpYimpyN
FN1bt+LPs64ZxmbBxfaV7V1Vn+1B1wEtQH8B+dctifgZuYcYJWgn+Gwhzgps
DqJPRZ8Jk5nE6SoZ29trEfVB275OXW+kXAMxqyX3W6CnK6AyeZ/ifH9yLmG8
OeP8Inx38lw+SI6lOC/BdyXX8ze1/wMNkau7zT2o/tPM5cQSz/dwcg7FH0Y/
n1nMx/cFdN8ly+vQz0N/qtNYPprxVE9vV9zXBnRfJe/Seno81Ot86mlTxX3t
IudVyB+G8bun4ryamepTbXdqZ8g1k7zDVe+TZqmZb81z/7Ez14L9bTeAxaD9
+4jXw4x/o4aNAxGViuvUt/DWXFSfviWfI9f9dc9PM17b5h14nj6OJ9eg/W52
ERf9e8m4CJPtyXayOQHfA53v8swm6Jt2Y5I8+1ot7wOPnprPdLc+yferjRqX
VW27qj3vIvotnL+a7D8Kfyb53o3BR5JrfQf+XPL9UtzJnOszdC8nY7U3eVe0
JwfgzybfwUn4+8lYfpq8N9qZ7+EfQbMWRqwE+6F+16W721K27/7lfgtUj7Bf
UzH+qnFrrlN1TeTatGvN3O9KbB8Eh9UFZgE/QKzjyGeQDyOfQr6x6llqTqr3
41zzCGejBe/5poK/hUM7tvcNun9xYSq5g7ens+G5/MWsz/S5xz/JdRo6if8a
6O6CcdbulHNe6VSj7trny/2WqRfhejRj2+z3m6LdKTXy/SH+LVXvpTB5iDxD
FedpaTi38t4BJg/0+r34hXjXDvh9m1737mpvz2F7hNxT2P9eM17C6lJ8r+/1
e9SKvLTXb9aVDd8f7aR8hKX2VjHO1qybgI9XjF/C/uqGZ/118j9Ad/koNYyX
/Uaqrqn89k5DPwM6ws4Mw8/2+Z17l3jjNc9G7/S2bP8DfEeyfUvd/pJ1n6Zy
bZehm1v3Hu4m1+PEvOmSiP8BYCUPvw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtsFVQQhkcsFKTU8DKSmtJaLz3FtJfbptTEhNxErreuTNCN0SYEQVxR
E0MJIGhMXCkCbSEij9pWVFAQkaK8Ki/FCgpargtwJ2zcyGNjXBC+v38Xk8w5
c+Y/c/75z9Qu61yyakJEdGJl2KxCxCPYHzX4UyLeThFHk9cXif+MP4J9konY
9FDE0w3scb67NiLzAPu5iMF8RG9VxKppEZ9ydgCrJ3eUvQ34m7G/KyJOsdfL
+ffbI/rAqyX/S2L7sD+J1YM5sRhRjv1O7t7JEeeIncGuKZecbfgfY69WOec1
8N5rd0xnfiJ2PhlbdxzAP4htBbua9+3h/Aftfs8vnP+W2FqM8mKkLuIb/I3Y
MOuJdc79KvmtwtiDvwt7lPglajiE/7WM9b3HIx6EmwkF55+DwzOLI04v9lvE
R0dzxHNPgTEzYlllxGOsh56Ew4cjsqy/AOvz5F6oB+L+QnKtqvn/BRF34fsq
WCXumw9XDUWfV71L29wT9aIE3gi1rGvy23uofz1YW7AniM8B83W4mJQ1dy+A
nyM3FY01xgH55QW/pQyMAeL93N9dNd5zYnfBb6h1/+40eU9+wk7w9uPYjsnm
axH1VYAxBOFHsY+oZWcynjguwM3LLREvwsd2OPoxuafqpTTUSn4b9s80Y77B
Xf9y574prmEdZ3uT41Opv4O7VuetlxVYF/6bLdbOctaTiFewnsN9R2ZE7E7u
sWoVvnpVajaX6plyOwt+mzAGkzU/Oq7XqZztpL7WStewGn53Za3HLt4wzNnT
yb72fsO/nMy3engY/AOtEc9O9//LNLtG1SbMS5z9NVlr6kdjszUhLSyqdG/6
Od9TZU6H0dZsMKt53yHsOLknk3utnpdnrQGtd1J/PfmVOfdmTJP4L+Xdixvs
zWNdXfT90vxbYF1J1of0sjvrN3eNz4v/4GJ/i892gHEB7gaz1qL+U4nc60X/
Pf3Bw8l/UmvVs4L73s279gx8vkNsSPOkzn9iOfHn2xyTpgfynlHSkjgQ9r1G
Ywlzf/LMkT6lmYXk3ygaT3/kbPLM0TwRnmbVtpy1Jw1KS6/krB1pSrOkL+e3
6n+K2xPJ94nTz/D3JvdKHN0i/6/x+aEZJ+3vSP6v6le/Zm2ylhSvoba5ReeL
84GsORR3msEz8Nej/9EazwtpvydZu9LfHe67nbc+NTM+JLYJg56xP9it2YiV
wjVotm5Pjul9jbztmTb3XhyIq7IGcy/ObnP3SjhYkjGfMwvWsLSrmr4D61hy
XP3V2VtN9sf2wF+T99/UnfobPyTzKQ1ptq/MuRfqibC+T75L+X3JnIkrcSpt
HEnupeq7in8z7/+s+H1T7ivC
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{11062, 13068, 12550, 12837, 12836, 14191, 12811, 14135, 
         14133, 11770, 17594, 17595, 16611, 16613, 10452, 13616, 10460, 16624,
          16621, 18183, 18181, 11784, 17600, 17601, 16625, 16626, 17603, 
         16627, 12538, 12845, 12844}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11067, 13077, 11198, 16514, 12645, 14474, 16728, 14159, 
         12644, 12647, 18565, 12646, 13179, 12038, 18536, 12039, 11773, 11774,
          18395, 10453, 13261, 12016, 18535, 12017, 12015, 17776, 12019, 
         17774, 12018, 17775, 13171, 16502, 12636, 16501, 12637, 16503, 12556,
          14142, 12557, 14441, 12558, 16423, 11189, 12828, 12827}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11125, 13147, 14405, 16473, 12591, 14631, 12590, 14147, 
         12589, 12693, 18571, 12692, 10551, 12188, 18549, 12189, 12185, 12703,
          18572, 12702, 10530, 10500, 18404, 12598, 11898, 17865, 12195, 
         17863, 12194, 17864, 10555, 16546, 12705, 16545, 12706, 16547, 12704,
          14176, 10705, 14665, 13013, 14409, 12893, 12892}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11903, 13741, 13234, 17683, 11899, 17682, 17686, 17684, 
         11887, 18217, 18218, 18216, 12593, 13712, 17666, 17667, 17665, 17671,
          17669, 11870, 18207, 18208, 18206, 12582, 13226, 14328, 14327}],
        "400"],
       Annotation[#, 400, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10451, 12835, 13607, 13606, 11063, 13070, 15022, 14131, 
         12549, 14136, 12548, 16415, 14192, 12812, 14134, 11769, 17596, 18176,
          12561, 18175, 16612, 16614, 13615, 16623, 16622, 16620, 12563, 
         18182, 11783, 17602, 13637, 11787, 15731, 11788, 17605, 17604, 15008,
          17229, 13091, 11075, 13188, 13189, 13089, 14261, 13088}],
        "324"],
       Annotation[#, 324, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10462, 15178, 12840, 13266, 13265, 11068, 13079, 14417, 
         15943, 15944, 14473, 14475, 10578, 13622, 14143, 14144, 13180, 11146,
          14160, 11145, 15936, 15937, 14472, 16727, 10577, 13619, 17597, 
         17598, 15712, 15714, 15713, 11195, 15908, 15909, 14443, 16724, 10558,
          13830, 10559, 14445, 14444, 15911, 15910, 11141, 14158, 11142, 
         13172, 14440, 10556, 13827, 10557, 16723, 14442, 15907, 15906, 14410,
          13045, 11051, 13250, 13251, 13043, 14215, 13042}],
        "324"],
       Annotation[#, 324, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10503, 14350, 12931, 11904, 13743, 11183, 15803, 11900, 
         14348, 16664, 13723, 17685, 11886, 18219, 12594, 18215, 12592, 13711,
          17668, 11883, 17664, 11884, 17670, 11869, 18209, 13705, 14325, 
         14324, 12583, 16460, 11175, 13709, 11871, 13224, 13707, 13706}],
        "324"],
       Annotation[#, 324, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{13167, 15334, 13168, 13315, 13314, 11140, 13170, 11188, 
         16175, 16176, 14666, 16836, 10706, 13730, 13746, 13747, 13317, 11229,
          14177, 12961, 16164, 16165, 14656, 14657, 10699, 13733, 16478, 
         16479, 16477, 16481, 16480, 12927, 16543, 16544, 14653, 14654, 10697,
          13946, 10698, 16831, 14655, 16157, 16156, 12958, 14173, 11222, 
         13302, 14629, 10682, 13936, 10683, 14632, 14630, 16130, 16129, 11179,
          13149, 11126, 13294, 13295, 12881, 14318, 18403}],
        "324"],
       Annotation[#, 324, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{11059, 13058, 13574, 13573, 10450, 12834, 11753, 13067, 
         15021, 11042, 13069, 11043, 14130, 14132, 12551, 14193, 14194, 16592,
          16591, 12813, 16590, 16589, 16425, 16618, 16426, 14240, 16428, 
         16427, 11771, 16440, 16441, 14242, 16439, 16438, 13636, 15729, 16630,
          15730, 14258, 15007, 15006, 11039, 13090, 13186, 13187, 13605, 
         13604, 11151, 15738, 15739, 14262, 14263, 14264, 13560, 13561, 12852,
          12851}],
        "256"],
       Annotation[#, 256, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11076, 13092, 13272, 13271, 15180, 11269, 15179, 15182, 
         15181, 11199, 15184, 15185, 14418, 10541, 13078, 10540, 17779, 17780,
          15942, 15946, 15945, 11775, 16429, 16430, 14228, 16615, 16616, 
         10507, 16512, 12642, 15956, 12643, 16513, 12036, 15941, 12041, 15938,
          12040, 15940, 10537, 17777, 12020, 15913, 12021, 15914, 11757, 
         16424, 12559, 14213, 16597, 16598, 10505, 16498, 12635, 15921, 16500,
          16499, 12014, 15904, 15905, 15901, 15903, 15902, 10533, 13044, 
         10534, 14411, 15132, 15131, 11190, 15702, 15703, 14214, 14216, 14217,
          13252, 13253, 12830, 12829}],
        "256"],
       Annotation[#, 256, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11119, 13143, 14317, 14402, 16655, 14404, 14403, 14319, 
         15777, 15776, 11217, 15296, 15297, 14435, 10549, 13148, 13230, 17856,
          17857, 16128, 16132, 16131, 12167, 16126, 16127, 16124, 12171, 
         16125, 13301, 14345, 14344, 14329, 11897, 15801, 11881, 16155, 12187,
          16120, 12186, 16154, 13232, 16162, 12192, 16150, 12193, 16163, 
         12181, 16161, 12191, 16159, 12190, 16160, 13316, 14357, 14356, 14342,
          15811, 15810, 11896, 16173, 16174, 16170, 16172, 16171, 13248, 
         13169, 10554, 14439, 15338, 15337, 11228, 15335, 15336, 15333, 11422,
          17382, 10532, 12932, 12891, 12890}],
        "256"],
       Annotation[#, 256, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11130, 13153, 14093, 14092, 13734, 13735, 12930, 13737, 
         12928, 13742, 11182, 15802, 15804, 14347, 16665, 10501, 13722, 10498,
          14336, 14335, 16475, 16474, 11873, 15790, 15791, 14332, 16658, 
         10496, 13704, 10494, 14326, 14323, 16459, 16458, 11174, 13708, 11172,
          13685, 13223, 13681, 13680, 14105, 14106, 12874, 12873}],
        "256"],
       Annotation[#, 256, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10449, 14221, 12832, 13572, 13571, 11060, 13060, 14926, 
         13064, 13576, 13575, 12833, 13608, 11061, 13066, 15023, 16416, 12552,
          15025, 15028, 15029, 14137, 18510, 14138, 12560, 18375, 16593, 
         16594, 16368, 18394, 18393, 16619, 16367, 14241, 15719, 15718, 11772,
          15725, 15726, 14243, 14244, 10461, 16370, 10464, 16631, 16369, 
         17258, 17257, 17260, 17259, 15039, 15009, 15010, 15693, 11750, 15011,
          17230, 11040, 13190, 13647, 13562, 13563, 15699, 15698, 14900, 
         13104, 11086, 13194, 13195, 13102, 14275, 13101}],
        "196"],
       Annotation[#, 196, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10466, 15197, 12846, 13276, 13275, 11077, 13094, 14419, 
         15974, 15975, 13274, 13273, 10591, 13267, 10592, 14500, 14499, 11270,
          15183, 11147, 15972, 12055, 14493, 14496, 14497, 13620, 13621, 
         11789, 14227, 14245, 14246, 13268, 15958, 12045, 15957, 12046, 15959,
          12037, 15961, 12048, 15939, 12047, 15960, 13181, 15947, 12043, 
         15912, 12044, 15948, 11756, 15715, 11776, 14212, 14229, 14230, 13262,
          15923, 12025, 15922, 12026, 13829, 13828, 14450, 14449, 14447, 
         12027, 15924, 11143, 15133, 11230, 14446, 16725, 10560, 13249, 13610,
          13254, 13255, 15920, 15919, 14412, 13049, 11052, 13256, 13257, 
         13047, 14219, 13046}],
        "196"],
       Annotation[#, 196, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10493, 14305, 12875, 13290, 13289, 11120, 13145, 11171, 
         13920, 13921, 13221, 13220, 13701, 13296, 10670, 14608, 14607, 11386,
          15295, 12955, 16107, 12168, 14625, 16821, 16822, 13934, 13935, 
         12691, 16123, 12690, 16537, 10525, 16657, 16656, 14330, 12588, 16472,
          11882, 16122, 12170, 16121, 12169, 17855, 10550, 16151, 12182, 
         16149, 12183, 16152, 12180, 16542, 12701, 16158, 12700, 16541, 10529,
          16663, 16662, 14343, 12597, 13732, 13731, 14652, 14651, 14647, 
         12184, 16153, 12960, 15339, 11423, 14664, 16835, 10704, 13313, 10703,
          13246, 13247, 13948, 13947, 11187, 13166, 11139, 13310, 13311, 
         13164, 15330, 13163}],
        "196"],
       Annotation[#, 196, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10504, 15620, 12889, 13238, 13237, 11131, 13155, 14914, 
         13739, 14095, 14094, 11901, 12929, 11902, 13736, 11181, 15797, 11890,
          14346, 15796, 15795, 16388, 15792, 15793, 14334, 15782, 15781, 
         11872, 15783, 15784, 14331, 16383, 16382, 16580, 15778, 15779, 14322,
          11867, 15780, 11173, 13686, 11855, 13222, 11854, 14107, 14108, 
         13684, 14942, 13132, 11113, 13581, 13582, 13130, 15664, 13129}],
        "196"],
       Annotation[#, 196, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{17877, 12212, 17875, 12211, 17876, 13202, 17880, 12215, 
         17879, 12216, 17881, 12213, 13956, 16843, 16842, 12214, 17878, 11313,
          17349, 17351, 17350, 10998, 12782, 18580, 12783, 12779, 12781, 
         18579, 12780, 13505, 12785, 18581, 12786, 12784, 12788, 18582, 12787,
          10999, 12803, 18585, 12804, 14187, 14186, 11037, 15001, 14126, 
         12534, 14208, 13019, 12707, 18551, 12228, 17896, 12230, 17894, 12229,
          17895, 10636, 17830, 12115, 16066, 12116, 16067, 12113, 13899, 
         16789, 16788, 12114, 17829, 11340, 17357, 17359, 17358, 10978, 11704,
          11705, 11041, 11164, 18407, 10516, 13041, 12794, 18583, 12795, 
         12776, 16575, 16576, 16573, 12777, 16574, 10979, 12774, 18361, 12775,
          18381, 18382, 16595, 12820, 18380, 14202, 14203, 14155, 12610, 
         14207, 12992, 12676, 18545, 12117, 17833, 12119, 17831, 12118, 17832,
          10637, 17387, 11438, 15352, 11439, 15353, 11019, 18504, 12519, 
         11836, 17646, 11837, 17647, 14377, 15107, 15108, 14893, 18602, 14892,
          18603, 10934, 12767, 12768, 12766, 16567, 16568, 16564, 16566, 
         16565, 10482, 10513, 16669, 16668, 18227, 18226, 12609, 16562, 16563,
          16560, 12765, 16561, 10933, 13387, 13388, 14211, 14210, 11315, 
         17639, 11833, 17638, 11832, 13661, 11831, 17887, 12220, 17885, 12219,
          17886, 10619, 17883, 12217, 17882, 12218, 17884, 11829, 13660, 
         12570, 18189, 12571, 18190, 11314, 17352, 17354, 17353, 10931, 12758,
          18576, 12759, 12755, 12757, 18575, 12756, 10479, 12761, 18577, 
         12762, 12760, 12764, 18578, 12763, 10930, 12798, 18584, 12799, 14185,
          14184, 11035, 17637, 11828, 17636, 11827, 13659, 11826, 17877}],
        "196"],
       Annotation[#, 196, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10857, 17007, 10858, 18588, 18589, 18460, 15234, 15232, 
         11304, 15233, 16635, 14276, 11812, 15746, 11155, 14901, 15096, 17164,
          15095, 13103, 10947, 15695, 15696, 15694, 11751, 15697, 17231, 
         15012, 17582, 17583, 11749, 15692, 11748, 13603, 11747, 13085, 15040,
          11073, 13184, 11074, 13087, 17212, 14960, 15728, 17599, 11786, 
         15727, 11785, 15723, 13618, 13630, 11778, 13634, 11779, 13632, 14954,
          16419, 16420, 15030, 16421, 18511, 11044, 16422, 12553, 15027, 
         15026, 15024, 11755, 15700, 11754, 13609, 13061, 14223, 13062, 11766,
          13065, 13063, 10968, 13059, 10967, 17185, 14925, 11699, 15710, 
         11765, 14222, 16610, 16609, 17324, 11247, 17325, 15163, 15164, 18470,
          18472, 18471, 10873, 15545, 13056}],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10908, 17102, 10909, 18598, 18599, 18479, 15274, 15272, 
         11359, 15273, 11730, 15663, 11731, 15665, 11709, 14938, 14940, 10986,
          13131, 10987, 13682, 13683, 12506, 14307, 16362, 10490, 13225, 
         14321, 14320, 16381, 11868, 13703, 14978, 14121, 12524, 14129, 12876,
          16384, 12878, 12584, 16462, 17672, 16461, 17673, 11885, 17674, 
         15794, 14983, 14985, 13725, 11889, 15848, 14338, 14339, 13233, 10502,
          16571, 14349, 12477, 13740, 13738, 10955, 13154, 13235, 13236, 
         14091, 14090, 11184, 15621, 11711, 15619, 11710, 16587, 16588, 15004,
          15005, 14127, 12536, 16405, 12537, 16402, 16404, 16403, 10864, 
         13570, 13156}],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11053, 13260, 11054, 15122, 15123, 15120, 11192, 15121, 
         16599, 14218, 11760, 15706, 11191, 14413, 14414, 10536, 13048, 10535,
          15916, 15917, 15915, 12024, 15918, 12022, 16504, 12639, 15925, 
         12638, 12895, 12894, 15705, 11759, 14448, 11758, 15704, 13264, 10561,
          14452, 14451, 15135, 15134, 12933, 15954, 15955, 14478, 16729, 
         10580, 13837, 10579, 14477, 14476, 16517, 16516, 12900, 16434, 16435,
          16431, 16433, 16432, 13624, 10581, 14480, 14479, 15964, 15963, 
         12936, 15176, 15177, 14498, 16742, 10590, 13269, 14495, 14494, 14492,
          11268, 15175, 12902, 12903, 16628, 14248, 12564, 16442, 11791, 
         15976, 12056, 15973, 17796, 17795, 10543, 13093, 10544, 16697, 14421,
          11202, 15200, 11277, 15198, 11276, 15199, 17304, 11204, 17305, 
         15124, 15126, 15125, 11087, 13279, 12853}],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11137, 13307, 11138, 15118, 15119, 14408, 15329, 18521, 
         18619, 18618, 11419, 17381, 11420, 15331, 11226, 14436, 14438, 16722,
          10553, 13165, 13245, 16167, 16168, 16166, 12196, 16169, 11894, 
         13745, 11907, 16476, 14355, 13312, 11227, 15321, 11414, 14648, 16829,
          16830, 13299, 10696, 14650, 14649, 15323, 15322, 11180, 16147, 
         16148, 14646, 16828, 10695, 13721, 17680, 17681, 15798, 15800, 15799,
          11221, 16113, 16114, 14626, 16823, 10680, 13931, 10681, 14628, 
         14627, 16117, 16116, 11178, 15303, 15304, 14623, 16820, 10679, 13291,
          15788, 11879, 14624, 11880, 15789, 11216, 13293, 12152, 16095, 
         12153, 16096, 12150, 16098, 12154, 16097, 17847, 17846, 13219, 13144,
          10548, 14434, 14432, 11214, 15766, 11851, 14306, 16653, 14397, 
         14396, 14395, 15114, 15113, 11112, 13284, 12871}],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl0zlsDnAYx/FHSASDCYuBBHEELb1FqZ6DyaAJQsLCQkSbUJPBUVX3LXFf
ad8ebkvdN0NbbTWhlLZuDYtBBJ/G8M3v/T/X//f83/cdvXTVvJX9IuIPmrIi
HqVHPEZ5dkTS1IgnGRFrcyIaUiMqp0RkpkVMEy9Uk0wznH/PjqhQP915K02h
2+h29Tf1lelfh1TxXfkRQwojBmO+XDES4k/Fq+kzunpCxKmCiD1JESfpGZzG
ePNe5UV04K87w8zP4yO+yH2nWdMihmIEb8ORpv643AkcxW7zjtE15r91T4P7
OukNuoSPxcg2dxa2858h3mj/De55JnfIvPaZEYfpGPGxGIeB8nXqC9XX0iJa
T8+qa9N3jr7Td5520QLz83HbGwS/931+iAcYnRxRyvsomkMfTIxo5vkq7020
Bc9xxTldfwZSkIZUDLPbT28xmKdBKMrlCyMnRezwbjtRicRkO9KH5tcUeVff
fYJ20PXqy7BMzwqe8nhZTnNph31q7XHPfovsWe39FtIXerNn8eZzqZ1KMJf/
Zudyv5EaPT/UvNS/n68qfQvk2sRanLv53qxuC5rEv8s30qPil+x7wL4X+/bG
Zex3/kZ78RXX7X4NPTxWOydQhVrUYK/6enoBddjnXGF2j3vuuKeb3qWb3L8R
nXIlmX4rWMVjgdwRNRW8ttrhlH1qvEG++GHxPNqqbqY3uNX3LnJzaBXNpQl6
UM9TvVvNKEeO+CG9xd651bu/wE8z2mi/GREf+Gzn8z39hI9I7vst+d660N+M
Aej1fX+We4036MBbdKJVfzftwTu0OXfRX+5ozPr/n/8HvYvQkA==
         "]],
        "144"],
       Annotation[#, 144, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{10860, 17008, 10861, 18590, 18591, 18461, 15243, 15240, 
         15242, 18399, 15241, 15825, 15824, 17691, 11922, 15823, 17690, 17689,
          13548, 10859, 15518, 15519, 15517, 11627, 12976, 12975, 15650, 
         11726, 14967, 15651, 18501, 11014, 15652, 11013, 14965, 14966, 17546,
          17547, 17545, 15583, 17548, 11690, 14902, 14906, 17232, 18639, 
         11752, 17584, 17233, 18516, 18517, 17264, 17265, 17266, 17263, 16371,
          16372, 16374, 16373, 10465, 14260, 14259, 15737, 15736, 11150, 
         13595, 11149, 13183, 13086, 11011, 14958, 14959, 14254, 15724, 16629,
          15722, 13617, 13628, 13629, 11780, 13633, 13631, 11009, 16417, 
         16418, 12790, 16577, 16579, 16578, 13592, 11045, 15031, 15032, 14236,
          16395, 18397, 10459, 16396, 16397, 14226, 14225, 14224, 11768, 
         15711, 11767, 13614, 14932, 14929, 12494, 16356, 14927, 15604, 17555,
          15605, 14950, 18498, 18500, 18499, 11005, 15627, 11006, 14952, 
         14951, 11713, 15626, 12967, 12968, 11638, 15542, 15544, 15543, 10875,
          13057, 10874, 17017, 14879, 12412, 18058, 16607, 16608, 16605, 
         16606, 15159, 15160, 18467, 18469, 18468, 10871, 15541, 13055}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{10901, 17094, 10902, 18596, 18597, 18477, 15262, 15259, 
         15261, 15260, 15390, 11473, 15610, 11706, 14936, 14937, 10983, 13556,
          10984, 15556, 15557, 15555, 11661, 12995, 12994, 15666, 11732, 
         14971, 16378, 18505, 11022, 16379, 15762, 15615, 15616, 14939, 14941,
          16365, 12509, 14943, 14945, 14109, 12505, 16364, 12508, 16361, 
         12507, 16363, 13445, 18162, 18163, 16385, 16387, 16386, 12522, 16380,
          14976, 14977, 13702, 11025, 14119, 14120, 12539, 12877, 10495, 
         16464, 10497, 16659, 16463, 14333, 14984, 18509, 14982, 11031, 13724,
          13793, 11956, 14125, 11957, 16392, 16393, 16389, 16391, 16390, 
         13458, 18358, 12770, 16570, 12771, 16572, 12476, 14096, 17169, 14917,
          12478, 16344, 12769, 16569, 14088, 14089, 12521, 16375, 16377, 
         16376, 13152, 13587, 11001, 17209, 17208, 12516, 14115, 14114, 17228,
          17227, 18169, 18170, 17859, 17858, 12172, 17860, 12173, 16136, 
         11629, 15520, 15522, 15521, 10957, 13157, 15850, 15851, 15849, 11962,
          15853, 11481, 17392, 15852, 15400, 15401, 15308, 15309, 18462, 
         18464, 18463, 10865, 15594, 13158}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11055, 13325, 11056, 15145, 15146, 15142, 15144, 15143, 
         16601, 16600, 13258, 11193, 13050, 11194, 13052, 13051, 14416, 14415,
          15139, 11232, 14455, 15537, 18412, 10563, 15538, 10562, 14453, 
         14454, 15089, 17292, 15088, 11144, 15929, 12030, 14456, 14458, 13831,
          12023, 15928, 12029, 15926, 12028, 15927, 16235, 16234, 10455, 
         14233, 14232, 15717, 15716, 11196, 13347, 12934, 12935, 13319, 13318,
          10538, 15950, 15951, 15949, 15953, 15952, 12042, 16518, 16519, 
         16515, 18254, 18253, 10508, 10454, 16617, 14231, 16437, 16436, 11777,
          15965, 15966, 15962, 17782, 17781, 10542, 13359, 13360, 12938, 
         12937, 13361, 11200, 15190, 15191, 15187, 15189, 15188, 16246, 16247,
          14266, 14265, 14247, 11804, 15740, 11790, 13638, 14521, 14518, 
         12067, 15986, 11152, 14420, 15094, 15093, 15741, 16299, 10599, 14524,
          14523, 11278, 15201, 14422, 14423, 13105, 13106, 11206, 12854, 
         11205, 13278, 11429, 17383, 15342, 15343, 15220, 15222, 15221, 11094,
          13373, 12855}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{11135, 13484, 11136, 15116, 15117, 14407, 15327, 16690, 
         10531, 15328, 11417, 13305, 11224, 13160, 11225, 13162, 13161, 13244,
          11186, 15332, 11421, 14663, 16311, 18431, 10702, 16312, 15807, 
         15129, 15130, 14437, 16141, 17862, 12179, 14641, 14645, 13727, 11895,
          13802, 11961, 14148, 18243, 12628, 18242, 12629, 12926, 10528, 
         12821, 18383, 12822, 18384, 12818, 13488, 18679, 13487, 11220, 13490,
          12956, 12957, 13494, 13493, 13231, 16143, 16144, 16142, 16146, 
         16145, 11878, 13728, 13729, 12587, 14341, 10499, 13300, 16109, 16110,
          16108, 16112, 16111, 12164, 16118, 16119, 16115, 17854, 17853, 
         13229, 13468, 13469, 12954, 12953, 13457, 11215, 15774, 15775, 14316,
          14401, 18402, 10492, 10524, 18587, 16654, 16492, 12614, 16094, 
         12615, 18659, 16493, 17845, 18303, 12685, 18570, 17844, 16534, 14604,
          12151, 16093, 14433, 15127, 17315, 15128, 14585, 18423, 18425, 
         18424, 10658, 15565, 10659, 14587, 14586, 11370, 15283, 11168, 13214,
          13127, 13128, 11212, 12872, 11211, 13283, 16651, 16652, 10520, 
         14387, 14386, 15112, 15111, 11102, 13421, 12868}],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwllElMU1EUhv8ScYoxRjdlo23BaMVYKC2jtpDiUNwZNSbiwrrQiBR1Z4Ka
qnGKxiUYE2HRihuHlUOi4BCRQgc72CIaUk001tk4oAuN34uLj6/3vnPPOffe
97AGujYETZJK+TPaKA3XSY+huFR67ZWyVVJolWRbIR3G5Xi3U5prlza6JSvj
bo9U6ZDu1kuDMAR3eOZkfQ1UgxtckGPdpgZpM9wj7j50MDdIfB3PI+SpxZdw
PR5uoa/V0gDjiXXSLZ9kXi7dxmU42CT5K6VDtZKDvqrAwrzXJf1tlv6AuVqa
s1ZaQq9Jcl0lVxxfwQm8n/opfI3xE3wdp7Gd+MlWaRk20UcJNJPXRv6V1GmC
EHW3GPXpYzHzB3EFfsX6IfLEWBOHXew3SP8NzJ3jvFLsOw1x9t1N/SPEZBh3
ErcHJpkL4i54xvwEHGMuT/xZYs/Ac+b85LtBPg89BnjWUyP1Qivjr/Tuw1+w
hXgr2GCKuy1wHg7Wj3PX7XgrOMk/tUb6zp3/xD/wL/wNPyS+hP0+wCYc5VxH
wM06FxTI00atfmr3QZHxW8jSWyc9zmQfs2C2sTf6vEytfnqZwThDTBr85Ivj
BJQyPx0GiHtBfB+xF2Eacx3GuRJTzr2a6acCl+G9nHuO92Ifvsk9BLiXA6zd
jn30tIP5EPcXY/0H7ieOP+Ix/Bkn8SecwD3UfcfvKL+LeBS/xyP4NLUi1DyF
wzhAzvXk9lCjnVo7qbkNn6eHNuZ7jXcULyB+EfHz8UL8ku8pwpkVcBjbyZ9l
7VFqn2Sv45xrhH2GoYWzyRGXh6dgJdZi9EX8CWKPQ554L/1dID5jnD3MM94j
47sg/yPGKUhDnjt9w/cV45uPwxgkIQG/Idr4///BP3b8yEI=
         "]],
        "100"],
       Annotation[#, 100, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl13lwV9UVwPELNoGyBIIobWV1bGcKSYiAbLInUDuKUqmVArZAqyRCobIl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         "]],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1F1M1mUYx/GrNbeOOGjLgg4SOeARECpCeVHA5OEhOEpWqZvRzJwh4Nam
8p5tbSm6CTiDKCtoIzkqfDsoZ+lqoiWVigi02kw96Ky1Tjqxz38dfPn9r/v+
Xdd93S8Pudv3bOp4KCLK/NlcEXGyJOJSeUTbqojs0ogcPF4UUVcVsZy2039r
I4rXRBTxptdGrHsm4mlxCQ4WRxyojngHfXgb/biXiigwX4gq/tVJPt7j7zbf
g04UqNlF7/Lfz6iX9KCfQ7SpLKIRw4XWWB+xQu7tuoin6I/iI/QHepim+Bv4
VlkjQ/PFM/SKmlcxg6xnI5rV22S81PxRedfkD9In0hGzvhfUX8Ii3hU/qHRY
zuB9ObfUyFZjjt7GPGrtrdGZ1NAGulX9UbWq7WvUvsbwAUas8Qn9FB/hY5zA
H7xVNc4U4+LPMIFx/pN0CpOoVe9zepGO6Cfjbo7TBrreXtZhwB3ecXaXebrd
7fUNETewS09vohXdz7l3OW16vWAvp+3zDLZs1DtS9nlWnE83i1/BKfF04pG3
6DxazC3R12iX+U6E9U5Y64H19/CdS3rzbjLotm6f+V704Kb+HqaT+n1J3y9j
Qq1quTXOYanBfumvdC55H3SDuJO2iaed2U/O4hf8jC+c1YB7P4y0e9hvXzlq
/8X3vLyNmOObxy18yd+qr92otWa+vlPo0ee4Xqbc+wTtT/pGp3qjxprl/e7c
/sRj6vwmbpH/gtx6/p3JO+VP89djjbk64zuMv6i3N2ha/KrxbViQn6VOPR1U
P0OH6Fty29XpwBj/I8kbov/4jRTJK0QB7vHexZS8MzxnMY3TOIW/+R91Dqlk
j1hM3jc+5B82fwyDqHSmQ3SZfeTxrcQKjOi33LprsVedWWPTvDvc3QzvFRyw
rwVzrxvbjovewiXkeQPf0l6ea/L2+t6PZjX30R7voxe5fN8kbxHfeVNN5jvM
t+P7JE/+V76f5DtPv07epHUuG5+3bp/1t4q3VPz//+w/AhLc4g==
         "]],
        "64"],
       Annotation[#, 64, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl13uUz3Uex/EPTgchtYVxSaai0LqEXAbjMoNcTgxm6LjNGGzbicIyRKuI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         "]],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1WtM1mUYx/FL1yrthVLThppGL1S0Yp0wgQdNBKHshGI1E7BwLU/gIayl
kjIPtFJTtKTStKymadrhja61IZKHhk2x0FpooGbOF0lttpb1edaLr7///7p/
1+G+//eDac9UFs/uFhHb/bMhO6Lg9oh6mk/zRkeMxRjccldEeyJi650RP9Oh
+RFDcPy+iLr0iFUPRJy5P2JfbsRejJZznK8VxzCIdyAO8S/lX8b/PX8iI+JN
/lT1s+UkkIPnUDQiIkO/M2MjTiPl7ogj4yJWqleHzMyIEegnfpT3O1waGrGE
luhzGV2Y731ecl2tFXqtxDJk6L2cjjJLLo4VRrTwjDPnUXqNtR/0XazXAs/V
qBM/5P1VepjmmrtA7QSdQHeYpcyM5Vitzhq8IC9dr3l0KJ1PE/rloFXPW8Ve
43sdM6xNx2H1r6qfJzYGHfa14p6IQvvplFNEB9n7QPThPci7nKY604JR9i6n
K9l/pD3o8wZ9xfsSLEW5HlPxFv9k32OveoXyijAOD+FBXLK2Vu46bORtwNNi
+/hnyZ+NmUizh0o6V6/dPHM8V6Gbe7QnL6I7zXevcofzmvk2DHdW7faVeW/E
OVplfQ4q0Y9/W07Eh3gflXdEfEBn6b1f/SZ85bz3Z5lTzUa6jecAHe+9mR62
/i3fZd/iCO2i8+W/bMYmZ1jFX+H7TsPHan+Eern9eQegF+9Fc+WZ73d6Vk7C
zLVmX4qneGvMOsSsafyD6UhnloXnnVeLPtNpvfNejw2odybr0cq/WP0W51hD
a3lPiL3L/w66xDbRzegQ78QqsTb+1clvwr9ZvU3Yii14L6n8VeZss77V88Nm
GY9Wd+NJ6ydoD/3z6SP28ChmqjkDfdW9Yp+9raegF07xfUMP4gCm+M7NtINO
UbdNr3LPO9WeSg9ZK6XF6jaY4RPxMu9z+X4xz4Ax9ueuTlL3bVpCa/SeSE/J
reRtS94repJ20lJ9Tia/l+fP1PscP1n7Ee3y+tIysVIsVKu/ffxtH//6rhfd
gd/kNuh1gW6kf4lfwQ7P0+RvpxV0kr85T6AEw/yeL6hbo2dfc9+ML9U9rf4X
dJe99RH7lec8Jso5S8/hRvGbsIevnX833cmfIrZIvc7k3wP1H5czAcVY6O6M
8o0X0UZ3aqa7tVbuOvR25160j5ewANWocyf3I1XtauvTxCqwRd6n7vFu7MQ8
d3wX3cbXTf/uOM9X6zfZId6Z9PGsdwZFzuBP51JIu+gfuFoQ8Q8m89+QnNkZ
DtMjoUY6fcx7T/GvzdDs93U9nchbgkmYxTcbPcUbeHvQwfKyxXJwnfcmedfS
A7TRnqYiy9+6c/zZtMIZPIvJw///P+o/jVE57A==
         "]],
        "36"],
       Annotation[#, 36, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl13eUV8UZxvFBjARMIkGDSDMigqF3IgrLLrCg51CyQKS3BUSkGIHoQmgC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         "]],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1nmUz1UYx/FLTudQOsWMNcRpsQwizDCVGTsZ2Rozoyyz2cKMfac6bfaO
XfWHss2CbDMmslVCWUoKobJzIv9kj15z+uN9Pvfe57nPc5/n3u9vpmbq8O7D
SoQQYkuGsCEmhFoNQ0hqH0Iy+seHkIo0bG0SwjYMaxRCIttQ2otGNAthTd0Q
7rYK4Q72twthHyo0COFgmxAq0kP0Qb0QippKFBVCA3F6Ng+hPr1vfaEY/9Io
8/zoEOrQO+aF/O/SuuY9+Nemt82P8L9Fx7wkv/gHxC9Pv6c/oLNzJKCnc10V
I65tCN+yt6R76HPiPIsYdUWjGdqqpQ1qqH+tPkyPC2EGZmEm0uuEkNs4hOPs
Z/mfw3n8JX4Jef40PoOC1iFsRpZxNqbVD2HniyHswDpxy6i/jDM+gtJ4mH2b
mrdiV4sQ2qmrR4cQShl3U8PA2BCesCeTPk4H0PM0WrwN/CKMC+WLpG+yrbJn
CC1vPoiWo4NpaXkele8xlEU3eUbZ15WmiPM6eiOF39d0pvi76Qz6Fb8d2I4C
97AZJdV8Xe0X1XgBhdZyvYk57mY2EtXTC2v1bA1eM67InqWX2UjSi2SkoKO7
6IRe7O3cQSJtT2+IP1uedWpai6Xe1RLsb2ks3z61VXG+GHpezuY0WZwhbL1p
rPleMVrQFPMDtA+No8v5x9O+5iP496OtzX/i34peUesaekhthzFG3rFIco5k
9HGuODE+9aY6exOf0AQ6Tpyx+MieuZiDwWoZhC7snezJMs7GcLyj1o7WOiBD
7kxMeN7dyDEaY3DbWtmXQ8hTaz4qeBsVUQlz3dd+a/sQaZ5tnud+85GL0+Zt
fCcH3eUJ4xxrv9E4ax3V2JqeMo+nJ2kruldtPV7w/aCr76U77Yb31fVBcb/4
VZarCqpikflqtexWy0q6i66ime58AG6bbze/RXfQ++q5h+ryV0NnMc6xRfKN
QCrSkGNtBv/VdJb+TNK/LfpchFx9zUM+FjjTQmTpW6p+pSEde+xJU0umcQam
uL/J2OT9THXnBe63pL5Noff4TqXzxYlgy1Pvat/GGusTvN+JOMq+iH0aXW/9
LbrYvBL/fP45/O8Xn5NvLXF/YV/Jtgo75N2J353jD6xwrgd60F8tZ/W4Hz1H
l4q3BCX5XlRvCVoKD2GaeWWx1qn5C8y3fwEW4km1VxO3OmqghHN00rtj+nsc
y/h/hs8x0H2d1fOhznuGDqMN5G+IuuyX7KtDN3szI9Twq/0j6Ra/Iz+KvZWO
Ni+io+iX9BX+nbDJngxrR+3JpPlsb9hTRp5EtgFynTaO9t3H4Bl7nkZ9uaOQ
bs8N6zdxC/OcdQn7YizCz+IeQQrfO+quKnYVVEZVPbhqz1K/1V3Vf934b1wr
/q3Ruwf2BH28T8+YT9TnSUj2vjqoOan4W6Q3xe3rfnqLmYLx9oxDS/czw/cR
R2fSbPd8WZ6P1TTf/Z+XJ128LmpYYT2Bppkf9Zaz+A7HMuuL+c/jf5L/q+xN
+V203oROFzdW/Cu+0xb0Er2MLc5RhLnOdYFvoXEBNhf/zXXuLuIkYKoeTcFk
pKslDRvUmuHdLPe7uwKrsBIn9OmYM43Xt2xxRmAk/lH/cPYcbzgX5dxXeURg
Ft/3nLGes71Lo2greeNxqbb37Y4bi/kNvyg11sN2Z65D62Kj9Ubsb/O7yD+6
+O8wKotzWJ2V6ES2yZiED/mfpt/5Zk/RPTSVXxruyF/T2m0a706vOXektxGB
8thp73o9zlDnU3q2yXhjzP//5/wH1Q6gCg==
         "]],
        "16"],
       Annotation[#, 16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl12eUVdUZxvFN7yC9VyF0ZICBaQzS+zQ6AgqGMgy9mShFkKqiURAC4qAR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         "]],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1nlwkNUVBfDH5qBQSQybQFwIIUgCBAgQtqKowAg6I0pBQ5W6oCKgKFSk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         "]],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.9890161957970904`, -0.37621255361854944`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.9890161957970904`, -0.37621255361854944`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.37621255361854944`}], 
    PointBox[{1.8268708012611898`, 3.5562606439414575`}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{1.8268708012611898`, 3.5562606439414575`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.8420774300766407`, -1.1947259500599068`}], 
    PointBox[{-3.9890161957970904`, 0.4462628177704646}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.8420774300766407`, -1.1947259500599068`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.8420774300766407`, -1.1947259500599068`}], 
    PointBox[{1.8268708012611898`, 3.5562606439414575`}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-2.7366639988756276`, -2.942345201011201}], 
    PointBox[{-3.9468878428150775`, 0.47974909276527367`}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.8420774300766407`, -1.1947259500599068`}], 
    PointBox[{1.8268708012611898`, 3.5562606439414575`}], 
    PointBox[{-3.9468878428150775`, 0.47974909276527367`}], 
    PointBox[{-3.9468878428150775`, 0.47974909276527367`}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-2.621362398525856, 2.9956327630491804`}], 
    PointBox[{-3.8420774300766407`, -1.1947259500599068`}], 
    PointBox[{-3.9890161957970904`, 0.3952577829077992}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-0.6340958904513947, 3.937673811980489}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.7498967229198605`, 1.4552469382196032`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9761217920422003`, -0.2899152158516196}], 
    PointBox[{-3.9468878428150775`, 0.47974909276527367`}], 
    PointBox[{-3.9468878428150775`, 0.47974909276527367`}], 
    PointBox[{-3.8420774300766407`, -1.1947259500599068`}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.989477455767874, -0.28994873947685196`}], 
    PointBox[{-3.9894773757783164`, -0.2899487336633409}], 
    PointBox[{-3.9894773757783164`, -0.2899487336633409}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9890161957970904`, -0.2899152158516196}], 
    PointBox[{-3.9894773757783115`, -0.2899487336633404}], 
    PointBox[{-3.9894773757783115`, -0.2899487336633404}], 
    PointBox[{-3.9894773757783115`, -0.2899487336633404}]},
  Frame->True,
  PlotRange->{{-5, 5}, {-5, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->205610275]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23837268],

Cell["Specifying a non-default method could give better solution:", \
"ExampleText",
 CellID->1424437279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{".4", " ", "x"}], "]"}], "+", 
      RowBox[{".7", 
       RowBox[{"Cos", "[", 
        RowBox[{".6", " ", "x"}], "]"}], " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "<", "x", "<", "10"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1467809973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.1024567269825942`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "5.879581711907245`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444104648]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{".4", " ", "x"}], "]"}], "+", 
      RowBox[{".7", 
       RowBox[{"Cos", "[", 
        RowBox[{".6", " ", "x"}], "]"}], " ", "x"}]}], ",", 
     RowBox[{
      RowBox[{"-", "10"}], "<", "x", "<", "10"}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "\"\<DifferentialEvolution\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->394924060],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5.964389511244633`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "10.`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55140969]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{".4", " ", "x"}], "]"}], "+", 
    RowBox[{".7", 
     RowBox[{"Cos", "[", 
      RowBox[{".6", " ", "x"}], "]"}], " ", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2988854],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->11693222]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "StepMonitor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->151017442],

Cell[TextData[{
 "Steps taken by ",
 Cell[BoxData[
  RowBox[{"NMinimize", " "}]], "InlineFormula"],
 "in finding the minimum of the classic Rosenbrock function:"
}], "ExampleText",
 CellID->922642942],

Cell[BoxData[{
 RowBox[{
  RowBox[{"pts", " ", "=", " ", 
   RowBox[{
    RowBox[{"Reap", "[", 
     RowBox[{"NMinimize", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}], "^", "2"}], "+", 
        RowBox[{"100", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"x", "^", "2"}]}], "-", "y"}], ")"}], "^", "2"}]}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", 
       RowBox[{"StepMonitor", "\[RuleDelayed]", 
        RowBox[{"Sow", "[", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], "]"}]}]}], "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "1"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"pts", " ", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.2"}], ",", "1"}], "}"}], "}"}], ",", "pts"}], "]"}]}],
   ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1534545049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], "^", "2"}], "+", 
    RowBox[{"100", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"x", "^", "2"}]}], "-", "y"}], ")"}], "^", "2"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.3"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.4"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Arrow", "[", "pts", "]"}], ",", 
      RowBox[{"Point", "[", "pts", "]"}]}], "}"}]}], ",", 
   RowBox[{"Contours", "\[Rule]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"-", "i"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"-", "2"}], ",", "10"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"ColorFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"10", ",", "#"}], "]"}], "+", "10"}], ")"}], "/", "12"}], 
       "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"ColorFunctionScaling", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1614037545],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxknQm4zsUXx+37WpZU1siWVAqRBiFE+duiKHuIUAkpIXtCsmTfsmSpZBfG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   "], {{{}, {}, {}, {}, {}, {}, {}, {}, 
     {Hue[0.3950302241245204], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{3693, 4678, 1968}, {4702, 4704, 1985}, {4515, 5312, 
         1825}, {4865, 4867, 2152}, {4102, 4700, 1290}, {4501, 4000, 1144}, {
         5026, 3693, 1968}, {4871, 4868, 2152}, {4700, 5050, 1290}, {4138, 
         4901, 1315}, {4034, 4857, 1985}, {4670, 4140, 1315}, {4719, 4515, 
         1825}, {3598, 4506, 1626}, {4519, 4001, 1144}, {4868, 5309, 2152}, {
         4506, 4300, 1626}, {4495, 4299, 1626}, {4854, 4852, 2141}, {4140, 
         4792, 1315}, {4514, 4719, 1825}, {4324, 4519, 1144}, {4873, 4670, 
         1315}, {4797, 3716, 1967}, {4792, 4138, 1315}, {4104, 4617, 1290}, {
         5052, 4702, 1985}, {4300, 4508, 1626}, {4861, 4676, 1968}, {4001, 
         4539, 1144}, {4795, 4674, 1967}, {4672, 4797, 1967}, {4804, 4671, 
         1967}, {4298, 4102, 1290}, {4517, 4717, 1825}, {4674, 4804, 1967}, {
         4000, 4503, 1144}, {4539, 3998, 1144}, {4118, 4512, 1823}, {4678, 
         4861, 1968}, {4499, 4106, 1291}, {5311, 4873, 1315}, {4105, 4499, 
         1291}, {4704, 4034, 1985}, {3998, 4501, 1144}, {4852, 4853, 2141}, {
         4507, 4108, 1291}, {4867, 3794, 2152}, {5309, 4865, 2152}, {3794, 
         4871, 2152}, {4106, 4493, 1291}, {4510, 4118, 1823}, {4299, 3598, 
         1626}, {4717, 4514, 1825}, {3716, 4795, 1967}, {4503, 4324, 1144}, {
         4903, 4517, 1825}},
         VertexColors->None], 
        PolygonBox[{{4617, 4854, 2141, 1290}, {5050, 5052, 1985, 1290}, {4508,
          4507, 1291, 1626}, {4671, 5026, 1968, 1967}, {4857, 4104, 1290, 
         1985}, {4853, 4298, 1290, 2141}, {4493, 4495, 1626, 1291}, {5312, 
         5311, 1315, 1825}, {4676, 4672, 1967, 1968}, {4108, 4510, 1823, 
         1291}, {4901, 4903, 1825, 1315}, {4512, 4105, 1291, 1823}},
         VertexColors->None]}]}, 
     {Hue[0.311696890791187], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlmdsVlUcxg/jbd+31LfvvbdllCpDlgwLxoQhagIpfDAqBUEkURIiwxZB
gQ8alQCxGLYrEVxxkTgiYlBJscowUQSUEU0YDlTAxPHFwRLR3+NzEj+cnHPP
+c/nv26vGfMnzmsfQviR1YE1KQuhLA1hKR9La0JIWK2VITxcHsJyVr92IbzO
+0PFEF7m+0RFCJ0vCaE2H8LWSp8nc54NTZdSCFkuhLPs86tCGN4xhGXIq68O
YUchhPuQcQN0DyKnCrq+8E3BmFZseIC3kdAM4q5/3vb8DO0B5DTy3YHzLZl5
f+PcDh3tcrarPrVti8pC6IXOBJmj4LmGdQH7DychrIZ+G/SNyJuUmq6cPc9a
DO8w1kH4W+CdBt/aMstvhncvPH/wvYT9QGq5x9H7d+l/Ou3j4f2C+9Pcryiz
HwPztqe63Nj04HyOtz6cF3PeV+5vnSeD0xTW7wVjK8yEc4bOJHVMhP/JCmMu
fOvYvwWr0bwPAOtN0LwETtfz3RP+/tB0heabDrZ3QmpbFYeOMRaH8Cuf2Y7p
+Ns+Yiv5oyKG8mVAjEsTPl6Brrl8/4OMAO9szg2yjf3Ljo6Z7D0M/b28L8j8
9gi8s9BxO/5OQO/O1HIf425lYpz6sHcrOvcy9KQ19rs/MvqyVkGfx8Zz8E7n
/Bd7WnJO9YS3NvLu4e5P3m7Dr3rOlfD2yzlXXom2vQPeldBPRU4neGtYP+DS
BmiH89a14Pr4vmjfb+VuN28N3K9nfzozzQbZjo5LkduGjlBuHxvhnchq5XsX
tG+ljkdffK+FZyO27chcP8qPkxFDxXcQ7wu53wLNLOibOQ+NMVFsFPf7satr
4twbk3e8Fes2ZG5jjca2+XnLkO9vImMTqzN343kbV7BM+a+8V9xlk+yVzKnI
H5oar8H4PoS1HZ6785YrmcrB2piHR7GziN6Lyv+cd9VUZc5xELb3IG8e6zNh
hLw7WOeROZO7cfhyALr3kbGkaPu/Qma31HmlHDsV8fkUvM/E+L7BXltl33vA
+3ms9ybu72LtRledco231pz9Ph99192qku9fK/Od8ufdTo6j9O6BZl3RmC1D
96sVpl+Tuq+pjo6h/9fUPBOFU+q6UT8Ym7gnCCfVtbDqljgPhPepWD/SdWW1
+6boBiOjpsq5qpgJe/l4MtILB/WmjbH/jCi4f6i/9cPmx0uul5nY2FjtXiSc
jqaWM5f7RxP3peuqnHPKlf2cf4JmQt518FTMc9Xu8qJzewiyc5l72UrO3VNj
sg6aNawu5cZd9SD67ZoDrGbsXgN9r8xv51PHUnE8zr4rdS9Xbm2J+aOc6B7n
hs7aNTsy6Nejq463Gs7Pcb5MdJyfVC/gPAN5xZJzUL3tv/mR8+xSn1VMNK8W
pa4r9S35Lcxvhr4NOVfF+dC73HndBu0vqW04zV6Ic0Q+rS3Zr23w3VTybPmu
ZN/kl+aq8kw5tg/6t1PX0JHEuIj3RnDaqh4E5h9ybmM1gdvHqWOmeA2GvqVo
Gy5wP7LKM/W9zPzilU97M/ulua4+Kn+7Q3swdR7Wc96d2ib1TvVf2XZ14rxR
zjTlnb+K9WjkbcbO57nrkZhfvM9wfjbiP427Oan70RlsOVvtmhFmsls2L0g8
ezR3jnF/OHUPu7No3dKrPG+pdF0IF+WT6nqMbEw8N9ch4wi8YzVrS54Hyg/1
2c5x9h2M/agl9smxca4J+yU1xr935hpW/apn9MysT3P12tSzVf8oI2J9qffP
KbouVifu4+rhm1PjK2wbEtske+SHeop8+QiaSVX+35E+3atGvi4ZO+E2t8J9
VnXQXHTsFXfl7YlY+xXofDHzLB4qPZn9FP+Y6OPFWEvyXfFbEf83FkI7sOje
o1jtzMynOq6LtfwE7wMT8yaZ+7vknSpZn3R9kLnGVF9DEs94+aJ/H+W74qhc
Ud9U7FYl5hH9LvJiZ7V9le3DosxPMs9azdnLM/cX2XMIPftTz0D5rX8R+V7g
/YX4//AvLUBTBw==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVGUUxz8Knd4p5c7ce6cICEJRi1RaqC+4IBGw5U1LEaJGIDFuaUEU
fHEJghETRSnGCOIDImhEjUjiAgVZihpRUIrRpLigqPCg0ZiAUgmiv3/+83Ay
59yzfmedutsXt99bEUJYCwwSZCFUAR1RCJdUhtAVh/ApdGs+hJnA1jSEawsh
LII/FOiBtx8YBj4OA3ExhLPI3JILoQb9WmR/g54Fv2+gba3BZkveNo+DPwP/
kaoQVsBvLIXwJvQx8L3wtyQhnMTmOGyNRWYtdAtQgL4QegayHwMfAdOBJ7DX
we8BePMq7Gu94svbZ4qtc/AvjWxjIv62Qf+Av33w+8C7iHkG/OnAQXQPASPB
J/O+M+j3F42fGxBCHvkIegH8ZfjcRGyL+HYIfBn+m6Dn1obw3uAQVtaA4+8Y
8nXon8JfA/ydQDPyK5GvB78P/c/L+rtLrolq0VHNN2w1lRzrduw9ja2j6HwA
fyeQwM+AX5Dthn8aW3+nju1n6juNt92PvRPEewKZ8chOgb8V/kK+NcOfh/2z
5fqktdaRrGymyJaUZ+QfB5bDfxQYETlH89GtI55Jg2xjOPnPUsvWk6/D4Mux
dw2yV0eWHZOYJ52nVFveNAL5EjAMuhM4TT/NJB/D0V9K/CfR/Rr5Fdj/j293
R36DYhuN/Os5x9iMrQT58zn3UBP8m9F5Bd5mIIIenDg3ytFFyJ7hDVt462OR
e30I3xZH7vlvkP82dW+oRw/CH47+qznH2I/uxch3V9rGVGTzmXOr+NqgH4z9
ltV6E7o3EuMV8I5Ar4PeiM1e8JF8O5q659Rr6skbitaRrHqmt+CaKL+asV3w
Xi6YL5ut8BbhbzT+MmJqh56f2H83/F3ShT+3wjPRAj0NuA64HngO2XzRtVBN
+vlWVe4n9fxKdO9MHa9s/A7+XcG1CcgMgv5TOY8843vB2+Bfpn0BrML2qMy5
Vs4qwfeU3Ovq+W1F10T8DcBg8PGxd4/q8VfqHlf9tHM6wT/LvKvUT/J9Crg1
cgw16A4s7xvR4v0YuxaSGYPu6MyzpB2yDvx9YHLeO+SP1DOo2ZuDfK9sx66P
elq9MpX3vZNzz8TQE3lDfaV7cA35fDZxPlWTg/C6oC+o8r68B1ufZN5V8qfZ
WlHrWdaMvYhsHPu9o9C5CdnZmXen3tQQO0bFphmpRX59YlnpbAQfWnQvKIYh
4C/xbQNQA7449Q7T7tEOUi+9lnj3qqdmw+/G31V57zD16vOJd7F6IAfvK2J4
MucbsgP6odj5uzLvWvclzq9qOgN8etmfdM6n7kH13r/AhKJnSLOjGd+Ofn3B
tmRzAPx3S67lAGwuybxztWu14xaiuwT6n5x3snp/QWJZzcAI8FmpZ0EzrFnd
i73Oas9sT8k9p15byLcm/FWX51kyEXhj0b0qH6qNaqpaKt/qje+Lvo3qkZ7U
N0/10gws1YzF3v3qmUl6c+pbqR21D7yd9zaU50Vvn1Py7VAOdEvuQD+pcD32
69YWjD+AvQOZd3pr+f6tRn5s5tnUzWjl/VnRu0b160b/cugGYEfqWZtQ8i3W
zKmWL5TvqfL/E/SH0on8pi/Qm5J5VlXjWei2lxy7YtRu2QPsLu+YGv1/KDm3
mpG3+fZWal/6T/Gr7k3B+WiTDejDBePaeZvR7yzvtzHEcwT+l6lvi2767IJz
KP+KUbk8XnRulNMD8O4qeFfoZqwmH6sS108z+XDsHlau1fPapZsy+5JPxfZG
6luiGKuwPQ/6NiBX9O1vTPxfRP8B/geQoycz
         "],
         VertexColors->None], 
        PolygonBox[{{4701, 5051, 2364, 5050, 4700}, {3795, 4870, 2154, 4871, 
         3794}, {3712, 4703, 4702, 5052, 2364}, {4669, 4035, 4034, 4704, 
         1966}, {4504, 4325, 4324, 4503, 1820}, {4119, 4862, 4861, 4678, 
         1299}, {4798, 4796, 598, 3716, 4797}, {3897, 4675, 4674, 4795, 
         2085}, {4540, 3999, 3998, 4539, 1842}, {4703, 3713, 1966, 4704, 
         4702}, {4035, 4856, 2143, 4857, 4034}, {5308, 4866, 4865, 5309, 
         2666}, {4301, 4117, 1822, 4508, 4300}, {4718, 4516, 4515, 4719, 
         1997}, {4864, 4793, 4792, 4140, 2151}, {4500, 4107, 4106, 4499, 
         1818}, {4509, 4109, 4108, 4507, 1822}, {4107, 4494, 1815, 4493, 
         4106}, {4805, 5027, 2336, 4671, 4804}, {4518, 4716, 1996, 4717, 
         4517}, {4655, 3795, 3794, 4867, 1955}, {4242, 4518, 4517, 4903, 
         2187}, {4855, 4103, 4102, 4298, 1625}, {4139, 4902, 2187, 4901, 
         4138}, {3999, 4502, 1819, 4501, 3998}, {4516, 4142, 2667, 5312, 
         4515}, {4116, 4301, 4300, 4506, 1821}, {4325, 4520, 1826, 4519, 
         4324}, {4511, 4492, 1299, 4118, 4510}, {4866, 4654, 1955, 4867, 
         4865}},
         VertexColors->None]}]}, 
     {Hue[0.22836355745785367`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgncl2O6x/963/e/vMv///yXt10lqaQ3YlBaCBlryE6rpIi02SLMkSUq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm8leMWx99O++yzz4n9Dnuf6lQUmnUalBIJlzJXGiQNVEqJTkpEhi4q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         "],
         VertexColors->None]}]}, 
     {Hue[0.14503022412452032`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNnXecVEX29nu6Z7qnu2c6j+yu6BoXFASVJGJEBXQVMK5ZSfrTVcxxDQQX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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmnmgTdX7xg/33nPvOdy9zzn7iJIGlLHIkDm+Zg2apIRcc0kayFQRSkkl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         "],
         VertexColors->None]}]}, 
     {Hue[0.06169689079118701], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFnQeUVFW2hqu6uru6K1dXtQ+z6BgQHUVQQUWigaCCCGYxoAgmUIwkFRUD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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXu8zWX2x7/HPvvssw/nu7/7YpIZt24qZibShV9y7eJWTKEkJfeUCiFy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         "],
         VertexColors->None]}]}, 
     {Hue[1.0406922648421473`], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmomT1dWVx++zu997vby1XwOaGGggZqmafyCZTHSMiQNOzCYmYSyrsorj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlltlvVVUUxndp6e1te8+57b04ATI68eYf4IAgwTJJy6gxJiIoqCAIRmiZ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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3551, 5260, 3550, 4930, 4929, 5246, 5245, 4291, 3994, 5458, 
         3993, 4030, 3557, 5378, 3995, 5250, 4942, 5115, 5114, 5249, 3585, 
         3556, 5377, 3778, 3619, 5391, 3827, 4173, 4056, 5390, 3618, 4469, 
         3617, 5389, 4055, 4172, 4054, 3616, 4467, 4468, 4053, 5280, 5282, 
         5281, 3562, 4596, 3555, 4593, 4592, 4624, 4623, 3607, 4963, 4964, 
         5248, 5247, 4931, 4932, 4417, 4928, 4927, 4926, 5337, 5336, 3992, 
         4531, 4532, 4271, 4278, 3549, 4533, 4534}],
        FractionBox["1", "10000000000"]],
       Annotation[#, 
        Rational[1, 10000000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3560, 4933, 4595, 3779, 4746, 3797, 4602, 4603, 4171, 5476, 
         4170, 5279, 4052, 4969, 4970, 3613, 4440, 4834, 4737, 4738, 4736, 
         3781, 5135, 3834, 4980, 4981, 4213, 5413, 3662, 4560, 4561, 4310, 
         5384, 4309, 3589, 3567, 5123, 5124, 5122, 3811, 5125, 3663, 3852, 
         3798, 5116, 3799, 3569, 5380, 3786, 3645, 3853, 5443, 3854, 3844, 
         5139, 3843, 5140, 4338, 4369, 3574, 5381, 4010, 4432, 4431, 3664, 
         4087, 3803, 5119, 3804, 5120, 4748, 5111, 3788, 5441, 4641, 4642, 
         3654, 3855, 5444, 3856, 3848, 5145, 3847, 5146, 4341, 4370, 3579, 
         5383, 4021, 4020, 4437, 3666, 4088, 3806, 4742, 3790, 4741, 3789, 
         5147, 5148, 4995, 4996, 4216, 5414, 3668, 4566, 3667, 4313, 4940, 
         4941, 3580, 5488, 4609, 4599, 4644, 4643, 3658, 4887, 4218, 4886, 
         4219, 4888, 4217, 5501, 4315, 5490, 4314, 3594, 3581, 5489, 4610, 
         4600, 4646, 4645, 3660, 4647, 4220, 3670, 4567, 3669, 4316, 5385, 
         4946, 3807, 5121, 3792, 4743, 4745, 4744, 4767, 3582, 5150, 5151, 
         5149, 5153, 5152, 3791, 5112, 5113, 4766, 4765, 4847, 5294, 3595, 
         4296, 4274, 4482, 4481, 4028, 4445, 3659, 5412, 4084, 4024, 5258, 
         4025, 5259, 4023, 4187, 5478, 4186, 4439, 4184, 5500, 4185, 4022, 
         4183, 5477, 4182, 4438, 4180, 5499, 4181, 4016, 4435, 3577, 5382, 
         4179, 4015, 5339, 5340, 4938, 4939, 3576, 4433, 3575, 3593, 4608, 
         4607, 3805, 4008, 5459, 4007, 4427, 4006, 5338, 4177, 4936, 4937, 
         3572, 4424, 3570, 3591, 4606, 4605, 3800, 5507, 4747, 4935, 5252, 
         4003, 4732, 5090, 5091, 4528, 4529, 4267, 4913, 4266, 5373, 4337, 
         4415, 3565}],
        FractionBox["1", "10000000000"]],
       Annotation[#, 
        Rational[1, 10000000000], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1Hloz3Ecx/GPf8hi7KDlP5QhfzhyZfwhJrIchea+RW0zmW2UaHOfc5Wa
ko1ph1iOUfgDuf2BcmTYnNtstYUiWx7fP557vd+vz/v49P3u++u7PGt2ZqcQ
QrI/ObEhDO4VwvQeIfTDZHF/WsaviAvhHB3fM4RdvPHyNPlLeZr8UkII1cjl
zU8MYRPN0b8JGzE1PoTuiEW8s5FqhuhbqmcJFqORf5hfhDnyeZiLInU5vHd6
36MWV9TecYeF9tc6W0RrUN89hHHyBpqqtw2tuKs+1z2+i6+Kj5g5yJyB6Co+
TZ/rf2DmUtpAGyPEJ9XXimtwHRd4zea04KazFbw6O/OQjyb+D9Q42yy/Rhvl
DdHziZ4Njtp5DNednaA36HH6wT0K8VBe6L4PaIH8Hy21dwzvjLjczhI6Vp7C
X4VnvGreBF6V/Jb8Jp7jBV7zXqFFvJquQZLaUXrWRPe3v8Md38jb6Vtaxf/N
r6C/aCX9SEtoHS2lN2iBmX9oM71v7l/xPP07zcmz47O4s9ouWMDrKY8T/1F7
jtarP0s/0WlmTEWpeAfvLN1Js/VU6q2KZiIfw3lP1Y6gfTynreYl27dAns5f
LG8X9+INpdvNGkZ7yzvoPflKdauwXW2rPdtoG012/pg/kK63KwuHcBDpvP30
ADKQiQG8SeoL9Bab+9F9TtE6WuZ8Cv2pJtb5E/EWZ8Xy8/alRO9MXK+/ko6T
l/ET5Qnoihgs4b2P3gE+4B7viPps8zagLXoPyNL/1Tcwy96ZmBE9L16T2hh9
P6L/Tftn8PJpkrybuJnejr5LM5ahXXxR/b/oG6cJzkfzE6M56h/x18nXopw3
Mfp9iJ6F2nhnm6N3L7/srFrNN/FXfEGq2iacd7ZX7Sy1++geZOjfTTPpBH3/
AYcKt9E=
         "]],
        FractionBox["1", "1000000000"]],
       Annotation[#, 
        Rational[1, 1000000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1HlM13Ucx/GP6ayJBCgYtZLQWil2eIJEyaELN93K1dZhq5BIMxPFaS0Q
M1334VGmOfEuhcqjdEtLcK7WxNQB3WXOAy0VDLXLrR6fP56/1/t4vT+fz/f7
+/x+mSVTxz3VKYRQ5+PE5SG80SOEk3QbzUwK4RN6LT2QHMJ+fJQawr/yhT1D
WIQS3nkpITxKh/PmohteRwK641X+qeZeo+V0A+8HZj5EgTWb1PJpM03Umyvu
EHem22gX2kbb8URaCJNQpXaV/a9Elj3y1RrMVovbrDvJXgPVFqg9KR4jnkIn
4+G4Ds3Qe1bcO3qsMxkJcR95jXglVmAIb576WfXu9A+aSHfQS+11Gfbw3Md7
Px5AvlqS/hrnWYvVSOFZR1/Rfxnp8izrfMHXIf+SnqOlaovF0/XHOncFnYYJ
6uX0Zr1K8U10Fv9MJMfvRb5RXIti+xSa7ca/StwfS8Qj1HbyXc+fIO9Dr0Nf
3KKe5NzJaPd+P5e3infRKvOzcV5+AR2JIfS0z2i+ndiBE+rFdDvdEN95XIen
DXeqf2uPU3Q9SpzjDrqL57O4F8YhjTcVL/DWWuNpez6DOr4R+vW0njZgt7gB
/zjLbnk7/2yz1XE/Z260RjGdqXdGPIu28DfjbvX5fGfNvKc3R/wcHoxnj9+x
+vu0g26ko+O91P9KvkQ+XvwQUtTHm5mD3+Pz4TfMsNdpupn/Hr0t9EX5VvoS
bTV3BU1HpXWqMDLeQ/ko2mS+GsM8ezZysMc6x5HDOxzZuA25mM5bgT7ea6H5
Fv4i2lfeHH/DWI530YrB8V5jEIZhKMrNT0OmmQKzefY6Jx8UfyPx90Qz6Hzc
xTOPPsI3xHpDkYG9qNDLj+9d/zEzZThv/b1qF2gFDXq9+fLEz4t/Uv8ZS81f
Iu9hphP9WH4NvVX+lvhtLMY78T5jlfnDzrmS/mj+B6xx5k/jfXAvuqpf1G+T
bxIfE2+mt9u7Tu17/u8wN/432KMp7of/eBbR4ziGkbwTzIyiRbwFvIW0kGbx
5lp3AE3lKY1eNKrVqGWrrY7v0ToDsRVb8JfeAvo3XUj3O8cB/GLuUHwmM1ny
GjqAnvI8XXhPx/uMozxH8KveoTiHi/F/AF+L96HSGSfK91k/HX+af5MexRG0
6H2D9bzrsDbeKTMHrX91/E/Xy8VE9cdRFn/P6jeq9cMN6MXf1TnOqDeI7/W8
9bTIGsvU6uP3rXbY+YP4IGrjXTczBY28CfppajnyXvFOWbe/+uD4fuM9QinK
9PrR7db+H3XC9II=
         "]],
        FractionBox["1", "1000000000"]],
       Annotation[#, 
        Rational[1, 1000000000], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1nmQz3Ucx/EvpdFMtBEb6z5y1LLt2rXIMROSe7RYdh27KlfWESnnTMpR
ucK6zWhSzIgKI0z5AysahGI6yS2qaYqZjqHH+4/nvD7v9+v1/ny/39/32K1f
PL5fSbkkSeqXT5IRDybJ4SpJUvhwkhSgkXp51SRZgVLk6T2Lf1OS5D/c4XeX
74leGPVQkpThMGqjCT+bnpPtY64vdthnJ3YhjVcLfeR68nrT3vRupSQ5j1zr
dL0c2oKOQo9qSTKSjqycJBfsWwGDHHswCrDAfrN5A63zsQWbkY5c2Wzza/kT
5CbitL2q8aojFW300vjPO7+96mz+bppDB6Kb+QH0rr0S2RRaxB+B5/Cy3hEc
RVO0lX2HXozztH7c/Bz7N9F7jT6mztc/yL9HfcN177F+Um+zc9iCEv1iv8F4
Op93y3oBvU3foLVk5tE0OpdWt3cN8+nqjeopcV6YivO8DfY5y2uBM8hxDt/Q
UziJ2WZH2/siLmC6mfVmvuadRjt7HtO/SkuRaX4F/we5Zerm8czQZnQ5/Uc2
h9dKZrreNFzWu4QfHeskPYXj+AonUCg7hg6hS+WXoJbslHhGHG8ybWnPbH6q
+pz6J9RwvHz1I7R8PF90sLo2vRLPEK2pzjWXwW9Na6gv8y4hLe6TumacN9bg
xXhm6Eqsxlj1Kpplvo35NPU1s1dRV79AXSfuJ39ovCPqYfTpwDV1jeeI/inT
TqaDPerKjItj4YTee3qbrFu67iz3rZp8ddxndo26DrrEXtgu8xGG81rY5y2z
O8x2te6it9O6xHoX/RjtZe+au4PBjlVR/pbnbj/vpvoG9sXvTHthFT+Ldx3F
+kOQYb+WWMQrUlfAEuxQF9JneAV0aqzjutXd6SZ+W+u51petKzqHK/R++jYt
pV/wVtDD8Z47/mT9I+qj4aG18/iSbuX3439I8+y5Lb4PcTxeD3THQrMzZa5a
X4tjxXsU10K7yf4e77XZ3+is+HagGX+4XlM6zPyjoeom9Fe5ElpP3ZGXGe+G
epx6A22FnPgmqLPpJJkGdIi6If3F/Nh4Z9VteU+Yb0drq2/ybqAxf6i6USiv
Hi1U14/z5s8wM9p6lN4Y2llvXTyP6lL5LfyVtJU6U3+b+/2U6+2Mg9YHMJ+/
UW4BLVMfwj7+3vidzCxFuvk3+d/JfY8leo3kFtO/5VL1KqFyfPfjO6e3HMuw
BxPMHqSHcCDuJ8rwrmzfeD/id/fclVkfQkZ87+g0z/Z0bDO/3d7b6c+843qz
zG6lM2mx7Eh7FNFX5abF99Y6RbYNrULL6Z2VXyR/hk52/JfQSd2RdqSd4m+d
YzSTbUxT7Pmt/ivqqdhvn8/xgvlPZXfH9zd+Q6TKNVffim+07G36QNxT2dHW
R2mJzBFaJDccuer28RzTDvEd9RuUl53jnP9Sv07n22MeZukPMNvYOkt+PM2k
6+U2YC1Oxv2nDXgN0V+dr86jg+I9t99EOgnrnfM6rEUGf5XeMVqkLkad+Lul
vu6Yx+k1ukZmNUp4M5xPnl5/VMAHqCr3Pr2X/0f06Wd6C80sxiLswoj4LsXf
d94nNHFec2XfiP8BzPXG/3P5JQI=
         "]],
        FractionBox["1", "100000000"]],
       Annotation[#, 
        Rational[1, 100000000], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwl1FmIz1EUwPFrnywzZouxj2WyzEKRFArhQRiDITWmZB/ZHyxZC2XfspUk
kshWwjCWGdn35cEeigdbopjsn5uH73zPPfec87u/3/z+v8wx0wqmVgkhdPGn
cUoIK+uH0Co1hMq0EL6jmfioXHe+zc25BSapnYzliSGMTw5hBedwYXoIuTxT
zQz0SgohRS4VyViCRViMY/pvqrmB2eJpaitd4zseW6+zfsRP8QSNrA9yjnNl
o51r1tFbLq5AXXGe3kR+ojaZO1kncUd+i/3O9oa3cSr343FmLjMrW/xBXIZz
6IW++IMGaifwBbNWq9uFenI7OZ1vIQ3b4xp1kKC+Fipx0Xl6cFv33Z3b8WTX
3G1ebeTq3atnqr3pyBL3Rh98s/dQbU11DzjP/gI+wGnmvuM78X45FRn2Wutr
xC04E6M9nyJ0UnfVnBHiKzxRzQ7ehnniUzyfS3moWUPUV/BLZ3iFAusL1kP5
Ir+O54pr9cNQTVxX7rj5VdR/sa7KxfEMKIgz4/9S3MaMDL7BJdwQc/Xm2/+t
56X4q/gzqmMA5sit4Vdczvl6z3OB6w3BOPnO5ozlF2YUyg1HlrqTzjdQfIK3
oqt4O69Xe43X8XUuMW98fE6cx83NSxOn4K71e07nbO6Ikfpy433qLTPzHGqI
c1w/ge+rnWnGFDX7eKN8lnwHLpUL4r+8xJxiXsxn5Iri+xN/D3yNf3Aij+Gz
9leZtTa+a3KbOYlX8gasj9cz57LaEt6j/pK4D7o5z694P+p/cjL3Vb8lvtf2
yniwXH8exKe5PTaZM0t9B3FPdfXM7MGH5Q7hCCri7zG+V+JR9p7rH6Xvbrwv
6zt8H/fQ2PpofMae19L43eCF/EmufbyWORniZ+o+xu8At5Rba2Ymr4nfCWdZ
zY+4aXwm4rbcJOX/9+wfN5Ghow==
         "]],
        FractionBox["1", "10000000"]],
       Annotation[#, 
        Rational[1, 10000000], "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5312, 4515, 4719, 4514, 4717, 4517, 4903, 4901, 4138, 4792, 
         4140, 4670, 4873, 5311, 5312}],
        FractionBox["1", "1000000"]],
       Annotation[#, 
        Rational[1, 1000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4797, 4672, 4676, 4861, 4678, 3693, 5026, 4671, 4804, 4674, 
         4795, 3716, 4797}],
        FractionBox["1", "1000000"]],
       Annotation[#, 
        Rational[1, 1000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4704, 4034, 4857, 4104, 4617, 4854, 4852, 4853, 4298, 4102, 
         4700, 5050, 5052, 4702, 4704}],
        FractionBox["1", "1000000"]],
       Annotation[#, 
        Rational[1, 1000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4510, 4118, 4512, 4105, 4499, 4106, 4493, 4495, 4299, 3598, 
         4506, 4300, 4508, 4507, 4108, 4510}],
        FractionBox["1", "1000000"]],
       Annotation[#, 
        Rational[1, 1000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{4867, 3794, 4871, 4868, 5309, 4865, 4867}],
        FractionBox["1", "1000000"]],
       Annotation[#, 
        Rational[1, 1000000], "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4324, 4503, 4000, 4501, 3998, 4539, 4001, 4519, 4324}],
        FractionBox["1", "1000000"]],
       Annotation[#, 
        Rational[1, 1000000], 
        "Tooltip"]& ]}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    ArrowBox[{{-1.2, 1}, {0.3656261737333204, 0.13270366218664575`}, {
      0.06771914560170122, -0.17705447588506507`}, {
      0.17254118152723774`, -0.16633346652518247`}, {
      0.24287816864889494`, -0.019495154509239}, {
      0.24287816864889494`, -0.019495154509239}, {
      0.23391518406945047`, -0.09023405817724009}, {
      0.23391518406945047`, -0.09023405817724009}, {
      0.2657225584129874, -0.04334199104476876}, {
      0.24634851994505694`, -0.043141589560121714`}, {
      0.24497536162423633`, -0.06673792423984266}, {
      0.24497536162423633`, -0.06673792423984266}, {
      0.25431909127799646`, -0.07273720865209643}, {
      0.25266973802496673`, -0.05943922020917251}, {
      0.2705325207059721, -0.06478879481221807}, {
      0.2705325207059721, -0.06478879481221807}, {
      0.2873994704916241, -0.07944316392207587}, {
      0.29997188087586324`, -0.07680635065289809}, {
      0.3399919856392869, -0.10479668223802481`}, {
      0.3399919856392869, -0.10479668223802481`}, {
      0.3925845007869496, -0.13015020055397375`}, {
      0.39373593759230274`, -0.14810058625030378`}, {
      0.39373593759230274`, -0.14810058625030378`}, {
      0.47492758392450307`, -0.22203163511688728`}, {
      0.47492758392450307`, -0.22203163511688728`}, {
      0.5584221038674096, -0.3318634553761308}, {
      0.6110146190150723, -0.3572169736920798}, {
      0.6945091389579789, -0.46704879395132337`}, {
      0.6945091389579789, -0.46704879395132337`}, {
      0.7281224575472753, -0.5441364979411998}, {
      0.7281224575472753, -0.5441364979411998}, {
      0.850652923667583, -0.7162748262834834}, {
      0.850652923667583, -0.7162748262834834}, {
      0.850652923667583, -0.7162748262834834}, {
      0.850652923667583, -0.7162748262834834}, {
      0.8728979578705099, -0.7689919521458588}, {
      0.9213203028348589, -0.8426184470116205}, {
      0.990021543722887, -0.9848659461692522}, {
      0.990021543722887, -0.9848659461692522}, {
      0.990021543722887, -0.9848659461692522}, {
      1.0296490608620266`, -1.0569282252306726`}, {
      1.0034463541377554`, -1.0035072022563436`}, {
      1.003284625611389, -1.0075418299563803`}, {
      1.003284625611389, -1.0075418299563803`}, {
      1.003284625611389, -1.0075418299563803`}, {
      1.003284625611389, -1.0075418299563803`}, {
      0.996370017785795, -0.9922171316881888}, {
      0.9941965704216871, -0.9884338284465501}, {
      0.999283959857565, -0.9989336550118749}, {
      0.999283959857565, -0.9989336550118749}, {
      1.0016425308985883`, -1.0034502632740256`}, {
      0.9985091934203936, -0.9970711979258255}, {
      0.9985091934203936, -0.9970711979258255}, {
      1.0006655049197468`, -1.0013898826654632`}, {
      1.0002275568157435`, -1.0004091732418103`}, {
      1.0002275568157435`, -1.0004091732418103`}, {
      1.0002591071998266`, -1.0005435753781171`}, {
      0.9998605970759271, -0.9997308686248475}, {
      0.9998605970759271, -0.9997308686248475}, {
      0.9998605970759271, -0.9997308686248475}, {
      1.0000696587544113`, -1.0001375170297055`}, {
      1.0000696587544113`, -1.0001375170297055`}, {
      1.0000696587544113`, -1.0001375170297055`}, {
      0.9999814631422528, -0.9999597066953214}, {
      0.9999926218939035, -0.9999871500335543}, {
      0.9999926218939035, -0.9999871500335543}, {
      0.9999959747036634, -0.9999905090303173}, {
      1.0000113244675142`, -1.0000221511145038`}, {
      0.9999981357397462, -0.9999967400529823}, {
      0.9999981357397462, -0.9999967400529823}, {
      0.9999981357397462, -0.9999967400529823}, {
      1.0000010312041612`, -1.0000017373910746`}, {
      1.0000024338707796`, -1.0000047468096418`}, {
      0.9999999341386083, -0.9999999910766703}, {
      0.9999999341386083, -0.9999999910766703}, {
      0.9999999341386083, -0.9999999910766703}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.0000000561587097`, -1.000000136010001}, {
      0.9999998674736963, -0.9999997345975675}, {
      1.0000000755605665`, -1.0000001420075226`}, {
      1.0000000138379206`, -1.0000000371562732`}, {
      0.9999999560864699, -0.9999999120897327}, {
      1.000000030261381, -1.0000000583152628`}, {
      1.000000030261381, -1.0000000583152628`}, {
      0.9999999864850609, -0.9999999734185284}, {
      0.9999999864850609, -0.9999999734185284}, {
      0.9999999864850609, -0.9999999734185284}, {
      1.0000000029002634`, -1.0000000065894645`}, {
      1.0000000039647554`, -1.0000000079485225`}, {
      1.0000000039647554`, -1.0000000079485225`}, {
      1.0000000039647554`, -1.0000000079485225`}, {
      0.9999999974764008, -0.9999999950847158}, {
      0.9999999983719277, -0.999999996609719}, {
      1.0000000009444598`, -1.0000000018978699`}, {
      1.0000000009444598`, -1.0000000018978699`}, {
      1.0000000009444598`, -1.0000000018978699`}, {
      0.9999999992857393, -0.9999999985770052}, {
      0.9999999995895013, -0.9999999991545392}, {1., -1.}, {
      1.00000000019104, -1.000000000381821}}], 
    PointBox[{{-1.2, 1}, {0.3656261737333204, 0.13270366218664575`}, {
      0.06771914560170122, -0.17705447588506507`}, {
      0.17254118152723774`, -0.16633346652518247`}, {
      0.24287816864889494`, -0.019495154509239}, {
      0.24287816864889494`, -0.019495154509239}, {
      0.23391518406945047`, -0.09023405817724009}, {
      0.23391518406945047`, -0.09023405817724009}, {
      0.2657225584129874, -0.04334199104476876}, {
      0.24634851994505694`, -0.043141589560121714`}, {
      0.24497536162423633`, -0.06673792423984266}, {
      0.24497536162423633`, -0.06673792423984266}, {
      0.25431909127799646`, -0.07273720865209643}, {
      0.25266973802496673`, -0.05943922020917251}, {
      0.2705325207059721, -0.06478879481221807}, {
      0.2705325207059721, -0.06478879481221807}, {
      0.2873994704916241, -0.07944316392207587}, {
      0.29997188087586324`, -0.07680635065289809}, {
      0.3399919856392869, -0.10479668223802481`}, {
      0.3399919856392869, -0.10479668223802481`}, {
      0.3925845007869496, -0.13015020055397375`}, {
      0.39373593759230274`, -0.14810058625030378`}, {
      0.39373593759230274`, -0.14810058625030378`}, {
      0.47492758392450307`, -0.22203163511688728`}, {
      0.47492758392450307`, -0.22203163511688728`}, {
      0.5584221038674096, -0.3318634553761308}, {
      0.6110146190150723, -0.3572169736920798}, {
      0.6945091389579789, -0.46704879395132337`}, {
      0.6945091389579789, -0.46704879395132337`}, {
      0.7281224575472753, -0.5441364979411998}, {
      0.7281224575472753, -0.5441364979411998}, {
      0.850652923667583, -0.7162748262834834}, {
      0.850652923667583, -0.7162748262834834}, {
      0.850652923667583, -0.7162748262834834}, {
      0.850652923667583, -0.7162748262834834}, {
      0.8728979578705099, -0.7689919521458588}, {
      0.9213203028348589, -0.8426184470116205}, {
      0.990021543722887, -0.9848659461692522}, {
      0.990021543722887, -0.9848659461692522}, {
      0.990021543722887, -0.9848659461692522}, {
      1.0296490608620266`, -1.0569282252306726`}, {
      1.0034463541377554`, -1.0035072022563436`}, {
      1.003284625611389, -1.0075418299563803`}, {
      1.003284625611389, -1.0075418299563803`}, {
      1.003284625611389, -1.0075418299563803`}, {
      1.003284625611389, -1.0075418299563803`}, {
      0.996370017785795, -0.9922171316881888}, {
      0.9941965704216871, -0.9884338284465501}, {
      0.999283959857565, -0.9989336550118749}, {
      0.999283959857565, -0.9989336550118749}, {
      1.0016425308985883`, -1.0034502632740256`}, {
      0.9985091934203936, -0.9970711979258255}, {
      0.9985091934203936, -0.9970711979258255}, {
      1.0006655049197468`, -1.0013898826654632`}, {
      1.0002275568157435`, -1.0004091732418103`}, {
      1.0002275568157435`, -1.0004091732418103`}, {
      1.0002591071998266`, -1.0005435753781171`}, {
      0.9998605970759271, -0.9997308686248475}, {
      0.9998605970759271, -0.9997308686248475}, {
      0.9998605970759271, -0.9997308686248475}, {
      1.0000696587544113`, -1.0001375170297055`}, {
      1.0000696587544113`, -1.0001375170297055`}, {
      1.0000696587544113`, -1.0001375170297055`}, {
      0.9999814631422528, -0.9999597066953214}, {
      0.9999926218939035, -0.9999871500335543}, {
      0.9999926218939035, -0.9999871500335543}, {
      0.9999959747036634, -0.9999905090303173}, {
      1.0000113244675142`, -1.0000221511145038`}, {
      0.9999981357397462, -0.9999967400529823}, {
      0.9999981357397462, -0.9999967400529823}, {
      0.9999981357397462, -0.9999967400529823}, {
      1.0000010312041612`, -1.0000017373910746`}, {
      1.0000024338707796`, -1.0000047468096418`}, {
      0.9999999341386083, -0.9999999910766703}, {
      0.9999999341386083, -0.9999999910766703}, {
      0.9999999341386083, -0.9999999910766703}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.00000018930493, -1.0000003487112612`}, {
      1.0000000561587097`, -1.000000136010001}, {
      0.9999998674736963, -0.9999997345975675}, {
      1.0000000755605665`, -1.0000001420075226`}, {
      1.0000000138379206`, -1.0000000371562732`}, {
      0.9999999560864699, -0.9999999120897327}, {
      1.000000030261381, -1.0000000583152628`}, {
      1.000000030261381, -1.0000000583152628`}, {
      0.9999999864850609, -0.9999999734185284}, {
      0.9999999864850609, -0.9999999734185284}, {
      0.9999999864850609, -0.9999999734185284}, {
      1.0000000029002634`, -1.0000000065894645`}, {
      1.0000000039647554`, -1.0000000079485225`}, {
      1.0000000039647554`, -1.0000000079485225`}, {
      1.0000000039647554`, -1.0000000079485225`}, {
      0.9999999974764008, -0.9999999950847158}, {
      0.9999999983719277, -0.999999996609719}, {
      1.0000000009444598`, -1.0000000018978699`}, {
      1.0000000009444598`, -1.0000000018978699`}, {
      1.0000000009444598`, -1.0000000018978699`}, {
      0.9999999992857393, -0.9999999985770052}, {
      0.9999999995895013, -0.9999999991545392}, {1., -1.}, {
      1.00000000019104, -1.000000000381821}}]},
  Frame->True,
  PlotRange->{{-1.3, 1.5}, {-1.5, 1.4}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 169},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278754953]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->792799295],

Cell[TextData[{
 "With the working precision set to ",
 Cell[BoxData[
  FormBox["20", TraditionalForm]], "InlineMath"],
 ", by default ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PrecisionGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PrecisionGoal"]], "InlineFormula"],
 " are set to ",
 Cell[BoxData[
  FormBox[
   FractionBox["20", "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->1087085504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"3", " ", "y"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2145912710],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.99999999999999999999999999999999999999`20."}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
      "-", "1.37638497240654581741970840207800708884`19.999999999999996"}]}], 
     ",", 
     RowBox[{
     "y", "\[Rule]", "1.67867608195212037654703522556762952552`20."}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{557, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209285780]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1677],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " aims to find a global minimum, while ",
 Cell[BoxData[
  ButtonBox["FindMinimum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindMinimum"]], "InlineFormula"],
 " attempts to find a local minimum:"
}], "ExampleText",
 CellID->316126506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "0.5"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1726927757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "6.250000005820451`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.9559659271231472`*^-10"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2.00000000116409`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{256, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8559842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindMinimum", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "0.5"}], ")"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283369064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.2500000420815556`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "7.028915517410935`*^-12"}]}], ",", 
     RowBox[{"y", "\[Rule]", "2.000000014027185`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{248, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22280327]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "0.5"}], ")"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<=", "4"}], "&"}], ")"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", ".02", "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<global minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1.8"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "2"}]}], "}"}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<local minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1.8"}], "}"}]}], "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], "]"}]}], "}"}], ")"}]}], ",", 
   RowBox[{"ContourLabels", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->288919193],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnQecVcX1xwElaBALAio2VAQLNgQVNA4iKCWYiA2IiUpERKogEIoKalRA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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2258, 2506, 1041}, {639, 732, 199}, {2061, 2402, 726}, {
         2318, 2319, 637}, {2170, 2115, 693}, {2320, 2147, 918}, {2039, 2170, 
         693}, {1421, 1043, 693}, {638, 639, 199}, {637, 635, 154}, {2322, 
         2321, 639}, {533, 726, 154}, {532, 302, 1}, {2315, 2000, 636}, {2316,
          2315, 636}, {2413, 2038, 1241}, {735, 1420, 693}, {2504, 1863, 
         1814}, {637, 918, 635}, {732, 656, 199}, {655, 859, 1}, {1868, 2005, 
         655}, {1420, 1421, 693}, {532, 534, 302}, {2147, 2317, 918}, {656, 
         921, 654}, {735, 639, 638}, {2148, 1864, 649}, {1873, 2463, 533}, {
         302, 533, 154}, {1420, 735, 638}, {1241, 1040, 636}, {2403, 2066, 
         732}, {2067, 2323, 735}, {859, 532, 1}, {2463, 1932, 533}, {2321, 
         2002, 639}, {654, 655, 1}, {2116, 2067, 735}, {1864, 2003, 649}, {
         534, 533, 302}, {921, 655, 654}, {1043, 1242, 693}, {1863, 2068, 
         1814}, {2003, 2041, 649}, {2040, 2414, 1242}, {2037, 2504, 1814}, {
         2505, 2037, 1814}, {2462, 1872, 532}, {918, 636, 635}, {2001, 2318, 
         637}, {1769, 635, 636}, {656, 654, 199}, {1931, 2462, 532}, {2006, 
         1869, 656}, {726, 637, 154}, {1040, 1769, 636}},
         VertexColors->None], 
        PolygonBox[{{2232, 2261, 1044, 1013}, {2260, 2040, 1242, 1043}, {2323,
          2322, 639, 735}, {1932, 2061, 726, 533}, {2005, 2108, 859, 655}, {
         2108, 1931, 532, 859}, {2259, 2258, 1041, 1042}, {2257, 2259, 1042, 
         1040}, {2261, 2260, 1043, 1044}, {2000, 2413, 1241, 636}, {1872, 
         1933, 534, 532}, {1933, 1873, 533, 534}, {2506, 2505, 1814, 1041}, {
         2317, 2316, 636, 918}, {2066, 2006, 656, 732}, {2038, 2257, 1040, 
         1241}, {2414, 2039, 693, 1242}, {2319, 2320, 918, 637}, {2153, 1868, 
         655, 921}, {2002, 2403, 732, 639}, {2402, 2001, 637, 726}, {2041, 
         2232, 1013, 649}, {1869, 2153, 921, 656}, {2115, 2116, 735, 693}},
         VertexColors->None]}]}, 
     {RGBColor[
      0.38411627715210295`, 0.21510768699696664`, 0.6569022118227853], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlktsV0UUxu//OfcfKSBoBES0VJfQisaFsdREFy4gIok8Wh62JBBDKVhc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlEtIl0EUxUcdne8jzdIitUVFtSxDql0UFBSkvSAotJdGm9REWkSQtQii
NHtCUD6yKGhfLaptvjaaUVAWUtAqWkTvXb/TCf6H/5177tyZO/fcb0nzsV3t
hSGErSCCtXkI1SkE+S7huJuFsBBfO/ZMUQgbWK8HnwtCWEXQFLFz4ZvhR8F2
uG2AX0jwP+DH4KeLQ3gL1mD3JufuBQ3Yr8E68i0ClWzcBFo56zt8F/Yp8IT1
U/CS2C2gjNjFoBG7H/4LZ3Wwfo59D3wgNkbffVz3ia7hFfH1yWfNgL3Y10EN
+2+AOmLPs6eQu0ZwmvUC8AnuGTmr4apAK7naQBl2C/xX6t3HehJ7AnSR+yPx
+8l9h/X7Ivvaif+N7zH57uPrZn0h99115izs0ty5mqL3joDi6BzlcLPBAdYH
o9++QneI7oFqvw3eFfkNTmL/Sj7rEZhMPkO5h9Vf1j25a60tdC1zcudWTT/h
23LHPoQfzd1T9fIN+JPcE/VCNd1ifx+owu7Ed0W9BpejfR1wNbnf7kiBa3kB
PxJd00RJCOdAE2iEryC+Jbe2pJGryZqQFqrJNwi3E98KuDrus5p1ASiD62HP
AHZ3cq9XwQ9hH8J3An4lqCdXQ2Zbmt+RvEexyvmAe3SCfrgx0JN8ps6qhV/O
3lFQEq0xabU9uffSrLRSpR5Ea0baPcx6/n8NH5eeM7+9Zmoe9mZ8pdjl/I+z
fyrz22uGVFvIPVuqUWcvAyn6Dkcza1pa7ivy2/+buegeXGO9O/ntpPmxzD1R
L5RjY2bNSCuaQc3ymcza10yf5S2+gYvR7zWE82bmXktzurs0Im2ohmG4pZm/
HdJws3qT+e3U88rcM69Zl4b3JNegu2vmmpJnWrM8jW8AezCzrZn/C5+2jxE=

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5453613928442013, 0.49546939652301614`, 0.8835517282349687], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVVcVxs/ce+495zgUBunMMFBQY+treFWYIQi0NQwJtAOUh4kPYgIO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1ol1UYxp/9n/+ec86XkiKHY/aC2psR9CalUzMz0rK1IoiScANL+uCc
pRUsXEniSs2c5ZxOXYY1MaIvZVSUr9EsZpCWm1lIiJBOndqHgux3dfXh4rmv
c9/nPufcb881jU2PzCtlWdYCymBXyrKJIcv2I/dUZllDkWUbwBn4JrAvZtk3
4GieZUNsfAvbHvbMwLYKfgTdL2AkzmrArcjL0bdiH8CH8K/ZcxL5D9CG7+fB
BXx/B5agu4jNQ+xdWracsb+u7LWx6KvBOM5qZP916O4B3egWgwvYX58sn63I
ss3Ij2Ffj3wHd1yFfjhrc9FfVvLdV6Gvq/Ab+uB98D0cu5R7jYOvDH7bLM7r
ZO25wrE4AR7G33xsjuDvVfR10W/Q3V+GL0D3N3wH+5fAm+BnsTnJeQPYnMbX
52A+chNYi24dOIhtLTYtyJNBA/wz0IVtY+FYnQNb0I2KzsX5kmM5WNiXYtqM
rg9cAt/G/sXIrdF3uwX7JuTXuVPO2z9gbQy8N9rXObCFu98PX5g7hz8jf8Xa
F/irKvvtNwa/RTH4CP1O+JfIp7Dv5y4Dhe/aCz6JrjHVlmpAsd/A2k+5c3An
8lzQAd8BpmB7Hn5GucTnFOxnw9vRPQFvh2/DZmalczyEbgy8Bd0g/Hbk25LP
Vg09rlxGv30O+meQH2DtYMln6m2qUdWm3tgGbwVl9JeDb9GNjo5NDzbT0V0B
H8Z3BWtb+b4EFuWuUcViAH112THpRt4Mmjn7UO63zAFrc79pBHetTvZ9nP01
6LrA4dwNekixio79cHAUeTtnDOP9V8HfVv8mv/1S1qah24nNRfb3gp7gHlVv
dskeeQ24C/sf0K9H7oy+m3LyBr7akntXNbJavYmPsRXeMwl5N/rt6L7nijPg
K7HZj/3v3P8A8lYQc9fgeGzfxWYdcge4Fz41uVcnqn6Da161rppbhtwW3Qvj
wT5s9yTf9eNK5/YAWFY4x8f5NoPlJedUZ81kf0vuM0+o1wrnU/d7LzimimUn
qE2eMZot6+GH0b0fHMsR8N8KnyHfyvepwjPhv1lQdi2uCa4t1WQdcnv0rFHM
jmH7WuH5opn6V/AM0ezQjOiPPlNnqWY0S+ujZ4dm6ovY35AcqyH8van5Cv7M
HfNfo2tCtXC1Zgr2NcnzZQEoId8MnkWuB3cjTwan8TUBn08FzwzNCs34K9GN
TM6tfOwK7nH19mDus1dE15bucB/6vcm5+Qe+CD4pudZ0hmZrA3xv2THoiO5p
9bJmnmpVPrRXNavamQc/VuEaUq/++H+vKQea/TcFzwb9A96BT0uOjXpidHJO
lUvNhCeDZ55mnXpqFnwTvD93Tz4dPYM0e9STL6C/Njk2mkEbo3tSvag9DypX
wf8G1dhC5AnJtaQZr974NDpW6pFXgntEtacanB6dM+VKM6MK+0eDa13/qNXB
/zD9uxSD7uAeUu8ohrXwPDmX+mf/C1D1E0M=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6688013508722924, 0.6962398622293419, 0.9118919729991575], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgnwFdWVxvu97ve6eypKjRJNXOCPC4sriyUIfxbBDUTWAEnVaMYFRKOi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnnQjmUUxp/3fd7vvZ/njzLTFFIUylJRaDLIvhStfEJ/NDXpI7Jna1Gy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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.784833771866956, 0.854402032803823, 0.904084178100232], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3n8llWZxp/3977P+zwPODNCOiqgyQ8EcSlrssA+08gygLiVoCjKMlYq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mUV2MYx+/c+f1+73unbIfjHFooWsjSiRKOpQVRHEslkxbZKioMrbQo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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8913019369690334, 0.8899063289206433, 0.8563865355440978], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmFtsllUWhr/v//9+B0w8BL0ZdTyVijqeoNh6MYqO0GTMEEVtKQqleCNC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllFuIV1UUxvf//z+es7eKGeRDiOakhJGYhEMZSGjCgKKE4OiMzYwjVIOm
oak4WWpqKuYNUxF88EI3rxPjKOVEGfpkEUSJeQkf1EpHMPPBdLz0+/gePs5a
+1tr7X3W+vaumvnO5LnlEEILyMCcPIS3wNBSCF34T8cQToGDlRD+IfBJ7P7g
OnYbaw0phDfAaZJPgpFwM8FWuA7QWRCLPxyuHazD/lg14f6g/jb4HWAg9T6B
nwC3CvwA3wx/Dm4P9V/qEcJYYl7HbkzeaxH+fPgv8WvgZ3DmTZz9RzANuwdc
otZo0KDz64ysTSd+IbmzQMROoA5uGlhJ7ApwouIzqPY8cppK3mMxtX8Gdfi9
WH8N/pi+ZffkMrlXomtPAPexF4AO/mU89Xtiv0fOrcw91V7fqEcV76nefAB/
O3OPhsCNZ60Vexhrg7AHgkfYN6nfmvyP+reboBV7sfoP10TOi8k9Vm+3gAbs
p6Jz1fMR+GOiz/oqZ9zLv20GF7CDekj+amJ+Y20K+S9gV4FGao/LrJXD4PGS
NTMSbiz1aqk3mxJtcF+A9uCYGckz1OxOkV9L/Cj8rZl7LK10gecza2YJuXPB
DfKPgrtw90ANXHPZvakD6yvuUZ58Zp21NnNv6/A7M/f4TWrtBvepNZj9vsbe
Ax7gv1Ky1qYW1pI0p16vYe1B5p5/lHwHpP1u/MPEthXW5nxwkFr7wQjy+4AY
PSPNpgX/MfzvwSHyzxJfTe4z2q/if1pTWJPS4hnqzCJ2cOFZ7lQM/ln8LeQu
wH+O2KX43SVr8EP85cl3S5p+H7s7WnvS1CVqfgp+DZ7BV9itue/K+WBtHwXn
gjXejn0g9788AY7k7pl61a/k3q9kj3uZZ3AH/79obfxC/UPEduSOrQZX4f4E
z8IPBfXJM9UsNaO/ojUpLSpmKfyy5FleZO1v+GvRd0Eaezv3TDXLniVrUz1T
r6TR7YXvgLQvjZ2Eq4p+y/Qm9MY+rjNj/wv/E/GnwbaK34iJ5E5KPqt6/Hvh
N01vmWawK3eP1JtuzreW2PrCs35ITDW1Nye/hQPAu9F7ai9p4DNyP8999n3k
T4erj377dId1lqbku6Iz6S1ZCM6X/aborduoGQa/eS3YJ0AN9hzWbhDbGH0X
daeWJM9Is9Eb1BytYWlXb/bL2BuJKdD+bPy+0ZqT1rTnKrgVoKvsmetuDIj+
V92R77D7RGtbmt4EvyH531XzW7jO6Fmq56q1Ovkuqeb/z4re8A==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1850, 2446, 2447, 2445, 2101, 2448, 2100, 2146, 2145, 1966, 
         1967, 2455, 1820, 2009, 2465, 1879, 1906, 2472, 1905, 1943, 1878, 
         2361, 2360, 1942, 2359, 1941, 1944, 1885, 2079, 2080, 2078, 2439, 
         2077, 2440, 1882, 2162, 2056, 2425, 2057, 2109, 1823, 2243, 2081, 
         2242, 2082, 2244, 2058, 2426, 2427, 2295, 2296, 1842, 1825, 2154, 
         1827, 2110, 2169, 2168, 2010, 2139, 2138, 2140, 2123, 2180, 2179, 
         2178, 1977, 2393, 2394, 2297, 2298, 1845, 1830, 2238, 2062, 2237, 
         2063, 2239, 2059, 2163, 2060, 2234, 2236, 2235, 2240, 2430, 2431, 
         2311, 2310, 2309, 1926}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1927, 2312, 2313, 2314, 2433, 2432, 1855, 2186, 2187, 2429, 
         2428, 2299, 2300, 2164, 2165, 2065, 2489, 2064, 2119, 2007, 2482, 
         2008, 1979, 2282, 2283, 2284, 2142, 1829, 1844, 2114, 1976, 2280, 
         2281, 1828, 2122, 2137, 2435, 2436, 2434, 2438, 2437, 2073, 2075, 
         2491, 2074, 2384, 1974, 2347, 1918, 2346, 1917, 2381, 2382, 2277, 
         2278, 2279, 1840, 2113, 1973, 2274, 2275, 2276, 1987, 2395, 1995, 
         2480, 1996, 1994, 2399, 2400, 2396, 2398, 2397, 2405}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2335, 1904, 2324, 1859, 1993, 2479, 1992, 1849, 2375, 2376, 
         2374, 1965, 1837, 1819, 2273, 2272, 2378, 2377, 1914, 1970, 2477, 
         1969, 1838, 1821, 2456, 1971, 1915, 2219, 2220, 2218, 2380, 2379, 
         1839, 1822, 2177, 2107, 2134, 2133, 1916, 2450, 2105, 2449, 2106, 
         2451, 2099, 2496, 2136, 2460, 2135, 1841, 1824, 2457, 2051, 2050, 
         2094, 2494, 2093, 1888, 2015, 2483, 2016, 2014, 2087, 2492, 2086, 
         1843, 1826, 2458, 2052, 1975, 2410, 2018, 2408, 2017, 2409, 2412, 
         2033, 2466, 1897, 2157, 1898, 2467, 2034, 2233, 2212, 477, 2215, 477,
          2181, 2183, 2054, 2488, 2053, 2141, 1901, 2471, 2036, 1893, 1946, 
         2475, 1945, 1889, 2020, 2484, 2021, 2019, 2089, 2493, 2088, 1846, 
         1831, 2459, 2055, 1978, 2031, 2486, 2030, 1891, 2337, 2338, 2336, 
         1907, 1847, 1832, 2286, 2285, 2386, 2385, 1919, 2388, 2389, 2387, 
         1981, 1848, 1833, 2288, 2287, 2302, 2301, 1851, 1997, 2481, 1998, 
         1860, 2354, 1928, 2353}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2348, 1922, 2349, 1856, 1989, 1988, 1215, 2391, 2392, 2390, 
         1982, 2143, 2423, 2424, 2422, 1261, 1980, 1237, 2411, 1280, 2090, 
         1145, 2339, 1146, 1239, 2032, 1892, 931, 767, 895, 2023, 2503, 2024, 
         2022, 2026, 2485, 2025, 1890, 1947, 2476, 1948, 1894, 2035, 2470, 
         1900, 2158, 1899, 2468, 2469, 1952, 2097, 1951, 2182}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2351, 1925, 2352, 1858, 1991, 2478, 1990, 1010, 2228, 2497, 
         2229, 2508, 2225, 2227, 2509, 2226, 2130, 2044, 2419, 1250, 1960, 
         1254, 2420, 1253, 2131, 2045, 2421, 1257, 1968, 2047, 2507, 2046, 
         2132, 2048, 2487, 2049, 1972, 1199, 2383, 1198, 1227, 882, 945, 2092,
          2251, 2091, 2252, 1887, 2012, 2406, 2013, 2407, 2011, 666, 894, 
         2095, 2495, 2096, 2027, 2156, 2029, 2171, 2028, 2102, 2117, 2166, 
         2167, 2103, 2118, 1895, 2254, 1896, 1476, 2253, 2217, 1950, 2216, 
         1949, 2215}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1930, 1929, 1920, 1921, 1866, 2190, 2191, 2188, 2189, 1861, 
         2241, 1862, 2501, 2502, 2500, 2197, 2196, 1874, 2194, 1870, 2193, 
         1871, 2195, 2325, 2192, 2326, 2327, 1875, 2198, 2184, 2185, 1876, 
         2199, 2201, 2200, 1857, 2144, 2149, 2150, 2104, 2152, 2151, 1867, 
         2004, 2461, 1865, 2069, 2490, 2070}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2510, 1903, 2332, 2334, 2333, 2404, 1854, 2499, 2231, 2224, 
         1986, 2223, 1985, 2267, 2266, 2265, 1959, 2453, 2365, 2290, 2341, 
         2340, 2364, 1835, 1818, 2452, 1958, 1913, 2121, 2271, 2270, 1964, 
         2454, 2373, 2294, 1912, 2345, 1963, 2372, 2371, 2293, 2344, 2343, 
         2370, 1836, 2369, 2292, 1911, 2342, 1962, 2368, 2367, 2291, 1910, 
         2366, 1961, 2268, 2269, 2129, 1957, 2418, 2043, 2417, 2042, 2128, 
         2416, 1834, 2415, 2289, 1909, 2363, 1956, 2262, 2263, 2264, 1983, 
         2221, 1984, 2222, 2230, 2498, 1853, 2308, 1852, 2307, 2306, 2350, 
         1924, 2513}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2511, 1999, 2401, 1953, 2362, 1954, 2125, 2124, 1817, 2358, 
         1934, 2357, 1935, 1937, 2473, 1936, 2204, 2203, 2202, 2209, 2208, 
         2213, 2245, 1884, 2207, 2206, 2076, 2205, 1883, 2159, 2442, 2443, 
         2441, 2098, 2444, 1955, 2120, 1908, 2172, 2111, 2112, 897, 2072, 
         2328, 2329, 2330, 2160, 2249, 2084, 2248, 2085, 2250, 2331, 2211, 
         2083, 2246, 2247, 2210, 1886, 2161, 2255, 2256, 2214, 1902, 2173, 
         2174, 1938, 2464, 1877, 1939, 2474, 1940, 1881, 2155, 1880, 2071, 
         2175, 2176, 2126, 2127, 1923, 2303, 2304, 2305, 2356, 2355, 2512}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2068, 1863, 2504, 2037, 2505, 2506, 2258, 2259, 2257, 2038, 
         2413, 2000, 2315, 2316, 2317, 2147, 2320, 2319, 2318, 2001, 2402, 
         2061, 1932, 2463, 1873, 1933, 1872, 2462, 1931, 2108, 2005, 1868, 
         2153, 1869, 2006, 2066, 2403, 2002, 2321, 2322, 2323, 2067, 2116, 
         2115, 2170, 2039, 2414, 2040, 2260, 2261, 2232, 2041, 2003, 1864, 
         2148}],
        RowBox[{"-", "6"}]],
       Annotation[#, -6, "Tooltip"]& ]}, {}, {}}, {InsetBox[
      RowBox[{"-", "6"}], 2514], InsetBox[
      RowBox[{"-", "4"}], 2515], InsetBox[
      RowBox[{"-", "2"}], 2516], InsetBox[
      RowBox[{"-", "2"}], 2517], InsetBox["0", 2518], InsetBox["0", 2519], 
     InsetBox["0", 2520], InsetBox["2", 2521], InsetBox["2", 2522]}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[0.02], 
    InsetBox[
     FormBox["\"global minimum\"", TraditionalForm], {0, -1.8}], 
    PointBox[{0, -2}], 
    InsetBox[
     FormBox["\"local minimum\"", TraditionalForm], {0, 1.8}], 
    PointBox[{0, 2}]},
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->336141137]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Minimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Minimize"]], "InlineFormula"],
 " finds a global minimum and can work in infinite precision:"
}], "ExampleText",
 CellID->1543511006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Minimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}], "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1936029081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["25", "4"]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{148, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->35197403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242298157],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " can use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " to find the global optimal fit. This sets up a model:"
}], "ExampleText",
 CellID->1667523556],

Cell[BoxData[{
 RowBox[{
  RowBox[{"model", "=", 
   RowBox[{"a", "+", 
    RowBox[{"b", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", "Pi", "c", "t"}], "]"}]}], "+", 
    RowBox[{"d", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "Pi", "e", "t"}], "]"}]}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"parameters", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683762628],

Cell["\<\
Create a function from the model and parameters, and generate sample points:\
\>", "ExampleText",
 CellID->211535797],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "t_", "]"}], ":=", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"model", "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "->", "0.2"}], ",", 
       RowBox[{"b", "->", "0.3"}], ",", 
       RowBox[{"c", "->", "0.1"}], ",", 
       RowBox[{"d", "->", "0.9"}], ",", 
       RowBox[{"e", "->", "0.55"}]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"f", "[", "#", "]"}]}], "}"}], "&"}], "/@", 
    RowBox[{"Table", "[", 
     RowBox[{"t", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"2", "Pi"}], ",", ".1"}], "}"}]}], "]"}]}]}], ";"}]}], "Input",\

 CellLabel->"In[2]:=",
 CellID->1790909421],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["FindFit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindFit"]], "InlineFormula"],
 " only finds the local optimal fit:"
}], "ExampleText",
 CellID->1520387461],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ffsol", "=", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", "model", ",", "parameters", ",", "t"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"lp", "=", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"PointSize", "[", "0.02", "]"}], "}"}]}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";", 
  RowBox[{"nfp", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"model", "/.", "ffsol"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"lp", ",", "nfp", ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->1520755593],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->994099202]
}, Open  ]],

Cell[TextData[{
 "Using the ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " method finds the global optimal fit"
}], "ExampleText",
 CellID->520058618],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ffsol", "=", 
   RowBox[{"FindFit", "[", 
    RowBox[{"data", ",", "model", ",", "parameters", ",", "t", ",", 
     RowBox[{"Method", "\[Rule]", "NMinimize"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"nfp", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"model", "/.", "ffsol"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"Show", "[", 
  RowBox[{"lp", ",", "nfp", ",", 
   RowBox[{"DisplayFunction", "\[Rule]", "$DisplayFunction"}]}], 
  "]"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->1967984934],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->223157356]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17575],

Cell[TextData[{
 "For nonlinear functions, ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " may sometimes find only a local minimum:"
}], "ExampleText",
 CellID->852609718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"x", "/", "1000"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73285609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "3.9108501677923626`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.5702528588727858`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34099179]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"x", "/", "1000"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->775860373],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62750017]
}, Open  ]],

Cell["\<\
Specifying a starting interval can help in achieving a better local minimum:\
\>", "ExampleText",
 CellID->220252790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "x"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{"x", "/", "1000"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->293976264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "26.97352558860916`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "26.851381348909204`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->378104969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->993018304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " finds a local minimum of a 2-dimensional function on a disk:"
}], "ExampleText",
 CellID->220009434],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "0.5"}], ")"}], " ", "y"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1642232626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.5734522220470394`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.9270953353893807`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.37482561490660843`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202757256]
}, Open  ]],

Cell["\<\
Specifying a starting interval helps in achieving the global minimum:\
\>", "ExampleText",
 CellID->1122017447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "-", 
      RowBox[{"Exp", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "0.5"}], ")"}], " ", "y"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "y"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->559037039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.6004629972522912`"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.657218786081364`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.7536998524938943`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->597801434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "-", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "0.5"}], ")"}], "y"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"RegionFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#1", "^", "2"}], "+", 
        RowBox[{"#2", "^", "2"}]}], "<=", "1"}], "&"}], ")"}]}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<local minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{".927", ",", ".374"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<global minimum\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.657"}], ",", 
           RowBox[{"-", "0.753"}]}], "}"}]}], "]"}]}], "}"}], ")"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->186971854],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFfQVYVc/zPmJ3d4vdjYq6Kja2Yndhd3e3qKiY2GLxUZRUxEFQWqQbiQvc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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{2098, 2113, 497}, {1127, 1232, 507}, {1126, 515, 496}, {
         515, 1127, 507}, {1217, 1126, 496}, {2563, 2564, 1127}, {1232, 1121, 
         507}, {2016, 2553, 1113}, {2597, 2062, 436}, {2423, 2386, 497}, {
         1883, 1778, 436}, {539, 1118, 506}, {2386, 2098, 497}, {2114, 2104, 
         509}, {1886, 531, 496}, {1103, 1217, 496}, {2566, 2565, 1128}, {2554,
          2662, 1118}, {1943, 1893, 507}, {1121, 539, 507}, {2020, 2126, 
         509}, {2018, 2554, 1118}, {1121, 1251, 539}, {1245, 531, 432}, {2027,
          2598, 519}, {2672, 2123, 532}, {2126, 2105, 509}, {2104, 2840, 
         509}, {1936, 1887, 497}, {2123, 2424, 532}, {2562, 2561, 1126}, {517,
          1162, 432}, {2595, 2596, 1162}, {2569, 2027, 519}, {1472, 1936, 
         497}, {1891, 1942, 506}, {2556, 2019, 1121}, {2871, 2676, 1250}, {
         2661, 2103, 506}, {2671, 2670, 1245}, {1251, 1118, 539}, {2840, 2020,
          509}, {1942, 1892, 506}, {531, 1103, 496}, {2063, 2597, 436}, {2010,
          2547, 1103}, {1894, 1943, 507}},
         VertexColors->None], 
        PolygonBox[{{2677, 2018, 1118, 1251}, {1778, 1902, 519, 436}, {1893, 
         1900, 515, 507}, {2676, 2016, 1113, 1250}, {1892, 1874, 539, 506}, {
         1887, 1864, 532, 497}, {2062, 2672, 532, 436}, {2553, 2552, 1223, 
         1113}, {2546, 2562, 1126, 1217}, {2670, 2122, 531, 1245}, {1874, 
         1894, 507, 539}, {2555, 2556, 1121, 1232}, {1864, 1883, 436, 532}, {
         2113, 2829, 1472, 497}, {2598, 2063, 436, 519}, {2019, 2677, 1251, 
         1121}, {2561, 2023, 515, 1126}, {2565, 2026, 517, 1128}, {2662, 2661,
          506, 1118}, {2424, 2423, 497, 532}, {1900, 1885, 496, 515}, {2596, 
         2594, 432, 1162}, {2547, 2546, 1217, 1103}, {2023, 2563, 1127, 
         515}, {2564, 2555, 1232, 1127}, {2829, 2112, 1901, 1472}, {1902, 
         1891, 506, 519}, {2103, 2569, 519, 506}, {2122, 2010, 1103, 531}, {
         2594, 2671, 1245, 432}, {2026, 2595, 1162, 517}, {2552, 2566, 1128, 
         1223}},
         VertexColors->None], PolygonBox[{{2112, 2114, 509, 1895, 1901}},
         VertexColors->None]}]}, 
     {RGBColor[0.3629665192245115, 0.17833396977030447`, 0.6271736685056853], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlktoXHUUxv+duTN37hXfCwvGim11qULVJtQEdSVCunDhhMmkEwRdldaF
Jm5sSV8k0EQUmvoo+IBoBR+LVhc+6gMCpQjZmCloDWObRuxKKmKKXfj9OB+4
ONwz557//5zzne+cO/c8u/fpPZWU0llJVbJcS2m0ntI5GVt63iH5SbZDjZQ+
L1Oakn1etqZsCyl+PyN9XfqK3l8o491vsn8pWZJ9XRevyfaVfg9mKZ2oxv3X
N6TUq8RZfHv2JwfeX5H+c57SU4r9Top7iUXMwSKl1yVzumsbdt37ViV8Rpzb
aeXyiXz+kc+NN6T0uO7J5LNVtgclE7Kfl2+3Fj7bZetIZqTfL/+PffZO6U8W
kTfYPJpFfuBwrB45kcNDErDk/XnfuQN/yZ+yt7PI913pv6iuL5Tfsg4sVKNm
6h2QfkSSVwOTZeMzqrMtyWKKmK/mxl1+16qBN7Ga8jkun756YEI+x/I4AybU
Sm77K1HLsvVp+XargfOqbJdr0Ys16/SOOBOOxe9V5wxPur6no5rakrNZ8OVw
I/p1NAsevS//vbJvlsxkcQ77PvOhzxx42JjSU+rYZmyn1IeDReS6pYhektMm
5XC35A/5bC4CX7B7QPqHjcDylJ736vek/E9Lv0/6y9LfziM2OO+X7YM8YoEJ
mIJn0zp9HNJzsB41jWcRt5MFLhPuGzUxO9Tb030vltG7AfeWXlRl+z2PnA8q
n1Nl4AB/B+wDlruM57pyuyYZkX5F52pl5NMzduB2UfaXZP9R+uEi8AIr8ofX
1EKu4FWkwGjKHPtB576VzKfo+Zrn+LKfS7avmg9bysiDHL6TfkbyiN69qVq+
l94v/bj0r8uYDbjwq3fIWBnxiMWZfvf6jJK6rYgZge/wmF70FzGf1DBUxPwz
S8wOOMO9q7L9JdmZhW2j8acX9ApsP9P7T4uYmwN6Xm0EDsS5S/IeuOYxMwue
O+zkslSNO4k5bAzp3WwW9xOLme+az+Ta8gy+kkff4d6/CpiVwR12A3MAhgfk
c0sefG+5X3AGjnJ+0ne3vJOJOyf5Wz4v6L6bVMtKFvxo+k4wot/UeGse9XDn
E/J9zPtwxnnA9yPOMfdMDfvsWBb7i1hd18+uAGt0cJjU/bN59HHNuwnetPOY
MThGvMVq7I1h7xzuv6RcLjaC9+z7PWXcD97gDraTzGsRv8mFGSQfdjG7GU52
vGPhPzXtcF1H7Q+vrhfRg3HzpGX+8H7Id270t49eM9+bPON8X+a989mp896r
57wTqQu+9Jkzu+FNFvjRryHvjUVzF3/6wPcJbMBj2jucvkwb556/p2B4Urkf
KsLn9iJ2B3zbVcQ77IXw296I+MScde/YNxvK6FfTXIEPM94Ri84fnjAL7Omt
3tXf6PlGI3Zz2zWB81z+/xzv864HZ/bQpTx8bmbflsFXepWywGvFuNBfbOvu
I99tvsHM03M693wZOL5WxI7gfvrVdqyTeXynT5i7Nc9vpYy9AE+Z9Y9y771a
4E/f6e+4OTxnbpEz30m+5fjwvmM7vN3pvvB+1PxBH/R/g3oZ+3rEHBgz/v8B
TIFJDQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJxFkz1IVnEUxk/3vdf7v/+gMpcGlzJbi8ovsKKmIGhwMIe0CIqG0IbwdTI0
E97BN2rIiqAP6AuiBqUh+xyEiOCdaoiKUJdsCSLSaPB3eIKGR89znnP+93y9
G48NdPUnZrYHpOBgMFvIzWrYjQjNhdk0vqGSWRlsiWbf0X+hV0noCMrx2JP4
T6D/IacXrQbm8f2FH8V+R84D+G54lbf4Z138KYMa/A64i94Or2B7XduDYlyb
Ba95/zK+a4jtmdkz+NlCsTvhQ9gH0G+b3jwHHy30rQ/wSxgXwU1TDZ/InyG+
h9xD4AhaH5g01TBBPVXQmumb3fTRWGd2C99Irl7ncvXmPS/Dv8Jn4T3wn/CP
8Bs+W3iFbzXhG+TtZfCokM/tJdBHPb3eI/FviH+Ivgg6sX+jd2I/LhTrC8uI
rYv61g9czdhrg3YzATasZk7wRbQFepjDbiF/nPwOMEX8dNTbw/S3CjuJqvWb
6Rb8Dc/1m9gbtBPfRUp8SmwpKtZ33IZ2PGr3p8CaoJq8li9gM3ZTVK2VVLs6
HaX5zvqxB6I0n5n3/pYadqWawRXiZ9B3UE9LJnsyaPfuewG/GnQbvrOX8FdR
ts90f6EZ+uyul3RLz6Pe8v1uQ9sKnibakc9qKuj2fWb3sDfhe58oZgz7fKHb
8pt5wltjxIwkijkDb2N+9f9u4rP3GnVrHuO/pSJqVv6b8l7v56rNe17P2w2F
duM363c3musO/f4ugMNgCa070y3PB+3Wb3odWjn/f7t+C/uCduc3sQJC1IaP

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4621392727305342, 0.35076860502739315`, 0.7665729707848687], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlllsVlUQx+93v358916CJrTlgciDS2MrifSFgNGowQR4oBjxyQQwog+K
oLL45IModaHUtHVhrxBMWIxLCAghuBETI10gMWwVNQ1qXJICjXyAxhj/P//T
6MPcc+6cOTNzZv4z59y45OkFT6VJkvwtKouaK0kyT7S4lCS/Z0nybjVJCvGn
SqhbAl+If1X898WvF79alyQPSn6m1peL9klmn2RGy57DW5wnycO5/ydr7y9S
eBhdoqOiL6XnibJ59WXPGVdp79fSf0zzXZK5VvIe5DvGiS9aJ+oSDYqGyh6P
ix4oec9a+Tlb882y/5bovGQ6NL6cWx77C0vWOUHjdMmPl92XtN4uOqv17tCJ
nYs6a6/GmvhfhQ+rJT+Y+p85PjGfklj2bdFEzS9VPEcHNrFNzEcrXntNP8/L
5seKz0nNp4m3tGydH4p/V26ZWuq4E3PiVItY/ab193Lbgncl+JxhNHLRLt27
q7Z7QfrrpWe1fOko2+bksTyWnPc+ffbmjic+T5T8gpL3MUfPOuX0A8l0at+W
quNIPG/OvQa/VTQn8LMhN4bADziqxbxRMvdHrvH98fC/RX4uGmdsbtX/M2X7
sEH7jhb+36/5dOkdCDvgFVt3ir9S/B2ys1O8FVrbrnGaeK2iF/T/bNnj5dQ2
x+lc/Zr3aP110XDZeCOvYImcd0SuyQe5uwX8pj7rjNT/5Jn8FBEXYkLMRir2
f1C+HxPdF3kGQ+j8XrzvRA8FLsAHOf1VvI90nkbJflL4/Jz9Z81Pad5QNr4u
hfyk1DHF51kV2yXXcyS7rDDOz2o8qP8Tqf1fqP3vJB4XxXyFZG7InBtywBrY
Y983hff+oPkR0enUsQdD4AecgDPOjW+9gf97FNc3c/eUzyX4mWiG+M+lrnMw
dA5+bqzj+4Xw/4D4+0W36n+5xjNV7wO71CjYpV67ow9wduaTI7/kFlzR55qj
d7HeE/Lkgzn71keub694XB95XyW7K0XD8u1Qydig3h8T71HR8Tr7MBh9o566
zG1/TBd5OUV9KW7zxbtJ67sz4/FuzffqXF1l9zD2IH9v7tgRN/AxteKY09da
A/PYpk8Sx7NR9+QE31dU7X+jdDTk7rUzNe6qugewTt9ZHbEcin6+LXX9g9sR
+bglcz2xhgy5BiN/BE6owTNRh+DqctTGSQn+JGqr+JzwwRgxnBRYbZOO64v/
/sEwPeE68SYU/u+rut+Bc+xxTyBDfe9IXePQmtR32YXAPzjsq3NNXi0Zs98W
juERjZsy9xj6N/VITqm3E1HXb8jmucxxpt6a4q6i95zP3H+QrYV8Z/SCsZ7Q
FHNq9OL/+gbyYzjsCqzSj7cGrtF7Os5zQHaacvvHGTgLveVQ5no+Ebm6Gn2Y
urqDeys1rrsD22ty3wf0cGp9YfTY4+jOXbvNWm8R9dTZdnO8DebHOwGfiXdP
1EFv+IT9PZnz3RZxh4etuZl7EP2HPjQ75uhrC/3YbyzswyKNi+mVda7NWdEH
qDlsghHwWBlvTHJf3FYxrvCHffj0b2+q+BwjoQc80zsG61wv7dJzsPB+YtIS
eogbtukPYHBeZhw+ovmSwvvR3RL60U3e0J+Ai8I+09euRV7w96+4l3j7NASW
uOfnxl3PXTQcPety1BL+bI+4g8/+uF+5Q2shA8Z472yMN0931GIRvf1w4I24
c378Ggh8oRPbYLMz3jYDwQeztfCTN9Sr8Y5qCnn49Ota1AH3W3/ccR3xvqBn
4PNw9CzeF+vijfFkblyCkxc1rs3dRzgrucYH3pvzA3vU4qbc9dgafZA4NBSO
OzHvin7E+rF4m4GdPVX3EXrIK7nfu2yjp08Ke0vFX5b7rcZ9cyXeWzujv4BV
aguM9ca90h+54K4eKtw/uKe3BR5+FO/PqvdulsynhdfWhM4pUbPogw8uGqNv
EL+toedk5ruf9Y2Z+xdrTYGlGVELzYFJdPVGb/gHfuaIRA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllF1MjmEYx2/v+9b73E8bWx8O2Gw+kzaysXyM2Wx0UMzHiY034oB8Jo4c
WKqhMcJUw9bYVOZjLcRGpKOobJQkrIWNAweZfB/4/Xcd/J9d1/2/vu/7eiYX
7V27J+KcWw9iYHPo3DbQg/JrjHMtyOWBcz+izmUmOfcn7txX9Ms4JeDvIfdh
swpuHXiL/B5sQH6FTZ53bmKKcyPoJ4mRAZcODuCbRo7PyL3ESIe7D2qRH3K2
D/kC/vnoJeir5Ys+SP4pxDyIfoV6H8DVBGbby9lG9ELwlNg/yfEJ+WNotRZQ
QyW2d9CzkLPBE+RNoBP7hejD8B8Cq70LPFMssAb/5fDHyH0UcOQGyLcfoQD7
8dgOEaOB+nq89QbtKpAbwQjKa/AutBqUWzOqgTsve2yH4ecyqypvsbuTnduK
fQ72HVG7kxtwt0O7i1HOHoXWg2rPBce9xZCvar6OPhv9EnoqOc6hnwUdcKfx
b8e3jvgXIzbzAfRW9OfoGehNyC85y0+yO36DPAjiMbOpJVadt9oVU7UWo7dH
reZMbEtDm00rfBPz+YbNSrhTIB3bCYHd/Q714+1N6S0px93Q7lx3PYuzMvhK
b7PMjlisI+j9UYv5F9uZ+FTjWw/fBlcNhuCSY9ZLY2BvQT3lwE0D37Etw2Y6
cktgd98Nyr3lVC7l6Cf+FmJ0E+sQZ5O85VSuEvhd6Du93b1m8C9uNuK0M6Pa
JVAasTtvQJ7jLbfetN5mRWC96o3ehLvlbXdORKzWqd5k1ZzqrUf1th2bJchL
vc02B36G3ktgvRRzdpV6DnvblSrwG24ReBGzHcsK7c50V5qhdrcxbm9HOzwP
PQ/7FOLN5zwR2s5p17RDRaH9Q/Tv0IzUa4a3u1XPXZpdaLukf0Au3AJvtTSj
lyAvxqee2J1R+/ekeetN/6BCbz6ybUbvg/8S2lvVP0S9KIZ81dM4uLGh/Tu0
o2e8zUiz0ZvQbia8xdKOXiPvMm+7oR1v4/M4tN3SjmiXtIPaPe3UCvLtDu0t
aCb/Aay8uLs=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5613120262365568, 0.5232032402844818, 0.9059722730640521], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl2+IVlUQxu/7vvf9c++WRm2WQkrgv0JBpS8ahJqK5QYW9qkP5mpgVsa6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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllV1Ml2UYxh/+7x9434fUlmjOmdZJFqstPdTNXIofaVs5WgcdqMBJKDVx
zlroPChTERVNU/sgp5uSZa2tmBxUsEZUwjqAlWA6J5pOwU1xZqbzd3EdXNt9
P/dzf77Xc79PVL617M1cCKEW5MG94hA2xhCGUSoLQqhDXgt2oZejn0b+Lg2h
B6dlhSGMy0IYC+qwfcHZYmxtoBf59SSEDuQO7PXIZzkrRZ4AlqB3yYd8N7mz
CL0JDGArI8du8j0JetG3o99FnoX/Ye6WlYRQVRTCCfTN6I2gCXkm8Z7n/tzM
sWZwtgDbavz78R8At9C/IufexDV8j/4X9lfopQL8hD6V+MVFrll3b3O2NLFP
F/oR0ErsLegHsQ2BeciHOHsE3/Ggnlzrcu7tA+rpT9zjdOQR/P/F9g56L7mP
cecH9CEwmDqHYs/SPND34HMe+VnwOHKOs3eJvxa9D/kfYrxB7avAcs0CvQB5
DvF+Re4G5ejH0f8kdm30LPbzve9wfwroZnb3C9zrPnJcSNzzKe4Gzr7MOcaP
2AY4exX5D85asPVFy+pB3LgSXYs40h89Y81WPt3kPwGmkv854h8m3orUtb6M
/je2hPk1c/cYqVdjrwHD1NaBfaG4Ah7i/hli/B7do3qbj08Xcmc0F+eif4zv
QfAz/rsTc2cy9m9y5lAzts/BpcR3DmWuUbVdAZvQV2XO3QfqkGenntUn3LtM
rMmpuVxDvqrMMeTbBo6k5rS4rJx9mTktLmsG27FfJ87dxBxuwfZbdC83Es++
FP3tvL+BuNqa+u2JsydTc2qUS9in0d+9aO6Iw+LC1cxcFCc+Qt4LZub8jS9G
c1Dcq8b+GbZPQWnwTHZga9SM6W8fegPyY6m/ld7ko+gTwYJCc/JFfKsz9y4f
vZVfor+F3szX6OWZYymH3kIn8S7k/Cbei565Zj2SNzfXcHYub45+i+01MCbn
mY3BNlY7Cnsd2IFtJziTeCdVYlsZzfVT2Ddj2yYOY3+GGIUlfsN6u0epcYLe
C/aGvGf+PvUNMcdpxKpFX5o6p3KppknICWcb8n7zR4vdg2ovBVXI1dG5xWHN
/gAYTPwN2pHbU+9GzeD/YtekWpYX+C1ox2m36U1ol+kNiPvaaR9m3nnaddoR
47C/lHpXaybaDb2puakdoV7qlSNxTxXaJdy5lvfOb9S+BaQdneHWzJwUFzWz
4/i+kPkt6c7+zDtKu0k9PU2sp6Jr1z9jA3J99FtWDs1KO0y7SzPbkvmb6Fto
R/ZE73jtdnFqfPQ/Sf+i9Xl/m57Ms9U30r/i4dQ2/TP+4+5gNJe1kx8ANkf3
uQ==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6348912080149632, 0.6417556982552245, 0.9111189261866778], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHmMltUVxt/51vd9B6GAgkWQvS1McUCEJgyLYJpGE4xiYSy2FGzVPyqC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhs+9597efc41KIMMaoGCxDhiRUi0RSxqDCQaKTIIGhUFHoxg
AlZBZKgPRGkLoQWHIijCC04JIUDRRApaMGghGiOgwItCiyDIEKdq/H5/Hv5k
rf2vtfY+ew37lE2bXT0rG0VRE8iB/WkUbQxRtJnF+/NR9D7yHDARfReYAj8V
jMP4FPbTkyjqD/9pHEWfgL+QD7M2GH4g/GXYFovwxOqOfw3cOHAmE0VfYz8Y
blDRcjt4HP+V+GSxv5sYRwucC/5d9E3E2wN/iLUi3HHiHUHOEG8Svq+gtyIf
ZO1NbBNsGrA/h34r/ivhb4C/MbHvKM5wDXtdnfpbl2B/CG4DOB37GzYiHyHG
fmx/jf0tPdF3ZPxNp5Cfx+YruNHgS/SLBccuYY++xO4Hqoj1Amtj4PPYL4Dr
ASYgR/DT4TNaI/6/6KuIfQAsxX558NmH4f8nsYejn0cewNqPyG8R42f2vgUU
0HuAFvgt8MuIVQdKid/OWk/kwB5biT0Ivjo4pmINBGuJtQbcjnyCeI/Ct8OX
I1ey1pI6p8ql7nQAsfqDI+iN6N/h+5HiRd7zRPAd6W5Ggk7kzoJr5zPO8wj6
PvShcMOJsYTYi1Pn+iz+9cRbBm5WrrF5GPuFqc9eBl5Gfim1fBr7ndi2Buc+
gBXoh9B3sdcx/Es4awa9Bn0T5x0Lvx6chFsLJsAtSr33OTAOfXzw3ZxEv4Dt
RVCdcw98i/wNGJH1N2zAtsAeHxJ7e8a1qxwqd6rh+aljKlanahj5ON//Q+Sc
KvZzYG/sPRQrh82LGcc8CPc9GJl1TvYSb0/q3h0FX4JtGfxc9YNqCv821srx
b867V9/GvlvePVuO/gX6yLx7cgT6s/i3xT6DzlaOXhv7jLORZ4F5kW3m6CzB
tasZkWC/uOC72Ra5N46h74vdI2vZqxnck/UZhhQ9A9T7vUui6DrkM9h35yxD
0HcF51S5THPOXW3q3CiH2xPPKM2mDGvX43sX6APXxf5vIDeB3YoFfgfz0Fsv
zbOt+G8DdezPcf73Xaj5ETvGZGIvZb+x6EOx/wn9n9S1rjv/O3jmadYpJ/04
/47g3u7A5j1ilwb33qnYs0k5US40o7rgFqSu3erYd7foUn/oDu/E/w71QOwz
atbJR7aaeZpNq/HP5z2jfkPvG9xbjZzhD+U7cS8/ELuXloOjsXvqAHxHcG8q
xw8F16hqUznWLHgHdMSeCeqlw8F3oZ6q4Ky3gQS9F/oFuLrEvTomdi3mg2er
avLz1Heuu67UTEfuBmbAnY89268tuhY041X7V+GzMOce2KlcJ64FzZw16Lvh
K/Ku4afgnk7cy5pBmqW/JH5LNFNbgnOk3KgnzhdcQ6qdD/BZD9+WupeqwDOq
1eBZXgE/E3kNazVZ13AfvVXBs30+MSYGzxjNFs1gvaUDUs9ival6C3oWPdv1
JvRCvhLU5hxTs/mK4NmhGV2HXB/8tqknSlP3uHpbPpsT94x6ZR3fci/6feB1
zlqBz6vYTwmerarhKrjRoBF5GGur4JvATdxVrPe+4Bwqd7JZAfdY8Ox/MPbb
/ERwLeuNXpf4DdLboxqZivxaalvNxIbEOVZuVXOatfXwXTnP3LPsNznx3at+
2uF6p75L5Vxv8ZPBb6/e5I8LrmnVsr6xOfE36Vv0Bs5FHp84lmaOaqM5uNZU
IzPgZib+V9E3X54458q1alC9Nin4rVDPTUNuTH036rGG1Hesu9U3VHKeAtgS
eT7+BzXAKy8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7078061296126511, 0.7589096884699754, 0.9127811618180771], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm0llUVxt/7je/3XhEkRcQJRJFBQBQI7rK04KqYpogo4pSWAaJiS3Gg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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnuQj1UYx9/d32/3Pe+7JIXKJZZS1q5atySlRkz3koh1GZQUhUmTSxcq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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7788770937779694, 0.8524156393824543, 0.9067527645461244], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmgm0lVUVx7973733GzDliSGYxuRASRoiUKIBKio8BVeIQkChKIiVpBZG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnuQj3UUxr/7299vf+/7bhrkOkNsK3e2WtmSQpHZluwIm+uUNOjCJEUu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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8443596421862515, 0.8742523244323247, 0.8774166415402622], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmG1sltUZx+/nvp+X+7nxy5Zs9YW6LJvC4qTKCntVly2ZZVCKkEBdHCi0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllGuIz2kUx5//zf/3+81ulmJct4SsJKWM+yK1TJiZpWSLdmNoDHMh12Fp
9w27bdhoX6xiKbdhLGPXuk3UTIiaMlPDC7nkmlu8YhE+374vvnXO8z3PeZ7n
PN9z+s2vmVmdDiFUgCw4lQ+hUxzCvEwIFyBWRCEcTkLokwthIHgIdw+chyti
w1r4Z+zZiv8DKIC7hP8ruRaQo0tBCKuJeZoKoZX9/5OrGX45/C/43+APgT9B
rkbwDv8i/Eb4LfBp8m0A7eSaA+5j/5f32SNALXvrI991LnwEn4/9nmbWemBv
ht+EvRl8jv8ZKCd2IajnvBr4UrhenDcTfxY4k/Udu8feo9glYCmxRfC74LsR
X8ldakEP9hennPsMyGR9xlRiixO/rZZ8e9i/Cywj9lDatT6X911V8xnEloCT
xC8jvhS+DFTCP2fPi9h31l2LVX/8H0EbewuJaSLXX5FzNxE/GK4nqIJfB2Ls
DmL+xP4eNJDrKDicdc1usLeJmBz+H+QYDzcW3CbXPtZewr0Ci9L+0/dwx9hT
gf87d+od+0ydVQ0OwVfBl8DPxr8KdwU8Yu9L/I/cZTf8GvjalLWjnMolDUl7
K+H75qzBjsR/rr8uxb+K3ZW1VdxtAf41/LbId68DqyJrUNpbSb7j+Odia/My
/OTEMeKOkOMk549L/NYy+LP4Ifbd5+Cvx37DWs+0a76dvf+y9iX2DtYGc9Z+
/JJO/CW4QOwU/J3wNaQagt8b3MRO8d7O2OPBY/wW8HfkHpD2VdMWuLf4v+Xc
E8fJdSy2lvWnquVT+Oqca9rI/u9Ya8j4D99wh+l5a7MquHevJ66derghck+q
F8vxO/Cf6M9yzvkc+xl4nfaatHM+716XhhaTb1hkbUoT6rUi1jZl3HPq3Tpw
LeMelvY/5P3X6oGh1Ouf2LXbwl0TzipQT3L3bazdIb6d+NnBGrqO/3Pkv1XN
pxM7LXFvqWcqsSfAp9OeSa3YocBa1xu+hS9L3FvqcdWqWTMh65qNghvAnlsp
z4Qj+APx76aswUHYk1irz7pnJiTWiLRxEP8suU7H1pZmwOjEmpKW9uK3xNas
tKoz+0fuafWyZopyfxVZizpDbz+QeNaoBl2wv1BPZK15ae1B7FkozUkrRyP/
pTSj2B34w3Pe8zX+xMR31ZukzbrIvSiN/oTdmHjWqyel9cLIs0SaXxd75mjW
6E9HEjsm8dtUsxOx/1R/qZn1Ku+ZoFmgP52SuCfUC5r57eQujD1bpZlP9Pnb
Cg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9098421905945334, 0.896089009482195, 0.8480805185344], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlk1onHUQxv+72ezu+yYBL01T4weJkijGXgQvaf0AsdrEr6oHPdlIDJXS
njzYtL0lu72k2YCgB0/eCmoFwWiKibRNQEFIU9tjQpNYGxXxUrD14PNjnmU9
DO/svPOfeeaZmf+7fWPHDx0rppSuSNokX1RTupOndFnGI5IOGRuyL0sfk35G
+iXp70g/Lf2onuckN6UfyFJaqqR0WO+flF6vxvte6X/LvquQ0ohij0q+KaW0
KNs1yQmdnWhP6bhkt/z7ZHtbckP2+/V8S7Iu/UWde0Hytc7uVazHJR+leA5Z
72sLHcxD9lmU/q4wLejcjm2cX5K9oNgX9fzL0uNa/lCeP/PAtKPntWpgg48+
c/Kq7K/lEXfIeRqO0ek45CXnKem/Sr6XzErGZL8l+0npF8TPV4pfUpzPhOdY
KbiCv54sODxRDX7h9tEsOMWnS89uyZzizJciH3HhiBy/SX9ZGF/K4z21Dxsr
9dwjW3dbxMV30tjoD3F2K/aacnfJZ0pcjLdHL86DWXJH9k+Eedu1wU+xFHh+
1PufssjBjOA7U4w68WG+UkdKPyv+x+3Rj72KlRci13R7zAY5p6zj9571db+b
T2Ebt50+PqUYP+j5RCXwge0NPR+QbEj/QM9XJKOFyEdv4OQxYXk+Dy6qzKdw
/lKKfTgs/OPFmNksa2Ej923Z75Z1RudmnH+fMeTmfMkzuc+zmhTnOcm9hZiX
fs8X7/fb59NKYAUnsR+WvpnChxzM7pxsjyj3oKRD2PM85uhCKXZ1xzmHjGez
HPUxe+Cm//Sd2G86/oOV4AuuXle8Q3nEm/COco547AIxO42dvhfdP/rT711o
+nR5L7psn/Mcdjsmth77w+uEua0LS01ytRR3Q7/vB/A+ZMwjyntQctb3QL/j
1FLYp1PUfMv7iMAN99hAOc6fdZxR95FzI9bBfLR5Pyjnh9WodU8WO8k+7pE8
U459OOd5x3/Y986SZ4MZpXf/iNfPq9Gnft8t8DjtmSc+fOBPLfvdS86OGhsz
0tzhSddEPOradm3Uxb1yXyFwznpfsV+sBI7mvX7ZZ+GJ+wSeqIOz1LIs/7t5
fBPYG+aXWOzhFeWaSsHBoHmA94UUdvaHc3xHmEHuGnrCd+NAHjVs2h/OicFs
U+Owd5U9xadSCD/moL0Q8ZmVtXILCzqc/KvYK4qxUoydxQ8fdmrTuajpy2rg
2yrH+cnUykH81XLsD5j5Tl6qBF8brn/K+7Xls+erzl0MjrbNOfcffT5iXunv
TWPmLHmIO+5efKv5WsjiHLlKhVY+fOH49zzuXO7burmG5xV/y5ucbxobPNI/
ZqG3EH3kN5zd9izB64bz8P1facZU3R1Z/N4yJ6veoQH3i11lfte9a3Xv4tPi
5H1hvV6KO3XZda6Z83nXdDK1drZmvebfp8zVquet4fhnzM26+7HgczOus2a/
q77XwUdubKc9bwOeW3a/5n7VnRMfzl33Wb4t7Dz+nVl8j7nTmNNe8wn3DWOj
1+zSLv9HWTQu9oV7vJl/0Bwy4zdcB9+KZ/29OOg7idq+yyL3nHE2/lfrrPH/
B1piRR8=
         "],
         VertexColors->None], 
        PolygonBox[{{2221, 2171, 864, 708}, {1838, 1858, 283, 266}, {2330, 
         2329, 277, 654}, {1927, 1800, 1237, 1236}, {1859, 1793, 239, 284}, {
         2481, 2330, 654, 1018}, {1881, 1928, 1236, 223}, {2171, 2222, 709, 
         864}, {1926, 1859, 284, 1134}, {2225, 2489, 1026, 1028}, {2471, 2170,
          609, 790}, {2223, 2173, 866, 710}, {2033, 2571, 1955, 277}, {1858, 
         1792, 282, 283}, {2313, 2816, 1432, 122}, {2315, 2174, 617, 711}, {
         1988, 2314, 865, 709}, {2666, 2028, 258, 1239}, {2255, 2796, 1391, 
         1383}, {2173, 2224, 711, 866}, {2314, 1990, 710, 865}, {2254, 2790, 
         1382, 1432}, {2797, 2794, 791, 1391}, {2174, 2492, 1028, 617}, {2390,
          2480, 1018, 938}, {2636, 2634, 489, 1207}, {2632, 1985, 610, 
         1204}, {1985, 2635, 1207, 610}, {2630, 2633, 1204, 488}, {2169, 2808,
          1414, 258}, {2491, 2490, 146, 1026}, {2641, 2639, 490, 1211}, {1871,
          1787, 142, 332}, {2631, 2091, 488, 609}, {1827, 1837, 263, 227}, {
         1804, 1823, 224, 261}, {1836, 1821, 223, 260}, {2808, 1983, 122, 
         1414}, {2110, 2665, 1237, 1238}, {2326, 2327, 781, 146}, {1837, 1825,
          226, 263}, {2665, 2111, 1239, 1237}, {1822, 1836, 260, 224}, {2259, 
         2358, 876, 781}, {2507, 2471, 790, 1040}, {1986, 2640, 1211, 611}, {
         2634, 2638, 1208, 489}, {2642, 1987, 708, 1212}, {2639, 2643, 1212, 
         490}, {1826, 1804, 261, 226}, {2262, 2795, 1040, 791}, {1857, 1843, 
         190, 282}, {2637, 1986, 611, 1208}, {2790, 2255, 1383, 1382}, {2328, 
         2390, 938, 876}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2110, 2665, 2111, 2666, 2028, 2169, 2808, 1983, 2006, 2313, 
         2816, 2254, 2790, 2255, 2796, 2797, 2794, 2262, 2795, 2506, 2507, 
         2471, 2170, 2375, 1984, 2631, 2091, 2630, 2633, 2632, 1985, 2635, 
         2636, 2634, 2638, 2637, 1986, 2640, 2641, 2639, 2643, 2642, 1987, 
         2809, 2221, 2171, 2222, 2810, 1988, 2314, 1990, 2811, 2223, 2173, 
         2224, 2812, 1991, 2315, 2174, 2492, 2225, 2489, 2491, 2490, 2316, 
         2317, 2326, 2327, 2259, 2358, 2184, 2328, 2390, 2480, 2481, 2330, 
         2329, 2345, 2331, 2033, 2571, 2570}],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2196, 2576, 2577, 2578, 2251, 2500, 2499, 2393, 2226, 2493, 
         2264, 2258, 2257, 2356, 2178, 2263, 2508, 2485, 2195, 2746, 2194, 
         2484, 2861, 2483, 2384, 2383, 2863, 2095, 2409, 1989, 2545, 2544, 
         2543, 2092, 2167, 2833, 2166, 2627, 2088, 2625, 2087, 2626, 2734, 
         2733, 2311, 2312, 2220, 2806, 1980, 2310, 1976, 2804, 2218, 2160, 
         2774, 2775, 2531, 2534, 1975, 2532, 2533, 2470, 2857, 75, 2619, 2621,
          2620, 1974, 2617, 2618, 2615, 2084, 2616, 1973, 2803, 2159, 2730, 
         2542, 2083, 2614, 2156, 2727, 2003, 2272, 2158, 2728, 2157, 2729, 
         2304, 1979, 2623, 2624, 2622, 2085, 2732, 2165, 2731, 2164, 2738, 
         2177, 2737, 2176, 2207, 2047, 2335, 2046, 2206, 2209, 2839, 2208, 
         1981, 2807, 2071, 2040, 2428, 2429, 2425, 2427, 2426, 2430, 2306}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2187, 2186, 2017, 2332, 2333, 2244, 2787, 2243, 1993, 1957, 
         2769, 2770, 2768, 2214, 2321, 2320, 2475, 2175, 2401, 2061, 2400, 
         2060, 2693, 2694, 2592, 2593, 2252, 2059, 2349, 2350, 2287, 2848, 
         2286, 1996, 1964, 2844, 2377, 2371, 2395, 2394, 2057, 2502, 2503, 
         2501, 2505, 2504, 2253, 2859, 2860, 2849, 2288, 1999, 1968, 2845, 
         2379, 2374, 2397, 2396, 2058, 2712, 2148, 2711, 2147, 2000, 2270, 
         2150, 2713, 2149, 2714, 2302, 2526, 2525, 2524, 2800, 2799, 2721, 
         2540, 2079, 2604, 2720, 2719, 2001, 1970, 2798, 2152, 2080, 2303, 
         2530, 2529, 2155, 2802, 2725, 2541, 2606, 2605, 2724, 2002, 1972, 
         2801, 2068, 2056, 2402, 2070, 2603, 2069, 2612, 2613, 2611, 2082, 
         2664, 2108, 2557, 2558, 2559, 2116, 2830, 2117, 2039, 2348, 2038, 
         2250, 2307, 2869}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2866, 2197, 2388, 2283, 2030, 2355, 2029, 2282, 2245, 2785, 
         2238, 2784, 2239, 2786, 2236, 2344, 2551, 2550, 2237, 2783, 2172, 
         2646, 2094, 2644, 2093, 2645, 2168, 2629, 2090, 2628, 2089, 2735, 
         2736, 2536, 2537, 2382, 2381, 2380, 2086, 2408, 2535, 1978, 2004, 
         2273, 2161, 2805, 1977, 2205, 2726, 2609, 2610, 2607, 2081, 2608, 
         2153, 2832, 2154, 2271, 2722, 2723, 2527, 2528, 1971, 2743, 2744, 
         2648, 2649, 2647, 2099, 2680, 2681, 2678, 2127, 2679, 2012, 2663, 
         2867}],
        RowBox[{"-", "0.25`"}]],
       Annotation[#, -0.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2021, 2560, 2389, 2109, 2419, 2162, 2163, 2219, 2488, 2035, 
         2392, 2032, 2387, 2420, 2854, 2015, 2421, 2284, 2279, 2864, 2280, 
         2256, 2353, 2022, 2278, 2100, 2828, 2101, 2041, 2130, 2831, 2131, 
         2129, 2682, 2128, 2005, 1982, 2414, 2415, 2413, 2102, 2416, 2549, 
         2548, 2651, 2650, 2024, 2354, 2025, 2281, 2072, 2289, 2192, 2838, 
         2193, 2870}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2277, 2667, 2115, 2567, 2568, 2249, 2037, 2346, 2347, 2248, 
         2842, 2247, 2009, 2852, 2853, 2851, 2850, 2818, 2422, 2385, 2097, 
         2757, 2204, 2755, 2203, 2756, 2486, 2487, 2363, 2362, 2361, 2135, 
         2448, 2265, 2266, 2512, 2511, 2136, 2695, 2073, 2697, 2138, 2696, 
         2137, 1995, 2515, 2514, 2513, 2139, 2698, 2075, 2704, 2141, 2703, 
         2140, 1998, 2520, 2519, 2518, 2142, 2299, 2298, 2522, 2521, 2468, 
         2145, 2469, 2269, 2710, 2146, 2707, 2709, 2708, 2301, 1969, 2406, 
         2407, 2405, 2078, 2717, 2718, 2715, 2151, 2716, 2815, 2836, 2837, 
         2590, 2589, 2054, 2337, 2053, 2588, 2587, 2767, 2213, 2591, 2055, 
         2066, 2825, 2065, 2134, 2822, 2049, 2690, 2133, 2687, 2689, 2688, 
         2691, 2308, 2014, 2820, 2183, 2191, 2190, 2034, 2745, 2572, 2827, 
         2067, 2856, 2826}],
        RowBox[{"-", "0.5`"}]],
       Annotation[#, -0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2309, 2121, 2234, 2841, 2233, 2343, 2036, 2246, 2817, 2008, 
         2497, 2241, 2496, 2242, 2498, 2240, 2846, 2847, 2813, 2276, 1992, 
         1956, 2759, 2760, 2758, 2210, 2319, 2318, 2474, 2446, 2447, 2443, 
         2445, 2444, 2292, 1963, 2370, 2369, 2459, 2458, 2268, 2463, 2464, 
         2460, 2462, 2461, 2296, 1967, 2373, 2372, 2702, 2701, 2466, 2378, 
         2404, 2403, 2465, 1997, 1966, 2517, 2516, 2700, 2699, 2077, 2467, 
         2144, 2706, 2143, 2705, 2539, 2814, 2834, 2835, 2585, 2584, 2051, 
         2336, 2050, 2583, 2582, 2766, 2211, 2858, 2586, 2052, 2823, 2212, 
         2523, 2602, 2064, 2824, 2579, 2045, 2686, 2132, 2683, 2685, 2684, 
         2300, 2305, 2013, 2819, 2182, 2189, 2188, 2031, 2855, 2482, 2391}],
        RowBox[{"-", "0.75`"}]],
       Annotation[#, -0.75, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2418, 2107, 2417, 2106, 2297, 2076, 2673, 2124, 2573, 2574, 
         2575, 2125, 2674, 2675, 2599, 2601, 2600, 2043, 2334, 2044, 2821, 
         2202, 2285, 2042, 2788, 2789, 2772, 2216, 2771, 2217, 2773, 2232, 
         2495, 2779, 2778, 2230, 2776, 2231, 2777, 2229, 2793, 2261, 2791, 
         2260, 2792, 2074, 2324, 2325, 2294, 2293, 1965, 2295, 2454, 2455, 
         2453, 2457, 2456, 2267, 2451, 2452, 2367, 2368, 1962, 2291, 2439, 
         2440, 2438, 2442, 2865, 2441, 2473, 2762, 2763, 2761, 2765, 2764, 
         2048, 2580, 2581, 2509, 2510, 1959, 2692, 2432, 2411, 2412, 2410, 
         2096, 2659, 2660, 2656, 2658, 2657, 2007, 2669, 2118, 2668, 2119, 
         2120, 2868}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2342, 2228, 2341, 2227, 2357, 2274, 2275, 2235, 2780, 2782, 
         2781, 2181, 2741, 2180, 2742, 2011, 2338, 2215, 2351, 2352, 2340, 
         2339, 2185, 2478, 2479, 2364, 2376, 2843, 1960, 1994, 2538, 2476, 
         2862, 2477, 2740, 2739, 2179, 2323, 2322, 2494, 2449, 2450, 2365, 
         2366, 1961, 2290, 2434, 2435, 2433, 2437, 2436, 2472, 2398, 2399, 
         2359, 2360, 1958, 2431, 2748, 2199, 2747, 2200, 2749, 2198, 2753, 
         2201, 2750, 2752, 2751, 2754, 2653, 2654, 2652, 2655}],
        RowBox[{"-", "1.25`"}]],
       Annotation[#, -1.25, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2105, 2126, 2020, 2840, 2104, 2114, 2112, 2829, 2113, 2098, 
         2386, 2423, 2424, 2123, 2672, 2062, 2597, 2063, 2598, 2027, 2569, 
         2103, 2661, 2662, 2554, 2018, 2677, 2019, 2556, 2555, 2564, 2563, 
         2023, 2561, 2562, 2546, 2547, 2010, 2122, 2670, 2671, 2594, 2596, 
         2595, 2026, 2565, 2566, 2552, 2553, 2016, 2676, 2871}],
        RowBox[{"-", "1.5`"}]],
       Annotation[#, -1.5, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    InsetBox[
     FormBox["\"local minimum\"", TraditionalForm], {0.927, 0.374}], 
    InsetBox[
     FormBox["\"global minimum\"", TraditionalForm], {-0.657, -0.753}]},
  Frame->True,
  PlotRange->{{-1.6, 1.6}, {-1.6, 1.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43948221]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21890],

Cell["\<\
Solve cannot work with this system of equations because they are highly \
nonalgebraic:\
\>", "ExampleText",
 CellID->1680507868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Floor", "[", 
      SuperscriptBox["x", "2"], "]"}], "\[Equal]", "196"}], "&&", 
    RowBox[{
     RowBox[{"Mod", "[", 
      RowBox[{"x", ",", "10"}], "]"}], "\[Equal]", "4"}]}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398952527],

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used. Values may be lost for \
multivalued inverses. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/InverseFunction/ifun\\\", ButtonNote -> \\\
\"InverseFunction::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->31987817],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->16020138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"InverseFunction", "[", 
      RowBox[{"Mod", ",", "1", ",", "2"}], "]"}], "[", 
     RowBox[{"4", ",", "10"}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{278, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46482859]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NMinimize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NMinimize"]], "InlineFormula"],
 " with a trivial objective function to find a solution{"
}], "ExampleText",
 CellID->1220382311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NMinimize", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"Floor", "[", 
        SuperscriptBox["x", "2"], "]"}], "\[Equal]", "196"}], "&&", 
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{"x", ",", "10"}], "]"}], "\[Equal]", "4"}]}]}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1696840635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "14.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->418695611]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6067],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMaximize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMaximize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindMinimum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindMinimum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindFit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindFit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearProgramming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearProgramming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LeastSquares",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LeastSquares"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22318],

Cell[TextData[ButtonBox["Numerical Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematics-BasicOperations"]], "Tutorials",
 CellID->123709578],

Cell[TextData[ButtonBox["Numerical Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalOptimization"]], "Tutorials",
 CellID->21967],

Cell[TextData[ButtonBox["Constrained Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ConstrainedOptimizationOverview"]], "Tutorials",\

 CellID->78894921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31594],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#10453"], None}]], "RelatedLinks",
 CellID->3572]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->440804277],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->104782564],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->270691275],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->911143417],

Cell[TextData[ButtonBox["Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Optimization"]], "MoreAbout",
 CellID->868251926],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->221870483]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NMinimize - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 17.9824618}", "context" -> "System`", 
    "keywords" -> {
     "constrained optimization", "cost function", "differential evolution", 
      "extremization", "flexible polyhedron method", "global minimization", 
      "goal functions", "integer programming", "linear programming", 
      "minimization", "Nelder-Mead", "numerical minimization", 
      "objective functions", "operations research", "optimization", 
      "pay-off functions", "random search", "simulated annealing"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NMinimize[f, {x, y, ...}] minimizes f numerically with respect to x, y, \
.... NMinimize[{f, cons}, {x, y, ...}] minimizes f numerically subject to the \
constraints cons. ", "synonyms" -> {}, "title" -> "NMinimize", "type" -> 
    "Symbol", "uri" -> "ref/NMinimize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17966, 529, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4261523]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 837082, 15295}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3278, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3901, 98, 4193, 83, 70, "ObjectNameGrid"],
Cell[8097, 183, 1688, 56, 70, "Usage",
 CellID->28454]
}, Open  ]],
Cell[CellGroupData[{
Cell[9822, 244, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10300, 261, 714, 27, 70, "Notes",
 CellID->3992],
Cell[11017, 290, 179, 5, 70, "Notes",
 CellID->27602],
Cell[11199, 297, 311, 10, 70, "Notes",
 CellID->32226],
Cell[11513, 309, 83, 1, 70, "Notes",
 CellID->25045],
Cell[11599, 312, 295, 9, 70, "Notes",
 CellID->21374],
Cell[11897, 323, 521, 17, 70, "Notes",
 CellID->14292637],
Cell[12421, 342, 227, 8, 70, "Notes",
 CellID->29994],
Cell[12651, 352, 662, 23, 70, "Notes",
 CellID->2548],
Cell[13316, 377, 69, 1, 70, "Notes",
 CellID->27883],
Cell[13388, 380, 2553, 69, 70, "3ColumnTableMod",
 CellID->30444],
Cell[15944, 451, 520, 20, 70, "Notes",
 CellID->11881],
Cell[16467, 473, 472, 14, 70, "Notes",
 CellID->31975],
Cell[16942, 489, 502, 17, 70, "Notes",
 CellID->4670],
Cell[17447, 508, 482, 16, 70, "Notes",
 CellID->28847]
}, Closed]],
Cell[CellGroupData[{
Cell[17966, 529, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4261523],
Cell[CellGroupData[{
Cell[18349, 543, 148, 5, 70, "ExampleSection",
 CellID->213397682],
Cell[18500, 550, 96, 1, 70, "ExampleText",
 CellID->1917251726],
Cell[CellGroupData[{
Cell[18621, 555, 234, 8, 28, "Input",
 CellID->1746774899],
Cell[18858, 565, 314, 11, 36, "Output",
 CellID->27842243]
}, Open  ]],
Cell[19187, 579, 76, 1, 70, "ExampleText",
 CellID->1664023518],
Cell[CellGroupData[{
Cell[19288, 584, 304, 11, 28, "Input",
 CellID->1557760567],
Cell[19595, 597, 175, 5, 36, "Output",
 CellID->542254139]
}, Open  ]],
Cell[19785, 605, 126, 3, 70, "ExampleDelimiter",
 CellID->1112598013],
Cell[19914, 610, 97, 1, 70, "ExampleText",
 CellID->1719552892],
Cell[CellGroupData[{
Cell[20036, 615, 483, 17, 70, "Input",
 CellID->886900649],
Cell[20522, 634, 413, 13, 39, "Output",
 CellID->143721150]
}, Open  ]],
Cell[CellGroupData[{
Cell[20972, 652, 1119, 36, 70, "Input",
 CellID->1759366686],
Cell[22094, 690, 416, 14, 36, "Output",
 CellID->45162468]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22559, 710, 216, 7, 70, "ExampleSection",
 CellID->26512],
Cell[22778, 719, 196, 7, 70, "ExampleText",
 CellID->1077996427],
Cell[CellGroupData[{
Cell[22999, 730, 706, 24, 70, "Input",
 CellID->1881132418],
Cell[23708, 756, 430, 14, 36, "Output",
 CellID->253276688]
}, Open  ]],
Cell[24153, 773, 125, 3, 70, "ExampleDelimiter",
 CellID->145340294],
Cell[24281, 778, 228, 8, 70, "ExampleText",
 CellID->1627702079],
Cell[CellGroupData[{
Cell[24534, 790, 593, 19, 70, "Input",
 CellID->555314442],
Cell[25130, 811, 343, 11, 36, "Output",
 CellID->131287448]
}, Open  ]],
Cell[25488, 825, 125, 3, 70, "ExampleDelimiter",
 CellID->592370280],
Cell[25616, 830, 79, 1, 70, "ExampleText",
 CellID->1554484569],
Cell[CellGroupData[{
Cell[25720, 835, 709, 23, 70, "Input",
 CellID->1605455941],
Cell[26432, 860, 319, 11, 36, "Output",
 CellID->111692357]
}, Open  ]],
Cell[CellGroupData[{
Cell[26788, 876, 523, 18, 70, "Input",
 CellID->1044023529],
Cell[27314, 896, 356, 12, 36, "Output",
 CellID->271323027]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27719, 914, 222, 7, 70, "ExampleSection",
 CellID->453790855],
Cell[CellGroupData[{
Cell[27966, 925, 248, 7, 70, "ExampleSubsection",
 CellID->61701773],
Cell[28217, 934, 782, 28, 70, "ExampleText",
 CellID->764461149],
Cell[CellGroupData[{
Cell[29024, 966, 288, 8, 70, "Input",
 CellID->1625295724],
Cell[29315, 976, 317, 11, 36, "Output",
 CellID->96017384]
}, Open  ]],
Cell[29647, 990, 126, 3, 70, "ExampleDelimiter",
 CellID->1055000278],
Cell[29776, 995, 858, 28, 70, "ExampleText",
 CellID->1329553122],
Cell[CellGroupData[{
Cell[30659, 1027, 290, 8, 70, "Input",
 CellID->1468387723],
Cell[30952, 1037, 228, 5, 70, "Message",
 CellID->200770448],
Cell[31183, 1044, 319, 11, 36, "Output",
 CellID->295424970]
}, Open  ]],
Cell[31517, 1058, 244, 8, 70, "ExampleText",
 CellID->1199314865],
Cell[CellGroupData[{
Cell[31786, 1070, 344, 9, 70, "Input",
 CellID->39134653],
Cell[32133, 1081, 374, 13, 54, "Output",
 CellID->36602932]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32556, 1100, 238, 7, 70, "ExampleSubsection",
 CellID->405919056],
Cell[32797, 1109, 150, 4, 70, "ExampleText",
 CellID->1914018609],
Cell[32950, 1115, 1090, 35, 70, "Input",
 CellID->157454682],
Cell[34043, 1152, 146, 4, 70, "ExampleText",
 CellID->738842830],
Cell[CellGroupData[{
Cell[34214, 1160, 1199, 38, 70, "Input",
 CellID->629793524],
Cell[35416, 1200, 460490, 7646, 70, "Output",
 CellID->205610275]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[495955, 8852, 226, 7, 70, "ExampleSubsection",
 CellID->23837268],
Cell[496184, 8861, 105, 2, 70, "ExampleText",
 CellID->1424437279],
Cell[CellGroupData[{
Cell[496314, 8867, 449, 15, 70, "Input",
 CellID->1467809973],
Cell[496766, 8884, 315, 11, 36, "Output",
 CellID->444104648]
}, Open  ]],
Cell[CellGroupData[{
Cell[497118, 8900, 524, 17, 70, "Input",
 CellID->394924060],
Cell[497645, 8919, 318, 11, 36, "Output",
 CellID->55140969]
}, Open  ]],
Cell[CellGroupData[{
Cell[498000, 8935, 378, 13, 70, "Input",
 CellID->2988854],
Cell[498381, 8950, 2875, 51, 70, "Output",
 Evaluatable->False,
 CellID->11693222]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[501305, 9007, 232, 7, 70, "ExampleSubsection",
 CellID->151017442],
Cell[501540, 9016, 200, 6, 70, "ExampleText",
 CellID->922642942],
Cell[501743, 9024, 1053, 36, 70, "Input",
 CellID->1534545049],
Cell[CellGroupData[{
Cell[502821, 9064, 1351, 44, 70, "Input",
 CellID->1614037545],
Cell[504175, 9110, 156282, 2647, 70, "Output",
 CellID->278754953]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[660506, 11763, 237, 7, 70, "ExampleSubsection",
 CellID->792799295],
Cell[660746, 11772, 552, 20, 70, "ExampleText",
 CellID->1087085504],
Cell[CellGroupData[{
Cell[661323, 11796, 482, 16, 70, "Input",
 CellID->2145912710],
Cell[661808, 11814, 526, 17, 36, "Output",
 CellID->209285780]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[662395, 11838, 232, 7, 70, "ExampleSection",
 CellID->1677],
Cell[662630, 11847, 381, 12, 70, "ExampleText",
 CellID->316126506],
Cell[CellGroupData[{
Cell[663036, 11863, 476, 17, 70, "Input",
 CellID->1726927757],
Cell[663515, 11882, 434, 14, 39, "Output",
 CellID->8559842]
}, Open  ]],
Cell[CellGroupData[{
Cell[663986, 11901, 477, 17, 70, "Input",
 CellID->283369064],
Cell[664466, 11920, 417, 14, 39, "Output",
 CellID->22280327]
}, Open  ]],
Cell[CellGroupData[{
Cell[664920, 11939, 1444, 44, 70, "Input",
 CellID->288919193],
Cell[666367, 11985, 59851, 1015, 70, "Output",
 CellID->336141137]
}, Open  ]],
Cell[726233, 13003, 237, 7, 70, "ExampleText",
 CellID->1543511006],
Cell[CellGroupData[{
Cell[726495, 13014, 503, 18, 70, "Input",
 CellID->1936029081],
Cell[727001, 13034, 381, 14, 51, "Output",
 CellID->35197403]
}, Open  ]],
Cell[727397, 13051, 125, 3, 70, "ExampleDelimiter",
 CellID->242298157],
Cell[727525, 13056, 365, 12, 70, "ExampleText",
 CellID->1667523556],
Cell[727893, 13070, 464, 16, 70, "Input",
 CellID->683762628],
Cell[728360, 13088, 127, 3, 70, "ExampleText",
 CellID->211535797],
Cell[728490, 13093, 797, 27, 70, "Input",
 CellID->1790909421],
Cell[729290, 13122, 226, 8, 70, "ExampleText",
 CellID->1520387461],
Cell[CellGroupData[{
Cell[729541, 13134, 925, 28, 70, "Input",
 CellID->1520755593],
Cell[730469, 13164, 3250, 57, 70, "Output",
 Evaluatable->False,
 CellID->994099202]
}, Open  ]],
Cell[733734, 13224, 230, 8, 70, "ExampleText",
 CellID->520058618],
Cell[CellGroupData[{
Cell[733989, 13236, 705, 21, 70, "Input",
 CellID->1967984934],
Cell[734697, 13259, 4661, 80, 70, "Output",
 Evaluatable->False,
 CellID->223157356]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[739407, 13345, 226, 7, 70, "ExampleSection",
 CellID->17575],
Cell[739636, 13354, 250, 8, 70, "ExampleText",
 CellID->852609718],
Cell[CellGroupData[{
Cell[739911, 13366, 326, 11, 70, "Input",
 CellID->73285609],
Cell[740240, 13379, 315, 11, 36, "Output",
 CellID->34099179]
}, Open  ]],
Cell[CellGroupData[{
Cell[740592, 13395, 404, 14, 70, "Input",
 CellID->775860373],
Cell[740999, 13411, 4868, 84, 70, "Output",
 Evaluatable->False,
 CellID->62750017]
}, Open  ]],
Cell[745882, 13498, 127, 3, 70, "ExampleText",
 CellID->220252790],
Cell[CellGroupData[{
Cell[746034, 13505, 411, 14, 70, "Input",
 CellID->293976264],
Cell[746448, 13521, 315, 11, 36, "Output",
 CellID->378104969]
}, Open  ]],
Cell[746778, 13535, 125, 3, 70, "ExampleDelimiter",
 CellID->993018304],
Cell[746906, 13540, 240, 7, 70, "ExampleText",
 CellID->220009434],
Cell[CellGroupData[{
Cell[747171, 13551, 519, 18, 70, "Input",
 CellID->1642232626],
Cell[747693, 13571, 394, 13, 36, "Output",
 CellID->202757256]
}, Open  ]],
Cell[748102, 13587, 121, 3, 70, "ExampleText",
 CellID->1122017447],
Cell[CellGroupData[{
Cell[748248, 13594, 607, 22, 70, "Input",
 CellID->559037039],
Cell[748858, 13618, 433, 14, 36, "Output",
 CellID->597801434]
}, Open  ]],
Cell[CellGroupData[{
Cell[749328, 13637, 1440, 47, 70, "Input",
 CellID->186971854],
Cell[750771, 13686, 77224, 1299, 70, "Output",
 CellID->43948221]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[828044, 14991, 224, 7, 70, "ExampleSection",
 CellID->21890],
Cell[828271, 15000, 139, 4, 70, "ExampleText",
 CellID->1680507868],
Cell[CellGroupData[{
Cell[828435, 15008, 363, 12, 70, "Input",
 CellID->398952527],
Cell[828801, 15022, 427, 8, 70, "Message",
 CellID->31987817],
Cell[829231, 15032, 452, 8, 70, "Message",
 CellID->16020138],
Cell[829686, 15042, 374, 12, 36, "Output",
 CellID->46482859]
}, Open  ]],
Cell[830075, 15057, 243, 8, 70, "ExampleText",
 CellID->1220382311],
Cell[CellGroupData[{
Cell[830343, 15069, 431, 14, 70, "Input",
 CellID->1696840635],
Cell[830777, 15085, 264, 9, 36, "Output",
 CellID->418695611]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[831102, 15101, 310, 9, 70, "SeeAlsoSection",
 CellID->6067],
Cell[831415, 15112, 1462, 53, 70, "SeeAlso",
 CellID->5138]
}, Open  ]],
Cell[CellGroupData[{
Cell[832914, 15170, 314, 9, 70, "TutorialsSection",
 CellID->22318],
Cell[833231, 15181, 193, 4, 70, "Tutorials",
 CellID->123709578],
Cell[833427, 15187, 154, 3, 70, "Tutorials",
 CellID->21967],
Cell[833584, 15192, 171, 4, 70, "Tutorials",
 CellID->78894921]
}, Open  ]],
Cell[CellGroupData[{
Cell[833792, 15201, 321, 9, 70, "RelatedLinksSection",
 CellID->31594],
Cell[834116, 15212, 266, 6, 70, "RelatedLinks",
 CellID->3572]
}, Open  ]],
Cell[CellGroupData[{
Cell[834419, 15223, 319, 9, 70, "MoreAboutSection",
 CellID->440804277],
Cell[834741, 15234, 156, 3, 70, "MoreAbout",
 CellID->104782564],
Cell[834900, 15239, 128, 3, 70, "MoreAbout",
 CellID->270691275],
Cell[835031, 15244, 175, 3, 70, "MoreAbout",
 CellID->911143417],
Cell[835209, 15249, 136, 3, 70, "MoreAbout",
 CellID->868251926],
Cell[835348, 15254, 147, 3, 70, "MoreAbout",
 CellID->221870483]
}, Open  ]],
Cell[835510, 15260, 50, 0, 70, "History"],
Cell[835563, 15262, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

