(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    102919,       3316]
NotebookOptionsPosition[     89245,       2841]
NotebookOutlinePosition[     90857,       2883]
CellTagsIndexPosition[     90771,       2878]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Mathematics: Basic Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematics-BasicOperations"], 
          "Numerical Equation Solving" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalEquationSolving"], 
          "Equations in One Variable" :> 
          Documentation`HelpLookup["paclet:tutorial/EquationsInOneVariable"], 
          "Numerical Mathematics in Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalMathematicsInMathematica"], 
          "Numerical Solution of Polynomial Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NumericalSolutionOfPolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Mathematics: Basic Operations\"\>", 
       2->"\<\"Numerical Equation Solving\"\>", 
       3->"\<\"Equations in One Variable\"\>", 
       4->"\<\"Numerical Mathematics in Mathematica\"\>", 
       5->"\<\"Numerical Solution of Polynomial Equations\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "FindRoot" :> Documentation`HelpLookup["paclet:ref/FindRoot"], 
          "NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"], 
          "NMinimize" :> Documentation`HelpLookup["paclet:ref/NMinimize"], 
          "InterpolatingFunction" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Solve\"\>", 
       2->"\<\"FindRoot\"\>", 3->"\<\"NDSolve\"\>", 4->"\<\"NMinimize\"\>", 
       5->"\<\"InterpolatingFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Equation Solving\"\>", 
       2->"\<\"Numerical Evaluation & Precision\"\>", 
       3->"\<\"Polynomial Equations\"\>", 
       4->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NSolve", "ObjectName",
 CellID->29260],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NSolve"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["lhs", "TI"], "==", 
         StyleBox["rhs", "TI"]}], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of numerical approximations to the roots \
of a polynomial equation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NSolve"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["var", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["var", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a system of polynomial equations. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25868]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"], "[", 
   RowBox[{
    StyleBox["eqns", "TI"], ",", 
    StyleBox["vars", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives results to ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]digit precision. "
}], "Notes",
 CellID->1570],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"], "[", 
   RowBox[{
    StyleBox["eqns", "TI"], ",", 
    StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
 " gives the same final result as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    ButtonBox["Solve",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Solve"], "[", 
    RowBox[{
     StyleBox["eqns", "TI"], ",", 
     StyleBox["vars", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 ", apart from issues of numerical precision. "
}], "Notes",
 CellID->14537]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->513124291],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->254744762],

Cell["Approximate solutions to a polynomial equation:", "ExampleText",
 CellID->407324565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", 
     RowBox[{"2", "x"}], "+", "3"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70203665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.4236058485523317`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.24672925691056408`"}], "-", 
      RowBox[{"1.3208163474502475`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.24672925691056408`"}], "+", 
      RowBox[{"1.3208163474502475`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.95853218118673`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.49842777903184604`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.95853218118673`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.49842777903184604`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{481, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21011152]
}, Open  ]],

Cell["Approximate solutions to a system of polynomial equations:", \
"ExampleText",
 CellID->261857536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}]}], "\[Equal]", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->168839098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.6153846153846154`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.3997040325158948`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.9230769230769231`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.26646935501059654`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.6153846153846154`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.3997040325158948`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.9230769230769231`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.26646935501059654`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->789716255]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->73424097],

Cell["A univariate polynomial equation:", "ExampleText",
 CellID->27800802],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"3", "x"}], "+", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418446648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.1667727754129407`"}], "-", 
      RowBox[{"1.4156826584847633`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.1667727754129407`"}], "+", 
      RowBox[{"1.4156826584847633`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.1667727754129407`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.8476792019125785`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.1667727754129407`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.8476792019125785`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{362, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407579846]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->714350],

Cell["\<\
A system of polynomial equations with finitely many solutions:\
\>", "ExampleText",
 CellID->274681437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}]}], "\[Equal]", "3"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "\[Equal]", "7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203335058],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "-", 
       RowBox[{"2.9176175550010606`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.3992178097507493`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.9176175550010606`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "-", 
       RowBox[{"2.3992178097507493`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "3.3930063656365874`"}], ",", 
     RowBox[{"y", "\[Rule]", "2.0630671580501683`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "3.3930063656365883`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "2.0630671580501674`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{519, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138710870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->361949363],

Cell["\<\
A system of polynomial equations with infinitely many solutions:\
\>", "ExampleText",
 CellID->105752139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "-", 
       RowBox[{"3", "y"}], "+", 
       RowBox[{"4", "z"}]}], "\[Equal]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86226923],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSolve", "::", "\<\"infsolns\"\>"}], ":", 
  " ", "\<\"Infinite solution set has dimension at least \\!\\(1\\). \
Returning intersection of solutions with \\!\\(\\(\\(-\\(\\(\\(85901\\\\ x\\)\
\\/60742\\)\\)\\)\\) + \\(28373\\\\ y\\)\\/30371 + z\\) == 1.\"\>"}]], \
"Message", "MSG",
 CellID->30635592],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.09626741116541515`"}], "+", 
       RowBox[{"0.3501567448990152`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.2578500469785694`"}], "+", 
       RowBox[{"0.39797096887073435`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1.1047461703487802`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.12339985420354313`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.09626741116541515`"}], "-", 
       RowBox[{"0.3501567448990152`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.2578500469785694`"}], "-", 
       RowBox[{"0.39797096887073435`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"1.1047461703487802`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.12339985420354313`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{525, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533806205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->587224177],

Cell["Polynomial equations with inexact coefficients:", "ExampleText",
 CellID->630506103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"1.23", 
        RowBox[{"x", "^", "2"}]}], "-", 
       RowBox[{"2.34", 
        RowBox[{"y", "^", "3"}]}]}], "\[Equal]", "3.45"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"4.56", "x"}], "+", 
       RowBox[{"5.67", "y"}]}], "\[Equal]", "6.78"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67463579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.8885674103386749`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.6939964378690764`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.4811521356006424`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.3623675055878286`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.8885674103386749`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.6939964378690764`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.4811521356006424`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.3623675055878286`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.6728738467844069`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.14961282915994617`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59984286]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22700041],

Cell["Equations involving radicals:", "ExampleText",
 CellID->249642838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "x", "]"}], "+", 
       RowBox[{"y", "^", 
        RowBox[{"(", 
         RowBox[{"1", "/", "3"}], ")"}]}]}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{"Sqrt", "[", 
       RowBox[{"x", "-", 
        RowBox[{"2", "y"}]}], "]"}], "\[Equal]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122633595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "13.56621126330499`"}], ",", 
    RowBox[{"y", "\[Rule]", "2.2831056316524947`"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361266307]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->80751290],

Cell["Eliminate a variable and solve the resulting system:", "ExampleText",
 CellID->235259990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "-", 
       RowBox[{"3", "y"}], "+", 
       RowBox[{"4", "z"}]}], "\[Equal]", "5"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y", " ", "z"}], "\[Equal]", "7"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"{", "z", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21972948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1.6632551450071944`", "\[InvisibleSpace]", "-", 
       RowBox[{"2.0085366504755324`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.949268827990123`"}], "-", 
       RowBox[{"1.606448605933545`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1.6632551450071944`", "\[InvisibleSpace]", "+", 
       RowBox[{"2.0085366504755324`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.949268827990123`"}], "+", 
       RowBox[{"1.606448605933545`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1.365997598756146`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.9109930246428175`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1.3952371559652201`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.4102338930678513`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1.365997598756146`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.9109930246428175`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"1.3952371559652201`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.4102338930678513`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.7600219745325778`"}], "-", 
       RowBox[{"0.2031450949630785`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.199814481821255`"}], "+", 
       RowBox[{"1.740570086872113`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], ",",
    
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.7600219745325778`"}], "+", 
       RowBox[{"0.2031450949630785`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.199814481821255`"}], "-", 
       RowBox[{"1.740570086872113`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{355, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261310767]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167790641],

Cell["Polynomial equations with parameters:", "ExampleText",
 CellID->701208053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "-", 
       RowBox[{"3", "y"}], "+", 
       RowBox[{"4", "z"}]}], "\[Equal]", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190096957],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.5`", " ", 
       RowBox[{"(", 
        RowBox[{"1.5384615384615383`", "\[InvisibleSpace]", "-", 
         RowBox[{"2.485460680215925`", " ", 
          SqrtBox[
           RowBox[{"0.9383138810664822`", "\[InvisibleSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "0.4409964637611041`"}], "+", "z"}]]}], "-", 
         RowBox[{"1.2307692307692308`", " ", "z"}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.038461538461538464`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "30.`"}], "-", 
         RowBox[{"21.540659228538015`", " ", 
          SqrtBox[
           RowBox[{"0.9383138810664822`", "\[InvisibleSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "0.4409964637611041`"}], "+", "z"}]]}], "+", 
         RowBox[{"24.`", " ", "z"}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.5`", " ", 
       RowBox[{"(", 
        RowBox[{"1.5384615384615383`", "\[InvisibleSpace]", "+", 
         RowBox[{"2.485460680215925`", " ", 
          SqrtBox[
           RowBox[{"0.9383138810664822`", "\[InvisibleSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "0.4409964637611041`"}], "+", "z"}]]}], "-", 
         RowBox[{"1.2307692307692308`", " ", "z"}]}], ")"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.038461538461538464`", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "30.`"}], "+", 
         RowBox[{"21.540659228538015`", " ", 
          SqrtBox[
           RowBox[{"0.9383138810664822`", "\[InvisibleSpace]", "-", 
            RowBox[{"1.`", " ", "z"}]}]], " ", 
          SqrtBox[
           RowBox[{
            RowBox[{"-", "0.4409964637611041`"}], "+", "z"}]]}], "+", 
         RowBox[{"24.`", " ", "z"}]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{485, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127855822]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418728915],

Cell["Transcendental equations:", "ExampleText",
 CellID->893129077],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0.5"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->816127536],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->245076444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "0.5235987755982989`"}], "}"}], "}"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19493385]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22000736],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MonomialOrder",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->109209473],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " computes a Gr\[ODoubleDot]bner basis in ",
 Cell[BoxData["DegreeReverseLexicographic"], "InlineFormula"],
 " order:"
}], "ExampleText",
 CellID->724452505],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"t", "^", "50"}], "+", 
      RowBox[{"22", "t"}], "+", "17"}], ",", 
     RowBox[{"x", "-", 
      RowBox[{"t", "^", "49"}], "-", "7"}], ",", 
     RowBox[{"y", "-", 
      RowBox[{"t", "^", "49"}], "-", "12"}], ",", 
     RowBox[{"z", "-", 
      RowBox[{"2", 
       RowBox[{"t", "^", "49"}]}], "-", "17"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NSolve", "[", 
    RowBox[{
     RowBox[{"polys", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}]}], "]"}], "//", 
   "Length"}], "//", "Timing", " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33571574],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.647000000000003`", ",", "50"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251164699]
}, Open  ]],

Cell[TextData[{
 "Here using the ",
 Cell[BoxData["Lexicographic"], "InlineFormula"],
 " order is faster, since ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " already form a Gr\[ODoubleDot]bner basis:"
}], "ExampleText",
 CellID->373920398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NSolve", "[", 
    RowBox[{
     RowBox[{"polys", "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "t"}], "}"}], ",", 
     RowBox[{"MonomialOrder", "\[Rule]", "Lexicographic"}]}], "]"}], "//", 
   "Length"}], "//", "Timing", " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->47284086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6009999999999998`", ",", "50"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->117485034]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->354845507],

Cell["By default the solutions are machine precision numbers:", "ExampleText",
 CellID->152291148],

Cell[BoxData[
 RowBox[{
  RowBox[{"polys", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "13"}], "+", 
      RowBox[{"u", "^", "2"}], "+", 
      RowBox[{"4", "u", " ", "w"}], "+", 
      RowBox[{"w", "^", "2"}], "+", 
      RowBox[{"4", " ", "x"}], "-", 
      RowBox[{"2", " ", "u", " ", "x"}], "+", 
      RowBox[{"18", " ", 
       RowBox[{"x", "^", "2"}]}], "-", 
      RowBox[{"4", " ", "u", " ", "y"}], "-", 
      RowBox[{"4", " ", "w", " ", "y"}], "+", 
      RowBox[{"8", " ", 
       RowBox[{"y", "^", "2"}]}], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "w", "+", 
         RowBox[{"7", " ", "x"}], "+", "y"}], ")"}], " ", "z"}], "+", 
      RowBox[{"4", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "13"}], "+", 
      RowBox[{"u", "^", "2"}], "+", 
      RowBox[{"w", "^", "2"}], "-", 
      RowBox[{"6", " ", "u", " ", "x"}], "-", 
      RowBox[{"4", " ", "w", " ", "x"}], "+", 
      RowBox[{"3", " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{"4", " ", "y"}], "+", 
      RowBox[{"18", " ", "x", " ", "y"}], "+", 
      RowBox[{"5", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"u", "+", "w", "-", "x", "-", 
         RowBox[{"7", " ", "y"}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"u", "^", "2"}], "+", 
      RowBox[{"4", " ", "u", " ", "w"}], "-", 
      RowBox[{"w", "^", "2"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"2", "+", 
         RowBox[{"2", " ", "u"}], "-", "w", "+", 
         RowBox[{"7", " ", "x"}], "-", "y"}], ")"}], " ", "z"}], "-", 
      RowBox[{"10", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "3"}], "-", 
      RowBox[{"u", "^", "2"}], "+", 
      RowBox[{"4", " ", "w"}], "-", 
      RowBox[{"4", " ", "u", " ", "w"}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"w", "^", "2"}]}], "+", 
      RowBox[{"2", " ", "w", " ", "x"}], "+", 
      RowBox[{"10", " ", "w", " ", "y"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "u"}], "+", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"2", " ", "y"}]}], ")"}], " ", "z"}], "-", 
      RowBox[{"5", " ", 
       RowBox[{"z", "^", "2"}]}]}], ",", 
     RowBox[{
      RowBox[{"4", " ", "u"}], "-", 
      RowBox[{"8", " ", 
       RowBox[{"u", "^", "2"}]}], "-", 
      RowBox[{"4", " ", "u", " ", "w"}], "-", 
      RowBox[{"w", "^", "2"}], "+", 
      RowBox[{"2", " ", "u", " ", "x"}], "+", 
      RowBox[{"10", " ", "u", " ", "y"}], "+", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "w"}], "+", 
         RowBox[{"2", " ", "x"}], "-", 
         RowBox[{"2", " ", "y"}]}], ")"}], " ", "z"}], "-", 
      RowBox[{"5", " ", 
       RowBox[{"z", "^", "2"}]}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463185446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"sols", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "w", ",", "u"}], "}"}]}], "]"}]}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11563469],

Cell[BoxData["MachinePrecision"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->590746424]
}, Open  ]],

Cell[TextData[{
 "The values of ",
 Cell[BoxData[
  StyleBox["polys", "TI"]], "InlineFormula"],
 " at some of the machine precision solutions are relatively large:"
}], "ExampleText",
 CellID->12405315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"polys", "/.", "sols"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->280129192],

Cell[BoxData["2.0130574540644375`*^-8"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->795115148]
}, Open  ]],

Cell["This computes solutions using 50 digits of precision:", "ExampleText",
 CellID->41535734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"sols50", "=", 
   RowBox[{"NSolve", "[", 
    RowBox[{"polys", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z", ",", "w", ",", "u"}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "\[Rule]", "50"}]}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->677915707],

Cell[BoxData["49.33870222331118`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->349086594]
}, Open  ]],

Cell["\<\
The solutions computed with 50 digits of precision satisfy the equations much \
more accurately:\
\>", "ExampleText",
 CellID->540420051],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"polys", "/.", "sols50"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->217881087],

Cell[BoxData["0``46.432334327915655"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->3217489]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->364540237],

Cell["Solve a polynomial equation with inexact coefficients:", "ExampleText",
 CellID->337878005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.23", 
      RowBox[{"x", "^", "5"}]}], "+", 
     RowBox[{"4.56", " ", "x"}], "+", "7.89"}], "\[Equal]", "0"}], ",", "x"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294558259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.161080399055659`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.6753737049001037`"}], "-", 
      RowBox[{"1.2676849868716031`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.6753737049001037`"}], "+", 
      RowBox[{"1.2676849868716031`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.2559139044279333`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.0490366996449056`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.2559139044279333`", "\[InvisibleSpace]", "+", 
      RowBox[{"1.0490366996449056`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{531, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19927472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176545917],

Cell["Find intersection points of a circle and a parabola:", "ExampleText",
 CellID->173697132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pts", "=", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], "&&", 
     RowBox[{
      RowBox[{"y", "-", 
       RowBox[{"2", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"3", "/", "2"}]}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423403341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.5877852522924732`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8090169943749472`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.9510565162951538`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.3090169943749474`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.5877852522924675`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.8090169943749431`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.9510565162951501`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.3090169943749448`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{411, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546640334]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "-", 
       RowBox[{"2", 
        RowBox[{"x", "^", "2"}]}], "+", 
       RowBox[{"3", "/", "2"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], "/.", "pts"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->539463603],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxlWAlcjWkXTxQ+Q5YZS4yxNIWsMyrGcJCyZGvsU33ZyVKMIuPLMgYxEUVk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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
        36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
        53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
        70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
        87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
        103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
        117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
        131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
        145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 
        159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
        173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 
        187, 188, 189}],
       RowBox[{
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["y", "2"]}], "\[Equal]", "1"}]],
      Annotation[#, $CellContext`x^2 + $CellContext`y^2 == 1, 
       "Tooltip"]& ]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
        202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 
        216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 
        230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 
        244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 
        258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 
        272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 
        286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 
        300, 301, 302, 303, 304, 305, 306, 307, 308, 309}],
       RowBox[{
         RowBox[{
           FractionBox["3", "2"], "-", 
           RowBox[{"2", " ", 
             SuperscriptBox["x", "2"]}], "+", "y"}], "\[Equal]", "0"}]],
      Annotation[#, Rational[3, 2] - 2 $CellContext`x^2 + $CellContext`y == 0,
        "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 
        322, 323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 
        336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 
        350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 
        364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 
        378, 379, 380, 381, 382, 383, 384, 385, 386, 387, 388, 389, 390, 391, 
        392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 402, 403, 404, 405, 
        406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 419, 
        420, 421, 422, 423, 424, 425, 426, 427, 428, 429, 430, 431, 432, 433, 
        434, 435, 436, 437, 438}],
       RowBox[{
         RowBox[{
           FractionBox["3", "2"], "-", 
           RowBox[{"2", " ", 
             SuperscriptBox["x", "2"]}], "+", "y"}], "\[Equal]", "0"}]],
      Annotation[#, Rational[3, 2] - 2 $CellContext`x^2 + $CellContext`y == 0,
        "Tooltip"]& ]}}],
  AspectRatio->1,
  Epilog->{
    RGBColor[1, 0, 0], 
    PointSize[Medium], 
    PointBox[{{0.5877852522924732, -0.8090169943749472}, {-0.9510565162951538,
      0.3090169943749474}, {-0.5877852522924675, -0.8090169943749431}, {
     0.9510565162951501, 0.3090169943749448}}]},
  Frame->True,
  PlotRange->{{-1.5, 1.5}, {-1.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62700761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->749693307],

Cell["Solutions satisfy the equations:", "ExampleText",
 CellID->39579334],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"2", "x"}], "+", 
       RowBox[{"3", "y"}]}], "\[Equal]", "4"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45108859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->64369885],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.6153846153846154`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.3997040325158948`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.9230769230769231`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.26646935501059654`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.6153846153846154`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.3997040325158948`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.9230769230769231`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.26646935501059654`", " ", "\[ImaginaryI]"}]}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84334495]
}, Open  ]],

Cell["\<\
Solutions are given as replacement rules and can be directly used for \
substitution:\
\>", "ExampleText",
 CellID->270685625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"eqns", "/.", "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->303461412],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True"}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->574182094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140335967],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  RowBox[{"{", "}"}]], "InlineFormula"],
 " to represent the empty or no solution:"
}], "ExampleText",
 CellID->76403412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"x", "\[Equal]", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33130858],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114583614]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"{", "}"}], "}"}]], "InlineFormula"],
 " to represent the universal solution or that all points satisfy the \
equations:"
}], "ExampleText",
 CellID->161040392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->699929497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", "}"}], "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171490016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228893758],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will produce solutions according to their multiplicity:"
}], "ExampleText",
 CellID->168204610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "3"}]}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->837282633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293005907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8247230],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " computes numeric approximations of solutions:"
}], "ExampleText",
 CellID->134746661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}]}], "+", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->466347090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.3501391245098764`"}], "-", 
      RowBox[{"0.907124939317785`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "1.3501391245098764`"}], "+", 
      RowBox[{"0.907124939317785`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.3501391245098764`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.9071249393177853`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1.3501391245098764`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.9071249393177853`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{376, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->144094902]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " to get exact values of solutions:"
}], "ExampleText",
 CellID->242201337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "4"}], "-", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}]}], "+", "7"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14111241],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["6"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["6"]}]}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "+", 
        RowBox[{"\[ImaginaryI]", " ", 
         SqrtBox["6"]}]}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "+", 
       RowBox[{"\[ImaginaryI]", " ", 
        SqrtBox["6"]}]}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{509, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96555639]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->418933029],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " finds solutions in complex numbers:"
}], "ExampleText",
 CellID->521815933],

Cell[BoxData[
 RowBox[{
  RowBox[{"eqns", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "3"}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "4"}], "+", 
       RowBox[{"y", "^", "4"}]}], "\[Equal]", "2"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675509501],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27371172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.4286528668755195`"}], "-", 
       RowBox[{"1.425668037428392`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.5523289324629079`"}], "+", 
       RowBox[{"1.3494243351694046`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.4286528668755195`"}], "+", 
       RowBox[{"1.425668037428392`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.5523289324629079`"}], "-", 
       RowBox[{"1.3494243351694046`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.153626027662713`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.6916372321061665`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.2009746404322086`"}], "-", 
       RowBox[{"0.05002165858925898`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.3241471797945372`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.6980877340703188`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "1.2009746404322086`"}], "+", 
       RowBox[{"0.05002165858925898`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.3241471797945372`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.6980877340703188`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.7162099605832954`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.1480007374429029`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.7162099605832954`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", "1.1480007374429029`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1.2009746404322101`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.05002165858926043`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.3241471797945384`", "\[InvisibleSpace]", "+", 
       RowBox[{"0.6980877340703193`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"1.2009746404322101`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.05002165858926043`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"0.3241471797945384`", "\[InvisibleSpace]", "-", 
       RowBox[{"0.6980877340703193`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.42865286687551324`", "\[InvisibleSpace]", "-", 
       RowBox[{"1.4256680374283783`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.5523289324629249`"}], "-", 
       RowBox[{"1.3494243351693904`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"0.42865286687551324`", "\[InvisibleSpace]", "+", 
       RowBox[{"1.4256680374283783`", " ", "\[ImaginaryI]"}]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{
       RowBox[{"-", "0.5523289324629249`"}], "+", 
       RowBox[{"1.3494243351693904`", " ", "\[ImaginaryI]"}]}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.1536260276627128`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.6916372321061678`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{573, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1110791]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " to find solutions over specified domains:"
}], "ExampleText",
 CellID->73497767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals", ",", 
   RowBox[{"Backsubstitution", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->288282998],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->601849970]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRules"]], "InlineFormula"],
 " to get approximations of the solutions given as replacement rules:"
}], "ExampleText",
 CellID->239338229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ToRules", "[", 
   RowBox[{"N", "[", "%", "]"}], "]"}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->360567736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "1.1536260276627184`"}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.6916372321060871`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "1.1536260276627184`"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "0.6916372321060871`"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{405, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->68953066]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " to find an approximate solution instance starting the search at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "=", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->201580779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->344276846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[Rule]", "1.1536260276627142`"}], ",", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"-", "0.6916372321061673`"}]}]}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->498664740]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find exact solution instances:"
}], "ExampleText",
 CellID->51610312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{"eqns", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->94194871],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"Root", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["#1", "3"]}], "+", 
            SuperscriptBox["#1", "4"], "+", 
            SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}], "3"]}]]}], 
    ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         SuperscriptBox["#1", "4"], "+", 
         SuperscriptBox["#1", "6"]}], "&"}], ",", "1"}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{518, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->152086054]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " to get a numeric approximation of the solution:"
}], "ExampleText",
 CellID->535211351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->173343448],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1.1536260276627142`"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "0.6916372321061672`"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->70566716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28783799],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to solve differential equations numerically:"
}], "ExampleText",
 CellID->923959507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153355340],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "7.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False], "[", "x", "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{351, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44651467]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10154124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139224060]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->34110045],

Cell[TextData[{
 "If the solutions set is infinite, ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " gives its intersection with random hyperplanes:"
}], "ExampleText",
 CellID->35189764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47974524],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSolve", "::", "\<\"infsolns\"\>"}], ":", 
  " ", "\<\"Infinite solution set has dimension at least \\!\\(1\\). \
Returning intersection of solutions with \\!\\(\\(\\(-\\(\\(\\(85901\\\\ x\\)\
\\/60742\\)\\)\\)\\) + \\(28373\\\\ y\\)\\/30371 + z\\) == 1.\"\>"}]], \
"Message", "MSG",
 CellID->385347692],

Cell[BoxData[
 RowBox[{
  RowBox[{"NSolve", "::", "\<\"infsolns\"\>"}], ":", 
  " ", "\<\"Infinite solution set has dimension at least \\!\\(2\\). \
Returning intersection of solutions with \\!\\(\\(\\(-\\(\\(\\(159931\\\\ \
x\\)\\/152414\\)\\)\\)\\) + \\(145789\\\\ y\\)\\/152414 + z\\) == 1.\"\>"}]], \
"Message", "MSG",
 CellID->26411008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "0.061045030229491475`"}]}], ",", 
     RowBox[{"y", "\[Rule]", "0.9979609816460452`"}], ",", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"-", "0.018638224066214883`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.`"}], ",", 
     RowBox[{"z", "\[Rule]", "1.0000000000000002`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{473, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44769252]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4414643],

Cell["\<\
Solutions obtained with machine precision numeric computations may not be \
accurate:\
\>", "ExampleText",
 CellID->617905174],

Cell[BoxData[
 RowBox[{
  RowBox[{"poly", "=", 
   RowBox[{"Expand", "[", 
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{"x", "-", "i"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "30"}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325679370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->307751873],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0.999999999999997`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1.9999999999949625`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.000000002020569`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "3.9999998160430534`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "5.000008020073888`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "5.999790948900934`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "7.0036197024006475`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "7.960878143031859`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "9.216541288548322`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "9.843779799965954`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "10.76133458062942`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "11.210295902058714`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "12.405918997391344`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"12.470947779606417`", "\[InvisibleSpace]", "-", 
      RowBox[{"2.5529371201566238`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"12.470947779606417`", "\[InvisibleSpace]", "+", 
      RowBox[{"2.5529371201566238`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"14.859877469945946`", "\[InvisibleSpace]", "-", 
      RowBox[{"4.293213110287337`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"14.859877469945946`", "\[InvisibleSpace]", "+", 
      RowBox[{"4.293213110287337`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "16.894177046833807`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"17.68429345083459`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.568701603544058`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"17.68429345083459`", "\[InvisibleSpace]", "+", 
      RowBox[{"5.568701603544058`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"20.795256376184906`", "\[InvisibleSpace]", "-", 
      RowBox[{"6.318471436992857`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"20.795256376184906`", "\[InvisibleSpace]", "+", 
      RowBox[{"6.318471436992857`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"24.113607860863663`", "\[InvisibleSpace]", "-", 
      RowBox[{"6.392353350204665`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"24.113607860863663`", "\[InvisibleSpace]", "+", 
      RowBox[{"6.392353350204665`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"27.40640055912231`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.583176431515258`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"27.40640055912231`", "\[InvisibleSpace]", "+", 
      RowBox[{"5.583176431515258`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"30.18613526009328`", "\[InvisibleSpace]", "-", 
      RowBox[{"3.818548102041718`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"30.18613526009328`", "\[InvisibleSpace]", "+", 
      RowBox[{"3.818548102041718`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "31.83530911940219`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "31.83530911940219`"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{541, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270512595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"poly", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->117408235],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnElv1TAQx9MsXVjLIlTayxMXxBmQWA6AkODEh3iqkNoDApV+bvgIIU7i
Np2MM4vtxK8UqSXJG/9tjydj5xf3fVufn3z/sT4/PV6vvp6tf52cHv9effl5
1lwqtrJs60+WZZ8Psua4bo7aH/Pvb/PTHXZHt83vwn5aZ8/BeQnOb/1n9lL/
vGu9Cmt5Ac6L5leeXR876CVoB7309tJL5cXVXit31F01v6rm1PxvLhdEHbsq
9aJXrxJWh94ue3WoQp3raonbh7xX3ybU90T+3+5VS2bbB/E5uJpfrbM5uIPp
VMNWZUhfcqSUafVeoPpy9CoWDSnXehdYFGz9mPUt00sYr1juw+I+/liO7xrY
Z9s2cxfsIXeD6cs2og49Q+nsED6S6vFGwqW606tCeyqvSfXitJLy5T3ClyA7
Z+PZmpq937TFYDzb9QbsD5phyfi9r1Sn8rlW16/VcEzgmFI5RKsbt9XGrkT0
9pk+BqsQJBKx2VizFoArml2yBOUjXR3Y+kapfGV9Vap04XwDMwv0ARWV8hr0
PkGVR5FOxROMVNr3pp7cKitn4elnqycTbXbevdNqo3bCcWBoXPEKjG1G+Qmv
oDla0BpqlEPr7QfW42W1pzUVcZzcjqvAFlL3Y0wV3ZyVihbMKD5aeFzAjGRq
MKdmxXKRmQafP3DYG/VSYO9iOy57Y1cJ21MgXpDaPxTa45TQHEIeKz+6IbjT
9jcEl2NHEVxr9/7SO2L6GZZPLkNwuXwyVbbKGYe46jJyKx1VLbmlxjMcPdU9
9Yerj8sSN5uYps2F5+e0ptZuZqP4LHxuo+44iqtiz+N6YulSRektQ29erkqd
S/XgWEAvUJxWytA/tH7QUlktgVyW9roIZJq8lMp7sXS5PFbK0j/WWMTxGJpP
7MlrcK1Q/JV1EROLZ/oTWerdT3yqLGeykEba+IajPYhX5xr3MSjDep/EVhNE
y6yaUZjqRGlF6yZKK/isQA3Pckf6UUhUJT5Blc5/qXDYLgIw7pr31lzOabNS
gdQSwt7aSe2xbBmbu35qvWoOw3PWFThPnYOmxlml+m3sj0o9Q6w2gbeG5rJc
vfLSiyIGZ079mOdyvHZ55pkiDebuo47La+PGTDv3Kmgb54llM+lvPC6q4xyb
Wx93V7f/u4i5Y0RWXzcvU1QZfi7dnTsPRYZ9lPJZikLDz6V6vpQbG2ls7zXF
jUPRd7/RbecONo02pSUcd1nqvBTH1epq90SHoeWx6HPc2GhzooJtVyz1dLgz
VY80JsO/8/avwUU4/JWLUQkq+lN7d4HtHB/EvnP139KeBEk21GTF70JvA8Kq
DXvmzMNsNdZeXtnITvQcz7Y8ijwPU5fmwZTI/lRfnJEyUV66z1tavosG1z7n
GNzc2nM5eGyOb58LLp7hBp9jnN3qc/dz2/V9gdi3d2F74s/lqbtmRXwOM8J1
t/d9j0HZv2pHhaKKXG6/qXbQy756r91eDb4PW8dkw6razBGWfe/UIb47BHse
C99WrqqMz0ufveKM2suakyPC0G0dE22VZv8OjXC0Gn2WD6LM3289h36cnf5z
jGk3T1K7lihSKiXeFAGjyms5viXQ5lzybR+2HLb/TlovTZQp7g1bwe2FLY+T
O9iK7m9YqOyoJcmhiDRXB/0eBIYOHAteXuCqUfkxbKu4fJp678z1OS8TdX8P
Ip+FpTzX/3stwuzWDsNnq5GFP692rfXkSqYtGG8Ns+PZbwxcq8OJOFQzWL+9
wzFLD1vuzGDO0o+AtYyZQq4Dc7xsV7Os3zyaz8tJFDnV7RUOU2rYNo79ITin
cgBlz9uVHKbv3WhRz5BDeji8PrX7N4TdUY3TTUyPQzUPa5wewLvqoJZ/K8Xw
evc39uaQwz+zrX9GiUax\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{494, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->969638635]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4471],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NMinimize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NMinimize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpolatingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpolatingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6474],

Cell[TextData[ButtonBox["Numerical Mathematics: Basic Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalMathematics-BasicOperations"]], "Tutorials",
 CellID->123709578],

Cell[TextData[ButtonBox["Numerical Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalEquationSolving"]], "Tutorials",
 CellID->8152],

Cell[TextData[ButtonBox["Equations in One Variable",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EquationsInOneVariable"]], "Tutorials",
 CellID->8113],

Cell[TextData[{
 ButtonBox["Numerical Mathematics in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsInMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/NumericalMathematicsInMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->653],

Cell[TextData[ButtonBox["Numerical Solution of Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalSolutionOfPolynomialEquations"]], "Tutorials",
 CellID->7152]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3669],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#25940"], None}]], "RelatedLinks",
 CellID->11822],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
NSolve"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->449245855],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->207109104],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->9347631],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->366118263],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->622440497]
}, Open  ]],

Cell["New in 2  |  Last modified in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 3, 58.6569140}", "context" -> "System`", 
    "keywords" -> {
     "equations", "Jenkins-Traub algorithm", 
      "numerical solution of polynomial equations", "polynomial equations", 
      "polynomial root finding", "roots of polynomials", 
      "solution of polynomial equations", "direct method for root finding", 
      "direct equation solving method"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NSolve[lhs == rhs, var] gives a list of numerical approximations to the \
roots of a polynomial equation. NSolve[{eqn_1, eqn_2, ...}, {var_1, var_2, \
...}] solves a system of polynomial equations. ", "synonyms" -> {}, "title" -> 
    "NSolve", "type" -> "Symbol", "uri" -> "ref/NSolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7328, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->513124291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 90628, 2871}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3512, 77, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4135, 104, 44, 1, 70, "ObjectName",
 CellID->29260],
Cell[4182, 107, 1500, 47, 70, "Usage",
 CellID->25868]
}, Open  ]],
Cell[CellGroupData[{
Cell[5719, 159, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6197, 176, 423, 15, 70, "Notes",
 CellID->1570],
Cell[6623, 193, 668, 24, 70, "Notes",
 CellID->14537]
}, Closed]],
Cell[CellGroupData[{
Cell[7328, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->513124291],
Cell[CellGroupData[{
Cell[7713, 236, 148, 5, 70, "ExampleSection",
 CellID->254744762],
Cell[7864, 243, 90, 1, 70, "ExampleText",
 CellID->407324565],
Cell[CellGroupData[{
Cell[7979, 248, 240, 9, 28, "Input",
 CellID->70203665],
Cell[8222, 259, 1044, 30, 54, "Output",
 CellID->21011152]
}, Open  ]],
Cell[9281, 292, 103, 2, 70, "ExampleText",
 CellID->261857536],
Cell[CellGroupData[{
Cell[9409, 298, 445, 16, 28, "Input",
 CellID->168839098],
Cell[9857, 316, 935, 25, 54, "Output",
 CellID->789716255]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10841, 347, 219, 7, 70, "ExampleSection",
 CellID->73424097],
Cell[11063, 356, 75, 1, 70, "ExampleText",
 CellID->27800802],
Cell[CellGroupData[{
Cell[11163, 361, 241, 9, 70, "Input",
 CellID->418446648],
Cell[11407, 372, 937, 26, 54, "Output",
 CellID->407579846]
}, Open  ]],
Cell[12359, 401, 122, 3, 70, "ExampleDelimiter",
 CellID->714350],
Cell[12484, 406, 113, 3, 70, "ExampleText",
 CellID->274681437],
Cell[CellGroupData[{
Cell[12622, 413, 423, 15, 70, "Input",
 CellID->203335058],
Cell[13048, 430, 1232, 35, 54, "Output",
 CellID->138710870]
}, Open  ]],
Cell[14295, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->361949363],
Cell[14423, 473, 115, 3, 70, "ExampleText",
 CellID->105752139],
Cell[CellGroupData[{
Cell[14563, 480, 525, 18, 70, "Input",
 CellID->86226923],
Cell[15091, 500, 337, 7, 70, "Message",
 CellID->30635592],
Cell[15431, 509, 1279, 35, 54, "Output",
 CellID->533806205]
}, Open  ]],
Cell[16725, 547, 125, 3, 70, "ExampleDelimiter",
 CellID->587224177],
Cell[16853, 552, 90, 1, 70, "ExampleText",
 CellID->630506103],
Cell[CellGroupData[{
Cell[16968, 557, 510, 18, 70, "Input",
 CellID->67463579],
Cell[17481, 577, 1115, 30, 54, "Output",
 CellID->59984286]
}, Open  ]],
Cell[18611, 610, 124, 3, 70, "ExampleDelimiter",
 CellID->22700041],
Cell[18738, 615, 72, 1, 70, "ExampleText",
 CellID->249642838],
Cell[CellGroupData[{
Cell[18835, 620, 526, 18, 70, "Input",
 CellID->122633595],
Cell[19364, 640, 327, 11, 36, "Output",
 CellID->361266307]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19740, 657, 242, 7, 70, "ExampleSection",
 CellID->80751290],
Cell[19985, 666, 95, 1, 70, "ExampleText",
 CellID->235259990],
Cell[CellGroupData[{
Cell[20105, 671, 629, 21, 70, "Input",
 CellID->21972948],
Cell[20737, 694, 2436, 67, 122, "Output",
 CellID->261310767]
}, Open  ]],
Cell[23188, 764, 125, 3, 70, "ExampleDelimiter",
 CellID->167790641],
Cell[23316, 769, 80, 1, 70, "ExampleText",
 CellID->701208053],
Cell[CellGroupData[{
Cell[23421, 774, 516, 18, 70, "Input",
 CellID->190096957],
Cell[23940, 794, 2276, 62, 109, "Output",
 CellID->127855822]
}, Open  ]],
Cell[26231, 859, 125, 3, 70, "ExampleDelimiter",
 CellID->418728915],
Cell[26359, 864, 68, 1, 70, "ExampleText",
 CellID->893129077],
Cell[CellGroupData[{
Cell[26452, 869, 193, 7, 70, "Input",
 CellID->816127536],
Cell[26648, 878, 453, 8, 70, "Message",
 CellID->245076444],
Cell[27104, 888, 251, 8, 36, "Output",
 CellID->19493385]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27404, 902, 221, 7, 70, "ExampleSection",
 CellID->22000736],
Cell[CellGroupData[{
Cell[27650, 913, 234, 7, 70, "ExampleSubsection",
 CellID->109209473],
Cell[27887, 922, 305, 10, 70, "ExampleText",
 CellID->724452505],
Cell[28195, 934, 485, 16, 70, "Input",
 CellID->430221],
Cell[CellGroupData[{
Cell[28705, 954, 304, 10, 70, "Input",
 CellID->33571574],
Cell[29012, 966, 221, 7, 36, "Output",
 CellID->251164699]
}, Open  ]],
Cell[29248, 976, 260, 8, 70, "ExampleText",
 CellID->373920398],
Cell[CellGroupData[{
Cell[29533, 988, 370, 11, 70, "Input",
 CellID->47284086],
Cell[29906, 1001, 222, 7, 36, "Output",
 CellID->117485034]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30177, 1014, 237, 7, 70, "ExampleSubsection",
 CellID->354845507],
Cell[30417, 1023, 98, 1, 70, "ExampleText",
 CellID->152291148],
Cell[30518, 1026, 3005, 86, 70, "Input",
 CellID->463185446],
Cell[CellGroupData[{
Cell[33548, 1116, 279, 9, 70, "Input",
 CellID->11563469],
Cell[33830, 1127, 174, 5, 36, "Output",
 CellID->590746424]
}, Open  ]],
Cell[34019, 1135, 202, 6, 70, "ExampleText",
 CellID->12405315],
Cell[CellGroupData[{
Cell[34246, 1145, 161, 5, 70, "Input",
 CellID->280129192],
Cell[34410, 1152, 180, 5, 36, "Output",
 CellID->795115148]
}, Open  ]],
Cell[34605, 1160, 95, 1, 70, "ExampleText",
 CellID->41535734],
Cell[CellGroupData[{
Cell[34725, 1165, 339, 10, 70, "Input",
 CellID->677915707],
Cell[35067, 1177, 175, 5, 36, "Output",
 CellID->349086594]
}, Open  ]],
Cell[35257, 1185, 147, 4, 70, "ExampleText",
 CellID->540420051],
Cell[CellGroupData[{
Cell[35429, 1193, 163, 5, 70, "Input",
 CellID->217881087],
Cell[35595, 1200, 176, 5, 36, "Output",
 CellID->3217489]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[35832, 1212, 227, 7, 70, "ExampleSection",
 CellID->364540237],
Cell[36062, 1221, 97, 1, 70, "ExampleText",
 CellID->337878005],
Cell[CellGroupData[{
Cell[36184, 1226, 277, 10, 70, "Input",
 CellID->294558259],
Cell[36464, 1238, 1039, 29, 54, "Output",
 CellID->19927472]
}, Open  ]],
Cell[37518, 1270, 125, 3, 70, "ExampleDelimiter",
 CellID->176545917],
Cell[37646, 1275, 95, 1, 70, "ExampleText",
 CellID->173697132],
Cell[CellGroupData[{
Cell[37766, 1280, 494, 17, 70, "Input",
 CellID->423403341],
Cell[38263, 1299, 911, 28, 54, "Output",
 CellID->546640334]
}, Open  ]],
Cell[CellGroupData[{
Cell[39211, 1332, 900, 30, 70, "Input",
 CellID->539463603],
Cell[40114, 1364, 8894, 161, 70, "Output",
 CellID->62700761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49057, 1531, 237, 7, 70, "ExampleSection",
 CellID->749693307],
Cell[49297, 1540, 74, 1, 70, "ExampleText",
 CellID->39579334],
Cell[49374, 1543, 383, 14, 70, "Input",
 CellID->45108859],
Cell[CellGroupData[{
Cell[49782, 1561, 176, 6, 70, "Input",
 CellID->64369885],
Cell[49961, 1569, 934, 25, 54, "Output",
 CellID->84334495]
}, Open  ]],
Cell[50910, 1597, 136, 4, 70, "ExampleText",
 CellID->270685625],
Cell[CellGroupData[{
Cell[51071, 1605, 96, 3, 70, "Input",
 CellID->303461412],
Cell[51170, 1610, 314, 11, 36, "Output",
 CellID->574182094]
}, Open  ]],
Cell[51499, 1624, 125, 3, 70, "ExampleDelimiter",
 CellID->140335967],
Cell[51627, 1629, 278, 10, 70, "ExampleText",
 CellID->76403412],
Cell[CellGroupData[{
Cell[51930, 1643, 213, 7, 70, "Input",
 CellID->33130858],
Cell[52146, 1652, 175, 6, 36, "Output",
 CellID->114583614]
}, Open  ]],
Cell[52336, 1661, 344, 12, 70, "ExampleText",
 CellID->161040392],
Cell[CellGroupData[{
Cell[52705, 1677, 156, 5, 70, "Input",
 CellID->699929497],
Cell[52864, 1684, 198, 7, 36, "Output",
 CellID->171490016]
}, Open  ]],
Cell[53077, 1694, 125, 3, 70, "ExampleDelimiter",
 CellID->228893758],
Cell[53205, 1699, 229, 7, 70, "ExampleText",
 CellID->168204610],
Cell[CellGroupData[{
Cell[53459, 1710, 342, 13, 70, "Input",
 CellID->837282633],
Cell[53804, 1725, 519, 17, 36, "Output",
 CellID->293005907]
}, Open  ]],
Cell[54338, 1745, 123, 3, 70, "ExampleDelimiter",
 CellID->8247230],
Cell[54464, 1750, 219, 7, 70, "ExampleText",
 CellID->134746661],
Cell[CellGroupData[{
Cell[54708, 1761, 268, 10, 70, "Input",
 CellID->466347090],
Cell[54979, 1773, 935, 26, 54, "Output",
 CellID->144094902]
}, Open  ]],
Cell[55929, 1802, 214, 8, 70, "ExampleText",
 CellID->242201337],
Cell[CellGroupData[{
Cell[56168, 1814, 266, 10, 70, "Input",
 CellID->14111241],
Cell[56437, 1826, 893, 33, 49, "Output",
 CellID->96555639]
}, Open  ]],
Cell[57345, 1862, 125, 3, 70, "ExampleDelimiter",
 CellID->418933029],
Cell[57473, 1867, 209, 7, 70, "ExampleText",
 CellID->521815933],
Cell[57685, 1876, 397, 15, 70, "Input",
 CellID->675509501],
Cell[CellGroupData[{
Cell[58107, 1895, 176, 6, 70, "Input",
 CellID->27371172],
Cell[58286, 1903, 4084, 110, 156, "Output",
 CellID->1110791]
}, Open  ]],
Cell[62385, 2016, 223, 8, 70, "ExampleText",
 CellID->73497767],
Cell[CellGroupData[{
Cell[62633, 2028, 249, 7, 70, "Input",
 CellID->288282998],
Cell[62885, 2037, 3067, 54, 70, "Output",
 Evaluatable->False,
 CellID->601849970]
}, Open  ]],
Cell[65967, 2094, 366, 13, 70, "ExampleText",
 CellID->239338229],
Cell[CellGroupData[{
Cell[66358, 2111, 155, 5, 70, "Input",
 CellID->360567736],
Cell[66516, 2118, 567, 18, 36, "Output",
 CellID->68953066]
}, Open  ]],
Cell[67098, 2139, 448, 17, 70, "ExampleText",
 CellID->201580779],
Cell[CellGroupData[{
Cell[67571, 2160, 308, 11, 70, "Input",
 CellID->344276846],
Cell[67882, 2173, 320, 10, 36, "Output",
 CellID->498664740]
}, Open  ]],
Cell[68217, 2186, 227, 8, 70, "ExampleText",
 CellID->51610312],
Cell[CellGroupData[{
Cell[68469, 2198, 196, 6, 70, "Input",
 CellID->94194871],
Cell[68668, 2206, 966, 33, 60, "Output",
 CellID->152086054]
}, Open  ]],
Cell[69649, 2242, 220, 8, 70, "ExampleText",
 CellID->535211351],
Cell[CellGroupData[{
Cell[69894, 2254, 97, 3, 70, "Input",
 CellID->173343448],
Cell[69994, 2259, 346, 11, 36, "Output",
 CellID->70566716]
}, Open  ]],
Cell[70355, 2273, 124, 3, 70, "ExampleDelimiter",
 CellID->28783799],
Cell[70482, 2278, 229, 8, 70, "ExampleText",
 CellID->923959507],
Cell[CellGroupData[{
Cell[70736, 2290, 580, 19, 70, "Input",
 CellID->153355340],
Cell[71319, 2311, 534, 19, 36, "Output",
 CellID->44651467]
}, Open  ]],
Cell[CellGroupData[{
Cell[71890, 2335, 292, 10, 70, "Input",
 CellID->10154124],
Cell[72185, 2347, 2592, 47, 70, "Output",
 Evaluatable->False,
 CellID->139224060]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74826, 2400, 229, 7, 70, "ExampleSection",
 CellID->34110045],
Cell[75058, 2409, 259, 8, 70, "ExampleText",
 CellID->35189764],
Cell[CellGroupData[{
Cell[75342, 2421, 327, 11, 70, "Input",
 CellID->47974524],
Cell[75672, 2434, 338, 7, 70, "Message",
 CellID->385347692],
Cell[76013, 2443, 341, 7, 70, "Message",
 CellID->26411008],
Cell[76357, 2452, 640, 20, 36, "Output",
 CellID->44769252]
}, Open  ]],
Cell[77012, 2475, 123, 3, 70, "ExampleDelimiter",
 CellID->4414643],
Cell[77138, 2480, 136, 4, 70, "ExampleText",
 CellID->617905174],
Cell[77277, 2486, 292, 10, 70, "Input",
 CellID->325679370],
Cell[CellGroupData[{
Cell[77594, 2500, 159, 5, 70, "Input",
 CellID->307751873],
Cell[77756, 2507, 4105, 96, 156, "Output",
 CellID->270512595]
}, Open  ]],
Cell[CellGroupData[{
Cell[81898, 2608, 158, 5, 70, "Input",
 CellID->117408235],
Cell[82059, 2615, 2123, 39, 70, "Output",
 Evaluatable->False,
 CellID->969638635]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84243, 2661, 310, 9, 70, "SeeAlsoSection",
 CellID->4471],
Cell[84556, 2672, 1206, 44, 70, "SeeAlso",
 CellID->26448]
}, Open  ]],
Cell[CellGroupData[{
Cell[85799, 2721, 313, 9, 70, "TutorialsSection",
 CellID->6474],
Cell[86115, 2732, 193, 4, 70, "Tutorials",
 CellID->123709578],
Cell[86311, 2738, 160, 3, 70, "Tutorials",
 CellID->8152],
Cell[86474, 2743, 157, 3, 70, "Tutorials",
 CellID->8113],
Cell[86634, 2748, 322, 9, 70, "Tutorials",
 CellID->653],
Cell[86959, 2759, 193, 4, 70, "Tutorials",
 CellID->7152]
}, Open  ]],
Cell[CellGroupData[{
Cell[87189, 2768, 320, 9, 70, "RelatedLinksSection",
 CellID->3669],
Cell[87512, 2779, 267, 6, 70, "RelatedLinks",
 CellID->11822],
Cell[87782, 2787, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88203, 2805, 319, 9, 70, "MoreAboutSection",
 CellID->449245855],
Cell[88525, 2816, 143, 3, 70, "MoreAbout",
 CellID->207109104],
Cell[88671, 2821, 173, 3, 70, "MoreAbout",
 CellID->9347631],
Cell[88847, 2826, 151, 3, 70, "MoreAbout",
 CellID->366118263],
Cell[89001, 2831, 147, 3, 70, "MoreAbout",
 CellID->622440497]
}, Open  ]],
Cell[89163, 2837, 52, 0, 70, "History"],
Cell[89218, 2839, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

