(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25247,        784]
NotebookOptionsPosition[     21116,        649]
NotebookOutlinePosition[     22533,        688]
CellTagsIndexPosition[     22448,        683]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Contexts" :> 
          Documentation`HelpLookup["paclet:tutorial/Contexts"], 
          "Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Contexts\"\>", 
       2->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"], "Contexts" :> 
          Documentation`HelpLookup["paclet:ref/Contexts"], "Unique" :> 
          Documentation`HelpLookup["paclet:ref/Unique"], "ValueQ" :> 
          Documentation`HelpLookup["paclet:ref/ValueQ"], "FileNames" :> 
          Documentation`HelpLookup["paclet:ref/FileNames"], "NameQ" :> 
          Documentation`HelpLookup["paclet:ref/NameQ"], "Remove" :> 
          Documentation`HelpLookup["paclet:ref/Remove"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Information\"\>", 2->"\<\"Contexts\"\>", 
       3->"\<\"Unique\"\>", 4->"\<\"ValueQ\"\>", 5->"\<\"FileNames\"\>", 
       6->"\<\"NameQ\"\>", 7->"\<\"Remove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Low-Level System Spelunking" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemSpelunking"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Low-Level System Spelunking\"\>", 
       3->"\<\"Mathematica Session Information\"\>", 
       4->"\<\"Mathematica Sessions\"\>", 5->"\<\"Namespace Management\"\>", 
       6->"\<\"Package Development\"\>", 7->"\<\"Symbol Handling\"\>", 
       8->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Names", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Names",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Names"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the names of symbols which match the \
string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Names",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Names"], "[", 
       StyleBox["patt", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of names matching the arbitrary string \
pattern ",
     Cell[BoxData[
      StyleBox["patt", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->29719]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives the same list of names as ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["string", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Names",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Names"]], "InlineFormula"],
 " returns a list of strings corresponding to the names of symbols. "
}], "Notes",
 CellID->24439],

Cell["The string can contain the following metacharacters:", "Notes",
 CellID->23859],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "match zero or more characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "@", Cell[
    "match one or more characters, but not upper-case letters", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->439942953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"], "[", "\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"context\", \"TI\"]`\)]\)*\>\"", "]"}]], "InlineFormula"],
 " lists all symbols in the specified context. "
}], "Notes",
 CellID->12238],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpellingCorrection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingCorrection"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Names",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Names"]], "InlineFormula"],
 " includes names which differ in a small fraction of their characters from \
those specifically requested. "
}], "Notes",
 CellID->5241],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SpellingCorrection",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SpellingCorrection"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Names",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Names"]], "InlineFormula"],
 " treats lower\[Hyphen] and upper\[Hyphen]case letters as equivalent when \
matching names. "
}], "Notes",
 CellID->20803],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"], "[", "]"}]], "InlineFormula"],
 " lists all names in all contexts. "
}], "Notes",
 CellID->6006]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200480603],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->53704264],

Cell[TextData[{
 "Get the names of symbols starting with ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->121189108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<List*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->407578117],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"List\"\>", ",", "\<\"Listable\"\>", ",", "\<\"ListAnimate\"\>",
    ",", "\<\"ListContourPlot\"\>", ",", "\<\"ListContourPlot3D\"\>", 
   ",", "\<\"ListConvolve\"\>", ",", "\<\"ListCorrelate\"\>", 
   ",", "\<\"ListDensityPlot\"\>", ",", "\<\"Listen\"\>", 
   ",", "\<\"ListInterpolation\"\>", ",", "\<\"ListLinePlot\"\>", 
   ",", "\<\"ListLogLinearPlot\"\>", ",", "\<\"ListLogLogPlot\"\>", 
   ",", "\<\"ListLogPlot\"\>", ",", "\<\"ListPlay\"\>", 
   ",", "\<\"ListPlot\"\>", ",", "\<\"ListPlot3D\"\>", 
   ",", "\<\"ListPointPlot3D\"\>", ",", "\<\"ListPolarPlot\"\>", 
   ",", "\<\"ListQ\"\>", ",", "\<\"ListSurfacePlot3D\"\>"}], "}"}]], "Output",\

 ImageSize->{543, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182184860]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->368877836],

Cell["Get the names of all system symbols:", "ExampleText",
 CellID->222400394],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"systemnames", " ", "=", " ", 
   RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Short", "[", "systemnames", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->795839],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{"\<\"Abort\"\>", ",", "\<\"AbortProtect\"\>", ",", 
    RowBox[{"\[LeftSkeleton]", "2957", "\[RightSkeleton]"}], 
    ",", "\<\"$Version\"\>", ",", "\<\"$VersionNumber\"\>"}], "}"}],
  Short]], "Output",
 ImageSize->{392, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->275310559]
}, Open  ]],

Cell[TextData[{
 "The set of those that have the ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " attribute:"
}], "ExampleText",
 CellID->79367676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"systemnames", ",", 
   RowBox[{
    RowBox[{"MemberQ", "[", 
     RowBox[{
      RowBox[{"Attributes", "[", "#", "]"}], ",", "Orderless"}], "]"}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276156195],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ArithmeticGeometricMean\"\>", ",", "\<\"BitAnd\"\>", 
   ",", "\<\"BitOr\"\>", ",", "\<\"BitXor\"\>", ",", "\<\"CoprimeQ\"\>", 
   ",", "\<\"DiracDelta\"\>", ",", "\<\"DiscreteDelta\"\>", 
   ",", "\<\"GCD\"\>", ",", "\<\"HeavisideTheta\"\>", 
   ",", "\<\"KroneckerDelta\"\>", ",", "\<\"LCM\"\>", ",", "\<\"Max\"\>", 
   ",", "\<\"Min\"\>", ",", "\<\"Multinomial\"\>", ",", "\<\"Plus\"\>", 
   ",", "\<\"Times\"\>", ",", "\<\"UnitStep\"\>", ",", "\<\"Xor\"\>"}], 
  "}"}]], "Output",
 ImageSize->{441, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->527325165]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4524],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Contexts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Contexts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ValueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ValueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNames",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNames"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25078]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22620],

Cell[TextData[ButtonBox["Contexts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Contexts"]], "Tutorials",
 CellID->28243],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->32670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->355952741],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->640346086],

Cell[TextData[ButtonBox["Low-Level System Spelunking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemSpelunking"]], "MoreAbout",
 CellID->270720248],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->57641341],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->880691688],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->149232400],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->98479784],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->258194010],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->37132449]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Names - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 17.5121638}", "context" -> "System`", 
    "keywords" -> {
     "catalog", "known symbols", "make list of symbols", "names listing", 
      "search for symbols", "all system symbols", "name space"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Names[\"string\"] gives a list of the names of symbols which match the \
string. Names[patt] gives a list of names matching the arbitrary string \
pattern patt.", "synonyms" -> {"who"}, "title" -> "Names", "type" -> "Symbol",
     "uri" -> "ref/Names"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12881, 355, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->200480603]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22304, 676}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3631, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4254, 105, 4189, 83, 70, "ObjectNameGrid"],
Cell[8446, 190, 914, 29, 70, "Usage",
 CellID->29719]
}, Open  ]],
Cell[CellGroupData[{
Cell[9397, 224, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9875, 241, 357, 13, 70, "Notes",
 CellID->18296],
Cell[10235, 256, 227, 7, 70, "Notes",
 CellID->24439],
Cell[10465, 265, 85, 1, 70, "Notes",
 CellID->23859],
Cell[10553, 268, 487, 11, 70, "2ColumnTableMod",
 CellID->439942953],
Cell[11043, 281, 301, 10, 70, "Notes",
 CellID->12238],
Cell[11347, 293, 525, 18, 70, "Notes",
 CellID->5241],
Cell[11875, 313, 746, 27, 70, "Notes",
 CellID->20803],
Cell[12624, 342, 220, 8, 70, "Notes",
 CellID->6006]
}, Closed]],
Cell[CellGroupData[{
Cell[12881, 355, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->200480603],
Cell[CellGroupData[{
Cell[13266, 369, 147, 5, 70, "ExampleSection",
 CellID->53704264],
Cell[13416, 376, 214, 8, 70, "ExampleText",
 CellID->121189108],
Cell[CellGroupData[{
Cell[13655, 388, 113, 3, 28, "Input",
 CellID->407578117],
Cell[13771, 393, 827, 17, 88, "Output",
 CellID->182184860]
}, Open  ]],
Cell[14613, 413, 125, 3, 70, "ExampleDelimiter",
 CellID->368877836],
Cell[14741, 418, 79, 1, 70, "ExampleText",
 CellID->222400394],
Cell[CellGroupData[{
Cell[14845, 423, 249, 7, 70, "Input",
 CellID->795839],
Cell[15097, 432, 391, 11, 36, "Output",
 CellID->275310559]
}, Open  ]],
Cell[15503, 446, 225, 8, 70, "ExampleText",
 CellID->79367676],
Cell[CellGroupData[{
Cell[15753, 458, 270, 9, 70, "Input",
 CellID->276156195],
Cell[16026, 469, 659, 14, 71, "Output",
 CellID->527325165]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16746, 490, 310, 9, 70, "SeeAlsoSection",
 CellID->4524],
Cell[17059, 501, 1666, 62, 70, "SeeAlso",
 CellID->25078]
}, Open  ]],
Cell[CellGroupData[{
Cell[18762, 568, 314, 9, 70, "TutorialsSection",
 CellID->22620],
Cell[19079, 579, 127, 3, 70, "Tutorials",
 CellID->28243],
Cell[19209, 584, 191, 4, 70, "Tutorials",
 CellID->32670]
}, Open  ]],
Cell[CellGroupData[{
Cell[19437, 593, 319, 9, 70, "MoreAboutSection",
 CellID->355952741],
Cell[19759, 604, 169, 3, 70, "MoreAbout",
 CellID->640346086],
Cell[19931, 609, 163, 3, 70, "MoreAbout",
 CellID->270720248],
Cell[20097, 614, 171, 3, 70, "MoreAbout",
 CellID->57641341],
Cell[20271, 619, 151, 3, 70, "MoreAbout",
 CellID->880691688],
Cell[20425, 624, 151, 3, 70, "MoreAbout",
 CellID->149232400],
Cell[20579, 629, 148, 3, 70, "MoreAbout",
 CellID->98479784],
Cell[20730, 634, 141, 3, 70, "MoreAbout",
 CellID->258194010],
Cell[20874, 639, 147, 3, 70, "MoreAbout",
 CellID->37132449]
}, Open  ]],
Cell[21036, 645, 50, 0, 70, "History"],
Cell[21089, 647, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

