(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     43399,       1567]
NotebookOptionsPosition[     35148,       1279]
NotebookOutlinePosition[     36575,       1318]
CellTagsIndexPosition[     36489,       1313]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "And" :> 
          Documentation`HelpLookup["paclet:ref/And"], "Nor" :> 
          Documentation`HelpLookup["paclet:ref/Nor"], "Not" :> 
          Documentation`HelpLookup["paclet:ref/Not"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 2->"\<\"And\"\>", 
       3->"\<\"Nor\"\>", 4->"\<\"Not\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nand", "ObjectName",
 CellID->7483],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nand"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the logical NAND function. It evaluates its \
arguments in order, giving ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " immediately if any of them are ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if they are all ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nand"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[Nand]", 
    SubscriptBox["e", "2"], "\[Nand]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". The character ",
 Cell[BoxData["\[Nand]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]nand\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Nand]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Nand"]], "InlineCharacterName"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->425944919]
}], "Notes",
 CellID->12537],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nand"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], "[", 
   RowBox[{
    ButtonBox["And",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/And"], "[", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->288385943]
}], "Notes",
 CellID->11560],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and explicitly controls the evaluation of its arguments. In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nand"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are evaluated in order, stopping if any of them is found to be ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->76232233]
}], "Notes",
 CellID->31349],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " gives symbolic results when necessary, removing initial arguments that are \
",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->18400621]
}], "Notes",
 CellID->10923],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " is not ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30883]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->629567459],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->208456370],

Cell["Symbolic arguments:", "ExampleText",
 CellID->234529830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nand", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3944073],

Cell[BoxData[
 RowBox[{"x", "\[Nand]", "y", "\[Nand]", "z"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623002385]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17419188],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]nand\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->425944919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "\[Nand]", "q"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->334579468],

Cell[BoxData[
 RowBox[{"p", "\[Nand]", "q"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12361568]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21157],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " with explicit ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " arguments will simplify:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18400621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nand", "[", 
  RowBox[{"x", ",", "True", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534512268],

Cell[BoxData[
 RowBox[{"x", "\[Nand]", "z"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79858847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nand", "[", 
  RowBox[{"x", ",", "False", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599319570],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9948100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39071304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " evaluates its arguments in order, stopping when an argument evaluates to \
",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->76232233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "False"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201736223],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->311354273],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27256151]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "True"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200768372],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->891690134],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->297228073]
}, Open  ]],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149791686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375923361],

Cell[TextData[{
 "Symbolic transformations may not preserve argument ordering or ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " operations:"
}], "ExampleText",
 CellID->531520307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "\[Nand]", 
  RowBox[{"!", "x"}], "\[Nand]", 
  RowBox[{"!", "y"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18042936],

Cell[BoxData[
 RowBox[{"z", "\[Nand]", 
  RowBox[{"!", "x"}], "\[Nand]", 
  RowBox[{"!", "y"}]}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232639490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172565786],

Cell[BoxData[
 RowBox[{"x", "||", "y", "||", 
  RowBox[{"!", "z"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354754997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63290867],

Cell["TraditionalForm formatting:", "ExampleText",
 CellID->37738970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Nand", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344385729],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Nand]", "y", "\[Nand]", "z"}], TraditionalForm]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->337331458]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4485],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " of two regions:"
}], "ExampleText",
 CellID->37965020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Nand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->958192352],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11084101]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15883216],

Cell[TextData[{
 "A cellular automaton based on ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12039839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Nand", "@@", "#"}], "&"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}], ",", "40"}], "]"}], ",", 
     "20"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40098381],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiJAkGIPs/kAXG
ICEgYAaxwYBhA5BgJF2UBS4KBBxAThSQ5gXSFkAaJMkydNUi+ZgVSCRDZR0G
WtVgCJvhEI6joT0ajkMvHEdDezQcR8N8MKkdDcfRMB9MYTMcwnE0tAc0HFmR
3M6CxOeF0pxI8qxAmgNIc0JpXqh6Dqg8JxItSET4jdpNc7sp7vdDxw8YAeNu
zi4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100835093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12625347],

Cell[TextData[{
 "Simplify trees of ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 "'s:"
}], "ExampleText",
 CellID->170940585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Nand", "[", 
     RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", "p", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327147365],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWm1v0zAQTpum3SidNt4FEhq/Ar4MhJDgEz+impA2IQQahS/AT+I3GtuN
u/Ry9p0dp3nBldrE9vnuufPZdfL443pz9enLenN9uT7/cLP+dnV9+f38/dcb
WZVPsmx6kmXZiyeZvBfyTn/N51R+b4vb0l31m++kspmjLH+zqfyqnqqqALJz
pK+SP/LQAe1zdNpwnllsYDZtOG06XHEKxZ3iHR5vKJ9rnUuOlqI6RxSOe4Ru
Vgy9tVIecUaqbvW+p1aeL021BvmWxq134zbVeu94alG9ZrII63OLHDWOsB+G
EtOj+82qMcKkWCuNR0ydaBhyVNS8vA+wFzseKTvGnB2Yf2ErRn01wzDWfKj1
Yq1pjvUax4Ii9u7VFBsvbhRWXtwoLXHiFoYldhxTPsaJY8pHB9ZIqyK+nyxY
uOPknsNWTzIOR8iLUZw8i4mgm9Uu5VnKs/3yROvpfhXDn33hG6z2c4qHo/1M
wqWaxCNO/oTFJ+VPyh+H50Hrj3rzjO6Qb5//5c3cJQnHba/nMdNmXutZMG2i
uePEwI1DHRM3DkXEOHBtsuaUV1xSvvjFYVz50mCN2Xt3qLCUpJT+KHx5Zbyq
bXBftShlj0mtRnLG0Aox71nx8sX05PgyF76+cLRSo+b0LY1bb8cNn30sVrdS
VrNVbTZWoP4hKC9LOepMBOwH25cWew+YcpQ/lP2x+4+zkD4nWdTtU1B+TLTD
/lAetj8D5UdEO4WXsjd0//ATHG/l70JWvgTXN+X1taX9ne4tyg928im0BHGr
W/guxqyW5tQNbK/mqloX2z7lA8uuuXIIPOjuk9Bpw2k7MWTTufDQQeXoD62D
4n3MPyH05tQip0enR6dbdpig9h5h9LZC+kKdlWGhiHICR8X/p7BlGsbKzy31
vDMN2FPXcE9kcJ5jh+td1+dNqH6x7VG7iI2wzRP8fePuHyEig650wjcE/9OJ
Acx/3lvqccajCTYPtqP1uKHtBzxBofJqu+Pi6VyhtT4MDdyhjZEJhz62z691
7/NhZmVjzq3xXIzJvv3Scrx/1iHMvK5Y3sPPt8Rnc3AsRNt2+TMKY66Wlno+
B3jCtDQsJpMzn4bvZR/52joGbE1pl6+tzCEnK7VC6lys2xmpsXsmEM38nmPu
hr00skdRtfLW8+diy3JBvqUpKwffio6N9futowlrL0DZl+WCaIbGmv3RUfks
tiyXuRrW61V5/aulRPmhOa1s8g9FAzxJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{526, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9063306]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220831765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", 
   RowBox[{"!", "p"}], ",", "p", ",", 
   RowBox[{"!", "p"}], ",", "p"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->407425483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114726115],

Cell["\<\
Find the area of the complement of the intersection of sets given by \
algebraic conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"Nand", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData[
 RowBox[{"17", "-", "\[Pi]"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32720299]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Nand", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198502635]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4227841],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->470387246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Nand", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"False", "True"},
    {"True", "True"}
   }],
  "Grid"]], "Output",
 ImageSize->{75, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->222987642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257522093],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to expand in terms of ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->392725173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Nand", "[", 
   RowBox[{"p", ",", "q", ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164328352],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "p"}], "||", 
  RowBox[{"!", "q"}], "||", 
  RowBox[{"!", "r"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->807165760]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->705562055],

Cell[TextData[{
 "The negation of ",
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->288385943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"Nand", "[", 
    RowBox[{"p", ",", "q", ",", "r"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258849493],

Cell[BoxData[
 RowBox[{"p", "&&", "q", "&&", "r"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119879105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94130961],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nand"]], "InlineFormula"],
 " of conditions in ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->257207371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"Nand", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], "-", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{
     RowBox[{"Boole", "[", "a", "]"}], 
     RowBox[{"Boole", "[", "b", "]"}], 
     RowBox[{"Boole", "[", "c", "]"}]}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551050724],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{
   RowBox[{"Boole", "[", "a", "]"}], " ", 
   RowBox[{"Boole", "[", "b", "]"}], " ", 
   RowBox[{"Boole", "[", "c", "]"}]}], "+", 
  RowBox[{"Boole", "[", 
   RowBox[{"a", "\[Nand]", "b", "\[Nand]", "c"}], "]"}]}]], "Output",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15604287]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40654382],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5422887]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26984],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["And",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/And"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14409]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15905],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->15847],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->163891692],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->372269445]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Nand"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 18.0746782}", "context" -> "System`", 
    "keywords" -> {
     "laws of form", "Sheffer stroke", "stroke", "logical connective", 
      "Boolean algebra", "switching algebra", "propositional logic"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Nand[e_1, e_2, ...] is the logical NAND function. It evaluates its \
arguments in order, giving True immediately if any of them are False, and \
False if they are all True. ", "synonyms" -> {"|"}, "title" -> "Nand", "type" -> 
    "Symbol", "uri" -> "ref/Nand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8758, 309, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->629567459]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36346, 1306}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2164, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2787, 79, 41, 1, 70, "ObjectName",
 CellID->7483],
Cell[2831, 82, 1324, 43, 70, "Usage",
 CellID->19221]
}, Open  ]],
Cell[CellGroupData[{
Cell[4192, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4670, 147, 1282, 46, 70, "Notes",
 CellID->12537],
Cell[5955, 195, 958, 37, 70, "Notes",
 CellID->11560],
Cell[6916, 234, 1073, 38, 70, "Notes",
 CellID->31349],
Cell[7992, 274, 441, 16, 70, "Notes",
 CellID->10923],
Cell[8436, 292, 285, 12, 70, "Notes",
 CellID->30883]
}, Closed]],
Cell[CellGroupData[{
Cell[8758, 309, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->629567459],
Cell[CellGroupData[{
Cell[9143, 323, 148, 5, 70, "ExampleSection",
 CellID->208456370],
Cell[9294, 330, 62, 1, 70, "ExampleText",
 CellID->234529830],
Cell[CellGroupData[{
Cell[9381, 335, 131, 4, 28, "Input",
 CellID->3944073],
Cell[9515, 341, 202, 6, 36, "Output",
 CellID->623002385]
}, Open  ]],
Cell[9732, 350, 124, 3, 70, "ExampleDelimiter",
 CellID->17419188],
Cell[9859, 355, 241, 8, 70, "ExampleText",
 CellID->425944919],
Cell[CellGroupData[{
Cell[10125, 367, 98, 3, 70, "Input",
 CellID->334579468],
Cell[10226, 372, 185, 6, 36, "Output",
 CellID->12361568]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10460, 384, 216, 7, 70, "ExampleSection",
 CellID->21157],
Cell[10679, 393, 494, 18, 70, "ExampleText",
 CellID->18400621],
Cell[CellGroupData[{
Cell[11198, 415, 136, 4, 70, "Input",
 CellID->534512268],
Cell[11337, 421, 185, 6, 36, "Output",
 CellID->79858847]
}, Open  ]],
Cell[CellGroupData[{
Cell[11559, 432, 137, 4, 70, "Input",
 CellID->599319570],
Cell[11699, 438, 159, 5, 36, "Output",
 CellID->9948100]
}, Open  ]],
Cell[11873, 446, 124, 3, 70, "ExampleDelimiter",
 CellID->39071304],
Cell[12000, 451, 411, 14, 70, "ExampleText",
 CellID->76232233],
Cell[CellGroupData[{
Cell[12436, 469, 246, 8, 70, "Input",
 CellID->201736223],
Cell[12685, 479, 91, 2, 70, "Print",
 CellID->311354273],
Cell[12779, 483, 160, 5, 36, "Output",
 CellID->27256151]
}, Open  ]],
Cell[CellGroupData[{
Cell[12976, 493, 245, 8, 70, "Input",
 CellID->200768372],
Cell[CellGroupData[{
Cell[13246, 505, 91, 2, 70, "Print",
 CellID->891690134],
Cell[13340, 509, 91, 2, 70, "Print",
 CellID->297228073]
}, Open  ]],
Cell[13446, 514, 162, 5, 36, "Output",
 CellID->149791686]
}, Open  ]],
Cell[13623, 522, 125, 3, 70, "ExampleDelimiter",
 CellID->375923361],
Cell[13751, 527, 249, 8, 70, "ExampleText",
 CellID->531520307],
Cell[CellGroupData[{
Cell[14025, 539, 149, 5, 70, "Input",
 CellID->18042936],
Cell[14177, 546, 238, 8, 36, "Output",
 CellID->232639490]
}, Open  ]],
Cell[CellGroupData[{
Cell[14452, 559, 104, 3, 70, "Input",
 CellID->172565786],
Cell[14559, 564, 210, 7, 36, "Output",
 CellID->354754997]
}, Open  ]],
Cell[14784, 574, 124, 3, 70, "ExampleDelimiter",
 CellID->63290867],
Cell[14911, 579, 69, 1, 70, "ExampleText",
 CellID->37738970],
Cell[CellGroupData[{
Cell[15005, 584, 175, 6, 70, "Input",
 CellID->344385729],
Cell[15183, 592, 248, 7, 50, "Output",
 CellID->337331458]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15480, 605, 222, 7, 70, "ExampleSection",
 CellID->4485],
Cell[15705, 614, 198, 8, 70, "ExampleText",
 CellID->37965020],
Cell[CellGroupData[{
Cell[15928, 626, 518, 18, 70, "Input",
 CellID->958192352],
Cell[16449, 646, 2403, 43, 70, "Output",
 Evaluatable->False,
 CellID->11084101]
}, Open  ]],
Cell[18867, 692, 124, 3, 70, "ExampleDelimiter",
 CellID->15883216],
Cell[18994, 697, 204, 8, 70, "ExampleText",
 CellID->12039839],
Cell[CellGroupData[{
Cell[19223, 709, 489, 16, 70, "Input",
 CellID->40098381],
Cell[19715, 727, 460, 12, 70, "Output",
 Evaluatable->False,
 CellID->100835093]
}, Open  ]],
Cell[20190, 742, 124, 3, 70, "ExampleDelimiter",
 CellID->12625347],
Cell[20317, 747, 195, 8, 70, "ExampleText",
 CellID->170940585],
Cell[CellGroupData[{
Cell[20537, 759, 218, 8, 70, "Input",
 CellID->327147365],
Cell[20758, 769, 1462, 28, 70, "Output",
 Evaluatable->False,
 CellID->9063306]
}, Open  ]],
Cell[CellGroupData[{
Cell[22257, 802, 104, 3, 70, "Input",
 CellID->220831765],
Cell[22364, 807, 272, 9, 36, "Output",
 CellID->407425483]
}, Open  ]],
Cell[22651, 819, 125, 3, 70, "ExampleDelimiter",
 CellID->114726115],
Cell[22779, 824, 143, 4, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[22947, 832, 730, 25, 70, "Input",
 CellID->310451651],
Cell[23680, 859, 184, 6, 36, "Output",
 CellID->32720299]
}, Open  ]],
Cell[23879, 868, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[23964, 873, 686, 24, 70, "Input",
 CellID->167686269],
Cell[24653, 899, 2657, 48, 70, "Output",
 Evaluatable->False,
 CellID->198502635]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27359, 953, 235, 7, 70, "ExampleSection",
 CellID->4227841],
Cell[27597, 962, 191, 8, 70, "ExampleText",
 CellID->470387246],
Cell[CellGroupData[{
Cell[27813, 974, 282, 10, 70, "Input",
 CellID->95768180],
Cell[28098, 986, 234, 10, 48, "Output",
 CellID->222987642]
}, Open  ]],
Cell[28347, 999, 125, 3, 70, "ExampleDelimiter",
 CellID->257522093],
Cell[28475, 1004, 451, 18, 70, "ExampleText",
 CellID->392725173],
Cell[CellGroupData[{
Cell[28951, 1026, 174, 5, 70, "Input",
 CellID->164328352],
Cell[29128, 1033, 246, 9, 36, "Output",
 CellID->807165760]
}, Open  ]],
Cell[29389, 1045, 125, 3, 70, "ExampleDelimiter",
 CellID->705562055],
Cell[29517, 1050, 371, 14, 70, "ExampleText",
 CellID->288385943],
Cell[CellGroupData[{
Cell[29913, 1068, 194, 6, 70, "Input",
 CellID->258849493],
Cell[30110, 1076, 192, 6, 36, "Output",
 CellID->119879105]
}, Open  ]],
Cell[30317, 1085, 124, 3, 70, "ExampleDelimiter",
 CellID->94130961],
Cell[30444, 1090, 316, 12, 70, "ExampleText",
 CellID->257207371],
Cell[CellGroupData[{
Cell[30785, 1106, 368, 12, 70, "Input",
 CellID->551050724],
Cell[31156, 1120, 418, 13, 36, "Output",
 CellID->15604287]
}, Open  ]],
Cell[CellGroupData[{
Cell[31611, 1138, 103, 3, 70, "Input",
 CellID->40654382],
Cell[31717, 1143, 156, 5, 36, "Output",
 CellID->5422887]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[31934, 1155, 311, 9, 70, "SeeAlsoSection",
 CellID->26984],
Cell[32248, 1166, 921, 35, 70, "SeeAlso",
 CellID->14409]
}, Open  ]],
Cell[CellGroupData[{
Cell[33206, 1206, 314, 9, 70, "TutorialsSection",
 CellID->15905],
Cell[33523, 1217, 172, 3, 70, "Tutorials",
 CellID->15847],
Cell[33698, 1222, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[33868, 1230, 319, 9, 70, "MoreAboutSection",
 CellID->163891692],
Cell[34190, 1241, 157, 3, 70, "MoreAbout",
 CellID->372269445]
}, Open  ]],
Cell[CellGroupData[{
Cell[34384, 1249, 305, 8, 70, "RelatedLinksSection"],
Cell[34692, 1259, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[35089, 1275, 29, 0, 70, "History"],
Cell[35121, 1277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

