(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     91907,       2443]
NotebookOptionsPosition[     82969,       2136]
NotebookOutlinePosition[     84700,       2180]
CellTagsIndexPosition[     84614,       2175]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"], "Using Nearest" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingNearest"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>", 
       2->"\<\"Using Nearest\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindClusters" :> 
          Documentation`HelpLookup["paclet:ref/FindClusters"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "Interpolation" :> 
          Documentation`HelpLookup["paclet:ref/Interpolation"], 
          "NearestFunction" :> 
          Documentation`HelpLookup["paclet:ref/NearestFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindClusters\"\>", 
       2->"\<\"Norm\"\>", 3->"\<\"Sort\"\>", 4->"\<\"Quantile\"\>", 
       5->"\<\"Interpolation\"\>", 
       6->"\<\"NearestFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Processing Textual Data" :> 
          Documentation`HelpLookup["paclet:guide/ProcessingTextualData"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Exploratory Data Analysis\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 
       4->"\<\"Logic & Boolean Algebra\"\>", 
       5->"\<\"Math & Counting Operations on Lists\"\>", 
       6->"\<\"Numerical Data\"\>", 7->"\<\"Processing Textual Data\"\>", 
       8->"\<\"Statistics\"\>", 9->"\<\"New in 6.0: Core Language\"\>", 
       10->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       11->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       12->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Nearest", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nearest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nearest"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["elem", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["elem", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the list of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to which ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is nearest. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nearest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nearest"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["elem", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["elem", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " corresponding to the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to which ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is nearest. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nearest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nearest"], "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["elem", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["elem", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the same result. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nearest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nearest"], "[", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["elem", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["elem", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "->", 
         ButtonBox["Automatic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Automatic"]}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to be successive integers ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nearest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nearest"], "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " nearest ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nearest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nearest"], "[", 
       StyleBox["data", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["NearestFunction",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NearestFunction"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     " which can be applied repeatedly to different ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are vectors or matrices of numbers, ",
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " by default in effect uses the metric ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Norm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Norm"], "[", 
    RowBox[{"#1", "-", "#2"}], "]"}], "&"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3063],

Cell[TextData[{
 "For strings, ",
 Cell[BoxData[
  ButtonBox["Nearest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nearest"]], "InlineFormula"],
 " by default uses the edit distance metric. "
}], "Notes",
 CellID->1818],

Cell["The following option can be given: ", "Notes",
 CellID->18815],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DistanceFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DistanceFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the distance metric to use ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->19984],

Cell["\<\
When several elements are returned, the nearest ones are given first.\
\>", "Notes",
 CellID->17974],

Cell[TextData[{
 "If several elements are at the same distance, they are returned in the \
order they appear in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1741]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88411096],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->409820525],

Cell["Find the element nearest to 20:", "ExampleText",
 CellID->27401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32"}], "}"}], 
   ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24796],

Cell[BoxData[
 RowBox[{"{", "16", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4172]
}, Open  ]],

Cell["Find the 3 elements nearest to 20:", "ExampleText",
 CellID->21109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "8", ",", "16", ",", "32"}], "}"}], 
   ",", "20", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"16", ",", "8", ",", "32"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11670],

Cell[TextData[{
 "Find which element is nearest to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "3"}], "}"}]], "InlineFormula"],
 " in 2D:"
}], "ExampleText",
 CellID->3525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", 
        RowBox[{"-", "1"}]}], "}"}], "->", "a"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], "->", "b"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "->", "c"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], "->", "d"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10184],

Cell[BoxData[
 RowBox[{"{", "c", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21727],

Cell["Find \[OpenCurlyDoubleQuote]nearest\[CloseCurlyDoubleQuote] strings:", \
"ExampleText",
 CellID->13746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "\"\<aaaa\>\"", ",", "\"\<abaa\>\"", ",", "\"\<bbbb\>\"", ",", 
     "\"\<aaaba\>\""}], "}"}], ",", "\"\<aaba\>\"", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"aaaba\"\>", ",", "\<\"aaaa\"\>", ",", "\<\"abaa\"\>"}], 
  "}"}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5352]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"Nearest", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "4", ",", "7", ",", "8"}], "}"}], ",", 
      "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19373],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OwkAQXlhUHqEHTXpQWk9UThw5ARcTHoFKTOBgrMhjYDh41IQX8B18
CSNHwokjR444s91Ku93+AMWs6Cbd7ex83+x0djr9ubYH3ds7e9Dr2Hqjbzvd
XudRr9/3YYrmCCEzOJ41AucrOGPHbLWC0d+XoS+AykSJIoY1YkCX5/M4lmBE
dZ7LlLEtH4tIrCCLFNYySTWDa+AF5HBkU1eC3QvutZGR/Ypg/1x2XQEbXnzC
HiRbv/DFlqa8irDVcqRPl1vsQti+FWHNywhvtZIvI9aZ4c8xPsXakWDt01UF
fClkiPnw1kzgFwX5RHG9av7QFDE2EmRZDYqT+ZqJ2SX6muUsZvxk76ts6pFZ
q9UIbbVai8UCFW9BzjtrxMCOWpYFowQViDoYPDCUV4FV8ScrVCHyzhORLsx7
yKXj5AUU3nzfz7AQmgpokZ0lK03tCXFiaocq+3nIubojajQaYQk7Y3VsMplw
/VASt/F4XGONnLLaWK1WdV1H1ZN0jTqTp9Ppn0Rh3JoCeii10VAEJatL+2J5
FRYVLqJYLPLsMlh2tdvt5XKJqhvG8H9LiHXGtQDZG3gqa5oGG+O3wOkSCw9M
hk3ckZEUDTlL3J+fQWGG9hXyR1XUf5wONU5bVITYN6R9cpAix9KN6xn26etZ
PrXXqu7z78zO/UXANE14eVs/a5vN5nw+R1U1xiYYjPjqlbNemLx+Ez0UFMbx
VSF/klFxdS6CEVuzMuQIniHBRTqOw+crcBynWGGDf5yJ/7vCf/lJ7guehBsb
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->817004583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31719],

Cell["Create a Voronoi diagram:", "ExampleText",
 CellID->23873],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t", " ", 
         RowBox[{"Sin", "[", "t", "]"}]}], ",", 
        RowBox[{"t", " ", 
         RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}], "->", "t"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "5"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6915],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"nf", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2883],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->538541144]
}, Open  ]],

Cell["Use higher resolution:", "ExampleText",
 CellID->11859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"nf", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "50"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2125],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->73716590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22839],

Cell[TextData[{
 "Use an ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 "-norm (\[OpenCurlyDoubleQuote]taxicab distance\[CloseCurlyDoubleQuote]):"
}], "ExampleText",
 CellID->17583],

Cell[BoxData[
 RowBox[{
  RowBox[{"nf", "=", 
   RowBox[{"Nearest", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", " ", 
           RowBox[{"Sin", "[", "t", "]"}]}], ",", 
          RowBox[{"t", " ", 
           RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}], "->", "t"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"DistanceFunction", "->", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Norm", "[", 
         RowBox[{
          RowBox[{"#1", "-", "#2"}], ",", "Infinity"}], "]"}], "&"}], 
       ")"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DensityPlot", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"nf", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotPoints", "->", "50"}], ",", 
   RowBox[{"Epilog", "->", 
    RowBox[{"{", 
     RowBox[{"Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t", " ", 
            RowBox[{"Sin", "[", "t", "]"}]}], ",", 
           RowBox[{"t", " ", 
            RowBox[{"Cos", "[", "t", "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "5"}], "}"}]}], "]"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9159],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[2]=",
 CellID->731882816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5618220],

Cell["Highlight the 200 random points closest to the origin:", "ExampleText",
 CellID->375300864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"data", ",", 
       RowBox[{"Nearest", "[", 
        RowBox[{"data", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "200"}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->760532945],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40177127]
}, Open  ]],

Cell["Use \"taxicab\" metric:", "ExampleText",
 CellID->153742444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data", "=", 
     RowBox[{"RandomReal", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1000", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"data", ",", 
       RowBox[{"Nearest", "[", 
        RowBox[{"data", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "200", ",", 
         RowBox[{"DistanceFunction", "->", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Norm", "[", 
             RowBox[{
              RowBox[{"#1", "-", "#2"}], ",", "Infinity"}], "]"}], "&"}], 
           ")"}]}]}], "]"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Red"}], "}"}]}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->618782659],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->646909918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23061],

Cell["\<\
Create a nearest function from all the words in a dictionary:\
\>", "ExampleText",
 CellID->247949843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"DictionaryLookup", "[", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122449866],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"92518", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{218, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295200793]
}, Open  ]],

Cell["Look up words closest to a given word:", "ExampleText",
 CellID->61215524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", "\"\<pickel\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29255790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"nickel\"\>", ",", "\<\"picked\"\>", ",", "\<\"picker\"\>", 
   ",", "\<\"picket\"\>"}], "}"}]], "Output",
 ImageSize->{220, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->338328870]
}, Open  ]],

Cell["Go further:", "ExampleText",
 CellID->591465096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "[", 
  RowBox[{"\"\<pickel\>\"", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->267433761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"nickel\"\>", ",", "\<\"picked\"\>", ",", "\<\"picker\"\>", 
   ",", "\<\"picket\"\>", ",", "\<\"bicker\"\>", ",", "\<\"dicker\"\>", 
   ",", "\<\"dickey\"\>", ",", "\<\"hickey\"\>", ",", "\<\"kicked\"\>", 
   ",", "\<\"kicker\"\>"}], "}"}]], "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7390452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28166],

Cell["\<\
Find the outputs from running a sequence of elementary cellular automata:\
\>", "ExampleText",
 CellID->29938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"First", "[", 
     RowBox[{"CellularAutomaton", "[", 
      RowBox[{"i", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "3", "}"}], ",", "All"}], "}"}]}], "]"}], "]"}], "->", 
    "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}],
     "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1"}], "}"}],
     "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}],
     "\[Rule]", "2"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1"}], "}"}],
     "\[Rule]", "3"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}],
     "\[Rule]", "4"}]}], "}"}]], "Output",
 ImageSize->{500, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7193]
}, Open  ]],

Cell["\<\
Generate a complete list of outputs from all 256 elementary cellular \
automata:\
\>", "ExampleText",
 CellID->17882],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"First", "[", 
      RowBox[{"CellularAutomaton", "[", 
       RowBox[{"i", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "5", "}"}], ",", "All"}], "}"}]}], "]"}], "]"}], "->", 
     "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "255"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27876],

Cell["\<\
Find which rules give outputs nearest the specified sequences:\
\>", "ExampleText",
 CellID->15760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0",
      ",", "1", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8738],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "250", ",", "242", ",", "186", ",", "179", ",", "178", ",", "122", ",", 
   "114", ",", "58", ",", "50"}], "}"}]], "Output",
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14557]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nearest", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "0",
      ",", "1", ",", "1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3780],

Cell[BoxData[
 RowBox[{"{", "94", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18554]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24521],

Cell["Find successive nearest words in a dictionary:", "ExampleText",
 CellID->23512390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"nf", "=", 
  RowBox[{"Nearest", "[", 
   RowBox[{"DictionaryLookup", "[", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3090030],

Cell[BoxData[
 TagBox[
  RowBox[{"NearestFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"92518", ",", "1"}], "}"}], ",", 
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", ">"],
     Editable->False]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{218, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501681325]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Thread", "[", 
        RowBox[{"#", "->", 
         RowBox[{"nf", "[", 
          RowBox[{"#", ",", "3"}], "]"}]}], "]"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"Last", "/@", "#"}], ")"}]}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"\"\<\>\"", "\[Rule]", "\"\<fish\>\""}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->756259379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"fish\"\>", "\[Rule]", "\<\"fish\"\>"}], ",", 
   RowBox[{"\<\"fish\"\>", "\[Rule]", "\<\"dish\"\>"}], ",", 
   RowBox[{"\<\"fish\"\>", "\[Rule]", "\<\"fishy\"\>"}], ",", 
   RowBox[{"\<\"dish\"\>", "\[Rule]", "\<\"dish\"\>"}], ",", 
   RowBox[{"\<\"dish\"\>", "\[Rule]", "\<\"dash\"\>"}], ",", 
   RowBox[{"\<\"dish\"\>", "\[Rule]", "\<\"dis\"\>"}], ",", 
   RowBox[{"\<\"fishy\"\>", "\[Rule]", "\<\"fishy\"\>"}], ",", 
   RowBox[{"\<\"fishy\"\>", "\[Rule]", "\<\"dishy\"\>"}], ",", 
   RowBox[{"\<\"fishy\"\>", "\[Rule]", "\<\"fish\"\>"}], ",", 
   RowBox[{"\<\"dish\"\>", "\[Rule]", "\<\"dish\"\>"}], ",", 
   RowBox[{"\<\"dish\"\>", "\[Rule]", "\<\"dash\"\>"}], ",", 
   RowBox[{"\<\"dish\"\>", "\[Rule]", "\<\"dis\"\>"}], ",", 
   RowBox[{"\<\"dash\"\>", "\[Rule]", "\<\"dash\"\>"}], ",", 
   RowBox[{"\<\"dash\"\>", "\[Rule]", "\<\"ash\"\>"}], ",", 
   RowBox[{"\<\"dash\"\>", "\[Rule]", "\<\"bash\"\>"}], ",", 
   RowBox[{"\<\"dis\"\>", "\[Rule]", "\<\"dis\"\>"}], ",", 
   RowBox[{"\<\"dis\"\>", "\[Rule]", "\<\"bis\"\>"}], ",", 
   RowBox[{"\<\"dis\"\>", "\[Rule]", "\<\"dais\"\>"}], ",", 
   RowBox[{"\<\"fishy\"\>", "\[Rule]", "\<\"fishy\"\>"}], ",", 
   RowBox[{"\<\"fishy\"\>", "\[Rule]", "\<\"dishy\"\>"}], ",", 
   RowBox[{"\<\"fishy\"\>", "\[Rule]", "\<\"fish\"\>"}], ",", 
   RowBox[{"\<\"dishy\"\>", "\[Rule]", "\<\"dishy\"\>"}], ",", 
   RowBox[{"\<\"dishy\"\>", "\[Rule]", "\<\"dish\"\>"}], ",", 
   RowBox[{"\<\"dishy\"\>", "\[Rule]", "\<\"fishy\"\>"}], ",", 
   RowBox[{"\<\"fish\"\>", "\[Rule]", "\<\"fish\"\>"}], ",", 
   RowBox[{"\<\"fish\"\>", "\[Rule]", "\<\"dish\"\>"}], ",", 
   RowBox[{"\<\"fish\"\>", "\[Rule]", "\<\"fishy\"\>"}]}], "}"}]], "Output",
 ImageSize->{506, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30207414]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->93767151],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlXHuwVdV535599jn3XOACF8FXOnGmnU5im9cfzcvEaBxbtCGJbaaxNkou
D70EREAQrAqosUBiMKRYk46OFasmk1atTYxpCT4nNJUZbWt9IAhyjYBi8L6F
K57+vu+3XmfdfR6XmGTaMtc9+7HW91rfe63jjK6l3XMv6Vo6b3bXyX+0pGtR
97zZl538h5cuwav0mCQ5ppIkyfPHJ7iv4k7/k3/t+I+3/xfuLpdrce+TT+56
6CH84Waqvjm4axff9GzdqmOSy/T9k7fd9vfTp69Okm9/8IOFvzv99KSIm7WT
Jv3Deec9e++9E3XMa88++4Pu7m+efDL+dEx2y0c/iim4feLmm0eGh5MlCnGx
jsY0jLvvy19+4Uc/yuRNNnzw4H/dffd3P/95TAD6ZJx9++CiRRvf8x7AAHWJ
ji2CQuC64fjjt954o8JLFsk1fWjVKgCQccpninGABhRJRZ/xBc+YxO9FQgcX
IO9ShaPXFMA3r1ght+P1GZ8BV+CU9RkCAxxckwn6TMKFx4UKRa8p8AC63HZY
KIa3zD6DMaFWJZhCyhCI3F6iUC6xuCBIgT1JnyFnCF+ei/qMKZgot5Oi5wUB
FJAHkatIiXvw6ZHBZ/CXVHApPHHT5ak8pPv/4/57zj/Vvk/Sw33bVP/tvP69
eyF2D32BpRE0yW1Jn3t3zOnfs2ygZ0VyolzS3hdmHTm013/31MwPoDy2Zo2R
Okf1vTj/yOEt1eq25ES58Pk1/x0gACiG4mG3BgXyhybGULAwEHQrUKgREApE
I7dfCaAAMMC3DsWPD6FAaaDIeVCw4tsKcFFtudBWG99VC62+fDoVinq8bXKb
5coLNgPLj+XldTeGWsClDUAJzv7TL3KT8q1cS2NYZb9qMT4FWPRcGBSGL0FZ
iPgUOvJxe1ua38CWItxZiNvCL4yiqmDWLsbs7Az8iZWHVgyuoZjyNhdzKcZM
3lXOxfBtLIE0lwb4RTg2b+sLo5Uu5qx0FnBmV3y0JAqWoABn0XpSoPU+8FLr
141nSPP4DjgpRc/jIixpoFPeXy+y/geeFmYvNNZgEVpTQ7PQPkFetjmo+Aer
gFQIlJFE41IJ3h4rxjhJeCcpmZyLr5iFhYZQGccYbxlPgvEZ7tefNB7kYSRw
mVi6rIlXWRqO2tl9uPeukcH7khPlgueLc0YNvnLdQM9ycdonqeeuHhk0PkQp
S65S90LrA6u4QlPh+yUWqmzLeAv/8MCCBf+ydCk+0Fg4j9cSgiJCI6MjVyKz
7x++9lp4UrzZun49JnPWlQrXWQSdpIGbBd/unjGD0yAml0FIlIX3xNomBaiR
6q/xsd0euqGJ1DCaqQ8tOVKQ/2xZuRKPmklkAMEMBM4ZqknYRS4mRgPJxQr9
L61MMBTrRkkZ2hVDmdjwCmBwNbLUb5J3MfXBVPVIkrMBCZCC5bkeQymUJlen
Yul/5LrrMB5wH1u7FopIz4bBgCMW4DIlSE1ykTkK9QpLN1cY3CP7oZCYS5Xx
jLcAC/lA8hxnrNhnPuOt38JA0dvZAXSOIv/e3yk9JcIF9ZAblALjaLk+0+iw
dIM5uZ3lIZcYvSlmiBWLr7pQpnwAALoJDTU009qpNHI7MfLyXQp5RQABwOmH
DQTlsoJX0IL7587F2x9fdhnu8ZoEJpMjagOYKZccLCYFEW9K0cknpbqClyQW
gvhnhQ7M0D7ohYHr9MvAXR7QSsnim6FVM9YKaXcAAR9YKDbJA2r4V2fPlRMO
wJdwVFgtDhGmjgcQgw/jrMZhHlWF3lzl2ea4AEbgxc2N7343FKMzirTEpnxk
AArhAAFw4p4rVQIveAD3+AC2sbptgSXR/+BqLInYKQUQQNRQWAzCy3zsM9XW
gIflCMCozhcxAepEQykF3IbWpytSpi8DpnsuuODha665vlIRWvIle6G+BTag
Er/AmgLKCA6k5igGPs6tI5NCrr/5Bs37yZVXYtK6zs7H160z2HxOSWwXBNic
10aev3Vo/x3DB/4xqcgl7X/5zp+uO+f1576DoXguPX/f4me+95UXfrDs6Tsv
2v/UBnwr67ih/beODG1XlbJ+lH4fQtp01lk3nXLK5MhuqaFfsnqLcUJF0USf
awdeXjV8YGPyLrmk/S8tefPg5qqL24d+8a/DB76viJWq3t23P3z1aU/89RdA
29avf+bHCz8wnh/33cbAZWybxhJj916K2If2rTn0xiYJoe/SOKrPj3rs/bsX
D+79KyFsqlzKiLMjA/9JU/VVGv3QX1j+jNVlLWFAyEVslk9TNUvQ52eqml4w
NZkdQAdLYEwN5WigZ4ROXZI1mBPA9rnfUcEu4vnpu9fCoQDw3ACur6tiuJ01
tUwT+PL82Ffnise7SKGfb7Xa1CalCPqxubVNfSyNq5aipYGrU0NDXJl4GiRX
rYyhEqpP3dhrnLQBxfWlll+1JGX3JkzwG9RVTThpsWLKcnmgXvlaN9arOjwU
Pd3Nq7Mm9Dequ4JVzdeaZnZRh/5grcdS4zXW+JrqrQZayVr1ndPfC78JxxZa
NXOsPOpTUzlZOSTJ2OrDJpJvUPmVrI/r63kcbh7Rx2e3pJpZXB7VWRPY45rQ
FteL6tO8N2cLD55xdhCNfP4ZRyMLZZR9VYNqtJnHLDvsDCdGHrMCCuLO4hh9
fqDZhQheV5B5+P5B+kti4Xdmmj6/udC+NR2DwtHE9tTFdvvd1SdBhlhCWspk
EE+DP1+F3OW3XN7y+gNh3nLr8IFveejD+75m8pNitPYKlzgyZoAI8SND9w+/
tiEh7KH93zgycqBqM64gsyKn3/7Qh+48+2y5nRzJh7CZWUMDkD4AL7iS+lVa
LEkGXGzsY5LEVmLw/cdj9dnnr8T4tWOPRY3pMfo+LjHOsXERHwQN63CgB+ny
aVykF1OsxE2nmTL8alubyUgmR+OJZbmNZZgl6yRQBFNqdXFNRwcAaFYs77mO
rMBY3sptZ+SNySGG337mmSKnOIOfGUDxvas4503tKj+1aRNeme+e1pAWV7+Y
Ud63Ki2Zyy9MF4Fdf5/LEpbWwUEWx1G+FigYKagCuuS1w9IFAUjW2hXA8n1Y
1sfQTkxy3JWczPAPBIOajkhWITRfsU6MtLSQKztIgfW06VdgPos201HQLkhQ
xxG378oXIlkW7bqaXlGb5ZHNOBMnCJWdDrllZear+DSSambtFlAhD6CTFSpI
oZZhIdgxYk2eMH5eGdHJfomvVwqRrNusNoMPAEp0p03WGeMF6sUBVA/FdcKM
zNPo+/JgluduXMR9GtHKWVdFMmiPVqIQQVkRzPLrUYl0P42ghLO8NCqR3RUi
PlXXkqsjm26LbKMQQfGzxELacinzs0McPqPgDoz3UYUIimpWsjKijPm390aF
CEo4y3vZzFqt8SZpBCWc5asTzvI1JHH5OKfakKjJjcpN/HMhghLO8j4ptRSa
OiONoISzYr/v/Y7LKoyM2R1erW99jIor/tjyw1kR92VmZVX952v3q4MZXsrs
RSEq4YEzyK/KmTvs6cjQdtNVaZNL9u8b/uTn/7YOt68/951Hr/l0UtBuxeC+
7z189Wm9u29HWGZP5Q7TU7k8gDX06jf6e1ZICnAcc4yeFUOv3lE7CvA2Hq/5
DW4A69f5VbLU+tVtseHc0fXsWOrM9GhgN6n/sqOBmVeTjar/GsmvbqU0uhar
Cye3Dhr1jIEHd9zqZy+znlXBblT+G9UcWtEUMRKaS0+jELhLJDbLFmDi9KZE
et2uAYZwR0n3vUzM5OaL2qOd1+b4rGqiwv49wHC/TPfaitwPoj9J62irehPZ
PwF+Nry4T6f7jNLrhYuAYwFdWT176++5xXnOInvTcB9wEdyr1F3SIrwA/Aac
DfxCyXiB+5G0e0h4uPeCM6T64i4PvBBmINRgBveZdb9ezsiAIKbi3I1i3bZz
82bwgJCAR41ORXY/GIM5EqDYqd7+wx+CW/u+iPdAxCSHpwK6rVwwjFsb7HXj
8cHFi0EAZO32vBg7TO+5YlcOND24ZMnN73+/+EVSBKGAQHzAQO6zXWTfI3Ty
Pc/gbFm5cu3EiZAjuGkPdAG3DLLmrA45WtfZ+U+zZrUHNEMUoJm9lDl2Lckj
JnMkBmDY1487buv69ZphZS6qmD2t8ZT4PfcAAfWIM8E81wCEMyecbdeM2z0g
i51vDAATlBdzJGJyUZA3zCEzxI3djzxClXfnlYrcg6HusDLvslQ4XatYaWAY
NwcZ4XwHjCenXMRjYkO8ZZenUbkwyNV53gYwg7n6zEB6+IPASScGsG7EFEZp
BHbce+wu6+diEnubG1XV+Ar6AAZMt1srBqGUvmJmx6AYSrbd2h6GYTA+0Vp9
lcFdKMenS7mYzfq6omh55vkyzCZs54kwX/GzW2QshxJ39LrjamXr90yuEp4/
q7osxOez/O6rnpKVtNtxah/lA5QO9mzNCoAgvK8EnOCl5STIr1wOa3Zb4p4G
82jfr6kEHg40h1pH94ar0pGcF4zkeowe6faAwZjsL5YtNaaC4woyMog2li11
Zl+CtomRDThWOpI/s++5R54rxQ67duK1Fi3CjTt5gjFCT9lKmBv5IDS1ekgN
ANyOhjoBRjBYqTH17eG+bea83RQ9Vzcy+LSx1vdZ7g12p4X0xwA4uVai9nyl
dEQgcvEe7nQj+MZbVoVFAIQjosQmB5bE+Nke4X2fofMJQ+c0pfPI8B5Dp66C
qauPHNrc+8IsOSAyRU+J9O9Z1rtDS8/fD3w1peB2TmnbUJVpVlI8a2r6Dlol
p66FwF6Tidf08W7VwSWj3ylKzaGDt/W9OE8ImUZqdl860HO9fJoQ0nx4S9+L
8yUpmKKZgT5rEvF7gb7JOZHQGzKKnBXEgsALS2VmTgy9l5S8sWlo3xoBP01x
6PPftk4J+2tH3nypb3vXG89/KTlBLmn/rmVGJtTDMEpoSW2iUZhz9O9Zhbky
vVNh9G6fSZVLpr6DlI4M3geJyydmW/p8vfN3xmYZPf9Y44KTKjcRTD3pe7yd
UY/3V0htmdQ6u4JKiS19TukEwfQtPHxj/Pc7Taek+lmTmqkJFxmeX/rJTBg6
nVnypzKqTEsH/bjiLQk3cqlPtdBTjGqQkqs4mnGTVwM135NsQaf2/my+rMEX
rQYxYW6RJ8XaNnqHLqjb/P6joTRrefUKkbTqVZKY9fp/d6uL04tLg+zZ8LqW
9OfWO9Xhl1IDPLKcszdsa7bRde8Y1jWLBNegwsXMvVvP1xClF+RfSE5XCwVy
kX4X3usZIv0Ow0OQcjsD4s0kLKhEijkamTa2mCJmbr/3XDoYjcHSe0UIgY0Y
GdpeRSmQpZ5e07WBnzf06K5IyoLR0wvdq+EH/IWyb6xrgT2UW9ayYD0bdAS8
JbkuMSMsO9ASrWrkDNcAfijnxpS3ZMniiX7x7BXca5WeOj0RqAAWBH92I80K
1Omg1LFETLrlw8dh/bQs1RWpWSGAruGUqb+LmJGHS/P6GoGdtGb97RGEeA1i
b1b/jEEL/qPk/AHEyVPA59r8jcV07n5+s75XqP95vjPeB+9oSTKVaniSp4lE
2uvpnNe8fC8T5RpBv/uz+uxPZMU5RvMTFeUmcrE78nFvrTWLbpad1OhoS5Yf
y8L/0miG9QSQhcTQLJJFo/MZ8XmbX00uFutYOdeuPIfxOeDP6HP8mwzPYQy/
/dfCVXjyw9uC54I66ev/c6w1m12yUsRFvTMgzTS1GTc7L9acQl3y4d67+nYu
bCW7L1qtMjsx50QWGFNfN1seePkqQT1N8Q+/umHolY0xldUjP8VEX2sO9Cwf
fOWmVqikJvidyenWNsweXLklKt8afqB/95KgutyzbPjVuzyVp7ZEhd+Pmh6t
dDMqTguwaN0dVoYvXWXinKyIRHU9+BHsGBL6YM8VUTV44VtDz9VCl3Mx5QZQ
RJO0lZWcqUvseltV7cvDGqdGOk1O/b6qrlfJWWrVNnjPDKCGO3DcCZwa6db0
SPcUatn1ujjP9LU+rZD1Guz10YP4XVeeN/EdzLOjZ5758FBTIyVCP0O/+jMT
diUI1XcEz4n0gFDjPVK/63hGAN3LlJbnfwdGKE5qBov3ju73Aabzl0VrwhU9
3crU9P9ov36HeVI0iz43/uVp/PtNT9WnAizeU1M3QZhZ2Q7Lm/mtyIyI9omW
NxPXyxGvxPKpyL7a7PqYX/BOCGZJ5+ZzAVaJmO47tNufgfL7/bSY0yLa3B4F
sLIv3m61znSIzrV4an6BzA4ig3N7pGchpugXNUU2/3EFcp46AQ4MgsHIgTHM
1uw7wx3m8ZfS7hx6hknsvXMDQ2GKzhLjJy0d/F0O18X89gGvAEzruiKKH7c3
8kU7hthgPByDe0zBRHxyv4I2Gv7JAJvXcNepZEaPPz3Rl/FXH/yT2Z2RTn5C
oX0i0pEbIk08NRjlNfGGSJM46tTIgtdHmvBxHfVxy5XRpxujVQxH+VX8ppE4
v37MzoE8Rec2RJL6WDDKS+pbkQT0SAyvAS8bIwl8JBjlverGaBZHfSSSwN9E
EviwjvodUjv0nOkcT9TO8ZsHn/r+F/7g4M4t0mjD81tv2k6yHsNI3z78mhnP
X5739Tz+3c9+ALOSCRw/vMOM/13F8tucNfKo6TyfwGxgz+V9O+bJp7X6HQkN
XvlsAYPf5q8cQyg+jzshyuMMFPeLSuZ5/heV/1+g2HxzbB3KGFeYtWbJ6N86
5+N+B3oRDWgaW+ehJVqPtqofO5U51XtLFB51lT1mCkdV0a3Ql1rUY+xz5dFk
K+fRHZ2WJDWqUqzf4cmVSDB+QktYLY3jqvldkxhLLU9xJfi/ycf8slB2dkvZ
eEJUu9o4MM/82n2K+bV7dw6U6ts/69+1MIgm8tP3NR7KQM8VAz1BNOnbteDt
t97wUCQ8/Wb/Tz7JMf8DmDesnw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{265, 217},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->86254467]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23085],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindClusters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindClusters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NearestFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NearestFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5778]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21885],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256],

Cell[TextData[ButtonBox["Using Nearest",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingNearest"]], "Tutorials",
 CellID->510394019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Nearest",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Nearest"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->224380915],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->102288929],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->102436897],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->283329812],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->321979088],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->20615836],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->13135260],

Cell[TextData[ButtonBox["Processing Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProcessingTextualData"]], "MoreAbout",
 CellID->36188141],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->372197621],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->402609919],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->445497467],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->51743425],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->302098768]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nearest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 52.2161772}", "context" -> "System`", 
    "keywords" -> {
     "geometric search", "nearest neighbors", "NN", 
      "spatial data structures"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Nearest[{elem_1, elem_2, ...}, x] gives the list of elem_i to which x is \
nearest. Nearest[{elem_1 -> v_1, elem_2 -> v_2, ...}, x] gives the v_i \
corresponding to the elem_i to which x is nearest. Nearest[{elem_1, elem_2, \
...} -> {v_1, v_2, ...}, x] gives the same result. Nearest[{elem_1, elem_2, \
...} -> Automatic, x] takes the v_i to be successive integers i. \
Nearest[data, x, n] gives the n nearest elem_i to x. Nearest[data] generates \
a NearestFunction[...] which can be applied repeatedly to different x. ", 
    "synonyms" -> {}, "title" -> "Nearest", "type" -> "Symbol", "uri" -> 
    "ref/Nearest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14203, 425, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->88411096]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 84471, 2168}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4263, 89, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4886, 116, 1572, 37, 70, "ObjectNameGrid"],
Cell[6461, 155, 5332, 175, 70, "Usage",
 CellID->15416]
}, Open  ]],
Cell[CellGroupData[{
Cell[11830, 335, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12308, 352, 557, 21, 70, "Notes",
 CellID->3063],
Cell[12868, 375, 225, 8, 70, "Notes",
 CellID->1818],
Cell[13096, 385, 68, 1, 70, "Notes",
 CellID->18815],
Cell[13167, 388, 675, 18, 70, "3ColumnTableMod",
 CellID->19984],
Cell[13845, 408, 110, 3, 70, "Notes",
 CellID->17974],
Cell[13958, 413, 208, 7, 70, "Notes",
 CellID->1741]
}, Closed]],
Cell[CellGroupData[{
Cell[14203, 425, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->88411096],
Cell[CellGroupData[{
Cell[14587, 439, 148, 5, 70, "ExampleSection",
 CellID->409820525],
Cell[14738, 446, 70, 1, 70, "ExampleText",
 CellID->27401],
Cell[CellGroupData[{
Cell[14833, 451, 218, 7, 28, "Input",
 CellID->24796],
Cell[15054, 460, 176, 6, 36, "Output",
 CellID->4172]
}, Open  ]],
Cell[15245, 469, 73, 1, 70, "ExampleText",
 CellID->21109],
Cell[CellGroupData[{
Cell[15343, 474, 228, 7, 28, "Input",
 CellID->20731],
Cell[15574, 483, 210, 7, 36, "Output",
 CellID->8987]
}, Open  ]],
Cell[15799, 493, 121, 3, 70, "ExampleDelimiter",
 CellID->11670],
Cell[15923, 498, 183, 7, 70, "ExampleText",
 CellID->3525],
Cell[CellGroupData[{
Cell[16131, 509, 664, 24, 70, "Input",
 CellID->10184],
Cell[16798, 535, 176, 6, 36, "Output",
 CellID->15802]
}, Open  ]],
Cell[16989, 544, 121, 3, 70, "ExampleDelimiter",
 CellID->21727],
Cell[17113, 549, 109, 2, 70, "ExampleText",
 CellID->13746],
Cell[CellGroupData[{
Cell[17247, 555, 271, 9, 70, "Input",
 CellID->19688],
Cell[17521, 566, 246, 8, 36, "Output",
 CellID->5352]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17816, 580, 223, 7, 70, "ExampleSection",
 CellID->12018],
Cell[CellGroupData[{
Cell[18064, 591, 366, 12, 70, "Input",
 CellID->19373],
Cell[18433, 605, 1058, 22, 70, "Output",
 Evaluatable->False,
 CellID->817004583]
}, Open  ]],
Cell[19506, 630, 121, 3, 70, "ExampleDelimiter",
 CellID->31719],
Cell[19630, 635, 64, 1, 70, "ExampleText",
 CellID->23873],
Cell[CellGroupData[{
Cell[19719, 640, 447, 15, 70, "Input",
 CellID->6915],
Cell[20169, 657, 442, 16, 36, "Output",
 CellID->3068]
}, Open  ]],
Cell[CellGroupData[{
Cell[20648, 678, 412, 14, 70, "Input",
 CellID->2883],
Cell[21063, 694, 6930, 118, 70, "Output",
 Evaluatable->False,
 CellID->538541144]
}, Open  ]],
Cell[28008, 815, 61, 1, 70, "ExampleText",
 CellID->11859],
Cell[CellGroupData[{
Cell[28094, 820, 457, 15, 70, "Input",
 CellID->2125],
Cell[28554, 837, 4002, 70, 70, "Output",
 Evaluatable->False,
 CellID->73716590]
}, Open  ]],
Cell[32571, 910, 121, 3, 70, "ExampleDelimiter",
 CellID->22839],
Cell[32695, 915, 212, 6, 70, "ExampleText",
 CellID->17583],
Cell[32910, 923, 721, 24, 70, "Input",
 CellID->13518],
Cell[CellGroupData[{
Cell[33656, 951, 921, 30, 70, "Input",
 CellID->9159],
Cell[34580, 983, 5181, 89, 70, "Output",
 Evaluatable->False,
 CellID->731882816]
}, Open  ]],
Cell[39776, 1075, 123, 3, 70, "ExampleDelimiter",
 CellID->5618220],
Cell[39902, 1080, 97, 1, 70, "ExampleText",
 CellID->375300864],
Cell[CellGroupData[{
Cell[40024, 1085, 746, 24, 70, "Input",
 CellID->760532945],
Cell[40773, 1111, 9524, 160, 70, "Output",
 Evaluatable->False,
 CellID->40177127]
}, Open  ]],
Cell[50312, 1274, 66, 1, 70, "ExampleText",
 CellID->153742444],
Cell[CellGroupData[{
Cell[50403, 1279, 991, 31, 70, "Input",
 CellID->618782659],
Cell[51397, 1312, 9525, 160, 70, "Output",
 Evaluatable->False,
 CellID->646909918]
}, Open  ]],
Cell[60937, 1475, 121, 3, 70, "ExampleDelimiter",
 CellID->23061],
Cell[61061, 1480, 112, 3, 70, "ExampleText",
 CellID->247949843],
Cell[CellGroupData[{
Cell[61198, 1487, 166, 5, 70, "Input",
 CellID->122449866],
Cell[61367, 1494, 451, 16, 36, "Output",
 CellID->295200793]
}, Open  ]],
Cell[61833, 1513, 80, 1, 70, "ExampleText",
 CellID->61215524],
Cell[CellGroupData[{
Cell[61938, 1518, 110, 3, 70, "Input",
 CellID->29255790],
Cell[62051, 1523, 280, 8, 36, "Output",
 CellID->338328870]
}, Open  ]],
Cell[62346, 1534, 54, 1, 70, "ExampleText",
 CellID->591465096],
Cell[CellGroupData[{
Cell[62425, 1539, 135, 4, 70, "Input",
 CellID->267433761],
Cell[62563, 1545, 424, 10, 36, "Output",
 CellID->7390452]
}, Open  ]],
Cell[63002, 1558, 121, 3, 70, "ExampleDelimiter",
 CellID->28166],
Cell[63126, 1563, 120, 3, 70, "ExampleText",
 CellID->29938],
Cell[CellGroupData[{
Cell[63271, 1570, 503, 17, 70, "Input",
 CellID->26226],
Cell[63777, 1589, 939, 32, 54, "Output",
 CellID->7193]
}, Open  ]],
Cell[64731, 1624, 127, 4, 70, "ExampleText",
 CellID->17882],
Cell[64861, 1630, 537, 18, 70, "Input",
 CellID->27876],
Cell[65401, 1650, 109, 3, 70, "ExampleText",
 CellID->15760],
Cell[CellGroupData[{
Cell[65535, 1657, 271, 8, 70, "Input",
 CellID->8738],
Cell[65809, 1667, 293, 9, 36, "Output",
 CellID->14557]
}, Open  ]],
Cell[CellGroupData[{
Cell[66139, 1681, 271, 8, 70, "Input",
 CellID->3780],
Cell[66413, 1691, 177, 6, 36, "Output",
 CellID->18554]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66639, 1703, 224, 7, 70, "ExampleSection",
 CellID->24521],
Cell[66866, 1712, 88, 1, 70, "ExampleText",
 CellID->23512390],
Cell[CellGroupData[{
Cell[66979, 1717, 164, 5, 70, "Input",
 CellID->3090030],
Cell[67146, 1724, 451, 16, 36, "Output",
 CellID->501681325]
}, Open  ]],
Cell[CellGroupData[{
Cell[67634, 1745, 507, 17, 70, "Input",
 CellID->756259379],
Cell[68144, 1764, 1866, 34, 105, "Output",
 CellID->30207414]
}, Open  ]],
Cell[CellGroupData[{
Cell[70047, 1803, 173, 5, 70, "Input",
 CellID->93767151],
Cell[70223, 1810, 7194, 122, 70, "Output",
 Evaluatable->False,
 CellID->86254467]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77478, 1939, 311, 9, 70, "SeeAlsoSection",
 CellID->23085],
Cell[77792, 1950, 1446, 53, 70, "SeeAlso",
 CellID->5778]
}, Open  ]],
Cell[CellGroupData[{
Cell[79275, 2008, 314, 9, 70, "TutorialsSection",
 CellID->21885],
Cell[79592, 2019, 170, 3, 70, "Tutorials",
 CellID->22256],
Cell[79765, 2024, 140, 3, 70, "Tutorials",
 CellID->510394019]
}, Open  ]],
Cell[CellGroupData[{
Cell[79942, 2032, 305, 8, 70, "RelatedLinksSection"],
Cell[80250, 2042, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[80646, 2059, 319, 9, 70, "MoreAboutSection",
 CellID->224380915],
Cell[80968, 2070, 155, 3, 70, "MoreAbout",
 CellID->102288929],
Cell[81126, 2075, 155, 3, 70, "MoreAbout",
 CellID->102436897],
Cell[81284, 2080, 155, 3, 70, "MoreAbout",
 CellID->283329812],
Cell[81442, 2085, 157, 3, 70, "MoreAbout",
 CellID->321979088],
Cell[81602, 2090, 189, 4, 70, "MoreAbout",
 CellID->20615836],
Cell[81794, 2096, 138, 3, 70, "MoreAbout",
 CellID->13135260],
Cell[81935, 2101, 155, 3, 70, "MoreAbout",
 CellID->36188141],
Cell[82093, 2106, 132, 3, 70, "MoreAbout",
 CellID->372197621],
Cell[82228, 2111, 156, 3, 70, "MoreAbout",
 CellID->402609919],
Cell[82387, 2116, 179, 3, 70, "MoreAbout",
 CellID->445497467],
Cell[82569, 2121, 174, 3, 70, "MoreAbout",
 CellID->51743425],
Cell[82746, 2126, 151, 3, 70, "MoreAbout",
 CellID->302098768]
}, Open  ]],
Cell[82912, 2132, 27, 0, 70, "History"],
Cell[82942, 2134, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

