(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57101,       2146]
NotebookOptionsPosition[     45517,       1732]
NotebookOutlinePosition[     46826,       1770]
CellTagsIndexPosition[     46740,       1765]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NestList" :> Documentation`HelpLookup["paclet:ref/NestList"], 
          "NestWhile" :> Documentation`HelpLookup["paclet:ref/NestWhile"], 
          "Fold" :> Documentation`HelpLookup["paclet:ref/Fold"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"], "FixedPoint" :> 
          Documentation`HelpLookup["paclet:ref/FixedPoint"], "Do" :> 
          Documentation`HelpLookup["paclet:ref/Do"], "Composition" :> 
          Documentation`HelpLookup["paclet:ref/Composition"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NestList\"\>", 
       2->"\<\"NestWhile\"\>", 3->"\<\"Fold\"\>", 4->"\<\"Function\"\>", 
       5->"\<\"FixedPoint\"\>", 6->"\<\"Do\"\>", 
       7->"\<\"Composition\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Functional Iteration\"\>", 
       2->"\<\"Functional Programming\"\>", 3->"\<\"Language Overview\"\>", 
       4->"\<\"Looping Constructs\"\>", 
       5->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nest", "ObjectName",
 CellID->32523],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nest",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nest"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an expression with ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " applied ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18222]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit from ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " before it is finished. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25361,
  ButtonNote->"25361"]
}], "Notes",
 CellID->647]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123771103],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->82456010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9526],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123107200]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->262150594],

Cell["The function to nest can be a pure function:", "ExampleText",
 CellID->1655192358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}], "^", "2"}], "&"}], ",", "1", ",", "3"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24906],

Cell[BoxData["676"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94263418]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->243097020],

Cell["Nesting a function can build a formula:", "ExampleText",
 CellID->1403736563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}], "^", "2"}], "&"}], ",", "x", ",", "5"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1727899158],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "+", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}], "2"]}], ")"}], "2"]}], ")"}], 
        "2"]}], ")"}], "2"]}], ")"}], "2"]], "Output",
 ImageSize->{207, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5023627]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->401963256],

Cell["Nesting can return a single number:", "ExampleText",
 CellID->1794672579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"Sqrt", ",", "100.0", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1708060685],

Cell[BoxData["1.333521432163324`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103924656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->845117407],

Cell["The nested function can operate on a list:", "ExampleText",
 CellID->1171950486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", "=", "0.1"}], "}"}], ",", 
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{"xy", ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "\[Epsilon]"}], ",", "0"}], "}"}], "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"2", "\[Epsilon]"}]}], ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"1", "-", 
              RowBox[{"2", "\[Epsilon]"}]}]}], "}"}]}], "}"}], ".", 
         "xy"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "1.0"}], "}"}], ",", "5"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1848319124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.`", ",", "0.32768000000000014`"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90414765]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4442],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit a ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "^", "2"}], "&"}], ",", "2", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "16", ",", "256", ",", "65536", ",", "4294967296", ",", 
   "18446744073709551616"}], "}"}]], "Output",
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242083806]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", 
        RowBox[{"10", "^", "6"}]}], ",", 
       RowBox[{"Throw", "[", "#", "]"}], ",", 
       RowBox[{"#", "^", "2"}]}], "]"}], "&"}], ",", "2", ",", "6"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6817],

Cell[BoxData["4294967296"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->678835929]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->153670297],

Cell["\<\
To nest a function of more than one argument, the arguments can be put into a \
list:\
\>", "ExampleText",
 CellID->2112928093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "+", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "2"], ",", 
      SqrtBox[
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "1", "]"}], "]"}], " ", 
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}]]}], "}"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "1.0"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701746386],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7283955155234534`", ",", "0.7283955155234534`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->738674630]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->100364462],

Cell["Continued fraction:", "ExampleText",
 CellID->1402887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "#"}], ")"}]}], "&"}], ",", "x", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->154089972],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", 
       FractionBox["1", 
        RowBox[{"1", "+", 
         FractionBox["1", 
          RowBox[{"1", "+", "x"}]]}]]}]]}]]}]]], "Output",
 ImageSize->{86, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38212515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10792491],

Cell["Power tower:", "ExampleText",
 CellID->29388853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "#"}], "&"}], ",", "x", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24140],

Cell[BoxData[
 SuperscriptBox["x", 
  SuperscriptBox["x", 
   SuperscriptBox["x", 
    SuperscriptBox["x", 
     SuperscriptBox["x", 
      SuperscriptBox["x", "x"]]]]]]], "Output",
 ImageSize->{44, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121557025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76877850],

Cell["Growth of annually compounded capital in 10 years:", "ExampleText",
 CellID->546491048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", 
     RowBox[{"(", 
      RowBox[{"1", "+", "0.05"}], ")"}]}], "&"}], ",", "1000", ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299056208],

Cell[BoxData["1628.8946267774422`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43273314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87244274],

Cell[TextData[{
 "Newton iterations for ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->10607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1.0", 
   ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3278],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->732819953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375037617],

Cell["Iterated string replacements:", "ExampleText",
 CellID->21100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"StringReplace", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<A\>\"", "->", "\"\<BA\>\""}], ",", 
        RowBox[{"\"\<B\>\"", "->", "\"\<AB\>\""}]}], "}"}]}], "]"}], "&"}], 
   ",", "\"\<A\>\"", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26637],

Cell[BoxData["\<\"BAABABBAABBABAABABBABAABBAABABBA\"\>"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15055466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->391168130],

Cell["Consecutive pairs of Fibonacci numbers:", "ExampleText",
 CellID->302199901],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ".", "#"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1680713036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"55", ",", "34"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168874853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3170460],

Cell[TextData[{
 "Functional composition for higher-order Newton iteration (for ",
 Cell[BoxData[
  SqrtBox["3"]], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->65103308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{"Together", "[", 
     RowBox[{"Nest", "[", 
      RowBox[{
       RowBox[{"Function", "[", 
        RowBox[{"z", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"z", "+", 
            RowBox[{"3", "/", "z"}]}], ")"}], "/", "2"}]}], "]"}], ",", "x", 
       ",", "4"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115406618],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"6561", "+", 
      RowBox[{"262440", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"1326780", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"1945944", " ", 
       SuperscriptBox["x", "6"]}], "+", 
      RowBox[{"1042470", " ", 
       SuperscriptBox["x", "8"]}], "+", 
      RowBox[{"216216", " ", 
       SuperscriptBox["x", "10"]}], "+", 
      RowBox[{"16380", " ", 
       SuperscriptBox["x", "12"]}], "+", 
      RowBox[{"360", " ", 
       SuperscriptBox["x", "14"]}], "+", 
      SuperscriptBox["x", "16"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"16", " ", "x", " ", 
      RowBox[{"(", 
       RowBox[{"3", "+", 
        SuperscriptBox["x", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"9", "+", 
        RowBox[{"18", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        SuperscriptBox["x", "4"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"81", "+", 
        RowBox[{"756", " ", 
         SuperscriptBox["x", "2"]}], "+", 
        RowBox[{"630", " ", 
         SuperscriptBox["x", "4"]}], "+", 
        RowBox[{"84", " ", 
         SuperscriptBox["x", "6"]}], "+", 
        SuperscriptBox["x", "8"]}], ")"}]}], ")"}]}]}], "]"}]], "Output",
 ImageSize->{520, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370279743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{"%", ",", "1`50"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->326869857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`50.", ",", 
   "1.7320508100147275405007363770250368188512518409425625920471284998672`48.\
931338793278755", ",", 
   "1.7320508075688772935274463415058723669428052538103806280558`47.\
7272188103162", ",", 
   "1.7320508075688772935274463415058723669428052538103806280557`46.\
52309882766028"}], "}"}]], "Output",
 ImageSize->{375, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->543381060]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1409091],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " gives the last element of ",
 ButtonBox["NestList",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NestList"],
 ":"
}], "ExampleText",
 CellID->1978538398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1755297811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->749915086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1412531012],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127761922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->273748276],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " is effectively ",
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 " using the same function multiple times:"
}], "ExampleText",
 CellID->31546149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53695177],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168757471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "f", ",", "f"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->912398279],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->124977633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38075630],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 " to symbolically compute ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " operations:"
}], "ExampleText",
 CellID->677217845],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"2", "x"}], "+", "3"}], 
   RowBox[{"x", "+", "4"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55334620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", 
      RowBox[{"k", "+", "1"}], "]"}], "\[Equal]", 
     RowBox[{"f", "[", 
      RowBox[{"y", "[", "k", "]"}], "]"}]}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], ",", "y", ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24538264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "k", "}"}], ",", 
      FractionBox[
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", "1"}], ")"}], "k"], "-", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"-", 
             FractionBox["1", "5"]}], ")"}], "k"]}], ")"}]}], 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], "k"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", 
           FractionBox["1", "5"]}], ")"}], "k"]}]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{272, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->255139919]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"y", "/.", 
   RowBox[{"First", "[", "%", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->97559505],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "k", "}"}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "k"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["1", "5"]}], ")"}], "k"]}], ")"}]}], 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "k"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        FractionBox["1", "5"]}], ")"}], "k"]}]]}], "]"}]], "Output",
 ImageSize->{221, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->147189409]
}, Open  ]],

Cell["Different length compositions or nests give the same result:", \
"ExampleText",
 CellID->6575437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"g", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->102669238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["18", "19"], ",", 
   FractionBox["93", "94"], ",", 
   FractionBox["468", "469"], ",", 
   FractionBox["2343", "2344"]}], "}"}]], "Output",
 ImageSize->{168, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->481814916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{"f", ",", "0", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->978254463],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["3", "4"], ",", 
   FractionBox["18", "19"], ",", 
   FractionBox["93", "94"], ",", 
   FractionBox["468", "469"], ",", 
   FractionBox["2343", "2344"]}], "}"}]], "Output",
 ImageSize->{168, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->258134795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->474711747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " automatically goes on until the result no longer changes:"
}], "ExampleText",
 CellID->10789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", "6"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20065],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325066471]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19127],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136457749]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->374518943],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 " goes on while a condition is true:"
}], "ExampleText",
 CellID->396943745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"NestWhile", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"EvenQ", "[", "#", "]"}], ",", 
       RowBox[{"#", "/", "2"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", "#"}], "+", "1"}], ")"}], "/", "2"}]}], "]"}], 
     "&"}], ",", "29", ",", 
    RowBox[{
     RowBox[{"#", ">", "1"}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->708326668],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333120604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63094744],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " automatically inserts second arguments from a list:"
}], "ExampleText",
 CellID->13503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#", ",", "a"}], "]"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1276],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], ",", "a"}], 
  "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22209795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6675],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "a"}], "]"}], ",", "a"}], 
  "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->793995481]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"Framed", ",", "x", ",", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22760],

Cell[BoxData[
 FrameBox[
  FrameBox[
   FrameBox[
    FrameBox[
     FrameBox[
      FrameBox["x",
       StripOnInput->False],
      StripOnInput->False],
     StripOnInput->False],
    StripOnInput->False],
   StripOnInput->False],
  StripOnInput->False]], "Output",
 ImageSize->{71, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322467642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32581],

Cell["Binary tree:", "ExampleText",
 CellID->13777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8208019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Framed", "[", 
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], "]"}], "]"}], "&"}], ",", "\"\<\>\"", 
   ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4784],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztm9FqgzAUhqOO4iOIeNF3KGywS5Htqg8hZdBejI2uTyK+b3s0p0uRLKRZ
I0Z/ITZHf3tOfj/OldnWp/3HZ3067Or1+7H+3h92P+u3ryNdSiIhomchxGsm
aH6mWT+644UGzZM0TYU8unBDI5KXkqvy3P9saERS6O1O3J1uKmpoxBS2giu9
0f31tIobOsUUtoPrc3966GLJLlYaF7ssT3foXatRcclZK41OVWOnRzXLqWZI
dc6UFpZUm/Q2qxsz/6PcUnHOVRWWqzXp7d0aJz/cgltwa55uDbvuirtoqumi
uq5r0rt0fZ/5Xd7mkv3xRZuKV1x1aumGSe/ydn3md6dtmf6ANtAG2sJ0E7SB
NtA2FX9AG2gDbWG6CdpAG2ibij+gDbSBtjDdBG2gDbRNxR/QBtpAW5hugjbQ
Btqm4g9oA23h05Zlmfwn+YUKhfILFZpoV2Ont3dznPzutC3Tn8fThq8B4Rbc
glthuKW6aM5dtNB0UV3XNeldur7P/P93q+QqKsvVmfSoZu7VKEpLprSypNqk
v7+acHc8ujytXGzYxVbjou8dr8M7qqrf3bj9pU7HO3ajC+Soof8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{310, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208497832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"p", "[", "#", "]"}], "[", "#", "]"}], "&"}], ",", "x", ",", 
   "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4444],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWV1PwyAUvf2YM87E7M3H+Wc0mvgjmsVkezCauf+PUIZ0N6yAtAXWS9LC
pVAOh9OtPbw3x93HZ3Pcb5vNy6H53u23P5vnrwOvqgqA4hUAnh6BlxkvtYdI
b/yQRVla8nMFMi95Xlri1Sm/QfEC1fv2s/WfGofK1y1Lt+JcKQ5Z27sbl4HX
VyiuPa/jeOrxfMefGx8PTKmoPmkLo7PW13/1TCtb5Max/VpbmIuNoRdTYlhT
wHBZfbDojgGGe5dDt9KzMqxYeI98kBHTsZiOpf+K6XeNPnyu7dJEQQwOzSDp
lfSaE4Nar+qtpe/duxyhXYz/vlSxhWBNdU4pYzM/DcpvaB8ykMn8TTBEixG/
K9JCMwA6YtMllipeo1rsg9jiUB9l7Pv7jpf7/PSqCo3co9zVU3Vtf6nf2OOd
e7di4tj19i8JEl098rl75t376F84cV4iPYb6xHPzkYmP/rhgXcWJpHSJUZMP
Tz781Hz1q1Whtn7fkIcfDRkxHYvpHJ+debqBxGAog6T1XFaKGBxX6yLF2E9I
1WtOGVsI1lTnlDI2tydpuj0I8tWHREds/ieWmr9Dtb6ufu4u/7XP7/Kqm3YZ
rnV349xlF0S47GNA8QtB9z2F\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{329, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99064317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Subsuperscript", "[", 
     RowBox[{"#", ",", "#", ",", "#"}], "]"}], "&"}], ",", "x", ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32108],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWzmPFDsQ7t0ZhuFYEPCetNyLFokj4D4EAWzAcgoIOAIIYIVAHEIcD14A
ARtBAAEEbAIBJBAACQF/z8y0u9S2v3JPlXuOlbZ7bJfL5XK5XFWuPj/37O7t
h3PP7t2amzr1dO7x3Xu3/ps6+ehpp6oxlmXZ787/n8ms89t0fuX/v43pvO3z
R/fZ7Nbmf50fjfz1s/Mc75SaTOlb99ly+9jnePfVKOvH8urvRd8leekLO17Z
/rUoNVRjfHVwlHR+EuJoeb0+F6WJCGeo/Z+89BGgxoWjLorgXwjm4s+puvV9
8thSqi2/Pzg8KNfuLYsV4d4VpXGAXw01ba/HYkEPy8XXCk64FFo+vnFkIN66
XEeNV789f73i5+vVtMSjzBd0LS3ebZZ6GdQLIf9aAriM6bdMiN/K28uARl+e
ngM/Qrnj93KJ4X/jSKSAKin1pFl02oyoCVeG3/OPhbhDSZfS5GvHJ0Yn+1Wa
lHDtcCjLsvvsakoobULPSQVvOAofBBynFdnMroQO+raGtoQdtj6Zj1YK7xTU
rineO427Y25EV5uHv2l0UrdUCLdFNSeiglYipNWuzDUhzlYllusmJv2roGY7
y80Sx5W8dImHSpJvOQ2XjX9eVPNOB31Bwek0WR6MHF0sZvFvZHZW5s+wVLv9
UDYIYppdjRL3WaM7sZYrOK3Bu8GknHBEPWlI4odMc54QjrUowK7ZLV34tUqe
WepmTeyEXBNdU4RdG5WQhjcKSZx/hh6DXulnqJQL2BMtgrq+0XHDy8lUUK62
mPqD5YhmLgnn94bEflLbtK4PeNTwuo+30fezK8r1X8HShRgPmNFaFIvNYHyG
MW92sfOz2nvbJRyr0oJJ9p53mzqWT9PoPIxyvKum1IUc5nTtg3TvFuKSaEU7
C9LgobahtTlUueL1ek8nc6bfdtg+AVxWe3dtDbhAXJoJ6q2m2ciumAsXt+Nm
ohC+PbfJONqsh7xQVArjZ3juT0Txtr1xMe7Ex+K6sBiFw3HbUbxW2qWeOWko
bdSCNNOMsp9vy5EVtsLgrqFVdUdpBvA+FpSBeMwEtR/yuFd8ZRLqUSeiT5lb
qQxluOpYgzsFPTf0ihCPpZ92ZajTNhtfl50L2pt96N0WyAunh9I15PrEEU8l
j2h1Ic071Gl0otCpuiQBmrSU1E7i5ifV7FNCuPMq7tgFdYBBF4Qzt/JDs16p
gkbbF/fhNqi5DDWNCO2/YFUkVpZ8RNT2ZCVXzz/0xGTQ/ba8ByNByJPQn+H3
DslZ3HLAGBFhvhjtY3FPCGegvb+gaJB0ZU4r8VuO9udc0FoE0jgIWR6zSvyW
Os0tCtkVuIdno33sPqWe5O9dMaVE1rk1SY/4oJ+UHsOKRY/I1iV5COM7JDcz
hpevZh+xoKXUb22WGnc6nMxlnd2h88EIOq4Nqf9Rli7EiNoz7iuh/0/RL3kO
A9recR8JxztoYr5Xr3iCVs8RH/co5CD0jcrRQ4+IsO911hN783dR/Pojr/YY
uW1jebUL6tHCsRkbGMfEFZFEuerkedSLDdbrjfMf1U3ccDJPdFFugo7Hg7ZG
W6S5KtJ7B+1N3kYl/GBzYI4bX0rr3fRoo0brlPD1cmrikR3UYOuiLfr8m+o7
ROktK1pueM+ZbgXWzeCpd9Ncr/cZAe2chpLe1Y8qM0iW/UBQGNOozhSS5oRQ
ZGG0GUVp2THS+7XqDCOM3bpx6dR8Hz/nSJoLVSfD6KaIdzKoGzDGqOwTSRYd
tabnAUmzCIeT15OWLzmcvBzMK03PvuEzV6WZuMPIlNHlEOugnwtoyxhah5WZ
Up0tTq3SPBNpJvxg80HmjcQ7m3dLyb77K+CMPieDvpGwuRjSrzHk2RL0RQjP
h+rWtwJq6shv1TcyVNvLy3sP7b1u8vFLpF538AsuRrU+XXBKtJ/KVqSmlzfy
CertTfQXqI/dF/NfgfG1iFWnY/yv2vyS7vu4qi/tYl/n2W/3srG/Kirbag==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{178, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203799603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->730248954],

Cell["Gray codes of length 4:", "ExampleText",
 CellID->176421555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"#", ",", 
      RowBox[{
       RowBox[{"Length", "[", "#", "]"}], "+", 
       RowBox[{"Reverse", "[", "#", "]"}]}]}], "]"}], "&"}], ",", 
   RowBox[{"{", "0", "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70881535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "3", ",", "2", ",", "6", ",", "7", ",", "5", ",", "4", 
   ",", "12", ",", "13", ",", "15", ",", "14", ",", "10", ",", "11", ",", "9",
    ",", "8"}], "}"}]], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679460342]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BaseForm", "[", 
  RowBox[{"%", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148113981],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtOwzAMTZsOBg+DBwo8bGgI+BV44iMmLmJcBIz9f2naFSJjJ46TDZCK
NBI7zqntuFF9rmfLh7uX2XJ+M5teLWZvD/Obj+nl66JW6UypbK6UOj1W9byq
Z83P/D3Wv3bazs7r/7pe1EbSnVWlzlb6gtBD+9/C0V9RQG2ufuoLQt/ZX2wY
ZwDkvIlmWP8f1Mp8NWordjIHlrxF7NeWDKNx7Ycj3A/lbce+EP8xv7H9lP9w
f6j/MO9U/nz+F8jo8r+tgl2O1eBLbvYoQot5bOpxR/QM3/kVTHSfTHntywwv
Cm5OeDngPYPKDO8Z0vyEVAr3GbwIYmp0/W9Fbu018p4IG7WyUPc9qKzqjcCT
xR5T9T6PZdUuQ5WdGS8bMbW2BZ6QVamrG75PIxG27z7wvTOhd1goniz2lHe6
7M0JzUPKO5yXjb99dx+IsKBV6UHxyaH7ebHEVCf0SFaNPBQeNi+6EC36fdNX
V19dfXX11fUvq8t0U6arGlijVt+MwYFj3ciHyLo9utYhvo3byaVjHeLbfnd2
2H57hFlpWT0zhXxl+Aye6bDCGcZRhbMzJWF/SOjHBM6YsJ8E4tw1UUFr2I93
fTr2Pd2dGGZ/ROgnBA7Ud/YngTj3aFQSxtB1N2DMqAsXYwI5fvgYTy7jGupf
CobS5ectekpx/JqUPYxjv9IyoqkY0LiYNsHdUZG2t1JeIR7IuCdr3cd4RTBD
Di/ScF3rYbXWzl9ZWM+V/J2HTEMo2yNjRdIwX7HMVBqeKCV3A7GeKv7Jwi9h
X/fA+wqXdUKhnYusr4j59n/vM9tn9l9mFotGq+8OEXaSsPOjOtUS0VOdo6tj
XDReGtc4vZ/KPgFM7J0H\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{361, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//BaseForm=",
 CellID->5754219]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22969],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Composition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Composition"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9740]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10150],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->15225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->247049000],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->573014432],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->262513405],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->374825582],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->261518292],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->530142642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Nest",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Nest"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Nest"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 57.9975752}", "context" -> "System`", 
    "keywords" -> {
     "continued fractions", "functional composition", "iterated functions", 
      "nesting of functions", "dynamic system"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Nest[f, expr, n] gives an expression with f applied n times to expr. ", 
    "synonyms" -> {}, "title" -> "Nest", "type" -> "Symbol", "uri" -> 
    "ref/Nest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5394, 165, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->123771103]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46597, 1758}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2941, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3564, 91, 42, 1, 70, "ObjectName",
 CellID->32523],
Cell[3609, 94, 797, 27, 70, "Usage",
 CellID->18222]
}, Open  ]],
Cell[CellGroupData[{
Cell[4443, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4921, 143, 436, 17, 70, "Notes",
 CellID->647]
}, Closed]],
Cell[CellGroupData[{
Cell[5394, 165, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123771103],
Cell[CellGroupData[{
Cell[5779, 179, 147, 5, 70, "ExampleSection",
 CellID->82456010],
Cell[CellGroupData[{
Cell[5951, 188, 128, 4, 28, "Input",
 CellID->9526],
Cell[6082, 194, 242, 8, 36, "Output",
 CellID->123107200]
}, Open  ]],
Cell[6339, 205, 125, 3, 70, "ExampleDelimiter",
 CellID->262150594],
Cell[6467, 210, 88, 1, 70, "ExampleText",
 CellID->1655192358],
Cell[CellGroupData[{
Cell[6580, 215, 229, 9, 28, "Input",
 CellID->24906],
Cell[6812, 226, 159, 5, 36, "Output",
 CellID->94263418]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7020, 237, 220, 7, 70, "ExampleSection",
 CellID->243097020],
Cell[7243, 246, 83, 1, 70, "ExampleText",
 CellID->1403736563],
Cell[CellGroupData[{
Cell[7351, 251, 234, 9, 70, "Input",
 CellID->1727899158],
Cell[7588, 262, 606, 21, 46, "Output",
 CellID->5023627]
}, Open  ]],
Cell[8209, 286, 125, 3, 70, "ExampleDelimiter",
 CellID->401963256],
Cell[8337, 291, 79, 1, 70, "ExampleText",
 CellID->1794672579],
Cell[CellGroupData[{
Cell[8441, 296, 141, 4, 70, "Input",
 CellID->1708060685],
Cell[8585, 302, 175, 5, 36, "Output",
 CellID->103924656]
}, Open  ]],
Cell[8775, 310, 125, 3, 70, "ExampleDelimiter",
 CellID->845117407],
Cell[8903, 315, 86, 1, 70, "ExampleText",
 CellID->1171950486],
Cell[CellGroupData[{
Cell[9014, 320, 875, 29, 70, "Input",
 CellID->1848319124],
Cell[9892, 351, 223, 7, 36, "Output",
 CellID->90414765]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10164, 364, 238, 7, 70, "ExampleSection",
 CellID->4442],
Cell[10405, 373, 352, 14, 70, "ExampleText",
 CellID->25361],
Cell[CellGroupData[{
Cell[10782, 391, 177, 6, 70, "Input",
 CellID->16983],
Cell[10962, 399, 296, 9, 36, "Output",
 CellID->242083806]
}, Open  ]],
Cell[CellGroupData[{
Cell[11295, 413, 376, 13, 70, "Input",
 CellID->6817],
Cell[11674, 428, 167, 5, 36, "Output",
 CellID->678835929]
}, Open  ]],
Cell[11856, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->153670297],
Cell[11984, 441, 137, 4, 70, "ExampleText",
 CellID->2112928093],
Cell[CellGroupData[{
Cell[12146, 449, 610, 21, 70, "Input",
 CellID->701746386],
Cell[12759, 472, 243, 8, 36, "Output",
 CellID->738674630]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13051, 486, 227, 7, 70, "ExampleSection",
 CellID->100364462],
Cell[13281, 495, 60, 1, 70, "ExampleText",
 CellID->1402887],
Cell[CellGroupData[{
Cell[13366, 500, 233, 9, 70, "Input",
 CellID->154089972],
Cell[13602, 511, 412, 15, 88, "Output",
 CellID->38212515]
}, Open  ]],
Cell[14029, 529, 124, 3, 70, "ExampleDelimiter",
 CellID->10792491],
Cell[14156, 534, 54, 1, 70, "ExampleText",
 CellID->29388853],
Cell[CellGroupData[{
Cell[14235, 539, 173, 6, 70, "Input",
 CellID->24140],
Cell[14411, 547, 311, 11, 51, "Output",
 CellID->121557025]
}, Open  ]],
Cell[14737, 561, 124, 3, 70, "ExampleDelimiter",
 CellID->76877850],
Cell[14864, 566, 93, 1, 70, "ExampleText",
 CellID->546491048],
Cell[CellGroupData[{
Cell[14982, 571, 235, 9, 70, "Input",
 CellID->299056208],
Cell[15220, 582, 175, 5, 36, "Output",
 CellID->43273314]
}, Open  ]],
Cell[15410, 590, 124, 3, 70, "ExampleDelimiter",
 CellID->87244274],
Cell[15537, 595, 159, 7, 70, "ExampleText",
 CellID->10607],
Cell[CellGroupData[{
Cell[15721, 606, 274, 10, 70, "Input",
 CellID->3278],
Cell[15998, 618, 175, 5, 36, "Output",
 CellID->732819953]
}, Open  ]],
Cell[16188, 626, 125, 3, 70, "ExampleDelimiter",
 CellID->375037617],
Cell[16316, 631, 68, 1, 70, "ExampleText",
 CellID->21100],
Cell[CellGroupData[{
Cell[16409, 636, 377, 12, 70, "Input",
 CellID->26637],
Cell[16789, 650, 197, 5, 36, "Output",
 CellID->15055466]
}, Open  ]],
Cell[17001, 658, 125, 3, 70, "ExampleDelimiter",
 CellID->391168130],
Cell[17129, 663, 82, 1, 70, "ExampleText",
 CellID->302199901],
Cell[CellGroupData[{
Cell[17236, 668, 395, 14, 70, "Input",
 CellID->1680713036],
Cell[17634, 684, 205, 7, 36, "Output",
 CellID->168874853]
}, Open  ]],
Cell[17854, 694, 123, 3, 70, "ExampleDelimiter",
 CellID->3170460],
Cell[17980, 699, 176, 6, 70, "ExampleText",
 CellID->65103308],
Cell[CellGroupData[{
Cell[18181, 709, 474, 15, 70, "Input",
 CellID->115406618],
Cell[18658, 726, 1446, 44, 77, "Output",
 CellID->370279743]
}, Open  ]],
Cell[CellGroupData[{
Cell[20141, 775, 136, 4, 70, "Input",
 CellID->326869857],
Cell[20280, 781, 490, 14, 88, "Output",
 CellID->543381060]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20819, 801, 235, 7, 70, "ExampleSection",
 CellID->1409091],
Cell[21057, 810, 285, 11, 70, "ExampleText",
 CellID->1978538398],
Cell[CellGroupData[{
Cell[21367, 825, 138, 4, 70, "Input",
 CellID->1755297811],
Cell[21508, 831, 534, 17, 36, "Output",
 CellID->749915086]
}, Open  ]],
Cell[CellGroupData[{
Cell[22079, 853, 134, 4, 70, "Input",
 CellID->1412531012],
Cell[22216, 859, 272, 9, 36, "Output",
 CellID->127761922]
}, Open  ]],
Cell[22503, 871, 125, 3, 70, "ExampleDelimiter",
 CellID->273748276],
Cell[22631, 876, 354, 12, 70, "ExampleText",
 CellID->31546149],
Cell[CellGroupData[{
Cell[23010, 892, 132, 4, 70, "Input",
 CellID->53695177],
Cell[23145, 898, 242, 8, 36, "Output",
 CellID->168757471]
}, Open  ]],
Cell[CellGroupData[{
Cell[23424, 911, 169, 5, 70, "Input",
 CellID->912398279],
Cell[23596, 918, 242, 8, 36, "Output",
 CellID->124977633]
}, Open  ]],
Cell[23853, 929, 124, 3, 70, "ExampleDelimiter",
 CellID->38075630],
Cell[23980, 934, 335, 13, 70, "ExampleText",
 CellID->677217845],
Cell[24318, 949, 210, 8, 70, "Input",
 CellID->55334620],
Cell[CellGroupData[{
Cell[24553, 961, 378, 13, 70, "Input",
 CellID->24538264],
Cell[24934, 976, 917, 32, 70, "Output",
 CellID->255139919]
}, Open  ]],
Cell[CellGroupData[{
Cell[25888, 1013, 148, 5, 70, "Input",
 CellID->97559505],
Cell[26039, 1020, 770, 28, 70, "Output",
 CellID->147189409]
}, Open  ]],
Cell[26824, 1051, 103, 2, 70, "ExampleText",
 CellID->6575437],
Cell[CellGroupData[{
Cell[26952, 1057, 212, 7, 70, "Input",
 CellID->102669238],
Cell[27167, 1066, 358, 12, 51, "Output",
 CellID->481814916]
}, Open  ]],
Cell[CellGroupData[{
Cell[27562, 1083, 250, 8, 70, "Input",
 CellID->978254463],
Cell[27815, 1093, 358, 12, 51, "Output",
 CellID->258134795]
}, Open  ]],
Cell[28188, 1108, 125, 3, 70, "ExampleDelimiter",
 CellID->474711747],
Cell[28316, 1113, 235, 7, 70, "ExampleText",
 CellID->10789],
Cell[CellGroupData[{
Cell[28576, 1124, 212, 8, 70, "Input",
 CellID->20065],
Cell[28791, 1134, 158, 5, 36, "Output",
 CellID->325066471]
}, Open  ]],
Cell[CellGroupData[{
Cell[28986, 1144, 205, 7, 70, "Input",
 CellID->19127],
Cell[29194, 1153, 158, 5, 36, "Output",
 CellID->136457749]
}, Open  ]],
Cell[29367, 1161, 125, 3, 70, "ExampleDelimiter",
 CellID->374518943],
Cell[29495, 1166, 214, 7, 70, "ExampleText",
 CellID->396943745],
Cell[CellGroupData[{
Cell[29734, 1177, 482, 17, 70, "Input",
 CellID->708326668],
Cell[30219, 1196, 158, 5, 36, "Output",
 CellID->333120604]
}, Open  ]],
Cell[30392, 1204, 124, 3, 70, "ExampleDelimiter",
 CellID->63094744],
Cell[30519, 1209, 217, 7, 70, "ExampleText",
 CellID->13503],
Cell[CellGroupData[{
Cell[30761, 1220, 206, 8, 70, "Input",
 CellID->1276],
Cell[30970, 1230, 323, 12, 36, "Output",
 CellID->22209795]
}, Open  ]],
Cell[CellGroupData[{
Cell[31330, 1247, 187, 6, 70, "Input",
 CellID->6675],
Cell[31520, 1255, 324, 12, 36, "Output",
 CellID->793995481]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31893, 1273, 224, 7, 70, "ExampleSection",
 CellID->24263],
Cell[CellGroupData[{
Cell[32142, 1284, 134, 4, 70, "Input",
 CellID->22760],
Cell[32279, 1290, 398, 17, 89, "Output",
 CellID->322467642]
}, Open  ]],
Cell[32692, 1310, 121, 3, 70, "ExampleDelimiter",
 CellID->32581],
Cell[32816, 1315, 51, 1, 70, "ExampleText",
 CellID->13777],
Cell[CellGroupData[{
Cell[32892, 1320, 202, 8, 70, "Input",
 CellID->32533],
Cell[33097, 1330, 512, 19, 36, "Output",
 CellID->8208019]
}, Open  ]],
Cell[CellGroupData[{
Cell[33646, 1354, 281, 10, 70, "Input",
 CellID->4784],
Cell[33930, 1366, 813, 17, 70, "Output",
 Evaluatable->False,
 CellID->208497832]
}, Open  ]],
Cell[CellGroupData[{
Cell[34780, 1388, 212, 8, 70, "Input",
 CellID->4444],
Cell[34995, 1398, 845, 18, 70, "Output",
 Evaluatable->False,
 CellID->99064317]
}, Open  ]],
Cell[35855, 1419, 121, 3, 70, "ExampleDelimiter",
 CellID->18374],
Cell[CellGroupData[{
Cell[36001, 1426, 230, 8, 70, "Input",
 CellID->32108],
Cell[36234, 1436, 2226, 41, 70, "Output",
 Evaluatable->False,
 CellID->203799603]
}, Open  ]],
Cell[38475, 1480, 125, 3, 70, "ExampleDelimiter",
 CellID->730248954],
Cell[38603, 1485, 66, 1, 70, "ExampleText",
 CellID->176421555],
Cell[CellGroupData[{
Cell[38694, 1490, 338, 11, 70, "Input",
 CellID->70881535],
Cell[39035, 1503, 361, 10, 36, "Output",
 CellID->679460342]
}, Open  ]],
Cell[CellGroupData[{
Cell[39433, 1518, 127, 4, 70, "Input",
 CellID->148113981],
Cell[39563, 1524, 1094, 22, 70, "Output",
 Evaluatable->False,
 CellID->5754219]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40718, 1553, 311, 9, 70, "SeeAlsoSection",
 CellID->22969],
Cell[41032, 1564, 1667, 62, 70, "SeeAlso",
 CellID->9740]
}, Open  ]],
Cell[CellGroupData[{
Cell[42736, 1631, 314, 9, 70, "TutorialsSection",
 CellID->10150],
Cell[43053, 1642, 167, 3, 70, "Tutorials",
 CellID->15225]
}, Open  ]],
Cell[CellGroupData[{
Cell[43257, 1650, 319, 9, 70, "MoreAboutSection",
 CellID->247049000],
Cell[43579, 1661, 151, 3, 70, "MoreAbout",
 CellID->573014432],
Cell[43733, 1666, 155, 3, 70, "MoreAbout",
 CellID->262513405],
Cell[43891, 1671, 145, 3, 70, "MoreAbout",
 CellID->374825582],
Cell[44039, 1676, 147, 3, 70, "MoreAbout",
 CellID->261518292],
Cell[44189, 1681, 155, 3, 70, "MoreAbout",
 CellID->530142642]
}, Open  ]],
Cell[CellGroupData[{
Cell[44381, 1689, 305, 8, 70, "RelatedLinksSection"],
Cell[44689, 1699, 348, 11, 70, "RelatedLinks"],
Cell[45040, 1712, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[45437, 1728, 50, 0, 70, "History"],
Cell[45490, 1730, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

