(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55741,       2110]
NotebookOptionsPosition[     44658,       1731]
NotebookOutlinePosition[     46466,       1775]
CellTagsIndexPosition[     46380,       1770]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NestWhileList" :> 
          Documentation`HelpLookup["paclet:ref/NestWhileList"], "FixedPoint" :> 
          Documentation`HelpLookup["paclet:ref/FixedPoint"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"], "TakeWhile" :> 
          Documentation`HelpLookup["paclet:ref/TakeWhile"], "Scan" :> 
          Documentation`HelpLookup["paclet:ref/Scan"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NestWhileList\"\>", 2->"\<\"FixedPoint\"\>", 
       3->"\<\"Nest\"\>", 4->"\<\"While\"\>", 5->"\<\"TakeWhile\"\>", 
       6->"\<\"Scan\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Functional Iteration\"\>", 3->"\<\"Functional Programming\"\>",
        4->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NestWhile", "ObjectName",
 CellID->9856],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhile"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]starts with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", then repeatedly applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " until applying ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to the result no longer yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhile"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]supplies the most recent ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " results as arguments for ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " at each step. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhile"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]supplies all results so far as arguments for ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " at each step. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhile"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["max", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " at most ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " times. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhile"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["max", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " an extra ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhile"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["max", "TI"], ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns the result found when ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " had been applied ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " fewer times. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32048]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
 " returns the first expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     StyleBox["\[Ellipsis]", "TR"], 
     StyleBox[" ", "TR"], 
     RowBox[{
      StyleBox["f", "TI"], "[", 
      StyleBox["expr", "TI"], "]"}], 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " to which applying ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " does not yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20760],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does not yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->824423642]
}], "Notes",
 CellID->2280],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " at each step evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["res", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["res", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["res", "TI"], 
     StyleBox["m", "TI"]]}], "]"}]], "InlineFormula"],
 ". It does not put the results ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["res", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in a list. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->166235110]
}], "Notes",
 CellID->21650],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["res", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are given in the order they are generated, with the most recent coming \
last. "
}], "Notes",
 CellID->12088],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " does not start applying ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " until at least ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " results have been generated. "
}], "Notes",
 CellID->24966],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["min", "TI"]], ",", 
      StyleBox["m", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " does not start applying ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " until at least ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " results have been generated. At each step it then supplies as arguments to \
",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " as many recent results as possible, up to a maximum of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->256178744]
}], "Notes",
 CellID->21067],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["m", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->577209543]
}], "Notes",
 CellID->15778],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    ButtonBox["UnsameQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/UnsameQ"], ",", "2"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->54762818]
}], "Notes",
 CellID->1173],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1961732027]
}], "Notes",
 CellID->3843],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    ButtonBox["UnsameQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/UnsameQ"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " goes on applying ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " until the same result first appears more than once. "
}], "Notes",
 CellID->9048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["max", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " an additional ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times after ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " fails, or ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " applications have already been performed. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1261113676]
}], "Notes",
 CellID->5932],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["max", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["NestWhileList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhileList"], "[", 
     RowBox[{
      StyleBox["f", "TI"], ",", 
      StyleBox["expr", "TI"], ",", 
      StyleBox["test", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["max", "TI"]}], "]"}], ",", 
    RowBox[{
     RowBox[{"-", 
      StyleBox["n", "TI"]}], "-", "1"}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->907238134]
}], "Notes",
 CellID->1576],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], ",", 
    RowBox[{"-", "1"}]}], "]"}]], "InlineFormula"],
 " returns, if possible, the last expression in the sequence ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 ", \[Ellipsis]",
 Cell[BoxData[""], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->763]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343290963],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->1001491],

Cell["\<\
Keep dividing by 2 until the result is no longer an even number:\
\>", "ExampleText",
 CellID->3929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/", "2"}], "&"}], ",", "123456", ",", "EvenQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->891],

Cell[BoxData["1929"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325605314]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9341],

Cell["\<\
Iterate taking logarithms until the result is no longer positive:\
\>", "ExampleText",
 CellID->32093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{"Log", ",", "100", ",", 
   RowBox[{
    RowBox[{"#", ">", "0"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28548],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Log", "[", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", "100", "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1168832964]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->105684614],

Cell["Compare the last two values generated:", "ExampleText",
 CellID->1287118561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", "UnsameQ", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->675779869],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472895285]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->363903318],

Cell["Always compare all values generated:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1961732027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", "##", "}"}], "]"}], ";", 
      RowBox[{"UnsameQ", "[", "##", "]"}]}], ")"}], "&"}], ",", "All"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659647004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", "10", "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->105505454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->7153057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->289118593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->5226246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->519593013],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->621430835]
}, Open  ]],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209300577]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1395264049],

Cell["\<\
Start comparisons after 4 iterations, and compare using the 4 last values:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->166235110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", "##", "}"}], "]"}], ";", 
      RowBox[{"UnsameQ", "[", "##", "]"}]}], ")"}], "&"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1196859741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->799739609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "2", ",", "1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->1452536971],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[10]:=",
 CellID->646112113]
}, Open  ]],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139272232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->600114759],

Cell["\<\
Start comparisons after 4 iterations, and compare using the 6 last values:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->256178744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", "##", "}"}], "]"}], ";", 
      RowBox[{"UnsameQ", "[", "##", "]"}]}], ")"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1524081621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->48069412],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1050803825],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->1955384151]
}, Open  ]],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1953561165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205064783],

Cell[TextData[{
 "Stop after at most 4 iterations, even if the test is still ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1261113676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/", "2"}], "&"}], ",", "123456", ",", "EvenQ", ",", "1", 
   ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2073469820],

Cell[BoxData["7716"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509934982]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->786],

Cell["Continue until the result is no longer greater than 1:", "ExampleText",
 CellID->86532202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", 
   RowBox[{
    RowBox[{"#", ">", "1"}], "&"}], ",", "1", ",", "\[Infinity]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1574573839],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->725454248]
}, Open  ]],

Cell[TextData[{
 "Perform one more step after the condition is no longer ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1059552853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", 
   RowBox[{
    RowBox[{"#", ">", "1"}], "&"}], ",", "1", ",", "\[Infinity]", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2095423814],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->356380335]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1317211376],

Cell[TextData[{
 "Return the last value for which the condition was still ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1906149638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", 
   RowBox[{
    RowBox[{"#", ">", "1"}], "&"}], ",", "1", ",", "\[Infinity]", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278538444],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210454205]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->157629351],

Cell["Find the next prime after 888:", "ExampleText",
 CellID->30074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", "1"}], "&"}], ",", "888", ",", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"PrimeQ", "[", "#", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26692],

Cell[BoxData["907"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326692882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->692759150],

Cell["Find the next twin prime after 888:", "ExampleText",
 CellID->24892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", "1"}], "&"}], ",", "888", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"!", 
      RowBox[{"PrimeQ", "[", "#1", "]"}]}], "||", 
     RowBox[{"!", 
      RowBox[{"PrimeQ", "[", "#3", "]"}]}]}], "&"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216],

Cell[BoxData["1021"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433261452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->545400734],

Cell["\<\
Find the index of the first Fibonacci number above a million:\
\>", "ExampleText",
 CellID->10163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "+", "1"}], ")"}], "&"}], ",", "1", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Fibonacci", "[", "#", "]"}], "<=", 
     RowBox[{"10", "^", "6"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21448],

Cell[BoxData["31"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->745776209]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fibonacci", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16250],

Cell[BoxData["1346269"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->317547608]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NestWhile", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"#", "+", "1"}], ")"}], "&"}], ",", "1", ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Fibonacci", "[", "#", "]"}], "<=", "n"}], "&"}]}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "200"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3196],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJx11kmKFFEQBuDAlUsXvXDhohQREZF2nu1nO8/azmM/W9th5RXiKHmUWHqM
PIJHUOksIT8woQi+9/NnkFRR5P6tHxvbuyLi55/P37lz/VrbmbvbdDDNPW1+
vsL5CnPvf+Y+vOD8AD6ID+HD+Aj3PYqP4VV8HJ/AJ/EpfJrnOIPP4nP4PL6A
L+JL+DK+gtdwmztxXJ3m9D0kjnVyHNfIcVwnx3GDHMdNchy3yHHcJsdxhxzH
XXIc98iXXv6O78+dOB6Q43hIjuMROY7HczecuHA8oY8TF44N+jhx4XhKHycu
HM/o48SF4zl9nLhwvKC/9PS/lrhwvJy74cSF4xV9nLhwvKaPExeON/Rx4sLx
lj5OXDje0ceJC8d7+jhx4fhAHycuHJv0ceLC0ede4IY7TjzgwiOOj+zHDXec
eMCFRxxb05zeGxa44Y4TD7jwiOMT+3HDHScecOERx2f244Y7TjzgwiOObfbj
hjtOPODCI44v7McNd5x4wIVHHF/ZjxvuOPGAC484vrEfN9xx4gEXHnF8/+ff
NhwFHQ==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 4.},
  PlotRange->{{0., 200.}, {3., 13.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159092169]
}, Open  ]],

Cell["Find the index of the last Fibonacci number below a million:", \
"ExampleText",
 CellID->938436469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"#", "+", "1"}], ")"}], "&"}], ",", "1", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Fibonacci", "[", "#", "]"}], "<=", 
     RowBox[{"10", "^", "6"}]}], "&"}], ",", "1", ",", "\[Infinity]", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->287061426],

Cell[BoxData["30"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->523616757]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->445014271],

Cell["These two forms are equivalent:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->577209543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", "UnsameQ", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->943247248],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254736459]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", "UnsameQ", ",", 
   "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1769253624],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128039702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301881179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 " returns if the condition returns anything other then ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->824423642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "a", ",", "Positive"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1157128705],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147240114]
}, Open  ]],

Cell[TextData[{
 "The outcome of a condition need not be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->857735767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Positive", "[", "a", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->986421239],

Cell[BoxData[
 RowBox[{"Positive", "[", "a", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192235690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304391153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " always compares the last two values; these two forms are equivalent:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->54762818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{"Cos", ",", "1.0", ",", "UnsameQ", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1026638739],

Cell[BoxData["0.7390851332151607`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->932960494]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"Cos", ",", "1.0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->988308988],

Cell[BoxData["0.7390851332151607`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128551496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->647285229],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhileList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhileList"]], "InlineFormula"],
 " applies the same stopping criteria, but returns all values generated:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->907238134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "+", 
       RowBox[{"3", "/", "#"}]}], ")"}], "/", "2"}], "&"}], ",", "1.0", ",", 
   "Unequal", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->949826975],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.75`", ",", "1.7321428571428572`", ",", 
   "1.7320508100147274`", ",", "1.7320508075688774`", ",", 
   "1.7320508075688772`"}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->263953237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28521529],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 " can be expressed in terms of a ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " loop:"
}], "ExampleText",
 CellID->1125436183],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"#", ">", "0"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324066301],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295707631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "10"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"x", ">", "0"}], ",", 
    RowBox[{"x", "=", 
     RowBox[{"Floor", "[", 
      RowBox[{"x", "/", "2"}], "]"}]}]}], "]"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->903825132],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66898306]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10980],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TakeWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TakeWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scan"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29598],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->24335]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->609624261],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->298863392],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->112153883],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->62949374],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->128810221]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
NestWhile"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NestWhile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 59.1538548}", "context" -> "System`", 
    "keywords" -> {
     "conditional iteration", "data driven iteration", 
      "functional while operation", "until", "while"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NestWhile[f, expr, test] starts with expr, then repeatedly applies f \
until applying test to the result no longer yields True. NestWhile[f, expr, \
test, m] supplies the most recent m results as arguments for test at each \
step. NestWhile[f, expr, test, All] supplies all results so far as arguments \
for test at each step. NestWhile[f, expr, test, m, max] applies f at most max \
times. NestWhile[f, expr, test, m, max, n] applies f an extra n times. \
NestWhile[f, expr, test, m, max, -n] returns the result found when f had been \
applied n fewer times. ", "synonyms" -> {"nest while"}, "title" -> 
    "NestWhile", "type" -> "Symbol", "uri" -> "ref/NestWhile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18504, 657, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->343290963]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46236, 1763}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2677, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3300, 87, 46, 1, 70, "ObjectName",
 CellID->9856],
Cell[3349, 90, 4124, 132, 70, "Usage",
 CellID->32048]
}, Open  ]],
Cell[CellGroupData[{
Cell[7510, 227, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7988, 244, 888, 33, 70, "Notes",
 CellID->20760],
Cell[8879, 279, 724, 29, 70, "Notes",
 CellID->2280],
Cell[9606, 310, 973, 36, 70, "Notes",
 CellID->21650],
Cell[10582, 348, 239, 9, 70, "Notes",
 CellID->12088],
Cell[10824, 359, 532, 19, 70, "Notes",
 CellID->24966],
Cell[11359, 380, 1050, 37, 70, "Notes",
 CellID->21067],
Cell[12412, 419, 807, 30, 70, "Notes",
 CellID->15778],
Cell[13222, 451, 707, 26, 70, "Notes",
 CellID->1173],
Cell[13932, 479, 914, 34, 70, "Notes",
 CellID->3843],
Cell[14849, 515, 583, 20, 70, "Notes",
 CellID->9048],
Cell[15435, 537, 829, 30, 70, "Notes",
 CellID->5932],
Cell[16267, 569, 1074, 39, 70, "Notes",
 CellID->1576],
Cell[17344, 610, 1123, 42, 70, "Notes",
 CellID->763]
}, Closed]],
Cell[CellGroupData[{
Cell[18504, 657, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->343290963],
Cell[CellGroupData[{
Cell[18889, 671, 146, 5, 70, "ExampleSection",
 CellID->1001491],
Cell[19038, 678, 110, 3, 70, "ExampleText",
 CellID->3929],
Cell[CellGroupData[{
Cell[19173, 685, 188, 7, 28, "Input",
 CellID->891],
Cell[19364, 694, 161, 5, 36, "Output",
 CellID->325605314]
}, Open  ]],
Cell[19540, 702, 120, 3, 70, "ExampleDelimiter",
 CellID->9341],
Cell[19663, 707, 112, 3, 70, "ExampleText",
 CellID->32093],
Cell[CellGroupData[{
Cell[19800, 714, 182, 6, 70, "Input",
 CellID->28548],
Cell[19985, 722, 284, 9, 36, "Output",
 CellID->1168832964]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20318, 737, 220, 7, 70, "ExampleSection",
 CellID->105684614],
Cell[20541, 746, 82, 1, 70, "ExampleText",
 CellID->1287118561],
Cell[CellGroupData[{
Cell[20648, 751, 238, 8, 70, "Input",
 CellID->675779869],
Cell[20889, 761, 158, 5, 36, "Output",
 CellID->472895285]
}, Open  ]],
Cell[21062, 769, 125, 3, 70, "ExampleDelimiter",
 CellID->363903318],
Cell[21190, 774, 128, 2, 70, "ExampleText",
 CellID->1961732027],
Cell[CellGroupData[{
Cell[21343, 780, 407, 14, 70, "Input",
 CellID->659647004],
Cell[CellGroupData[{
Cell[21775, 798, 114, 3, 70, "Print",
 CellID->105505454],
Cell[21892, 803, 135, 4, 70, "Print",
 CellID->7153057],
Cell[22030, 809, 147, 4, 70, "Print",
 CellID->289118593],
Cell[22180, 815, 155, 4, 70, "Print",
 CellID->5226246],
Cell[22338, 821, 167, 4, 70, "Print",
 CellID->519593013],
Cell[22508, 827, 180, 5, 70, "Print",
 CellID->621430835]
}, Open  ]],
Cell[22703, 835, 158, 5, 36, "Output",
 CellID->209300577]
}, Open  ]],
Cell[22876, 843, 126, 3, 70, "ExampleDelimiter",
 CellID->1395264049],
Cell[23005, 848, 173, 4, 70, "ExampleText",
 CellID->166235110],
Cell[CellGroupData[{
Cell[23203, 856, 406, 14, 70, "Input",
 CellID->1196859741],
Cell[CellGroupData[{
Cell[23634, 874, 158, 4, 70, "Print",
 CellID->799739609],
Cell[23795, 880, 158, 4, 70, "Print",
 CellID->1452536971],
Cell[23956, 886, 157, 4, 70, "Print",
 CellID->646112113]
}, Open  ]],
Cell[24128, 893, 158, 5, 36, "Output",
 CellID->139272232]
}, Open  ]],
Cell[24301, 901, 125, 3, 70, "ExampleDelimiter",
 CellID->600114759],
Cell[24429, 906, 173, 4, 70, "ExampleText",
 CellID->256178744],
Cell[CellGroupData[{
Cell[24627, 914, 452, 15, 70, "Input",
 CellID->1524081621],
Cell[CellGroupData[{
Cell[25104, 933, 156, 4, 70, "Print",
 CellID->48069412],
Cell[25263, 939, 168, 4, 70, "Print",
 CellID->1050803825],
Cell[25434, 945, 181, 5, 70, "Print",
 CellID->1955384151]
}, Open  ]],
Cell[25630, 953, 159, 5, 36, "Output",
 CellID->1953561165]
}, Open  ]],
Cell[25804, 961, 125, 3, 70, "ExampleDelimiter",
 CellID->205064783],
Cell[25932, 966, 283, 9, 70, "ExampleText",
 CellID->1261113676],
Cell[CellGroupData[{
Cell[26240, 979, 216, 7, 70, "Input",
 CellID->2073469820],
Cell[26459, 988, 161, 5, 36, "Output",
 CellID->509934982]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26669, 999, 237, 7, 70, "ExampleSection",
 CellID->786],
Cell[26909, 1008, 96, 1, 70, "ExampleText",
 CellID->86532202],
Cell[CellGroupData[{
Cell[27030, 1013, 296, 10, 70, "Input",
 CellID->1574573839],
Cell[27329, 1025, 158, 5, 36, "Output",
 CellID->725454248]
}, Open  ]],
Cell[27502, 1033, 231, 8, 70, "ExampleText",
 CellID->1059552853],
Cell[CellGroupData[{
Cell[27758, 1045, 306, 10, 70, "Input",
 CellID->2095423814],
Cell[28067, 1057, 158, 5, 36, "Output",
 CellID->356380335]
}, Open  ]],
Cell[28240, 1065, 126, 3, 70, "ExampleDelimiter",
 CellID->1317211376],
Cell[28369, 1070, 232, 8, 70, "ExampleText",
 CellID->1906149638],
Cell[CellGroupData[{
Cell[28626, 1082, 321, 10, 70, "Input",
 CellID->278538444],
Cell[28950, 1094, 158, 5, 36, "Output",
 CellID->210454205]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29157, 1105, 227, 7, 70, "ExampleSection",
 CellID->157629351],
Cell[29387, 1114, 69, 1, 70, "ExampleText",
 CellID->30074],
Cell[CellGroupData[{
Cell[29481, 1119, 276, 9, 70, "Input",
 CellID->26692],
Cell[29760, 1130, 160, 5, 36, "Output",
 CellID->326692882]
}, Open  ]],
Cell[29935, 1138, 125, 3, 70, "ExampleDelimiter",
 CellID->692759150],
Cell[30063, 1143, 74, 1, 70, "ExampleText",
 CellID->24892],
Cell[CellGroupData[{
Cell[30162, 1148, 354, 13, 70, "Input",
 CellID->216],
Cell[30519, 1163, 161, 5, 36, "Output",
 CellID->433261452]
}, Open  ]],
Cell[30695, 1171, 125, 3, 70, "ExampleDelimiter",
 CellID->545400734],
Cell[30823, 1176, 108, 3, 70, "ExampleText",
 CellID->10163],
Cell[CellGroupData[{
Cell[30956, 1183, 315, 11, 70, "Input",
 CellID->21448],
Cell[31274, 1196, 159, 5, 36, "Output",
 CellID->745776209]
}, Open  ]],
Cell[CellGroupData[{
Cell[31470, 1206, 101, 3, 70, "Input",
 CellID->16250],
Cell[31574, 1211, 164, 5, 36, "Output",
 CellID->317547608]
}, Open  ]],
Cell[CellGroupData[{
Cell[31775, 1221, 463, 16, 70, "Input",
 CellID->3196],
Cell[32241, 1239, 1025, 26, 127, "Output",
 CellID->159092169]
}, Open  ]],
Cell[33281, 1268, 105, 2, 70, "ExampleText",
 CellID->938436469],
Cell[CellGroupData[{
Cell[33411, 1274, 378, 12, 70, "Input",
 CellID->287061426],
Cell[33792, 1288, 159, 5, 36, "Output",
 CellID->523616757]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34000, 1299, 237, 7, 70, "ExampleSection",
 CellID->445014271],
Cell[34240, 1308, 122, 2, 70, "ExampleText",
 CellID->577209543],
Cell[CellGroupData[{
Cell[34387, 1314, 283, 9, 70, "Input",
 CellID->943247248],
Cell[34673, 1325, 158, 5, 36, "Output",
 CellID->254736459]
}, Open  ]],
Cell[CellGroupData[{
Cell[34868, 1335, 239, 8, 70, "Input",
 CellID->1769253624],
Cell[35110, 1345, 158, 5, 36, "Output",
 CellID->128039702]
}, Open  ]],
Cell[35283, 1353, 125, 3, 70, "ExampleDelimiter",
 CellID->301881179],
Cell[35411, 1358, 398, 13, 70, "ExampleText",
 CellID->824423642],
Cell[CellGroupData[{
Cell[35834, 1375, 228, 8, 70, "Input",
 CellID->1157128705],
Cell[36065, 1385, 158, 5, 36, "Output",
 CellID->147240114]
}, Open  ]],
Cell[36238, 1393, 336, 13, 70, "ExampleText",
 CellID->857735767],
Cell[CellGroupData[{
Cell[36599, 1410, 104, 3, 70, "Input",
 CellID->986421239],
Cell[36706, 1415, 192, 6, 36, "Output",
 CellID->192235690]
}, Open  ]],
Cell[36913, 1424, 125, 3, 70, "ExampleDelimiter",
 CellID->304391153],
Cell[37041, 1429, 297, 8, 70, "ExampleText",
 CellID->54762818],
Cell[CellGroupData[{
Cell[37363, 1441, 159, 4, 70, "Input",
 CellID->1026638739],
Cell[37525, 1447, 176, 5, 36, "Output",
 CellID->932960494]
}, Open  ]],
Cell[CellGroupData[{
Cell[37738, 1457, 133, 4, 70, "Input",
 CellID->988308988],
Cell[37874, 1463, 176, 5, 36, "Output",
 CellID->128551496]
}, Open  ]],
Cell[38065, 1471, 125, 3, 70, "ExampleDelimiter",
 CellID->647285229],
Cell[38193, 1476, 305, 8, 70, "ExampleText",
 CellID->907238134],
Cell[CellGroupData[{
Cell[38523, 1488, 289, 10, 70, "Input",
 CellID->949826975],
Cell[38815, 1500, 345, 10, 36, "Output",
 CellID->263953237]
}, Open  ]],
Cell[39175, 1513, 124, 3, 70, "ExampleDelimiter",
 CellID->28521529],
Cell[39302, 1518, 336, 12, 70, "ExampleText",
 CellID->1125436183],
Cell[CellGroupData[{
Cell[39663, 1534, 262, 9, 70, "Input",
 CellID->324066301],
Cell[39928, 1545, 158, 5, 36, "Output",
 CellID->295707631]
}, Open  ]],
Cell[CellGroupData[{
Cell[40123, 1555, 294, 10, 70, "Input",
 CellID->903825132],
Cell[40420, 1567, 157, 5, 36, "Output",
 CellID->66898306]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40638, 1579, 311, 9, 70, "SeeAlsoSection",
 CellID->10980],
Cell[40952, 1590, 1425, 53, 70, "SeeAlso",
 CellID->12166]
}, Open  ]],
Cell[CellGroupData[{
Cell[42414, 1648, 314, 9, 70, "TutorialsSection",
 CellID->29598],
Cell[42731, 1659, 167, 3, 70, "Tutorials",
 CellID->24335]
}, Open  ]],
Cell[CellGroupData[{
Cell[42935, 1667, 319, 9, 70, "MoreAboutSection",
 CellID->609624261],
Cell[43257, 1678, 136, 3, 70, "MoreAbout",
 CellID->298863392],
Cell[43396, 1683, 151, 3, 70, "MoreAbout",
 CellID->112153883],
Cell[43550, 1688, 154, 3, 70, "MoreAbout",
 CellID->62949374],
Cell[43707, 1693, 147, 3, 70, "MoreAbout",
 CellID->128810221]
}, Open  ]],
Cell[CellGroupData[{
Cell[43891, 1701, 305, 8, 70, "RelatedLinksSection"],
Cell[44199, 1711, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[44601, 1727, 27, 0, 70, "History"],
Cell[44631, 1729, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

