(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     73535,       2418]
NotebookOptionsPosition[     62196,       2027]
NotebookOutlinePosition[     63940,       2070]
CellTagsIndexPosition[     63854,       2065]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NestWhile" :> Documentation`HelpLookup["paclet:ref/NestWhile"],
           "FixedPointList" :> 
          Documentation`HelpLookup["paclet:ref/FixedPointList"], "NestList" :> 
          Documentation`HelpLookup["paclet:ref/NestList"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NestWhile\"\>", 2->"\<\"FixedPointList\"\>", 
       3->"\<\"NestList\"\>", 4->"\<\"While\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Constructing Lists\"\>", 3->"\<\"Functional Iteration\"\>", 
       4->"\<\"Functional Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NestWhileList", "ObjectName",
 CellID->6850],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhileList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhileList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of the results of applying ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly, starting with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and continuing until applying ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to the result no longer yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhileList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhileList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]supplies the most recent ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " results as arguments for ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " at each step. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhileList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhileList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        ButtonBox["All",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]supplies all results so far as arguments for ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " at each step. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NestWhileList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NestWhileList"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["test", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["max", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " at most ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     " times. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->29934]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The last element of the list returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
 " is always an expression to which applying ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " does not yield ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26495],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " at each step evaluates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["test", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["res", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["res", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"], ",", 
    SubscriptBox[
     StyleBox["res", "TI"], 
     StyleBox["m", "TI"]]}], "]"}]], "InlineFormula"],
 ". It does not put the results ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["res", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in a list. "
}], "Notes",
 CellID->6975],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["res", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are given in the order they are generated, with the most recent coming \
last. "
}], "Notes",
 CellID->29075],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " does not start applying ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " until at least ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " results have been generated. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->166235110]
}], "Notes",
 CellID->7694],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["m", "TI"], 
       StyleBox["min", "TI"]], ",", 
      StyleBox["m", "TI"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " does not start applying ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " until at least ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["m", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " results have been generated. At each step it then supplies as arguments to \
",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " as many recent results as possible, up to a maximum of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->256178744]
}], "Notes",
 CellID->15787],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["m", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->577209543]
}], "Notes",
 CellID->5465],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    ButtonBox["UnsameQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/UnsameQ"], ",", "2"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1351214094]
}], "Notes",
 CellID->14762],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1961732027]
}], "Notes",
 CellID->7639],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    ButtonBox["UnsameQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/UnsameQ"], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " goes on applying ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " until the same result first appears more than once. "
}], "Notes",
 CellID->17508],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["max", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " an extra ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times, appending the results to the list generated.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1059552853]
}], "Notes",
 CellID->17460],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["test", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["max", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " drops the last ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " elements from the list generated. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1906149638]
}], "Notes",
 CellID->25682]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23483894],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->366919842],

Cell["\<\
Keep dividing by 2 until the result is no longer an even number:\
\>", "ExampleText",
 CellID->11373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/", "2"}], "&"}], ",", "123456", ",", "EvenQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "123456", ",", "61728", ",", "30864", ",", "15432", ",", "7716", ",", 
   "3858", ",", "1929"}], "}"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116278574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9341],

Cell["\<\
Iterate taking logarithms until the result is no longer positive:\
\>", "ExampleText",
 CellID->32093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{"Log", ",", "100", ",", 
   RowBox[{
    RowBox[{"#", ">", "0"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", 
   RowBox[{"Log", "[", "100", "]"}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", "100", "]"}], "]"}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"Log", "[", "100", "]"}], "]"}], "]"}], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"Log", "[", 
      RowBox[{"Log", "[", "100", "]"}], "]"}], "]"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{518, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1817933596]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->261402687],

Cell["\<\
Start comparisons after 4 iterations, and compare using the 4 last values:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->166235110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", "##", "}"}], "]"}], ";", 
      RowBox[{"UnsameQ", "[", "##", "]"}]}], ")"}], "&"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1196859741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->616462454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "2", ",", "1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1797114913],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "0", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1895124410]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->911135238]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->725152482],

Cell["\<\
Start comparisons after 4 iterations, and compare using the 6 last values:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->256178744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", "##", "}"}], "]"}], ";", 
      RowBox[{"UnsameQ", "[", "##", "]"}]}], ")"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1524081621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->499060791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->721710099],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->153533085]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1112962864]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->361181765],

Cell["Always compare all values generated:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1961732027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", 
       RowBox[{"{", "##", "}"}], "]"}], ";", 
      RowBox[{"UnsameQ", "[", "##", "]"}]}], ")"}], "&"}], ",", "All"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659647004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", "10", "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->622533948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->736227834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1922143705],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1060842087],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->926802334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->1445000564]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1344317417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->717198611],

Cell[TextData[{
 "Stop after at most 4 steps, even if the condition is still ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1261113676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", "UnsameQ", ",", 
   "2", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->722757198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1001441026]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->212],

Cell["Continue until the result is no longer greater than 1:", "ExampleText",
 CellID->86532202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", 
   RowBox[{
    RowBox[{"#", ">", "1"}], "&"}], ",", "1", ",", "\[Infinity]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1574573839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "10", ",", "5", ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2052064136]
}, Open  ]],

Cell[TextData[{
 "Perform one more step after the condition is no longer ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1059552853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", 
   RowBox[{
    RowBox[{"#", ">", "1"}], "&"}], ",", "1", ",", "\[Infinity]", ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2095423814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "10", ",", "5", ",", "2", ",", "1", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{130, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1725888160]
}, Open  ]],

Cell[TextData[{
 "Drop the last value generated (for which the test was no longer ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 "):"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1906149638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "20", ",", 
   RowBox[{
    RowBox[{"#", ">", "1"}], "&"}], ",", "1", ",", "\[Infinity]", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->278538444],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "10", ",", "5", ",", "2"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1188055759]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20465],

Cell["Find successive integers until a prime is reached:", "ExampleText",
 CellID->9783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "+", "1"}], "&"}], ",", "899", ",", "\[InvisibleSpace]", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"PrimeQ", "[", "#", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "899", ",", "900", ",", "901", ",", "902", ",", "903", ",", "904", ",", 
   "905", ",", "906", ",", "907"}], "}"}]], "Output",
 ImageSize->{297, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->245420007]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11626],

Cell["Find the multiplicative order of 2 modulo 19:", "ExampleText",
 CellID->31153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"2", "#"}], ",", "19"}], "]"}], "&"}], ",", "2", ",", 
   RowBox[{
    RowBox[{"#", "!=", "1"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "4", ",", "8", ",", "16", ",", "13", ",", "7", ",", "14", ",", 
   "9", ",", "18", ",", "17", ",", "15", ",", "11", ",", "3", ",", "6", ",", 
   "12", ",", "5", ",", "10", ",", "1"}], "}"}]], "Output",
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185937932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->307727696],

Cell[BoxData["18"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20184968]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MultiplicativeOrder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MultiplicativeOrder"]], "InlineFormula"],
 " to compute directly:"
}], "ExampleText",
 CellID->6207935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultiplicativeOrder", "[", 
  RowBox[{"2", ",", "19"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->174375926],

Cell[BoxData["18"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23225109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60963931],

Cell[TextData[{
 "Find the orbit of ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 " under the mapping ",
 Cell[BoxData[
  FormBox[
   RowBox[{"5", "x", "  ", "mod", " ", "7"}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->330830305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"5", " ", "#"}], ",", " ", "7"}], "]"}], "&"}], ",", " ", "4", 
   ",", " ", "Unequal", ",", " ", "All"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "6", ",", "2", ",", "3", ",", "1", ",", "5", ",", "4"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->120436524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31127],

Cell[TextData[{
 "Keep applying iterations in the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"3", "n"}], "+", "1"}], TraditionalForm]], "InlineMath"],
 " problem until the results repeat:"
}], "ExampleText",
 CellID->15780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "#", "]"}], ",", 
      RowBox[{"#", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "#"}], "+", "1"}], ")"}], "/", "2"}]}], "]"}], "&"}], 
   ",", "400", ",", "Unequal", ",", "All"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22431],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "400", ",", "200", ",", "100", ",", "50", ",", "25", ",", "38", ",", "19", 
   ",", "29", ",", "44", ",", "22", ",", "11", ",", "17", ",", "26", ",", 
   "13", ",", "20", ",", "10", ",", "5", ",", "8", ",", "4", ",", "2", ",", 
   "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{540, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->602732450]
}, Open  ]],

Cell["Exclude the first repeating element from the output:", "ExampleText",
 CellID->302295282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "#", "]"}], ",", 
      RowBox[{"#", "/", "2"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", "#"}], "+", "1"}], ")"}], "/", "2"}]}], "]"}], "&"}], 
   ",", "400", ",", "Unequal", ",", "All", ",", "\[Infinity]", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->586831891],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "400", ",", "200", ",", "100", ",", "50", ",", "25", ",", "38", ",", "19", 
   ",", "29", ",", "44", ",", "22", ",", "11", ",", "17", ",", "26", ",", 
   "13", ",", "20", ",", "10", ",", "5", ",", "8", ",", "4", ",", "2", ",", 
   "1"}], "}"}]], "Output",
 ImageSize->{522, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242010561]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30183],

Cell[TextData[{
 "Apply Newton iterations for ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " until successive results are within 0.001."
}], "ExampleText",
 CellID->11347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", " ", "+", " ", 
       RowBox[{"2", "/", "#"}]}], " ", ")"}], "/", "2"}], "&"}], ",", "1", 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"#1", "-", "#2"}], "]"}], ">", "0.001"}], "&"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110917709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   FractionBox["3", "2"], ",", 
   FractionBox["17", "12"], ",", 
   FractionBox["577", "408"], ",", 
   FractionBox["665857", "470832"]}], "}"}]], "Output",
 ImageSize->{173, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->361333973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6440],

Cell["These two forms are equivalent:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->577209543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", "UnsameQ", ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->943247248],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54179947]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", "UnsameQ", ",", 
   "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1769253624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"10", ",", "5", ",", "2", ",", "1", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7091726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->49694176],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhileList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhileList"]], "InlineFormula"],
 " returns all intermediate values of ",
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->74374445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#", "/", "2"}], "&"}], ",", "123456", ",", "EvenQ"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->253442084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "123456", ",", "61728", ",", "30864", ",", "15432", ",", "7716", ",", 
   "3858", ",", "1929"}], "}"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244148614]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reap", "[", 
  RowBox[{"NestWhile", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sow", "[", "#", "]"}], "/", "2"}], ")"}], "&"}], ",", 
    "123456", ",", "EvenQ"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->63368894],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1929", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "123456", ",", "61728", ",", "30864", ",", "15432", ",", "7716", ",", 
      "3858"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->697581582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->605083354],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 " always compares the last two values; these two forms are equivalent:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1351214094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "+", 
       RowBox[{"3", "/", "#"}]}], ")"}], "/", "2"}], "&"}], ",", "1.0", ",", 
   "UnsameQ", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1026638739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.75`", ",", "1.7321428571428572`", ",", 
   "1.7320508100147274`", ",", "1.7320508075688774`", ",", 
   "1.7320508075688772`"}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1781069206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"#", "+", 
       RowBox[{"3", "/", "#"}]}], ")"}], "/", "2"}], "&"}], ",", "1.0"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->988308988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.75`", ",", "1.7321428571428572`", ",", 
   "1.7320508100147274`", ",", "1.7320508075688774`", ",", 
   "1.7320508075688772`"}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->851291144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9029],

Cell["Find the digits of a number:", "ExampleText",
 CellID->783524944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "123456"}], ",", 
     RowBox[{"k", "=", "10"}]}], "}"}], ",", 
   RowBox[{"Reverse", "[", 
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"NestWhileList", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Quotient", "[", 
          RowBox[{
          "#", ",", "\[NegativeVeryThinSpace]\[NegativeVeryThinSpace]", "k"}],
           "]"}], "&"}], ",", "n", ",", 
        RowBox[{
         RowBox[{"#", "\[GreaterEqual]", "k"}], "&"}]}], "]"}], ",", "k"}], 
     "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->915893112],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203236694]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1847397887],

Cell["Distance of two vertices in a graph:", "ExampleText",
 CellID->1892781608],

Cell[BoxData[
 RowBox[{
  RowBox[{"Distance", "[", 
   RowBox[{"g_", ",", 
    RowBox[{"{", 
     RowBox[{"i_", ",", "j_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Length", "[", 
    RowBox[{"NestWhileList", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Union", "[", 
        RowBox[{"Flatten", "[", 
         RowBox[{"#", "/.", "\[InvisibleSpace]", "g"}], "]"}], "]"}], "&"}], 
      ",", 
      RowBox[{"{", "i", "}"}], ",", 
      RowBox[{
       RowBox[{"!", 
        RowBox[{"MemberQ", "[", 
         RowBox[{"#", ",", "j"}], "]"}]}], "&"}]}], "]"}], "]"}], "-", 
   "1"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->804477011],

Cell[BoxData[
 RowBox[{
  RowBox[{"dodec", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "17", ",", "20"}], "}"}]}], ",", 
     RowBox[{"2", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "15"}], "}"}]}], ",", 
     RowBox[{"3", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"13", ",", "2", ",", "4"}], "}"}]}], ",", 
     RowBox[{"4", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"20", ",", "5", ",", "3"}], "}"}]}], ",", 
     RowBox[{"5", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"12", ",", "6", ",", "4"}], "}"}]}], ",", 
     RowBox[{"6", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"5", ",", "7", ",", "19"}], "}"}]}], ",", 
     RowBox[{"7", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"6", ",", "8", ",", "11"}], "}"}]}], ",", 
     RowBox[{"8", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"18", ",", "7", ",", "9"}], "}"}]}], ",", 
     RowBox[{"9", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"8", ",", "10", ",", "16"}], "}"}]}], ",", 
     RowBox[{"10", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"9", ",", "11", ",", "14"}], "}"}]}], ",", 
     RowBox[{"11", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"10", ",", "12", ",", "7"}], "}"}]}], ",", 
     RowBox[{"12", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"11", ",", "13", ",", "5"}], "}"}]}], ",", 
     RowBox[{"13", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"12", ",", "14", ",", "3"}], "}"}]}], ",", 
     RowBox[{"14", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"13", ",", "15", ",", "10"}], "}"}]}], ",", 
     RowBox[{"15", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"14", ",", "16", ",", "2"}], "}"}]}], ",", 
     RowBox[{"16", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"15", ",", "17", ",", "9"}], "}"}]}], ",", 
     RowBox[{"17", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"16", ",", "18", ",", "1"}], "}"}]}], ",", 
     RowBox[{"18", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"17", ",", "19", ",", "8"}], "}"}]}], ",", 
     RowBox[{"19", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"18", ",", "20", ",", "6"}], "}"}]}], ",", 
     RowBox[{"20", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"19", ",", "1", ",", "4"}], "}"}]}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->171374371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Distance", "[", 
  RowBox[{"dodec", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "11"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->374038222],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1033712897]
}, Open  ]],

Cell["A plot of the graph:", "ExampleText",
 CellID->82594885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Map", "[", 
     RowBox[{"Thread", ",", "dodec"}], "]"}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->263254748],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{295, 290},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->638392903]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23948],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FixedPointList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FixedPointList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31559]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30586],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->11495]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->310309876],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->162022125],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->156494277],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->232038351],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->10840434]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
NestWhileList"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NestWhileList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 1, 58.5757150}", "context" -> "System`", 
    "keywords" -> {
     "conditional iteration", "cycle detection", "data driven iteration", 
      "functional while operation", "until", "while"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NestWhileList[f, expr, test] generates a list of the results of applying \
f repeatedly, starting with expr, and continuing until applying test to the \
result no longer yields True. NestWhileList[f, expr, test, m] supplies the \
most recent m results as arguments for test at each step. NestWhileList[f, \
expr, test, All] supplies all results so far as arguments for test at each \
step. NestWhileList[f, expr, test, m, max] applies f at most max times. ", 
    "synonyms" -> {"nest while list"}, "title" -> "NestWhileList", "type" -> 
    "Symbol", "uri" -> "ref/NestWhileList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14500, 502, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23483894]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63711, 2058}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2546, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3169, 85, 50, 1, 70, "ObjectName",
 CellID->6850],
Cell[3222, 88, 2872, 89, 70, "Usage",
 CellID->29934]
}, Open  ]],
Cell[CellGroupData[{
Cell[6131, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6609, 199, 599, 21, 70, "Notes",
 CellID->26495],
Cell[7211, 222, 893, 33, 70, "Notes",
 CellID->6975],
Cell[8107, 257, 239, 9, 70, "Notes",
 CellID->29075],
Cell[8349, 268, 626, 22, 70, "Notes",
 CellID->7694],
Cell[8978, 292, 1058, 37, 70, "Notes",
 CellID->15787],
Cell[10039, 331, 823, 30, 70, "Notes",
 CellID->5465],
Cell[10865, 363, 726, 26, 70, "Notes",
 CellID->14762],
Cell[11594, 391, 930, 34, 70, "Notes",
 CellID->7639],
Cell[12527, 427, 592, 20, 70, "Notes",
 CellID->17508],
Cell[13122, 449, 710, 24, 70, "Notes",
 CellID->17460],
Cell[13835, 475, 628, 22, 70, "Notes",
 CellID->25682]
}, Closed]],
Cell[CellGroupData[{
Cell[14500, 502, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23483894],
Cell[CellGroupData[{
Cell[14884, 516, 148, 5, 70, "ExampleSection",
 CellID->366919842],
Cell[15035, 523, 111, 3, 70, "ExampleText",
 CellID->11373],
Cell[CellGroupData[{
Cell[15171, 530, 194, 7, 28, "Input",
 CellID->30750],
Cell[15368, 539, 287, 9, 36, "Output",
 CellID->116278574]
}, Open  ]],
Cell[15670, 551, 120, 3, 70, "ExampleDelimiter",
 CellID->9341],
Cell[15793, 556, 112, 3, 70, "ExampleText",
 CellID->32093],
Cell[CellGroupData[{
Cell[15930, 563, 186, 6, 70, "Input",
 CellID->28548],
Cell[16119, 571, 568, 18, 36, "Output",
 CellID->1817933596]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16736, 595, 220, 7, 70, "ExampleSection",
 CellID->261402687],
Cell[16959, 604, 173, 4, 70, "ExampleText",
 CellID->166235110],
Cell[CellGroupData[{
Cell[17157, 612, 410, 14, 70, "Input",
 CellID->1196859741],
Cell[CellGroupData[{
Cell[17592, 630, 157, 4, 70, "Print",
 CellID->616462454],
Cell[17752, 636, 157, 4, 70, "Print",
 CellID->1797114913],
Cell[17912, 642, 157, 4, 70, "Print",
 CellID->1895124410]
}, Open  ]],
Cell[18084, 649, 248, 8, 36, "Output",
 CellID->911135238]
}, Open  ]],
Cell[18347, 660, 125, 3, 70, "ExampleDelimiter",
 CellID->725152482],
Cell[18475, 665, 173, 4, 70, "ExampleText",
 CellID->256178744],
Cell[CellGroupData[{
Cell[18673, 673, 456, 15, 70, "Input",
 CellID->1524081621],
Cell[CellGroupData[{
Cell[19154, 692, 157, 4, 70, "Print",
 CellID->499060791],
Cell[19314, 698, 167, 4, 70, "Print",
 CellID->721710099],
Cell[19484, 704, 180, 5, 70, "Print",
 CellID->153533085]
}, Open  ]],
Cell[19679, 712, 249, 8, 36, "Output",
 CellID->1112962864]
}, Open  ]],
Cell[19943, 723, 125, 3, 70, "ExampleDelimiter",
 CellID->361181765],
Cell[20071, 728, 128, 2, 70, "ExampleText",
 CellID->1961732027],
Cell[CellGroupData[{
Cell[20224, 734, 411, 14, 70, "Input",
 CellID->659647004],
Cell[CellGroupData[{
Cell[20660, 752, 114, 3, 70, "Print",
 CellID->622533948],
Cell[20777, 757, 137, 4, 70, "Print",
 CellID->736227834],
Cell[20917, 763, 148, 4, 70, "Print",
 CellID->1922143705],
Cell[21068, 769, 158, 4, 70, "Print",
 CellID->1060842087],
Cell[21229, 775, 167, 4, 70, "Print",
 CellID->926802334],
Cell[21399, 781, 181, 5, 70, "Print",
 CellID->1445000564]
}, Open  ]],
Cell[21595, 789, 249, 8, 36, "Output",
 CellID->1344317417]
}, Open  ]],
Cell[21859, 800, 125, 3, 70, "ExampleDelimiter",
 CellID->717198611],
Cell[21987, 805, 283, 9, 70, "ExampleText",
 CellID->1261113676],
Cell[CellGroupData[{
Cell[22295, 818, 252, 8, 70, "Input",
 CellID->722757198],
Cell[22550, 828, 237, 7, 36, "Output",
 CellID->1001441026]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22836, 841, 237, 7, 70, "ExampleSection",
 CellID->212],
Cell[23076, 850, 96, 1, 70, "ExampleText",
 CellID->86532202],
Cell[CellGroupData[{
Cell[23197, 855, 300, 10, 70, "Input",
 CellID->1574573839],
Cell[23500, 867, 237, 7, 36, "Output",
 CellID->2052064136]
}, Open  ]],
Cell[23752, 877, 279, 9, 70, "ExampleText",
 CellID->1059552853],
Cell[CellGroupData[{
Cell[24056, 890, 310, 10, 70, "Input",
 CellID->2095423814],
Cell[24369, 902, 250, 8, 36, "Output",
 CellID->1725888160]
}, Open  ]],
Cell[24634, 913, 289, 9, 70, "ExampleText",
 CellID->1906149638],
Cell[CellGroupData[{
Cell[24948, 926, 325, 10, 70, "Input",
 CellID->278538444],
Cell[25276, 938, 226, 7, 36, "Output",
 CellID->1188055759]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25551, 951, 223, 7, 70, "ExampleSection",
 CellID->20465],
Cell[25777, 960, 88, 1, 70, "ExampleText",
 CellID->9783],
Cell[CellGroupData[{
Cell[25890, 965, 280, 9, 70, "Input",
 CellID->13953],
Cell[26173, 976, 299, 9, 36, "Output",
 CellID->245420007]
}, Open  ]],
Cell[26487, 988, 121, 3, 70, "ExampleDelimiter",
 CellID->11626],
Cell[26611, 993, 84, 1, 70, "ExampleText",
 CellID->31153],
Cell[CellGroupData[{
Cell[26720, 998, 281, 10, 70, "Input",
 CellID->165],
Cell[27004, 1010, 384, 10, 36, "Output",
 CellID->185937932]
}, Open  ]],
Cell[CellGroupData[{
Cell[27425, 1025, 102, 3, 70, "Input",
 CellID->307727696],
Cell[27530, 1030, 158, 5, 36, "Output",
 CellID->20184968]
}, Open  ]],
Cell[27703, 1038, 227, 8, 70, "ExampleText",
 CellID->6207935],
Cell[CellGroupData[{
Cell[27955, 1050, 139, 4, 70, "Input",
 CellID->174375926],
Cell[28097, 1056, 158, 5, 36, "Output",
 CellID->23225109]
}, Open  ]],
Cell[28270, 1064, 124, 3, 70, "ExampleDelimiter",
 CellID->60963931],
Cell[28397, 1069, 279, 11, 70, "ExampleText",
 CellID->330830305],
Cell[CellGroupData[{
Cell[28701, 1084, 283, 9, 70, "Input",
 CellID->6619],
Cell[28987, 1095, 257, 8, 36, "Output",
 CellID->120436524]
}, Open  ]],
Cell[29259, 1106, 121, 3, 70, "ExampleDelimiter",
 CellID->31127],
Cell[29383, 1111, 233, 8, 70, "ExampleText",
 CellID->15780],
Cell[CellGroupData[{
Cell[29641, 1123, 420, 14, 70, "Input",
 CellID->22431],
Cell[30064, 1139, 438, 11, 36, "Output",
 CellID->602732450]
}, Open  ]],
Cell[30517, 1153, 95, 1, 70, "ExampleText",
 CellID->302295282],
Cell[CellGroupData[{
Cell[30637, 1158, 473, 15, 70, "Input",
 CellID->586831891],
Cell[31113, 1175, 428, 11, 36, "Output",
 CellID->242010561]
}, Open  ]],
Cell[31556, 1189, 121, 3, 70, "ExampleDelimiter",
 CellID->30183],
Cell[31680, 1194, 207, 7, 70, "ExampleText",
 CellID->11347],
Cell[CellGroupData[{
Cell[31912, 1205, 409, 15, 70, "Input",
 CellID->110917709],
Cell[32324, 1222, 338, 11, 51, "Output",
 CellID->361333973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32711, 1239, 232, 7, 70, "ExampleSection",
 CellID->6440],
Cell[32946, 1248, 122, 2, 70, "ExampleText",
 CellID->577209543],
Cell[CellGroupData[{
Cell[33093, 1254, 287, 9, 70, "Input",
 CellID->943247248],
Cell[33383, 1265, 247, 8, 36, "Output",
 CellID->54179947]
}, Open  ]],
Cell[CellGroupData[{
Cell[33667, 1278, 243, 8, 70, "Input",
 CellID->1769253624],
Cell[33913, 1288, 246, 8, 36, "Output",
 CellID->7091726]
}, Open  ]],
Cell[34174, 1299, 124, 3, 70, "ExampleDelimiter",
 CellID->49694176],
Cell[34301, 1304, 349, 12, 70, "ExampleText",
 CellID->74374445],
Cell[CellGroupData[{
Cell[34675, 1320, 198, 7, 70, "Input",
 CellID->253442084],
Cell[34876, 1329, 287, 9, 36, "Output",
 CellID->244148614]
}, Open  ]],
Cell[CellGroupData[{
Cell[35200, 1343, 291, 10, 70, "Input",
 CellID->63368894],
Cell[35494, 1355, 358, 12, 36, "Output",
 CellID->697581582]
}, Open  ]],
Cell[35867, 1370, 125, 3, 70, "ExampleDelimiter",
 CellID->605083354],
Cell[35995, 1375, 307, 8, 70, "ExampleText",
 CellID->1351214094],
Cell[CellGroupData[{
Cell[36327, 1387, 290, 10, 70, "Input",
 CellID->1026638739],
Cell[36620, 1399, 346, 10, 36, "Output",
 CellID->1781069206]
}, Open  ]],
Cell[CellGroupData[{
Cell[37003, 1414, 263, 10, 70, "Input",
 CellID->988308988],
Cell[37269, 1426, 345, 10, 36, "Output",
 CellID->851291144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37663, 1442, 223, 7, 70, "ExampleSection",
 CellID->9029],
Cell[37889, 1451, 71, 1, 70, "ExampleText",
 CellID->783524944],
Cell[CellGroupData[{
Cell[37985, 1456, 650, 21, 70, "Input",
 CellID->915893112],
Cell[38638, 1479, 247, 8, 36, "Output",
 CellID->203236694]
}, Open  ]],
Cell[38900, 1490, 126, 3, 70, "ExampleDelimiter",
 CellID->1847397887],
Cell[39029, 1495, 80, 1, 70, "ExampleText",
 CellID->1892781608],
Cell[39112, 1498, 645, 22, 70, "Input",
 CellID->804477011],
Cell[39760, 1522, 2334, 67, 70, "Input",
 CellID->171374371],
Cell[CellGroupData[{
Cell[42119, 1593, 181, 6, 70, "Input",
 CellID->374038222],
Cell[42303, 1601, 159, 5, 36, "Output",
 CellID->1033712897]
}, Open  ]],
Cell[42477, 1609, 62, 1, 70, "ExampleText",
 CellID->82594885],
Cell[CellGroupData[{
Cell[42564, 1614, 276, 8, 70, "Input",
 CellID->263254748],
Cell[42843, 1624, 15715, 262, 70, "Output",
 Evaluatable->False,
 CellID->638392903]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58619, 1893, 311, 9, 70, "SeeAlsoSection",
 CellID->23948],
Cell[58933, 1904, 949, 35, 70, "SeeAlso",
 CellID->31559]
}, Open  ]],
Cell[CellGroupData[{
Cell[59919, 1944, 314, 9, 70, "TutorialsSection",
 CellID->30586],
Cell[60236, 1955, 167, 3, 70, "Tutorials",
 CellID->11495]
}, Open  ]],
Cell[CellGroupData[{
Cell[60440, 1963, 319, 9, 70, "MoreAboutSection",
 CellID->310309876],
Cell[60762, 1974, 165, 3, 70, "MoreAbout",
 CellID->162022125],
Cell[60930, 1979, 147, 3, 70, "MoreAbout",
 CellID->156494277],
Cell[61080, 1984, 151, 3, 70, "MoreAbout",
 CellID->232038351],
Cell[61234, 1989, 154, 3, 70, "MoreAbout",
 CellID->10840434]
}, Open  ]],
Cell[CellGroupData[{
Cell[61425, 1997, 305, 8, 70, "RelatedLinksSection"],
Cell[61733, 2007, 391, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[62139, 2023, 27, 0, 70, "History"],
Cell[62169, 2025, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

