(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25909,        995]
NotebookOptionsPosition[     19873,        788]
NotebookOutlinePosition[     21296,        827]
CellTagsIndexPosition[     21211,        822]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Dot" :> Documentation`HelpLookup["paclet:ref/Dot"], "Times" :> 
         Documentation`HelpLookup["paclet:ref/Times"], "Cross" :> 
         Documentation`HelpLookup["paclet:ref/Cross"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Dot\"\>", 2->"\<\"Times\"\>", 
      3->"\<\"Cross\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "NonCommutativeMultiply ",
 StyleBox["(**)", "OperatorCharacter"]
}], "ObjectName",
 CellID->25922],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "**", 
       StyleBox["b", "TI"], "**", 
       StyleBox["c", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]is a general associative, but non\[Hyphen]commutative, \
form of multiplication. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27401],

Cell[TextData[{
 "Instances of ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 " are automatically flattened, but no other simplification is performed. "
}], "Notes",
 CellID->15937],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 " as a generalization of ordinary multiplication for special mathematical \
objects. "
}], "Notes",
 CellID->30012]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628747683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->16872158],

Cell["\<\
Compare commutative multiplication with non-commutative multiplication:\
\>", "ExampleText",
 CellID->867296684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "*", "b"}], "\[Equal]", 
    RowBox[{"b", "*", "a"}]}], ",", 
   RowBox[{
    RowBox[{"a", "**", "b"}], "\[Equal]", 
    RowBox[{"b", "**", "a"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523260902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", 
   RowBox[{
    RowBox[{"a", "**", "b"}], "\[Equal]", 
    RowBox[{"b", "**", "a"}]}]}], "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51005927]
}, Open  ]],

Cell["Operations are associative: ", "ExampleText",
 CellID->168644701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "**", 
   RowBox[{"(", 
    RowBox[{"b", "**", "c"}], ")"}]}], "\[Equal]", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "**", "b"}], ")"}], "**", "c"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->56882610],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->96641984]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29411],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 " to represent composition in an algebra of differential operators:"
}], "ExampleText",
 CellID->133361952],

Cell[TextData[{
 "The base case, where ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 " is a function, simply multiplies by ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->48556666],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DOperator", "[", 
    RowBox[{"A_", ",", "expr_"}], "]"}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"A", ",", "D"}], "]"}]}], ":=", 
  RowBox[{"A", "expr"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463642272],

Cell["The next two properties express linearity:", "ExampleText",
 CellID->93648321],

Cell[BoxData[
 RowBox[{
  RowBox[{"DOperator", "[", 
   RowBox[{
    RowBox[{"L1_", "+", "L2_"}], ",", "expr_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"DOperator", "[", 
    RowBox[{"L1", ",", "expr"}], "]"}], "+", 
   RowBox[{"DOperator", "[", 
    RowBox[{"L2", ",", "expr"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202429102],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DOperator", "[", 
    RowBox[{
     RowBox[{"A_", "L_"}], ",", "expr_"}], "]"}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"A", ",", "D"}], "]"}]}], ":=", 
  RowBox[{"A", 
   RowBox[{"DOperator", "[", 
    RowBox[{"L", ",", "expr"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->205625045],

Cell[TextData[{
 "Here the operator is ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " stops the derivative from acting on the double blank:"
}], "ExampleText",
 CellID->28204838],

Cell[BoxData[
 RowBox[{
  RowBox[{"DOperator", "[", 
   RowBox[{
    RowBox[{"A", ":", 
     RowBox[{"HoldPattern", "[", 
      RowBox[{
       RowBox[{"D", "[", "__", "]"}], "&"}], "]"}]}], ",", "expr_"}], "]"}], ":=",
   
  RowBox[{"A", "[", "expr", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->327891947],

Cell["Composition of operators applied to an expression:", "ExampleText",
 CellID->8246866],

Cell[BoxData[
 RowBox[{
  RowBox[{"DOperator", "[", 
   RowBox[{
    RowBox[{"L1__", "**", "L2_"}], ",", "expr_"}], "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"DOperator", "[", 
    RowBox[{"L1", ",", 
     RowBox[{"DOperator", "[", 
      RowBox[{"L2", ",", "expr"}], "]"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->801910443],

Cell["Power of an operator applied to an expression:", "ExampleText",
 CellID->166899389],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DOperator", "[", 
    RowBox[{
     SuperscriptBox["L1_", "n_Integer"], ",", "expr_"}], "]"}], "/;", 
   RowBox[{"n", ">", "1"}]}], ":=", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Expand", "[", 
      RowBox[{"DOperator", "[", 
       RowBox[{"L1", ",", "#1"}], "]"}], "]"}], "&"}], ",", "expr", ",", 
    "n"}], "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->387032813],

Cell["\<\
Apply these rules to derive the kdV equation for the Lax pair:\
\>", "ExampleText",
 CellID->70115701],

Cell[BoxData[
 RowBox[{
  RowBox[{"Dx", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", "x"], "#1"}], "&"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->214060791],

Cell[BoxData[{
 RowBox[{
  RowBox[{"L", "=", 
   RowBox[{
    RowBox[{"Dx", "**", "Dx"}], "+", 
    RowBox[{"u", "[", 
     RowBox[{"t", ",", "x"}], "]"}]}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{
    RowBox[{"4", 
     RowBox[{"Dx", "^", "3"}]}], "+", 
    RowBox[{"6", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x"}], "]"}], "**", "Dx"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"Dx", "[", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "x"}], "]"}], "]"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[8]:=",
 CellID->316048883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"DOperator", "[", 
      RowBox[{"L", ",", 
       RowBox[{"f", "[", "x", "]"}]}], "]"}], ",", "t"}], "]"}], "==", 
   RowBox[{"DOperator", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"L", "**", "A"}], "-", 
      RowBox[{"A", "**", "L"}]}], ",", 
     RowBox[{"f", "[", "x", "]"}]}], "]"}]}], "//", "FullSimplify"}]], "Input",\

 CellLabel->"In[9]:=",
 CellID->14191908],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWNtKw0AQ3TaXWq0tXqpFWykoSEEEL28iIoI+iB9RitAiotb+f83mUtaT
k0zSJvhgoNnu7Ow5M7Mzm2RfhrPx6/twNhkN+0/T4ed4MvruP35MPZFVUary
pZTa7ijv/9z75//0NfV+Sp3ouxXJ5n5zBrKur3lMNM9BdphTc927Vz3hRtiu
g9auMW7KW6F8IIxfC+NXwriTaLUpxdk16LehH3m9BfLTjHqXGfUuMurZ0D/w
vVRW0OhLD/pa9kIrxKqGLWJgDDSY7tZC/V/oxB6LYDoCp0uwuwVhoz+Mq1cS
l1MiF/Z3Q5yAqkrQzH71d06QikFf/BmOmUWKzGKWWnSmFfpVEy1hHBjFVTnY
yiHnUcmcGLcyOFnl6W4wEF0uZfEzQMysyBZX8DYln2JSmlFk10dOjkZzJyOa
k2gjXakcqHahqBixHYr+31eUVn1ha0Dru7QVLr6Sl3tG2Ims0po3Rb5sudQS
IpWfN1ueSHawulrNDp5R5duRZ3cp9m0Uc9YV5mu5Nqwh6NkwjjFBO9hb8jK8
zRV5l/V38494i3wuSV9vbCdNG9+HfkPQj9lH4og6EudeFs5Y9UgVLbG2Y6iO
isdf8iUva55ciL5CozpNOneI9KK66oVtM8WXxZ4pf90AaicLakoEWURNfIwY
jbBr7tTBnT3xTFz0qz03vx3xFOhB8HJNsPKm4Pk47gIeej+APj/rKtvLesp4
eV7iKaHvZQ3yPMFDtPA2Za659yqyD94K2OgdzkfvgpPNtzmrWu0He6bdUe06
ld6jvYmaz0Fb+QH03lE+\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{369, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->216924986]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27431100],

Cell[TextData[{
 "Build a function to expand non-commutative products. ",
 "Distributivity with respect to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->258809320],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandNCM", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"h", ":", "NonCommutativeMultiply"}], ")"}], "[", 
    RowBox[{"a___", ",", "b_Plus", ",", "c___"}], "]"}], "]"}], ":=", 
  RowBox[{"Distribute", "[", 
   RowBox[{
    RowBox[{"h", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], ",", "Plus", ",", "h", ",", 
    "Plus", ",", 
    RowBox[{
     RowBox[{"ExpandNCM", "[", 
      RowBox[{"h", "[", "##", "]"}], "]"}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->245175090],

Cell["\<\
Handling the commutative product inside the non-commutative one:\
\>", "ExampleText",
 CellID->158202580],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandNCM", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"h", ":", "NonCommutativeMultiply"}], ")"}], "[", 
    RowBox[{"a___", ",", "b_Times", ",", "c___"}], "]"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Most", "[", "b", "]"}], 
   RowBox[{"ExpandNCM", "[", 
    RowBox[{"h", "[", 
     RowBox[{"a", ",", 
      RowBox[{"Last", "[", "b", "]"}], ",", "c"}], "]"}], "]"}]}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->18540319],

Cell["Fall-back operation applied to everything else:", "ExampleText",
 CellID->484549201],

Cell[BoxData[
 RowBox[{
  RowBox[{"ExpandNCM", "[", "a_", "]"}], ":=", 
  RowBox[{"ExpandAll", "[", "a", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->462224505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNCM", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], "**", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->345973345],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "**", "a"}], "+", 
  RowBox[{"a", "**", "b"}], "-", 
  RowBox[{"b", "**", "a"}], "-", 
  RowBox[{"b", "**", "b"}]}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->266946532]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpandNCM", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->136854550],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "**", "a", "**", "a"}], "+", 
  RowBox[{"a", "**", "a", "**", "b"}], "+", 
  RowBox[{"a", "**", "b", "**", "a"}], "+", 
  RowBox[{"a", "**", "b", "**", "b"}], "+", 
  RowBox[{"b", "**", "a", "**", "a"}], "+", 
  RowBox[{"b", "**", "a", "**", "b"}], "+", 
  RowBox[{"b", "**", "b", "**", "a"}], "+", 
  RowBox[{"b", "**", "b", "**", "b"}]}]], "Output",
 ImageSize->{575, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->212887883]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19984],

Cell[TextData[{
 "No automatic simplification rules exist for ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->366898613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "**", "a"}], ",", 
   RowBox[{"1", "**", "a"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134028759],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"0", "**", "a"}], ",", 
   RowBox[{"1", "**", "a"}]}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->524305201]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->499555621],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " do not operate on expressions with ",
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->181931523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", "c"}], "-", 
  RowBox[{"a", "*", "c"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304866053],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "a"}], " ", "c"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", "c"}]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198504243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->373982319],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "a"}], " ", "c"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", "c"}]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->366450410]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->218269007],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "a"}], " ", "c"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", "c"}]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->915877095]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->41596395],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "a"}], " ", "c"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "+", "b"}], ")"}], "**", "c"}]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->649673110]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19647],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NonCommutativeMultiply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NonCommutativeMultiply"]], "InlineFormula"],
 " of one argument, unlike ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", stays unevaluated:"
}], "ExampleText",
 CellID->355680506],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonCommutativeMultiply", "[", "a", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20080253],

Cell[BoxData[
 RowBox[{"NonCommutativeMultiply", "[", "a", "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172791451]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11160],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cross",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cross"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1405]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NonCommutativeMultiply (**) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 24.9982664}", "context" -> "System`", 
    "keywords" -> {
     "group multiplication", "group operation", "group product", 
      "non-commutative multiplication", "noncommutative multiply"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "a ** b ** c is a general associative, but non-commutative, form of \
multiplication. ", "synonyms" -> {"non commutative multiply", "**"}, "title" -> 
    "NonCommutativeMultiply", "type" -> "Symbol", "uri" -> 
    "ref/NonCommutativeMultiply"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3405, 124, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->628747683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21068, 815}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 714, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1337, 43, 116, 4, 70, "ObjectName",
 CellID->25922],
Cell[1456, 49, 482, 15, 70, "Usage",
 CellID->29040]
}, Open  ]],
Cell[CellGroupData[{
Cell[1975, 69, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2453, 86, 328, 12, 70, "Notes",
 CellID->27401],
Cell[2784, 100, 285, 8, 70, "Notes",
 CellID->15937],
Cell[3072, 110, 296, 9, 70, "Notes",
 CellID->30012]
}, Closed]],
Cell[CellGroupData[{
Cell[3405, 124, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->628747683],
Cell[CellGroupData[{
Cell[3790, 138, 147, 5, 70, "ExampleSection",
 CellID->16872158],
Cell[3940, 145, 122, 3, 70, "ExampleText",
 CellID->867296684],
Cell[CellGroupData[{
Cell[4087, 152, 279, 10, 28, "Input",
 CellID->523260902],
Cell[4369, 164, 289, 10, 36, "Output",
 CellID->51005927]
}, Open  ]],
Cell[4673, 177, 71, 1, 70, "ExampleText",
 CellID->168644701],
Cell[CellGroupData[{
Cell[4769, 182, 246, 9, 28, "Input",
 CellID->56882610],
Cell[5018, 193, 160, 5, 36, "Output",
 CellID->96641984]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5227, 204, 223, 7, 70, "ExampleSection",
 CellID->29411],
Cell[5453, 213, 280, 8, 70, "ExampleText",
 CellID->133361952],
Cell[5736, 223, 254, 9, 70, "ExampleText",
 CellID->48556666],
Cell[5993, 234, 263, 9, 70, "Input",
 CellID->463642272],
Cell[6259, 245, 84, 1, 70, "ExampleText",
 CellID->93648321],
Cell[6346, 248, 341, 11, 70, "Input",
 CellID->202429102],
Cell[6690, 261, 347, 12, 70, "Input",
 CellID->205625045],
Cell[7040, 275, 374, 13, 70, "ExampleText",
 CellID->28204838],
Cell[7417, 290, 313, 11, 70, "Input",
 CellID->327891947],
Cell[7733, 303, 91, 1, 70, "ExampleText",
 CellID->8246866],
Cell[7827, 306, 354, 11, 70, "Input",
 CellID->801910443],
Cell[8184, 319, 89, 1, 70, "ExampleText",
 CellID->166899389],
Cell[8276, 322, 443, 15, 70, "Input",
 CellID->387032813],
Cell[8722, 339, 112, 3, 70, "ExampleText",
 CellID->70115701],
Cell[8837, 344, 186, 7, 70, "Input",
 CellID->214060791],
Cell[9026, 353, 572, 21, 70, "Input",
 CellID->316048883],
Cell[CellGroupData[{
Cell[9623, 378, 457, 16, 70, "Input",
 CellID->14191908],
Cell[10083, 396, 1025, 21, 70, "Output",
 Evaluatable->False,
 CellID->216924986]
}, Open  ]],
Cell[11123, 420, 124, 3, 70, "ExampleDelimiter",
 CellID->27431100],
Cell[11250, 425, 264, 9, 70, "ExampleText",
 CellID->258809320],
Cell[11517, 436, 536, 16, 70, "Input",
 CellID->245175090],
Cell[12056, 454, 115, 3, 70, "ExampleText",
 CellID->158202580],
Cell[12174, 459, 466, 15, 70, "Input",
 CellID->18540319],
Cell[12643, 476, 90, 1, 70, "ExampleText",
 CellID->484549201],
Cell[12736, 479, 166, 5, 70, "Input",
 CellID->462224505],
Cell[CellGroupData[{
Cell[12927, 488, 227, 8, 70, "Input",
 CellID->345973345],
Cell[13157, 498, 297, 10, 36, "Output",
 CellID->266946532]
}, Open  ]],
Cell[CellGroupData[{
Cell[13491, 513, 287, 10, 70, "Input",
 CellID->136854550],
Cell[13781, 525, 521, 14, 36, "Output",
 CellID->212887883]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14351, 545, 233, 7, 70, "ExampleSection",
 CellID->19984],
Cell[14587, 554, 255, 8, 70, "ExampleText",
 CellID->366898613],
Cell[CellGroupData[{
Cell[14867, 566, 165, 6, 70, "Input",
 CellID->134028759],
Cell[15035, 574, 253, 9, 36, "Output",
 CellID->524305201]
}, Open  ]],
Cell[15303, 586, 125, 3, 70, "ExampleDelimiter",
 CellID->499555621],
Cell[15431, 591, 491, 17, 70, "ExampleText",
 CellID->181931523],
Cell[CellGroupData[{
Cell[15947, 612, 188, 7, 70, "Input",
 CellID->304866053],
Cell[16138, 621, 296, 11, 36, "Output",
 CellID->198504243]
}, Open  ]],
Cell[CellGroupData[{
Cell[16471, 637, 102, 3, 70, "Input",
 CellID->373982319],
Cell[16576, 642, 296, 11, 36, "Output",
 CellID->366450410]
}, Open  ]],
Cell[CellGroupData[{
Cell[16909, 658, 104, 3, 70, "Input",
 CellID->218269007],
Cell[17016, 663, 296, 11, 36, "Output",
 CellID->915877095]
}, Open  ]],
Cell[CellGroupData[{
Cell[17349, 679, 107, 3, 70, "Input",
 CellID->41596395],
Cell[17459, 684, 296, 11, 36, "Output",
 CellID->649673110]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17804, 701, 226, 7, 70, "ExampleSection",
 CellID->19647],
Cell[18033, 710, 368, 12, 70, "ExampleText",
 CellID->355680506],
Cell[CellGroupData[{
Cell[18426, 726, 117, 3, 70, "Input",
 CellID->20080253],
Cell[18546, 731, 207, 6, 36, "Output",
 CellID->172791451]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18814, 744, 311, 9, 70, "SeeAlsoSection",
 CellID->11160],
Cell[19128, 755, 673, 26, 70, "SeeAlso",
 CellID->1405]
}, Open  ]],
Cell[19816, 784, 27, 0, 70, "History"],
Cell[19846, 786, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

