(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11456,        408]
NotebookOptionsPosition[      8831,        321]
NotebookOutlinePosition[     10107,        358]
CellTagsIndexPosition[     10023,        353]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Negative" :> Documentation`HelpLookup["paclet:ref/Negative"], 
          "Positive" :> Documentation`HelpLookup["paclet:ref/Positive"], 
          "NonPositive" :> Documentation`HelpLookup["paclet:ref/NonPositive"],
           "Sign" :> Documentation`HelpLookup["paclet:ref/Sign"], "Greater" :> 
          Documentation`HelpLookup["paclet:ref/Greater"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "Assumptions" :> 
          Documentation`HelpLookup["paclet:ref/Assumptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Negative\"\>", 
       2->"\<\"Positive\"\>", 3->"\<\"NonPositive\"\>", 4->"\<\"Sign\"\>", 
       5->"\<\"Greater\"\>", 6->"\<\"Simplify\"\>", 
       7->"\<\"Assumptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NonNegative", "ObjectName",
 CellID->21028],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NonNegative",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NonNegative"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is a non\[Hyphen]negative number. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19661]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NonNegative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonNegative"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is manifestly a negative or complex numerical quantity. Otherwise, it \
remains unevaluated. "
}], "Notes",
 CellID->20790]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151299588],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->381365509],

Cell["Evaluate different types of numbers:", "ExampleText",
 CellID->115213883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonNegative", "[", 
  RowBox[{"{", 
   RowBox[{"1.6", ",", 
    RowBox[{"3", "/", "4"}], ",", "Pi", ",", "0", ",", 
    RowBox[{"-", "5"}], ",", 
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"Sin", "[", 
     RowBox[{"10", "^", "5"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187009233],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "False", ",", "False", 
   ",", "True"}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->868305299]
}, Open  ]],

Cell[TextData[{
 "Quantities that are not ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 " remain unevaluated:"
}], "ExampleText",
 CellID->236549865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NonNegative", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", 
    RowBox[{"Sin", "[", "y", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238276832],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"NonNegative", "[", "x", "]"}], ",", 
   RowBox[{"NonNegative", "[", 
    RowBox[{"Sin", "[", "y", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->648499255]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32719],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Negative",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Negative"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonPositive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonPositive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Greater",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Greater"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Assumptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Assumptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->531382091]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NonNegative - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 26.9514414}", "context" -> "System`", 
    "keywords" -> {
     "non-negative", "non-negative number", "testing if non-negative"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NonNegative[x] gives True if x is a non-negative number. ", 
    "synonyms" -> {"non negative"}, "title" -> "NonNegative", "type" -> 
    "Symbol", "uri" -> "ref/NonNegative"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4186, 136, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->151299588]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9880, 346}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1747, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2370, 65, 49, 1, 70, "ObjectName",
 CellID->21028],
Cell[2422, 68, 703, 23, 70, "Usage",
 CellID->19661]
}, Open  ]],
Cell[CellGroupData[{
Cell[3162, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3640, 113, 509, 18, 70, "Notes",
 CellID->20790]
}, Closed]],
Cell[CellGroupData[{
Cell[4186, 136, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->151299588],
Cell[CellGroupData[{
Cell[4571, 150, 148, 5, 70, "ExampleSection",
 CellID->381365509],
Cell[4722, 157, 79, 1, 70, "ExampleText",
 CellID->115213883],
Cell[CellGroupData[{
Cell[4826, 162, 336, 10, 28, "Input",
 CellID->187009233],
Cell[5165, 174, 284, 9, 36, "Output",
 CellID->868305299]
}, Open  ]],
Cell[5464, 186, 226, 8, 70, "ExampleText",
 CellID->236549865],
Cell[CellGroupData[{
Cell[5715, 198, 186, 6, 28, "Input",
 CellID->238276832],
Cell[5904, 206, 314, 10, 36, "Output",
 CellID->648499255]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6279, 223, 311, 9, 70, "SeeAlsoSection",
 CellID->32719],
Cell[6593, 234, 1678, 62, 70, "SeeAlso",
 CellID->21081]
}, Open  ]],
Cell[CellGroupData[{
Cell[8308, 301, 299, 8, 70, "MoreAboutSection"],
Cell[8610, 311, 149, 3, 70, "MoreAbout",
 CellID->531382091]
}, Open  ]],
Cell[8774, 317, 27, 0, 70, "History"],
Cell[8804, 319, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

