(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46571,       1469]
NotebookOptionsPosition[     39597,       1225]
NotebookOutlinePosition[     41152,       1266]
CellTagsIndexPosition[     41066,       1261]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FRatioDistribution" :> 
          Documentation`HelpLookup["paclet:ref/FRatioDistribution"], 
          "NoncentralChiSquareDistribution" :> 
          Documentation`HelpLookup[
           "paclet:ref/NoncentralChiSquareDistribution"], 
          "NoncentralStudentTDistribution" :> 
          Documentation`HelpLookup[
           "paclet:ref/NoncentralStudentTDistribution"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"FRatioDistribution\"\>", 
       2->"\<\"NoncentralChiSquareDistribution\"\>", 
       3->"\<\"NoncentralStudentTDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NoncentralFRatioDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NoncentralFRatioDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NoncentralFRatioDistribution"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["\[Lambda]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a noncentral ",
     StyleBox["F",
      FontSlant->"Italic"],
     "-ratio distribution with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " numerator degrees of freedom and ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " denominator degrees of freedom and numerator noncentrality parameter ",
     
     Cell[BoxData[
      StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29236]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The noncentral ",
 StyleBox["F",
  FontSlant->"Italic"],
 "-ratio distribution is the distribution of the ratio of a noncentral ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable and a ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Chi]", "2"], TraditionalForm]], "InlineMath"],
 " random variable."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->10357],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralFRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralFRatioDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox["\[Lambda]", "TR"]], "InlineFormula"],
 " to be any positive real numbers."
}], "Notes",
 CellID->28290],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralFRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralFRatioDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6767,
  ButtonNote->"6767"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->859770862],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->316909923],

Cell[TextData[{
 "The mean and variance of a noncentral ",
 StyleBox["F",
  FontSlant->"Italic"],
 "-ratio distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5053],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9V8FOGzEQdXa9m0AIIKBVpV6QeuDWH+CAuLQnbiAhEEhbVAlaVY0oh9xy
gxPKMZ+QYz6BT8hn5DOM7bU33rdj7wYolmJnxuN542d77D3K7q5//snubq6y
3e+3Wf/65urf7re/t1IVtxhjj/K394nJ/0L+079HIWSb17Gq+WAweNJlPp/f
L/TxcDgUurBUVokczBLdbYo2km1kelXLZctlq/SxkW1/7jYvKMe13mPw2nNk
2x+B18iJoDqrjoUwsrZKCtm4CWidsTr0NlgZ2zbYxo7HhRV/RTRxAH2LQg/I
ETE7/j78BaIi+9+ew0AEm014rJ3n/2Ey8cTv07+UOXv2fFjrL+bI5o9m3BR7
lC/0rNzTbH1Jq8jy0YglOhbae0JqKdYwhjJbHi3NHXdtMUNy0NlZYWa1clTQ
oIvp8Y2m0CjPGx5ey0iW6Qhiqt8zPZCx/yvI25X1xHO8Q+Lae3LNRLkHo5Ss
0vRHcvTDu2pXIbYPIP8gR62A1VoNs5n2krM3Ho8nkwnlRd2QxWquwN52a/Ni
wR2Nq3PqoPpjt68D3L36bZJWwSs3ZTkW+efMwe33+6PRiMIls339rBsg150D
EtmbH4TJRWULJZyTaDjP1JGpPJeRXnBfpiDjjqP36TIn4ZfITyVmd8WW/176
rarKDZEaDjtOb7FIHk/5+1C+v02W/KLXQMqmf59E6hgk8nW5ZLTIOR0nZgjM
2ockBr7cuiC3SKwdsMJZonwgqjeR8qE+ghQCjdIlIw7kmOCdYO8lV3fsIBQD
PfwGosG1cc8HY8U9mde4j09E6K5cAjU8e+G8Whw9nSu6ommuqf1e8ePx6XQ6
1GU2m22DXY9cmUvdfgbbVbF4dbj6C22df0uz1jPhjRKw\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18249562]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28505],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WctuEzEUdeaRB2mohKBCPMujIECCPQ+BRNXHgl35gBBA7QIRlS6yC3/Q
ZfiDLrNh1Q2fkM/IZxjbYyeeM3dszwQ6Umbm2tfnXh/b19eTD/2Twy/f+idH
g/7m7nF/eHg0+LG58/1YFMUNxti5+L24zsQ7F2/qd865eNr3WN6T0Wj0R13z
+TwVJalQZqlS0Jd8j8Uz0rXymYhnIp6yPNayqc+Aswvl2IseA+pLSzb1EaBG
lge6Ih6Px1xdrG1MaFlppQtZwzhKrbbK9RZoad0W6MYW4lIrWcGb2GH9LWXd
IUdE75KL4c/hFVn/7zl0ePAmhEdvP/8Pk2mJ/2XldZkza6/M1qvaHJn4EcbN
Yo4my3KWrwkbX1IrMnwEsUT7QqOnZCnFGvqQZ6uklOYusXUxQiZQZnqFkdXI
0YIGdemastaUNQr5dQmveUuG6Qh88s+ZHshY/xzkd4XxxHV8lbTb1P1a014+
hlYH4ibD9AbZ+veFlj4A366B3PTUfyRR74PWmod5XFE+/QPS6j2ilckdWAfW
in0v7n4gt7g1zyohSf6ovXQnqAcmc7FR1YKQt2bRvK8fBg9XahqIp3KY3IrY
C+pHi1sZ2EojQe6RlRBX6YM9BnEehxcjaK2+VEJsal73lUqGP5lMzs7OOLG2
WxrxMpTj6rPXPDP6Ob9kZUc/ty3bS/YeOtiTr12HTUrGiIBcdkC2vRoOh6en
p/J14Gn1nlMz4VOtVn1gsQPydi1bj3i2d+CYdfVoNEjUX/JWyGNMbJLcNnRb
un02euIUyLLrp5qXQrZHs4Df1vjSTrOmb22rVjdgZXnOXeDkM8jrpCU8UyjG
i7t+wdodaPcV5B4vZkVXYA7UQ94KQrkNrXDGrIOMUcGXCWx48Le4tfN5vSOj
dAUZ40HVjAPxkA307wnZK5Nx0OcGXMt0vKdPNHg2p3aC4joxMbp63hLqWy4D
9/iI/SjnsDBSYVw6ZBl/zDkiu+MMkLL9PYrrUV8lXwryysK2YxEjfAxjELmh
z/pBDLrnIbdOqN65eInCXykXDPMQx5jyuD6vmKH513jZlxPnPAlntHpG6vXO
95XOx7p/nZveSNH3DbBHcmHiEEYPMpd17ANd0KeZRx/D5gvKiIK+SEZC4iji
+nJnrMdc3MxrtIv+0b325QW3QN4vR02m0+lYXbPZDPMRZO8myHsgP1W4ttZi
fC2tG1CP3mUo2AcXinzdBfmZQsn+Z2GNv5q6e3E=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{186, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->75168397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3609],

Cell[TextData[{
 "The probability density function of the noncentral ",
 StyleBox["F",
  FontSlant->"Italic"],
 "-ratio distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19854],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[Lambda]"}], "/", "2"}]], " ", 
   SuperscriptBox["m", 
    RowBox[{"m", "/", "2"}]], " ", 
   SuperscriptBox["n", 
    RowBox[{"n", "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", "n"}], ")"}]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"n", " ", "x"}]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "m"}], "-", "n"}], ")"}]}]], " ", 
   RowBox[{"Hypergeometric1F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"m", "+", "n"}], "2"], ",", 
     FractionBox["n", "2"], ",", 
     FractionBox[
      RowBox[{"n", " ", "x", " ", "\[Lambda]"}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"n", " ", "x"}]}], ")"}]}]]}], "]"}]}], 
  RowBox[{"Beta", "[", 
   RowBox[{
    FractionBox["n", "2"], ",", 
    FractionBox["m", "2"]}], "]"}]]], "Output",
 ImageSize->{466, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390098256]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NoncentralFRatioDistribution", "[", 
      RowBox[{"5", ",", "10", ",", "2"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12239],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->669499250]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15492],

Cell[TextData[{
 "Generate a set of pseudorandom numbers that have the noncentral ",
 StyleBox["F",
  FontSlant->"Italic"],
 "-ratio distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"5", ",", "10", ",", "2"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.2201557365630116`", ",", "1.72397992397603`", ",", "0.4914747743911282`",
    ",", "0.9179047446551094`", ",", "1.81653011244456`"}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106740209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23061],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13647],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{428, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11260304]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26727],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{594, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250294845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27896],

Cell[TextData[{
 "The 0.75 quantile of a noncentral ",
 StyleBox["F",
  FontSlant->"Italic"],
 "-ratio distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->21909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"5", ",", "10", ",", "2"}], "]"}], ",", "0.75"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->27841],

Cell[BoxData["2.2201451704373314`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434175944]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7915],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NoncentralFRatioDistribution", "[", 
      RowBox[{"5", ",", "10", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WG9oVlUYP3vv+75zbqvUaWtOW6GF4GYEIn0QIalIsehDKojQGsIG1WRO
zWalpc7UWTnntjKHpMG0DxPFCAwiQRyIA2kQKcgGoh+SwOGHgXD7Peecu3Pu
uc+975/w5X3vPeee3/N7/p9777umsb1504eN7S1NjXVvtDVubm5p2lL3emsb
LnklQogL+H1cLTD2MZK/C76Pc/RYj2MagHk08wgpP6IWh5S+Tmea03JKzz0p
3WBJCYZlLh3SZi6YK7WRK6SD3Cihs7y0xOGt0VZHZYvjf8nhf4bzK8KaYldy
s9dYsh5rYT4218faND9nFvLhb4hhsyvCPnuhyrBr7CmH4WTC1UocT2t7NIbs
HLl+p6V56P79h2lHKlPg/P/KP+7547bPC8cV58t/3O745NdaB+fOuf0had3S
k5m6ihSO/nlPDHBrygxrLRVUgbdxw+DY2L80/MFIZqck8Tl75kb3kSsnYlYn
JiZXvzlgrVp2Kg1b2y8OXx2n4fEE1C8X/+rc93sYNVXxntISz6FQrR+dRy3T
8PsE1Lmh0a5Dl3Oh7t59sO7dn+JRqpaa3v/55t//0PC7kNVUGamBE9eSZJEt
5MzI6rTKj2dJyDl+fPW+8/aP6Fwa9itsaOfJODw8BwKP8MdxZNn4uBy/Xbq1
e9elOI5SJufelH0mu/nK2vOsk/s+hkP6Hb3isFDG+iO5yFo5jeo1Wexjc62s
h3twkoa9oTqZ5sS/N4HDdEgSysSSRymNarOg4bFYFEUjbG2Z4zEvW+Z43JOA
Mp4noYznPSF7pjse8xzTnfo4moBSe51BRXrS7Kl6wa0KxWN2D81TUEeVy7nZ
W7oZDqrftD6TaLnOGKfPrnXOZqUPyqAyTl/G57ugQs7hLFym4ZGCZRFwhN2S
tWLu9r4bKcWAxCK9hiGojyfkqtkhv2UzXynnuCXgxpALZWqfRymN5p76TSyK
cmU4yNonncrhZRXKVPPXCShzp0tCoX8QosnJRzEoNcfzA54iaHg4ZPUMJy6H
WQ6FMhXdFcm0m1muXhSL6dEuptZy7/QzHK+LY5nph2v3UN4sRKKkUZawIUna
Y6Iwy8nHQUY215Ov4jAdfzCSj1KdX1eyytF+gM13lcNvUMQ5x+H4iuWY7et+
QDtRnnjUHCcP+xNQiDd6i7h41NNyfvrUSH/fMA07Q1ar91ZTw/tYjmo/3A88
SnFBDZTRcG8CCvYiAohDDKom0IhNgXzbE7JavUuYnvmS5VAoczf+IlIP+fRn
bWAvLKF3Ec1SYGfNC/KOCJLXu/NmIZL5gTQShR4XuxjpuPvRs76uWthPsp8X
ZX9dwKLt/6wolufkHLcRsIBLfBrJSNxz6fO+rnVIosHEzlA9LJCr8A6vZag/
0cHWw0JfdwI4YIPYwaJekF4g04g1uJD47SzuRYnDMghRyjBqG4tbJHGIGbYG
dYdrD9m+WK6ruz2+eOVoY3nkvzcZ4PBGgoaHVkRDtLJY+e9XFjrhADZj0KIF
EJ4PWPTLEg1mtAoeOoFGZ1GpsuildCgFGr0HO0APg3BTpt7YFPLsFZqVwUr4
hFs2or5ieT+OGEMBGMR7rIbldKgAH1ihBPZAThkGC/GIAT5Ig3i9VWbBx32T
4qrpVTqUIyCgQWRACR9AD2egCl5hjFIS9Dwj0spYfGHSW1KVq8PLWfmrfN3B
oBm+Oq6ZlXf4IioeNMs3DHVFpOhAuymQBCYJCrvsQs26rEhr1gb9ovwSKcmL
krJ1Sf1oAthFpmWkfa+tPK7tq5Dr8EDLVOGQdezzCrCPALKaaa/VdlVIPsTf
1hHoLUJH9N/DYuW4PWtQXor+Yy5K/gMNGdzT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214519728]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19285],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NoncentralFRatioDistribution", "[", 
      RowBox[{"3", ",", "6", ",", "2"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24008],

Cell[BoxData["1.0000000000000069`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->801859206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7523],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NoncentralFRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralFRatioDistribution"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    StyleBox["m", "TI"], ",", "0"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FRatioDistribution"], "[", 
   StyleBox[
    RowBox[{"n", ",", "m"}], "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->26364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"n", ",", "m", ",", "0"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1411],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["m", 
    RowBox[{"m", "/", "2"}]], " ", 
   SuperscriptBox["n", 
    RowBox[{"n", "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["n", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"n", " ", "x"}]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "m"}], "-", "n"}], ")"}]}]]}], 
  RowBox[{"Beta", "[", 
   RowBox[{
    FractionBox["n", "2"], ",", 
    FractionBox["m", "2"]}], "]"}]]], "Output",
 ImageSize->{186, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->39250355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"FRatioDistribution", "[", 
    RowBox[{"n", ",", "m"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["m", 
    RowBox[{"m", "/", "2"}]], " ", 
   SuperscriptBox["n", 
    RowBox[{"n", "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["n", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"m", "+", 
      RowBox[{"n", " ", "x"}]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "m"}], "-", "n"}], ")"}]}]]}], 
  RowBox[{"Beta", "[", 
   RowBox[{
    FractionBox["n", "2"], ",", 
    FractionBox["m", "2"]}], "]"}]]], "Output",
 ImageSize->{186, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252362992]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(4)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23483],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralFRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralFRatioDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->21766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{
    RowBox[{"5", "+", "I"}], ",", "8", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16141],

Cell[BoxData[
 RowBox[{
  RowBox[{"NoncentralFRatioDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(5 + \[ImaginaryI]\\) is expected to be \
positive.\"\>"}]], "Message", "MSG",
 CellID->152467365],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{
    RowBox[{"5", "+", "\[ImaginaryI]"}], ",", "8", ",", "2"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{320, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->462160254]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10506],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralFRatioDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralFRatioDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  FormBox[
   StyleBox["\[Lambda]", "TR"], TraditionalForm]], "InlineMath"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{"5", ",", "8", ",", 
    RowBox[{"-", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23256],

Cell[BoxData[
 RowBox[{
  RowBox[{"NoncentralFRatioDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-2\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->207474032],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralFRatioDistribution", "[", 
   RowBox[{"5", ",", "8", ",", 
    RowBox[{"-", "2"}]}], "]"}], "]"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229110235]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5857],

Cell[TextData[{
 "The characteristic function of a noncentral ",
 StyleBox["F",
  FontSlant->"Italic"],
 "-ratio distribution has no closed-form representation:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->22678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14199],

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], ",", "t"}], 
  "]"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233371366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"NoncentralFRatioDistribution", "[", 
    RowBox[{"n", ",", "m", ",", "\[Lambda]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "\[Rule]", 
     RowBox[{"3", "+", "I"}]}], ",", 
    RowBox[{"m", "\[Rule]", "10"}], ",", 
    RowBox[{"\[Lambda]", "\[Rule]", "5"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  FractionBox["25", "8"], "-", 
  FractionBox[
   RowBox[{"5", " ", "\[ImaginaryI]"}], "8"]}]], "Output",
 ImageSize->{57, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285638595]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18725],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FRatioDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NoncentralChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralChiSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NoncentralStudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralStudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8996]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->985],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->112826479]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NoncentralFRatioDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 23.7326090}", "context" -> "System`", 
    "keywords" -> {
     "noncentral F distribution", "noncentral Fisher's F distribution", 
      "noncentral F ratio distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NoncentralFRatioDistribution[n, m, \\[Lambda]] represents a noncentral \
F-ratio distribution with n numerator degrees of freedom and m denominator \
degrees of freedom and numerator noncentrality parameter \\[Lambda].", 
    "synonyms" -> {"noncentral ratio distribution"}, "title" -> 
    "NoncentralFRatioDistribution", "type" -> "Symbol", "uri" -> 
    "ref/NoncentralFRatioDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7754, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->859770862]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 40923, 1254}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 83, 1593, 37, 70, "ObjectNameGrid"],
Cell[4451, 122, 1026, 31, 70, "Usage",
 CellID->29236]
}, Open  ]],
Cell[CellGroupData[{
Cell[5514, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5992, 175, 553, 18, 70, "Notes",
 CellID->10357],
Cell[6548, 195, 450, 16, 70, "Notes",
 CellID->28290],
Cell[7001, 213, 716, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7754, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->859770862],
Cell[CellGroupData[{
Cell[8139, 258, 148, 5, 70, "ExampleSection",
 CellID->316909923],
Cell[8290, 265, 340, 11, 70, "ExampleText",
 CellID->6767],
Cell[CellGroupData[{
Cell[8655, 280, 192, 5, 28, "Input",
 CellID->5053],
Cell[8850, 287, 1109, 22, 60, "Output",
 Evaluatable->False,
 CellID->18249562]
}, Open  ]],
Cell[CellGroupData[{
Cell[9996, 314, 197, 5, 28, "Input",
 CellID->28505],
Cell[10196, 321, 1471, 28, 68, "Output",
 Evaluatable->False,
 CellID->75168397]
}, Open  ]],
Cell[11682, 352, 120, 3, 70, "ExampleDelimiter",
 CellID->3609],
Cell[11805, 357, 306, 10, 70, "ExampleText",
 CellID->13924],
Cell[CellGroupData[{
Cell[12136, 371, 220, 7, 70, "Input",
 CellID->19854],
Cell[12359, 380, 1252, 44, 76, "Output",
 CellID->390098256]
}, Open  ]],
Cell[CellGroupData[{
Cell[13648, 429, 331, 10, 28, "Input",
 CellID->12239],
Cell[13982, 441, 2864, 51, 165, "Output",
 Evaluatable->False,
 CellID->669499250]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16895, 498, 216, 7, 70, "ExampleSection",
 CellID->15492],
Cell[17114, 507, 319, 10, 70, "ExampleText",
 CellID->16499],
Cell[CellGroupData[{
Cell[17458, 521, 217, 6, 70, "Input",
 CellID->18175],
Cell[17678, 529, 327, 9, 36, "Output",
 CellID->106740209]
}, Open  ]],
Cell[18020, 541, 121, 3, 70, "ExampleDelimiter",
 CellID->23061],
Cell[18144, 546, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[18268, 553, 197, 5, 70, "Input",
 CellID->13647],
Cell[18468, 560, 2211, 40, 70, "Output",
 Evaluatable->False,
 CellID->11260304]
}, Open  ]],
Cell[CellGroupData[{
Cell[20716, 605, 197, 5, 70, "Input",
 CellID->26727],
Cell[20916, 612, 3481, 61, 70, "Output",
 Evaluatable->False,
 CellID->250294845]
}, Open  ]],
Cell[24412, 676, 121, 3, 70, "ExampleDelimiter",
 CellID->27896],
Cell[24536, 681, 289, 10, 70, "ExampleText",
 CellID->21909],
Cell[CellGroupData[{
Cell[24850, 695, 220, 7, 70, "Input",
 CellID->27841],
Cell[25073, 704, 176, 5, 36, "Output",
 CellID->434175944]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25298, 715, 222, 7, 70, "ExampleSection",
 CellID->7915],
Cell[25523, 724, 249, 7, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[25797, 735, 331, 10, 70, "Input",
 CellID->12368],
Cell[26131, 747, 2079, 38, 70, "Output",
 Evaluatable->False,
 CellID->214519728]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28259, 791, 233, 7, 70, "ExampleSection",
 CellID->19285],
Cell[28495, 800, 228, 5, 70, "ExampleText",
 CellID->9729],
Cell[CellGroupData[{
Cell[28748, 809, 345, 10, 70, "Input",
 CellID->24008],
Cell[29096, 821, 176, 5, 36, "Output",
 CellID->801859206]
}, Open  ]],
Cell[29287, 829, 120, 3, 70, "ExampleDelimiter",
 CellID->7523],
Cell[29410, 834, 696, 23, 70, "ExampleText",
 CellID->26364],
Cell[CellGroupData[{
Cell[30131, 861, 208, 6, 70, "Input",
 CellID->1411],
Cell[30342, 869, 745, 28, 69, "Output",
 CellID->39250355]
}, Open  ]],
Cell[CellGroupData[{
Cell[31124, 902, 187, 6, 70, "Input",
 CellID->250],
Cell[31314, 910, 746, 28, 69, "Output",
 CellID->252362992]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32109, 944, 327, 9, 70, "ExampleSection",
 CellID->23483],
Cell[32439, 955, 530, 17, 70, "ExampleText",
 CellID->21766],
Cell[CellGroupData[{
Cell[32994, 976, 210, 6, 70, "Input",
 CellID->16141],
Cell[33207, 984, 224, 5, 70, "Message",
 CellID->152467365],
Cell[33434, 991, 318, 10, 36, "Output",
 CellID->462160254]
}, Open  ]],
Cell[33767, 1004, 121, 3, 70, "ExampleDelimiter",
 CellID->10506],
Cell[33891, 1009, 498, 15, 70, "ExampleText",
 CellID->9088],
Cell[CellGroupData[{
Cell[34414, 1028, 205, 6, 70, "Input",
 CellID->23256],
Cell[34622, 1036, 209, 5, 70, "Message",
 CellID->207474032],
Cell[34834, 1043, 298, 9, 36, "Output",
 CellID->229110235]
}, Open  ]],
Cell[35147, 1055, 120, 3, 70, "ExampleDelimiter",
 CellID->5857],
Cell[35270, 1060, 333, 10, 70, "ExampleText",
 CellID->22678],
Cell[CellGroupData[{
Cell[35628, 1074, 239, 7, 70, "Input",
 CellID->14199],
Cell[35870, 1083, 332, 10, 36, "Output",
 CellID->233371366]
}, Open  ]],
Cell[36217, 1096, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[36341, 1101, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[36647, 1113, 404, 12, 70, "Input",
 CellID->25838],
Cell[37054, 1127, 259, 9, 51, "Output",
 CellID->285638595]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37374, 1143, 311, 9, 70, "SeeAlsoSection",
 CellID->18725],
Cell[37688, 1154, 805, 26, 70, "SeeAlso",
 CellID->8996]
}, Open  ]],
Cell[CellGroupData[{
Cell[38530, 1185, 312, 9, 70, "TutorialsSection",
 CellID->985],
Cell[38845, 1196, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[39039, 1204, 299, 8, 70, "MoreAboutSection"],
Cell[39341, 1214, 184, 4, 70, "MoreAbout",
 CellID->112826479]
}, Open  ]],
Cell[39540, 1221, 27, 0, 70, "History"],
Cell[39570, 1223, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

