(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     49919,       1566]
NotebookOptionsPosition[     43009,       1324]
NotebookOutlinePosition[     44527,       1365]
CellTagsIndexPosition[     44441,       1360]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTDistribution" :> 
          Documentation`HelpLookup["paclet:ref/StudentTDistribution"], 
          "NoncentralChiSquareDistribution" :> 
          Documentation`HelpLookup[
           "paclet:ref/NoncentralChiSquareDistribution"], 
          "NoncentralFRatioDistribution" :> 
          Documentation`HelpLookup[
           "paclet:ref/NoncentralFRatioDistribution"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StudentTDistribution\"\>", 
       2->"\<\"NoncentralChiSquareDistribution\"\>", 
       3->"\<\"NoncentralFRatioDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NoncentralStudentTDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NoncentralStudentTDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NoncentralStudentTDistribution"], "[", 
       RowBox[{
        StyleBox["\[Nu]", "TR"], ",", 
        StyleBox["\[Delta]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a noncentral Student ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with ",
     Cell[BoxData[
      StyleBox["\[Nu]", "TR"]], "InlineFormula"],
     " degrees of freedom and noncentrality parameter ",
     Cell[BoxData[
      StyleBox["\[Delta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralStudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " to be any positive real number and ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 " to be any real number."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->5939],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralStudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6336,
  ButtonNote->"6336"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->272296441],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->100544509],

Cell[TextData[{
 "The mean and variance of a noncentral Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution depend on the ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32621],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      RowBox[{"\[Delta]", " ", 
       SqrtBox["\[Nu]"], " ", 
       RowBox[{"Gamma", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}], "]"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["\[Nu]", "2"], "]"}]}]], 
     RowBox[{"\[Nu]", ">", "1"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{163, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440918847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26034],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["\[Delta]", "2"]}], ")"}], " ", "\[Nu]"}], 
       RowBox[{
        RowBox[{"-", "2"}], "+", "\[Nu]"}]], "-", 
      FractionBox[
       RowBox[{
        SuperscriptBox["\[Delta]", "2"], " ", "\[Nu]", " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", "\[Nu]"}], ")"}]}], "]"}], "2"]}], 
       RowBox[{"2", " ", 
        SuperscriptBox[
         RowBox[{"Gamma", "[", 
          FractionBox["\[Nu]", "2"], "]"}], "2"]}]]}], 
     RowBox[{"\[Nu]", ">", "2"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{213, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218880153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21358],

Cell[TextData[{
 "The probability density function of the noncentral Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution depends on both the ",
 Cell[BoxData[
  ButtonBox["Hypergeometric1F1",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Hypergeometric1F1"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28469],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"Gamma", "[", 
    FractionBox["\[Nu]", "2"], "]"}]], 
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{"-", "\[Nu]"}]], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      SuperscriptBox["\[Delta]", "2"], "2"]}]], " ", 
   SuperscriptBox["\[Nu]", 
    RowBox[{"\[Nu]", "/", "2"}]], " ", 
   RowBox[{"\[Nu]", "!"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       SqrtBox["2"], " ", "x", " ", "\[Delta]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", "\[Nu]"}], ")"}], 
        RowBox[{
         RowBox[{"-", "1"}], "-", 
         FractionBox["\[Nu]", "2"]}]], " ", 
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{
         RowBox[{"1", "+", 
          FractionBox["\[Nu]", "2"]}], ",", 
         FractionBox["3", "2"], ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["\[Delta]", "2"]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", "\[Nu]"}], ")"}]}]]}], "]"}]}], 
      RowBox[{"Gamma", "[", 
       FractionBox[
        RowBox[{"1", "+", "\[Nu]"}], "2"], "]"}]], "+", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["x", "2"], "+", "\[Nu]"}], ")"}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "2"]}], "-", 
         FractionBox["\[Nu]", "2"]}]], " ", 
       RowBox[{"Hypergeometric1F1", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "+", "\[Nu]"}], "2"], ",", 
         FractionBox["1", "2"], ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox["x", "2"], " ", 
           SuperscriptBox["\[Delta]", "2"]}], 
          RowBox[{"2", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["x", "2"], "+", "\[Nu]"}], ")"}]}]]}], "]"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", 
        FractionBox["\[Nu]", "2"]}], "]"}]]}], ")"}]}]}]], "Output",
 ImageSize->{541, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283270614]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NoncentralStudentTDistribution", "[", 
      RowBox[{"3", ",", "5"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28504],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4106517]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23105],

Cell[TextData[{
 "Generate a set of pseudorandom numbers that have the noncentral Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"5", ",", "2"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6348608639144389`", ",", "1.1972240206090605`", ",", 
   "2.288925410701033`", ",", "0.8383640653704926`", ",", 
   "2.0533185435843095`"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6201396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12516],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14481],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->618521660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1727],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{520, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->613598453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31313],

Cell[TextData[{
 "The 0.75 quantile of a noncentral Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->10382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"5", ",", "2"}], "]"}], ",", "0.75"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6140],

Cell[BoxData["3.0968891239639604`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73364138]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5589],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NoncentralStudentTDistribution", "[", 
      RowBox[{"3", ",", "2"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520021495]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28733],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NoncentralStudentTDistribution", "[", 
      RowBox[{"5", ",", "3"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160814443],

Cell[BoxData["0.9999999999755175`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21825864]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->344091268],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["NoncentralStudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralStudentTDistribution"], "[", 
   RowBox[{
    StyleBox["\[Nu]", "TR"], ",", "0"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"], "[", 
   StyleBox["\[Nu]", "TR"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->27441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"\[Nu]", ",", "0"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6648],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["\[Nu]", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "\[Nu]"}]], ")"}], 
   FractionBox[
    RowBox[{"1", "+", "\[Nu]"}], "2"]], 
  RowBox[{
   SqrtBox["\[Nu]"], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{
     FractionBox["\[Nu]", "2"], ",", 
     FractionBox["1", "2"]}], "]"}]}]]], "Output",
 ImageSize->{109, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13631351]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27834],

Cell[BoxData[
 FractionBox[
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["\[Nu]", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", "\[Nu]"}]], ")"}], 
   FractionBox[
    RowBox[{"1", "+", "\[Nu]"}], "2"]], 
  RowBox[{
   SqrtBox["\[Nu]"], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{
     FractionBox["\[Nu]", "2"], ",", 
     FractionBox["1", "2"]}], "]"}]}]]], "Output",
 ImageSize->{109, 58},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208054001]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(4)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31441],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralStudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Nu]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{
    RowBox[{"-", "3"}], ",", "\[Delta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32668],

Cell[BoxData[
 RowBox[{
  RowBox[{"NoncentralStudentTDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-3\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->288410706],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{
    RowBox[{"-", "3"}], ",", "\[Delta]"}], "]"}], "]"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195518240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5137],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NoncentralStudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NoncentralStudentTDistribution"]], 
  "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Delta]", "TR"]], "InlineFormula"],
 " is not a real number:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->20633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{"\[Nu]", ",", 
    RowBox[{"5", "+", "I"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3241],

Cell[BoxData[
 RowBox[{
  RowBox[{"NoncentralStudentTDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(5 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->65326563],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NoncentralStudentTDistribution", "[", 
   RowBox[{"\[Nu]", ",", 
    RowBox[{"5", "+", "\[ImaginaryI]"}]}], "]"}], "]"}]], "Output",
 ImageSize->{316, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124172069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31015],

Cell[TextData[{
 "The characteristic function of a noncentral Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution has no closed-form representation:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->22974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19252],

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], ",", "t"}], "]"}]], "Output",
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9275852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"NoncentralStudentTDistribution", "[", 
    RowBox[{"\[Nu]", ",", "\[Delta]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Nu]", "\[Rule]", 
     RowBox[{"1", "+", "I"}]}], ",", 
    RowBox[{"\[Delta]", "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  RowBox[{"Greater", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(1 + \[ImaginaryI]\\) attempted. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Greater::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->249771199],

Cell[BoxData[
 RowBox[{"\[Piecewise]", GridBox[{
    {
     FractionBox[
      RowBox[{
       SqrtBox[
        RowBox[{"2", "+", 
         RowBox[{"2", " ", "\[ImaginaryI]"}]}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["\[ImaginaryI]", "2"], "]"}]}], 
      RowBox[{"Gamma", "[", 
       RowBox[{
        FractionBox["1", "2"], "+", 
        FractionBox["\[ImaginaryI]", "2"]}], "]"}]], 
     RowBox[{
      RowBox[{"1", "+", "\[ImaginaryI]"}], ">", "1"}]},
    {"Indeterminate", 
     TagBox["True",
      "PiecewiseDefault",
      AutoDelete->False,
      DeletionWarning->True]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxItemSize->{
    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.84]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}]}]], "Output",
 ImageSize->{166, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597388284]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21419],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NoncentralChiSquareDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralChiSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NoncentralFRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NoncentralFRatioDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24007]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9290],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->118479912]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NoncentralStudentTDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 24.3888758}", "context" -> "System`", 
    "keywords" -> {
     "noncentral Student's t distribution", 
      "noncentral Student t distribution", "noncentral t distribution"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NoncentralStudentTDistribution[\\[Nu], \\[Delta]] represents a \
noncentral Student t distribution with \\[Nu] degrees of freedom and \
noncentrality parameter \\[Delta].", 
    "synonyms" -> {"noncentral student distribution"}, "title" -> 
    "NoncentralStudentTDistribution", "type" -> "Symbol", "uri" -> 
    "ref/NoncentralStudentTDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7170, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->272296441]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44298, 1353}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 83, 1595, 37, 70, "ObjectNameGrid"],
Cell[4453, 122, 885, 26, 70, "Usage",
 CellID->21856]
}, Open  ]],
Cell[CellGroupData[{
Cell[5375, 153, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5853, 170, 554, 18, 70, "Notes",
 CellID->5939],
Cell[6410, 190, 723, 27, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7170, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->272296441],
Cell[CellGroupData[{
Cell[7555, 236, 148, 5, 70, "ExampleSection",
 CellID->100544509],
Cell[7706, 243, 510, 16, 70, "ExampleText",
 CellID->6336],
Cell[CellGroupData[{
Cell[8241, 263, 188, 5, 28, "Input",
 CellID->32621],
Cell[8432, 270, 1267, 40, 80, "Output",
 CellID->440918847]
}, Open  ]],
Cell[CellGroupData[{
Cell[9736, 315, 192, 5, 28, "Input",
 CellID->26034],
Cell[9931, 322, 1579, 49, 76, "Output",
 CellID->218880153]
}, Open  ]],
Cell[11525, 374, 121, 3, 70, "ExampleDelimiter",
 CellID->21358],
Cell[11649, 379, 685, 21, 70, "ExampleText",
 CellID->1436],
Cell[CellGroupData[{
Cell[12359, 404, 212, 6, 70, "Input",
 CellID->28469],
Cell[12574, 412, 2295, 73, 165, "Output",
 CellID->283270614]
}, Open  ]],
Cell[CellGroupData[{
Cell[14906, 490, 322, 10, 28, "Input",
 CellID->28504],
Cell[15231, 502, 2508, 45, 134, "Output",
 Evaluatable->False,
 CellID->4106517]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17788, 553, 216, 7, 70, "ExampleSection",
 CellID->23105],
Cell[18007, 562, 338, 10, 70, "ExampleText",
 CellID->1238],
Cell[CellGroupData[{
Cell[18370, 576, 208, 6, 70, "Input",
 CellID->15032],
Cell[18581, 584, 332, 10, 36, "Output",
 CellID->6201396]
}, Open  ]],
Cell[18928, 597, 121, 3, 70, "ExampleDelimiter",
 CellID->12516],
Cell[19052, 602, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[19176, 609, 192, 5, 70, "Input",
 CellID->14481],
Cell[19371, 616, 3477, 61, 70, "Output",
 Evaluatable->False,
 CellID->618521660]
}, Open  ]],
Cell[CellGroupData[{
Cell[22885, 682, 191, 5, 70, "Input",
 CellID->1727],
Cell[23079, 689, 3836, 67, 70, "Output",
 Evaluatable->False,
 CellID->613598453]
}, Open  ]],
Cell[26930, 759, 121, 3, 70, "ExampleDelimiter",
 CellID->31313],
Cell[27054, 764, 309, 10, 70, "ExampleText",
 CellID->10382],
Cell[CellGroupData[{
Cell[27388, 778, 208, 6, 70, "Input",
 CellID->6140],
Cell[27599, 786, 175, 5, 36, "Output",
 CellID->73364138]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27823, 797, 222, 7, 70, "ExampleSection",
 CellID->5589],
Cell[28048, 806, 249, 7, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[28322, 817, 322, 10, 70, "Input",
 CellID->12368],
Cell[28647, 829, 2226, 41, 70, "Output",
 Evaluatable->False,
 CellID->520021495]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30922, 876, 233, 7, 70, "ExampleSection",
 CellID->28733],
Cell[31158, 885, 228, 5, 70, "ExampleText",
 CellID->9228],
Cell[CellGroupData[{
Cell[31411, 894, 366, 11, 70, "Input",
 CellID->160814443],
Cell[31780, 907, 175, 5, 36, "Output",
 CellID->21825864]
}, Open  ]],
Cell[31970, 915, 125, 3, 70, "ExampleDelimiter",
 CellID->344091268],
Cell[32098, 920, 656, 21, 70, "ExampleText",
 CellID->27441],
Cell[CellGroupData[{
Cell[32779, 945, 204, 6, 70, "Input",
 CellID->6648],
Cell[32986, 953, 511, 19, 79, "Output",
 CellID->13631351]
}, Open  ]],
Cell[CellGroupData[{
Cell[33534, 977, 173, 6, 70, "Input",
 CellID->27834],
Cell[33710, 985, 512, 19, 79, "Output",
 CellID->208054001]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34271, 1010, 327, 9, 70, "ExampleSection",
 CellID->31441],
Cell[34601, 1021, 474, 15, 70, "ExampleText",
 CellID->8872],
Cell[CellGroupData[{
Cell[35100, 1040, 204, 6, 70, "Input",
 CellID->32668],
Cell[35307, 1048, 211, 5, 70, "Message",
 CellID->288410706],
Cell[35521, 1055, 297, 9, 36, "Output",
 CellID->195518240]
}, Open  ]],
Cell[35833, 1067, 120, 3, 70, "ExampleDelimiter",
 CellID->5137],
Cell[35956, 1072, 469, 15, 70, "ExampleText",
 CellID->20633],
Cell[CellGroupData[{
Cell[36450, 1091, 205, 6, 70, "Input",
 CellID->3241],
Cell[36658, 1099, 222, 5, 70, "Message",
 CellID->65326563],
Cell[36883, 1106, 311, 9, 36, "Output",
 CellID->124172069]
}, Open  ]],
Cell[37209, 1118, 121, 3, 70, "ExampleDelimiter",
 CellID->31015],
Cell[37333, 1123, 353, 10, 70, "ExampleText",
 CellID->22974],
Cell[CellGroupData[{
Cell[37711, 1137, 231, 6, 70, "Input",
 CellID->19252],
Cell[37945, 1145, 322, 9, 36, "Output",
 CellID->9275852]
}, Open  ]],
Cell[38282, 1157, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[38406, 1162, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[38712, 1174, 360, 11, 70, "Input",
 CellID->25838],
Cell[39075, 1187, 385, 7, 70, "Message",
 CellID->249771199],
Cell[39463, 1196, 1260, 39, 78, "Output",
 CellID->597388284]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40784, 1242, 311, 9, 70, "SeeAlsoSection",
 CellID->21419],
Cell[41098, 1253, 806, 26, 70, "SeeAlso",
 CellID->24007]
}, Open  ]],
Cell[CellGroupData[{
Cell[41941, 1284, 313, 9, 70, "TutorialsSection",
 CellID->9290],
Cell[42257, 1295, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[42451, 1303, 299, 8, 70, "MoreAboutSection"],
Cell[42753, 1313, 184, 4, 70, "MoreAbout",
 CellID->118479912]
}, Open  ]],
Cell[42952, 1320, 27, 0, 70, "History"],
Cell[42982, 1322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

