(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     45587,       1625]
NotebookOptionsPosition[     37247,       1333]
NotebookOutlinePosition[     38671,       1372]
CellTagsIndexPosition[     38585,       1367]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LogicalExpand" :> 
          Documentation`HelpLookup["paclet:ref/LogicalExpand"], "Or" :> 
          Documentation`HelpLookup["paclet:ref/Or"], "Xor" :> 
          Documentation`HelpLookup["paclet:ref/Xor"], "Nand" :> 
          Documentation`HelpLookup["paclet:ref/Nand"], "Not" :> 
          Documentation`HelpLookup["paclet:ref/Not"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LogicalExpand\"\>", 2->"\<\"Or\"\>", 
       3->"\<\"Xor\"\>", 4->"\<\"Nand\"\>", 
       5->"\<\"Not\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Nor", "ObjectName",
 CellID->1030],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Nor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Nor"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["e", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the logical NOR function. It evaluates its arguments \
in order, giving ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " immediately if any of them are ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if they are all ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18249]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " can be input in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[Nor]", 
    SubscriptBox["e", "2"], "\[Nor]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 ". The character ",
 Cell[BoxData["\[Nor]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]nor\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Nor]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Nor"]], "InlineCharacterName"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->8119997]
}], "Notes",
 CellID->21375],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"], "[", 
   RowBox[{
    ButtonBox["Or",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Or"], "[", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->288385943]
}], "Notes",
 CellID->1425],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ", and explicitly controls the evaluation of its arguments. In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nor"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["e", "i"], TraditionalForm]], "InlineMath"],
 " are evaluated in order, stopping if any of them is found to be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->76232233]
}], "Notes",
 CellID->8493],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " gives symbolic results when necessary, removing initial arguments that are \
",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22291],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " is not ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->619085734],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->61728939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nor", "[", 
  RowBox[{"True", ",", "False"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178169843],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43080777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37477389],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]nor\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->8119997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "\[Nor]", "q"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162312622],

Cell[BoxData[
 RowBox[{"p", "\[Nor]", "q"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84289971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->251724513],

Cell["Nor[p, q]", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->1453032]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8513],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " with explicit ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " arguments will simplify:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18400621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nor", "[", 
  RowBox[{"x", ",", "True", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534512268],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29495578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nor", "[", 
  RowBox[{"x", ",", "False", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->599319570],

Cell[BoxData[
 RowBox[{"x", "\[Nor]", "z"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11316329]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39071304],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " evaluates its arguments in order, stopping when an argument evaluates to \
",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->76232233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "True"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->201736223],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->1057752593],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159950443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "1", "]"}], ";", "False"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "2", "]"}], ";", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200768372],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->644244816],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[6]:=",
 CellID->153816993]
}, Open  ]],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261207483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->375923361],

Cell[TextData[{
 "Symbolic transformations may not preserve argument ordering or ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " operations:"
}], "ExampleText",
 CellID->531520307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z", "\[Nor]", 
  RowBox[{"!", "x"}], "\[Nor]", 
  RowBox[{"!", "y"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18042936],

Cell[BoxData[
 RowBox[{"z", "\[Nor]", 
  RowBox[{"!", "x"}], "\[Nor]", 
  RowBox[{"!", "y"}]}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101212442]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->172565786],

Cell[BoxData[
 RowBox[{"x", "&&", "y", "&&", 
  RowBox[{"!", "z"}]}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147578023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63290867],

Cell["TraditionalForm formatting:", "ExampleText",
 CellID->37738970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Nor", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344385729],

Cell[BoxData[
 FormBox[
  RowBox[{"x", "\[Nor]", "y", "\[Nor]", "z"}], TraditionalForm]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->207579512]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23750],

Cell[TextData[{
 "Find the ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " of two regions:"
}], "ExampleText",
 CellID->37965020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Nor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], ">", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->958192352],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233686955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103158259],

Cell[TextData[{
 "A cellular automaton based on ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12039839],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"CellularAutomaton", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Nor", "@@", "#"}], "&"}], ",", 
       RowBox[{"{", "}"}]}], "}"}], ",", 
     RowBox[{"RandomChoice", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"True", ",", "False"}], "}"}], ",", "40"}], "]"}], ",", 
     "20"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40098381],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmEEKwjAQRROagAGz6EJRF6Wn0ZWHiEVoF6LUHqwL76e/ZSrdKQp2IhNI
fiad+YHOW2UfmvJ4Ck1VhHxXh0tZFdd8e65xlGil1A3zsFLY37HrZ3eEkXT7
fqgWi/7q1GHxCD00JV1CU4oXFM+l2jyrMQzlWOiaNIPOoBvyzijP/KdHvJ0U
Drh5xEuDsCQcCAccPeKlQVgSDqau5tI9Lh7xdlI4EA6mrubSPS4e8XZSOODm
ES8NwtIPOOiyHOkQ21G1pb88xI5u96Pvr3smt7xzy2fv9fTurx8Jha15\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304516984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12625347],

Cell[TextData[{
 "Simplify trees of ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 "'s:"
}], "ExampleText",
 CellID->170940585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Nor", "[", 
     RowBox[{"#", ",", "#"}], "]"}], "&"}], ",", "p", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->327147365],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttuEzEQdbJNNjSkSgtICCRUvgN4AQFP/YioQmofqqISeAG+iU9c1s5u
sp2d8YxvJF0cKRc74/Hx8dhr+czFan315Wa1vr5cnX++W329ur78dv7p9q6u
KkZKjU+UUq+fq/p3Vf8y7/a1rN9Kfag/i7r6Dfhu698T/380rR/rz2LrVR1Z
yvWnGtfvZeNhAmxnpsGurNTcoTXs2e6NwnZKeC9F2KjWNlbcsWZepbxC+8L4
FHE76a4UjeOM8V2irR55+YKILL5Z3E+YvqYOuDlf3Hw4jCPPhwB36HxA+7Hx
e+zoRbfSS1gjL5rvI2S14iObEd7KarfmMW8Qhcw7hb3tjcI+8cJOeeMY9RtL
npfU84Kh9FsvfcxdLKrB2LcSrWDIPtt312qLhe07FIuMF4hNxgvqO5gXv75j
85TjScbT/xJPKXcl/Awjm0/09M3Nr0tfwRHFIXJYaZ4cwXJMjvwQxOYsx1mO
MwwBx9nI+Mm7WI6uFNGVd7EcZyniLN5ZTN97WqIMsLC1tpxRfc7bEr9YOQYe
Dp+VNQe8Uv5gtKXiL9Z8hvKZozIGizkqeX6EO+ROJ2qwNIKOouLP3kIS/7rN
1NkTnBOfnkkkTqygyILGEshK8Ix485SjScJSjiawM7ko8fqn3sn0w3EB6p+B
8ryx4zIoYDv4/5zo76nQjhsP1//Qx49rpC55L/rnC1DWSlSp+poxtIN+qHbQ
7iUoT4l20I4bh7T/oY4fzyipmtcyYumm2miVt9X9vKu3zfcfY9V7TiH7eqv/
thk+8P9uLOt9M10uESzbVlFaJJC3uFlNfW/HDq25mPtufPROBUgr3QvUwpeE
nZmLvWfZbJFAPvaOTOibxc3l7OC+Z16+qJPfj4qKICo/RJL5Acd/GPkn3JPi
MFCmzZLBvZee3rhn5Loi9yf01mjcYgnII9A+4B3CkPIisPE53Lc/uPGGYJHx
4peLwWGRKRDx8kB0XGzOA+i9YM/nAq11UY3g+WGIShgcY1b/eETp1T/JXVJa
BLD809jJnnR55eWVl1de+pWHaVRzot5XMzyx2Q1WGZWszeGz4Koi7Fsf9lE9
/iWezkq2qjkLpM5VKTtle3nIuh+6Pgc72kNWOSkskz30jT8pX1UbNQzqLaHq
HbxJHZo6+MuwCWvfgbKv2gVRHZqK1raD95KcivbbsFY1L1clTI3+AjzKbBk=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{526, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78238108]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->220831765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"p", ",", 
   RowBox[{"!", "p"}], ",", "p", ",", 
   RowBox[{"!", "p"}], ",", "p"}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43870713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146944960],

Cell["\<\
Find the area of the complement of the union of sets given by algebraic \
conditions:\
\>", "ExampleText",
 CellID->100096229],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Boole", "[", 
    RowBox[{"Nor", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310451651],

Cell[BoxData[
 RowBox[{"15", "-", 
  RowBox[{"2", " ", "\[Pi]"}]}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72142882]
}, Open  ]],

Cell["This shows the set:", "ExampleText",
 CellID->2908850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{"Nor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "3"}], "/", "2"}], ",", 
     RowBox[{"5", "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167686269],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184433566]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->119468940],

Cell[TextData[{
 "Truth table for ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->470387246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Nor", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"False", "False"},
    {"False", "True"}
   }],
  "Grid"]], "Output",
 ImageSize->{82, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349888094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->435207580],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to expand in terms of ",
 Cell[BoxData[
  ButtonBox["And",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/And"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Not",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Not"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->392725173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"Nor", "[", 
   RowBox[{"p", ",", "q", ",", "r"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->164328352],

Cell[BoxData[
 RowBox[{
  RowBox[{"!", "p"}], "&&", 
  RowBox[{"!", "q"}], "&&", 
  RowBox[{"!", "r"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->237705777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199789300],

Cell[TextData[{
 "The negation of ",
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Or",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Or"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->288385943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"!", 
   RowBox[{"Nor", "[", 
    RowBox[{"p", ",", "q", ",", "r"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258849493],

Cell[BoxData[
 RowBox[{"p", "||", "q", "||", "r"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->290993710]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->212669702],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nor"]], "InlineFormula"],
 " of conditions in ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " functions:"
}], "ExampleText",
 CellID->257207371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Boole", "[", 
   RowBox[{"Nor", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "a", "]"}]}], ")"}], 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "b", "]"}]}], ")"}], 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "c", "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551050724],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"Boole", "[", "a", "]"}]}], ")"}]}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "b", "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Boole", "[", "c", "]"}]}], ")"}]}], "+", 
  RowBox[{"Boole", "[", 
   RowBox[{"a", "\[Nor]", "b", "\[Nor]", "c"}], "]"}]}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182780244]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40654382],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->754225596]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30354],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LogicalExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LogicalExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Or",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Or"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Xor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Xor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Not",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Not"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12771],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->9537],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41578352],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->124939666]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Nor"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 4.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Nor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 38.1392278}", "context" -> "System`", 
    "keywords" -> {
     "joint denial", "pierce arrow", "double stroke", "logical connective", 
      "Boolean algebra", "switching algebra", "propositional logic"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Nor[e_1, e_2, ...] is the logical NOR function. It evaluates its \
arguments in order, giving False immediately if any of them are True, and \
True if they are all False. ", "synonyms" -> {}, "title" -> "Nor", "type" -> 
    "Symbol", "uri" -> "ref/Nor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8732, 308, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->619085734]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38442, 1360}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2254, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2877, 81, 40, 1, 70, "ObjectName",
 CellID->1030],
Cell[2920, 84, 1321, 43, 70, "Usage",
 CellID->18249]
}, Open  ]],
Cell[CellGroupData[{
Cell[4278, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4756, 149, 1272, 46, 70, "Notes",
 CellID->21375],
Cell[6031, 197, 953, 37, 70, "Notes",
 CellID->1425],
Cell[6987, 236, 1066, 38, 70, "Notes",
 CellID->8493],
Cell[8056, 276, 355, 13, 70, "Notes",
 CellID->22291],
Cell[8414, 291, 281, 12, 70, "Notes",
 CellID->162]
}, Closed]],
Cell[CellGroupData[{
Cell[8732, 308, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->619085734],
Cell[CellGroupData[{
Cell[9117, 322, 147, 5, 70, "ExampleSection",
 CellID->61728939],
Cell[CellGroupData[{
Cell[9289, 331, 129, 4, 28, "Input",
 CellID->178169843],
Cell[9421, 337, 161, 5, 36, "Output",
 CellID->43080777]
}, Open  ]],
Cell[9597, 345, 124, 3, 70, "ExampleDelimiter",
 CellID->37477389],
Cell[9724, 350, 238, 8, 70, "ExampleText",
 CellID->8119997],
Cell[CellGroupData[{
Cell[9987, 362, 97, 3, 28, "Input",
 CellID->162312622],
Cell[10087, 367, 184, 6, 36, "Output",
 CellID->84289971]
}, Open  ]],
Cell[CellGroupData[{
Cell[10308, 378, 105, 3, 70, "Input",
 CellID->251724513],
Cell[10416, 383, 166, 5, 50, "Output",
 CellID->1453032]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10631, 394, 215, 7, 70, "ExampleSection",
 CellID->8513],
Cell[10849, 403, 492, 18, 70, "ExampleText",
 CellID->18400621],
Cell[CellGroupData[{
Cell[11366, 425, 135, 4, 70, "Input",
 CellID->534512268],
Cell[11504, 431, 161, 5, 36, "Output",
 CellID->29495578]
}, Open  ]],
Cell[CellGroupData[{
Cell[11702, 441, 136, 4, 70, "Input",
 CellID->599319570],
Cell[11841, 447, 184, 6, 36, "Output",
 CellID->11316329]
}, Open  ]],
Cell[12040, 456, 124, 3, 70, "ExampleDelimiter",
 CellID->39071304],
Cell[12167, 461, 407, 14, 70, "ExampleText",
 CellID->76232233],
Cell[CellGroupData[{
Cell[12599, 479, 244, 8, 70, "Input",
 CellID->201736223],
Cell[12846, 489, 92, 2, 70, "Print",
 CellID->1057752593],
Cell[12941, 493, 162, 5, 36, "Output",
 CellID->159950443]
}, Open  ]],
Cell[CellGroupData[{
Cell[13140, 503, 245, 8, 70, "Input",
 CellID->200768372],
Cell[CellGroupData[{
Cell[13410, 515, 91, 2, 70, "Print",
 CellID->644244816],
Cell[13504, 519, 91, 2, 70, "Print",
 CellID->153816993]
}, Open  ]],
Cell[13610, 524, 162, 5, 36, "Output",
 CellID->261207483]
}, Open  ]],
Cell[13787, 532, 125, 3, 70, "ExampleDelimiter",
 CellID->375923361],
Cell[13915, 537, 247, 8, 70, "ExampleText",
 CellID->531520307],
Cell[CellGroupData[{
Cell[14187, 549, 147, 5, 70, "Input",
 CellID->18042936],
Cell[14337, 556, 236, 8, 36, "Output",
 CellID->101212442]
}, Open  ]],
Cell[CellGroupData[{
Cell[14610, 569, 104, 3, 70, "Input",
 CellID->172565786],
Cell[14717, 574, 210, 7, 36, "Output",
 CellID->147578023]
}, Open  ]],
Cell[14942, 584, 124, 3, 70, "ExampleDelimiter",
 CellID->63290867],
Cell[15069, 589, 69, 1, 70, "ExampleText",
 CellID->37738970],
Cell[CellGroupData[{
Cell[15163, 594, 174, 6, 70, "Input",
 CellID->344385729],
Cell[15340, 602, 246, 7, 50, "Output",
 CellID->207579512]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15635, 615, 223, 7, 70, "ExampleSection",
 CellID->23750],
Cell[15861, 624, 196, 8, 70, "ExampleText",
 CellID->37965020],
Cell[CellGroupData[{
Cell[16082, 636, 517, 18, 70, "Input",
 CellID->958192352],
Cell[16602, 656, 2775, 50, 70, "Output",
 Evaluatable->False,
 CellID->233686955]
}, Open  ]],
Cell[19392, 709, 125, 3, 70, "ExampleDelimiter",
 CellID->103158259],
Cell[19520, 714, 202, 8, 70, "ExampleText",
 CellID->12039839],
Cell[CellGroupData[{
Cell[19747, 726, 488, 16, 70, "Input",
 CellID->40098381],
Cell[20238, 744, 512, 12, 70, "Output",
 Evaluatable->False,
 CellID->304516984]
}, Open  ]],
Cell[20765, 759, 124, 3, 70, "ExampleDelimiter",
 CellID->12625347],
Cell[20892, 764, 193, 8, 70, "ExampleText",
 CellID->170940585],
Cell[CellGroupData[{
Cell[21110, 776, 217, 8, 70, "Input",
 CellID->327147365],
Cell[21330, 786, 1431, 28, 70, "Output",
 Evaluatable->False,
 CellID->78238108]
}, Open  ]],
Cell[CellGroupData[{
Cell[22798, 819, 104, 3, 70, "Input",
 CellID->220831765],
Cell[22905, 824, 271, 9, 36, "Output",
 CellID->43870713]
}, Open  ]],
Cell[23191, 836, 125, 3, 70, "ExampleDelimiter",
 CellID->146944960],
Cell[23319, 841, 136, 4, 70, "ExampleText",
 CellID->100096229],
Cell[CellGroupData[{
Cell[23480, 849, 729, 25, 70, "Input",
 CellID->310451651],
Cell[24212, 876, 207, 7, 36, "Output",
 CellID->72142882]
}, Open  ]],
Cell[24434, 886, 60, 1, 70, "ExampleText",
 CellID->2908850],
Cell[CellGroupData[{
Cell[24519, 891, 685, 24, 70, "Input",
 CellID->167686269],
Cell[25207, 917, 3730, 65, 70, "Output",
 Evaluatable->False,
 CellID->184433566]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28986, 988, 237, 7, 70, "ExampleSection",
 CellID->119468940],
Cell[29226, 997, 189, 8, 70, "ExampleText",
 CellID->470387246],
Cell[CellGroupData[{
Cell[29440, 1009, 281, 10, 70, "Input",
 CellID->95768180],
Cell[29724, 1021, 236, 10, 48, "Output",
 CellID->349888094]
}, Open  ]],
Cell[29975, 1034, 125, 3, 70, "ExampleDelimiter",
 CellID->435207580],
Cell[30103, 1039, 453, 18, 70, "ExampleText",
 CellID->392725173],
Cell[CellGroupData[{
Cell[30581, 1061, 173, 5, 70, "Input",
 CellID->164328352],
Cell[30757, 1068, 246, 9, 36, "Output",
 CellID->237705777]
}, Open  ]],
Cell[31018, 1080, 125, 3, 70, "ExampleDelimiter",
 CellID->199789300],
Cell[31146, 1085, 367, 14, 70, "ExampleText",
 CellID->288385943],
Cell[CellGroupData[{
Cell[31538, 1103, 193, 6, 70, "Input",
 CellID->258849493],
Cell[31734, 1111, 192, 6, 36, "Output",
 CellID->290993710]
}, Open  ]],
Cell[31941, 1120, 125, 3, 70, "ExampleDelimiter",
 CellID->212669702],
Cell[32069, 1125, 314, 12, 70, "ExampleText",
 CellID->257207371],
Cell[CellGroupData[{
Cell[32408, 1141, 465, 16, 70, "Input",
 CellID->551050724],
Cell[32876, 1159, 564, 19, 36, "Output",
 CellID->182780244]
}, Open  ]],
Cell[CellGroupData[{
Cell[33477, 1183, 103, 3, 70, "Input",
 CellID->40654382],
Cell[33583, 1188, 158, 5, 36, "Output",
 CellID->754225596]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33802, 1200, 311, 9, 70, "SeeAlsoSection",
 CellID->30354],
Cell[34116, 1211, 1155, 44, 70, "SeeAlso",
 CellID->5363]
}, Open  ]],
Cell[CellGroupData[{
Cell[35308, 1260, 314, 9, 70, "TutorialsSection",
 CellID->12771],
Cell[35625, 1271, 171, 3, 70, "Tutorials",
 CellID->9537],
Cell[35799, 1276, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[35969, 1284, 318, 9, 70, "MoreAboutSection",
 CellID->41578352],
Cell[36290, 1295, 157, 3, 70, "MoreAbout",
 CellID->124939666]
}, Open  ]],
Cell[CellGroupData[{
Cell[36484, 1303, 305, 8, 70, "RelatedLinksSection"],
Cell[36792, 1313, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[37188, 1329, 29, 0, 70, "History"],
Cell[37220, 1331, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

