(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    101100,       3182]
NotebookOptionsPosition[     86956,       2681]
NotebookOutlinePosition[     88365,       2721]
CellTagsIndexPosition[     88279,       2716]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Vector Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorOperations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Vector Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Normalize" :> Documentation`HelpLookup["paclet:ref/Normalize"],
           "Abs" :> Documentation`HelpLookup["paclet:ref/Abs"], 
          "EuclideanDistance" :> 
          Documentation`HelpLookup["paclet:ref/EuclideanDistance"], "Dot" :> 
          Documentation`HelpLookup["paclet:ref/Dot"], "Total" :> 
          Documentation`HelpLookup["paclet:ref/Total"], "RootMeanSquare" :> 
          Documentation`HelpLookup["paclet:ref/RootMeanSquare"], 
          "SingularValueList" :> 
          Documentation`HelpLookup["paclet:ref/SingularValueList"], 
          "Integrate" :> Documentation`HelpLookup["paclet:ref/Integrate"], 
          "Outer" :> Documentation`HelpLookup["paclet:ref/Outer"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Normalize\"\>", 2->"\<\"Abs\"\>", 
       3->"\<\"EuclideanDistance\"\>", 4->"\<\"Dot\"\>", 5->"\<\"Total\"\>", 
       6->"\<\"RootMeanSquare\"\>", 7->"\<\"SingularValueList\"\>", 
       8->"\<\"Integrate\"\>", 9->"\<\"Outer\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix-Based Minimization" :> 
          Documentation`HelpLookup["paclet:guide/MatrixBasedMinimization"], 
          "Numerical Evaluation & Precision" :> 
          Documentation`HelpLookup[
           "paclet:guide/NumericalEvaluationAndPrecision"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Math & Counting Operations on Lists\"\>", 
       3->"\<\"Matrices and Linear Algebra\"\>", 
       4->"\<\"Matrix-Based Minimization\"\>", 
       5->"\<\"Numerical Evaluation & Precision\"\>", 
       6->"\<\"Operations on Vectors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Norm", "ObjectName",
 CellID->19480],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Norm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Norm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the norm of a number or array. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Norm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Norm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      FormBox[
       StyleBox["p", "TI"], TraditionalForm]], "InlineMath"],
     "\[Hyphen]norm. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17153]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For complex numbers, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24027],

Cell[TextData[{
 "For vectors, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   StyleBox["v", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Sqrt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sqrt"], "[", 
   RowBox[{
    StyleBox["v", "TI"], ".", 
    RowBox[{
     ButtonBox["Conjugate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Conjugate"], "[", 
     StyleBox["v", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->100066169,
  ButtonNote->"100066169"]
}], "Notes",
 CellID->16891],

Cell[TextData[{
 "For vectors, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{
    ButtonBox["Total",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Total"], "[", 
    SuperscriptBox[
     RowBox[{
      ButtonBox["Abs",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Abs"], "[", 
      StyleBox["v", "TI"], "]"}], 
     StyleBox["p", "TI"]], "]"}], 
   RowBox[{"(", 
    RowBox[{"1", "/", 
     StyleBox["p", "TI"]}], ")"}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7491],

Cell[TextData[{
 "For vectors, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "]"}]], "InlineFormula"],
 " is the ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 "\[Hyphen]norm given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"], "[", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["v", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->532848272,
  ButtonNote->"532848272"]
}], "Notes",
 CellID->17252],

Cell[TextData[{
 "For matrices, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " gives the maximum singular value of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->128011670,
  ButtonNote->"128011670"]
}], "Notes",
 CellID->31809],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", "\"\<Frobenius\>\""}], "]"}]], 
  "InlineFormula"],
 " gives the Frobenius norm of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->106372133,
  ButtonNote->"106372133"]
}], "Notes",
 CellID->388425225],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->116053276,
  ButtonNote->"116053276"]
}], "Notes",
 CellID->5726]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5083978],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->993256781],

Cell["Norm of a vector:", "ExampleText",
 CellID->17011],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27725],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "z", "]"}], "2"]}]]], "Output",
 ImageSize->{191, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27398415]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3162],

Cell["Norm of a complex number:", "ExampleText",
 CellID->2050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"-", "2"}], "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3524],

Cell[BoxData[
 SqrtBox["5"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51099614]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17670],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " is a vector of integers:"
}], "ExampleText",
 CellID->329690736],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", " ", "0", ",", " ", "1", ",", " ", "0", ",", "0", ",", "1", ",",
      " ", "0", ",", "0", ",", "0", ",", "1", ",", " ", "0", ",", "0", ",", 
     "0", ",", "0", ",", "1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57851032],

Cell["Use exact arithmetic to compute the norm:", "ExampleText",
 CellID->368945127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "v", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->748179647],

Cell[BoxData[
 SqrtBox["5"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->367459980]
}, Open  ]],

Cell["Use approximate machine-number arithmetic:", "ExampleText",
 CellID->70220019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"N", "[", "v", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->260726578],

Cell[BoxData["2.23606797749979`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->672369949]
}, Open  ]],

Cell["Use 35-digit precision arithmetic:", "ExampleText",
 CellID->448198231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"N", "[", 
   RowBox[{"v", ",", " ", "35"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->150165824],

Cell[BoxData["2.236067977499789696409173668731276235440618359612`35."], \
"Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->328571705]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " representation of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->116053276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", "v", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2219250],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 5, ">"],
     Editable->False], ",", 
    RowBox[{"{", "15", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->108484406]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "s", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->361780245],

Cell[BoxData[
 SqrtBox["5"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->378730135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95171118],

Cell["The norm is always real even when the input is complex:", "ExampleText",
 CellID->117577568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", " ", "+", " ", "I"}], ",", " ", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->731752643],

Cell[BoxData["2.2874804866642475`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5018500]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200539654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->4081979],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Norm", "[", "v", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195494340],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}], 
  TraditionalForm]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->392359298]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12455],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 "-norm:"
}], "ExampleText",
 CellID->24711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "p"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6221],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", "x", "]"}], "p"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "y", "]"}], "p"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "z", "]"}], "p"]}], ")"}], 
  FractionBox["1", "p"]]], "Output",
 ImageSize->{195, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224626524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20037],

Cell["The \[Infinity]-norm:", "ExampleText",
 CellID->18569],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2807],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"Abs", "[", "y", "]"}], ",", 
   RowBox[{"Abs", "[", "z", "]"}]}], "]"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->242814071]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23666],

Cell["Norm of a matrix, equal to the largest singular value:", "ExampleText",
 CellID->3092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1882],

Cell[BoxData["6.2836187224170805`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97916541]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "1.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.2836187224170805`", ",", "0.8752918092210963`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32143210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366272733],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 "-norm and ",
 Cell[BoxData[
  StyleBox["\[Infinity]", "TR"]], "InlineFormula"],
 "-norm respectively for matrices:"
}], "ExampleText",
 CellID->430789043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219433305],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "1"}]], "]"}], "+", 
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "1"}]], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "2"}]], "]"}], "+", 
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "2"}]], "]"}]}]}], "]"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187384683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "Infinity"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->97626248],

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "1"}]], "]"}], "+", 
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "2"}]], "]"}]}], ",", 
   RowBox[{
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "1"}]], "]"}], "+", 
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "2"}]], "]"}]}]}], "]"}]], "Output",
 ImageSize->{306, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->57385882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->244169965],

Cell["The Frobenius norm for matrices:", "ExampleText",
 CellID->11915213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", "\"\<Frobenius\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19303230],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "1"}]], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "2"}]], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "1"}]], "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "2"}]], "]"}], "2"]}]]], "Output",
 ImageSize->{313, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25841722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23324],

Cell[TextData[{
 "Symbolic matrix norms for a real parameter ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->6444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "x"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19093],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{"26", "+", 
    SuperscriptBox["x", "2"], "+", 
    SqrtBox[
     RowBox[{"612", "+", 
      RowBox[{"96", " ", "x"}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      SuperscriptBox["x", "4"]}]]}]], 
  SqrtBox["2"]]], "Output",
 ImageSize->{224, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104653990]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14605],

Cell["\<\
Estimate the mean distance from the origin to random points in the unit \
square:\
\>", "ExampleText",
 CellID->10005677],

Cell[BoxData[
 RowBox[{
  RowBox[{"pts", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"10", "^", "3"}], ",", "2"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->155831190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "pts", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12851194],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->489802170]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Norm", ",", "pts"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->271885685],

Cell[BoxData["0.7613231490325127`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->651790659]
}, Open  ]],

Cell["Compare to the asymptotic result:", "ExampleText",
 CellID->945454037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->659515735],

Cell[BoxData["0.7651960148783958`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->511823650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->740107304],

Cell[TextData[{
 "Solve an ill-conditioned linear system ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"m", ".", "x"}], "=", "b"}], TraditionalForm]], "InlineMath"],
 " with a known solution:"
}], "ExampleText",
 CellID->139438935],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"N", "[", 
    RowBox[{"HilbertMatrix", "[", "20", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", " ", "=", " ", 
   RowBox[{"m", ".", 
    RowBox[{"Range", "[", "20", "]"}]}]}], ";"}], "\n", 
 RowBox[{"x", " ", "=", " ", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{"m", ",", " ", "b"}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->148016919],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)}\\) may contain significant \
numerical errors. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/luc\\\", ButtonNote -> \
\\\"LinearSolve::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->976380834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999973538030333`", ",", "2.000404467037038`", ",", "2.984855550846815`",
    ",", "4.240497400135888`", ",", "3.017412667299681`", ",", 
   "15.183709954570132`", ",", 
   RowBox[{"-", "16.601501920408328`"}], ",", "34.767197292579866`", ",", 
   "22.754856554827683`", ",", 
   RowBox[{"-", "60.371920888280656`"}], ",", "62.47983828585981`", ",", 
   "33.13022047047735`", ",", 
   RowBox[{"-", "20.503821981755717`"}], ",", "88.49201335729637`", ",", 
   RowBox[{"-", "217.55332593649487`"}], ",", "238.67685322363317`", ",", 
   "98.37584369147964`", ",", 
   RowBox[{"-", "265.30942389653944`"}], ",", "204.36351406042218`", ",", 
   RowBox[{"-", "21.12722186977222`"}]}], "}"}]], "Output",
 ImageSize->{452, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341087032]
}, Open  ]],

Cell["Get the norm of the residual:", "ExampleText",
 CellID->549473122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{
   RowBox[{"m", ".", "x"}], " ", "-", " ", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224806250],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->292380845]
}, Open  ]],

Cell["Get the norm of the actual error:", "ExampleText",
 CellID->139923894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"x", " ", "-", " ", 
   RowBox[{"Range", "[", "20", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->143452749],

Cell[BoxData["492.8233366273905`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->191618441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47206210],

Cell[TextData[{
 "Approximate the solution of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", "u"}], 
     RowBox[{"\[PartialD]", "t"}],
     MultilineFunction->None], "\[LongEqual]", 
    RowBox[{"\[Alpha]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "2"], "u"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x", "2"]}],
      MultilineFunction->None]}]}], TraditionalForm]], "InlineMath"],
 " using ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " spatial points and ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " time steps:"
}], "ExampleText",
 CellID->209244596],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f0", "[", "x_", "]"}], " ", ":=", "  ", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"10", 
        RowBox[{"(", " ", 
         RowBox[{"x", "-", 
          RowBox[{"1", "/", "2"}]}], ")"}]}], ")"}], "^", "2"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Alpha]", " ", "=", " ", "0.1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"heat", "[", 
   RowBox[{"n_", ",", " ", "k_"}], "]"}], " ", ":=", " ", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"u", ",", " ", "m", ",", " ", 
      RowBox[{"dt", " ", "=", " ", 
       RowBox[{"1", "/", "k"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"m", " ", "=", " ", 
      RowBox[{"SparseArray", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", 
           RowBox[{
            RowBox[{"-", "2."}], "dt", " ", 
            RowBox[{"n", "^", "2"}]}]}], ",", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i_", ",", " ", "j_"}], "}"}], "/;", 
            RowBox[{
             RowBox[{"Abs", "[", 
              RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
           
           RowBox[{"1.", "dt", " ", 
            RowBox[{"n", "^", "2"}]}]}]}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"n", "-", "1"}], ",", 
          RowBox[{"n", "-", "1"}]}], "}"}], ",", " ", "0."}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"minv", " ", "=", " ", 
      RowBox[{"LinearSolve", "[", 
       RowBox[{
        RowBox[{"SparseArray", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"{", 
            RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", "1."}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"n", "-", "1"}], ",", 
            RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "-", 
        RowBox[{"\[Alpha]", " ", "m"}]}], "]"}]}], ";", "\[IndentingNewLine]",
      
     RowBox[{"xgrid", " ", "=", " ", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"Range", "[", 
         RowBox[{"n", "-", "1"}], "]"}], "/", "n"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"u", " ", "=", 
      RowBox[{"f0", "[", "xgrid", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"u", " ", "=", " ", 
        RowBox[{"minv", "[", "u", "]"}]}], ",", 
       RowBox[{"{", "k", "}"}]}], "]"}], " ", ";", "\[IndentingNewLine]", 
     "u"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->64919291],

Cell[TextData[{
 "Find two solutions with fixed ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " where the second has twice as many time steps:"
}], "ExampleText",
 CellID->174628382],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u1", " ", "=", " ", 
   RowBox[{"heat", "[", 
    RowBox[{"100", ",", " ", "10"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"u2", " ", "=", " ", 
   RowBox[{"heat", "[", 
    RowBox[{"100", ",", " ", "20"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->628985845],

Cell["Estimate the error by the norm of the difference:", "ExampleText",
 CellID->556931524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"u1", " ", "-", " ", "u2"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->138896849],

Cell[BoxData["0.021005867573774532`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->217237108]
}, Open  ]],

Cell["\<\
Extrapolate to a better solution from the first-order convergence of the \
backward Euler method:\
\>", "ExampleText",
 CellID->20790594],

Cell[BoxData[
 RowBox[{
  RowBox[{"u3", " ", "=", " ", 
   RowBox[{
    RowBox[{"2", " ", "u2"}], " ", "-", " ", "u1"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->92751767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"xgrid", ",", " ", "u3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->306791638],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVlXtMk2cUxoEY2dQQQ9gWBXSoGzQsU0ASY2KeZQbHFI0wBkTxgoiGKNA1
zs7OqlHZRqJBY72bjgys0yyorCK20H7cIioQRaHIQFto6b1gJs546/i+c/7x
TZqm/fqey/M752nclrKsorCQkJDCyZf4/nNU7Tc21WGcUDRpt+nkoM8aXDi0
oRs1B9Awp9yb2aDFJacqKzj+Gz+vgStj5T7d+WM4d1Y8l1G/vy9w0KDh39ci
tiija8qjM/Blit9cx7u9Mb/GOi/wfT3yTXuWbt5ThWmWavmyaTfRfiKgeab6
g+Pdwn8bNVaTsgay/MqWiYRGHK9QnEwr03F8E3ocRcYpBX+iZvK2pVpAqNIQ
oc64wvmaEe7om5+U9BdSpNOKzxe4Ki5G1HL+Nnz9eq9vs/0qWicSJjO0IzI+
dPaL/mtcz210JFdkFRuvI0tK2IG7JWnBtWfruL472J64cNWPir9hU4kB72LG
ziOG31foud5OqMrDl5z/6AZ+EMuTd0FWOCtu8dMbXH83wta3ZS6prkeIdO7j
Y7V2obLgJvdzH23JifrmWQ1IlxI8QMT44d2eew3c3wPILuXp25W3IGbLr+yB
9nTqOlmsgft9CNvzxdP9RgOkdiwPMdXwNt7znZH7f4SjXbLe13Yj5orlzOnF
rtzI0GBpI+vRiy8ff1jc86wR26TTh+eLpmtzSppYHwuyUx0flNqaIEaLqrUg
KtTrf7PaxHr146u8JLm7zoQXYriJfsxrK9BEzzSzfo9RF/3FcnWRGZI8ywbw
Mn7Tqld1ZtZzAJqxa4UHXpohlVf+DwZ+mnsqOFtgfQdRFuP8RJ8qoKtTPIP4
Pq9YkZshsN5DaE6fl2vfKEBqN+oJPg37rDSnRGD9n6AicUPOFaUAKVz+U8ir
zBeH1ALzsOKqbYc7sF/gfqzYzc+JjxUn+T71Z0UyxydeNvRzfurXBjnXR/xs
OMb1U//DCHJ/xHMYLu6fwg0jO4H0Ib4jmBlD+pE+IzjI+hKeEehYf9LLDjXz
If52tDA/0s+OrUnEl+bBgSrmT3o64HhvPhx4w/ND+o5iF88Xzcso1kzQ/JHe
o5h6huaT5seJSp5f0t8JOc83zZMT81No/omHCwreD+LhQh7vD/FwQc37RTxc
uMP7RzzcyOb9JB5uXOb9JR5uhJfSfhMPD8JSaP+Jhwffsj8QDw907B/Ew4tD
7C/Ew4t17D/Ew4uV7E/Ew4fIUfIv4uFDJ/sb8fAhcRP5H/Hw41/2R+Lhxy/s
n8TDjzQ1+SvxCGA9+y/xCMDznj8HELma/Jt4jMHF/k48xtDB/k88xmDm/4f/
Aab8DSc=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 0.99}, {0., 0.12890421292810347`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->18952817]
}, Open  ]],

Cell[TextData[{
 "Compute a more accurate solution with ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->413033574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"First", "[", 
   RowBox[{"u", " ", "/.", " ", 
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}], " ", 
         "\[Equal]", " ", 
         RowBox[{"\[Alpha]", " ", 
          RowBox[{"D", "[", 
           RowBox[{
            RowBox[{"u", "[", 
             RowBox[{"t", ",", "x"}], "]"}], ",", " ", "x", ",", "x"}], 
           "]"}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"0", ",", "x"}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"Exp", "[", 
          RowBox[{"-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"10", 
              RowBox[{"(", " ", 
               RowBox[{"x", "-", 
                RowBox[{"1", "/", "2"}]}], ")"}]}], ")"}], "^", "2"}]}], 
          "]"}]}], ",", " ", 
        RowBox[{
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "0"}], "]"}], " ", "\[Equal]", " ", 
         RowBox[{"u", "[", 
          RowBox[{"t", ",", "1"}], "]"}], " ", "\[Equal]", " ", "0"}]}], 
       "}"}], ",", "u", ",", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[6]:=",
 CellID->104725247],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->307900176]
}, Open  ]],

Cell["Compare the errors in the three solutions:", "ExampleText",
 CellID->309495485],

Cell[BoxData[
 RowBox[{
  RowBox[{"und", " ", "=", " ", 
   RowBox[{"sol", "[", 
    RowBox[{"1", ",", " ", "xgrid"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->273268397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"u1", " ", "-", "und"}], "]"}], ",", " ", 
   RowBox[{"Norm", "[", 
    RowBox[{"u2", " ", "-", " ", "und"}], "]"}], ",", " ", 
   RowBox[{"Norm", "[", 
    RowBox[{"u3", " ", "-", " ", "und"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->486255424],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.04283641723652413`", ",", "0.021847211662737`", ",", 
   "0.0014613754702971615`"}], "}"}]], "Output",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->238254591]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21887],

Cell[TextData[{
 "The norm of ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 " is equal to the square root of the ",
 Cell[BoxData[
  ButtonBox["Dot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dot"]], "InlineFormula"],
 " product ",
 Cell[BoxData[
  FormBox[
   RowBox[{"v", ".", 
    SuperscriptBox["v", "\[Conjugate]"]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->100066169],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"RandomComplex", "[", 
    RowBox[{
     RowBox[{"1", "+", "I"}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->712811474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "v", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87684770],

Cell[BoxData["0.970111814160201`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59886000]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 SqrtBox[
  RowBox[{"v", ".", " ", 
   RowBox[{"Conjugate", "[", "v", "]"}]}]]], "Input",
 CellLabel->"In[3]:=",
 CellID->113634755],

Cell[BoxData[
 RowBox[{"0.970111814160201`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->50821149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->456950530],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    RowBox[{
    "\[LeftDoubleBracketingBar]", "v", "\[RightDoubleBracketingBar]"}], "p"], 
   TraditionalForm]], "InlineMath"],
 " is a decreasing function of ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->599496764],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", "100", "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357524249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"v", ",", " ", "p"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"p", ",", " ", "1", ",", " ", "100"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108364792],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylV9uLTVEYX3P2Psb9zpDbxOCvkAchSfIgD/IwJjXz4BIjoYRySTPkbtwG
M5TLAxEpSpQoUTIllCjxYFImD1Pq+H3rW/ustb69zj7njOnM2utb6/fdL2ef
ZY2tzevWN7a2NDXWL97cuKm5pWlL/aKNm3EU1Sil7uF/2ySFfQE7/X+vUMAz
vc7CGgMwDc8Iz/HmmcMzh+cYc5/Qk819ZOhJWkoDrXSsKaXqHZq2Y2mJLc3y
XMQoWvJFCUaORE0WeuT9BH0+W5zOqNqa0WURlVkyR5xOr9qSMWX0DMyOqSZ7
E/5bf52RlEtJqisk9eWfyxiML2vDSFoGuYgwTmvMF+nMiDQYu+vNc5x5JnU9
VtBTHD9t3ZfqqhFYrwFVU6RcCyaWoWO99Lz7gaM3r789fvQp6rz4SkXHjz3f
uOEuPirSC66b1t6aP69D5Wghz/HEZ9VKUm5Rhiuv6a2t9yGNBI7UUnFv6FpN
X+1+A6X4qOG0RGwEbfOCHiLonAYVaaLICjwri8M4Tff19YPjwf33Kqftgb2w
e83q6+xl3NJ8m13as/sRx+XmjbdGXawt+vjhp5E4pIxGWYt1RTspx3O1iN7e
P5AKRQf2P4FW2LB0SSc2II2FL198BQJa1aagnzM1/eXLrzu3e2C0yq1Y3qVi
iAA3/ATv9iDfDFpqcd3e9gwpRQiwQTXAIrUryDFVdwo0AQglUAGV37//3uv5
NUX3CazmuAJCEvcFJeo6jyERWGQCxhwsncu4v/9vx5mXkAncoSBOd1+E2kbl
otJUm2cZ38JFaINO1R6UwXUCbgQTGtXhIErPVioQWETbI0EUzTfK4tHgrf4e
iBAgxJO2FkXW8i1cRWDIjmP6lts3+UvmRV5I1jMtQmpQzhT945opPUXl9ArO
RuoRpJO2A5XDnqMaUda0PVGFHCKH63N4grySPycHaAfLwaRDU9N2oHKGJfag
cSg3p5gtsrlJJrvMDHMi4Ug7bU95Oedb1CaKnLang3UzVHgRRvF0gnUYKGTj
mQwUBEEcbbNQCD4PPwdFVvMtug7VRtuOoIzBwvMwqjaxGpGlTJ/NQKE30Mm0
PevZM1jEJ0sG5hjUlEYN0jTchvO0PVcSRX1+3rODNcBEGFqaNy/yxDLct2JZ
Q0yjJdGYtGUONtV/xS1XxywJIwzjzkqqvh/ywlOWEzmo0LtS0t2xiMCFirlT
7zVOTVwwUXH9qMwbloSQmNluJFXQ3cy5c8fDZ08/W84RHtpWnL11ZbDfgABI
24sZKKiBsmwU1WWnZ4e0MkuDtTaMyglrOzNQtmKzUHYW+VazPXZ+ZMmwlZiF
QrnhdVCgbL3gj/267NnBvHbaXSrBy9/rzBvJmvGQ3H8G6Vhasuo9bs5j5dxR
UsD4jqG3IOZ0qzvd/3FK68IF59GqzFvhvLC/nTis6krlHlteDnzCK+NqcXjN
o7fhK17uNJgb27lxuPB+Qr8NgndcVOE7fFvhbSukjQPlcplIcRC6UufsYPqc
HeoSGmy3pDXwN2BaEsRAWPqcHUyfs3NSMztmNYsqKIgJaXLeXU3FEM1fvYaP
WFikw2rmGTY8YAw2VVOpiiZAgi2Uq37nl2xVPJyEsN8yRpwYg7WR5lEmckx4
U3Xd/imPNXmKdNG2OyXBPyWNV32MmdmC07zJi1NTi5ny0GABTjOvy50G5Jkq
NFmp+Qfw7B6k\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61083633]
}, Open  ]],

Cell[TextData[{
 "The horizontal asymptote is the ",
 Cell[BoxData[
  StyleBox["\[Infinity]", "TR"]], "InlineFormula"],
 "-norm, equal to by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"], "[", 
   RowBox[{
    ButtonBox["Abs",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Abs"], "[", 
    StyleBox["v", "TI"], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->532848272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"v", ",", " ", "Infinity"}], "]"}], ",", " ", 
   RowBox[{"Max", "[", 
    RowBox[{"Abs", "[", "v", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->98386036],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.9879967619717249`", ",", "0.9879967619717249`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->458867308]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101642818],

Cell[TextData[{
 "The matrix 2-norm is the maximum 2-norm of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], ".", 
   StyleBox["v", "TI"]}]], "InlineFormula"],
 " for all unit vectors ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->552152998],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233974724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], ",", 
   RowBox[{"Maximize", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Norm", "[", 
        RowBox[{"m", ".", "v"}], "]"}], ",", 
       RowBox[{
        RowBox[{"Norm", "[", "v", "]"}], " ", "\[Equal]", " ", "1"}]}], "}"}],
      ",", "v"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36476480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"15.016453855298975`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0.6504894488894332`"}], ",", 
     RowBox[{"y", "\[Rule]", "0.4700395040807698`"}], ",", 
     RowBox[{"z", "\[Rule]", "0.5965956264397422`"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68608563]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", "m", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->44768470],

Cell[BoxData["15.01645385530648`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->153823481]
}, Open  ]],

Cell[TextData[{
 "This is also equal to the largest singular value of ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->128011670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{"m", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->94467490],

Cell[BoxData[
 RowBox[{"{", "15.01645385530648`", "}"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->613437451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->285995928],

Cell["\<\
The Frobenius norm is the same as the norm made up the vector of the \
elements:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->106372133],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"9", ",", " ", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272689616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"m", ",", " ", "\"\<Frobenius\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->521732757],

Cell[BoxData["5.858668608403863`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->367349050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"Flatten", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->660359064],

Cell[BoxData["5.858668608403864`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42043082]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24757],

Cell["It is expensive to compute the 2-norm for large matrices:", \
"ExampleText",
 CellID->629613985],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1000", ",", " ", "1000"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->214685411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Norm", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->379756764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11.877000000000002`", ",", "500.07598401497694`"}], 
  "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48429443]
}, Open  ]],

Cell[TextData[{
 "If you need only an estimate, the 1- or ",
 Cell[BoxData[
  StyleBox["\[Infinity]", "TR"]], "InlineFormula"],
 "-norms are very fast:"
}], "ExampleText",
 CellID->595626364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Norm", "[", 
     RowBox[{"m", ",", "1"}], "]"}], ",", " ", 
    RowBox[{"Norm", "[", 
     RowBox[{"m", ",", "\[Infinity]"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86868123],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.04000000000000351`", ",", 
   RowBox[{"{", 
    RowBox[{"530.5018196044426`", ",", "529.5505334632493`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->342988727]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16028],

Cell[TextData[{
 "Unit balls for using ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["3", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 " norms:"
}], "ExampleText",
 CellID->15938337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RegionPlot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Norm", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}], ",", "p"}], "]"}], "\[LessEqual]", 
      "1"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "Infinity"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->689154011],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->713212941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130397478],

Cell["Different norm functions:", "ExampleText",
 CellID->571284191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", "p"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
     RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "Infinity"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->512039636],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1917585]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5721],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normalize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normalize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EuclideanDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EuclideanDistance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootMeanSquare",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootMeanSquare"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SingularValueList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SingularValueList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31667]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26269],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->5134],

Cell[TextData[ButtonBox["Vector Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorOperations"]], "Tutorials",
 CellID->513408734]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Norm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Norm"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->388711156],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->136511972],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->10977877],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->64684109],

Cell[TextData[ButtonBox["Matrix-Based Minimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixBasedMinimization"]], "MoreAbout",
 CellID->162766220],

Cell[TextData[ButtonBox["Numerical Evaluation & Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalEvaluationAndPrecision"]], "MoreAbout",
 CellID->179649921],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->216174095]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Norm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 36.2798052}", "context" -> "System`", 
    "keywords" -> {
     "1-norm", "2-norm", "Euclidean norm", "Frobenius norm", 
      "induced matrix norm", "infinity-norm", "inner product norm", 
      "matrix norm", "metric", "norm", "p-norm", "vector length", 
      "vector norm"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Norm[expr] gives the norm of a number or array. Norm[expr, p] gives the \
p-norm. ", "synonyms" -> {}, "title" -> "Norm", "type" -> "Symbol", "uri" -> 
    "ref/Norm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9718, 330, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->5083978]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 88138, 2709}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3592, 75, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4215, 102, 42, 1, 70, "ObjectName",
 CellID->19480],
Cell[4260, 105, 911, 30, 70, "Usage",
 CellID->17153]
}, Open  ]],
Cell[CellGroupData[{
Cell[5208, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5686, 157, 407, 17, 70, "Notes",
 CellID->24027],
Cell[6096, 176, 684, 27, 70, "Notes",
 CellID->16891],
Cell[6783, 205, 712, 29, 70, "Notes",
 CellID->7491],
Cell[7498, 236, 838, 32, 70, "Notes",
 CellID->17252],
Cell[8339, 270, 444, 17, 70, "Notes",
 CellID->31809],
Cell[8786, 289, 464, 18, 70, "Notes",
 CellID->388425225],
Cell[9253, 309, 428, 16, 70, "Notes",
 CellID->5726]
}, Closed]],
Cell[CellGroupData[{
Cell[9718, 330, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->5083978],
Cell[CellGroupData[{
Cell[10101, 344, 148, 5, 70, "ExampleSection",
 CellID->993256781],
Cell[10252, 351, 56, 1, 70, "ExampleText",
 CellID->17011],
Cell[CellGroupData[{
Cell[10333, 356, 153, 5, 28, "Input",
 CellID->27725],
Cell[10489, 363, 373, 13, 45, "Output",
 CellID->27398415]
}, Open  ]],
Cell[10877, 379, 120, 3, 70, "ExampleDelimiter",
 CellID->3162],
Cell[11000, 384, 63, 1, 70, "ExampleText",
 CellID->2050],
Cell[CellGroupData[{
Cell[11088, 389, 137, 5, 70, "Input",
 CellID->3524],
Cell[11228, 396, 168, 6, 38, "Output",
 CellID->51099614]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11445, 408, 216, 7, 70, "ExampleSection",
 CellID->17670],
Cell[11664, 417, 140, 5, 70, "ExampleText",
 CellID->329690736],
Cell[11807, 424, 340, 9, 70, "Input",
 CellID->57851032],
Cell[12150, 435, 84, 1, 70, "ExampleText",
 CellID->368945127],
Cell[CellGroupData[{
Cell[12259, 440, 100, 3, 70, "Input",
 CellID->748179647],
Cell[12362, 445, 169, 6, 38, "Output",
 CellID->367459980]
}, Open  ]],
Cell[12546, 454, 84, 1, 70, "ExampleText",
 CellID->70220019],
Cell[CellGroupData[{
Cell[12655, 459, 128, 4, 70, "Input",
 CellID->260726578],
Cell[12786, 465, 174, 5, 36, "Output",
 CellID->672369949]
}, Open  ]],
Cell[12975, 473, 77, 1, 70, "ExampleText",
 CellID->448198231],
Cell[CellGroupData[{
Cell[13077, 478, 158, 5, 70, "Input",
 CellID->150165824],
Cell[13238, 485, 214, 6, 36, "Output",
 CellID->328571705]
}, Open  ]],
Cell[13467, 494, 381, 14, 70, "ExampleText",
 CellID->116053276],
Cell[CellGroupData[{
Cell[13873, 512, 138, 4, 70, "Input",
 CellID->2219250],
Cell[14014, 518, 454, 16, 36, "Output",
 CellID->108484406]
}, Open  ]],
Cell[CellGroupData[{
Cell[14505, 539, 100, 3, 70, "Input",
 CellID->361780245],
Cell[14608, 544, 169, 6, 38, "Output",
 CellID->378730135]
}, Open  ]],
Cell[14792, 553, 124, 3, 70, "ExampleDelimiter",
 CellID->95171118],
Cell[14919, 558, 98, 1, 70, "ExampleText",
 CellID->117577568],
Cell[CellGroupData[{
Cell[15042, 563, 208, 7, 70, "Input",
 CellID->731752643],
Cell[15253, 572, 174, 5, 36, "Output",
 CellID->5018500]
}, Open  ]],
Cell[15442, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->200539654],
Cell[15570, 585, 201, 7, 70, "ExampleText",
 CellID->4081979],
Cell[CellGroupData[{
Cell[15796, 596, 138, 4, 70, "Input",
 CellID->195494340],
Cell[15937, 602, 280, 8, 50, "Output",
 CellID->392359298]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16266, 616, 239, 7, 70, "ExampleSection",
 CellID->12455],
Cell[16508, 625, 126, 6, 70, "ExampleText",
 CellID->24711],
Cell[CellGroupData[{
Cell[16659, 635, 177, 6, 70, "Input",
 CellID->6221],
Cell[16839, 643, 437, 15, 45, "Output",
 CellID->224626524]
}, Open  ]],
Cell[17291, 661, 121, 3, 70, "ExampleDelimiter",
 CellID->20037],
Cell[17415, 666, 60, 1, 70, "ExampleText",
 CellID->18569],
Cell[CellGroupData[{
Cell[17500, 671, 187, 7, 70, "Input",
 CellID->2807],
Cell[17690, 680, 314, 10, 36, "Output",
 CellID->242814071]
}, Open  ]],
Cell[18019, 693, 121, 3, 70, "ExampleDelimiter",
 CellID->23666],
Cell[18143, 698, 92, 1, 70, "ExampleText",
 CellID->3092],
Cell[CellGroupData[{
Cell[18260, 703, 246, 9, 70, "Input",
 CellID->1882],
Cell[18509, 714, 175, 5, 36, "Output",
 CellID->97916541]
}, Open  ]],
Cell[CellGroupData[{
Cell[18721, 724, 259, 9, 70, "Input",
 CellID->3106],
Cell[18983, 735, 242, 8, 36, "Output",
 CellID->32143210]
}, Open  ]],
Cell[19240, 746, 125, 3, 70, "ExampleDelimiter",
 CellID->366272733],
Cell[19368, 751, 245, 9, 70, "ExampleText",
 CellID->430789043],
Cell[CellGroupData[{
Cell[19638, 764, 282, 10, 70, "Input",
 CellID->219433305],
Cell[19923, 776, 595, 21, 36, "Output",
 CellID->187384683]
}, Open  ]],
Cell[CellGroupData[{
Cell[20555, 802, 291, 11, 70, "Input",
 CellID->97626248],
Cell[20849, 815, 594, 21, 36, "Output",
 CellID->57385882]
}, Open  ]],
Cell[21458, 839, 125, 3, 70, "ExampleDelimiter",
 CellID->244169965],
Cell[21586, 844, 74, 1, 70, "ExampleText",
 CellID->11915213],
Cell[CellGroupData[{
Cell[21685, 849, 300, 11, 70, "Input",
 CellID->19303230],
Cell[21988, 862, 648, 23, 45, "Output",
 CellID->25841722]
}, Open  ]],
Cell[22651, 888, 121, 3, 70, "ExampleDelimiter",
 CellID->23324],
Cell[22775, 893, 166, 6, 70, "ExampleText",
 CellID->6444],
Cell[CellGroupData[{
Cell[22966, 903, 351, 12, 70, "Input",
 CellID->19093],
Cell[23320, 917, 439, 16, 80, "Output",
 CellID->104653990]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23808, 939, 223, 7, 70, "ExampleSection",
 CellID->14605],
Cell[24034, 948, 131, 4, 70, "ExampleText",
 CellID->10005677],
Cell[24168, 954, 259, 10, 70, "Input",
 CellID->155831190],
Cell[CellGroupData[{
Cell[24452, 968, 105, 3, 70, "Input",
 CellID->12851194],
Cell[24560, 973, 9184, 155, 70, "Output",
 Evaluatable->False,
 CellID->489802170]
}, Open  ]],
Cell[CellGroupData[{
Cell[33781, 1133, 159, 5, 70, "Input",
 CellID->271885685],
Cell[33943, 1140, 176, 5, 36, "Output",
 CellID->651790659]
}, Open  ]],
Cell[34134, 1148, 76, 1, 70, "ExampleText",
 CellID->945454037],
Cell[CellGroupData[{
Cell[34235, 1153, 366, 12, 70, "Input",
 CellID->659515735],
Cell[34604, 1167, 176, 5, 36, "Output",
 CellID->511823650]
}, Open  ]],
Cell[34795, 1175, 125, 3, 70, "ExampleDelimiter",
 CellID->740107304],
Cell[34923, 1180, 238, 8, 70, "ExampleText",
 CellID->139438935],
Cell[CellGroupData[{
Cell[35186, 1192, 424, 13, 70, "Input",
 CellID->148016919],
Cell[35613, 1207, 486, 9, 70, "Message",
 CellID->976380834],
Cell[36102, 1218, 872, 19, 71, "Output",
 CellID->341087032]
}, Open  ]],
Cell[36989, 1240, 72, 1, 70, "ExampleText",
 CellID->549473122],
Cell[CellGroupData[{
Cell[37086, 1245, 157, 5, 70, "Input",
 CellID->224806250],
Cell[37246, 1252, 160, 5, 36, "Output",
 CellID->292380845]
}, Open  ]],
Cell[37421, 1260, 76, 1, 70, "ExampleText",
 CellID->139923894],
Cell[CellGroupData[{
Cell[37522, 1265, 167, 5, 70, "Input",
 CellID->143452749],
Cell[37692, 1272, 175, 5, 36, "Output",
 CellID->191618441]
}, Open  ]],
Cell[37882, 1280, 124, 3, 70, "ExampleDelimiter",
 CellID->47206210],
Cell[38009, 1285, 672, 24, 70, "ExampleText",
 CellID->209244596],
Cell[38684, 1311, 2703, 80, 70, "Input",
 CellID->64919291],
Cell[41390, 1393, 197, 6, 70, "ExampleText",
 CellID->174628382],
Cell[41590, 1401, 315, 10, 70, "Input",
 CellID->628985845],
Cell[41908, 1413, 92, 1, 70, "ExampleText",
 CellID->556931524],
Cell[CellGroupData[{
Cell[42025, 1418, 135, 4, 70, "Input",
 CellID->138896849],
Cell[42163, 1424, 178, 5, 36, "Output",
 CellID->217237108]
}, Open  ]],
Cell[42356, 1432, 147, 4, 70, "ExampleText",
 CellID->20790594],
Cell[42506, 1438, 181, 6, 70, "Input",
 CellID->92751767],
Cell[CellGroupData[{
Cell[42712, 1448, 199, 6, 70, "Input",
 CellID->306791638],
Cell[42914, 1456, 1834, 39, 132, "Output",
 CellID->18952817]
}, Open  ]],
Cell[44763, 1498, 219, 8, 70, "ExampleText",
 CellID->413033574],
Cell[CellGroupData[{
Cell[45007, 1510, 1468, 44, 70, "Input",
 CellID->104725247],
Cell[46478, 1556, 451, 17, 36, "Output",
 CellID->307900176]
}, Open  ]],
Cell[46944, 1576, 85, 1, 70, "ExampleText",
 CellID->309495485],
Cell[47032, 1579, 187, 6, 70, "Input",
 CellID->273268397],
Cell[CellGroupData[{
Cell[47244, 1589, 340, 10, 70, "Input",
 CellID->486255424],
Cell[47587, 1601, 278, 9, 36, "Output",
 CellID->238254591]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47914, 1616, 233, 7, 70, "ExampleSection",
 CellID->21887],
Cell[48150, 1625, 470, 17, 70, "ExampleText",
 CellID->100066169],
Cell[48623, 1644, 238, 8, 70, "Input",
 CellID->712811474],
Cell[CellGroupData[{
Cell[48886, 1656, 99, 3, 70, "Input",
 CellID->87684770],
Cell[48988, 1661, 174, 5, 36, "Output",
 CellID->59886000]
}, Open  ]],
Cell[CellGroupData[{
Cell[49199, 1671, 146, 5, 70, "Input",
 CellID->113634755],
Cell[49348, 1678, 254, 7, 36, "Output",
 CellID->50821149]
}, Open  ]],
Cell[49617, 1688, 125, 3, 70, "ExampleDelimiter",
 CellID->456950530],
Cell[49745, 1693, 322, 12, 70, "ExampleText",
 CellID->599496764],
Cell[50070, 1707, 216, 7, 70, "Input",
 CellID->357524249],
Cell[CellGroupData[{
Cell[50311, 1718, 325, 9, 70, "Input",
 CellID->108364792],
Cell[50639, 1729, 1932, 36, 70, "Output",
 Evaluatable->False,
 CellID->61083633]
}, Open  ]],
Cell[52586, 1768, 502, 18, 70, "ExampleText",
 CellID->532848272],
Cell[CellGroupData[{
Cell[53113, 1790, 251, 8, 70, "Input",
 CellID->98386036],
Cell[53367, 1800, 243, 8, 36, "Output",
 CellID->458867308]
}, Open  ]],
Cell[53625, 1811, 125, 3, 70, "ExampleDelimiter",
 CellID->101642818],
Cell[53753, 1816, 292, 11, 70, "ExampleText",
 CellID->552152998],
Cell[54048, 1829, 236, 8, 70, "Input",
 CellID->233974724],
Cell[CellGroupData[{
Cell[54309, 1841, 512, 17, 70, "Input",
 CellID->36476480],
Cell[54824, 1860, 433, 13, 36, "Output",
 CellID->68608563]
}, Open  ]],
Cell[CellGroupData[{
Cell[55294, 1878, 99, 3, 70, "Input",
 CellID->44768470],
Cell[55396, 1883, 175, 5, 36, "Output",
 CellID->153823481]
}, Open  ]],
Cell[55586, 1891, 221, 7, 70, "ExampleText",
 CellID->128011670],
Cell[CellGroupData[{
Cell[55832, 1902, 135, 4, 70, "Input",
 CellID->94467490],
Cell[55970, 1908, 197, 6, 36, "Output",
 CellID->613437451]
}, Open  ]],
Cell[56182, 1917, 125, 3, 70, "ExampleDelimiter",
 CellID->285995928],
Cell[56310, 1922, 179, 5, 70, "ExampleText",
 CellID->106372133],
Cell[56492, 1929, 247, 8, 70, "Input",
 CellID->272689616],
Cell[CellGroupData[{
Cell[56764, 1941, 144, 4, 70, "Input",
 CellID->521732757],
Cell[56911, 1947, 175, 5, 36, "Output",
 CellID->367349050]
}, Open  ]],
Cell[CellGroupData[{
Cell[57123, 1957, 134, 4, 70, "Input",
 CellID->660359064],
Cell[57260, 1963, 174, 5, 36, "Output",
 CellID->42043082]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57483, 1974, 226, 7, 70, "ExampleSection",
 CellID->24757],
Cell[57712, 1983, 102, 2, 70, "ExampleText",
 CellID->629613985],
Cell[57817, 1987, 252, 8, 70, "Input",
 CellID->214685411],
Cell[CellGroupData[{
Cell[58094, 1999, 133, 4, 70, "Input",
 CellID->379756764],
Cell[58230, 2005, 242, 8, 36, "Output",
 CellID->48429443]
}, Open  ]],
Cell[58487, 2016, 191, 6, 70, "ExampleText",
 CellID->595626364],
Cell[CellGroupData[{
Cell[58703, 2026, 281, 9, 70, "Input",
 CellID->86868123],
Cell[58987, 2037, 309, 10, 36, "Output",
 CellID->342988727]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59345, 2053, 224, 7, 70, "ExampleSection",
 CellID->16028],
Cell[59572, 2062, 380, 15, 70, "ExampleText",
 CellID->15938337],
Cell[CellGroupData[{
Cell[59977, 2081, 729, 24, 70, "Input",
 CellID->689154011],
Cell[60709, 2107, 4490, 78, 70, "Output",
 Evaluatable->False,
 CellID->713212941]
}, Open  ]],
Cell[65214, 2188, 125, 3, 70, "ExampleDelimiter",
 CellID->130397478],
Cell[65342, 2193, 68, 1, 70, "ExampleText",
 CellID->571284191],
Cell[CellGroupData[{
Cell[65435, 2198, 720, 23, 70, "Input",
 CellID->512039636],
Cell[66158, 2223, 15469, 258, 70, "Output",
 Evaluatable->False,
 CellID->1917585]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81688, 2488, 310, 9, 70, "SeeAlsoSection",
 CellID->5721],
Cell[82001, 2499, 2186, 80, 70, "SeeAlso",
 CellID->31667]
}, Open  ]],
Cell[CellGroupData[{
Cell[84224, 2584, 314, 9, 70, "TutorialsSection",
 CellID->26269],
Cell[84541, 2595, 148, 3, 70, "Tutorials",
 CellID->5134],
Cell[84692, 2600, 148, 3, 70, "Tutorials",
 CellID->513408734]
}, Open  ]],
Cell[CellGroupData[{
Cell[84877, 2608, 305, 8, 70, "RelatedLinksSection"],
Cell[85185, 2618, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85570, 2634, 319, 9, 70, "MoreAboutSection",
 CellID->388711156],
Cell[85892, 2645, 139, 3, 70, "MoreAbout",
 CellID->136511972],
Cell[86034, 2650, 189, 4, 70, "MoreAbout",
 CellID->10977877],
Cell[86226, 2656, 162, 3, 70, "MoreAbout",
 CellID->64684109],
Cell[86391, 2661, 160, 3, 70, "MoreAbout",
 CellID->162766220],
Cell[86554, 2666, 175, 3, 70, "MoreAbout",
 CellID->179649921],
Cell[86732, 2671, 152, 3, 70, "MoreAbout",
 CellID->216174095]
}, Open  ]],
Cell[86899, 2677, 27, 0, 70, "History"],
Cell[86929, 2679, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

