(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    140050,       3259]
NotebookOptionsPosition[    130482,       2927]
NotebookOutlinePosition[    132004,       2968]
CellTagsIndexPosition[    131917,       2963]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTDistribution" :> 
          Documentation`HelpLookup["paclet:ref/StudentTDistribution"], 
          "HalfNormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/HalfNormalDistribution"], 
          "Erf" :> Documentation`HelpLookup["paclet:ref/Erf"], "InverseErf" :> 
          Documentation`HelpLookup["paclet:ref/InverseErf"], 
          "BinomialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/BinomialDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"StudentTDistribution\"\>", 
       2->"\<\"HalfNormalDistribution\"\>", 3->"\<\"Erf\"\>", 
       4->"\<\"InverseErf\"\>", 
       5->"\<\"BinomialDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"], 
          "Functions Used in Statistics" :> 
          Documentation`HelpLookup["paclet:guide/FunctionsUsedInStatistics"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>", 
       2->"\<\"Functions Used in Statistics\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Statistical Distributions\"\>", 5->"\<\"Statistics\"\>", 
       6->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       7->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NormalDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NormalDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NormalDistribution"], "[", 
       RowBox[{
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[Sigma]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a normal (Gaussian) distribution with mean \
",
     Cell[BoxData[
      FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
     " and standard deviation ",
     Cell[BoxData[
      FormBox["\[Sigma]", TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["NormalDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/NormalDistribution"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]represents a normal distribution with zero mean and \
unit standard deviation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15871]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " in a normal distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"]}], "/", 
     RowBox[{"(", 
      RowBox[{"2", 
       SuperscriptBox["\[Sigma]", "2"]}], ")"}]}]], TraditionalForm]], 
  "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6303,
  ButtonNote->"6303"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->9742,
  ButtonNote->"9742"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13187464],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->9379783],

Cell["The mean and variance of a normal distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24173],

Cell[BoxData["\[Mu]"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138283537]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 SuperscriptBox["\[Sigma]", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->334863141]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30324],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"x", "-", "\[Mu]"}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "\[Sigma]"}]]], "Output",
 ImageSize->{55, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209770377]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31536419]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24588],

Cell["\<\
Generate a set of pseudorandom numbers that are normally distributed:\
\>", "ExampleText",
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.6078113734049725`"}], ",", "0.001569633916562692`", ",", 
   "0.3559930999358887`", ",", 
   RowBox[{"-", "0.1130979673334375`"}], ",", 
   RowBox[{"-", "0.7150479448078997`"}], ",", "0.8170851455420451`", ",", 
   RowBox[{"-", "1.1657435426463905`"}], ",", "0.13855037127408254`", ",", 
   RowBox[{"-", "2.6271292148471104`"}], ",", 
   RowBox[{"-", "1.136183229455685`"}]}], "}"}]], "Output",
 ImageSize->{413, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141461717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell["Properties based on higher-order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6096],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219242895]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63972662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24103],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["q", TraditionalForm]], "InlineMath"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a normal distribution:"
}], "ExampleText",
 CellID->5694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18627],

Cell[BoxData[
 RowBox[{"\[Mu]", "+", 
  RowBox[{
   SqrtBox["2"], " ", "\[Sigma]", " ", 
   RowBox[{"InverseErf", "[", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "q"}]}], "]"}]}]}]], "Output",
 ImageSize->{189, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446232048]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28359],

Cell[TextData[{
 "Compute ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 "\[Hyphen]values for a ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "\[Hyphen]test with alternative hypothesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", "<", "z"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->813014373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338871180],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Erf", "[", 
     FractionBox["z", 
      SqrtBox["2"]], "]"}]}], ")"}]}]], "Output",
 ImageSize->{115, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446157531]
}, Open  ]],

Cell[TextData[{
 "Alternative hypothesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"X", ">", "z"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->326644389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", "]"}], ",", "z"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->944228315],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"Erf", "[", 
      FractionBox["z", 
       SqrtBox["2"]], "]"}]}], ")"}]}]}]], "Output",
 ImageSize->{143, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102500314]
}, Open  ]],

Cell[TextData[{
 "Alternative hypothesis ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftBracketingBar]", "X", "\[RightBracketingBar]"}], ">", 
    "z"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->86298351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"CDF", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", "]"}], ",", "z"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->892686001],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"Erf", "[", 
   FractionBox["z", 
    SqrtBox["2"]], "]"}]}]], "Output",
 ImageSize->{87, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->540164673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108324723],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233452814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197502749],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineMath"],
 " are varied:"
}], "ExampleText",
 CellID->2750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"0", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Sigma]", ",", 
     RowBox[{"1", "/", "10"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19414],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxtXXdclLnTZ1maiAiIvffeu6J59Oy993Yqdj09FfXUs3fF3nvvFQsi+qyI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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Vk1oXFUUvm9+3ptXI04niZhoO5mk3YVkdBaukkCErqKCCzdubBSnhaSd
FiELddFMtMyIEKgLSV0lWswm2o0I/lBBFKV1rVixramYmfy4sujC+H35vi4O
9757zz33nO9859xXmT373JlMCGETkoX8CeH3YchWPoQPIf2Yr3oeRRqveM7D
85Bd6MT4nsP8DuYfYH/NOhz5XcTeeYznIE9Dp1gI4Zs4hEuR1rh3AvMWHGln
ZfNkLoQO1l/EeA26zx7SHuWM712yD4ORxjmvf4JzV33XJsa7ea2v2rftIN1N
r/dEmjOO6az0ucbxD+vQN86538jrDtqfijSfDPJ1y7gRK87fijR2PL+IWE6n
IbwM3X37RH9ou+XYP8PYhCSRcNmC7gzWn0hCGAcONeiOwMavsLWO/YmMzlD/
FtZ/wfpHmI9G8on+VCF1nBsPsteBvBCEf8OxEPOa/TyN8RRkyng2HGPd65PW
P7AP/c+R0y8g38KPaxi/hnyP+QD8+RlyORLRGDf9ZXzT9rkF3evweSUSDneN
MzHjHfSnYf4QB9r7MZbNHzK6p4zxVeDzUCq+zeZ0lr7Nwv4C9haw/jzmTyXy
4QLmiwXhznytOnf3sP9aLA7vYHwzUR5YJ72QEqQchOUYpAPpg+S5Bv0xyHBQ
PDXICDkPGfK5jG0cNp7MDXG+Dd9fwtl3M8J3zHes2Tf6w7w+CXncd+Z8L21V
fAdtD/t73Hdy/Rlw52yi+hlxLLRBf6vWr8aKgX4PmTe0cSNWnlbMq25Qvfe6
f9AP8njENqu+s+IaZL2xvnqtM+wzfbbRNY6x90pe/wmYnMTiMs5vuU8RS/L+
44xwu4X9tUQcfg/z9xPtNSFtyGJGNgZT2SGGxJg4HsmIQ3s4uwydO9DZwPdv
mC8mqm/m5HiqM+xZ68bvHay3C/omF3mOeWn6TuLDPJK7E+w5qbmYEYbU6Xef
JGe3nXOeof7vqeJhLBXnuGRci/6mjZbtsAcuuQ/+6/VB9+am/Wl7zvWm9Tlv
GSvOmWPiVLPNBa+z7tkXpjyvuz/w7D/2gViWjWcjEefIN+aXMbO+drF+JJGP
bwCPT2P1g78Q7x7m2znhy/vJhWOp+h1zzjxPx8p12zESgx3zkfwhIVnfRyEX
C8oTc9Rw/yC2V93DGcsjqXK/YU5Mmb9l22AsN2P1VnJnAPJAJD4WzUnmYt8c
7rcfHdcmdf+z3oORbLLvkTNV19rxvPw+uLOgN5Jcq+POV1L1M3KL/tE3xrPi
3rJs/tVs77L7A/l0yTpvA7fRRL2047eJvfu7rHLGOriJ/b9xvku+IW9Dh+QX
eb/uvnPOb/WM65S9g9x8NCsOMB/sweWCOF21Dv05Zbwn3SerXh9zz+GcNXc7
lt6Ga/V+3OvODeMcd4/tuHcQ869w55cFxcT3je8cfSXmxDshl5w7PkfkDHsS
ecP+um87V/zPc4CV88o+1YXtSqK3lu9Tj+0+nFWNzLvH0W7ifDPv7PfUje1D
3e8n+yq5MGE+7CKmPWDXzak2iCnxfAyHdhLhy7i6fru3/Y6f8P8Y/aAPxazO
s2YX/D1ovjJ2+vV6rHeOb0qKuOZTnSf/yMOjrqtR41NyHFnbOGZO75tnfa6/
rrlPbh3Uu/EeMOZ82zf9f7XkXjTn+HuMT9F9lnZL8GsmUQz0iblkPf4PSxIr
3A==
         "],
         VertexColors->None], 
        PolygonBox[{{2341, 2340, 425, 660}, {1732, 2183, 681, 403}, {2543, 
         1958, 91, 1259}, {2406, 2405, 1121, 1122}, {2413, 2412, 631, 790}, {
         1742, 2328, 686, 411}, {2530, 1756, 424, 686}, {2237, 1726, 714, 
         967}, {2409, 2134, 573, 1124}, {1825, 2173, 899, 952}, {2236, 2131, 
         541, 966}, {1836, 2670, 1446, 390}, {2592, 2035, 768, 1317}, {2639, 
         1904, 622, 906}, {1596, 2648, 1385, 63}, {2670, 1660, 257, 1446}, {
         2330, 2329, 411, 656}, {1659, 2669, 1444, 257}, {1903, 2057, 790, 
         622}, {1925, 2544, 1260, 326}, {1740, 2520, 656, 410}, {2239, 2593, 
         1317, 543}, {2607, 1931, 390, 1331}, {1911, 2322, 784, 631}, {2186, 
         1741, 410, 681}, {2029, 1986, 277, 761}, {2674, 1760, 77, 1457}, {
         1948, 1596, 63, 687}, {2178, 1728, 906, 905}, {2405, 1842, 1331, 
         1121}, {2102, 2177, 905, 834}, {1821, 2061, 795, 762}, {2651, 1773, 
         326, 1394}, {1602, 2651, 1394, 77}, {2669, 1908, 528, 1444}, {2061, 
         1820, 761, 795}, {2648, 1759, 319, 1385}, {1986, 2407, 1122, 277}, {
         1859, 2283, 952, 573}, {1755, 2529, 660, 424}, {1757, 2531, 687, 
         425}, {2241, 2239, 543, 969}, {1868, 2030, 762, 784}, {1761, 2674, 
         1457, 319}, {2131, 2238, 967, 541}, {1775, 2542, 1258, 1260}, {1726, 
         2240, 969, 714}, {2542, 1774, 1259, 1258}, {1718, 2102, 834, 899}, {
         1958, 2012, 747, 91}, {2035, 1671, 1124, 768}, {2079, 2078, 403, 
         528}},
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV21ollUYft73fd7n4xWl10At58qhVCMJloQ/KvwoFZJt6Mwot4lRrvKj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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtoVVcQhtc5Z2evvSP1ChI1MUZbKGIpRB98UYzFvigK1gsIRqpF06K1
VbF4xQsq9UIVidhWH6Qtghi8xAvVtihR6UO9VHxojdLE4I2iBgW12ki/v78P
w5l/zayZtWf+mVMze+HkT4shhEVIgixOQzgUQzjD4chSCJuzELZxNqIQwi7w
FPBkZCZ6PXIC2ypwX/zX4jOpnLucbUWfUhZCjzyEJcRbgr1AgnPYeuI/kLs7
kUH41yC/oldx5wt8Z2OfBy7Dfx362syxFXMNvnPAdbw1EmsP8pIc/+B7khzb
wRXgHDwS/wHoOzj7hnjdOLuE/idnVxP7SO+HlCc++478bfg0c/cY8QZiq0L2
gneA/0V/gfxecM79+KbceQA+hX0Ceu/cb38f/CH2P+QPrg2O1YpcSxyzDf0G
PjfA15F74O+JMQnfdnAf8DJwBe9PwR+DN6Wu1SzOxmF7SD3eQB9NvgX6dvA7
2BvwH4Xv25xVJK7Zb+AvsTeW/KYh3D8I/hF8GumVOadyVYM36Nu400K8r4uu
5efY5yeuaS/0pfgsLfoNVXpP9Ld3R57q28An0K8Q4zn6ec4ugcvw30q+K+oj
tgOcTaS/n0Vz5wNkEfE/wqeh5Jzt+K7D3lh0j97FvxZcC96H3MrNAfVeNW1S
PzJ/S9/wmnvI0JI5OA7fDdxZrf5z5yZ4CLg3+CbSmrpH6k0rcji6ZqqVZiSJ
5oB6f7vgWdmUmduamRXgZ/gkJc+AuD0/d2/EcfX6B9Wk4J4/w/8T5NuiOTYM
25bobxtadC00A+L+/zXhd0Lq3Huxd+pcfC86Zi25niCd5LsA7ok+lfszytyz
ErE3Rt+t18yWewdo9uXTjO0Ysgr7AOzjsc3CZyW25bz3EbgzNzfOYX+ceyY1
i8q5MLqn6qU4eRf7rdTcbkPGpp45zZo4dgf7baSuYM52YZuaeddUcjYX2zzk
YtE9V6/eRPok7tnP+P7yej9tLpjbg4lxqmSOt5DvrHomLmN/BV7M+5p533T1
D//K3LtCM7obe0duLozB/oC7ldHc1htUC9VQtVNNfuL+6cxv1RvewzYt86x2
INXgFuQyd7uQjcQemzu3OCiurEzda3HmKPhINHfVg/Xo91XDxDVqIvbx6N7o
G+eotrm5OoY797B/FV2L9pJn/2LqXa4dsCf6G/VtR5Gz2M9k9tdOrs68w7W7
NTP9c+807TLtzLdy51Qu9WAEeHhuromDmtW/UsfWzD7C9jA1V7QTxHXNoGZP
nNdbt0fvMr2hIzVnxBV982Xw9dy7WDtjZ3RNVUv1tFvmHqu32pk12P7OXHv9
R2n3NEbvGu2gC6l3knaReiIudKXmtjih/7q66Nqpn/8B9Z/wAA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1uMltUVhr///7/jP2iGk0paqwxSxSZeCIpWTS2WC2kvcKKJTZtOBDUK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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtsV0UQxrc97e45FQ01cou3iFd8BLEikGihPogPYiRqNGpKvAVUUCm2
Kn9N7UVbSRUUals1amP7UEGlIZBKgkQejHeMDxpjgqUBg2BBhaigvy9fHyaZ
2flmZndue1H9o7c8Uh5CKEEV0G1VIZxXhNCThbC8MoRq+NoUwgJAFQBujiFE
5PvKQtgE/gTy32BOoluJPIJcykNow/5Lzs6AbwTfiP3n0LfonyHGOL7fxMdO
dIfBjIKfWmbdhfjry4zpQPc1Nt3Im6FWdC2FY81VTPA1YBah64Ca8LcN+oRY
M5Cvgx9Dn8Nfy9k8+PlQHXIz8YbgZ4KZhm4PNB15GnQp+sugW+GXTdjPR38Y
7PnIs5CrkHPkAe73Dnc5ir9mdA3Rd+mE9sLvAVMNdiP6tdEY6XSHp9A18YbP
eOunvOkcdN+A6UU3E3qftw4iv4v/t6EO+N3JuZyNv9PIi8Bcje4n5HH4cc6O
Ih+BLke+ApoBv63MtTxCjLHMNS2D3wl+L/wkvZe7LIMy8L9wn3p0P2C/D3lO
cG5GORvKnKOvomuk2ggj3fPE2FRuTDu2i6HbiV1Cvxr93VBN5hyOgC3PHVv3
6YPvhWqJtYKzHvjl0EPwg9BKbFuxGcXfC2CugT+Efn/mGtVz98TZ/ehbyOlf
xD4BHSP2jZwdgz8OXYy8FPkV/D2O/HCFe24qtg342IXtGvQPwE/mbBV8F2eP
gV0NzSvzncYK51i5/Rkfg2BPRddih2YG+/+QE7YR+hPse2Du4e7HlWN0hzh7
DewwNhvRdUbXdh10A3xb4dx9h3wV/IPKIfaXcPYv8j+F36IZXBFtI2wvPvvh
N6PvQvdyhXtVPaVeUs9uSO4pxVOPNpLLJ9X/2gm87wn4LdG5OA2tQu6OzuV2
6Ht8rcl91y/w14P8OtQRHPPcwjtFu0Q5C8k5US5y6CVsfwQzqcI75xT6Vvzf
NVHPHck7RbtEPfp7dI+rt5UD7ZqPOWvPvHNUuynJs6Qa/qHaR+daPXAyOkfK
zT7usxC+D/zWcs/IVvgtyb2vnfARfAuYOzPvlGH4tblz81zm2X0aTFHuGZ5N
vDmFa6MeuyO6h9Q7A/icnrxDtDtksxDsgsK5fQt5SXQPqXfU47qbZkC9rzvW
oJ+SezeoRmfh+8wq+9aOaAPfnryLNANLdNfo3ar9pd5qyn131Vy9vyF61jQD
FxSeec26ajKErw+g3djuUj/D30u8UqX/gMXIXVA/ugOZe3sgObfqce32kYn/
Qzv+IP73R/f6MGcNuXtIvaMdvg5sKflvmAs9i3579K5WjX/N/Sa9RTOv3Vdb
+C/QDtSsvpicS82sZq+7cO9rBjuxXR/tW3/Kh8l/hv4KvfEN8bl3v3ZQHbaV
Ve5V7TC9/abo3aMcqDeGk/8O9Ug1tmfnzpX+vGZ0BwrvBs24Yr+a/BfoDpPR
NST/rdq5S6N3mHaXZmh97pwIqz+hDv63if9SO/xK7GcVnkXt3IPork/Oj2oi
rGqk2shGf0N/cu71R/wPNdoKhw==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmF2MVdUVx8+959zzMWUmxjpATZqm2thaJH4hAxVTDdiHGm0skxgfbIlB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVVUUhvftvffsfaoliiKVxKghQdAgJD7agmBIy0QEwyvGkcYXGAgP
pa0g9mEwLTVoggwApS0DEkCS0gFC2+BEkCb4AKLRgRonYnRgqEEtYIvfn7+D
lbPWWa+91/rX2ve/uHHFhooQQgdUgk5kIWxLIRzmZ2shhK3wzcl8WzGEGTGE
2cjz4T+DfsxDuA+ahPN3UAFdBXQO/w58AvblyhDq0P2MfBfyQ+gfx7eETQ3y
18gZ8qPIG8m/ChrBtgf5iM6imMgnsFlArk3oTxJ6NjH7kI8gr0M/Cu2Gv5d/
VejmIY/DX+ffTeRxaC2x2jlPFf/WE+8Q3325z/YCdBz5c+QBbAehDs4XoT/R
dXOecfhd0XfL8a8nXiNyBbZLkZvxn8+/BvgrnPEBcs2ApuP7bMmx+7EZKjnH
+9heRO7W2bEZIlZddGzVcDK+3+AzTKwp5RDOYH8W+gr9eeh5dC3434H/SuSX
sc/xX4vchf0mbGdhM41cjeifTs6h2KuRf8V3DbQX+ZR6jP408k74HegTvjk0
UnSONnTXovsl/5nwreQcK/uOC9E3Yf+G7od9Q3KNVJtl0IPwfdhsh38M2oP/
w/x7omjMbUV3nn8/wC8p+q5vJmNPd54FPxN6RHgpOvdP5Puy6DMIW8qh2MJY
E3ztBF7fhurgT2a+m3qk3I3JOp3hTvgp0PSie7Ke+E2Ze3mQ+OuQa5L5Xmgx
uRug2pIx/hq29dAwvnORm9EthJYUXBOdfV/mXugOA9x1MDOeVPOPsN2bG4u7
sR+Dv4b+P/gb0G+anehZ+QX/OfBPJff+guqL/avYLw/ueeK8+3PHuoXzvoS8
Av1+9J1lz9px9IdKnjnVSnfU3VSzS+guQt9j/wU2B+C7oT3wLfx7D74gvGL/
Dv+WE+8o8lCFZ2aLept7VtXzFvgDmvGCa9RIrtuxHyDWEDGeQ3cM+TT+Y+jP
Yj81GvuamZrMMyDsq0cp+k66i3bAFt0/ebZ7oMnRORT7dfSTKr0ztCtuK3tW
dkbvGs1Mr7CPvo1c7VAnfAe0IbjH84Rl7K9M4Ee9fTJ3r9XjZfDPqGfCDjQE
fyxzbv27Ff+78X+XfNPwvx49k5olzZR26xxoQdH1V686o3ePeqbdM5zca2Fm
ZeaZ16zvQv83+f7i3zl0p/DZDH8P9qPw3wbvzq7o2mqH/pN7pjRLV9Vf+Feg
T9AfLbo3Z3LvQvWoFvlyMvaEQdl+mHnXyke1O5gZC6phdfSddVedYRH6m1Ao
GwOXMr8heju0s3uw743eRfWY/YHv78m5VhWNjapK904YqVY9oX74Twve7WuS
fasmdpt2knaRdlxWaQwLu8LsVfh/c99dNdOsHY6unWZOb0dXbizoDdFs7YjO
pRnLyLU4ebfpjRI2+pLfRmFEu2xb5t2vnaZdfiH3LGmn6+1sjd79ekM3c74P
krGrnfaWsB/9VrZDU9FXV/otvIz/XGxHonlh5kbmN09vnWrcje7j5F6qRtrd
rZlrKbyNZt4x2i3C+GD0jl898f70ouvJjS3N/LLoGRD29Sb0o1uaG+vaIZp9
7RztGu0AvY2Lkne53khhf3v0XTQD/wPY2RLH
         "],
         VertexColors->None], 
        PolygonBox[{{2253, 2279, 992, 1856, 2252}, {2277, 2253, 2252, 1855, 
         991}},
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV11o11UY/m3/j985fwNLL5YSUTcriJy6LCowZBPZTAstwatQIhvmF6nl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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF9MlmUYxh/g+773eVibG7jRWiedkFsHoMxc66BYsKYt3KDVOnBNDkqn
QkyiYY1ReVItsVbOKQKFDgsVsKA2UVvpANso0fwzKzeTDjop50mThf4uLg+u
vdf93s9z/7+fR5pbG1uKQwgbQQ4sZiE8AVbzcxC0FkJ4H/nfohB60V+MIVwA
NejOl4SwO4XQA7rR7cRAA/x5UAevB22lnMfGAPdH8iG8ia4DNHK+Cn0BW4vg
NrbKwRp8zUTbvgBWcb8G/AYvw0bk7j+cWcD///z7EPlz7L+M7jro4+5rYBu6
YfAH/Dq4Cl/GnTvcrckcv3Ks5f7TYBWx1IAN8B3Y+4/4XkRuR/4U+UlstyBf
wdbl6FguYbMV3gKaOL+9xLkcBhMlzult7r8FmtG3c/8FeBNYB38OTHB2HFSi
/4Hzm/H1VHJt1JP34O+CNviOnHPvUr4512Ard7eAOvQt3P8ZPne/fnyWcp2N
rqVy/hp+XPHDT/OvCv10dK+rwBy+ZhUz+U3joxpdFXgI3SJ4RbFHn1UMZ5HH
iKeD83nZR/4GDKHrw38vvA98pnw48z38NJhEN8a/r+DDOgPv4V8X/JmCc+9U
fZDHwdFgmwvo7ib36lfsPVrqnqlXj+U9O4+T01yJa/ARul3Js6kajsFHk2dZ
MzqAvQ+SbWmGTsBf4t8w+hH0ZZl7pl7dRX8OPgN+Qn+Sf93wd5J7ox4fhR9J
zl05fQEfBHtz3pFD8IPJuepfk3zhY7LYO9afeYY1u8f5tx95n/aR82uRp7g7
nexbNTwJP5VcS9WoU7Ekz5pmUr38BUzl3NOr2L4WPbuah0781yK/UeyZ16y/
Tk2P5T3zDdo1zRj6Z8HH8E+iZ00x/aXdzhzrPD7mkf/G382cd1y2eqJ3Xza/
hA+B8mLviN6G3zl/Kec3Qr5S8m7LZyW2R6J9awb/hN+I3mW9CSvQV5a697Ix
j+5m9OxrBlaiqwYVwW+Aers++W1Sj7X7BwqeNb0BA8kzq1ndk/OuHil4FrSz
BWwVZX5rNNOj6M4kz4Z2oEy+Mu+Cal5HIPXRb5tq/C38u+hd1w4mzvcn+3qA
HJYjn0/evQrkCuRbmXfv4bxrq5qr1qrxJmy9Gv026c1TbR8s9VnVeA9392ae
naU3Bv2P0buvmvTDB6LfLr0hmkXFpFg0k/cAL0TX4A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVltslUUQ3r//Oef/zwlqBPUFVFqVRh6MAt6rPinEECNqNbY89aghxdIb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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlslkUUhufv//X7Zn53S7hRkbpGL4wiiyQul6LRCCouQELSGqNIKQHK
YksEQa9UxERRSGz7gwuUIulCgSibympCImoJYgUBMfECo9Fo0kSfN68Xb3Le
OWfOnJmzTH1D86NzakIIbSADs2MIz4O5kLnlEAaQRxch/IvRF/B98B/ACeTD
oBm5CczDfgF8YwqhC7TDZ5VC+CMP4UP0fej+Ym0H8kHWvsbfl6yNg++Mlq9m
rR35LPuHsN3MWh98e/TZ0u9HdxDsQr8I/7PQtcCb4VX4AeTLKyHU1drmJfhy
0Io8Ff0R5B7OX4xcwt+12N7M/a5CHs2eMfCl6DfAx8Ffxz6wVkJ+BR9bOe/z
6LvXs7Yi+Qz5bsv8Fh3RsetNJiNPAdPgE2v8tm+BzrLfeBG+R1V89h7wJr5e
A9Pw9yr6D5A7QQN8LfwYch32I7E9Aj+FrzsrjlX+13CXQ8R/DLkLbMK+gv6S
WufkO+y/B8c5f0KNfa8H72U+o4pcYF+p9dpi+IugBfkh9MuQ/wZ/Zn7T1fga
gg9mvtM6zp8MrkTuxv8vxNKJzRb4VnAjvq8H9ehu5Yy25DPkeyE+3sd+JXxp
5pr5FvkpcfRfZda1Y9Nats0j+L4Ofzfh6xZwJvpN9BZD2KzGvor9dPYPluzr
aTAls0/lehD7wbJzfo7Yz4IO0v4s/DfkFdg0Yj8Mn6R6Zv86+Gn270S+TPfl
7G7W5qsXQCP7F+LzFLqpuX1dAO/A9xeuf+XnfvZPSvalGJehW164lseDe5BD
dGzKl9723cJ79cZVdEfhj2P2Cfx35BbOeyxzz+qsftVs2Weq99b8v198FPJP
0W+l+x1O7jH11m58fIT8AGgs+c7XVFyzqlXlsFo4x8ptL/x4dI0pVr2pcnND
xblWjsaoXqNjU89NT54B6m3F/HDuN9NbNYBt0TNAet3hALpVud9GNX4Hvk+i
vwt5LP57o3tUvbm37NnwNvZ3lzwjZiB/k1xLBXtW5s6x7q4efQLdk8k6zQjV
7vncb6safgZ5IhjB/tvgzyXXoGpPNbJN8wU0sXdj5tnZEx2L7vyZ6oWYr8C+
B303vvay1q+9mXX9yXtlo97dkNz76uGL4JvhHfBL4UuQfwU/Z+7R9aqV6NpT
TWgW7kbfm3kmqlb3JZ+lmtVdOgvnTndSrh8E92XOeb36K/quesMt2NcVnp0D
mWPXmmTdoSl3DpU7+TjB3uHC9aCZ05t8B8X+ceZZdii51jTTNEvWFp4dminK
7Y+aWWXneAD9pty91gVK7B/O3duaCXvQfwrml3xn/SUvRP9l+lM0W99InuWa
sduRdyT7Us9r1r+cPMs18zXrWpNnk2aectuXHLtyrLefE/33KQdD0T2lelLM
imVXcq4V02n09xaeT+pp/aW3V1y7+lM1e1clz37N4O7kP1V/qXI+j7vOBBfX
eIZp1vyT/Ldq5vwHsbUPdw==
         "],
         VertexColors->None], 
        PolygonBox[{{2261, 1845, 1844, 2259, 981}, {2251, 1852, 981, 2260, 
         2250}, {1588, 2325, 980, 2255, 1587}, {1850, 2251, 2250, 2258, 
         980}, {1845, 2266, 984, 2265, 1844}},
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl3uIVVUUxs+999xz7rkFFVnahJVpD3L8o5fV2EwaVDPapEmZPawoK5Mc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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlX1olmUUxu/32etzP8+rYNGMdKVMt4qcf/ThCqdOg9pKHTrayjQI01pa
G+VCI4NmURJR2crIIHHqCrMgjWrra1kUmhmFI4UGGdUqi8IVJS3od3X5x4Fz
3efjPvc55z6nckVHc3sSQuiCilB1FsL5eQgTAM0IziuFsBx8HXjamBDWxBBW
cfYY/EghhLvTEJYiX4x8CPth5Ms4ux3bP6Ee/A2D+9EdAs8DrwePoNtYFkIT
/HFsfkd2C9QArsNfDf7WolMLfg75HmSV6C9Ddg9nw8jmg5/F3xbwHPz3gicS
2yRoCvFNhsZi2wl+A74Hm+PoP87ZJsWDfgWy3ZyVJ7aZB57JHTeC54OngM+F
rkG3CvwauhdE8wOcfcXdWzjbBX+UmDeC30N+APvrOXsRX73QRu6eW/RbrkBn
fNFv2oHtL8iHwXvR/0S28lmwfILew9kk7psIVcO/is3DemviWrSgvzm4JjfB
/4zOX8hWQ/343s1ZO/7+gRaAF0JXct9KcB+y+sy1kM+P4WdgX6NagW9OXQPl
vga6JHMO9PZ66AF0D0HH0O+GXtJ7U/v+VndG50S5iNAr8Ptzx9IJLYFvhtqw
7QC/BT+ON43nLXuI8VPVApv3ed8AeB/8Ic72w38INRHLaLRv3dGG7VnRvrvx
8RP8j9AHwT1ZDv9Zbtty5D9E94h64w/kx+BvhRZJBi7ivyxzv6imikV3yLdi
aoBfhf5C8AJoc+4eVu8+wh3L9XbOmuAPc/a6ahFdm484q4iusWpbAb2AfAP4
N/hW7pyDfOB0P43lfW8jfze69opJufoOPJI4Z5XE+gw6HejOgK7m7p7UsdRB
3eCnoU3wncSzFv27oHXgdWXO1Zkl50Y5099sxf62xH/0DnApOlc6+z56JmgW
KAb1whOpe1c9ob8WMseueO+D3wDNLfMM+BL5F1AL/DvIV2I7NXPsV3G2A5xE
99KjxDgLfhT5SeS1iWulGij3qtnFyC7L3Lu6Q72inCvX6pk28IPgc/B3A/I3
wX25e01/RLnYmfkvKictyPam7r1F0P3g58H3Il8PHoE/lTt3BwuuXW9mXjU8
EV1j1VZ/crHeHj17lkKrwVOxP6PommnWTsPHhWM8c6fDXwR9EzwDTmJ7aea/
pxl4gvt3gfepduhXYn82eHvBM6YPvj/zrNRM0ax7OfNf1sw7ED3DNLsGwY3c
NRTdG+rpanBVyblSTA2ZZ6xmq2ZEVeadoV2hGay3dEXPAr1pFr4Pg79OvFNq
kV+e+29pxnalnhH6v62i3DlXrvVnCty1LfVfSLjzX+6qi669ekC1qC95Vqsm
Pci2R/eOds6dyK/NPXs1IxvBjeDZRc9k7ZrR1L61c2rA03P3omLW39OM0WzR
H1Sv/po71+rZI9g+mTl3yvkg/OzT8elN2g1HU+8m7Yj21DtPu04z+G/kpzK/
XTYPIVuSuTf+79HUO1W7VDNSu2hyybtYO+mp3H9Ef0N/ehB8JPes0U7W7hsX
PVu1A7VrPo/exdo5DblnhGaDcrI1dY+rt9VT/wFEzQNi
         "],
         VertexColors->None], 
        PolygonBox[{{2257, 1871, 1010, 2300, 2256}, {2324, 2257, 2256, 2325, 
         1031}},
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl21sluUVx+/nuV+fZzpD5iCzMmO0UGgRNBMXnBaptAqslZJUmTDAgNuM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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlW1olmUUx+/nvrf7uu+HVISYYBRJtlXbfInU0HKabnv2YnMLzNTVJs5Q
ahGBFFZUZCTEMLepSR+ipgWCUEEWYX4yS9AyyjSogUaxLdfrrISw35//Pvzh
nOu8X9c555q18bGO3jiKoh2gDPwUoqgIJgpRdBk0pVHUWYyibeVR9CLyMfhL
eRQNY3QM+VZkveg/Bb0PnWfhp8AfQPcK/Bj0KDgDPwWb57FflUVRPfQMbD6F
vgM8B306IRb0VPAq9CZwI/QhcAS6GpzHfh/826JJ+Bl8R+QzAV+Jzwb4P5CP
wNfBbyefA5lzHSefGP57dH5BlsB3I+uazKeIzU78b8gcuwf/tfi+G5s6dNeg
Mwg/hE4fslfAMXz9hf7oZLwG6NrgWtrAROacJBuD/wp6BPt3E9/hTcj3wD8O
Pxc8mNuHbNeWOdbD2HTHkzGh7yOfB8inlrMK6JnBd1sFdmM/AHaiu4Gat+ht
0DmB/mBkeqvqL/isLHMNym8aMWdnzkm5zAOfIzupO0d/CMzAdwVo1fuDWdB3
Iq/C92z0O9B/GfuBxG+yH/o1sLTgN/tSsdC/gfx+wL4G+9OcNWB/HWf/qXb4
0uR71JDvbWAuuc4DU4N7TL2lGhZivwBUYlsFPsL3YXwcxXYH8mH02zjbhL9x
sBa6A/0Suu8R81voQfSHlBtnJ9Efzt1bi5AvSZ2zcq3g7J3cM6FZeB2+hO0c
5F9g3w7+gV8SnPs46If/Bv23oN8EG5GtIP9G8t+Mj7+RP4m8GdklMJA5B8WW
zYfBPalePE4OvdCt5LAcvl93pvcHqxPPyK3Q1cGzUEuMntQ1KPfbE89yHNwb
muly4l2dzHd64tn8N3PumonfoX8DPxLrZ84aM/eoelMxmzLfgWrvAI/gazMx
+sq9Q9QLumPdrXpiD/Te3LOzDZ+HyO2a4F1zmLOZ6Ffn7oUq9N9Hfgo+ib1j
bka3Bp3Fid+4Bf4K/MHY+X4AfwT0FZzz/tQ7QLN/b8G26/DXUWYf/bl3gnaB
ZmY78pfALmQvaOcUPWOaLfVgc+qeUi9pJrcgW5+6lwaRPxp8JjqOfRdrUr+V
7uRs6p5QL6jntAtUs2rVTjgefKe6yzPYL8e+i7OV2K4Ai9GvzD2bmpl16K7P
3BuquVK+Mr+1Zq4R218zv5124onMO0S7Qz37tXoj8+y+AfZCn0s969pJLcQ6
mLrX1XMjwTWqtsvgWujpRdN6oz+xbwreddqJ3cE1KPd6cBf0KP4uxN6ppWAb
6S6Evwf5d8GzoZqXafcW/Xaace2iXZlz1U5aiqwT/ftj++xK/Wfor9BOOhuc
g2JfRH4e+hzoQfZQ7F44Cv9Z7J64CH0heFdqZ7RDX838Ftp59cRbCU4VPMMl
6J5gX/pT9HdNA9cn/sN2B9eo2tSj+is+Cf77VLN6TTtAs6+e+5j8k8y7WDnN
yf0H6e/RzmwhXnPRs9OmnYhsfu7adAerc8+UZqkRzMfX05l7WX/sAsmCd7dy
fAL6lqJ3hf6UZejWZd6d2kmdqf94/e36w3V3i3LvWt1he+6YiqWd2oruqqJz
0x39D1R0BlA=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV0tsVVUUve19992PUhqDygApJKKg4YUmEmkttWCF8tWCpYV+fG2p/BJR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllV1ol2UYxp//5/O+rzkP7EPIT9BSg7lB5jbd8mN+Tattltt0m3O6Pia4
ch3YQYKgIYqI4jQ7NGgdBZ2oR0KxMBBBMJUkDMrwI6MMN80i+11dBxfc13tf
z/08z/3c9/3O6B1o3Z4PIQyCIjhXDuFxEsL9QghDuRA2Yz+OIczCfpNvX+Nv
zUJoL4VwiG9X4ENoXiXIp/CVaP+EV6BdzLe58Ah/El4Au7DPsGYP2kn4E/gL
aCqJ9xT+npQ9wUV8VXmvnYM/X3CMenhD4r0Vo4WzZPBK7DZi7EDbzLf1JZ/x
OHudwP85a3eA8/AS8R9hn2DNc4k18lWDpfCx6LOuBRew5xOvhlg15Od7tD+y
/ipn+4z1Y+hnRt/lLvoVaLfCu+G3wWT8z4If0N6Br8G3Cd6H9nfQRLxu1nxA
/I+I30/snfAReCP6a/hr4Avhw8Q4p7sqX/hOguX4loFO7FVouvB3gmloJxN/
FHs1+iV5v8lXxDsNH4EfhH+L/SLrF7B2Nvu/Dd8M3w3/lRhrse+z5hb6Fr4t
hfeg2Qi/CeZx3i74YnzTKaD30f7BnreIXQs2YHeAXuwtIIf+dfQPsMfAIPa6
zHcZBBPRPo0mIdZ01Qz2G2j+wn5Y8Fu/y7dtRb+5zvpa2bnTmd9B+xO4R6w+
8BL+DngdvlqwD207MXqINZX1vfiuRd9FOVyC/yr8F+wOcAX7MmgLvvNd/Jui
fTfAEezD4EDOOb6O/zt4O/aXOb91T+Le0Zuv4TyrlUP8zZznKL7LZfeOaqoB
3x342Zxz+mF0j6g3DuEf4O7bQX/ROVCtVEX3impmEbweTCk6xkZ8tfBF+OrB
fGJPSFwbk7jT+ugcK7fqia3YW0B13j24ITqHyp1qsA1exv93wT1Rif0yMVcG
76m7vZK5VnTHvey1J3F+dH/15nvRvaoeHWL9cXCQtV1oqlLXlGppBlgXXTOq
FdVoH3s9n7hXtefCzDlXrhtKfrtGeFfeb7gA/yW+rQquAZ29Hf5PwXeowC5p
ZqF9kHOuOqNjKWdPoB+Xulb+Rf9zdI+oN1RjA5o1mXt1uORefiv6LurpTzjr
x4lnhWbQeGJVpI6lnFSrlzPPGuW8FR5Sv7VmqmrrUeJZIf092Ylnq3qsDbsp
evaoplUbO6PPohpR76nn1ev/9yC+0bJnk3LUHV3TqmXVbEt0D6r39A+IqWeQ
Zo9yplnQmHnWaCYUU89IzUb1qHqlOvXbqWeuw5sy1/pv6AuZv8kulpz7/uhe
1Rvoreoy16re7FjqNdKqRp6BfxFdu5oRZzSLEs8Wzbxvov9h+ndpRtair0s9
ezWTT0XPKM0mzcB86n+C/gWaSfuxt6WuVf3zRqNnpGaj/kFzOMvszLNK/6z/
AMKv18U=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVs1PVHcU/T2GmTfvh8zKpJGPBhOnwAwIY+oHYE1qGhtwYVH8ACr4FU1B
Z/BjQSLpqk0aF9pd/wL3LrtwQ1dNCN2U2IQmjV1MZOFGI2ztOZxDuri839x3
f/fec++593HwRuN8vSWEsAHJQU5CyoUQxvDshgxCBiBLMLoPeY/zVj6EN5CZ
1hA6iyF0QfpweRPvv4E8T0JYtn0Pzl32UYV8gAxB18RzDvevQsqwOwRZgfyC
d522rUBm8/JFPwliNHi27wfO52voz+R03nbepaB7n+Rk+9j+DwTF4O8OnCNy
n4yyo1/6fwf9/RRYomLw3QPHXIa+nsl3lqgujJvCTyUVDmKqJopVSXQm3lqi
39H6ftvsC6oRcZcSYSkm6sNEUC9qqMNt+J2FPM0JM+MuZcLAHBdhs5DXnTb7
I0beYa/2J8Kw5Hreg+1DyHRQP6lnnv2p8BDLDs6ni+pRu2vLXJn7cKI4xDJk
XNTVfCYW1oh51vOKx1hvgWsOfldtO+xavEaMKcgL94e6Dvuv2abqGrJui8D+
BL7utOrdY/d3w3xin/OwWYPNqxblw7pm5mHmM2tD/MRegqKdSuj+xZ2LkPGg
nvzovrCeW+Y/ca275os+E9eviPl9UXf+AtYvC8I+gfNl6E+bv0/dR/5OzMFp
2ByLqsXfkEnICGwuQp/L/p8xPvuhX8PzGe7+bD4SC/tLzOdsQ92W9azvlH1u
I6+b8PsHdD8w36J8Xc8pH+ZVNQdHId+ag+TSkbxmmNygjvykf/J/zjY3ke8t
yLx189Z3e1Y/9XPH5wHvIMYbRl7LUX5Z/5K5tOTZa7qHJfexwzuDeDnHa55l
zmvDM0v+sG9N7yHyIHqnzTr/l8a9O4OeZ/KKNeK8zAQ9H5nPtIvOYRR/RiAV
74CrxnsIWHaK8k1OvDSX2mC7D/Ixp9kdd50rfrJH58xl4roFP2eQ8Hhe3GQv
9+7wTPsp2CSZ7pFP0bxf8R6kL+bXD/kuaC4/Aw/Osr+4OxLle49/9EkObpp3
A94B7CHnrOy5o4+y/ZCbr8y9Qduyvxvw/09Bs7WJZ5opxjr0rZliMP5sqhwq
7it3WZ9zZh96C4p3z3PIWrPOnMeGZ/CR9xvtr8P3tUz8PQz/tVT8nU+1j1bt
s+5ZXvEOIS76q7vXnL9LqfCRmwuZ+Hk3r/mnH+Ibi8LI2veYh18VtAumPe89
5hgx9bkX64616v3MWs5437a5FkPegU1/yzrM+Svg108Fze5D79vdu63iC+vA
XdiSqTdj/s4OeI44C033lt+kds97zbNRdR+6vOvumq9l92LCZ87vWXP4uXlL
bjMebQqIfzkVpybNKXKM++ajv/FjvkNecxev+dvc6W8b8zsaxRty5nc8t1Pt
/m7nzv8BPo96Rz136kwqXp+I4h+5t+DejZvDvcbSZ66xhrvfXu/PvflkPS7B
TyPq3Qu/o58/Eed41DftPJ6/FbTrT6FHXxT1/Sa/X3uG2fNe85lYucvfuX4V
74F158ncON8XUs34lVQ1ZS1Pup+D3hsbnvfd/2VSfXNGo/Jj7P8AC8Xwig==

         "],
         VertexColors->None], 
        PolygonBox[{{2306, 1876, 591, 726}, {2114, 2606, 1330, 549}, {2308, 
         1877, 592, 730}, {1672, 2036, 769, 865}, {1883, 2618, 736, 597}, {
         2311, 1880, 593, 731}, {1906, 2642, 910, 626}, {2316, 2314, 623, 
         1023}, {1875, 2612, 724, 591}, {1834, 2038, 549, 548}, {2671, 1912, 
         632, 1371}, {2317, 1727, 715, 1024}, {1886, 2649, 1388, 449}, {2415, 
         2416, 791, 632}, {1601, 2650, 1391, 89}, {2135, 2136, 865, 578}, {
         1727, 2180, 911, 715}, {2641, 1905, 626, 791}, {2400, 2605, 1329, 
         1116}, {2036, 2315, 1023, 769}, {2360, 1892, 1353, 1065}, {1600, 
         2004, 737, 73}, {1878, 2309, 726, 592}, {2605, 1840, 1126, 1329}, {
         1882, 2616, 731, 596}, {1841, 2402, 1118, 1330}, {2615, 1881, 596, 
         736}, {2404, 1988, 276, 1119}, {1879, 2613, 730, 593}, {2108, 1720, 
         901, 838}, {1730, 2110, 839, 910}, {2314, 2318, 1024, 623}, {2361, 
         2360, 1065, 1066}, {2109, 2108, 838, 839}, {2181, 2142, 400, 911}, {
         1891, 2652, 1396, 462}, {2402, 2403, 1119, 1118}, {2410, 2646, 1371, 
         1126}, {2142, 2411, 1127, 400}, {2652, 1604, 89, 1396}, {2294, 1866, 
         578, 956}, {2649, 1600, 73, 1388}, {2619, 1884, 597, 737}, {2076, 
         2011, 105, 808}, {1988, 2401, 1116, 276}, {2037, 1833, 548, 724}, {
         2174, 1828, 956, 901}, {2011, 2362, 1066, 105}, {2630, 1781, 462, 
         1353}, {2650, 1887, 449, 1391}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{271, 246, 245}, {271, 294, 246}, {256, 271, 245}, {256, 
        245, 14}, {271, 289, 15}, {289, 271, 256}, {294, 271, 15}},
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1674, 2411, 2142, 2181, 2180, 1727, 2317, 2318, 2314, 2316, 
         2315, 2036, 1672, 2136, 2135, 1866, 2294, 1828, 2174, 1720, 2108, 
         2109, 2110, 1730, 2642, 1906, 2640, 1905, 2641, 2058, 2416, 2415, 
         2414, 1912, 2671, 2646, 2410, 2680, 1840, 2605, 2400, 2401, 1988, 
         2404, 2403, 2402, 1841, 2606, 2114, 2038, 1834, 2055, 1833, 2037, 
         1992, 2612, 1875, 2305, 1876, 2306, 1739, 2309, 1878, 2307, 1877, 
         2308, 1997, 2613, 1879, 2310, 1880, 2311, 1754, 2616, 1882, 2614, 
         1881, 2615, 2003, 2618, 1883, 2617, 1884, 2619, 1758, 2004, 1600, 
         2649, 1886, 1772, 1887, 2650, 1601, 2007, 1604, 2652, 1891, 1781, 
         2630, 1892, 2360, 2361, 2362, 2011, 2076, 2075}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1805, 2686, 1806, 1797, 1898, 2681, 1897, 2018, 2019, 1896, 
         2657, 1615, 2015, 1610, 2654, 1895, 1700, 2453, 2455, 2454, 2563, 
         2014, 2634, 2635, 2633, 2637, 2636, 1780, 2628, 2629, 2627, 1890, 
         2010, 2626, 1888, 2625, 1889, 2006, 2005, 2353, 2352, 2351, 1885, 
         2622, 1770, 2620, 2621, 2349, 2350, 1599, 2000, 1595, 1637, 2087, 
         2086, 1687, 2201, 2202, 2200, 1753, 2527, 1994, 2196, 1749, 2195, 
         1750, 2197, 2519, 2184, 1874, 2304, 1917, 2056, 1835, 2601, 2600, 
         1907, 2643, 1932, 2247, 1838, 2120, 2121, 1989, 1735, 2303, 1873, 
         2067, 2326, 2327, 1966, 1589, 2063, 2062, 2141, 2140, 1673, 1976, 
         2139, 2138, 2137, 1729, 1975, 1974, 1652, 2288, 2289, 2287, 1863, 
         2290, 1862, 2293, 1865, 2291, 1864, 1938, 1937, 2298, 1867, 2143, 
         2144, 2145, 2047, 2053}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2324, 2257, 1871, 2301, 1851, 2296, 2297, 2125, 1665, 2043, 
         1666, 1982, 2292, 1983, 2052, 2051, 1723, 1981, 2394, 2092, 1829, 
         2222, 1721, 2111, 2112, 1656, 2295, 2182, 2171, 2172, 2097, 2100, 
         2246, 1837, 2118, 2398, 2119, 2585, 2586, 2587, 2218, 2219, 2080, 
         1632, 1590, 1945, 1592, 2337, 2070, 1748, 2192, 1738, 1993, 1751, 
         2198, 1752, 2199, 1686, 2083, 2084, 2085, 2342, 1594, 1998, 2348, 
         2347, 2074, 1769, 2002, 2001, 2541, 1771, 2213, 2683, 1690, 2429, 
         1691, 2623, 2624, 2357, 2358, 2359, 2008, 2009, 1894, 2631, 1893, 
         2632, 2013, 2562, 2451, 2452, 2450, 1699, 1794, 2653, 1609, 2472, 
         1702, 2379, 2380, 1646, 1614, 2017, 1622, 2662, 1900, 1802, 2022, 
         1803, 2676, 1804, 1707, 2384, 2385, 2386, 1624, 2023, 1627, 2665, 
         1901, 2025, 2024, 2577, 1812, 2509, 1715, 2508, 1716, 1902, 2666, 
         1629, 2026, 2027, 1819, 2581, 1818, 2582, 2603, 2602, 2604}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1631, 1650, 2393, 2392, 2517, 2516, 1628, 2391, 2390, 2389, 
         1714, 2507, 1626, 2664, 1811, 1710, 2497, 1709, 2498, 1807, 2490, 
         1706, 2487, 2489, 2488, 2572, 2020, 2021, 1899, 2661, 1621, 2016, 
         1613, 1645, 2378, 2377, 2471, 2470, 1608, 2376, 2375, 2374, 1698, 
         2449, 1607, 2363, 1788, 2561, 1695, 2436, 1694, 2684, 2214, 1779, 
         2553, 2162, 2163, 2161, 2212, 2211, 2540, 1999, 2210, 1767, 2209, 
         1768, 1954, 1953, 1593, 1636, 2082, 2081, 1685, 2421, 2154, 2338, 
         1921, 1920, 1996, 1679, 1991, 1737, 1943, 1736, 2233, 2234, 2101, 
         2395, 1653, 2034, 2099, 2098, 2225, 1831, 2591, 2588, 2590, 2679, 
         2589, 2396, 2595, 2597, 2596, 2594, 2127, 2408, 1667, 2032, 1668, 
         2129, 2128, 1854, 2273, 1934, 2048, 1853, 1984, 2126, 2044, 2266, 
         1845, 2261, 1852, 2251, 1850, 2300, 2256, 2325, 1588}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1587, 2255, 2258, 2250, 2260, 2259, 1844, 2265, 2267, 2262, 
         2264, 2263, 1661, 2610, 2611, 2272, 2275, 2274, 1822, 2270, 2271, 
         2268, 2609, 2608, 2269, 2242, 2243, 2224, 2227, 2226, 1824, 2231, 
         2232, 2228, 2230, 2229, 1990, 1942, 1944, 1872, 1947, 1946, 2526, 
         2193, 2194, 2153, 2156, 2155, 2532, 2207, 2208, 2157, 2159, 2158, 
         2539, 2425, 2426, 2424, 2428, 2427, 2552, 2432, 2433, 2431, 2435, 
         2434, 2560, 2445, 2446, 2444, 2448, 2447, 2567, 2466, 2467, 2465, 
         2469, 2468, 2570, 2474, 2475, 2473, 2477, 2476, 2571, 2483, 2484, 
         2482, 2486, 2485, 2575, 2493, 2494, 2492, 2496, 2495, 2576, 2503, 
         2504, 2502, 2506, 2505, 2579, 2515, 1226, 218}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2276, 2277, 2253, 2279, 1846, 2249, 1847, 2254, 1843, 2042, 
         2124, 1979, 1849, 2046, 1933, 2248, 1839, 2122, 2399, 1662, 2031, 
         2312, 2313, 2299, 1870, 2106, 1869, 2223, 1830, 2093, 2095, 2096, 
         2033, 2583, 2584, 2215, 2217, 2216, 2302, 2054, 2117, 2116, 2115, 
         1909, 2113, 1657, 1995, 1658, 2397, 2599, 2598, 1832, 2687, 2525, 
         1747, 2673, 2191, 2672, 1684, 2420, 2150, 2152, 2689, 2151, 2206, 
         1951, 1952, 1766, 2538, 1765, 1639, 1598, 2422, 2423, 2366, 2367, 
         1641, 1603, 2430, 1693, 2368, 2369, 2559, 1787, 2558, 1786, 2442, 
         1696, 2441, 1697, 2443, 1793, 2566, 2461, 2462, 2460, 2464, 2463, 
         2569, 1963, 1619, 2660, 1801, 1929, 1647, 1620, 2480, 2481, 2381, 
         2382, 2383, 1623, 2491, 1708, 2387, 2388, 1810, 2677, 1809, 2500, 
         1712, 2499, 1713, 2501, 1815, 2578, 2511, 2512, 2510, 2514, 2513, 
         2580}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1630, 1649, 2077, 2028, 1816, 2060, 1817, 1916, 2682, 1915, 
         1813, 2678, 1814, 2091, 2090, 1711, 2164, 2364, 2365, 1648, 1930, 
         1808, 2663, 1625, 1964, 2573, 2574, 2479, 1705, 2478, 1704, 1800, 
         2659, 1618, 1928, 1927, 1799, 2658, 1617, 1962, 2568, 2458, 2459, 
         2456, 1701, 2457, 1791, 2564, 1792, 2565, 2373, 2372, 2440, 2439, 
         1606, 1643, 1784, 2557, 1785, 1960, 1959, 2549, 1778, 2548, 2551, 
         2550, 2089, 2088, 1689, 2160, 2345, 2346, 1638, 1924, 1764, 2071, 
         2072, 2073, 1950, 2204, 2205, 2149, 1683, 2419, 1682, 2335, 2685, 
         1746, 2524, 2336, 1919, 1918, 2190, 1745, 2068, 2069, 1591, 2244, 
         2245, 2168, 2169, 2167, 1717, 2170, 1676, 1940, 2094, 2165, 2518, 
         2166, 2104, 2667, 2103, 2668, 1654, 2179, 1655, 2107, 2105, 1719, 
         2176, 1725, 2175, 1724, 1977, 1722, 2049, 2050, 1980, 2284, 1978, 
         1664, 2041, 1663, 2123, 2282, 2281, 1848, 2278, 1856, 2252, 1855}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1616, 1798, 1703, 1796, 2656, 1612, 1644, 1926, 1795, 2655, 
         1611, 1961, 1789, 2675, 1790, 2371, 2370, 2438, 2437, 1605, 1642, 
         1783, 2554, 2556, 2555, 1692, 2546, 2547, 2354, 2355, 2356, 1640, 
         1776, 2545, 1777, 1957, 1956, 2536, 1762, 2535, 1763, 2537, 1923, 
         2533, 2534, 2343, 2344, 1597, 1949, 2203, 2147, 2688, 2148, 2418, 
         2417, 1681, 2331, 2647, 2332, 2189, 2523, 2333, 2334, 1634, 2522, 
         1743, 2187, 1744, 2188, 1678, 1941, 1733, 2040, 1734, 1987, 1823, 
         1939, 1675, 1985, 1731, 2059, 1913, 2323, 2065, 2066, 1965, 1969, 
         1970, 1914, 1972, 1971, 1669, 1973, 2221, 1826, 2220, 1827, 1968, 
         1967, 1651, 2644, 2645, 2320, 1910, 2321, 1858, 2286, 1861, 2285, 
         1860, 1936, 1935, 2280, 1857, 2130, 2132, 2133, 2045, 1670}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1782, 2012, 1958, 2543, 1774, 2542, 1775, 2544, 1925, 1773, 
         2651, 1602, 1955, 1760, 2674, 1761, 1922, 1759, 2648, 1596, 1948, 
         1688, 2531, 1757, 2339, 2340, 2341, 1635, 2529, 1755, 2528, 1756, 
         2530, 1680, 2328, 1742, 2521, 2329, 2330, 1633, 2520, 1740, 2185, 
         1741, 2186, 1677, 2183, 1732, 2064, 2078, 2079, 2319, 1908, 2669, 
         1659, 2039, 1660, 2670, 1836, 1931, 2607, 1842, 2405, 2406, 2407, 
         1986, 2029, 1820, 2061, 1821, 2030, 1868, 2322, 1911, 2146, 2412, 
         2413, 2057, 1903, 2638, 1904, 2639, 1728, 2178, 2177, 2102, 1718, 
         2173, 1825, 2283, 1859, 2134, 2409, 1671, 2035, 2592, 2593, 2239, 
         2241, 2240, 1726, 2237, 2238, 2131, 2236, 2235}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{-3, 3}, {
      Rational[1, 10], 5}}, {{-3, 3}, {0.1, 5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84239030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->90684142],

Cell["Normally distributed points in the plane:", "ExampleText",
 CellID->478465894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2000", ",", "2"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773766157],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83890366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->317250630],

Cell["Normally distributed points in 3D:", "ExampleText",
 CellID->81925240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"5000", ",", "3"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->462882338],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->163647935]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31323],

Cell["Its probability density function integrates to unity:", "ExampleText",
 CellID->4348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"NormalDistribution", "[", 
      RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Im", "[", "\[Mu]", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{"\[Sigma]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16031],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372599400]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117124851],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StudentTDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StudentTDistribution"]], "InlineFormula"],
 " goes to a normal distribution as ",
 Cell[BoxData[
  FormBox["\[Nu]", TraditionalForm]], "InlineMath"],
 " goes to ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->613077661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"StudentTDistribution", "[", "\[Nu]", "]"}], ",", "x"}], "]"}], 
   ",", 
   RowBox[{"\[Nu]", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621668576],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472501237]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"0", ",", "1"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->935210979],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}]], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{43, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92998172]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4026631],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LogNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogNormalDistribution"]], "InlineFormula"],
 " is logarithmically related to ",
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->558417638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"LogNormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395883545],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Mu]"}], "+", 
        RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "x", " ", "\[Sigma]"}]]], "Output",
 ImageSize->{85, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->531305099]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", 
    RowBox[{"Log", "[", "x", "]"}]}], "]"}], " ", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Log", "[", "x", "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->586952983],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[Mu]"}], "+", 
        RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"], 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Sigma]", "2"]}]]}]], 
  RowBox[{
   SqrtBox[
    RowBox[{"2", " ", "\[Pi]"}]], " ", "x", " ", "\[Sigma]"}]]], "Output",
 ImageSize->{85, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88692705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134216175],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HalfNormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HalfNormalDistribution"]], "InlineFormula"],
 " density is proportional to ",
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 " for positive values:"
}], "ExampleText",
 CellID->170016638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"HalfNormalDistribution", "[", "\[Theta]", "]"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->727439971],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["\[Theta]", "2"]}], "\[Pi]"]}]], " ", "\[Theta]"}], 
  "\[Pi]"]], "Output",
 ImageSize->{67, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->514713394]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"NormalDistribution", "[", 
     RowBox[{"0", ",", 
      RowBox[{
       RowBox[{"Sqrt", "[", 
        RowBox[{"\[Pi]", "/", "2"}], "]"}], "/", "\[Theta]"}]}], "]"}], ",", 
    "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33767499],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       SuperscriptBox["x", "2"], " ", 
       SuperscriptBox["\[Theta]", "2"]}], "\[Pi]"]}]], " ", "\[Theta]"}], 
  "\[Pi]"]], "Output",
 ImageSize->{67, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->934331569]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11362],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  FormBox["\[Mu]", TraditionalForm]], "InlineMath"],
 " is not a real number:"
}], "ExampleText",
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "I"}], ",", "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17867],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->294006424],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{
    RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "6"}], "]"}], "]"}]], "Output",
 ImageSize->{232, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74949631]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NormalDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NormalDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  FormBox["\[Sigma]", TraditionalForm]], "InlineMath"],
 " is not a positive real number:"
}], "ExampleText",
 CellID->3568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "6"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5392],

Cell[BoxData[
 RowBox[{
  RowBox[{"NormalDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-6\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->673168865],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"NormalDistribution", "[", 
   RowBox[{"3", ",", 
    RowBox[{"-", "6"}]}], "]"}], "]"}]], "Output",
 ImageSize->{219, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37583384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"NormalDistribution", "[", 
    RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Mu]", "->", "I"}], ",", 
    RowBox[{"\[Sigma]", "->", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2647],

Cell[BoxData["\[ImaginaryI]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314962371]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23000],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HalfNormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HalfNormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Erf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Erf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseErf",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseErf"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23965]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4689],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with NormalDistribution",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
NormalDistribution"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->72958396],

Cell[TextData[ButtonBox["Functions Used in Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInStatistics"]], "MoreAbout",
 CellID->181196522],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->680258068],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->938589208],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->121638156],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->352879068],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->56695546]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NormalDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 30.3421532}", "context" -> "System`", 
    "keywords" -> {
     "Gauss integral", "Gaussian distribution", "Gaussian integral", 
      "standard normal distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "NormalDistribution[\\[Mu], \\[Sigma]] represents a normal (Gaussian) \
distribution with mean \\[Mu] and standard deviation \\[Sigma]. \
NormalDistribution[] represents a normal distribution with zero mean and unit \
standard deviation.", "synonyms" -> {"normal distribution"}, "title" -> 
    "NormalDistribution", "type" -> "Symbol", "uri" -> 
    "ref/NormalDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8534, 251, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->13187464]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 131775, 2956}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3321, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3944, 100, 1583, 37, 70, "ObjectNameGrid"],
Cell[5530, 139, 1116, 34, 70, "Usage",
 CellID->15871]
}, Open  ]],
Cell[CellGroupData[{
Cell[6683, 178, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7161, 195, 636, 23, 70, "Notes",
 CellID->429991538],
Cell[7800, 220, 697, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[8534, 251, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->13187464],
Cell[CellGroupData[{
Cell[8918, 265, 146, 5, 70, "ExampleSection",
 CellID->9379783],
Cell[9067, 272, 200, 3, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[9292, 279, 176, 5, 28, "Input",
 CellID->24173],
Cell[9471, 286, 162, 5, 36, "Output",
 CellID->138283537]
}, Open  ]],
Cell[CellGroupData[{
Cell[9670, 296, 179, 5, 28, "Input",
 CellID->8902],
Cell[9852, 303, 188, 6, 36, "Output",
 CellID->334863141]
}, Open  ]],
Cell[10055, 312, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[10177, 317, 182, 3, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[10384, 324, 200, 6, 70, "Input",
 CellID->30324],
Cell[10587, 332, 477, 17, 73, "Output",
 CellID->209770377]
}, Open  ]],
Cell[CellGroupData[{
Cell[11101, 354, 330, 11, 28, "Input",
 CellID->20649],
Cell[11434, 367, 3127, 55, 175, "Output",
 Evaluatable->False,
 CellID->31536419]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14610, 428, 216, 7, 70, "ExampleSection",
 CellID->24588],
Cell[14829, 437, 116, 3, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[14970, 444, 196, 6, 70, "Input",
 CellID->5765],
Cell[15169, 452, 584, 14, 54, "Output",
 CellID->141461717]
}, Open  ]],
Cell[15768, 469, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[15891, 474, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15999, 479, 179, 5, 70, "Input",
 CellID->6096],
Cell[16181, 486, 158, 5, 36, "Output",
 CellID->219242895]
}, Open  ]],
Cell[CellGroupData[{
Cell[16376, 496, 179, 5, 70, "Input",
 CellID->6916],
Cell[16558, 503, 157, 5, 36, "Output",
 CellID->63972662]
}, Open  ]],
Cell[16730, 511, 121, 3, 70, "ExampleDelimiter",
 CellID->24103],
Cell[16854, 516, 243, 9, 70, "ExampleText",
 CellID->5694],
Cell[CellGroupData[{
Cell[17122, 529, 205, 6, 70, "Input",
 CellID->18627],
Cell[17330, 537, 348, 12, 38, "Output",
 CellID->446232048]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17727, 555, 223, 7, 70, "ExampleSection",
 CellID->28359],
Cell[17953, 564, 362, 13, 70, "ExampleText",
 CellID->813014373],
Cell[CellGroupData[{
Cell[18340, 581, 163, 5, 70, "Input",
 CellID->338871180],
Cell[18506, 588, 321, 12, 58, "Output",
 CellID->446157531]
}, Open  ]],
Cell[18842, 603, 175, 7, 70, "ExampleText",
 CellID->326644389],
Cell[CellGroupData[{
Cell[19042, 614, 188, 6, 70, "Input",
 CellID->944228315],
Cell[19233, 622, 371, 14, 58, "Output",
 CellID->102500314]
}, Open  ]],
Cell[19619, 639, 243, 9, 70, "ExampleText",
 CellID->86298351],
Cell[CellGroupData[{
Cell[19887, 652, 188, 6, 70, "Input",
 CellID->892686001],
Cell[20078, 660, 246, 9, 53, "Output",
 CellID->540164673]
}, Open  ]],
Cell[20339, 672, 125, 3, 70, "ExampleDelimiter",
 CellID->108324723],
Cell[20467, 677, 112, 3, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[20604, 684, 330, 11, 70, "Input",
 CellID->12368],
Cell[20937, 697, 2714, 49, 70, "Output",
 Evaluatable->False,
 CellID->233452814]
}, Open  ]],
Cell[23666, 749, 125, 3, 70, "ExampleDelimiter",
 CellID->197502749],
Cell[23794, 754, 238, 9, 70, "ExampleText",
 CellID->2750],
Cell[CellGroupData[{
Cell[24057, 767, 447, 14, 70, "Input",
 CellID->19414],
Cell[24507, 783, 74563, 1255, 70, "Output",
 CellID->84239030]
}, Open  ]],
Cell[99085, 2041, 124, 3, 70, "ExampleDelimiter",
 CellID->90684142],
Cell[99212, 2046, 84, 1, 70, "ExampleText",
 CellID->478465894],
Cell[CellGroupData[{
Cell[99321, 2051, 298, 9, 70, "Input",
 CellID->773766157],
Cell[99622, 2062, 11537, 193, 70, "Output",
 Evaluatable->False,
 CellID->83890366]
}, Open  ]],
Cell[111174, 2258, 125, 3, 70, "ExampleDelimiter",
 CellID->317250630],
Cell[111302, 2263, 76, 1, 70, "ExampleText",
 CellID->81925240],
Cell[CellGroupData[{
Cell[111403, 2268, 300, 9, 70, "Input",
 CellID->462882338],
Cell[111706, 2279, 4186, 73, 70, "Output",
 Evaluatable->False,
 CellID->163647935]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[115941, 2358, 233, 7, 70, "ExampleSection",
 CellID->31323],
Cell[116177, 2367, 91, 1, 70, "ExampleText",
 CellID->4348],
Cell[CellGroupData[{
Cell[116293, 2372, 573, 17, 70, "Input",
 CellID->16031],
Cell[116869, 2391, 158, 5, 36, "Output",
 CellID->372599400]
}, Open  ]],
Cell[117042, 2399, 125, 3, 70, "ExampleDelimiter",
 CellID->117124851],
Cell[117170, 2404, 397, 13, 70, "ExampleText",
 CellID->613077661],
Cell[CellGroupData[{
Cell[117592, 2421, 282, 9, 70, "Input",
 CellID->621668576],
Cell[117877, 2432, 325, 12, 68, "Output",
 CellID->472501237]
}, Open  ]],
Cell[CellGroupData[{
Cell[118239, 2449, 193, 6, 70, "Input",
 CellID->935210979],
Cell[118435, 2457, 324, 12, 68, "Output",
 CellID->92998172]
}, Open  ]],
Cell[118774, 2472, 123, 3, 70, "ExampleDelimiter",
 CellID->4026631],
Cell[118900, 2477, 379, 12, 70, "ExampleText",
 CellID->558417638],
Cell[CellGroupData[{
Cell[119304, 2493, 207, 6, 70, "Input",
 CellID->395883545],
Cell[119514, 2501, 547, 19, 73, "Output",
 CellID->531305099]
}, Open  ]],
Cell[CellGroupData[{
Cell[120098, 2525, 346, 11, 70, "Input",
 CellID->586952983],
Cell[120447, 2538, 546, 19, 73, "Output",
 CellID->88692705]
}, Open  ]],
Cell[121008, 2560, 125, 3, 70, "ExampleDelimiter",
 CellID->134216175],
Cell[121136, 2565, 398, 12, 70, "ExampleText",
 CellID->170016638],
Cell[CellGroupData[{
Cell[121559, 2581, 182, 6, 70, "Input",
 CellID->727439971],
Cell[121744, 2589, 404, 14, 64, "Output",
 CellID->514713394]
}, Open  ]],
Cell[CellGroupData[{
Cell[122185, 2608, 321, 11, 70, "Input",
 CellID->33767499],
Cell[122509, 2621, 404, 14, 64, "Output",
 CellID->934331569]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[122962, 2641, 226, 7, 70, "ExampleSection",
 CellID->11362],
Cell[123191, 2650, 308, 10, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[123524, 2664, 190, 6, 70, "Input",
 CellID->17867],
Cell[123717, 2672, 211, 5, 70, "Message",
 CellID->294006424],
Cell[123931, 2679, 294, 9, 36, "Output",
 CellID->74949631]
}, Open  ]],
Cell[124240, 2691, 320, 10, 70, "ExampleText",
 CellID->3568],
Cell[CellGroupData[{
Cell[124585, 2705, 184, 6, 70, "Input",
 CellID->5392],
Cell[124772, 2713, 199, 5, 70, "Message",
 CellID->673168865],
Cell[124974, 2720, 277, 9, 36, "Output",
 CellID->37583384]
}, Open  ]],
Cell[125266, 2732, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[125390, 2737, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[125559, 2745, 332, 11, 70, "Input",
 CellID->2647],
Cell[125894, 2758, 170, 5, 36, "Output",
 CellID->314962371]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[126125, 2770, 311, 9, 70, "SeeAlsoSection",
 CellID->23000],
Cell[126439, 2781, 1256, 44, 70, "SeeAlso",
 CellID->23965]
}, Open  ]],
Cell[CellGroupData[{
Cell[127732, 2830, 313, 9, 70, "TutorialsSection",
 CellID->4689],
Cell[128048, 2841, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[128242, 2849, 305, 8, 70, "RelatedLinksSection"],
Cell[128550, 2859, 378, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[128965, 2876, 299, 8, 70, "MoreAboutSection"],
Cell[129267, 2886, 183, 4, 70, "MoreAbout",
 CellID->72958396],
Cell[129453, 2892, 165, 3, 70, "MoreAbout",
 CellID->181196522],
Cell[129621, 2897, 155, 3, 70, "MoreAbout",
 CellID->680258068],
Cell[129779, 2902, 161, 3, 70, "MoreAbout",
 CellID->938589208],
Cell[129943, 2907, 132, 3, 70, "MoreAbout",
 CellID->121638156],
Cell[130078, 2912, 179, 3, 70, "MoreAbout",
 CellID->352879068],
Cell[130260, 2917, 150, 3, 70, "MoreAbout",
 CellID->56695546]
}, Open  ]],
Cell[130425, 2923, 27, 0, 70, "History"],
Cell[130455, 2925, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

