(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     92747,       1853]
NotebookOptionsPosition[     89132,       1738]
NotebookOutlinePosition[     90506,       1775]
CellTagsIndexPosition[     90420,       1770]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VertexNormals" :> 
          Documentation`HelpLookup["paclet:ref/VertexNormals"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"], 
          "VertexColors" :> 
          Documentation`HelpLookup["paclet:ref/VertexColors"], "Lighting" :> 
          Documentation`HelpLookup["paclet:ref/Lighting"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VertexNormals\"\>", 
       2->"\<\"ColorFunction\"\>", 3->"\<\"VertexColors\"\>", 
       4->"\<\"Lighting\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       2->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["NormalsFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["NormalsFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NormalsFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     " and related functions that specifies a function to apply to determine \
the effective surface normals at every point."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12948]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->12040],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "determine normals from explicit polygon vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "determine normals from overall surface properties", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["f", "TI"], Cell[TextData[{
     "determine normals by applying a function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->409260814],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"NormalsFunction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", the arguments supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " are as follows: "
}], "Notes",
 CellID->26249],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Plot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Plot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ParametricPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ParametricPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContourPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContourPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["w", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RegionPlot3D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RegionPlot3D"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->70264450],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " must return a vector of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["x", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["y", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["z", "TI"]]}], "}"}]], "InlineFormula"],
 ". Only the direction of this vector matters; the vector is in effect \
automatically normalized to unit length."
}], "Notes",
 CellID->440408949]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331617836],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->423320541],

Cell["Use automatic methods to compute surface normals: ", "ExampleText",
 CellID->978114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"NormalsFunction", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716608076],

Cell[GraphicsData["CompressedBitmap", "\<\
eJycvQV8XNeZPnx3ZAfbplvYdnfbf9vtbtvtfjKF06ZJkzYp5MoYO4x2GjTE
zCxbtmVmZmbLJFuWRcPMzMxM976/7zvn3JmRIiv7tX//jkd37twZnfd5Xj7n
juj3Z3w86Yv3Z3zy4fs/ffnL96d+/MmH03/60pQv0am6f6IoqgX9X/NDCh3/
v+iI/G8BAPRCn8cm9DgIvfRL8mwNfqxDT8mz6tlJlWv+rfJzUJ+r8OEvyFUf
9Xvvz/td9V/k/N/6nf2PAa/6uN/Z76IHHnr6IH4yqPd8dYb9r//nyvVUHTqY
NGkSVXkvPvermkxf/aRvox/4I3gVKUfUpMLveqTyc3D1fehTufdx182ovPsB
8jr3Ivf6cPJjWuVTH/qa16f0+T3V1ynybxg5+rzy+VgyanDt/ZWrhpKfn1Y+
43v/yzV/q3wOQaZC1ncJer1z4vVD8/+pIVZDoB/WfSSqfH49ec+Llff8uHL2
3/v9prp+n/U/5F0v3MPNv1Xe/+N+7++vib/+mvf/oPL+n/Z7f39Z/vtr3v/9
ihw/H+D34/NfN+/vVH7vfw2E8ODalRWGvlm5+t++5tMe+QqKb9dPfKd+4uv1
E7lPe+TL+onT6id+Xj/xo/qJn9VPnFU/cX79xHn1E9FvRQcLyDF688K2Qo3+
PpI/3O/5v36Fv29Vfn6bXDWyfiL65R/j3zwVPQyaSX4bOvyifiIP/5ZvzK6f
OL1+Ijq/sH7i0vqJi+snLiIHK+onriSPjehKdEQ9tJycR3NE1ywjr6Jfc1YF
5zVQscW+s8KzHsgDcbMdVcEHs/ogFvJhNIMZ9ROnkJktIrNB05tN0EC/dTmW
YBmWoDYvdIq3Cp9prE52NTqzBv1vQv/X4hmvIefQjJcTMdCvaZeCQAkCFfSo
er1OxbYGxrUB4J4reZXZUw8uucFu7mCPitlLcjjeljlwJXXuLrRJ4JqQUwjq
W9xMlxDI0GRWkZlwJ1eSp2i2aJ5rublTg5vIcXP9xHXkgOLOriOn1tdP3EDk
4c7ehz5fKwKNGDQS0EphAF15cECZ/toHfSLbA3f47I12uHwDDl9mD11hWtqY
9jaWfxt4klssdZ+oFfg34fZ1puVGsb21KGotkXc9vJpMnRs12TiR1hIBKB6a
9WA0beqfaxLV5NhIRNlEjtGnmbpZSzdr7QZLD1gExMr669TA0vy5IsV9VWm+
13GzdOdWof1Wnn+tJLvEdJ9jWk6Uuy6UpedYxbmy9FJB0pKXXyipTrPS0+Xu
swX+ubz8XEF1pqg+W8CfwMNTf2AtEWR1H3G4qdeh+dahyVPf2UCe9xVoE5Fp
MxHIfLdobWds7YyjnXXeBVdHRX3q+kQ44h+olypn7ydCoQPZ8bL4REFwKtd1
Nt1xKSk8k5GdyMmPFhSHisoDJeWhgvJwVnY8JT2Tkp/IqI7k1Yfy6gN52aGM
5mBWczijPprWHElrD+Uogsd9Nexr8A9G0+Wh+fLQhKlvbyTTr0mwuY8Q1tsF
e2vJ2cq4WhnPLfDcZgewaeJrqZ9VLP4nFdn66yKvys+/S4/kpQezsj0Z6a6U
cF+8+0hEdDAm25uQ70oqdqSVu7LKHSnlzrhiT1R+MKo4GFPtSah3J9Q7E5qd
SQ163B3X7I1pd8d1uxK6vSn9vhQn56C+ZGDp6io/qfs4qTYT8Tgh67B8D3EJ
h/16znWt6Lla9l5lfNdY3w3Gd6s8gAScnH3zIPxrf9SHU+rH6ECyNSbdnZAe
SEv3xGXbY7JNEdmGsHhrQLLNL98clG8MKzZHFdviyi1R5caQclNAsc2v2BlQ
bQ2pt6AR1myPabZFtFtC2i0B3ZagbltYtyNC8fTooc6wM8KlGtQgJMYgbDl1
nDyYyEFYpm9uqcrKCee6kvFczvsuFf2XSoEr5cDVUuB6iRqARSIX0ciB/PYP
K1ISL/ktLOVav2RjULI9Itkdk2wPSTcFZOv8sjVeWZNbusYpX+OWr/XKm/08
xcYg9ZCy2atc61audSk3ulTNbvV6r3pTQINk3RzQbvTxtBs81AO6jV7dZp8e
jS1+w9aAcXvIsDtUkRQzSQ42Vcd9ffjznE/5zmUD5/LBC4XgxWLocjHUUuzH
H1XNCaj/7CdZNWPAMZ36L3QgXukUr3JJ1nklmwMSRNtGr2StS7rKKW20S1dY
ZSttshVWeaNNvtqhWOtWrPMompzK1XblaptylVXVZFevc6k3+DSb/JoNXs16
t3adU7vOoUOj2aFf79RvdBs2eYxbfMbtfsMeP9FcTCFvYAkfRhJ6zsR8p5OB
0+ng2UzoXDZ0IRe+mItcykevFAbi8WcDSlnNb3B+QP0KHYiWmEXLLOLlNvFq
p3i9W7zBLVnrkDRaJcvM0qVG6TKTbLlFhh6XGmTLTfJGq6LJoWi0KFaalStM
ypUm1SqLeo1d3ezWrPdomp2atXbtGqt2jUWHxlqrHo1mm2G9w7jRadziNu5w
m7a7zFucxLtii6zjvE3VOHlVWX0nIoHjseDJROh0Mnw2HT6XjpzPRC9mYpey
FHVvRvvTmue5N5urZUE/QwfC+VrhAr1okUG0xCReYRGvsYubbOKVJvFSvWSh
VrJIJ11iqEi7WCdbpJUv1ctXmBTLDIpleiUayw2qlUb1aqt6rUOzzqFZY9Os
NmtXmbSrjLrVJt0aM7JP9PCwYa3Z2Gw1brAbt9hNm+zmjTbLJrt1swPNgHOy
Fek31aQnfmpTRfrAkVDwWDh0Iho+FQufTkTOJqLnkrHzqfjFdJVpLPzPan6o
KmOt3vguOhDMUQlmK4VzVcL5GtFCnWiJQdxoFq8wihdrxfNV4nlKyUKNdLFe
tkRPZNXIFqplC1UUT75YQz2oWKxWLNEol+lUy/WqRpO6yapBY5VJ02igeNqV
OqpOt8qgX23UN5konqHJSD1gXGM0rTObNljMzWbLeotlo9W6yWbbbKtqds0L
f2tTNegHDwdCR4PhY6HIiXDkVDR6JhY7G4ufiycuJJOXUgPw/BMi8YiKxKQK
+h464M+SC+YoBbMVglky4RyFcJ5KtEAjWoZ41ojmKcSzZeK5CskClXSRVrpY
K1ukli1QyRYoZQsUPPkCBfUtxUKlYrFKuUStWqpVrdCrV5nVjUbNSr1muUaL
xgqNbqVOv0qvX23gGVbrqYeMTXoTGmsM5nVGS7PJusFs3WixbbLa0dhsJbqN
ZV1f8czfQJKGDvtDR/zho4HI8WD0RCh2Khw/E0mciyYvxFOXEpWspa+k/4dI
OrTCKakPH8GSzpDyZ8qQpEIirGCGRDhLJpqjEC1UiebKRDMl4tlS8RyZZL6S
4kkXqqnvSpGc8+WyeWjI5GgskCvQWKhQLlaqlqhUy7TqlQb1Cp1mmVqzVKld
ptIuV+lWaPSNWsTqKh31TeMqnXG1ztSkM6/Rm9fqLesM1majbYPJttFs32h2
bDI7N1ucW6zEf+HAS32rmSQMWOZD3vARX+SoP3rMHzsRiJ8MJk6HkmfDqfOR
9MXY18pcX2H3X0i4QQc9X4r50yX8mVLBLLlwtlw4S4rEFkwXCWdKhHOkwhlC
0UyReJYYSS6ZJ5cimucrpehgrlSGh0Q+T4pE5ikWyKiHlQvlqkUKJLh6uUa9
VKVZrMBSY8GVuuVK/Qo1krpRg3S5UWNcpTGt1pqbdJY1OstanXWd3rbewLNv
MFKDHRtNzs0m1xaze6vFs42TneSKj6ytyh4+5Ikc9kaPemPHfPHj/sSpQPJ0
MHU2lD4fzlyIZC9FqQHkr9amPyA4/LrC/Q9JyotxmCbkIyiQ7EjLEQ4zkexi
4XQhxRN+KaC+IZwuEM0QigkWkjky6XwFh4J0jlg2WyybI0ZAEBR+olwgVc6X
qhbKVIvk6iVK9SK5ZrFcu0ShXarQobFMoV+uNKxQGVaqjI0qU6PatFpjbtJa
1mitGAedbZ3Ovl7v2GBwbjQ4NxldW0zurWbPNot3u8W3g0ODeqSphsRBV+Sw
O3rEEzvmjZ/wJU8FUmeC6bOhzPlQ9mI4d4kkMvcPkCN+1ZMTbSC9o1q9/W/o
oHsKv2eqgP+liD9dLECA9IFFOI0vnNYj/JIvmi4QE2AksyXSuTLpHIl0tlg6
SyibLZQTVBAoygUyHoKF+olqvkS1UKpGY5FUs1imXSInqMj1aCyTG5YrjCuU
xpVKU6PKvEptadIQVLS2tVr7Oq29WedYr3Nu0Ls2GdybjZ6tJu82s3e72bfD
4t9pCeyuYPNNhErkoCN6yBU74o4f8yQwKv7UmUD6XBChkkOoXA7/I6j8V0Vv
+tdJRI++gVH6ort7ck/PVD5/GsaK8xrYfGaIkOoglHjCad3U90Vf9oin88Uz
BJJZIoKSCKEkncnngFLMk2CgFiKspCo8JKr5YvUCsWahRLNIql0so3gIJ+qX
VaTkRjRWKkyNSvMqlWW12rpGY0NjrQYh5WjWOjFSOtcmvXuzwbPV6N1m8m03
+XeYAzstwd3W0B5beJ8NARU94IgdcsSPOBPH3MmT3tRpf/qMP3MukL0QzF0M
5a+E81cjVVuqVRsDYPQf0KcfhfPWrs86uj/v6p7c3TOlh4+REQqQ2syS9oUF
ocITIWQeERNkJDOFUoTMTIF0Rk8VFhGCBQOCjGlhBRaKh1ChBmkWirWLJNrF
Ut0SGU+/VMYzLJNR/2lcITetkJtXKsyNSstqlbVJbVujtmNQNBgUhMhGnXuT
3rNZ791i8G0z+rYb/TtMgV3m4G5LeK+1AspBOwIlccSZPO5OnfSmT/syZ/3Z
c4HchUD+EgalcA2D8sA9WPTXEBJXSPbEq1RsBJvOT9q7Pr3bjRD6oqtncjcf
ITSNz3lc0Uwx8rjIqhA8dRibQeJp3QgeyQwEj4CHkKEekSFsZgkINuIaNtik
FkiwvmCVEWsXinWLJbolUpQxLZVSv0DgGJfLEDSmlRgdS6PCulppa1IRdNSO
dRrneq1rg87di47et9Xg324M7DAFd5lDBJ3IPitCJ3bQHj/sSBx1po670ic9
mdPe7Flf7rw/fzGQvxwstIQK18L/ADo/hnv7rz+uxuPOj+90fYJGe/dnd7s/
7+j5oos/pZs/tUeA9GeGGIElmi4UYbC6KaJJCLIuMRpfdlE8yfRu6hnp9G6E
GUJMPkugmCPEiGEPJFPjgUAjiBG4tIvEukUYNP0SqWGp1LBMygFmRoA1EsBW
KWxNSvsaFQasWePcoCW6pKuipfdvMwS2G4I7jKFdpvAec2SvJbofAxY/ZEsc
tiePOjBgpzzZM97cWV/+vA8BVrgSLFwNFa+HizcjFY9U9TS9kerfoU+vldgW
0h+Myp3uTzEwPV908idjYATIJeNwXUGFIDKogggZPAkC5mGEiQxj0iOfxUeY
KOeJkFcmLhljgvwNxUOQUPVVRMR6NJZIDEslxmVS03KZmYBiaZQjRKyrOVCU
jnVqZ7PGtUGLVMizSeetgbLdENhhDO6sgWKO7rcgUBKHbMkj9tQxR/qEM3PK
nT3jyZ3z5i/4Cpf8hSuB4rVg8Ua41FrzPfd2v6larVyrwYi2tFM8hAz1jW4C
T8/nd/kInildAuRuUASfKULhCjliBA0Cpo5gMq2T+qb0yy4CS7e8AouAwCLm
YEEOGLthBAoPgYJq6EUEk8ViwxKxsQbLShkPgUJ9GyvKaoW9SelYo3SuU7vW
a9wbtURRdH0UBWFiIpiYcBuceiR+EOtK6qg9fcyROeHMnnbnzrjzCJOLvsJl
f7EFY1K6GSrdIrGrf4+OZDG1rj5BZDBBpI2zHwwJD0FCPdT96Z2ez9r5CJfJ
nYKp3TiAI52pgNKLyC8JIl0yNAgoilk9BBQhAQWFJAIKcsC9llMBhOiJxLRM
al4hRZgQPZHbsJ4osJ6sVTmb1a4NGBOiJzrfFr1/q56zHLIkQH03us8c22+J
H7AkDlmTh7FLzhx3ZE86c6dd+bPu/HlP4aK3cMVXvOovXg+WWkPl2+HynchA
uHAW9AD0rmR9JeL3rYEmkX+clRHs/tZWcT+fthPseAg66sGeT+/wEX5fdAim
dAkRZjMEoul80ZdYnSiMHvULBJ+EgIfxm8Hh143wUyL85lbxWyzVoqiO8Otn
ZEsq2mRajvGzrJRZq/jZmxREoVSuZrV7AwJP68UKpUMKRVD7l/BuEzavfZYK
dgcxdqmjBL4TjtxJR/60M3/OXbjgKVzyFhF81/ylG4FSa7DcFmLaaxGtTyeH
06r+mN6bA1Qz6+rqIlT7IxUcu4hhInOk6qoY9nzaxv/sDv+Lu4Ipnch9IwxR
BkBcOMZwEMGwE2M4o5uHEOQhCKkfExD5qrlC9XwRMkiMIMZRUnHc2HcTBJf2
cVNYA2UEQbl9NUFwLQFxvZpoIAaR4mH8/hWrYNVPVVG0VlA8YksfsyMlRBfm
EIpnXYXz7sJFT/Gyt9jiK133l24GyrcIkHeJfT7UDzMuS6qupPbveA6M6FfX
w/AUf1q9rvNvtznTRjrZjvWShyClHqiA+nm7YHKHcGoXSTh7UALBq1r1IA5R
GRkE0wcUs7qrsAoIrGIOVh5ClPrnPphKjMulphUyLhhaVhGt5GBFislh2qxy
b1BzNvwj/1ZdYJs+uMMQ2mWsaOZ+S+yAFfm5xGHk+yuAZk86cqec6B0Vzbzs
KbZ4S9d8pRv+cmugfDvItIeYjjDbFRkA1e//nfpZV9FProfXu+r4oyrKHR/d
QpB2EUgpjCn1MPaTldHGxzZ/R/D5HcEXd4VTOpG1I1ypXlQlXPSYiYMqRpWH
EKXuV85GsPYQWIVctqpbjPIxjOv9HKiVkIpARYq6SkHxUFJGDa74SmzuCqSs
HJ4/8WJV1fq26PzbsLMM7SSocpraB1UcQBCqJzCq+TMuhCp6d+GSp3jFW7yK
NbWC6h2sqWxnhO2O9vebVC2r//uRHdwPWRKh8cpZx6RbnR/dJj6gjfOh7XVY
Vx/BsCJF5cYX7cIpHThTQRqLM5XOmg/FqjoTYS2f1YNR5SFQqftVc/jquXwC
qwjDukSKQeUhUKmHetMUnKMoLKuVVpTmNqlw4rZGSbD8Oaeono0agqgWq+r2
r6gqtv2+iCJVPeHInuICELZ99DE1RDnbZ7AT5RCNAD8KwthAfuB7/wCufa/o
j++/VvHt7KO52Beg2E58wWDOFyCFxTr7xV2KJ5x8l3pANLVTjLS3AnBnDWCE
L5/6Pg7ySGnJUHEeYZ5AM1+gXSDCKc8Saa874ILUCpIbryIQr+Esn4ccAfWf
OEatV3s2qL2bNL7NWv+WqjP4qtpWssAawjjEY++ar3pX9IElEqaId+11BtCD
EQYxBrn/ivJ3azG/73plNUbd3w9JkiE8WPEBVTArySPKrT9DsR/jWUccwF3k
WDGSHdQgBKdoyl3R1A5UbBAvMBhnTARMhKV8toDiKWbzqQeVs/nYuaIxjzgC
NBYItQuECFBOY+/jIhapNiqOgGjpf+OaFRVmqNRACRMKVxs0WGMJnpzSBrfr
QzsN4V3GyB5TtK/SHiWJNZcyVd1AJey34LCPPv4rbqArwiI8BRhPkMb76y1V
sW/89Bvk+b9UsHygH5bEH5MKF5s8Hl1VOHuqcPagAPVpJUbxkDPliaZ0UA9i
HNHoNXxcotRwnCPgIQypuiqKIlShLBBRD2gXinRoLBL1c6cEv0FYKVHl36x1
rNfyUH1L/RKXJxhFbT9n2quYe00o96wknsj0CYo4G++HIs49K6aPflVfZwr8
GIhiIImDPA5K3Hq+Rz/7rySR12u1X//VtIF2GPXH/bvV1zsQ7h8jZUWYUw92
f9LGJfsc8JXMgEQwVC1P7UL/O6kfiJFHuMcdcCWQYq5QOVeA09be7ECiuTdn
XSrhYtR9fZ0B1t71Op5zg476FS6UUVlYzbcI7lxZSEog7BBMlZy/krTaa7hz
OX+B5Pz9XC6GHrncDg534hAQ7rI4KBKgTlS1tb+fvQf5e+vL+796psLMw/1Q
/07103Aq9ilXd3I1Vk+txsKPBPPJnVxChlLcumol/kAlG+Pwno0bFMq5IlQj
8BDa1KBKNra4lo09hcCeVP33Ffe7mmvkcD0uvWujHjf+Nuk9uJdTrbE4xHeZ
Q3ss4b2WyD5LJcdFLoMo+1eDHFdloXyMJLicC0aVwm0c5NBv7+My4shlYMRV
CdAmQZ8cwHsMrPHVjk9Vyzk170MDx8OAu8L68vDtKls4y8Ctoo46nMFVKl3c
AcADs1BJi6fh9I2H4iA1CDlvCRnSmXweTjQGc06nQsU85GlU84TUfRwXuGpb
ItctkaGMg9QM3yR9NXlvX43jgnM867S4XY242GykeO7NBupXni0G3HbkOgBc
Y22PNbzPGtlvix6wxQ7aSKuIa4wQC+BKXtwH+Ir/7iWj6nkwGogMESFDnkCe
BzRJ0CXBmBrADvrXwf+YHdTwr3BH1rrv74P/3e7PO3F38zOUdSDfg+yBM4bP
71Y4QCk04UA8A1V9PXW4U1fHdXxls5C/x07/QQWplrkujGq+CBGgRgQswgRw
v7wOYW9YhtvgFM/UqKQeM69Scvj3dUCV5YItRs8WE+6DbzX6thmr8FsI/Lbw
AXvkIOmDH3Ykjjhwp47rS510ZU+7SBvG08fx+0vXA6WbQZyR9HH8mAHO8csI
/GoCvyEF5lQVs4E1eQDcqzvGBrSbB9DzhdX9i9y+wilkayHZaTio70u8mXiH
1TSyVkTIudNFyOn5oqvni05ez+cd1MP8zzswNzhP7BAgL0W4wZXjDIEEDz7F
k8zoQb6K68jPleDGMxrYUWED4SF+qDpuoYLsmcM5oH65khpkWK7AyxQrFKZG
Fc+8WkN9Ay9TNKmta9S2NZqqt9K5NlZWczzbzN5tZp5vu4n6JWnKW4J7rKF9
9vABR+SQM3rYFTviih91JY65ksdd6ROuzEk37pKd9eTPc51DX/GKv3g1UKUn
RPoaYQbFh64o9MRQfMAkIXoUhB4toceUAmsaHOlq1nPPLsT/H576x5dapHgY
HSwjmxBXka17K8n+RG6jJbeBjyJ7KPHBQ9z2RBJL7nTilhOhCa+edPdM7qrj
f9FJ3c8nBOF+yZQuUaW6x+zMFFLfkMwUIIJqHCnmy/B60jyxEje8xdiEFkiI
1TyPHRheglTpV6rxKuQKpXEFWW9brcEL0Gt0Vm7JbZ2WLCTpKj4M2xBhCK9C
omH27zQThmyEIWfkkCt6xB076sErbsc9yROe1EkP7naf9uTOevPnfYWL/sLl
QIHrY94I1bp2zN0I0xllu2IsYkgQJ/EkgXlSIYZSoEcMpcGSBnsGXJma9+nF
nHifWvbUN4viVSPRN9FBEwG9qc8Gw2ay67DvtkJuXwE+eJDbLNnFLdRgJrrw
Ks3UHv6UborHn9xFfVcwuQt3AKd2C6f1VCwGL2GRxb1Z3MqeQDZbJCfLenhH
wILKyh7nvX6oqS6A9rLRqDE2qitrwk1azEaz0dpssK3T25r1eE0YjY1GvCa8
2UhMBrPB8+20Ur/277IGdtv6sOHGbBzzxI97Eyd9yVO+1GkfXsc648vitQd/
Aa89hIotoeK1ENdpL92OlO9EmbsxpjPGdsdZfgKECRAnQJoERRJUKcyJPg1G
xEYGbBlwZsGdBd9AnHD28v1+Zx+o+sANBHZul2TvTp3N9RO34MPN1Z066NnW
vjR8htd/8HLiNIEAjak9FE+A6HhAwHGAG9kCro/IrbHypLPF1H2IA7I4j2iQ
KxcplYtVXPRQL5KrF8s1SxQUT7tUQb2gw3sUCA2rtEY8NCY0KjTgTSh4V8Z6
o32DEXHg2GRybrW6tlrIFgW8NO/dYfXtsvl32QJ77MG9jtB+R5WGysp84qQ/
eTqAl6HPBvAC6zl/7nwgfymIabgaKV6PFG9GS7eipbZYuT1e7ogznQm2O8Hy
kyBMgTgF0hTIU6BKgyaNmTBmwIxoyFZo8GYhkK1E+tpdE6TbUNsziSM0tzVz
QxVsDG8d+lmHDvBP6uEK4J93kvXbzu4a4NOFgi+FgmnI32DgB3Pr/nhDxCyx
eJaI80L3IcBlcyWyOZLavhCC9V/xjpDFSvUSpQYNbh/MCo1uhVq3AgGuwYCv
1hmbqttg1hks603VLT8W+yZuG4zZuc3m2uFw77B7dti9O+3eXXbfLrt/tz2w
xxHc5wztd+GtEBhwsinkRJ9NIefIbogLodyFYP5SqHAlXLwWLd2IlW7GSrfi
pbZ4uT1R7kgyXUmmJ8UK0iBKgyQNsjQo0gTwDOizYMxi2BHgjiy4cuDNgT8L
oSxEMrV6+Sux4Vu1mDHgLt0Bonut+76Fs4RBFVZ46OfgbXgnNHqte3JP9xR+
9xfdPdza8VQ+4oXsyBDhTRlf8oVf1vapSCRzZZI50jrpHFSgyeZJESXVCE09
pFyqUS3XqdFYplEvVWuWqjTL1GQzlla3Ss/Tr9JRLxrw7iS8EwtvxlqLN2NZ
1putG622LXb7Vrt9i82xxepEY5vdtdPl3u3x7HZ5dzu9e5y+PS7/Xldgnyt4
wB066O6zXYdsVToVTJypblW6EMlcjOQuRfKXI4WWCGEmXmpNlG4nSneS5fZk
uSPFdKWZnjQryLCiLEiyIMuCIguqLGiyoEPM5MCcA1se84OY8SBmchDMQTgL
0QzE01SfuEDVXXKx90T2wfewN+ieM9WIUlvX5uwHDd42jiNq8JY+hoUJ423H
NO6on7idmBXijtczXUw90jNNwG2LqHA3UyLE6/4ivDw5UyxGY7akssdoPspu
ZfPk1Hdl82Vc4acgTkzF0Yc30hk0K3Sa5VrEnXalTteIN9Lp15gMeBiNa1Dt
YVprpJ43E/IsGyx42yDib5vTsd3l2OZA5Dm3O1y73O69Xvc+v2ef17vX49vn
8e/3BA54g4d8wcreOn/kmD96PNDL3zluq1k0cymWvRzLXYnlr8YK1+LFG4nS
rWS5LVW+kyrfTZc700x3huFnWWGWFedAmgN5DpQ5UOdAmwN9jvCXB2sBHAVw
FTCLvjwE8xDOQTQL8Qwk09VaBPuwC044ooatt6sJ2j/MYl+bq+0BqjBWtTly
sI0QhwZvB/aNOwmJPdMl/DkK/my5YIaEP12EvSK3c2O2lOKJZkmoweI5MvE8
BeIPmR+iEPG3kIs5DymWaL6yExKxt9qsWWXSNhq0jXqebpWBqtM3GQ1rzIZ1
VopnbLZSD5jWW81obLBZNtoQddbNdttWp32bi+fY6aGece5wu3a6Xbs97r1+
94Gg52DIezDgO+D3H/QHDvm5DaChY6HwcbwHNHoyTHZGhhNnI8lzkdSFaPpi
LHM5nm1J5FoS+WuJwo1k8WaydCtVbsuU2zPljizTlWW6sww/xwrzrDgP0gLI
C6AsgLoA2gLoC2AsgLlA2CuCqwgeQmAAsZeHaA5iWUhkIJWCdKKaL+Ou9Sk9
7BfBpuuw6uhAO0Me+oetssbjNi6q9edxWy+P36nwiOiboxQs1AnmqfGmVrxj
S0p4lInmyMVoIA7nk02tC9XS+dzKQZ0cMUj27VI85QoDNRbbYJVIvDO7yaJb
bcabs9dZ9WsthrUWY7PNuMFh2ug0bXSYNzksm52WrS7rNrd1m8u2zWXf7nbs
9Dp3+527fa49PhcicX8Akeg5EvUeifqORPyHQ3i38tFw6Hg4dCISPhmNnI5V
N/LGYheiiQvx5KV4+nIicyWRbUnmrqXy11OFm+lia6Z0O1O+k2Xu5pjOHNOV
Z3ryjKDAiAqspAiyIiiKoCqCpgi6IhiKYCqBuQTWEthL4CqBpwS+IgSKmM1I
HmI5SGQhlYF0EtJxyES4js2DUO3gnDTA7i5ovgBLdrMzV7EU1buLBfM4qMry
/5WV1nZybq3kLNjrYnYH93W32MkShr/NMYw3885VCRbqhcvMokV60Xy1aK5K
NFcpmqsQozFPiegle7R1hNvvyJdo5Ut1imV6vBl9hVHVaFattqqbbOrVFs0q
s2a1RbvWpltn16216Zvt+g1O/Sa3YZOLZ9zopMaYNrvMWz1oWLZ5rNt91p1+
6+6AbbffvtvvQOzuCTj3BV37gu4DIffBsOdw1HMk5j2e9B1P+I/HA8eigRPR
0IlY6FScbEdPctvRYxdSsUuJ+JVE8koq1ZJOX0tnrmeyNzK5m5n8rWzhdrbU
liu355mOPNNZYLsLLL/ICousqMRKSqysDIoyqMqgKYOuDIYymMpgKYOtDI4y
uMrgKYOvDIEShIoQITQncpDMQjoNmQRkYpAJQdpXTOJN9U6f4pgOdrRD0wlY
vq84u6n82YzShx8V+tfKfeth6h9ivHqvX43pLb1MD9pSOahwXIc5xl0QvC99
rkqIqF1mEa20i5eZxYv0PPFCLVUnWaBB1EoWabk1KXmjlfo/ihVmxQqTgruv
otGCyV2DbyMht1a4tM1ObbND1+ys3T1i2OIzbA8YtwdM2/ymbT7zNp9lu9+y
I2DdFbTuCdn2Rmz7o/b9UceBCM95IEL9yXUw4j4UdR+OeY7GvceS3hMp3+mM
/1Q6cCoVOJ0MnEkEzybD51KR8+nohUz0YjZ2KRtrycSupeLXU8nr2dSNXPpm
LtOaz97O59py+Tu5wt18qaNQ7iwy3UW2p8gKSqyozIrLrJRh5QwoGVAzoGFA
x4CBARMDFgZsDDgYcDHgYcDHQKAMoTJEShArQoK45jSy4RRksA1DOlBOuTJx
SyCoOayArTeg8SDMW1+e3ZibPCfzwQf5tyakB7DG/nnrP30l0/26jLemG9xd
U9R9Wyq3UtXstw6Ti7smgjkq4TyNcJFBtNwqXuUUN7kljXbJMrNkiVGyxMDV
z4/g22WWm+WNNkWTU7HGpWxyKFfbVWistavXOAitbs0mn3YrvsGL4uk2+6m3
yF1PPnLXU9C4M2zcHTXtiZn3RM27IxY09oat+yK2fTHbgbj9UMJ+JOk4knIc
TTqPplzHkq7jcfeJhOdEynsy4z2V9Z3J+c4V/GdzgfO5wIVs8GImeCkTvpyN
XMlFr+RjLYXYtXz0RjbamonfyiZv5dO3i5m2UvZOKdtezHUU852FQlex1FMq
80tlYYlBRot5LSNeWQXDqlhQs6BlQc+AkQEzA1YG7Aw4GXAz4OWoZSDEQKQM
sTIkSpDk2EXWm4Qstl427c0nbNGwfq8ANl6GFXtg1gqYPKv02dTURx/F3hyX
eGN0tE8ExbzhL0nAbHKMfrfPK4S5yv1v+C6iumqp3sdOqYe2Eb+LbwJaqBct
NmL6Vrsk6/zSZr+0yU14+7ZslUPe5JKtd8rXOfDNTmucymavaoNftd6rWudW
b/CqtnhVW72azT7t5oB2W5in2xnj6XdGqbf1u8O6vSHDnohpd8y0N2E6kDIf
SpsPpiwHUtZDScuRuOVY3Ho0aT+acRzLOk7kHCfzzlN51+mc60zWdTbtOpd2
n896zud85wv+CyX/xXIA36pXDLYUglfzwWu58PV85EYxeqMUvVmMthajbflo
ey7enk+2l9LtTKaDyXYyua5yrruc55cKgnJRWC6Jy0VJqYx5K3O8sWqW0bKs
jgUDCyYWLGx/k/QzECTUhRmIMhAvQ7IE6QJkcpjAbIIYpr+YdCZjJodPsfoo
zG9mv1zAfjq5/OH7+XdeS745JjjhL/5XX/aMe9FJfY193stkXd+Kc1PvXVHV
3svmCrO4iCF5tnCpWbjUJF6Kb16TEBo5y5sha3LLVjvlazzyZp9iY0C+1S/f
6lNs8qk2BlQbg+otEfXmkHprSLMjot4TUe0LafaEtbui+l0J/d60fl/GsC9t
OJAyHE7ojsb1R+PGIynz4Yz5SN5yvGA5VrAez1tPZi2nM+azKcvZjO1szn62
4Dhbcp5jnOfLrosl16WC63Le2ZJzt+Q9LUXv1bLvKuu9xvivsYHrbPAmE2wt
B2+VQrdL4bZyBI075Wh7KdpRjHQV4l2lZBeT6oZ0D2T4kBNAXsjmRWxBwhal
TEHGFBTlkhLRyLAaltWyjJ5lDCxrrDHJgoMFFwsetmKBiMkwCxEGYohJBpIM
pEuQKUA2y2Zxx4zNBMspTyZuRS525X5m8ebCl/PzH3+c/2hS5r03Yq83hF59
yf3qS64xz1tHPW342sj4VTYHD+BhSbQdoKdQe87dRE06nH3vZa1123BfTtTo
FK1xCdc7xE1OjuuHZduT8q1x+aawfENAshmxHMb3026PK/bEFPuiyt1Riqfe
maQex7cM705q9qa0B9KaIynV8bj6WEJ7JKU7ktUfKRiOFA3HCoYTecOpnO5s
RncubTibNZ0pmM+ULGdZ6znWer5svVC0XC6Yr+TMLXlrS9HWUra3sLarYL8K
rmus6zrjulF2thZdrSX3LcZzi/XcZt1trKeN9d1h/Xcg2A6hu2yogw13suEu
JoJGNxPpKUcEpbiApXgJIVCPJkWQEkNGAlkp5GSQl0NeyeZVTF7NlDQMo2NZ
PcsaWMbEMmaWsbCslQU7C04W3Cx4WfCzEGQhxGLOoyzEWEiwkGQhzUCmxGbz
bDbDZnHzmk37cwlHJKxftJGd25iftTTx6afJ915Lvv969K0x/lf/6ESEj3vR
Nvb3llHP6PvmyhxhVfpqLA+gFwOvjdZyrdpN87zKvfRUHdfqrtk9vgoZtWRD
ULw1SHpC35duCso2ReXbU4o9ecXOtHxnQr4nKjoQluyLK3dnVPuyysMZ5fG0
6khGc6ioOVxUHMvIjmU1x4raEyXN6QLShfNZ6ifac3nduZL2XFl5vqw5zxgv
MIZLZX1LUXstr79aNLaUzS2gvwbqa2C4BpbrYLnJmG+VTbdL5tuM5TaY28DU
BsY2MN8B2x1wtoPzLuvsYFwdrKsTMensYqkXnN2sq5v19IC3B9Cjjw8BAYSE
EBayYREbEbMRCRuVQkwKcRnE5ZCQQ0oJaRVkVJBVQ07DZrVMTs8UDWzZCIwJ
EOFlK1u2sYydZXuNnIUA4RwbOSE8TjhPIc5ZNotGkc3mkKmz2TibCeF97VGT
3aeYOqv8xZT0Z5+F33899AYdeJP2vf4X55jfmUb/Rj/2OcO436MDbYV1/EUx
9/9vHA+0Xxlftb76/RWYWOoB7qsHVlfXONaTUCzdFCV2/Avh0ajoSFS6Py7f
l1bszSsPlBUHC/KjOdnJtOBMsudsSnwqrzxZVJ8sqc4V1WfL6rOguFCWXM53
Xc4JL5cUl0BzBTFWVt8oaa4zqhuMvJUR3WQENxlZK6u5BbrboL3D6NoZ3R3Q
tIOyA3jSu0B9W9UB+k4wdIGxmzV2g6EH9HzQ8UHTA1o+GPj4OyisQjCTR7uI
5dnFLPUHm5i1S1inBKxi0AvAJgaXFDwy8MnBL4egAkIKiCghooKoGmJqiGsg
oYWkDlI6SOshY4CMkc2Z2IIZihYoWwHxWnKwZSfLuFjGzbLeKrUhwmtfW0bU
ZljA1JZrFs1mI6W0LxXDO/Q//4KZ9F7u/QnRd8f6X/+Ta/yL9vEv2Ma/YBr5
hHrkE6rRz6jHPKsZ81t0LKPInnLOS/f7hp2/k+vaVWur343B6/sNJo3k605W
EKY5f/1z/oGs/FBReqIgOpcVXkxLzmblp4uKU9B9EmRnQX6xLG0p8q/n77Zm
u6+XJNfL8uuM4jrIb4D8FkjbWH57qb29eKe93NMOkg6QdYL4Lsi7WEkPK+Kz
XT1sWzdzt5sVCND8pMijvtnTDXIxSMUgkkCPGDpFIBCDTAoKGQjFwBeCVAJq
OSjlIJeDTA4qBWgVoEJPZSCXgkqGnxqUYFKBWQU6BSik+C1aOVhUYFODQwN2
NZgV4NaAVwt+HQT0ENJDxAAxI8RNkDBB0gwpC6StbMYGOTvk7VB0QMkJJTdb
9rBlL8v4WPYeM2YTwJkxRzfkWDZXqhkzkwmlE85wWP/ZJxkE7PsTEm+94p/w
B8erz1tGP6Mf9aRm9JPqhuHyhkdlIx+Xjn5KNvo3ilFPSmsO/O/ge6AoTniH
ytrxamLNnEGv/Oq32izB7hzz/ZTgPLLQ7NWLmSvnc3fPs6LLIL7OCG4XxTcZ
4Q1ob4Ur1+HkRbh5AwTt0NPF3OGX2/kMn8/e7YYrHXCyFc7ehls90Cllb0nZ
K1KmVQZ35NAigtNdcLgNznbDdRncUsI1JduiYFtVcF0B5yVwkg/Hu+G8GFrk
cEMFtzRwWwu31HBThc9cksJlCdxQQLsGOrTQoQFejw6ood1a6NJApxq61MDX
gEgLIg2INSBUQacCuhQgUYNGBwYDaHWgVINSBQYd2AxgN4LTBE70aAC/GQIW
CFkhYoOYHRIOSDkh7YSsC3IeKHih6IOSH0oBKAehHAImDGwU2BggxtkksClg
04BIR0jnWOqHbB4RX2RzWTaXZLPRbNITiZiMTuHEN/D+snfHhl5/yTnuWePY
3+rHPK0Z+ai8YaiEHiKihwobhgtGPiYc9YRo1FPif5D3gb6vhegB7mqsrG4V
mEt2dcwnGwYI2y+gVy+dLbdfZ7rambbO0oX24qG2wrk7cLMH7gjhehdc7S5f
E8MFMRzugW13YMttONgDp2RwTgV7u/JHJOVDMtghgnWdsOwWNLXD+m7YIGAb
7xaX3kitbMtskkKTAJZ1wPxbsKILmiWwvJNd0Fqedy237E5hjZBZK4JVPbCq
G9bwoakbVnfCqg5o6oBNQtgpg71K2C2D/Uo4pISDCtgvgQNiOCKFkwo4p4ZL
Wriqh2t64F1HuvCrm1po1cBVFX7s1APfACIj8HVYO3q0IEMqYAGDFXRm0BhB
bwSbFZx2cNvB6wC/E0IuiLgg5oa4B5JeSPkgjUYAMkHcuMqFoYQ4j/dyzqSB
zQKbAx7kWepf2TzD5gtsPsPmEoV0MB6z+4LaTz70vv2K842X8V0e439vHvW4
aszTqjFPKUY+iigX0PVCup5P13c1DO0cOaJ75GM9DSO6B7L4QV/J0vve00c9
1C9fW0y+gmsW2cHzMccyyQLfQda3tx2arxUXnEk3Xs7s6mT2imCPjN0lh41C
WH4Xpl0pTzqVeGO/57UD7rfP4DYNXhDT5sFQAHMR93EdZXBzPT6uUUBylyTx
eMTdQYGFIsuWoIAqlhJuIYSL4C2AHX1GFhQpvJO11QcXrJjOLR2w8grMPgKf
boV3GmHCPBgzBUYfZV47UX73VOlvF8tTrjOz29iFHbD4Lrv4VnnxtdKqtvJG
PrtdjKaNP+GEBk5r4ZwWLujgsg6u6uCGDlrUcEsPnSYQmEFsAaEJ64HUBBob
mJ1gdYHdBU43eDzg80DACyEf8MI+oL4Z8UMkANEgJMKQiUIhBuVExbSZDJSz
wOSAzWPrKrDUP7OFMlvIM/l0MRtNJT3BiOm9Ud73RtvG/840/jnjhBeMCPeG
4ZJRj8tGPykdOQJR3U3x6Poe6j66vpOuv0vX32kYdnfkiI6vZfs7/ax6UCUi
c3e2vrbPWjlP1uVfwdeps6DL4dUTSxHsRXCSlru/DMFypZxMVHMRRBXyUQWW
LTLlIsuxFS9CsAhu9O4caNN4j0ZXBG544KwF9klh/W1Ycg6+3AcfrYc3l8DY
GTD6U6DfZenXivTYLD0yRb8co18M078P0r/10c946Kfd4w8U3ztV/uQKO+Uq
O6OFnXuFWdbGruXDJhHslGKbPqaBU4g/HVzSw1UDtBrhlhFuG6AT0WYDmQPU
TtC5wOgGixfsiCe3H6hfe3zg9YM3AL4ghMIQjUAyhnscRWKRHFXlHDB5YArA
FgFrZLHEFHKlXDKTDkZidqtH9tpzpvG/1Y99Sj32KdXYpxVjnpIjZEcOF45+
QjRyeDdd30FY6iaP7XR9G11/mx5y+3/nalCtbkaP3NpOL3vk7pdH8XMDWZu0
kdUtdxF8JdwxD5cgWq6W+yRXRMkDcihIy4qlUrGcLzKpIhstsn70PsRxFu8i
ECehPQRXXHBCDzsF0HQN5h+Dydvh/UZ4Yx47ZjLb8CFLv1WmX83TDSn6r3H6
pQj9fJB+1o/5ecpFP+Gkn3TST9jpx+1INx+3UT+gtzETDrDvnWI/bYFp12D2
dVjcCmu6YDOh7IASjmvgnB4uGeGaCVrN0G6FHjsIHSB1gsINWg+YkCnxrIin
b9r8YA+COwT+CIRjEI/jhZ5cGooZTE8JjQKUC+hqpgjUdxmsicVSIZvNRmNJ
jzekf+MPlld/qx3zhGLMY7JRI8SjRghHPSrEVjW0e+SjPQ3DOggzd7FVdVCD
kT1hjupv0fWtX+9BcUT8urs2q9/Rg+tWchfXa/h1hLQljx2YqwCeIviLZHGj
BDHk3sqQQlU6g9P6XInJo1FkCoVisZgpluKFcqhQ9uQZW47VZ/E+G34cbgXh
gh0OymBTGyw7B7P2wSfr4O2F8Np0ZuzHDP02S0/I02My9F8T9B8j9Ish+llf
L1WPOejHEFU2+jEr/aiNftSKj5+00r+x0b+30/Nio/fCm8fgo3OYuHm3YWk7
jqUb+bBHDodV2NAuGOCqGW7boMMBfCeI3aDwgtYPej8YA2ANgTMC3hgE4xBN
QiKN2/rZLBTywCsimr5XKkKphEexWC4WCtlcMpkOBqKW1543vP6CYdzTigpJ
IwQjh3XTQzroIXcJW3cbht5BHLVR9xOO7pJHTBNdf/Prmerfdfqa+8TQ28gd
jHg/Hthy4MyDOw++AgQKOPZEixAvkWZoCbIoFS8ibcsVqP9g8vlyIZ8r5JP5
QiSf9+WKjmzJmCmpUmVxkr0bhhY3nDTALj6suQrzj8DkzfDhMnh9Joz9lBn1
Xgk7PURTQ5L+cwx7vN/56d96sC096aCfcGB2hiOOrDx6hIX6BT4eYcWsPWmj
n7HTv3fQr7joSaGG1eWRO9jxR+GDs/DpBZh5HZbcgXV8bGu7pXBIAac0cMUE
Nyxwxw5dThAivvygDYIxBNYIOGPgTUAwBZE0xLOQzEEmD7kC5IvAQw6d+mah
xOaLpUw+nchEg3GXwtL96tPKCc9rxjwhaRjagzgaNby7YWgHtp92qg4RhLCk
h9zCz29RDxBjaiMDE0XX36Drr9dqi3+crf4sk28Oeh1fYc+RzU958OchVIBI
AWIFSBQgVYBMAdfLuTyTyzH5bDmfLeQz6XwmlssEsllXJmdO5zWpMopUPXFo
9cN5Ylsbke6fhpm74JPV8PYc9vXJpdEflOjXSZiik/TLEfqlMP28n/4NYQzR
hRzgE8iqEGkWeqgZPw4308PQsCD+MG9P2enfOOgXXPSfPfSEAP1psmFRYXRz
eexe9q3j8LfzMP0aLGqDxrvQ3A07xDgzOaWDC8hHImuzQrcLJD5QBEATAmME
7DHwJCGQhlAG72ZI5HGjPosI4+Uwa9kSk8pnE9lkOOk3eVVjHhWPfUz86jPS
0Y8JcFQa0t4wFI07FLGoQYglzBrhh4ftaRCh6zZ5xGeu33vH731/J2ODK/ZF
vmPk1/gVvDczR7bR5CGWh3gea10aKR6qcFGtk2HQyKdLuRTyDfFsIpRJudNp
azqnT5UVSRAkoD2Co9VxHWzvgFXnYe4+mNwMHyyA16cwEz7Kj34rV0kl/hKj
XwjSz/no33npp5Dns/EQDcjHP47oQKSY6aEmeogJYTDURD2LOcNUWTGXTzvp
Z130i276L356TIj+IEHPLNBLSnQzM3YnvH0I/nYGprXgWqSxAzYKcG1xRI19
I4poN5FjdIPQB7IAqENgiIItAe40+DMQykEUyVuAZJE04/HSWDGez4bTEXfE
hqAZPaxn9PCe0Y/1jBrBJQwkGA25RRwdx8ZNQhSyomuIFXRAVfm6Tk5dG8BG
6v5Opvrff0ii18/xFWQPJ5l+DuJkLT6VJX49zaKRSzG5VDmXzGVjyUw0nIl5
03FbMq5PZJTxnDBW6Iyx1zxwygh7UH13FRYegqkbYNJieHMajJvEjH07N3Jc
mqYTSJI/R1Be+3tkUy76KQeOSyMwTTz6UTPyLI+a6BEmeqgBXTfEQP0PPcSI
yKtYGnKViDL0tt956D946b8G6bER+u0kPaVIzy3TK5jRG+HNXfDhUfjsPMy8
CkvaYG03bBPDPjlORc4b4boN7rqB7wNJAFRhMMTBlgJPluzXQ4paqISARJGJ
F4rhbNIX9/Z2xgePHNY+chiXOGCWOE7uq7o8xMx1wtp1dP4q9pEcd9co7nm/
Dsv/BXP977ojzL2FrwhmIZIle524PTJpyKQgm2RzSSaXYHJI+SKpTCiaDvtS
YXsibIhHlbG4OFbsijKtIbjgwNXyplZYegxmbGE/W8G8Ox1e+1t53Lu5hnFZ
+pU4/SeUXwTo3/vo57300yitsGKzGm6ihxvp4QZ6hJEeYcAHw/T0ED1djx4N
mDdkd0MtOKAhU/uNGwe957z0H/30K2F6bJx+O0N/XKSnl+nF7Mi1MGEbvHMA
Jp2CqRdhwQ1YdRe2CGGvHGf9iLdrdmj3QI8fJCFQRcGQwPu/PTmyT48L3Sgj
RjlUNuNJBNQuefVeW8JQHReOsHvjcX7uGj7HkXUVn2shDCHrakE/8eG9kauu
lhH23WPw0ECMvIEZwRs/M5DMQKrCBWTjbDbGZGPFTDiTDsRS/kAy4IwHjFG/
KhqVRHPdeAc8e9EOh5WwrR0aT8HsrfD5SnbinNLrHzOvvlsY91pyZEOMfjlM
v4TcnYd+xoEDDcrpkMkMI/gP1dNDdfQwHT1cjx/R8RAtXa/DjBAfWHF+yIxQ
kvisl/6dD4e2l0I0HaXHJel38vTHZfrLMr2AHbUaxm+Gt/fBpBMw9TzMvwar
2mGzAJfSR9VwHiUaDujwgSAIsgho4vj+CGcOF+9+UheGUOmRy3lSUWvI2rvz
lZBwtYL5tZqV9OEBPb2Cz7VwJHwNCz+sxJof42f4O05x/om3+CXxziGMcxQ3
zDOhbNqfQNV2wuOKecwRjyrklYRj3ZFCW6h8xQPH1CSynIW5O+DzFewHM+DN
T8pj3yqOfjU9ZlS04eUg/YKPfsFLP4fcFMrIzPTjJqzhGGEML/JPGmoIPUxL
D9PQQzV0PRoE7aFGnA8MrTqtxx04eXiOQI3iFDKlkQl6Qpp+t0h/wtLTGXoR
O2oVTNgM7+yFScdh2nlYeB1W34WtItivgJOo3rXALRd0BUAcBlUc3/9gzeLU
1UsKDG+u4E6nbFEP0UXctyXwtVSV+Ur1gMO5BRc/HMaVAnRgb/Rv/c6Sb7DG
3zVHUI6T/VkRNhNiMsF82pdKukNxhyfqsIQdOIWgvnfKBLt6YM0FWLQXpjTC
R7NL736ef/Xt3OhXMw2vRBteCtDPe3Dw/Y2dfs5BP2WmHzVglR2CoNTyEKjU
g/RQNV2vooeo6KHksV5dgXiIHunKcDP1nwRmFDqIOmNdDmCAUdmKitcxafrN
HP1hmf4M6Jks8jFjmuD1LfD+fvj0JMy6BEtbobkLdkpwtXMGlTrIwXhBGAZF
HN/0U8PYU2Dc2Zw9Hq7e1zAIo9frKRBA9+Ez9+RNXPe1/19XIM/xvf64Z5QJ
QybIZgKFlDeddEViNm/E2rvq8kPu/sa1FzGCM9bCRzPhvc/yb36QHD0uMaoh
NvJPQfp5N/2sA+vmE2aM4FMocmqrqKnxwTD0qEKTVeBqqg+Cw4z0o8gxWxCO
wyzUz7CKosIRwxei/xim/xLHadWrWfqdAv0RS08Beg7Qy2B8M7yzHT46CFNO
w/wWWNUGW/hYRU8gFbVCqxu6g/jmT1USDBmwkurKmSta4hGNz8DdjcBp5yW6
/jIZNdVsIaqJnl6u4FtDE73AIfmjAZB8oJrNVLCauhI+ngVvT2JfeyszfkKU
/kuo4eXAyBeQp0SllIV+2kyP0NPDtfQTOnoEQkaJgKGHKPHBMBV+HCJHPkhO
/Rqfr1f2IobcKgp3j5LCDJdnqJB24WIbldx/CNN/iuF+CUpF3yjQH5TpT6Fh
BjQshNGr4K3N8BFKWk/AnIuwohU2dsEeKRxDpbUFbiK0QvheTXUaNzstOVTY
MKZEXBt0fLs3dl3G2QWHUi9EgwbUN66y+nHFM5K/fvHP6JpP5xTe/aj4xluF
caMTI/8cpF9Ensg58llUwxjpJw3000b6MR02LgTDCASAjCIIDKKHKOihaMjR
KXRGSv03Ov0VWFBgQcEflTuoEkLxBGHyhLOiRH+M0C9H6VeS9OgsPaFAv1um
/8aOngaj58Go5fBqM7y3Ez47DLPOwdJrsO4u7BTBUQ3GpNUDXSH8DRDKFL7f
xZwDUyqjjwa5bxd4oI/ucJBcIZBgPFq+Do+f9NMa8tdEvo2uff311IRxiXGv
hBpecFccEELkUR39GFIPLf24Bos/REYPkdL1EoIAYkJGDyWDnETnCFa/qMJC
VAVFhkfNXJMMI4NrDDdWFWRYLyGFTNCjMvSrBfrtEj2JoSez4+bAa8tgwlp4
dxt8chBmnCaYtGNMUKVxAVmVF+4GgB/Gt1TrMsgvFbWxaPWbzLEr59DAekGk
/l+w+Gk/LMhf3cHfcTiWjoz7S3DsHz30b6z0sxasF8M12CSGI6VQ0I+r6GFI
DyT0EDEOG2KqHkuPMBgq5c4SMGT9FWSoFueFj5PkD4FRQ+L3Qawgf47TDWn6
1XzD26WRk8r058yomTBhCby9Bt7dCp/sh5mnYOlVaK5qx0Ub3PJBVxjfDqhK
gz7DKsJh7tvB7id6cbmGQSV54P0vSPysHxK/rCIx6o+e0S84Rz9nI7ahr6jB
MCXhXUIPl9IjpHjtrV6IkRZhnRBjAPApET6u6MR9vUggR4ySscdQdfOkg/r3
Cgy/9eHO6h8i9J8qMNBvlUdNKo+dUh49k30VlUxN8P4W+Hw/zDkNK67Chg7s
OE7q4YoD2vx4WUSaxDAoY0kSp6vZ1WXOJvDcrn7Vh3Jy/8dAcuNvS2l4xjzy
CaS5GvpxNf2okpArI/yK6CFCeriIrD7x67DgD9D1ZCWKewkvSVUUgEj+s17J
UTRHiekTpGRDZTkW24vdA3aZ8YaR6YbxWfqtUsNEdsxkZvwcZvxieKsJJm2D
KYdg/llYdQO2dMEBBZwxw1UX7lwLEyBLgjJR4L6dk/MHV6qe8SpXbtW6tb1S
cnvAf17xjL0y/wa5LzVW7eEyzCwSY6gYszyEW2XroYf0oEeEpQBHTz4Wewif
CCziBKa+IjFyoigVRHXQ4xZc1T7jop9x4xybk5hY/qjXsqPfK4ycxI7+AsbN
hteWsO+sgY+3w/TDsOg8rGmF7Xxi9ja46YPuGEhSIE9Cl11H+l9Vi79K5L2G
mwJfK23/v270n1W/1/CsvgEZNKIWCyskQgnwAZa6h6xhdJFHLC/im09WoQYT
zisaXpP8JyR+qrClo+TtcTPpWPaK3fBSGLemR2cbXiuM/qAw9pPS2Kkwfi68
vgw+XA9f7IY5x2H5Fdh4F/ZKcfv0ihPuhIAfZ8Vxtsft6P3+Pq6orvR/B5b3
F/3Oku9QxPf5NDytanhCgYVFAg7p4eGFtfsxs0OR4JywneSxB8vEr665dRPy
+TX15mGhf4Jd3BAiMop+jxorIj/twJUtEhl5tpejo0bFR47L0K+VRr1fHvtZ
+dXp7IT58O4q+GQLfHkAFp6GphuEZg3u7bcGoCvGCpG8Pl/v9z4SeXFfbiB5
uR2YvxxIXmzxDU/KCJucpIOwdEM6saRDusjKx6DqShXW8Dp8zX1Eq/lVhitx
TUb9mGRERFSk1E8gpbbhivO3btxmQ5nPn2MjRyXHvpEe805h9MTy2M+Z8TPZ
NxfDxLUweSfMOQorLsGmdtgvg9MmuOqGu1FMbbc/1MsVxf0bWMJfVeyVSIZX
rRseE9HD+UiOKmNkXRQvHHTy8MLOYLIM10W0uKeyftrFSVdZOhfWPLSM+hHO
eFCUQ9KhkI1M9mk7/Rsn/awbVWlEcePIXke/kR0/MT/uY2b8VPa1OewHjfDZ
Zpi5H5acgeZbsEsIx/VwyQG3Q9AZyXcHoiSiDuYk6405XD31635S/rQqFz2s
ix5BVkAq8++otASHtJNe+6/JIghHWlVhEQhYLGHVG3EeGLlrOSbtUS3Oc4fh
qIPF+i1pl70YHP3XyJgxSDmzo94sjJtYfG1y6fUZ7DuL4ZNmmL4bFhyHpquw
vZtopgNag9ARLXd4g/9dlekrcZST6X/6yUSyrQeJX26nhyJyuAWcXpm4PvSv
qys7tWXTvkKJBhJKhSsblKA9ZiLu1Y4rx+d99Evhhlfir05IjH87M/a94viP
S69PY96eB5MaYcoWmHsIVl6Eze24t3XWAtdQJhVlb9nMZNa9fx2vukOO+5t6
/dccuChzp7Kmi4WoLMfjJRDqYfJSe1UYTik7KpJgnyPCEotR3OcyJk4UVIE8
aaKfshB/6cA696Kf/nOEHpkc81r6jQ+zr39cfGNK+e3Z7EcrYOpmmLMflp/F
a4D7pXDGAld9cCcC1JA+s+1lpB76dOEHkblzq5x3iI0Mqq574sHDhPxXdfqd
feYuIHMX96FA1vAoqSZRhHvchNcQn8EUNPzeO/JlTAGqtke9kZ8wsfDOlOK7
M5kPF8Pk9TB3Pyw7DRtaYa8YTpvhipu9FWS4v3l4z7yH9sP+RzXrqOe64m3V
edbWbW/X4fn/vIp9R2XyQwXVMC6pTB4VMY+qG3B6gyzCiGvB37no5zwj/xgY
TcdGjk41jM+Ne7/w+ield6YzHy5gP2+CmTtg6QlovgF7hHDKBFc8TGugxP1V
yD4z5yLPsH4zJxU+l5O2knGrqiNt3FpZXXWtrJ1bS3ugjynUpo8gl5Kq4wc4
+xyhaXjG1IDKV6QzuF/ixo2pP4XHjE6OmZAb/VbxjU9K700vT1rAfLEa5u6G
5Seh+TrsEeCgetUPN7wJ6tGKXnBzHt5vzqTXw9XmN0gru7UKeFt17fVWZQGp
HUfBqj/iFGUYVxPJsHYPVyHv0/C0aeTz9obf2nHn7AUv7lS8Ehs9LjPurdKE
ieV3p5U/XsR83sjO2QErT8HGm7BXhFG+GoCrTj/1OJrLP6Gp9d5tMKIydzLL
b5BZXq9O9HbVNmuzxEY6COv6j+6ZJC5mG0aocO3/mA7BOfJ5x8gX3A0veumX
AmNHRV59NTkOKfEH7DtfsJPmsJMb2dlbYdlx2HADazDCssULGMdBNY/xWD8c
f9DL/XUuY6nq7m3MdSvmnpviHXyI5ziks2Eoceycw0DZ6DBcdjc8phnzG+PI
p4yoMB35vHPUy/6RLwdG/jUyfnz8zXczb3xYen8K++lidupqds423CnecgsO
yHGkveKBYdB3T/fjA81xUB8UW3l4evdV8BtyqwrqXZIv/DuyqYYRgoZhOP+v
zhBFTmXDE7oxz1nGveAY/Zxj1AvukS/7R70SGTsm+frb6fc+zr/3OfvpQnbm
BnbBbrbxJGxtw222804ULWPER+H5cd/59US/+f1L7/y45ZObxGruq4A5pA0P
DCk3v39FuQ2a3MjHJA3DidkjorESahqeMqA67rW/eMf/2TfuzwFU4475/9q6
1qcmriieTvsP2A92Wm07nWk/GiBgIpEABhGLsLvZhGxgEwlPhUTwMaEUfBVx
BLUiRVpasPYDQrV1OvoBRltFRCUIhCIJRiLIoxBRGmIkMSZ7Z7r37gY0dSZf
so9zfnv23PO49+45ikUqa0mbG8grDRR9DfbVgkMtoOZ35vtu0GoFf0y/Qv4M
IuNql0h4vVu94gc6uLg7pGvXkBUVdkFduxFyDrdQdGnGxYN4jCVdxMIZYhFh
621skkUkTqi3zdGqBQ25QKncWTpPnvFF4Z6AoZIpPw2qzoGTl0ETC2cYXJkF
0PNCwXDVRGPD5ISOfvEaqmV1Qyu6wi5uTwVvXEK+lYVEbBiGGUDMfSzGSrAj
VfYIl09mpDlptUtHe2itN6/Yt2u/b8+RQPkpcKwNNFyD+ygvjIHL0z4Uu70X
kolAGoZpeQ8av0YJV1sEn6yMTAiqB8ajnK1j5cQOTuE9LNpCSFksrFu0EdKH
qk2PyaQpxZZ/MrD5LMqdk/syd0eg2BQw1QT2NwZr2kHjdRik/Drq/JxHw1Xj
3xiGZtUbmt4ZWvNey49JHsxtFFHexkXm9Ag2o+3HRENErE0RZ8eldjJxPDN1
Tp3qVGNP9fqF3PwXBYZXJZWg7Bg41ASOXwRNN0HbA3DpseszHgnX4SjubUje
XR5znC34CIu8wZtZ/u2w4rhLxAxgooH0KAsePYxLbIp4ByFzqJKnaeIZrXRt
pxeLSt1Gk7ekgjnQAD+Gru8ALb1wR9enPAKuu5+M191VKxFZyLIL/yJE3XhU
N4qee+Aqa6/gfSzCrBBbcPHfWPSwSvZQKRsjE8aVSZPUNqdOvajXegt2eHdX
estr/AcbwInfQPMdcN4GPuZ5ct2mE8KeGs34rkW8OZfyJya8jkfdIsW9OAx4
kWkW9mFR/QrJsEJqxSRWKmmCSp5Sp8zo1LPbNQs5uqXCQqbEFCw/FjzSzNRd
BmfN4OIEs4YfGVxv4cQwvqgWx5qQB4aRDibswiN7VLH9pOQe+6KxyD7WUuAi
Cxk7opLZSdlY5pczOmKexuYL8p8ZStzG3f6yKqbqR+Z4OzhzNXjWvHRhfAnN
NsGn5foobwrjiiocfhiKWK6jAP4mHnlHuWEgI26IlAwS0YMsS4V4hJSOqjc9
opIntcSTvCx3rtZdsvd5+dEXX1Uz1S3MmavMz/1Mu4NBlhDy47pRy/k3ivh8
APMhjgmyOkTUXaVkkEq0qmUjpGRYKbVqkhxq+bgmeZJOm9OrXTvyXhp3+csO
+480+WtbQVMXOG/nakFDDshHCDaHPREqrbAacbqJretmJQjHSaRZKbZQCTaN
3J4RN6qRj+nJaR3LQ/XEUPTUUOQp3RvcfxxU/wTqr7Cm7N9zg45VPBdkwQTJ
b+MCu9nh63oUMWZC1IdH3iPXD1Hxo3TKuEbu0KZOFmjn87NcxYWLFUfZn+9Q
Hfj2Imi+DVof+LmueCw5GaK+JYw6WjGH8+DEuruqDYMZsUNK8ZAmYYSKt9Nb
Hmu3TuUonxXnu4xFXlOFr/oH34m2wJlOmDAg7YWokXYJUnjpI3pwHkUR0Udt
vJ+VZFfH2bLTxrLTZ/S4s5B+sjPbU2r0l1UGqxqYuktMS69PwFXjg7SQhFEf
2//t04ezj6oYS2b8g+y0KVruKNBMGfKf7tzu2WdyH6z1fHM6UPuL/7uO5+cf
BgX8TgBIcSuimBpGEc32wXhOs9Gq3fwoj3TmYLPGAmf5Adfe3cHDpwL1V7yN
nYwgtJINKaUhStvCKHHfBKzk6gKBQb9oKvMcPumtblzuLQxvIND9abycuL0L
r2eNoV6j8KASXYu9eQ0fscADFDqPv4YllCnAszQ6C/nBtDQb/RO88x9VPpcz
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140641539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->62753772],

Cell["Make effective normals to the surface vary locally: ", "ExampleText",
 CellID->314696300],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"NormalsFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"3", "#1"}], "]"}], ",", 
        RowBox[{"Cos", "[", 
         RowBox[{"5", "#2"}], "]"}], ",", "1"}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69401601],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->759602152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214183720],

Cell["Use flat shading for all polygons:", "ExampleText",
 CellID->70331186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"y", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"NormalsFunction", "\[Rule]", "None"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->280625324],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11127494]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30293],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexNormals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexNormals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexColors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexColors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->356903514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with NormalsFunction",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
NormalsFunction"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->293947038],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->292449731]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NormalsFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 2, 34.5610112}", "context" -> "System`", 
    "keywords" -> {"surface normal", "shading normal", "lighting normal"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "NormalsFunction is an option for Plot3D and related functions that \
specifies a function to apply to determine the effective surface normals at \
every point.", "synonyms" -> {"normals function"}, "title" -> 
    "NormalsFunction", "type" -> "Symbol", "uri" -> "ref/NormalsFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9130, 285, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->331617836]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 90277, 1763}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1812, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2435, 70, 1580, 37, 70, "ObjectNameGrid"],
Cell[4018, 109, 673, 19, 70, "Usage",
 CellID->12948]
}, Open  ]],
Cell[CellGroupData[{
Cell[4728, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5206, 150, 69, 1, 70, "Notes",
 CellID->12040],
Cell[5278, 153, 894, 23, 70, "2ColumnTableMod",
 CellID->409260814],
Cell[6175, 178, 261, 10, 70, "Notes",
 CellID->26249],
Cell[6439, 190, 2075, 68, 70, "2ColumnTableMod",
 CellID->70264450],
Cell[8517, 260, 576, 20, 70, "Notes",
 CellID->440408949]
}, Closed]],
Cell[CellGroupData[{
Cell[9130, 285, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->331617836],
Cell[CellGroupData[{
Cell[9515, 299, 148, 5, 70, "ExampleSection",
 CellID->423320541],
Cell[9666, 306, 90, 1, 70, "ExampleText",
 CellID->978114],
Cell[CellGroupData[{
Cell[9781, 311, 485, 15, 28, "Input",
 CellID->716608076],
Cell[10269, 328, 27785, 460, 159, "Output",
 Evaluatable->False,
 CellID->140641539]
}, Open  ]],
Cell[38069, 791, 124, 3, 70, "ExampleDelimiter",
 CellID->62753772],
Cell[38196, 796, 95, 1, 70, "ExampleText",
 CellID->314696300],
Cell[CellGroupData[{
Cell[38316, 801, 711, 23, 47, "Input",
 CellID->69401601],
Cell[39030, 826, 30172, 499, 159, "Output",
 Evaluatable->False,
 CellID->759602152]
}, Open  ]],
Cell[69217, 1328, 125, 3, 70, "ExampleDelimiter",
 CellID->214183720],
Cell[69345, 1333, 76, 1, 70, "ExampleText",
 CellID->70331186],
Cell[CellGroupData[{
Cell[69446, 1338, 480, 15, 28, "Input",
 CellID->280625324],
Cell[69929, 1355, 16348, 272, 159, "Output",
 Evaluatable->False,
 CellID->11127494]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86338, 1634, 311, 9, 70, "SeeAlsoSection",
 CellID->30293],
Cell[86652, 1645, 973, 35, 70, "SeeAlso",
 CellID->356903514]
}, Open  ]],
Cell[CellGroupData[{
Cell[87662, 1685, 305, 8, 70, "RelatedLinksSection"],
Cell[87970, 1695, 372, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[88379, 1712, 299, 8, 70, "MoreAboutSection"],
Cell[88681, 1722, 197, 4, 70, "MoreAbout",
 CellID->293947038],
Cell[88881, 1728, 179, 3, 70, "MoreAbout",
 CellID->292449731]
}, Open  ]],
Cell[89075, 1734, 27, 0, 70, "History"],
Cell[89105, 1736, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

